// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__22396 = arguments.length;
switch (G__22396) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async22397 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22397 = (function (f,blockable,meta22398){
this.f = f;
this.blockable = blockable;
this.meta22398 = meta22398;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async22397.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22399,meta22398__$1){
var self__ = this;
var _22399__$1 = this;
return (new cljs.core.async.t_cljs$core$async22397(self__.f,self__.blockable,meta22398__$1));
});

cljs.core.async.t_cljs$core$async22397.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22399){
var self__ = this;
var _22399__$1 = this;
return self__.meta22398;
});

cljs.core.async.t_cljs$core$async22397.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22397.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async22397.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async22397.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async22397.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta22398], null);
});

cljs.core.async.t_cljs$core$async22397.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22397.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22397";

cljs.core.async.t_cljs$core$async22397.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async22397");
});

cljs.core.async.__GT_t_cljs$core$async22397 = (function cljs$core$async$__GT_t_cljs$core$async22397(f__$1,blockable__$1,meta22398){
return (new cljs.core.async.t_cljs$core$async22397(f__$1,blockable__$1,meta22398));
});

}

return (new cljs.core.async.t_cljs$core$async22397(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__22403 = arguments.length;
switch (G__22403) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__22406 = arguments.length;
switch (G__22406) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__22409 = arguments.length;
switch (G__22409) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_22411 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_22411) : fn1.call(null,val_22411));
} else {
cljs.core.async.impl.dispatch.run(((function (val_22411,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_22411) : fn1.call(null,val_22411));
});})(val_22411,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__22413 = arguments.length;
switch (G__22413) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9853__auto___22415 = n;
var x_22416 = (0);
while(true){
if((x_22416 < n__9853__auto___22415)){
(a[x_22416] = (0));

var G__22417 = (x_22416 + (1));
x_22416 = G__22417;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__22418 = (i + (1));
i = G__22418;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async22419 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22419 = (function (flag,meta22420){
this.flag = flag;
this.meta22420 = meta22420;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async22419.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_22421,meta22420__$1){
var self__ = this;
var _22421__$1 = this;
return (new cljs.core.async.t_cljs$core$async22419(self__.flag,meta22420__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async22419.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_22421){
var self__ = this;
var _22421__$1 = this;
return self__.meta22420;
});})(flag))
;

cljs.core.async.t_cljs$core$async22419.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22419.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async22419.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async22419.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async22419.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta22420], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async22419.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22419.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22419";

cljs.core.async.t_cljs$core$async22419.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async22419");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async22419 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async22419(flag__$1,meta22420){
return (new cljs.core.async.t_cljs$core$async22419(flag__$1,meta22420));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async22419(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async22422 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22422 = (function (flag,cb,meta22423){
this.flag = flag;
this.cb = cb;
this.meta22423 = meta22423;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async22422.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22424,meta22423__$1){
var self__ = this;
var _22424__$1 = this;
return (new cljs.core.async.t_cljs$core$async22422(self__.flag,self__.cb,meta22423__$1));
});

cljs.core.async.t_cljs$core$async22422.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22424){
var self__ = this;
var _22424__$1 = this;
return self__.meta22423;
});

cljs.core.async.t_cljs$core$async22422.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22422.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async22422.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async22422.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async22422.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta22423], null);
});

cljs.core.async.t_cljs$core$async22422.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22422.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22422";

cljs.core.async.t_cljs$core$async22422.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async22422");
});

cljs.core.async.__GT_t_cljs$core$async22422 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async22422(flag__$1,cb__$1,meta22423){
return (new cljs.core.async.t_cljs$core$async22422(flag__$1,cb__$1,meta22423));
});

}

return (new cljs.core.async.t_cljs$core$async22422(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22425_SHARP_){
var G__22427 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22425_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__22427) : fret.call(null,G__22427));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22426_SHARP_){
var G__22428 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22426_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__22428) : fret.call(null,G__22428));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__8808__auto__ = wport;
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return port;
}
})()], null));
} else {
var G__22429 = (i + (1));
i = G__22429;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8808__auto__ = ret;
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__8796__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8796__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8796__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10094__auto__ = [];
var len__10087__auto___22435 = arguments.length;
var i__10088__auto___22436 = (0);
while(true){
if((i__10088__auto___22436 < len__10087__auto___22435)){
args__10094__auto__.push((arguments[i__10088__auto___22436]));

var G__22437 = (i__10088__auto___22436 + (1));
i__10088__auto___22436 = G__22437;
continue;
} else {
}
break;
}

var argseq__10095__auto__ = ((((1) < args__10094__auto__.length))?(new cljs.core.IndexedSeq(args__10094__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10095__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__22432){
var map__22433 = p__22432;
var map__22433__$1 = ((((!((map__22433 == null)))?((((map__22433.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22433.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22433):map__22433);
var opts = map__22433__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq22430){
var G__22431 = cljs.core.first(seq22430);
var seq22430__$1 = cljs.core.next(seq22430);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22431,seq22430__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__22439 = arguments.length;
switch (G__22439) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__22336__auto___22485 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___22485){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___22485){
return (function (state_22463){
var state_val_22464 = (state_22463[(1)]);
if((state_val_22464 === (7))){
var inst_22459 = (state_22463[(2)]);
var state_22463__$1 = state_22463;
var statearr_22465_22486 = state_22463__$1;
(statearr_22465_22486[(2)] = inst_22459);

(statearr_22465_22486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22464 === (1))){
var state_22463__$1 = state_22463;
var statearr_22466_22487 = state_22463__$1;
(statearr_22466_22487[(2)] = null);

(statearr_22466_22487[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22464 === (4))){
var inst_22442 = (state_22463[(7)]);
var inst_22442__$1 = (state_22463[(2)]);
var inst_22443 = (inst_22442__$1 == null);
var state_22463__$1 = (function (){var statearr_22467 = state_22463;
(statearr_22467[(7)] = inst_22442__$1);

return statearr_22467;
})();
if(cljs.core.truth_(inst_22443)){
var statearr_22468_22488 = state_22463__$1;
(statearr_22468_22488[(1)] = (5));

} else {
var statearr_22469_22489 = state_22463__$1;
(statearr_22469_22489[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22464 === (13))){
var state_22463__$1 = state_22463;
var statearr_22470_22490 = state_22463__$1;
(statearr_22470_22490[(2)] = null);

(statearr_22470_22490[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22464 === (6))){
var inst_22442 = (state_22463[(7)]);
var state_22463__$1 = state_22463;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22463__$1,(11),to,inst_22442);
} else {
if((state_val_22464 === (3))){
var inst_22461 = (state_22463[(2)]);
var state_22463__$1 = state_22463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22463__$1,inst_22461);
} else {
if((state_val_22464 === (12))){
var state_22463__$1 = state_22463;
var statearr_22471_22491 = state_22463__$1;
(statearr_22471_22491[(2)] = null);

(statearr_22471_22491[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22464 === (2))){
var state_22463__$1 = state_22463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22463__$1,(4),from);
} else {
if((state_val_22464 === (11))){
var inst_22452 = (state_22463[(2)]);
var state_22463__$1 = state_22463;
if(cljs.core.truth_(inst_22452)){
var statearr_22472_22492 = state_22463__$1;
(statearr_22472_22492[(1)] = (12));

} else {
var statearr_22473_22493 = state_22463__$1;
(statearr_22473_22493[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22464 === (9))){
var state_22463__$1 = state_22463;
var statearr_22474_22494 = state_22463__$1;
(statearr_22474_22494[(2)] = null);

(statearr_22474_22494[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22464 === (5))){
var state_22463__$1 = state_22463;
if(cljs.core.truth_(close_QMARK_)){
var statearr_22475_22495 = state_22463__$1;
(statearr_22475_22495[(1)] = (8));

} else {
var statearr_22476_22496 = state_22463__$1;
(statearr_22476_22496[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22464 === (14))){
var inst_22457 = (state_22463[(2)]);
var state_22463__$1 = state_22463;
var statearr_22477_22497 = state_22463__$1;
(statearr_22477_22497[(2)] = inst_22457);

(statearr_22477_22497[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22464 === (10))){
var inst_22449 = (state_22463[(2)]);
var state_22463__$1 = state_22463;
var statearr_22478_22498 = state_22463__$1;
(statearr_22478_22498[(2)] = inst_22449);

(statearr_22478_22498[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22464 === (8))){
var inst_22446 = cljs.core.async.close_BANG_(to);
var state_22463__$1 = state_22463;
var statearr_22479_22499 = state_22463__$1;
(statearr_22479_22499[(2)] = inst_22446);

(statearr_22479_22499[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___22485))
;
return ((function (switch__22234__auto__,c__22336__auto___22485){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_22480 = [null,null,null,null,null,null,null,null];
(statearr_22480[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_22480[(1)] = (1));

return statearr_22480;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_22463){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_22463);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e22481){if((e22481 instanceof Object)){
var ex__22238__auto__ = e22481;
var statearr_22482_22500 = state_22463;
(statearr_22482_22500[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22463);

return cljs.core.cst$kw$recur;
} else {
throw e22481;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__22501 = state_22463;
state_22463 = G__22501;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_22463){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_22463);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___22485))
})();
var state__22338__auto__ = (function (){var statearr_22483 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_22483[(6)] = c__22336__auto___22485);

return statearr_22483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___22485))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__22502){
var vec__22503 = p__22502;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22503,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22503,(1),null);
var job = vec__22503;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__22336__auto___22674 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___22674,res,vec__22503,v,p,job,jobs,results){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___22674,res,vec__22503,v,p,job,jobs,results){
return (function (state_22510){
var state_val_22511 = (state_22510[(1)]);
if((state_val_22511 === (1))){
var state_22510__$1 = state_22510;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22510__$1,(2),res,v);
} else {
if((state_val_22511 === (2))){
var inst_22507 = (state_22510[(2)]);
var inst_22508 = cljs.core.async.close_BANG_(res);
var state_22510__$1 = (function (){var statearr_22512 = state_22510;
(statearr_22512[(7)] = inst_22507);

return statearr_22512;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_22510__$1,inst_22508);
} else {
return null;
}
}
});})(c__22336__auto___22674,res,vec__22503,v,p,job,jobs,results))
;
return ((function (switch__22234__auto__,c__22336__auto___22674,res,vec__22503,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0 = (function (){
var statearr_22513 = [null,null,null,null,null,null,null,null];
(statearr_22513[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__);

(statearr_22513[(1)] = (1));

return statearr_22513;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1 = (function (state_22510){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_22510);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e22514){if((e22514 instanceof Object)){
var ex__22238__auto__ = e22514;
var statearr_22515_22675 = state_22510;
(statearr_22515_22675[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22510);

return cljs.core.cst$kw$recur;
} else {
throw e22514;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__22676 = state_22510;
state_22510 = G__22676;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__ = function(state_22510){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1.call(this,state_22510);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___22674,res,vec__22503,v,p,job,jobs,results))
})();
var state__22338__auto__ = (function (){var statearr_22516 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_22516[(6)] = c__22336__auto___22674);

return statearr_22516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___22674,res,vec__22503,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__22517){
var vec__22518 = p__22517;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22518,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22518,(1),null);
var job = vec__22518;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__9853__auto___22677 = n;
var __22678 = (0);
while(true){
if((__22678 < n__9853__auto___22677)){
var G__22521_22679 = type;
var G__22521_22680__$1 = (((G__22521_22679 instanceof cljs.core.Keyword))?G__22521_22679.fqn:null);
switch (G__22521_22680__$1) {
case "compute":
var c__22336__auto___22682 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__22678,c__22336__auto___22682,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (__22678,c__22336__auto___22682,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async){
return (function (state_22534){
var state_val_22535 = (state_22534[(1)]);
if((state_val_22535 === (1))){
var state_22534__$1 = state_22534;
var statearr_22536_22683 = state_22534__$1;
(statearr_22536_22683[(2)] = null);

(statearr_22536_22683[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22535 === (2))){
var state_22534__$1 = state_22534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22534__$1,(4),jobs);
} else {
if((state_val_22535 === (3))){
var inst_22532 = (state_22534[(2)]);
var state_22534__$1 = state_22534;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22534__$1,inst_22532);
} else {
if((state_val_22535 === (4))){
var inst_22524 = (state_22534[(2)]);
var inst_22525 = process(inst_22524);
var state_22534__$1 = state_22534;
if(cljs.core.truth_(inst_22525)){
var statearr_22537_22684 = state_22534__$1;
(statearr_22537_22684[(1)] = (5));

} else {
var statearr_22538_22685 = state_22534__$1;
(statearr_22538_22685[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22535 === (5))){
var state_22534__$1 = state_22534;
var statearr_22539_22686 = state_22534__$1;
(statearr_22539_22686[(2)] = null);

(statearr_22539_22686[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22535 === (6))){
var state_22534__$1 = state_22534;
var statearr_22540_22687 = state_22534__$1;
(statearr_22540_22687[(2)] = null);

(statearr_22540_22687[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22535 === (7))){
var inst_22530 = (state_22534[(2)]);
var state_22534__$1 = state_22534;
var statearr_22541_22688 = state_22534__$1;
(statearr_22541_22688[(2)] = inst_22530);

(statearr_22541_22688[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__22678,c__22336__auto___22682,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async))
;
return ((function (__22678,switch__22234__auto__,c__22336__auto___22682,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0 = (function (){
var statearr_22542 = [null,null,null,null,null,null,null];
(statearr_22542[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__);

(statearr_22542[(1)] = (1));

return statearr_22542;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1 = (function (state_22534){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_22534);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e22543){if((e22543 instanceof Object)){
var ex__22238__auto__ = e22543;
var statearr_22544_22689 = state_22534;
(statearr_22544_22689[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22534);

return cljs.core.cst$kw$recur;
} else {
throw e22543;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__22690 = state_22534;
state_22534 = G__22690;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__ = function(state_22534){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1.call(this,state_22534);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__;
})()
;})(__22678,switch__22234__auto__,c__22336__auto___22682,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async))
})();
var state__22338__auto__ = (function (){var statearr_22545 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_22545[(6)] = c__22336__auto___22682);

return statearr_22545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(__22678,c__22336__auto___22682,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async))
);


break;
case "async":
var c__22336__auto___22691 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__22678,c__22336__auto___22691,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (__22678,c__22336__auto___22691,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async){
return (function (state_22558){
var state_val_22559 = (state_22558[(1)]);
if((state_val_22559 === (1))){
var state_22558__$1 = state_22558;
var statearr_22560_22692 = state_22558__$1;
(statearr_22560_22692[(2)] = null);

(statearr_22560_22692[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22559 === (2))){
var state_22558__$1 = state_22558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22558__$1,(4),jobs);
} else {
if((state_val_22559 === (3))){
var inst_22556 = (state_22558[(2)]);
var state_22558__$1 = state_22558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22558__$1,inst_22556);
} else {
if((state_val_22559 === (4))){
var inst_22548 = (state_22558[(2)]);
var inst_22549 = async(inst_22548);
var state_22558__$1 = state_22558;
if(cljs.core.truth_(inst_22549)){
var statearr_22561_22693 = state_22558__$1;
(statearr_22561_22693[(1)] = (5));

} else {
var statearr_22562_22694 = state_22558__$1;
(statearr_22562_22694[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22559 === (5))){
var state_22558__$1 = state_22558;
var statearr_22563_22695 = state_22558__$1;
(statearr_22563_22695[(2)] = null);

(statearr_22563_22695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22559 === (6))){
var state_22558__$1 = state_22558;
var statearr_22564_22696 = state_22558__$1;
(statearr_22564_22696[(2)] = null);

(statearr_22564_22696[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22559 === (7))){
var inst_22554 = (state_22558[(2)]);
var state_22558__$1 = state_22558;
var statearr_22565_22697 = state_22558__$1;
(statearr_22565_22697[(2)] = inst_22554);

(statearr_22565_22697[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__22678,c__22336__auto___22691,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async))
;
return ((function (__22678,switch__22234__auto__,c__22336__auto___22691,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0 = (function (){
var statearr_22566 = [null,null,null,null,null,null,null];
(statearr_22566[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__);

(statearr_22566[(1)] = (1));

return statearr_22566;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1 = (function (state_22558){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_22558);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e22567){if((e22567 instanceof Object)){
var ex__22238__auto__ = e22567;
var statearr_22568_22698 = state_22558;
(statearr_22568_22698[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22558);

return cljs.core.cst$kw$recur;
} else {
throw e22567;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__22699 = state_22558;
state_22558 = G__22699;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__ = function(state_22558){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1.call(this,state_22558);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__;
})()
;})(__22678,switch__22234__auto__,c__22336__auto___22691,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async))
})();
var state__22338__auto__ = (function (){var statearr_22569 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_22569[(6)] = c__22336__auto___22691);

return statearr_22569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(__22678,c__22336__auto___22691,G__22521_22679,G__22521_22680__$1,n__9853__auto___22677,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__22521_22680__$1)].join('')));

}

var G__22700 = (__22678 + (1));
__22678 = G__22700;
continue;
} else {
}
break;
}

var c__22336__auto___22701 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___22701,jobs,results,process,async){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___22701,jobs,results,process,async){
return (function (state_22591){
var state_val_22592 = (state_22591[(1)]);
if((state_val_22592 === (1))){
var state_22591__$1 = state_22591;
var statearr_22593_22702 = state_22591__$1;
(statearr_22593_22702[(2)] = null);

(statearr_22593_22702[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22592 === (2))){
var state_22591__$1 = state_22591;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22591__$1,(4),from);
} else {
if((state_val_22592 === (3))){
var inst_22589 = (state_22591[(2)]);
var state_22591__$1 = state_22591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22591__$1,inst_22589);
} else {
if((state_val_22592 === (4))){
var inst_22572 = (state_22591[(7)]);
var inst_22572__$1 = (state_22591[(2)]);
var inst_22573 = (inst_22572__$1 == null);
var state_22591__$1 = (function (){var statearr_22594 = state_22591;
(statearr_22594[(7)] = inst_22572__$1);

return statearr_22594;
})();
if(cljs.core.truth_(inst_22573)){
var statearr_22595_22703 = state_22591__$1;
(statearr_22595_22703[(1)] = (5));

} else {
var statearr_22596_22704 = state_22591__$1;
(statearr_22596_22704[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22592 === (5))){
var inst_22575 = cljs.core.async.close_BANG_(jobs);
var state_22591__$1 = state_22591;
var statearr_22597_22705 = state_22591__$1;
(statearr_22597_22705[(2)] = inst_22575);

(statearr_22597_22705[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22592 === (6))){
var inst_22577 = (state_22591[(8)]);
var inst_22572 = (state_22591[(7)]);
var inst_22577__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_22578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22579 = [inst_22572,inst_22577__$1];
var inst_22580 = (new cljs.core.PersistentVector(null,2,(5),inst_22578,inst_22579,null));
var state_22591__$1 = (function (){var statearr_22598 = state_22591;
(statearr_22598[(8)] = inst_22577__$1);

return statearr_22598;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22591__$1,(8),jobs,inst_22580);
} else {
if((state_val_22592 === (7))){
var inst_22587 = (state_22591[(2)]);
var state_22591__$1 = state_22591;
var statearr_22599_22706 = state_22591__$1;
(statearr_22599_22706[(2)] = inst_22587);

(statearr_22599_22706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22592 === (8))){
var inst_22577 = (state_22591[(8)]);
var inst_22582 = (state_22591[(2)]);
var state_22591__$1 = (function (){var statearr_22600 = state_22591;
(statearr_22600[(9)] = inst_22582);

return statearr_22600;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22591__$1,(9),results,inst_22577);
} else {
if((state_val_22592 === (9))){
var inst_22584 = (state_22591[(2)]);
var state_22591__$1 = (function (){var statearr_22601 = state_22591;
(statearr_22601[(10)] = inst_22584);

return statearr_22601;
})();
var statearr_22602_22707 = state_22591__$1;
(statearr_22602_22707[(2)] = null);

(statearr_22602_22707[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___22701,jobs,results,process,async))
;
return ((function (switch__22234__auto__,c__22336__auto___22701,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0 = (function (){
var statearr_22603 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22603[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__);

(statearr_22603[(1)] = (1));

return statearr_22603;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1 = (function (state_22591){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_22591);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e22604){if((e22604 instanceof Object)){
var ex__22238__auto__ = e22604;
var statearr_22605_22708 = state_22591;
(statearr_22605_22708[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22591);

return cljs.core.cst$kw$recur;
} else {
throw e22604;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__22709 = state_22591;
state_22591 = G__22709;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__ = function(state_22591){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1.call(this,state_22591);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___22701,jobs,results,process,async))
})();
var state__22338__auto__ = (function (){var statearr_22606 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_22606[(6)] = c__22336__auto___22701);

return statearr_22606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___22701,jobs,results,process,async))
);


var c__22336__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto__,jobs,results,process,async){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto__,jobs,results,process,async){
return (function (state_22644){
var state_val_22645 = (state_22644[(1)]);
if((state_val_22645 === (7))){
var inst_22640 = (state_22644[(2)]);
var state_22644__$1 = state_22644;
var statearr_22646_22710 = state_22644__$1;
(statearr_22646_22710[(2)] = inst_22640);

(statearr_22646_22710[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (20))){
var state_22644__$1 = state_22644;
var statearr_22647_22711 = state_22644__$1;
(statearr_22647_22711[(2)] = null);

(statearr_22647_22711[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (1))){
var state_22644__$1 = state_22644;
var statearr_22648_22712 = state_22644__$1;
(statearr_22648_22712[(2)] = null);

(statearr_22648_22712[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (4))){
var inst_22609 = (state_22644[(7)]);
var inst_22609__$1 = (state_22644[(2)]);
var inst_22610 = (inst_22609__$1 == null);
var state_22644__$1 = (function (){var statearr_22649 = state_22644;
(statearr_22649[(7)] = inst_22609__$1);

return statearr_22649;
})();
if(cljs.core.truth_(inst_22610)){
var statearr_22650_22713 = state_22644__$1;
(statearr_22650_22713[(1)] = (5));

} else {
var statearr_22651_22714 = state_22644__$1;
(statearr_22651_22714[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (15))){
var inst_22622 = (state_22644[(8)]);
var state_22644__$1 = state_22644;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22644__$1,(18),to,inst_22622);
} else {
if((state_val_22645 === (21))){
var inst_22635 = (state_22644[(2)]);
var state_22644__$1 = state_22644;
var statearr_22652_22715 = state_22644__$1;
(statearr_22652_22715[(2)] = inst_22635);

(statearr_22652_22715[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (13))){
var inst_22637 = (state_22644[(2)]);
var state_22644__$1 = (function (){var statearr_22653 = state_22644;
(statearr_22653[(9)] = inst_22637);

return statearr_22653;
})();
var statearr_22654_22716 = state_22644__$1;
(statearr_22654_22716[(2)] = null);

(statearr_22654_22716[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (6))){
var inst_22609 = (state_22644[(7)]);
var state_22644__$1 = state_22644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22644__$1,(11),inst_22609);
} else {
if((state_val_22645 === (17))){
var inst_22630 = (state_22644[(2)]);
var state_22644__$1 = state_22644;
if(cljs.core.truth_(inst_22630)){
var statearr_22655_22717 = state_22644__$1;
(statearr_22655_22717[(1)] = (19));

} else {
var statearr_22656_22718 = state_22644__$1;
(statearr_22656_22718[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (3))){
var inst_22642 = (state_22644[(2)]);
var state_22644__$1 = state_22644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22644__$1,inst_22642);
} else {
if((state_val_22645 === (12))){
var inst_22619 = (state_22644[(10)]);
var state_22644__$1 = state_22644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22644__$1,(14),inst_22619);
} else {
if((state_val_22645 === (2))){
var state_22644__$1 = state_22644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22644__$1,(4),results);
} else {
if((state_val_22645 === (19))){
var state_22644__$1 = state_22644;
var statearr_22657_22719 = state_22644__$1;
(statearr_22657_22719[(2)] = null);

(statearr_22657_22719[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (11))){
var inst_22619 = (state_22644[(2)]);
var state_22644__$1 = (function (){var statearr_22658 = state_22644;
(statearr_22658[(10)] = inst_22619);

return statearr_22658;
})();
var statearr_22659_22720 = state_22644__$1;
(statearr_22659_22720[(2)] = null);

(statearr_22659_22720[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (9))){
var state_22644__$1 = state_22644;
var statearr_22660_22721 = state_22644__$1;
(statearr_22660_22721[(2)] = null);

(statearr_22660_22721[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (5))){
var state_22644__$1 = state_22644;
if(cljs.core.truth_(close_QMARK_)){
var statearr_22661_22722 = state_22644__$1;
(statearr_22661_22722[(1)] = (8));

} else {
var statearr_22662_22723 = state_22644__$1;
(statearr_22662_22723[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (14))){
var inst_22622 = (state_22644[(8)]);
var inst_22624 = (state_22644[(11)]);
var inst_22622__$1 = (state_22644[(2)]);
var inst_22623 = (inst_22622__$1 == null);
var inst_22624__$1 = cljs.core.not(inst_22623);
var state_22644__$1 = (function (){var statearr_22663 = state_22644;
(statearr_22663[(8)] = inst_22622__$1);

(statearr_22663[(11)] = inst_22624__$1);

return statearr_22663;
})();
if(inst_22624__$1){
var statearr_22664_22724 = state_22644__$1;
(statearr_22664_22724[(1)] = (15));

} else {
var statearr_22665_22725 = state_22644__$1;
(statearr_22665_22725[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (16))){
var inst_22624 = (state_22644[(11)]);
var state_22644__$1 = state_22644;
var statearr_22666_22726 = state_22644__$1;
(statearr_22666_22726[(2)] = inst_22624);

(statearr_22666_22726[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (10))){
var inst_22616 = (state_22644[(2)]);
var state_22644__$1 = state_22644;
var statearr_22667_22727 = state_22644__$1;
(statearr_22667_22727[(2)] = inst_22616);

(statearr_22667_22727[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (18))){
var inst_22627 = (state_22644[(2)]);
var state_22644__$1 = state_22644;
var statearr_22668_22728 = state_22644__$1;
(statearr_22668_22728[(2)] = inst_22627);

(statearr_22668_22728[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22645 === (8))){
var inst_22613 = cljs.core.async.close_BANG_(to);
var state_22644__$1 = state_22644;
var statearr_22669_22729 = state_22644__$1;
(statearr_22669_22729[(2)] = inst_22613);

(statearr_22669_22729[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto__,jobs,results,process,async))
;
return ((function (switch__22234__auto__,c__22336__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0 = (function (){
var statearr_22670 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22670[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__);

(statearr_22670[(1)] = (1));

return statearr_22670;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1 = (function (state_22644){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_22644);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e22671){if((e22671 instanceof Object)){
var ex__22238__auto__ = e22671;
var statearr_22672_22730 = state_22644;
(statearr_22672_22730[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22644);

return cljs.core.cst$kw$recur;
} else {
throw e22671;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__22731 = state_22644;
state_22644 = G__22731;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__ = function(state_22644){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1.call(this,state_22644);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22235__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto__,jobs,results,process,async))
})();
var state__22338__auto__ = (function (){var statearr_22673 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_22673[(6)] = c__22336__auto__);

return statearr_22673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto__,jobs,results,process,async))
);

return c__22336__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__22733 = arguments.length;
switch (G__22733) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__22736 = arguments.length;
switch (G__22736) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__22739 = arguments.length;
switch (G__22739) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__22336__auto___22788 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___22788,tc,fc){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___22788,tc,fc){
return (function (state_22765){
var state_val_22766 = (state_22765[(1)]);
if((state_val_22766 === (7))){
var inst_22761 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22767_22789 = state_22765__$1;
(statearr_22767_22789[(2)] = inst_22761);

(statearr_22767_22789[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22766 === (1))){
var state_22765__$1 = state_22765;
var statearr_22768_22790 = state_22765__$1;
(statearr_22768_22790[(2)] = null);

(statearr_22768_22790[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22766 === (4))){
var inst_22742 = (state_22765[(7)]);
var inst_22742__$1 = (state_22765[(2)]);
var inst_22743 = (inst_22742__$1 == null);
var state_22765__$1 = (function (){var statearr_22769 = state_22765;
(statearr_22769[(7)] = inst_22742__$1);

return statearr_22769;
})();
if(cljs.core.truth_(inst_22743)){
var statearr_22770_22791 = state_22765__$1;
(statearr_22770_22791[(1)] = (5));

} else {
var statearr_22771_22792 = state_22765__$1;
(statearr_22771_22792[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22766 === (13))){
var state_22765__$1 = state_22765;
var statearr_22772_22793 = state_22765__$1;
(statearr_22772_22793[(2)] = null);

(statearr_22772_22793[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22766 === (6))){
var inst_22742 = (state_22765[(7)]);
var inst_22748 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_22742) : p.call(null,inst_22742));
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22748)){
var statearr_22773_22794 = state_22765__$1;
(statearr_22773_22794[(1)] = (9));

} else {
var statearr_22774_22795 = state_22765__$1;
(statearr_22774_22795[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22766 === (3))){
var inst_22763 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22765__$1,inst_22763);
} else {
if((state_val_22766 === (12))){
var state_22765__$1 = state_22765;
var statearr_22775_22796 = state_22765__$1;
(statearr_22775_22796[(2)] = null);

(statearr_22775_22796[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22766 === (2))){
var state_22765__$1 = state_22765;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22765__$1,(4),ch);
} else {
if((state_val_22766 === (11))){
var inst_22742 = (state_22765[(7)]);
var inst_22752 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22765__$1,(8),inst_22752,inst_22742);
} else {
if((state_val_22766 === (9))){
var state_22765__$1 = state_22765;
var statearr_22776_22797 = state_22765__$1;
(statearr_22776_22797[(2)] = tc);

(statearr_22776_22797[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22766 === (5))){
var inst_22745 = cljs.core.async.close_BANG_(tc);
var inst_22746 = cljs.core.async.close_BANG_(fc);
var state_22765__$1 = (function (){var statearr_22777 = state_22765;
(statearr_22777[(8)] = inst_22745);

return statearr_22777;
})();
var statearr_22778_22798 = state_22765__$1;
(statearr_22778_22798[(2)] = inst_22746);

(statearr_22778_22798[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22766 === (14))){
var inst_22759 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22779_22799 = state_22765__$1;
(statearr_22779_22799[(2)] = inst_22759);

(statearr_22779_22799[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22766 === (10))){
var state_22765__$1 = state_22765;
var statearr_22780_22800 = state_22765__$1;
(statearr_22780_22800[(2)] = fc);

(statearr_22780_22800[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22766 === (8))){
var inst_22754 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22754)){
var statearr_22781_22801 = state_22765__$1;
(statearr_22781_22801[(1)] = (12));

} else {
var statearr_22782_22802 = state_22765__$1;
(statearr_22782_22802[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___22788,tc,fc))
;
return ((function (switch__22234__auto__,c__22336__auto___22788,tc,fc){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_22783 = [null,null,null,null,null,null,null,null,null];
(statearr_22783[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_22783[(1)] = (1));

return statearr_22783;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_22765){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_22765);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e22784){if((e22784 instanceof Object)){
var ex__22238__auto__ = e22784;
var statearr_22785_22803 = state_22765;
(statearr_22785_22803[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22765);

return cljs.core.cst$kw$recur;
} else {
throw e22784;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__22804 = state_22765;
state_22765 = G__22804;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_22765){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_22765);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___22788,tc,fc))
})();
var state__22338__auto__ = (function (){var statearr_22786 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_22786[(6)] = c__22336__auto___22788);

return statearr_22786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___22788,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__22336__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto__){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto__){
return (function (state_22825){
var state_val_22826 = (state_22825[(1)]);
if((state_val_22826 === (7))){
var inst_22821 = (state_22825[(2)]);
var state_22825__$1 = state_22825;
var statearr_22827_22845 = state_22825__$1;
(statearr_22827_22845[(2)] = inst_22821);

(statearr_22827_22845[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22826 === (1))){
var inst_22805 = init;
var state_22825__$1 = (function (){var statearr_22828 = state_22825;
(statearr_22828[(7)] = inst_22805);

return statearr_22828;
})();
var statearr_22829_22846 = state_22825__$1;
(statearr_22829_22846[(2)] = null);

(statearr_22829_22846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22826 === (4))){
var inst_22808 = (state_22825[(8)]);
var inst_22808__$1 = (state_22825[(2)]);
var inst_22809 = (inst_22808__$1 == null);
var state_22825__$1 = (function (){var statearr_22830 = state_22825;
(statearr_22830[(8)] = inst_22808__$1);

return statearr_22830;
})();
if(cljs.core.truth_(inst_22809)){
var statearr_22831_22847 = state_22825__$1;
(statearr_22831_22847[(1)] = (5));

} else {
var statearr_22832_22848 = state_22825__$1;
(statearr_22832_22848[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22826 === (6))){
var inst_22805 = (state_22825[(7)]);
var inst_22808 = (state_22825[(8)]);
var inst_22812 = (state_22825[(9)]);
var inst_22812__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_22805,inst_22808) : f.call(null,inst_22805,inst_22808));
var inst_22813 = cljs.core.reduced_QMARK_(inst_22812__$1);
var state_22825__$1 = (function (){var statearr_22833 = state_22825;
(statearr_22833[(9)] = inst_22812__$1);

return statearr_22833;
})();
if(inst_22813){
var statearr_22834_22849 = state_22825__$1;
(statearr_22834_22849[(1)] = (8));

} else {
var statearr_22835_22850 = state_22825__$1;
(statearr_22835_22850[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22826 === (3))){
var inst_22823 = (state_22825[(2)]);
var state_22825__$1 = state_22825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22825__$1,inst_22823);
} else {
if((state_val_22826 === (2))){
var state_22825__$1 = state_22825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22825__$1,(4),ch);
} else {
if((state_val_22826 === (9))){
var inst_22812 = (state_22825[(9)]);
var inst_22805 = inst_22812;
var state_22825__$1 = (function (){var statearr_22836 = state_22825;
(statearr_22836[(7)] = inst_22805);

return statearr_22836;
})();
var statearr_22837_22851 = state_22825__$1;
(statearr_22837_22851[(2)] = null);

(statearr_22837_22851[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22826 === (5))){
var inst_22805 = (state_22825[(7)]);
var state_22825__$1 = state_22825;
var statearr_22838_22852 = state_22825__$1;
(statearr_22838_22852[(2)] = inst_22805);

(statearr_22838_22852[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22826 === (10))){
var inst_22819 = (state_22825[(2)]);
var state_22825__$1 = state_22825;
var statearr_22839_22853 = state_22825__$1;
(statearr_22839_22853[(2)] = inst_22819);

(statearr_22839_22853[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22826 === (8))){
var inst_22812 = (state_22825[(9)]);
var inst_22815 = cljs.core.deref(inst_22812);
var state_22825__$1 = state_22825;
var statearr_22840_22854 = state_22825__$1;
(statearr_22840_22854[(2)] = inst_22815);

(statearr_22840_22854[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto__))
;
return ((function (switch__22234__auto__,c__22336__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__22235__auto__ = null;
var cljs$core$async$reduce_$_state_machine__22235__auto____0 = (function (){
var statearr_22841 = [null,null,null,null,null,null,null,null,null,null];
(statearr_22841[(0)] = cljs$core$async$reduce_$_state_machine__22235__auto__);

(statearr_22841[(1)] = (1));

return statearr_22841;
});
var cljs$core$async$reduce_$_state_machine__22235__auto____1 = (function (state_22825){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_22825);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e22842){if((e22842 instanceof Object)){
var ex__22238__auto__ = e22842;
var statearr_22843_22855 = state_22825;
(statearr_22843_22855[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22825);

return cljs.core.cst$kw$recur;
} else {
throw e22842;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__22856 = state_22825;
state_22825 = G__22856;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__22235__auto__ = function(state_22825){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__22235__auto____1.call(this,state_22825);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__22235__auto____0;
cljs$core$async$reduce_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__22235__auto____1;
return cljs$core$async$reduce_$_state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto__))
})();
var state__22338__auto__ = (function (){var statearr_22844 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_22844[(6)] = c__22336__auto__);

return statearr_22844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto__))
);

return c__22336__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__22336__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto__,f__$1){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto__,f__$1){
return (function (state_22862){
var state_val_22863 = (state_22862[(1)]);
if((state_val_22863 === (1))){
var inst_22857 = cljs.core.async.reduce(f__$1,init,ch);
var state_22862__$1 = state_22862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22862__$1,(2),inst_22857);
} else {
if((state_val_22863 === (2))){
var inst_22859 = (state_22862[(2)]);
var inst_22860 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_22859) : f__$1.call(null,inst_22859));
var state_22862__$1 = state_22862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22862__$1,inst_22860);
} else {
return null;
}
}
});})(c__22336__auto__,f__$1))
;
return ((function (switch__22234__auto__,c__22336__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__22235__auto__ = null;
var cljs$core$async$transduce_$_state_machine__22235__auto____0 = (function (){
var statearr_22864 = [null,null,null,null,null,null,null];
(statearr_22864[(0)] = cljs$core$async$transduce_$_state_machine__22235__auto__);

(statearr_22864[(1)] = (1));

return statearr_22864;
});
var cljs$core$async$transduce_$_state_machine__22235__auto____1 = (function (state_22862){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_22862);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e22865){if((e22865 instanceof Object)){
var ex__22238__auto__ = e22865;
var statearr_22866_22868 = state_22862;
(statearr_22866_22868[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22862);

return cljs.core.cst$kw$recur;
} else {
throw e22865;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__22869 = state_22862;
state_22862 = G__22869;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__22235__auto__ = function(state_22862){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__22235__auto____1.call(this,state_22862);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__22235__auto____0;
cljs$core$async$transduce_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__22235__auto____1;
return cljs$core$async$transduce_$_state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto__,f__$1))
})();
var state__22338__auto__ = (function (){var statearr_22867 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_22867[(6)] = c__22336__auto__);

return statearr_22867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto__,f__$1))
);

return c__22336__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__22871 = arguments.length;
switch (G__22871) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__22336__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto__){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto__){
return (function (state_22896){
var state_val_22897 = (state_22896[(1)]);
if((state_val_22897 === (7))){
var inst_22878 = (state_22896[(2)]);
var state_22896__$1 = state_22896;
var statearr_22898_22919 = state_22896__$1;
(statearr_22898_22919[(2)] = inst_22878);

(statearr_22898_22919[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22897 === (1))){
var inst_22872 = cljs.core.seq(coll);
var inst_22873 = inst_22872;
var state_22896__$1 = (function (){var statearr_22899 = state_22896;
(statearr_22899[(7)] = inst_22873);

return statearr_22899;
})();
var statearr_22900_22920 = state_22896__$1;
(statearr_22900_22920[(2)] = null);

(statearr_22900_22920[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22897 === (4))){
var inst_22873 = (state_22896[(7)]);
var inst_22876 = cljs.core.first(inst_22873);
var state_22896__$1 = state_22896;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22896__$1,(7),ch,inst_22876);
} else {
if((state_val_22897 === (13))){
var inst_22890 = (state_22896[(2)]);
var state_22896__$1 = state_22896;
var statearr_22901_22921 = state_22896__$1;
(statearr_22901_22921[(2)] = inst_22890);

(statearr_22901_22921[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22897 === (6))){
var inst_22881 = (state_22896[(2)]);
var state_22896__$1 = state_22896;
if(cljs.core.truth_(inst_22881)){
var statearr_22902_22922 = state_22896__$1;
(statearr_22902_22922[(1)] = (8));

} else {
var statearr_22903_22923 = state_22896__$1;
(statearr_22903_22923[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22897 === (3))){
var inst_22894 = (state_22896[(2)]);
var state_22896__$1 = state_22896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22896__$1,inst_22894);
} else {
if((state_val_22897 === (12))){
var state_22896__$1 = state_22896;
var statearr_22904_22924 = state_22896__$1;
(statearr_22904_22924[(2)] = null);

(statearr_22904_22924[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22897 === (2))){
var inst_22873 = (state_22896[(7)]);
var state_22896__$1 = state_22896;
if(cljs.core.truth_(inst_22873)){
var statearr_22905_22925 = state_22896__$1;
(statearr_22905_22925[(1)] = (4));

} else {
var statearr_22906_22926 = state_22896__$1;
(statearr_22906_22926[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22897 === (11))){
var inst_22887 = cljs.core.async.close_BANG_(ch);
var state_22896__$1 = state_22896;
var statearr_22907_22927 = state_22896__$1;
(statearr_22907_22927[(2)] = inst_22887);

(statearr_22907_22927[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22897 === (9))){
var state_22896__$1 = state_22896;
if(cljs.core.truth_(close_QMARK_)){
var statearr_22908_22928 = state_22896__$1;
(statearr_22908_22928[(1)] = (11));

} else {
var statearr_22909_22929 = state_22896__$1;
(statearr_22909_22929[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22897 === (5))){
var inst_22873 = (state_22896[(7)]);
var state_22896__$1 = state_22896;
var statearr_22910_22930 = state_22896__$1;
(statearr_22910_22930[(2)] = inst_22873);

(statearr_22910_22930[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22897 === (10))){
var inst_22892 = (state_22896[(2)]);
var state_22896__$1 = state_22896;
var statearr_22911_22931 = state_22896__$1;
(statearr_22911_22931[(2)] = inst_22892);

(statearr_22911_22931[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22897 === (8))){
var inst_22873 = (state_22896[(7)]);
var inst_22883 = cljs.core.next(inst_22873);
var inst_22873__$1 = inst_22883;
var state_22896__$1 = (function (){var statearr_22912 = state_22896;
(statearr_22912[(7)] = inst_22873__$1);

return statearr_22912;
})();
var statearr_22913_22932 = state_22896__$1;
(statearr_22913_22932[(2)] = null);

(statearr_22913_22932[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto__))
;
return ((function (switch__22234__auto__,c__22336__auto__){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_22914 = [null,null,null,null,null,null,null,null];
(statearr_22914[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_22914[(1)] = (1));

return statearr_22914;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_22896){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_22896);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e22915){if((e22915 instanceof Object)){
var ex__22238__auto__ = e22915;
var statearr_22916_22933 = state_22896;
(statearr_22916_22933[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_22896);

return cljs.core.cst$kw$recur;
} else {
throw e22915;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__22934 = state_22896;
state_22896 = G__22934;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_22896){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_22896);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto__))
})();
var state__22338__auto__ = (function (){var statearr_22917 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_22917[(6)] = c__22336__auto__);

return statearr_22917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto__))
);

return c__22336__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9541__auto__ = (((_ == null))?null:_);
var m__9542__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__9542__auto__.call(null,_));
} else {
var m__9542__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__9542__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9542__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__9542__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9542__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto__.call(null,m,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto__.call(null,m));
} else {
var m__9542__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async22935 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22935 = (function (ch,cs,meta22936){
this.ch = ch;
this.cs = cs;
this.meta22936 = meta22936;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async22935.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_22937,meta22936__$1){
var self__ = this;
var _22937__$1 = this;
return (new cljs.core.async.t_cljs$core$async22935(self__.ch,self__.cs,meta22936__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async22935.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_22937){
var self__ = this;
var _22937__$1 = this;
return self__.meta22936;
});})(cs))
;

cljs.core.async.t_cljs$core$async22935.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22935.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async22935.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async22935.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async22935.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async22935.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async22935.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta22936], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async22935.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async22935.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22935";

cljs.core.async.t_cljs$core$async22935.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async22935");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async22935 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async22935(ch__$1,cs__$1,meta22936){
return (new cljs.core.async.t_cljs$core$async22935(ch__$1,cs__$1,meta22936));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async22935(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__22336__auto___23157 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___23157,cs,m,dchan,dctr,done){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___23157,cs,m,dchan,dctr,done){
return (function (state_23072){
var state_val_23073 = (state_23072[(1)]);
if((state_val_23073 === (7))){
var inst_23068 = (state_23072[(2)]);
var state_23072__$1 = state_23072;
var statearr_23074_23158 = state_23072__$1;
(statearr_23074_23158[(2)] = inst_23068);

(statearr_23074_23158[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (20))){
var inst_22971 = (state_23072[(7)]);
var inst_22983 = cljs.core.first(inst_22971);
var inst_22984 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22983,(0),null);
var inst_22985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22983,(1),null);
var state_23072__$1 = (function (){var statearr_23075 = state_23072;
(statearr_23075[(8)] = inst_22984);

return statearr_23075;
})();
if(cljs.core.truth_(inst_22985)){
var statearr_23076_23159 = state_23072__$1;
(statearr_23076_23159[(1)] = (22));

} else {
var statearr_23077_23160 = state_23072__$1;
(statearr_23077_23160[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (27))){
var inst_23015 = (state_23072[(9)]);
var inst_23020 = (state_23072[(10)]);
var inst_22940 = (state_23072[(11)]);
var inst_23013 = (state_23072[(12)]);
var inst_23020__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_23013,inst_23015);
var inst_23021 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_23020__$1,inst_22940,done);
var state_23072__$1 = (function (){var statearr_23078 = state_23072;
(statearr_23078[(10)] = inst_23020__$1);

return statearr_23078;
})();
if(cljs.core.truth_(inst_23021)){
var statearr_23079_23161 = state_23072__$1;
(statearr_23079_23161[(1)] = (30));

} else {
var statearr_23080_23162 = state_23072__$1;
(statearr_23080_23162[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (1))){
var state_23072__$1 = state_23072;
var statearr_23081_23163 = state_23072__$1;
(statearr_23081_23163[(2)] = null);

(statearr_23081_23163[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (24))){
var inst_22971 = (state_23072[(7)]);
var inst_22990 = (state_23072[(2)]);
var inst_22991 = cljs.core.next(inst_22971);
var inst_22949 = inst_22991;
var inst_22950 = null;
var inst_22951 = (0);
var inst_22952 = (0);
var state_23072__$1 = (function (){var statearr_23082 = state_23072;
(statearr_23082[(13)] = inst_22952);

(statearr_23082[(14)] = inst_22951);

(statearr_23082[(15)] = inst_22949);

(statearr_23082[(16)] = inst_22990);

(statearr_23082[(17)] = inst_22950);

return statearr_23082;
})();
var statearr_23083_23164 = state_23072__$1;
(statearr_23083_23164[(2)] = null);

(statearr_23083_23164[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (39))){
var state_23072__$1 = state_23072;
var statearr_23087_23165 = state_23072__$1;
(statearr_23087_23165[(2)] = null);

(statearr_23087_23165[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (4))){
var inst_22940 = (state_23072[(11)]);
var inst_22940__$1 = (state_23072[(2)]);
var inst_22941 = (inst_22940__$1 == null);
var state_23072__$1 = (function (){var statearr_23088 = state_23072;
(statearr_23088[(11)] = inst_22940__$1);

return statearr_23088;
})();
if(cljs.core.truth_(inst_22941)){
var statearr_23089_23166 = state_23072__$1;
(statearr_23089_23166[(1)] = (5));

} else {
var statearr_23090_23167 = state_23072__$1;
(statearr_23090_23167[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (15))){
var inst_22952 = (state_23072[(13)]);
var inst_22951 = (state_23072[(14)]);
var inst_22949 = (state_23072[(15)]);
var inst_22950 = (state_23072[(17)]);
var inst_22967 = (state_23072[(2)]);
var inst_22968 = (inst_22952 + (1));
var tmp23084 = inst_22951;
var tmp23085 = inst_22949;
var tmp23086 = inst_22950;
var inst_22949__$1 = tmp23085;
var inst_22950__$1 = tmp23086;
var inst_22951__$1 = tmp23084;
var inst_22952__$1 = inst_22968;
var state_23072__$1 = (function (){var statearr_23091 = state_23072;
(statearr_23091[(13)] = inst_22952__$1);

(statearr_23091[(14)] = inst_22951__$1);

(statearr_23091[(15)] = inst_22949__$1);

(statearr_23091[(18)] = inst_22967);

(statearr_23091[(17)] = inst_22950__$1);

return statearr_23091;
})();
var statearr_23092_23168 = state_23072__$1;
(statearr_23092_23168[(2)] = null);

(statearr_23092_23168[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (21))){
var inst_22994 = (state_23072[(2)]);
var state_23072__$1 = state_23072;
var statearr_23096_23169 = state_23072__$1;
(statearr_23096_23169[(2)] = inst_22994);

(statearr_23096_23169[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (31))){
var inst_23020 = (state_23072[(10)]);
var inst_23024 = done(null);
var inst_23025 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_23020);
var state_23072__$1 = (function (){var statearr_23097 = state_23072;
(statearr_23097[(19)] = inst_23024);

return statearr_23097;
})();
var statearr_23098_23170 = state_23072__$1;
(statearr_23098_23170[(2)] = inst_23025);

(statearr_23098_23170[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (32))){
var inst_23012 = (state_23072[(20)]);
var inst_23014 = (state_23072[(21)]);
var inst_23015 = (state_23072[(9)]);
var inst_23013 = (state_23072[(12)]);
var inst_23027 = (state_23072[(2)]);
var inst_23028 = (inst_23015 + (1));
var tmp23093 = inst_23012;
var tmp23094 = inst_23014;
var tmp23095 = inst_23013;
var inst_23012__$1 = tmp23093;
var inst_23013__$1 = tmp23095;
var inst_23014__$1 = tmp23094;
var inst_23015__$1 = inst_23028;
var state_23072__$1 = (function (){var statearr_23099 = state_23072;
(statearr_23099[(22)] = inst_23027);

(statearr_23099[(20)] = inst_23012__$1);

(statearr_23099[(21)] = inst_23014__$1);

(statearr_23099[(9)] = inst_23015__$1);

(statearr_23099[(12)] = inst_23013__$1);

return statearr_23099;
})();
var statearr_23100_23171 = state_23072__$1;
(statearr_23100_23171[(2)] = null);

(statearr_23100_23171[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (40))){
var inst_23040 = (state_23072[(23)]);
var inst_23044 = done(null);
var inst_23045 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_23040);
var state_23072__$1 = (function (){var statearr_23101 = state_23072;
(statearr_23101[(24)] = inst_23044);

return statearr_23101;
})();
var statearr_23102_23172 = state_23072__$1;
(statearr_23102_23172[(2)] = inst_23045);

(statearr_23102_23172[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (33))){
var inst_23031 = (state_23072[(25)]);
var inst_23033 = cljs.core.chunked_seq_QMARK_(inst_23031);
var state_23072__$1 = state_23072;
if(inst_23033){
var statearr_23103_23173 = state_23072__$1;
(statearr_23103_23173[(1)] = (36));

} else {
var statearr_23104_23174 = state_23072__$1;
(statearr_23104_23174[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (13))){
var inst_22961 = (state_23072[(26)]);
var inst_22964 = cljs.core.async.close_BANG_(inst_22961);
var state_23072__$1 = state_23072;
var statearr_23105_23175 = state_23072__$1;
(statearr_23105_23175[(2)] = inst_22964);

(statearr_23105_23175[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (22))){
var inst_22984 = (state_23072[(8)]);
var inst_22987 = cljs.core.async.close_BANG_(inst_22984);
var state_23072__$1 = state_23072;
var statearr_23106_23176 = state_23072__$1;
(statearr_23106_23176[(2)] = inst_22987);

(statearr_23106_23176[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (36))){
var inst_23031 = (state_23072[(25)]);
var inst_23035 = cljs.core.chunk_first(inst_23031);
var inst_23036 = cljs.core.chunk_rest(inst_23031);
var inst_23037 = cljs.core.count(inst_23035);
var inst_23012 = inst_23036;
var inst_23013 = inst_23035;
var inst_23014 = inst_23037;
var inst_23015 = (0);
var state_23072__$1 = (function (){var statearr_23107 = state_23072;
(statearr_23107[(20)] = inst_23012);

(statearr_23107[(21)] = inst_23014);

(statearr_23107[(9)] = inst_23015);

(statearr_23107[(12)] = inst_23013);

return statearr_23107;
})();
var statearr_23108_23177 = state_23072__$1;
(statearr_23108_23177[(2)] = null);

(statearr_23108_23177[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (41))){
var inst_23031 = (state_23072[(25)]);
var inst_23047 = (state_23072[(2)]);
var inst_23048 = cljs.core.next(inst_23031);
var inst_23012 = inst_23048;
var inst_23013 = null;
var inst_23014 = (0);
var inst_23015 = (0);
var state_23072__$1 = (function (){var statearr_23109 = state_23072;
(statearr_23109[(27)] = inst_23047);

(statearr_23109[(20)] = inst_23012);

(statearr_23109[(21)] = inst_23014);

(statearr_23109[(9)] = inst_23015);

(statearr_23109[(12)] = inst_23013);

return statearr_23109;
})();
var statearr_23110_23178 = state_23072__$1;
(statearr_23110_23178[(2)] = null);

(statearr_23110_23178[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (43))){
var state_23072__$1 = state_23072;
var statearr_23111_23179 = state_23072__$1;
(statearr_23111_23179[(2)] = null);

(statearr_23111_23179[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (29))){
var inst_23056 = (state_23072[(2)]);
var state_23072__$1 = state_23072;
var statearr_23112_23180 = state_23072__$1;
(statearr_23112_23180[(2)] = inst_23056);

(statearr_23112_23180[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (44))){
var inst_23065 = (state_23072[(2)]);
var state_23072__$1 = (function (){var statearr_23113 = state_23072;
(statearr_23113[(28)] = inst_23065);

return statearr_23113;
})();
var statearr_23114_23181 = state_23072__$1;
(statearr_23114_23181[(2)] = null);

(statearr_23114_23181[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (6))){
var inst_23004 = (state_23072[(29)]);
var inst_23003 = cljs.core.deref(cs);
var inst_23004__$1 = cljs.core.keys(inst_23003);
var inst_23005 = cljs.core.count(inst_23004__$1);
var inst_23006 = cljs.core.reset_BANG_(dctr,inst_23005);
var inst_23011 = cljs.core.seq(inst_23004__$1);
var inst_23012 = inst_23011;
var inst_23013 = null;
var inst_23014 = (0);
var inst_23015 = (0);
var state_23072__$1 = (function (){var statearr_23115 = state_23072;
(statearr_23115[(29)] = inst_23004__$1);

(statearr_23115[(20)] = inst_23012);

(statearr_23115[(21)] = inst_23014);

(statearr_23115[(30)] = inst_23006);

(statearr_23115[(9)] = inst_23015);

(statearr_23115[(12)] = inst_23013);

return statearr_23115;
})();
var statearr_23116_23182 = state_23072__$1;
(statearr_23116_23182[(2)] = null);

(statearr_23116_23182[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (28))){
var inst_23012 = (state_23072[(20)]);
var inst_23031 = (state_23072[(25)]);
var inst_23031__$1 = cljs.core.seq(inst_23012);
var state_23072__$1 = (function (){var statearr_23117 = state_23072;
(statearr_23117[(25)] = inst_23031__$1);

return statearr_23117;
})();
if(inst_23031__$1){
var statearr_23118_23183 = state_23072__$1;
(statearr_23118_23183[(1)] = (33));

} else {
var statearr_23119_23184 = state_23072__$1;
(statearr_23119_23184[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (25))){
var inst_23014 = (state_23072[(21)]);
var inst_23015 = (state_23072[(9)]);
var inst_23017 = (inst_23015 < inst_23014);
var inst_23018 = inst_23017;
var state_23072__$1 = state_23072;
if(cljs.core.truth_(inst_23018)){
var statearr_23120_23185 = state_23072__$1;
(statearr_23120_23185[(1)] = (27));

} else {
var statearr_23121_23186 = state_23072__$1;
(statearr_23121_23186[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (34))){
var state_23072__$1 = state_23072;
var statearr_23122_23187 = state_23072__$1;
(statearr_23122_23187[(2)] = null);

(statearr_23122_23187[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (17))){
var state_23072__$1 = state_23072;
var statearr_23123_23188 = state_23072__$1;
(statearr_23123_23188[(2)] = null);

(statearr_23123_23188[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (3))){
var inst_23070 = (state_23072[(2)]);
var state_23072__$1 = state_23072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23072__$1,inst_23070);
} else {
if((state_val_23073 === (12))){
var inst_22999 = (state_23072[(2)]);
var state_23072__$1 = state_23072;
var statearr_23124_23189 = state_23072__$1;
(statearr_23124_23189[(2)] = inst_22999);

(statearr_23124_23189[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (2))){
var state_23072__$1 = state_23072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23072__$1,(4),ch);
} else {
if((state_val_23073 === (23))){
var state_23072__$1 = state_23072;
var statearr_23125_23190 = state_23072__$1;
(statearr_23125_23190[(2)] = null);

(statearr_23125_23190[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (35))){
var inst_23054 = (state_23072[(2)]);
var state_23072__$1 = state_23072;
var statearr_23126_23191 = state_23072__$1;
(statearr_23126_23191[(2)] = inst_23054);

(statearr_23126_23191[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (19))){
var inst_22971 = (state_23072[(7)]);
var inst_22975 = cljs.core.chunk_first(inst_22971);
var inst_22976 = cljs.core.chunk_rest(inst_22971);
var inst_22977 = cljs.core.count(inst_22975);
var inst_22949 = inst_22976;
var inst_22950 = inst_22975;
var inst_22951 = inst_22977;
var inst_22952 = (0);
var state_23072__$1 = (function (){var statearr_23127 = state_23072;
(statearr_23127[(13)] = inst_22952);

(statearr_23127[(14)] = inst_22951);

(statearr_23127[(15)] = inst_22949);

(statearr_23127[(17)] = inst_22950);

return statearr_23127;
})();
var statearr_23128_23192 = state_23072__$1;
(statearr_23128_23192[(2)] = null);

(statearr_23128_23192[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (11))){
var inst_22971 = (state_23072[(7)]);
var inst_22949 = (state_23072[(15)]);
var inst_22971__$1 = cljs.core.seq(inst_22949);
var state_23072__$1 = (function (){var statearr_23129 = state_23072;
(statearr_23129[(7)] = inst_22971__$1);

return statearr_23129;
})();
if(inst_22971__$1){
var statearr_23130_23193 = state_23072__$1;
(statearr_23130_23193[(1)] = (16));

} else {
var statearr_23131_23194 = state_23072__$1;
(statearr_23131_23194[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (9))){
var inst_23001 = (state_23072[(2)]);
var state_23072__$1 = state_23072;
var statearr_23132_23195 = state_23072__$1;
(statearr_23132_23195[(2)] = inst_23001);

(statearr_23132_23195[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (5))){
var inst_22947 = cljs.core.deref(cs);
var inst_22948 = cljs.core.seq(inst_22947);
var inst_22949 = inst_22948;
var inst_22950 = null;
var inst_22951 = (0);
var inst_22952 = (0);
var state_23072__$1 = (function (){var statearr_23133 = state_23072;
(statearr_23133[(13)] = inst_22952);

(statearr_23133[(14)] = inst_22951);

(statearr_23133[(15)] = inst_22949);

(statearr_23133[(17)] = inst_22950);

return statearr_23133;
})();
var statearr_23134_23196 = state_23072__$1;
(statearr_23134_23196[(2)] = null);

(statearr_23134_23196[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (14))){
var state_23072__$1 = state_23072;
var statearr_23135_23197 = state_23072__$1;
(statearr_23135_23197[(2)] = null);

(statearr_23135_23197[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (45))){
var inst_23062 = (state_23072[(2)]);
var state_23072__$1 = state_23072;
var statearr_23136_23198 = state_23072__$1;
(statearr_23136_23198[(2)] = inst_23062);

(statearr_23136_23198[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (26))){
var inst_23004 = (state_23072[(29)]);
var inst_23058 = (state_23072[(2)]);
var inst_23059 = cljs.core.seq(inst_23004);
var state_23072__$1 = (function (){var statearr_23137 = state_23072;
(statearr_23137[(31)] = inst_23058);

return statearr_23137;
})();
if(inst_23059){
var statearr_23138_23199 = state_23072__$1;
(statearr_23138_23199[(1)] = (42));

} else {
var statearr_23139_23200 = state_23072__$1;
(statearr_23139_23200[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (16))){
var inst_22971 = (state_23072[(7)]);
var inst_22973 = cljs.core.chunked_seq_QMARK_(inst_22971);
var state_23072__$1 = state_23072;
if(inst_22973){
var statearr_23140_23201 = state_23072__$1;
(statearr_23140_23201[(1)] = (19));

} else {
var statearr_23141_23202 = state_23072__$1;
(statearr_23141_23202[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (38))){
var inst_23051 = (state_23072[(2)]);
var state_23072__$1 = state_23072;
var statearr_23142_23203 = state_23072__$1;
(statearr_23142_23203[(2)] = inst_23051);

(statearr_23142_23203[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (30))){
var state_23072__$1 = state_23072;
var statearr_23143_23204 = state_23072__$1;
(statearr_23143_23204[(2)] = null);

(statearr_23143_23204[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (10))){
var inst_22952 = (state_23072[(13)]);
var inst_22950 = (state_23072[(17)]);
var inst_22960 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_22950,inst_22952);
var inst_22961 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22960,(0),null);
var inst_22962 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22960,(1),null);
var state_23072__$1 = (function (){var statearr_23144 = state_23072;
(statearr_23144[(26)] = inst_22961);

return statearr_23144;
})();
if(cljs.core.truth_(inst_22962)){
var statearr_23145_23205 = state_23072__$1;
(statearr_23145_23205[(1)] = (13));

} else {
var statearr_23146_23206 = state_23072__$1;
(statearr_23146_23206[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (18))){
var inst_22997 = (state_23072[(2)]);
var state_23072__$1 = state_23072;
var statearr_23147_23207 = state_23072__$1;
(statearr_23147_23207[(2)] = inst_22997);

(statearr_23147_23207[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (42))){
var state_23072__$1 = state_23072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23072__$1,(45),dchan);
} else {
if((state_val_23073 === (37))){
var inst_23040 = (state_23072[(23)]);
var inst_22940 = (state_23072[(11)]);
var inst_23031 = (state_23072[(25)]);
var inst_23040__$1 = cljs.core.first(inst_23031);
var inst_23041 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_23040__$1,inst_22940,done);
var state_23072__$1 = (function (){var statearr_23148 = state_23072;
(statearr_23148[(23)] = inst_23040__$1);

return statearr_23148;
})();
if(cljs.core.truth_(inst_23041)){
var statearr_23149_23208 = state_23072__$1;
(statearr_23149_23208[(1)] = (39));

} else {
var statearr_23150_23209 = state_23072__$1;
(statearr_23150_23209[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23073 === (8))){
var inst_22952 = (state_23072[(13)]);
var inst_22951 = (state_23072[(14)]);
var inst_22954 = (inst_22952 < inst_22951);
var inst_22955 = inst_22954;
var state_23072__$1 = state_23072;
if(cljs.core.truth_(inst_22955)){
var statearr_23151_23210 = state_23072__$1;
(statearr_23151_23210[(1)] = (10));

} else {
var statearr_23152_23211 = state_23072__$1;
(statearr_23152_23211[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___23157,cs,m,dchan,dctr,done))
;
return ((function (switch__22234__auto__,c__22336__auto___23157,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__22235__auto__ = null;
var cljs$core$async$mult_$_state_machine__22235__auto____0 = (function (){
var statearr_23153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23153[(0)] = cljs$core$async$mult_$_state_machine__22235__auto__);

(statearr_23153[(1)] = (1));

return statearr_23153;
});
var cljs$core$async$mult_$_state_machine__22235__auto____1 = (function (state_23072){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_23072);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e23154){if((e23154 instanceof Object)){
var ex__22238__auto__ = e23154;
var statearr_23155_23212 = state_23072;
(statearr_23155_23212[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23072);

return cljs.core.cst$kw$recur;
} else {
throw e23154;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__23213 = state_23072;
state_23072 = G__23213;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__22235__auto__ = function(state_23072){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__22235__auto____1.call(this,state_23072);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__22235__auto____0;
cljs$core$async$mult_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__22235__auto____1;
return cljs$core$async$mult_$_state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___23157,cs,m,dchan,dctr,done))
})();
var state__22338__auto__ = (function (){var statearr_23156 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_23156[(6)] = c__22336__auto___23157);

return statearr_23156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___23157,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__23215 = arguments.length;
switch (G__23215) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto__.call(null,m,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto__.call(null,m,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9542__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto__.call(null,m));
} else {
var m__9542__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9542__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9542__auto__.call(null,m,state_map));
} else {
var m__9542__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9542__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__9541__auto__ = (((m == null))?null:m);
var m__9542__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9542__auto__.call(null,m,mode));
} else {
var m__9542__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9542__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10094__auto__ = [];
var len__10087__auto___23227 = arguments.length;
var i__10088__auto___23228 = (0);
while(true){
if((i__10088__auto___23228 < len__10087__auto___23227)){
args__10094__auto__.push((arguments[i__10088__auto___23228]));

var G__23229 = (i__10088__auto___23228 + (1));
i__10088__auto___23228 = G__23229;
continue;
} else {
}
break;
}

var argseq__10095__auto__ = ((((3) < args__10094__auto__.length))?(new cljs.core.IndexedSeq(args__10094__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10095__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__23221){
var map__23222 = p__23221;
var map__23222__$1 = ((((!((map__23222 == null)))?((((map__23222.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23222.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23222):map__23222);
var opts = map__23222__$1;
var statearr_23224_23230 = state;
(statearr_23224_23230[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__23222,map__23222__$1,opts){
return (function (val){
var statearr_23225_23231 = state;
(statearr_23225_23231[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__23222,map__23222__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_23226_23232 = state;
(statearr_23226_23232[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq23217){
var G__23218 = cljs.core.first(seq23217);
var seq23217__$1 = cljs.core.next(seq23217);
var G__23219 = cljs.core.first(seq23217__$1);
var seq23217__$2 = cljs.core.next(seq23217__$1);
var G__23220 = cljs.core.first(seq23217__$2);
var seq23217__$3 = cljs.core.next(seq23217__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23218,G__23219,G__23220,seq23217__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async23233 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23233 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta23234){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta23234 = meta23234;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23233.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_23235,meta23234__$1){
var self__ = this;
var _23235__$1 = this;
return (new cljs.core.async.t_cljs$core$async23233(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta23234__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23233.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_23235){
var self__ = this;
var _23235__$1 = this;
return self__.meta23234;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23233.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23233.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23233.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23233.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23233.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23233.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23233.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23233.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23233.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta23234], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async23233.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23233.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23233";

cljs.core.async.t_cljs$core$async23233.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async23233");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async23233 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async23233(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta23234){
return (new cljs.core.async.t_cljs$core$async23233(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta23234));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async23233(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__22336__auto___23397 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___23397,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___23397,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_23337){
var state_val_23338 = (state_23337[(1)]);
if((state_val_23338 === (7))){
var inst_23252 = (state_23337[(2)]);
var state_23337__$1 = state_23337;
var statearr_23339_23398 = state_23337__$1;
(statearr_23339_23398[(2)] = inst_23252);

(statearr_23339_23398[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (20))){
var inst_23264 = (state_23337[(7)]);
var state_23337__$1 = state_23337;
var statearr_23340_23399 = state_23337__$1;
(statearr_23340_23399[(2)] = inst_23264);

(statearr_23340_23399[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (27))){
var state_23337__$1 = state_23337;
var statearr_23341_23400 = state_23337__$1;
(statearr_23341_23400[(2)] = null);

(statearr_23341_23400[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (1))){
var inst_23239 = (state_23337[(8)]);
var inst_23239__$1 = calc_state();
var inst_23241 = (inst_23239__$1 == null);
var inst_23242 = cljs.core.not(inst_23241);
var state_23337__$1 = (function (){var statearr_23342 = state_23337;
(statearr_23342[(8)] = inst_23239__$1);

return statearr_23342;
})();
if(inst_23242){
var statearr_23343_23401 = state_23337__$1;
(statearr_23343_23401[(1)] = (2));

} else {
var statearr_23344_23402 = state_23337__$1;
(statearr_23344_23402[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (24))){
var inst_23311 = (state_23337[(9)]);
var inst_23297 = (state_23337[(10)]);
var inst_23288 = (state_23337[(11)]);
var inst_23311__$1 = (inst_23288.cljs$core$IFn$_invoke$arity$1 ? inst_23288.cljs$core$IFn$_invoke$arity$1(inst_23297) : inst_23288.call(null,inst_23297));
var state_23337__$1 = (function (){var statearr_23345 = state_23337;
(statearr_23345[(9)] = inst_23311__$1);

return statearr_23345;
})();
if(cljs.core.truth_(inst_23311__$1)){
var statearr_23346_23403 = state_23337__$1;
(statearr_23346_23403[(1)] = (29));

} else {
var statearr_23347_23404 = state_23337__$1;
(statearr_23347_23404[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (4))){
var inst_23255 = (state_23337[(2)]);
var state_23337__$1 = state_23337;
if(cljs.core.truth_(inst_23255)){
var statearr_23348_23405 = state_23337__$1;
(statearr_23348_23405[(1)] = (8));

} else {
var statearr_23349_23406 = state_23337__$1;
(statearr_23349_23406[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (15))){
var inst_23282 = (state_23337[(2)]);
var state_23337__$1 = state_23337;
if(cljs.core.truth_(inst_23282)){
var statearr_23350_23407 = state_23337__$1;
(statearr_23350_23407[(1)] = (19));

} else {
var statearr_23351_23408 = state_23337__$1;
(statearr_23351_23408[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (21))){
var inst_23287 = (state_23337[(12)]);
var inst_23287__$1 = (state_23337[(2)]);
var inst_23288 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23287__$1,cljs.core.cst$kw$solos);
var inst_23289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23287__$1,cljs.core.cst$kw$mutes);
var inst_23290 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23287__$1,cljs.core.cst$kw$reads);
var state_23337__$1 = (function (){var statearr_23352 = state_23337;
(statearr_23352[(13)] = inst_23289);

(statearr_23352[(11)] = inst_23288);

(statearr_23352[(12)] = inst_23287__$1);

return statearr_23352;
})();
return cljs.core.async.ioc_alts_BANG_(state_23337__$1,(22),inst_23290);
} else {
if((state_val_23338 === (31))){
var inst_23319 = (state_23337[(2)]);
var state_23337__$1 = state_23337;
if(cljs.core.truth_(inst_23319)){
var statearr_23353_23409 = state_23337__$1;
(statearr_23353_23409[(1)] = (32));

} else {
var statearr_23354_23410 = state_23337__$1;
(statearr_23354_23410[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (32))){
var inst_23296 = (state_23337[(14)]);
var state_23337__$1 = state_23337;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23337__$1,(35),out,inst_23296);
} else {
if((state_val_23338 === (33))){
var inst_23287 = (state_23337[(12)]);
var inst_23264 = inst_23287;
var state_23337__$1 = (function (){var statearr_23355 = state_23337;
(statearr_23355[(7)] = inst_23264);

return statearr_23355;
})();
var statearr_23356_23411 = state_23337__$1;
(statearr_23356_23411[(2)] = null);

(statearr_23356_23411[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (13))){
var inst_23264 = (state_23337[(7)]);
var inst_23271 = inst_23264.cljs$lang$protocol_mask$partition0$;
var inst_23272 = (inst_23271 & (64));
var inst_23273 = inst_23264.cljs$core$ISeq$;
var inst_23274 = (cljs.core.PROTOCOL_SENTINEL === inst_23273);
var inst_23275 = (inst_23272) || (inst_23274);
var state_23337__$1 = state_23337;
if(cljs.core.truth_(inst_23275)){
var statearr_23357_23412 = state_23337__$1;
(statearr_23357_23412[(1)] = (16));

} else {
var statearr_23358_23413 = state_23337__$1;
(statearr_23358_23413[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (22))){
var inst_23297 = (state_23337[(10)]);
var inst_23296 = (state_23337[(14)]);
var inst_23295 = (state_23337[(2)]);
var inst_23296__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23295,(0),null);
var inst_23297__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23295,(1),null);
var inst_23298 = (inst_23296__$1 == null);
var inst_23299 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_23297__$1,change);
var inst_23300 = (inst_23298) || (inst_23299);
var state_23337__$1 = (function (){var statearr_23359 = state_23337;
(statearr_23359[(10)] = inst_23297__$1);

(statearr_23359[(14)] = inst_23296__$1);

return statearr_23359;
})();
if(cljs.core.truth_(inst_23300)){
var statearr_23360_23414 = state_23337__$1;
(statearr_23360_23414[(1)] = (23));

} else {
var statearr_23361_23415 = state_23337__$1;
(statearr_23361_23415[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (36))){
var inst_23287 = (state_23337[(12)]);
var inst_23264 = inst_23287;
var state_23337__$1 = (function (){var statearr_23362 = state_23337;
(statearr_23362[(7)] = inst_23264);

return statearr_23362;
})();
var statearr_23363_23416 = state_23337__$1;
(statearr_23363_23416[(2)] = null);

(statearr_23363_23416[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (29))){
var inst_23311 = (state_23337[(9)]);
var state_23337__$1 = state_23337;
var statearr_23364_23417 = state_23337__$1;
(statearr_23364_23417[(2)] = inst_23311);

(statearr_23364_23417[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (6))){
var state_23337__$1 = state_23337;
var statearr_23365_23418 = state_23337__$1;
(statearr_23365_23418[(2)] = false);

(statearr_23365_23418[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (28))){
var inst_23307 = (state_23337[(2)]);
var inst_23308 = calc_state();
var inst_23264 = inst_23308;
var state_23337__$1 = (function (){var statearr_23366 = state_23337;
(statearr_23366[(15)] = inst_23307);

(statearr_23366[(7)] = inst_23264);

return statearr_23366;
})();
var statearr_23367_23419 = state_23337__$1;
(statearr_23367_23419[(2)] = null);

(statearr_23367_23419[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (25))){
var inst_23333 = (state_23337[(2)]);
var state_23337__$1 = state_23337;
var statearr_23368_23420 = state_23337__$1;
(statearr_23368_23420[(2)] = inst_23333);

(statearr_23368_23420[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (34))){
var inst_23331 = (state_23337[(2)]);
var state_23337__$1 = state_23337;
var statearr_23369_23421 = state_23337__$1;
(statearr_23369_23421[(2)] = inst_23331);

(statearr_23369_23421[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (17))){
var state_23337__$1 = state_23337;
var statearr_23370_23422 = state_23337__$1;
(statearr_23370_23422[(2)] = false);

(statearr_23370_23422[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (3))){
var state_23337__$1 = state_23337;
var statearr_23371_23423 = state_23337__$1;
(statearr_23371_23423[(2)] = false);

(statearr_23371_23423[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (12))){
var inst_23335 = (state_23337[(2)]);
var state_23337__$1 = state_23337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23337__$1,inst_23335);
} else {
if((state_val_23338 === (2))){
var inst_23239 = (state_23337[(8)]);
var inst_23244 = inst_23239.cljs$lang$protocol_mask$partition0$;
var inst_23245 = (inst_23244 & (64));
var inst_23246 = inst_23239.cljs$core$ISeq$;
var inst_23247 = (cljs.core.PROTOCOL_SENTINEL === inst_23246);
var inst_23248 = (inst_23245) || (inst_23247);
var state_23337__$1 = state_23337;
if(cljs.core.truth_(inst_23248)){
var statearr_23372_23424 = state_23337__$1;
(statearr_23372_23424[(1)] = (5));

} else {
var statearr_23373_23425 = state_23337__$1;
(statearr_23373_23425[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (23))){
var inst_23296 = (state_23337[(14)]);
var inst_23302 = (inst_23296 == null);
var state_23337__$1 = state_23337;
if(cljs.core.truth_(inst_23302)){
var statearr_23374_23426 = state_23337__$1;
(statearr_23374_23426[(1)] = (26));

} else {
var statearr_23375_23427 = state_23337__$1;
(statearr_23375_23427[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (35))){
var inst_23322 = (state_23337[(2)]);
var state_23337__$1 = state_23337;
if(cljs.core.truth_(inst_23322)){
var statearr_23376_23428 = state_23337__$1;
(statearr_23376_23428[(1)] = (36));

} else {
var statearr_23377_23429 = state_23337__$1;
(statearr_23377_23429[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (19))){
var inst_23264 = (state_23337[(7)]);
var inst_23284 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_23264);
var state_23337__$1 = state_23337;
var statearr_23378_23430 = state_23337__$1;
(statearr_23378_23430[(2)] = inst_23284);

(statearr_23378_23430[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (11))){
var inst_23264 = (state_23337[(7)]);
var inst_23268 = (inst_23264 == null);
var inst_23269 = cljs.core.not(inst_23268);
var state_23337__$1 = state_23337;
if(inst_23269){
var statearr_23379_23431 = state_23337__$1;
(statearr_23379_23431[(1)] = (13));

} else {
var statearr_23380_23432 = state_23337__$1;
(statearr_23380_23432[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (9))){
var inst_23239 = (state_23337[(8)]);
var state_23337__$1 = state_23337;
var statearr_23381_23433 = state_23337__$1;
(statearr_23381_23433[(2)] = inst_23239);

(statearr_23381_23433[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (5))){
var state_23337__$1 = state_23337;
var statearr_23382_23434 = state_23337__$1;
(statearr_23382_23434[(2)] = true);

(statearr_23382_23434[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (14))){
var state_23337__$1 = state_23337;
var statearr_23383_23435 = state_23337__$1;
(statearr_23383_23435[(2)] = false);

(statearr_23383_23435[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (26))){
var inst_23297 = (state_23337[(10)]);
var inst_23304 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_23297);
var state_23337__$1 = state_23337;
var statearr_23384_23436 = state_23337__$1;
(statearr_23384_23436[(2)] = inst_23304);

(statearr_23384_23436[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (16))){
var state_23337__$1 = state_23337;
var statearr_23385_23437 = state_23337__$1;
(statearr_23385_23437[(2)] = true);

(statearr_23385_23437[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (38))){
var inst_23327 = (state_23337[(2)]);
var state_23337__$1 = state_23337;
var statearr_23386_23438 = state_23337__$1;
(statearr_23386_23438[(2)] = inst_23327);

(statearr_23386_23438[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (30))){
var inst_23289 = (state_23337[(13)]);
var inst_23297 = (state_23337[(10)]);
var inst_23288 = (state_23337[(11)]);
var inst_23314 = cljs.core.empty_QMARK_(inst_23288);
var inst_23315 = (inst_23289.cljs$core$IFn$_invoke$arity$1 ? inst_23289.cljs$core$IFn$_invoke$arity$1(inst_23297) : inst_23289.call(null,inst_23297));
var inst_23316 = cljs.core.not(inst_23315);
var inst_23317 = (inst_23314) && (inst_23316);
var state_23337__$1 = state_23337;
var statearr_23387_23439 = state_23337__$1;
(statearr_23387_23439[(2)] = inst_23317);

(statearr_23387_23439[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (10))){
var inst_23239 = (state_23337[(8)]);
var inst_23260 = (state_23337[(2)]);
var inst_23261 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23260,cljs.core.cst$kw$solos);
var inst_23262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23260,cljs.core.cst$kw$mutes);
var inst_23263 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23260,cljs.core.cst$kw$reads);
var inst_23264 = inst_23239;
var state_23337__$1 = (function (){var statearr_23388 = state_23337;
(statearr_23388[(16)] = inst_23263);

(statearr_23388[(7)] = inst_23264);

(statearr_23388[(17)] = inst_23261);

(statearr_23388[(18)] = inst_23262);

return statearr_23388;
})();
var statearr_23389_23440 = state_23337__$1;
(statearr_23389_23440[(2)] = null);

(statearr_23389_23440[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (18))){
var inst_23279 = (state_23337[(2)]);
var state_23337__$1 = state_23337;
var statearr_23390_23441 = state_23337__$1;
(statearr_23390_23441[(2)] = inst_23279);

(statearr_23390_23441[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (37))){
var state_23337__$1 = state_23337;
var statearr_23391_23442 = state_23337__$1;
(statearr_23391_23442[(2)] = null);

(statearr_23391_23442[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23338 === (8))){
var inst_23239 = (state_23337[(8)]);
var inst_23257 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_23239);
var state_23337__$1 = state_23337;
var statearr_23392_23443 = state_23337__$1;
(statearr_23392_23443[(2)] = inst_23257);

(statearr_23392_23443[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___23397,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__22234__auto__,c__22336__auto___23397,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__22235__auto__ = null;
var cljs$core$async$mix_$_state_machine__22235__auto____0 = (function (){
var statearr_23393 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23393[(0)] = cljs$core$async$mix_$_state_machine__22235__auto__);

(statearr_23393[(1)] = (1));

return statearr_23393;
});
var cljs$core$async$mix_$_state_machine__22235__auto____1 = (function (state_23337){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_23337);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e23394){if((e23394 instanceof Object)){
var ex__22238__auto__ = e23394;
var statearr_23395_23444 = state_23337;
(statearr_23395_23444[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23337);

return cljs.core.cst$kw$recur;
} else {
throw e23394;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__23445 = state_23337;
state_23337 = G__23445;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__22235__auto__ = function(state_23337){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__22235__auto____1.call(this,state_23337);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__22235__auto____0;
cljs$core$async$mix_$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__22235__auto____1;
return cljs$core$async$mix_$_state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___23397,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__22338__auto__ = (function (){var statearr_23396 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_23396[(6)] = c__22336__auto___23397);

return statearr_23396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___23397,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9542__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__9542__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9542__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9542__auto__.call(null,p,v,ch));
} else {
var m__9542__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9542__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__23447 = arguments.length;
switch (G__23447) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__9542__auto__.call(null,p));
} else {
var m__9542__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__9542__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9541__auto__ = (((p == null))?null:p);
var m__9542__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9541__auto__)]);
if(!((m__9542__auto__ == null))){
return (m__9542__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__9542__auto__.call(null,p,v));
} else {
var m__9542__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9542__auto____$1 == null))){
return (m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9542__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__9542__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__23451 = arguments.length;
switch (G__23451) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8808__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__8808__auto__)){
return or__8808__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8808__auto__,mults){
return (function (p1__23449_SHARP_){
if(cljs.core.truth_((p1__23449_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23449_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__23449_SHARP_.call(null,topic)))){
return p1__23449_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__23449_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__8808__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async23452 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23452 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta23453){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta23453 = meta23453;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23452.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_23454,meta23453__$1){
var self__ = this;
var _23454__$1 = this;
return (new cljs.core.async.t_cljs$core$async23452(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta23453__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23452.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_23454){
var self__ = this;
var _23454__$1 = this;
return self__.meta23453;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23452.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23452.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23452.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23452.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23452.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23452.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23452.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23452.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta23453], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async23452.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23452.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23452";

cljs.core.async.t_cljs$core$async23452.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async23452");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async23452 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async23452(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23453){
return (new cljs.core.async.t_cljs$core$async23452(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23453));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async23452(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__22336__auto___23572 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___23572,mults,ensure_mult,p){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___23572,mults,ensure_mult,p){
return (function (state_23526){
var state_val_23527 = (state_23526[(1)]);
if((state_val_23527 === (7))){
var inst_23522 = (state_23526[(2)]);
var state_23526__$1 = state_23526;
var statearr_23528_23573 = state_23526__$1;
(statearr_23528_23573[(2)] = inst_23522);

(statearr_23528_23573[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (20))){
var state_23526__$1 = state_23526;
var statearr_23529_23574 = state_23526__$1;
(statearr_23529_23574[(2)] = null);

(statearr_23529_23574[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (1))){
var state_23526__$1 = state_23526;
var statearr_23530_23575 = state_23526__$1;
(statearr_23530_23575[(2)] = null);

(statearr_23530_23575[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (24))){
var inst_23505 = (state_23526[(7)]);
var inst_23514 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_23505);
var state_23526__$1 = state_23526;
var statearr_23531_23576 = state_23526__$1;
(statearr_23531_23576[(2)] = inst_23514);

(statearr_23531_23576[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (4))){
var inst_23457 = (state_23526[(8)]);
var inst_23457__$1 = (state_23526[(2)]);
var inst_23458 = (inst_23457__$1 == null);
var state_23526__$1 = (function (){var statearr_23532 = state_23526;
(statearr_23532[(8)] = inst_23457__$1);

return statearr_23532;
})();
if(cljs.core.truth_(inst_23458)){
var statearr_23533_23577 = state_23526__$1;
(statearr_23533_23577[(1)] = (5));

} else {
var statearr_23534_23578 = state_23526__$1;
(statearr_23534_23578[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (15))){
var inst_23499 = (state_23526[(2)]);
var state_23526__$1 = state_23526;
var statearr_23535_23579 = state_23526__$1;
(statearr_23535_23579[(2)] = inst_23499);

(statearr_23535_23579[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (21))){
var inst_23519 = (state_23526[(2)]);
var state_23526__$1 = (function (){var statearr_23536 = state_23526;
(statearr_23536[(9)] = inst_23519);

return statearr_23536;
})();
var statearr_23537_23580 = state_23526__$1;
(statearr_23537_23580[(2)] = null);

(statearr_23537_23580[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (13))){
var inst_23481 = (state_23526[(10)]);
var inst_23483 = cljs.core.chunked_seq_QMARK_(inst_23481);
var state_23526__$1 = state_23526;
if(inst_23483){
var statearr_23538_23581 = state_23526__$1;
(statearr_23538_23581[(1)] = (16));

} else {
var statearr_23539_23582 = state_23526__$1;
(statearr_23539_23582[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (22))){
var inst_23511 = (state_23526[(2)]);
var state_23526__$1 = state_23526;
if(cljs.core.truth_(inst_23511)){
var statearr_23540_23583 = state_23526__$1;
(statearr_23540_23583[(1)] = (23));

} else {
var statearr_23541_23584 = state_23526__$1;
(statearr_23541_23584[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (6))){
var inst_23507 = (state_23526[(11)]);
var inst_23505 = (state_23526[(7)]);
var inst_23457 = (state_23526[(8)]);
var inst_23505__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_23457) : topic_fn.call(null,inst_23457));
var inst_23506 = cljs.core.deref(mults);
var inst_23507__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23506,inst_23505__$1);
var state_23526__$1 = (function (){var statearr_23542 = state_23526;
(statearr_23542[(11)] = inst_23507__$1);

(statearr_23542[(7)] = inst_23505__$1);

return statearr_23542;
})();
if(cljs.core.truth_(inst_23507__$1)){
var statearr_23543_23585 = state_23526__$1;
(statearr_23543_23585[(1)] = (19));

} else {
var statearr_23544_23586 = state_23526__$1;
(statearr_23544_23586[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (25))){
var inst_23516 = (state_23526[(2)]);
var state_23526__$1 = state_23526;
var statearr_23545_23587 = state_23526__$1;
(statearr_23545_23587[(2)] = inst_23516);

(statearr_23545_23587[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (17))){
var inst_23481 = (state_23526[(10)]);
var inst_23490 = cljs.core.first(inst_23481);
var inst_23491 = cljs.core.async.muxch_STAR_(inst_23490);
var inst_23492 = cljs.core.async.close_BANG_(inst_23491);
var inst_23493 = cljs.core.next(inst_23481);
var inst_23467 = inst_23493;
var inst_23468 = null;
var inst_23469 = (0);
var inst_23470 = (0);
var state_23526__$1 = (function (){var statearr_23546 = state_23526;
(statearr_23546[(12)] = inst_23492);

(statearr_23546[(13)] = inst_23470);

(statearr_23546[(14)] = inst_23467);

(statearr_23546[(15)] = inst_23468);

(statearr_23546[(16)] = inst_23469);

return statearr_23546;
})();
var statearr_23547_23588 = state_23526__$1;
(statearr_23547_23588[(2)] = null);

(statearr_23547_23588[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (3))){
var inst_23524 = (state_23526[(2)]);
var state_23526__$1 = state_23526;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23526__$1,inst_23524);
} else {
if((state_val_23527 === (12))){
var inst_23501 = (state_23526[(2)]);
var state_23526__$1 = state_23526;
var statearr_23548_23589 = state_23526__$1;
(statearr_23548_23589[(2)] = inst_23501);

(statearr_23548_23589[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (2))){
var state_23526__$1 = state_23526;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23526__$1,(4),ch);
} else {
if((state_val_23527 === (23))){
var state_23526__$1 = state_23526;
var statearr_23549_23590 = state_23526__$1;
(statearr_23549_23590[(2)] = null);

(statearr_23549_23590[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (19))){
var inst_23507 = (state_23526[(11)]);
var inst_23457 = (state_23526[(8)]);
var inst_23509 = cljs.core.async.muxch_STAR_(inst_23507);
var state_23526__$1 = state_23526;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23526__$1,(22),inst_23509,inst_23457);
} else {
if((state_val_23527 === (11))){
var inst_23481 = (state_23526[(10)]);
var inst_23467 = (state_23526[(14)]);
var inst_23481__$1 = cljs.core.seq(inst_23467);
var state_23526__$1 = (function (){var statearr_23550 = state_23526;
(statearr_23550[(10)] = inst_23481__$1);

return statearr_23550;
})();
if(inst_23481__$1){
var statearr_23551_23591 = state_23526__$1;
(statearr_23551_23591[(1)] = (13));

} else {
var statearr_23552_23592 = state_23526__$1;
(statearr_23552_23592[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (9))){
var inst_23503 = (state_23526[(2)]);
var state_23526__$1 = state_23526;
var statearr_23553_23593 = state_23526__$1;
(statearr_23553_23593[(2)] = inst_23503);

(statearr_23553_23593[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (5))){
var inst_23464 = cljs.core.deref(mults);
var inst_23465 = cljs.core.vals(inst_23464);
var inst_23466 = cljs.core.seq(inst_23465);
var inst_23467 = inst_23466;
var inst_23468 = null;
var inst_23469 = (0);
var inst_23470 = (0);
var state_23526__$1 = (function (){var statearr_23554 = state_23526;
(statearr_23554[(13)] = inst_23470);

(statearr_23554[(14)] = inst_23467);

(statearr_23554[(15)] = inst_23468);

(statearr_23554[(16)] = inst_23469);

return statearr_23554;
})();
var statearr_23555_23594 = state_23526__$1;
(statearr_23555_23594[(2)] = null);

(statearr_23555_23594[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (14))){
var state_23526__$1 = state_23526;
var statearr_23559_23595 = state_23526__$1;
(statearr_23559_23595[(2)] = null);

(statearr_23559_23595[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (16))){
var inst_23481 = (state_23526[(10)]);
var inst_23485 = cljs.core.chunk_first(inst_23481);
var inst_23486 = cljs.core.chunk_rest(inst_23481);
var inst_23487 = cljs.core.count(inst_23485);
var inst_23467 = inst_23486;
var inst_23468 = inst_23485;
var inst_23469 = inst_23487;
var inst_23470 = (0);
var state_23526__$1 = (function (){var statearr_23560 = state_23526;
(statearr_23560[(13)] = inst_23470);

(statearr_23560[(14)] = inst_23467);

(statearr_23560[(15)] = inst_23468);

(statearr_23560[(16)] = inst_23469);

return statearr_23560;
})();
var statearr_23561_23596 = state_23526__$1;
(statearr_23561_23596[(2)] = null);

(statearr_23561_23596[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (10))){
var inst_23470 = (state_23526[(13)]);
var inst_23467 = (state_23526[(14)]);
var inst_23468 = (state_23526[(15)]);
var inst_23469 = (state_23526[(16)]);
var inst_23475 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_23468,inst_23470);
var inst_23476 = cljs.core.async.muxch_STAR_(inst_23475);
var inst_23477 = cljs.core.async.close_BANG_(inst_23476);
var inst_23478 = (inst_23470 + (1));
var tmp23556 = inst_23467;
var tmp23557 = inst_23468;
var tmp23558 = inst_23469;
var inst_23467__$1 = tmp23556;
var inst_23468__$1 = tmp23557;
var inst_23469__$1 = tmp23558;
var inst_23470__$1 = inst_23478;
var state_23526__$1 = (function (){var statearr_23562 = state_23526;
(statearr_23562[(17)] = inst_23477);

(statearr_23562[(13)] = inst_23470__$1);

(statearr_23562[(14)] = inst_23467__$1);

(statearr_23562[(15)] = inst_23468__$1);

(statearr_23562[(16)] = inst_23469__$1);

return statearr_23562;
})();
var statearr_23563_23597 = state_23526__$1;
(statearr_23563_23597[(2)] = null);

(statearr_23563_23597[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (18))){
var inst_23496 = (state_23526[(2)]);
var state_23526__$1 = state_23526;
var statearr_23564_23598 = state_23526__$1;
(statearr_23564_23598[(2)] = inst_23496);

(statearr_23564_23598[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23527 === (8))){
var inst_23470 = (state_23526[(13)]);
var inst_23469 = (state_23526[(16)]);
var inst_23472 = (inst_23470 < inst_23469);
var inst_23473 = inst_23472;
var state_23526__$1 = state_23526;
if(cljs.core.truth_(inst_23473)){
var statearr_23565_23599 = state_23526__$1;
(statearr_23565_23599[(1)] = (10));

} else {
var statearr_23566_23600 = state_23526__$1;
(statearr_23566_23600[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___23572,mults,ensure_mult,p))
;
return ((function (switch__22234__auto__,c__22336__auto___23572,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_23567 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23567[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_23567[(1)] = (1));

return statearr_23567;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_23526){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_23526);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e23568){if((e23568 instanceof Object)){
var ex__22238__auto__ = e23568;
var statearr_23569_23601 = state_23526;
(statearr_23569_23601[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23526);

return cljs.core.cst$kw$recur;
} else {
throw e23568;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__23602 = state_23526;
state_23526 = G__23602;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_23526){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_23526);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___23572,mults,ensure_mult,p))
})();
var state__22338__auto__ = (function (){var statearr_23570 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_23570[(6)] = c__22336__auto___23572);

return statearr_23570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___23572,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__23604 = arguments.length;
switch (G__23604) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__23607 = arguments.length;
switch (G__23607) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__23610 = arguments.length;
switch (G__23610) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__22336__auto___23677 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___23677,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___23677,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_23649){
var state_val_23650 = (state_23649[(1)]);
if((state_val_23650 === (7))){
var state_23649__$1 = state_23649;
var statearr_23651_23678 = state_23649__$1;
(statearr_23651_23678[(2)] = null);

(statearr_23651_23678[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (1))){
var state_23649__$1 = state_23649;
var statearr_23652_23679 = state_23649__$1;
(statearr_23652_23679[(2)] = null);

(statearr_23652_23679[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (4))){
var inst_23613 = (state_23649[(7)]);
var inst_23615 = (inst_23613 < cnt);
var state_23649__$1 = state_23649;
if(cljs.core.truth_(inst_23615)){
var statearr_23653_23680 = state_23649__$1;
(statearr_23653_23680[(1)] = (6));

} else {
var statearr_23654_23681 = state_23649__$1;
(statearr_23654_23681[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (15))){
var inst_23645 = (state_23649[(2)]);
var state_23649__$1 = state_23649;
var statearr_23655_23682 = state_23649__$1;
(statearr_23655_23682[(2)] = inst_23645);

(statearr_23655_23682[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (13))){
var inst_23638 = cljs.core.async.close_BANG_(out);
var state_23649__$1 = state_23649;
var statearr_23656_23683 = state_23649__$1;
(statearr_23656_23683[(2)] = inst_23638);

(statearr_23656_23683[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (6))){
var state_23649__$1 = state_23649;
var statearr_23657_23684 = state_23649__$1;
(statearr_23657_23684[(2)] = null);

(statearr_23657_23684[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (3))){
var inst_23647 = (state_23649[(2)]);
var state_23649__$1 = state_23649;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23649__$1,inst_23647);
} else {
if((state_val_23650 === (12))){
var inst_23635 = (state_23649[(8)]);
var inst_23635__$1 = (state_23649[(2)]);
var inst_23636 = cljs.core.some(cljs.core.nil_QMARK_,inst_23635__$1);
var state_23649__$1 = (function (){var statearr_23658 = state_23649;
(statearr_23658[(8)] = inst_23635__$1);

return statearr_23658;
})();
if(cljs.core.truth_(inst_23636)){
var statearr_23659_23685 = state_23649__$1;
(statearr_23659_23685[(1)] = (13));

} else {
var statearr_23660_23686 = state_23649__$1;
(statearr_23660_23686[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (2))){
var inst_23612 = cljs.core.reset_BANG_(dctr,cnt);
var inst_23613 = (0);
var state_23649__$1 = (function (){var statearr_23661 = state_23649;
(statearr_23661[(7)] = inst_23613);

(statearr_23661[(9)] = inst_23612);

return statearr_23661;
})();
var statearr_23662_23687 = state_23649__$1;
(statearr_23662_23687[(2)] = null);

(statearr_23662_23687[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (11))){
var inst_23613 = (state_23649[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_23649,(10),Object,null,(9));
var inst_23622 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_23613) : chs__$1.call(null,inst_23613));
var inst_23623 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_23613) : done.call(null,inst_23613));
var inst_23624 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_23622,inst_23623);
var state_23649__$1 = state_23649;
var statearr_23663_23688 = state_23649__$1;
(statearr_23663_23688[(2)] = inst_23624);


cljs.core.async.impl.ioc_helpers.process_exception(state_23649__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (9))){
var inst_23613 = (state_23649[(7)]);
var inst_23626 = (state_23649[(2)]);
var inst_23627 = (inst_23613 + (1));
var inst_23613__$1 = inst_23627;
var state_23649__$1 = (function (){var statearr_23664 = state_23649;
(statearr_23664[(7)] = inst_23613__$1);

(statearr_23664[(10)] = inst_23626);

return statearr_23664;
})();
var statearr_23665_23689 = state_23649__$1;
(statearr_23665_23689[(2)] = null);

(statearr_23665_23689[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (5))){
var inst_23633 = (state_23649[(2)]);
var state_23649__$1 = (function (){var statearr_23666 = state_23649;
(statearr_23666[(11)] = inst_23633);

return statearr_23666;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23649__$1,(12),dchan);
} else {
if((state_val_23650 === (14))){
var inst_23635 = (state_23649[(8)]);
var inst_23640 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_23635);
var state_23649__$1 = state_23649;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23649__$1,(16),out,inst_23640);
} else {
if((state_val_23650 === (16))){
var inst_23642 = (state_23649[(2)]);
var state_23649__$1 = (function (){var statearr_23667 = state_23649;
(statearr_23667[(12)] = inst_23642);

return statearr_23667;
})();
var statearr_23668_23690 = state_23649__$1;
(statearr_23668_23690[(2)] = null);

(statearr_23668_23690[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (10))){
var inst_23617 = (state_23649[(2)]);
var inst_23618 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_23649__$1 = (function (){var statearr_23669 = state_23649;
(statearr_23669[(13)] = inst_23617);

return statearr_23669;
})();
var statearr_23670_23691 = state_23649__$1;
(statearr_23670_23691[(2)] = inst_23618);


cljs.core.async.impl.ioc_helpers.process_exception(state_23649__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_23650 === (8))){
var inst_23631 = (state_23649[(2)]);
var state_23649__$1 = state_23649;
var statearr_23671_23692 = state_23649__$1;
(statearr_23671_23692[(2)] = inst_23631);

(statearr_23671_23692[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___23677,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__22234__auto__,c__22336__auto___23677,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_23672 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23672[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_23672[(1)] = (1));

return statearr_23672;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_23649){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_23649);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e23673){if((e23673 instanceof Object)){
var ex__22238__auto__ = e23673;
var statearr_23674_23693 = state_23649;
(statearr_23674_23693[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23649);

return cljs.core.cst$kw$recur;
} else {
throw e23673;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__23694 = state_23649;
state_23649 = G__23694;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_23649){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_23649);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___23677,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__22338__auto__ = (function (){var statearr_23675 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_23675[(6)] = c__22336__auto___23677);

return statearr_23675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___23677,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__23697 = arguments.length;
switch (G__23697) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__22336__auto___23751 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___23751,out){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___23751,out){
return (function (state_23729){
var state_val_23730 = (state_23729[(1)]);
if((state_val_23730 === (7))){
var inst_23708 = (state_23729[(7)]);
var inst_23709 = (state_23729[(8)]);
var inst_23708__$1 = (state_23729[(2)]);
var inst_23709__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23708__$1,(0),null);
var inst_23710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23708__$1,(1),null);
var inst_23711 = (inst_23709__$1 == null);
var state_23729__$1 = (function (){var statearr_23731 = state_23729;
(statearr_23731[(9)] = inst_23710);

(statearr_23731[(7)] = inst_23708__$1);

(statearr_23731[(8)] = inst_23709__$1);

return statearr_23731;
})();
if(cljs.core.truth_(inst_23711)){
var statearr_23732_23752 = state_23729__$1;
(statearr_23732_23752[(1)] = (8));

} else {
var statearr_23733_23753 = state_23729__$1;
(statearr_23733_23753[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23730 === (1))){
var inst_23698 = cljs.core.vec(chs);
var inst_23699 = inst_23698;
var state_23729__$1 = (function (){var statearr_23734 = state_23729;
(statearr_23734[(10)] = inst_23699);

return statearr_23734;
})();
var statearr_23735_23754 = state_23729__$1;
(statearr_23735_23754[(2)] = null);

(statearr_23735_23754[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23730 === (4))){
var inst_23699 = (state_23729[(10)]);
var state_23729__$1 = state_23729;
return cljs.core.async.ioc_alts_BANG_(state_23729__$1,(7),inst_23699);
} else {
if((state_val_23730 === (6))){
var inst_23725 = (state_23729[(2)]);
var state_23729__$1 = state_23729;
var statearr_23736_23755 = state_23729__$1;
(statearr_23736_23755[(2)] = inst_23725);

(statearr_23736_23755[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23730 === (3))){
var inst_23727 = (state_23729[(2)]);
var state_23729__$1 = state_23729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23729__$1,inst_23727);
} else {
if((state_val_23730 === (2))){
var inst_23699 = (state_23729[(10)]);
var inst_23701 = cljs.core.count(inst_23699);
var inst_23702 = (inst_23701 > (0));
var state_23729__$1 = state_23729;
if(cljs.core.truth_(inst_23702)){
var statearr_23738_23756 = state_23729__$1;
(statearr_23738_23756[(1)] = (4));

} else {
var statearr_23739_23757 = state_23729__$1;
(statearr_23739_23757[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23730 === (11))){
var inst_23699 = (state_23729[(10)]);
var inst_23718 = (state_23729[(2)]);
var tmp23737 = inst_23699;
var inst_23699__$1 = tmp23737;
var state_23729__$1 = (function (){var statearr_23740 = state_23729;
(statearr_23740[(10)] = inst_23699__$1);

(statearr_23740[(11)] = inst_23718);

return statearr_23740;
})();
var statearr_23741_23758 = state_23729__$1;
(statearr_23741_23758[(2)] = null);

(statearr_23741_23758[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23730 === (9))){
var inst_23709 = (state_23729[(8)]);
var state_23729__$1 = state_23729;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23729__$1,(11),out,inst_23709);
} else {
if((state_val_23730 === (5))){
var inst_23723 = cljs.core.async.close_BANG_(out);
var state_23729__$1 = state_23729;
var statearr_23742_23759 = state_23729__$1;
(statearr_23742_23759[(2)] = inst_23723);

(statearr_23742_23759[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23730 === (10))){
var inst_23721 = (state_23729[(2)]);
var state_23729__$1 = state_23729;
var statearr_23743_23760 = state_23729__$1;
(statearr_23743_23760[(2)] = inst_23721);

(statearr_23743_23760[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23730 === (8))){
var inst_23710 = (state_23729[(9)]);
var inst_23708 = (state_23729[(7)]);
var inst_23709 = (state_23729[(8)]);
var inst_23699 = (state_23729[(10)]);
var inst_23713 = (function (){var cs = inst_23699;
var vec__23704 = inst_23708;
var v = inst_23709;
var c = inst_23710;
return ((function (cs,vec__23704,v,c,inst_23710,inst_23708,inst_23709,inst_23699,state_val_23730,c__22336__auto___23751,out){
return (function (p1__23695_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__23695_SHARP_);
});
;})(cs,vec__23704,v,c,inst_23710,inst_23708,inst_23709,inst_23699,state_val_23730,c__22336__auto___23751,out))
})();
var inst_23714 = cljs.core.filterv(inst_23713,inst_23699);
var inst_23699__$1 = inst_23714;
var state_23729__$1 = (function (){var statearr_23744 = state_23729;
(statearr_23744[(10)] = inst_23699__$1);

return statearr_23744;
})();
var statearr_23745_23761 = state_23729__$1;
(statearr_23745_23761[(2)] = null);

(statearr_23745_23761[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___23751,out))
;
return ((function (switch__22234__auto__,c__22336__auto___23751,out){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_23746 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23746[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_23746[(1)] = (1));

return statearr_23746;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_23729){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_23729);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e23747){if((e23747 instanceof Object)){
var ex__22238__auto__ = e23747;
var statearr_23748_23762 = state_23729;
(statearr_23748_23762[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23729);

return cljs.core.cst$kw$recur;
} else {
throw e23747;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__23763 = state_23729;
state_23729 = G__23763;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_23729){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_23729);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___23751,out))
})();
var state__22338__auto__ = (function (){var statearr_23749 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_23749[(6)] = c__22336__auto___23751);

return statearr_23749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___23751,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__23765 = arguments.length;
switch (G__23765) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__22336__auto___23810 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___23810,out){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___23810,out){
return (function (state_23789){
var state_val_23790 = (state_23789[(1)]);
if((state_val_23790 === (7))){
var inst_23771 = (state_23789[(7)]);
var inst_23771__$1 = (state_23789[(2)]);
var inst_23772 = (inst_23771__$1 == null);
var inst_23773 = cljs.core.not(inst_23772);
var state_23789__$1 = (function (){var statearr_23791 = state_23789;
(statearr_23791[(7)] = inst_23771__$1);

return statearr_23791;
})();
if(inst_23773){
var statearr_23792_23811 = state_23789__$1;
(statearr_23792_23811[(1)] = (8));

} else {
var statearr_23793_23812 = state_23789__$1;
(statearr_23793_23812[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23790 === (1))){
var inst_23766 = (0);
var state_23789__$1 = (function (){var statearr_23794 = state_23789;
(statearr_23794[(8)] = inst_23766);

return statearr_23794;
})();
var statearr_23795_23813 = state_23789__$1;
(statearr_23795_23813[(2)] = null);

(statearr_23795_23813[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23790 === (4))){
var state_23789__$1 = state_23789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23789__$1,(7),ch);
} else {
if((state_val_23790 === (6))){
var inst_23784 = (state_23789[(2)]);
var state_23789__$1 = state_23789;
var statearr_23796_23814 = state_23789__$1;
(statearr_23796_23814[(2)] = inst_23784);

(statearr_23796_23814[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23790 === (3))){
var inst_23786 = (state_23789[(2)]);
var inst_23787 = cljs.core.async.close_BANG_(out);
var state_23789__$1 = (function (){var statearr_23797 = state_23789;
(statearr_23797[(9)] = inst_23786);

return statearr_23797;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_23789__$1,inst_23787);
} else {
if((state_val_23790 === (2))){
var inst_23766 = (state_23789[(8)]);
var inst_23768 = (inst_23766 < n);
var state_23789__$1 = state_23789;
if(cljs.core.truth_(inst_23768)){
var statearr_23798_23815 = state_23789__$1;
(statearr_23798_23815[(1)] = (4));

} else {
var statearr_23799_23816 = state_23789__$1;
(statearr_23799_23816[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23790 === (11))){
var inst_23766 = (state_23789[(8)]);
var inst_23776 = (state_23789[(2)]);
var inst_23777 = (inst_23766 + (1));
var inst_23766__$1 = inst_23777;
var state_23789__$1 = (function (){var statearr_23800 = state_23789;
(statearr_23800[(8)] = inst_23766__$1);

(statearr_23800[(10)] = inst_23776);

return statearr_23800;
})();
var statearr_23801_23817 = state_23789__$1;
(statearr_23801_23817[(2)] = null);

(statearr_23801_23817[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23790 === (9))){
var state_23789__$1 = state_23789;
var statearr_23802_23818 = state_23789__$1;
(statearr_23802_23818[(2)] = null);

(statearr_23802_23818[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23790 === (5))){
var state_23789__$1 = state_23789;
var statearr_23803_23819 = state_23789__$1;
(statearr_23803_23819[(2)] = null);

(statearr_23803_23819[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23790 === (10))){
var inst_23781 = (state_23789[(2)]);
var state_23789__$1 = state_23789;
var statearr_23804_23820 = state_23789__$1;
(statearr_23804_23820[(2)] = inst_23781);

(statearr_23804_23820[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23790 === (8))){
var inst_23771 = (state_23789[(7)]);
var state_23789__$1 = state_23789;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23789__$1,(11),out,inst_23771);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___23810,out))
;
return ((function (switch__22234__auto__,c__22336__auto___23810,out){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_23805 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23805[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_23805[(1)] = (1));

return statearr_23805;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_23789){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_23789);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e23806){if((e23806 instanceof Object)){
var ex__22238__auto__ = e23806;
var statearr_23807_23821 = state_23789;
(statearr_23807_23821[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23789);

return cljs.core.cst$kw$recur;
} else {
throw e23806;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__23822 = state_23789;
state_23789 = G__23822;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_23789){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_23789);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___23810,out))
})();
var state__22338__auto__ = (function (){var statearr_23808 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_23808[(6)] = c__22336__auto___23810);

return statearr_23808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___23810,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async23824 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23824 = (function (f,ch,meta23825){
this.f = f;
this.ch = ch;
this.meta23825 = meta23825;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23824.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23826,meta23825__$1){
var self__ = this;
var _23826__$1 = this;
return (new cljs.core.async.t_cljs$core$async23824(self__.f,self__.ch,meta23825__$1));
});

cljs.core.async.t_cljs$core$async23824.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23826){
var self__ = this;
var _23826__$1 = this;
return self__.meta23825;
});

cljs.core.async.t_cljs$core$async23824.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23824.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async23824.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async23824.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23824.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async23827 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23827 = (function (f,ch,meta23825,_,fn1,meta23828){
this.f = f;
this.ch = ch;
this.meta23825 = meta23825;
this._ = _;
this.fn1 = fn1;
this.meta23828 = meta23828;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23827.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_23829,meta23828__$1){
var self__ = this;
var _23829__$1 = this;
return (new cljs.core.async.t_cljs$core$async23827(self__.f,self__.ch,self__.meta23825,self__._,self__.fn1,meta23828__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async23827.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_23829){
var self__ = this;
var _23829__$1 = this;
return self__.meta23828;
});})(___$1))
;

cljs.core.async.t_cljs$core$async23827.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23827.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async23827.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async23827.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__23823_SHARP_){
var G__23830 = (((p1__23823_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__23823_SHARP_) : self__.f.call(null,p1__23823_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__23830) : f1.call(null,G__23830));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async23827.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta23825,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async23824], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta23828], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async23827.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23827.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23827";

cljs.core.async.t_cljs$core$async23827.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async23827");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async23827 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async23827(f__$1,ch__$1,meta23825__$1,___$2,fn1__$1,meta23828){
return (new cljs.core.async.t_cljs$core$async23827(f__$1,ch__$1,meta23825__$1,___$2,fn1__$1,meta23828));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async23827(self__.f,self__.ch,self__.meta23825,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8796__auto__ = ret;
if(cljs.core.truth_(and__8796__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__8796__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__23831 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__23831) : self__.f.call(null,G__23831));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async23824.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23824.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async23824.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta23825], null);
});

cljs.core.async.t_cljs$core$async23824.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23824.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23824";

cljs.core.async.t_cljs$core$async23824.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async23824");
});

cljs.core.async.__GT_t_cljs$core$async23824 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async23824(f__$1,ch__$1,meta23825){
return (new cljs.core.async.t_cljs$core$async23824(f__$1,ch__$1,meta23825));
});

}

return (new cljs.core.async.t_cljs$core$async23824(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async23832 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23832 = (function (f,ch,meta23833){
this.f = f;
this.ch = ch;
this.meta23833 = meta23833;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23832.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23834,meta23833__$1){
var self__ = this;
var _23834__$1 = this;
return (new cljs.core.async.t_cljs$core$async23832(self__.f,self__.ch,meta23833__$1));
});

cljs.core.async.t_cljs$core$async23832.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23834){
var self__ = this;
var _23834__$1 = this;
return self__.meta23833;
});

cljs.core.async.t_cljs$core$async23832.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23832.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async23832.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23832.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async23832.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23832.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async23832.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta23833], null);
});

cljs.core.async.t_cljs$core$async23832.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23832.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23832";

cljs.core.async.t_cljs$core$async23832.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async23832");
});

cljs.core.async.__GT_t_cljs$core$async23832 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async23832(f__$1,ch__$1,meta23833){
return (new cljs.core.async.t_cljs$core$async23832(f__$1,ch__$1,meta23833));
});

}

return (new cljs.core.async.t_cljs$core$async23832(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async23835 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23835 = (function (p,ch,meta23836){
this.p = p;
this.ch = ch;
this.meta23836 = meta23836;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async23835.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23837,meta23836__$1){
var self__ = this;
var _23837__$1 = this;
return (new cljs.core.async.t_cljs$core$async23835(self__.p,self__.ch,meta23836__$1));
});

cljs.core.async.t_cljs$core$async23835.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23837){
var self__ = this;
var _23837__$1 = this;
return self__.meta23836;
});

cljs.core.async.t_cljs$core$async23835.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23835.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async23835.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async23835.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23835.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async23835.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23835.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async23835.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta23836], null);
});

cljs.core.async.t_cljs$core$async23835.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23835.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23835";

cljs.core.async.t_cljs$core$async23835.cljs$lang$ctorPrWriter = (function (this__9479__auto__,writer__9480__auto__,opt__9481__auto__){
return cljs.core._write(writer__9480__auto__,"cljs.core.async/t_cljs$core$async23835");
});

cljs.core.async.__GT_t_cljs$core$async23835 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async23835(p__$1,ch__$1,meta23836){
return (new cljs.core.async.t_cljs$core$async23835(p__$1,ch__$1,meta23836));
});

}

return (new cljs.core.async.t_cljs$core$async23835(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__23839 = arguments.length;
switch (G__23839) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__22336__auto___23879 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___23879,out){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___23879,out){
return (function (state_23860){
var state_val_23861 = (state_23860[(1)]);
if((state_val_23861 === (7))){
var inst_23856 = (state_23860[(2)]);
var state_23860__$1 = state_23860;
var statearr_23862_23880 = state_23860__$1;
(statearr_23862_23880[(2)] = inst_23856);

(statearr_23862_23880[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23861 === (1))){
var state_23860__$1 = state_23860;
var statearr_23863_23881 = state_23860__$1;
(statearr_23863_23881[(2)] = null);

(statearr_23863_23881[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23861 === (4))){
var inst_23842 = (state_23860[(7)]);
var inst_23842__$1 = (state_23860[(2)]);
var inst_23843 = (inst_23842__$1 == null);
var state_23860__$1 = (function (){var statearr_23864 = state_23860;
(statearr_23864[(7)] = inst_23842__$1);

return statearr_23864;
})();
if(cljs.core.truth_(inst_23843)){
var statearr_23865_23882 = state_23860__$1;
(statearr_23865_23882[(1)] = (5));

} else {
var statearr_23866_23883 = state_23860__$1;
(statearr_23866_23883[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23861 === (6))){
var inst_23842 = (state_23860[(7)]);
var inst_23847 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_23842) : p.call(null,inst_23842));
var state_23860__$1 = state_23860;
if(cljs.core.truth_(inst_23847)){
var statearr_23867_23884 = state_23860__$1;
(statearr_23867_23884[(1)] = (8));

} else {
var statearr_23868_23885 = state_23860__$1;
(statearr_23868_23885[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23861 === (3))){
var inst_23858 = (state_23860[(2)]);
var state_23860__$1 = state_23860;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23860__$1,inst_23858);
} else {
if((state_val_23861 === (2))){
var state_23860__$1 = state_23860;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23860__$1,(4),ch);
} else {
if((state_val_23861 === (11))){
var inst_23850 = (state_23860[(2)]);
var state_23860__$1 = state_23860;
var statearr_23869_23886 = state_23860__$1;
(statearr_23869_23886[(2)] = inst_23850);

(statearr_23869_23886[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23861 === (9))){
var state_23860__$1 = state_23860;
var statearr_23870_23887 = state_23860__$1;
(statearr_23870_23887[(2)] = null);

(statearr_23870_23887[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23861 === (5))){
var inst_23845 = cljs.core.async.close_BANG_(out);
var state_23860__$1 = state_23860;
var statearr_23871_23888 = state_23860__$1;
(statearr_23871_23888[(2)] = inst_23845);

(statearr_23871_23888[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23861 === (10))){
var inst_23853 = (state_23860[(2)]);
var state_23860__$1 = (function (){var statearr_23872 = state_23860;
(statearr_23872[(8)] = inst_23853);

return statearr_23872;
})();
var statearr_23873_23889 = state_23860__$1;
(statearr_23873_23889[(2)] = null);

(statearr_23873_23889[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23861 === (8))){
var inst_23842 = (state_23860[(7)]);
var state_23860__$1 = state_23860;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23860__$1,(11),out,inst_23842);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___23879,out))
;
return ((function (switch__22234__auto__,c__22336__auto___23879,out){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_23874 = [null,null,null,null,null,null,null,null,null];
(statearr_23874[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_23874[(1)] = (1));

return statearr_23874;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_23860){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_23860);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e23875){if((e23875 instanceof Object)){
var ex__22238__auto__ = e23875;
var statearr_23876_23890 = state_23860;
(statearr_23876_23890[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23860);

return cljs.core.cst$kw$recur;
} else {
throw e23875;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__23891 = state_23860;
state_23860 = G__23891;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_23860){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_23860);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___23879,out))
})();
var state__22338__auto__ = (function (){var statearr_23877 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_23877[(6)] = c__22336__auto___23879);

return statearr_23877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___23879,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__23893 = arguments.length;
switch (G__23893) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__22336__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto__){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto__){
return (function (state_23956){
var state_val_23957 = (state_23956[(1)]);
if((state_val_23957 === (7))){
var inst_23952 = (state_23956[(2)]);
var state_23956__$1 = state_23956;
var statearr_23958_23996 = state_23956__$1;
(statearr_23958_23996[(2)] = inst_23952);

(statearr_23958_23996[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (20))){
var inst_23922 = (state_23956[(7)]);
var inst_23933 = (state_23956[(2)]);
var inst_23934 = cljs.core.next(inst_23922);
var inst_23908 = inst_23934;
var inst_23909 = null;
var inst_23910 = (0);
var inst_23911 = (0);
var state_23956__$1 = (function (){var statearr_23959 = state_23956;
(statearr_23959[(8)] = inst_23910);

(statearr_23959[(9)] = inst_23933);

(statearr_23959[(10)] = inst_23911);

(statearr_23959[(11)] = inst_23909);

(statearr_23959[(12)] = inst_23908);

return statearr_23959;
})();
var statearr_23960_23997 = state_23956__$1;
(statearr_23960_23997[(2)] = null);

(statearr_23960_23997[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (1))){
var state_23956__$1 = state_23956;
var statearr_23961_23998 = state_23956__$1;
(statearr_23961_23998[(2)] = null);

(statearr_23961_23998[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (4))){
var inst_23897 = (state_23956[(13)]);
var inst_23897__$1 = (state_23956[(2)]);
var inst_23898 = (inst_23897__$1 == null);
var state_23956__$1 = (function (){var statearr_23962 = state_23956;
(statearr_23962[(13)] = inst_23897__$1);

return statearr_23962;
})();
if(cljs.core.truth_(inst_23898)){
var statearr_23963_23999 = state_23956__$1;
(statearr_23963_23999[(1)] = (5));

} else {
var statearr_23964_24000 = state_23956__$1;
(statearr_23964_24000[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (15))){
var state_23956__$1 = state_23956;
var statearr_23968_24001 = state_23956__$1;
(statearr_23968_24001[(2)] = null);

(statearr_23968_24001[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (21))){
var state_23956__$1 = state_23956;
var statearr_23969_24002 = state_23956__$1;
(statearr_23969_24002[(2)] = null);

(statearr_23969_24002[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (13))){
var inst_23910 = (state_23956[(8)]);
var inst_23911 = (state_23956[(10)]);
var inst_23909 = (state_23956[(11)]);
var inst_23908 = (state_23956[(12)]);
var inst_23918 = (state_23956[(2)]);
var inst_23919 = (inst_23911 + (1));
var tmp23965 = inst_23910;
var tmp23966 = inst_23909;
var tmp23967 = inst_23908;
var inst_23908__$1 = tmp23967;
var inst_23909__$1 = tmp23966;
var inst_23910__$1 = tmp23965;
var inst_23911__$1 = inst_23919;
var state_23956__$1 = (function (){var statearr_23970 = state_23956;
(statearr_23970[(8)] = inst_23910__$1);

(statearr_23970[(10)] = inst_23911__$1);

(statearr_23970[(11)] = inst_23909__$1);

(statearr_23970[(12)] = inst_23908__$1);

(statearr_23970[(14)] = inst_23918);

return statearr_23970;
})();
var statearr_23971_24003 = state_23956__$1;
(statearr_23971_24003[(2)] = null);

(statearr_23971_24003[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (22))){
var state_23956__$1 = state_23956;
var statearr_23972_24004 = state_23956__$1;
(statearr_23972_24004[(2)] = null);

(statearr_23972_24004[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (6))){
var inst_23897 = (state_23956[(13)]);
var inst_23906 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_23897) : f.call(null,inst_23897));
var inst_23907 = cljs.core.seq(inst_23906);
var inst_23908 = inst_23907;
var inst_23909 = null;
var inst_23910 = (0);
var inst_23911 = (0);
var state_23956__$1 = (function (){var statearr_23973 = state_23956;
(statearr_23973[(8)] = inst_23910);

(statearr_23973[(10)] = inst_23911);

(statearr_23973[(11)] = inst_23909);

(statearr_23973[(12)] = inst_23908);

return statearr_23973;
})();
var statearr_23974_24005 = state_23956__$1;
(statearr_23974_24005[(2)] = null);

(statearr_23974_24005[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (17))){
var inst_23922 = (state_23956[(7)]);
var inst_23926 = cljs.core.chunk_first(inst_23922);
var inst_23927 = cljs.core.chunk_rest(inst_23922);
var inst_23928 = cljs.core.count(inst_23926);
var inst_23908 = inst_23927;
var inst_23909 = inst_23926;
var inst_23910 = inst_23928;
var inst_23911 = (0);
var state_23956__$1 = (function (){var statearr_23975 = state_23956;
(statearr_23975[(8)] = inst_23910);

(statearr_23975[(10)] = inst_23911);

(statearr_23975[(11)] = inst_23909);

(statearr_23975[(12)] = inst_23908);

return statearr_23975;
})();
var statearr_23976_24006 = state_23956__$1;
(statearr_23976_24006[(2)] = null);

(statearr_23976_24006[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (3))){
var inst_23954 = (state_23956[(2)]);
var state_23956__$1 = state_23956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23956__$1,inst_23954);
} else {
if((state_val_23957 === (12))){
var inst_23942 = (state_23956[(2)]);
var state_23956__$1 = state_23956;
var statearr_23977_24007 = state_23956__$1;
(statearr_23977_24007[(2)] = inst_23942);

(statearr_23977_24007[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (2))){
var state_23956__$1 = state_23956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23956__$1,(4),in$);
} else {
if((state_val_23957 === (23))){
var inst_23950 = (state_23956[(2)]);
var state_23956__$1 = state_23956;
var statearr_23978_24008 = state_23956__$1;
(statearr_23978_24008[(2)] = inst_23950);

(statearr_23978_24008[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (19))){
var inst_23937 = (state_23956[(2)]);
var state_23956__$1 = state_23956;
var statearr_23979_24009 = state_23956__$1;
(statearr_23979_24009[(2)] = inst_23937);

(statearr_23979_24009[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (11))){
var inst_23922 = (state_23956[(7)]);
var inst_23908 = (state_23956[(12)]);
var inst_23922__$1 = cljs.core.seq(inst_23908);
var state_23956__$1 = (function (){var statearr_23980 = state_23956;
(statearr_23980[(7)] = inst_23922__$1);

return statearr_23980;
})();
if(inst_23922__$1){
var statearr_23981_24010 = state_23956__$1;
(statearr_23981_24010[(1)] = (14));

} else {
var statearr_23982_24011 = state_23956__$1;
(statearr_23982_24011[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (9))){
var inst_23944 = (state_23956[(2)]);
var inst_23945 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_23956__$1 = (function (){var statearr_23983 = state_23956;
(statearr_23983[(15)] = inst_23944);

return statearr_23983;
})();
if(cljs.core.truth_(inst_23945)){
var statearr_23984_24012 = state_23956__$1;
(statearr_23984_24012[(1)] = (21));

} else {
var statearr_23985_24013 = state_23956__$1;
(statearr_23985_24013[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (5))){
var inst_23900 = cljs.core.async.close_BANG_(out);
var state_23956__$1 = state_23956;
var statearr_23986_24014 = state_23956__$1;
(statearr_23986_24014[(2)] = inst_23900);

(statearr_23986_24014[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (14))){
var inst_23922 = (state_23956[(7)]);
var inst_23924 = cljs.core.chunked_seq_QMARK_(inst_23922);
var state_23956__$1 = state_23956;
if(inst_23924){
var statearr_23987_24015 = state_23956__$1;
(statearr_23987_24015[(1)] = (17));

} else {
var statearr_23988_24016 = state_23956__$1;
(statearr_23988_24016[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (16))){
var inst_23940 = (state_23956[(2)]);
var state_23956__$1 = state_23956;
var statearr_23989_24017 = state_23956__$1;
(statearr_23989_24017[(2)] = inst_23940);

(statearr_23989_24017[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23957 === (10))){
var inst_23911 = (state_23956[(10)]);
var inst_23909 = (state_23956[(11)]);
var inst_23916 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_23909,inst_23911);
var state_23956__$1 = state_23956;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23956__$1,(13),out,inst_23916);
} else {
if((state_val_23957 === (18))){
var inst_23922 = (state_23956[(7)]);
var inst_23931 = cljs.core.first(inst_23922);
var state_23956__$1 = state_23956;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23956__$1,(20),out,inst_23931);
} else {
if((state_val_23957 === (8))){
var inst_23910 = (state_23956[(8)]);
var inst_23911 = (state_23956[(10)]);
var inst_23913 = (inst_23911 < inst_23910);
var inst_23914 = inst_23913;
var state_23956__$1 = state_23956;
if(cljs.core.truth_(inst_23914)){
var statearr_23990_24018 = state_23956__$1;
(statearr_23990_24018[(1)] = (10));

} else {
var statearr_23991_24019 = state_23956__$1;
(statearr_23991_24019[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto__))
;
return ((function (switch__22234__auto__,c__22336__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__22235__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__22235__auto____0 = (function (){
var statearr_23992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23992[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__22235__auto__);

(statearr_23992[(1)] = (1));

return statearr_23992;
});
var cljs$core$async$mapcat_STAR__$_state_machine__22235__auto____1 = (function (state_23956){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_23956);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e23993){if((e23993 instanceof Object)){
var ex__22238__auto__ = e23993;
var statearr_23994_24020 = state_23956;
(statearr_23994_24020[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23956);

return cljs.core.cst$kw$recur;
} else {
throw e23993;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__24021 = state_23956;
state_23956 = G__24021;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__22235__auto__ = function(state_23956){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__22235__auto____1.call(this,state_23956);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__22235__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__22235__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto__))
})();
var state__22338__auto__ = (function (){var statearr_23995 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_23995[(6)] = c__22336__auto__);

return statearr_23995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto__))
);

return c__22336__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__24023 = arguments.length;
switch (G__24023) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__24026 = arguments.length;
switch (G__24026) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__24029 = arguments.length;
switch (G__24029) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__22336__auto___24076 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___24076,out){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___24076,out){
return (function (state_24053){
var state_val_24054 = (state_24053[(1)]);
if((state_val_24054 === (7))){
var inst_24048 = (state_24053[(2)]);
var state_24053__$1 = state_24053;
var statearr_24055_24077 = state_24053__$1;
(statearr_24055_24077[(2)] = inst_24048);

(statearr_24055_24077[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24054 === (1))){
var inst_24030 = null;
var state_24053__$1 = (function (){var statearr_24056 = state_24053;
(statearr_24056[(7)] = inst_24030);

return statearr_24056;
})();
var statearr_24057_24078 = state_24053__$1;
(statearr_24057_24078[(2)] = null);

(statearr_24057_24078[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24054 === (4))){
var inst_24033 = (state_24053[(8)]);
var inst_24033__$1 = (state_24053[(2)]);
var inst_24034 = (inst_24033__$1 == null);
var inst_24035 = cljs.core.not(inst_24034);
var state_24053__$1 = (function (){var statearr_24058 = state_24053;
(statearr_24058[(8)] = inst_24033__$1);

return statearr_24058;
})();
if(inst_24035){
var statearr_24059_24079 = state_24053__$1;
(statearr_24059_24079[(1)] = (5));

} else {
var statearr_24060_24080 = state_24053__$1;
(statearr_24060_24080[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24054 === (6))){
var state_24053__$1 = state_24053;
var statearr_24061_24081 = state_24053__$1;
(statearr_24061_24081[(2)] = null);

(statearr_24061_24081[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24054 === (3))){
var inst_24050 = (state_24053[(2)]);
var inst_24051 = cljs.core.async.close_BANG_(out);
var state_24053__$1 = (function (){var statearr_24062 = state_24053;
(statearr_24062[(9)] = inst_24050);

return statearr_24062;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_24053__$1,inst_24051);
} else {
if((state_val_24054 === (2))){
var state_24053__$1 = state_24053;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24053__$1,(4),ch);
} else {
if((state_val_24054 === (11))){
var inst_24033 = (state_24053[(8)]);
var inst_24042 = (state_24053[(2)]);
var inst_24030 = inst_24033;
var state_24053__$1 = (function (){var statearr_24063 = state_24053;
(statearr_24063[(7)] = inst_24030);

(statearr_24063[(10)] = inst_24042);

return statearr_24063;
})();
var statearr_24064_24082 = state_24053__$1;
(statearr_24064_24082[(2)] = null);

(statearr_24064_24082[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24054 === (9))){
var inst_24033 = (state_24053[(8)]);
var state_24053__$1 = state_24053;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24053__$1,(11),out,inst_24033);
} else {
if((state_val_24054 === (5))){
var inst_24030 = (state_24053[(7)]);
var inst_24033 = (state_24053[(8)]);
var inst_24037 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24033,inst_24030);
var state_24053__$1 = state_24053;
if(inst_24037){
var statearr_24066_24083 = state_24053__$1;
(statearr_24066_24083[(1)] = (8));

} else {
var statearr_24067_24084 = state_24053__$1;
(statearr_24067_24084[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24054 === (10))){
var inst_24045 = (state_24053[(2)]);
var state_24053__$1 = state_24053;
var statearr_24068_24085 = state_24053__$1;
(statearr_24068_24085[(2)] = inst_24045);

(statearr_24068_24085[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24054 === (8))){
var inst_24030 = (state_24053[(7)]);
var tmp24065 = inst_24030;
var inst_24030__$1 = tmp24065;
var state_24053__$1 = (function (){var statearr_24069 = state_24053;
(statearr_24069[(7)] = inst_24030__$1);

return statearr_24069;
})();
var statearr_24070_24086 = state_24053__$1;
(statearr_24070_24086[(2)] = null);

(statearr_24070_24086[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___24076,out))
;
return ((function (switch__22234__auto__,c__22336__auto___24076,out){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_24071 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24071[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_24071[(1)] = (1));

return statearr_24071;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_24053){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_24053);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e24072){if((e24072 instanceof Object)){
var ex__22238__auto__ = e24072;
var statearr_24073_24087 = state_24053;
(statearr_24073_24087[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_24053);

return cljs.core.cst$kw$recur;
} else {
throw e24072;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__24088 = state_24053;
state_24053 = G__24088;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_24053){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_24053);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___24076,out))
})();
var state__22338__auto__ = (function (){var statearr_24074 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_24074[(6)] = c__22336__auto___24076);

return statearr_24074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___24076,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__24090 = arguments.length;
switch (G__24090) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__22336__auto___24156 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___24156,out){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___24156,out){
return (function (state_24128){
var state_val_24129 = (state_24128[(1)]);
if((state_val_24129 === (7))){
var inst_24124 = (state_24128[(2)]);
var state_24128__$1 = state_24128;
var statearr_24130_24157 = state_24128__$1;
(statearr_24130_24157[(2)] = inst_24124);

(statearr_24130_24157[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24129 === (1))){
var inst_24091 = (new Array(n));
var inst_24092 = inst_24091;
var inst_24093 = (0);
var state_24128__$1 = (function (){var statearr_24131 = state_24128;
(statearr_24131[(7)] = inst_24093);

(statearr_24131[(8)] = inst_24092);

return statearr_24131;
})();
var statearr_24132_24158 = state_24128__$1;
(statearr_24132_24158[(2)] = null);

(statearr_24132_24158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24129 === (4))){
var inst_24096 = (state_24128[(9)]);
var inst_24096__$1 = (state_24128[(2)]);
var inst_24097 = (inst_24096__$1 == null);
var inst_24098 = cljs.core.not(inst_24097);
var state_24128__$1 = (function (){var statearr_24133 = state_24128;
(statearr_24133[(9)] = inst_24096__$1);

return statearr_24133;
})();
if(inst_24098){
var statearr_24134_24159 = state_24128__$1;
(statearr_24134_24159[(1)] = (5));

} else {
var statearr_24135_24160 = state_24128__$1;
(statearr_24135_24160[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24129 === (15))){
var inst_24118 = (state_24128[(2)]);
var state_24128__$1 = state_24128;
var statearr_24136_24161 = state_24128__$1;
(statearr_24136_24161[(2)] = inst_24118);

(statearr_24136_24161[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24129 === (13))){
var state_24128__$1 = state_24128;
var statearr_24137_24162 = state_24128__$1;
(statearr_24137_24162[(2)] = null);

(statearr_24137_24162[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24129 === (6))){
var inst_24093 = (state_24128[(7)]);
var inst_24114 = (inst_24093 > (0));
var state_24128__$1 = state_24128;
if(cljs.core.truth_(inst_24114)){
var statearr_24138_24163 = state_24128__$1;
(statearr_24138_24163[(1)] = (12));

} else {
var statearr_24139_24164 = state_24128__$1;
(statearr_24139_24164[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24129 === (3))){
var inst_24126 = (state_24128[(2)]);
var state_24128__$1 = state_24128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24128__$1,inst_24126);
} else {
if((state_val_24129 === (12))){
var inst_24092 = (state_24128[(8)]);
var inst_24116 = cljs.core.vec(inst_24092);
var state_24128__$1 = state_24128;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24128__$1,(15),out,inst_24116);
} else {
if((state_val_24129 === (2))){
var state_24128__$1 = state_24128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24128__$1,(4),ch);
} else {
if((state_val_24129 === (11))){
var inst_24108 = (state_24128[(2)]);
var inst_24109 = (new Array(n));
var inst_24092 = inst_24109;
var inst_24093 = (0);
var state_24128__$1 = (function (){var statearr_24140 = state_24128;
(statearr_24140[(7)] = inst_24093);

(statearr_24140[(10)] = inst_24108);

(statearr_24140[(8)] = inst_24092);

return statearr_24140;
})();
var statearr_24141_24165 = state_24128__$1;
(statearr_24141_24165[(2)] = null);

(statearr_24141_24165[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24129 === (9))){
var inst_24092 = (state_24128[(8)]);
var inst_24106 = cljs.core.vec(inst_24092);
var state_24128__$1 = state_24128;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24128__$1,(11),out,inst_24106);
} else {
if((state_val_24129 === (5))){
var inst_24093 = (state_24128[(7)]);
var inst_24101 = (state_24128[(11)]);
var inst_24096 = (state_24128[(9)]);
var inst_24092 = (state_24128[(8)]);
var inst_24100 = (inst_24092[inst_24093] = inst_24096);
var inst_24101__$1 = (inst_24093 + (1));
var inst_24102 = (inst_24101__$1 < n);
var state_24128__$1 = (function (){var statearr_24142 = state_24128;
(statearr_24142[(11)] = inst_24101__$1);

(statearr_24142[(12)] = inst_24100);

return statearr_24142;
})();
if(cljs.core.truth_(inst_24102)){
var statearr_24143_24166 = state_24128__$1;
(statearr_24143_24166[(1)] = (8));

} else {
var statearr_24144_24167 = state_24128__$1;
(statearr_24144_24167[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24129 === (14))){
var inst_24121 = (state_24128[(2)]);
var inst_24122 = cljs.core.async.close_BANG_(out);
var state_24128__$1 = (function (){var statearr_24146 = state_24128;
(statearr_24146[(13)] = inst_24121);

return statearr_24146;
})();
var statearr_24147_24168 = state_24128__$1;
(statearr_24147_24168[(2)] = inst_24122);

(statearr_24147_24168[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24129 === (10))){
var inst_24112 = (state_24128[(2)]);
var state_24128__$1 = state_24128;
var statearr_24148_24169 = state_24128__$1;
(statearr_24148_24169[(2)] = inst_24112);

(statearr_24148_24169[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24129 === (8))){
var inst_24101 = (state_24128[(11)]);
var inst_24092 = (state_24128[(8)]);
var tmp24145 = inst_24092;
var inst_24092__$1 = tmp24145;
var inst_24093 = inst_24101;
var state_24128__$1 = (function (){var statearr_24149 = state_24128;
(statearr_24149[(7)] = inst_24093);

(statearr_24149[(8)] = inst_24092__$1);

return statearr_24149;
})();
var statearr_24150_24170 = state_24128__$1;
(statearr_24150_24170[(2)] = null);

(statearr_24150_24170[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___24156,out))
;
return ((function (switch__22234__auto__,c__22336__auto___24156,out){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_24151 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24151[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_24151[(1)] = (1));

return statearr_24151;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_24128){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_24128);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e24152){if((e24152 instanceof Object)){
var ex__22238__auto__ = e24152;
var statearr_24153_24171 = state_24128;
(statearr_24153_24171[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_24128);

return cljs.core.cst$kw$recur;
} else {
throw e24152;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__24172 = state_24128;
state_24128 = G__24172;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_24128){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_24128);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___24156,out))
})();
var state__22338__auto__ = (function (){var statearr_24154 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_24154[(6)] = c__22336__auto___24156);

return statearr_24154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___24156,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__24174 = arguments.length;
switch (G__24174) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__22336__auto___24244 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__22336__auto___24244,out){
return (function (){
var f__22337__auto__ = (function (){var switch__22234__auto__ = ((function (c__22336__auto___24244,out){
return (function (state_24216){
var state_val_24217 = (state_24216[(1)]);
if((state_val_24217 === (7))){
var inst_24212 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24218_24245 = state_24216__$1;
(statearr_24218_24245[(2)] = inst_24212);

(statearr_24218_24245[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24217 === (1))){
var inst_24175 = [];
var inst_24176 = inst_24175;
var inst_24177 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_24216__$1 = (function (){var statearr_24219 = state_24216;
(statearr_24219[(7)] = inst_24177);

(statearr_24219[(8)] = inst_24176);

return statearr_24219;
})();
var statearr_24220_24246 = state_24216__$1;
(statearr_24220_24246[(2)] = null);

(statearr_24220_24246[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24217 === (4))){
var inst_24180 = (state_24216[(9)]);
var inst_24180__$1 = (state_24216[(2)]);
var inst_24181 = (inst_24180__$1 == null);
var inst_24182 = cljs.core.not(inst_24181);
var state_24216__$1 = (function (){var statearr_24221 = state_24216;
(statearr_24221[(9)] = inst_24180__$1);

return statearr_24221;
})();
if(inst_24182){
var statearr_24222_24247 = state_24216__$1;
(statearr_24222_24247[(1)] = (5));

} else {
var statearr_24223_24248 = state_24216__$1;
(statearr_24223_24248[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24217 === (15))){
var inst_24206 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24224_24249 = state_24216__$1;
(statearr_24224_24249[(2)] = inst_24206);

(statearr_24224_24249[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24217 === (13))){
var state_24216__$1 = state_24216;
var statearr_24225_24250 = state_24216__$1;
(statearr_24225_24250[(2)] = null);

(statearr_24225_24250[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24217 === (6))){
var inst_24176 = (state_24216[(8)]);
var inst_24201 = inst_24176.length;
var inst_24202 = (inst_24201 > (0));
var state_24216__$1 = state_24216;
if(cljs.core.truth_(inst_24202)){
var statearr_24226_24251 = state_24216__$1;
(statearr_24226_24251[(1)] = (12));

} else {
var statearr_24227_24252 = state_24216__$1;
(statearr_24227_24252[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24217 === (3))){
var inst_24214 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24216__$1,inst_24214);
} else {
if((state_val_24217 === (12))){
var inst_24176 = (state_24216[(8)]);
var inst_24204 = cljs.core.vec(inst_24176);
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24216__$1,(15),out,inst_24204);
} else {
if((state_val_24217 === (2))){
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24216__$1,(4),ch);
} else {
if((state_val_24217 === (11))){
var inst_24184 = (state_24216[(10)]);
var inst_24180 = (state_24216[(9)]);
var inst_24194 = (state_24216[(2)]);
var inst_24195 = [];
var inst_24196 = inst_24195.push(inst_24180);
var inst_24176 = inst_24195;
var inst_24177 = inst_24184;
var state_24216__$1 = (function (){var statearr_24228 = state_24216;
(statearr_24228[(7)] = inst_24177);

(statearr_24228[(8)] = inst_24176);

(statearr_24228[(11)] = inst_24194);

(statearr_24228[(12)] = inst_24196);

return statearr_24228;
})();
var statearr_24229_24253 = state_24216__$1;
(statearr_24229_24253[(2)] = null);

(statearr_24229_24253[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24217 === (9))){
var inst_24176 = (state_24216[(8)]);
var inst_24192 = cljs.core.vec(inst_24176);
var state_24216__$1 = state_24216;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24216__$1,(11),out,inst_24192);
} else {
if((state_val_24217 === (5))){
var inst_24177 = (state_24216[(7)]);
var inst_24184 = (state_24216[(10)]);
var inst_24180 = (state_24216[(9)]);
var inst_24184__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_24180) : f.call(null,inst_24180));
var inst_24185 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24184__$1,inst_24177);
var inst_24186 = cljs.core.keyword_identical_QMARK_(inst_24177,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_24187 = (inst_24185) || (inst_24186);
var state_24216__$1 = (function (){var statearr_24230 = state_24216;
(statearr_24230[(10)] = inst_24184__$1);

return statearr_24230;
})();
if(cljs.core.truth_(inst_24187)){
var statearr_24231_24254 = state_24216__$1;
(statearr_24231_24254[(1)] = (8));

} else {
var statearr_24232_24255 = state_24216__$1;
(statearr_24232_24255[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24217 === (14))){
var inst_24209 = (state_24216[(2)]);
var inst_24210 = cljs.core.async.close_BANG_(out);
var state_24216__$1 = (function (){var statearr_24234 = state_24216;
(statearr_24234[(13)] = inst_24209);

return statearr_24234;
})();
var statearr_24235_24256 = state_24216__$1;
(statearr_24235_24256[(2)] = inst_24210);

(statearr_24235_24256[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24217 === (10))){
var inst_24199 = (state_24216[(2)]);
var state_24216__$1 = state_24216;
var statearr_24236_24257 = state_24216__$1;
(statearr_24236_24257[(2)] = inst_24199);

(statearr_24236_24257[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24217 === (8))){
var inst_24176 = (state_24216[(8)]);
var inst_24184 = (state_24216[(10)]);
var inst_24180 = (state_24216[(9)]);
var inst_24189 = inst_24176.push(inst_24180);
var tmp24233 = inst_24176;
var inst_24176__$1 = tmp24233;
var inst_24177 = inst_24184;
var state_24216__$1 = (function (){var statearr_24237 = state_24216;
(statearr_24237[(7)] = inst_24177);

(statearr_24237[(8)] = inst_24176__$1);

(statearr_24237[(14)] = inst_24189);

return statearr_24237;
})();
var statearr_24238_24258 = state_24216__$1;
(statearr_24238_24258[(2)] = null);

(statearr_24238_24258[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__22336__auto___24244,out))
;
return ((function (switch__22234__auto__,c__22336__auto___24244,out){
return (function() {
var cljs$core$async$state_machine__22235__auto__ = null;
var cljs$core$async$state_machine__22235__auto____0 = (function (){
var statearr_24239 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24239[(0)] = cljs$core$async$state_machine__22235__auto__);

(statearr_24239[(1)] = (1));

return statearr_24239;
});
var cljs$core$async$state_machine__22235__auto____1 = (function (state_24216){
while(true){
var ret_value__22236__auto__ = (function (){try{while(true){
var result__22237__auto__ = switch__22234__auto__(state_24216);
if(cljs.core.keyword_identical_QMARK_(result__22237__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__22237__auto__;
}
break;
}
}catch (e24240){if((e24240 instanceof Object)){
var ex__22238__auto__ = e24240;
var statearr_24241_24259 = state_24216;
(statearr_24241_24259[(5)] = ex__22238__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_24216);

return cljs.core.cst$kw$recur;
} else {
throw e24240;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__22236__auto__,cljs.core.cst$kw$recur)){
var G__24260 = state_24216;
state_24216 = G__24260;
continue;
} else {
return ret_value__22236__auto__;
}
break;
}
});
cljs$core$async$state_machine__22235__auto__ = function(state_24216){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22235__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22235__auto____1.call(this,state_24216);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22235__auto____0;
cljs$core$async$state_machine__22235__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22235__auto____1;
return cljs$core$async$state_machine__22235__auto__;
})()
;})(switch__22234__auto__,c__22336__auto___24244,out))
})();
var state__22338__auto__ = (function (){var statearr_24242 = (f__22337__auto__.cljs$core$IFn$_invoke$arity$0 ? f__22337__auto__.cljs$core$IFn$_invoke$arity$0() : f__22337__auto__.call(null));
(statearr_24242[(6)] = c__22336__auto___24244);

return statearr_24242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__22338__auto__);
});})(c__22336__auto___24244,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

