// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.XhrIo');
goog.require('goog.net.Jsonp');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5457__auto__ = (function (){var fexpr__18823 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__18823.cljs$core$IFn$_invoke$arity$1 ? fexpr__18823.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__18823.call(null,channel));
})();
if(cljs.core.truth_(temp__5457__auto__)){
var req = temp__5457__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__18824){
var vec__18825 = p__18824;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18825,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18825,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__18828 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__18828)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__18828)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__18828)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__18828)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__18828)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__18828)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18828)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__18829){
var map__18830 = p__18829;
var map__18830__$1 = ((((!((map__18830 == null)))?((((map__18830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18830.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18830):map__18830);
var request = map__18830__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18830__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18830__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18830__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__8806__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__18832 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__18832,default_headers);

cljs_http.core.apply_response_type_BANG_(G__18832,response_type);

G__18832.setTimeoutInterval(timeout);

G__18832.setWithCredentials(send_credentials);

return G__18832;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__18833){
var map__18834 = p__18833;
var map__18834__$1 = ((((!((map__18834 == null)))?((((map__18834.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18834.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18834):map__18834);
var request = map__18834__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18834__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18834__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18834__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18834__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18834__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18834__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__8806__auto__ = request_method;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__18834,map__18834__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__18836 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__18836) : cljs_http.core.error_kw.call(null,G__18836));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__18834,map__18834__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_18859 = ((function (channel,request_url,method,headers__$1,xhr,map__18834,map__18834__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__18834,map__18834__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__18837_18860 = xhr;
G__18837_18860.setProgressEventsEnabled(true);

G__18837_18860.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_18859,cljs.core.cst$kw$upload));

G__18837_18860.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_18859,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__16896__auto___18861 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___18861,channel,request_url,method,headers__$1,xhr,map__18834,map__18834__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___18861,channel,request_url,method,headers__$1,xhr,map__18834,map__18834__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_18848){
var state_val_18849 = (state_18848[(1)]);
if((state_val_18849 === (1))){
var state_18848__$1 = state_18848;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18848__$1,(2),cancel);
} else {
if((state_val_18849 === (2))){
var inst_18839 = (state_18848[(2)]);
var inst_18840 = xhr.isComplete();
var inst_18841 = cljs.core.not(inst_18840);
var state_18848__$1 = (function (){var statearr_18850 = state_18848;
(statearr_18850[(7)] = inst_18839);

return statearr_18850;
})();
if(inst_18841){
var statearr_18851_18862 = state_18848__$1;
(statearr_18851_18862[(1)] = (3));

} else {
var statearr_18852_18863 = state_18848__$1;
(statearr_18852_18863[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18849 === (3))){
var inst_18843 = xhr.abort();
var state_18848__$1 = state_18848;
var statearr_18853_18864 = state_18848__$1;
(statearr_18853_18864[(2)] = inst_18843);

(statearr_18853_18864[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18849 === (4))){
var state_18848__$1 = state_18848;
var statearr_18854_18865 = state_18848__$1;
(statearr_18854_18865[(2)] = null);

(statearr_18854_18865[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18849 === (5))){
var inst_18846 = (state_18848[(2)]);
var state_18848__$1 = state_18848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18848__$1,inst_18846);
} else {
return null;
}
}
}
}
}
});})(c__16896__auto___18861,channel,request_url,method,headers__$1,xhr,map__18834,map__18834__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__16794__auto__,c__16896__auto___18861,channel,request_url,method,headers__$1,xhr,map__18834,map__18834__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__16795__auto__ = null;
var cljs_http$core$xhr_$_state_machine__16795__auto____0 = (function (){
var statearr_18855 = [null,null,null,null,null,null,null,null];
(statearr_18855[(0)] = cljs_http$core$xhr_$_state_machine__16795__auto__);

(statearr_18855[(1)] = (1));

return statearr_18855;
});
var cljs_http$core$xhr_$_state_machine__16795__auto____1 = (function (state_18848){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18848);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18856){if((e18856 instanceof Object)){
var ex__16798__auto__ = e18856;
var statearr_18857_18866 = state_18848;
(statearr_18857_18866[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18848);

return cljs.core.cst$kw$recur;
} else {
throw e18856;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18867 = state_18848;
state_18848 = G__18867;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__16795__auto__ = function(state_18848){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__16795__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__16795__auto____1.call(this,state_18848);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$xhr_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__16795__auto____0;
cljs_http$core$xhr_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__16795__auto____1;
return cljs_http$core$xhr_$_state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___18861,channel,request_url,method,headers__$1,xhr,map__18834,map__18834__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__16898__auto__ = (function (){var statearr_18858 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18858[(6)] = c__16896__auto___18861);

return statearr_18858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___18861,channel,request_url,method,headers__$1,xhr,map__18834,map__18834__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__18868){
var map__18869 = p__18868;
var map__18869__$1 = ((((!((map__18869 == null)))?((((map__18869.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18869.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18869):map__18869);
var request = map__18869__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18869__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18869__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18869__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18869__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_18882 = jsonp.send(null,((function (channel,jsonp,map__18869,map__18869__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__18869,map__18869__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__18869,map__18869__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__18869,map__18869__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_18882], null));

if(cljs.core.truth_(cancel)){
var c__16896__auto___18883 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___18883,req_18882,channel,jsonp,map__18869,map__18869__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___18883,req_18882,channel,jsonp,map__18869,map__18869__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_18875){
var state_val_18876 = (state_18875[(1)]);
if((state_val_18876 === (1))){
var state_18875__$1 = state_18875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18875__$1,(2),cancel);
} else {
if((state_val_18876 === (2))){
var inst_18872 = (state_18875[(2)]);
var inst_18873 = jsonp.cancel(req_18882);
var state_18875__$1 = (function (){var statearr_18877 = state_18875;
(statearr_18877[(7)] = inst_18872);

return statearr_18877;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18875__$1,inst_18873);
} else {
return null;
}
}
});})(c__16896__auto___18883,req_18882,channel,jsonp,map__18869,map__18869__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__16794__auto__,c__16896__auto___18883,req_18882,channel,jsonp,map__18869,map__18869__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__16795__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__16795__auto____0 = (function (){
var statearr_18878 = [null,null,null,null,null,null,null,null];
(statearr_18878[(0)] = cljs_http$core$jsonp_$_state_machine__16795__auto__);

(statearr_18878[(1)] = (1));

return statearr_18878;
});
var cljs_http$core$jsonp_$_state_machine__16795__auto____1 = (function (state_18875){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18875);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18879){if((e18879 instanceof Object)){
var ex__16798__auto__ = e18879;
var statearr_18880_18884 = state_18875;
(statearr_18880_18884[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18875);

return cljs.core.cst$kw$recur;
} else {
throw e18879;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18885 = state_18875;
state_18875 = G__18885;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__16795__auto__ = function(state_18875){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__16795__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__16795__auto____1.call(this,state_18875);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$jsonp_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__16795__auto____0;
cljs_http$core$jsonp_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__16795__auto____1;
return cljs_http$core$jsonp_$_state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___18883,req_18882,channel,jsonp,map__18869,map__18869__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__16898__auto__ = (function (){var statearr_18881 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18881[(6)] = c__16896__auto___18883);

return statearr_18881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___18883,req_18882,channel,jsonp,map__18869,map__18869__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__18886){
var map__18887 = p__18886;
var map__18887__$1 = ((((!((map__18887 == null)))?((((map__18887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18887.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18887):map__18887);
var request = map__18887__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18887__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
