// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__8794__auto__ = v;
if(cljs.core.truth_(and__8794__auto__)){
return (v > (0));
} else {
return and__8794__auto__;
}
})())){
return v;
} else {
return null;
}
});
cljs_http.client.acc_param = (function cljs_http$client$acc_param(o,v){
if(cljs.core.coll_QMARK_(o)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(o,v);
} else {
if(!((o == null))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o,v], null);
} else {
return v;

}
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__18892_SHARP_,p2__18891_SHARP_){
var vec__18893 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__18891_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18893,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18893,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__18892_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),cljs_http.client.acc_param,no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_(url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.cst$kw$server_DASH_name,uri.getDomain(),cljs.core.cst$kw$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.cst$kw$uri,uri.getPath(),cljs.core.cst$kw$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),cljs.core.cst$kw$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode(cljs.core.name(k))),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode([cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18896_SHARP_){
return cljs_http.client.encode_val(k,p1__18896_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__18897){
var vec__18898 = p__18897;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18898,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18898,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__18901_SHARP_){
return ["\\",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__18901_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__8794__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$head,request_method);
if(and__8794__auto__){
var and__8794__auto____$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((204),cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response));
if(and__8794__auto____$1){
return cljs.core.re_find(cljs.core.re_pattern(["(?i)",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__8794__auto____$1;
}
} else {
return and__8794__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__5455__auto__ = cljs.core.cst$kw$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var params = temp__5455__auto__;
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request)], 0));
var G__18902 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$edn_DASH_params),cljs.core.cst$kw$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([params], 0))),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18902) : client.call(null,G__18902));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__18903_SHARP_){
return cljs_http.client.decode_body(p1__18903_SHARP_,cljs.reader.read_string,"application/edn",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__10092__auto__ = [];
var len__10085__auto___18911 = arguments.length;
var i__10086__auto___18912 = (0);
while(true){
if((i__10086__auto___18912 < len__10085__auto___18911)){
args__10092__auto__.push((arguments[i__10086__auto___18912]));

var G__18913 = (i__10086__auto___18912 + (1));
i__10086__auto___18912 = G__18913;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__18906){
var vec__18907 = p__18906;
var default_headers = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18907,(0),null);
return ((function (vec__18907,default_headers){
return (function (request){
var temp__5455__auto__ = (function (){var or__8806__auto__ = cljs.core.cst$kw$default_DASH_headers.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var default_headers__$1 = temp__5455__auto__;
var G__18910 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(request,cljs.core.cst$kw$default_DASH_headers,default_headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18910) : client.call(null,G__18910));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__18907,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq18904){
var G__18905 = cljs.core.first(seq18904);
var seq18904__$1 = cljs.core.next(seq18904);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__18905,seq18904__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__10092__auto__ = [];
var len__10085__auto___18921 = arguments.length;
var i__10086__auto___18922 = (0);
while(true){
if((i__10086__auto___18922 < len__10085__auto___18921)){
args__10092__auto__.push((arguments[i__10086__auto___18922]));

var G__18923 = (i__10086__auto___18922 + (1));
i__10086__auto___18922 = G__18923;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__18916){
var vec__18917 = p__18916;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18917,(0),null);
return ((function (vec__18917,accept){
return (function (request){
var temp__5455__auto__ = (function (){var or__8806__auto__ = cljs.core.cst$kw$accept.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var accept__$1 = temp__5455__auto__;
var G__18920 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18920) : client.call(null,G__18920));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__18917,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq18914){
var G__18915 = cljs.core.first(seq18914);
var seq18914__$1 = cljs.core.next(seq18914);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__18915,seq18914__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__10092__auto__ = [];
var len__10085__auto___18931 = arguments.length;
var i__10086__auto___18932 = (0);
while(true){
if((i__10086__auto___18932 < len__10085__auto___18931)){
args__10092__auto__.push((arguments[i__10086__auto___18932]));

var G__18933 = (i__10086__auto___18932 + (1));
i__10086__auto___18932 = G__18933;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__18926){
var vec__18927 = p__18926;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18927,(0),null);
return ((function (vec__18927,content_type){
return (function (request){
var temp__5455__auto__ = (function (){var or__8806__auto__ = cljs.core.cst$kw$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var content_type__$1 = temp__5455__auto__;
var G__18930 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18930) : client.call(null,G__18930));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__18927,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq18924){
var G__18925 = cljs.core.first(seq18924);
var seq18924__$1 = cljs.core.next(seq18924);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__18925,seq18924__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$encoding,cljs.core.cst$kw$json,cljs.core.cst$kw$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$decoding,cljs.core.cst$kw$json,cljs.core.cst$kw$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__5455__auto__ = cljs.core.cst$kw$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var params = temp__5455__auto__;
var map__18934 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs_http.client.default_transit_opts,cljs.core.cst$kw$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__18934__$1 = ((((!((map__18934 == null)))?((((map__18934.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18934.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18934):map__18934);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18934__$1,cljs.core.cst$kw$encoding);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18934__$1,cljs.core.cst$kw$encoding_DASH_opts);
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request)], 0));
var G__18936 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$transit_DASH_params),cljs.core.cst$kw$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18936) : client.call(null,G__18936));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__18939 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs_http.client.default_transit_opts,cljs.core.cst$kw$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__18939__$1 = ((((!((map__18939 == null)))?((((map__18939.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18939.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18939):map__18939);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18939__$1,cljs.core.cst$kw$decoding);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18939__$1,cljs.core.cst$kw$decoding_DASH_opts);
var transit_decode = ((function (map__18939,map__18939__$1,decoding,decoding_opts){
return (function (p1__18937_SHARP_){
return cljs_http.util.transit_decode(p1__18937_SHARP_,decoding,decoding_opts);
});})(map__18939,map__18939__$1,decoding,decoding_opts))
;
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(((function (map__18939,map__18939__$1,decoding,decoding_opts,transit_decode){
return (function (p1__18938_SHARP_){
return cljs_http.client.decode_body(p1__18938_SHARP_,transit_decode,"application/transit+json",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
});})(map__18939,map__18939__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__5455__auto__ = cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var params = temp__5455__auto__;
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request)], 0));
var G__18941 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$json_DASH_params),cljs.core.cst$kw$body,cljs_http.util.json_encode(params)),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18941) : client.call(null,G__18941));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__18942_SHARP_){
return cljs_http.client.decode_body(p1__18942_SHARP_,cljs_http.util.json_decode,"application/json",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__18943){
var map__18944 = p__18943;
var map__18944__$1 = ((((!((map__18944 == null)))?((((map__18944.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18944.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18944):map__18944);
var req = map__18944__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18944__$1,cljs.core.cst$kw$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__18946 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$query_DASH_params),cljs.core.cst$kw$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18946) : client.call(null,G__18946));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__18947){
var map__18948 = p__18947;
var map__18948__$1 = ((((!((map__18948 == null)))?((((map__18948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18948.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18948):map__18948);
var request = map__18948__$1;
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18948__$1,cljs.core.cst$kw$form_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18948__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18948__$1,cljs.core.cst$kw$headers);
if(cljs.core.truth_((function (){var and__8794__auto__ = form_params;
if(cljs.core.truth_(and__8794__auto__)){
var fexpr__18950 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$patch,null,cljs.core.cst$kw$delete,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$put,null], null), null);
return (fexpr__18950.cljs$core$IFn$_invoke$arity$1 ? fexpr__18950.cljs$core$IFn$_invoke$arity$1(request_method) : fexpr__18950.call(null,request_method));
} else {
return and__8794__auto__;
}
})())){
var headers__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers], 0));
var G__18951 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$form_DASH_params),cljs.core.cst$kw$body,cljs_http.client.generate_query_string(form_params)),cljs.core.cst$kw$headers,headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18951) : client.call(null,G__18951));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__18952_18962 = cljs.core.seq(params);
var chunk__18953_18963 = null;
var count__18954_18964 = (0);
var i__18955_18965 = (0);
while(true){
if((i__18955_18965 < count__18954_18964)){
var vec__18956_18966 = chunk__18953_18963.cljs$core$IIndexed$_nth$arity$2(null,i__18955_18965);
var k_18967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18956_18966,(0),null);
var v_18968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18956_18966,(1),null);
if(cljs.core.coll_QMARK_(v_18968)){
form_data.append(cljs.core.name(k_18967),cljs.core.first(v_18968),cljs.core.second(v_18968));
} else {
form_data.append(cljs.core.name(k_18967),v_18968);
}

var G__18969 = seq__18952_18962;
var G__18970 = chunk__18953_18963;
var G__18971 = count__18954_18964;
var G__18972 = (i__18955_18965 + (1));
seq__18952_18962 = G__18969;
chunk__18953_18963 = G__18970;
count__18954_18964 = G__18971;
i__18955_18965 = G__18972;
continue;
} else {
var temp__5457__auto___18973 = cljs.core.seq(seq__18952_18962);
if(temp__5457__auto___18973){
var seq__18952_18974__$1 = temp__5457__auto___18973;
if(cljs.core.chunked_seq_QMARK_(seq__18952_18974__$1)){
var c__9737__auto___18975 = cljs.core.chunk_first(seq__18952_18974__$1);
var G__18976 = cljs.core.chunk_rest(seq__18952_18974__$1);
var G__18977 = c__9737__auto___18975;
var G__18978 = cljs.core.count(c__9737__auto___18975);
var G__18979 = (0);
seq__18952_18962 = G__18976;
chunk__18953_18963 = G__18977;
count__18954_18964 = G__18978;
i__18955_18965 = G__18979;
continue;
} else {
var vec__18959_18980 = cljs.core.first(seq__18952_18974__$1);
var k_18981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18959_18980,(0),null);
var v_18982 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18959_18980,(1),null);
if(cljs.core.coll_QMARK_(v_18982)){
form_data.append(cljs.core.name(k_18981),cljs.core.first(v_18982),cljs.core.second(v_18982));
} else {
form_data.append(cljs.core.name(k_18981),v_18982);
}

var G__18983 = cljs.core.next(seq__18952_18974__$1);
var G__18984 = null;
var G__18985 = (0);
var G__18986 = (0);
seq__18952_18962 = G__18983;
chunk__18953_18963 = G__18984;
count__18954_18964 = G__18985;
i__18955_18965 = G__18986;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__18987){
var map__18988 = p__18987;
var map__18988__$1 = ((((!((map__18988 == null)))?((((map__18988.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18988.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18988):map__18988);
var request = map__18988__$1;
var multipart_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18988__$1,cljs.core.cst$kw$multipart_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18988__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core.truth_((function (){var and__8794__auto__ = multipart_params;
if(cljs.core.truth_(and__8794__auto__)){
var fexpr__18990 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$patch,null,cljs.core.cst$kw$delete,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$put,null], null), null);
return (fexpr__18990.cljs$core$IFn$_invoke$arity$1 ? fexpr__18990.cljs$core$IFn$_invoke$arity$1(request_method) : fexpr__18990.call(null,request_method));
} else {
return and__8794__auto__;
}
})())){
var G__18991 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$multipart_DASH_params),cljs.core.cst$kw$body,cljs_http.client.generate_form_data(multipart_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18991) : client.call(null,G__18991));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__5455__auto__ = cljs.core.cst$kw$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__5455__auto__)){
var m = temp__5455__auto__;
var G__18992 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$method),cljs.core.cst$kw$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18992) : client.call(null,G__18992));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__18993_SHARP_){
var G__18994 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__18993_SHARP_,cljs.core.cst$kw$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18994) : client.call(null,G__18994));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__18996){
var map__18997 = p__18996;
var map__18997__$1 = ((((!((map__18997 == null)))?((((map__18997.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18997.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18997):map__18997);
var req = map__18997__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18997__$1,cljs.core.cst$kw$query_DASH_params);
var temp__5455__auto__ = cljs_http.client.parse_url(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__5455__auto__)){
var spec = temp__5455__auto__;
var G__18999 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,spec], 0)),cljs.core.cst$kw$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params], null),((function (spec,temp__5455__auto__,map__18997,map__18997__$1,req,query_params){
return (function (p1__18995_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p1__18995_SHARP_,query_params], 0));
});})(spec,temp__5455__auto__,map__18997,map__18997__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18999) : client.call(null,G__18999));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19007 = arguments.length;
var i__10086__auto___19008 = (0);
while(true){
if((i__10086__auto___19008 < len__10085__auto___19007)){
args__10092__auto__.push((arguments[i__10086__auto___19008]));

var G__19009 = (i__10086__auto___19008 + (1));
i__10086__auto___19008 = G__19009;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__19002){
var vec__19003 = p__19002;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19003,(0),null);
return ((function (vec__19003,credentials){
return (function (req){
var credentials__$1 = (function (){var or__8806__auto__ = cljs.core.cst$kw$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__19006 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__19006) : client.call(null,G__19006));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
;})(vec__19003,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq19000){
var G__19001 = cljs.core.first(seq19000);
var seq19000__$1 = cljs.core.next(seq19000);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__19001,seq19000__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__5455__auto__ = cljs.core.cst$kw$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__5455__auto__)){
var oauth_token = temp__5455__auto__;
var G__19010 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"authorization"], null),["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__19010) : client.call(null,G__19010));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__5455__auto__ = cljs.core.cst$kw$channel.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var custom_channel = temp__5455__auto__;
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request)),custom_channel);
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers(cljs_http.client.wrap_channel_from_request_map(cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_multipart_params(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19018 = arguments.length;
var i__10086__auto___19019 = (0);
while(true){
if((i__10086__auto___19019 < len__10085__auto___19018)){
args__10092__auto__.push((arguments[i__10086__auto___19019]));

var G__19020 = (i__10086__auto___19019 + (1));
i__10086__auto___19019 = G__19020;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19013){
var vec__19014 = p__19013;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19014,(0),null);
var G__19017 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$delete,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19017) : cljs_http.client.request.call(null,G__19017));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq19011){
var G__19012 = cljs.core.first(seq19011);
var seq19011__$1 = cljs.core.next(seq19011);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__19012,seq19011__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19028 = arguments.length;
var i__10086__auto___19029 = (0);
while(true){
if((i__10086__auto___19029 < len__10085__auto___19028)){
args__10092__auto__.push((arguments[i__10086__auto___19029]));

var G__19030 = (i__10086__auto___19029 + (1));
i__10086__auto___19029 = G__19030;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19023){
var vec__19024 = p__19023;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19024,(0),null);
var G__19027 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$get,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19027) : cljs_http.client.request.call(null,G__19027));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq19021){
var G__19022 = cljs.core.first(seq19021);
var seq19021__$1 = cljs.core.next(seq19021);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__19022,seq19021__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19038 = arguments.length;
var i__10086__auto___19039 = (0);
while(true){
if((i__10086__auto___19039 < len__10085__auto___19038)){
args__10092__auto__.push((arguments[i__10086__auto___19039]));

var G__19040 = (i__10086__auto___19039 + (1));
i__10086__auto___19039 = G__19040;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19033){
var vec__19034 = p__19033;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19034,(0),null);
var G__19037 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$head,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19037) : cljs_http.client.request.call(null,G__19037));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq19031){
var G__19032 = cljs.core.first(seq19031);
var seq19031__$1 = cljs.core.next(seq19031);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__19032,seq19031__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19048 = arguments.length;
var i__10086__auto___19049 = (0);
while(true){
if((i__10086__auto___19049 < len__10085__auto___19048)){
args__10092__auto__.push((arguments[i__10086__auto___19049]));

var G__19050 = (i__10086__auto___19049 + (1));
i__10086__auto___19049 = G__19050;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19043){
var vec__19044 = p__19043;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19044,(0),null);
var G__19047 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$jsonp,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19047) : cljs_http.client.request.call(null,G__19047));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq19041){
var G__19042 = cljs.core.first(seq19041);
var seq19041__$1 = cljs.core.next(seq19041);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__19042,seq19041__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19058 = arguments.length;
var i__10086__auto___19059 = (0);
while(true){
if((i__10086__auto___19059 < len__10085__auto___19058)){
args__10092__auto__.push((arguments[i__10086__auto___19059]));

var G__19060 = (i__10086__auto___19059 + (1));
i__10086__auto___19059 = G__19060;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19053){
var vec__19054 = p__19053;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19054,(0),null);
var G__19057 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$move,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19057) : cljs_http.client.request.call(null,G__19057));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq19051){
var G__19052 = cljs.core.first(seq19051);
var seq19051__$1 = cljs.core.next(seq19051);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__19052,seq19051__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19068 = arguments.length;
var i__10086__auto___19069 = (0);
while(true){
if((i__10086__auto___19069 < len__10085__auto___19068)){
args__10092__auto__.push((arguments[i__10086__auto___19069]));

var G__19070 = (i__10086__auto___19069 + (1));
i__10086__auto___19069 = G__19070;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19063){
var vec__19064 = p__19063;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19064,(0),null);
var G__19067 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$options,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19067) : cljs_http.client.request.call(null,G__19067));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq19061){
var G__19062 = cljs.core.first(seq19061);
var seq19061__$1 = cljs.core.next(seq19061);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__19062,seq19061__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19078 = arguments.length;
var i__10086__auto___19079 = (0);
while(true){
if((i__10086__auto___19079 < len__10085__auto___19078)){
args__10092__auto__.push((arguments[i__10086__auto___19079]));

var G__19080 = (i__10086__auto___19079 + (1));
i__10086__auto___19079 = G__19080;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19073){
var vec__19074 = p__19073;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19074,(0),null);
var G__19077 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$patch,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19077) : cljs_http.client.request.call(null,G__19077));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq19071){
var G__19072 = cljs.core.first(seq19071);
var seq19071__$1 = cljs.core.next(seq19071);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__19072,seq19071__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19088 = arguments.length;
var i__10086__auto___19089 = (0);
while(true){
if((i__10086__auto___19089 < len__10085__auto___19088)){
args__10092__auto__.push((arguments[i__10086__auto___19089]));

var G__19090 = (i__10086__auto___19089 + (1));
i__10086__auto___19089 = G__19090;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19083){
var vec__19084 = p__19083;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19084,(0),null);
var G__19087 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$post,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19087) : cljs_http.client.request.call(null,G__19087));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq19081){
var G__19082 = cljs.core.first(seq19081);
var seq19081__$1 = cljs.core.next(seq19081);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__19082,seq19081__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19098 = arguments.length;
var i__10086__auto___19099 = (0);
while(true){
if((i__10086__auto___19099 < len__10085__auto___19098)){
args__10092__auto__.push((arguments[i__10086__auto___19099]));

var G__19100 = (i__10086__auto___19099 + (1));
i__10086__auto___19099 = G__19100;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19093){
var vec__19094 = p__19093;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19094,(0),null);
var G__19097 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$put,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19097) : cljs_http.client.request.call(null,G__19097));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq19091){
var G__19092 = cljs.core.first(seq19091);
var seq19091__$1 = cljs.core.next(seq19091);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__19092,seq19091__$1);
});

