// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__16956 = arguments.length;
switch (G__16956) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async16957 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16957 = (function (f,blockable,meta16958){
this.f = f;
this.blockable = blockable;
this.meta16958 = meta16958;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16957.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16959,meta16958__$1){
var self__ = this;
var _16959__$1 = this;
return (new cljs.core.async.t_cljs$core$async16957(self__.f,self__.blockable,meta16958__$1));
});

cljs.core.async.t_cljs$core$async16957.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16959){
var self__ = this;
var _16959__$1 = this;
return self__.meta16958;
});

cljs.core.async.t_cljs$core$async16957.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16957.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16957.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async16957.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async16957.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta16958], null);
});

cljs.core.async.t_cljs$core$async16957.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16957.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16957";

cljs.core.async.t_cljs$core$async16957.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16957");
});

cljs.core.async.__GT_t_cljs$core$async16957 = (function cljs$core$async$__GT_t_cljs$core$async16957(f__$1,blockable__$1,meta16958){
return (new cljs.core.async.t_cljs$core$async16957(f__$1,blockable__$1,meta16958));
});

}

return (new cljs.core.async.t_cljs$core$async16957(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__16963 = arguments.length;
switch (G__16963) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__16966 = arguments.length;
switch (G__16966) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__16969 = arguments.length;
switch (G__16969) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_16971 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16971) : fn1.call(null,val_16971));
} else {
cljs.core.async.impl.dispatch.run(((function (val_16971,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16971) : fn1.call(null,val_16971));
});})(val_16971,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__16973 = arguments.length;
switch (G__16973) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9851__auto___16975 = n;
var x_16976 = (0);
while(true){
if((x_16976 < n__9851__auto___16975)){
(a[x_16976] = (0));

var G__16977 = (x_16976 + (1));
x_16976 = G__16977;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__16978 = (i + (1));
i = G__16978;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async16979 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16979 = (function (flag,meta16980){
this.flag = flag;
this.meta16980 = meta16980;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_16981,meta16980__$1){
var self__ = this;
var _16981__$1 = this;
return (new cljs.core.async.t_cljs$core$async16979(self__.flag,meta16980__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_16981){
var self__ = this;
var _16981__$1 = this;
return self__.meta16980;
});})(flag))
;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16979.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16979.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta16980], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async16979.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16979.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16979";

cljs.core.async.t_cljs$core$async16979.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16979");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async16979 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async16979(flag__$1,meta16980){
return (new cljs.core.async.t_cljs$core$async16979(flag__$1,meta16980));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async16979(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async16982 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16982 = (function (flag,cb,meta16983){
this.flag = flag;
this.cb = cb;
this.meta16983 = meta16983;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16982.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16984,meta16983__$1){
var self__ = this;
var _16984__$1 = this;
return (new cljs.core.async.t_cljs$core$async16982(self__.flag,self__.cb,meta16983__$1));
});

cljs.core.async.t_cljs$core$async16982.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16984){
var self__ = this;
var _16984__$1 = this;
return self__.meta16983;
});

cljs.core.async.t_cljs$core$async16982.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16982.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async16982.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16982.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async16982.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta16983], null);
});

cljs.core.async.t_cljs$core$async16982.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16982.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16982";

cljs.core.async.t_cljs$core$async16982.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16982");
});

cljs.core.async.__GT_t_cljs$core$async16982 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async16982(flag__$1,cb__$1,meta16983){
return (new cljs.core.async.t_cljs$core$async16982(flag__$1,cb__$1,meta16983));
});

}

return (new cljs.core.async.t_cljs$core$async16982(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16985_SHARP_){
var G__16987 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16985_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16987) : fret.call(null,G__16987));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16986_SHARP_){
var G__16988 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16986_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16988) : fret.call(null,G__16988));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__8806__auto__ = wport;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return port;
}
})()], null));
} else {
var G__16989 = (i + (1));
i = G__16989;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8806__auto__ = ret;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__8794__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8794__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8794__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10092__auto__ = [];
var len__10085__auto___16995 = arguments.length;
var i__10086__auto___16996 = (0);
while(true){
if((i__10086__auto___16996 < len__10085__auto___16995)){
args__10092__auto__.push((arguments[i__10086__auto___16996]));

var G__16997 = (i__10086__auto___16996 + (1));
i__10086__auto___16996 = G__16997;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__16992){
var map__16993 = p__16992;
var map__16993__$1 = ((((!((map__16993 == null)))?((((map__16993.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16993.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16993):map__16993);
var opts = map__16993__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq16990){
var G__16991 = cljs.core.first(seq16990);
var seq16990__$1 = cljs.core.next(seq16990);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16991,seq16990__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__16999 = arguments.length;
switch (G__16999) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16896__auto___17045 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___17045){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___17045){
return (function (state_17023){
var state_val_17024 = (state_17023[(1)]);
if((state_val_17024 === (7))){
var inst_17019 = (state_17023[(2)]);
var state_17023__$1 = state_17023;
var statearr_17025_17046 = state_17023__$1;
(statearr_17025_17046[(2)] = inst_17019);

(statearr_17025_17046[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17024 === (1))){
var state_17023__$1 = state_17023;
var statearr_17026_17047 = state_17023__$1;
(statearr_17026_17047[(2)] = null);

(statearr_17026_17047[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17024 === (4))){
var inst_17002 = (state_17023[(7)]);
var inst_17002__$1 = (state_17023[(2)]);
var inst_17003 = (inst_17002__$1 == null);
var state_17023__$1 = (function (){var statearr_17027 = state_17023;
(statearr_17027[(7)] = inst_17002__$1);

return statearr_17027;
})();
if(cljs.core.truth_(inst_17003)){
var statearr_17028_17048 = state_17023__$1;
(statearr_17028_17048[(1)] = (5));

} else {
var statearr_17029_17049 = state_17023__$1;
(statearr_17029_17049[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17024 === (13))){
var state_17023__$1 = state_17023;
var statearr_17030_17050 = state_17023__$1;
(statearr_17030_17050[(2)] = null);

(statearr_17030_17050[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17024 === (6))){
var inst_17002 = (state_17023[(7)]);
var state_17023__$1 = state_17023;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17023__$1,(11),to,inst_17002);
} else {
if((state_val_17024 === (3))){
var inst_17021 = (state_17023[(2)]);
var state_17023__$1 = state_17023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17023__$1,inst_17021);
} else {
if((state_val_17024 === (12))){
var state_17023__$1 = state_17023;
var statearr_17031_17051 = state_17023__$1;
(statearr_17031_17051[(2)] = null);

(statearr_17031_17051[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17024 === (2))){
var state_17023__$1 = state_17023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17023__$1,(4),from);
} else {
if((state_val_17024 === (11))){
var inst_17012 = (state_17023[(2)]);
var state_17023__$1 = state_17023;
if(cljs.core.truth_(inst_17012)){
var statearr_17032_17052 = state_17023__$1;
(statearr_17032_17052[(1)] = (12));

} else {
var statearr_17033_17053 = state_17023__$1;
(statearr_17033_17053[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17024 === (9))){
var state_17023__$1 = state_17023;
var statearr_17034_17054 = state_17023__$1;
(statearr_17034_17054[(2)] = null);

(statearr_17034_17054[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17024 === (5))){
var state_17023__$1 = state_17023;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17035_17055 = state_17023__$1;
(statearr_17035_17055[(1)] = (8));

} else {
var statearr_17036_17056 = state_17023__$1;
(statearr_17036_17056[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17024 === (14))){
var inst_17017 = (state_17023[(2)]);
var state_17023__$1 = state_17023;
var statearr_17037_17057 = state_17023__$1;
(statearr_17037_17057[(2)] = inst_17017);

(statearr_17037_17057[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17024 === (10))){
var inst_17009 = (state_17023[(2)]);
var state_17023__$1 = state_17023;
var statearr_17038_17058 = state_17023__$1;
(statearr_17038_17058[(2)] = inst_17009);

(statearr_17038_17058[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17024 === (8))){
var inst_17006 = cljs.core.async.close_BANG_(to);
var state_17023__$1 = state_17023;
var statearr_17039_17059 = state_17023__$1;
(statearr_17039_17059[(2)] = inst_17006);

(statearr_17039_17059[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___17045))
;
return ((function (switch__16794__auto__,c__16896__auto___17045){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_17040 = [null,null,null,null,null,null,null,null];
(statearr_17040[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_17040[(1)] = (1));

return statearr_17040;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_17023){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17023);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17041){if((e17041 instanceof Object)){
var ex__16798__auto__ = e17041;
var statearr_17042_17060 = state_17023;
(statearr_17042_17060[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17023);

return cljs.core.cst$kw$recur;
} else {
throw e17041;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17061 = state_17023;
state_17023 = G__17061;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_17023){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_17023);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___17045))
})();
var state__16898__auto__ = (function (){var statearr_17043 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17043[(6)] = c__16896__auto___17045);

return statearr_17043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___17045))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__17062){
var vec__17063 = p__17062;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17063,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17063,(1),null);
var job = vec__17063;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__16896__auto___17234 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___17234,res,vec__17063,v,p,job,jobs,results){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___17234,res,vec__17063,v,p,job,jobs,results){
return (function (state_17070){
var state_val_17071 = (state_17070[(1)]);
if((state_val_17071 === (1))){
var state_17070__$1 = state_17070;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17070__$1,(2),res,v);
} else {
if((state_val_17071 === (2))){
var inst_17067 = (state_17070[(2)]);
var inst_17068 = cljs.core.async.close_BANG_(res);
var state_17070__$1 = (function (){var statearr_17072 = state_17070;
(statearr_17072[(7)] = inst_17067);

return statearr_17072;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17070__$1,inst_17068);
} else {
return null;
}
}
});})(c__16896__auto___17234,res,vec__17063,v,p,job,jobs,results))
;
return ((function (switch__16794__auto__,c__16896__auto___17234,res,vec__17063,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0 = (function (){
var statearr_17073 = [null,null,null,null,null,null,null,null];
(statearr_17073[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__);

(statearr_17073[(1)] = (1));

return statearr_17073;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1 = (function (state_17070){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17070);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17074){if((e17074 instanceof Object)){
var ex__16798__auto__ = e17074;
var statearr_17075_17235 = state_17070;
(statearr_17075_17235[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17070);

return cljs.core.cst$kw$recur;
} else {
throw e17074;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17236 = state_17070;
state_17070 = G__17236;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__ = function(state_17070){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1.call(this,state_17070);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___17234,res,vec__17063,v,p,job,jobs,results))
})();
var state__16898__auto__ = (function (){var statearr_17076 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17076[(6)] = c__16896__auto___17234);

return statearr_17076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___17234,res,vec__17063,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17077){
var vec__17078 = p__17077;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17078,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17078,(1),null);
var job = vec__17078;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__9851__auto___17237 = n;
var __17238 = (0);
while(true){
if((__17238 < n__9851__auto___17237)){
var G__17081_17239 = type;
var G__17081_17240__$1 = (((G__17081_17239 instanceof cljs.core.Keyword))?G__17081_17239.fqn:null);
switch (G__17081_17240__$1) {
case "compute":
var c__16896__auto___17242 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17238,c__16896__auto___17242,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (__17238,c__16896__auto___17242,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async){
return (function (state_17094){
var state_val_17095 = (state_17094[(1)]);
if((state_val_17095 === (1))){
var state_17094__$1 = state_17094;
var statearr_17096_17243 = state_17094__$1;
(statearr_17096_17243[(2)] = null);

(statearr_17096_17243[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17095 === (2))){
var state_17094__$1 = state_17094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17094__$1,(4),jobs);
} else {
if((state_val_17095 === (3))){
var inst_17092 = (state_17094[(2)]);
var state_17094__$1 = state_17094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17094__$1,inst_17092);
} else {
if((state_val_17095 === (4))){
var inst_17084 = (state_17094[(2)]);
var inst_17085 = process(inst_17084);
var state_17094__$1 = state_17094;
if(cljs.core.truth_(inst_17085)){
var statearr_17097_17244 = state_17094__$1;
(statearr_17097_17244[(1)] = (5));

} else {
var statearr_17098_17245 = state_17094__$1;
(statearr_17098_17245[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17095 === (5))){
var state_17094__$1 = state_17094;
var statearr_17099_17246 = state_17094__$1;
(statearr_17099_17246[(2)] = null);

(statearr_17099_17246[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17095 === (6))){
var state_17094__$1 = state_17094;
var statearr_17100_17247 = state_17094__$1;
(statearr_17100_17247[(2)] = null);

(statearr_17100_17247[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17095 === (7))){
var inst_17090 = (state_17094[(2)]);
var state_17094__$1 = state_17094;
var statearr_17101_17248 = state_17094__$1;
(statearr_17101_17248[(2)] = inst_17090);

(statearr_17101_17248[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17238,c__16896__auto___17242,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async))
;
return ((function (__17238,switch__16794__auto__,c__16896__auto___17242,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0 = (function (){
var statearr_17102 = [null,null,null,null,null,null,null];
(statearr_17102[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__);

(statearr_17102[(1)] = (1));

return statearr_17102;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1 = (function (state_17094){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17094);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17103){if((e17103 instanceof Object)){
var ex__16798__auto__ = e17103;
var statearr_17104_17249 = state_17094;
(statearr_17104_17249[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17094);

return cljs.core.cst$kw$recur;
} else {
throw e17103;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17250 = state_17094;
state_17094 = G__17250;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__ = function(state_17094){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1.call(this,state_17094);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__;
})()
;})(__17238,switch__16794__auto__,c__16896__auto___17242,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async))
})();
var state__16898__auto__ = (function (){var statearr_17105 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17105[(6)] = c__16896__auto___17242);

return statearr_17105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(__17238,c__16896__auto___17242,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async))
);


break;
case "async":
var c__16896__auto___17251 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17238,c__16896__auto___17251,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (__17238,c__16896__auto___17251,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async){
return (function (state_17118){
var state_val_17119 = (state_17118[(1)]);
if((state_val_17119 === (1))){
var state_17118__$1 = state_17118;
var statearr_17120_17252 = state_17118__$1;
(statearr_17120_17252[(2)] = null);

(statearr_17120_17252[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (2))){
var state_17118__$1 = state_17118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17118__$1,(4),jobs);
} else {
if((state_val_17119 === (3))){
var inst_17116 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17118__$1,inst_17116);
} else {
if((state_val_17119 === (4))){
var inst_17108 = (state_17118[(2)]);
var inst_17109 = async(inst_17108);
var state_17118__$1 = state_17118;
if(cljs.core.truth_(inst_17109)){
var statearr_17121_17253 = state_17118__$1;
(statearr_17121_17253[(1)] = (5));

} else {
var statearr_17122_17254 = state_17118__$1;
(statearr_17122_17254[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (5))){
var state_17118__$1 = state_17118;
var statearr_17123_17255 = state_17118__$1;
(statearr_17123_17255[(2)] = null);

(statearr_17123_17255[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (6))){
var state_17118__$1 = state_17118;
var statearr_17124_17256 = state_17118__$1;
(statearr_17124_17256[(2)] = null);

(statearr_17124_17256[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (7))){
var inst_17114 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
var statearr_17125_17257 = state_17118__$1;
(statearr_17125_17257[(2)] = inst_17114);

(statearr_17125_17257[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17238,c__16896__auto___17251,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async))
;
return ((function (__17238,switch__16794__auto__,c__16896__auto___17251,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0 = (function (){
var statearr_17126 = [null,null,null,null,null,null,null];
(statearr_17126[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__);

(statearr_17126[(1)] = (1));

return statearr_17126;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1 = (function (state_17118){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17118);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17127){if((e17127 instanceof Object)){
var ex__16798__auto__ = e17127;
var statearr_17128_17258 = state_17118;
(statearr_17128_17258[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17118);

return cljs.core.cst$kw$recur;
} else {
throw e17127;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17259 = state_17118;
state_17118 = G__17259;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__ = function(state_17118){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1.call(this,state_17118);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__;
})()
;})(__17238,switch__16794__auto__,c__16896__auto___17251,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async))
})();
var state__16898__auto__ = (function (){var statearr_17129 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17129[(6)] = c__16896__auto___17251);

return statearr_17129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(__17238,c__16896__auto___17251,G__17081_17239,G__17081_17240__$1,n__9851__auto___17237,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17081_17240__$1)].join('')));

}

var G__17260 = (__17238 + (1));
__17238 = G__17260;
continue;
} else {
}
break;
}

var c__16896__auto___17261 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___17261,jobs,results,process,async){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___17261,jobs,results,process,async){
return (function (state_17151){
var state_val_17152 = (state_17151[(1)]);
if((state_val_17152 === (1))){
var state_17151__$1 = state_17151;
var statearr_17153_17262 = state_17151__$1;
(statearr_17153_17262[(2)] = null);

(statearr_17153_17262[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17152 === (2))){
var state_17151__$1 = state_17151;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17151__$1,(4),from);
} else {
if((state_val_17152 === (3))){
var inst_17149 = (state_17151[(2)]);
var state_17151__$1 = state_17151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17151__$1,inst_17149);
} else {
if((state_val_17152 === (4))){
var inst_17132 = (state_17151[(7)]);
var inst_17132__$1 = (state_17151[(2)]);
var inst_17133 = (inst_17132__$1 == null);
var state_17151__$1 = (function (){var statearr_17154 = state_17151;
(statearr_17154[(7)] = inst_17132__$1);

return statearr_17154;
})();
if(cljs.core.truth_(inst_17133)){
var statearr_17155_17263 = state_17151__$1;
(statearr_17155_17263[(1)] = (5));

} else {
var statearr_17156_17264 = state_17151__$1;
(statearr_17156_17264[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17152 === (5))){
var inst_17135 = cljs.core.async.close_BANG_(jobs);
var state_17151__$1 = state_17151;
var statearr_17157_17265 = state_17151__$1;
(statearr_17157_17265[(2)] = inst_17135);

(statearr_17157_17265[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17152 === (6))){
var inst_17132 = (state_17151[(7)]);
var inst_17137 = (state_17151[(8)]);
var inst_17137__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_17138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17139 = [inst_17132,inst_17137__$1];
var inst_17140 = (new cljs.core.PersistentVector(null,2,(5),inst_17138,inst_17139,null));
var state_17151__$1 = (function (){var statearr_17158 = state_17151;
(statearr_17158[(8)] = inst_17137__$1);

return statearr_17158;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17151__$1,(8),jobs,inst_17140);
} else {
if((state_val_17152 === (7))){
var inst_17147 = (state_17151[(2)]);
var state_17151__$1 = state_17151;
var statearr_17159_17266 = state_17151__$1;
(statearr_17159_17266[(2)] = inst_17147);

(statearr_17159_17266[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17152 === (8))){
var inst_17137 = (state_17151[(8)]);
var inst_17142 = (state_17151[(2)]);
var state_17151__$1 = (function (){var statearr_17160 = state_17151;
(statearr_17160[(9)] = inst_17142);

return statearr_17160;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17151__$1,(9),results,inst_17137);
} else {
if((state_val_17152 === (9))){
var inst_17144 = (state_17151[(2)]);
var state_17151__$1 = (function (){var statearr_17161 = state_17151;
(statearr_17161[(10)] = inst_17144);

return statearr_17161;
})();
var statearr_17162_17267 = state_17151__$1;
(statearr_17162_17267[(2)] = null);

(statearr_17162_17267[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___17261,jobs,results,process,async))
;
return ((function (switch__16794__auto__,c__16896__auto___17261,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0 = (function (){
var statearr_17163 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17163[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__);

(statearr_17163[(1)] = (1));

return statearr_17163;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1 = (function (state_17151){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17151);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17164){if((e17164 instanceof Object)){
var ex__16798__auto__ = e17164;
var statearr_17165_17268 = state_17151;
(statearr_17165_17268[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17151);

return cljs.core.cst$kw$recur;
} else {
throw e17164;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17269 = state_17151;
state_17151 = G__17269;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__ = function(state_17151){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1.call(this,state_17151);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___17261,jobs,results,process,async))
})();
var state__16898__auto__ = (function (){var statearr_17166 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17166[(6)] = c__16896__auto___17261);

return statearr_17166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___17261,jobs,results,process,async))
);


var c__16896__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto__,jobs,results,process,async){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto__,jobs,results,process,async){
return (function (state_17204){
var state_val_17205 = (state_17204[(1)]);
if((state_val_17205 === (7))){
var inst_17200 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
var statearr_17206_17270 = state_17204__$1;
(statearr_17206_17270[(2)] = inst_17200);

(statearr_17206_17270[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (20))){
var state_17204__$1 = state_17204;
var statearr_17207_17271 = state_17204__$1;
(statearr_17207_17271[(2)] = null);

(statearr_17207_17271[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (1))){
var state_17204__$1 = state_17204;
var statearr_17208_17272 = state_17204__$1;
(statearr_17208_17272[(2)] = null);

(statearr_17208_17272[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (4))){
var inst_17169 = (state_17204[(7)]);
var inst_17169__$1 = (state_17204[(2)]);
var inst_17170 = (inst_17169__$1 == null);
var state_17204__$1 = (function (){var statearr_17209 = state_17204;
(statearr_17209[(7)] = inst_17169__$1);

return statearr_17209;
})();
if(cljs.core.truth_(inst_17170)){
var statearr_17210_17273 = state_17204__$1;
(statearr_17210_17273[(1)] = (5));

} else {
var statearr_17211_17274 = state_17204__$1;
(statearr_17211_17274[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (15))){
var inst_17182 = (state_17204[(8)]);
var state_17204__$1 = state_17204;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17204__$1,(18),to,inst_17182);
} else {
if((state_val_17205 === (21))){
var inst_17195 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
var statearr_17212_17275 = state_17204__$1;
(statearr_17212_17275[(2)] = inst_17195);

(statearr_17212_17275[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (13))){
var inst_17197 = (state_17204[(2)]);
var state_17204__$1 = (function (){var statearr_17213 = state_17204;
(statearr_17213[(9)] = inst_17197);

return statearr_17213;
})();
var statearr_17214_17276 = state_17204__$1;
(statearr_17214_17276[(2)] = null);

(statearr_17214_17276[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (6))){
var inst_17169 = (state_17204[(7)]);
var state_17204__$1 = state_17204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17204__$1,(11),inst_17169);
} else {
if((state_val_17205 === (17))){
var inst_17190 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
if(cljs.core.truth_(inst_17190)){
var statearr_17215_17277 = state_17204__$1;
(statearr_17215_17277[(1)] = (19));

} else {
var statearr_17216_17278 = state_17204__$1;
(statearr_17216_17278[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (3))){
var inst_17202 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17204__$1,inst_17202);
} else {
if((state_val_17205 === (12))){
var inst_17179 = (state_17204[(10)]);
var state_17204__$1 = state_17204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17204__$1,(14),inst_17179);
} else {
if((state_val_17205 === (2))){
var state_17204__$1 = state_17204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17204__$1,(4),results);
} else {
if((state_val_17205 === (19))){
var state_17204__$1 = state_17204;
var statearr_17217_17279 = state_17204__$1;
(statearr_17217_17279[(2)] = null);

(statearr_17217_17279[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (11))){
var inst_17179 = (state_17204[(2)]);
var state_17204__$1 = (function (){var statearr_17218 = state_17204;
(statearr_17218[(10)] = inst_17179);

return statearr_17218;
})();
var statearr_17219_17280 = state_17204__$1;
(statearr_17219_17280[(2)] = null);

(statearr_17219_17280[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (9))){
var state_17204__$1 = state_17204;
var statearr_17220_17281 = state_17204__$1;
(statearr_17220_17281[(2)] = null);

(statearr_17220_17281[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (5))){
var state_17204__$1 = state_17204;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17221_17282 = state_17204__$1;
(statearr_17221_17282[(1)] = (8));

} else {
var statearr_17222_17283 = state_17204__$1;
(statearr_17222_17283[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (14))){
var inst_17184 = (state_17204[(11)]);
var inst_17182 = (state_17204[(8)]);
var inst_17182__$1 = (state_17204[(2)]);
var inst_17183 = (inst_17182__$1 == null);
var inst_17184__$1 = cljs.core.not(inst_17183);
var state_17204__$1 = (function (){var statearr_17223 = state_17204;
(statearr_17223[(11)] = inst_17184__$1);

(statearr_17223[(8)] = inst_17182__$1);

return statearr_17223;
})();
if(inst_17184__$1){
var statearr_17224_17284 = state_17204__$1;
(statearr_17224_17284[(1)] = (15));

} else {
var statearr_17225_17285 = state_17204__$1;
(statearr_17225_17285[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (16))){
var inst_17184 = (state_17204[(11)]);
var state_17204__$1 = state_17204;
var statearr_17226_17286 = state_17204__$1;
(statearr_17226_17286[(2)] = inst_17184);

(statearr_17226_17286[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (10))){
var inst_17176 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
var statearr_17227_17287 = state_17204__$1;
(statearr_17227_17287[(2)] = inst_17176);

(statearr_17227_17287[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (18))){
var inst_17187 = (state_17204[(2)]);
var state_17204__$1 = state_17204;
var statearr_17228_17288 = state_17204__$1;
(statearr_17228_17288[(2)] = inst_17187);

(statearr_17228_17288[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17205 === (8))){
var inst_17173 = cljs.core.async.close_BANG_(to);
var state_17204__$1 = state_17204;
var statearr_17229_17289 = state_17204__$1;
(statearr_17229_17289[(2)] = inst_17173);

(statearr_17229_17289[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto__,jobs,results,process,async))
;
return ((function (switch__16794__auto__,c__16896__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0 = (function (){
var statearr_17230 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17230[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__);

(statearr_17230[(1)] = (1));

return statearr_17230;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1 = (function (state_17204){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17204);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17231){if((e17231 instanceof Object)){
var ex__16798__auto__ = e17231;
var statearr_17232_17290 = state_17204;
(statearr_17232_17290[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17204);

return cljs.core.cst$kw$recur;
} else {
throw e17231;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17291 = state_17204;
state_17204 = G__17291;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__ = function(state_17204){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1.call(this,state_17204);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16795__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto__,jobs,results,process,async))
})();
var state__16898__auto__ = (function (){var statearr_17233 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17233[(6)] = c__16896__auto__);

return statearr_17233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto__,jobs,results,process,async))
);

return c__16896__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__17293 = arguments.length;
switch (G__17293) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__17296 = arguments.length;
switch (G__17296) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__17299 = arguments.length;
switch (G__17299) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__16896__auto___17348 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___17348,tc,fc){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___17348,tc,fc){
return (function (state_17325){
var state_val_17326 = (state_17325[(1)]);
if((state_val_17326 === (7))){
var inst_17321 = (state_17325[(2)]);
var state_17325__$1 = state_17325;
var statearr_17327_17349 = state_17325__$1;
(statearr_17327_17349[(2)] = inst_17321);

(statearr_17327_17349[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17326 === (1))){
var state_17325__$1 = state_17325;
var statearr_17328_17350 = state_17325__$1;
(statearr_17328_17350[(2)] = null);

(statearr_17328_17350[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17326 === (4))){
var inst_17302 = (state_17325[(7)]);
var inst_17302__$1 = (state_17325[(2)]);
var inst_17303 = (inst_17302__$1 == null);
var state_17325__$1 = (function (){var statearr_17329 = state_17325;
(statearr_17329[(7)] = inst_17302__$1);

return statearr_17329;
})();
if(cljs.core.truth_(inst_17303)){
var statearr_17330_17351 = state_17325__$1;
(statearr_17330_17351[(1)] = (5));

} else {
var statearr_17331_17352 = state_17325__$1;
(statearr_17331_17352[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17326 === (13))){
var state_17325__$1 = state_17325;
var statearr_17332_17353 = state_17325__$1;
(statearr_17332_17353[(2)] = null);

(statearr_17332_17353[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17326 === (6))){
var inst_17302 = (state_17325[(7)]);
var inst_17308 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17302) : p.call(null,inst_17302));
var state_17325__$1 = state_17325;
if(cljs.core.truth_(inst_17308)){
var statearr_17333_17354 = state_17325__$1;
(statearr_17333_17354[(1)] = (9));

} else {
var statearr_17334_17355 = state_17325__$1;
(statearr_17334_17355[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17326 === (3))){
var inst_17323 = (state_17325[(2)]);
var state_17325__$1 = state_17325;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17325__$1,inst_17323);
} else {
if((state_val_17326 === (12))){
var state_17325__$1 = state_17325;
var statearr_17335_17356 = state_17325__$1;
(statearr_17335_17356[(2)] = null);

(statearr_17335_17356[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17326 === (2))){
var state_17325__$1 = state_17325;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17325__$1,(4),ch);
} else {
if((state_val_17326 === (11))){
var inst_17302 = (state_17325[(7)]);
var inst_17312 = (state_17325[(2)]);
var state_17325__$1 = state_17325;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17325__$1,(8),inst_17312,inst_17302);
} else {
if((state_val_17326 === (9))){
var state_17325__$1 = state_17325;
var statearr_17336_17357 = state_17325__$1;
(statearr_17336_17357[(2)] = tc);

(statearr_17336_17357[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17326 === (5))){
var inst_17305 = cljs.core.async.close_BANG_(tc);
var inst_17306 = cljs.core.async.close_BANG_(fc);
var state_17325__$1 = (function (){var statearr_17337 = state_17325;
(statearr_17337[(8)] = inst_17305);

return statearr_17337;
})();
var statearr_17338_17358 = state_17325__$1;
(statearr_17338_17358[(2)] = inst_17306);

(statearr_17338_17358[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17326 === (14))){
var inst_17319 = (state_17325[(2)]);
var state_17325__$1 = state_17325;
var statearr_17339_17359 = state_17325__$1;
(statearr_17339_17359[(2)] = inst_17319);

(statearr_17339_17359[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17326 === (10))){
var state_17325__$1 = state_17325;
var statearr_17340_17360 = state_17325__$1;
(statearr_17340_17360[(2)] = fc);

(statearr_17340_17360[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17326 === (8))){
var inst_17314 = (state_17325[(2)]);
var state_17325__$1 = state_17325;
if(cljs.core.truth_(inst_17314)){
var statearr_17341_17361 = state_17325__$1;
(statearr_17341_17361[(1)] = (12));

} else {
var statearr_17342_17362 = state_17325__$1;
(statearr_17342_17362[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___17348,tc,fc))
;
return ((function (switch__16794__auto__,c__16896__auto___17348,tc,fc){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_17343 = [null,null,null,null,null,null,null,null,null];
(statearr_17343[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_17343[(1)] = (1));

return statearr_17343;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_17325){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17325);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17344){if((e17344 instanceof Object)){
var ex__16798__auto__ = e17344;
var statearr_17345_17363 = state_17325;
(statearr_17345_17363[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17325);

return cljs.core.cst$kw$recur;
} else {
throw e17344;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17364 = state_17325;
state_17325 = G__17364;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_17325){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_17325);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___17348,tc,fc))
})();
var state__16898__auto__ = (function (){var statearr_17346 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17346[(6)] = c__16896__auto___17348);

return statearr_17346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___17348,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16896__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto__){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto__){
return (function (state_17385){
var state_val_17386 = (state_17385[(1)]);
if((state_val_17386 === (7))){
var inst_17381 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
var statearr_17387_17405 = state_17385__$1;
(statearr_17387_17405[(2)] = inst_17381);

(statearr_17387_17405[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (1))){
var inst_17365 = init;
var state_17385__$1 = (function (){var statearr_17388 = state_17385;
(statearr_17388[(7)] = inst_17365);

return statearr_17388;
})();
var statearr_17389_17406 = state_17385__$1;
(statearr_17389_17406[(2)] = null);

(statearr_17389_17406[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (4))){
var inst_17368 = (state_17385[(8)]);
var inst_17368__$1 = (state_17385[(2)]);
var inst_17369 = (inst_17368__$1 == null);
var state_17385__$1 = (function (){var statearr_17390 = state_17385;
(statearr_17390[(8)] = inst_17368__$1);

return statearr_17390;
})();
if(cljs.core.truth_(inst_17369)){
var statearr_17391_17407 = state_17385__$1;
(statearr_17391_17407[(1)] = (5));

} else {
var statearr_17392_17408 = state_17385__$1;
(statearr_17392_17408[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (6))){
var inst_17372 = (state_17385[(9)]);
var inst_17368 = (state_17385[(8)]);
var inst_17365 = (state_17385[(7)]);
var inst_17372__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_17365,inst_17368) : f.call(null,inst_17365,inst_17368));
var inst_17373 = cljs.core.reduced_QMARK_(inst_17372__$1);
var state_17385__$1 = (function (){var statearr_17393 = state_17385;
(statearr_17393[(9)] = inst_17372__$1);

return statearr_17393;
})();
if(inst_17373){
var statearr_17394_17409 = state_17385__$1;
(statearr_17394_17409[(1)] = (8));

} else {
var statearr_17395_17410 = state_17385__$1;
(statearr_17395_17410[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (3))){
var inst_17383 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17385__$1,inst_17383);
} else {
if((state_val_17386 === (2))){
var state_17385__$1 = state_17385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17385__$1,(4),ch);
} else {
if((state_val_17386 === (9))){
var inst_17372 = (state_17385[(9)]);
var inst_17365 = inst_17372;
var state_17385__$1 = (function (){var statearr_17396 = state_17385;
(statearr_17396[(7)] = inst_17365);

return statearr_17396;
})();
var statearr_17397_17411 = state_17385__$1;
(statearr_17397_17411[(2)] = null);

(statearr_17397_17411[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (5))){
var inst_17365 = (state_17385[(7)]);
var state_17385__$1 = state_17385;
var statearr_17398_17412 = state_17385__$1;
(statearr_17398_17412[(2)] = inst_17365);

(statearr_17398_17412[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (10))){
var inst_17379 = (state_17385[(2)]);
var state_17385__$1 = state_17385;
var statearr_17399_17413 = state_17385__$1;
(statearr_17399_17413[(2)] = inst_17379);

(statearr_17399_17413[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17386 === (8))){
var inst_17372 = (state_17385[(9)]);
var inst_17375 = cljs.core.deref(inst_17372);
var state_17385__$1 = state_17385;
var statearr_17400_17414 = state_17385__$1;
(statearr_17400_17414[(2)] = inst_17375);

(statearr_17400_17414[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto__))
;
return ((function (switch__16794__auto__,c__16896__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16795__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16795__auto____0 = (function (){
var statearr_17401 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17401[(0)] = cljs$core$async$reduce_$_state_machine__16795__auto__);

(statearr_17401[(1)] = (1));

return statearr_17401;
});
var cljs$core$async$reduce_$_state_machine__16795__auto____1 = (function (state_17385){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17385);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17402){if((e17402 instanceof Object)){
var ex__16798__auto__ = e17402;
var statearr_17403_17415 = state_17385;
(statearr_17403_17415[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17385);

return cljs.core.cst$kw$recur;
} else {
throw e17402;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17416 = state_17385;
state_17385 = G__17416;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16795__auto__ = function(state_17385){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16795__auto____1.call(this,state_17385);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16795__auto____0;
cljs$core$async$reduce_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16795__auto____1;
return cljs$core$async$reduce_$_state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto__))
})();
var state__16898__auto__ = (function (){var statearr_17404 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17404[(6)] = c__16896__auto__);

return statearr_17404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto__))
);

return c__16896__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__16896__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto__,f__$1){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto__,f__$1){
return (function (state_17422){
var state_val_17423 = (state_17422[(1)]);
if((state_val_17423 === (1))){
var inst_17417 = cljs.core.async.reduce(f__$1,init,ch);
var state_17422__$1 = state_17422;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17422__$1,(2),inst_17417);
} else {
if((state_val_17423 === (2))){
var inst_17419 = (state_17422[(2)]);
var inst_17420 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_17419) : f__$1.call(null,inst_17419));
var state_17422__$1 = state_17422;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17422__$1,inst_17420);
} else {
return null;
}
}
});})(c__16896__auto__,f__$1))
;
return ((function (switch__16794__auto__,c__16896__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16795__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16795__auto____0 = (function (){
var statearr_17424 = [null,null,null,null,null,null,null];
(statearr_17424[(0)] = cljs$core$async$transduce_$_state_machine__16795__auto__);

(statearr_17424[(1)] = (1));

return statearr_17424;
});
var cljs$core$async$transduce_$_state_machine__16795__auto____1 = (function (state_17422){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17422);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17425){if((e17425 instanceof Object)){
var ex__16798__auto__ = e17425;
var statearr_17426_17428 = state_17422;
(statearr_17426_17428[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17422);

return cljs.core.cst$kw$recur;
} else {
throw e17425;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17429 = state_17422;
state_17422 = G__17429;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16795__auto__ = function(state_17422){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16795__auto____1.call(this,state_17422);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16795__auto____0;
cljs$core$async$transduce_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16795__auto____1;
return cljs$core$async$transduce_$_state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto__,f__$1))
})();
var state__16898__auto__ = (function (){var statearr_17427 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17427[(6)] = c__16896__auto__);

return statearr_17427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto__,f__$1))
);

return c__16896__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__17431 = arguments.length;
switch (G__17431) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16896__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto__){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto__){
return (function (state_17456){
var state_val_17457 = (state_17456[(1)]);
if((state_val_17457 === (7))){
var inst_17438 = (state_17456[(2)]);
var state_17456__$1 = state_17456;
var statearr_17458_17479 = state_17456__$1;
(statearr_17458_17479[(2)] = inst_17438);

(statearr_17458_17479[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17457 === (1))){
var inst_17432 = cljs.core.seq(coll);
var inst_17433 = inst_17432;
var state_17456__$1 = (function (){var statearr_17459 = state_17456;
(statearr_17459[(7)] = inst_17433);

return statearr_17459;
})();
var statearr_17460_17480 = state_17456__$1;
(statearr_17460_17480[(2)] = null);

(statearr_17460_17480[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17457 === (4))){
var inst_17433 = (state_17456[(7)]);
var inst_17436 = cljs.core.first(inst_17433);
var state_17456__$1 = state_17456;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17456__$1,(7),ch,inst_17436);
} else {
if((state_val_17457 === (13))){
var inst_17450 = (state_17456[(2)]);
var state_17456__$1 = state_17456;
var statearr_17461_17481 = state_17456__$1;
(statearr_17461_17481[(2)] = inst_17450);

(statearr_17461_17481[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17457 === (6))){
var inst_17441 = (state_17456[(2)]);
var state_17456__$1 = state_17456;
if(cljs.core.truth_(inst_17441)){
var statearr_17462_17482 = state_17456__$1;
(statearr_17462_17482[(1)] = (8));

} else {
var statearr_17463_17483 = state_17456__$1;
(statearr_17463_17483[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17457 === (3))){
var inst_17454 = (state_17456[(2)]);
var state_17456__$1 = state_17456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17456__$1,inst_17454);
} else {
if((state_val_17457 === (12))){
var state_17456__$1 = state_17456;
var statearr_17464_17484 = state_17456__$1;
(statearr_17464_17484[(2)] = null);

(statearr_17464_17484[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17457 === (2))){
var inst_17433 = (state_17456[(7)]);
var state_17456__$1 = state_17456;
if(cljs.core.truth_(inst_17433)){
var statearr_17465_17485 = state_17456__$1;
(statearr_17465_17485[(1)] = (4));

} else {
var statearr_17466_17486 = state_17456__$1;
(statearr_17466_17486[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17457 === (11))){
var inst_17447 = cljs.core.async.close_BANG_(ch);
var state_17456__$1 = state_17456;
var statearr_17467_17487 = state_17456__$1;
(statearr_17467_17487[(2)] = inst_17447);

(statearr_17467_17487[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17457 === (9))){
var state_17456__$1 = state_17456;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17468_17488 = state_17456__$1;
(statearr_17468_17488[(1)] = (11));

} else {
var statearr_17469_17489 = state_17456__$1;
(statearr_17469_17489[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17457 === (5))){
var inst_17433 = (state_17456[(7)]);
var state_17456__$1 = state_17456;
var statearr_17470_17490 = state_17456__$1;
(statearr_17470_17490[(2)] = inst_17433);

(statearr_17470_17490[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17457 === (10))){
var inst_17452 = (state_17456[(2)]);
var state_17456__$1 = state_17456;
var statearr_17471_17491 = state_17456__$1;
(statearr_17471_17491[(2)] = inst_17452);

(statearr_17471_17491[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17457 === (8))){
var inst_17433 = (state_17456[(7)]);
var inst_17443 = cljs.core.next(inst_17433);
var inst_17433__$1 = inst_17443;
var state_17456__$1 = (function (){var statearr_17472 = state_17456;
(statearr_17472[(7)] = inst_17433__$1);

return statearr_17472;
})();
var statearr_17473_17492 = state_17456__$1;
(statearr_17473_17492[(2)] = null);

(statearr_17473_17492[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto__))
;
return ((function (switch__16794__auto__,c__16896__auto__){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_17474 = [null,null,null,null,null,null,null,null];
(statearr_17474[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_17474[(1)] = (1));

return statearr_17474;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_17456){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17456);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17475){if((e17475 instanceof Object)){
var ex__16798__auto__ = e17475;
var statearr_17476_17493 = state_17456;
(statearr_17476_17493[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17456);

return cljs.core.cst$kw$recur;
} else {
throw e17475;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17494 = state_17456;
state_17456 = G__17494;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_17456){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_17456);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto__))
})();
var state__16898__auto__ = (function (){var statearr_17477 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17477[(6)] = c__16896__auto__);

return statearr_17477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto__))
);

return c__16896__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9539__auto__ = (((_ == null))?null:_);
var m__9540__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__9540__auto__.call(null,_));
} else {
var m__9540__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__9540__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9540__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__9540__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9540__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto__.call(null,m));
} else {
var m__9540__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17495 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17495 = (function (ch,cs,meta17496){
this.ch = ch;
this.cs = cs;
this.meta17496 = meta17496;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17495.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_17497,meta17496__$1){
var self__ = this;
var _17497__$1 = this;
return (new cljs.core.async.t_cljs$core$async17495(self__.ch,self__.cs,meta17496__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async17495.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_17497){
var self__ = this;
var _17497__$1 = this;
return self__.meta17496;
});})(cs))
;

cljs.core.async.t_cljs$core$async17495.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17495.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async17495.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17495.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17495.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17495.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17495.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta17496], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async17495.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17495.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17495";

cljs.core.async.t_cljs$core$async17495.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17495");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async17495 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async17495(ch__$1,cs__$1,meta17496){
return (new cljs.core.async.t_cljs$core$async17495(ch__$1,cs__$1,meta17496));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async17495(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__16896__auto___17717 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___17717,cs,m,dchan,dctr,done){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___17717,cs,m,dchan,dctr,done){
return (function (state_17632){
var state_val_17633 = (state_17632[(1)]);
if((state_val_17633 === (7))){
var inst_17628 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
var statearr_17634_17718 = state_17632__$1;
(statearr_17634_17718[(2)] = inst_17628);

(statearr_17634_17718[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (20))){
var inst_17531 = (state_17632[(7)]);
var inst_17543 = cljs.core.first(inst_17531);
var inst_17544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17543,(0),null);
var inst_17545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17543,(1),null);
var state_17632__$1 = (function (){var statearr_17635 = state_17632;
(statearr_17635[(8)] = inst_17544);

return statearr_17635;
})();
if(cljs.core.truth_(inst_17545)){
var statearr_17636_17719 = state_17632__$1;
(statearr_17636_17719[(1)] = (22));

} else {
var statearr_17637_17720 = state_17632__$1;
(statearr_17637_17720[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (27))){
var inst_17500 = (state_17632[(9)]);
var inst_17573 = (state_17632[(10)]);
var inst_17575 = (state_17632[(11)]);
var inst_17580 = (state_17632[(12)]);
var inst_17580__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17573,inst_17575);
var inst_17581 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17580__$1,inst_17500,done);
var state_17632__$1 = (function (){var statearr_17638 = state_17632;
(statearr_17638[(12)] = inst_17580__$1);

return statearr_17638;
})();
if(cljs.core.truth_(inst_17581)){
var statearr_17639_17721 = state_17632__$1;
(statearr_17639_17721[(1)] = (30));

} else {
var statearr_17640_17722 = state_17632__$1;
(statearr_17640_17722[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (1))){
var state_17632__$1 = state_17632;
var statearr_17641_17723 = state_17632__$1;
(statearr_17641_17723[(2)] = null);

(statearr_17641_17723[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (24))){
var inst_17531 = (state_17632[(7)]);
var inst_17550 = (state_17632[(2)]);
var inst_17551 = cljs.core.next(inst_17531);
var inst_17509 = inst_17551;
var inst_17510 = null;
var inst_17511 = (0);
var inst_17512 = (0);
var state_17632__$1 = (function (){var statearr_17642 = state_17632;
(statearr_17642[(13)] = inst_17550);

(statearr_17642[(14)] = inst_17510);

(statearr_17642[(15)] = inst_17511);

(statearr_17642[(16)] = inst_17509);

(statearr_17642[(17)] = inst_17512);

return statearr_17642;
})();
var statearr_17643_17724 = state_17632__$1;
(statearr_17643_17724[(2)] = null);

(statearr_17643_17724[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (39))){
var state_17632__$1 = state_17632;
var statearr_17647_17725 = state_17632__$1;
(statearr_17647_17725[(2)] = null);

(statearr_17647_17725[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (4))){
var inst_17500 = (state_17632[(9)]);
var inst_17500__$1 = (state_17632[(2)]);
var inst_17501 = (inst_17500__$1 == null);
var state_17632__$1 = (function (){var statearr_17648 = state_17632;
(statearr_17648[(9)] = inst_17500__$1);

return statearr_17648;
})();
if(cljs.core.truth_(inst_17501)){
var statearr_17649_17726 = state_17632__$1;
(statearr_17649_17726[(1)] = (5));

} else {
var statearr_17650_17727 = state_17632__$1;
(statearr_17650_17727[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (15))){
var inst_17510 = (state_17632[(14)]);
var inst_17511 = (state_17632[(15)]);
var inst_17509 = (state_17632[(16)]);
var inst_17512 = (state_17632[(17)]);
var inst_17527 = (state_17632[(2)]);
var inst_17528 = (inst_17512 + (1));
var tmp17644 = inst_17510;
var tmp17645 = inst_17511;
var tmp17646 = inst_17509;
var inst_17509__$1 = tmp17646;
var inst_17510__$1 = tmp17644;
var inst_17511__$1 = tmp17645;
var inst_17512__$1 = inst_17528;
var state_17632__$1 = (function (){var statearr_17651 = state_17632;
(statearr_17651[(14)] = inst_17510__$1);

(statearr_17651[(15)] = inst_17511__$1);

(statearr_17651[(18)] = inst_17527);

(statearr_17651[(16)] = inst_17509__$1);

(statearr_17651[(17)] = inst_17512__$1);

return statearr_17651;
})();
var statearr_17652_17728 = state_17632__$1;
(statearr_17652_17728[(2)] = null);

(statearr_17652_17728[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (21))){
var inst_17554 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
var statearr_17656_17729 = state_17632__$1;
(statearr_17656_17729[(2)] = inst_17554);

(statearr_17656_17729[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (31))){
var inst_17580 = (state_17632[(12)]);
var inst_17584 = done(null);
var inst_17585 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17580);
var state_17632__$1 = (function (){var statearr_17657 = state_17632;
(statearr_17657[(19)] = inst_17584);

return statearr_17657;
})();
var statearr_17658_17730 = state_17632__$1;
(statearr_17658_17730[(2)] = inst_17585);

(statearr_17658_17730[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (32))){
var inst_17572 = (state_17632[(20)]);
var inst_17573 = (state_17632[(10)]);
var inst_17575 = (state_17632[(11)]);
var inst_17574 = (state_17632[(21)]);
var inst_17587 = (state_17632[(2)]);
var inst_17588 = (inst_17575 + (1));
var tmp17653 = inst_17572;
var tmp17654 = inst_17573;
var tmp17655 = inst_17574;
var inst_17572__$1 = tmp17653;
var inst_17573__$1 = tmp17654;
var inst_17574__$1 = tmp17655;
var inst_17575__$1 = inst_17588;
var state_17632__$1 = (function (){var statearr_17659 = state_17632;
(statearr_17659[(20)] = inst_17572__$1);

(statearr_17659[(10)] = inst_17573__$1);

(statearr_17659[(11)] = inst_17575__$1);

(statearr_17659[(22)] = inst_17587);

(statearr_17659[(21)] = inst_17574__$1);

return statearr_17659;
})();
var statearr_17660_17731 = state_17632__$1;
(statearr_17660_17731[(2)] = null);

(statearr_17660_17731[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (40))){
var inst_17600 = (state_17632[(23)]);
var inst_17604 = done(null);
var inst_17605 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17600);
var state_17632__$1 = (function (){var statearr_17661 = state_17632;
(statearr_17661[(24)] = inst_17604);

return statearr_17661;
})();
var statearr_17662_17732 = state_17632__$1;
(statearr_17662_17732[(2)] = inst_17605);

(statearr_17662_17732[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (33))){
var inst_17591 = (state_17632[(25)]);
var inst_17593 = cljs.core.chunked_seq_QMARK_(inst_17591);
var state_17632__$1 = state_17632;
if(inst_17593){
var statearr_17663_17733 = state_17632__$1;
(statearr_17663_17733[(1)] = (36));

} else {
var statearr_17664_17734 = state_17632__$1;
(statearr_17664_17734[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (13))){
var inst_17521 = (state_17632[(26)]);
var inst_17524 = cljs.core.async.close_BANG_(inst_17521);
var state_17632__$1 = state_17632;
var statearr_17665_17735 = state_17632__$1;
(statearr_17665_17735[(2)] = inst_17524);

(statearr_17665_17735[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (22))){
var inst_17544 = (state_17632[(8)]);
var inst_17547 = cljs.core.async.close_BANG_(inst_17544);
var state_17632__$1 = state_17632;
var statearr_17666_17736 = state_17632__$1;
(statearr_17666_17736[(2)] = inst_17547);

(statearr_17666_17736[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (36))){
var inst_17591 = (state_17632[(25)]);
var inst_17595 = cljs.core.chunk_first(inst_17591);
var inst_17596 = cljs.core.chunk_rest(inst_17591);
var inst_17597 = cljs.core.count(inst_17595);
var inst_17572 = inst_17596;
var inst_17573 = inst_17595;
var inst_17574 = inst_17597;
var inst_17575 = (0);
var state_17632__$1 = (function (){var statearr_17667 = state_17632;
(statearr_17667[(20)] = inst_17572);

(statearr_17667[(10)] = inst_17573);

(statearr_17667[(11)] = inst_17575);

(statearr_17667[(21)] = inst_17574);

return statearr_17667;
})();
var statearr_17668_17737 = state_17632__$1;
(statearr_17668_17737[(2)] = null);

(statearr_17668_17737[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (41))){
var inst_17591 = (state_17632[(25)]);
var inst_17607 = (state_17632[(2)]);
var inst_17608 = cljs.core.next(inst_17591);
var inst_17572 = inst_17608;
var inst_17573 = null;
var inst_17574 = (0);
var inst_17575 = (0);
var state_17632__$1 = (function (){var statearr_17669 = state_17632;
(statearr_17669[(20)] = inst_17572);

(statearr_17669[(10)] = inst_17573);

(statearr_17669[(11)] = inst_17575);

(statearr_17669[(21)] = inst_17574);

(statearr_17669[(27)] = inst_17607);

return statearr_17669;
})();
var statearr_17670_17738 = state_17632__$1;
(statearr_17670_17738[(2)] = null);

(statearr_17670_17738[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (43))){
var state_17632__$1 = state_17632;
var statearr_17671_17739 = state_17632__$1;
(statearr_17671_17739[(2)] = null);

(statearr_17671_17739[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (29))){
var inst_17616 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
var statearr_17672_17740 = state_17632__$1;
(statearr_17672_17740[(2)] = inst_17616);

(statearr_17672_17740[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (44))){
var inst_17625 = (state_17632[(2)]);
var state_17632__$1 = (function (){var statearr_17673 = state_17632;
(statearr_17673[(28)] = inst_17625);

return statearr_17673;
})();
var statearr_17674_17741 = state_17632__$1;
(statearr_17674_17741[(2)] = null);

(statearr_17674_17741[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (6))){
var inst_17564 = (state_17632[(29)]);
var inst_17563 = cljs.core.deref(cs);
var inst_17564__$1 = cljs.core.keys(inst_17563);
var inst_17565 = cljs.core.count(inst_17564__$1);
var inst_17566 = cljs.core.reset_BANG_(dctr,inst_17565);
var inst_17571 = cljs.core.seq(inst_17564__$1);
var inst_17572 = inst_17571;
var inst_17573 = null;
var inst_17574 = (0);
var inst_17575 = (0);
var state_17632__$1 = (function (){var statearr_17675 = state_17632;
(statearr_17675[(29)] = inst_17564__$1);

(statearr_17675[(20)] = inst_17572);

(statearr_17675[(10)] = inst_17573);

(statearr_17675[(11)] = inst_17575);

(statearr_17675[(21)] = inst_17574);

(statearr_17675[(30)] = inst_17566);

return statearr_17675;
})();
var statearr_17676_17742 = state_17632__$1;
(statearr_17676_17742[(2)] = null);

(statearr_17676_17742[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (28))){
var inst_17572 = (state_17632[(20)]);
var inst_17591 = (state_17632[(25)]);
var inst_17591__$1 = cljs.core.seq(inst_17572);
var state_17632__$1 = (function (){var statearr_17677 = state_17632;
(statearr_17677[(25)] = inst_17591__$1);

return statearr_17677;
})();
if(inst_17591__$1){
var statearr_17678_17743 = state_17632__$1;
(statearr_17678_17743[(1)] = (33));

} else {
var statearr_17679_17744 = state_17632__$1;
(statearr_17679_17744[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (25))){
var inst_17575 = (state_17632[(11)]);
var inst_17574 = (state_17632[(21)]);
var inst_17577 = (inst_17575 < inst_17574);
var inst_17578 = inst_17577;
var state_17632__$1 = state_17632;
if(cljs.core.truth_(inst_17578)){
var statearr_17680_17745 = state_17632__$1;
(statearr_17680_17745[(1)] = (27));

} else {
var statearr_17681_17746 = state_17632__$1;
(statearr_17681_17746[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (34))){
var state_17632__$1 = state_17632;
var statearr_17682_17747 = state_17632__$1;
(statearr_17682_17747[(2)] = null);

(statearr_17682_17747[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (17))){
var state_17632__$1 = state_17632;
var statearr_17683_17748 = state_17632__$1;
(statearr_17683_17748[(2)] = null);

(statearr_17683_17748[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (3))){
var inst_17630 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17632__$1,inst_17630);
} else {
if((state_val_17633 === (12))){
var inst_17559 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
var statearr_17684_17749 = state_17632__$1;
(statearr_17684_17749[(2)] = inst_17559);

(statearr_17684_17749[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (2))){
var state_17632__$1 = state_17632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17632__$1,(4),ch);
} else {
if((state_val_17633 === (23))){
var state_17632__$1 = state_17632;
var statearr_17685_17750 = state_17632__$1;
(statearr_17685_17750[(2)] = null);

(statearr_17685_17750[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (35))){
var inst_17614 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
var statearr_17686_17751 = state_17632__$1;
(statearr_17686_17751[(2)] = inst_17614);

(statearr_17686_17751[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (19))){
var inst_17531 = (state_17632[(7)]);
var inst_17535 = cljs.core.chunk_first(inst_17531);
var inst_17536 = cljs.core.chunk_rest(inst_17531);
var inst_17537 = cljs.core.count(inst_17535);
var inst_17509 = inst_17536;
var inst_17510 = inst_17535;
var inst_17511 = inst_17537;
var inst_17512 = (0);
var state_17632__$1 = (function (){var statearr_17687 = state_17632;
(statearr_17687[(14)] = inst_17510);

(statearr_17687[(15)] = inst_17511);

(statearr_17687[(16)] = inst_17509);

(statearr_17687[(17)] = inst_17512);

return statearr_17687;
})();
var statearr_17688_17752 = state_17632__$1;
(statearr_17688_17752[(2)] = null);

(statearr_17688_17752[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (11))){
var inst_17531 = (state_17632[(7)]);
var inst_17509 = (state_17632[(16)]);
var inst_17531__$1 = cljs.core.seq(inst_17509);
var state_17632__$1 = (function (){var statearr_17689 = state_17632;
(statearr_17689[(7)] = inst_17531__$1);

return statearr_17689;
})();
if(inst_17531__$1){
var statearr_17690_17753 = state_17632__$1;
(statearr_17690_17753[(1)] = (16));

} else {
var statearr_17691_17754 = state_17632__$1;
(statearr_17691_17754[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (9))){
var inst_17561 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
var statearr_17692_17755 = state_17632__$1;
(statearr_17692_17755[(2)] = inst_17561);

(statearr_17692_17755[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (5))){
var inst_17507 = cljs.core.deref(cs);
var inst_17508 = cljs.core.seq(inst_17507);
var inst_17509 = inst_17508;
var inst_17510 = null;
var inst_17511 = (0);
var inst_17512 = (0);
var state_17632__$1 = (function (){var statearr_17693 = state_17632;
(statearr_17693[(14)] = inst_17510);

(statearr_17693[(15)] = inst_17511);

(statearr_17693[(16)] = inst_17509);

(statearr_17693[(17)] = inst_17512);

return statearr_17693;
})();
var statearr_17694_17756 = state_17632__$1;
(statearr_17694_17756[(2)] = null);

(statearr_17694_17756[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (14))){
var state_17632__$1 = state_17632;
var statearr_17695_17757 = state_17632__$1;
(statearr_17695_17757[(2)] = null);

(statearr_17695_17757[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (45))){
var inst_17622 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
var statearr_17696_17758 = state_17632__$1;
(statearr_17696_17758[(2)] = inst_17622);

(statearr_17696_17758[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (26))){
var inst_17564 = (state_17632[(29)]);
var inst_17618 = (state_17632[(2)]);
var inst_17619 = cljs.core.seq(inst_17564);
var state_17632__$1 = (function (){var statearr_17697 = state_17632;
(statearr_17697[(31)] = inst_17618);

return statearr_17697;
})();
if(inst_17619){
var statearr_17698_17759 = state_17632__$1;
(statearr_17698_17759[(1)] = (42));

} else {
var statearr_17699_17760 = state_17632__$1;
(statearr_17699_17760[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (16))){
var inst_17531 = (state_17632[(7)]);
var inst_17533 = cljs.core.chunked_seq_QMARK_(inst_17531);
var state_17632__$1 = state_17632;
if(inst_17533){
var statearr_17700_17761 = state_17632__$1;
(statearr_17700_17761[(1)] = (19));

} else {
var statearr_17701_17762 = state_17632__$1;
(statearr_17701_17762[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (38))){
var inst_17611 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
var statearr_17702_17763 = state_17632__$1;
(statearr_17702_17763[(2)] = inst_17611);

(statearr_17702_17763[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (30))){
var state_17632__$1 = state_17632;
var statearr_17703_17764 = state_17632__$1;
(statearr_17703_17764[(2)] = null);

(statearr_17703_17764[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (10))){
var inst_17510 = (state_17632[(14)]);
var inst_17512 = (state_17632[(17)]);
var inst_17520 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17510,inst_17512);
var inst_17521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17520,(0),null);
var inst_17522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17520,(1),null);
var state_17632__$1 = (function (){var statearr_17704 = state_17632;
(statearr_17704[(26)] = inst_17521);

return statearr_17704;
})();
if(cljs.core.truth_(inst_17522)){
var statearr_17705_17765 = state_17632__$1;
(statearr_17705_17765[(1)] = (13));

} else {
var statearr_17706_17766 = state_17632__$1;
(statearr_17706_17766[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (18))){
var inst_17557 = (state_17632[(2)]);
var state_17632__$1 = state_17632;
var statearr_17707_17767 = state_17632__$1;
(statearr_17707_17767[(2)] = inst_17557);

(statearr_17707_17767[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (42))){
var state_17632__$1 = state_17632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17632__$1,(45),dchan);
} else {
if((state_val_17633 === (37))){
var inst_17500 = (state_17632[(9)]);
var inst_17600 = (state_17632[(23)]);
var inst_17591 = (state_17632[(25)]);
var inst_17600__$1 = cljs.core.first(inst_17591);
var inst_17601 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17600__$1,inst_17500,done);
var state_17632__$1 = (function (){var statearr_17708 = state_17632;
(statearr_17708[(23)] = inst_17600__$1);

return statearr_17708;
})();
if(cljs.core.truth_(inst_17601)){
var statearr_17709_17768 = state_17632__$1;
(statearr_17709_17768[(1)] = (39));

} else {
var statearr_17710_17769 = state_17632__$1;
(statearr_17710_17769[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17633 === (8))){
var inst_17511 = (state_17632[(15)]);
var inst_17512 = (state_17632[(17)]);
var inst_17514 = (inst_17512 < inst_17511);
var inst_17515 = inst_17514;
var state_17632__$1 = state_17632;
if(cljs.core.truth_(inst_17515)){
var statearr_17711_17770 = state_17632__$1;
(statearr_17711_17770[(1)] = (10));

} else {
var statearr_17712_17771 = state_17632__$1;
(statearr_17712_17771[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___17717,cs,m,dchan,dctr,done))
;
return ((function (switch__16794__auto__,c__16896__auto___17717,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16795__auto__ = null;
var cljs$core$async$mult_$_state_machine__16795__auto____0 = (function (){
var statearr_17713 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17713[(0)] = cljs$core$async$mult_$_state_machine__16795__auto__);

(statearr_17713[(1)] = (1));

return statearr_17713;
});
var cljs$core$async$mult_$_state_machine__16795__auto____1 = (function (state_17632){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17632);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17714){if((e17714 instanceof Object)){
var ex__16798__auto__ = e17714;
var statearr_17715_17772 = state_17632;
(statearr_17715_17772[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17632);

return cljs.core.cst$kw$recur;
} else {
throw e17714;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__17773 = state_17632;
state_17632 = G__17773;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16795__auto__ = function(state_17632){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16795__auto____1.call(this,state_17632);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16795__auto____0;
cljs$core$async$mult_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16795__auto____1;
return cljs$core$async$mult_$_state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___17717,cs,m,dchan,dctr,done))
})();
var state__16898__auto__ = (function (){var statearr_17716 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17716[(6)] = c__16896__auto___17717);

return statearr_17716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___17717,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__17775 = arguments.length;
switch (G__17775) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto__.call(null,m));
} else {
var m__9540__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9540__auto__.call(null,m,state_map));
} else {
var m__9540__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9540__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9540__auto__.call(null,m,mode));
} else {
var m__9540__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9540__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10092__auto__ = [];
var len__10085__auto___17787 = arguments.length;
var i__10086__auto___17788 = (0);
while(true){
if((i__10086__auto___17788 < len__10085__auto___17787)){
args__10092__auto__.push((arguments[i__10086__auto___17788]));

var G__17789 = (i__10086__auto___17788 + (1));
i__10086__auto___17788 = G__17789;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((3) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10093__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17781){
var map__17782 = p__17781;
var map__17782__$1 = ((((!((map__17782 == null)))?((((map__17782.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17782.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17782):map__17782);
var opts = map__17782__$1;
var statearr_17784_17790 = state;
(statearr_17784_17790[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__17782,map__17782__$1,opts){
return (function (val){
var statearr_17785_17791 = state;
(statearr_17785_17791[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__17782,map__17782__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_17786_17792 = state;
(statearr_17786_17792[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17777){
var G__17778 = cljs.core.first(seq17777);
var seq17777__$1 = cljs.core.next(seq17777);
var G__17779 = cljs.core.first(seq17777__$1);
var seq17777__$2 = cljs.core.next(seq17777__$1);
var G__17780 = cljs.core.first(seq17777__$2);
var seq17777__$3 = cljs.core.next(seq17777__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17778,G__17779,G__17780,seq17777__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17793 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17793 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta17794){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta17794 = meta17794;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17793.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17795,meta17794__$1){
var self__ = this;
var _17795__$1 = this;
return (new cljs.core.async.t_cljs$core$async17793(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta17794__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17793.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17795){
var self__ = this;
var _17795__$1 = this;
return self__.meta17794;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17793.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17793.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17793.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17793.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17793.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17793.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17793.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17793.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17793.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta17794], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17793.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17793.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17793";

cljs.core.async.t_cljs$core$async17793.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17793");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async17793 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async17793(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17794){
return (new cljs.core.async.t_cljs$core$async17793(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17794));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async17793(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16896__auto___17957 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___17957,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___17957,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_17897){
var state_val_17898 = (state_17897[(1)]);
if((state_val_17898 === (7))){
var inst_17812 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
var statearr_17899_17958 = state_17897__$1;
(statearr_17899_17958[(2)] = inst_17812);

(statearr_17899_17958[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (20))){
var inst_17824 = (state_17897[(7)]);
var state_17897__$1 = state_17897;
var statearr_17900_17959 = state_17897__$1;
(statearr_17900_17959[(2)] = inst_17824);

(statearr_17900_17959[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (27))){
var state_17897__$1 = state_17897;
var statearr_17901_17960 = state_17897__$1;
(statearr_17901_17960[(2)] = null);

(statearr_17901_17960[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (1))){
var inst_17799 = (state_17897[(8)]);
var inst_17799__$1 = calc_state();
var inst_17801 = (inst_17799__$1 == null);
var inst_17802 = cljs.core.not(inst_17801);
var state_17897__$1 = (function (){var statearr_17902 = state_17897;
(statearr_17902[(8)] = inst_17799__$1);

return statearr_17902;
})();
if(inst_17802){
var statearr_17903_17961 = state_17897__$1;
(statearr_17903_17961[(1)] = (2));

} else {
var statearr_17904_17962 = state_17897__$1;
(statearr_17904_17962[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (24))){
var inst_17848 = (state_17897[(9)]);
var inst_17857 = (state_17897[(10)]);
var inst_17871 = (state_17897[(11)]);
var inst_17871__$1 = (inst_17848.cljs$core$IFn$_invoke$arity$1 ? inst_17848.cljs$core$IFn$_invoke$arity$1(inst_17857) : inst_17848.call(null,inst_17857));
var state_17897__$1 = (function (){var statearr_17905 = state_17897;
(statearr_17905[(11)] = inst_17871__$1);

return statearr_17905;
})();
if(cljs.core.truth_(inst_17871__$1)){
var statearr_17906_17963 = state_17897__$1;
(statearr_17906_17963[(1)] = (29));

} else {
var statearr_17907_17964 = state_17897__$1;
(statearr_17907_17964[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (4))){
var inst_17815 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
if(cljs.core.truth_(inst_17815)){
var statearr_17908_17965 = state_17897__$1;
(statearr_17908_17965[(1)] = (8));

} else {
var statearr_17909_17966 = state_17897__$1;
(statearr_17909_17966[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (15))){
var inst_17842 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
if(cljs.core.truth_(inst_17842)){
var statearr_17910_17967 = state_17897__$1;
(statearr_17910_17967[(1)] = (19));

} else {
var statearr_17911_17968 = state_17897__$1;
(statearr_17911_17968[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (21))){
var inst_17847 = (state_17897[(12)]);
var inst_17847__$1 = (state_17897[(2)]);
var inst_17848 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17847__$1,cljs.core.cst$kw$solos);
var inst_17849 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17847__$1,cljs.core.cst$kw$mutes);
var inst_17850 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17847__$1,cljs.core.cst$kw$reads);
var state_17897__$1 = (function (){var statearr_17912 = state_17897;
(statearr_17912[(12)] = inst_17847__$1);

(statearr_17912[(13)] = inst_17849);

(statearr_17912[(9)] = inst_17848);

return statearr_17912;
})();
return cljs.core.async.ioc_alts_BANG_(state_17897__$1,(22),inst_17850);
} else {
if((state_val_17898 === (31))){
var inst_17879 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
if(cljs.core.truth_(inst_17879)){
var statearr_17913_17969 = state_17897__$1;
(statearr_17913_17969[(1)] = (32));

} else {
var statearr_17914_17970 = state_17897__$1;
(statearr_17914_17970[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (32))){
var inst_17856 = (state_17897[(14)]);
var state_17897__$1 = state_17897;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17897__$1,(35),out,inst_17856);
} else {
if((state_val_17898 === (33))){
var inst_17847 = (state_17897[(12)]);
var inst_17824 = inst_17847;
var state_17897__$1 = (function (){var statearr_17915 = state_17897;
(statearr_17915[(7)] = inst_17824);

return statearr_17915;
})();
var statearr_17916_17971 = state_17897__$1;
(statearr_17916_17971[(2)] = null);

(statearr_17916_17971[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (13))){
var inst_17824 = (state_17897[(7)]);
var inst_17831 = inst_17824.cljs$lang$protocol_mask$partition0$;
var inst_17832 = (inst_17831 & (64));
var inst_17833 = inst_17824.cljs$core$ISeq$;
var inst_17834 = (cljs.core.PROTOCOL_SENTINEL === inst_17833);
var inst_17835 = (inst_17832) || (inst_17834);
var state_17897__$1 = state_17897;
if(cljs.core.truth_(inst_17835)){
var statearr_17917_17972 = state_17897__$1;
(statearr_17917_17972[(1)] = (16));

} else {
var statearr_17918_17973 = state_17897__$1;
(statearr_17918_17973[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (22))){
var inst_17856 = (state_17897[(14)]);
var inst_17857 = (state_17897[(10)]);
var inst_17855 = (state_17897[(2)]);
var inst_17856__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17855,(0),null);
var inst_17857__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17855,(1),null);
var inst_17858 = (inst_17856__$1 == null);
var inst_17859 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17857__$1,change);
var inst_17860 = (inst_17858) || (inst_17859);
var state_17897__$1 = (function (){var statearr_17919 = state_17897;
(statearr_17919[(14)] = inst_17856__$1);

(statearr_17919[(10)] = inst_17857__$1);

return statearr_17919;
})();
if(cljs.core.truth_(inst_17860)){
var statearr_17920_17974 = state_17897__$1;
(statearr_17920_17974[(1)] = (23));

} else {
var statearr_17921_17975 = state_17897__$1;
(statearr_17921_17975[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (36))){
var inst_17847 = (state_17897[(12)]);
var inst_17824 = inst_17847;
var state_17897__$1 = (function (){var statearr_17922 = state_17897;
(statearr_17922[(7)] = inst_17824);

return statearr_17922;
})();
var statearr_17923_17976 = state_17897__$1;
(statearr_17923_17976[(2)] = null);

(statearr_17923_17976[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (29))){
var inst_17871 = (state_17897[(11)]);
var state_17897__$1 = state_17897;
var statearr_17924_17977 = state_17897__$1;
(statearr_17924_17977[(2)] = inst_17871);

(statearr_17924_17977[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (6))){
var state_17897__$1 = state_17897;
var statearr_17925_17978 = state_17897__$1;
(statearr_17925_17978[(2)] = false);

(statearr_17925_17978[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (28))){
var inst_17867 = (state_17897[(2)]);
var inst_17868 = calc_state();
var inst_17824 = inst_17868;
var state_17897__$1 = (function (){var statearr_17926 = state_17897;
(statearr_17926[(7)] = inst_17824);

(statearr_17926[(15)] = inst_17867);

return statearr_17926;
})();
var statearr_17927_17979 = state_17897__$1;
(statearr_17927_17979[(2)] = null);

(statearr_17927_17979[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (25))){
var inst_17893 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
var statearr_17928_17980 = state_17897__$1;
(statearr_17928_17980[(2)] = inst_17893);

(statearr_17928_17980[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (34))){
var inst_17891 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
var statearr_17929_17981 = state_17897__$1;
(statearr_17929_17981[(2)] = inst_17891);

(statearr_17929_17981[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (17))){
var state_17897__$1 = state_17897;
var statearr_17930_17982 = state_17897__$1;
(statearr_17930_17982[(2)] = false);

(statearr_17930_17982[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (3))){
var state_17897__$1 = state_17897;
var statearr_17931_17983 = state_17897__$1;
(statearr_17931_17983[(2)] = false);

(statearr_17931_17983[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (12))){
var inst_17895 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17897__$1,inst_17895);
} else {
if((state_val_17898 === (2))){
var inst_17799 = (state_17897[(8)]);
var inst_17804 = inst_17799.cljs$lang$protocol_mask$partition0$;
var inst_17805 = (inst_17804 & (64));
var inst_17806 = inst_17799.cljs$core$ISeq$;
var inst_17807 = (cljs.core.PROTOCOL_SENTINEL === inst_17806);
var inst_17808 = (inst_17805) || (inst_17807);
var state_17897__$1 = state_17897;
if(cljs.core.truth_(inst_17808)){
var statearr_17932_17984 = state_17897__$1;
(statearr_17932_17984[(1)] = (5));

} else {
var statearr_17933_17985 = state_17897__$1;
(statearr_17933_17985[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (23))){
var inst_17856 = (state_17897[(14)]);
var inst_17862 = (inst_17856 == null);
var state_17897__$1 = state_17897;
if(cljs.core.truth_(inst_17862)){
var statearr_17934_17986 = state_17897__$1;
(statearr_17934_17986[(1)] = (26));

} else {
var statearr_17935_17987 = state_17897__$1;
(statearr_17935_17987[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (35))){
var inst_17882 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
if(cljs.core.truth_(inst_17882)){
var statearr_17936_17988 = state_17897__$1;
(statearr_17936_17988[(1)] = (36));

} else {
var statearr_17937_17989 = state_17897__$1;
(statearr_17937_17989[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (19))){
var inst_17824 = (state_17897[(7)]);
var inst_17844 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17824);
var state_17897__$1 = state_17897;
var statearr_17938_17990 = state_17897__$1;
(statearr_17938_17990[(2)] = inst_17844);

(statearr_17938_17990[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (11))){
var inst_17824 = (state_17897[(7)]);
var inst_17828 = (inst_17824 == null);
var inst_17829 = cljs.core.not(inst_17828);
var state_17897__$1 = state_17897;
if(inst_17829){
var statearr_17939_17991 = state_17897__$1;
(statearr_17939_17991[(1)] = (13));

} else {
var statearr_17940_17992 = state_17897__$1;
(statearr_17940_17992[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (9))){
var inst_17799 = (state_17897[(8)]);
var state_17897__$1 = state_17897;
var statearr_17941_17993 = state_17897__$1;
(statearr_17941_17993[(2)] = inst_17799);

(statearr_17941_17993[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (5))){
var state_17897__$1 = state_17897;
var statearr_17942_17994 = state_17897__$1;
(statearr_17942_17994[(2)] = true);

(statearr_17942_17994[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (14))){
var state_17897__$1 = state_17897;
var statearr_17943_17995 = state_17897__$1;
(statearr_17943_17995[(2)] = false);

(statearr_17943_17995[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (26))){
var inst_17857 = (state_17897[(10)]);
var inst_17864 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_17857);
var state_17897__$1 = state_17897;
var statearr_17944_17996 = state_17897__$1;
(statearr_17944_17996[(2)] = inst_17864);

(statearr_17944_17996[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (16))){
var state_17897__$1 = state_17897;
var statearr_17945_17997 = state_17897__$1;
(statearr_17945_17997[(2)] = true);

(statearr_17945_17997[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (38))){
var inst_17887 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
var statearr_17946_17998 = state_17897__$1;
(statearr_17946_17998[(2)] = inst_17887);

(statearr_17946_17998[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (30))){
var inst_17849 = (state_17897[(13)]);
var inst_17848 = (state_17897[(9)]);
var inst_17857 = (state_17897[(10)]);
var inst_17874 = cljs.core.empty_QMARK_(inst_17848);
var inst_17875 = (inst_17849.cljs$core$IFn$_invoke$arity$1 ? inst_17849.cljs$core$IFn$_invoke$arity$1(inst_17857) : inst_17849.call(null,inst_17857));
var inst_17876 = cljs.core.not(inst_17875);
var inst_17877 = (inst_17874) && (inst_17876);
var state_17897__$1 = state_17897;
var statearr_17947_17999 = state_17897__$1;
(statearr_17947_17999[(2)] = inst_17877);

(statearr_17947_17999[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (10))){
var inst_17799 = (state_17897[(8)]);
var inst_17820 = (state_17897[(2)]);
var inst_17821 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17820,cljs.core.cst$kw$solos);
var inst_17822 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17820,cljs.core.cst$kw$mutes);
var inst_17823 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17820,cljs.core.cst$kw$reads);
var inst_17824 = inst_17799;
var state_17897__$1 = (function (){var statearr_17948 = state_17897;
(statearr_17948[(16)] = inst_17821);

(statearr_17948[(7)] = inst_17824);

(statearr_17948[(17)] = inst_17822);

(statearr_17948[(18)] = inst_17823);

return statearr_17948;
})();
var statearr_17949_18000 = state_17897__$1;
(statearr_17949_18000[(2)] = null);

(statearr_17949_18000[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (18))){
var inst_17839 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
var statearr_17950_18001 = state_17897__$1;
(statearr_17950_18001[(2)] = inst_17839);

(statearr_17950_18001[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (37))){
var state_17897__$1 = state_17897;
var statearr_17951_18002 = state_17897__$1;
(statearr_17951_18002[(2)] = null);

(statearr_17951_18002[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17898 === (8))){
var inst_17799 = (state_17897[(8)]);
var inst_17817 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17799);
var state_17897__$1 = state_17897;
var statearr_17952_18003 = state_17897__$1;
(statearr_17952_18003[(2)] = inst_17817);

(statearr_17952_18003[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___17957,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__16794__auto__,c__16896__auto___17957,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__16795__auto__ = null;
var cljs$core$async$mix_$_state_machine__16795__auto____0 = (function (){
var statearr_17953 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17953[(0)] = cljs$core$async$mix_$_state_machine__16795__auto__);

(statearr_17953[(1)] = (1));

return statearr_17953;
});
var cljs$core$async$mix_$_state_machine__16795__auto____1 = (function (state_17897){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_17897);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e17954){if((e17954 instanceof Object)){
var ex__16798__auto__ = e17954;
var statearr_17955_18004 = state_17897;
(statearr_17955_18004[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17897);

return cljs.core.cst$kw$recur;
} else {
throw e17954;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18005 = state_17897;
state_17897 = G__18005;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16795__auto__ = function(state_17897){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16795__auto____1.call(this,state_17897);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16795__auto____0;
cljs$core$async$mix_$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16795__auto____1;
return cljs$core$async$mix_$_state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___17957,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__16898__auto__ = (function (){var statearr_17956 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_17956[(6)] = c__16896__auto___17957);

return statearr_17956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___17957,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9540__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__9540__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9540__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9540__auto__.call(null,p,v,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9540__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__18007 = arguments.length;
switch (G__18007) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__9540__auto__.call(null,p));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__9540__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__9540__auto__.call(null,p,v));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__9540__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__18011 = arguments.length;
switch (G__18011) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8806__auto__,mults){
return (function (p1__18009_SHARP_){
if(cljs.core.truth_((p1__18009_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18009_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__18009_SHARP_.call(null,topic)))){
return p1__18009_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__18009_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__8806__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async18012 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18012 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18013){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18013 = meta18013;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_18014,meta18013__$1){
var self__ = this;
var _18014__$1 = this;
return (new cljs.core.async.t_cljs$core$async18012(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18013__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_18014){
var self__ = this;
var _18014__$1 = this;
return self__.meta18013;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18012.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta18013], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18012.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18012.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18012";

cljs.core.async.t_cljs$core$async18012.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18012");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async18012 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async18012(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18013){
return (new cljs.core.async.t_cljs$core$async18012(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18013));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async18012(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16896__auto___18132 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___18132,mults,ensure_mult,p){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___18132,mults,ensure_mult,p){
return (function (state_18086){
var state_val_18087 = (state_18086[(1)]);
if((state_val_18087 === (7))){
var inst_18082 = (state_18086[(2)]);
var state_18086__$1 = state_18086;
var statearr_18088_18133 = state_18086__$1;
(statearr_18088_18133[(2)] = inst_18082);

(statearr_18088_18133[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (20))){
var state_18086__$1 = state_18086;
var statearr_18089_18134 = state_18086__$1;
(statearr_18089_18134[(2)] = null);

(statearr_18089_18134[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (1))){
var state_18086__$1 = state_18086;
var statearr_18090_18135 = state_18086__$1;
(statearr_18090_18135[(2)] = null);

(statearr_18090_18135[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (24))){
var inst_18065 = (state_18086[(7)]);
var inst_18074 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_18065);
var state_18086__$1 = state_18086;
var statearr_18091_18136 = state_18086__$1;
(statearr_18091_18136[(2)] = inst_18074);

(statearr_18091_18136[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (4))){
var inst_18017 = (state_18086[(8)]);
var inst_18017__$1 = (state_18086[(2)]);
var inst_18018 = (inst_18017__$1 == null);
var state_18086__$1 = (function (){var statearr_18092 = state_18086;
(statearr_18092[(8)] = inst_18017__$1);

return statearr_18092;
})();
if(cljs.core.truth_(inst_18018)){
var statearr_18093_18137 = state_18086__$1;
(statearr_18093_18137[(1)] = (5));

} else {
var statearr_18094_18138 = state_18086__$1;
(statearr_18094_18138[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (15))){
var inst_18059 = (state_18086[(2)]);
var state_18086__$1 = state_18086;
var statearr_18095_18139 = state_18086__$1;
(statearr_18095_18139[(2)] = inst_18059);

(statearr_18095_18139[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (21))){
var inst_18079 = (state_18086[(2)]);
var state_18086__$1 = (function (){var statearr_18096 = state_18086;
(statearr_18096[(9)] = inst_18079);

return statearr_18096;
})();
var statearr_18097_18140 = state_18086__$1;
(statearr_18097_18140[(2)] = null);

(statearr_18097_18140[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (13))){
var inst_18041 = (state_18086[(10)]);
var inst_18043 = cljs.core.chunked_seq_QMARK_(inst_18041);
var state_18086__$1 = state_18086;
if(inst_18043){
var statearr_18098_18141 = state_18086__$1;
(statearr_18098_18141[(1)] = (16));

} else {
var statearr_18099_18142 = state_18086__$1;
(statearr_18099_18142[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (22))){
var inst_18071 = (state_18086[(2)]);
var state_18086__$1 = state_18086;
if(cljs.core.truth_(inst_18071)){
var statearr_18100_18143 = state_18086__$1;
(statearr_18100_18143[(1)] = (23));

} else {
var statearr_18101_18144 = state_18086__$1;
(statearr_18101_18144[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (6))){
var inst_18017 = (state_18086[(8)]);
var inst_18065 = (state_18086[(7)]);
var inst_18067 = (state_18086[(11)]);
var inst_18065__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_18017) : topic_fn.call(null,inst_18017));
var inst_18066 = cljs.core.deref(mults);
var inst_18067__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18066,inst_18065__$1);
var state_18086__$1 = (function (){var statearr_18102 = state_18086;
(statearr_18102[(7)] = inst_18065__$1);

(statearr_18102[(11)] = inst_18067__$1);

return statearr_18102;
})();
if(cljs.core.truth_(inst_18067__$1)){
var statearr_18103_18145 = state_18086__$1;
(statearr_18103_18145[(1)] = (19));

} else {
var statearr_18104_18146 = state_18086__$1;
(statearr_18104_18146[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (25))){
var inst_18076 = (state_18086[(2)]);
var state_18086__$1 = state_18086;
var statearr_18105_18147 = state_18086__$1;
(statearr_18105_18147[(2)] = inst_18076);

(statearr_18105_18147[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (17))){
var inst_18041 = (state_18086[(10)]);
var inst_18050 = cljs.core.first(inst_18041);
var inst_18051 = cljs.core.async.muxch_STAR_(inst_18050);
var inst_18052 = cljs.core.async.close_BANG_(inst_18051);
var inst_18053 = cljs.core.next(inst_18041);
var inst_18027 = inst_18053;
var inst_18028 = null;
var inst_18029 = (0);
var inst_18030 = (0);
var state_18086__$1 = (function (){var statearr_18106 = state_18086;
(statearr_18106[(12)] = inst_18052);

(statearr_18106[(13)] = inst_18030);

(statearr_18106[(14)] = inst_18027);

(statearr_18106[(15)] = inst_18028);

(statearr_18106[(16)] = inst_18029);

return statearr_18106;
})();
var statearr_18107_18148 = state_18086__$1;
(statearr_18107_18148[(2)] = null);

(statearr_18107_18148[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (3))){
var inst_18084 = (state_18086[(2)]);
var state_18086__$1 = state_18086;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18086__$1,inst_18084);
} else {
if((state_val_18087 === (12))){
var inst_18061 = (state_18086[(2)]);
var state_18086__$1 = state_18086;
var statearr_18108_18149 = state_18086__$1;
(statearr_18108_18149[(2)] = inst_18061);

(statearr_18108_18149[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (2))){
var state_18086__$1 = state_18086;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18086__$1,(4),ch);
} else {
if((state_val_18087 === (23))){
var state_18086__$1 = state_18086;
var statearr_18109_18150 = state_18086__$1;
(statearr_18109_18150[(2)] = null);

(statearr_18109_18150[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (19))){
var inst_18017 = (state_18086[(8)]);
var inst_18067 = (state_18086[(11)]);
var inst_18069 = cljs.core.async.muxch_STAR_(inst_18067);
var state_18086__$1 = state_18086;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18086__$1,(22),inst_18069,inst_18017);
} else {
if((state_val_18087 === (11))){
var inst_18027 = (state_18086[(14)]);
var inst_18041 = (state_18086[(10)]);
var inst_18041__$1 = cljs.core.seq(inst_18027);
var state_18086__$1 = (function (){var statearr_18110 = state_18086;
(statearr_18110[(10)] = inst_18041__$1);

return statearr_18110;
})();
if(inst_18041__$1){
var statearr_18111_18151 = state_18086__$1;
(statearr_18111_18151[(1)] = (13));

} else {
var statearr_18112_18152 = state_18086__$1;
(statearr_18112_18152[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (9))){
var inst_18063 = (state_18086[(2)]);
var state_18086__$1 = state_18086;
var statearr_18113_18153 = state_18086__$1;
(statearr_18113_18153[(2)] = inst_18063);

(statearr_18113_18153[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (5))){
var inst_18024 = cljs.core.deref(mults);
var inst_18025 = cljs.core.vals(inst_18024);
var inst_18026 = cljs.core.seq(inst_18025);
var inst_18027 = inst_18026;
var inst_18028 = null;
var inst_18029 = (0);
var inst_18030 = (0);
var state_18086__$1 = (function (){var statearr_18114 = state_18086;
(statearr_18114[(13)] = inst_18030);

(statearr_18114[(14)] = inst_18027);

(statearr_18114[(15)] = inst_18028);

(statearr_18114[(16)] = inst_18029);

return statearr_18114;
})();
var statearr_18115_18154 = state_18086__$1;
(statearr_18115_18154[(2)] = null);

(statearr_18115_18154[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (14))){
var state_18086__$1 = state_18086;
var statearr_18119_18155 = state_18086__$1;
(statearr_18119_18155[(2)] = null);

(statearr_18119_18155[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (16))){
var inst_18041 = (state_18086[(10)]);
var inst_18045 = cljs.core.chunk_first(inst_18041);
var inst_18046 = cljs.core.chunk_rest(inst_18041);
var inst_18047 = cljs.core.count(inst_18045);
var inst_18027 = inst_18046;
var inst_18028 = inst_18045;
var inst_18029 = inst_18047;
var inst_18030 = (0);
var state_18086__$1 = (function (){var statearr_18120 = state_18086;
(statearr_18120[(13)] = inst_18030);

(statearr_18120[(14)] = inst_18027);

(statearr_18120[(15)] = inst_18028);

(statearr_18120[(16)] = inst_18029);

return statearr_18120;
})();
var statearr_18121_18156 = state_18086__$1;
(statearr_18121_18156[(2)] = null);

(statearr_18121_18156[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (10))){
var inst_18030 = (state_18086[(13)]);
var inst_18027 = (state_18086[(14)]);
var inst_18028 = (state_18086[(15)]);
var inst_18029 = (state_18086[(16)]);
var inst_18035 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18028,inst_18030);
var inst_18036 = cljs.core.async.muxch_STAR_(inst_18035);
var inst_18037 = cljs.core.async.close_BANG_(inst_18036);
var inst_18038 = (inst_18030 + (1));
var tmp18116 = inst_18027;
var tmp18117 = inst_18028;
var tmp18118 = inst_18029;
var inst_18027__$1 = tmp18116;
var inst_18028__$1 = tmp18117;
var inst_18029__$1 = tmp18118;
var inst_18030__$1 = inst_18038;
var state_18086__$1 = (function (){var statearr_18122 = state_18086;
(statearr_18122[(17)] = inst_18037);

(statearr_18122[(13)] = inst_18030__$1);

(statearr_18122[(14)] = inst_18027__$1);

(statearr_18122[(15)] = inst_18028__$1);

(statearr_18122[(16)] = inst_18029__$1);

return statearr_18122;
})();
var statearr_18123_18157 = state_18086__$1;
(statearr_18123_18157[(2)] = null);

(statearr_18123_18157[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (18))){
var inst_18056 = (state_18086[(2)]);
var state_18086__$1 = state_18086;
var statearr_18124_18158 = state_18086__$1;
(statearr_18124_18158[(2)] = inst_18056);

(statearr_18124_18158[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18087 === (8))){
var inst_18030 = (state_18086[(13)]);
var inst_18029 = (state_18086[(16)]);
var inst_18032 = (inst_18030 < inst_18029);
var inst_18033 = inst_18032;
var state_18086__$1 = state_18086;
if(cljs.core.truth_(inst_18033)){
var statearr_18125_18159 = state_18086__$1;
(statearr_18125_18159[(1)] = (10));

} else {
var statearr_18126_18160 = state_18086__$1;
(statearr_18126_18160[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___18132,mults,ensure_mult,p))
;
return ((function (switch__16794__auto__,c__16896__auto___18132,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_18127 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18127[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_18127[(1)] = (1));

return statearr_18127;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_18086){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18086);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18128){if((e18128 instanceof Object)){
var ex__16798__auto__ = e18128;
var statearr_18129_18161 = state_18086;
(statearr_18129_18161[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18086);

return cljs.core.cst$kw$recur;
} else {
throw e18128;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18162 = state_18086;
state_18086 = G__18162;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_18086){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_18086);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___18132,mults,ensure_mult,p))
})();
var state__16898__auto__ = (function (){var statearr_18130 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18130[(6)] = c__16896__auto___18132);

return statearr_18130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___18132,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__18164 = arguments.length;
switch (G__18164) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__18167 = arguments.length;
switch (G__18167) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__18170 = arguments.length;
switch (G__18170) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__16896__auto___18237 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___18237,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___18237,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_18209){
var state_val_18210 = (state_18209[(1)]);
if((state_val_18210 === (7))){
var state_18209__$1 = state_18209;
var statearr_18211_18238 = state_18209__$1;
(statearr_18211_18238[(2)] = null);

(statearr_18211_18238[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (1))){
var state_18209__$1 = state_18209;
var statearr_18212_18239 = state_18209__$1;
(statearr_18212_18239[(2)] = null);

(statearr_18212_18239[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (4))){
var inst_18173 = (state_18209[(7)]);
var inst_18175 = (inst_18173 < cnt);
var state_18209__$1 = state_18209;
if(cljs.core.truth_(inst_18175)){
var statearr_18213_18240 = state_18209__$1;
(statearr_18213_18240[(1)] = (6));

} else {
var statearr_18214_18241 = state_18209__$1;
(statearr_18214_18241[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (15))){
var inst_18205 = (state_18209[(2)]);
var state_18209__$1 = state_18209;
var statearr_18215_18242 = state_18209__$1;
(statearr_18215_18242[(2)] = inst_18205);

(statearr_18215_18242[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (13))){
var inst_18198 = cljs.core.async.close_BANG_(out);
var state_18209__$1 = state_18209;
var statearr_18216_18243 = state_18209__$1;
(statearr_18216_18243[(2)] = inst_18198);

(statearr_18216_18243[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (6))){
var state_18209__$1 = state_18209;
var statearr_18217_18244 = state_18209__$1;
(statearr_18217_18244[(2)] = null);

(statearr_18217_18244[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (3))){
var inst_18207 = (state_18209[(2)]);
var state_18209__$1 = state_18209;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18209__$1,inst_18207);
} else {
if((state_val_18210 === (12))){
var inst_18195 = (state_18209[(8)]);
var inst_18195__$1 = (state_18209[(2)]);
var inst_18196 = cljs.core.some(cljs.core.nil_QMARK_,inst_18195__$1);
var state_18209__$1 = (function (){var statearr_18218 = state_18209;
(statearr_18218[(8)] = inst_18195__$1);

return statearr_18218;
})();
if(cljs.core.truth_(inst_18196)){
var statearr_18219_18245 = state_18209__$1;
(statearr_18219_18245[(1)] = (13));

} else {
var statearr_18220_18246 = state_18209__$1;
(statearr_18220_18246[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (2))){
var inst_18172 = cljs.core.reset_BANG_(dctr,cnt);
var inst_18173 = (0);
var state_18209__$1 = (function (){var statearr_18221 = state_18209;
(statearr_18221[(7)] = inst_18173);

(statearr_18221[(9)] = inst_18172);

return statearr_18221;
})();
var statearr_18222_18247 = state_18209__$1;
(statearr_18222_18247[(2)] = null);

(statearr_18222_18247[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (11))){
var inst_18173 = (state_18209[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_18209,(10),Object,null,(9));
var inst_18182 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_18173) : chs__$1.call(null,inst_18173));
var inst_18183 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_18173) : done.call(null,inst_18173));
var inst_18184 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18182,inst_18183);
var state_18209__$1 = state_18209;
var statearr_18223_18248 = state_18209__$1;
(statearr_18223_18248[(2)] = inst_18184);


cljs.core.async.impl.ioc_helpers.process_exception(state_18209__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (9))){
var inst_18173 = (state_18209[(7)]);
var inst_18186 = (state_18209[(2)]);
var inst_18187 = (inst_18173 + (1));
var inst_18173__$1 = inst_18187;
var state_18209__$1 = (function (){var statearr_18224 = state_18209;
(statearr_18224[(7)] = inst_18173__$1);

(statearr_18224[(10)] = inst_18186);

return statearr_18224;
})();
var statearr_18225_18249 = state_18209__$1;
(statearr_18225_18249[(2)] = null);

(statearr_18225_18249[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (5))){
var inst_18193 = (state_18209[(2)]);
var state_18209__$1 = (function (){var statearr_18226 = state_18209;
(statearr_18226[(11)] = inst_18193);

return statearr_18226;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18209__$1,(12),dchan);
} else {
if((state_val_18210 === (14))){
var inst_18195 = (state_18209[(8)]);
var inst_18200 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_18195);
var state_18209__$1 = state_18209;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18209__$1,(16),out,inst_18200);
} else {
if((state_val_18210 === (16))){
var inst_18202 = (state_18209[(2)]);
var state_18209__$1 = (function (){var statearr_18227 = state_18209;
(statearr_18227[(12)] = inst_18202);

return statearr_18227;
})();
var statearr_18228_18250 = state_18209__$1;
(statearr_18228_18250[(2)] = null);

(statearr_18228_18250[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (10))){
var inst_18177 = (state_18209[(2)]);
var inst_18178 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_18209__$1 = (function (){var statearr_18229 = state_18209;
(statearr_18229[(13)] = inst_18177);

return statearr_18229;
})();
var statearr_18230_18251 = state_18209__$1;
(statearr_18230_18251[(2)] = inst_18178);


cljs.core.async.impl.ioc_helpers.process_exception(state_18209__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18210 === (8))){
var inst_18191 = (state_18209[(2)]);
var state_18209__$1 = state_18209;
var statearr_18231_18252 = state_18209__$1;
(statearr_18231_18252[(2)] = inst_18191);

(statearr_18231_18252[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___18237,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16794__auto__,c__16896__auto___18237,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_18232 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18232[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_18232[(1)] = (1));

return statearr_18232;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_18209){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18209);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18233){if((e18233 instanceof Object)){
var ex__16798__auto__ = e18233;
var statearr_18234_18253 = state_18209;
(statearr_18234_18253[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18209);

return cljs.core.cst$kw$recur;
} else {
throw e18233;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18254 = state_18209;
state_18209 = G__18254;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_18209){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_18209);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___18237,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16898__auto__ = (function (){var statearr_18235 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18235[(6)] = c__16896__auto___18237);

return statearr_18235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___18237,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__18257 = arguments.length;
switch (G__18257) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16896__auto___18311 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___18311,out){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___18311,out){
return (function (state_18289){
var state_val_18290 = (state_18289[(1)]);
if((state_val_18290 === (7))){
var inst_18269 = (state_18289[(7)]);
var inst_18268 = (state_18289[(8)]);
var inst_18268__$1 = (state_18289[(2)]);
var inst_18269__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18268__$1,(0),null);
var inst_18270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18268__$1,(1),null);
var inst_18271 = (inst_18269__$1 == null);
var state_18289__$1 = (function (){var statearr_18291 = state_18289;
(statearr_18291[(7)] = inst_18269__$1);

(statearr_18291[(8)] = inst_18268__$1);

(statearr_18291[(9)] = inst_18270);

return statearr_18291;
})();
if(cljs.core.truth_(inst_18271)){
var statearr_18292_18312 = state_18289__$1;
(statearr_18292_18312[(1)] = (8));

} else {
var statearr_18293_18313 = state_18289__$1;
(statearr_18293_18313[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18290 === (1))){
var inst_18258 = cljs.core.vec(chs);
var inst_18259 = inst_18258;
var state_18289__$1 = (function (){var statearr_18294 = state_18289;
(statearr_18294[(10)] = inst_18259);

return statearr_18294;
})();
var statearr_18295_18314 = state_18289__$1;
(statearr_18295_18314[(2)] = null);

(statearr_18295_18314[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18290 === (4))){
var inst_18259 = (state_18289[(10)]);
var state_18289__$1 = state_18289;
return cljs.core.async.ioc_alts_BANG_(state_18289__$1,(7),inst_18259);
} else {
if((state_val_18290 === (6))){
var inst_18285 = (state_18289[(2)]);
var state_18289__$1 = state_18289;
var statearr_18296_18315 = state_18289__$1;
(statearr_18296_18315[(2)] = inst_18285);

(statearr_18296_18315[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18290 === (3))){
var inst_18287 = (state_18289[(2)]);
var state_18289__$1 = state_18289;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18289__$1,inst_18287);
} else {
if((state_val_18290 === (2))){
var inst_18259 = (state_18289[(10)]);
var inst_18261 = cljs.core.count(inst_18259);
var inst_18262 = (inst_18261 > (0));
var state_18289__$1 = state_18289;
if(cljs.core.truth_(inst_18262)){
var statearr_18298_18316 = state_18289__$1;
(statearr_18298_18316[(1)] = (4));

} else {
var statearr_18299_18317 = state_18289__$1;
(statearr_18299_18317[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18290 === (11))){
var inst_18259 = (state_18289[(10)]);
var inst_18278 = (state_18289[(2)]);
var tmp18297 = inst_18259;
var inst_18259__$1 = tmp18297;
var state_18289__$1 = (function (){var statearr_18300 = state_18289;
(statearr_18300[(11)] = inst_18278);

(statearr_18300[(10)] = inst_18259__$1);

return statearr_18300;
})();
var statearr_18301_18318 = state_18289__$1;
(statearr_18301_18318[(2)] = null);

(statearr_18301_18318[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18290 === (9))){
var inst_18269 = (state_18289[(7)]);
var state_18289__$1 = state_18289;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18289__$1,(11),out,inst_18269);
} else {
if((state_val_18290 === (5))){
var inst_18283 = cljs.core.async.close_BANG_(out);
var state_18289__$1 = state_18289;
var statearr_18302_18319 = state_18289__$1;
(statearr_18302_18319[(2)] = inst_18283);

(statearr_18302_18319[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18290 === (10))){
var inst_18281 = (state_18289[(2)]);
var state_18289__$1 = state_18289;
var statearr_18303_18320 = state_18289__$1;
(statearr_18303_18320[(2)] = inst_18281);

(statearr_18303_18320[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18290 === (8))){
var inst_18269 = (state_18289[(7)]);
var inst_18268 = (state_18289[(8)]);
var inst_18259 = (state_18289[(10)]);
var inst_18270 = (state_18289[(9)]);
var inst_18273 = (function (){var cs = inst_18259;
var vec__18264 = inst_18268;
var v = inst_18269;
var c = inst_18270;
return ((function (cs,vec__18264,v,c,inst_18269,inst_18268,inst_18259,inst_18270,state_val_18290,c__16896__auto___18311,out){
return (function (p1__18255_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__18255_SHARP_);
});
;})(cs,vec__18264,v,c,inst_18269,inst_18268,inst_18259,inst_18270,state_val_18290,c__16896__auto___18311,out))
})();
var inst_18274 = cljs.core.filterv(inst_18273,inst_18259);
var inst_18259__$1 = inst_18274;
var state_18289__$1 = (function (){var statearr_18304 = state_18289;
(statearr_18304[(10)] = inst_18259__$1);

return statearr_18304;
})();
var statearr_18305_18321 = state_18289__$1;
(statearr_18305_18321[(2)] = null);

(statearr_18305_18321[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___18311,out))
;
return ((function (switch__16794__auto__,c__16896__auto___18311,out){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_18306 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18306[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_18306[(1)] = (1));

return statearr_18306;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_18289){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18289);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18307){if((e18307 instanceof Object)){
var ex__16798__auto__ = e18307;
var statearr_18308_18322 = state_18289;
(statearr_18308_18322[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18289);

return cljs.core.cst$kw$recur;
} else {
throw e18307;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18323 = state_18289;
state_18289 = G__18323;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_18289){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_18289);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___18311,out))
})();
var state__16898__auto__ = (function (){var statearr_18309 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18309[(6)] = c__16896__auto___18311);

return statearr_18309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___18311,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__18325 = arguments.length;
switch (G__18325) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16896__auto___18370 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___18370,out){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___18370,out){
return (function (state_18349){
var state_val_18350 = (state_18349[(1)]);
if((state_val_18350 === (7))){
var inst_18331 = (state_18349[(7)]);
var inst_18331__$1 = (state_18349[(2)]);
var inst_18332 = (inst_18331__$1 == null);
var inst_18333 = cljs.core.not(inst_18332);
var state_18349__$1 = (function (){var statearr_18351 = state_18349;
(statearr_18351[(7)] = inst_18331__$1);

return statearr_18351;
})();
if(inst_18333){
var statearr_18352_18371 = state_18349__$1;
(statearr_18352_18371[(1)] = (8));

} else {
var statearr_18353_18372 = state_18349__$1;
(statearr_18353_18372[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18350 === (1))){
var inst_18326 = (0);
var state_18349__$1 = (function (){var statearr_18354 = state_18349;
(statearr_18354[(8)] = inst_18326);

return statearr_18354;
})();
var statearr_18355_18373 = state_18349__$1;
(statearr_18355_18373[(2)] = null);

(statearr_18355_18373[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18350 === (4))){
var state_18349__$1 = state_18349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18349__$1,(7),ch);
} else {
if((state_val_18350 === (6))){
var inst_18344 = (state_18349[(2)]);
var state_18349__$1 = state_18349;
var statearr_18356_18374 = state_18349__$1;
(statearr_18356_18374[(2)] = inst_18344);

(statearr_18356_18374[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18350 === (3))){
var inst_18346 = (state_18349[(2)]);
var inst_18347 = cljs.core.async.close_BANG_(out);
var state_18349__$1 = (function (){var statearr_18357 = state_18349;
(statearr_18357[(9)] = inst_18346);

return statearr_18357;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18349__$1,inst_18347);
} else {
if((state_val_18350 === (2))){
var inst_18326 = (state_18349[(8)]);
var inst_18328 = (inst_18326 < n);
var state_18349__$1 = state_18349;
if(cljs.core.truth_(inst_18328)){
var statearr_18358_18375 = state_18349__$1;
(statearr_18358_18375[(1)] = (4));

} else {
var statearr_18359_18376 = state_18349__$1;
(statearr_18359_18376[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18350 === (11))){
var inst_18326 = (state_18349[(8)]);
var inst_18336 = (state_18349[(2)]);
var inst_18337 = (inst_18326 + (1));
var inst_18326__$1 = inst_18337;
var state_18349__$1 = (function (){var statearr_18360 = state_18349;
(statearr_18360[(10)] = inst_18336);

(statearr_18360[(8)] = inst_18326__$1);

return statearr_18360;
})();
var statearr_18361_18377 = state_18349__$1;
(statearr_18361_18377[(2)] = null);

(statearr_18361_18377[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18350 === (9))){
var state_18349__$1 = state_18349;
var statearr_18362_18378 = state_18349__$1;
(statearr_18362_18378[(2)] = null);

(statearr_18362_18378[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18350 === (5))){
var state_18349__$1 = state_18349;
var statearr_18363_18379 = state_18349__$1;
(statearr_18363_18379[(2)] = null);

(statearr_18363_18379[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18350 === (10))){
var inst_18341 = (state_18349[(2)]);
var state_18349__$1 = state_18349;
var statearr_18364_18380 = state_18349__$1;
(statearr_18364_18380[(2)] = inst_18341);

(statearr_18364_18380[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18350 === (8))){
var inst_18331 = (state_18349[(7)]);
var state_18349__$1 = state_18349;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18349__$1,(11),out,inst_18331);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___18370,out))
;
return ((function (switch__16794__auto__,c__16896__auto___18370,out){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_18365 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18365[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_18365[(1)] = (1));

return statearr_18365;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_18349){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18349);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18366){if((e18366 instanceof Object)){
var ex__16798__auto__ = e18366;
var statearr_18367_18381 = state_18349;
(statearr_18367_18381[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18349);

return cljs.core.cst$kw$recur;
} else {
throw e18366;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18382 = state_18349;
state_18349 = G__18382;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_18349){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_18349);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___18370,out))
})();
var state__16898__auto__ = (function (){var statearr_18368 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18368[(6)] = c__16896__auto___18370);

return statearr_18368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___18370,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18384 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18384 = (function (f,ch,meta18385){
this.f = f;
this.ch = ch;
this.meta18385 = meta18385;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18386,meta18385__$1){
var self__ = this;
var _18386__$1 = this;
return (new cljs.core.async.t_cljs$core$async18384(self__.f,self__.ch,meta18385__$1));
});

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18386){
var self__ = this;
var _18386__$1 = this;
return self__.meta18385;
});

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async18387 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18387 = (function (f,ch,meta18385,_,fn1,meta18388){
this.f = f;
this.ch = ch;
this.meta18385 = meta18385;
this._ = _;
this.fn1 = fn1;
this.meta18388 = meta18388;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_18389,meta18388__$1){
var self__ = this;
var _18389__$1 = this;
return (new cljs.core.async.t_cljs$core$async18387(self__.f,self__.ch,self__.meta18385,self__._,self__.fn1,meta18388__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_18389){
var self__ = this;
var _18389__$1 = this;
return self__.meta18388;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__18383_SHARP_){
var G__18390 = (((p1__18383_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__18383_SHARP_) : self__.f.call(null,p1__18383_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__18390) : f1.call(null,G__18390));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async18387.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18385,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async18384], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta18388], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18387.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18387.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18387";

cljs.core.async.t_cljs$core$async18387.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18387");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async18387 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18387(f__$1,ch__$1,meta18385__$1,___$2,fn1__$1,meta18388){
return (new cljs.core.async.t_cljs$core$async18387(f__$1,ch__$1,meta18385__$1,___$2,fn1__$1,meta18388));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async18387(self__.f,self__.ch,self__.meta18385,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8794__auto__ = ret;
if(cljs.core.truth_(and__8794__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__8794__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__18391 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__18391) : self__.f.call(null,G__18391));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18384.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async18384.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18385], null);
});

cljs.core.async.t_cljs$core$async18384.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18384.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18384";

cljs.core.async.t_cljs$core$async18384.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18384");
});

cljs.core.async.__GT_t_cljs$core$async18384 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18384(f__$1,ch__$1,meta18385){
return (new cljs.core.async.t_cljs$core$async18384(f__$1,ch__$1,meta18385));
});

}

return (new cljs.core.async.t_cljs$core$async18384(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18392 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18392 = (function (f,ch,meta18393){
this.f = f;
this.ch = ch;
this.meta18393 = meta18393;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18394,meta18393__$1){
var self__ = this;
var _18394__$1 = this;
return (new cljs.core.async.t_cljs$core$async18392(self__.f,self__.ch,meta18393__$1));
});

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18394){
var self__ = this;
var _18394__$1 = this;
return self__.meta18393;
});

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18392.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async18392.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18393], null);
});

cljs.core.async.t_cljs$core$async18392.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18392.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18392";

cljs.core.async.t_cljs$core$async18392.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18392");
});

cljs.core.async.__GT_t_cljs$core$async18392 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async18392(f__$1,ch__$1,meta18393){
return (new cljs.core.async.t_cljs$core$async18392(f__$1,ch__$1,meta18393));
});

}

return (new cljs.core.async.t_cljs$core$async18392(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async18395 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18395 = (function (p,ch,meta18396){
this.p = p;
this.ch = ch;
this.meta18396 = meta18396;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18395.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18397,meta18396__$1){
var self__ = this;
var _18397__$1 = this;
return (new cljs.core.async.t_cljs$core$async18395(self__.p,self__.ch,meta18396__$1));
});

cljs.core.async.t_cljs$core$async18395.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18397){
var self__ = this;
var _18397__$1 = this;
return self__.meta18396;
});

cljs.core.async.t_cljs$core$async18395.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18395.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18395.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async18395.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18395.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18395.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18395.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async18395.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18396], null);
});

cljs.core.async.t_cljs$core$async18395.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18395.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18395";

cljs.core.async.t_cljs$core$async18395.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18395");
});

cljs.core.async.__GT_t_cljs$core$async18395 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async18395(p__$1,ch__$1,meta18396){
return (new cljs.core.async.t_cljs$core$async18395(p__$1,ch__$1,meta18396));
});

}

return (new cljs.core.async.t_cljs$core$async18395(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__18399 = arguments.length;
switch (G__18399) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16896__auto___18439 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___18439,out){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___18439,out){
return (function (state_18420){
var state_val_18421 = (state_18420[(1)]);
if((state_val_18421 === (7))){
var inst_18416 = (state_18420[(2)]);
var state_18420__$1 = state_18420;
var statearr_18422_18440 = state_18420__$1;
(statearr_18422_18440[(2)] = inst_18416);

(statearr_18422_18440[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18421 === (1))){
var state_18420__$1 = state_18420;
var statearr_18423_18441 = state_18420__$1;
(statearr_18423_18441[(2)] = null);

(statearr_18423_18441[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18421 === (4))){
var inst_18402 = (state_18420[(7)]);
var inst_18402__$1 = (state_18420[(2)]);
var inst_18403 = (inst_18402__$1 == null);
var state_18420__$1 = (function (){var statearr_18424 = state_18420;
(statearr_18424[(7)] = inst_18402__$1);

return statearr_18424;
})();
if(cljs.core.truth_(inst_18403)){
var statearr_18425_18442 = state_18420__$1;
(statearr_18425_18442[(1)] = (5));

} else {
var statearr_18426_18443 = state_18420__$1;
(statearr_18426_18443[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18421 === (6))){
var inst_18402 = (state_18420[(7)]);
var inst_18407 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_18402) : p.call(null,inst_18402));
var state_18420__$1 = state_18420;
if(cljs.core.truth_(inst_18407)){
var statearr_18427_18444 = state_18420__$1;
(statearr_18427_18444[(1)] = (8));

} else {
var statearr_18428_18445 = state_18420__$1;
(statearr_18428_18445[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18421 === (3))){
var inst_18418 = (state_18420[(2)]);
var state_18420__$1 = state_18420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18420__$1,inst_18418);
} else {
if((state_val_18421 === (2))){
var state_18420__$1 = state_18420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18420__$1,(4),ch);
} else {
if((state_val_18421 === (11))){
var inst_18410 = (state_18420[(2)]);
var state_18420__$1 = state_18420;
var statearr_18429_18446 = state_18420__$1;
(statearr_18429_18446[(2)] = inst_18410);

(statearr_18429_18446[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18421 === (9))){
var state_18420__$1 = state_18420;
var statearr_18430_18447 = state_18420__$1;
(statearr_18430_18447[(2)] = null);

(statearr_18430_18447[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18421 === (5))){
var inst_18405 = cljs.core.async.close_BANG_(out);
var state_18420__$1 = state_18420;
var statearr_18431_18448 = state_18420__$1;
(statearr_18431_18448[(2)] = inst_18405);

(statearr_18431_18448[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18421 === (10))){
var inst_18413 = (state_18420[(2)]);
var state_18420__$1 = (function (){var statearr_18432 = state_18420;
(statearr_18432[(8)] = inst_18413);

return statearr_18432;
})();
var statearr_18433_18449 = state_18420__$1;
(statearr_18433_18449[(2)] = null);

(statearr_18433_18449[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18421 === (8))){
var inst_18402 = (state_18420[(7)]);
var state_18420__$1 = state_18420;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18420__$1,(11),out,inst_18402);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___18439,out))
;
return ((function (switch__16794__auto__,c__16896__auto___18439,out){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_18434 = [null,null,null,null,null,null,null,null,null];
(statearr_18434[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_18434[(1)] = (1));

return statearr_18434;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_18420){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18420);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18435){if((e18435 instanceof Object)){
var ex__16798__auto__ = e18435;
var statearr_18436_18450 = state_18420;
(statearr_18436_18450[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18420);

return cljs.core.cst$kw$recur;
} else {
throw e18435;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18451 = state_18420;
state_18420 = G__18451;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_18420){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_18420);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___18439,out))
})();
var state__16898__auto__ = (function (){var statearr_18437 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18437[(6)] = c__16896__auto___18439);

return statearr_18437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___18439,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__18453 = arguments.length;
switch (G__18453) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16896__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto__){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto__){
return (function (state_18516){
var state_val_18517 = (state_18516[(1)]);
if((state_val_18517 === (7))){
var inst_18512 = (state_18516[(2)]);
var state_18516__$1 = state_18516;
var statearr_18518_18556 = state_18516__$1;
(statearr_18518_18556[(2)] = inst_18512);

(statearr_18518_18556[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (20))){
var inst_18482 = (state_18516[(7)]);
var inst_18493 = (state_18516[(2)]);
var inst_18494 = cljs.core.next(inst_18482);
var inst_18468 = inst_18494;
var inst_18469 = null;
var inst_18470 = (0);
var inst_18471 = (0);
var state_18516__$1 = (function (){var statearr_18519 = state_18516;
(statearr_18519[(8)] = inst_18493);

(statearr_18519[(9)] = inst_18469);

(statearr_18519[(10)] = inst_18471);

(statearr_18519[(11)] = inst_18468);

(statearr_18519[(12)] = inst_18470);

return statearr_18519;
})();
var statearr_18520_18557 = state_18516__$1;
(statearr_18520_18557[(2)] = null);

(statearr_18520_18557[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (1))){
var state_18516__$1 = state_18516;
var statearr_18521_18558 = state_18516__$1;
(statearr_18521_18558[(2)] = null);

(statearr_18521_18558[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (4))){
var inst_18457 = (state_18516[(13)]);
var inst_18457__$1 = (state_18516[(2)]);
var inst_18458 = (inst_18457__$1 == null);
var state_18516__$1 = (function (){var statearr_18522 = state_18516;
(statearr_18522[(13)] = inst_18457__$1);

return statearr_18522;
})();
if(cljs.core.truth_(inst_18458)){
var statearr_18523_18559 = state_18516__$1;
(statearr_18523_18559[(1)] = (5));

} else {
var statearr_18524_18560 = state_18516__$1;
(statearr_18524_18560[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (15))){
var state_18516__$1 = state_18516;
var statearr_18528_18561 = state_18516__$1;
(statearr_18528_18561[(2)] = null);

(statearr_18528_18561[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (21))){
var state_18516__$1 = state_18516;
var statearr_18529_18562 = state_18516__$1;
(statearr_18529_18562[(2)] = null);

(statearr_18529_18562[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (13))){
var inst_18469 = (state_18516[(9)]);
var inst_18471 = (state_18516[(10)]);
var inst_18468 = (state_18516[(11)]);
var inst_18470 = (state_18516[(12)]);
var inst_18478 = (state_18516[(2)]);
var inst_18479 = (inst_18471 + (1));
var tmp18525 = inst_18469;
var tmp18526 = inst_18468;
var tmp18527 = inst_18470;
var inst_18468__$1 = tmp18526;
var inst_18469__$1 = tmp18525;
var inst_18470__$1 = tmp18527;
var inst_18471__$1 = inst_18479;
var state_18516__$1 = (function (){var statearr_18530 = state_18516;
(statearr_18530[(9)] = inst_18469__$1);

(statearr_18530[(10)] = inst_18471__$1);

(statearr_18530[(11)] = inst_18468__$1);

(statearr_18530[(14)] = inst_18478);

(statearr_18530[(12)] = inst_18470__$1);

return statearr_18530;
})();
var statearr_18531_18563 = state_18516__$1;
(statearr_18531_18563[(2)] = null);

(statearr_18531_18563[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (22))){
var state_18516__$1 = state_18516;
var statearr_18532_18564 = state_18516__$1;
(statearr_18532_18564[(2)] = null);

(statearr_18532_18564[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (6))){
var inst_18457 = (state_18516[(13)]);
var inst_18466 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18457) : f.call(null,inst_18457));
var inst_18467 = cljs.core.seq(inst_18466);
var inst_18468 = inst_18467;
var inst_18469 = null;
var inst_18470 = (0);
var inst_18471 = (0);
var state_18516__$1 = (function (){var statearr_18533 = state_18516;
(statearr_18533[(9)] = inst_18469);

(statearr_18533[(10)] = inst_18471);

(statearr_18533[(11)] = inst_18468);

(statearr_18533[(12)] = inst_18470);

return statearr_18533;
})();
var statearr_18534_18565 = state_18516__$1;
(statearr_18534_18565[(2)] = null);

(statearr_18534_18565[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (17))){
var inst_18482 = (state_18516[(7)]);
var inst_18486 = cljs.core.chunk_first(inst_18482);
var inst_18487 = cljs.core.chunk_rest(inst_18482);
var inst_18488 = cljs.core.count(inst_18486);
var inst_18468 = inst_18487;
var inst_18469 = inst_18486;
var inst_18470 = inst_18488;
var inst_18471 = (0);
var state_18516__$1 = (function (){var statearr_18535 = state_18516;
(statearr_18535[(9)] = inst_18469);

(statearr_18535[(10)] = inst_18471);

(statearr_18535[(11)] = inst_18468);

(statearr_18535[(12)] = inst_18470);

return statearr_18535;
})();
var statearr_18536_18566 = state_18516__$1;
(statearr_18536_18566[(2)] = null);

(statearr_18536_18566[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (3))){
var inst_18514 = (state_18516[(2)]);
var state_18516__$1 = state_18516;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18516__$1,inst_18514);
} else {
if((state_val_18517 === (12))){
var inst_18502 = (state_18516[(2)]);
var state_18516__$1 = state_18516;
var statearr_18537_18567 = state_18516__$1;
(statearr_18537_18567[(2)] = inst_18502);

(statearr_18537_18567[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (2))){
var state_18516__$1 = state_18516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18516__$1,(4),in$);
} else {
if((state_val_18517 === (23))){
var inst_18510 = (state_18516[(2)]);
var state_18516__$1 = state_18516;
var statearr_18538_18568 = state_18516__$1;
(statearr_18538_18568[(2)] = inst_18510);

(statearr_18538_18568[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (19))){
var inst_18497 = (state_18516[(2)]);
var state_18516__$1 = state_18516;
var statearr_18539_18569 = state_18516__$1;
(statearr_18539_18569[(2)] = inst_18497);

(statearr_18539_18569[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (11))){
var inst_18482 = (state_18516[(7)]);
var inst_18468 = (state_18516[(11)]);
var inst_18482__$1 = cljs.core.seq(inst_18468);
var state_18516__$1 = (function (){var statearr_18540 = state_18516;
(statearr_18540[(7)] = inst_18482__$1);

return statearr_18540;
})();
if(inst_18482__$1){
var statearr_18541_18570 = state_18516__$1;
(statearr_18541_18570[(1)] = (14));

} else {
var statearr_18542_18571 = state_18516__$1;
(statearr_18542_18571[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (9))){
var inst_18504 = (state_18516[(2)]);
var inst_18505 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_18516__$1 = (function (){var statearr_18543 = state_18516;
(statearr_18543[(15)] = inst_18504);

return statearr_18543;
})();
if(cljs.core.truth_(inst_18505)){
var statearr_18544_18572 = state_18516__$1;
(statearr_18544_18572[(1)] = (21));

} else {
var statearr_18545_18573 = state_18516__$1;
(statearr_18545_18573[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (5))){
var inst_18460 = cljs.core.async.close_BANG_(out);
var state_18516__$1 = state_18516;
var statearr_18546_18574 = state_18516__$1;
(statearr_18546_18574[(2)] = inst_18460);

(statearr_18546_18574[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (14))){
var inst_18482 = (state_18516[(7)]);
var inst_18484 = cljs.core.chunked_seq_QMARK_(inst_18482);
var state_18516__$1 = state_18516;
if(inst_18484){
var statearr_18547_18575 = state_18516__$1;
(statearr_18547_18575[(1)] = (17));

} else {
var statearr_18548_18576 = state_18516__$1;
(statearr_18548_18576[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (16))){
var inst_18500 = (state_18516[(2)]);
var state_18516__$1 = state_18516;
var statearr_18549_18577 = state_18516__$1;
(statearr_18549_18577[(2)] = inst_18500);

(statearr_18549_18577[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18517 === (10))){
var inst_18469 = (state_18516[(9)]);
var inst_18471 = (state_18516[(10)]);
var inst_18476 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18469,inst_18471);
var state_18516__$1 = state_18516;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18516__$1,(13),out,inst_18476);
} else {
if((state_val_18517 === (18))){
var inst_18482 = (state_18516[(7)]);
var inst_18491 = cljs.core.first(inst_18482);
var state_18516__$1 = state_18516;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18516__$1,(20),out,inst_18491);
} else {
if((state_val_18517 === (8))){
var inst_18471 = (state_18516[(10)]);
var inst_18470 = (state_18516[(12)]);
var inst_18473 = (inst_18471 < inst_18470);
var inst_18474 = inst_18473;
var state_18516__$1 = state_18516;
if(cljs.core.truth_(inst_18474)){
var statearr_18550_18578 = state_18516__$1;
(statearr_18550_18578[(1)] = (10));

} else {
var statearr_18551_18579 = state_18516__$1;
(statearr_18551_18579[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto__))
;
return ((function (switch__16794__auto__,c__16896__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16795__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16795__auto____0 = (function (){
var statearr_18552 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18552[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16795__auto__);

(statearr_18552[(1)] = (1));

return statearr_18552;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16795__auto____1 = (function (state_18516){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18516);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18553){if((e18553 instanceof Object)){
var ex__16798__auto__ = e18553;
var statearr_18554_18580 = state_18516;
(statearr_18554_18580[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18516);

return cljs.core.cst$kw$recur;
} else {
throw e18553;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18581 = state_18516;
state_18516 = G__18581;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16795__auto__ = function(state_18516){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16795__auto____1.call(this,state_18516);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16795__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16795__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto__))
})();
var state__16898__auto__ = (function (){var statearr_18555 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18555[(6)] = c__16896__auto__);

return statearr_18555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto__))
);

return c__16896__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18583 = arguments.length;
switch (G__18583) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18586 = arguments.length;
switch (G__18586) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18589 = arguments.length;
switch (G__18589) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16896__auto___18636 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___18636,out){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___18636,out){
return (function (state_18613){
var state_val_18614 = (state_18613[(1)]);
if((state_val_18614 === (7))){
var inst_18608 = (state_18613[(2)]);
var state_18613__$1 = state_18613;
var statearr_18615_18637 = state_18613__$1;
(statearr_18615_18637[(2)] = inst_18608);

(statearr_18615_18637[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18614 === (1))){
var inst_18590 = null;
var state_18613__$1 = (function (){var statearr_18616 = state_18613;
(statearr_18616[(7)] = inst_18590);

return statearr_18616;
})();
var statearr_18617_18638 = state_18613__$1;
(statearr_18617_18638[(2)] = null);

(statearr_18617_18638[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18614 === (4))){
var inst_18593 = (state_18613[(8)]);
var inst_18593__$1 = (state_18613[(2)]);
var inst_18594 = (inst_18593__$1 == null);
var inst_18595 = cljs.core.not(inst_18594);
var state_18613__$1 = (function (){var statearr_18618 = state_18613;
(statearr_18618[(8)] = inst_18593__$1);

return statearr_18618;
})();
if(inst_18595){
var statearr_18619_18639 = state_18613__$1;
(statearr_18619_18639[(1)] = (5));

} else {
var statearr_18620_18640 = state_18613__$1;
(statearr_18620_18640[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18614 === (6))){
var state_18613__$1 = state_18613;
var statearr_18621_18641 = state_18613__$1;
(statearr_18621_18641[(2)] = null);

(statearr_18621_18641[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18614 === (3))){
var inst_18610 = (state_18613[(2)]);
var inst_18611 = cljs.core.async.close_BANG_(out);
var state_18613__$1 = (function (){var statearr_18622 = state_18613;
(statearr_18622[(9)] = inst_18610);

return statearr_18622;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18613__$1,inst_18611);
} else {
if((state_val_18614 === (2))){
var state_18613__$1 = state_18613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18613__$1,(4),ch);
} else {
if((state_val_18614 === (11))){
var inst_18593 = (state_18613[(8)]);
var inst_18602 = (state_18613[(2)]);
var inst_18590 = inst_18593;
var state_18613__$1 = (function (){var statearr_18623 = state_18613;
(statearr_18623[(10)] = inst_18602);

(statearr_18623[(7)] = inst_18590);

return statearr_18623;
})();
var statearr_18624_18642 = state_18613__$1;
(statearr_18624_18642[(2)] = null);

(statearr_18624_18642[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18614 === (9))){
var inst_18593 = (state_18613[(8)]);
var state_18613__$1 = state_18613;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18613__$1,(11),out,inst_18593);
} else {
if((state_val_18614 === (5))){
var inst_18593 = (state_18613[(8)]);
var inst_18590 = (state_18613[(7)]);
var inst_18597 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18593,inst_18590);
var state_18613__$1 = state_18613;
if(inst_18597){
var statearr_18626_18643 = state_18613__$1;
(statearr_18626_18643[(1)] = (8));

} else {
var statearr_18627_18644 = state_18613__$1;
(statearr_18627_18644[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18614 === (10))){
var inst_18605 = (state_18613[(2)]);
var state_18613__$1 = state_18613;
var statearr_18628_18645 = state_18613__$1;
(statearr_18628_18645[(2)] = inst_18605);

(statearr_18628_18645[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18614 === (8))){
var inst_18590 = (state_18613[(7)]);
var tmp18625 = inst_18590;
var inst_18590__$1 = tmp18625;
var state_18613__$1 = (function (){var statearr_18629 = state_18613;
(statearr_18629[(7)] = inst_18590__$1);

return statearr_18629;
})();
var statearr_18630_18646 = state_18613__$1;
(statearr_18630_18646[(2)] = null);

(statearr_18630_18646[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___18636,out))
;
return ((function (switch__16794__auto__,c__16896__auto___18636,out){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_18631 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18631[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_18631[(1)] = (1));

return statearr_18631;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_18613){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18613);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18632){if((e18632 instanceof Object)){
var ex__16798__auto__ = e18632;
var statearr_18633_18647 = state_18613;
(statearr_18633_18647[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18613);

return cljs.core.cst$kw$recur;
} else {
throw e18632;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18648 = state_18613;
state_18613 = G__18648;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_18613){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_18613);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___18636,out))
})();
var state__16898__auto__ = (function (){var statearr_18634 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18634[(6)] = c__16896__auto___18636);

return statearr_18634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___18636,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__18650 = arguments.length;
switch (G__18650) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16896__auto___18716 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___18716,out){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___18716,out){
return (function (state_18688){
var state_val_18689 = (state_18688[(1)]);
if((state_val_18689 === (7))){
var inst_18684 = (state_18688[(2)]);
var state_18688__$1 = state_18688;
var statearr_18690_18717 = state_18688__$1;
(statearr_18690_18717[(2)] = inst_18684);

(statearr_18690_18717[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18689 === (1))){
var inst_18651 = (new Array(n));
var inst_18652 = inst_18651;
var inst_18653 = (0);
var state_18688__$1 = (function (){var statearr_18691 = state_18688;
(statearr_18691[(7)] = inst_18652);

(statearr_18691[(8)] = inst_18653);

return statearr_18691;
})();
var statearr_18692_18718 = state_18688__$1;
(statearr_18692_18718[(2)] = null);

(statearr_18692_18718[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18689 === (4))){
var inst_18656 = (state_18688[(9)]);
var inst_18656__$1 = (state_18688[(2)]);
var inst_18657 = (inst_18656__$1 == null);
var inst_18658 = cljs.core.not(inst_18657);
var state_18688__$1 = (function (){var statearr_18693 = state_18688;
(statearr_18693[(9)] = inst_18656__$1);

return statearr_18693;
})();
if(inst_18658){
var statearr_18694_18719 = state_18688__$1;
(statearr_18694_18719[(1)] = (5));

} else {
var statearr_18695_18720 = state_18688__$1;
(statearr_18695_18720[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18689 === (15))){
var inst_18678 = (state_18688[(2)]);
var state_18688__$1 = state_18688;
var statearr_18696_18721 = state_18688__$1;
(statearr_18696_18721[(2)] = inst_18678);

(statearr_18696_18721[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18689 === (13))){
var state_18688__$1 = state_18688;
var statearr_18697_18722 = state_18688__$1;
(statearr_18697_18722[(2)] = null);

(statearr_18697_18722[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18689 === (6))){
var inst_18653 = (state_18688[(8)]);
var inst_18674 = (inst_18653 > (0));
var state_18688__$1 = state_18688;
if(cljs.core.truth_(inst_18674)){
var statearr_18698_18723 = state_18688__$1;
(statearr_18698_18723[(1)] = (12));

} else {
var statearr_18699_18724 = state_18688__$1;
(statearr_18699_18724[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18689 === (3))){
var inst_18686 = (state_18688[(2)]);
var state_18688__$1 = state_18688;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18688__$1,inst_18686);
} else {
if((state_val_18689 === (12))){
var inst_18652 = (state_18688[(7)]);
var inst_18676 = cljs.core.vec(inst_18652);
var state_18688__$1 = state_18688;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18688__$1,(15),out,inst_18676);
} else {
if((state_val_18689 === (2))){
var state_18688__$1 = state_18688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18688__$1,(4),ch);
} else {
if((state_val_18689 === (11))){
var inst_18668 = (state_18688[(2)]);
var inst_18669 = (new Array(n));
var inst_18652 = inst_18669;
var inst_18653 = (0);
var state_18688__$1 = (function (){var statearr_18700 = state_18688;
(statearr_18700[(7)] = inst_18652);

(statearr_18700[(10)] = inst_18668);

(statearr_18700[(8)] = inst_18653);

return statearr_18700;
})();
var statearr_18701_18725 = state_18688__$1;
(statearr_18701_18725[(2)] = null);

(statearr_18701_18725[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18689 === (9))){
var inst_18652 = (state_18688[(7)]);
var inst_18666 = cljs.core.vec(inst_18652);
var state_18688__$1 = state_18688;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18688__$1,(11),out,inst_18666);
} else {
if((state_val_18689 === (5))){
var inst_18652 = (state_18688[(7)]);
var inst_18661 = (state_18688[(11)]);
var inst_18656 = (state_18688[(9)]);
var inst_18653 = (state_18688[(8)]);
var inst_18660 = (inst_18652[inst_18653] = inst_18656);
var inst_18661__$1 = (inst_18653 + (1));
var inst_18662 = (inst_18661__$1 < n);
var state_18688__$1 = (function (){var statearr_18702 = state_18688;
(statearr_18702[(12)] = inst_18660);

(statearr_18702[(11)] = inst_18661__$1);

return statearr_18702;
})();
if(cljs.core.truth_(inst_18662)){
var statearr_18703_18726 = state_18688__$1;
(statearr_18703_18726[(1)] = (8));

} else {
var statearr_18704_18727 = state_18688__$1;
(statearr_18704_18727[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18689 === (14))){
var inst_18681 = (state_18688[(2)]);
var inst_18682 = cljs.core.async.close_BANG_(out);
var state_18688__$1 = (function (){var statearr_18706 = state_18688;
(statearr_18706[(13)] = inst_18681);

return statearr_18706;
})();
var statearr_18707_18728 = state_18688__$1;
(statearr_18707_18728[(2)] = inst_18682);

(statearr_18707_18728[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18689 === (10))){
var inst_18672 = (state_18688[(2)]);
var state_18688__$1 = state_18688;
var statearr_18708_18729 = state_18688__$1;
(statearr_18708_18729[(2)] = inst_18672);

(statearr_18708_18729[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18689 === (8))){
var inst_18652 = (state_18688[(7)]);
var inst_18661 = (state_18688[(11)]);
var tmp18705 = inst_18652;
var inst_18652__$1 = tmp18705;
var inst_18653 = inst_18661;
var state_18688__$1 = (function (){var statearr_18709 = state_18688;
(statearr_18709[(7)] = inst_18652__$1);

(statearr_18709[(8)] = inst_18653);

return statearr_18709;
})();
var statearr_18710_18730 = state_18688__$1;
(statearr_18710_18730[(2)] = null);

(statearr_18710_18730[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___18716,out))
;
return ((function (switch__16794__auto__,c__16896__auto___18716,out){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_18711 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18711[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_18711[(1)] = (1));

return statearr_18711;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_18688){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18688);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18712){if((e18712 instanceof Object)){
var ex__16798__auto__ = e18712;
var statearr_18713_18731 = state_18688;
(statearr_18713_18731[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18688);

return cljs.core.cst$kw$recur;
} else {
throw e18712;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18732 = state_18688;
state_18688 = G__18732;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_18688){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_18688);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___18716,out))
})();
var state__16898__auto__ = (function (){var statearr_18714 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18714[(6)] = c__16896__auto___18716);

return statearr_18714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___18716,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18734 = arguments.length;
switch (G__18734) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16896__auto___18804 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16896__auto___18804,out){
return (function (){
var f__16897__auto__ = (function (){var switch__16794__auto__ = ((function (c__16896__auto___18804,out){
return (function (state_18776){
var state_val_18777 = (state_18776[(1)]);
if((state_val_18777 === (7))){
var inst_18772 = (state_18776[(2)]);
var state_18776__$1 = state_18776;
var statearr_18778_18805 = state_18776__$1;
(statearr_18778_18805[(2)] = inst_18772);

(statearr_18778_18805[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18777 === (1))){
var inst_18735 = [];
var inst_18736 = inst_18735;
var inst_18737 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_18776__$1 = (function (){var statearr_18779 = state_18776;
(statearr_18779[(7)] = inst_18736);

(statearr_18779[(8)] = inst_18737);

return statearr_18779;
})();
var statearr_18780_18806 = state_18776__$1;
(statearr_18780_18806[(2)] = null);

(statearr_18780_18806[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18777 === (4))){
var inst_18740 = (state_18776[(9)]);
var inst_18740__$1 = (state_18776[(2)]);
var inst_18741 = (inst_18740__$1 == null);
var inst_18742 = cljs.core.not(inst_18741);
var state_18776__$1 = (function (){var statearr_18781 = state_18776;
(statearr_18781[(9)] = inst_18740__$1);

return statearr_18781;
})();
if(inst_18742){
var statearr_18782_18807 = state_18776__$1;
(statearr_18782_18807[(1)] = (5));

} else {
var statearr_18783_18808 = state_18776__$1;
(statearr_18783_18808[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18777 === (15))){
var inst_18766 = (state_18776[(2)]);
var state_18776__$1 = state_18776;
var statearr_18784_18809 = state_18776__$1;
(statearr_18784_18809[(2)] = inst_18766);

(statearr_18784_18809[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18777 === (13))){
var state_18776__$1 = state_18776;
var statearr_18785_18810 = state_18776__$1;
(statearr_18785_18810[(2)] = null);

(statearr_18785_18810[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18777 === (6))){
var inst_18736 = (state_18776[(7)]);
var inst_18761 = inst_18736.length;
var inst_18762 = (inst_18761 > (0));
var state_18776__$1 = state_18776;
if(cljs.core.truth_(inst_18762)){
var statearr_18786_18811 = state_18776__$1;
(statearr_18786_18811[(1)] = (12));

} else {
var statearr_18787_18812 = state_18776__$1;
(statearr_18787_18812[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18777 === (3))){
var inst_18774 = (state_18776[(2)]);
var state_18776__$1 = state_18776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18776__$1,inst_18774);
} else {
if((state_val_18777 === (12))){
var inst_18736 = (state_18776[(7)]);
var inst_18764 = cljs.core.vec(inst_18736);
var state_18776__$1 = state_18776;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18776__$1,(15),out,inst_18764);
} else {
if((state_val_18777 === (2))){
var state_18776__$1 = state_18776;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18776__$1,(4),ch);
} else {
if((state_val_18777 === (11))){
var inst_18744 = (state_18776[(10)]);
var inst_18740 = (state_18776[(9)]);
var inst_18754 = (state_18776[(2)]);
var inst_18755 = [];
var inst_18756 = inst_18755.push(inst_18740);
var inst_18736 = inst_18755;
var inst_18737 = inst_18744;
var state_18776__$1 = (function (){var statearr_18788 = state_18776;
(statearr_18788[(11)] = inst_18756);

(statearr_18788[(7)] = inst_18736);

(statearr_18788[(12)] = inst_18754);

(statearr_18788[(8)] = inst_18737);

return statearr_18788;
})();
var statearr_18789_18813 = state_18776__$1;
(statearr_18789_18813[(2)] = null);

(statearr_18789_18813[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18777 === (9))){
var inst_18736 = (state_18776[(7)]);
var inst_18752 = cljs.core.vec(inst_18736);
var state_18776__$1 = state_18776;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18776__$1,(11),out,inst_18752);
} else {
if((state_val_18777 === (5))){
var inst_18744 = (state_18776[(10)]);
var inst_18740 = (state_18776[(9)]);
var inst_18737 = (state_18776[(8)]);
var inst_18744__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18740) : f.call(null,inst_18740));
var inst_18745 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18744__$1,inst_18737);
var inst_18746 = cljs.core.keyword_identical_QMARK_(inst_18737,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_18747 = (inst_18745) || (inst_18746);
var state_18776__$1 = (function (){var statearr_18790 = state_18776;
(statearr_18790[(10)] = inst_18744__$1);

return statearr_18790;
})();
if(cljs.core.truth_(inst_18747)){
var statearr_18791_18814 = state_18776__$1;
(statearr_18791_18814[(1)] = (8));

} else {
var statearr_18792_18815 = state_18776__$1;
(statearr_18792_18815[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18777 === (14))){
var inst_18769 = (state_18776[(2)]);
var inst_18770 = cljs.core.async.close_BANG_(out);
var state_18776__$1 = (function (){var statearr_18794 = state_18776;
(statearr_18794[(13)] = inst_18769);

return statearr_18794;
})();
var statearr_18795_18816 = state_18776__$1;
(statearr_18795_18816[(2)] = inst_18770);

(statearr_18795_18816[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18777 === (10))){
var inst_18759 = (state_18776[(2)]);
var state_18776__$1 = state_18776;
var statearr_18796_18817 = state_18776__$1;
(statearr_18796_18817[(2)] = inst_18759);

(statearr_18796_18817[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18777 === (8))){
var inst_18744 = (state_18776[(10)]);
var inst_18740 = (state_18776[(9)]);
var inst_18736 = (state_18776[(7)]);
var inst_18749 = inst_18736.push(inst_18740);
var tmp18793 = inst_18736;
var inst_18736__$1 = tmp18793;
var inst_18737 = inst_18744;
var state_18776__$1 = (function (){var statearr_18797 = state_18776;
(statearr_18797[(14)] = inst_18749);

(statearr_18797[(7)] = inst_18736__$1);

(statearr_18797[(8)] = inst_18737);

return statearr_18797;
})();
var statearr_18798_18818 = state_18776__$1;
(statearr_18798_18818[(2)] = null);

(statearr_18798_18818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16896__auto___18804,out))
;
return ((function (switch__16794__auto__,c__16896__auto___18804,out){
return (function() {
var cljs$core$async$state_machine__16795__auto__ = null;
var cljs$core$async$state_machine__16795__auto____0 = (function (){
var statearr_18799 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18799[(0)] = cljs$core$async$state_machine__16795__auto__);

(statearr_18799[(1)] = (1));

return statearr_18799;
});
var cljs$core$async$state_machine__16795__auto____1 = (function (state_18776){
while(true){
var ret_value__16796__auto__ = (function (){try{while(true){
var result__16797__auto__ = switch__16794__auto__(state_18776);
if(cljs.core.keyword_identical_QMARK_(result__16797__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16797__auto__;
}
break;
}
}catch (e18800){if((e18800 instanceof Object)){
var ex__16798__auto__ = e18800;
var statearr_18801_18819 = state_18776;
(statearr_18801_18819[(5)] = ex__16798__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18776);

return cljs.core.cst$kw$recur;
} else {
throw e18800;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16796__auto__,cljs.core.cst$kw$recur)){
var G__18820 = state_18776;
state_18776 = G__18820;
continue;
} else {
return ret_value__16796__auto__;
}
break;
}
});
cljs$core$async$state_machine__16795__auto__ = function(state_18776){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16795__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16795__auto____1.call(this,state_18776);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16795__auto____0;
cljs$core$async$state_machine__16795__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16795__auto____1;
return cljs$core$async$state_machine__16795__auto__;
})()
;})(switch__16794__auto__,c__16896__auto___18804,out))
})();
var state__16898__auto__ = (function (){var statearr_18802 = (f__16897__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16897__auto__.cljs$core$IFn$_invoke$arity$0() : f__16897__auto__.call(null));
(statearr_18802[(6)] = c__16896__auto___18804);

return statearr_18802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16898__auto__);
});})(c__16896__auto___18804,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

