// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__16951 = arguments.length;
switch (G__16951) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async16952 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16952 = (function (f,blockable,meta16953){
this.f = f;
this.blockable = blockable;
this.meta16953 = meta16953;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16952.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16954,meta16953__$1){
var self__ = this;
var _16954__$1 = this;
return (new cljs.core.async.t_cljs$core$async16952(self__.f,self__.blockable,meta16953__$1));
});

cljs.core.async.t_cljs$core$async16952.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16954){
var self__ = this;
var _16954__$1 = this;
return self__.meta16953;
});

cljs.core.async.t_cljs$core$async16952.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16952.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16952.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async16952.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async16952.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta16953], null);
});

cljs.core.async.t_cljs$core$async16952.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16952.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16952";

cljs.core.async.t_cljs$core$async16952.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16952");
});

cljs.core.async.__GT_t_cljs$core$async16952 = (function cljs$core$async$__GT_t_cljs$core$async16952(f__$1,blockable__$1,meta16953){
return (new cljs.core.async.t_cljs$core$async16952(f__$1,blockable__$1,meta16953));
});

}

return (new cljs.core.async.t_cljs$core$async16952(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__16958 = arguments.length;
switch (G__16958) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__16961 = arguments.length;
switch (G__16961) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__16964 = arguments.length;
switch (G__16964) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_16966 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16966) : fn1.call(null,val_16966));
} else {
cljs.core.async.impl.dispatch.run(((function (val_16966,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16966) : fn1.call(null,val_16966));
});})(val_16966,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__16968 = arguments.length;
switch (G__16968) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9851__auto___16970 = n;
var x_16971 = (0);
while(true){
if((x_16971 < n__9851__auto___16970)){
(a[x_16971] = (0));

var G__16972 = (x_16971 + (1));
x_16971 = G__16972;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__16973 = (i + (1));
i = G__16973;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async16974 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16974 = (function (flag,meta16975){
this.flag = flag;
this.meta16975 = meta16975;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16974.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_16976,meta16975__$1){
var self__ = this;
var _16976__$1 = this;
return (new cljs.core.async.t_cljs$core$async16974(self__.flag,meta16975__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async16974.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_16976){
var self__ = this;
var _16976__$1 = this;
return self__.meta16975;
});})(flag))
;

cljs.core.async.t_cljs$core$async16974.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16974.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async16974.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16974.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16974.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta16975], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async16974.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16974.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16974";

cljs.core.async.t_cljs$core$async16974.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16974");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async16974 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async16974(flag__$1,meta16975){
return (new cljs.core.async.t_cljs$core$async16974(flag__$1,meta16975));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async16974(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async16977 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16977 = (function (flag,cb,meta16978){
this.flag = flag;
this.cb = cb;
this.meta16978 = meta16978;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16977.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16979,meta16978__$1){
var self__ = this;
var _16979__$1 = this;
return (new cljs.core.async.t_cljs$core$async16977(self__.flag,self__.cb,meta16978__$1));
});

cljs.core.async.t_cljs$core$async16977.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16979){
var self__ = this;
var _16979__$1 = this;
return self__.meta16978;
});

cljs.core.async.t_cljs$core$async16977.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16977.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async16977.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16977.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async16977.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta16978], null);
});

cljs.core.async.t_cljs$core$async16977.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16977.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16977";

cljs.core.async.t_cljs$core$async16977.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16977");
});

cljs.core.async.__GT_t_cljs$core$async16977 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async16977(flag__$1,cb__$1,meta16978){
return (new cljs.core.async.t_cljs$core$async16977(flag__$1,cb__$1,meta16978));
});

}

return (new cljs.core.async.t_cljs$core$async16977(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16980_SHARP_){
var G__16982 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16980_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16982) : fret.call(null,G__16982));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16981_SHARP_){
var G__16983 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16981_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16983) : fret.call(null,G__16983));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__8806__auto__ = wport;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return port;
}
})()], null));
} else {
var G__16984 = (i + (1));
i = G__16984;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8806__auto__ = ret;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__8794__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8794__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8794__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10092__auto__ = [];
var len__10085__auto___16990 = arguments.length;
var i__10086__auto___16991 = (0);
while(true){
if((i__10086__auto___16991 < len__10085__auto___16990)){
args__10092__auto__.push((arguments[i__10086__auto___16991]));

var G__16992 = (i__10086__auto___16991 + (1));
i__10086__auto___16991 = G__16992;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__16987){
var map__16988 = p__16987;
var map__16988__$1 = ((((!((map__16988 == null)))?((((map__16988.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16988.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16988):map__16988);
var opts = map__16988__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq16985){
var G__16986 = cljs.core.first(seq16985);
var seq16985__$1 = cljs.core.next(seq16985);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16986,seq16985__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__16994 = arguments.length;
switch (G__16994) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16891__auto___17040 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___17040){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___17040){
return (function (state_17018){
var state_val_17019 = (state_17018[(1)]);
if((state_val_17019 === (7))){
var inst_17014 = (state_17018[(2)]);
var state_17018__$1 = state_17018;
var statearr_17020_17041 = state_17018__$1;
(statearr_17020_17041[(2)] = inst_17014);

(statearr_17020_17041[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17019 === (1))){
var state_17018__$1 = state_17018;
var statearr_17021_17042 = state_17018__$1;
(statearr_17021_17042[(2)] = null);

(statearr_17021_17042[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17019 === (4))){
var inst_16997 = (state_17018[(7)]);
var inst_16997__$1 = (state_17018[(2)]);
var inst_16998 = (inst_16997__$1 == null);
var state_17018__$1 = (function (){var statearr_17022 = state_17018;
(statearr_17022[(7)] = inst_16997__$1);

return statearr_17022;
})();
if(cljs.core.truth_(inst_16998)){
var statearr_17023_17043 = state_17018__$1;
(statearr_17023_17043[(1)] = (5));

} else {
var statearr_17024_17044 = state_17018__$1;
(statearr_17024_17044[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17019 === (13))){
var state_17018__$1 = state_17018;
var statearr_17025_17045 = state_17018__$1;
(statearr_17025_17045[(2)] = null);

(statearr_17025_17045[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17019 === (6))){
var inst_16997 = (state_17018[(7)]);
var state_17018__$1 = state_17018;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17018__$1,(11),to,inst_16997);
} else {
if((state_val_17019 === (3))){
var inst_17016 = (state_17018[(2)]);
var state_17018__$1 = state_17018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17018__$1,inst_17016);
} else {
if((state_val_17019 === (12))){
var state_17018__$1 = state_17018;
var statearr_17026_17046 = state_17018__$1;
(statearr_17026_17046[(2)] = null);

(statearr_17026_17046[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17019 === (2))){
var state_17018__$1 = state_17018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17018__$1,(4),from);
} else {
if((state_val_17019 === (11))){
var inst_17007 = (state_17018[(2)]);
var state_17018__$1 = state_17018;
if(cljs.core.truth_(inst_17007)){
var statearr_17027_17047 = state_17018__$1;
(statearr_17027_17047[(1)] = (12));

} else {
var statearr_17028_17048 = state_17018__$1;
(statearr_17028_17048[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17019 === (9))){
var state_17018__$1 = state_17018;
var statearr_17029_17049 = state_17018__$1;
(statearr_17029_17049[(2)] = null);

(statearr_17029_17049[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17019 === (5))){
var state_17018__$1 = state_17018;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17030_17050 = state_17018__$1;
(statearr_17030_17050[(1)] = (8));

} else {
var statearr_17031_17051 = state_17018__$1;
(statearr_17031_17051[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17019 === (14))){
var inst_17012 = (state_17018[(2)]);
var state_17018__$1 = state_17018;
var statearr_17032_17052 = state_17018__$1;
(statearr_17032_17052[(2)] = inst_17012);

(statearr_17032_17052[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17019 === (10))){
var inst_17004 = (state_17018[(2)]);
var state_17018__$1 = state_17018;
var statearr_17033_17053 = state_17018__$1;
(statearr_17033_17053[(2)] = inst_17004);

(statearr_17033_17053[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17019 === (8))){
var inst_17001 = cljs.core.async.close_BANG_(to);
var state_17018__$1 = state_17018;
var statearr_17034_17054 = state_17018__$1;
(statearr_17034_17054[(2)] = inst_17001);

(statearr_17034_17054[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___17040))
;
return ((function (switch__16789__auto__,c__16891__auto___17040){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_17035 = [null,null,null,null,null,null,null,null];
(statearr_17035[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_17035[(1)] = (1));

return statearr_17035;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_17018){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17018);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17036){if((e17036 instanceof Object)){
var ex__16793__auto__ = e17036;
var statearr_17037_17055 = state_17018;
(statearr_17037_17055[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17018);

return cljs.core.cst$kw$recur;
} else {
throw e17036;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17056 = state_17018;
state_17018 = G__17056;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_17018){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_17018);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___17040))
})();
var state__16893__auto__ = (function (){var statearr_17038 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17038[(6)] = c__16891__auto___17040);

return statearr_17038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___17040))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__17057){
var vec__17058 = p__17057;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17058,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17058,(1),null);
var job = vec__17058;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__16891__auto___17229 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___17229,res,vec__17058,v,p,job,jobs,results){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___17229,res,vec__17058,v,p,job,jobs,results){
return (function (state_17065){
var state_val_17066 = (state_17065[(1)]);
if((state_val_17066 === (1))){
var state_17065__$1 = state_17065;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17065__$1,(2),res,v);
} else {
if((state_val_17066 === (2))){
var inst_17062 = (state_17065[(2)]);
var inst_17063 = cljs.core.async.close_BANG_(res);
var state_17065__$1 = (function (){var statearr_17067 = state_17065;
(statearr_17067[(7)] = inst_17062);

return statearr_17067;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17065__$1,inst_17063);
} else {
return null;
}
}
});})(c__16891__auto___17229,res,vec__17058,v,p,job,jobs,results))
;
return ((function (switch__16789__auto__,c__16891__auto___17229,res,vec__17058,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0 = (function (){
var statearr_17068 = [null,null,null,null,null,null,null,null];
(statearr_17068[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__);

(statearr_17068[(1)] = (1));

return statearr_17068;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1 = (function (state_17065){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17065);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17069){if((e17069 instanceof Object)){
var ex__16793__auto__ = e17069;
var statearr_17070_17230 = state_17065;
(statearr_17070_17230[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17065);

return cljs.core.cst$kw$recur;
} else {
throw e17069;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17231 = state_17065;
state_17065 = G__17231;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__ = function(state_17065){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1.call(this,state_17065);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___17229,res,vec__17058,v,p,job,jobs,results))
})();
var state__16893__auto__ = (function (){var statearr_17071 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17071[(6)] = c__16891__auto___17229);

return statearr_17071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___17229,res,vec__17058,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17072){
var vec__17073 = p__17072;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17073,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17073,(1),null);
var job = vec__17073;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__9851__auto___17232 = n;
var __17233 = (0);
while(true){
if((__17233 < n__9851__auto___17232)){
var G__17076_17234 = type;
var G__17076_17235__$1 = (((G__17076_17234 instanceof cljs.core.Keyword))?G__17076_17234.fqn:null);
switch (G__17076_17235__$1) {
case "compute":
var c__16891__auto___17237 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17233,c__16891__auto___17237,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (__17233,c__16891__auto___17237,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async){
return (function (state_17089){
var state_val_17090 = (state_17089[(1)]);
if((state_val_17090 === (1))){
var state_17089__$1 = state_17089;
var statearr_17091_17238 = state_17089__$1;
(statearr_17091_17238[(2)] = null);

(statearr_17091_17238[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17090 === (2))){
var state_17089__$1 = state_17089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17089__$1,(4),jobs);
} else {
if((state_val_17090 === (3))){
var inst_17087 = (state_17089[(2)]);
var state_17089__$1 = state_17089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17089__$1,inst_17087);
} else {
if((state_val_17090 === (4))){
var inst_17079 = (state_17089[(2)]);
var inst_17080 = process(inst_17079);
var state_17089__$1 = state_17089;
if(cljs.core.truth_(inst_17080)){
var statearr_17092_17239 = state_17089__$1;
(statearr_17092_17239[(1)] = (5));

} else {
var statearr_17093_17240 = state_17089__$1;
(statearr_17093_17240[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17090 === (5))){
var state_17089__$1 = state_17089;
var statearr_17094_17241 = state_17089__$1;
(statearr_17094_17241[(2)] = null);

(statearr_17094_17241[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17090 === (6))){
var state_17089__$1 = state_17089;
var statearr_17095_17242 = state_17089__$1;
(statearr_17095_17242[(2)] = null);

(statearr_17095_17242[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17090 === (7))){
var inst_17085 = (state_17089[(2)]);
var state_17089__$1 = state_17089;
var statearr_17096_17243 = state_17089__$1;
(statearr_17096_17243[(2)] = inst_17085);

(statearr_17096_17243[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17233,c__16891__auto___17237,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async))
;
return ((function (__17233,switch__16789__auto__,c__16891__auto___17237,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0 = (function (){
var statearr_17097 = [null,null,null,null,null,null,null];
(statearr_17097[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__);

(statearr_17097[(1)] = (1));

return statearr_17097;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1 = (function (state_17089){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17089);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17098){if((e17098 instanceof Object)){
var ex__16793__auto__ = e17098;
var statearr_17099_17244 = state_17089;
(statearr_17099_17244[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17089);

return cljs.core.cst$kw$recur;
} else {
throw e17098;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17245 = state_17089;
state_17089 = G__17245;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__ = function(state_17089){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1.call(this,state_17089);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__;
})()
;})(__17233,switch__16789__auto__,c__16891__auto___17237,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async))
})();
var state__16893__auto__ = (function (){var statearr_17100 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17100[(6)] = c__16891__auto___17237);

return statearr_17100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(__17233,c__16891__auto___17237,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async))
);


break;
case "async":
var c__16891__auto___17246 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17233,c__16891__auto___17246,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (__17233,c__16891__auto___17246,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async){
return (function (state_17113){
var state_val_17114 = (state_17113[(1)]);
if((state_val_17114 === (1))){
var state_17113__$1 = state_17113;
var statearr_17115_17247 = state_17113__$1;
(statearr_17115_17247[(2)] = null);

(statearr_17115_17247[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17114 === (2))){
var state_17113__$1 = state_17113;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17113__$1,(4),jobs);
} else {
if((state_val_17114 === (3))){
var inst_17111 = (state_17113[(2)]);
var state_17113__$1 = state_17113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17113__$1,inst_17111);
} else {
if((state_val_17114 === (4))){
var inst_17103 = (state_17113[(2)]);
var inst_17104 = async(inst_17103);
var state_17113__$1 = state_17113;
if(cljs.core.truth_(inst_17104)){
var statearr_17116_17248 = state_17113__$1;
(statearr_17116_17248[(1)] = (5));

} else {
var statearr_17117_17249 = state_17113__$1;
(statearr_17117_17249[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17114 === (5))){
var state_17113__$1 = state_17113;
var statearr_17118_17250 = state_17113__$1;
(statearr_17118_17250[(2)] = null);

(statearr_17118_17250[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17114 === (6))){
var state_17113__$1 = state_17113;
var statearr_17119_17251 = state_17113__$1;
(statearr_17119_17251[(2)] = null);

(statearr_17119_17251[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17114 === (7))){
var inst_17109 = (state_17113[(2)]);
var state_17113__$1 = state_17113;
var statearr_17120_17252 = state_17113__$1;
(statearr_17120_17252[(2)] = inst_17109);

(statearr_17120_17252[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17233,c__16891__auto___17246,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async))
;
return ((function (__17233,switch__16789__auto__,c__16891__auto___17246,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0 = (function (){
var statearr_17121 = [null,null,null,null,null,null,null];
(statearr_17121[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__);

(statearr_17121[(1)] = (1));

return statearr_17121;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1 = (function (state_17113){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17113);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17122){if((e17122 instanceof Object)){
var ex__16793__auto__ = e17122;
var statearr_17123_17253 = state_17113;
(statearr_17123_17253[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17113);

return cljs.core.cst$kw$recur;
} else {
throw e17122;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17254 = state_17113;
state_17113 = G__17254;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__ = function(state_17113){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1.call(this,state_17113);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__;
})()
;})(__17233,switch__16789__auto__,c__16891__auto___17246,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async))
})();
var state__16893__auto__ = (function (){var statearr_17124 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17124[(6)] = c__16891__auto___17246);

return statearr_17124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(__17233,c__16891__auto___17246,G__17076_17234,G__17076_17235__$1,n__9851__auto___17232,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17076_17235__$1)].join('')));

}

var G__17255 = (__17233 + (1));
__17233 = G__17255;
continue;
} else {
}
break;
}

var c__16891__auto___17256 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___17256,jobs,results,process,async){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___17256,jobs,results,process,async){
return (function (state_17146){
var state_val_17147 = (state_17146[(1)]);
if((state_val_17147 === (1))){
var state_17146__$1 = state_17146;
var statearr_17148_17257 = state_17146__$1;
(statearr_17148_17257[(2)] = null);

(statearr_17148_17257[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17147 === (2))){
var state_17146__$1 = state_17146;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17146__$1,(4),from);
} else {
if((state_val_17147 === (3))){
var inst_17144 = (state_17146[(2)]);
var state_17146__$1 = state_17146;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17146__$1,inst_17144);
} else {
if((state_val_17147 === (4))){
var inst_17127 = (state_17146[(7)]);
var inst_17127__$1 = (state_17146[(2)]);
var inst_17128 = (inst_17127__$1 == null);
var state_17146__$1 = (function (){var statearr_17149 = state_17146;
(statearr_17149[(7)] = inst_17127__$1);

return statearr_17149;
})();
if(cljs.core.truth_(inst_17128)){
var statearr_17150_17258 = state_17146__$1;
(statearr_17150_17258[(1)] = (5));

} else {
var statearr_17151_17259 = state_17146__$1;
(statearr_17151_17259[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17147 === (5))){
var inst_17130 = cljs.core.async.close_BANG_(jobs);
var state_17146__$1 = state_17146;
var statearr_17152_17260 = state_17146__$1;
(statearr_17152_17260[(2)] = inst_17130);

(statearr_17152_17260[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17147 === (6))){
var inst_17132 = (state_17146[(8)]);
var inst_17127 = (state_17146[(7)]);
var inst_17132__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_17133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17134 = [inst_17127,inst_17132__$1];
var inst_17135 = (new cljs.core.PersistentVector(null,2,(5),inst_17133,inst_17134,null));
var state_17146__$1 = (function (){var statearr_17153 = state_17146;
(statearr_17153[(8)] = inst_17132__$1);

return statearr_17153;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17146__$1,(8),jobs,inst_17135);
} else {
if((state_val_17147 === (7))){
var inst_17142 = (state_17146[(2)]);
var state_17146__$1 = state_17146;
var statearr_17154_17261 = state_17146__$1;
(statearr_17154_17261[(2)] = inst_17142);

(statearr_17154_17261[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17147 === (8))){
var inst_17132 = (state_17146[(8)]);
var inst_17137 = (state_17146[(2)]);
var state_17146__$1 = (function (){var statearr_17155 = state_17146;
(statearr_17155[(9)] = inst_17137);

return statearr_17155;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17146__$1,(9),results,inst_17132);
} else {
if((state_val_17147 === (9))){
var inst_17139 = (state_17146[(2)]);
var state_17146__$1 = (function (){var statearr_17156 = state_17146;
(statearr_17156[(10)] = inst_17139);

return statearr_17156;
})();
var statearr_17157_17262 = state_17146__$1;
(statearr_17157_17262[(2)] = null);

(statearr_17157_17262[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___17256,jobs,results,process,async))
;
return ((function (switch__16789__auto__,c__16891__auto___17256,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0 = (function (){
var statearr_17158 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17158[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__);

(statearr_17158[(1)] = (1));

return statearr_17158;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1 = (function (state_17146){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17146);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17159){if((e17159 instanceof Object)){
var ex__16793__auto__ = e17159;
var statearr_17160_17263 = state_17146;
(statearr_17160_17263[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17146);

return cljs.core.cst$kw$recur;
} else {
throw e17159;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17264 = state_17146;
state_17146 = G__17264;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__ = function(state_17146){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1.call(this,state_17146);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___17256,jobs,results,process,async))
})();
var state__16893__auto__ = (function (){var statearr_17161 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17161[(6)] = c__16891__auto___17256);

return statearr_17161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___17256,jobs,results,process,async))
);


var c__16891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto__,jobs,results,process,async){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto__,jobs,results,process,async){
return (function (state_17199){
var state_val_17200 = (state_17199[(1)]);
if((state_val_17200 === (7))){
var inst_17195 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
var statearr_17201_17265 = state_17199__$1;
(statearr_17201_17265[(2)] = inst_17195);

(statearr_17201_17265[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (20))){
var state_17199__$1 = state_17199;
var statearr_17202_17266 = state_17199__$1;
(statearr_17202_17266[(2)] = null);

(statearr_17202_17266[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (1))){
var state_17199__$1 = state_17199;
var statearr_17203_17267 = state_17199__$1;
(statearr_17203_17267[(2)] = null);

(statearr_17203_17267[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (4))){
var inst_17164 = (state_17199[(7)]);
var inst_17164__$1 = (state_17199[(2)]);
var inst_17165 = (inst_17164__$1 == null);
var state_17199__$1 = (function (){var statearr_17204 = state_17199;
(statearr_17204[(7)] = inst_17164__$1);

return statearr_17204;
})();
if(cljs.core.truth_(inst_17165)){
var statearr_17205_17268 = state_17199__$1;
(statearr_17205_17268[(1)] = (5));

} else {
var statearr_17206_17269 = state_17199__$1;
(statearr_17206_17269[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (15))){
var inst_17177 = (state_17199[(8)]);
var state_17199__$1 = state_17199;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17199__$1,(18),to,inst_17177);
} else {
if((state_val_17200 === (21))){
var inst_17190 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
var statearr_17207_17270 = state_17199__$1;
(statearr_17207_17270[(2)] = inst_17190);

(statearr_17207_17270[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (13))){
var inst_17192 = (state_17199[(2)]);
var state_17199__$1 = (function (){var statearr_17208 = state_17199;
(statearr_17208[(9)] = inst_17192);

return statearr_17208;
})();
var statearr_17209_17271 = state_17199__$1;
(statearr_17209_17271[(2)] = null);

(statearr_17209_17271[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (6))){
var inst_17164 = (state_17199[(7)]);
var state_17199__$1 = state_17199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17199__$1,(11),inst_17164);
} else {
if((state_val_17200 === (17))){
var inst_17185 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
if(cljs.core.truth_(inst_17185)){
var statearr_17210_17272 = state_17199__$1;
(statearr_17210_17272[(1)] = (19));

} else {
var statearr_17211_17273 = state_17199__$1;
(statearr_17211_17273[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (3))){
var inst_17197 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17199__$1,inst_17197);
} else {
if((state_val_17200 === (12))){
var inst_17174 = (state_17199[(10)]);
var state_17199__$1 = state_17199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17199__$1,(14),inst_17174);
} else {
if((state_val_17200 === (2))){
var state_17199__$1 = state_17199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17199__$1,(4),results);
} else {
if((state_val_17200 === (19))){
var state_17199__$1 = state_17199;
var statearr_17212_17274 = state_17199__$1;
(statearr_17212_17274[(2)] = null);

(statearr_17212_17274[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (11))){
var inst_17174 = (state_17199[(2)]);
var state_17199__$1 = (function (){var statearr_17213 = state_17199;
(statearr_17213[(10)] = inst_17174);

return statearr_17213;
})();
var statearr_17214_17275 = state_17199__$1;
(statearr_17214_17275[(2)] = null);

(statearr_17214_17275[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (9))){
var state_17199__$1 = state_17199;
var statearr_17215_17276 = state_17199__$1;
(statearr_17215_17276[(2)] = null);

(statearr_17215_17276[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (5))){
var state_17199__$1 = state_17199;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17216_17277 = state_17199__$1;
(statearr_17216_17277[(1)] = (8));

} else {
var statearr_17217_17278 = state_17199__$1;
(statearr_17217_17278[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (14))){
var inst_17177 = (state_17199[(8)]);
var inst_17179 = (state_17199[(11)]);
var inst_17177__$1 = (state_17199[(2)]);
var inst_17178 = (inst_17177__$1 == null);
var inst_17179__$1 = cljs.core.not(inst_17178);
var state_17199__$1 = (function (){var statearr_17218 = state_17199;
(statearr_17218[(8)] = inst_17177__$1);

(statearr_17218[(11)] = inst_17179__$1);

return statearr_17218;
})();
if(inst_17179__$1){
var statearr_17219_17279 = state_17199__$1;
(statearr_17219_17279[(1)] = (15));

} else {
var statearr_17220_17280 = state_17199__$1;
(statearr_17220_17280[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (16))){
var inst_17179 = (state_17199[(11)]);
var state_17199__$1 = state_17199;
var statearr_17221_17281 = state_17199__$1;
(statearr_17221_17281[(2)] = inst_17179);

(statearr_17221_17281[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (10))){
var inst_17171 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
var statearr_17222_17282 = state_17199__$1;
(statearr_17222_17282[(2)] = inst_17171);

(statearr_17222_17282[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (18))){
var inst_17182 = (state_17199[(2)]);
var state_17199__$1 = state_17199;
var statearr_17223_17283 = state_17199__$1;
(statearr_17223_17283[(2)] = inst_17182);

(statearr_17223_17283[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17200 === (8))){
var inst_17168 = cljs.core.async.close_BANG_(to);
var state_17199__$1 = state_17199;
var statearr_17224_17284 = state_17199__$1;
(statearr_17224_17284[(2)] = inst_17168);

(statearr_17224_17284[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto__,jobs,results,process,async))
;
return ((function (switch__16789__auto__,c__16891__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0 = (function (){
var statearr_17225 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17225[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__);

(statearr_17225[(1)] = (1));

return statearr_17225;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1 = (function (state_17199){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17199);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17226){if((e17226 instanceof Object)){
var ex__16793__auto__ = e17226;
var statearr_17227_17285 = state_17199;
(statearr_17227_17285[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17199);

return cljs.core.cst$kw$recur;
} else {
throw e17226;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17286 = state_17199;
state_17199 = G__17286;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__ = function(state_17199){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1.call(this,state_17199);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16790__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto__,jobs,results,process,async))
})();
var state__16893__auto__ = (function (){var statearr_17228 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17228[(6)] = c__16891__auto__);

return statearr_17228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto__,jobs,results,process,async))
);

return c__16891__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__17288 = arguments.length;
switch (G__17288) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__17291 = arguments.length;
switch (G__17291) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__17294 = arguments.length;
switch (G__17294) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__16891__auto___17343 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___17343,tc,fc){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___17343,tc,fc){
return (function (state_17320){
var state_val_17321 = (state_17320[(1)]);
if((state_val_17321 === (7))){
var inst_17316 = (state_17320[(2)]);
var state_17320__$1 = state_17320;
var statearr_17322_17344 = state_17320__$1;
(statearr_17322_17344[(2)] = inst_17316);

(statearr_17322_17344[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17321 === (1))){
var state_17320__$1 = state_17320;
var statearr_17323_17345 = state_17320__$1;
(statearr_17323_17345[(2)] = null);

(statearr_17323_17345[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17321 === (4))){
var inst_17297 = (state_17320[(7)]);
var inst_17297__$1 = (state_17320[(2)]);
var inst_17298 = (inst_17297__$1 == null);
var state_17320__$1 = (function (){var statearr_17324 = state_17320;
(statearr_17324[(7)] = inst_17297__$1);

return statearr_17324;
})();
if(cljs.core.truth_(inst_17298)){
var statearr_17325_17346 = state_17320__$1;
(statearr_17325_17346[(1)] = (5));

} else {
var statearr_17326_17347 = state_17320__$1;
(statearr_17326_17347[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17321 === (13))){
var state_17320__$1 = state_17320;
var statearr_17327_17348 = state_17320__$1;
(statearr_17327_17348[(2)] = null);

(statearr_17327_17348[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17321 === (6))){
var inst_17297 = (state_17320[(7)]);
var inst_17303 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17297) : p.call(null,inst_17297));
var state_17320__$1 = state_17320;
if(cljs.core.truth_(inst_17303)){
var statearr_17328_17349 = state_17320__$1;
(statearr_17328_17349[(1)] = (9));

} else {
var statearr_17329_17350 = state_17320__$1;
(statearr_17329_17350[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17321 === (3))){
var inst_17318 = (state_17320[(2)]);
var state_17320__$1 = state_17320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17320__$1,inst_17318);
} else {
if((state_val_17321 === (12))){
var state_17320__$1 = state_17320;
var statearr_17330_17351 = state_17320__$1;
(statearr_17330_17351[(2)] = null);

(statearr_17330_17351[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17321 === (2))){
var state_17320__$1 = state_17320;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17320__$1,(4),ch);
} else {
if((state_val_17321 === (11))){
var inst_17297 = (state_17320[(7)]);
var inst_17307 = (state_17320[(2)]);
var state_17320__$1 = state_17320;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17320__$1,(8),inst_17307,inst_17297);
} else {
if((state_val_17321 === (9))){
var state_17320__$1 = state_17320;
var statearr_17331_17352 = state_17320__$1;
(statearr_17331_17352[(2)] = tc);

(statearr_17331_17352[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17321 === (5))){
var inst_17300 = cljs.core.async.close_BANG_(tc);
var inst_17301 = cljs.core.async.close_BANG_(fc);
var state_17320__$1 = (function (){var statearr_17332 = state_17320;
(statearr_17332[(8)] = inst_17300);

return statearr_17332;
})();
var statearr_17333_17353 = state_17320__$1;
(statearr_17333_17353[(2)] = inst_17301);

(statearr_17333_17353[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17321 === (14))){
var inst_17314 = (state_17320[(2)]);
var state_17320__$1 = state_17320;
var statearr_17334_17354 = state_17320__$1;
(statearr_17334_17354[(2)] = inst_17314);

(statearr_17334_17354[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17321 === (10))){
var state_17320__$1 = state_17320;
var statearr_17335_17355 = state_17320__$1;
(statearr_17335_17355[(2)] = fc);

(statearr_17335_17355[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17321 === (8))){
var inst_17309 = (state_17320[(2)]);
var state_17320__$1 = state_17320;
if(cljs.core.truth_(inst_17309)){
var statearr_17336_17356 = state_17320__$1;
(statearr_17336_17356[(1)] = (12));

} else {
var statearr_17337_17357 = state_17320__$1;
(statearr_17337_17357[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___17343,tc,fc))
;
return ((function (switch__16789__auto__,c__16891__auto___17343,tc,fc){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_17338 = [null,null,null,null,null,null,null,null,null];
(statearr_17338[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_17338[(1)] = (1));

return statearr_17338;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_17320){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17320);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17339){if((e17339 instanceof Object)){
var ex__16793__auto__ = e17339;
var statearr_17340_17358 = state_17320;
(statearr_17340_17358[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17320);

return cljs.core.cst$kw$recur;
} else {
throw e17339;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17359 = state_17320;
state_17320 = G__17359;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_17320){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_17320);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___17343,tc,fc))
})();
var state__16893__auto__ = (function (){var statearr_17341 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17341[(6)] = c__16891__auto___17343);

return statearr_17341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___17343,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto__){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto__){
return (function (state_17380){
var state_val_17381 = (state_17380[(1)]);
if((state_val_17381 === (7))){
var inst_17376 = (state_17380[(2)]);
var state_17380__$1 = state_17380;
var statearr_17382_17400 = state_17380__$1;
(statearr_17382_17400[(2)] = inst_17376);

(statearr_17382_17400[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17381 === (1))){
var inst_17360 = init;
var state_17380__$1 = (function (){var statearr_17383 = state_17380;
(statearr_17383[(7)] = inst_17360);

return statearr_17383;
})();
var statearr_17384_17401 = state_17380__$1;
(statearr_17384_17401[(2)] = null);

(statearr_17384_17401[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17381 === (4))){
var inst_17363 = (state_17380[(8)]);
var inst_17363__$1 = (state_17380[(2)]);
var inst_17364 = (inst_17363__$1 == null);
var state_17380__$1 = (function (){var statearr_17385 = state_17380;
(statearr_17385[(8)] = inst_17363__$1);

return statearr_17385;
})();
if(cljs.core.truth_(inst_17364)){
var statearr_17386_17402 = state_17380__$1;
(statearr_17386_17402[(1)] = (5));

} else {
var statearr_17387_17403 = state_17380__$1;
(statearr_17387_17403[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17381 === (6))){
var inst_17363 = (state_17380[(8)]);
var inst_17367 = (state_17380[(9)]);
var inst_17360 = (state_17380[(7)]);
var inst_17367__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_17360,inst_17363) : f.call(null,inst_17360,inst_17363));
var inst_17368 = cljs.core.reduced_QMARK_(inst_17367__$1);
var state_17380__$1 = (function (){var statearr_17388 = state_17380;
(statearr_17388[(9)] = inst_17367__$1);

return statearr_17388;
})();
if(inst_17368){
var statearr_17389_17404 = state_17380__$1;
(statearr_17389_17404[(1)] = (8));

} else {
var statearr_17390_17405 = state_17380__$1;
(statearr_17390_17405[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17381 === (3))){
var inst_17378 = (state_17380[(2)]);
var state_17380__$1 = state_17380;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17380__$1,inst_17378);
} else {
if((state_val_17381 === (2))){
var state_17380__$1 = state_17380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17380__$1,(4),ch);
} else {
if((state_val_17381 === (9))){
var inst_17367 = (state_17380[(9)]);
var inst_17360 = inst_17367;
var state_17380__$1 = (function (){var statearr_17391 = state_17380;
(statearr_17391[(7)] = inst_17360);

return statearr_17391;
})();
var statearr_17392_17406 = state_17380__$1;
(statearr_17392_17406[(2)] = null);

(statearr_17392_17406[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17381 === (5))){
var inst_17360 = (state_17380[(7)]);
var state_17380__$1 = state_17380;
var statearr_17393_17407 = state_17380__$1;
(statearr_17393_17407[(2)] = inst_17360);

(statearr_17393_17407[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17381 === (10))){
var inst_17374 = (state_17380[(2)]);
var state_17380__$1 = state_17380;
var statearr_17394_17408 = state_17380__$1;
(statearr_17394_17408[(2)] = inst_17374);

(statearr_17394_17408[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17381 === (8))){
var inst_17367 = (state_17380[(9)]);
var inst_17370 = cljs.core.deref(inst_17367);
var state_17380__$1 = state_17380;
var statearr_17395_17409 = state_17380__$1;
(statearr_17395_17409[(2)] = inst_17370);

(statearr_17395_17409[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto__))
;
return ((function (switch__16789__auto__,c__16891__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16790__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16790__auto____0 = (function (){
var statearr_17396 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17396[(0)] = cljs$core$async$reduce_$_state_machine__16790__auto__);

(statearr_17396[(1)] = (1));

return statearr_17396;
});
var cljs$core$async$reduce_$_state_machine__16790__auto____1 = (function (state_17380){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17380);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17397){if((e17397 instanceof Object)){
var ex__16793__auto__ = e17397;
var statearr_17398_17410 = state_17380;
(statearr_17398_17410[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17380);

return cljs.core.cst$kw$recur;
} else {
throw e17397;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17411 = state_17380;
state_17380 = G__17411;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16790__auto__ = function(state_17380){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16790__auto____1.call(this,state_17380);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16790__auto____0;
cljs$core$async$reduce_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16790__auto____1;
return cljs$core$async$reduce_$_state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto__))
})();
var state__16893__auto__ = (function (){var statearr_17399 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17399[(6)] = c__16891__auto__);

return statearr_17399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto__))
);

return c__16891__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__16891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto__,f__$1){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto__,f__$1){
return (function (state_17417){
var state_val_17418 = (state_17417[(1)]);
if((state_val_17418 === (1))){
var inst_17412 = cljs.core.async.reduce(f__$1,init,ch);
var state_17417__$1 = state_17417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17417__$1,(2),inst_17412);
} else {
if((state_val_17418 === (2))){
var inst_17414 = (state_17417[(2)]);
var inst_17415 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_17414) : f__$1.call(null,inst_17414));
var state_17417__$1 = state_17417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17417__$1,inst_17415);
} else {
return null;
}
}
});})(c__16891__auto__,f__$1))
;
return ((function (switch__16789__auto__,c__16891__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16790__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16790__auto____0 = (function (){
var statearr_17419 = [null,null,null,null,null,null,null];
(statearr_17419[(0)] = cljs$core$async$transduce_$_state_machine__16790__auto__);

(statearr_17419[(1)] = (1));

return statearr_17419;
});
var cljs$core$async$transduce_$_state_machine__16790__auto____1 = (function (state_17417){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17417);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17420){if((e17420 instanceof Object)){
var ex__16793__auto__ = e17420;
var statearr_17421_17423 = state_17417;
(statearr_17421_17423[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17417);

return cljs.core.cst$kw$recur;
} else {
throw e17420;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17424 = state_17417;
state_17417 = G__17424;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16790__auto__ = function(state_17417){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16790__auto____1.call(this,state_17417);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16790__auto____0;
cljs$core$async$transduce_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16790__auto____1;
return cljs$core$async$transduce_$_state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto__,f__$1))
})();
var state__16893__auto__ = (function (){var statearr_17422 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17422[(6)] = c__16891__auto__);

return statearr_17422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto__,f__$1))
);

return c__16891__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__17426 = arguments.length;
switch (G__17426) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto__){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto__){
return (function (state_17451){
var state_val_17452 = (state_17451[(1)]);
if((state_val_17452 === (7))){
var inst_17433 = (state_17451[(2)]);
var state_17451__$1 = state_17451;
var statearr_17453_17474 = state_17451__$1;
(statearr_17453_17474[(2)] = inst_17433);

(statearr_17453_17474[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17452 === (1))){
var inst_17427 = cljs.core.seq(coll);
var inst_17428 = inst_17427;
var state_17451__$1 = (function (){var statearr_17454 = state_17451;
(statearr_17454[(7)] = inst_17428);

return statearr_17454;
})();
var statearr_17455_17475 = state_17451__$1;
(statearr_17455_17475[(2)] = null);

(statearr_17455_17475[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17452 === (4))){
var inst_17428 = (state_17451[(7)]);
var inst_17431 = cljs.core.first(inst_17428);
var state_17451__$1 = state_17451;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17451__$1,(7),ch,inst_17431);
} else {
if((state_val_17452 === (13))){
var inst_17445 = (state_17451[(2)]);
var state_17451__$1 = state_17451;
var statearr_17456_17476 = state_17451__$1;
(statearr_17456_17476[(2)] = inst_17445);

(statearr_17456_17476[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17452 === (6))){
var inst_17436 = (state_17451[(2)]);
var state_17451__$1 = state_17451;
if(cljs.core.truth_(inst_17436)){
var statearr_17457_17477 = state_17451__$1;
(statearr_17457_17477[(1)] = (8));

} else {
var statearr_17458_17478 = state_17451__$1;
(statearr_17458_17478[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17452 === (3))){
var inst_17449 = (state_17451[(2)]);
var state_17451__$1 = state_17451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17451__$1,inst_17449);
} else {
if((state_val_17452 === (12))){
var state_17451__$1 = state_17451;
var statearr_17459_17479 = state_17451__$1;
(statearr_17459_17479[(2)] = null);

(statearr_17459_17479[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17452 === (2))){
var inst_17428 = (state_17451[(7)]);
var state_17451__$1 = state_17451;
if(cljs.core.truth_(inst_17428)){
var statearr_17460_17480 = state_17451__$1;
(statearr_17460_17480[(1)] = (4));

} else {
var statearr_17461_17481 = state_17451__$1;
(statearr_17461_17481[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17452 === (11))){
var inst_17442 = cljs.core.async.close_BANG_(ch);
var state_17451__$1 = state_17451;
var statearr_17462_17482 = state_17451__$1;
(statearr_17462_17482[(2)] = inst_17442);

(statearr_17462_17482[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17452 === (9))){
var state_17451__$1 = state_17451;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17463_17483 = state_17451__$1;
(statearr_17463_17483[(1)] = (11));

} else {
var statearr_17464_17484 = state_17451__$1;
(statearr_17464_17484[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17452 === (5))){
var inst_17428 = (state_17451[(7)]);
var state_17451__$1 = state_17451;
var statearr_17465_17485 = state_17451__$1;
(statearr_17465_17485[(2)] = inst_17428);

(statearr_17465_17485[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17452 === (10))){
var inst_17447 = (state_17451[(2)]);
var state_17451__$1 = state_17451;
var statearr_17466_17486 = state_17451__$1;
(statearr_17466_17486[(2)] = inst_17447);

(statearr_17466_17486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17452 === (8))){
var inst_17428 = (state_17451[(7)]);
var inst_17438 = cljs.core.next(inst_17428);
var inst_17428__$1 = inst_17438;
var state_17451__$1 = (function (){var statearr_17467 = state_17451;
(statearr_17467[(7)] = inst_17428__$1);

return statearr_17467;
})();
var statearr_17468_17487 = state_17451__$1;
(statearr_17468_17487[(2)] = null);

(statearr_17468_17487[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto__))
;
return ((function (switch__16789__auto__,c__16891__auto__){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_17469 = [null,null,null,null,null,null,null,null];
(statearr_17469[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_17469[(1)] = (1));

return statearr_17469;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_17451){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17451);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17470){if((e17470 instanceof Object)){
var ex__16793__auto__ = e17470;
var statearr_17471_17488 = state_17451;
(statearr_17471_17488[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17451);

return cljs.core.cst$kw$recur;
} else {
throw e17470;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17489 = state_17451;
state_17451 = G__17489;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_17451){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_17451);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto__))
})();
var state__16893__auto__ = (function (){var statearr_17472 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17472[(6)] = c__16891__auto__);

return statearr_17472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto__))
);

return c__16891__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9539__auto__ = (((_ == null))?null:_);
var m__9540__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__9540__auto__.call(null,_));
} else {
var m__9540__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__9540__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9540__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__9540__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9540__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto__.call(null,m));
} else {
var m__9540__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17490 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17490 = (function (ch,cs,meta17491){
this.ch = ch;
this.cs = cs;
this.meta17491 = meta17491;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17490.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_17492,meta17491__$1){
var self__ = this;
var _17492__$1 = this;
return (new cljs.core.async.t_cljs$core$async17490(self__.ch,self__.cs,meta17491__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async17490.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_17492){
var self__ = this;
var _17492__$1 = this;
return self__.meta17491;
});})(cs))
;

cljs.core.async.t_cljs$core$async17490.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17490.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async17490.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17490.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17490.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17490.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17490.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta17491], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async17490.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17490.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17490";

cljs.core.async.t_cljs$core$async17490.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17490");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async17490 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async17490(ch__$1,cs__$1,meta17491){
return (new cljs.core.async.t_cljs$core$async17490(ch__$1,cs__$1,meta17491));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async17490(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__16891__auto___17712 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___17712,cs,m,dchan,dctr,done){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___17712,cs,m,dchan,dctr,done){
return (function (state_17627){
var state_val_17628 = (state_17627[(1)]);
if((state_val_17628 === (7))){
var inst_17623 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17629_17713 = state_17627__$1;
(statearr_17629_17713[(2)] = inst_17623);

(statearr_17629_17713[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (20))){
var inst_17526 = (state_17627[(7)]);
var inst_17538 = cljs.core.first(inst_17526);
var inst_17539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17538,(0),null);
var inst_17540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17538,(1),null);
var state_17627__$1 = (function (){var statearr_17630 = state_17627;
(statearr_17630[(8)] = inst_17539);

return statearr_17630;
})();
if(cljs.core.truth_(inst_17540)){
var statearr_17631_17714 = state_17627__$1;
(statearr_17631_17714[(1)] = (22));

} else {
var statearr_17632_17715 = state_17627__$1;
(statearr_17632_17715[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (27))){
var inst_17568 = (state_17627[(9)]);
var inst_17495 = (state_17627[(10)]);
var inst_17570 = (state_17627[(11)]);
var inst_17575 = (state_17627[(12)]);
var inst_17575__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17568,inst_17570);
var inst_17576 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17575__$1,inst_17495,done);
var state_17627__$1 = (function (){var statearr_17633 = state_17627;
(statearr_17633[(12)] = inst_17575__$1);

return statearr_17633;
})();
if(cljs.core.truth_(inst_17576)){
var statearr_17634_17716 = state_17627__$1;
(statearr_17634_17716[(1)] = (30));

} else {
var statearr_17635_17717 = state_17627__$1;
(statearr_17635_17717[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (1))){
var state_17627__$1 = state_17627;
var statearr_17636_17718 = state_17627__$1;
(statearr_17636_17718[(2)] = null);

(statearr_17636_17718[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (24))){
var inst_17526 = (state_17627[(7)]);
var inst_17545 = (state_17627[(2)]);
var inst_17546 = cljs.core.next(inst_17526);
var inst_17504 = inst_17546;
var inst_17505 = null;
var inst_17506 = (0);
var inst_17507 = (0);
var state_17627__$1 = (function (){var statearr_17637 = state_17627;
(statearr_17637[(13)] = inst_17505);

(statearr_17637[(14)] = inst_17507);

(statearr_17637[(15)] = inst_17545);

(statearr_17637[(16)] = inst_17506);

(statearr_17637[(17)] = inst_17504);

return statearr_17637;
})();
var statearr_17638_17719 = state_17627__$1;
(statearr_17638_17719[(2)] = null);

(statearr_17638_17719[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (39))){
var state_17627__$1 = state_17627;
var statearr_17642_17720 = state_17627__$1;
(statearr_17642_17720[(2)] = null);

(statearr_17642_17720[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (4))){
var inst_17495 = (state_17627[(10)]);
var inst_17495__$1 = (state_17627[(2)]);
var inst_17496 = (inst_17495__$1 == null);
var state_17627__$1 = (function (){var statearr_17643 = state_17627;
(statearr_17643[(10)] = inst_17495__$1);

return statearr_17643;
})();
if(cljs.core.truth_(inst_17496)){
var statearr_17644_17721 = state_17627__$1;
(statearr_17644_17721[(1)] = (5));

} else {
var statearr_17645_17722 = state_17627__$1;
(statearr_17645_17722[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (15))){
var inst_17505 = (state_17627[(13)]);
var inst_17507 = (state_17627[(14)]);
var inst_17506 = (state_17627[(16)]);
var inst_17504 = (state_17627[(17)]);
var inst_17522 = (state_17627[(2)]);
var inst_17523 = (inst_17507 + (1));
var tmp17639 = inst_17505;
var tmp17640 = inst_17506;
var tmp17641 = inst_17504;
var inst_17504__$1 = tmp17641;
var inst_17505__$1 = tmp17639;
var inst_17506__$1 = tmp17640;
var inst_17507__$1 = inst_17523;
var state_17627__$1 = (function (){var statearr_17646 = state_17627;
(statearr_17646[(13)] = inst_17505__$1);

(statearr_17646[(14)] = inst_17507__$1);

(statearr_17646[(18)] = inst_17522);

(statearr_17646[(16)] = inst_17506__$1);

(statearr_17646[(17)] = inst_17504__$1);

return statearr_17646;
})();
var statearr_17647_17723 = state_17627__$1;
(statearr_17647_17723[(2)] = null);

(statearr_17647_17723[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (21))){
var inst_17549 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17651_17724 = state_17627__$1;
(statearr_17651_17724[(2)] = inst_17549);

(statearr_17651_17724[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (31))){
var inst_17575 = (state_17627[(12)]);
var inst_17579 = done(null);
var inst_17580 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17575);
var state_17627__$1 = (function (){var statearr_17652 = state_17627;
(statearr_17652[(19)] = inst_17579);

return statearr_17652;
})();
var statearr_17653_17725 = state_17627__$1;
(statearr_17653_17725[(2)] = inst_17580);

(statearr_17653_17725[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (32))){
var inst_17568 = (state_17627[(9)]);
var inst_17570 = (state_17627[(11)]);
var inst_17567 = (state_17627[(20)]);
var inst_17569 = (state_17627[(21)]);
var inst_17582 = (state_17627[(2)]);
var inst_17583 = (inst_17570 + (1));
var tmp17648 = inst_17568;
var tmp17649 = inst_17567;
var tmp17650 = inst_17569;
var inst_17567__$1 = tmp17649;
var inst_17568__$1 = tmp17648;
var inst_17569__$1 = tmp17650;
var inst_17570__$1 = inst_17583;
var state_17627__$1 = (function (){var statearr_17654 = state_17627;
(statearr_17654[(22)] = inst_17582);

(statearr_17654[(9)] = inst_17568__$1);

(statearr_17654[(11)] = inst_17570__$1);

(statearr_17654[(20)] = inst_17567__$1);

(statearr_17654[(21)] = inst_17569__$1);

return statearr_17654;
})();
var statearr_17655_17726 = state_17627__$1;
(statearr_17655_17726[(2)] = null);

(statearr_17655_17726[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (40))){
var inst_17595 = (state_17627[(23)]);
var inst_17599 = done(null);
var inst_17600 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17595);
var state_17627__$1 = (function (){var statearr_17656 = state_17627;
(statearr_17656[(24)] = inst_17599);

return statearr_17656;
})();
var statearr_17657_17727 = state_17627__$1;
(statearr_17657_17727[(2)] = inst_17600);

(statearr_17657_17727[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (33))){
var inst_17586 = (state_17627[(25)]);
var inst_17588 = cljs.core.chunked_seq_QMARK_(inst_17586);
var state_17627__$1 = state_17627;
if(inst_17588){
var statearr_17658_17728 = state_17627__$1;
(statearr_17658_17728[(1)] = (36));

} else {
var statearr_17659_17729 = state_17627__$1;
(statearr_17659_17729[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (13))){
var inst_17516 = (state_17627[(26)]);
var inst_17519 = cljs.core.async.close_BANG_(inst_17516);
var state_17627__$1 = state_17627;
var statearr_17660_17730 = state_17627__$1;
(statearr_17660_17730[(2)] = inst_17519);

(statearr_17660_17730[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (22))){
var inst_17539 = (state_17627[(8)]);
var inst_17542 = cljs.core.async.close_BANG_(inst_17539);
var state_17627__$1 = state_17627;
var statearr_17661_17731 = state_17627__$1;
(statearr_17661_17731[(2)] = inst_17542);

(statearr_17661_17731[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (36))){
var inst_17586 = (state_17627[(25)]);
var inst_17590 = cljs.core.chunk_first(inst_17586);
var inst_17591 = cljs.core.chunk_rest(inst_17586);
var inst_17592 = cljs.core.count(inst_17590);
var inst_17567 = inst_17591;
var inst_17568 = inst_17590;
var inst_17569 = inst_17592;
var inst_17570 = (0);
var state_17627__$1 = (function (){var statearr_17662 = state_17627;
(statearr_17662[(9)] = inst_17568);

(statearr_17662[(11)] = inst_17570);

(statearr_17662[(20)] = inst_17567);

(statearr_17662[(21)] = inst_17569);

return statearr_17662;
})();
var statearr_17663_17732 = state_17627__$1;
(statearr_17663_17732[(2)] = null);

(statearr_17663_17732[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (41))){
var inst_17586 = (state_17627[(25)]);
var inst_17602 = (state_17627[(2)]);
var inst_17603 = cljs.core.next(inst_17586);
var inst_17567 = inst_17603;
var inst_17568 = null;
var inst_17569 = (0);
var inst_17570 = (0);
var state_17627__$1 = (function (){var statearr_17664 = state_17627;
(statearr_17664[(9)] = inst_17568);

(statearr_17664[(11)] = inst_17570);

(statearr_17664[(27)] = inst_17602);

(statearr_17664[(20)] = inst_17567);

(statearr_17664[(21)] = inst_17569);

return statearr_17664;
})();
var statearr_17665_17733 = state_17627__$1;
(statearr_17665_17733[(2)] = null);

(statearr_17665_17733[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (43))){
var state_17627__$1 = state_17627;
var statearr_17666_17734 = state_17627__$1;
(statearr_17666_17734[(2)] = null);

(statearr_17666_17734[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (29))){
var inst_17611 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17667_17735 = state_17627__$1;
(statearr_17667_17735[(2)] = inst_17611);

(statearr_17667_17735[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (44))){
var inst_17620 = (state_17627[(2)]);
var state_17627__$1 = (function (){var statearr_17668 = state_17627;
(statearr_17668[(28)] = inst_17620);

return statearr_17668;
})();
var statearr_17669_17736 = state_17627__$1;
(statearr_17669_17736[(2)] = null);

(statearr_17669_17736[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (6))){
var inst_17559 = (state_17627[(29)]);
var inst_17558 = cljs.core.deref(cs);
var inst_17559__$1 = cljs.core.keys(inst_17558);
var inst_17560 = cljs.core.count(inst_17559__$1);
var inst_17561 = cljs.core.reset_BANG_(dctr,inst_17560);
var inst_17566 = cljs.core.seq(inst_17559__$1);
var inst_17567 = inst_17566;
var inst_17568 = null;
var inst_17569 = (0);
var inst_17570 = (0);
var state_17627__$1 = (function (){var statearr_17670 = state_17627;
(statearr_17670[(9)] = inst_17568);

(statearr_17670[(11)] = inst_17570);

(statearr_17670[(20)] = inst_17567);

(statearr_17670[(21)] = inst_17569);

(statearr_17670[(29)] = inst_17559__$1);

(statearr_17670[(30)] = inst_17561);

return statearr_17670;
})();
var statearr_17671_17737 = state_17627__$1;
(statearr_17671_17737[(2)] = null);

(statearr_17671_17737[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (28))){
var inst_17586 = (state_17627[(25)]);
var inst_17567 = (state_17627[(20)]);
var inst_17586__$1 = cljs.core.seq(inst_17567);
var state_17627__$1 = (function (){var statearr_17672 = state_17627;
(statearr_17672[(25)] = inst_17586__$1);

return statearr_17672;
})();
if(inst_17586__$1){
var statearr_17673_17738 = state_17627__$1;
(statearr_17673_17738[(1)] = (33));

} else {
var statearr_17674_17739 = state_17627__$1;
(statearr_17674_17739[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (25))){
var inst_17570 = (state_17627[(11)]);
var inst_17569 = (state_17627[(21)]);
var inst_17572 = (inst_17570 < inst_17569);
var inst_17573 = inst_17572;
var state_17627__$1 = state_17627;
if(cljs.core.truth_(inst_17573)){
var statearr_17675_17740 = state_17627__$1;
(statearr_17675_17740[(1)] = (27));

} else {
var statearr_17676_17741 = state_17627__$1;
(statearr_17676_17741[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (34))){
var state_17627__$1 = state_17627;
var statearr_17677_17742 = state_17627__$1;
(statearr_17677_17742[(2)] = null);

(statearr_17677_17742[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (17))){
var state_17627__$1 = state_17627;
var statearr_17678_17743 = state_17627__$1;
(statearr_17678_17743[(2)] = null);

(statearr_17678_17743[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (3))){
var inst_17625 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17627__$1,inst_17625);
} else {
if((state_val_17628 === (12))){
var inst_17554 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17679_17744 = state_17627__$1;
(statearr_17679_17744[(2)] = inst_17554);

(statearr_17679_17744[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (2))){
var state_17627__$1 = state_17627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17627__$1,(4),ch);
} else {
if((state_val_17628 === (23))){
var state_17627__$1 = state_17627;
var statearr_17680_17745 = state_17627__$1;
(statearr_17680_17745[(2)] = null);

(statearr_17680_17745[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (35))){
var inst_17609 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17681_17746 = state_17627__$1;
(statearr_17681_17746[(2)] = inst_17609);

(statearr_17681_17746[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (19))){
var inst_17526 = (state_17627[(7)]);
var inst_17530 = cljs.core.chunk_first(inst_17526);
var inst_17531 = cljs.core.chunk_rest(inst_17526);
var inst_17532 = cljs.core.count(inst_17530);
var inst_17504 = inst_17531;
var inst_17505 = inst_17530;
var inst_17506 = inst_17532;
var inst_17507 = (0);
var state_17627__$1 = (function (){var statearr_17682 = state_17627;
(statearr_17682[(13)] = inst_17505);

(statearr_17682[(14)] = inst_17507);

(statearr_17682[(16)] = inst_17506);

(statearr_17682[(17)] = inst_17504);

return statearr_17682;
})();
var statearr_17683_17747 = state_17627__$1;
(statearr_17683_17747[(2)] = null);

(statearr_17683_17747[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (11))){
var inst_17504 = (state_17627[(17)]);
var inst_17526 = (state_17627[(7)]);
var inst_17526__$1 = cljs.core.seq(inst_17504);
var state_17627__$1 = (function (){var statearr_17684 = state_17627;
(statearr_17684[(7)] = inst_17526__$1);

return statearr_17684;
})();
if(inst_17526__$1){
var statearr_17685_17748 = state_17627__$1;
(statearr_17685_17748[(1)] = (16));

} else {
var statearr_17686_17749 = state_17627__$1;
(statearr_17686_17749[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (9))){
var inst_17556 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17687_17750 = state_17627__$1;
(statearr_17687_17750[(2)] = inst_17556);

(statearr_17687_17750[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (5))){
var inst_17502 = cljs.core.deref(cs);
var inst_17503 = cljs.core.seq(inst_17502);
var inst_17504 = inst_17503;
var inst_17505 = null;
var inst_17506 = (0);
var inst_17507 = (0);
var state_17627__$1 = (function (){var statearr_17688 = state_17627;
(statearr_17688[(13)] = inst_17505);

(statearr_17688[(14)] = inst_17507);

(statearr_17688[(16)] = inst_17506);

(statearr_17688[(17)] = inst_17504);

return statearr_17688;
})();
var statearr_17689_17751 = state_17627__$1;
(statearr_17689_17751[(2)] = null);

(statearr_17689_17751[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (14))){
var state_17627__$1 = state_17627;
var statearr_17690_17752 = state_17627__$1;
(statearr_17690_17752[(2)] = null);

(statearr_17690_17752[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (45))){
var inst_17617 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17691_17753 = state_17627__$1;
(statearr_17691_17753[(2)] = inst_17617);

(statearr_17691_17753[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (26))){
var inst_17559 = (state_17627[(29)]);
var inst_17613 = (state_17627[(2)]);
var inst_17614 = cljs.core.seq(inst_17559);
var state_17627__$1 = (function (){var statearr_17692 = state_17627;
(statearr_17692[(31)] = inst_17613);

return statearr_17692;
})();
if(inst_17614){
var statearr_17693_17754 = state_17627__$1;
(statearr_17693_17754[(1)] = (42));

} else {
var statearr_17694_17755 = state_17627__$1;
(statearr_17694_17755[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (16))){
var inst_17526 = (state_17627[(7)]);
var inst_17528 = cljs.core.chunked_seq_QMARK_(inst_17526);
var state_17627__$1 = state_17627;
if(inst_17528){
var statearr_17695_17756 = state_17627__$1;
(statearr_17695_17756[(1)] = (19));

} else {
var statearr_17696_17757 = state_17627__$1;
(statearr_17696_17757[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (38))){
var inst_17606 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17697_17758 = state_17627__$1;
(statearr_17697_17758[(2)] = inst_17606);

(statearr_17697_17758[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (30))){
var state_17627__$1 = state_17627;
var statearr_17698_17759 = state_17627__$1;
(statearr_17698_17759[(2)] = null);

(statearr_17698_17759[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (10))){
var inst_17505 = (state_17627[(13)]);
var inst_17507 = (state_17627[(14)]);
var inst_17515 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17505,inst_17507);
var inst_17516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17515,(0),null);
var inst_17517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17515,(1),null);
var state_17627__$1 = (function (){var statearr_17699 = state_17627;
(statearr_17699[(26)] = inst_17516);

return statearr_17699;
})();
if(cljs.core.truth_(inst_17517)){
var statearr_17700_17760 = state_17627__$1;
(statearr_17700_17760[(1)] = (13));

} else {
var statearr_17701_17761 = state_17627__$1;
(statearr_17701_17761[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (18))){
var inst_17552 = (state_17627[(2)]);
var state_17627__$1 = state_17627;
var statearr_17702_17762 = state_17627__$1;
(statearr_17702_17762[(2)] = inst_17552);

(statearr_17702_17762[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (42))){
var state_17627__$1 = state_17627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17627__$1,(45),dchan);
} else {
if((state_val_17628 === (37))){
var inst_17495 = (state_17627[(10)]);
var inst_17586 = (state_17627[(25)]);
var inst_17595 = (state_17627[(23)]);
var inst_17595__$1 = cljs.core.first(inst_17586);
var inst_17596 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17595__$1,inst_17495,done);
var state_17627__$1 = (function (){var statearr_17703 = state_17627;
(statearr_17703[(23)] = inst_17595__$1);

return statearr_17703;
})();
if(cljs.core.truth_(inst_17596)){
var statearr_17704_17763 = state_17627__$1;
(statearr_17704_17763[(1)] = (39));

} else {
var statearr_17705_17764 = state_17627__$1;
(statearr_17705_17764[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17628 === (8))){
var inst_17507 = (state_17627[(14)]);
var inst_17506 = (state_17627[(16)]);
var inst_17509 = (inst_17507 < inst_17506);
var inst_17510 = inst_17509;
var state_17627__$1 = state_17627;
if(cljs.core.truth_(inst_17510)){
var statearr_17706_17765 = state_17627__$1;
(statearr_17706_17765[(1)] = (10));

} else {
var statearr_17707_17766 = state_17627__$1;
(statearr_17707_17766[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___17712,cs,m,dchan,dctr,done))
;
return ((function (switch__16789__auto__,c__16891__auto___17712,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16790__auto__ = null;
var cljs$core$async$mult_$_state_machine__16790__auto____0 = (function (){
var statearr_17708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17708[(0)] = cljs$core$async$mult_$_state_machine__16790__auto__);

(statearr_17708[(1)] = (1));

return statearr_17708;
});
var cljs$core$async$mult_$_state_machine__16790__auto____1 = (function (state_17627){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17627);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17709){if((e17709 instanceof Object)){
var ex__16793__auto__ = e17709;
var statearr_17710_17767 = state_17627;
(statearr_17710_17767[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17627);

return cljs.core.cst$kw$recur;
} else {
throw e17709;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__17768 = state_17627;
state_17627 = G__17768;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16790__auto__ = function(state_17627){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16790__auto____1.call(this,state_17627);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16790__auto____0;
cljs$core$async$mult_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16790__auto____1;
return cljs$core$async$mult_$_state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___17712,cs,m,dchan,dctr,done))
})();
var state__16893__auto__ = (function (){var statearr_17711 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17711[(6)] = c__16891__auto___17712);

return statearr_17711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___17712,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__17770 = arguments.length;
switch (G__17770) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto__.call(null,m));
} else {
var m__9540__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9540__auto__.call(null,m,state_map));
} else {
var m__9540__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9540__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9540__auto__.call(null,m,mode));
} else {
var m__9540__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9540__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10092__auto__ = [];
var len__10085__auto___17782 = arguments.length;
var i__10086__auto___17783 = (0);
while(true){
if((i__10086__auto___17783 < len__10085__auto___17782)){
args__10092__auto__.push((arguments[i__10086__auto___17783]));

var G__17784 = (i__10086__auto___17783 + (1));
i__10086__auto___17783 = G__17784;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((3) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10093__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17776){
var map__17777 = p__17776;
var map__17777__$1 = ((((!((map__17777 == null)))?((((map__17777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17777.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17777):map__17777);
var opts = map__17777__$1;
var statearr_17779_17785 = state;
(statearr_17779_17785[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__17777,map__17777__$1,opts){
return (function (val){
var statearr_17780_17786 = state;
(statearr_17780_17786[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__17777,map__17777__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_17781_17787 = state;
(statearr_17781_17787[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17772){
var G__17773 = cljs.core.first(seq17772);
var seq17772__$1 = cljs.core.next(seq17772);
var G__17774 = cljs.core.first(seq17772__$1);
var seq17772__$2 = cljs.core.next(seq17772__$1);
var G__17775 = cljs.core.first(seq17772__$2);
var seq17772__$3 = cljs.core.next(seq17772__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17773,G__17774,G__17775,seq17772__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17788 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17788 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta17789){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta17789 = meta17789;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17788.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17790,meta17789__$1){
var self__ = this;
var _17790__$1 = this;
return (new cljs.core.async.t_cljs$core$async17788(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta17789__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17788.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17790){
var self__ = this;
var _17790__$1 = this;
return self__.meta17789;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17788.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17788.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17788.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17788.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17788.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17788.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17788.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17788.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17788.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta17789], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17788.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17788.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17788";

cljs.core.async.t_cljs$core$async17788.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17788");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async17788 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async17788(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17789){
return (new cljs.core.async.t_cljs$core$async17788(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17789));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async17788(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16891__auto___17952 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___17952,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___17952,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_17892){
var state_val_17893 = (state_17892[(1)]);
if((state_val_17893 === (7))){
var inst_17807 = (state_17892[(2)]);
var state_17892__$1 = state_17892;
var statearr_17894_17953 = state_17892__$1;
(statearr_17894_17953[(2)] = inst_17807);

(statearr_17894_17953[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (20))){
var inst_17819 = (state_17892[(7)]);
var state_17892__$1 = state_17892;
var statearr_17895_17954 = state_17892__$1;
(statearr_17895_17954[(2)] = inst_17819);

(statearr_17895_17954[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (27))){
var state_17892__$1 = state_17892;
var statearr_17896_17955 = state_17892__$1;
(statearr_17896_17955[(2)] = null);

(statearr_17896_17955[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (1))){
var inst_17794 = (state_17892[(8)]);
var inst_17794__$1 = calc_state();
var inst_17796 = (inst_17794__$1 == null);
var inst_17797 = cljs.core.not(inst_17796);
var state_17892__$1 = (function (){var statearr_17897 = state_17892;
(statearr_17897[(8)] = inst_17794__$1);

return statearr_17897;
})();
if(inst_17797){
var statearr_17898_17956 = state_17892__$1;
(statearr_17898_17956[(1)] = (2));

} else {
var statearr_17899_17957 = state_17892__$1;
(statearr_17899_17957[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (24))){
var inst_17852 = (state_17892[(9)]);
var inst_17866 = (state_17892[(10)]);
var inst_17843 = (state_17892[(11)]);
var inst_17866__$1 = (inst_17843.cljs$core$IFn$_invoke$arity$1 ? inst_17843.cljs$core$IFn$_invoke$arity$1(inst_17852) : inst_17843.call(null,inst_17852));
var state_17892__$1 = (function (){var statearr_17900 = state_17892;
(statearr_17900[(10)] = inst_17866__$1);

return statearr_17900;
})();
if(cljs.core.truth_(inst_17866__$1)){
var statearr_17901_17958 = state_17892__$1;
(statearr_17901_17958[(1)] = (29));

} else {
var statearr_17902_17959 = state_17892__$1;
(statearr_17902_17959[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (4))){
var inst_17810 = (state_17892[(2)]);
var state_17892__$1 = state_17892;
if(cljs.core.truth_(inst_17810)){
var statearr_17903_17960 = state_17892__$1;
(statearr_17903_17960[(1)] = (8));

} else {
var statearr_17904_17961 = state_17892__$1;
(statearr_17904_17961[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (15))){
var inst_17837 = (state_17892[(2)]);
var state_17892__$1 = state_17892;
if(cljs.core.truth_(inst_17837)){
var statearr_17905_17962 = state_17892__$1;
(statearr_17905_17962[(1)] = (19));

} else {
var statearr_17906_17963 = state_17892__$1;
(statearr_17906_17963[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (21))){
var inst_17842 = (state_17892[(12)]);
var inst_17842__$1 = (state_17892[(2)]);
var inst_17843 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17842__$1,cljs.core.cst$kw$solos);
var inst_17844 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17842__$1,cljs.core.cst$kw$mutes);
var inst_17845 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17842__$1,cljs.core.cst$kw$reads);
var state_17892__$1 = (function (){var statearr_17907 = state_17892;
(statearr_17907[(13)] = inst_17844);

(statearr_17907[(12)] = inst_17842__$1);

(statearr_17907[(11)] = inst_17843);

return statearr_17907;
})();
return cljs.core.async.ioc_alts_BANG_(state_17892__$1,(22),inst_17845);
} else {
if((state_val_17893 === (31))){
var inst_17874 = (state_17892[(2)]);
var state_17892__$1 = state_17892;
if(cljs.core.truth_(inst_17874)){
var statearr_17908_17964 = state_17892__$1;
(statearr_17908_17964[(1)] = (32));

} else {
var statearr_17909_17965 = state_17892__$1;
(statearr_17909_17965[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (32))){
var inst_17851 = (state_17892[(14)]);
var state_17892__$1 = state_17892;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17892__$1,(35),out,inst_17851);
} else {
if((state_val_17893 === (33))){
var inst_17842 = (state_17892[(12)]);
var inst_17819 = inst_17842;
var state_17892__$1 = (function (){var statearr_17910 = state_17892;
(statearr_17910[(7)] = inst_17819);

return statearr_17910;
})();
var statearr_17911_17966 = state_17892__$1;
(statearr_17911_17966[(2)] = null);

(statearr_17911_17966[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (13))){
var inst_17819 = (state_17892[(7)]);
var inst_17826 = inst_17819.cljs$lang$protocol_mask$partition0$;
var inst_17827 = (inst_17826 & (64));
var inst_17828 = inst_17819.cljs$core$ISeq$;
var inst_17829 = (cljs.core.PROTOCOL_SENTINEL === inst_17828);
var inst_17830 = (inst_17827) || (inst_17829);
var state_17892__$1 = state_17892;
if(cljs.core.truth_(inst_17830)){
var statearr_17912_17967 = state_17892__$1;
(statearr_17912_17967[(1)] = (16));

} else {
var statearr_17913_17968 = state_17892__$1;
(statearr_17913_17968[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (22))){
var inst_17851 = (state_17892[(14)]);
var inst_17852 = (state_17892[(9)]);
var inst_17850 = (state_17892[(2)]);
var inst_17851__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17850,(0),null);
var inst_17852__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17850,(1),null);
var inst_17853 = (inst_17851__$1 == null);
var inst_17854 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17852__$1,change);
var inst_17855 = (inst_17853) || (inst_17854);
var state_17892__$1 = (function (){var statearr_17914 = state_17892;
(statearr_17914[(14)] = inst_17851__$1);

(statearr_17914[(9)] = inst_17852__$1);

return statearr_17914;
})();
if(cljs.core.truth_(inst_17855)){
var statearr_17915_17969 = state_17892__$1;
(statearr_17915_17969[(1)] = (23));

} else {
var statearr_17916_17970 = state_17892__$1;
(statearr_17916_17970[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (36))){
var inst_17842 = (state_17892[(12)]);
var inst_17819 = inst_17842;
var state_17892__$1 = (function (){var statearr_17917 = state_17892;
(statearr_17917[(7)] = inst_17819);

return statearr_17917;
})();
var statearr_17918_17971 = state_17892__$1;
(statearr_17918_17971[(2)] = null);

(statearr_17918_17971[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (29))){
var inst_17866 = (state_17892[(10)]);
var state_17892__$1 = state_17892;
var statearr_17919_17972 = state_17892__$1;
(statearr_17919_17972[(2)] = inst_17866);

(statearr_17919_17972[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (6))){
var state_17892__$1 = state_17892;
var statearr_17920_17973 = state_17892__$1;
(statearr_17920_17973[(2)] = false);

(statearr_17920_17973[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (28))){
var inst_17862 = (state_17892[(2)]);
var inst_17863 = calc_state();
var inst_17819 = inst_17863;
var state_17892__$1 = (function (){var statearr_17921 = state_17892;
(statearr_17921[(7)] = inst_17819);

(statearr_17921[(15)] = inst_17862);

return statearr_17921;
})();
var statearr_17922_17974 = state_17892__$1;
(statearr_17922_17974[(2)] = null);

(statearr_17922_17974[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (25))){
var inst_17888 = (state_17892[(2)]);
var state_17892__$1 = state_17892;
var statearr_17923_17975 = state_17892__$1;
(statearr_17923_17975[(2)] = inst_17888);

(statearr_17923_17975[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (34))){
var inst_17886 = (state_17892[(2)]);
var state_17892__$1 = state_17892;
var statearr_17924_17976 = state_17892__$1;
(statearr_17924_17976[(2)] = inst_17886);

(statearr_17924_17976[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (17))){
var state_17892__$1 = state_17892;
var statearr_17925_17977 = state_17892__$1;
(statearr_17925_17977[(2)] = false);

(statearr_17925_17977[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (3))){
var state_17892__$1 = state_17892;
var statearr_17926_17978 = state_17892__$1;
(statearr_17926_17978[(2)] = false);

(statearr_17926_17978[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (12))){
var inst_17890 = (state_17892[(2)]);
var state_17892__$1 = state_17892;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17892__$1,inst_17890);
} else {
if((state_val_17893 === (2))){
var inst_17794 = (state_17892[(8)]);
var inst_17799 = inst_17794.cljs$lang$protocol_mask$partition0$;
var inst_17800 = (inst_17799 & (64));
var inst_17801 = inst_17794.cljs$core$ISeq$;
var inst_17802 = (cljs.core.PROTOCOL_SENTINEL === inst_17801);
var inst_17803 = (inst_17800) || (inst_17802);
var state_17892__$1 = state_17892;
if(cljs.core.truth_(inst_17803)){
var statearr_17927_17979 = state_17892__$1;
(statearr_17927_17979[(1)] = (5));

} else {
var statearr_17928_17980 = state_17892__$1;
(statearr_17928_17980[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (23))){
var inst_17851 = (state_17892[(14)]);
var inst_17857 = (inst_17851 == null);
var state_17892__$1 = state_17892;
if(cljs.core.truth_(inst_17857)){
var statearr_17929_17981 = state_17892__$1;
(statearr_17929_17981[(1)] = (26));

} else {
var statearr_17930_17982 = state_17892__$1;
(statearr_17930_17982[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (35))){
var inst_17877 = (state_17892[(2)]);
var state_17892__$1 = state_17892;
if(cljs.core.truth_(inst_17877)){
var statearr_17931_17983 = state_17892__$1;
(statearr_17931_17983[(1)] = (36));

} else {
var statearr_17932_17984 = state_17892__$1;
(statearr_17932_17984[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (19))){
var inst_17819 = (state_17892[(7)]);
var inst_17839 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17819);
var state_17892__$1 = state_17892;
var statearr_17933_17985 = state_17892__$1;
(statearr_17933_17985[(2)] = inst_17839);

(statearr_17933_17985[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (11))){
var inst_17819 = (state_17892[(7)]);
var inst_17823 = (inst_17819 == null);
var inst_17824 = cljs.core.not(inst_17823);
var state_17892__$1 = state_17892;
if(inst_17824){
var statearr_17934_17986 = state_17892__$1;
(statearr_17934_17986[(1)] = (13));

} else {
var statearr_17935_17987 = state_17892__$1;
(statearr_17935_17987[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (9))){
var inst_17794 = (state_17892[(8)]);
var state_17892__$1 = state_17892;
var statearr_17936_17988 = state_17892__$1;
(statearr_17936_17988[(2)] = inst_17794);

(statearr_17936_17988[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (5))){
var state_17892__$1 = state_17892;
var statearr_17937_17989 = state_17892__$1;
(statearr_17937_17989[(2)] = true);

(statearr_17937_17989[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (14))){
var state_17892__$1 = state_17892;
var statearr_17938_17990 = state_17892__$1;
(statearr_17938_17990[(2)] = false);

(statearr_17938_17990[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (26))){
var inst_17852 = (state_17892[(9)]);
var inst_17859 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_17852);
var state_17892__$1 = state_17892;
var statearr_17939_17991 = state_17892__$1;
(statearr_17939_17991[(2)] = inst_17859);

(statearr_17939_17991[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (16))){
var state_17892__$1 = state_17892;
var statearr_17940_17992 = state_17892__$1;
(statearr_17940_17992[(2)] = true);

(statearr_17940_17992[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (38))){
var inst_17882 = (state_17892[(2)]);
var state_17892__$1 = state_17892;
var statearr_17941_17993 = state_17892__$1;
(statearr_17941_17993[(2)] = inst_17882);

(statearr_17941_17993[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (30))){
var inst_17844 = (state_17892[(13)]);
var inst_17852 = (state_17892[(9)]);
var inst_17843 = (state_17892[(11)]);
var inst_17869 = cljs.core.empty_QMARK_(inst_17843);
var inst_17870 = (inst_17844.cljs$core$IFn$_invoke$arity$1 ? inst_17844.cljs$core$IFn$_invoke$arity$1(inst_17852) : inst_17844.call(null,inst_17852));
var inst_17871 = cljs.core.not(inst_17870);
var inst_17872 = (inst_17869) && (inst_17871);
var state_17892__$1 = state_17892;
var statearr_17942_17994 = state_17892__$1;
(statearr_17942_17994[(2)] = inst_17872);

(statearr_17942_17994[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (10))){
var inst_17794 = (state_17892[(8)]);
var inst_17815 = (state_17892[(2)]);
var inst_17816 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17815,cljs.core.cst$kw$solos);
var inst_17817 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17815,cljs.core.cst$kw$mutes);
var inst_17818 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17815,cljs.core.cst$kw$reads);
var inst_17819 = inst_17794;
var state_17892__$1 = (function (){var statearr_17943 = state_17892;
(statearr_17943[(7)] = inst_17819);

(statearr_17943[(16)] = inst_17817);

(statearr_17943[(17)] = inst_17816);

(statearr_17943[(18)] = inst_17818);

return statearr_17943;
})();
var statearr_17944_17995 = state_17892__$1;
(statearr_17944_17995[(2)] = null);

(statearr_17944_17995[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (18))){
var inst_17834 = (state_17892[(2)]);
var state_17892__$1 = state_17892;
var statearr_17945_17996 = state_17892__$1;
(statearr_17945_17996[(2)] = inst_17834);

(statearr_17945_17996[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (37))){
var state_17892__$1 = state_17892;
var statearr_17946_17997 = state_17892__$1;
(statearr_17946_17997[(2)] = null);

(statearr_17946_17997[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17893 === (8))){
var inst_17794 = (state_17892[(8)]);
var inst_17812 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17794);
var state_17892__$1 = state_17892;
var statearr_17947_17998 = state_17892__$1;
(statearr_17947_17998[(2)] = inst_17812);

(statearr_17947_17998[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___17952,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__16789__auto__,c__16891__auto___17952,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__16790__auto__ = null;
var cljs$core$async$mix_$_state_machine__16790__auto____0 = (function (){
var statearr_17948 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17948[(0)] = cljs$core$async$mix_$_state_machine__16790__auto__);

(statearr_17948[(1)] = (1));

return statearr_17948;
});
var cljs$core$async$mix_$_state_machine__16790__auto____1 = (function (state_17892){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_17892);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e17949){if((e17949 instanceof Object)){
var ex__16793__auto__ = e17949;
var statearr_17950_17999 = state_17892;
(statearr_17950_17999[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17892);

return cljs.core.cst$kw$recur;
} else {
throw e17949;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18000 = state_17892;
state_17892 = G__18000;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16790__auto__ = function(state_17892){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16790__auto____1.call(this,state_17892);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16790__auto____0;
cljs$core$async$mix_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16790__auto____1;
return cljs$core$async$mix_$_state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___17952,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__16893__auto__ = (function (){var statearr_17951 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_17951[(6)] = c__16891__auto___17952);

return statearr_17951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___17952,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9540__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__9540__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9540__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9540__auto__.call(null,p,v,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9540__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__18002 = arguments.length;
switch (G__18002) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__9540__auto__.call(null,p));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__9540__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__9540__auto__.call(null,p,v));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__9540__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__18006 = arguments.length;
switch (G__18006) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8806__auto__,mults){
return (function (p1__18004_SHARP_){
if(cljs.core.truth_((p1__18004_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18004_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__18004_SHARP_.call(null,topic)))){
return p1__18004_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__18004_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__8806__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async18007 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18007 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18008){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18008 = meta18008;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18007.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_18009,meta18008__$1){
var self__ = this;
var _18009__$1 = this;
return (new cljs.core.async.t_cljs$core$async18007(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18008__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18007.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_18009){
var self__ = this;
var _18009__$1 = this;
return self__.meta18008;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18007.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18007.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18007.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18007.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18007.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18007.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18007.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18007.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta18008], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18007.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18007.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18007";

cljs.core.async.t_cljs$core$async18007.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18007");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async18007 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async18007(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18008){
return (new cljs.core.async.t_cljs$core$async18007(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18008));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async18007(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16891__auto___18127 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___18127,mults,ensure_mult,p){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___18127,mults,ensure_mult,p){
return (function (state_18081){
var state_val_18082 = (state_18081[(1)]);
if((state_val_18082 === (7))){
var inst_18077 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
var statearr_18083_18128 = state_18081__$1;
(statearr_18083_18128[(2)] = inst_18077);

(statearr_18083_18128[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (20))){
var state_18081__$1 = state_18081;
var statearr_18084_18129 = state_18081__$1;
(statearr_18084_18129[(2)] = null);

(statearr_18084_18129[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (1))){
var state_18081__$1 = state_18081;
var statearr_18085_18130 = state_18081__$1;
(statearr_18085_18130[(2)] = null);

(statearr_18085_18130[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (24))){
var inst_18060 = (state_18081[(7)]);
var inst_18069 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_18060);
var state_18081__$1 = state_18081;
var statearr_18086_18131 = state_18081__$1;
(statearr_18086_18131[(2)] = inst_18069);

(statearr_18086_18131[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (4))){
var inst_18012 = (state_18081[(8)]);
var inst_18012__$1 = (state_18081[(2)]);
var inst_18013 = (inst_18012__$1 == null);
var state_18081__$1 = (function (){var statearr_18087 = state_18081;
(statearr_18087[(8)] = inst_18012__$1);

return statearr_18087;
})();
if(cljs.core.truth_(inst_18013)){
var statearr_18088_18132 = state_18081__$1;
(statearr_18088_18132[(1)] = (5));

} else {
var statearr_18089_18133 = state_18081__$1;
(statearr_18089_18133[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (15))){
var inst_18054 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
var statearr_18090_18134 = state_18081__$1;
(statearr_18090_18134[(2)] = inst_18054);

(statearr_18090_18134[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (21))){
var inst_18074 = (state_18081[(2)]);
var state_18081__$1 = (function (){var statearr_18091 = state_18081;
(statearr_18091[(9)] = inst_18074);

return statearr_18091;
})();
var statearr_18092_18135 = state_18081__$1;
(statearr_18092_18135[(2)] = null);

(statearr_18092_18135[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (13))){
var inst_18036 = (state_18081[(10)]);
var inst_18038 = cljs.core.chunked_seq_QMARK_(inst_18036);
var state_18081__$1 = state_18081;
if(inst_18038){
var statearr_18093_18136 = state_18081__$1;
(statearr_18093_18136[(1)] = (16));

} else {
var statearr_18094_18137 = state_18081__$1;
(statearr_18094_18137[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (22))){
var inst_18066 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
if(cljs.core.truth_(inst_18066)){
var statearr_18095_18138 = state_18081__$1;
(statearr_18095_18138[(1)] = (23));

} else {
var statearr_18096_18139 = state_18081__$1;
(statearr_18096_18139[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (6))){
var inst_18012 = (state_18081[(8)]);
var inst_18062 = (state_18081[(11)]);
var inst_18060 = (state_18081[(7)]);
var inst_18060__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_18012) : topic_fn.call(null,inst_18012));
var inst_18061 = cljs.core.deref(mults);
var inst_18062__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18061,inst_18060__$1);
var state_18081__$1 = (function (){var statearr_18097 = state_18081;
(statearr_18097[(11)] = inst_18062__$1);

(statearr_18097[(7)] = inst_18060__$1);

return statearr_18097;
})();
if(cljs.core.truth_(inst_18062__$1)){
var statearr_18098_18140 = state_18081__$1;
(statearr_18098_18140[(1)] = (19));

} else {
var statearr_18099_18141 = state_18081__$1;
(statearr_18099_18141[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (25))){
var inst_18071 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
var statearr_18100_18142 = state_18081__$1;
(statearr_18100_18142[(2)] = inst_18071);

(statearr_18100_18142[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (17))){
var inst_18036 = (state_18081[(10)]);
var inst_18045 = cljs.core.first(inst_18036);
var inst_18046 = cljs.core.async.muxch_STAR_(inst_18045);
var inst_18047 = cljs.core.async.close_BANG_(inst_18046);
var inst_18048 = cljs.core.next(inst_18036);
var inst_18022 = inst_18048;
var inst_18023 = null;
var inst_18024 = (0);
var inst_18025 = (0);
var state_18081__$1 = (function (){var statearr_18101 = state_18081;
(statearr_18101[(12)] = inst_18047);

(statearr_18101[(13)] = inst_18022);

(statearr_18101[(14)] = inst_18023);

(statearr_18101[(15)] = inst_18024);

(statearr_18101[(16)] = inst_18025);

return statearr_18101;
})();
var statearr_18102_18143 = state_18081__$1;
(statearr_18102_18143[(2)] = null);

(statearr_18102_18143[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (3))){
var inst_18079 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18081__$1,inst_18079);
} else {
if((state_val_18082 === (12))){
var inst_18056 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
var statearr_18103_18144 = state_18081__$1;
(statearr_18103_18144[(2)] = inst_18056);

(statearr_18103_18144[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (2))){
var state_18081__$1 = state_18081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18081__$1,(4),ch);
} else {
if((state_val_18082 === (23))){
var state_18081__$1 = state_18081;
var statearr_18104_18145 = state_18081__$1;
(statearr_18104_18145[(2)] = null);

(statearr_18104_18145[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (19))){
var inst_18012 = (state_18081[(8)]);
var inst_18062 = (state_18081[(11)]);
var inst_18064 = cljs.core.async.muxch_STAR_(inst_18062);
var state_18081__$1 = state_18081;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18081__$1,(22),inst_18064,inst_18012);
} else {
if((state_val_18082 === (11))){
var inst_18022 = (state_18081[(13)]);
var inst_18036 = (state_18081[(10)]);
var inst_18036__$1 = cljs.core.seq(inst_18022);
var state_18081__$1 = (function (){var statearr_18105 = state_18081;
(statearr_18105[(10)] = inst_18036__$1);

return statearr_18105;
})();
if(inst_18036__$1){
var statearr_18106_18146 = state_18081__$1;
(statearr_18106_18146[(1)] = (13));

} else {
var statearr_18107_18147 = state_18081__$1;
(statearr_18107_18147[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (9))){
var inst_18058 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
var statearr_18108_18148 = state_18081__$1;
(statearr_18108_18148[(2)] = inst_18058);

(statearr_18108_18148[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (5))){
var inst_18019 = cljs.core.deref(mults);
var inst_18020 = cljs.core.vals(inst_18019);
var inst_18021 = cljs.core.seq(inst_18020);
var inst_18022 = inst_18021;
var inst_18023 = null;
var inst_18024 = (0);
var inst_18025 = (0);
var state_18081__$1 = (function (){var statearr_18109 = state_18081;
(statearr_18109[(13)] = inst_18022);

(statearr_18109[(14)] = inst_18023);

(statearr_18109[(15)] = inst_18024);

(statearr_18109[(16)] = inst_18025);

return statearr_18109;
})();
var statearr_18110_18149 = state_18081__$1;
(statearr_18110_18149[(2)] = null);

(statearr_18110_18149[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (14))){
var state_18081__$1 = state_18081;
var statearr_18114_18150 = state_18081__$1;
(statearr_18114_18150[(2)] = null);

(statearr_18114_18150[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (16))){
var inst_18036 = (state_18081[(10)]);
var inst_18040 = cljs.core.chunk_first(inst_18036);
var inst_18041 = cljs.core.chunk_rest(inst_18036);
var inst_18042 = cljs.core.count(inst_18040);
var inst_18022 = inst_18041;
var inst_18023 = inst_18040;
var inst_18024 = inst_18042;
var inst_18025 = (0);
var state_18081__$1 = (function (){var statearr_18115 = state_18081;
(statearr_18115[(13)] = inst_18022);

(statearr_18115[(14)] = inst_18023);

(statearr_18115[(15)] = inst_18024);

(statearr_18115[(16)] = inst_18025);

return statearr_18115;
})();
var statearr_18116_18151 = state_18081__$1;
(statearr_18116_18151[(2)] = null);

(statearr_18116_18151[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (10))){
var inst_18022 = (state_18081[(13)]);
var inst_18023 = (state_18081[(14)]);
var inst_18024 = (state_18081[(15)]);
var inst_18025 = (state_18081[(16)]);
var inst_18030 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18023,inst_18025);
var inst_18031 = cljs.core.async.muxch_STAR_(inst_18030);
var inst_18032 = cljs.core.async.close_BANG_(inst_18031);
var inst_18033 = (inst_18025 + (1));
var tmp18111 = inst_18022;
var tmp18112 = inst_18023;
var tmp18113 = inst_18024;
var inst_18022__$1 = tmp18111;
var inst_18023__$1 = tmp18112;
var inst_18024__$1 = tmp18113;
var inst_18025__$1 = inst_18033;
var state_18081__$1 = (function (){var statearr_18117 = state_18081;
(statearr_18117[(13)] = inst_18022__$1);

(statearr_18117[(14)] = inst_18023__$1);

(statearr_18117[(15)] = inst_18024__$1);

(statearr_18117[(16)] = inst_18025__$1);

(statearr_18117[(17)] = inst_18032);

return statearr_18117;
})();
var statearr_18118_18152 = state_18081__$1;
(statearr_18118_18152[(2)] = null);

(statearr_18118_18152[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (18))){
var inst_18051 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
var statearr_18119_18153 = state_18081__$1;
(statearr_18119_18153[(2)] = inst_18051);

(statearr_18119_18153[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18082 === (8))){
var inst_18024 = (state_18081[(15)]);
var inst_18025 = (state_18081[(16)]);
var inst_18027 = (inst_18025 < inst_18024);
var inst_18028 = inst_18027;
var state_18081__$1 = state_18081;
if(cljs.core.truth_(inst_18028)){
var statearr_18120_18154 = state_18081__$1;
(statearr_18120_18154[(1)] = (10));

} else {
var statearr_18121_18155 = state_18081__$1;
(statearr_18121_18155[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___18127,mults,ensure_mult,p))
;
return ((function (switch__16789__auto__,c__16891__auto___18127,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_18122 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18122[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_18122[(1)] = (1));

return statearr_18122;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_18081){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18081);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18123){if((e18123 instanceof Object)){
var ex__16793__auto__ = e18123;
var statearr_18124_18156 = state_18081;
(statearr_18124_18156[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18081);

return cljs.core.cst$kw$recur;
} else {
throw e18123;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18157 = state_18081;
state_18081 = G__18157;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_18081){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_18081);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___18127,mults,ensure_mult,p))
})();
var state__16893__auto__ = (function (){var statearr_18125 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18125[(6)] = c__16891__auto___18127);

return statearr_18125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___18127,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__18159 = arguments.length;
switch (G__18159) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__18162 = arguments.length;
switch (G__18162) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__18165 = arguments.length;
switch (G__18165) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__16891__auto___18232 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___18232,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___18232,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_18204){
var state_val_18205 = (state_18204[(1)]);
if((state_val_18205 === (7))){
var state_18204__$1 = state_18204;
var statearr_18206_18233 = state_18204__$1;
(statearr_18206_18233[(2)] = null);

(statearr_18206_18233[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (1))){
var state_18204__$1 = state_18204;
var statearr_18207_18234 = state_18204__$1;
(statearr_18207_18234[(2)] = null);

(statearr_18207_18234[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (4))){
var inst_18168 = (state_18204[(7)]);
var inst_18170 = (inst_18168 < cnt);
var state_18204__$1 = state_18204;
if(cljs.core.truth_(inst_18170)){
var statearr_18208_18235 = state_18204__$1;
(statearr_18208_18235[(1)] = (6));

} else {
var statearr_18209_18236 = state_18204__$1;
(statearr_18209_18236[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (15))){
var inst_18200 = (state_18204[(2)]);
var state_18204__$1 = state_18204;
var statearr_18210_18237 = state_18204__$1;
(statearr_18210_18237[(2)] = inst_18200);

(statearr_18210_18237[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (13))){
var inst_18193 = cljs.core.async.close_BANG_(out);
var state_18204__$1 = state_18204;
var statearr_18211_18238 = state_18204__$1;
(statearr_18211_18238[(2)] = inst_18193);

(statearr_18211_18238[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (6))){
var state_18204__$1 = state_18204;
var statearr_18212_18239 = state_18204__$1;
(statearr_18212_18239[(2)] = null);

(statearr_18212_18239[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (3))){
var inst_18202 = (state_18204[(2)]);
var state_18204__$1 = state_18204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18204__$1,inst_18202);
} else {
if((state_val_18205 === (12))){
var inst_18190 = (state_18204[(8)]);
var inst_18190__$1 = (state_18204[(2)]);
var inst_18191 = cljs.core.some(cljs.core.nil_QMARK_,inst_18190__$1);
var state_18204__$1 = (function (){var statearr_18213 = state_18204;
(statearr_18213[(8)] = inst_18190__$1);

return statearr_18213;
})();
if(cljs.core.truth_(inst_18191)){
var statearr_18214_18240 = state_18204__$1;
(statearr_18214_18240[(1)] = (13));

} else {
var statearr_18215_18241 = state_18204__$1;
(statearr_18215_18241[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (2))){
var inst_18167 = cljs.core.reset_BANG_(dctr,cnt);
var inst_18168 = (0);
var state_18204__$1 = (function (){var statearr_18216 = state_18204;
(statearr_18216[(9)] = inst_18167);

(statearr_18216[(7)] = inst_18168);

return statearr_18216;
})();
var statearr_18217_18242 = state_18204__$1;
(statearr_18217_18242[(2)] = null);

(statearr_18217_18242[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (11))){
var inst_18168 = (state_18204[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_18204,(10),Object,null,(9));
var inst_18177 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_18168) : chs__$1.call(null,inst_18168));
var inst_18178 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_18168) : done.call(null,inst_18168));
var inst_18179 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18177,inst_18178);
var state_18204__$1 = state_18204;
var statearr_18218_18243 = state_18204__$1;
(statearr_18218_18243[(2)] = inst_18179);


cljs.core.async.impl.ioc_helpers.process_exception(state_18204__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (9))){
var inst_18168 = (state_18204[(7)]);
var inst_18181 = (state_18204[(2)]);
var inst_18182 = (inst_18168 + (1));
var inst_18168__$1 = inst_18182;
var state_18204__$1 = (function (){var statearr_18219 = state_18204;
(statearr_18219[(7)] = inst_18168__$1);

(statearr_18219[(10)] = inst_18181);

return statearr_18219;
})();
var statearr_18220_18244 = state_18204__$1;
(statearr_18220_18244[(2)] = null);

(statearr_18220_18244[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (5))){
var inst_18188 = (state_18204[(2)]);
var state_18204__$1 = (function (){var statearr_18221 = state_18204;
(statearr_18221[(11)] = inst_18188);

return statearr_18221;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18204__$1,(12),dchan);
} else {
if((state_val_18205 === (14))){
var inst_18190 = (state_18204[(8)]);
var inst_18195 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_18190);
var state_18204__$1 = state_18204;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18204__$1,(16),out,inst_18195);
} else {
if((state_val_18205 === (16))){
var inst_18197 = (state_18204[(2)]);
var state_18204__$1 = (function (){var statearr_18222 = state_18204;
(statearr_18222[(12)] = inst_18197);

return statearr_18222;
})();
var statearr_18223_18245 = state_18204__$1;
(statearr_18223_18245[(2)] = null);

(statearr_18223_18245[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (10))){
var inst_18172 = (state_18204[(2)]);
var inst_18173 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_18204__$1 = (function (){var statearr_18224 = state_18204;
(statearr_18224[(13)] = inst_18172);

return statearr_18224;
})();
var statearr_18225_18246 = state_18204__$1;
(statearr_18225_18246[(2)] = inst_18173);


cljs.core.async.impl.ioc_helpers.process_exception(state_18204__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18205 === (8))){
var inst_18186 = (state_18204[(2)]);
var state_18204__$1 = state_18204;
var statearr_18226_18247 = state_18204__$1;
(statearr_18226_18247[(2)] = inst_18186);

(statearr_18226_18247[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___18232,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16789__auto__,c__16891__auto___18232,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_18227 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18227[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_18227[(1)] = (1));

return statearr_18227;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_18204){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18204);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18228){if((e18228 instanceof Object)){
var ex__16793__auto__ = e18228;
var statearr_18229_18248 = state_18204;
(statearr_18229_18248[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18204);

return cljs.core.cst$kw$recur;
} else {
throw e18228;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18249 = state_18204;
state_18204 = G__18249;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_18204){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_18204);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___18232,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16893__auto__ = (function (){var statearr_18230 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18230[(6)] = c__16891__auto___18232);

return statearr_18230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___18232,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__18252 = arguments.length;
switch (G__18252) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16891__auto___18306 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___18306,out){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___18306,out){
return (function (state_18284){
var state_val_18285 = (state_18284[(1)]);
if((state_val_18285 === (7))){
var inst_18264 = (state_18284[(7)]);
var inst_18263 = (state_18284[(8)]);
var inst_18263__$1 = (state_18284[(2)]);
var inst_18264__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18263__$1,(0),null);
var inst_18265 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18263__$1,(1),null);
var inst_18266 = (inst_18264__$1 == null);
var state_18284__$1 = (function (){var statearr_18286 = state_18284;
(statearr_18286[(7)] = inst_18264__$1);

(statearr_18286[(8)] = inst_18263__$1);

(statearr_18286[(9)] = inst_18265);

return statearr_18286;
})();
if(cljs.core.truth_(inst_18266)){
var statearr_18287_18307 = state_18284__$1;
(statearr_18287_18307[(1)] = (8));

} else {
var statearr_18288_18308 = state_18284__$1;
(statearr_18288_18308[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18285 === (1))){
var inst_18253 = cljs.core.vec(chs);
var inst_18254 = inst_18253;
var state_18284__$1 = (function (){var statearr_18289 = state_18284;
(statearr_18289[(10)] = inst_18254);

return statearr_18289;
})();
var statearr_18290_18309 = state_18284__$1;
(statearr_18290_18309[(2)] = null);

(statearr_18290_18309[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18285 === (4))){
var inst_18254 = (state_18284[(10)]);
var state_18284__$1 = state_18284;
return cljs.core.async.ioc_alts_BANG_(state_18284__$1,(7),inst_18254);
} else {
if((state_val_18285 === (6))){
var inst_18280 = (state_18284[(2)]);
var state_18284__$1 = state_18284;
var statearr_18291_18310 = state_18284__$1;
(statearr_18291_18310[(2)] = inst_18280);

(statearr_18291_18310[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18285 === (3))){
var inst_18282 = (state_18284[(2)]);
var state_18284__$1 = state_18284;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18284__$1,inst_18282);
} else {
if((state_val_18285 === (2))){
var inst_18254 = (state_18284[(10)]);
var inst_18256 = cljs.core.count(inst_18254);
var inst_18257 = (inst_18256 > (0));
var state_18284__$1 = state_18284;
if(cljs.core.truth_(inst_18257)){
var statearr_18293_18311 = state_18284__$1;
(statearr_18293_18311[(1)] = (4));

} else {
var statearr_18294_18312 = state_18284__$1;
(statearr_18294_18312[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18285 === (11))){
var inst_18254 = (state_18284[(10)]);
var inst_18273 = (state_18284[(2)]);
var tmp18292 = inst_18254;
var inst_18254__$1 = tmp18292;
var state_18284__$1 = (function (){var statearr_18295 = state_18284;
(statearr_18295[(10)] = inst_18254__$1);

(statearr_18295[(11)] = inst_18273);

return statearr_18295;
})();
var statearr_18296_18313 = state_18284__$1;
(statearr_18296_18313[(2)] = null);

(statearr_18296_18313[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18285 === (9))){
var inst_18264 = (state_18284[(7)]);
var state_18284__$1 = state_18284;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18284__$1,(11),out,inst_18264);
} else {
if((state_val_18285 === (5))){
var inst_18278 = cljs.core.async.close_BANG_(out);
var state_18284__$1 = state_18284;
var statearr_18297_18314 = state_18284__$1;
(statearr_18297_18314[(2)] = inst_18278);

(statearr_18297_18314[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18285 === (10))){
var inst_18276 = (state_18284[(2)]);
var state_18284__$1 = state_18284;
var statearr_18298_18315 = state_18284__$1;
(statearr_18298_18315[(2)] = inst_18276);

(statearr_18298_18315[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18285 === (8))){
var inst_18264 = (state_18284[(7)]);
var inst_18263 = (state_18284[(8)]);
var inst_18254 = (state_18284[(10)]);
var inst_18265 = (state_18284[(9)]);
var inst_18268 = (function (){var cs = inst_18254;
var vec__18259 = inst_18263;
var v = inst_18264;
var c = inst_18265;
return ((function (cs,vec__18259,v,c,inst_18264,inst_18263,inst_18254,inst_18265,state_val_18285,c__16891__auto___18306,out){
return (function (p1__18250_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__18250_SHARP_);
});
;})(cs,vec__18259,v,c,inst_18264,inst_18263,inst_18254,inst_18265,state_val_18285,c__16891__auto___18306,out))
})();
var inst_18269 = cljs.core.filterv(inst_18268,inst_18254);
var inst_18254__$1 = inst_18269;
var state_18284__$1 = (function (){var statearr_18299 = state_18284;
(statearr_18299[(10)] = inst_18254__$1);

return statearr_18299;
})();
var statearr_18300_18316 = state_18284__$1;
(statearr_18300_18316[(2)] = null);

(statearr_18300_18316[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___18306,out))
;
return ((function (switch__16789__auto__,c__16891__auto___18306,out){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_18301 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18301[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_18301[(1)] = (1));

return statearr_18301;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_18284){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18284);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18302){if((e18302 instanceof Object)){
var ex__16793__auto__ = e18302;
var statearr_18303_18317 = state_18284;
(statearr_18303_18317[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18284);

return cljs.core.cst$kw$recur;
} else {
throw e18302;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18318 = state_18284;
state_18284 = G__18318;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_18284){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_18284);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___18306,out))
})();
var state__16893__auto__ = (function (){var statearr_18304 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18304[(6)] = c__16891__auto___18306);

return statearr_18304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___18306,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__18320 = arguments.length;
switch (G__18320) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16891__auto___18365 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___18365,out){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___18365,out){
return (function (state_18344){
var state_val_18345 = (state_18344[(1)]);
if((state_val_18345 === (7))){
var inst_18326 = (state_18344[(7)]);
var inst_18326__$1 = (state_18344[(2)]);
var inst_18327 = (inst_18326__$1 == null);
var inst_18328 = cljs.core.not(inst_18327);
var state_18344__$1 = (function (){var statearr_18346 = state_18344;
(statearr_18346[(7)] = inst_18326__$1);

return statearr_18346;
})();
if(inst_18328){
var statearr_18347_18366 = state_18344__$1;
(statearr_18347_18366[(1)] = (8));

} else {
var statearr_18348_18367 = state_18344__$1;
(statearr_18348_18367[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18345 === (1))){
var inst_18321 = (0);
var state_18344__$1 = (function (){var statearr_18349 = state_18344;
(statearr_18349[(8)] = inst_18321);

return statearr_18349;
})();
var statearr_18350_18368 = state_18344__$1;
(statearr_18350_18368[(2)] = null);

(statearr_18350_18368[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18345 === (4))){
var state_18344__$1 = state_18344;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18344__$1,(7),ch);
} else {
if((state_val_18345 === (6))){
var inst_18339 = (state_18344[(2)]);
var state_18344__$1 = state_18344;
var statearr_18351_18369 = state_18344__$1;
(statearr_18351_18369[(2)] = inst_18339);

(statearr_18351_18369[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18345 === (3))){
var inst_18341 = (state_18344[(2)]);
var inst_18342 = cljs.core.async.close_BANG_(out);
var state_18344__$1 = (function (){var statearr_18352 = state_18344;
(statearr_18352[(9)] = inst_18341);

return statearr_18352;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18344__$1,inst_18342);
} else {
if((state_val_18345 === (2))){
var inst_18321 = (state_18344[(8)]);
var inst_18323 = (inst_18321 < n);
var state_18344__$1 = state_18344;
if(cljs.core.truth_(inst_18323)){
var statearr_18353_18370 = state_18344__$1;
(statearr_18353_18370[(1)] = (4));

} else {
var statearr_18354_18371 = state_18344__$1;
(statearr_18354_18371[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18345 === (11))){
var inst_18321 = (state_18344[(8)]);
var inst_18331 = (state_18344[(2)]);
var inst_18332 = (inst_18321 + (1));
var inst_18321__$1 = inst_18332;
var state_18344__$1 = (function (){var statearr_18355 = state_18344;
(statearr_18355[(8)] = inst_18321__$1);

(statearr_18355[(10)] = inst_18331);

return statearr_18355;
})();
var statearr_18356_18372 = state_18344__$1;
(statearr_18356_18372[(2)] = null);

(statearr_18356_18372[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18345 === (9))){
var state_18344__$1 = state_18344;
var statearr_18357_18373 = state_18344__$1;
(statearr_18357_18373[(2)] = null);

(statearr_18357_18373[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18345 === (5))){
var state_18344__$1 = state_18344;
var statearr_18358_18374 = state_18344__$1;
(statearr_18358_18374[(2)] = null);

(statearr_18358_18374[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18345 === (10))){
var inst_18336 = (state_18344[(2)]);
var state_18344__$1 = state_18344;
var statearr_18359_18375 = state_18344__$1;
(statearr_18359_18375[(2)] = inst_18336);

(statearr_18359_18375[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18345 === (8))){
var inst_18326 = (state_18344[(7)]);
var state_18344__$1 = state_18344;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18344__$1,(11),out,inst_18326);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___18365,out))
;
return ((function (switch__16789__auto__,c__16891__auto___18365,out){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_18360 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18360[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_18360[(1)] = (1));

return statearr_18360;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_18344){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18344);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18361){if((e18361 instanceof Object)){
var ex__16793__auto__ = e18361;
var statearr_18362_18376 = state_18344;
(statearr_18362_18376[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18344);

return cljs.core.cst$kw$recur;
} else {
throw e18361;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18377 = state_18344;
state_18344 = G__18377;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_18344){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_18344);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___18365,out))
})();
var state__16893__auto__ = (function (){var statearr_18363 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18363[(6)] = c__16891__auto___18365);

return statearr_18363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___18365,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18379 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18379 = (function (f,ch,meta18380){
this.f = f;
this.ch = ch;
this.meta18380 = meta18380;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18381,meta18380__$1){
var self__ = this;
var _18381__$1 = this;
return (new cljs.core.async.t_cljs$core$async18379(self__.f,self__.ch,meta18380__$1));
});

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18381){
var self__ = this;
var _18381__$1 = this;
return self__.meta18380;
});

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async18382 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18382 = (function (f,ch,meta18380,_,fn1,meta18383){
this.f = f;
this.ch = ch;
this.meta18380 = meta18380;
this._ = _;
this.fn1 = fn1;
this.meta18383 = meta18383;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18382.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_18384,meta18383__$1){
var self__ = this;
var _18384__$1 = this;
return (new cljs.core.async.t_cljs$core$async18382(self__.f,self__.ch,self__.meta18380,self__._,self__.fn1,meta18383__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async18382.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_18384){
var self__ = this;
var _18384__$1 = this;
return self__.meta18383;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18382.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18382.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18382.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18382.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__18378_SHARP_){
var G__18385 = (((p1__18378_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__18378_SHARP_) : self__.f.call(null,p1__18378_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__18385) : f1.call(null,G__18385));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async18382.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18380,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async18379], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta18383], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18382.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18382.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18382";

cljs.core.async.t_cljs$core$async18382.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18382");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async18382 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18382(f__$1,ch__$1,meta18380__$1,___$2,fn1__$1,meta18383){
return (new cljs.core.async.t_cljs$core$async18382(f__$1,ch__$1,meta18380__$1,___$2,fn1__$1,meta18383));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async18382(self__.f,self__.ch,self__.meta18380,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8794__auto__ = ret;
if(cljs.core.truth_(and__8794__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__8794__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__18386 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__18386) : self__.f.call(null,G__18386));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18379.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async18379.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18380], null);
});

cljs.core.async.t_cljs$core$async18379.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18379.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18379";

cljs.core.async.t_cljs$core$async18379.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18379");
});

cljs.core.async.__GT_t_cljs$core$async18379 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18379(f__$1,ch__$1,meta18380){
return (new cljs.core.async.t_cljs$core$async18379(f__$1,ch__$1,meta18380));
});

}

return (new cljs.core.async.t_cljs$core$async18379(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18387 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18387 = (function (f,ch,meta18388){
this.f = f;
this.ch = ch;
this.meta18388 = meta18388;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18389,meta18388__$1){
var self__ = this;
var _18389__$1 = this;
return (new cljs.core.async.t_cljs$core$async18387(self__.f,self__.ch,meta18388__$1));
});

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18389){
var self__ = this;
var _18389__$1 = this;
return self__.meta18388;
});

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18387.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async18387.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18388], null);
});

cljs.core.async.t_cljs$core$async18387.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18387.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18387";

cljs.core.async.t_cljs$core$async18387.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18387");
});

cljs.core.async.__GT_t_cljs$core$async18387 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async18387(f__$1,ch__$1,meta18388){
return (new cljs.core.async.t_cljs$core$async18387(f__$1,ch__$1,meta18388));
});

}

return (new cljs.core.async.t_cljs$core$async18387(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async18390 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18390 = (function (p,ch,meta18391){
this.p = p;
this.ch = ch;
this.meta18391 = meta18391;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18390.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18392,meta18391__$1){
var self__ = this;
var _18392__$1 = this;
return (new cljs.core.async.t_cljs$core$async18390(self__.p,self__.ch,meta18391__$1));
});

cljs.core.async.t_cljs$core$async18390.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18392){
var self__ = this;
var _18392__$1 = this;
return self__.meta18391;
});

cljs.core.async.t_cljs$core$async18390.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18390.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18390.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async18390.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18390.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18390.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18390.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async18390.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18391], null);
});

cljs.core.async.t_cljs$core$async18390.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18390.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18390";

cljs.core.async.t_cljs$core$async18390.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async18390");
});

cljs.core.async.__GT_t_cljs$core$async18390 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async18390(p__$1,ch__$1,meta18391){
return (new cljs.core.async.t_cljs$core$async18390(p__$1,ch__$1,meta18391));
});

}

return (new cljs.core.async.t_cljs$core$async18390(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__18394 = arguments.length;
switch (G__18394) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16891__auto___18434 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___18434,out){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___18434,out){
return (function (state_18415){
var state_val_18416 = (state_18415[(1)]);
if((state_val_18416 === (7))){
var inst_18411 = (state_18415[(2)]);
var state_18415__$1 = state_18415;
var statearr_18417_18435 = state_18415__$1;
(statearr_18417_18435[(2)] = inst_18411);

(statearr_18417_18435[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18416 === (1))){
var state_18415__$1 = state_18415;
var statearr_18418_18436 = state_18415__$1;
(statearr_18418_18436[(2)] = null);

(statearr_18418_18436[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18416 === (4))){
var inst_18397 = (state_18415[(7)]);
var inst_18397__$1 = (state_18415[(2)]);
var inst_18398 = (inst_18397__$1 == null);
var state_18415__$1 = (function (){var statearr_18419 = state_18415;
(statearr_18419[(7)] = inst_18397__$1);

return statearr_18419;
})();
if(cljs.core.truth_(inst_18398)){
var statearr_18420_18437 = state_18415__$1;
(statearr_18420_18437[(1)] = (5));

} else {
var statearr_18421_18438 = state_18415__$1;
(statearr_18421_18438[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18416 === (6))){
var inst_18397 = (state_18415[(7)]);
var inst_18402 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_18397) : p.call(null,inst_18397));
var state_18415__$1 = state_18415;
if(cljs.core.truth_(inst_18402)){
var statearr_18422_18439 = state_18415__$1;
(statearr_18422_18439[(1)] = (8));

} else {
var statearr_18423_18440 = state_18415__$1;
(statearr_18423_18440[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18416 === (3))){
var inst_18413 = (state_18415[(2)]);
var state_18415__$1 = state_18415;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18415__$1,inst_18413);
} else {
if((state_val_18416 === (2))){
var state_18415__$1 = state_18415;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18415__$1,(4),ch);
} else {
if((state_val_18416 === (11))){
var inst_18405 = (state_18415[(2)]);
var state_18415__$1 = state_18415;
var statearr_18424_18441 = state_18415__$1;
(statearr_18424_18441[(2)] = inst_18405);

(statearr_18424_18441[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18416 === (9))){
var state_18415__$1 = state_18415;
var statearr_18425_18442 = state_18415__$1;
(statearr_18425_18442[(2)] = null);

(statearr_18425_18442[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18416 === (5))){
var inst_18400 = cljs.core.async.close_BANG_(out);
var state_18415__$1 = state_18415;
var statearr_18426_18443 = state_18415__$1;
(statearr_18426_18443[(2)] = inst_18400);

(statearr_18426_18443[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18416 === (10))){
var inst_18408 = (state_18415[(2)]);
var state_18415__$1 = (function (){var statearr_18427 = state_18415;
(statearr_18427[(8)] = inst_18408);

return statearr_18427;
})();
var statearr_18428_18444 = state_18415__$1;
(statearr_18428_18444[(2)] = null);

(statearr_18428_18444[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18416 === (8))){
var inst_18397 = (state_18415[(7)]);
var state_18415__$1 = state_18415;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18415__$1,(11),out,inst_18397);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___18434,out))
;
return ((function (switch__16789__auto__,c__16891__auto___18434,out){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_18429 = [null,null,null,null,null,null,null,null,null];
(statearr_18429[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_18429[(1)] = (1));

return statearr_18429;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_18415){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18415);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18430){if((e18430 instanceof Object)){
var ex__16793__auto__ = e18430;
var statearr_18431_18445 = state_18415;
(statearr_18431_18445[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18415);

return cljs.core.cst$kw$recur;
} else {
throw e18430;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18446 = state_18415;
state_18415 = G__18446;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_18415){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_18415);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___18434,out))
})();
var state__16893__auto__ = (function (){var statearr_18432 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18432[(6)] = c__16891__auto___18434);

return statearr_18432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___18434,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__18448 = arguments.length;
switch (G__18448) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16891__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto__){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto__){
return (function (state_18511){
var state_val_18512 = (state_18511[(1)]);
if((state_val_18512 === (7))){
var inst_18507 = (state_18511[(2)]);
var state_18511__$1 = state_18511;
var statearr_18513_18551 = state_18511__$1;
(statearr_18513_18551[(2)] = inst_18507);

(statearr_18513_18551[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (20))){
var inst_18477 = (state_18511[(7)]);
var inst_18488 = (state_18511[(2)]);
var inst_18489 = cljs.core.next(inst_18477);
var inst_18463 = inst_18489;
var inst_18464 = null;
var inst_18465 = (0);
var inst_18466 = (0);
var state_18511__$1 = (function (){var statearr_18514 = state_18511;
(statearr_18514[(8)] = inst_18465);

(statearr_18514[(9)] = inst_18488);

(statearr_18514[(10)] = inst_18464);

(statearr_18514[(11)] = inst_18463);

(statearr_18514[(12)] = inst_18466);

return statearr_18514;
})();
var statearr_18515_18552 = state_18511__$1;
(statearr_18515_18552[(2)] = null);

(statearr_18515_18552[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (1))){
var state_18511__$1 = state_18511;
var statearr_18516_18553 = state_18511__$1;
(statearr_18516_18553[(2)] = null);

(statearr_18516_18553[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (4))){
var inst_18452 = (state_18511[(13)]);
var inst_18452__$1 = (state_18511[(2)]);
var inst_18453 = (inst_18452__$1 == null);
var state_18511__$1 = (function (){var statearr_18517 = state_18511;
(statearr_18517[(13)] = inst_18452__$1);

return statearr_18517;
})();
if(cljs.core.truth_(inst_18453)){
var statearr_18518_18554 = state_18511__$1;
(statearr_18518_18554[(1)] = (5));

} else {
var statearr_18519_18555 = state_18511__$1;
(statearr_18519_18555[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (15))){
var state_18511__$1 = state_18511;
var statearr_18523_18556 = state_18511__$1;
(statearr_18523_18556[(2)] = null);

(statearr_18523_18556[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (21))){
var state_18511__$1 = state_18511;
var statearr_18524_18557 = state_18511__$1;
(statearr_18524_18557[(2)] = null);

(statearr_18524_18557[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (13))){
var inst_18465 = (state_18511[(8)]);
var inst_18464 = (state_18511[(10)]);
var inst_18463 = (state_18511[(11)]);
var inst_18466 = (state_18511[(12)]);
var inst_18473 = (state_18511[(2)]);
var inst_18474 = (inst_18466 + (1));
var tmp18520 = inst_18465;
var tmp18521 = inst_18464;
var tmp18522 = inst_18463;
var inst_18463__$1 = tmp18522;
var inst_18464__$1 = tmp18521;
var inst_18465__$1 = tmp18520;
var inst_18466__$1 = inst_18474;
var state_18511__$1 = (function (){var statearr_18525 = state_18511;
(statearr_18525[(14)] = inst_18473);

(statearr_18525[(8)] = inst_18465__$1);

(statearr_18525[(10)] = inst_18464__$1);

(statearr_18525[(11)] = inst_18463__$1);

(statearr_18525[(12)] = inst_18466__$1);

return statearr_18525;
})();
var statearr_18526_18558 = state_18511__$1;
(statearr_18526_18558[(2)] = null);

(statearr_18526_18558[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (22))){
var state_18511__$1 = state_18511;
var statearr_18527_18559 = state_18511__$1;
(statearr_18527_18559[(2)] = null);

(statearr_18527_18559[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (6))){
var inst_18452 = (state_18511[(13)]);
var inst_18461 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18452) : f.call(null,inst_18452));
var inst_18462 = cljs.core.seq(inst_18461);
var inst_18463 = inst_18462;
var inst_18464 = null;
var inst_18465 = (0);
var inst_18466 = (0);
var state_18511__$1 = (function (){var statearr_18528 = state_18511;
(statearr_18528[(8)] = inst_18465);

(statearr_18528[(10)] = inst_18464);

(statearr_18528[(11)] = inst_18463);

(statearr_18528[(12)] = inst_18466);

return statearr_18528;
})();
var statearr_18529_18560 = state_18511__$1;
(statearr_18529_18560[(2)] = null);

(statearr_18529_18560[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (17))){
var inst_18477 = (state_18511[(7)]);
var inst_18481 = cljs.core.chunk_first(inst_18477);
var inst_18482 = cljs.core.chunk_rest(inst_18477);
var inst_18483 = cljs.core.count(inst_18481);
var inst_18463 = inst_18482;
var inst_18464 = inst_18481;
var inst_18465 = inst_18483;
var inst_18466 = (0);
var state_18511__$1 = (function (){var statearr_18530 = state_18511;
(statearr_18530[(8)] = inst_18465);

(statearr_18530[(10)] = inst_18464);

(statearr_18530[(11)] = inst_18463);

(statearr_18530[(12)] = inst_18466);

return statearr_18530;
})();
var statearr_18531_18561 = state_18511__$1;
(statearr_18531_18561[(2)] = null);

(statearr_18531_18561[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (3))){
var inst_18509 = (state_18511[(2)]);
var state_18511__$1 = state_18511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18511__$1,inst_18509);
} else {
if((state_val_18512 === (12))){
var inst_18497 = (state_18511[(2)]);
var state_18511__$1 = state_18511;
var statearr_18532_18562 = state_18511__$1;
(statearr_18532_18562[(2)] = inst_18497);

(statearr_18532_18562[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (2))){
var state_18511__$1 = state_18511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18511__$1,(4),in$);
} else {
if((state_val_18512 === (23))){
var inst_18505 = (state_18511[(2)]);
var state_18511__$1 = state_18511;
var statearr_18533_18563 = state_18511__$1;
(statearr_18533_18563[(2)] = inst_18505);

(statearr_18533_18563[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (19))){
var inst_18492 = (state_18511[(2)]);
var state_18511__$1 = state_18511;
var statearr_18534_18564 = state_18511__$1;
(statearr_18534_18564[(2)] = inst_18492);

(statearr_18534_18564[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (11))){
var inst_18477 = (state_18511[(7)]);
var inst_18463 = (state_18511[(11)]);
var inst_18477__$1 = cljs.core.seq(inst_18463);
var state_18511__$1 = (function (){var statearr_18535 = state_18511;
(statearr_18535[(7)] = inst_18477__$1);

return statearr_18535;
})();
if(inst_18477__$1){
var statearr_18536_18565 = state_18511__$1;
(statearr_18536_18565[(1)] = (14));

} else {
var statearr_18537_18566 = state_18511__$1;
(statearr_18537_18566[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (9))){
var inst_18499 = (state_18511[(2)]);
var inst_18500 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_18511__$1 = (function (){var statearr_18538 = state_18511;
(statearr_18538[(15)] = inst_18499);

return statearr_18538;
})();
if(cljs.core.truth_(inst_18500)){
var statearr_18539_18567 = state_18511__$1;
(statearr_18539_18567[(1)] = (21));

} else {
var statearr_18540_18568 = state_18511__$1;
(statearr_18540_18568[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (5))){
var inst_18455 = cljs.core.async.close_BANG_(out);
var state_18511__$1 = state_18511;
var statearr_18541_18569 = state_18511__$1;
(statearr_18541_18569[(2)] = inst_18455);

(statearr_18541_18569[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (14))){
var inst_18477 = (state_18511[(7)]);
var inst_18479 = cljs.core.chunked_seq_QMARK_(inst_18477);
var state_18511__$1 = state_18511;
if(inst_18479){
var statearr_18542_18570 = state_18511__$1;
(statearr_18542_18570[(1)] = (17));

} else {
var statearr_18543_18571 = state_18511__$1;
(statearr_18543_18571[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (16))){
var inst_18495 = (state_18511[(2)]);
var state_18511__$1 = state_18511;
var statearr_18544_18572 = state_18511__$1;
(statearr_18544_18572[(2)] = inst_18495);

(statearr_18544_18572[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18512 === (10))){
var inst_18464 = (state_18511[(10)]);
var inst_18466 = (state_18511[(12)]);
var inst_18471 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18464,inst_18466);
var state_18511__$1 = state_18511;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18511__$1,(13),out,inst_18471);
} else {
if((state_val_18512 === (18))){
var inst_18477 = (state_18511[(7)]);
var inst_18486 = cljs.core.first(inst_18477);
var state_18511__$1 = state_18511;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18511__$1,(20),out,inst_18486);
} else {
if((state_val_18512 === (8))){
var inst_18465 = (state_18511[(8)]);
var inst_18466 = (state_18511[(12)]);
var inst_18468 = (inst_18466 < inst_18465);
var inst_18469 = inst_18468;
var state_18511__$1 = state_18511;
if(cljs.core.truth_(inst_18469)){
var statearr_18545_18573 = state_18511__$1;
(statearr_18545_18573[(1)] = (10));

} else {
var statearr_18546_18574 = state_18511__$1;
(statearr_18546_18574[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto__))
;
return ((function (switch__16789__auto__,c__16891__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16790__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16790__auto____0 = (function (){
var statearr_18547 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18547[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16790__auto__);

(statearr_18547[(1)] = (1));

return statearr_18547;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16790__auto____1 = (function (state_18511){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18511);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18548){if((e18548 instanceof Object)){
var ex__16793__auto__ = e18548;
var statearr_18549_18575 = state_18511;
(statearr_18549_18575[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18511);

return cljs.core.cst$kw$recur;
} else {
throw e18548;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18576 = state_18511;
state_18511 = G__18576;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16790__auto__ = function(state_18511){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16790__auto____1.call(this,state_18511);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16790__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16790__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto__))
})();
var state__16893__auto__ = (function (){var statearr_18550 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18550[(6)] = c__16891__auto__);

return statearr_18550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto__))
);

return c__16891__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18578 = arguments.length;
switch (G__18578) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18581 = arguments.length;
switch (G__18581) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18584 = arguments.length;
switch (G__18584) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16891__auto___18631 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___18631,out){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___18631,out){
return (function (state_18608){
var state_val_18609 = (state_18608[(1)]);
if((state_val_18609 === (7))){
var inst_18603 = (state_18608[(2)]);
var state_18608__$1 = state_18608;
var statearr_18610_18632 = state_18608__$1;
(statearr_18610_18632[(2)] = inst_18603);

(statearr_18610_18632[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18609 === (1))){
var inst_18585 = null;
var state_18608__$1 = (function (){var statearr_18611 = state_18608;
(statearr_18611[(7)] = inst_18585);

return statearr_18611;
})();
var statearr_18612_18633 = state_18608__$1;
(statearr_18612_18633[(2)] = null);

(statearr_18612_18633[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18609 === (4))){
var inst_18588 = (state_18608[(8)]);
var inst_18588__$1 = (state_18608[(2)]);
var inst_18589 = (inst_18588__$1 == null);
var inst_18590 = cljs.core.not(inst_18589);
var state_18608__$1 = (function (){var statearr_18613 = state_18608;
(statearr_18613[(8)] = inst_18588__$1);

return statearr_18613;
})();
if(inst_18590){
var statearr_18614_18634 = state_18608__$1;
(statearr_18614_18634[(1)] = (5));

} else {
var statearr_18615_18635 = state_18608__$1;
(statearr_18615_18635[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18609 === (6))){
var state_18608__$1 = state_18608;
var statearr_18616_18636 = state_18608__$1;
(statearr_18616_18636[(2)] = null);

(statearr_18616_18636[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18609 === (3))){
var inst_18605 = (state_18608[(2)]);
var inst_18606 = cljs.core.async.close_BANG_(out);
var state_18608__$1 = (function (){var statearr_18617 = state_18608;
(statearr_18617[(9)] = inst_18605);

return statearr_18617;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18608__$1,inst_18606);
} else {
if((state_val_18609 === (2))){
var state_18608__$1 = state_18608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18608__$1,(4),ch);
} else {
if((state_val_18609 === (11))){
var inst_18588 = (state_18608[(8)]);
var inst_18597 = (state_18608[(2)]);
var inst_18585 = inst_18588;
var state_18608__$1 = (function (){var statearr_18618 = state_18608;
(statearr_18618[(10)] = inst_18597);

(statearr_18618[(7)] = inst_18585);

return statearr_18618;
})();
var statearr_18619_18637 = state_18608__$1;
(statearr_18619_18637[(2)] = null);

(statearr_18619_18637[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18609 === (9))){
var inst_18588 = (state_18608[(8)]);
var state_18608__$1 = state_18608;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18608__$1,(11),out,inst_18588);
} else {
if((state_val_18609 === (5))){
var inst_18588 = (state_18608[(8)]);
var inst_18585 = (state_18608[(7)]);
var inst_18592 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18588,inst_18585);
var state_18608__$1 = state_18608;
if(inst_18592){
var statearr_18621_18638 = state_18608__$1;
(statearr_18621_18638[(1)] = (8));

} else {
var statearr_18622_18639 = state_18608__$1;
(statearr_18622_18639[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18609 === (10))){
var inst_18600 = (state_18608[(2)]);
var state_18608__$1 = state_18608;
var statearr_18623_18640 = state_18608__$1;
(statearr_18623_18640[(2)] = inst_18600);

(statearr_18623_18640[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18609 === (8))){
var inst_18585 = (state_18608[(7)]);
var tmp18620 = inst_18585;
var inst_18585__$1 = tmp18620;
var state_18608__$1 = (function (){var statearr_18624 = state_18608;
(statearr_18624[(7)] = inst_18585__$1);

return statearr_18624;
})();
var statearr_18625_18641 = state_18608__$1;
(statearr_18625_18641[(2)] = null);

(statearr_18625_18641[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___18631,out))
;
return ((function (switch__16789__auto__,c__16891__auto___18631,out){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_18626 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18626[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_18626[(1)] = (1));

return statearr_18626;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_18608){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18608);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18627){if((e18627 instanceof Object)){
var ex__16793__auto__ = e18627;
var statearr_18628_18642 = state_18608;
(statearr_18628_18642[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18608);

return cljs.core.cst$kw$recur;
} else {
throw e18627;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18643 = state_18608;
state_18608 = G__18643;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_18608){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_18608);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___18631,out))
})();
var state__16893__auto__ = (function (){var statearr_18629 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18629[(6)] = c__16891__auto___18631);

return statearr_18629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___18631,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__18645 = arguments.length;
switch (G__18645) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16891__auto___18711 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___18711,out){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___18711,out){
return (function (state_18683){
var state_val_18684 = (state_18683[(1)]);
if((state_val_18684 === (7))){
var inst_18679 = (state_18683[(2)]);
var state_18683__$1 = state_18683;
var statearr_18685_18712 = state_18683__$1;
(statearr_18685_18712[(2)] = inst_18679);

(statearr_18685_18712[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18684 === (1))){
var inst_18646 = (new Array(n));
var inst_18647 = inst_18646;
var inst_18648 = (0);
var state_18683__$1 = (function (){var statearr_18686 = state_18683;
(statearr_18686[(7)] = inst_18648);

(statearr_18686[(8)] = inst_18647);

return statearr_18686;
})();
var statearr_18687_18713 = state_18683__$1;
(statearr_18687_18713[(2)] = null);

(statearr_18687_18713[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18684 === (4))){
var inst_18651 = (state_18683[(9)]);
var inst_18651__$1 = (state_18683[(2)]);
var inst_18652 = (inst_18651__$1 == null);
var inst_18653 = cljs.core.not(inst_18652);
var state_18683__$1 = (function (){var statearr_18688 = state_18683;
(statearr_18688[(9)] = inst_18651__$1);

return statearr_18688;
})();
if(inst_18653){
var statearr_18689_18714 = state_18683__$1;
(statearr_18689_18714[(1)] = (5));

} else {
var statearr_18690_18715 = state_18683__$1;
(statearr_18690_18715[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18684 === (15))){
var inst_18673 = (state_18683[(2)]);
var state_18683__$1 = state_18683;
var statearr_18691_18716 = state_18683__$1;
(statearr_18691_18716[(2)] = inst_18673);

(statearr_18691_18716[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18684 === (13))){
var state_18683__$1 = state_18683;
var statearr_18692_18717 = state_18683__$1;
(statearr_18692_18717[(2)] = null);

(statearr_18692_18717[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18684 === (6))){
var inst_18648 = (state_18683[(7)]);
var inst_18669 = (inst_18648 > (0));
var state_18683__$1 = state_18683;
if(cljs.core.truth_(inst_18669)){
var statearr_18693_18718 = state_18683__$1;
(statearr_18693_18718[(1)] = (12));

} else {
var statearr_18694_18719 = state_18683__$1;
(statearr_18694_18719[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18684 === (3))){
var inst_18681 = (state_18683[(2)]);
var state_18683__$1 = state_18683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18683__$1,inst_18681);
} else {
if((state_val_18684 === (12))){
var inst_18647 = (state_18683[(8)]);
var inst_18671 = cljs.core.vec(inst_18647);
var state_18683__$1 = state_18683;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18683__$1,(15),out,inst_18671);
} else {
if((state_val_18684 === (2))){
var state_18683__$1 = state_18683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18683__$1,(4),ch);
} else {
if((state_val_18684 === (11))){
var inst_18663 = (state_18683[(2)]);
var inst_18664 = (new Array(n));
var inst_18647 = inst_18664;
var inst_18648 = (0);
var state_18683__$1 = (function (){var statearr_18695 = state_18683;
(statearr_18695[(7)] = inst_18648);

(statearr_18695[(8)] = inst_18647);

(statearr_18695[(10)] = inst_18663);

return statearr_18695;
})();
var statearr_18696_18720 = state_18683__$1;
(statearr_18696_18720[(2)] = null);

(statearr_18696_18720[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18684 === (9))){
var inst_18647 = (state_18683[(8)]);
var inst_18661 = cljs.core.vec(inst_18647);
var state_18683__$1 = state_18683;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18683__$1,(11),out,inst_18661);
} else {
if((state_val_18684 === (5))){
var inst_18651 = (state_18683[(9)]);
var inst_18648 = (state_18683[(7)]);
var inst_18647 = (state_18683[(8)]);
var inst_18656 = (state_18683[(11)]);
var inst_18655 = (inst_18647[inst_18648] = inst_18651);
var inst_18656__$1 = (inst_18648 + (1));
var inst_18657 = (inst_18656__$1 < n);
var state_18683__$1 = (function (){var statearr_18697 = state_18683;
(statearr_18697[(12)] = inst_18655);

(statearr_18697[(11)] = inst_18656__$1);

return statearr_18697;
})();
if(cljs.core.truth_(inst_18657)){
var statearr_18698_18721 = state_18683__$1;
(statearr_18698_18721[(1)] = (8));

} else {
var statearr_18699_18722 = state_18683__$1;
(statearr_18699_18722[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18684 === (14))){
var inst_18676 = (state_18683[(2)]);
var inst_18677 = cljs.core.async.close_BANG_(out);
var state_18683__$1 = (function (){var statearr_18701 = state_18683;
(statearr_18701[(13)] = inst_18676);

return statearr_18701;
})();
var statearr_18702_18723 = state_18683__$1;
(statearr_18702_18723[(2)] = inst_18677);

(statearr_18702_18723[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18684 === (10))){
var inst_18667 = (state_18683[(2)]);
var state_18683__$1 = state_18683;
var statearr_18703_18724 = state_18683__$1;
(statearr_18703_18724[(2)] = inst_18667);

(statearr_18703_18724[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18684 === (8))){
var inst_18647 = (state_18683[(8)]);
var inst_18656 = (state_18683[(11)]);
var tmp18700 = inst_18647;
var inst_18647__$1 = tmp18700;
var inst_18648 = inst_18656;
var state_18683__$1 = (function (){var statearr_18704 = state_18683;
(statearr_18704[(7)] = inst_18648);

(statearr_18704[(8)] = inst_18647__$1);

return statearr_18704;
})();
var statearr_18705_18725 = state_18683__$1;
(statearr_18705_18725[(2)] = null);

(statearr_18705_18725[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___18711,out))
;
return ((function (switch__16789__auto__,c__16891__auto___18711,out){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_18706 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18706[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_18706[(1)] = (1));

return statearr_18706;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_18683){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18683);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18707){if((e18707 instanceof Object)){
var ex__16793__auto__ = e18707;
var statearr_18708_18726 = state_18683;
(statearr_18708_18726[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18683);

return cljs.core.cst$kw$recur;
} else {
throw e18707;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18727 = state_18683;
state_18683 = G__18727;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_18683){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_18683);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___18711,out))
})();
var state__16893__auto__ = (function (){var statearr_18709 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18709[(6)] = c__16891__auto___18711);

return statearr_18709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___18711,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18729 = arguments.length;
switch (G__18729) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16891__auto___18799 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___18799,out){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___18799,out){
return (function (state_18771){
var state_val_18772 = (state_18771[(1)]);
if((state_val_18772 === (7))){
var inst_18767 = (state_18771[(2)]);
var state_18771__$1 = state_18771;
var statearr_18773_18800 = state_18771__$1;
(statearr_18773_18800[(2)] = inst_18767);

(statearr_18773_18800[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18772 === (1))){
var inst_18730 = [];
var inst_18731 = inst_18730;
var inst_18732 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_18771__$1 = (function (){var statearr_18774 = state_18771;
(statearr_18774[(7)] = inst_18731);

(statearr_18774[(8)] = inst_18732);

return statearr_18774;
})();
var statearr_18775_18801 = state_18771__$1;
(statearr_18775_18801[(2)] = null);

(statearr_18775_18801[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18772 === (4))){
var inst_18735 = (state_18771[(9)]);
var inst_18735__$1 = (state_18771[(2)]);
var inst_18736 = (inst_18735__$1 == null);
var inst_18737 = cljs.core.not(inst_18736);
var state_18771__$1 = (function (){var statearr_18776 = state_18771;
(statearr_18776[(9)] = inst_18735__$1);

return statearr_18776;
})();
if(inst_18737){
var statearr_18777_18802 = state_18771__$1;
(statearr_18777_18802[(1)] = (5));

} else {
var statearr_18778_18803 = state_18771__$1;
(statearr_18778_18803[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18772 === (15))){
var inst_18761 = (state_18771[(2)]);
var state_18771__$1 = state_18771;
var statearr_18779_18804 = state_18771__$1;
(statearr_18779_18804[(2)] = inst_18761);

(statearr_18779_18804[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18772 === (13))){
var state_18771__$1 = state_18771;
var statearr_18780_18805 = state_18771__$1;
(statearr_18780_18805[(2)] = null);

(statearr_18780_18805[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18772 === (6))){
var inst_18731 = (state_18771[(7)]);
var inst_18756 = inst_18731.length;
var inst_18757 = (inst_18756 > (0));
var state_18771__$1 = state_18771;
if(cljs.core.truth_(inst_18757)){
var statearr_18781_18806 = state_18771__$1;
(statearr_18781_18806[(1)] = (12));

} else {
var statearr_18782_18807 = state_18771__$1;
(statearr_18782_18807[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18772 === (3))){
var inst_18769 = (state_18771[(2)]);
var state_18771__$1 = state_18771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18771__$1,inst_18769);
} else {
if((state_val_18772 === (12))){
var inst_18731 = (state_18771[(7)]);
var inst_18759 = cljs.core.vec(inst_18731);
var state_18771__$1 = state_18771;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18771__$1,(15),out,inst_18759);
} else {
if((state_val_18772 === (2))){
var state_18771__$1 = state_18771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18771__$1,(4),ch);
} else {
if((state_val_18772 === (11))){
var inst_18739 = (state_18771[(10)]);
var inst_18735 = (state_18771[(9)]);
var inst_18749 = (state_18771[(2)]);
var inst_18750 = [];
var inst_18751 = inst_18750.push(inst_18735);
var inst_18731 = inst_18750;
var inst_18732 = inst_18739;
var state_18771__$1 = (function (){var statearr_18783 = state_18771;
(statearr_18783[(7)] = inst_18731);

(statearr_18783[(11)] = inst_18751);

(statearr_18783[(12)] = inst_18749);

(statearr_18783[(8)] = inst_18732);

return statearr_18783;
})();
var statearr_18784_18808 = state_18771__$1;
(statearr_18784_18808[(2)] = null);

(statearr_18784_18808[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18772 === (9))){
var inst_18731 = (state_18771[(7)]);
var inst_18747 = cljs.core.vec(inst_18731);
var state_18771__$1 = state_18771;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18771__$1,(11),out,inst_18747);
} else {
if((state_val_18772 === (5))){
var inst_18739 = (state_18771[(10)]);
var inst_18735 = (state_18771[(9)]);
var inst_18732 = (state_18771[(8)]);
var inst_18739__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18735) : f.call(null,inst_18735));
var inst_18740 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18739__$1,inst_18732);
var inst_18741 = cljs.core.keyword_identical_QMARK_(inst_18732,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_18742 = (inst_18740) || (inst_18741);
var state_18771__$1 = (function (){var statearr_18785 = state_18771;
(statearr_18785[(10)] = inst_18739__$1);

return statearr_18785;
})();
if(cljs.core.truth_(inst_18742)){
var statearr_18786_18809 = state_18771__$1;
(statearr_18786_18809[(1)] = (8));

} else {
var statearr_18787_18810 = state_18771__$1;
(statearr_18787_18810[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18772 === (14))){
var inst_18764 = (state_18771[(2)]);
var inst_18765 = cljs.core.async.close_BANG_(out);
var state_18771__$1 = (function (){var statearr_18789 = state_18771;
(statearr_18789[(13)] = inst_18764);

return statearr_18789;
})();
var statearr_18790_18811 = state_18771__$1;
(statearr_18790_18811[(2)] = inst_18765);

(statearr_18790_18811[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18772 === (10))){
var inst_18754 = (state_18771[(2)]);
var state_18771__$1 = state_18771;
var statearr_18791_18812 = state_18771__$1;
(statearr_18791_18812[(2)] = inst_18754);

(statearr_18791_18812[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18772 === (8))){
var inst_18731 = (state_18771[(7)]);
var inst_18739 = (state_18771[(10)]);
var inst_18735 = (state_18771[(9)]);
var inst_18744 = inst_18731.push(inst_18735);
var tmp18788 = inst_18731;
var inst_18731__$1 = tmp18788;
var inst_18732 = inst_18739;
var state_18771__$1 = (function (){var statearr_18792 = state_18771;
(statearr_18792[(14)] = inst_18744);

(statearr_18792[(7)] = inst_18731__$1);

(statearr_18792[(8)] = inst_18732);

return statearr_18792;
})();
var statearr_18793_18813 = state_18771__$1;
(statearr_18793_18813[(2)] = null);

(statearr_18793_18813[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16891__auto___18799,out))
;
return ((function (switch__16789__auto__,c__16891__auto___18799,out){
return (function() {
var cljs$core$async$state_machine__16790__auto__ = null;
var cljs$core$async$state_machine__16790__auto____0 = (function (){
var statearr_18794 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18794[(0)] = cljs$core$async$state_machine__16790__auto__);

(statearr_18794[(1)] = (1));

return statearr_18794;
});
var cljs$core$async$state_machine__16790__auto____1 = (function (state_18771){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18771);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18795){if((e18795 instanceof Object)){
var ex__16793__auto__ = e18795;
var statearr_18796_18814 = state_18771;
(statearr_18796_18814[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18771);

return cljs.core.cst$kw$recur;
} else {
throw e18795;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18815 = state_18771;
state_18771 = G__18815;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs$core$async$state_machine__16790__auto__ = function(state_18771){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16790__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16790__auto____1.call(this,state_18771);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16790__auto____0;
cljs$core$async$state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16790__auto____1;
return cljs$core$async$state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___18799,out))
})();
var state__16893__auto__ = (function (){var statearr_18797 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18797[(6)] = c__16891__auto___18799);

return statearr_18797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___18799,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

