// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.XhrIo');
goog.require('goog.net.Jsonp');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5457__auto__ = (function (){var fexpr__18818 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__18818.cljs$core$IFn$_invoke$arity$1 ? fexpr__18818.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__18818.call(null,channel));
})();
if(cljs.core.truth_(temp__5457__auto__)){
var req = temp__5457__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__18819){
var vec__18820 = p__18819;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18820,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18820,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__18823 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__18823)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__18823)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__18823)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__18823)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__18823)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__18823)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18823)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__18824){
var map__18825 = p__18824;
var map__18825__$1 = ((((!((map__18825 == null)))?((((map__18825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18825.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18825):map__18825);
var request = map__18825__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18825__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18825__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18825__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__8806__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__18827 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__18827,default_headers);

cljs_http.core.apply_response_type_BANG_(G__18827,response_type);

G__18827.setTimeoutInterval(timeout);

G__18827.setWithCredentials(send_credentials);

return G__18827;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__18828){
var map__18829 = p__18828;
var map__18829__$1 = ((((!((map__18829 == null)))?((((map__18829.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18829.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18829):map__18829);
var request = map__18829__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18829__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18829__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18829__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18829__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18829__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18829__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__8806__auto__ = request_method;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__18829,map__18829__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__18831 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__18831) : cljs_http.core.error_kw.call(null,G__18831));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__18829,map__18829__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_18854 = ((function (channel,request_url,method,headers__$1,xhr,map__18829,map__18829__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__18829,map__18829__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__18832_18855 = xhr;
G__18832_18855.setProgressEventsEnabled(true);

G__18832_18855.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_18854,cljs.core.cst$kw$upload));

G__18832_18855.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_18854,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__16891__auto___18856 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___18856,channel,request_url,method,headers__$1,xhr,map__18829,map__18829__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___18856,channel,request_url,method,headers__$1,xhr,map__18829,map__18829__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_18843){
var state_val_18844 = (state_18843[(1)]);
if((state_val_18844 === (1))){
var state_18843__$1 = state_18843;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18843__$1,(2),cancel);
} else {
if((state_val_18844 === (2))){
var inst_18834 = (state_18843[(2)]);
var inst_18835 = xhr.isComplete();
var inst_18836 = cljs.core.not(inst_18835);
var state_18843__$1 = (function (){var statearr_18845 = state_18843;
(statearr_18845[(7)] = inst_18834);

return statearr_18845;
})();
if(inst_18836){
var statearr_18846_18857 = state_18843__$1;
(statearr_18846_18857[(1)] = (3));

} else {
var statearr_18847_18858 = state_18843__$1;
(statearr_18847_18858[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18844 === (3))){
var inst_18838 = xhr.abort();
var state_18843__$1 = state_18843;
var statearr_18848_18859 = state_18843__$1;
(statearr_18848_18859[(2)] = inst_18838);

(statearr_18848_18859[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18844 === (4))){
var state_18843__$1 = state_18843;
var statearr_18849_18860 = state_18843__$1;
(statearr_18849_18860[(2)] = null);

(statearr_18849_18860[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18844 === (5))){
var inst_18841 = (state_18843[(2)]);
var state_18843__$1 = state_18843;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18843__$1,inst_18841);
} else {
return null;
}
}
}
}
}
});})(c__16891__auto___18856,channel,request_url,method,headers__$1,xhr,map__18829,map__18829__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__16789__auto__,c__16891__auto___18856,channel,request_url,method,headers__$1,xhr,map__18829,map__18829__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__16790__auto__ = null;
var cljs_http$core$xhr_$_state_machine__16790__auto____0 = (function (){
var statearr_18850 = [null,null,null,null,null,null,null,null];
(statearr_18850[(0)] = cljs_http$core$xhr_$_state_machine__16790__auto__);

(statearr_18850[(1)] = (1));

return statearr_18850;
});
var cljs_http$core$xhr_$_state_machine__16790__auto____1 = (function (state_18843){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18843);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18851){if((e18851 instanceof Object)){
var ex__16793__auto__ = e18851;
var statearr_18852_18861 = state_18843;
(statearr_18852_18861[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18843);

return cljs.core.cst$kw$recur;
} else {
throw e18851;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18862 = state_18843;
state_18843 = G__18862;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__16790__auto__ = function(state_18843){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__16790__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__16790__auto____1.call(this,state_18843);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$xhr_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__16790__auto____0;
cljs_http$core$xhr_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__16790__auto____1;
return cljs_http$core$xhr_$_state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___18856,channel,request_url,method,headers__$1,xhr,map__18829,map__18829__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__16893__auto__ = (function (){var statearr_18853 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18853[(6)] = c__16891__auto___18856);

return statearr_18853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___18856,channel,request_url,method,headers__$1,xhr,map__18829,map__18829__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__18863){
var map__18864 = p__18863;
var map__18864__$1 = ((((!((map__18864 == null)))?((((map__18864.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18864.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18864):map__18864);
var request = map__18864__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18864__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_18877 = jsonp.send(null,((function (channel,jsonp,map__18864,map__18864__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__18864,map__18864__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__18864,map__18864__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__18864,map__18864__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_18877], null));

if(cljs.core.truth_(cancel)){
var c__16891__auto___18878 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16891__auto___18878,req_18877,channel,jsonp,map__18864,map__18864__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__16892__auto__ = (function (){var switch__16789__auto__ = ((function (c__16891__auto___18878,req_18877,channel,jsonp,map__18864,map__18864__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_18870){
var state_val_18871 = (state_18870[(1)]);
if((state_val_18871 === (1))){
var state_18870__$1 = state_18870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18870__$1,(2),cancel);
} else {
if((state_val_18871 === (2))){
var inst_18867 = (state_18870[(2)]);
var inst_18868 = jsonp.cancel(req_18877);
var state_18870__$1 = (function (){var statearr_18872 = state_18870;
(statearr_18872[(7)] = inst_18867);

return statearr_18872;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18870__$1,inst_18868);
} else {
return null;
}
}
});})(c__16891__auto___18878,req_18877,channel,jsonp,map__18864,map__18864__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__16789__auto__,c__16891__auto___18878,req_18877,channel,jsonp,map__18864,map__18864__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__16790__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__16790__auto____0 = (function (){
var statearr_18873 = [null,null,null,null,null,null,null,null];
(statearr_18873[(0)] = cljs_http$core$jsonp_$_state_machine__16790__auto__);

(statearr_18873[(1)] = (1));

return statearr_18873;
});
var cljs_http$core$jsonp_$_state_machine__16790__auto____1 = (function (state_18870){
while(true){
var ret_value__16791__auto__ = (function (){try{while(true){
var result__16792__auto__ = switch__16789__auto__(state_18870);
if(cljs.core.keyword_identical_QMARK_(result__16792__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16792__auto__;
}
break;
}
}catch (e18874){if((e18874 instanceof Object)){
var ex__16793__auto__ = e18874;
var statearr_18875_18879 = state_18870;
(statearr_18875_18879[(5)] = ex__16793__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18870);

return cljs.core.cst$kw$recur;
} else {
throw e18874;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16791__auto__,cljs.core.cst$kw$recur)){
var G__18880 = state_18870;
state_18870 = G__18880;
continue;
} else {
return ret_value__16791__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__16790__auto__ = function(state_18870){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__16790__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__16790__auto____1.call(this,state_18870);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$jsonp_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__16790__auto____0;
cljs_http$core$jsonp_$_state_machine__16790__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__16790__auto____1;
return cljs_http$core$jsonp_$_state_machine__16790__auto__;
})()
;})(switch__16789__auto__,c__16891__auto___18878,req_18877,channel,jsonp,map__18864,map__18864__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__16893__auto__ = (function (){var statearr_18876 = (f__16892__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16892__auto__.cljs$core$IFn$_invoke$arity$0() : f__16892__auto__.call(null));
(statearr_18876[(6)] = c__16891__auto___18878);

return statearr_18876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16893__auto__);
});})(c__16891__auto___18878,req_18877,channel,jsonp,map__18864,map__18864__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__18881){
var map__18882 = p__18881;
var map__18882__$1 = ((((!((map__18882 == null)))?((((map__18882.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18882.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18882):map__18882);
var request = map__18882__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18882__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
