// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__8794__auto__ = v;
if(cljs.core.truth_(and__8794__auto__)){
return (v > (0));
} else {
return and__8794__auto__;
}
})())){
return v;
} else {
return null;
}
});
cljs_http.client.acc_param = (function cljs_http$client$acc_param(o,v){
if(cljs.core.coll_QMARK_(o)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(o,v);
} else {
if(!((o == null))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o,v], null);
} else {
return v;

}
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__18887_SHARP_,p2__18886_SHARP_){
var vec__18888 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__18886_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18888,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18888,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__18887_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),cljs_http.client.acc_param,no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_(url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.cst$kw$server_DASH_name,uri.getDomain(),cljs.core.cst$kw$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.cst$kw$uri,uri.getPath(),cljs.core.cst$kw$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),cljs.core.cst$kw$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode(cljs.core.name(k))),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode([cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18891_SHARP_){
return cljs_http.client.encode_val(k,p1__18891_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__18892){
var vec__18893 = p__18892;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18893,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18893,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__18896_SHARP_){
return ["\\",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__18896_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__8794__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$head,request_method);
if(and__8794__auto__){
var and__8794__auto____$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((204),cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response));
if(and__8794__auto____$1){
return cljs.core.re_find(cljs.core.re_pattern(["(?i)",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__8794__auto____$1;
}
} else {
return and__8794__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__5455__auto__ = cljs.core.cst$kw$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var params = temp__5455__auto__;
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request)], 0));
var G__18897 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$edn_DASH_params),cljs.core.cst$kw$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([params], 0))),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18897) : client.call(null,G__18897));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__18898_SHARP_){
return cljs_http.client.decode_body(p1__18898_SHARP_,cljs.reader.read_string,"application/edn",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__10092__auto__ = [];
var len__10085__auto___18906 = arguments.length;
var i__10086__auto___18907 = (0);
while(true){
if((i__10086__auto___18907 < len__10085__auto___18906)){
args__10092__auto__.push((arguments[i__10086__auto___18907]));

var G__18908 = (i__10086__auto___18907 + (1));
i__10086__auto___18907 = G__18908;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__18901){
var vec__18902 = p__18901;
var default_headers = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18902,(0),null);
return ((function (vec__18902,default_headers){
return (function (request){
var temp__5455__auto__ = (function (){var or__8806__auto__ = cljs.core.cst$kw$default_DASH_headers.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var default_headers__$1 = temp__5455__auto__;
var G__18905 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(request,cljs.core.cst$kw$default_DASH_headers,default_headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18905) : client.call(null,G__18905));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__18902,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq18899){
var G__18900 = cljs.core.first(seq18899);
var seq18899__$1 = cljs.core.next(seq18899);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__18900,seq18899__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__10092__auto__ = [];
var len__10085__auto___18916 = arguments.length;
var i__10086__auto___18917 = (0);
while(true){
if((i__10086__auto___18917 < len__10085__auto___18916)){
args__10092__auto__.push((arguments[i__10086__auto___18917]));

var G__18918 = (i__10086__auto___18917 + (1));
i__10086__auto___18917 = G__18918;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__18911){
var vec__18912 = p__18911;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18912,(0),null);
return ((function (vec__18912,accept){
return (function (request){
var temp__5455__auto__ = (function (){var or__8806__auto__ = cljs.core.cst$kw$accept.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var accept__$1 = temp__5455__auto__;
var G__18915 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18915) : client.call(null,G__18915));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__18912,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq18909){
var G__18910 = cljs.core.first(seq18909);
var seq18909__$1 = cljs.core.next(seq18909);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__18910,seq18909__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__10092__auto__ = [];
var len__10085__auto___18926 = arguments.length;
var i__10086__auto___18927 = (0);
while(true){
if((i__10086__auto___18927 < len__10085__auto___18926)){
args__10092__auto__.push((arguments[i__10086__auto___18927]));

var G__18928 = (i__10086__auto___18927 + (1));
i__10086__auto___18927 = G__18928;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__18921){
var vec__18922 = p__18921;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18922,(0),null);
return ((function (vec__18922,content_type){
return (function (request){
var temp__5455__auto__ = (function (){var or__8806__auto__ = cljs.core.cst$kw$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var content_type__$1 = temp__5455__auto__;
var G__18925 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18925) : client.call(null,G__18925));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__18922,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq18919){
var G__18920 = cljs.core.first(seq18919);
var seq18919__$1 = cljs.core.next(seq18919);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__18920,seq18919__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$encoding,cljs.core.cst$kw$json,cljs.core.cst$kw$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$decoding,cljs.core.cst$kw$json,cljs.core.cst$kw$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__5455__auto__ = cljs.core.cst$kw$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var params = temp__5455__auto__;
var map__18929 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs_http.client.default_transit_opts,cljs.core.cst$kw$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__18929__$1 = ((((!((map__18929 == null)))?((((map__18929.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18929.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18929):map__18929);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18929__$1,cljs.core.cst$kw$encoding);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18929__$1,cljs.core.cst$kw$encoding_DASH_opts);
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request)], 0));
var G__18931 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$transit_DASH_params),cljs.core.cst$kw$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18931) : client.call(null,G__18931));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__18934 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs_http.client.default_transit_opts,cljs.core.cst$kw$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__18934__$1 = ((((!((map__18934 == null)))?((((map__18934.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18934.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18934):map__18934);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18934__$1,cljs.core.cst$kw$decoding);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18934__$1,cljs.core.cst$kw$decoding_DASH_opts);
var transit_decode = ((function (map__18934,map__18934__$1,decoding,decoding_opts){
return (function (p1__18932_SHARP_){
return cljs_http.util.transit_decode(p1__18932_SHARP_,decoding,decoding_opts);
});})(map__18934,map__18934__$1,decoding,decoding_opts))
;
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(((function (map__18934,map__18934__$1,decoding,decoding_opts,transit_decode){
return (function (p1__18933_SHARP_){
return cljs_http.client.decode_body(p1__18933_SHARP_,transit_decode,"application/transit+json",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
});})(map__18934,map__18934__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__5455__auto__ = cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var params = temp__5455__auto__;
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request)], 0));
var G__18936 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$json_DASH_params),cljs.core.cst$kw$body,cljs_http.util.json_encode(params)),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18936) : client.call(null,G__18936));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__18937_SHARP_){
return cljs_http.client.decode_body(p1__18937_SHARP_,cljs_http.util.json_decode,"application/json",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__18938){
var map__18939 = p__18938;
var map__18939__$1 = ((((!((map__18939 == null)))?((((map__18939.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18939.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18939):map__18939);
var req = map__18939__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18939__$1,cljs.core.cst$kw$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__18941 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$query_DASH_params),cljs.core.cst$kw$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18941) : client.call(null,G__18941));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__18942){
var map__18943 = p__18942;
var map__18943__$1 = ((((!((map__18943 == null)))?((((map__18943.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18943.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18943):map__18943);
var request = map__18943__$1;
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18943__$1,cljs.core.cst$kw$form_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18943__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18943__$1,cljs.core.cst$kw$headers);
if(cljs.core.truth_((function (){var and__8794__auto__ = form_params;
if(cljs.core.truth_(and__8794__auto__)){
var fexpr__18945 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$patch,null,cljs.core.cst$kw$delete,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$put,null], null), null);
return (fexpr__18945.cljs$core$IFn$_invoke$arity$1 ? fexpr__18945.cljs$core$IFn$_invoke$arity$1(request_method) : fexpr__18945.call(null,request_method));
} else {
return and__8794__auto__;
}
})())){
var headers__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers], 0));
var G__18946 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$form_DASH_params),cljs.core.cst$kw$body,cljs_http.client.generate_query_string(form_params)),cljs.core.cst$kw$headers,headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18946) : client.call(null,G__18946));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__18947_18957 = cljs.core.seq(params);
var chunk__18948_18958 = null;
var count__18949_18959 = (0);
var i__18950_18960 = (0);
while(true){
if((i__18950_18960 < count__18949_18959)){
var vec__18951_18961 = chunk__18948_18958.cljs$core$IIndexed$_nth$arity$2(null,i__18950_18960);
var k_18962 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18951_18961,(0),null);
var v_18963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18951_18961,(1),null);
if(cljs.core.coll_QMARK_(v_18963)){
form_data.append(cljs.core.name(k_18962),cljs.core.first(v_18963),cljs.core.second(v_18963));
} else {
form_data.append(cljs.core.name(k_18962),v_18963);
}

var G__18964 = seq__18947_18957;
var G__18965 = chunk__18948_18958;
var G__18966 = count__18949_18959;
var G__18967 = (i__18950_18960 + (1));
seq__18947_18957 = G__18964;
chunk__18948_18958 = G__18965;
count__18949_18959 = G__18966;
i__18950_18960 = G__18967;
continue;
} else {
var temp__5457__auto___18968 = cljs.core.seq(seq__18947_18957);
if(temp__5457__auto___18968){
var seq__18947_18969__$1 = temp__5457__auto___18968;
if(cljs.core.chunked_seq_QMARK_(seq__18947_18969__$1)){
var c__9737__auto___18970 = cljs.core.chunk_first(seq__18947_18969__$1);
var G__18971 = cljs.core.chunk_rest(seq__18947_18969__$1);
var G__18972 = c__9737__auto___18970;
var G__18973 = cljs.core.count(c__9737__auto___18970);
var G__18974 = (0);
seq__18947_18957 = G__18971;
chunk__18948_18958 = G__18972;
count__18949_18959 = G__18973;
i__18950_18960 = G__18974;
continue;
} else {
var vec__18954_18975 = cljs.core.first(seq__18947_18969__$1);
var k_18976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18954_18975,(0),null);
var v_18977 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18954_18975,(1),null);
if(cljs.core.coll_QMARK_(v_18977)){
form_data.append(cljs.core.name(k_18976),cljs.core.first(v_18977),cljs.core.second(v_18977));
} else {
form_data.append(cljs.core.name(k_18976),v_18977);
}

var G__18978 = cljs.core.next(seq__18947_18969__$1);
var G__18979 = null;
var G__18980 = (0);
var G__18981 = (0);
seq__18947_18957 = G__18978;
chunk__18948_18958 = G__18979;
count__18949_18959 = G__18980;
i__18950_18960 = G__18981;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__18982){
var map__18983 = p__18982;
var map__18983__$1 = ((((!((map__18983 == null)))?((((map__18983.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18983.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18983):map__18983);
var request = map__18983__$1;
var multipart_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18983__$1,cljs.core.cst$kw$multipart_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18983__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core.truth_((function (){var and__8794__auto__ = multipart_params;
if(cljs.core.truth_(and__8794__auto__)){
var fexpr__18985 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$patch,null,cljs.core.cst$kw$delete,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$put,null], null), null);
return (fexpr__18985.cljs$core$IFn$_invoke$arity$1 ? fexpr__18985.cljs$core$IFn$_invoke$arity$1(request_method) : fexpr__18985.call(null,request_method));
} else {
return and__8794__auto__;
}
})())){
var G__18986 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$multipart_DASH_params),cljs.core.cst$kw$body,cljs_http.client.generate_form_data(multipart_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18986) : client.call(null,G__18986));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__5455__auto__ = cljs.core.cst$kw$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__5455__auto__)){
var m = temp__5455__auto__;
var G__18987 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$method),cljs.core.cst$kw$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18987) : client.call(null,G__18987));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__18988_SHARP_){
var G__18989 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__18988_SHARP_,cljs.core.cst$kw$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18989) : client.call(null,G__18989));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__18991){
var map__18992 = p__18991;
var map__18992__$1 = ((((!((map__18992 == null)))?((((map__18992.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18992.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18992):map__18992);
var req = map__18992__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18992__$1,cljs.core.cst$kw$query_DASH_params);
var temp__5455__auto__ = cljs_http.client.parse_url(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__5455__auto__)){
var spec = temp__5455__auto__;
var G__18994 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,spec], 0)),cljs.core.cst$kw$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params], null),((function (spec,temp__5455__auto__,map__18992,map__18992__$1,req,query_params){
return (function (p1__18990_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p1__18990_SHARP_,query_params], 0));
});})(spec,temp__5455__auto__,map__18992,map__18992__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__18994) : client.call(null,G__18994));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19002 = arguments.length;
var i__10086__auto___19003 = (0);
while(true){
if((i__10086__auto___19003 < len__10085__auto___19002)){
args__10092__auto__.push((arguments[i__10086__auto___19003]));

var G__19004 = (i__10086__auto___19003 + (1));
i__10086__auto___19003 = G__19004;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__18997){
var vec__18998 = p__18997;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18998,(0),null);
return ((function (vec__18998,credentials){
return (function (req){
var credentials__$1 = (function (){var or__8806__auto__ = cljs.core.cst$kw$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__19001 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__19001) : client.call(null,G__19001));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
;})(vec__18998,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq18995){
var G__18996 = cljs.core.first(seq18995);
var seq18995__$1 = cljs.core.next(seq18995);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__18996,seq18995__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__5455__auto__ = cljs.core.cst$kw$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__5455__auto__)){
var oauth_token = temp__5455__auto__;
var G__19005 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"authorization"], null),["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__19005) : client.call(null,G__19005));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__5455__auto__ = cljs.core.cst$kw$channel.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__5455__auto__)){
var custom_channel = temp__5455__auto__;
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request)),custom_channel);
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers(cljs_http.client.wrap_channel_from_request_map(cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_multipart_params(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19013 = arguments.length;
var i__10086__auto___19014 = (0);
while(true){
if((i__10086__auto___19014 < len__10085__auto___19013)){
args__10092__auto__.push((arguments[i__10086__auto___19014]));

var G__19015 = (i__10086__auto___19014 + (1));
i__10086__auto___19014 = G__19015;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19008){
var vec__19009 = p__19008;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19009,(0),null);
var G__19012 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$delete,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19012) : cljs_http.client.request.call(null,G__19012));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq19006){
var G__19007 = cljs.core.first(seq19006);
var seq19006__$1 = cljs.core.next(seq19006);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__19007,seq19006__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19023 = arguments.length;
var i__10086__auto___19024 = (0);
while(true){
if((i__10086__auto___19024 < len__10085__auto___19023)){
args__10092__auto__.push((arguments[i__10086__auto___19024]));

var G__19025 = (i__10086__auto___19024 + (1));
i__10086__auto___19024 = G__19025;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19018){
var vec__19019 = p__19018;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19019,(0),null);
var G__19022 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$get,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19022) : cljs_http.client.request.call(null,G__19022));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq19016){
var G__19017 = cljs.core.first(seq19016);
var seq19016__$1 = cljs.core.next(seq19016);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__19017,seq19016__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19033 = arguments.length;
var i__10086__auto___19034 = (0);
while(true){
if((i__10086__auto___19034 < len__10085__auto___19033)){
args__10092__auto__.push((arguments[i__10086__auto___19034]));

var G__19035 = (i__10086__auto___19034 + (1));
i__10086__auto___19034 = G__19035;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19028){
var vec__19029 = p__19028;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19029,(0),null);
var G__19032 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$head,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19032) : cljs_http.client.request.call(null,G__19032));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq19026){
var G__19027 = cljs.core.first(seq19026);
var seq19026__$1 = cljs.core.next(seq19026);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__19027,seq19026__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19043 = arguments.length;
var i__10086__auto___19044 = (0);
while(true){
if((i__10086__auto___19044 < len__10085__auto___19043)){
args__10092__auto__.push((arguments[i__10086__auto___19044]));

var G__19045 = (i__10086__auto___19044 + (1));
i__10086__auto___19044 = G__19045;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19038){
var vec__19039 = p__19038;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19039,(0),null);
var G__19042 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$jsonp,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19042) : cljs_http.client.request.call(null,G__19042));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq19036){
var G__19037 = cljs.core.first(seq19036);
var seq19036__$1 = cljs.core.next(seq19036);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__19037,seq19036__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19053 = arguments.length;
var i__10086__auto___19054 = (0);
while(true){
if((i__10086__auto___19054 < len__10085__auto___19053)){
args__10092__auto__.push((arguments[i__10086__auto___19054]));

var G__19055 = (i__10086__auto___19054 + (1));
i__10086__auto___19054 = G__19055;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19048){
var vec__19049 = p__19048;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19049,(0),null);
var G__19052 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$move,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19052) : cljs_http.client.request.call(null,G__19052));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq19046){
var G__19047 = cljs.core.first(seq19046);
var seq19046__$1 = cljs.core.next(seq19046);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__19047,seq19046__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19063 = arguments.length;
var i__10086__auto___19064 = (0);
while(true){
if((i__10086__auto___19064 < len__10085__auto___19063)){
args__10092__auto__.push((arguments[i__10086__auto___19064]));

var G__19065 = (i__10086__auto___19064 + (1));
i__10086__auto___19064 = G__19065;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19058){
var vec__19059 = p__19058;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19059,(0),null);
var G__19062 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$options,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19062) : cljs_http.client.request.call(null,G__19062));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq19056){
var G__19057 = cljs.core.first(seq19056);
var seq19056__$1 = cljs.core.next(seq19056);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__19057,seq19056__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19073 = arguments.length;
var i__10086__auto___19074 = (0);
while(true){
if((i__10086__auto___19074 < len__10085__auto___19073)){
args__10092__auto__.push((arguments[i__10086__auto___19074]));

var G__19075 = (i__10086__auto___19074 + (1));
i__10086__auto___19074 = G__19075;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19068){
var vec__19069 = p__19068;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19069,(0),null);
var G__19072 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$patch,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19072) : cljs_http.client.request.call(null,G__19072));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq19066){
var G__19067 = cljs.core.first(seq19066);
var seq19066__$1 = cljs.core.next(seq19066);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__19067,seq19066__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19083 = arguments.length;
var i__10086__auto___19084 = (0);
while(true){
if((i__10086__auto___19084 < len__10085__auto___19083)){
args__10092__auto__.push((arguments[i__10086__auto___19084]));

var G__19085 = (i__10086__auto___19084 + (1));
i__10086__auto___19084 = G__19085;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19078){
var vec__19079 = p__19078;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19079,(0),null);
var G__19082 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$post,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19082) : cljs_http.client.request.call(null,G__19082));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq19076){
var G__19077 = cljs.core.first(seq19076);
var seq19076__$1 = cljs.core.next(seq19076);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__19077,seq19076__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__10092__auto__ = [];
var len__10085__auto___19093 = arguments.length;
var i__10086__auto___19094 = (0);
while(true){
if((i__10086__auto___19094 < len__10085__auto___19093)){
args__10092__auto__.push((arguments[i__10086__auto___19094]));

var G__19095 = (i__10086__auto___19094 + (1));
i__10086__auto___19094 = G__19095;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19088){
var vec__19089 = p__19088;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19089,(0),null);
var G__19092 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$put,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__19092) : cljs_http.client.request.call(null,G__19092));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq19086){
var G__19087 = cljs.core.first(seq19086);
var seq19086__$1 = cljs.core.next(seq19086);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__19087,seq19086__$1);
});

