// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__16177 = arguments.length;
switch (G__16177) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async16178 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16178 = (function (f,blockable,meta16179){
this.f = f;
this.blockable = blockable;
this.meta16179 = meta16179;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16178.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16180,meta16179__$1){
var self__ = this;
var _16180__$1 = this;
return (new cljs.core.async.t_cljs$core$async16178(self__.f,self__.blockable,meta16179__$1));
});

cljs.core.async.t_cljs$core$async16178.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16180){
var self__ = this;
var _16180__$1 = this;
return self__.meta16179;
});

cljs.core.async.t_cljs$core$async16178.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16178.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16178.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async16178.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async16178.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta16179], null);
});

cljs.core.async.t_cljs$core$async16178.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16178.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16178";

cljs.core.async.t_cljs$core$async16178.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16178");
});

cljs.core.async.__GT_t_cljs$core$async16178 = (function cljs$core$async$__GT_t_cljs$core$async16178(f__$1,blockable__$1,meta16179){
return (new cljs.core.async.t_cljs$core$async16178(f__$1,blockable__$1,meta16179));
});

}

return (new cljs.core.async.t_cljs$core$async16178(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__16184 = arguments.length;
switch (G__16184) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__16187 = arguments.length;
switch (G__16187) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__16190 = arguments.length;
switch (G__16190) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_16192 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16192) : fn1.call(null,val_16192));
} else {
cljs.core.async.impl.dispatch.run(((function (val_16192,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16192) : fn1.call(null,val_16192));
});})(val_16192,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__16194 = arguments.length;
switch (G__16194) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9851__auto___16196 = n;
var x_16197 = (0);
while(true){
if((x_16197 < n__9851__auto___16196)){
(a[x_16197] = (0));

var G__16198 = (x_16197 + (1));
x_16197 = G__16198;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__16199 = (i + (1));
i = G__16199;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async16200 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16200 = (function (flag,meta16201){
this.flag = flag;
this.meta16201 = meta16201;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16200.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_16202,meta16201__$1){
var self__ = this;
var _16202__$1 = this;
return (new cljs.core.async.t_cljs$core$async16200(self__.flag,meta16201__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async16200.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_16202){
var self__ = this;
var _16202__$1 = this;
return self__.meta16201;
});})(flag))
;

cljs.core.async.t_cljs$core$async16200.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16200.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async16200.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16200.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16200.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta16201], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async16200.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16200.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16200";

cljs.core.async.t_cljs$core$async16200.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16200");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async16200 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async16200(flag__$1,meta16201){
return (new cljs.core.async.t_cljs$core$async16200(flag__$1,meta16201));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async16200(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async16203 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16203 = (function (flag,cb,meta16204){
this.flag = flag;
this.cb = cb;
this.meta16204 = meta16204;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16203.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16205,meta16204__$1){
var self__ = this;
var _16205__$1 = this;
return (new cljs.core.async.t_cljs$core$async16203(self__.flag,self__.cb,meta16204__$1));
});

cljs.core.async.t_cljs$core$async16203.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16205){
var self__ = this;
var _16205__$1 = this;
return self__.meta16204;
});

cljs.core.async.t_cljs$core$async16203.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16203.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async16203.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16203.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async16203.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta16204], null);
});

cljs.core.async.t_cljs$core$async16203.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16203.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16203";

cljs.core.async.t_cljs$core$async16203.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16203");
});

cljs.core.async.__GT_t_cljs$core$async16203 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async16203(flag__$1,cb__$1,meta16204){
return (new cljs.core.async.t_cljs$core$async16203(flag__$1,cb__$1,meta16204));
});

}

return (new cljs.core.async.t_cljs$core$async16203(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16206_SHARP_){
var G__16208 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16206_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16208) : fret.call(null,G__16208));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16207_SHARP_){
var G__16209 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16207_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16209) : fret.call(null,G__16209));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__8806__auto__ = wport;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return port;
}
})()], null));
} else {
var G__16210 = (i + (1));
i = G__16210;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8806__auto__ = ret;
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__8794__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8794__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8794__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10092__auto__ = [];
var len__10085__auto___16216 = arguments.length;
var i__10086__auto___16217 = (0);
while(true){
if((i__10086__auto___16217 < len__10085__auto___16216)){
args__10092__auto__.push((arguments[i__10086__auto___16217]));

var G__16218 = (i__10086__auto___16217 + (1));
i__10086__auto___16217 = G__16218;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((1) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10093__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__16213){
var map__16214 = p__16213;
var map__16214__$1 = ((((!((map__16214 == null)))?((((map__16214.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16214.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16214):map__16214);
var opts = map__16214__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq16211){
var G__16212 = cljs.core.first(seq16211);
var seq16211__$1 = cljs.core.next(seq16211);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16212,seq16211__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__16220 = arguments.length;
switch (G__16220) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16117__auto___16266 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___16266){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___16266){
return (function (state_16244){
var state_val_16245 = (state_16244[(1)]);
if((state_val_16245 === (7))){
var inst_16240 = (state_16244[(2)]);
var state_16244__$1 = state_16244;
var statearr_16246_16267 = state_16244__$1;
(statearr_16246_16267[(2)] = inst_16240);

(statearr_16246_16267[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16245 === (1))){
var state_16244__$1 = state_16244;
var statearr_16247_16268 = state_16244__$1;
(statearr_16247_16268[(2)] = null);

(statearr_16247_16268[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16245 === (4))){
var inst_16223 = (state_16244[(7)]);
var inst_16223__$1 = (state_16244[(2)]);
var inst_16224 = (inst_16223__$1 == null);
var state_16244__$1 = (function (){var statearr_16248 = state_16244;
(statearr_16248[(7)] = inst_16223__$1);

return statearr_16248;
})();
if(cljs.core.truth_(inst_16224)){
var statearr_16249_16269 = state_16244__$1;
(statearr_16249_16269[(1)] = (5));

} else {
var statearr_16250_16270 = state_16244__$1;
(statearr_16250_16270[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16245 === (13))){
var state_16244__$1 = state_16244;
var statearr_16251_16271 = state_16244__$1;
(statearr_16251_16271[(2)] = null);

(statearr_16251_16271[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16245 === (6))){
var inst_16223 = (state_16244[(7)]);
var state_16244__$1 = state_16244;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16244__$1,(11),to,inst_16223);
} else {
if((state_val_16245 === (3))){
var inst_16242 = (state_16244[(2)]);
var state_16244__$1 = state_16244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16244__$1,inst_16242);
} else {
if((state_val_16245 === (12))){
var state_16244__$1 = state_16244;
var statearr_16252_16272 = state_16244__$1;
(statearr_16252_16272[(2)] = null);

(statearr_16252_16272[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16245 === (2))){
var state_16244__$1 = state_16244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16244__$1,(4),from);
} else {
if((state_val_16245 === (11))){
var inst_16233 = (state_16244[(2)]);
var state_16244__$1 = state_16244;
if(cljs.core.truth_(inst_16233)){
var statearr_16253_16273 = state_16244__$1;
(statearr_16253_16273[(1)] = (12));

} else {
var statearr_16254_16274 = state_16244__$1;
(statearr_16254_16274[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16245 === (9))){
var state_16244__$1 = state_16244;
var statearr_16255_16275 = state_16244__$1;
(statearr_16255_16275[(2)] = null);

(statearr_16255_16275[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16245 === (5))){
var state_16244__$1 = state_16244;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16256_16276 = state_16244__$1;
(statearr_16256_16276[(1)] = (8));

} else {
var statearr_16257_16277 = state_16244__$1;
(statearr_16257_16277[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16245 === (14))){
var inst_16238 = (state_16244[(2)]);
var state_16244__$1 = state_16244;
var statearr_16258_16278 = state_16244__$1;
(statearr_16258_16278[(2)] = inst_16238);

(statearr_16258_16278[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16245 === (10))){
var inst_16230 = (state_16244[(2)]);
var state_16244__$1 = state_16244;
var statearr_16259_16279 = state_16244__$1;
(statearr_16259_16279[(2)] = inst_16230);

(statearr_16259_16279[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16245 === (8))){
var inst_16227 = cljs.core.async.close_BANG_(to);
var state_16244__$1 = state_16244;
var statearr_16260_16280 = state_16244__$1;
(statearr_16260_16280[(2)] = inst_16227);

(statearr_16260_16280[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___16266))
;
return ((function (switch__16015__auto__,c__16117__auto___16266){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_16261 = [null,null,null,null,null,null,null,null];
(statearr_16261[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_16261[(1)] = (1));

return statearr_16261;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_16244){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16244);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16262){if((e16262 instanceof Object)){
var ex__16019__auto__ = e16262;
var statearr_16263_16281 = state_16244;
(statearr_16263_16281[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16244);

return cljs.core.cst$kw$recur;
} else {
throw e16262;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16282 = state_16244;
state_16244 = G__16282;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_16244){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_16244);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___16266))
})();
var state__16119__auto__ = (function (){var statearr_16264 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16264[(6)] = c__16117__auto___16266);

return statearr_16264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___16266))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__16283){
var vec__16284 = p__16283;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16284,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16284,(1),null);
var job = vec__16284;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__16117__auto___16455 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___16455,res,vec__16284,v,p,job,jobs,results){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___16455,res,vec__16284,v,p,job,jobs,results){
return (function (state_16291){
var state_val_16292 = (state_16291[(1)]);
if((state_val_16292 === (1))){
var state_16291__$1 = state_16291;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16291__$1,(2),res,v);
} else {
if((state_val_16292 === (2))){
var inst_16288 = (state_16291[(2)]);
var inst_16289 = cljs.core.async.close_BANG_(res);
var state_16291__$1 = (function (){var statearr_16293 = state_16291;
(statearr_16293[(7)] = inst_16288);

return statearr_16293;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16291__$1,inst_16289);
} else {
return null;
}
}
});})(c__16117__auto___16455,res,vec__16284,v,p,job,jobs,results))
;
return ((function (switch__16015__auto__,c__16117__auto___16455,res,vec__16284,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0 = (function (){
var statearr_16294 = [null,null,null,null,null,null,null,null];
(statearr_16294[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__);

(statearr_16294[(1)] = (1));

return statearr_16294;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1 = (function (state_16291){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16291);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16295){if((e16295 instanceof Object)){
var ex__16019__auto__ = e16295;
var statearr_16296_16456 = state_16291;
(statearr_16296_16456[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16291);

return cljs.core.cst$kw$recur;
} else {
throw e16295;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16457 = state_16291;
state_16291 = G__16457;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__ = function(state_16291){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1.call(this,state_16291);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___16455,res,vec__16284,v,p,job,jobs,results))
})();
var state__16119__auto__ = (function (){var statearr_16297 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16297[(6)] = c__16117__auto___16455);

return statearr_16297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___16455,res,vec__16284,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__16298){
var vec__16299 = p__16298;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16299,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16299,(1),null);
var job = vec__16299;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__9851__auto___16458 = n;
var __16459 = (0);
while(true){
if((__16459 < n__9851__auto___16458)){
var G__16302_16460 = type;
var G__16302_16461__$1 = (((G__16302_16460 instanceof cljs.core.Keyword))?G__16302_16460.fqn:null);
switch (G__16302_16461__$1) {
case "compute":
var c__16117__auto___16463 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__16459,c__16117__auto___16463,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (__16459,c__16117__auto___16463,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async){
return (function (state_16315){
var state_val_16316 = (state_16315[(1)]);
if((state_val_16316 === (1))){
var state_16315__$1 = state_16315;
var statearr_16317_16464 = state_16315__$1;
(statearr_16317_16464[(2)] = null);

(statearr_16317_16464[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16316 === (2))){
var state_16315__$1 = state_16315;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16315__$1,(4),jobs);
} else {
if((state_val_16316 === (3))){
var inst_16313 = (state_16315[(2)]);
var state_16315__$1 = state_16315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16315__$1,inst_16313);
} else {
if((state_val_16316 === (4))){
var inst_16305 = (state_16315[(2)]);
var inst_16306 = process(inst_16305);
var state_16315__$1 = state_16315;
if(cljs.core.truth_(inst_16306)){
var statearr_16318_16465 = state_16315__$1;
(statearr_16318_16465[(1)] = (5));

} else {
var statearr_16319_16466 = state_16315__$1;
(statearr_16319_16466[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16316 === (5))){
var state_16315__$1 = state_16315;
var statearr_16320_16467 = state_16315__$1;
(statearr_16320_16467[(2)] = null);

(statearr_16320_16467[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16316 === (6))){
var state_16315__$1 = state_16315;
var statearr_16321_16468 = state_16315__$1;
(statearr_16321_16468[(2)] = null);

(statearr_16321_16468[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16316 === (7))){
var inst_16311 = (state_16315[(2)]);
var state_16315__$1 = state_16315;
var statearr_16322_16469 = state_16315__$1;
(statearr_16322_16469[(2)] = inst_16311);

(statearr_16322_16469[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__16459,c__16117__auto___16463,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async))
;
return ((function (__16459,switch__16015__auto__,c__16117__auto___16463,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0 = (function (){
var statearr_16323 = [null,null,null,null,null,null,null];
(statearr_16323[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__);

(statearr_16323[(1)] = (1));

return statearr_16323;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1 = (function (state_16315){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16315);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16324){if((e16324 instanceof Object)){
var ex__16019__auto__ = e16324;
var statearr_16325_16470 = state_16315;
(statearr_16325_16470[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16315);

return cljs.core.cst$kw$recur;
} else {
throw e16324;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16471 = state_16315;
state_16315 = G__16471;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__ = function(state_16315){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1.call(this,state_16315);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__;
})()
;})(__16459,switch__16015__auto__,c__16117__auto___16463,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async))
})();
var state__16119__auto__ = (function (){var statearr_16326 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16326[(6)] = c__16117__auto___16463);

return statearr_16326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(__16459,c__16117__auto___16463,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async))
);


break;
case "async":
var c__16117__auto___16472 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__16459,c__16117__auto___16472,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (__16459,c__16117__auto___16472,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async){
return (function (state_16339){
var state_val_16340 = (state_16339[(1)]);
if((state_val_16340 === (1))){
var state_16339__$1 = state_16339;
var statearr_16341_16473 = state_16339__$1;
(statearr_16341_16473[(2)] = null);

(statearr_16341_16473[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16340 === (2))){
var state_16339__$1 = state_16339;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16339__$1,(4),jobs);
} else {
if((state_val_16340 === (3))){
var inst_16337 = (state_16339[(2)]);
var state_16339__$1 = state_16339;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16339__$1,inst_16337);
} else {
if((state_val_16340 === (4))){
var inst_16329 = (state_16339[(2)]);
var inst_16330 = async(inst_16329);
var state_16339__$1 = state_16339;
if(cljs.core.truth_(inst_16330)){
var statearr_16342_16474 = state_16339__$1;
(statearr_16342_16474[(1)] = (5));

} else {
var statearr_16343_16475 = state_16339__$1;
(statearr_16343_16475[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16340 === (5))){
var state_16339__$1 = state_16339;
var statearr_16344_16476 = state_16339__$1;
(statearr_16344_16476[(2)] = null);

(statearr_16344_16476[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16340 === (6))){
var state_16339__$1 = state_16339;
var statearr_16345_16477 = state_16339__$1;
(statearr_16345_16477[(2)] = null);

(statearr_16345_16477[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16340 === (7))){
var inst_16335 = (state_16339[(2)]);
var state_16339__$1 = state_16339;
var statearr_16346_16478 = state_16339__$1;
(statearr_16346_16478[(2)] = inst_16335);

(statearr_16346_16478[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__16459,c__16117__auto___16472,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async))
;
return ((function (__16459,switch__16015__auto__,c__16117__auto___16472,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0 = (function (){
var statearr_16347 = [null,null,null,null,null,null,null];
(statearr_16347[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__);

(statearr_16347[(1)] = (1));

return statearr_16347;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1 = (function (state_16339){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16339);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16348){if((e16348 instanceof Object)){
var ex__16019__auto__ = e16348;
var statearr_16349_16479 = state_16339;
(statearr_16349_16479[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16339);

return cljs.core.cst$kw$recur;
} else {
throw e16348;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16480 = state_16339;
state_16339 = G__16480;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__ = function(state_16339){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1.call(this,state_16339);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__;
})()
;})(__16459,switch__16015__auto__,c__16117__auto___16472,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async))
})();
var state__16119__auto__ = (function (){var statearr_16350 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16350[(6)] = c__16117__auto___16472);

return statearr_16350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(__16459,c__16117__auto___16472,G__16302_16460,G__16302_16461__$1,n__9851__auto___16458,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__16302_16461__$1)].join('')));

}

var G__16481 = (__16459 + (1));
__16459 = G__16481;
continue;
} else {
}
break;
}

var c__16117__auto___16482 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___16482,jobs,results,process,async){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___16482,jobs,results,process,async){
return (function (state_16372){
var state_val_16373 = (state_16372[(1)]);
if((state_val_16373 === (1))){
var state_16372__$1 = state_16372;
var statearr_16374_16483 = state_16372__$1;
(statearr_16374_16483[(2)] = null);

(statearr_16374_16483[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16373 === (2))){
var state_16372__$1 = state_16372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16372__$1,(4),from);
} else {
if((state_val_16373 === (3))){
var inst_16370 = (state_16372[(2)]);
var state_16372__$1 = state_16372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16372__$1,inst_16370);
} else {
if((state_val_16373 === (4))){
var inst_16353 = (state_16372[(7)]);
var inst_16353__$1 = (state_16372[(2)]);
var inst_16354 = (inst_16353__$1 == null);
var state_16372__$1 = (function (){var statearr_16375 = state_16372;
(statearr_16375[(7)] = inst_16353__$1);

return statearr_16375;
})();
if(cljs.core.truth_(inst_16354)){
var statearr_16376_16484 = state_16372__$1;
(statearr_16376_16484[(1)] = (5));

} else {
var statearr_16377_16485 = state_16372__$1;
(statearr_16377_16485[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16373 === (5))){
var inst_16356 = cljs.core.async.close_BANG_(jobs);
var state_16372__$1 = state_16372;
var statearr_16378_16486 = state_16372__$1;
(statearr_16378_16486[(2)] = inst_16356);

(statearr_16378_16486[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16373 === (6))){
var inst_16358 = (state_16372[(8)]);
var inst_16353 = (state_16372[(7)]);
var inst_16358__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_16359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16360 = [inst_16353,inst_16358__$1];
var inst_16361 = (new cljs.core.PersistentVector(null,2,(5),inst_16359,inst_16360,null));
var state_16372__$1 = (function (){var statearr_16379 = state_16372;
(statearr_16379[(8)] = inst_16358__$1);

return statearr_16379;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16372__$1,(8),jobs,inst_16361);
} else {
if((state_val_16373 === (7))){
var inst_16368 = (state_16372[(2)]);
var state_16372__$1 = state_16372;
var statearr_16380_16487 = state_16372__$1;
(statearr_16380_16487[(2)] = inst_16368);

(statearr_16380_16487[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16373 === (8))){
var inst_16358 = (state_16372[(8)]);
var inst_16363 = (state_16372[(2)]);
var state_16372__$1 = (function (){var statearr_16381 = state_16372;
(statearr_16381[(9)] = inst_16363);

return statearr_16381;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16372__$1,(9),results,inst_16358);
} else {
if((state_val_16373 === (9))){
var inst_16365 = (state_16372[(2)]);
var state_16372__$1 = (function (){var statearr_16382 = state_16372;
(statearr_16382[(10)] = inst_16365);

return statearr_16382;
})();
var statearr_16383_16488 = state_16372__$1;
(statearr_16383_16488[(2)] = null);

(statearr_16383_16488[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___16482,jobs,results,process,async))
;
return ((function (switch__16015__auto__,c__16117__auto___16482,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0 = (function (){
var statearr_16384 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16384[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__);

(statearr_16384[(1)] = (1));

return statearr_16384;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1 = (function (state_16372){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16372);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16385){if((e16385 instanceof Object)){
var ex__16019__auto__ = e16385;
var statearr_16386_16489 = state_16372;
(statearr_16386_16489[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16372);

return cljs.core.cst$kw$recur;
} else {
throw e16385;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16490 = state_16372;
state_16372 = G__16490;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__ = function(state_16372){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1.call(this,state_16372);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___16482,jobs,results,process,async))
})();
var state__16119__auto__ = (function (){var statearr_16387 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16387[(6)] = c__16117__auto___16482);

return statearr_16387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___16482,jobs,results,process,async))
);


var c__16117__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto__,jobs,results,process,async){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto__,jobs,results,process,async){
return (function (state_16425){
var state_val_16426 = (state_16425[(1)]);
if((state_val_16426 === (7))){
var inst_16421 = (state_16425[(2)]);
var state_16425__$1 = state_16425;
var statearr_16427_16491 = state_16425__$1;
(statearr_16427_16491[(2)] = inst_16421);

(statearr_16427_16491[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (20))){
var state_16425__$1 = state_16425;
var statearr_16428_16492 = state_16425__$1;
(statearr_16428_16492[(2)] = null);

(statearr_16428_16492[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (1))){
var state_16425__$1 = state_16425;
var statearr_16429_16493 = state_16425__$1;
(statearr_16429_16493[(2)] = null);

(statearr_16429_16493[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (4))){
var inst_16390 = (state_16425[(7)]);
var inst_16390__$1 = (state_16425[(2)]);
var inst_16391 = (inst_16390__$1 == null);
var state_16425__$1 = (function (){var statearr_16430 = state_16425;
(statearr_16430[(7)] = inst_16390__$1);

return statearr_16430;
})();
if(cljs.core.truth_(inst_16391)){
var statearr_16431_16494 = state_16425__$1;
(statearr_16431_16494[(1)] = (5));

} else {
var statearr_16432_16495 = state_16425__$1;
(statearr_16432_16495[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (15))){
var inst_16403 = (state_16425[(8)]);
var state_16425__$1 = state_16425;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16425__$1,(18),to,inst_16403);
} else {
if((state_val_16426 === (21))){
var inst_16416 = (state_16425[(2)]);
var state_16425__$1 = state_16425;
var statearr_16433_16496 = state_16425__$1;
(statearr_16433_16496[(2)] = inst_16416);

(statearr_16433_16496[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (13))){
var inst_16418 = (state_16425[(2)]);
var state_16425__$1 = (function (){var statearr_16434 = state_16425;
(statearr_16434[(9)] = inst_16418);

return statearr_16434;
})();
var statearr_16435_16497 = state_16425__$1;
(statearr_16435_16497[(2)] = null);

(statearr_16435_16497[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (6))){
var inst_16390 = (state_16425[(7)]);
var state_16425__$1 = state_16425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16425__$1,(11),inst_16390);
} else {
if((state_val_16426 === (17))){
var inst_16411 = (state_16425[(2)]);
var state_16425__$1 = state_16425;
if(cljs.core.truth_(inst_16411)){
var statearr_16436_16498 = state_16425__$1;
(statearr_16436_16498[(1)] = (19));

} else {
var statearr_16437_16499 = state_16425__$1;
(statearr_16437_16499[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (3))){
var inst_16423 = (state_16425[(2)]);
var state_16425__$1 = state_16425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16425__$1,inst_16423);
} else {
if((state_val_16426 === (12))){
var inst_16400 = (state_16425[(10)]);
var state_16425__$1 = state_16425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16425__$1,(14),inst_16400);
} else {
if((state_val_16426 === (2))){
var state_16425__$1 = state_16425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16425__$1,(4),results);
} else {
if((state_val_16426 === (19))){
var state_16425__$1 = state_16425;
var statearr_16438_16500 = state_16425__$1;
(statearr_16438_16500[(2)] = null);

(statearr_16438_16500[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (11))){
var inst_16400 = (state_16425[(2)]);
var state_16425__$1 = (function (){var statearr_16439 = state_16425;
(statearr_16439[(10)] = inst_16400);

return statearr_16439;
})();
var statearr_16440_16501 = state_16425__$1;
(statearr_16440_16501[(2)] = null);

(statearr_16440_16501[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (9))){
var state_16425__$1 = state_16425;
var statearr_16441_16502 = state_16425__$1;
(statearr_16441_16502[(2)] = null);

(statearr_16441_16502[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (5))){
var state_16425__$1 = state_16425;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16442_16503 = state_16425__$1;
(statearr_16442_16503[(1)] = (8));

} else {
var statearr_16443_16504 = state_16425__$1;
(statearr_16443_16504[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (14))){
var inst_16403 = (state_16425[(8)]);
var inst_16405 = (state_16425[(11)]);
var inst_16403__$1 = (state_16425[(2)]);
var inst_16404 = (inst_16403__$1 == null);
var inst_16405__$1 = cljs.core.not(inst_16404);
var state_16425__$1 = (function (){var statearr_16444 = state_16425;
(statearr_16444[(8)] = inst_16403__$1);

(statearr_16444[(11)] = inst_16405__$1);

return statearr_16444;
})();
if(inst_16405__$1){
var statearr_16445_16505 = state_16425__$1;
(statearr_16445_16505[(1)] = (15));

} else {
var statearr_16446_16506 = state_16425__$1;
(statearr_16446_16506[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (16))){
var inst_16405 = (state_16425[(11)]);
var state_16425__$1 = state_16425;
var statearr_16447_16507 = state_16425__$1;
(statearr_16447_16507[(2)] = inst_16405);

(statearr_16447_16507[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (10))){
var inst_16397 = (state_16425[(2)]);
var state_16425__$1 = state_16425;
var statearr_16448_16508 = state_16425__$1;
(statearr_16448_16508[(2)] = inst_16397);

(statearr_16448_16508[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (18))){
var inst_16408 = (state_16425[(2)]);
var state_16425__$1 = state_16425;
var statearr_16449_16509 = state_16425__$1;
(statearr_16449_16509[(2)] = inst_16408);

(statearr_16449_16509[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16426 === (8))){
var inst_16394 = cljs.core.async.close_BANG_(to);
var state_16425__$1 = state_16425;
var statearr_16450_16510 = state_16425__$1;
(statearr_16450_16510[(2)] = inst_16394);

(statearr_16450_16510[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto__,jobs,results,process,async))
;
return ((function (switch__16015__auto__,c__16117__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0 = (function (){
var statearr_16451 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16451[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__);

(statearr_16451[(1)] = (1));

return statearr_16451;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1 = (function (state_16425){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16425);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16452){if((e16452 instanceof Object)){
var ex__16019__auto__ = e16452;
var statearr_16453_16511 = state_16425;
(statearr_16453_16511[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16425);

return cljs.core.cst$kw$recur;
} else {
throw e16452;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16512 = state_16425;
state_16425 = G__16512;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__ = function(state_16425){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1.call(this,state_16425);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16016__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto__,jobs,results,process,async))
})();
var state__16119__auto__ = (function (){var statearr_16454 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16454[(6)] = c__16117__auto__);

return statearr_16454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto__,jobs,results,process,async))
);

return c__16117__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__16514 = arguments.length;
switch (G__16514) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__16517 = arguments.length;
switch (G__16517) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__16520 = arguments.length;
switch (G__16520) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__16117__auto___16569 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___16569,tc,fc){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___16569,tc,fc){
return (function (state_16546){
var state_val_16547 = (state_16546[(1)]);
if((state_val_16547 === (7))){
var inst_16542 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
var statearr_16548_16570 = state_16546__$1;
(statearr_16548_16570[(2)] = inst_16542);

(statearr_16548_16570[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16547 === (1))){
var state_16546__$1 = state_16546;
var statearr_16549_16571 = state_16546__$1;
(statearr_16549_16571[(2)] = null);

(statearr_16549_16571[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16547 === (4))){
var inst_16523 = (state_16546[(7)]);
var inst_16523__$1 = (state_16546[(2)]);
var inst_16524 = (inst_16523__$1 == null);
var state_16546__$1 = (function (){var statearr_16550 = state_16546;
(statearr_16550[(7)] = inst_16523__$1);

return statearr_16550;
})();
if(cljs.core.truth_(inst_16524)){
var statearr_16551_16572 = state_16546__$1;
(statearr_16551_16572[(1)] = (5));

} else {
var statearr_16552_16573 = state_16546__$1;
(statearr_16552_16573[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16547 === (13))){
var state_16546__$1 = state_16546;
var statearr_16553_16574 = state_16546__$1;
(statearr_16553_16574[(2)] = null);

(statearr_16553_16574[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16547 === (6))){
var inst_16523 = (state_16546[(7)]);
var inst_16529 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_16523) : p.call(null,inst_16523));
var state_16546__$1 = state_16546;
if(cljs.core.truth_(inst_16529)){
var statearr_16554_16575 = state_16546__$1;
(statearr_16554_16575[(1)] = (9));

} else {
var statearr_16555_16576 = state_16546__$1;
(statearr_16555_16576[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16547 === (3))){
var inst_16544 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16546__$1,inst_16544);
} else {
if((state_val_16547 === (12))){
var state_16546__$1 = state_16546;
var statearr_16556_16577 = state_16546__$1;
(statearr_16556_16577[(2)] = null);

(statearr_16556_16577[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16547 === (2))){
var state_16546__$1 = state_16546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16546__$1,(4),ch);
} else {
if((state_val_16547 === (11))){
var inst_16523 = (state_16546[(7)]);
var inst_16533 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16546__$1,(8),inst_16533,inst_16523);
} else {
if((state_val_16547 === (9))){
var state_16546__$1 = state_16546;
var statearr_16557_16578 = state_16546__$1;
(statearr_16557_16578[(2)] = tc);

(statearr_16557_16578[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16547 === (5))){
var inst_16526 = cljs.core.async.close_BANG_(tc);
var inst_16527 = cljs.core.async.close_BANG_(fc);
var state_16546__$1 = (function (){var statearr_16558 = state_16546;
(statearr_16558[(8)] = inst_16526);

return statearr_16558;
})();
var statearr_16559_16579 = state_16546__$1;
(statearr_16559_16579[(2)] = inst_16527);

(statearr_16559_16579[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16547 === (14))){
var inst_16540 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
var statearr_16560_16580 = state_16546__$1;
(statearr_16560_16580[(2)] = inst_16540);

(statearr_16560_16580[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16547 === (10))){
var state_16546__$1 = state_16546;
var statearr_16561_16581 = state_16546__$1;
(statearr_16561_16581[(2)] = fc);

(statearr_16561_16581[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16547 === (8))){
var inst_16535 = (state_16546[(2)]);
var state_16546__$1 = state_16546;
if(cljs.core.truth_(inst_16535)){
var statearr_16562_16582 = state_16546__$1;
(statearr_16562_16582[(1)] = (12));

} else {
var statearr_16563_16583 = state_16546__$1;
(statearr_16563_16583[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___16569,tc,fc))
;
return ((function (switch__16015__auto__,c__16117__auto___16569,tc,fc){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_16564 = [null,null,null,null,null,null,null,null,null];
(statearr_16564[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_16564[(1)] = (1));

return statearr_16564;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_16546){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16546);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16565){if((e16565 instanceof Object)){
var ex__16019__auto__ = e16565;
var statearr_16566_16584 = state_16546;
(statearr_16566_16584[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16546);

return cljs.core.cst$kw$recur;
} else {
throw e16565;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16585 = state_16546;
state_16546 = G__16585;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_16546){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_16546);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___16569,tc,fc))
})();
var state__16119__auto__ = (function (){var statearr_16567 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16567[(6)] = c__16117__auto___16569);

return statearr_16567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___16569,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16117__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto__){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto__){
return (function (state_16606){
var state_val_16607 = (state_16606[(1)]);
if((state_val_16607 === (7))){
var inst_16602 = (state_16606[(2)]);
var state_16606__$1 = state_16606;
var statearr_16608_16626 = state_16606__$1;
(statearr_16608_16626[(2)] = inst_16602);

(statearr_16608_16626[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16607 === (1))){
var inst_16586 = init;
var state_16606__$1 = (function (){var statearr_16609 = state_16606;
(statearr_16609[(7)] = inst_16586);

return statearr_16609;
})();
var statearr_16610_16627 = state_16606__$1;
(statearr_16610_16627[(2)] = null);

(statearr_16610_16627[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16607 === (4))){
var inst_16589 = (state_16606[(8)]);
var inst_16589__$1 = (state_16606[(2)]);
var inst_16590 = (inst_16589__$1 == null);
var state_16606__$1 = (function (){var statearr_16611 = state_16606;
(statearr_16611[(8)] = inst_16589__$1);

return statearr_16611;
})();
if(cljs.core.truth_(inst_16590)){
var statearr_16612_16628 = state_16606__$1;
(statearr_16612_16628[(1)] = (5));

} else {
var statearr_16613_16629 = state_16606__$1;
(statearr_16613_16629[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16607 === (6))){
var inst_16593 = (state_16606[(9)]);
var inst_16589 = (state_16606[(8)]);
var inst_16586 = (state_16606[(7)]);
var inst_16593__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_16586,inst_16589) : f.call(null,inst_16586,inst_16589));
var inst_16594 = cljs.core.reduced_QMARK_(inst_16593__$1);
var state_16606__$1 = (function (){var statearr_16614 = state_16606;
(statearr_16614[(9)] = inst_16593__$1);

return statearr_16614;
})();
if(inst_16594){
var statearr_16615_16630 = state_16606__$1;
(statearr_16615_16630[(1)] = (8));

} else {
var statearr_16616_16631 = state_16606__$1;
(statearr_16616_16631[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16607 === (3))){
var inst_16604 = (state_16606[(2)]);
var state_16606__$1 = state_16606;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16606__$1,inst_16604);
} else {
if((state_val_16607 === (2))){
var state_16606__$1 = state_16606;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16606__$1,(4),ch);
} else {
if((state_val_16607 === (9))){
var inst_16593 = (state_16606[(9)]);
var inst_16586 = inst_16593;
var state_16606__$1 = (function (){var statearr_16617 = state_16606;
(statearr_16617[(7)] = inst_16586);

return statearr_16617;
})();
var statearr_16618_16632 = state_16606__$1;
(statearr_16618_16632[(2)] = null);

(statearr_16618_16632[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16607 === (5))){
var inst_16586 = (state_16606[(7)]);
var state_16606__$1 = state_16606;
var statearr_16619_16633 = state_16606__$1;
(statearr_16619_16633[(2)] = inst_16586);

(statearr_16619_16633[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16607 === (10))){
var inst_16600 = (state_16606[(2)]);
var state_16606__$1 = state_16606;
var statearr_16620_16634 = state_16606__$1;
(statearr_16620_16634[(2)] = inst_16600);

(statearr_16620_16634[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16607 === (8))){
var inst_16593 = (state_16606[(9)]);
var inst_16596 = cljs.core.deref(inst_16593);
var state_16606__$1 = state_16606;
var statearr_16621_16635 = state_16606__$1;
(statearr_16621_16635[(2)] = inst_16596);

(statearr_16621_16635[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto__))
;
return ((function (switch__16015__auto__,c__16117__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16016__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16016__auto____0 = (function (){
var statearr_16622 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16622[(0)] = cljs$core$async$reduce_$_state_machine__16016__auto__);

(statearr_16622[(1)] = (1));

return statearr_16622;
});
var cljs$core$async$reduce_$_state_machine__16016__auto____1 = (function (state_16606){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16606);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16623){if((e16623 instanceof Object)){
var ex__16019__auto__ = e16623;
var statearr_16624_16636 = state_16606;
(statearr_16624_16636[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16606);

return cljs.core.cst$kw$recur;
} else {
throw e16623;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16637 = state_16606;
state_16606 = G__16637;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16016__auto__ = function(state_16606){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16016__auto____1.call(this,state_16606);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16016__auto____0;
cljs$core$async$reduce_$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16016__auto____1;
return cljs$core$async$reduce_$_state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto__))
})();
var state__16119__auto__ = (function (){var statearr_16625 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16625[(6)] = c__16117__auto__);

return statearr_16625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto__))
);

return c__16117__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__16117__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto__,f__$1){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto__,f__$1){
return (function (state_16643){
var state_val_16644 = (state_16643[(1)]);
if((state_val_16644 === (1))){
var inst_16638 = cljs.core.async.reduce(f__$1,init,ch);
var state_16643__$1 = state_16643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16643__$1,(2),inst_16638);
} else {
if((state_val_16644 === (2))){
var inst_16640 = (state_16643[(2)]);
var inst_16641 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_16640) : f__$1.call(null,inst_16640));
var state_16643__$1 = state_16643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16643__$1,inst_16641);
} else {
return null;
}
}
});})(c__16117__auto__,f__$1))
;
return ((function (switch__16015__auto__,c__16117__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16016__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16016__auto____0 = (function (){
var statearr_16645 = [null,null,null,null,null,null,null];
(statearr_16645[(0)] = cljs$core$async$transduce_$_state_machine__16016__auto__);

(statearr_16645[(1)] = (1));

return statearr_16645;
});
var cljs$core$async$transduce_$_state_machine__16016__auto____1 = (function (state_16643){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16643);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16646){if((e16646 instanceof Object)){
var ex__16019__auto__ = e16646;
var statearr_16647_16649 = state_16643;
(statearr_16647_16649[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16643);

return cljs.core.cst$kw$recur;
} else {
throw e16646;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16650 = state_16643;
state_16643 = G__16650;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16016__auto__ = function(state_16643){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16016__auto____1.call(this,state_16643);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16016__auto____0;
cljs$core$async$transduce_$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16016__auto____1;
return cljs$core$async$transduce_$_state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto__,f__$1))
})();
var state__16119__auto__ = (function (){var statearr_16648 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16648[(6)] = c__16117__auto__);

return statearr_16648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto__,f__$1))
);

return c__16117__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__16652 = arguments.length;
switch (G__16652) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16117__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto__){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto__){
return (function (state_16677){
var state_val_16678 = (state_16677[(1)]);
if((state_val_16678 === (7))){
var inst_16659 = (state_16677[(2)]);
var state_16677__$1 = state_16677;
var statearr_16679_16700 = state_16677__$1;
(statearr_16679_16700[(2)] = inst_16659);

(statearr_16679_16700[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (1))){
var inst_16653 = cljs.core.seq(coll);
var inst_16654 = inst_16653;
var state_16677__$1 = (function (){var statearr_16680 = state_16677;
(statearr_16680[(7)] = inst_16654);

return statearr_16680;
})();
var statearr_16681_16701 = state_16677__$1;
(statearr_16681_16701[(2)] = null);

(statearr_16681_16701[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (4))){
var inst_16654 = (state_16677[(7)]);
var inst_16657 = cljs.core.first(inst_16654);
var state_16677__$1 = state_16677;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16677__$1,(7),ch,inst_16657);
} else {
if((state_val_16678 === (13))){
var inst_16671 = (state_16677[(2)]);
var state_16677__$1 = state_16677;
var statearr_16682_16702 = state_16677__$1;
(statearr_16682_16702[(2)] = inst_16671);

(statearr_16682_16702[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (6))){
var inst_16662 = (state_16677[(2)]);
var state_16677__$1 = state_16677;
if(cljs.core.truth_(inst_16662)){
var statearr_16683_16703 = state_16677__$1;
(statearr_16683_16703[(1)] = (8));

} else {
var statearr_16684_16704 = state_16677__$1;
(statearr_16684_16704[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (3))){
var inst_16675 = (state_16677[(2)]);
var state_16677__$1 = state_16677;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16677__$1,inst_16675);
} else {
if((state_val_16678 === (12))){
var state_16677__$1 = state_16677;
var statearr_16685_16705 = state_16677__$1;
(statearr_16685_16705[(2)] = null);

(statearr_16685_16705[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (2))){
var inst_16654 = (state_16677[(7)]);
var state_16677__$1 = state_16677;
if(cljs.core.truth_(inst_16654)){
var statearr_16686_16706 = state_16677__$1;
(statearr_16686_16706[(1)] = (4));

} else {
var statearr_16687_16707 = state_16677__$1;
(statearr_16687_16707[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (11))){
var inst_16668 = cljs.core.async.close_BANG_(ch);
var state_16677__$1 = state_16677;
var statearr_16688_16708 = state_16677__$1;
(statearr_16688_16708[(2)] = inst_16668);

(statearr_16688_16708[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (9))){
var state_16677__$1 = state_16677;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16689_16709 = state_16677__$1;
(statearr_16689_16709[(1)] = (11));

} else {
var statearr_16690_16710 = state_16677__$1;
(statearr_16690_16710[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (5))){
var inst_16654 = (state_16677[(7)]);
var state_16677__$1 = state_16677;
var statearr_16691_16711 = state_16677__$1;
(statearr_16691_16711[(2)] = inst_16654);

(statearr_16691_16711[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (10))){
var inst_16673 = (state_16677[(2)]);
var state_16677__$1 = state_16677;
var statearr_16692_16712 = state_16677__$1;
(statearr_16692_16712[(2)] = inst_16673);

(statearr_16692_16712[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (8))){
var inst_16654 = (state_16677[(7)]);
var inst_16664 = cljs.core.next(inst_16654);
var inst_16654__$1 = inst_16664;
var state_16677__$1 = (function (){var statearr_16693 = state_16677;
(statearr_16693[(7)] = inst_16654__$1);

return statearr_16693;
})();
var statearr_16694_16713 = state_16677__$1;
(statearr_16694_16713[(2)] = null);

(statearr_16694_16713[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto__))
;
return ((function (switch__16015__auto__,c__16117__auto__){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_16695 = [null,null,null,null,null,null,null,null];
(statearr_16695[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_16695[(1)] = (1));

return statearr_16695;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_16677){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16677);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16696){if((e16696 instanceof Object)){
var ex__16019__auto__ = e16696;
var statearr_16697_16714 = state_16677;
(statearr_16697_16714[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16677);

return cljs.core.cst$kw$recur;
} else {
throw e16696;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16715 = state_16677;
state_16677 = G__16715;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_16677){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_16677);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto__))
})();
var state__16119__auto__ = (function (){var statearr_16698 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16698[(6)] = c__16117__auto__);

return statearr_16698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto__))
);

return c__16117__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9539__auto__ = (((_ == null))?null:_);
var m__9540__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__9540__auto__.call(null,_));
} else {
var m__9540__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__9540__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9540__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__9540__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__9540__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto__.call(null,m));
} else {
var m__9540__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16716 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16716 = (function (ch,cs,meta16717){
this.ch = ch;
this.cs = cs;
this.meta16717 = meta16717;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16716.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_16718,meta16717__$1){
var self__ = this;
var _16718__$1 = this;
return (new cljs.core.async.t_cljs$core$async16716(self__.ch,self__.cs,meta16717__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async16716.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_16718){
var self__ = this;
var _16718__$1 = this;
return self__.meta16717;
});})(cs))
;

cljs.core.async.t_cljs$core$async16716.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16716.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async16716.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16716.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16716.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16716.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16716.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta16717], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async16716.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16716.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16716";

cljs.core.async.t_cljs$core$async16716.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async16716");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async16716 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async16716(ch__$1,cs__$1,meta16717){
return (new cljs.core.async.t_cljs$core$async16716(ch__$1,cs__$1,meta16717));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async16716(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__16117__auto___16938 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___16938,cs,m,dchan,dctr,done){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___16938,cs,m,dchan,dctr,done){
return (function (state_16853){
var state_val_16854 = (state_16853[(1)]);
if((state_val_16854 === (7))){
var inst_16849 = (state_16853[(2)]);
var state_16853__$1 = state_16853;
var statearr_16855_16939 = state_16853__$1;
(statearr_16855_16939[(2)] = inst_16849);

(statearr_16855_16939[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (20))){
var inst_16752 = (state_16853[(7)]);
var inst_16764 = cljs.core.first(inst_16752);
var inst_16765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16764,(0),null);
var inst_16766 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16764,(1),null);
var state_16853__$1 = (function (){var statearr_16856 = state_16853;
(statearr_16856[(8)] = inst_16765);

return statearr_16856;
})();
if(cljs.core.truth_(inst_16766)){
var statearr_16857_16940 = state_16853__$1;
(statearr_16857_16940[(1)] = (22));

} else {
var statearr_16858_16941 = state_16853__$1;
(statearr_16858_16941[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (27))){
var inst_16721 = (state_16853[(9)]);
var inst_16796 = (state_16853[(10)]);
var inst_16794 = (state_16853[(11)]);
var inst_16801 = (state_16853[(12)]);
var inst_16801__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16794,inst_16796);
var inst_16802 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_16801__$1,inst_16721,done);
var state_16853__$1 = (function (){var statearr_16859 = state_16853;
(statearr_16859[(12)] = inst_16801__$1);

return statearr_16859;
})();
if(cljs.core.truth_(inst_16802)){
var statearr_16860_16942 = state_16853__$1;
(statearr_16860_16942[(1)] = (30));

} else {
var statearr_16861_16943 = state_16853__$1;
(statearr_16861_16943[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (1))){
var state_16853__$1 = state_16853;
var statearr_16862_16944 = state_16853__$1;
(statearr_16862_16944[(2)] = null);

(statearr_16862_16944[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (24))){
var inst_16752 = (state_16853[(7)]);
var inst_16771 = (state_16853[(2)]);
var inst_16772 = cljs.core.next(inst_16752);
var inst_16730 = inst_16772;
var inst_16731 = null;
var inst_16732 = (0);
var inst_16733 = (0);
var state_16853__$1 = (function (){var statearr_16863 = state_16853;
(statearr_16863[(13)] = inst_16733);

(statearr_16863[(14)] = inst_16771);

(statearr_16863[(15)] = inst_16731);

(statearr_16863[(16)] = inst_16730);

(statearr_16863[(17)] = inst_16732);

return statearr_16863;
})();
var statearr_16864_16945 = state_16853__$1;
(statearr_16864_16945[(2)] = null);

(statearr_16864_16945[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (39))){
var state_16853__$1 = state_16853;
var statearr_16868_16946 = state_16853__$1;
(statearr_16868_16946[(2)] = null);

(statearr_16868_16946[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (4))){
var inst_16721 = (state_16853[(9)]);
var inst_16721__$1 = (state_16853[(2)]);
var inst_16722 = (inst_16721__$1 == null);
var state_16853__$1 = (function (){var statearr_16869 = state_16853;
(statearr_16869[(9)] = inst_16721__$1);

return statearr_16869;
})();
if(cljs.core.truth_(inst_16722)){
var statearr_16870_16947 = state_16853__$1;
(statearr_16870_16947[(1)] = (5));

} else {
var statearr_16871_16948 = state_16853__$1;
(statearr_16871_16948[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (15))){
var inst_16733 = (state_16853[(13)]);
var inst_16731 = (state_16853[(15)]);
var inst_16730 = (state_16853[(16)]);
var inst_16732 = (state_16853[(17)]);
var inst_16748 = (state_16853[(2)]);
var inst_16749 = (inst_16733 + (1));
var tmp16865 = inst_16731;
var tmp16866 = inst_16730;
var tmp16867 = inst_16732;
var inst_16730__$1 = tmp16866;
var inst_16731__$1 = tmp16865;
var inst_16732__$1 = tmp16867;
var inst_16733__$1 = inst_16749;
var state_16853__$1 = (function (){var statearr_16872 = state_16853;
(statearr_16872[(13)] = inst_16733__$1);

(statearr_16872[(15)] = inst_16731__$1);

(statearr_16872[(18)] = inst_16748);

(statearr_16872[(16)] = inst_16730__$1);

(statearr_16872[(17)] = inst_16732__$1);

return statearr_16872;
})();
var statearr_16873_16949 = state_16853__$1;
(statearr_16873_16949[(2)] = null);

(statearr_16873_16949[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (21))){
var inst_16775 = (state_16853[(2)]);
var state_16853__$1 = state_16853;
var statearr_16877_16950 = state_16853__$1;
(statearr_16877_16950[(2)] = inst_16775);

(statearr_16877_16950[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (31))){
var inst_16801 = (state_16853[(12)]);
var inst_16805 = done(null);
var inst_16806 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_16801);
var state_16853__$1 = (function (){var statearr_16878 = state_16853;
(statearr_16878[(19)] = inst_16805);

return statearr_16878;
})();
var statearr_16879_16951 = state_16853__$1;
(statearr_16879_16951[(2)] = inst_16806);

(statearr_16879_16951[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (32))){
var inst_16793 = (state_16853[(20)]);
var inst_16795 = (state_16853[(21)]);
var inst_16796 = (state_16853[(10)]);
var inst_16794 = (state_16853[(11)]);
var inst_16808 = (state_16853[(2)]);
var inst_16809 = (inst_16796 + (1));
var tmp16874 = inst_16793;
var tmp16875 = inst_16795;
var tmp16876 = inst_16794;
var inst_16793__$1 = tmp16874;
var inst_16794__$1 = tmp16876;
var inst_16795__$1 = tmp16875;
var inst_16796__$1 = inst_16809;
var state_16853__$1 = (function (){var statearr_16880 = state_16853;
(statearr_16880[(20)] = inst_16793__$1);

(statearr_16880[(21)] = inst_16795__$1);

(statearr_16880[(10)] = inst_16796__$1);

(statearr_16880[(11)] = inst_16794__$1);

(statearr_16880[(22)] = inst_16808);

return statearr_16880;
})();
var statearr_16881_16952 = state_16853__$1;
(statearr_16881_16952[(2)] = null);

(statearr_16881_16952[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (40))){
var inst_16821 = (state_16853[(23)]);
var inst_16825 = done(null);
var inst_16826 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_16821);
var state_16853__$1 = (function (){var statearr_16882 = state_16853;
(statearr_16882[(24)] = inst_16825);

return statearr_16882;
})();
var statearr_16883_16953 = state_16853__$1;
(statearr_16883_16953[(2)] = inst_16826);

(statearr_16883_16953[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (33))){
var inst_16812 = (state_16853[(25)]);
var inst_16814 = cljs.core.chunked_seq_QMARK_(inst_16812);
var state_16853__$1 = state_16853;
if(inst_16814){
var statearr_16884_16954 = state_16853__$1;
(statearr_16884_16954[(1)] = (36));

} else {
var statearr_16885_16955 = state_16853__$1;
(statearr_16885_16955[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (13))){
var inst_16742 = (state_16853[(26)]);
var inst_16745 = cljs.core.async.close_BANG_(inst_16742);
var state_16853__$1 = state_16853;
var statearr_16886_16956 = state_16853__$1;
(statearr_16886_16956[(2)] = inst_16745);

(statearr_16886_16956[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (22))){
var inst_16765 = (state_16853[(8)]);
var inst_16768 = cljs.core.async.close_BANG_(inst_16765);
var state_16853__$1 = state_16853;
var statearr_16887_16957 = state_16853__$1;
(statearr_16887_16957[(2)] = inst_16768);

(statearr_16887_16957[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (36))){
var inst_16812 = (state_16853[(25)]);
var inst_16816 = cljs.core.chunk_first(inst_16812);
var inst_16817 = cljs.core.chunk_rest(inst_16812);
var inst_16818 = cljs.core.count(inst_16816);
var inst_16793 = inst_16817;
var inst_16794 = inst_16816;
var inst_16795 = inst_16818;
var inst_16796 = (0);
var state_16853__$1 = (function (){var statearr_16888 = state_16853;
(statearr_16888[(20)] = inst_16793);

(statearr_16888[(21)] = inst_16795);

(statearr_16888[(10)] = inst_16796);

(statearr_16888[(11)] = inst_16794);

return statearr_16888;
})();
var statearr_16889_16958 = state_16853__$1;
(statearr_16889_16958[(2)] = null);

(statearr_16889_16958[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (41))){
var inst_16812 = (state_16853[(25)]);
var inst_16828 = (state_16853[(2)]);
var inst_16829 = cljs.core.next(inst_16812);
var inst_16793 = inst_16829;
var inst_16794 = null;
var inst_16795 = (0);
var inst_16796 = (0);
var state_16853__$1 = (function (){var statearr_16890 = state_16853;
(statearr_16890[(20)] = inst_16793);

(statearr_16890[(27)] = inst_16828);

(statearr_16890[(21)] = inst_16795);

(statearr_16890[(10)] = inst_16796);

(statearr_16890[(11)] = inst_16794);

return statearr_16890;
})();
var statearr_16891_16959 = state_16853__$1;
(statearr_16891_16959[(2)] = null);

(statearr_16891_16959[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (43))){
var state_16853__$1 = state_16853;
var statearr_16892_16960 = state_16853__$1;
(statearr_16892_16960[(2)] = null);

(statearr_16892_16960[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (29))){
var inst_16837 = (state_16853[(2)]);
var state_16853__$1 = state_16853;
var statearr_16893_16961 = state_16853__$1;
(statearr_16893_16961[(2)] = inst_16837);

(statearr_16893_16961[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (44))){
var inst_16846 = (state_16853[(2)]);
var state_16853__$1 = (function (){var statearr_16894 = state_16853;
(statearr_16894[(28)] = inst_16846);

return statearr_16894;
})();
var statearr_16895_16962 = state_16853__$1;
(statearr_16895_16962[(2)] = null);

(statearr_16895_16962[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (6))){
var inst_16785 = (state_16853[(29)]);
var inst_16784 = cljs.core.deref(cs);
var inst_16785__$1 = cljs.core.keys(inst_16784);
var inst_16786 = cljs.core.count(inst_16785__$1);
var inst_16787 = cljs.core.reset_BANG_(dctr,inst_16786);
var inst_16792 = cljs.core.seq(inst_16785__$1);
var inst_16793 = inst_16792;
var inst_16794 = null;
var inst_16795 = (0);
var inst_16796 = (0);
var state_16853__$1 = (function (){var statearr_16896 = state_16853;
(statearr_16896[(20)] = inst_16793);

(statearr_16896[(21)] = inst_16795);

(statearr_16896[(10)] = inst_16796);

(statearr_16896[(11)] = inst_16794);

(statearr_16896[(30)] = inst_16787);

(statearr_16896[(29)] = inst_16785__$1);

return statearr_16896;
})();
var statearr_16897_16963 = state_16853__$1;
(statearr_16897_16963[(2)] = null);

(statearr_16897_16963[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (28))){
var inst_16793 = (state_16853[(20)]);
var inst_16812 = (state_16853[(25)]);
var inst_16812__$1 = cljs.core.seq(inst_16793);
var state_16853__$1 = (function (){var statearr_16898 = state_16853;
(statearr_16898[(25)] = inst_16812__$1);

return statearr_16898;
})();
if(inst_16812__$1){
var statearr_16899_16964 = state_16853__$1;
(statearr_16899_16964[(1)] = (33));

} else {
var statearr_16900_16965 = state_16853__$1;
(statearr_16900_16965[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (25))){
var inst_16795 = (state_16853[(21)]);
var inst_16796 = (state_16853[(10)]);
var inst_16798 = (inst_16796 < inst_16795);
var inst_16799 = inst_16798;
var state_16853__$1 = state_16853;
if(cljs.core.truth_(inst_16799)){
var statearr_16901_16966 = state_16853__$1;
(statearr_16901_16966[(1)] = (27));

} else {
var statearr_16902_16967 = state_16853__$1;
(statearr_16902_16967[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (34))){
var state_16853__$1 = state_16853;
var statearr_16903_16968 = state_16853__$1;
(statearr_16903_16968[(2)] = null);

(statearr_16903_16968[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (17))){
var state_16853__$1 = state_16853;
var statearr_16904_16969 = state_16853__$1;
(statearr_16904_16969[(2)] = null);

(statearr_16904_16969[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (3))){
var inst_16851 = (state_16853[(2)]);
var state_16853__$1 = state_16853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16853__$1,inst_16851);
} else {
if((state_val_16854 === (12))){
var inst_16780 = (state_16853[(2)]);
var state_16853__$1 = state_16853;
var statearr_16905_16970 = state_16853__$1;
(statearr_16905_16970[(2)] = inst_16780);

(statearr_16905_16970[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (2))){
var state_16853__$1 = state_16853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16853__$1,(4),ch);
} else {
if((state_val_16854 === (23))){
var state_16853__$1 = state_16853;
var statearr_16906_16971 = state_16853__$1;
(statearr_16906_16971[(2)] = null);

(statearr_16906_16971[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (35))){
var inst_16835 = (state_16853[(2)]);
var state_16853__$1 = state_16853;
var statearr_16907_16972 = state_16853__$1;
(statearr_16907_16972[(2)] = inst_16835);

(statearr_16907_16972[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (19))){
var inst_16752 = (state_16853[(7)]);
var inst_16756 = cljs.core.chunk_first(inst_16752);
var inst_16757 = cljs.core.chunk_rest(inst_16752);
var inst_16758 = cljs.core.count(inst_16756);
var inst_16730 = inst_16757;
var inst_16731 = inst_16756;
var inst_16732 = inst_16758;
var inst_16733 = (0);
var state_16853__$1 = (function (){var statearr_16908 = state_16853;
(statearr_16908[(13)] = inst_16733);

(statearr_16908[(15)] = inst_16731);

(statearr_16908[(16)] = inst_16730);

(statearr_16908[(17)] = inst_16732);

return statearr_16908;
})();
var statearr_16909_16973 = state_16853__$1;
(statearr_16909_16973[(2)] = null);

(statearr_16909_16973[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (11))){
var inst_16752 = (state_16853[(7)]);
var inst_16730 = (state_16853[(16)]);
var inst_16752__$1 = cljs.core.seq(inst_16730);
var state_16853__$1 = (function (){var statearr_16910 = state_16853;
(statearr_16910[(7)] = inst_16752__$1);

return statearr_16910;
})();
if(inst_16752__$1){
var statearr_16911_16974 = state_16853__$1;
(statearr_16911_16974[(1)] = (16));

} else {
var statearr_16912_16975 = state_16853__$1;
(statearr_16912_16975[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (9))){
var inst_16782 = (state_16853[(2)]);
var state_16853__$1 = state_16853;
var statearr_16913_16976 = state_16853__$1;
(statearr_16913_16976[(2)] = inst_16782);

(statearr_16913_16976[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (5))){
var inst_16728 = cljs.core.deref(cs);
var inst_16729 = cljs.core.seq(inst_16728);
var inst_16730 = inst_16729;
var inst_16731 = null;
var inst_16732 = (0);
var inst_16733 = (0);
var state_16853__$1 = (function (){var statearr_16914 = state_16853;
(statearr_16914[(13)] = inst_16733);

(statearr_16914[(15)] = inst_16731);

(statearr_16914[(16)] = inst_16730);

(statearr_16914[(17)] = inst_16732);

return statearr_16914;
})();
var statearr_16915_16977 = state_16853__$1;
(statearr_16915_16977[(2)] = null);

(statearr_16915_16977[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (14))){
var state_16853__$1 = state_16853;
var statearr_16916_16978 = state_16853__$1;
(statearr_16916_16978[(2)] = null);

(statearr_16916_16978[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (45))){
var inst_16843 = (state_16853[(2)]);
var state_16853__$1 = state_16853;
var statearr_16917_16979 = state_16853__$1;
(statearr_16917_16979[(2)] = inst_16843);

(statearr_16917_16979[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (26))){
var inst_16785 = (state_16853[(29)]);
var inst_16839 = (state_16853[(2)]);
var inst_16840 = cljs.core.seq(inst_16785);
var state_16853__$1 = (function (){var statearr_16918 = state_16853;
(statearr_16918[(31)] = inst_16839);

return statearr_16918;
})();
if(inst_16840){
var statearr_16919_16980 = state_16853__$1;
(statearr_16919_16980[(1)] = (42));

} else {
var statearr_16920_16981 = state_16853__$1;
(statearr_16920_16981[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (16))){
var inst_16752 = (state_16853[(7)]);
var inst_16754 = cljs.core.chunked_seq_QMARK_(inst_16752);
var state_16853__$1 = state_16853;
if(inst_16754){
var statearr_16921_16982 = state_16853__$1;
(statearr_16921_16982[(1)] = (19));

} else {
var statearr_16922_16983 = state_16853__$1;
(statearr_16922_16983[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (38))){
var inst_16832 = (state_16853[(2)]);
var state_16853__$1 = state_16853;
var statearr_16923_16984 = state_16853__$1;
(statearr_16923_16984[(2)] = inst_16832);

(statearr_16923_16984[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (30))){
var state_16853__$1 = state_16853;
var statearr_16924_16985 = state_16853__$1;
(statearr_16924_16985[(2)] = null);

(statearr_16924_16985[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (10))){
var inst_16733 = (state_16853[(13)]);
var inst_16731 = (state_16853[(15)]);
var inst_16741 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16731,inst_16733);
var inst_16742 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16741,(0),null);
var inst_16743 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16741,(1),null);
var state_16853__$1 = (function (){var statearr_16925 = state_16853;
(statearr_16925[(26)] = inst_16742);

return statearr_16925;
})();
if(cljs.core.truth_(inst_16743)){
var statearr_16926_16986 = state_16853__$1;
(statearr_16926_16986[(1)] = (13));

} else {
var statearr_16927_16987 = state_16853__$1;
(statearr_16927_16987[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (18))){
var inst_16778 = (state_16853[(2)]);
var state_16853__$1 = state_16853;
var statearr_16928_16988 = state_16853__$1;
(statearr_16928_16988[(2)] = inst_16778);

(statearr_16928_16988[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (42))){
var state_16853__$1 = state_16853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16853__$1,(45),dchan);
} else {
if((state_val_16854 === (37))){
var inst_16721 = (state_16853[(9)]);
var inst_16821 = (state_16853[(23)]);
var inst_16812 = (state_16853[(25)]);
var inst_16821__$1 = cljs.core.first(inst_16812);
var inst_16822 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_16821__$1,inst_16721,done);
var state_16853__$1 = (function (){var statearr_16929 = state_16853;
(statearr_16929[(23)] = inst_16821__$1);

return statearr_16929;
})();
if(cljs.core.truth_(inst_16822)){
var statearr_16930_16989 = state_16853__$1;
(statearr_16930_16989[(1)] = (39));

} else {
var statearr_16931_16990 = state_16853__$1;
(statearr_16931_16990[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16854 === (8))){
var inst_16733 = (state_16853[(13)]);
var inst_16732 = (state_16853[(17)]);
var inst_16735 = (inst_16733 < inst_16732);
var inst_16736 = inst_16735;
var state_16853__$1 = state_16853;
if(cljs.core.truth_(inst_16736)){
var statearr_16932_16991 = state_16853__$1;
(statearr_16932_16991[(1)] = (10));

} else {
var statearr_16933_16992 = state_16853__$1;
(statearr_16933_16992[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___16938,cs,m,dchan,dctr,done))
;
return ((function (switch__16015__auto__,c__16117__auto___16938,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16016__auto__ = null;
var cljs$core$async$mult_$_state_machine__16016__auto____0 = (function (){
var statearr_16934 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16934[(0)] = cljs$core$async$mult_$_state_machine__16016__auto__);

(statearr_16934[(1)] = (1));

return statearr_16934;
});
var cljs$core$async$mult_$_state_machine__16016__auto____1 = (function (state_16853){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_16853);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e16935){if((e16935 instanceof Object)){
var ex__16019__auto__ = e16935;
var statearr_16936_16993 = state_16853;
(statearr_16936_16993[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16853);

return cljs.core.cst$kw$recur;
} else {
throw e16935;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__16994 = state_16853;
state_16853 = G__16994;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16016__auto__ = function(state_16853){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16016__auto____1.call(this,state_16853);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16016__auto____0;
cljs$core$async$mult_$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16016__auto____1;
return cljs$core$async$mult_$_state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___16938,cs,m,dchan,dctr,done))
})();
var state__16119__auto__ = (function (){var statearr_16937 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_16937[(6)] = c__16117__auto___16938);

return statearr_16937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___16938,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__16996 = arguments.length;
switch (G__16996) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto__.call(null,m,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__9540__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto__.call(null,m));
} else {
var m__9540__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__9540__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9540__auto__.call(null,m,state_map));
} else {
var m__9540__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__9540__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__9539__auto__ = (((m == null))?null:m);
var m__9540__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9540__auto__.call(null,m,mode));
} else {
var m__9540__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__9540__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10092__auto__ = [];
var len__10085__auto___17008 = arguments.length;
var i__10086__auto___17009 = (0);
while(true){
if((i__10086__auto___17009 < len__10085__auto___17008)){
args__10092__auto__.push((arguments[i__10086__auto___17009]));

var G__17010 = (i__10086__auto___17009 + (1));
i__10086__auto___17009 = G__17010;
continue;
} else {
}
break;
}

var argseq__10093__auto__ = ((((3) < args__10092__auto__.length))?(new cljs.core.IndexedSeq(args__10092__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10093__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17002){
var map__17003 = p__17002;
var map__17003__$1 = ((((!((map__17003 == null)))?((((map__17003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17003.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17003):map__17003);
var opts = map__17003__$1;
var statearr_17005_17011 = state;
(statearr_17005_17011[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__17003,map__17003__$1,opts){
return (function (val){
var statearr_17006_17012 = state;
(statearr_17006_17012[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__17003,map__17003__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_17007_17013 = state;
(statearr_17007_17013[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq16998){
var G__16999 = cljs.core.first(seq16998);
var seq16998__$1 = cljs.core.next(seq16998);
var G__17000 = cljs.core.first(seq16998__$1);
var seq16998__$2 = cljs.core.next(seq16998__$1);
var G__17001 = cljs.core.first(seq16998__$2);
var seq16998__$3 = cljs.core.next(seq16998__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16999,G__17000,G__17001,seq16998__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17014 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17014 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta17015){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta17015 = meta17015;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17014.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17016,meta17015__$1){
var self__ = this;
var _17016__$1 = this;
return (new cljs.core.async.t_cljs$core$async17014(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta17015__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17014.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_17016){
var self__ = this;
var _17016__$1 = this;
return self__.meta17015;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17014.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17014.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17014.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17014.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17014.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17014.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17014.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17014.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17014.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta17015], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async17014.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17014.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17014";

cljs.core.async.t_cljs$core$async17014.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17014");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async17014 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async17014(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17015){
return (new cljs.core.async.t_cljs$core$async17014(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta17015));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async17014(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16117__auto___17178 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___17178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___17178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_17118){
var state_val_17119 = (state_17118[(1)]);
if((state_val_17119 === (7))){
var inst_17033 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
var statearr_17120_17179 = state_17118__$1;
(statearr_17120_17179[(2)] = inst_17033);

(statearr_17120_17179[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (20))){
var inst_17045 = (state_17118[(7)]);
var state_17118__$1 = state_17118;
var statearr_17121_17180 = state_17118__$1;
(statearr_17121_17180[(2)] = inst_17045);

(statearr_17121_17180[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (27))){
var state_17118__$1 = state_17118;
var statearr_17122_17181 = state_17118__$1;
(statearr_17122_17181[(2)] = null);

(statearr_17122_17181[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (1))){
var inst_17020 = (state_17118[(8)]);
var inst_17020__$1 = calc_state();
var inst_17022 = (inst_17020__$1 == null);
var inst_17023 = cljs.core.not(inst_17022);
var state_17118__$1 = (function (){var statearr_17123 = state_17118;
(statearr_17123[(8)] = inst_17020__$1);

return statearr_17123;
})();
if(inst_17023){
var statearr_17124_17182 = state_17118__$1;
(statearr_17124_17182[(1)] = (2));

} else {
var statearr_17125_17183 = state_17118__$1;
(statearr_17125_17183[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (24))){
var inst_17069 = (state_17118[(9)]);
var inst_17078 = (state_17118[(10)]);
var inst_17092 = (state_17118[(11)]);
var inst_17092__$1 = (inst_17069.cljs$core$IFn$_invoke$arity$1 ? inst_17069.cljs$core$IFn$_invoke$arity$1(inst_17078) : inst_17069.call(null,inst_17078));
var state_17118__$1 = (function (){var statearr_17126 = state_17118;
(statearr_17126[(11)] = inst_17092__$1);

return statearr_17126;
})();
if(cljs.core.truth_(inst_17092__$1)){
var statearr_17127_17184 = state_17118__$1;
(statearr_17127_17184[(1)] = (29));

} else {
var statearr_17128_17185 = state_17118__$1;
(statearr_17128_17185[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (4))){
var inst_17036 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
if(cljs.core.truth_(inst_17036)){
var statearr_17129_17186 = state_17118__$1;
(statearr_17129_17186[(1)] = (8));

} else {
var statearr_17130_17187 = state_17118__$1;
(statearr_17130_17187[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (15))){
var inst_17063 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
if(cljs.core.truth_(inst_17063)){
var statearr_17131_17188 = state_17118__$1;
(statearr_17131_17188[(1)] = (19));

} else {
var statearr_17132_17189 = state_17118__$1;
(statearr_17132_17189[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (21))){
var inst_17068 = (state_17118[(12)]);
var inst_17068__$1 = (state_17118[(2)]);
var inst_17069 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17068__$1,cljs.core.cst$kw$solos);
var inst_17070 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17068__$1,cljs.core.cst$kw$mutes);
var inst_17071 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17068__$1,cljs.core.cst$kw$reads);
var state_17118__$1 = (function (){var statearr_17133 = state_17118;
(statearr_17133[(12)] = inst_17068__$1);

(statearr_17133[(9)] = inst_17069);

(statearr_17133[(13)] = inst_17070);

return statearr_17133;
})();
return cljs.core.async.ioc_alts_BANG_(state_17118__$1,(22),inst_17071);
} else {
if((state_val_17119 === (31))){
var inst_17100 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
if(cljs.core.truth_(inst_17100)){
var statearr_17134_17190 = state_17118__$1;
(statearr_17134_17190[(1)] = (32));

} else {
var statearr_17135_17191 = state_17118__$1;
(statearr_17135_17191[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (32))){
var inst_17077 = (state_17118[(14)]);
var state_17118__$1 = state_17118;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17118__$1,(35),out,inst_17077);
} else {
if((state_val_17119 === (33))){
var inst_17068 = (state_17118[(12)]);
var inst_17045 = inst_17068;
var state_17118__$1 = (function (){var statearr_17136 = state_17118;
(statearr_17136[(7)] = inst_17045);

return statearr_17136;
})();
var statearr_17137_17192 = state_17118__$1;
(statearr_17137_17192[(2)] = null);

(statearr_17137_17192[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (13))){
var inst_17045 = (state_17118[(7)]);
var inst_17052 = inst_17045.cljs$lang$protocol_mask$partition0$;
var inst_17053 = (inst_17052 & (64));
var inst_17054 = inst_17045.cljs$core$ISeq$;
var inst_17055 = (cljs.core.PROTOCOL_SENTINEL === inst_17054);
var inst_17056 = (inst_17053) || (inst_17055);
var state_17118__$1 = state_17118;
if(cljs.core.truth_(inst_17056)){
var statearr_17138_17193 = state_17118__$1;
(statearr_17138_17193[(1)] = (16));

} else {
var statearr_17139_17194 = state_17118__$1;
(statearr_17139_17194[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (22))){
var inst_17077 = (state_17118[(14)]);
var inst_17078 = (state_17118[(10)]);
var inst_17076 = (state_17118[(2)]);
var inst_17077__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17076,(0),null);
var inst_17078__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17076,(1),null);
var inst_17079 = (inst_17077__$1 == null);
var inst_17080 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17078__$1,change);
var inst_17081 = (inst_17079) || (inst_17080);
var state_17118__$1 = (function (){var statearr_17140 = state_17118;
(statearr_17140[(14)] = inst_17077__$1);

(statearr_17140[(10)] = inst_17078__$1);

return statearr_17140;
})();
if(cljs.core.truth_(inst_17081)){
var statearr_17141_17195 = state_17118__$1;
(statearr_17141_17195[(1)] = (23));

} else {
var statearr_17142_17196 = state_17118__$1;
(statearr_17142_17196[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (36))){
var inst_17068 = (state_17118[(12)]);
var inst_17045 = inst_17068;
var state_17118__$1 = (function (){var statearr_17143 = state_17118;
(statearr_17143[(7)] = inst_17045);

return statearr_17143;
})();
var statearr_17144_17197 = state_17118__$1;
(statearr_17144_17197[(2)] = null);

(statearr_17144_17197[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (29))){
var inst_17092 = (state_17118[(11)]);
var state_17118__$1 = state_17118;
var statearr_17145_17198 = state_17118__$1;
(statearr_17145_17198[(2)] = inst_17092);

(statearr_17145_17198[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (6))){
var state_17118__$1 = state_17118;
var statearr_17146_17199 = state_17118__$1;
(statearr_17146_17199[(2)] = false);

(statearr_17146_17199[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (28))){
var inst_17088 = (state_17118[(2)]);
var inst_17089 = calc_state();
var inst_17045 = inst_17089;
var state_17118__$1 = (function (){var statearr_17147 = state_17118;
(statearr_17147[(15)] = inst_17088);

(statearr_17147[(7)] = inst_17045);

return statearr_17147;
})();
var statearr_17148_17200 = state_17118__$1;
(statearr_17148_17200[(2)] = null);

(statearr_17148_17200[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (25))){
var inst_17114 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
var statearr_17149_17201 = state_17118__$1;
(statearr_17149_17201[(2)] = inst_17114);

(statearr_17149_17201[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (34))){
var inst_17112 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
var statearr_17150_17202 = state_17118__$1;
(statearr_17150_17202[(2)] = inst_17112);

(statearr_17150_17202[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (17))){
var state_17118__$1 = state_17118;
var statearr_17151_17203 = state_17118__$1;
(statearr_17151_17203[(2)] = false);

(statearr_17151_17203[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (3))){
var state_17118__$1 = state_17118;
var statearr_17152_17204 = state_17118__$1;
(statearr_17152_17204[(2)] = false);

(statearr_17152_17204[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (12))){
var inst_17116 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17118__$1,inst_17116);
} else {
if((state_val_17119 === (2))){
var inst_17020 = (state_17118[(8)]);
var inst_17025 = inst_17020.cljs$lang$protocol_mask$partition0$;
var inst_17026 = (inst_17025 & (64));
var inst_17027 = inst_17020.cljs$core$ISeq$;
var inst_17028 = (cljs.core.PROTOCOL_SENTINEL === inst_17027);
var inst_17029 = (inst_17026) || (inst_17028);
var state_17118__$1 = state_17118;
if(cljs.core.truth_(inst_17029)){
var statearr_17153_17205 = state_17118__$1;
(statearr_17153_17205[(1)] = (5));

} else {
var statearr_17154_17206 = state_17118__$1;
(statearr_17154_17206[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (23))){
var inst_17077 = (state_17118[(14)]);
var inst_17083 = (inst_17077 == null);
var state_17118__$1 = state_17118;
if(cljs.core.truth_(inst_17083)){
var statearr_17155_17207 = state_17118__$1;
(statearr_17155_17207[(1)] = (26));

} else {
var statearr_17156_17208 = state_17118__$1;
(statearr_17156_17208[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (35))){
var inst_17103 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
if(cljs.core.truth_(inst_17103)){
var statearr_17157_17209 = state_17118__$1;
(statearr_17157_17209[(1)] = (36));

} else {
var statearr_17158_17210 = state_17118__$1;
(statearr_17158_17210[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (19))){
var inst_17045 = (state_17118[(7)]);
var inst_17065 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17045);
var state_17118__$1 = state_17118;
var statearr_17159_17211 = state_17118__$1;
(statearr_17159_17211[(2)] = inst_17065);

(statearr_17159_17211[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (11))){
var inst_17045 = (state_17118[(7)]);
var inst_17049 = (inst_17045 == null);
var inst_17050 = cljs.core.not(inst_17049);
var state_17118__$1 = state_17118;
if(inst_17050){
var statearr_17160_17212 = state_17118__$1;
(statearr_17160_17212[(1)] = (13));

} else {
var statearr_17161_17213 = state_17118__$1;
(statearr_17161_17213[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (9))){
var inst_17020 = (state_17118[(8)]);
var state_17118__$1 = state_17118;
var statearr_17162_17214 = state_17118__$1;
(statearr_17162_17214[(2)] = inst_17020);

(statearr_17162_17214[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (5))){
var state_17118__$1 = state_17118;
var statearr_17163_17215 = state_17118__$1;
(statearr_17163_17215[(2)] = true);

(statearr_17163_17215[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (14))){
var state_17118__$1 = state_17118;
var statearr_17164_17216 = state_17118__$1;
(statearr_17164_17216[(2)] = false);

(statearr_17164_17216[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (26))){
var inst_17078 = (state_17118[(10)]);
var inst_17085 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_17078);
var state_17118__$1 = state_17118;
var statearr_17165_17217 = state_17118__$1;
(statearr_17165_17217[(2)] = inst_17085);

(statearr_17165_17217[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (16))){
var state_17118__$1 = state_17118;
var statearr_17166_17218 = state_17118__$1;
(statearr_17166_17218[(2)] = true);

(statearr_17166_17218[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (38))){
var inst_17108 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
var statearr_17167_17219 = state_17118__$1;
(statearr_17167_17219[(2)] = inst_17108);

(statearr_17167_17219[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (30))){
var inst_17069 = (state_17118[(9)]);
var inst_17078 = (state_17118[(10)]);
var inst_17070 = (state_17118[(13)]);
var inst_17095 = cljs.core.empty_QMARK_(inst_17069);
var inst_17096 = (inst_17070.cljs$core$IFn$_invoke$arity$1 ? inst_17070.cljs$core$IFn$_invoke$arity$1(inst_17078) : inst_17070.call(null,inst_17078));
var inst_17097 = cljs.core.not(inst_17096);
var inst_17098 = (inst_17095) && (inst_17097);
var state_17118__$1 = state_17118;
var statearr_17168_17220 = state_17118__$1;
(statearr_17168_17220[(2)] = inst_17098);

(statearr_17168_17220[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (10))){
var inst_17020 = (state_17118[(8)]);
var inst_17041 = (state_17118[(2)]);
var inst_17042 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17041,cljs.core.cst$kw$solos);
var inst_17043 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17041,cljs.core.cst$kw$mutes);
var inst_17044 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17041,cljs.core.cst$kw$reads);
var inst_17045 = inst_17020;
var state_17118__$1 = (function (){var statearr_17169 = state_17118;
(statearr_17169[(16)] = inst_17042);

(statearr_17169[(7)] = inst_17045);

(statearr_17169[(17)] = inst_17043);

(statearr_17169[(18)] = inst_17044);

return statearr_17169;
})();
var statearr_17170_17221 = state_17118__$1;
(statearr_17170_17221[(2)] = null);

(statearr_17170_17221[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (18))){
var inst_17060 = (state_17118[(2)]);
var state_17118__$1 = state_17118;
var statearr_17171_17222 = state_17118__$1;
(statearr_17171_17222[(2)] = inst_17060);

(statearr_17171_17222[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (37))){
var state_17118__$1 = state_17118;
var statearr_17172_17223 = state_17118__$1;
(statearr_17172_17223[(2)] = null);

(statearr_17172_17223[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17119 === (8))){
var inst_17020 = (state_17118[(8)]);
var inst_17038 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17020);
var state_17118__$1 = state_17118;
var statearr_17173_17224 = state_17118__$1;
(statearr_17173_17224[(2)] = inst_17038);

(statearr_17173_17224[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___17178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__16015__auto__,c__16117__auto___17178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__16016__auto__ = null;
var cljs$core$async$mix_$_state_machine__16016__auto____0 = (function (){
var statearr_17174 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17174[(0)] = cljs$core$async$mix_$_state_machine__16016__auto__);

(statearr_17174[(1)] = (1));

return statearr_17174;
});
var cljs$core$async$mix_$_state_machine__16016__auto____1 = (function (state_17118){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_17118);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e17175){if((e17175 instanceof Object)){
var ex__16019__auto__ = e17175;
var statearr_17176_17225 = state_17118;
(statearr_17176_17225[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17118);

return cljs.core.cst$kw$recur;
} else {
throw e17175;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__17226 = state_17118;
state_17118 = G__17226;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16016__auto__ = function(state_17118){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16016__auto____1.call(this,state_17118);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16016__auto____0;
cljs$core$async$mix_$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16016__auto____1;
return cljs$core$async$mix_$_state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___17178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__16119__auto__ = (function (){var statearr_17177 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_17177[(6)] = c__16117__auto___17178);

return statearr_17177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___17178,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9540__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__9540__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9540__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9540__auto__.call(null,p,v,ch));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9540__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__17228 = arguments.length;
switch (G__17228) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__9540__auto__.call(null,p));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__9540__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9539__auto__ = (((p == null))?null:p);
var m__9540__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9539__auto__)]);
if(!((m__9540__auto__ == null))){
return (m__9540__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__9540__auto__.call(null,p,v));
} else {
var m__9540__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9540__auto____$1 == null))){
return (m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9540__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__9540__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__17232 = arguments.length;
switch (G__17232) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__8806__auto__)){
return or__8806__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8806__auto__,mults){
return (function (p1__17230_SHARP_){
if(cljs.core.truth_((p1__17230_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17230_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__17230_SHARP_.call(null,topic)))){
return p1__17230_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17230_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__8806__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async17233 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17233 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta17234){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta17234 = meta17234;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_17235,meta17234__$1){
var self__ = this;
var _17235__$1 = this;
return (new cljs.core.async.t_cljs$core$async17233(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta17234__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_17235){
var self__ = this;
var _17235__$1 = this;
return self__.meta17234;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17233.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta17234], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async17233.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17233.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17233";

cljs.core.async.t_cljs$core$async17233.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17233");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async17233 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async17233(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta17234){
return (new cljs.core.async.t_cljs$core$async17233(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta17234));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async17233(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16117__auto___17353 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___17353,mults,ensure_mult,p){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___17353,mults,ensure_mult,p){
return (function (state_17307){
var state_val_17308 = (state_17307[(1)]);
if((state_val_17308 === (7))){
var inst_17303 = (state_17307[(2)]);
var state_17307__$1 = state_17307;
var statearr_17309_17354 = state_17307__$1;
(statearr_17309_17354[(2)] = inst_17303);

(statearr_17309_17354[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (20))){
var state_17307__$1 = state_17307;
var statearr_17310_17355 = state_17307__$1;
(statearr_17310_17355[(2)] = null);

(statearr_17310_17355[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (1))){
var state_17307__$1 = state_17307;
var statearr_17311_17356 = state_17307__$1;
(statearr_17311_17356[(2)] = null);

(statearr_17311_17356[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (24))){
var inst_17286 = (state_17307[(7)]);
var inst_17295 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_17286);
var state_17307__$1 = state_17307;
var statearr_17312_17357 = state_17307__$1;
(statearr_17312_17357[(2)] = inst_17295);

(statearr_17312_17357[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (4))){
var inst_17238 = (state_17307[(8)]);
var inst_17238__$1 = (state_17307[(2)]);
var inst_17239 = (inst_17238__$1 == null);
var state_17307__$1 = (function (){var statearr_17313 = state_17307;
(statearr_17313[(8)] = inst_17238__$1);

return statearr_17313;
})();
if(cljs.core.truth_(inst_17239)){
var statearr_17314_17358 = state_17307__$1;
(statearr_17314_17358[(1)] = (5));

} else {
var statearr_17315_17359 = state_17307__$1;
(statearr_17315_17359[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (15))){
var inst_17280 = (state_17307[(2)]);
var state_17307__$1 = state_17307;
var statearr_17316_17360 = state_17307__$1;
(statearr_17316_17360[(2)] = inst_17280);

(statearr_17316_17360[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (21))){
var inst_17300 = (state_17307[(2)]);
var state_17307__$1 = (function (){var statearr_17317 = state_17307;
(statearr_17317[(9)] = inst_17300);

return statearr_17317;
})();
var statearr_17318_17361 = state_17307__$1;
(statearr_17318_17361[(2)] = null);

(statearr_17318_17361[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (13))){
var inst_17262 = (state_17307[(10)]);
var inst_17264 = cljs.core.chunked_seq_QMARK_(inst_17262);
var state_17307__$1 = state_17307;
if(inst_17264){
var statearr_17319_17362 = state_17307__$1;
(statearr_17319_17362[(1)] = (16));

} else {
var statearr_17320_17363 = state_17307__$1;
(statearr_17320_17363[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (22))){
var inst_17292 = (state_17307[(2)]);
var state_17307__$1 = state_17307;
if(cljs.core.truth_(inst_17292)){
var statearr_17321_17364 = state_17307__$1;
(statearr_17321_17364[(1)] = (23));

} else {
var statearr_17322_17365 = state_17307__$1;
(statearr_17322_17365[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (6))){
var inst_17288 = (state_17307[(11)]);
var inst_17238 = (state_17307[(8)]);
var inst_17286 = (state_17307[(7)]);
var inst_17286__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_17238) : topic_fn.call(null,inst_17238));
var inst_17287 = cljs.core.deref(mults);
var inst_17288__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17287,inst_17286__$1);
var state_17307__$1 = (function (){var statearr_17323 = state_17307;
(statearr_17323[(11)] = inst_17288__$1);

(statearr_17323[(7)] = inst_17286__$1);

return statearr_17323;
})();
if(cljs.core.truth_(inst_17288__$1)){
var statearr_17324_17366 = state_17307__$1;
(statearr_17324_17366[(1)] = (19));

} else {
var statearr_17325_17367 = state_17307__$1;
(statearr_17325_17367[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (25))){
var inst_17297 = (state_17307[(2)]);
var state_17307__$1 = state_17307;
var statearr_17326_17368 = state_17307__$1;
(statearr_17326_17368[(2)] = inst_17297);

(statearr_17326_17368[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (17))){
var inst_17262 = (state_17307[(10)]);
var inst_17271 = cljs.core.first(inst_17262);
var inst_17272 = cljs.core.async.muxch_STAR_(inst_17271);
var inst_17273 = cljs.core.async.close_BANG_(inst_17272);
var inst_17274 = cljs.core.next(inst_17262);
var inst_17248 = inst_17274;
var inst_17249 = null;
var inst_17250 = (0);
var inst_17251 = (0);
var state_17307__$1 = (function (){var statearr_17327 = state_17307;
(statearr_17327[(12)] = inst_17251);

(statearr_17327[(13)] = inst_17273);

(statearr_17327[(14)] = inst_17248);

(statearr_17327[(15)] = inst_17250);

(statearr_17327[(16)] = inst_17249);

return statearr_17327;
})();
var statearr_17328_17369 = state_17307__$1;
(statearr_17328_17369[(2)] = null);

(statearr_17328_17369[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (3))){
var inst_17305 = (state_17307[(2)]);
var state_17307__$1 = state_17307;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17307__$1,inst_17305);
} else {
if((state_val_17308 === (12))){
var inst_17282 = (state_17307[(2)]);
var state_17307__$1 = state_17307;
var statearr_17329_17370 = state_17307__$1;
(statearr_17329_17370[(2)] = inst_17282);

(statearr_17329_17370[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (2))){
var state_17307__$1 = state_17307;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17307__$1,(4),ch);
} else {
if((state_val_17308 === (23))){
var state_17307__$1 = state_17307;
var statearr_17330_17371 = state_17307__$1;
(statearr_17330_17371[(2)] = null);

(statearr_17330_17371[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (19))){
var inst_17288 = (state_17307[(11)]);
var inst_17238 = (state_17307[(8)]);
var inst_17290 = cljs.core.async.muxch_STAR_(inst_17288);
var state_17307__$1 = state_17307;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17307__$1,(22),inst_17290,inst_17238);
} else {
if((state_val_17308 === (11))){
var inst_17248 = (state_17307[(14)]);
var inst_17262 = (state_17307[(10)]);
var inst_17262__$1 = cljs.core.seq(inst_17248);
var state_17307__$1 = (function (){var statearr_17331 = state_17307;
(statearr_17331[(10)] = inst_17262__$1);

return statearr_17331;
})();
if(inst_17262__$1){
var statearr_17332_17372 = state_17307__$1;
(statearr_17332_17372[(1)] = (13));

} else {
var statearr_17333_17373 = state_17307__$1;
(statearr_17333_17373[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (9))){
var inst_17284 = (state_17307[(2)]);
var state_17307__$1 = state_17307;
var statearr_17334_17374 = state_17307__$1;
(statearr_17334_17374[(2)] = inst_17284);

(statearr_17334_17374[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (5))){
var inst_17245 = cljs.core.deref(mults);
var inst_17246 = cljs.core.vals(inst_17245);
var inst_17247 = cljs.core.seq(inst_17246);
var inst_17248 = inst_17247;
var inst_17249 = null;
var inst_17250 = (0);
var inst_17251 = (0);
var state_17307__$1 = (function (){var statearr_17335 = state_17307;
(statearr_17335[(12)] = inst_17251);

(statearr_17335[(14)] = inst_17248);

(statearr_17335[(15)] = inst_17250);

(statearr_17335[(16)] = inst_17249);

return statearr_17335;
})();
var statearr_17336_17375 = state_17307__$1;
(statearr_17336_17375[(2)] = null);

(statearr_17336_17375[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (14))){
var state_17307__$1 = state_17307;
var statearr_17340_17376 = state_17307__$1;
(statearr_17340_17376[(2)] = null);

(statearr_17340_17376[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (16))){
var inst_17262 = (state_17307[(10)]);
var inst_17266 = cljs.core.chunk_first(inst_17262);
var inst_17267 = cljs.core.chunk_rest(inst_17262);
var inst_17268 = cljs.core.count(inst_17266);
var inst_17248 = inst_17267;
var inst_17249 = inst_17266;
var inst_17250 = inst_17268;
var inst_17251 = (0);
var state_17307__$1 = (function (){var statearr_17341 = state_17307;
(statearr_17341[(12)] = inst_17251);

(statearr_17341[(14)] = inst_17248);

(statearr_17341[(15)] = inst_17250);

(statearr_17341[(16)] = inst_17249);

return statearr_17341;
})();
var statearr_17342_17377 = state_17307__$1;
(statearr_17342_17377[(2)] = null);

(statearr_17342_17377[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (10))){
var inst_17251 = (state_17307[(12)]);
var inst_17248 = (state_17307[(14)]);
var inst_17250 = (state_17307[(15)]);
var inst_17249 = (state_17307[(16)]);
var inst_17256 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17249,inst_17251);
var inst_17257 = cljs.core.async.muxch_STAR_(inst_17256);
var inst_17258 = cljs.core.async.close_BANG_(inst_17257);
var inst_17259 = (inst_17251 + (1));
var tmp17337 = inst_17248;
var tmp17338 = inst_17250;
var tmp17339 = inst_17249;
var inst_17248__$1 = tmp17337;
var inst_17249__$1 = tmp17339;
var inst_17250__$1 = tmp17338;
var inst_17251__$1 = inst_17259;
var state_17307__$1 = (function (){var statearr_17343 = state_17307;
(statearr_17343[(12)] = inst_17251__$1);

(statearr_17343[(17)] = inst_17258);

(statearr_17343[(14)] = inst_17248__$1);

(statearr_17343[(15)] = inst_17250__$1);

(statearr_17343[(16)] = inst_17249__$1);

return statearr_17343;
})();
var statearr_17344_17378 = state_17307__$1;
(statearr_17344_17378[(2)] = null);

(statearr_17344_17378[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (18))){
var inst_17277 = (state_17307[(2)]);
var state_17307__$1 = state_17307;
var statearr_17345_17379 = state_17307__$1;
(statearr_17345_17379[(2)] = inst_17277);

(statearr_17345_17379[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17308 === (8))){
var inst_17251 = (state_17307[(12)]);
var inst_17250 = (state_17307[(15)]);
var inst_17253 = (inst_17251 < inst_17250);
var inst_17254 = inst_17253;
var state_17307__$1 = state_17307;
if(cljs.core.truth_(inst_17254)){
var statearr_17346_17380 = state_17307__$1;
(statearr_17346_17380[(1)] = (10));

} else {
var statearr_17347_17381 = state_17307__$1;
(statearr_17347_17381[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___17353,mults,ensure_mult,p))
;
return ((function (switch__16015__auto__,c__16117__auto___17353,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_17348 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17348[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_17348[(1)] = (1));

return statearr_17348;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_17307){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_17307);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e17349){if((e17349 instanceof Object)){
var ex__16019__auto__ = e17349;
var statearr_17350_17382 = state_17307;
(statearr_17350_17382[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17307);

return cljs.core.cst$kw$recur;
} else {
throw e17349;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__17383 = state_17307;
state_17307 = G__17383;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_17307){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_17307);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___17353,mults,ensure_mult,p))
})();
var state__16119__auto__ = (function (){var statearr_17351 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_17351[(6)] = c__16117__auto___17353);

return statearr_17351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___17353,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__17385 = arguments.length;
switch (G__17385) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__17388 = arguments.length;
switch (G__17388) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__17391 = arguments.length;
switch (G__17391) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__16117__auto___17458 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___17458,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___17458,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_17430){
var state_val_17431 = (state_17430[(1)]);
if((state_val_17431 === (7))){
var state_17430__$1 = state_17430;
var statearr_17432_17459 = state_17430__$1;
(statearr_17432_17459[(2)] = null);

(statearr_17432_17459[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (1))){
var state_17430__$1 = state_17430;
var statearr_17433_17460 = state_17430__$1;
(statearr_17433_17460[(2)] = null);

(statearr_17433_17460[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (4))){
var inst_17394 = (state_17430[(7)]);
var inst_17396 = (inst_17394 < cnt);
var state_17430__$1 = state_17430;
if(cljs.core.truth_(inst_17396)){
var statearr_17434_17461 = state_17430__$1;
(statearr_17434_17461[(1)] = (6));

} else {
var statearr_17435_17462 = state_17430__$1;
(statearr_17435_17462[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (15))){
var inst_17426 = (state_17430[(2)]);
var state_17430__$1 = state_17430;
var statearr_17436_17463 = state_17430__$1;
(statearr_17436_17463[(2)] = inst_17426);

(statearr_17436_17463[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (13))){
var inst_17419 = cljs.core.async.close_BANG_(out);
var state_17430__$1 = state_17430;
var statearr_17437_17464 = state_17430__$1;
(statearr_17437_17464[(2)] = inst_17419);

(statearr_17437_17464[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (6))){
var state_17430__$1 = state_17430;
var statearr_17438_17465 = state_17430__$1;
(statearr_17438_17465[(2)] = null);

(statearr_17438_17465[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (3))){
var inst_17428 = (state_17430[(2)]);
var state_17430__$1 = state_17430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17430__$1,inst_17428);
} else {
if((state_val_17431 === (12))){
var inst_17416 = (state_17430[(8)]);
var inst_17416__$1 = (state_17430[(2)]);
var inst_17417 = cljs.core.some(cljs.core.nil_QMARK_,inst_17416__$1);
var state_17430__$1 = (function (){var statearr_17439 = state_17430;
(statearr_17439[(8)] = inst_17416__$1);

return statearr_17439;
})();
if(cljs.core.truth_(inst_17417)){
var statearr_17440_17466 = state_17430__$1;
(statearr_17440_17466[(1)] = (13));

} else {
var statearr_17441_17467 = state_17430__$1;
(statearr_17441_17467[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (2))){
var inst_17393 = cljs.core.reset_BANG_(dctr,cnt);
var inst_17394 = (0);
var state_17430__$1 = (function (){var statearr_17442 = state_17430;
(statearr_17442[(7)] = inst_17394);

(statearr_17442[(9)] = inst_17393);

return statearr_17442;
})();
var statearr_17443_17468 = state_17430__$1;
(statearr_17443_17468[(2)] = null);

(statearr_17443_17468[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (11))){
var inst_17394 = (state_17430[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_17430,(10),Object,null,(9));
var inst_17403 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_17394) : chs__$1.call(null,inst_17394));
var inst_17404 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_17394) : done.call(null,inst_17394));
var inst_17405 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_17403,inst_17404);
var state_17430__$1 = state_17430;
var statearr_17444_17469 = state_17430__$1;
(statearr_17444_17469[(2)] = inst_17405);


cljs.core.async.impl.ioc_helpers.process_exception(state_17430__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (9))){
var inst_17394 = (state_17430[(7)]);
var inst_17407 = (state_17430[(2)]);
var inst_17408 = (inst_17394 + (1));
var inst_17394__$1 = inst_17408;
var state_17430__$1 = (function (){var statearr_17445 = state_17430;
(statearr_17445[(10)] = inst_17407);

(statearr_17445[(7)] = inst_17394__$1);

return statearr_17445;
})();
var statearr_17446_17470 = state_17430__$1;
(statearr_17446_17470[(2)] = null);

(statearr_17446_17470[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (5))){
var inst_17414 = (state_17430[(2)]);
var state_17430__$1 = (function (){var statearr_17447 = state_17430;
(statearr_17447[(11)] = inst_17414);

return statearr_17447;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17430__$1,(12),dchan);
} else {
if((state_val_17431 === (14))){
var inst_17416 = (state_17430[(8)]);
var inst_17421 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_17416);
var state_17430__$1 = state_17430;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17430__$1,(16),out,inst_17421);
} else {
if((state_val_17431 === (16))){
var inst_17423 = (state_17430[(2)]);
var state_17430__$1 = (function (){var statearr_17448 = state_17430;
(statearr_17448[(12)] = inst_17423);

return statearr_17448;
})();
var statearr_17449_17471 = state_17430__$1;
(statearr_17449_17471[(2)] = null);

(statearr_17449_17471[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (10))){
var inst_17398 = (state_17430[(2)]);
var inst_17399 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_17430__$1 = (function (){var statearr_17450 = state_17430;
(statearr_17450[(13)] = inst_17398);

return statearr_17450;
})();
var statearr_17451_17472 = state_17430__$1;
(statearr_17451_17472[(2)] = inst_17399);


cljs.core.async.impl.ioc_helpers.process_exception(state_17430__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_17431 === (8))){
var inst_17412 = (state_17430[(2)]);
var state_17430__$1 = state_17430;
var statearr_17452_17473 = state_17430__$1;
(statearr_17452_17473[(2)] = inst_17412);

(statearr_17452_17473[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___17458,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16015__auto__,c__16117__auto___17458,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_17453 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17453[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_17453[(1)] = (1));

return statearr_17453;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_17430){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_17430);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e17454){if((e17454 instanceof Object)){
var ex__16019__auto__ = e17454;
var statearr_17455_17474 = state_17430;
(statearr_17455_17474[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17430);

return cljs.core.cst$kw$recur;
} else {
throw e17454;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__17475 = state_17430;
state_17430 = G__17475;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_17430){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_17430);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___17458,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16119__auto__ = (function (){var statearr_17456 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_17456[(6)] = c__16117__auto___17458);

return statearr_17456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___17458,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__17478 = arguments.length;
switch (G__17478) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16117__auto___17532 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___17532,out){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___17532,out){
return (function (state_17510){
var state_val_17511 = (state_17510[(1)]);
if((state_val_17511 === (7))){
var inst_17490 = (state_17510[(7)]);
var inst_17489 = (state_17510[(8)]);
var inst_17489__$1 = (state_17510[(2)]);
var inst_17490__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17489__$1,(0),null);
var inst_17491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17489__$1,(1),null);
var inst_17492 = (inst_17490__$1 == null);
var state_17510__$1 = (function (){var statearr_17512 = state_17510;
(statearr_17512[(7)] = inst_17490__$1);

(statearr_17512[(9)] = inst_17491);

(statearr_17512[(8)] = inst_17489__$1);

return statearr_17512;
})();
if(cljs.core.truth_(inst_17492)){
var statearr_17513_17533 = state_17510__$1;
(statearr_17513_17533[(1)] = (8));

} else {
var statearr_17514_17534 = state_17510__$1;
(statearr_17514_17534[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17511 === (1))){
var inst_17479 = cljs.core.vec(chs);
var inst_17480 = inst_17479;
var state_17510__$1 = (function (){var statearr_17515 = state_17510;
(statearr_17515[(10)] = inst_17480);

return statearr_17515;
})();
var statearr_17516_17535 = state_17510__$1;
(statearr_17516_17535[(2)] = null);

(statearr_17516_17535[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17511 === (4))){
var inst_17480 = (state_17510[(10)]);
var state_17510__$1 = state_17510;
return cljs.core.async.ioc_alts_BANG_(state_17510__$1,(7),inst_17480);
} else {
if((state_val_17511 === (6))){
var inst_17506 = (state_17510[(2)]);
var state_17510__$1 = state_17510;
var statearr_17517_17536 = state_17510__$1;
(statearr_17517_17536[(2)] = inst_17506);

(statearr_17517_17536[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17511 === (3))){
var inst_17508 = (state_17510[(2)]);
var state_17510__$1 = state_17510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17510__$1,inst_17508);
} else {
if((state_val_17511 === (2))){
var inst_17480 = (state_17510[(10)]);
var inst_17482 = cljs.core.count(inst_17480);
var inst_17483 = (inst_17482 > (0));
var state_17510__$1 = state_17510;
if(cljs.core.truth_(inst_17483)){
var statearr_17519_17537 = state_17510__$1;
(statearr_17519_17537[(1)] = (4));

} else {
var statearr_17520_17538 = state_17510__$1;
(statearr_17520_17538[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17511 === (11))){
var inst_17480 = (state_17510[(10)]);
var inst_17499 = (state_17510[(2)]);
var tmp17518 = inst_17480;
var inst_17480__$1 = tmp17518;
var state_17510__$1 = (function (){var statearr_17521 = state_17510;
(statearr_17521[(11)] = inst_17499);

(statearr_17521[(10)] = inst_17480__$1);

return statearr_17521;
})();
var statearr_17522_17539 = state_17510__$1;
(statearr_17522_17539[(2)] = null);

(statearr_17522_17539[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17511 === (9))){
var inst_17490 = (state_17510[(7)]);
var state_17510__$1 = state_17510;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17510__$1,(11),out,inst_17490);
} else {
if((state_val_17511 === (5))){
var inst_17504 = cljs.core.async.close_BANG_(out);
var state_17510__$1 = state_17510;
var statearr_17523_17540 = state_17510__$1;
(statearr_17523_17540[(2)] = inst_17504);

(statearr_17523_17540[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17511 === (10))){
var inst_17502 = (state_17510[(2)]);
var state_17510__$1 = state_17510;
var statearr_17524_17541 = state_17510__$1;
(statearr_17524_17541[(2)] = inst_17502);

(statearr_17524_17541[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17511 === (8))){
var inst_17490 = (state_17510[(7)]);
var inst_17480 = (state_17510[(10)]);
var inst_17491 = (state_17510[(9)]);
var inst_17489 = (state_17510[(8)]);
var inst_17494 = (function (){var cs = inst_17480;
var vec__17485 = inst_17489;
var v = inst_17490;
var c = inst_17491;
return ((function (cs,vec__17485,v,c,inst_17490,inst_17480,inst_17491,inst_17489,state_val_17511,c__16117__auto___17532,out){
return (function (p1__17476_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__17476_SHARP_);
});
;})(cs,vec__17485,v,c,inst_17490,inst_17480,inst_17491,inst_17489,state_val_17511,c__16117__auto___17532,out))
})();
var inst_17495 = cljs.core.filterv(inst_17494,inst_17480);
var inst_17480__$1 = inst_17495;
var state_17510__$1 = (function (){var statearr_17525 = state_17510;
(statearr_17525[(10)] = inst_17480__$1);

return statearr_17525;
})();
var statearr_17526_17542 = state_17510__$1;
(statearr_17526_17542[(2)] = null);

(statearr_17526_17542[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___17532,out))
;
return ((function (switch__16015__auto__,c__16117__auto___17532,out){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_17527 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17527[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_17527[(1)] = (1));

return statearr_17527;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_17510){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_17510);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e17528){if((e17528 instanceof Object)){
var ex__16019__auto__ = e17528;
var statearr_17529_17543 = state_17510;
(statearr_17529_17543[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17510);

return cljs.core.cst$kw$recur;
} else {
throw e17528;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__17544 = state_17510;
state_17510 = G__17544;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_17510){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_17510);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___17532,out))
})();
var state__16119__auto__ = (function (){var statearr_17530 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_17530[(6)] = c__16117__auto___17532);

return statearr_17530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___17532,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__17546 = arguments.length;
switch (G__17546) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16117__auto___17591 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___17591,out){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___17591,out){
return (function (state_17570){
var state_val_17571 = (state_17570[(1)]);
if((state_val_17571 === (7))){
var inst_17552 = (state_17570[(7)]);
var inst_17552__$1 = (state_17570[(2)]);
var inst_17553 = (inst_17552__$1 == null);
var inst_17554 = cljs.core.not(inst_17553);
var state_17570__$1 = (function (){var statearr_17572 = state_17570;
(statearr_17572[(7)] = inst_17552__$1);

return statearr_17572;
})();
if(inst_17554){
var statearr_17573_17592 = state_17570__$1;
(statearr_17573_17592[(1)] = (8));

} else {
var statearr_17574_17593 = state_17570__$1;
(statearr_17574_17593[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17571 === (1))){
var inst_17547 = (0);
var state_17570__$1 = (function (){var statearr_17575 = state_17570;
(statearr_17575[(8)] = inst_17547);

return statearr_17575;
})();
var statearr_17576_17594 = state_17570__$1;
(statearr_17576_17594[(2)] = null);

(statearr_17576_17594[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17571 === (4))){
var state_17570__$1 = state_17570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17570__$1,(7),ch);
} else {
if((state_val_17571 === (6))){
var inst_17565 = (state_17570[(2)]);
var state_17570__$1 = state_17570;
var statearr_17577_17595 = state_17570__$1;
(statearr_17577_17595[(2)] = inst_17565);

(statearr_17577_17595[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17571 === (3))){
var inst_17567 = (state_17570[(2)]);
var inst_17568 = cljs.core.async.close_BANG_(out);
var state_17570__$1 = (function (){var statearr_17578 = state_17570;
(statearr_17578[(9)] = inst_17567);

return statearr_17578;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17570__$1,inst_17568);
} else {
if((state_val_17571 === (2))){
var inst_17547 = (state_17570[(8)]);
var inst_17549 = (inst_17547 < n);
var state_17570__$1 = state_17570;
if(cljs.core.truth_(inst_17549)){
var statearr_17579_17596 = state_17570__$1;
(statearr_17579_17596[(1)] = (4));

} else {
var statearr_17580_17597 = state_17570__$1;
(statearr_17580_17597[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17571 === (11))){
var inst_17547 = (state_17570[(8)]);
var inst_17557 = (state_17570[(2)]);
var inst_17558 = (inst_17547 + (1));
var inst_17547__$1 = inst_17558;
var state_17570__$1 = (function (){var statearr_17581 = state_17570;
(statearr_17581[(10)] = inst_17557);

(statearr_17581[(8)] = inst_17547__$1);

return statearr_17581;
})();
var statearr_17582_17598 = state_17570__$1;
(statearr_17582_17598[(2)] = null);

(statearr_17582_17598[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17571 === (9))){
var state_17570__$1 = state_17570;
var statearr_17583_17599 = state_17570__$1;
(statearr_17583_17599[(2)] = null);

(statearr_17583_17599[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17571 === (5))){
var state_17570__$1 = state_17570;
var statearr_17584_17600 = state_17570__$1;
(statearr_17584_17600[(2)] = null);

(statearr_17584_17600[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17571 === (10))){
var inst_17562 = (state_17570[(2)]);
var state_17570__$1 = state_17570;
var statearr_17585_17601 = state_17570__$1;
(statearr_17585_17601[(2)] = inst_17562);

(statearr_17585_17601[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17571 === (8))){
var inst_17552 = (state_17570[(7)]);
var state_17570__$1 = state_17570;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17570__$1,(11),out,inst_17552);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___17591,out))
;
return ((function (switch__16015__auto__,c__16117__auto___17591,out){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_17586 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17586[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_17586[(1)] = (1));

return statearr_17586;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_17570){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_17570);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e17587){if((e17587 instanceof Object)){
var ex__16019__auto__ = e17587;
var statearr_17588_17602 = state_17570;
(statearr_17588_17602[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17570);

return cljs.core.cst$kw$recur;
} else {
throw e17587;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__17603 = state_17570;
state_17570 = G__17603;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_17570){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_17570);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___17591,out))
})();
var state__16119__auto__ = (function (){var statearr_17589 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_17589[(6)] = c__16117__auto___17591);

return statearr_17589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___17591,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async17605 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17605 = (function (f,ch,meta17606){
this.f = f;
this.ch = ch;
this.meta17606 = meta17606;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17605.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17607,meta17606__$1){
var self__ = this;
var _17607__$1 = this;
return (new cljs.core.async.t_cljs$core$async17605(self__.f,self__.ch,meta17606__$1));
});

cljs.core.async.t_cljs$core$async17605.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17607){
var self__ = this;
var _17607__$1 = this;
return self__.meta17606;
});

cljs.core.async.t_cljs$core$async17605.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17605.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async17605.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async17605.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17605.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async17608 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17608 = (function (f,ch,meta17606,_,fn1,meta17609){
this.f = f;
this.ch = ch;
this.meta17606 = meta17606;
this._ = _;
this.fn1 = fn1;
this.meta17609 = meta17609;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17608.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_17610,meta17609__$1){
var self__ = this;
var _17610__$1 = this;
return (new cljs.core.async.t_cljs$core$async17608(self__.f,self__.ch,self__.meta17606,self__._,self__.fn1,meta17609__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async17608.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_17610){
var self__ = this;
var _17610__$1 = this;
return self__.meta17609;
});})(___$1))
;

cljs.core.async.t_cljs$core$async17608.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17608.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async17608.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async17608.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__17604_SHARP_){
var G__17611 = (((p1__17604_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__17604_SHARP_) : self__.f.call(null,p1__17604_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__17611) : f1.call(null,G__17611));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async17608.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17606,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async17605], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta17609], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async17608.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17608.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17608";

cljs.core.async.t_cljs$core$async17608.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17608");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async17608 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17608(f__$1,ch__$1,meta17606__$1,___$2,fn1__$1,meta17609){
return (new cljs.core.async.t_cljs$core$async17608(f__$1,ch__$1,meta17606__$1,___$2,fn1__$1,meta17609));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async17608(self__.f,self__.ch,self__.meta17606,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8794__auto__ = ret;
if(cljs.core.truth_(and__8794__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__8794__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__17612 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__17612) : self__.f.call(null,G__17612));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async17605.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17605.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async17605.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17606], null);
});

cljs.core.async.t_cljs$core$async17605.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17605.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17605";

cljs.core.async.t_cljs$core$async17605.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17605");
});

cljs.core.async.__GT_t_cljs$core$async17605 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17605(f__$1,ch__$1,meta17606){
return (new cljs.core.async.t_cljs$core$async17605(f__$1,ch__$1,meta17606));
});

}

return (new cljs.core.async.t_cljs$core$async17605(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async17613 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17613 = (function (f,ch,meta17614){
this.f = f;
this.ch = ch;
this.meta17614 = meta17614;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17613.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17615,meta17614__$1){
var self__ = this;
var _17615__$1 = this;
return (new cljs.core.async.t_cljs$core$async17613(self__.f,self__.ch,meta17614__$1));
});

cljs.core.async.t_cljs$core$async17613.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17615){
var self__ = this;
var _17615__$1 = this;
return self__.meta17614;
});

cljs.core.async.t_cljs$core$async17613.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17613.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async17613.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17613.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17613.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17613.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async17613.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17614], null);
});

cljs.core.async.t_cljs$core$async17613.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17613.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17613";

cljs.core.async.t_cljs$core$async17613.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17613");
});

cljs.core.async.__GT_t_cljs$core$async17613 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async17613(f__$1,ch__$1,meta17614){
return (new cljs.core.async.t_cljs$core$async17613(f__$1,ch__$1,meta17614));
});

}

return (new cljs.core.async.t_cljs$core$async17613(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async17616 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17616 = (function (p,ch,meta17617){
this.p = p;
this.ch = ch;
this.meta17617 = meta17617;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17616.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17618,meta17617__$1){
var self__ = this;
var _17618__$1 = this;
return (new cljs.core.async.t_cljs$core$async17616(self__.p,self__.ch,meta17617__$1));
});

cljs.core.async.t_cljs$core$async17616.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17618){
var self__ = this;
var _17618__$1 = this;
return self__.meta17617;
});

cljs.core.async.t_cljs$core$async17616.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17616.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async17616.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async17616.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17616.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17616.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17616.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async17616.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17617], null);
});

cljs.core.async.t_cljs$core$async17616.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17616.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17616";

cljs.core.async.t_cljs$core$async17616.cljs$lang$ctorPrWriter = (function (this__9477__auto__,writer__9478__auto__,opt__9479__auto__){
return cljs.core._write(writer__9478__auto__,"cljs.core.async/t_cljs$core$async17616");
});

cljs.core.async.__GT_t_cljs$core$async17616 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async17616(p__$1,ch__$1,meta17617){
return (new cljs.core.async.t_cljs$core$async17616(p__$1,ch__$1,meta17617));
});

}

return (new cljs.core.async.t_cljs$core$async17616(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__17620 = arguments.length;
switch (G__17620) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16117__auto___17660 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___17660,out){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___17660,out){
return (function (state_17641){
var state_val_17642 = (state_17641[(1)]);
if((state_val_17642 === (7))){
var inst_17637 = (state_17641[(2)]);
var state_17641__$1 = state_17641;
var statearr_17643_17661 = state_17641__$1;
(statearr_17643_17661[(2)] = inst_17637);

(statearr_17643_17661[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17642 === (1))){
var state_17641__$1 = state_17641;
var statearr_17644_17662 = state_17641__$1;
(statearr_17644_17662[(2)] = null);

(statearr_17644_17662[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17642 === (4))){
var inst_17623 = (state_17641[(7)]);
var inst_17623__$1 = (state_17641[(2)]);
var inst_17624 = (inst_17623__$1 == null);
var state_17641__$1 = (function (){var statearr_17645 = state_17641;
(statearr_17645[(7)] = inst_17623__$1);

return statearr_17645;
})();
if(cljs.core.truth_(inst_17624)){
var statearr_17646_17663 = state_17641__$1;
(statearr_17646_17663[(1)] = (5));

} else {
var statearr_17647_17664 = state_17641__$1;
(statearr_17647_17664[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17642 === (6))){
var inst_17623 = (state_17641[(7)]);
var inst_17628 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17623) : p.call(null,inst_17623));
var state_17641__$1 = state_17641;
if(cljs.core.truth_(inst_17628)){
var statearr_17648_17665 = state_17641__$1;
(statearr_17648_17665[(1)] = (8));

} else {
var statearr_17649_17666 = state_17641__$1;
(statearr_17649_17666[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17642 === (3))){
var inst_17639 = (state_17641[(2)]);
var state_17641__$1 = state_17641;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17641__$1,inst_17639);
} else {
if((state_val_17642 === (2))){
var state_17641__$1 = state_17641;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17641__$1,(4),ch);
} else {
if((state_val_17642 === (11))){
var inst_17631 = (state_17641[(2)]);
var state_17641__$1 = state_17641;
var statearr_17650_17667 = state_17641__$1;
(statearr_17650_17667[(2)] = inst_17631);

(statearr_17650_17667[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17642 === (9))){
var state_17641__$1 = state_17641;
var statearr_17651_17668 = state_17641__$1;
(statearr_17651_17668[(2)] = null);

(statearr_17651_17668[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17642 === (5))){
var inst_17626 = cljs.core.async.close_BANG_(out);
var state_17641__$1 = state_17641;
var statearr_17652_17669 = state_17641__$1;
(statearr_17652_17669[(2)] = inst_17626);

(statearr_17652_17669[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17642 === (10))){
var inst_17634 = (state_17641[(2)]);
var state_17641__$1 = (function (){var statearr_17653 = state_17641;
(statearr_17653[(8)] = inst_17634);

return statearr_17653;
})();
var statearr_17654_17670 = state_17641__$1;
(statearr_17654_17670[(2)] = null);

(statearr_17654_17670[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17642 === (8))){
var inst_17623 = (state_17641[(7)]);
var state_17641__$1 = state_17641;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17641__$1,(11),out,inst_17623);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___17660,out))
;
return ((function (switch__16015__auto__,c__16117__auto___17660,out){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_17655 = [null,null,null,null,null,null,null,null,null];
(statearr_17655[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_17655[(1)] = (1));

return statearr_17655;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_17641){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_17641);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e17656){if((e17656 instanceof Object)){
var ex__16019__auto__ = e17656;
var statearr_17657_17671 = state_17641;
(statearr_17657_17671[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17641);

return cljs.core.cst$kw$recur;
} else {
throw e17656;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__17672 = state_17641;
state_17641 = G__17672;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_17641){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_17641);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___17660,out))
})();
var state__16119__auto__ = (function (){var statearr_17658 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_17658[(6)] = c__16117__auto___17660);

return statearr_17658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___17660,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__17674 = arguments.length;
switch (G__17674) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16117__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto__){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto__){
return (function (state_17737){
var state_val_17738 = (state_17737[(1)]);
if((state_val_17738 === (7))){
var inst_17733 = (state_17737[(2)]);
var state_17737__$1 = state_17737;
var statearr_17739_17777 = state_17737__$1;
(statearr_17739_17777[(2)] = inst_17733);

(statearr_17739_17777[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (20))){
var inst_17703 = (state_17737[(7)]);
var inst_17714 = (state_17737[(2)]);
var inst_17715 = cljs.core.next(inst_17703);
var inst_17689 = inst_17715;
var inst_17690 = null;
var inst_17691 = (0);
var inst_17692 = (0);
var state_17737__$1 = (function (){var statearr_17740 = state_17737;
(statearr_17740[(8)] = inst_17690);

(statearr_17740[(9)] = inst_17689);

(statearr_17740[(10)] = inst_17692);

(statearr_17740[(11)] = inst_17714);

(statearr_17740[(12)] = inst_17691);

return statearr_17740;
})();
var statearr_17741_17778 = state_17737__$1;
(statearr_17741_17778[(2)] = null);

(statearr_17741_17778[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (1))){
var state_17737__$1 = state_17737;
var statearr_17742_17779 = state_17737__$1;
(statearr_17742_17779[(2)] = null);

(statearr_17742_17779[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (4))){
var inst_17678 = (state_17737[(13)]);
var inst_17678__$1 = (state_17737[(2)]);
var inst_17679 = (inst_17678__$1 == null);
var state_17737__$1 = (function (){var statearr_17743 = state_17737;
(statearr_17743[(13)] = inst_17678__$1);

return statearr_17743;
})();
if(cljs.core.truth_(inst_17679)){
var statearr_17744_17780 = state_17737__$1;
(statearr_17744_17780[(1)] = (5));

} else {
var statearr_17745_17781 = state_17737__$1;
(statearr_17745_17781[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (15))){
var state_17737__$1 = state_17737;
var statearr_17749_17782 = state_17737__$1;
(statearr_17749_17782[(2)] = null);

(statearr_17749_17782[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (21))){
var state_17737__$1 = state_17737;
var statearr_17750_17783 = state_17737__$1;
(statearr_17750_17783[(2)] = null);

(statearr_17750_17783[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (13))){
var inst_17690 = (state_17737[(8)]);
var inst_17689 = (state_17737[(9)]);
var inst_17692 = (state_17737[(10)]);
var inst_17691 = (state_17737[(12)]);
var inst_17699 = (state_17737[(2)]);
var inst_17700 = (inst_17692 + (1));
var tmp17746 = inst_17690;
var tmp17747 = inst_17689;
var tmp17748 = inst_17691;
var inst_17689__$1 = tmp17747;
var inst_17690__$1 = tmp17746;
var inst_17691__$1 = tmp17748;
var inst_17692__$1 = inst_17700;
var state_17737__$1 = (function (){var statearr_17751 = state_17737;
(statearr_17751[(8)] = inst_17690__$1);

(statearr_17751[(9)] = inst_17689__$1);

(statearr_17751[(10)] = inst_17692__$1);

(statearr_17751[(14)] = inst_17699);

(statearr_17751[(12)] = inst_17691__$1);

return statearr_17751;
})();
var statearr_17752_17784 = state_17737__$1;
(statearr_17752_17784[(2)] = null);

(statearr_17752_17784[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (22))){
var state_17737__$1 = state_17737;
var statearr_17753_17785 = state_17737__$1;
(statearr_17753_17785[(2)] = null);

(statearr_17753_17785[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (6))){
var inst_17678 = (state_17737[(13)]);
var inst_17687 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17678) : f.call(null,inst_17678));
var inst_17688 = cljs.core.seq(inst_17687);
var inst_17689 = inst_17688;
var inst_17690 = null;
var inst_17691 = (0);
var inst_17692 = (0);
var state_17737__$1 = (function (){var statearr_17754 = state_17737;
(statearr_17754[(8)] = inst_17690);

(statearr_17754[(9)] = inst_17689);

(statearr_17754[(10)] = inst_17692);

(statearr_17754[(12)] = inst_17691);

return statearr_17754;
})();
var statearr_17755_17786 = state_17737__$1;
(statearr_17755_17786[(2)] = null);

(statearr_17755_17786[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (17))){
var inst_17703 = (state_17737[(7)]);
var inst_17707 = cljs.core.chunk_first(inst_17703);
var inst_17708 = cljs.core.chunk_rest(inst_17703);
var inst_17709 = cljs.core.count(inst_17707);
var inst_17689 = inst_17708;
var inst_17690 = inst_17707;
var inst_17691 = inst_17709;
var inst_17692 = (0);
var state_17737__$1 = (function (){var statearr_17756 = state_17737;
(statearr_17756[(8)] = inst_17690);

(statearr_17756[(9)] = inst_17689);

(statearr_17756[(10)] = inst_17692);

(statearr_17756[(12)] = inst_17691);

return statearr_17756;
})();
var statearr_17757_17787 = state_17737__$1;
(statearr_17757_17787[(2)] = null);

(statearr_17757_17787[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (3))){
var inst_17735 = (state_17737[(2)]);
var state_17737__$1 = state_17737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17737__$1,inst_17735);
} else {
if((state_val_17738 === (12))){
var inst_17723 = (state_17737[(2)]);
var state_17737__$1 = state_17737;
var statearr_17758_17788 = state_17737__$1;
(statearr_17758_17788[(2)] = inst_17723);

(statearr_17758_17788[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (2))){
var state_17737__$1 = state_17737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17737__$1,(4),in$);
} else {
if((state_val_17738 === (23))){
var inst_17731 = (state_17737[(2)]);
var state_17737__$1 = state_17737;
var statearr_17759_17789 = state_17737__$1;
(statearr_17759_17789[(2)] = inst_17731);

(statearr_17759_17789[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (19))){
var inst_17718 = (state_17737[(2)]);
var state_17737__$1 = state_17737;
var statearr_17760_17790 = state_17737__$1;
(statearr_17760_17790[(2)] = inst_17718);

(statearr_17760_17790[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (11))){
var inst_17689 = (state_17737[(9)]);
var inst_17703 = (state_17737[(7)]);
var inst_17703__$1 = cljs.core.seq(inst_17689);
var state_17737__$1 = (function (){var statearr_17761 = state_17737;
(statearr_17761[(7)] = inst_17703__$1);

return statearr_17761;
})();
if(inst_17703__$1){
var statearr_17762_17791 = state_17737__$1;
(statearr_17762_17791[(1)] = (14));

} else {
var statearr_17763_17792 = state_17737__$1;
(statearr_17763_17792[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (9))){
var inst_17725 = (state_17737[(2)]);
var inst_17726 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_17737__$1 = (function (){var statearr_17764 = state_17737;
(statearr_17764[(15)] = inst_17725);

return statearr_17764;
})();
if(cljs.core.truth_(inst_17726)){
var statearr_17765_17793 = state_17737__$1;
(statearr_17765_17793[(1)] = (21));

} else {
var statearr_17766_17794 = state_17737__$1;
(statearr_17766_17794[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (5))){
var inst_17681 = cljs.core.async.close_BANG_(out);
var state_17737__$1 = state_17737;
var statearr_17767_17795 = state_17737__$1;
(statearr_17767_17795[(2)] = inst_17681);

(statearr_17767_17795[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (14))){
var inst_17703 = (state_17737[(7)]);
var inst_17705 = cljs.core.chunked_seq_QMARK_(inst_17703);
var state_17737__$1 = state_17737;
if(inst_17705){
var statearr_17768_17796 = state_17737__$1;
(statearr_17768_17796[(1)] = (17));

} else {
var statearr_17769_17797 = state_17737__$1;
(statearr_17769_17797[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (16))){
var inst_17721 = (state_17737[(2)]);
var state_17737__$1 = state_17737;
var statearr_17770_17798 = state_17737__$1;
(statearr_17770_17798[(2)] = inst_17721);

(statearr_17770_17798[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17738 === (10))){
var inst_17690 = (state_17737[(8)]);
var inst_17692 = (state_17737[(10)]);
var inst_17697 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17690,inst_17692);
var state_17737__$1 = state_17737;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17737__$1,(13),out,inst_17697);
} else {
if((state_val_17738 === (18))){
var inst_17703 = (state_17737[(7)]);
var inst_17712 = cljs.core.first(inst_17703);
var state_17737__$1 = state_17737;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17737__$1,(20),out,inst_17712);
} else {
if((state_val_17738 === (8))){
var inst_17692 = (state_17737[(10)]);
var inst_17691 = (state_17737[(12)]);
var inst_17694 = (inst_17692 < inst_17691);
var inst_17695 = inst_17694;
var state_17737__$1 = state_17737;
if(cljs.core.truth_(inst_17695)){
var statearr_17771_17799 = state_17737__$1;
(statearr_17771_17799[(1)] = (10));

} else {
var statearr_17772_17800 = state_17737__$1;
(statearr_17772_17800[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto__))
;
return ((function (switch__16015__auto__,c__16117__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16016__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16016__auto____0 = (function (){
var statearr_17773 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17773[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16016__auto__);

(statearr_17773[(1)] = (1));

return statearr_17773;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16016__auto____1 = (function (state_17737){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_17737);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e17774){if((e17774 instanceof Object)){
var ex__16019__auto__ = e17774;
var statearr_17775_17801 = state_17737;
(statearr_17775_17801[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17737);

return cljs.core.cst$kw$recur;
} else {
throw e17774;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__17802 = state_17737;
state_17737 = G__17802;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16016__auto__ = function(state_17737){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16016__auto____1.call(this,state_17737);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16016__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16016__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto__))
})();
var state__16119__auto__ = (function (){var statearr_17776 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_17776[(6)] = c__16117__auto__);

return statearr_17776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto__))
);

return c__16117__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__17804 = arguments.length;
switch (G__17804) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__17807 = arguments.length;
switch (G__17807) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__17810 = arguments.length;
switch (G__17810) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16117__auto___17857 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___17857,out){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___17857,out){
return (function (state_17834){
var state_val_17835 = (state_17834[(1)]);
if((state_val_17835 === (7))){
var inst_17829 = (state_17834[(2)]);
var state_17834__$1 = state_17834;
var statearr_17836_17858 = state_17834__$1;
(statearr_17836_17858[(2)] = inst_17829);

(statearr_17836_17858[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17835 === (1))){
var inst_17811 = null;
var state_17834__$1 = (function (){var statearr_17837 = state_17834;
(statearr_17837[(7)] = inst_17811);

return statearr_17837;
})();
var statearr_17838_17859 = state_17834__$1;
(statearr_17838_17859[(2)] = null);

(statearr_17838_17859[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17835 === (4))){
var inst_17814 = (state_17834[(8)]);
var inst_17814__$1 = (state_17834[(2)]);
var inst_17815 = (inst_17814__$1 == null);
var inst_17816 = cljs.core.not(inst_17815);
var state_17834__$1 = (function (){var statearr_17839 = state_17834;
(statearr_17839[(8)] = inst_17814__$1);

return statearr_17839;
})();
if(inst_17816){
var statearr_17840_17860 = state_17834__$1;
(statearr_17840_17860[(1)] = (5));

} else {
var statearr_17841_17861 = state_17834__$1;
(statearr_17841_17861[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17835 === (6))){
var state_17834__$1 = state_17834;
var statearr_17842_17862 = state_17834__$1;
(statearr_17842_17862[(2)] = null);

(statearr_17842_17862[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17835 === (3))){
var inst_17831 = (state_17834[(2)]);
var inst_17832 = cljs.core.async.close_BANG_(out);
var state_17834__$1 = (function (){var statearr_17843 = state_17834;
(statearr_17843[(9)] = inst_17831);

return statearr_17843;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17834__$1,inst_17832);
} else {
if((state_val_17835 === (2))){
var state_17834__$1 = state_17834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17834__$1,(4),ch);
} else {
if((state_val_17835 === (11))){
var inst_17814 = (state_17834[(8)]);
var inst_17823 = (state_17834[(2)]);
var inst_17811 = inst_17814;
var state_17834__$1 = (function (){var statearr_17844 = state_17834;
(statearr_17844[(7)] = inst_17811);

(statearr_17844[(10)] = inst_17823);

return statearr_17844;
})();
var statearr_17845_17863 = state_17834__$1;
(statearr_17845_17863[(2)] = null);

(statearr_17845_17863[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17835 === (9))){
var inst_17814 = (state_17834[(8)]);
var state_17834__$1 = state_17834;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17834__$1,(11),out,inst_17814);
} else {
if((state_val_17835 === (5))){
var inst_17811 = (state_17834[(7)]);
var inst_17814 = (state_17834[(8)]);
var inst_17818 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17814,inst_17811);
var state_17834__$1 = state_17834;
if(inst_17818){
var statearr_17847_17864 = state_17834__$1;
(statearr_17847_17864[(1)] = (8));

} else {
var statearr_17848_17865 = state_17834__$1;
(statearr_17848_17865[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17835 === (10))){
var inst_17826 = (state_17834[(2)]);
var state_17834__$1 = state_17834;
var statearr_17849_17866 = state_17834__$1;
(statearr_17849_17866[(2)] = inst_17826);

(statearr_17849_17866[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17835 === (8))){
var inst_17811 = (state_17834[(7)]);
var tmp17846 = inst_17811;
var inst_17811__$1 = tmp17846;
var state_17834__$1 = (function (){var statearr_17850 = state_17834;
(statearr_17850[(7)] = inst_17811__$1);

return statearr_17850;
})();
var statearr_17851_17867 = state_17834__$1;
(statearr_17851_17867[(2)] = null);

(statearr_17851_17867[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___17857,out))
;
return ((function (switch__16015__auto__,c__16117__auto___17857,out){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_17852 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17852[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_17852[(1)] = (1));

return statearr_17852;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_17834){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_17834);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e17853){if((e17853 instanceof Object)){
var ex__16019__auto__ = e17853;
var statearr_17854_17868 = state_17834;
(statearr_17854_17868[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17834);

return cljs.core.cst$kw$recur;
} else {
throw e17853;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__17869 = state_17834;
state_17834 = G__17869;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_17834){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_17834);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___17857,out))
})();
var state__16119__auto__ = (function (){var statearr_17855 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_17855[(6)] = c__16117__auto___17857);

return statearr_17855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___17857,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__17871 = arguments.length;
switch (G__17871) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16117__auto___17937 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___17937,out){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___17937,out){
return (function (state_17909){
var state_val_17910 = (state_17909[(1)]);
if((state_val_17910 === (7))){
var inst_17905 = (state_17909[(2)]);
var state_17909__$1 = state_17909;
var statearr_17911_17938 = state_17909__$1;
(statearr_17911_17938[(2)] = inst_17905);

(statearr_17911_17938[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17910 === (1))){
var inst_17872 = (new Array(n));
var inst_17873 = inst_17872;
var inst_17874 = (0);
var state_17909__$1 = (function (){var statearr_17912 = state_17909;
(statearr_17912[(7)] = inst_17874);

(statearr_17912[(8)] = inst_17873);

return statearr_17912;
})();
var statearr_17913_17939 = state_17909__$1;
(statearr_17913_17939[(2)] = null);

(statearr_17913_17939[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17910 === (4))){
var inst_17877 = (state_17909[(9)]);
var inst_17877__$1 = (state_17909[(2)]);
var inst_17878 = (inst_17877__$1 == null);
var inst_17879 = cljs.core.not(inst_17878);
var state_17909__$1 = (function (){var statearr_17914 = state_17909;
(statearr_17914[(9)] = inst_17877__$1);

return statearr_17914;
})();
if(inst_17879){
var statearr_17915_17940 = state_17909__$1;
(statearr_17915_17940[(1)] = (5));

} else {
var statearr_17916_17941 = state_17909__$1;
(statearr_17916_17941[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17910 === (15))){
var inst_17899 = (state_17909[(2)]);
var state_17909__$1 = state_17909;
var statearr_17917_17942 = state_17909__$1;
(statearr_17917_17942[(2)] = inst_17899);

(statearr_17917_17942[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17910 === (13))){
var state_17909__$1 = state_17909;
var statearr_17918_17943 = state_17909__$1;
(statearr_17918_17943[(2)] = null);

(statearr_17918_17943[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17910 === (6))){
var inst_17874 = (state_17909[(7)]);
var inst_17895 = (inst_17874 > (0));
var state_17909__$1 = state_17909;
if(cljs.core.truth_(inst_17895)){
var statearr_17919_17944 = state_17909__$1;
(statearr_17919_17944[(1)] = (12));

} else {
var statearr_17920_17945 = state_17909__$1;
(statearr_17920_17945[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17910 === (3))){
var inst_17907 = (state_17909[(2)]);
var state_17909__$1 = state_17909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17909__$1,inst_17907);
} else {
if((state_val_17910 === (12))){
var inst_17873 = (state_17909[(8)]);
var inst_17897 = cljs.core.vec(inst_17873);
var state_17909__$1 = state_17909;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17909__$1,(15),out,inst_17897);
} else {
if((state_val_17910 === (2))){
var state_17909__$1 = state_17909;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17909__$1,(4),ch);
} else {
if((state_val_17910 === (11))){
var inst_17889 = (state_17909[(2)]);
var inst_17890 = (new Array(n));
var inst_17873 = inst_17890;
var inst_17874 = (0);
var state_17909__$1 = (function (){var statearr_17921 = state_17909;
(statearr_17921[(7)] = inst_17874);

(statearr_17921[(10)] = inst_17889);

(statearr_17921[(8)] = inst_17873);

return statearr_17921;
})();
var statearr_17922_17946 = state_17909__$1;
(statearr_17922_17946[(2)] = null);

(statearr_17922_17946[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17910 === (9))){
var inst_17873 = (state_17909[(8)]);
var inst_17887 = cljs.core.vec(inst_17873);
var state_17909__$1 = state_17909;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17909__$1,(11),out,inst_17887);
} else {
if((state_val_17910 === (5))){
var inst_17877 = (state_17909[(9)]);
var inst_17882 = (state_17909[(11)]);
var inst_17874 = (state_17909[(7)]);
var inst_17873 = (state_17909[(8)]);
var inst_17881 = (inst_17873[inst_17874] = inst_17877);
var inst_17882__$1 = (inst_17874 + (1));
var inst_17883 = (inst_17882__$1 < n);
var state_17909__$1 = (function (){var statearr_17923 = state_17909;
(statearr_17923[(12)] = inst_17881);

(statearr_17923[(11)] = inst_17882__$1);

return statearr_17923;
})();
if(cljs.core.truth_(inst_17883)){
var statearr_17924_17947 = state_17909__$1;
(statearr_17924_17947[(1)] = (8));

} else {
var statearr_17925_17948 = state_17909__$1;
(statearr_17925_17948[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17910 === (14))){
var inst_17902 = (state_17909[(2)]);
var inst_17903 = cljs.core.async.close_BANG_(out);
var state_17909__$1 = (function (){var statearr_17927 = state_17909;
(statearr_17927[(13)] = inst_17902);

return statearr_17927;
})();
var statearr_17928_17949 = state_17909__$1;
(statearr_17928_17949[(2)] = inst_17903);

(statearr_17928_17949[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17910 === (10))){
var inst_17893 = (state_17909[(2)]);
var state_17909__$1 = state_17909;
var statearr_17929_17950 = state_17909__$1;
(statearr_17929_17950[(2)] = inst_17893);

(statearr_17929_17950[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17910 === (8))){
var inst_17882 = (state_17909[(11)]);
var inst_17873 = (state_17909[(8)]);
var tmp17926 = inst_17873;
var inst_17873__$1 = tmp17926;
var inst_17874 = inst_17882;
var state_17909__$1 = (function (){var statearr_17930 = state_17909;
(statearr_17930[(7)] = inst_17874);

(statearr_17930[(8)] = inst_17873__$1);

return statearr_17930;
})();
var statearr_17931_17951 = state_17909__$1;
(statearr_17931_17951[(2)] = null);

(statearr_17931_17951[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___17937,out))
;
return ((function (switch__16015__auto__,c__16117__auto___17937,out){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_17932 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17932[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_17932[(1)] = (1));

return statearr_17932;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_17909){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_17909);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e17933){if((e17933 instanceof Object)){
var ex__16019__auto__ = e17933;
var statearr_17934_17952 = state_17909;
(statearr_17934_17952[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17909);

return cljs.core.cst$kw$recur;
} else {
throw e17933;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__17953 = state_17909;
state_17909 = G__17953;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_17909){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_17909);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___17937,out))
})();
var state__16119__auto__ = (function (){var statearr_17935 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_17935[(6)] = c__16117__auto___17937);

return statearr_17935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___17937,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__17955 = arguments.length;
switch (G__17955) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16117__auto___18025 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16117__auto___18025,out){
return (function (){
var f__16118__auto__ = (function (){var switch__16015__auto__ = ((function (c__16117__auto___18025,out){
return (function (state_17997){
var state_val_17998 = (state_17997[(1)]);
if((state_val_17998 === (7))){
var inst_17993 = (state_17997[(2)]);
var state_17997__$1 = state_17997;
var statearr_17999_18026 = state_17997__$1;
(statearr_17999_18026[(2)] = inst_17993);

(statearr_17999_18026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17998 === (1))){
var inst_17956 = [];
var inst_17957 = inst_17956;
var inst_17958 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_17997__$1 = (function (){var statearr_18000 = state_17997;
(statearr_18000[(7)] = inst_17958);

(statearr_18000[(8)] = inst_17957);

return statearr_18000;
})();
var statearr_18001_18027 = state_17997__$1;
(statearr_18001_18027[(2)] = null);

(statearr_18001_18027[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17998 === (4))){
var inst_17961 = (state_17997[(9)]);
var inst_17961__$1 = (state_17997[(2)]);
var inst_17962 = (inst_17961__$1 == null);
var inst_17963 = cljs.core.not(inst_17962);
var state_17997__$1 = (function (){var statearr_18002 = state_17997;
(statearr_18002[(9)] = inst_17961__$1);

return statearr_18002;
})();
if(inst_17963){
var statearr_18003_18028 = state_17997__$1;
(statearr_18003_18028[(1)] = (5));

} else {
var statearr_18004_18029 = state_17997__$1;
(statearr_18004_18029[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17998 === (15))){
var inst_17987 = (state_17997[(2)]);
var state_17997__$1 = state_17997;
var statearr_18005_18030 = state_17997__$1;
(statearr_18005_18030[(2)] = inst_17987);

(statearr_18005_18030[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17998 === (13))){
var state_17997__$1 = state_17997;
var statearr_18006_18031 = state_17997__$1;
(statearr_18006_18031[(2)] = null);

(statearr_18006_18031[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17998 === (6))){
var inst_17957 = (state_17997[(8)]);
var inst_17982 = inst_17957.length;
var inst_17983 = (inst_17982 > (0));
var state_17997__$1 = state_17997;
if(cljs.core.truth_(inst_17983)){
var statearr_18007_18032 = state_17997__$1;
(statearr_18007_18032[(1)] = (12));

} else {
var statearr_18008_18033 = state_17997__$1;
(statearr_18008_18033[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17998 === (3))){
var inst_17995 = (state_17997[(2)]);
var state_17997__$1 = state_17997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17997__$1,inst_17995);
} else {
if((state_val_17998 === (12))){
var inst_17957 = (state_17997[(8)]);
var inst_17985 = cljs.core.vec(inst_17957);
var state_17997__$1 = state_17997;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17997__$1,(15),out,inst_17985);
} else {
if((state_val_17998 === (2))){
var state_17997__$1 = state_17997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17997__$1,(4),ch);
} else {
if((state_val_17998 === (11))){
var inst_17961 = (state_17997[(9)]);
var inst_17965 = (state_17997[(10)]);
var inst_17975 = (state_17997[(2)]);
var inst_17976 = [];
var inst_17977 = inst_17976.push(inst_17961);
var inst_17957 = inst_17976;
var inst_17958 = inst_17965;
var state_17997__$1 = (function (){var statearr_18009 = state_17997;
(statearr_18009[(7)] = inst_17958);

(statearr_18009[(11)] = inst_17977);

(statearr_18009[(8)] = inst_17957);

(statearr_18009[(12)] = inst_17975);

return statearr_18009;
})();
var statearr_18010_18034 = state_17997__$1;
(statearr_18010_18034[(2)] = null);

(statearr_18010_18034[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17998 === (9))){
var inst_17957 = (state_17997[(8)]);
var inst_17973 = cljs.core.vec(inst_17957);
var state_17997__$1 = state_17997;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17997__$1,(11),out,inst_17973);
} else {
if((state_val_17998 === (5))){
var inst_17958 = (state_17997[(7)]);
var inst_17961 = (state_17997[(9)]);
var inst_17965 = (state_17997[(10)]);
var inst_17965__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17961) : f.call(null,inst_17961));
var inst_17966 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17965__$1,inst_17958);
var inst_17967 = cljs.core.keyword_identical_QMARK_(inst_17958,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_17968 = (inst_17966) || (inst_17967);
var state_17997__$1 = (function (){var statearr_18011 = state_17997;
(statearr_18011[(10)] = inst_17965__$1);

return statearr_18011;
})();
if(cljs.core.truth_(inst_17968)){
var statearr_18012_18035 = state_17997__$1;
(statearr_18012_18035[(1)] = (8));

} else {
var statearr_18013_18036 = state_17997__$1;
(statearr_18013_18036[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17998 === (14))){
var inst_17990 = (state_17997[(2)]);
var inst_17991 = cljs.core.async.close_BANG_(out);
var state_17997__$1 = (function (){var statearr_18015 = state_17997;
(statearr_18015[(13)] = inst_17990);

return statearr_18015;
})();
var statearr_18016_18037 = state_17997__$1;
(statearr_18016_18037[(2)] = inst_17991);

(statearr_18016_18037[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17998 === (10))){
var inst_17980 = (state_17997[(2)]);
var state_17997__$1 = state_17997;
var statearr_18017_18038 = state_17997__$1;
(statearr_18017_18038[(2)] = inst_17980);

(statearr_18017_18038[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17998 === (8))){
var inst_17961 = (state_17997[(9)]);
var inst_17957 = (state_17997[(8)]);
var inst_17965 = (state_17997[(10)]);
var inst_17970 = inst_17957.push(inst_17961);
var tmp18014 = inst_17957;
var inst_17957__$1 = tmp18014;
var inst_17958 = inst_17965;
var state_17997__$1 = (function (){var statearr_18018 = state_17997;
(statearr_18018[(7)] = inst_17958);

(statearr_18018[(8)] = inst_17957__$1);

(statearr_18018[(14)] = inst_17970);

return statearr_18018;
})();
var statearr_18019_18039 = state_17997__$1;
(statearr_18019_18039[(2)] = null);

(statearr_18019_18039[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16117__auto___18025,out))
;
return ((function (switch__16015__auto__,c__16117__auto___18025,out){
return (function() {
var cljs$core$async$state_machine__16016__auto__ = null;
var cljs$core$async$state_machine__16016__auto____0 = (function (){
var statearr_18020 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18020[(0)] = cljs$core$async$state_machine__16016__auto__);

(statearr_18020[(1)] = (1));

return statearr_18020;
});
var cljs$core$async$state_machine__16016__auto____1 = (function (state_17997){
while(true){
var ret_value__16017__auto__ = (function (){try{while(true){
var result__16018__auto__ = switch__16015__auto__(state_17997);
if(cljs.core.keyword_identical_QMARK_(result__16018__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16018__auto__;
}
break;
}
}catch (e18021){if((e18021 instanceof Object)){
var ex__16019__auto__ = e18021;
var statearr_18022_18040 = state_17997;
(statearr_18022_18040[(5)] = ex__16019__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17997);

return cljs.core.cst$kw$recur;
} else {
throw e18021;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16017__auto__,cljs.core.cst$kw$recur)){
var G__18041 = state_17997;
state_17997 = G__18041;
continue;
} else {
return ret_value__16017__auto__;
}
break;
}
});
cljs$core$async$state_machine__16016__auto__ = function(state_17997){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16016__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16016__auto____1.call(this,state_17997);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16016__auto____0;
cljs$core$async$state_machine__16016__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16016__auto____1;
return cljs$core$async$state_machine__16016__auto__;
})()
;})(switch__16015__auto__,c__16117__auto___18025,out))
})();
var state__16119__auto__ = (function (){var statearr_18023 = (f__16118__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16118__auto__.cljs$core$IFn$_invoke$arity$0() : f__16118__auto__.call(null));
(statearr_18023[(6)] = c__16117__auto___18025);

return statearr_18023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16119__auto__);
});})(c__16117__auto___18025,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

