;;
;; Copyright: Dmitry Kakurin
;;

(ns dimagog.util.trace
  (:use dimagog.util.seq)
  (:require clojure.string))

(def ^:dynamic *tr-indent* 0)
(def ^:dynamic *trace* true)

(defn indent-string []
   (clojure.string/join (repeat *tr-indent* \space))
)

(defmacro tr-base [ name val & b ]
  (if *trace*
    (let [pname# (str (if name (str name ":")) (first b)) res# (gensym "res")]
      `(do
          (println (str "TRACE:" (indent-string)) ~(str "+" pname#))
              (let [~res#
                     (binding [*tr-indent* (inc *tr-indent*)]
                       ~(delist b))]
                (println (str "TRACE:" (indent-string)) ~(str "-" pname#) ~(if val (list str "= " (list pr-str res#)) ""))
                ~res#)))
    (delist b)))

(defmacro trn  [ name & b ] `(tr-base ~name false ~@b))
(defmacro tr   [ & b]       `(tr-base nil   false ~@b))
(defmacro trv  [ & b]       `(tr-base nil   true  ~@b))

(defmacro trnv [ name & b]  `(tr-base ~name true  ~@b))
(defmacro trvn [ name & b]  `(tr-base ~name true  ~@b))

(defmacro trn- [ name & b] (delist b))
(defmacro tr-  [ & b]      (delist b))
(defmacro trv- [ & b]      (delist b))

(defmacro log [ & b]
  (when *trace*
    `(println "TRACE:" ~@b)))

(defmacro trace [ & b]
  (if *trace*
    `(let [res# ~(delist b)]
        do (println (str "TRACE:" (indent-string)) '~(delist b) "->" (if (seq? res#) (doall res#) res#)) res#)
    (delist b)))

(defmacro traces [ & b]
  (if *trace*
    `(let [res# ~(delist b)]
        do (println (str "TRACE:" (indent-string)) '~(first b) "->" (if (seq? res#) (doall res#) res#)) res#)
    (delist b)))

(defmacro tracen [ name & b]
  (if *trace*
    `(let [res# ~(delist b)]
        do (println (str "TRACE:" (indent-string)) '~name "->" (if (seq? res#) (doall res#) res#)) res#)
    (delist b)))

(defmacro mtrace [ & b]
  (if *trace*
    `(let [res# ~(delist b)]
        do (println "TRACE:" '~(delist b) "=>" (macroexpand-1 '~(delist b)) "->" res#) res#)
    (delist b)))

(defmacro traceeval [ & b]
  (if *trace*
    `(let [res# ~(delist b)] 
        do (println "TRACE:" '~(delist b) "->" res# \= (eval res#)) res#)
    (delist b)))

(defmacro ttrace  "Convert statement into test" [ & b] `(println (str "(is (= "  '~b " '" (seq  ~b) "))")))
(defmacro ttrace1 "Convert statement into test" [ & b] `(println (str "(is (= " '~@b " '" (seq ~@b) "))")))

(defmacro trace- [ & b] (delist b))
(defmacro tracen- [ name & b] (delist b))

; (mtrace ($ 1 + 2))