(ns dimagog.util.test)

;(defmacro assert2 [exp str]
;  `(when-not ~exp (assert (not ~str))))

(defmacro with-assert-str [exp reason & forms]
  (if *assert*
    `(if ~exp
       (do ~@forms)
       (throw (new AssertionError (str "Assert failed: " ~reason))))
    `(do ~@forms)))

(defmacro with-assert [exp & forms]
  `(with-assert-str ~exp '~exp ~@forms))

(let [printed-files (atom #{})]
  (defmacro test-only [& forms]
    "Executes forms only if user/*test* var is declared
    Pass \"-e \"(declare *test*)\" to clojure.main to declare it"
    #_(prn *file* user/*test-only-file*)
    (if-let [sw-core-ns (find-ns 'swank.core)]
      (if (= (name (ns-name *ns*)) (ns-resolve sw-core-ns '*current-package*))
      	(cons 'do forms))
      (when-let [tof (resolve 'user/*test-only-file*)]
        (when (= *file* @tof)
          (when-not (@printed-files *file*)
            (swap! printed-files conj *file*)
            (println "Testing" *file*))
          (cons 'do forms))))))

(test-only

(use 'clojure.pprint)

(pprint (macroexpand
  '(with-assert-str
        (singleton-seq? (filter #{sym} %2))
        (str "Symbol '" sym "' must appear exactly once in expression '" (pr-str %2) "'")
        (replace {sym %1} %2))
))
(pprint (macroexpand
  '(with-assert
        (singleton-seq? (filter #{sym} %2))
        (replace {sym %1} %2))
))

(set! *assert* false)

(pprint (macroexpand
  '(with-assert-str
        (singleton-seq? (filter #{sym} %2))
        (str "Symbol '" sym "' must appear exactly once in expression '" (pr-str %2) "'")
        (replace {sym %1} %2))
))
(pprint (macroexpand
  '(with-assert
        (singleton-seq? (filter #{sym} %2))
        (replace {sym %1} %2))
))

)

