(ns dimagog.util.seq)

(defn delist [l]
  "If seq has exactly one element then return this element, else return seq unchanged"
  (if (and (seq l) (empty? (rest l)))
    (first l)
    l))

(defn enlist [x]
  "If x is collection leave it as-is, or make it into (x)"
  (if (sequential? x)
    x
    (list x)))

#_(defn envec [x]
  (cond
    (vector? x) x
    (sequential? x) (vec x)
    :else (vector x)))
      
(defn singleton-seq? [c]
  "Tests if seq has exactly one element without realizing entire seq"
  (let [s (seq c)]
    (and s (not (next s)))))


#_(defn delist2 [coll]
  (if-let [s (seq coll)]
    (if (next s)
      coll
      (first coll))
    coll))

(defn delist-or-seq [coll]
  (if (sequential? coll)
    (let [s (seq coll)]
      (if (next s)
        s
        (first coll)))
    coll))

(defn- try-seq [s]
  (if (sequential? s)
    (seq s)
    s))

(defn flip [f]
  "Flips 1st and 2nd arguments and then calls f"
  (fn [a b]
    (f b a)))

(defn- file-to-seq [^java.io.Reader f]
  (->>
    (repeatedly #(.read f))
    (take-while pos?)
    (map char)))

(use 'dimagog.util.test)

(test-only

(println
  (into {}
    (map (juxt identity delist)
      [nil [] [[1]] [2] [3 4] [3 4 5]])))

(println
  (map (juxt identity enlist)
    [nil 1 '() [] '(1) [1] [[1]] [2] [3 4] [3 4 5]]))
)
