;;
;; Copyright: Dmitry Kakurin
;;

(ns dimagog.util.infix
  (:use dimagog.util.defprivate)
  (:use dimagog.util.seq)
)

(defn- separate [sep l]
    (if (or (not (seq? l)) (empty? l))  
        l
        (let [[a b] (split-with #(not= sep %) l)]
                (cons a (if (empty? b) b (separate sep (rest b))))))
)

(defn- splitby [l sep]
    (cond
        (not (seq? l)) l
        (empty? l) l
        :else (let [sp (separate sep l)]
            (if (empty? (rest sp)) (map #(splitby % sep) (first sp))
                (cons sep (map #(splitby (delist %) sep) sp))
                )
            )
    )
)

(defn- msplitby [lsep lst]
    (reduce splitby lst lsep)
)

(defonce- ^:dynamic *infix-symbols* '(or || and && = == not= != < > <= >= + - * / **))

(defonce- ^:dynamic *infix-subs*
  (zipmap
   '( !  || &&   **   !=   =0   )
   '(not or and expt not= zero? )))

(defn- translate [tr l]
    (letfn [
        (mapsym [s] (or (tr s) s))

        (maprest-tree [f l]
          (if (coll? l)
            (map #(mapcar-tree f %) l)
            l))
            
        (mapcar-tree [f l]
          (if (coll? l)
            (cons (mapcar-tree f (first l)) (map #(maprest-tree f %) (rest l)))
            (f l)))
    ]
        (mapcar-tree mapsym l)
    )
)

(defn infix->prefix [l]
  (->> l (msplitby *infix-symbols*) (translate *infix-subs*)))

(defmacro infix [ & b ] (infix->prefix b))
(defmacro $ [ & b ] (infix->prefix b))

(defmacro $$ [& b] 
  (do 
    (println (str *file* "(" (:line (meta &form)) "):") "infix->prefix")
    (println "  infix :" (pr-str b) "=>")
    (println "  prefix:" (pr-str (infix->prefix b)))
    (cons '$ b)))
    
; (defmacro $$ [ & b ] (list* 'mtrace '$ b))
