;;
;; Copyright: Dmitry Kakurin
;;

(ns dimagog.util.defprivate)

(comment
(defn make-private [s]
    (with-meta s (assoc (meta s) :private true))
)
)

(defmacro #^{:private true} defprivate [m]
  `(defmacro ~(symbol (str m "-"))
      ~(str "same as " m ", yielding non-public definition")
      [~'name & ~'decls]
      (list* '~m (with-meta ~'name (assoc (meta ~'name) :private true)) ~'decls)
  )
)

(defprivate def)
(defprivate defonce)
(defprivate defmacro)
(defprivate declare)

(ns-unmap *ns* 'defprivate)
