(ns pagerduty.fml)

(defn max-sub-vector [v]
  (let [cnt (count v)]
    (for [starts (range 0 cnt)]
      (let [ends (range starts cnt)]
        (for [[x ys] [starts ends]]
          [x ys])))))

(->> (let [arr [1 3 4 5]
           cnt (count arr)]
       (for [x (range 0 cnt)]
         (for [y (range x cnt)]
           [x y]))))

(defn max-subarray [A]
  (let [pos+ (fn [sum x] (if (neg? sum) x (+ sum x)))
        ending-heres (reductions pos+ 0 A)]
    (reduce max ending-heres)))

(defn max-sub [coll]
  (loop [[best current] [0 0]
         x coll]
    (recur (max [current]))))

(defn max-sub-array [coll]
  (apply + (reductions (fn [sum n] (+ sum n)) 0 coll)))
