;; Copyright (c) Brenton Ashworth. All rights reserved.
;; The use and distribution terms for this software are covered by the
;; Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;; which can be found in the file COPYING at the root of this distribution.
;; By using this software in any fashion, you are agreeing to be bound by
;; the terms of this license.
;; You must not remove this notice, or any other, from this software.

(ns leiningen.deview
  (:use [leiningen.compile :only [eval-in-project]])
  (:import (java.io BufferedReader
                    BufferedWriter
                    InputStreamReader
                    OutputStreamWriter)
           (java.net Socket)))

(defn- stop-deview [host port]
  (with-open [socket (Socket. host port)
              writer (BufferedWriter.
                      (OutputStreamWriter. (.getOutputStream socket)))]
    (do (.write writer "shutdown\r\n")
        (.flush writer))))

(defn deview
  "Start deview server. Configure port with :deview-server in project.clj.
   Add argument \"stop\" to shutdown a running server."
  ([project]
     (if-let [port (-> project :deview-server)]
       (eval-in-project project
                        `(do (require 'deview.server)
                             (deview.server/start ~port)))
       (println "Could not find :deview-server in project.clj")))
  ([project command]
     (if (= command "stop")
       (stop-deview "localhost" (-> project :deview-server))
       (println "Unknown command: " command))))

