;; Copyright (c) Brenton Ashworth. All rights reserved.
;; The use and distribution terms for this software are covered by the
;; Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;; which can be found in the file COPYING at the root of this distribution.
;; By using this software in any fashion, you are agreeing to be bound by
;; the terms of this license.
;; You must not remove this notice, or any other, from this software.

(ns deview.project
  (:import (java.io File)))

(defn read-project []
  (let [[_ name v & m] (read-string (slurp "project.clj"))]
    (merge {:name (str name)
            :version (str v)}
           (apply hash-map m))))

(defn get-test-path
  ([] (get-test-path (read-project)))
  ([p] (get p :test-path "test")))

(defn get-source-path
  ([] (get-test-path (read-project)))
  ([p] (get p :source-path "src")))
