;; Copyright (c) Brenton Ashworth. All rights reserved.
;; The use and distribution terms for this software are covered by the
;; Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;; which can be found in the file COPYING at the root of this distribution.
;; By using this software in any fashion, you are agreeing to be bound by
;; the terms of this license.
;; You must not remove this notice, or any other, from this software.

(ns deview.stats
  "Various project statistics."
  (:use (deview project))
  (:import (java.io File
                    BufferedReader
                    InputStreamReader
                    FileInputStream)))

(defn non-blank? [line] (if (re-find #"\S" line) true false))

(defn non-source? [file] (and
                       (not (.contains (.toString file) ".svn"))
                       (not (.contains (.toString file) "#"))))

(defn source-fn [ext]
  (fn [file]
    (let [file-string (.toString file)]
      (.endsWith file-string ext))))

(defn loc [base-file ext]
  (reduce
    +
    (for [file (file-seq base-file)
           :when (and ((source-fn ext) file) (non-source? file))]
      (with-open [rdr (BufferedReader.
                       (InputStreamReader.
                        (FileInputStream. file)))]
        (count (filter non-blank? (line-seq rdr)))))))

;; TODO - Improve this.

(defn project-statistics []
  (let [p (read-project)]
    {:loc {:source {:clj (loc (File. (get-source-path p)) ".clj")}
           :test {:clj (loc (File. (get-test-path p)) ".clj")}}}))

