;; Copyright (c) Brenton Ashworth. All rights reserved.
;; The use and distribution terms for this software are covered by the
;; Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;; which can be found in the file COPYING at the root of this distribution.
;; By using this software in any fashion, you are agreeing to be bound by
;; the terms of this license.
;; You must not remove this notice, or any other, from this software.

(ns deview.test
  (:use (clojure test)
        (clj-stacktrace core)
        (deview project))
  (:import (java.io File)))

(def test-file-ext ".clj")
 
(defn- possible-test-file? [file]
  (.endsWith (.getName file) ".clj"))

(defn get-namespace-name [forms]
  (str (second (first (filter #(= (first %) 'ns) forms)))))

(defn test-namespaces []
  (->> (file-seq (File. (get-test-path)))
       (filter possible-test-file?)
       (map #(read-string (str "[" (slurp (.getAbsolutePath %)) "]")))
       (reduce (fn [a b]
                 (if (some #(= (first %) 'deftest) b)
                   (conj a (get-namespace-name b))
                   a))
               [])))

(defn test-results-for-namespace [namespace]
  (with-open [sw (java.io.StringWriter.)]
    (try
     (let [namespace-sym (symbol namespace)
           summary (binding [*test-out* sw]
                     (with-test-out
                       (require :reload-all namespace-sym)
                       (time (run-tests namespace-sym))))]
       {:namespace namespace
        :summary summary
        :output (.toString sw)})
     (catch Exception e {:namespace namespace
                         :exception (parse-exception e)}))))

(defn test-results-for-all-namespaces []
  (let [namespaces (test-namespaces)]
    (map #(test-results-for-namespace %) namespaces)))
