(ns vlaaad.reveal.pro.form.enum
  "© 2021 Vladislav Protsenko. All rights reserved."
  (:require [vlaaad.reveal.pro.form.impl :as impl]
            [vlaaad.reveal.event :as event]
            [vlaaad.reveal.pro.form.vignette :as vignette]
            [vlaaad.reveal.pro.form.copy-paste :as copy-paste]
            [vlaaad.reveal.font :as font]
            [cljfx.fx.menu-item :as fx.menu-item])
  (:import [javafx.scene.input KeyCode KeyEvent]
           [javafx.scene.control ComboBox]))

(defmethod event/handle ::select-enum [{:keys [value on-edit]}]
  (event/handle (assoc on-edit :fn #(assoc % :value value))))

(defn- view [values {:keys [edit on-edit form]}]
  (let [{:keys [value]} edit]
    {:fx/type vignette/view
     :edit edit
     :on-edit on-edit
     :form form
     :desc {:fx/type impl/menu-button
            :pseudo-classes #{:object}
            :text (pr-str value)
            :items (for [v values]
                     {:fx/type fx.menu-item/lifecycle
                      :text (pr-str v)
                      :on-action {::event/type ::select-enum
                                  :on-edit on-edit
                                  :value v}})}}))

(defn- edit [values x]
  {:value (if (and (impl/completely-undefined? x)
                   (= 1 (count values)))
            (first values)
            x)})

(defn value-editor [{:keys [values]}]
  (copy-paste/wrap
    (impl/make-editor
      :edit #(edit values %)
      :assemble :value
      :view #(view values %))))

