(ns vlaaad.reveal.pro.form.map-of
  "© 2021 Vladislav Protsenko. All rights reserved."
  (:require [vlaaad.reveal.pro.form.coll-of :as coll-of]
            [vlaaad.reveal.pro.form.tuple :as tuple]
            [vlaaad.reveal.pro.form.impl :as impl]
            [vlaaad.reveal.pro.form.compatible :as compatible]
            [vlaaad.reveal.pro.form.copy-paste :as copy-paste]
            [vlaaad.reveal.pro.form.vignette :as vignette]
            [vlaaad.reveal.event :as event]
            [cljfx.fx.button :as fx.button]
            [cljfx.fx.label :as fx.label]))

(defn- edit-entry [key-form val-form x]
  (let [[k v] (if (impl/completely-undefined? x)
                [impl/undefined impl/undefined]
                x)]
    {:key (impl/edit (:editor key-form) k)
     :val (impl/edit (:editor val-form) v)}))

(defmethod event/handle ::edit-entry [{:keys [at on-edit fn]}]
  (event/handle (assoc on-edit :fn #(update % at fn))))

(defn- view-entry [key-form val-form {:keys [form edit on-edit]}]
  (let [opts (->> form
                  :options
                  (map (fn [option] (update option :label #(str "Entry: " %)))))]
    {:fx/type impl/multi-line-view
     :children [{:fx/type impl/form-view
                 :form (update key-form :options (fnil into []) opts)
                 :edit (:key edit)
                 :on-edit {::event/type ::edit-entry
                           :at :key
                           :on-edit on-edit}}
                {:fx/type impl/form-view
                 :form (update val-form :options (fnil into []) opts)
                 :edit (:val edit)
                 :on-edit {::event/type ::edit-entry
                           :at :val
                           :on-edit on-edit}}]}))

(defn- entry-value-editor [key-form val-form]
  (impl/make-editor
    :edit #(edit-entry key-form val-form %)
    :assemble #(-> % impl/assemble-all (impl/fmap-result (juxt :key :val)))
    :view #(view-entry key-form val-form %)))

(defn- edit [content-editor coll]
  {:content (impl/edit content-editor coll)})

(defn- assemble [{:keys [content]}]
  (impl/fmap-result (impl/assemble content) #(into {} %)))

(defmethod event/handle ::edit-content [{:keys [on-edit fn]}]
  (event/handle (assoc on-edit :fn #(update % :content fn))))

(defn- view [{:keys [edit on-edit form]}]
  (let [{:keys [content]} edit]
    {:fx/type impl/multi-line-view
     :children [{:fx/type vignette/view
                 :edit edit
                 :on-edit on-edit
                 :form form
                 :main true
                 :desc {:fx/type fx.button/lifecycle
                        :style-class "reveal-form-input"
                        :pseudo-classes #{:object}
                        :text "{"}}
                {:fx/type impl/indent-view
                 :desc {:fx/type impl/content-view
                        :edit content
                        :on-edit {::event/type ::edit-content
                                  :on-edit on-edit}}}
                {:fx/type fx.label/lifecycle
                 :style-class "reveal-form-object"
                 :text "}"}]}))

(defn value-editor [{:keys [key-form val-form min-count max-count]
                     :as opts}]
  (let [content-editor (coll-of/content-editor
                         (assoc opts :item-form
                                     {:label (str (:label key-form) " -> " (:label val-form))
                                      :editor (entry-value-editor key-form val-form)}))]
    (-> (impl/make-editor
          :edit #(edit content-editor %)
          :assemble assemble
          :view view)
        (compatible/wrap map?)
        (copy-paste/wrap))))
