(ns vlaaad.reveal.pro.form.alt
  "© 2021 Vladislav Protsenko. All rights reserved."
  (:require [vlaaad.reveal.event :as event]
            [vlaaad.reveal.pro.form.impl :as impl]
            [vlaaad.reveal.pro.form.vignette :as vignette]
            [vlaaad.reveal.pro.form.copy-paste :as copy-paste]
            [vlaaad.reveal.font :as font])
  (:import [javafx.scene.input KeyCode KeyEvent]
           [javafx.scene.control ComboBox]
           [javafx.event Event]
           [javafx.scene Node]))

(defmethod event/handle ::select-alt [{:keys [alt on-edit]}]
  (let [[_ alt-form :as alt] alt]
    (event/handle (assoc on-edit :fn (fn [edit]
                                       (-> edit
                                           (assoc :alt alt)
                                           (cond-> (not (contains? (:edits edit) alt))
                                             (assoc-in [:edits alt] (impl/edit (:editor alt-form))))))))))

(defmethod event/handle ::edit-alt [{:keys [on-edit fn]}]
  (event/handle (assoc on-edit :fn #(update-in % [:edits (:alt %)] fn))))

(defn- view [alts {:keys [edit on-edit form]}]
  (let [{:keys [alt edits]} edit
        [_ alt-form] alt]
    {:fx/type impl/multi-line-view
     :children [{:fx/type vignette/view
                 :edit edit
                 :on-edit on-edit
                 :form form
                 :desc {:fx/type impl/menu-button
                        :pseudo-classes #{:control}
                        :text (pr-str (first alt))
                        :items (for [[k form :as alt] alts]
                                 {:fx/type :menu-item
                                  :on-action {::event/type ::select-alt :on-edit on-edit :alt alt}
                                  :graphic {:fx/type :h-box
                                            :spacing (font/char-width)
                                            :children [{:fx/type :label
                                                        :style-class "reveal-form-label"
                                                        :pseudo-classes #{:control}
                                                        :text (pr-str k)}
                                                       {:fx/type :label
                                                        :style-class "reveal-form-label"
                                                        :pseudo-classes #{:hint}
                                                        :text (:label form)}]}})}}
                {:fx/type impl/indent-view
                 :desc {:fx/type impl/form-view
                        :edit (get edits alt)
                        :on-edit {::event/type ::edit-alt
                                  :on-edit on-edit
                                  :alt alt}
                        :form alt-form}}]}))

(defn- edit [alts x]
  (let [[_ alt-form :as alt] (or (some (fn [[_ alt-form :as alt]]
                                         (when (impl/valid? alt-form x)
                                           alt))
                                       alts)
                                 (first alts))]
    {:alt alt
     :edits {alt (impl/edit (:editor alt-form) x)}}))

(defn- assemble [{:keys [alt edits]}]
  (impl/assemble (get edits alt)))

(defn value-editor [{:keys [alts]}]
  (copy-paste/wrap
    (impl/make-editor
      :edit #(edit alts %)
      :assemble assemble
      :view #(view alts %))))