(ns vlaaad.reveal.pro.sql
  (:require [vlaaad.reveal.action :as action]
            [vlaaad.reveal.pro.sql.connection :as conn]
            [vlaaad.reveal.pro.sql.schema-graph :as schema-graph]
            [clojure.string :as str])
  (:import [javax.sql DataSource]
           [java.io FileNotFoundException]
           [java.sql PreparedStatement DriverManager]
           [clojure.lang Associative]))

(defmacro ^:private when-ns [ns-sym & body]
  `(try
     (binding [*warn-on-reflection* false] ;; not our problem
       (require '~ns-sym))
     ~@body
     (catch FileNotFoundException _#)))

(defmacro db-explorer [conn-fn-expr]
  `(fn []
     (let [conn-fn# ~conn-fn-expr]
       {:fx/type schema-graph/view
        :schema (conn/query-schema! conn-fn#)
        :conn-fn conn-fn#})))

(def next-jdbc-explorer-fn
  (or (when-ns next.jdbc
        (let [get-ds (resolve 'next.jdbc.protocols/get-datasource)
              get-conn (resolve 'next.jdbc.protocols/get-connection)
              sourceable (resolve 'next.jdbc.protocols/Sourceable)]
          (fn [x]
            (when (or (and (string? x) (str/starts-with? x "jdbc:"))
                      (and (instance? Associative x)
                           (or (contains? x :jdbcUrl)
                               (and (contains? x :dbtype) (contains? x :dbname))))
                      (contains? (meta x) 'next.jdbc.protocols/get-datasource)
                      (->> sourceable
                           deref
                           :impls
                           keys
                           (remove #{Associative String})
                           (some #(instance? % x))))
              (db-explorer (let [ds (get-ds x)]
                             #(get-conn ds {})))))))
      (constantly nil)))

(def clojure-java-jdbc-explorer-fn
  (or (when-ns clojure.java.jdbc
        (let [get-conn (resolve 'clojure.java.jdbc/get-connection)]
          (fn [x]
            (when (or (and (map? x)
                           (or (and (contains? x :dbtype) (contains? x :dbname))
                               (contains? x :connection-uri)
                               (and (contains? x :subprotocol) (contains? x :subname))
                               (contains? x :factory)
                               (contains? x :datasource)))
                      (and (string? x)
                           (str/starts-with? x "jdbc:")))
              (db-explorer #(get-conn x))))))
      (constantly nil)))

(action/defaction ::action/db:explore [x]
  (or
    (next-jdbc-explorer-fn x)
    (clojure-java-jdbc-explorer-fn x)
    (when (instance? DataSource x)
      (db-explorer #(.getConnection ^DataSource x)))
    (when (and (string? x) (str/starts-with? x "jdbc:"))
      (db-explorer #(DriverManager/getConnection x)))))
