(ns vlaaad.reveal.pro.form.lazy
  "© 2021 Vladislav Protsenko. All rights reserved."
  (:require [vlaaad.reveal.pro.form.impl :as impl]
            [vlaaad.reveal.pro.form.vignette :as vignette]
            [vlaaad.reveal.event :as event]))

(defn- edit [pref-value-editor-fn x]
  (if (impl/completely-undefined? x)
    {:undefined true}
    (let [editor (pref-value-editor-fn)]
      {:defined (impl/edit editor x)
       :editor editor})))

(defn- assemble [{:keys [undefined defined]}]
  (if undefined
    impl/undefined
    (impl/assemble defined)))

(defmethod event/handle ::edit-defined [{:keys [on-edit fn]}]
  (event/handle (assoc on-edit :fn #(update % :defined fn))))

(defmethod event/handle ::define [{:keys [pref-editor-fn on-edit]}]
  (let [editor (pref-editor-fn)]
    (event/handle (assoc on-edit :fn #(-> %
                                          (dissoc :undefined)
                                          (assoc :defined (impl/edit editor)
                                                 :editor editor))))))

(defn- view [pref-value-editor-fn {:keys [edit on-edit form]}]
  (let [{:keys [undefined defined editor]} edit]
    (if undefined
      {:fx/type vignette/view
       :edit edit
       :on-edit on-edit
       :form form
       :desc {:fx/type :button
              :style-class "reveal-form-button"
              :text "+"
              :on-action {::event/type ::define
                          :pref-editor-fn pref-value-editor-fn
                          :on-edit on-edit}}}
      {:fx/type impl/form-view
       :form (assoc form :editor editor)
       :edit defined
       :on-edit {::event/type ::edit-defined
                 :on-edit on-edit}})))

(defn value-editor [pref-value-editor-fn]
  (impl/make-editor
    :edit #(edit pref-value-editor-fn %)
    :assemble assemble
    :view #(view pref-value-editor-fn %)))
