# match-with

A simple macro built on top of [core.match][1] intended to bring [Elixir's with][2]
special form to Clojure code.

NOTE: This software should be considered **alpha**. It should be a superset
of `core.match`. If you do spot a bug, send me an e-mail.

## Usage

At the most basic level, `with` behaves a lot like `let`:

    (require '[samps.match-with.core :refer [with]])
    (with [a 2
           b 2]
     (+ a b))

It's when you match against specific patterns that the macro becomes more useful.
For example:

    (with [{:ok user} (db/fetch-user db user-id)
           {:ok post} (db/save-post user title content)]
     {:ok [user post]})

In the example above, the body, `{:ok [user post]}`, will only be evaluated
if all matching clauses are matched correctly. That is, without `with`,
one could write the code above like so:

    (require '[clojure.core.match :refer [match]])
    (match (db/fetch-user db user-id)
     {:ok user}
     (match (db/save-post user title content)
       {:ok post}
       {:ok [user post]}

       on-err-2
       on-err-2)

     on-err-1
     on-err-1)

## But why?

Mostly, because it was fun. The `with` macro behaves similarly to the
`mlet` macro on [funcool.cats][3]. As I prefer to treat errors as values,
I started to lean more on either Cats or clojure.core.match. Since
the former has a little bit of baggage (i.e. monads are a bit hard for
folks to grok, in my experience) and I was already used to Elixir's
approach of just returning values and matching against them, I thought
it would be a fun weekend project to build this.

[1]: https://github.com/clojure/core.match
[2]: https://hexdocs.pm/elixir/1.12/Kernel.SpecialForms.html#with/1
[3]: https://github.com/funcool/cats