(ns railjure.readme-examples
  (:require
   [cognitect.anomalies :as a]
   [railjure.core :refer [! fail ok-let | ||]]))

(defn lookup [id]
  (if (< (rand) 0.9)
    {:id id :value (rand-int 1000)}
    (fail ::a/unavailable "'Timed out'")))

(defn alternate-lookup [id]
  (println "Expensive!")
  {:id id :value (rand-int 1000)})

(defn transform [entity]
  (update entity :value inc))

(defn- errorf [_f _fmt & _args])

(defn write-to-db [{:keys [id value]}]
  (if (< (rand) 0.9)
    (printf "Wrote %d as %d%n" id value)
    (fail ::a/conflict)))

(defn example-1a [id]
  (-> id
      (| lookup
         (fn [_failure id _body] (alternate-lookup id)))
      (| transform
         !)
      (| write-to-db
         (fn [failure transformed _body]
           (errorf failure "Failed to save resulting value: %s"
                   (pr-str transformed))))))

(defn example-1b [id]
  (let [entity (try
                 (lookup id)
                 (catch Exception _ (alternate-lookup id)))
        transformed (transform entity)]
    (try
      (write-to-db entity)
      (catch Exception e
        (errorf e "Failed to save resulting value: %s"
                (pr-str transformed))))))

(defn example-2 [id]
  (ok-let [entity (| id lookup
                     (fn [_failure id _body] (alternate-lookup id)))
           transformed (transform entity)]
    (| transformed write-to-db
       (fn [failure transformed _body]
         (errorf failure "Failed to save resulting transformed value:%n%s%n(was: %s)"
                 (pr-str transformed) (pr-str entity))
         failure))
    transformed))

(defn example-3 [coll]
  (->> coll
       (|| (mapv inc) !)
       (|| (mapv transform) !)))
