(ns hooks.railjure.core
  (:require
   [clj-kondo.hooks-api :refer [list-node token-node] :as hapi]))

(def ^:private placeholder (list-node ()))

(defn | [{:keys [node]}]
  (let [[expr form recovery] (rest (:children node))
        [inv & args] (or (not-empty (:children form))
                         [form])
        exp-form (list-node (list* inv expr args))
        exp-recovery (list-node (list recovery placeholder expr exp-form))]
    {:node (list-node (list (token-node '|) placeholder exp-form exp-recovery))
     :expr expr :inv inv :form form :recovery recovery}))

;; TODO: Deduplicate
(defn || [{:keys [node]}]
  (let [[form recovery expr] (rest (:children node))
        [inv & args] (or (not-empty (:children form))
                         [form])
        exp-form (list-node (concat (list* inv args) [expr]))
        exp-recovery (list-node (list recovery placeholder expr exp-form))]
    {:node (list-node (list (token-node '||) exp-form exp-recovery placeholder))}))

(comment
  (require '[clj-kondo.core :as k]
           '[zprint.core :as zp :refer [zprint-file-str]])
  (defn apply-hook [hook-var code-str]
    (-> {:node (hapi/parse-string code-str)}
        hook-var
        :node
        str
        (zprint-file-str (:name (meta hook-var)))
        println))
  (def problem-a
    "(|| (mapv inc) ! (range 10))")
  (def problem-b
    "(-> id
         (| lookup attempt-alternate-lookup)
         (| transform !)
         (| write-to-db log-db-write-failure))")
  (def problem-c
    "(| (| (| id
             lookup attempt-alternate-lookup)
          transform !)
       write-to-db log-db-write-failure)")
  (apply-hook #'|| problem-a)
  (apply-hook #'| problem-b))
