(defproject dev.nathantuggy/railjure "0.1.0"
  :description "Simple, obvious, boring failure handling"
  :url "https://github.com/tuggyne/railjure"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[com.cognitect/anomalies "0.1.12"]]
  :plugins [[lein-cloverage "1.2.4"]
            [lein-shell "0.5.0"]
            [lein-ancient "0.7.0"]
            [lein-changelog "0.3.2"]]
  :profiles {:dev {:dependencies [[org.clojure/clojure "1.12.1"]
                                  [org.clojure/test.check "1.1.1"]
                                  [clj-kondo "2025.06.05"]
                                  [criterium "0.4.6"]
                                  [com.gfredericks/test.chuck "0.2.15"]
                                  [zprint "1.3.0"]]}}
  :deploy-repositories [["releases" :clojars]]
  :aliases {"update-readme-version" ["shell" "sed" "-i" "s/\\\\[dev\\.nathantuggy\\\\/railjure \"[0-9.]*\"\\\\]/[dev\\.nathantuggy\\\\/railjure \"${:version}\"]/" "README.md"]}
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["changelog" "release"]
                  ["update-readme-version"]
                  ["vcs" "commit"]
                  ["vcs" "tag"]
                  ["deploy"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]])
