(ns server.test
  (:use compojure.core clojure.java.io)
  (:require
    [less.awful.ssl :as less-awful] 
    [compojure.route :as route]    
    [singular.web :as webserver]
    [singular.web.ssl :as tls]
    [singular.acme :as cert]
    ))
  
(println "Jézus a király!")

(defn app "A basic route for learning."
  [request]
  {:status 200
   :body "Hello world!"})

(defn default "Webserver one-liner" [] (webserver/run app {:port 8080}))

(defn secure "Webserver using TLS (SSL as you know it)"
  []
  (webserver/run
    app
    {:port 8080
     :ssl-port 4343
     :keystore (resource "test.keystore")
     :key-password "password"}))

(def ssl-context1 (tls/keystore->ssl-context {:keystore (resource "server.keystore") :key-password "password"}))
(def ssl-context2 (tls/keystore->ssl-context {:keystore (resource "test.keystore") :key-password "password"}))

(defn party "Webserver using TLS with SNI support (For multiple domains)"
  []
  (webserver/run
    app
    {:port 80
     :ssl-port 443
     :host "0.0.0.0" ;wildcard for all domains
     :sni
     {"example.com" ssl-context1 ;add them to '/etc/hosts' to try out
      "example.org" ssl-context2}
     :default-ssl-context ssl-context2 ;use default as fallback
     }))

(defn shopping "Get certificate by Let's Encrypt manually"
  []
  (cert/guide {:domain "yourdomain.com" :organisation "Your Company" :test? true})
  )

(defn gathering "Getting certificates automatically"
  []    
  (webserver/run
    app
    {;:port 80        ;80 is default when using SNI
     ;:ssl-port 443   ;443 is default when using SNI
     ;:host "0.0.0.0" ;0.0.0.0 is default when using SNI
     :certificates "certificates/"
     :sni
     {"igen.cloud" ssl-context1
      "igen.host" :auto
      "igen.dev" :auto}
     :default-ssl-context ssl-context2}))

(defn merriment "Semi-automatized way"
  []
  (webserver/run
    app
    {;:certificates "certificates/" ;"certificates/" is the default
     :sni
     {"igen.cloud" ssl-context1
      ;"igen.host" :auto
      ;"igen.dev" :auto
      true :auto} ;Searches and uses all valid certificates under the provided certificates directory
     :default-ssl-context ssl-context2}))

(defn wingding "Insanely fun automatized way (One-liners rock!)"
  []
  (webserver/run app {:sni :full-auto}))


