(ns server.test
  (:use compojure.core clojure.java.io)
  (:require
    [less.awful.ssl :as less-awful] 
    [compojure.route :as route]    
    [singular.web :as webserver]
    [singular.web.ssl :as tls]
    [singular.acme :as cert]
    ))
  
(println "Jézus a király!")

(defn app "A basic route for learning."
  [request]
  {:status 200
   :body "Hello world!"})

(defn default "Webserver one-liner" [] (webserver/run app {:port 8080}))

(defn secure "Webserver using TLS (SSL as you know it)"
  []
  (webserver/run
    app
    {:port 8080
     :ssl-port 4343
     :keystore (resource "test.keystore")
     :key-password "password"}))

(def ssl-context1 (tls/keystore->ssl-context {:keystore (resource "server.keystore") :key-password "password"}))
(def ssl-context2 (tls/keystore->ssl-context {:keystore (resource "test.keystore") :key-password "password"}))

(defn party "Webserver using TLS with SNI support (For multiple domains)"
  []
  (webserver/run
    app
    {:port 80
     :ssl-port 443
     :host "0.0.0.0" ;wildcard for all domains
     :sni
     {"example.com" ssl-context1 ;add them to '/etc/hosts'
      "example.org" ssl-context2}
     :default-ssl-context ssl-context2}))

(defn shopping
  []
  (cert/guide {:domain "yourdomain.com" :organisation "Your Company" :test? true})
  )

