;; Copyright 2014-2017 Red Hat, Inc, and individual contributors.
;; SPDX-License-Identifier: Apache-2.0

(ns ^:no-doc ^:internal
    singular.web.internal.headers
  (:require [clojure.string :as str]))

(def ^:internal default-encoding "ISO-8859-1")

(defprotocol Headers
  (get-names [x])
  (get-values [x key])
  (get-value [x key])
  (set-header [x key value])
  (add-header [x key value]))

(defn ^:internal headers->map [headers]
  (persistent!
    (reduce
      (fn [accum ^String name]
        (assoc! accum
          (-> name .toLowerCase)
          (->> name
            (get-values headers)
            (str/join ","))))
      (transient {})
      (get-names headers))))

(defn ^:internal set-headers
  [output, headers]
  (doseq [[^String k, v] headers]
    (if (coll? v)
      (doseq [value v]
        (add-header output k (str value)))
      (set-header output k (str v)))))
