(ns server.test
  (:use compojure.core clojure.java.io)
  (:require
    [less.awful.ssl :as less-awful] 
    [compojure.route :as route]    
    [singular.web :as webserver]
    [singular.web.ssl :as tls]
    [certificaat.kung-fu :as cert]
    [certificaat.interface.cli :as cert-cli]
    [certificaat.util.configuration :as cert-conf]
    ))
  
(println "Jézus a király!")

(defn app "A basic route for learning."
  [request]
  {:status 200
   :body "Hello world!"})

(defn default "Webserver one-liner" [] (webserver/run app {:port 8080}))

(defn secure "Webserver using TLS (SSL as you know it)"
  []
  (webserver/run
    app
    {:port 8080
     :ssl-port 4343
     :keystore (resource "test.keystore")
     :key-password "password"}))

(def ssl-context1 (tls/keystore->ssl-context {:keystore (resource "server.keystore") :key-password "password"}))
(def ssl-context2 (tls/keystore->ssl-context {:keystore (resource "test.keystore") :key-password "password"}))

(defn party "Webserver using TLS with SNI support (For multiple domains)"
  []
  (webserver/run
    app
    {:port 80
     :ssl-port 443
     :host "0.0.0.0" ;wildcard for all domains
     :sni
     {"example.com" ssl-context1 ;add them to '/etc/hosts'
      "example.org" ssl-context2}
     :default-ssl-context ssl-context2}))

(defn default-cert-configuration
  [domain]
  {:config-dir "resources/certificates/"
   :domain domain
   :san #{(str "www."domain)}
   :keypair-filename "account.key"
   :key-type :rsa
   :key-size 2048
   :acme-uri "acme://letsencrypt.org/staging" ; in production, use acme://letsencrypt.org
   :organisation "ChangeMe corporation"
   :contact (str "mailto:admin@"domain)
   :challenges #{"http-01"}
   :hooks [:before-challenge :after-request] ; hooks to inject before challenges and after certificate request
   :plugins {:webroot {:enabled false
                       :path "/tmp"}
             :httpd {:enabled false}
             :diffie-hellman {:enabled false
                              :modulus 2048
                              :filename "dhparam.pem"
                              :group14 true}
             :email {:enabled false
                     :smtp {:host (str "smtp."domain)
                            :user "changeme"
                            :pass "changeme"
                            :port 587}
                     :sendmail false}}})

(defn get-cert
  [domain]
  (let [config 
        {:config-dir "resources/certificates/"
         :domain domain}]
    (cert-cli/run (merge (cert-conf/read-config config) config))))

(defn shopping "Prepare with certificates before party"
  []
  (do
    (cert/setup (default-cert-configuration "example.com"))
    (get-cert "example.com")
    ))





