package dev.goodpay.ir.interfaces.common.validator;

import java.util.function.Predicate;
import java.util.regex.Pattern;

public class ValidationUtils {
    public static final Predicate<String> sortCodePredicate = Pattern.compile("^([0-9]{6})$|^([0-9]{2}-[0-9]{2}-[0-9]{2})$").asPredicate();
    public static final Pattern everythingButNumbersPattern = Pattern.compile("[^0-9.]+");

    public static boolean isValidSortCode(final String sortCode) {
        return sortCodePredicate.test(sortCode);
    }

    public static String normaliseSortCode(final String sortCode) {
        return everythingButNumbersPattern.matcher(sortCode)
            .replaceAll("");
    }
}
