package dev.goodpay.ir.interfaces.issuer.v1.validator;

import dev.goodpay.ir.interfaces.common.ContractValidationResult;
import dev.goodpay.ir.interfaces.common.ValidationError;
import dev.goodpay.ir.interfaces.common.validator.ValidationUtils;
import dev.goodpay.ir.interfaces.common.validator.Validator;
import dev.goodpay.ir.interfaces.issuer.v1.methods.fps.IssuerFPSDetailsV1;
import dev.goodpay.ir.interfaces.issuer.v1.methods.fps.SortCodeV1;
import org.apache.commons.lang3.StringUtils;

public class IssuerFPSDetailsValidator implements Validator<IssuerFPSDetailsV1> {

    public IssuerFPSDetailsValidator() {
    }

    @Override
    public ContractValidationResult validateCreate(final IssuerFPSDetailsV1 fpsDetails) {
        final ContractValidationResult validationResult = new ContractValidationResult();
        if (fpsDetails.getIssuerId() == null) {
            validationResult.registerError(ValidationError.missing("issuerId"));
        }
        if (fpsDetails.getSortCodes() == null || fpsDetails.getSortCodes().size() == 0) {
            validationResult.registerError(ValidationError.missing("sortCodes"));
        } else {
            fpsDetails.getSortCodes().forEach(sortCode -> validateSortCode(sortCode, validationResult));
        }
        return validationResult;
    }

    private void validateSortCode(final SortCodeV1 sortCode, final ContractValidationResult validationResult) {
        final String sortCodeString = sortCode.getSortCode();
        if (StringUtils.isBlank(sortCode.getSortCode())) {
            validationResult.registerError(ValidationError.missing("sortCodes.sortCode"));
        } else {
            final boolean isValidSortCode = ValidationUtils.isValidSortCode(sortCodeString);
            if (!isValidSortCode) {
                validationResult.registerError(ValidationError.invalid("sortCodes.sortCode",
                    "sortCode is invalid" + sortCodeString));
            }
        }
        if (StringUtils.isBlank(sortCode.getBranchName())) {
            validationResult.registerError(ValidationError.missing("sortCodes.branchName"));
        }
    }
}
