/*
 * Decompiled with CFR 0.152.
 */
package dev.goodpay.ir.interfaces.common;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Country {
    GB("United Kingdom", "gb", "gbr", "826"),
    UNKNOWN("unknown", "unknown", "unknown", "-1");

    public static final Set<Country> CACHED_VALUES;
    public static final Map<String, Country> BY_ISO2_CODE;
    public static final Map<String, Country> BY_ISO3_CODE;
    public static final Map<String, Country> BY_NUMERIC3_CODE;
    private final String name;
    private final String iso2Code;
    private final String iso3Code;
    private final String numeric3Code;

    private Country(String name, String iso2Code, String iso3Code, String numeric3Code) {
        this.name = name;
        this.iso2Code = iso2Code;
        this.iso3Code = iso3Code;
        this.numeric3Code = numeric3Code;
    }

    public String getName() {
        return this.name;
    }

    public String getIso2Code() {
        return this.iso2Code;
    }

    public String getIso3Code() {
        return this.iso3Code;
    }

    public String getNumeric3Code() {
        return this.numeric3Code;
    }

    static {
        CACHED_VALUES = Arrays.stream(Country.values()).collect(Collectors.toSet());
        BY_ISO2_CODE = CACHED_VALUES.stream().collect(Collectors.toMap(o -> o.iso2Code, Function.identity()));
        BY_ISO3_CODE = CACHED_VALUES.stream().collect(Collectors.toMap(o -> o.iso3Code.toLowerCase(Locale.ROOT), Function.identity()));
        BY_NUMERIC3_CODE = CACHED_VALUES.stream().filter(currency -> currency.getNumeric3Code() != null).collect(Collectors.toMap(Country::getNumeric3Code, Function.identity()));
    }
}

