package dev.goodpay.ir.interfaces.common;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(exclude = {"details"})
public class ValidationError {
    private ErrorType errorType;
    private String details;
    private String field;

    public static ValidationError missing(final String field) {
        return new ValidationError().setErrorType(ErrorType.MISSING).setField(field);
    }

    public static ValidationError invalid(final String field, final String details) {
        return new ValidationError().setErrorType(ErrorType.INVALID).setField(field).setDetails(details);
    }

    public static ValidationError conflict(final String field) {
        return new ValidationError().setErrorType(ErrorType.CONFLICT).setField(field);
    }

    public static ValidationError invalid(final String field) {
        return invalid(field, null);
    }


}
