package dev.goodpay.ir.interfaces.common;

import lombok.Data;

import java.util.HashSet;
import java.util.Set;

@Data
public class ContractValidationResult {
    private Set<ValidationError> errors;
    private boolean isValid;

    public ContractValidationResult() {
        errors = new HashSet<>();
        isValid = true;
    }

    public ContractValidationResult registerError(final ValidationError validationError) {
        this.errors.add(validationError);
        this.isValid = false;
        return this;
    }

}
