(ns toddler.i18n.common
  (:require
   [toddler.i18n.keyword :refer [add-translations]]))

(add-translations
 (merge
  #:not-available {:default "N/A" :hr "-" :es "-" :de "-" :fr "-"}
  #:open {:default "Open" :hr "Otvori" :es "Abrir" :de "Öffnen" :fr "Ouvrir"}
  #:neutral {:default "Neutral" :hr "Neutralan" :es "Neutral" :de "Neutral" :fr "Neutre"}
  #:positive {:default "Positive" :hr "Pozitivan" :es "Positivo" :de "Positiv" :fr "Positif"}
  #:negative {:default "Negative" :hr "Negativan" :es "Negativo" :de "Negativ" :fr "Négatif"}
  #:warn {:default "Warning" :hr "Upozorenje" :es "Advertencia" :de "Warnung" :fr "Avertissement"}
  #:ok {:default "OK" :hr "OK" :es "OK" :de "OK" :fr "OK"}
  #:cancel {:default "Cancel" :hr "Odbaci" :es "Cancelar" :de "Abbrechen" :fr "Annuler"}
  #:add {:default "Add" :hr "Dodaj" :es "Añadir" :de "Hinzufügen" :fr "Ajouter"}
  #:delete {:default "Delete" :hr "Izbriši" :es "Eliminar" :de "Löschen" :fr "Supprimer"}
  #:remove {:default "Remove" :hr "Ukloni" :es "Eliminar" :de "Entfernen" :fr "Supprimer"}
  #:first-name {:default "First Name" :hr "Ime" :es "Nombre" :de "Vorname" :fr "Prénom"}
  #:last-name {:default "Last Name" :hr "Prezime" :es "Apellido" :de "Nachname" :fr "Nom"}
  #:address {:default "Address" :hr "Adresa" :es "Dirección" :de "Adresse" :fr "Adresse"}
  #:post-code {:default "Post Code" :hr "Poštanski kod" :es "Código Postal" :de "Postleitzahl" :fr "Code Postal"}
  #:credit-card {:default "Credit Card" :hr "Kreditna kartica" :es "Tarjeta de Crédito" :de "Kreditkarte" :fr "Carte de Crédit"}
  #:image {:default "Image" :hr "Slika" :es "Imagen" :de "Bild" :fr "Image"}
  #:example {:default "Example" :hr "Primjer" :es "Ejemplo" :de "Beispiel" :fr "Exemple"}
  #:examples {:default "Examples" :hr "Primjeri" :es "Ejemplos" :de "Beispiele" :fr "Exemples"}
  #:result {:default "Result" :de "Ergebnis" :fr "Résultat" :es "Resultado" :hr "Rezultat"}
  #:locale {:default "English"
            :af            "Afrikaans"
            :am            "አማርኛ"
            :ar            "العربية"
            :ar_DZ         "العربية (الجزائر)"
            :ar_EG         "العربية (مصر)"
            :ar_EG_u_nu_la "العربية (مصر, لاتيني)"
            :az            "Azərbaycan"
            :be            "Беларуская"
            :bg            "Български"
            :bn            "বাংলা"
            :bn_u_nu_latn  "বাংলা (ল্যাটিন)"
            :br            "Brezhoneg"
            :bs            "Bosanski"
            :ca            "Català"
            :chr           "ᏣᎳᎩ"
            :cs            "Čeština"
            :cy            "Cymraeg"
            :da            "Dansk"
            :de            "Deutsch"
            :de_AT         "Deutsch (Österreich)"
            :de_CH         "Deutsch (Schweiz)"
            :el            "Ελληνικά"
            :en            "English"
            :en_AU         "English (Australia)"
            :en_CA         "English (Canada)"
            :en_GB         "English (UK)"
            :en_IE         "English (Ireland)"
            :en_IN         "English (India)"
            :en_SG         "English (Singapore)"
            :en_US         "English (USA)"
            :en_ZA         "English (South Africa)"
            :es            "Español"
            :es_419        "Español (Latinoamérica)"
            :es_ES         "Español (España)"
            :es_MX         "Español (México)"
            :es_US         "Español (EE.UU.)"
            :et            "Eesti"
            :eu            "Euskara"
            :fa            "فارسی"
            :fa_u_nu_latn  "فارسی (لاتین)"
            :fi            "Suomi"
            :fil           "Filipino"
            :fr            "Français"
            :fr_CA         "Français (Canada)"
            :ga            "Gaeilge"
            :gl            "Galego"
            :gsw           "Schwiizerdütsch"
            :gu            "ગુજરાતી"
            :haw           "ʻŌlelo Hawaiʻi"
            :he            "עברית"
            :hi            "हिन्दी"
            :hr            "Hrvatski"
            :hu            "Magyar"
            :hy            "Հայերեն"
            :id            "Bahasa Indonesia"
            :in            "Bahasa Indonesia"
            :is            "Íslenska"
            :it            "Italiano"
            :iw            "עברית"
            :ja            "日本語"
            :ka            "ქართული"
            :kk            "Қазақша"
            :km            "ភាសាខ្មែរ"
            :kn            "ಕನ್ನಡ"
            :ko            "한국어"
            :ky            "Кыргызча"
            :ln            "Lingála"
            :lo            "ພາສາລາວ"
            :lt            "Lietuvių"
            :lv            "Latviešu"
            :mk            "Македонски"
            :ml            "മലയാളം"
            :mn            "Монгол"
            :mo            "Moldovenească"
            :mr            "मराठी"
            :mr_u_nu_latn  "मराठी (लॅटिन)"
            :ms            "Bahasa Melayu"
            :mt            "Malti"
            :my            "မြန်မာစာ"
            :my_u_nu_latn  "မြန်မာစာ (လက်တင်)"
            :nb            "Norsk Bokmål"
            :ne            "नेपाली"
            :ne_u_nu_latn  "नेपाली (लॅटिन)"
            :nl            "Nederlands"
            :no            "Norsk"
            :no_NO         "Norsk (Norge)"
            :or            "ଓଡ଼ିଆ"
            :pa            "ਪੰਜਾਬੀ"
            :pl            "Polski"
            :pt            "Português"
            :pt_BR         "Português (Brasil)"
            :pt_PT         "Português (Portugal)"
            :ro            "Română"
            :ru            "Русский"
            :sh            "Srpskohrvatski"
            :si            "සිංහල"
            :sk            "Slovenčina"
            :sl            "Slovenščina"
            :sq            "Shqip"
            :sr            "Српски"
            :sr_Latn       "Srpski (Latinica)"
            :sv            "Svenska"
            :sw            "Kiswahili"
            :ta            "தமிழ்"
            :te            "తెలుగు"
            :th            "ไทย"
            :tl            "Tagalog"
            :tr            "Türkçe"
            :u_nu_latn     "Latin"
            :uk            "Українська"
            :ur            "اردو"
            :uz            "Oʻzbek"
            :vi            "Tiếng Việt"
            :zh            "中文"
            :zh_CN         "中文 (中国)"
            :zh_HK         "中文 (香港)"
            :zh_TW         "中文 (台灣)"
            :zu            "IsiZulu"}))
