(ns
 toddler.material.two-tone
 (:refer-clojure
  :exclude
  [merge
   map
   loop
   cast
   repeat
   shuffle
   sync
   remove
   sort
   send
   compare
   filter
   update
   print
   list
   commute
   class
   comment
   key])
 (:require [helix.core] [helix.dom]))


(helix.core/defnc
 agriculture
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M4,9h5c0-1.1-0.9-2-2-2H4C3.45,7,3,7.45,3,8C3,8.55,3.45,9,4,9z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M22,14.06V8c0-1.1-0.9-2-2-2h-6.29l-1.06-1.06l1.41-1.41l-0.71-0.71L9.82,6.35l0.71,0.71l1.41-1.41L13,6.71V9 c0,1.1-0.9,2-2,2H8.96c-0.22-0.16-0.45-0.3-0.69-0.43l-0.4,0.89l-0.46-0.21l0.4-0.9C7.26,10.13,6.64,10,6,10 c-0.53,0-1.04,0.11-1.52,0.26l0.34,0.91l-0.47,0.18L4,10.42c-1.06,0.46-1.91,1.28-2.43,2.31l0.89,0.4l-0.21,0.46l-0.9-0.4 C1.13,13.74,1,14.36,1,15c0,0.53,0.11,1.04,0.26,1.52l0.91-0.34l0.18,0.47L1.42,17c0.46,1.06,1.28,1.91,2.31,2.43l0.4-0.89 l0.46,0.21l-0.4,0.9C4.74,19.87,5.36,20,6,20c0.53,0,1.04-0.11,1.52-0.26l-0.34-0.91l0.47-0.18L8,19.58 c1.06-0.46,1.91-1.28,2.43-2.31l-0.89-0.4l0.21-0.46l0.9,0.4c0.1-0.26,0.18-0.54,0.24-0.82h5.16C16.03,16.16,16,16.33,16,16.5 c0,1.93,1.57,3.5,3.5,3.5s3.5-1.57,3.5-3.5C23,15.55,22.62,14.69,22,14.06z M6,18c-1.66,0-3-1.34-3-3s1.34-3,3-3s3,1.34,3,3 S7.66,18,6,18z M10.87,14c-0.04-0.18-0.08-0.35-0.13-0.52l-0.91,0.34l-0.18-0.47L10.58,13c0,0,0.42,0,0.42,0c2.21,0,4-1.79,4-4V8 h5v5.05C19.84,13.03,19.67,13,19.5,13c-0.95,0-1.81,0.38-2.44,1H10.87z M19.5,18c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5 s1.5,0.67,1.5,1.5S20.33,18,19.5,18z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:opacity ".3",
      :d
      "M20,13.05V8h-5v1c0,2.21-1.79,4-4,4c0,0-0.42,0-0.42,0c0.14,0.32,0.25,0.65,0.32,1h6.16 c0.63-0.62,1.49-1,2.44-1C19.67,13,19.84,13.03,20,13.05z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 diamond
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "8.88,5 6.24,5 4.74,8 7.38,8",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "19.26,8 17.76,5 15.12,5 16.62,8",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,16.68 11,10 5.44,10",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "13,16.68 18.56,10 13,10",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "12.88,5 11.12,5 9.62,8 14.38,8",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5L2,9l10,12L22,9L19,3z M17.76,5l1.5,3h-2.65l-1.5-3H17.76z M6.24,5h2.65l-1.5,3H4.74L6.24,5z M11,16.68L5.44,10H11 V16.68z M9.62,8l1.5-3h1.76l1.5,3H9.62z M13,16.68V10h5.56L13,16.68z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-library
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 17.13v-6.95c-2.1.38-4.05 1.35-5.64 2.83L12 14.28l-1.36-1.27C9.05 11.53 7.1 10.56 5 10.18v6.95c2.53.34 4.94 1.3 7 2.83 2.07-1.52 4.47-2.49 7-2.83z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2", :opacity ".3", :cy "5", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M16 5c0-2.21-1.79-4-4-4S8 2.79 8 5s1.79 4 4 4 4-1.79 4-4zm-6 0c0-1.1.9-2 2-2s2 .9 2 2-.9 2-2 2-2-.9-2-2zM3 19c3.48 0 6.64 1.35 9 3.55 2.36-2.19 5.52-3.55 9-3.55V8c-3.48 0-6.64 1.35-9 3.55C9.64 9.35 6.48 8 3 8v11zm2-8.82c2.1.38 4.05 1.35 5.64 2.83L12 14.28l1.36-1.27c1.59-1.48 3.54-2.45 5.64-2.83v6.95c-2.53.34-4.93 1.3-7 2.82-2.06-1.52-4.47-2.49-7-2.83v-6.94z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 connecting-airports
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15.4,17l1.3,4.4h-1.1L13,17h-3c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h3l2.6-4.4h1.1L15.4,15h2.85L19,14h1l-0.6,2l0.6,2h-1 l-0.75-1H15.4z M5.75,7L5,6H4l0.6,2L4,10h1l0.75-1H8.6l-1.3,4.4h1.1L11,9h3c0.55,0,1-0.45,1-1s-0.45-1-1-1h-3L8.4,2.6H7.3L8.6,7 H5.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 traffic
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M9 19h6V5H9v14zm3-13c.83 0 1.5.67 1.5 1.5S12.83 9 12 9s-1.5-.67-1.5-1.5S11.17 6 12 6zm0 4.5c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zm0 4.5c.83 0 1.5.67 1.5 1.5S12.83 18 12 18s-1.5-.67-1.5-1.5.67-1.5 1.5-1.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 5h-3V4c0-.55-.45-1-1-1H8c-.55 0-1 .45-1 1v1H4c0 1.86 1.28 3.41 3 3.86V10H4c0 1.86 1.28 3.41 3 3.86V15H4c0 1.86 1.28 3.41 3 3.86V20c0 .55.45 1 1 1h8c.55 0 1-.45 1-1v-1.14c1.72-.45 3-2 3-3.86h-3v-1.14c1.72-.45 3-2 3-3.86h-3V8.86c1.72-.45 3-2 3-3.86zm-5 14H9V5h6v14zm-3-1c.83 0 1.5-.67 1.5-1.5S12.83 15 12 15s-1.5.67-1.5 1.5.67 1.5 1.5 1.5zm0-4.5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5.67 1.5 1.5 1.5zM12 9c.83 0 1.5-.67 1.5-1.5S12.83 6 12 6s-1.5.67-1.5 1.5S11.17 9 12 9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crisis-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14.5,2.5c0,1.5-1.5,6-1.5,6h-2c0,0-1.5-4.5-1.5-6C9.5,1.12,10.62,0,12,0S14.5,1.12,14.5,2.5z M12,10c-1.1,0-2,0.9-2,2 s0.9,2,2,2s2-0.9,2-2S13.1,10,12,10z M16.08,5.11c0.18-0.75,0.33-1.47,0.39-2.06C19.75,4.69,22,8.08,22,12c0,5.52-4.48,10-10,10 S2,17.52,2,12c0-3.92,2.25-7.31,5.53-8.95C7.6,3.64,7.74,4.37,7.92,5.11C5.58,6.51,4,9.07,4,12c0,4.42,3.58,8,8,8s8-3.58,8-8 C20,9.07,18.42,6.51,16.08,5.11z M18,12c0,3.31-2.69,6-6,6s-6-2.69-6-6c0-2,0.98-3.77,2.48-4.86c0.23,0.81,0.65,2.07,0.65,2.07 C8.43,9.93,8,10.92,8,12c0,2.21,1.79,4,4,4s4-1.79,4-4c0-1.08-0.43-2.07-1.13-2.79c0,0,0.41-1.22,0.65-2.07C17.02,8.23,18,10,18,12 z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bakery-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M7.6,8.67l-2.01,0.8c-0.22,0.09-0.34,0.31-0.31,0.54l2.4,5.98h1.23l-0.62-6.9C8.25,8.75,7.91,8.54,7.6,8.67 z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M3.07,16.1c-0.27,0.53,0.29,1.09,0.82,0.83l1.68-0.84l-1.08-2.71L3.07,16.1z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M13.36,6.99h-2.71c-0.27,0-0.53,0.23-0.5,0.54l0.77,8.45h2.17l0.77-8.45C13.88,7.22,13.63,6.99,13.36,6.99z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M18.41,9.47l-2.01-0.8c-0.31-0.12-0.65,0.09-0.68,0.42l-0.62,6.9h1.23l2.4-5.98 C18.75,9.78,18.63,9.56,18.41,9.47z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M19.52,13.39l-1.08,2.7l1.68,0.84c0.52,0.26,1.09-0.3,0.82-0.83L19.52,13.39z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.5,10.94c0.13-0.32,0.1-0.23,0.15-0.39c0.3-1.21-0.34-2.47-1.5-2.93l-2.01-0.8c-0.46-0.18-0.95-0.21-1.41-0.12 c-0.11-0.33-0.29-0.63-0.52-0.89C14.73,5.29,14.06,5,13.36,5h-2.71C9.94,5,9.27,5.29,8.8,5.81C8.56,6.07,8.38,6.37,8.27,6.69 C7.81,6.6,7.32,6.63,6.86,6.81l-2.01,0.8c-1.16,0.46-1.8,1.72-1.5,2.93l0.15,0.38C1.1,15.55,1,15.55,1,16.38 c0,0.91,0.46,1.74,1.24,2.22c1.42,0.88,2.49,0.14,4-0.61h11.53c1.52,0.76,1.86,1.01,2.63,1.01c1,0,2.61-0.77,2.61-2.61 C23,15.54,22.88,15.51,20.5,10.94z M3.88,16.93c-0.53,0.26-1.09-0.3-0.82-0.83l1.41-2.72l1.08,2.71L3.88,16.93z M7.68,15.99 l-2.4-5.98C5.25,9.78,5.37,9.56,5.59,9.47l2.01-0.8c0.31-0.12,0.65,0.08,0.68,0.42l0.62,6.9H7.68z M13.09,15.99h-2.17l-0.77-8.45 c-0.03-0.31,0.23-0.54,0.5-0.54h2.71c0.27,0,0.53,0.23,0.5,0.54L13.09,15.99z M16.32,15.99h-1.23l0.62-6.9 c0.03-0.33,0.37-0.54,0.68-0.42l2.01,0.8c0.22,0.09,0.34,0.31,0.31,0.54L16.32,15.99z M20.12,16.93l-1.68-0.84l1.08-2.7l1.41,2.71 C21.21,16.63,20.64,17.19,20.12,16.93z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 signpost
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d "M6,6h11.17l1,1l-1,1H6V6z M18,16H6.83l-1-1l1-1H18V16z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M13,10h5l3-3l-3-3h-5V2h-2v2H4v6h7v2H6l-3,3l3,3h5v4h2v-4h7v-6h-7V10z M6,6h11.17l1,1l-1,1H6V6z M18,16H6.83l-1-1l1-1H18 V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 departure-board
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M9.29 6H9c-3.69 0-5.11.46-5.66.99h5.74c.05-.33.12-.67.21-.99zM3 14v4c0 .37.21.62.34.73l.29.27h10.74l.29-.27c.13-.11.34-.36.34-.73v-3.08c-.94-.13-1.81-.45-2.59-.92H3zm2.5 4c-.83 0-1.5-.67-1.5-1.5S4.67 15 5.5 15s1.5.67 1.5 1.5S6.33 18 5.5 18zm8.5-1.5c0 .83-.67 1.5-1.5 1.5s-1.5-.67-1.5-1.5.67-1.5 1.5-1.5 1.5.67 1.5 1.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "16.5", :cx "5.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "16.5", :cx "12.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M16 1c-2.39 0-4.49 1.2-5.75 3.02C9.84 4.01 9.43 4 9 4c-4.42 0-8 .5-8 4v10c0 .88.39 1.67 1 2.22V22c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1h8v1c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1.78c.61-.55 1-1.34 1-2.22v-3.08c3.39-.49 6-3.39 6-6.92 0-3.87-3.13-7-7-7zM9 6h.29c-.09.32-.16.66-.21.99H3.34C3.89 6.46 5.31 6 9 6zM3 8.99h6.08c.16 1.11.57 2.13 1.18 3.01H3V8.99zM15 18c0 .37-.21.62-.34.73l-.29.27H3.63l-.29-.27C3.21 18.62 3 18.37 3 18v-4h9.41c.78.47 1.65.79 2.59.92V18zm1-5c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm.5-9H15v5l3.62 2.16.75-1.23-2.87-1.68z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 moped
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M4,13v1h4v-3H6C4.9,11,4,11.9,4,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,7c0-1.1-0.9-2-2-2h-3v2h3v2.65L13.52,14H10V9H6c-2.21,0-4,1.79-4,4v3h2c0,1.66,1.34,3,3,3s3-1.34,3-3h4.48L19,10.35V7 z M7,17c-0.55,0-1-0.45-1-1h2C8,16.55,7.55,17,7,17z M8,14H4v-1c0-1.1,0.9-2,2-2h2V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6", :x "5", :width "5", :height "2", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M19,13c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,13,19,13z M19,17c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S19.55,17,19,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 u-turn-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6,9v12h2V9c0-2.21,1.79-4,4-4s4,1.79,4,4v4.17l-1.59-1.59L13,13l4,4l4-4l-1.41-1.41L18,13.17V9c0-3.31-2.69-6-6-6 S6,5.69,6,9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 forest
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "16.48,10 18.16,10 15,5.49 13.22,8.03 16,12 14.14,12 16.71,16 20.34,16",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "12.16,10 9,5.49 5.84,10 7.52,10 3.66,16 14.34,16 10.48,10",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.14,12H22L15,2l-3,4.29L9,2L2,12h1.86L0,18h7v4h4v-4h2v4h4v-4h7L20.14,12z M3.66,16l3.86-6H5.84L9,5.49L12.16,10h-1.68 l3.86,6H3.66z M16.71,16l-2.57-4H16l-2.78-3.97L15,5.49L18.16,10h-1.68l3.86,6H16.71z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-walk
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.5 5.5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zM9.8 8.9L7 23h2.1l1.8-8 2.1 2v6h2v-7.5l-2.1-2 .6-3C14.8 12 16.8 13 19 13v-2c-1.9 0-3.5-1-4.3-2.4l-1-1.6c-.56-.89-1.68-1.25-2.65-.84L6 8.3V13h2V9.6l1.8-.7",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 miscellaneous-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.17,13.71l1.4-2.42c0.09-0.15,0.05-0.34-0.08-0.45l-1.48-1.16c0.03-0.22,0.05-0.45,0.05-0.68s-0.02-0.46-0.05-0.69 l1.48-1.16c0.13-0.11,0.17-0.3,0.08-0.45l-1.4-2.42c-0.09-0.15-0.27-0.21-0.43-0.15L12,4.83c-0.36-0.28-0.75-0.51-1.18-0.69 l-0.26-1.85C10.53,2.13,10.38,2,10.21,2h-2.8C7.24,2,7.09,2.13,7.06,2.3L6.8,4.15C6.38,4.33,5.98,4.56,5.62,4.84l-1.74-0.7 c-0.16-0.06-0.34,0-0.43,0.15l-1.4,2.42C1.96,6.86,2,7.05,2.13,7.16l1.48,1.16C3.58,8.54,3.56,8.77,3.56,9s0.02,0.46,0.05,0.69 l-1.48,1.16C2,10.96,1.96,11.15,2.05,11.3l1.4,2.42c0.09,0.15,0.27,0.21,0.43,0.15l1.74-0.7c0.36,0.28,0.75,0.51,1.18,0.69 l0.26,1.85C7.09,15.87,7.24,16,7.41,16h2.8c0.17,0,0.32-0.13,0.35-0.3l0.26-1.85c0.42-0.18,0.82-0.41,1.18-0.69l1.74,0.7 C13.9,13.92,14.08,13.86,14.17,13.71z M8.81,11c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2s2,0.9,2,2C10.81,10.1,9.91,11,8.81,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.92,18.67l-0.96-0.74c0.02-0.14,0.04-0.29,0.04-0.44c0-0.15-0.01-0.3-0.04-0.44l0.95-0.74 c0.08-0.07,0.11-0.19,0.05-0.29l-0.9-1.55c-0.05-0.1-0.17-0.13-0.28-0.1l-1.11,0.45c-0.23-0.18-0.48-0.33-0.76-0.44l-0.17-1.18 C18.73,13.08,18.63,13,18.53,13h-1.79c-0.11,0-0.21,0.08-0.22,0.19l-0.17,1.18c-0.27,0.12-0.53,0.26-0.76,0.44l-1.11-0.45 c-0.1-0.04-0.22,0-0.28,0.1l-0.9,1.55c-0.05,0.1-0.04,0.22,0.05,0.29l0.95,0.74c-0.02,0.14-0.03,0.29-0.03,0.44 c0,0.15,0.01,0.3,0.03,0.44l-0.95,0.74c-0.08,0.07-0.11,0.19-0.05,0.29l0.9,1.55c0.05,0.1,0.17,0.13,0.28,0.1l1.11-0.45 c0.23,0.18,0.48,0.33,0.76,0.44l0.17,1.18c0.02,0.11,0.11,0.19,0.22,0.19h1.79c0.11,0,0.21-0.08,0.22-0.19l0.17-1.18 c0.27-0.12,0.53-0.26,0.75-0.44l1.12,0.45c0.1,0.04,0.22,0,0.28-0.1l0.9-1.55C22.03,18.86,22,18.74,21.92,18.67z M17.63,18.83 c-0.74,0-1.35-0.6-1.35-1.35s0.6-1.35,1.35-1.35s1.35,0.6,1.35,1.35S18.37,18.83,17.63,18.83z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 wrong-location
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,11c0,0.07,0,0.13,0,0.2c0,2.34-1.95,5.44-6,9.14c-4.05-3.7-6-6.79-6-9.14C6,7.57,8.65,5,12,5c0.34,0,0.68,0.03,1,0.08 V3.06C12.67,3.02,12.34,3,12,3c-4.2,0-8,3.22-8,8.2c0,3.32,2.67,7.25,8,11.8c5.33-4.55,8-8.48,8-11.8c0-0.07,0-0.13,0-0.2H18z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "11", :cx "12", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points
      "22.54,2.88 21.12,1.46 19,3.59 16.88,1.46 15.46,2.88 17.59,5 15.46,7.12 16.88,8.54 19,6.41 21.12,8.54 22.54,7.12 20.41,5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-road
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "20,18 20,15 18,15 18,18 15,18 15,20 18,20 18,23 20,23 20,20 23,20 23,18",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "18",
      :width "2",
      :height "9",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "4",
      :width "2",
      :height "16",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "16",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 not-listed-location
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:fill-opacity ".3",
    :d
    "M18.5 10.2c0 2.57-2.1 5.79-6.16 9.51l-.34.3-.34-.31C7.6 15.99 5.5 12.77 5.5 10.2c0-3.84 2.82-6.7 6.5-6.7s6.5 2.85 6.5 6.7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12.01 16c-.27 0-.52-.1-.71-.29-.2-.2-.29-.43-.29-.71-.01-.55.43-.99.98-1h.02c.28 0 .51.1.71.29.18.19.28.43.28.7s-.1.51-.29.71-.43.3-.7.3zm-.88-3.66c0-.45.1-.84.29-1.16.19-.33.53-.7 1-1.12.28-.25.48-.47.61-.66s.19-.4.19-.64c0-.29-.11-.53-.32-.74-.21-.2-.5-.3-.85-.3-.37 0-.74.1-.96.3-.21.2-.4.45-.4.98H9c0-1.01.46-1.73.97-2.21C10.53 6.28 11.25 6 12 6c.59 0 1.11.12 1.57.35.88.43 1.43 1.33 1.43 2.31 0 .49-.1.9-.31 1.25s-.48.71-.89 1.09c-.32.3-.53.56-.65.77s-.18.49-.18.81V13h-1.85v-.66h.01zM18 10.2C18 6.57 15.35 4 12 4s-6 2.57-6 6.2c0 2.34 1.95 5.44 6 9.14 4.05-3.7 6-6.8 6-9.14zM12 2c4.2 0 8 3.22 8 8.2 0 3.32-2.67 7.25-8 11.8-5.33-4.55-8-8.48-8-11.8C4 5.22 7.8 2 12 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 attractions
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1.5",
      :opacity ".3",
      :cy "12.02",
      :cx "11.98",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.15,14.42c0.23-0.77,0.35-1.58,0.35-2.42s-0.12-1.65-0.35-2.42c0.78-0.6,1.02-1.7,0.51-2.58 c-0.51-0.88-1.58-1.23-2.49-0.85c-1.11-1.17-2.56-2.03-4.18-2.42C13.85,2.75,13.01,2,12,2s-1.85,0.75-1.98,1.73 C8.39,4.12,6.95,4.98,5.83,6.15C4.92,5.77,3.85,6.12,3.34,7C2.83,7.88,3.07,8.98,3.85,9.58C3.62,10.35,3.5,11.16,3.5,12 s0.12,1.65,0.35,2.42c-0.78,0.6-1.02,1.7-0.51,2.58c0.51,0.88,1.58,1.23,2.49,0.85c0.4,0.42,0.83,0.79,1.3,1.12L5.78,22h1.88 l0.98-2.19c0.44,0.19,0.9,0.34,1.38,0.46C10.15,21.25,10.99,22,12,22s1.85-0.75,1.98-1.73c0.46-0.11,0.91-0.26,1.34-0.44L16.3,22 h1.88l-1.34-3c0.48-0.34,0.93-0.72,1.34-1.15c0.91,0.38,1.99,0.03,2.49-0.85S20.93,15.02,20.15,14.42z M13.56,18.75 C13.19,18.29,12.63,18,12,18s-1.2,0.29-1.57,0.75c-0.4-0.09-0.79-0.21-1.16-0.37l1.43-3.19c0.4,0.16,0.84,0.25,1.3,0.25 c0.44,0,0.87-0.08,1.26-0.23l1.42,3.18C14.32,18.54,13.95,18.66,13.56,18.75z M10.48,12.02c0-0.83,0.67-1.5,1.5-1.5 c0.83,0,1.5,0.67,1.5,1.5s-0.67,1.5-1.5,1.5C11.15,13.52,10.48,12.85,10.48,12.02z M18.71,14.01c-0.61,0.07-1.18,0.41-1.52,0.99 c-0.32,0.56-0.34,1.2-0.12,1.75c-0.28,0.29-0.58,0.55-0.9,0.79l-1.5-3.35c0.49-0.59,0.78-1.34,0.78-2.16 c0-1.89-1.55-3.41-3.46-3.41c-1.91,0-3.46,1.53-3.46,3.41c0,0.8,0.28,1.54,0.75,2.13l-1.52,3.39c-0.31-0.23-0.6-0.48-0.87-0.76 C7.15,16.23,7.13,15.57,6.8,15c-0.34-0.59-0.93-0.94-1.56-0.99c-0.22-0.68-0.33-1.4-0.33-2.15c0-0.64,0.09-1.26,0.25-1.85 c0.66-0.03,1.3-0.38,1.65-1c0.37-0.63,0.35-1.38,0.01-1.98C7.74,6.05,8.93,5.34,10.27,5c0.34,0.59,0.99,1,1.73,1s1.39-0.4,1.73-1 c1.34,0.34,2.53,1.07,3.44,2.05C16.85,7.64,16.84,8.38,17.2,9c0.35,0.6,0.96,0.95,1.6,1c0.16,0.59,0.25,1.21,0.25,1.86 C19.05,12.61,18.93,13.33,18.71,14.01z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 brunch-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M20,10h-2v1.47c0,0.95,0.37,1.89,1.03,2.6c0.63-0.71,0.97-1.61,0.97-2.56V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2,21.5C2,21.78,2.22,22,2.49,22h13.02c0.27,0,0.49-0.22,0.49-0.5V20H2V21.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.47,15.45c0.99-1.07,1.53-2.48,1.53-3.94V2h-6v9.47c0,1.48,0.58,2.92,1.6,4l0.4,0.42V22h4v-2h-2v-4.03L20.47,15.45z M18,4h2v4h-2V4z M19.03,14.07c-0.65-0.71-1.03-1.65-1.03-2.6V10h2v1.51C20,12.46,19.66,13.36,19.03,14.07z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.5,16H11v-2H7v2H2.5C2.22,16,2,16.22,2,16.5V18h14v-1.5C16,16.22,15.78,16,15.5,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 handyman
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/polygon
      {:points
       "8.66,14.64 4.41,18.88 5.12,19.59 9.36,15.34 9.36,15.34 8.66,14.64",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/rect
      {:y "14.11",
       :x "16.57",
       :width "1",
       :transform
       "matrix(0.7071 -0.7071 0.7071 0.7071 -7.0983 17.0848)",
       :height "6",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M21.67,18.17l-5.3-5.3h-0.99l-2.54,2.54v0.99l5.3,5.3c0.39,0.39,1.02,0.39,1.41,0l2.12-2.12 C22.06,19.2,22.06,18.56,21.67,18.17z M18.84,19.59l-4.24-4.24l0.71-0.71l4.24,4.24L18.84,19.59z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M17.34,10.19l1.41-1.41l2.12,2.12c1.17-1.17,1.17-3.07,0-4.24l-3.54-3.54l-1.41,1.41V1.71L15.22,1l-3.54,3.54l0.71,0.71 h2.83l-1.41,1.41l1.06,1.06l-2.89,2.89L7.85,6.48V5.06L4.83,2.04L2,4.87l3.03,3.03h1.41l4.13,4.13l-0.85,0.85H7.6l-5.3,5.3 c-0.39,0.39-0.39,1.02,0,1.41l2.12,2.12c0.39,0.39,1.02,0.39,1.41,0l5.3-5.3v-2.12l5.15-5.15L17.34,10.19z M9.36,15.34 l-4.24,4.24l-0.71-0.71l4.24-4.24l0,0L9.36,15.34L9.36,15.34z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 two-wheeler
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0",
     :x "0",
     :width "24",
     :height "24",
     :fill-rule "evenodd",
     :fill "none",
     :stroke nil})
   (helix.dom/path
    {:d
     "M4.17,11L4.17,11C4.12,11,4.06,11,4,11H4.17 M13.41,5H9v2h3.59l2,2H11l-4,2L5,9H0v2h4c-2.21,0-4,1.79-4,4 c0,2.21,1.79,4,4,4c2.21,0,4-1.79,4-4l2,2h3l3.49-6.1l1.01,1.01C16.59,12.64,16,13.75,16,15c0,2.21,1.79,4,4,4c2.21,0,4-1.79,4-4 c0-2.21-1.79-4-4-4c-0.18,0-0.36,0.03-0.53,0.05L17.41,9H20V6l-3.72,1.86L13.41,5L13.41,5z M20,17c-1.1,0-2-0.9-2-2 c0-1.1,0.9-2,2-2c1.1,0,2,0.9,2,2C22,16.1,21.1,17,20,17L20,17z M4,17c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2c1.1,0,2,0.9,2,2 C6,16.1,5.1,17,4,17L4,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 add-location
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :enable-background "new",
    :d
    "M18.5,10.2c0,2.57-2.1,5.79-6.16,9.51L12,20.01l-0.34-0.31 C7.6,15.99,5.5,12.77,5.5,10.2c0-3.84,2.82-6.7,6.5-6.7S18.5,6.35,18.5,10.2z",
    :stroke nil,
    :fill nil})
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13,6v3h3v2h-3v3h-2v-3H8V9h3V6H13z M18,10.2C18,6.57,15.35,4,12,4s-6,2.57-6,6.2c0,2.34,1.95,5.44,6,9.14 C16.05,15.64,18,12.54,18,10.2z M12,2c4.2,0,8,3.22,8,8.2c0,3.32-2.67,7.25-8,11.8c-5.33-4.55-8-8.48-8-11.8C4,5.22,7.8,2,12,2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-scooter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M7.82,16H15v-1c0-2.21,1.79-4,4-4h0.74l-1.9-8.44C17.63,1.65,16.82,1,15.89,1H12v2h3.89l1.4,6.25c0,0-0.01,0-0.01,0 c-2.16,0.65-3.81,2.48-4.19,4.75H7.82c-0.48-1.34-1.86-2.24-3.42-1.94c-1.18,0.23-2.13,1.2-2.35,2.38C1.7,16.34,3.16,18,5,18 C6.3,18,7.4,17.16,7.82,16z M5,16c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S5.55,16,5,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,12c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,12,19,12z M19,16c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S19.55,16,19,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,20 7,20 13,23 13,21 17,21 11,18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 turn-sharp-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6,6.83L4.41,8.41L3,7l4-4l4,4L9.59,8.41L8,6.83V13h8c1.1,0,2,0.9,2,2v6h-2v-6H8c-1.1,0-2-0.9-2-2V6.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-printshop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M8 5h8v3H8zm11 5H5c-.55 0-1 .45-1 1v4h2v-2h12v2h2v-4c0-.55-.45-1-1-1zm-1 2.5c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 8h-1V3H6v5H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zM8 5h8v3H8V5zm8 14H8v-4h8v4zm4-4h-2v-2H6v2H4v-4c0-.55.45-1 1-1h14c.55 0 1 .45 1 1v4z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "11.5", :cx "18", :stroke nil, :fill nil})))


(helix.core/defnc
 restaurant
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 6v8h3v8h2V2c-2.76 0-5 2.24-5 4zm-5 3H9V2H7v7H5V2H3v7c0 2.21 1.79 4 4 4v9h2v-9c2.21 0 4-1.79 4-4V2h-2v7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cleaning-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "3",
      :x "11",
      :width "2",
      :opacity ".3",
      :height "8",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M16,13H8c-1.65,0-3,1.35-3,3v5h2v-3c0-0.55,0.45-1,1-1s1,0.45,1,1v3h2v-3c0-0.55,0.45-1,1-1s1,0.45,1,1v3h2 v-3c0-0.55,0.45-1,1-1s1,0.45,1,1v3h2v-5C19,14.35,17.65,13,16,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,11h-1V3c0-1.1-0.9-2-2-2h-2C9.9,1,9,1.9,9,3v8H8c-2.76,0-5,2.24-5,5v7h18v-7C21,13.24,18.76,11,16,11z M11,3h2v8h-2V3 z M19,21h-2v-3c0-0.55-0.45-1-1-1s-1,0.45-1,1v3h-2v-3c0-0.55-0.45-1-1-1s-1,0.45-1,1v3H9v-3c0-0.55-0.45-1-1-1s-1,0.45-1,1v3H5 v-5c0-1.65,1.35-3,3-3h8c1.65,0,3,1.35,3,3V21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 tire-repair
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,8c-0.55,0-1-0.45-1-1c0-0.28,0.11-0.53,0.29-0.71c0.4-0.4,2.46-1.04,2.46-1.04s-0.64,2.06-1.04,2.46 C19.53,7.89,19.28,8,19,8z M20,13v5c0,1.65-1.35,3-3,3s-3-1.35-3-3v-2c0-0.55-0.45-1-1-1s-1,0.45-1,1v3c0,1.1-0.9,2-2,2H4 c-1.1,0-2-0.9-2-2V5c0-1.1,0.9-2,2-2h6c1.1,0,2,0.9,2,2v8.17c0.31-0.11,0.65-0.17,1-0.17c1.65,0,3,1.35,3,3v2c0,0.55,0.45,1,1,1 s1-0.45,1-1v-5h-1l0-1.42c-1.77-0.77-3-2.53-3-4.58c0-2.76,2.24-5,5-5s5,2.24,5,5c0,2.05-1.23,3.81-3,4.58L21,13H20z M22,7 c0-1.66-1.34-3-3-3s-3,1.34-3,3s1.34,3,3,3S22,8.66,22,7z M10,7L8,9V6.17L9.17,5H4.83L6,6.17V9L4,7v2.17l2,2V14l-2-2v2.17l2,2V19 l-2-2v2h6v-2l-2,2v-2.83l2-2V12l-2,2v-2.83l2-2V7z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M10,7L8,9V6.17L9.17,5H4.83L6,6.17V9L4,7v2.17l2,2V14l-2-2v2.17l2,2V19l-2-2v2h6v-2l-2,2v-2.83l2-2V12l-2,2 v-2.83l2-2V7z M19,4c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,4,19,4z M19.71,7.71C19.53,7.89,19.28,8,19,8 c-0.55,0-1-0.45-1-1c0-0.28,0.11-0.53,0.29-0.71c0.4-0.4,2.46-1.04,2.46-1.04S20.11,7.31,19.71,7.71z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fastfood
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M1 21.98c0 .56.45 1.01 1.01 1.01H15c.56 0 1.01-.45 1.01-1.01V21H1v.98z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M8.5 10.99c-1.42 0-3.77.46-4.88 2.01h9.77c-1.12-1.55-3.47-2.01-4.89-2.01z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8.5 8.99C4.75 8.99 1 11 1 15h15c0-4-3.75-6.01-7.5-6.01zM3.62 13c1.11-1.55 3.47-2.01 4.88-2.01s3.77.46 4.88 2.01H3.62zM1 17h15v2H1zM18 5V1h-2v4h-5l.23 2h9.56l-1.4 14H18v2h1.72c.84 0 1.53-.65 1.63-1.47L23 5h-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-laundry-service
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5.99 4L6 20h12V4H5.99c.01 0 0 0 0 0zM11 5c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM8 5c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm4 4c2.76 0 5 2.24 5 5s-2.24 5-5 5-5-2.24-5-5 2.24-5 5-5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18 2.01L6 2c-1.11 0-2 .89-2 2v16c0 1.11.89 2 2 2h12c1.11 0 2-.89 2-2V4c0-1.11-.89-1.99-2-1.99zM18 20H6L5.99 4H18v16z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle {:r "1", :cy "6", :cx "8", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "11", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 19c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm2.36-7.36c1.3 1.3 1.3 3.42 0 4.72-1.3 1.3-3.42 1.3-4.72 0l4.72-4.72z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 medical-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d "M4,20h16V8H4V20z M8,13h3v-3h2v3h3v2h-3v3h-2v-3H8V13z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M20,6h-4V4c0-1.1-0.9-2-2-2h-4C8.9,2,8,2.9,8,4v2H4C2.9,6,2,6.9,2,8v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8 C22,6.9,21.1,6,20,6z M10,4h4v2h-4V4z M20,20H4V8h16V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "11,18 13,18 13,15 16,15 16,13 13,13 13,10 11,10 11,13 8,13 8,15 11,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "m3.01 12 9 9L21 12l-9-9-8.99 9zM14 7.5l3.5 3.5-3.5 3.5V12h-4v3H8v-4c0-.55.45-1 1-1h5V7.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M13.42 1.58c-.75-.75-2.07-.76-2.83 0l-9 9c-.78.78-.78 2.04 0 2.82l9 9c.39.39.9.58 1.41.58.51 0 1.02-.19 1.41-.58l8.99-8.99c.78-.76.79-2.03.02-2.82l-9-9.01zm-1.41 19.41-9-9 9-9 9 9-9 9zM8 11v4h2v-3h4v2.5l3.5-3.5L14 7.5V10H9c-.55 0-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-car-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M5,17h14v-5H5V17z M16.5,13c0.83,0,1.5,0.67,1.5,1.5S17.33,16,16.5,16 S15,15.33,15,14.5S15.67,13,16.5,13z M7.5,13C8.33,13,9,13.67,9,14.5S8.33,16,7.5,16S6,15.33,6,14.5S6.67,13,7.5,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.92,6.01C18.72,5.42,18.16,5,17.5,5h-11C5.84,5,5.29,5.42,5.08,6.01L3,12v8c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-1 h12v1c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-8L18.92,6.01z M6.85,7h10.29l1.04,3H5.81L6.85,7z M19,17H5v-5h14V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "7.5", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "16.5", :stroke nil, :fill nil})))))


(helix.core/defnc
 edit-location
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14.11,14h-0.83H10H8v-2V8.74V7.91l0.59-0.59L11.91,4C8.61,4.05,6,6.6,6,10.2c0,2.34,1.95,5.44,6,9.14 c4.05-3.7,6-6.79,6-9.14c0-0.03,0-0.06,0-0.08l-3.3,3.3L14.11,14z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18.17,4.91L17.1,3.84l-5.55,5.55v1.08h1.08L18.17,4.91z M16,2.74l1.29-1.29c0.58-0.59,1.52-0.59,2.11-0.01 c0,0,0.01,0.01,0.01,0.01l1.15,1.15c0.59,0.59,0.59,1.54,0,2.12L19.88,5.4l-0.02,0.02L19.28,6l-6,6H10V8.74L16,2.74z M13.72,2.19 l-0.55,0.55L11.9,4.01C8.6,4.06,6,6.61,6,10.21c0,2.34,1.95,5.44,6,9.14c4.05-3.7,6-6.79,6-9.14v-0.1l1.8-1.8 c0.13,0.6,0.2,1.24,0.2,1.9c0,3.32-2.67,7.25-8,11.8c-5.33-4.55-8-8.48-8-11.8c0-4.98,3.8-8.2,8-8.2 C12.58,2.01,13.16,2.07,13.72,2.19z",
    :stroke nil,
    :fill nil})
  (helix.dom/polygon
   {:points "18.17,4.91 17.1,3.84 11.55,9.39 11.55,10.47 12.63,10.47",
    :opacity ".3",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 roundabout-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10.08,8c0.48-2.84,2.94-5,5.92-5c3.31,0,6,2.69,6,6c0,2.97-2.16,5.44-5,5.92L17,21h-2l0-6.09c0-0.98,0.71-1.8,1.67-1.97 C18.56,12.63,20,10.98,20,9c0-2.21-1.79-4-4-4c-1.98,0-3.63,1.44-3.94,3.33C11.89,9.29,11.07,10,10.09,10l-4.26,0l1.59,1.59L6,13 L2,9l4-4l1.41,1.41L5.83,8L10.08,8z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-shipping
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 15h.78c.55-.61 1.34-1 2.22-1s1.67.39 2.22 1H15V6H3v9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17 8V4H3c-1.1 0-2 .9-2 2v11h2c0 1.66 1.34 3 3 3s3-1.34 3-3h6c0 1.66 1.34 3 3 3s3-1.34 3-3h2v-5l-3-4h-3zM6 18c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm9-3H8.22c-.55-.61-1.33-1-2.22-1s-1.67.39-2.22 1H3V6h12v9zm3 3c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-6V9.5h2.5l1.96 2.5H17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-railway-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    {:enable-background "new"}
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M6,15.5C6,16.33,6.67,17,7.5,17h9c0.83,0,1.5-0.67,1.5-1.5V12H6V15.5z M12,13 c0.83,0,1.5,0.67,1.5,1.5S12.83,16,12,16s-1.5-0.67-1.5-1.5S11.17,13,12,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M12,4C8.48,4,7.03,4.48,6.43,5h11.24C17.13,4.46,15.71,4,12,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C8,2,4,2.5,4,6v9.5C4,17.43,5.57,19,7.5,19L6,20v1h12v-1l-1.5-1c1.93,0,3.5-1.57,3.5-3.5V6C20,2.5,16.42,2,12,2z M12,4c3.71,0,5.13,0.46,5.67,1H6.43C7.03,4.48,8.48,4,12,4z M18,15.5c0,0.83-0.67,1.5-1.5,1.5h-9C6.67,17,6,16.33,6,15.5V12h12 V15.5z M18,10H6V7h12V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 egg
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,5c-1.93,0-5,4.91-5,9c0,2.76,2.24,5,5,5s5-2.24,5-5C17,9.91,13.93,5,12,5z M13,18c-3.01,0-5-2-5-5 c0-0.55,0.45-1,1-1s1,0.45,1,1c0,2.92,2.42,3,3,3c0.55,0,1,0.45,1,1S13.55,18,13,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,3C8.5,3,5,9.33,5,14c0,3.87,3.13,7,7,7c3.87,0,7-3.13,7-7C19,9.33,15.5,3,12,3z M12,19c-2.76,0-5-2.24-5-5 c0-4.09,3.07-9,5-9s5,4.91,5,9C17,16.76,14.76,19,12,19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13,16c-0.58,0-3-0.08-3-3c0-0.55-0.45-1-1-1s-1,0.45-1,1c0,3,1.99,5,5,5c0.55,0,1-0.45,1-1S13.55,16,13,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 turn-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17.17,11l-1.59,1.59L17,14l4-4l-4-4l-1.41,1.41L17.17,9L9,9c-1.1,0-2,0.9-2,2v9h2v-9L17.17,11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 remove-road
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "4",
      :x "18",
      :width "2",
      :height "9",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "4",
      :width "2",
      :height "16",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "16",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "22.5,16.41 21.09,15 19,17.09 16.91,15 15.5,16.41 17.59,18.5 15.5,20.59 16.91,22 19,19.91 21.09,22 22.5,20.59 20.41,18.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-business
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "15.36,9 3.64,9 3.04,12 15.96,12",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "2",
      :width "15",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15,17h2v-3h1v-2l-1-5H2l-1,5v2h1v6h9v-6h4V17z M9,18H4v-4h5V18z M3.04,12l0.6-3h11.72l0.6,3H3.04z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20,18 20,15 18,15 18,18 15,18 15,20 18,20 18,23 20,23 20,20 23,20 23,18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-bike
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,7h-0.82l-1.7-4.68C16.19,1.53,15.44,1,14.6,1H12v2h2.6l1.46,4h-4.81l-0.36-1H12V4H7v2h1.75l1.82,5H9.9 C9.46,8.77,7.59,7.12,5.25,7.01C2.45,6.87,0,9.2,0,12c0,2.8,2.2,5,5,5c2.46,0,4.45-1.69,4.9-4h4.2c0.44,2.23,2.31,3.88,4.65,3.99 c2.8,0.13,5.25-2.19,5.25-5C24,9.2,21.8,7,19,7z M7.82,13c-0.4,1.17-1.49,2-2.82,2c-1.68,0-3-1.32-3-3s1.32-3,3-3 c1.33,0,2.42,0.83,2.82,2H5v2H7.82z M14.1,11h-1.4l-0.73-2H15C14.56,9.58,14.24,10.25,14.1,11z M19,15c-1.68,0-3-1.32-3-3 c0-0.93,0.41-1.73,1.05-2.28l0.96,2.64l1.88-0.68l-0.97-2.67C18.94,9.01,18.97,9,19,9c1.68,0,3,1.32,3,3S20.68,15,19,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,20 7,20 13,23 13,21 17,21 11,18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 hardware
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d "M6.77,6H11v5h2V5H9C8.11,5,7.32,5.39,6.77,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "13",
      :x "11",
      :width "2",
      :opacity ".3",
      :height "6",
      :enable-background "new",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,3l-3,3V3H9C6.24,3,4,5.24,4,8h5v12c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1V8l3,3h2V3H18z M13,19h-2v-6h2V19z M13,11 h-2V6H6.77C7.32,5.39,8.11,5,9,5h4V11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 car-crash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d
       "M17.91,13c0.06,0.16,0.09,0.33,0.09,0.5c0,0.83-0.67,1.5-1.5,1.5S15,14.33,15,13.5c0-0.39,0.15-0.74,0.39-1 c-0.86-0.35-1.63-0.86-2.29-1.5H5v5h14v-3.07C18.67,12.98,18.39,13,17.91,13z M7.5,15C6.67,15,6,14.33,6,13.5S6.67,12,7.5,12 S9,12.67,9,13.5S8.33,15,7.5,15z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18.5,7h-1V3h1V7z M18.5,8v1h-1V8H18.5z M6,13.5 C6,12.67,6.67,12,7.5,12S9,12.67,9,13.5S8.33,15,7.5,15S6,14.33,6,13.5z M19,12.93c0.65-0.09,1.34-0.28,2-0.6h0V19 c0,0.55-0.45,1-1,1h-1c-0.55,0-1-0.45-1-1v-1H6v1c0,0.55-0.45,1-1,1H4c-0.55,0-1-0.45-1-1v-8l2.08-5.99C5.29,4.42,5.84,4,6.5,4 l4.79,0C11.1,4.63,11,5.31,11,6H6.85L5.81,9h5.86v0c0.36,0.75,0.84,1.43,1.43,2L5,11v5h14L19,12.93z M17.91,13 c-0.89-0.01-1.74-0.19-2.53-0.51C15.15,12.76,15,13.11,15,13.5c0,0.83,0.67,1.5,1.5,1.5s1.5-0.67,1.5-1.5 C18,13.32,17.97,13.16,17.91,13z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 transfer-within-a-station
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.49 13.75L14 16.25l2.49 2.5V17H22v-1.5h-5.51zm3.02 6H14v1.5h5.51V23L22 20.5 19.51 18zM7.5 3.5c0 1.1.9 2 2 2s2-.9 2-2-.9-2-2-2-2 .9-2 2zm2.05 6.9C10.85 12 12.8 13 15 13v-2c-1.85 0-3.45-1-4.35-2.45l-.95-1.6C9.35 6.35 8.7 6 8 6c-.25 0-.5.05-.75.15L2 8.3V13h2V9.65l1.75-.75L3 23h2.1l1.75-8L9 17v6h2v-7.55L8.95 13.4l.6-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-grocery-store
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M8.53 11h7.02l2.76-5H6.16z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M7 18c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-1.45-5c.75 0 1.41-.41 1.75-1.03l3.58-6.49c.37-.66-.11-1.48-.87-1.48H5.21l-.94-2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2h7.45zM6.16 6h12.15l-2.76 5H8.53L6.16 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-transfer
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :enable-background "new",
    :d
    "M14.83,12H18v3.17L14.83,12z M9.17,12l5,5H6.63l-0.29-0.27 C6.21,16.62,6,16.37,6,16v-4H9.17z M10,14.5c0-0.83-0.67-1.5-1.5-1.5S7,13.67,7,14.5C7,15.33,7.67,16,8.5,16S10,15.33,10,14.5z M7.82,4.99h9.83C17.11,4.46,15.69,4,12,4C9.6,4,8.17,4.2,7.31,4.48L7.82,4.99z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8.5,13c0.83,0,1.5,0.67,1.5,1.5S9.33,16,8.5,16S7,15.33,7,14.5S7.67,13,8.5,13z M7.31,4.48C8.17,4.2,9.6,4,12,4 c3.69,0,5.11,0.46,5.66,0.99H7.82l2,2H18V10h-5.17l2,2H18v3.17l1.81,1.81C19.92,16.67,20,16.35,20,16V6c0-3.5-3.58-4-8-4 C9.48,2,7.24,2.16,5.78,2.95L7.31,4.48z M19.78,22.61l-1.64-1.64C18.09,20.98,18.05,21,18,21h-1c-0.55,0-1-0.45-1-1v-1H8v1 c0,0.55-0.45,1-1,1H6c-0.55,0-1-0.45-1-1v-1.78C4.39,17.67,4,16.88,4,16V6.83L1.39,4.22l1.41-1.41l18.38,18.38L19.78,22.61z M6,8.83 V10h1.17L6,8.83z M14.17,17l-5-5H6v4c0,0.37,0.21,0.62,0.34,0.73L6.63,17H8H14.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-activity
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4.01 8.54C5.2 9.23 6 10.52 6 12s-.81 2.77-2 3.46V18h16v-2.54c-1.19-.69-2-1.99-2-3.46s.81-2.77 2-3.46V6H4l.01 2.54zm6.72 1.68L12 7l1.26 3.23 3.47.2-2.69 2.2.89 3.37L12 14.12 9.07 16l.88-3.37-2.69-2.2 3.47-.21z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-1.99.9-1.99 2v4c1.1 0 1.99.9 1.99 2s-.89 2-2 2v4c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-4c-1.1 0-2-.9-2-2s.9-2 2-2V6c0-1.1-.9-2-2-2zm0 4.54c-1.19.69-2 1.99-2 3.46s.81 2.77 2 3.46V18H4v-2.54c1.19-.69 2-1.99 2-3.46 0-1.48-.8-2.77-1.99-3.46L4 6h16v2.54zM9.07 16L12 14.12 14.93 16l-.89-3.36 2.69-2.2-3.47-.21L12 7l-1.27 3.22-3.47.21 2.69 2.2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flight-class
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/rect
   {:y "6",
    :x "14",
    :width "2",
    :opacity ".3",
    :height "5",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16,4h-2c-1.1,0-2,0.9-2,2v5c0,1.1,0.9,2,2,2h2c1.1,0,2-0.9,2-2V6C18,4.9,17.1,4,16,4z M16,11h-2V6h2V11z M9.5,16H18v2H9.49 c-0.88,0-1.66-0.58-1.92-1.43L5,8V4h2v4L9.5,16z M8,19h10v2H8V19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-phone
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 17.47c-.88-.07-1.75-.22-2.6-.45l-1.19 1.19c1.2.41 2.48.67 3.8.75v-1.49zM6.99 7.59c-.24-.83-.39-1.7-.45-2.59h-1.5c.09 1.32.35 2.59.75 3.8l1.2-1.21z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 4c0 9.39 7.61 17 17 17 .55 0 1-.45 1-1v-3.49c0-.55-.45-1-1-1-1.24 0-2.45-.2-3.57-.57-.1-.04-.21-.05-.31-.05-.26 0-.51.1-.71.29l-2.2 2.2c-2.83-1.45-5.15-3.76-6.59-6.59l2.2-2.2c.28-.28.36-.67.25-1.02C8.7 6.45 8.5 5.25 8.5 4c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1zm13.4 13.02c.85.24 1.72.39 2.6.45v1.49c-1.32-.09-2.59-.35-3.8-.75l1.2-1.19zM6.54 5c.06.89.21 1.76.45 2.59l-1.2 1.2c-.41-1.2-.67-2.47-.76-3.79h1.51z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 design-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "15.91,9.28 14.61,7.98 5,17.59 5,19 6.41,19 16.02,9.39",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "10.83,8.93 9.63,7.73 8.44,8.92 7.02,7.5 8.21,6.32 6.94,5.04 6.94,5.04 5.04,6.94 8.93,10.83",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "16.27,14.38 15.07,13.17 13.17,15.07 17.06,18.96 18.96,17.06 17.69,15.79 16.5,16.98 15.08,15.57",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5.56",
      :x "16.44",
      :width "2",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 0.4645 14.2513)",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.97,5.86l-2.83-2.83c-0.39-0.39-1.02-0.39-1.41,0l-4.49,4.49L8.35,3.63c-0.78-0.78-2.05-0.78-2.83,0l-1.9,1.9 c-0.78,0.78-0.78,2.05,0,2.83l3.89,3.89L3,16.76V21h4.24l4.52-4.52l3.89,3.89c0.95,0.95,2.23,0.6,2.83,0l1.9-1.9 c0.78-0.78,0.78-2.05,0-2.83l-3.89-3.89l4.49-4.49C21.36,6.88,21.36,6.25,20.97,5.86z M5.04,6.94l1.89-1.9c0,0,0,0,0,0l1.27,1.27 L7.02,7.5l1.41,1.41l1.19-1.19l1.2,1.2l-1.9,1.9L5.04,6.94z M6.41,19H5v-1.41l9.61-9.61l1.3,1.3l0.11,0.11L6.41,19z M16.5,16.98 l1.19-1.19l1.27,1.27l-1.9,1.9l-3.89-3.89l1.9-1.9l1.2,1.2l-1.19,1.19L16.5,16.98z M17.44,7.98l-1.41-1.41l1.41-1.41l1.41,1.41 L17.44,7.98z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 layers
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M6.26 9L12 13.47 17.74 9 12 4.53z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.37 12.8l-7.38 5.74-7.37-5.73L3 14.07l9 7 9-7zM12 2L3 9l1.63 1.27L12 16l7.36-5.73L21 9l-9-7zm0 11.47L6.26 9 12 4.53 17.74 9 12 13.47z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wine-bar
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,13c-1.86,0-3.41-1.28-3.86-3h7.72C15.41,11.72,13.86,13,12,13z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M6,3l0,6c0,2.97,2.16,5.43,5,5.91V19H8v2h8v-2h-3v-4.09c2.84-0.48,5-2.94,5-5.91V3H6z M12,13c-1.86,0-3.41-1.28-3.86-3h7.72 C15.41,11.72,13.86,13,12,13z M16,8H8l0-3h8L16,8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-crash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M5,15v5h14v-5H5z M7.5,19C6.67,19,6,18.33,6,17.5S6.67,16,7.5,16S9,16.67,9,17.5S8.33,19,7.5,19z M16.5,19 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S17.33,19,16.5,19z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M18.92,9.01C18.72,8.42,18.16,8,17.5,8h-11C5.84,8,5.29,8.42,5.08,9.01L3,15v8c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-1 h12v1c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-8L18.92,9.01z M6.85,10h10.29l1.04,3H5.81L6.85,10z M19,20H5v-5h14V20z M6,17.5 C6,16.67,6.67,16,7.5,16S9,16.67,9,17.5S8.33,19,7.5,19S6,18.33,6,17.5z M15,17.5c0-0.83,0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5 S17.33,19,16.5,19S15,18.33,15,17.5z M12,6.36L9.17,3.54l1.41-1.41L12,3.54L15.54,0l1.41,1.41L12,6.36z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 route
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1", :opacity ".3", :cy "6", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1",
      :opacity ".3",
      :cy "18",
      :cx "18",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,15.18V7c0-2.21-1.79-4-4-4s-4,1.79-4,4v10c0,1.1-0.9,2-2,2s-2-0.9-2-2V8.82C8.16,8.4,9,7.3,9,6c0-1.66-1.34-3-3-3 S3,4.34,3,6c0,1.3,0.84,2.4,2,2.82V17c0,2.21,1.79,4,4,4s4-1.79,4-4V7c0-1.1,0.9-2,2-2s2,0.9,2,2v8.18c-1.16,0.41-2,1.51-2,2.82 c0,1.66,1.34,3,3,3s3-1.34,3-3C21,16.7,20.16,15.6,19,15.18z M6,7C5.45,7,5,6.55,5,6s0.45-1,1-1s1,0.45,1,1S6.55,7,6,7z M18,19 c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S18.55,19,18,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-boat-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19.77,12.66l-1.12,3.97c-0.78-0.43-1.07-0.86-2.65-2.67C14.4,15.78,13.57,17,12,17c-1.53,0-2.34-1.15-4-3.04 c-1.6,1.82-1.87,2.21-2.65,2.65l-1.13-3.96L12,10.11L19.77,12.66z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.77,12.66l-1.12,3.97c-0.78-0.43-1.07-0.86-2.65-2.67C14.4,15.78,13.57,17,12,17c-1.53,0-2.34-1.15-4-3.04 c-1.6,1.82-1.87,2.21-2.65,2.65l-1.13-3.96L12,10.11L19.77,12.66z M15,1H9v3H6C4.9,4,4,4.9,4,6v4.62l-1.29,0.42 c-0.63,0.19-0.81,0.84-0.66,1.28L3.95,19H4c1.6,0,3.02-0.88,4-2c0.98,1.12,2.4,2,4,2s3.02-0.88,4-2c0.98,1.12,2.4,2,4,2h0.05 l1.91-6.68c0.11-0.37,0.04-1.06-0.66-1.28L20,10.62V6c0-1.1-0.9-2-2-2h-3V1L15,1z M6,9.97V6h12v3.97L12,8L6,9.97L6,9.97z M16,19.68 c-1.22,0.85-2.61,1.28-4,1.28s-2.78-0.43-4-1.28C6.78,20.53,5.39,21,4,21H2v2h2c1.38,0,2.74-0.35,4-0.99c1.26,0.64,2.63,0.97,4,0.97 s2.74-0.32,4-0.97c1.26,0.65,2.62,0.99,4,0.99h2v-2h-2C18.61,21,17.22,20.53,16,19.68L16,19.68z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 category
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "2.5",
    :opacity ".3",
    :cy "17.5",
    :cx "17.5",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 15.5h4v4H5zm7-9.66L10.07 9h3.86z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2l-5.5 9h11L12 2zm0 3.84L13.93 9h-3.87L12 5.84zM17.5 13c-2.49 0-4.5 2.01-4.5 4.5s2.01 4.5 4.5 4.5 4.5-2.01 4.5-4.5-2.01-4.5-4.5-4.5zm0 7c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5zM11 13.5H3v8h8v-8zm-2 6H5v-4h4v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 store-mall-directory
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5.64 9l-.6 3h13.92l-.6-3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 7l-1 5v2h1v6h10v-6h4v6h2v-6h1v-2l-1-5H4zm8 11H6v-4h6v4zm-6.96-6l.6-3h12.72l.6 3H5.04zM4 4h16v2H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fork-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9.41,15.59L8,17l-4-4l4-4l1.41,1.41L7.83,12c1.51-0.33,3.73,0.08,5.17,1.36l0-6.53l-1.59,1.59L10,7l4-4l4,4l-1.41,1.41 L15,6.83V21l-2,0v-4c-0.73-2.58-3.07-3.47-5.17-3L9.41,15.59z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 turn-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6.83,11l1.59,1.59L7,14l-4-4l4-4l1.41,1.41L6.83,9L15,9c1.1,0,2,0.9,2,2v9h-2v-9L6.83,11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 car-rental
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M7,15.01V18h10v-2.99V15H7V15.01z M15,15.5c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S14.45,15.5,15,15.5z M9,15.5c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S8.45,15.5,9,15.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "16.5", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "16.5", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M17.25,9.6c-0.02-0.02-0.03-0.04-0.05-0.07C16.82,9.01,16.28,9,16.28,9H7.72c0,0-0.54,0.01-0.92,0.54 C6.78,9.56,6.77,9.58,6.75,9.6C6.68,9.71,6.61,9.84,6.56,10C6.34,10.66,5.82,12.22,5,14.69v6.5C5,21.64,5.35,22,5.78,22h0.44 C6.65,22,7,21.64,7,21.19V20h10v1.19c0,0.45,0.34,0.81,0.78,0.81h0.44c0.43,0,0.78-0.36,0.78-0.81v-6.5 c-0.82-2.46-1.34-4.03-1.56-4.69C17.39,9.84,17.32,9.71,17.25,9.6z M8.33,11h7.34l0.23,0.69L16.33,13H7.67L8.33,11z M17,15.01V18 H7v-2.99V15h10V15.01z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.83,3C10.41,1.83,9.3,1,8,1C6.34,1,5,2.34,5,4c0,1.65,1.34,3,3,3c1.3,0,2.41-0.84,2.83-2H16v2h2V5h1V3H10.83z M8,5 C7.45,5,7,4.55,7,4s0.45-1,1-1s1,0.45,1,1S8.55,5,8,5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 hotel
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M19 9h-6v6h8v-4c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :opacity ".3", :cy "11", :cx "7", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M4 11c0 1.66 1.34 3 3 3s3-1.34 3-3-1.34-3-3-3-3 1.34-3 3zm4 0c0 .55-.45 1-1 1s-1-.45-1-1 .45-1 1-1 1 .45 1 1zm11-4h-8v8H3V5H1v15h2v-3h18v3h2v-9c0-2.21-1.79-4-4-4zm2 8h-8V9h6c1.1 0 2 .9 2 2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 emergency-share
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M12,11c-1.94,0-4,1.45-4,4.15c0,0.94,0.55,2.93,4,6.17c3.45-3.24,4-5.23,4-6.17C16,12.45,13.94,11,12,11z M12,16.5c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S12.83,16.5,12,16.5z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M12,4c1.93,0,3.68,0.78,4.95,2.05l-1.41,1.41C14.63,6.56,13.38,6,12,6S9.37,6.56,8.46,7.46L7.05,6.05 C8.32,4.78,10.07,4,12,4z M19.78,3.23l-1.41,1.41C16.74,3.01,14.49,2,12.01,2S7.27,3.01,5.64,4.63L4.22,3.22 C6.22,1.23,8.97,0,12.01,0S17.79,1.23,19.78,3.23z M12,11c1.94,0,4,1.45,4,4.15c0,0.94-0.55,2.93-4,6.17c-3.45-3.24-4-5.23-4-6.17 C8,12.45,10.06,11,12,11z M12,9c-3.15,0-6,2.41-6,6.15c0,2.49,2,5.44,6,8.85c4-3.41,6-6.36,6-8.85C18,11.41,15.15,9,12,9z M13.5,15 c0-0.83-0.67-1.5-1.5-1.5c-0.83,0-1.5,0.67-1.5,1.5c0,0.83,0.67,1.5,1.5,1.5C12.83,16.5,13.5,15.83,13.5,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 dinner-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M17.08,15.14C16.41,14.4,15.49,14,14.5,14c-1.35,0-2.58,0.79-3.16,2h6.32 C17.52,15.69,17.32,15.4,17.08,15.14z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "2,19 4,21 20,21 22,19", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M3,18h16.97c0,0,0,0,0,0c0.29-3.26-2.28-6-5.48-6c-2.35,0-4.35,1.48-5.14,3.55C8.94,15.32,8.48,15.17,8,15.08V9h1.75 C10.99,9,12,7.99,12,6.75h9v-1.5h-9C12,4.01,10.99,3,9.75,3H3v1.5h1v0.75H3v1.5h1V7.5H3V9h1v7.39C3.56,16.85,3.22,17.39,3,18z M14.5,14c0.99,0,1.91,0.4,2.58,1.14c0.24,0.26,0.44,0.55,0.58,0.86h-6.32C11.92,14.79,13.15,14,14.5,14z M8,4.5h2v0.75H8V4.5z M8,6.75h2V7.5H8V6.75z M5.5,4.5h1v0.75h-1V4.5z M5.5,6.75h1V7.5h-1V6.75z M5.5,9h1v6.06c-0.35,0.06-0.68,0.17-1,0.3V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 lunch-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "18",
      :x "4",
      :width "16",
      :height "1",
      :fill-opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:fill-opacity ".3",
      :d
      "M12,5C8.61,5,5.01,5.81,4.18,8h15.66c-0.13-0.37-0.35-0.7-0.66-1.01C17.93,5.73,15.31,5,12,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2,19c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2v-3H2V19z M4,18h16v1H4V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.66,11.5c-1.95,0-2.09,1-3.33,1c-1.19,0-1.42-1-3.33-1c-1.95,0-2.09,1-3.33,1c-1.19,0-1.42-1-3.33-1 c-1.95,0-2.09,1-3.33,1v2c1.9,0,2.17-1,3.35-1c1.19,0,1.42,1,3.33,1c1.95,0,2.09-1,3.33-1c1.19,0,1.42,1,3.33,1 c1.95,0,2.09-1,3.33-1c1.19,0,1.4,0.98,3.32,1l-0.01-1.98C20.38,12.19,20.37,11.5,18.66,11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,9c0.02-4-4.28-6-10-6C6.29,3,2,5,2,9v1h20L22,9L22,9z M4.18,8C5.01,5.81,8.61,5,12,5c3.31,0,5.93,0.73,7.19,1.99 C19.49,7.3,19.71,7.63,19.84,8H4.18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 turn-slight-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11.66,6V4H6v5.66h2V7.41l5,5V20h2v-7.58c0-0.53-0.21-1.04-0.59-1.41l-5-5H11.66z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 merge
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6.41,21L5,19.59l4.83-4.83c0.75-0.75,1.17-1.77,1.17-2.83v-5.1L9.41,8.41L8,7l4-4l4,4l-1.41,1.41L13,6.83v5.1 c0,1.06,0.42,2.08,1.17,2.83L19,19.59L17.59,21L12,15.41L6.41,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 roundabout-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13.92,8C13.44,5.16,10.97,3,8,3C4.69,3,2,5.69,2,9c0,2.97,2.16,5.44,5,5.92L7,21h2l0-6.09c0-0.98-0.71-1.8-1.67-1.97 C5.44,12.63,4,10.98,4,9c0-2.21,1.79-4,4-4c1.98,0,3.63,1.44,3.94,3.33C12.11,9.29,12.93,10,13.91,10l4.26,0l-1.59,1.59L18,13l4-4 l-4-4l-1.41,1.41L18.17,8L13.92,8z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 ramen-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M8.73,18.39l1.27,0.5V20h4v-1.11l1.27-0.5c2.16-0.85,3.74-2.47,4.4-4.39H4.34 C4.99,15.92,6.58,17.54,8.73,18.39z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,3.51V2L4,3.99V12H2c0,3.69,2.47,6.86,6,8.25V22h8v-1.75c3.53-1.39,6-4.56,6-8.25H10.5V8H22V6.5H10.5V4.78L22,3.51z M8,5.06l1-0.11V6.5H8V5.06z M8,8h1v4H8V8z M5.5,5.34l1-0.11V6.5h-1V5.34z M5.5,8h1v4h-1V8z M19.66,14 c-0.66,1.92-2.24,3.54-4.4,4.39L14,18.89V20h-4v-1.11l-1.27-0.5c-2.16-0.85-3.74-2.47-4.4-4.39H19.66z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 edit-location-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.9,9.05C17.96,9.41,18,9.79,18,10.2c0,1.71-1.08,4.64-6,9.14c-4.92-4.49-6-7.43-6-9.14C6,6.17,9.09,4,12,4 c0.32,0,0.65,0.03,0.97,0.08l1.65-1.65C13.78,2.16,12.9,2,12,2c-4.2,0-8,3.22-8,8.2c0,3.32,2.67,7.25,8,11.8 c5.33-4.55,8-8.48,8-11.8c0-1.01-0.16-1.94-0.45-2.8L17.9,9.05z M20.71,2L20,1.29c-0.39-0.39-1.02-0.39-1.41,0l-0.72,0.72 l2.12,2.12l0.72-0.72C21.1,3.02,21.1,2.39,20.71,2z M11,11h2.12l6.16-6.16l-2.12-2.12L11,8.88V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M13.95,13H9V8.05l3.97-3.97C12.65,4.03,12.32,4,12,4c-2.91,0-6,2.17-6,6.2 c0,1.71,1.08,4.64,6,9.14c4.92-4.49,6-7.43,6-9.14c0-0.4-0.04-0.78-0.1-1.15L13.95,13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 taxi-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M4,18h14v-5H4V18z M15.5,14c0.83,0,1.5,0.67,1.5,1.5S16.33,17,15.5,17 S14,16.33,14,15.5S14.67,14,15.5,14z M6.5,14C7.33,14,8,14.67,8,15.5S7.33,17,6.5,17S5,16.33,5,15.5S5.67,14,6.5,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "15.5", :cx "6.5", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "15.5", :cx "15.5", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M18,18H4v-5h14c-1.91,0-3.63-0.76-4.89-2H4.81l1.04-3h5.44C11.1,7.37,11,6.7,11,6s0.1-1.37,0.29-2H8v2H5.5 C4.84,6,4.29,6.42,4.08,7.01L2,13v8c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-1h12v1c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-8 l-0.09-0.27C19.3,12.9,18.66,13,18,13V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18.5,3v4h-1V3H18.5z M18.5,9h-1V8h1V9z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 soup-kitchen
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14.12,17c-0.73,1.78-2.43,3-4.37,3c-1.94,0-3.67-1.23-4.43-3h8.78",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M6.4,7C6.06,7.55,6,7.97,6,8.38C6,9.15,7,11,7,12c0,0.95-0.4,1.5-0.4,1.5H5.1c0,0,0.4-0.55,0.4-1.5c0-1-1-2.85-1-3.62 C4.5,7.97,4.56,7.55,4.9,7H6.4z M11.4,7C11.06,7.55,11,7.97,11,8.38C11,9.15,12,11,12,12c0,0.95-0.4,1.5-0.4,1.5h1.5 c0,0,0.4-0.55,0.4-1.5c0-1-1-2.85-1-3.62c0-0.41,0.06-0.83,0.4-1.38H11.4z M8.15,7c-0.34,0.55-0.4,0.97-0.4,1.38 c0,0.77,1,2.63,1,3.62c0,0.95-0.4,1.5-0.4,1.5h1.5c0,0,0.4-0.55,0.4-1.5c0-1-1-2.85-1-3.62c0-0.41,0.06-0.83,0.4-1.38H8.15z M18.6,2 c-1.54,0-2.81,1.16-2.98,2.65L14.53,15H4.01c-0.6,0-1.09,0.53-1,1.13C3.53,19.46,6.39,22,9.75,22c3.48,0,6.34-2.73,6.71-6.23 l1.15-10.87C17.66,4.39,18.08,4,18.6,4c0.55,0,1,0.45,1,1c0,0.3-0.1,1.25-0.1,1.25l1.97,0.25c0,0,0.13-1.06,0.13-1.5 C21.6,3.35,20.25,2,18.6,2z M9.75,20c-1.94,0-3.67-1.23-4.43-3h8.78h0.01C13.39,18.78,11.69,20,9.75,20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-pizza
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5.51 6.36L12 17.92l6.49-11.55C16.68 4.85 14.38 4 12 4s-4.68.85-6.49 2.36zM9 8.5c-.83 0-1.5-.67-1.5-1.5S8.17 5.5 9 5.5s1.5.67 1.5 1.5S9.82 8.5 9 8.5zm4.5 4.5c0 .83-.68 1.5-1.5 1.5-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C8.43 2 5.23 3.54 3.01 6L12 22l8.99-16C18.78 3.55 15.57 2 12 2zm0 15.92L5.51 6.36C7.32 4.85 9.62 4 12 4s4.68.85 6.49 2.36L12 17.92zM9 5.5c-.83 0-1.5.67-1.5 1.5S8.17 8.5 9 8.5s1.5-.67 1.5-1.5S9.82 5.5 9 5.5zm1.5 7.5c0 .83.67 1.5 1.5 1.5.82 0 1.5-.67 1.5-1.5s-.68-1.5-1.5-1.5-1.5.67-1.5 1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 bike-scooter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10,14h0.74L8.82,5.56C8.61,4.65,7.8,4,6.87,4H3v2h3.87l1.42,6.25c0,0-0.01,0-0.01,0C6.12,12.9,4.47,14.73,4.09,17H0v2h6 v-1C6,15.79,7.79,14,10,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,8h-0.82l-1.35-3.69C16.55,3.52,15.8,3,14.96,3H11v2h3.96l1.1,3H10.4l0.46,2H15c-0.43,0.58-0.75,1.25-0.9,2h-2.79 l0.46,2h2.33c0.44,2.23,2.31,3.88,4.65,3.99c2.8,0.13,5.25-2.19,5.25-5C24,10.2,21.8,8,19,8z M19,16c-1.68,0-3-1.32-3-3 c0-0.93,0.41-1.73,1.05-2.28l0.96,2.64l1.88-0.68l-0.97-2.67c0.03,0,0.06-0.01,0.09-0.01c1.68,0,3,1.32,3,3S20.68,16,19,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,15c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S11.66,15,10,15z M10,19c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S10.55,19,10,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 atm
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3.5 13.5h2V15H7v-5c0-.55-.45-1-1-1H3c-.55 0-1 .45-1 1v5h1.5v-1.5zm0-3h2V12h-2v-1.5zm13.5 0h1V14h1.5v-3.51h1V15H22v-5c0-.55-.45-1-1-1h-4.5c-.55 0-1 .45-1 1v5H17v-4.5zM10.25 15h1.5v-4.5H14V9H8v1.5h2.25z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 set-meal
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M21,13H3V4h18V13z M20,6c-1.68,0-3.04,0.98-3.21,2.23C16.15,7.5,14.06,5.5,10.25,5.5c-4.67,0-6.75,3-6.75,3 s2.08,3,6.75,3c3.81,0,5.9-2,6.54-2.73C16.96,10.02,18.32,11,20,11V6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21.05,17.56L3.08,18.5L3,17l17.98-0.94L21.05,17.56z M21,19.48H3v1.5h18V19.48z M23,13V4c0-1.1-0.9-2-2-2H3 C1.9,2,1,2.9,1,4v9c0,1.1,0.9,2,2,2h18C22.1,15,23,14.1,23,13z M21,13H3V4h18V13z M20,6c-1.68,0-3.04,0.98-3.21,2.23 C16.15,7.5,14.06,5.5,10.25,5.5c-4.67,0-6.75,3-6.75,3s2.08,3,6.75,3c3.81,0,5.9-2,6.54-2.73C16.96,10.02,18.32,11,20,11V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 takeout-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "9.83,5 7.03,7.73 7.12,9 16.87,9 16.96,7.73 14.16,5",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "7.79,18 16.23,18 16.74,11 7.28,11",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.59,6.05L19,7.63l0.03-0.56L14.98,3H9.02L4.97,7.07L5,7.57L3.41,6.01L2,7.44l3.23,3.11L5.93,20h12.14l0.7-9.44L22,7.46 L20.59,6.05z M16.23,18H7.79l-0.51-7h9.46L16.23,18z M16.87,9H7.12L7.03,7.73L9.83,5h4.33l2.8,2.73L16.87,9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 screen-rotation-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M4,7.59l5-5c0.78-0.78,2.05-0.78,2.83,0L20.24,11h-2.83L10.4,4L5.41,9H8v2H2V5h2V7.59z M20,19h2v-6h-6v2h2.59l-4.99,5 l-7.01-7H3.76l8.41,8.41c0.78,0.78,2.05,0.78,2.83,0l5-5V19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 minor-crash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M5,15v5h14v-5H5z M7.5,19C6.67,19,6,18.33,6,17.5S6.67,16,7.5,16S9,16.67,9,17.5S8.33,19,7.5,19z M16.5,19 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S17.33,19,16.5,19z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M9.41,5L8,6.41l-3-3L6.41,2L9.41,5z M19,3.41L17.59,2l-3,3L16,6.41L19,3.41z M13,0h-2v5h2V0z M21,15v8c0,0.55-0.45,1-1,1 h-1c-0.55,0-1-0.45-1-1v-1H6v1c0,0.55-0.45,1-1,1H4c-0.55,0-1-0.45-1-1v-8l2.08-5.99C5.29,8.42,5.84,8,6.5,8h11 c0.66,0,1.22,0.42,1.42,1.01L21,15z M5.81,13h12.38l-1.04-3H6.85L5.81,13z M19,15H5v5h14V15z M7.5,19C8.33,19,9,18.33,9,17.5 S8.33,16,7.5,16S6,16.67,6,17.5S6.67,19,7.5,19z M16.5,19c0.83,0,1.5-0.67,1.5-1.5S17.33,16,16.5,16S15,16.67,15,17.5 S15.67,19,16.5,19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 maps-ugc
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0",
    :width "24",
    :height "24",
    :fill-rule "evenodd",
    :fill "none",
    :stroke nil})
  (helix.dom/path
   {:fill-opacity ".3",
    :d
    "M12,4c4.41,0,8,3.59,8,8s-3.59,8-8,8c-1.18,0-2.34-0.26-3.43-0.78c-0.27-0.13-0.56-0.19-0.86-0.19 c-0.19,0-0.38,0.03-0.56,0.08l-3.2,0.94l0.94-3.2c0.14-0.47,0.1-0.98-0.11-1.42C4.26,14.34,4,13.18,4,12C4,7.59,7.59,4,12,4",
    :stroke nil,
    :fill nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,4c4.41,0,8,3.59,8,8s-3.59,8-8,8c-1.18,0-2.34-0.26-3.43-0.78c-0.27-0.13-0.56-0.19-0.86-0.19 c-0.19,0-0.38,0.03-0.56,0.08l-3.2,0.94l0.94-3.2c0.14-0.47,0.1-0.98-0.11-1.42C4.26,14.34,4,13.18,4,12C4,7.59,7.59,4,12,4 M12,2 C6.48,2,2,6.48,2,12c0,1.54,0.36,2.98,0.97,4.29L1,23l6.71-1.97C9.02,21.64,10.46,22,12,22c5.52,0,10-4.48,10-10 C22,6.48,17.52,2,12,2L12,2z",
     :stroke nil,
     :fill nil}))
  (helix.dom/polygon
   {:points
    "13,8 11,8 11,11 8,11 8,13 11,13 11,16 13,16 13,13 16,13 16,11 13,11",
    :fill-rule "evenodd",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 park
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "13.26,10 15.16,10 12.01,5.5 8.88,10 10.69,10 6.79,16 17.26,16",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,12h2L12,2L5.05,12H7l-3.9,6h6.92v4h3.95v-4H21L17,12z M6.79,16l3.9-6H8.88l3.13-4.5l3.15,4.5h-1.9l4,6H6.79z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 pest-control
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,9c-2.21,0-4,2.24-4,5s1.79,5,4,5s4-2.24,4-5S14.21,9,12,9z M13,17h-2v-6h2V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M13.88,7.36C13.62,6.57,12.88,6,12,6s-1.62,0.57-1.88,1.36C10.71,7.13,11.34,7,12,7S13.29,7.13,13.88,7.36z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,15v-2h-3.07c-0.05-0.39-0.12-0.77-0.22-1.14l2.58-1.49l-1-1.73L16.92,10c-0.28-0.48-0.62-0.91-0.99-1.29 c0.1-0.56,0.2-1.69-0.58-2.89L17,4.17l-1.41-1.41l-1.72,1.72c-1.68-0.89-3.1-0.33-3.73,0L8.41,2.76L7,4.17l1.65,1.65 c-0.78,1.2-0.68,2.34-0.58,2.89C7.7,9.1,7.36,9.53,7.08,10L4.71,8.63l-1,1.73l2.58,1.49c-0.1,0.37-0.17,0.75-0.22,1.14H3v2h3.07 c0.05,0.39,0.12,0.77,0.22,1.14l-2.58,1.49l1,1.73L7.08,18c1.08,1.81,2.88,3,4.92,3s3.84-1.19,4.92-3l2.37,1.37l1-1.73l-2.58-1.49 c0.1-0.37,0.17-0.75,0.22-1.14H21z M12,6c0.88,0,1.62,0.57,1.88,1.36C13.29,7.13,12.66,7,12,7s-1.29,0.13-1.88,0.36 C10.38,6.57,11.12,6,12,6z M12,19c-2.21,0-4-2.24-4-5s1.79-5,4-5s4,2.24,4,5S14.21,19,12,19z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11",
      :x "11",
      :width "2",
      :height "6",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-boat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M6.49 15.68L8 13.96l1.51 1.72c.34.4 1.28 1.32 2.49 1.32 1.21 0 2.15-.92 2.49-1.32L16 13.96l1.51 1.72c.2.23.6.64 1.14.94l1.12-3.97-2.39-.78L12 10.11l-5.38 1.77-2.4.79 1.13 3.96c.55-.31.94-.72 1.14-.95zM11 3h2v1h-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3.95 19H4c1.6 0 3.02-.88 4-2 .98 1.12 2.4 2 4 2s3.02-.88 4-2c.98 1.12 2.4 2 4 2h.05l1.89-6.68c.08-.26.06-.54-.06-.78s-.34-.42-.6-.5L20 10.62V6c0-1.1-.9-2-2-2h-3V1H9v3H6c-1.1 0-2 .9-2 2v4.62l-1.29.42c-.26.08-.48.26-.6.5s-.15.52-.06.78L3.95 19zM11 3h2v1h-2V3zM6 6h12v3.97L12 8 6 9.97V6zm.62 5.87L12 10.11l5.38 1.77 2.39.78-1.12 3.97c-.54-.3-.94-.71-1.14-.94L16 13.96l-1.51 1.72c-.34.4-1.28 1.32-2.49 1.32-1.21 0-2.15-.92-2.49-1.32L8 13.96l-1.51 1.72c-.2.23-.6.63-1.14.93l-1.13-3.96 2.4-.78zM8 22.01c1.26.64 2.63.97 4 .97s2.74-.32 4-.97c1.26.65 2.62.99 4 .99h2v-2h-2c-1.39 0-2.78-.47-4-1.32-1.22.85-2.61 1.28-4 1.28s-2.78-.43-4-1.28C6.78 20.53 5.39 21 4 21H2v2h2c1.38 0 2.74-.35 4-.99z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flight
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 19l-2 1.5V22l3.5-1 3.5 1v-1.5L13 19v-5.5l8 2.5v-2l-8-5V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5V9l-8 5v2l8-2.5V19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pedal-bike
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.18,10l-1.7-4.68C16.19,4.53,15.44,4,14.6,4H12v2h2.6l1.46,4h-4.81l-0.36-1H12V7H7v2h1.75l1.82,5H9.9 c-0.44-2.23-2.31-3.88-4.65-3.99C2.45,9.87,0,12.2,0,15c0,2.8,2.2,5,5,5c2.46,0,4.45-1.69,4.9-4h4.2c0.44,2.23,2.31,3.88,4.65,3.99 c2.8,0.13,5.25-2.19,5.25-5c0-2.8-2.2-5-5-5H18.18z M7.82,16c-0.4,1.17-1.49,2-2.82,2c-1.68,0-3-1.32-3-3s1.32-3,3-3 c1.33,0,2.42,0.83,2.82,2H5v2H7.82z M14.1,14h-1.4l-0.73-2H15C14.56,12.58,14.24,13.25,14.1,14z M19,18c-1.68,0-3-1.32-3-3 c0-0.93,0.41-1.73,1.05-2.28l0.96,2.64l1.88-0.68l-0.97-2.67c0.03,0,0.06-0.01,0.09-0.01c1.68,0,3,1.32,3,3S20.68,18,19,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 directions-bike
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.5 5.5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zM5 22c2.8 0 5-2.2 5-5s-2.2-5-5-5-5 2.2-5 5 2.2 5 5 5zm0-8.5c1.9 0 3.5 1.6 3.5 3.5S6.9 20.5 5 20.5 1.5 18.9 1.5 17s1.6-3.5 3.5-3.5zm2.8-2.3L11 14v5h2v-6.2l-2.2-2.3 2.4-2.4.8.8c1.3 1.3 3 2.1 5.1 2.1V9c-1.5 0-2.7-.6-3.6-1.5l-1.9-1.9c-.5-.4-1-.6-1.6-.6s-1.1.2-1.4.6L7.8 8.4c-.4.4-.6.9-.6 1.4 0 .6.2 1.1.6 1.4zM19 12c-2.8 0-5 2.2-5 5s2.2 5 5 5 5-2.2 5-5-2.2-5-5-5zm0 8.5c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5 3.5 1.6 3.5 3.5-1.6 3.5-3.5 3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 moving
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19.71,9.71L22,12V6h-6l2.29,2.29l-4.17,4.17c-0.39,0.39-1.02,0.39-1.41,0l-1.17-1.17c-1.17-1.17-3.07-1.17-4.24,0L2,16.59 L3.41,18l5.29-5.29c0.39-0.39,1.02-0.39,1.41,0l1.17,1.17c1.17,1.17,3.07,1.17,4.24,0L19.71,9.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fire-truck
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M3,16h1.78c0.55-0.61,1.34-1,2.22-1s1.67,0.39,2.22,1H12v-3H3V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M14,16h0.78c0.55-0.61,1.34-1,2.22-1s1.67,0.39,2.22,1H21v-3h-7V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.9,10.69l-1.44-4.32C21.18,5.55,20.42,5,19.56,5H19V4c0-0.55-0.45-1-1-1h-1c-0.55,0-1,0.45-1,1v1h-2c-1.1,0-2,0.9-2,2 v4H1v5c0,1.1,0.9,2,2,2h1c0,1.66,1.34,3,3,3s3-1.34,3-3h4c0,1.66,1.34,3,3,3s3-1.34,3-3h3v-6.68C23,11.11,22.97,10.9,22.9,10.69z M7,19c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S7.55,19,7,19z M12,16H9.22C8.67,15.39,7.89,15,7,15s-1.67,0.39-2.22,1H3v-3h9V16 z M14,7h5.56l1.33,4H14V7z M17,19c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S17.55,19,17,19z M21,16h-1.78 c-0.55-0.61-1.34-1-2.22-1s-1.67,0.39-2.22,1H14v-3h7V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,8.5h-1v-2h1V5H1v1.5h1v2H1V10h10V8.5z M5.25,8.5H3.5v-2h1.75V8.5z M8.5,8.5H6.75v-2H8.5V8.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-run
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.49 3.48c0 1.1.9 2 2 2s2-.9 2-2-.9-2-2-2-2 .9-2 2zm-.6 11.5l2.1 2v6h2v-7.5l-2.1-2 .6-3c1.3 1.5 3.3 2.5 5.5 2.5v-2c-1.9 0-3.5-1-4.3-2.4l-1-1.6c-.4-.6-1-1-1.7-1-.3 0-.5.1-.8.1l-5.2 2.2v4.7h2v-3.4l1.8-.7-1.6 8.1-4.9-1-.4 2 7 1.4 1-4.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-car-wash
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5.12 14l-.12.34V19h14v-4.66l-.12-.34H5.12zm2.38 4c-.83 0-1.5-.67-1.5-1.5S6.67 15 7.5 15s1.5.67 1.5 1.5S8.33 18 7.5 18zm9 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15.5 3.5c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5c0-1-1.5-2.7-1.5-2.7s-1.5 1.7-1.5 2.7zm-2 0c0-1-1.5-2.7-1.5-2.7s-1.5 1.7-1.5 2.7c0 .83.67 1.5 1.5 1.5s1.5-.67 1.5-1.5zm-5 0C8.5 2.5 7 .8 7 .8S5.5 2.5 5.5 3.5C5.5 4.33 6.17 5 7 5s1.5-.67 1.5-1.5zM21 14l-2.08-5.99C18.72 7.42 18.16 7 17.5 7h-11c-.66 0-1.21.42-1.42 1.01L3 14v8c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1h12v1c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-8zM6.85 9h10.29l1.04 3H5.81l1.04-3zM19 19H5v-4.66l.12-.34h13.77l.11.34V19z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "16.5", :cx "7.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "16.5", :cx "16.5", :stroke nil, :fill nil})))


(helix.core/defnc
 church
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M16,10.04L12,8l-4,2.04v3.35l-4,1.81V20h5v-2.04c0-1.69,1.35-3.06,3-3.06c1.65,0,3,1.37,3,3.06V20h5v-4.79 l-4-1.81V10.04z M12,13.5c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S12.83,13.5,12,13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,12.22V9l-5-2.5V5h2V3h-2V1h-2v2H9v2h2v1.5L6,9v3.22L2,14v8h9v-4c0-0.55,0.45-1,1-1s1,0.45,1,1v4h9v-8L18,12.22z M20,20h-5v-2.04c0-1.69-1.35-3.06-3-3.06c-1.65,0-3,1.37-3,3.06V20H4v-4.79l4-1.81v-3.35L12,8l4,2.04v3.35l4,1.81V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "12", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 my-location
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 3.06V1h-2v2.06C6.83 3.52 3.52 6.83 3.06 11H1v2h2.06c.46 4.17 3.77 7.48 7.94 7.94V23h2v-2.06c4.17-.46 7.48-3.77 7.94-7.94H23v-2h-2.06c-.46-4.17-3.77-7.48-7.94-7.94zM12 19c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2", :opacity ".3", :cy "12", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 straight
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "11,6.83 9.41,8.41 8,7 12,3 16,7 14.59,8.41 13,6.83 13,21 11,21",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 turn-slight-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12.34,6V4H18v5.66h-2V7.41l-5,5V20H9v-7.58c0-0.53,0.21-1.04,0.59-1.41l5-5H12.34z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 railway-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d
       "M4,16.5C4,17.33,4.67,18,5.5,18h9c0.83,0,1.5-0.67,1.5-1.5V13H4V16.5z M10,14c0.83,0,1.5,0.67,1.5,1.5S10.83,17,10,17 s-1.5-0.67-1.5-1.5S9.17,14,10,14z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d
       "M4.43,6H11c0-0.33,0.03-0.66,0.08-0.98C7.71,4.92,5.33,5.23,4.43,6z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M4,11V8h7.29C11.1,7.37,11,6.7,11,6H4.43c0.9-0.77,3.28-1.08,6.65-0.98c0.1-0.7,0.3-1.37,0.59-1.99C2.97,2.67,2,5.02,2,7 v9.5C2,18.43,3.57,20,5.5,20L4,21v1h12v-1l-1.5-1c1.93,0,3.5-1.57,3.5-3.5V13c-1.91,0-3.63-0.76-4.89-2H4z M16,16.5 c0,0.83-0.67,1.5-1.5,1.5h-9C4.67,18,4,17.33,4,16.5V13h12V16.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "15.5", :cx "10", :stroke nil, :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18.5,9h-1V8h1V9z M18.5,7h-1V3h1V7z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 zoom-in-map
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9,9l0-6L7,3l0,2.59L3.91,2.5L2.5,3.91L5.59,7L3,7l0,2L9,9z M21,9V7l-2.59,0l3.09-3.09L20.09,2.5L17,5.59V3l-2,0l0,6L21,9z M3,15l0,2h2.59L2.5,20.09l1.41,1.41L7,18.41L7,21h2l0-6L3,15z M15,15l0,6h2v-2.59l3.09,3.09l1.41-1.41L18.41,17H21v-2L15,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-gas-station
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M6 19h6v-7H6z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 3H6c-1.1 0-2 .9-2 2v16h10v-7.5h1.5v5c0 1.38 1.12 2.5 2.5 2.5s2.5-1.12 2.5-2.5V9c0-.69-.28-1.32-.73-1.77l.01-.01-3.72-3.72L15 4.56l2.11 2.11c-.94.36-1.61 1.26-1.61 2.33 0 1.38 1.12 2.5 2.5 2.5.36 0 .69-.08 1-.21v7.21c0 .55-.45 1-1 1s-1-.45-1-1V14c0-1.1-.9-2-2-2h-1V5c0-1.1-.9-2-2-2zm0 10.5V19H6v-7h6v1.5zm0-3.5H6V5h6v5zm6 0c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 transit-enterexit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M15.98 6L9 12.77V8H6v10h10v-3h-4.85L18 8.03z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 navigation
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M7.72 17.7l3.47-1.53.81-.36.81.36 3.47 1.53L12 7.27z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4.5 20.29l.71.71L12 18l6.79 3 .71-.71L12 2 4.5 20.29zm8.31-4.12l-.81-.36-.81.36-3.47 1.53L12 7.27l4.28 10.43-3.47-1.53z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-see
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M20 6h-4.05l-.59-.65L14.12 4H9.88L8.65 5.35l-.6.65H4v12h16V6zm-8 11c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 20h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2zM4 6h4.05l.59-.65L9.88 4h4.24l1.24 1.35.59.65H20v12H4V6zm8 1c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5zm0 8.2c-1.77 0-3.2-1.43-3.2-3.2 0-1.77 1.43-3.2 3.2-3.2s3.2 1.43 3.2 3.2c0 1.77-1.43 3.2-3.2 3.2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hail
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,6c-1.1,0-2-0.9-2-2s0.9-2,2-2s2,0.9,2,2S13.1,6,12,6z M17,2h2c0,2.7-0.93,4.41-2.3,5.5c-0.5,0.4-1.1,0.7-1.7,0.9V22h-2 v-6h-2v6H9V10.1c-0.3,0.1-0.5,0.2-0.6,0.3C7.87,10.81,7,11.43,7,14H5c0-2.06,0.35-3.78,2.11-5.29C8.21,7.81,10,7,12,7 s2.68-0.46,3.48-1.06C15.96,5.55,17,4.76,17,2z M4,16h3v6H4V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 emergency
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M18.43,16.87l-4.68-2.7C13.42,13.97,13,14.21,13,14.6V20h-2v-5.4c0-0.38-0.42-0.63-0.75-0.43l-4.68,2.7 l-1-1.73l4.68-2.7c0.33-0.19,0.33-0.67,0-0.87l-4.68-2.7l1-1.73l4.68,2.7C10.58,10.03,11,9.79,11,9.4V4h2v5.4 c0,0.38,0.42,0.63,0.75,0.43l4.68-2.7l1,1.73l-4.68,2.7c-0.33,0.19-0.33,0.67,0,0.87l4.68,2.7L18.43,16.87z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21.29,13.9L18,12l3.29-1.9c0.48-0.28,0.64-0.89,0.37-1.37l-2-3.46c-0.28-0.48-0.89-0.64-1.37-0.37L15,6.8V3 c0-0.55-0.45-1-1-1h-4C9.45,2,9,2.45,9,3v3.8L5.71,4.9C5.23,4.63,4.62,4.79,4.34,5.27l-2,3.46C2.06,9.21,2.23,9.82,2.71,10.1L6,12 l-3.29,1.9c-0.48,0.28-0.64,0.89-0.37,1.37l2,3.46c0.28,0.48,0.89,0.64,1.37,0.37L9,17.2V21c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1 v-3.8l3.29,1.9c0.48,0.28,1.09,0.11,1.37-0.37l2-3.46C21.94,14.79,21.77,14.18,21.29,13.9z M18.43,16.87l-4.68-2.7 C13.42,13.97,13,14.21,13,14.6V20h-2v-5.4c0-0.38-0.42-0.63-0.75-0.43l-4.68,2.7l-1-1.73l4.68-2.7c0.33-0.19,0.33-0.67,0-0.87 l-4.68-2.7l1-1.73l4.68,2.7C10.58,10.03,11,9.79,11,9.4V4h2v5.4c0,0.38,0.42,0.63,0.75,0.43l4.68-2.7l1,1.73l-4.68,2.7 c-0.33,0.19-0.33,0.67,0,0.87l4.68,2.7L18.43,16.87z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hvac
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M12,6c3.31,0,6,2.69,6,6s-2.69,6-6,6s-6-2.69-6-6S8.69,6,12,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,18c3.31,0,6-2.69,6-6s-2.69-6-6-6s-6,2.69-6,6S8.69,18,12,18z M12,16c-1.01,0-1.91-0.39-2.62-1h5.24 C13.91,15.61,13.01,16,12,16z M12,8c1.01,0,1.91,0.39,2.62,1H9.38C10.09,8.39,10.99,8,12,8z M8.56,10h6.89 c0.26,0.45,0.44,0.96,0.51,1.5h-7.9C8.12,10.96,8.29,10.45,8.56,10z M15.95,12.5c-0.07,0.54-0.24,1.05-0.51,1.5H8.56 c-0.26-0.45-0.44-0.96-0.51-1.5H15.95z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 stadium
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M5,10.04C6.38,10.53,8.77,11,12,11s5.62-0.47,7-0.96C19,9.86,16.22,9,12,9S5,9.86,5,10.04z M20,11.8 c-1.82,0.73-4.73,1.2-8,1.2s-6.18-0.47-8-1.2v6.78c0.61,0.41,2.36,1.01,5,1.28V16h6v3.86c2.64-0.27,4.39-0.87,5-1.28V11.8z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M7,5L3,7V3L7,5z M18,3v4l4-2L18,3z M11,2v4l4-2L11,2z M13,18h-2l0,4c-5.05-0.15-9-1.44-9-3v-9c0-1.66,4.48-3,10-3 s10,1.34,10,3v9c0,1.56-3.95,2.85-9,3L13,18z M5,10.04C6.38,10.53,8.77,11,12,11s5.62-0.47,7-0.96C19,9.86,16.22,9,12,9 S5,9.86,5,10.04z M20,11.8c-1.82,0.73-4.73,1.2-8,1.2s-6.18-0.47-8-1.2v6.78c0.61,0.41,2.36,1.01,5,1.28V16h6v3.86 c2.64-0.27,4.39-0.87,5-1.28V11.8z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 tram
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12.97 7h-1.94c-2.75.08-3.62.58-3.9 1h9.74c-.28-.42-1.15-.92-3.9-1zM7 16v1c0 .45.3.84.74.95h3.11c-.22-.26-.35-.59-.35-.95 0-.39.15-.73.39-1H7zm6.5 1c0 .36-.13.69-.35.95h3.11c.44-.11.74-.5.74-.95v-1h-3.89c.24.27.39.61.39 1z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M13 5l.75-1.5H17V2H7v1.5h4.75L11 5c-3.13.09-6 .73-6 3.5V17c0 1.5 1.11 2.73 2.55 2.95L6 21.5v.5h2l2-2h4l2 2h2v-.5l-1.55-1.55h-.01.01C17.89 19.73 19 18.5 19 17V8.5c0-2.77-2.87-3.41-6-3.5zm-1.97 2h1.94c2.75.08 3.62.58 3.9 1H7.13c.28-.42 1.15-.92 3.9-1zm-.18 10.95H7.74C7.3 17.84 7 17.45 7 17v-1h3.89c-.24.27-.39.61-.39 1 0 .36.13.69.35.95zM17 17c0 .45-.3.84-.74.95h-3.11c.22-.26.35-.59.35-.95 0-.39-.15-.73-.39-1H17v1zm0-3H7v-4h10v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-florist
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 13c.62 0 1.12-.49 1.14-1.1l-.11-1.09c-.32.12-.67.19-1.03.19s-.7-.07-1.02-.19l-.12 1.09c.02.61.52 1.1 1.14 1.1zM8.17 7.1l.88.42c.12-.73.51-1.37 1.06-1.83l-.81-.56c-.18-.13-.41-.2-.64-.2-.63 0-1.14.51-1.14 1.14-.01.44.25.83.65 1.03zm7.66 1.8l-.88-.42c-.12.73-.51 1.37-1.06 1.83l.81.57c.18.13.41.2.64.2.63 0 1.14-.51 1.14-1.14.01-.45-.25-.84-.65-1.04zm-.88-1.38l.88-.42c.4-.19.66-.59.66-1.03 0-.63-.51-1.14-1.14-1.14-.24 0-.46.07-.65.2l-.81.55c.55.46.94 1.1 1.06 1.84zM12 5c.36 0 .71.07 1.03.19l.11-1.09C13.12 3.49 12.62 3 12 3s-1.12.49-1.14 1.1l.12 1.09C11.3 5.07 11.64 5 12 5zm-3.34 6.07c.24 0 .46-.07.65-.2l.81-.55c-.56-.46-.95-1.1-1.07-1.84l-.88.42c-.4.2-.66.59-.66 1.03 0 .63.52 1.14 1.15 1.14zm9.9 4.37c-1.9.71-3.42 2.22-4.12 4.12 1.9-.71 3.41-2.22 4.12-4.12zm-13.12 0c.71 1.9 2.22 3.42 4.12 4.12-.71-1.9-2.22-3.41-4.12-4.12z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8.66 13.07c.15 0 .29-.01.43-.03C9.56 14.19 10.69 15 12 15s2.44-.81 2.91-1.96c.14.02.29.03.43.03 1.73 0 3.14-1.41 3.14-3.14 0-.71-.25-1.39-.67-1.93.43-.54.67-1.22.67-1.93 0-1.73-1.41-3.14-3.14-3.14-.15 0-.29.01-.43.03C14.44 1.81 13.31 1 12 1s-2.44.81-2.91 1.96c-.14-.02-.29-.03-.43-.03-1.73 0-3.14 1.41-3.14 3.14 0 .71.25 1.39.67 1.93-.43.54-.68 1.22-.68 1.93 0 1.73 1.41 3.14 3.15 3.14zm6.68-2c-.24 0-.46-.07-.64-.2l-.81-.57c.55-.45.94-1.09 1.06-1.83l.88.42c.4.19.66.59.66 1.03 0 .64-.52 1.15-1.15 1.15zm-.65-5.94c.2-.13.42-.2.65-.2.63 0 1.14.51 1.14 1.14 0 .44-.25.83-.66 1.03l-.88.42c-.12-.74-.51-1.38-1.07-1.83l.82-.56zM12 3c.62 0 1.12.49 1.14 1.1l-.11 1.09C12.71 5.07 12.36 5 12 5s-.7.07-1.02.19l-.12-1.09c.02-.61.52-1.1 1.14-1.1zm1 5c0 .55-.45 1-1 1s-1-.45-1-1 .45-1 1-1 1 .45 1 1zm-2.02 2.81c.32.12.66.19 1.02.19s.71-.07 1.03-.19l.11 1.09c-.02.61-.52 1.1-1.14 1.1s-1.12-.49-1.14-1.1l.12-1.09zM8.66 4.93c.24 0 .46.07.64.2l.81.56c-.55.45-.94 1.09-1.06 1.83l-.88-.42c-.4-.2-.66-.59-.66-1.03 0-.63.52-1.14 1.15-1.14zM8.17 8.9l.88-.42c.12.74.51 1.38 1.07 1.83l-.81.55c-.2.13-.42.2-.65.2-.63 0-1.14-.51-1.14-1.14-.01-.43.25-.82.65-1.02zM12 22c4.97 0 9-4.03 9-9-4.97 0-9 4.03-9 9zm6.56-6.56c-.71 1.9-2.22 3.42-4.12 4.12.71-1.9 2.22-3.41 4.12-4.12zM3 13c0 4.97 4.03 9 9 9 0-4.97-4.03-9-9-9zm2.44 2.44c1.9.71 3.42 2.22 4.12 4.12-1.9-.71-3.41-2.22-4.12-4.12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 compass-calibration
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4.94 7.26l2.21 2.21c1.44-.91 3.11-1.4 4.85-1.4 1.74 0 3.41.49 4.84 1.4l2.21-2.21C17 5.79 14.56 5 12 5c-2.56 0-5.01.79-7.06 2.26z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "3", :opacity ".3", :cy "17", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M17 17c0-2.76-2.24-5-5-5s-5 2.24-5 5 2.24 5 5 5 5-2.24 5-5zm-8 0c0-1.65 1.35-3 3-3s3 1.35 3 3-1.35 3-3 3-3-1.35-3-3zM2 7.15l5 5c1.28-1.28 3.05-2.08 5-2.08s3.72.79 5 2.07l5-5C19.44 4.59 15.9 3 12 3 8.1 3 4.56 4.59 2 7.15zm14.84 2.32c-1.44-.91-3.1-1.4-4.84-1.4-1.74 0-3.41.49-4.85 1.41L4.94 7.26C6.99 5.79 9.44 5 12 5c2.56 0 5 .79 7.05 2.26l-2.21 2.21z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-atm
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 18h16V6H4v12zm5-4h4v-1h-3c-.55 0-1-.45-1-1V9c0-.55.45-1 1-1h1V7h2v1h2v2h-4v1h3c.55 0 1 .45 1 1v3c0 .55-.45 1-1 1h-1v1h-2v-1H9v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6c0-1.11-.89-2-2-2zm0 14H4V6h16v12zm-9-1h2v-1h1c.55 0 1-.45 1-1v-3c0-.55-.45-1-1-1h-3v-1h4V8h-2V7h-2v1h-1c-.55 0-1 .45-1 1v3c0 .55.45 1 1 1h3v1H9v2h2v1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-drink
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 20.01L17 20l1.1-10H5.89L7 20.01zm5-9.41s3 3.4 3 5.4c0 1.66-1.34 3-3 3s-3-1.34-3-3c0-2 3-5.4 3-5.4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5.01 20.23C5.13 21.23 5.97 22 7 22h10c1.03 0 1.87-.77 1.99-1.77L21 2H3l2.01 18.23zM17 20l-10 .01L5.89 10H18.1L17 20zm1.76-16l-.43 4H5.67l-.44-4h13.53zM12 19c1.66 0 3-1.34 3-3 0-2-3-5.4-3-5.4S9 14 9 16c0 1.66 1.34 3 3 3zm0-5.09c.59.91 1 1.73 1 2.09 0 .55-.45 1-1 1s-1-.45-1-1c0-.37.41-1.19 1-2.09z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fire-hydrant-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,4c-1.47,0-2.75,0.81-3.44,2h6.89C14.75,4.81,13.47,4,12,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5",
      :opacity ".3",
      :cy "14",
      :cx "12",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M16,8H8v5H5v2h3v5h8v-5h3v-2h-3V8z M12,17.5c-1.93,0-3.5-1.57-3.5-3.5s1.57-3.5,3.5-3.5s3.5,1.57,3.5,3.5 S13.93,17.5,12,17.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,10.5c-1.93,0-3.5,1.57-3.5,3.5s1.57,3.5,3.5,3.5s3.5-1.57,3.5-3.5S13.93,10.5,12,10.5z M12,15.5 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S12.83,15.5,12,15.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,11h-1V8h2V6h-2.35C16.83,3.67,14.61,2,12,2S7.17,3.67,6.35,6H4v2h2v3H5c-1.1,0-2,0.9-2,2v2c0,1.1,0.9,2,2,2h1v3H4v2 h16v-2h-2v-3h1c1.1,0,2-0.9,2-2v-2C21,11.9,20.1,11,19,11z M12,4c1.47,0,2.75,0.81,3.44,2H8.56C9.25,4.81,10.53,4,12,4z M19,15h-3 v5H8v-5H5v-2h3V8h8v5h3V15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 liquor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "4",
      :x "16",
      :width "1",
      :opacity ".3",
      :height "1",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M6,15c0.55,0,1-0.45,1-1v-1H5v1C5,14.55,5.45,15,6,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "13",
      :width "7",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,14c0,1.3,0.84,2.4,2,2.82V20H3v2h6v-2H7v-3.18C8.16,16.4,9,15.3,9,14V6H3V14z M5,8h2v3H5V8z M5,13h2v1 c0,0.55-0.45,1-1,1s-1-0.45-1-1V13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.64,8.54l-0.96-0.32C19.27,8.08,19,7.7,19,7.27V3c0-0.55-0.45-1-1-1h-3c-0.55,0-1,0.45-1,1v4.28 c0,0.43-0.27,0.81-0.68,0.95l-0.96,0.32C11.55,8.83,11,9.59,11,10.45V20c0,1.1,0.9,2,2,2h7c1.1,0,2-0.9,2-2v-9.56 C22,9.58,21.45,8.82,20.64,8.54z M16,4h1v1h-1V4z M20,20h-7v-2h7V20z M20,16h-7v-2h7V16z M20,12h-7v-1.56l0.95-0.32 C15.18,9.72,16,8.57,16,7.28V7h1v0.28c0,1.29,0.82,2.44,2.05,2.85L20,10.44V12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 emergency-recording
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M4,6v12h12V6H4z M15,13.73l-1,1.73l-3-1.73V17H9v-3.27l-3,1.73l-1-1.73L8,12l-3-1.73l1-1.73l3,1.73V7h2v3.27 l3-1.73l1,1.73L12,12L15,13.73z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M18,10.48V6c0-1.1-0.9-2-2-2H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-4.48l4,3.98v-11L18,10.48z M16,18 H4V6h12V18z M12,12l3,1.73l-1,1.73l-3-1.73V17H9v-3.27l-3,1.73l-1-1.73L8,12l-3-1.73l1-1.73l3,1.73V7h2v3.27l3-1.73l1,1.73L12,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bus-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,16c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2v-3H4V16z M13.5,14c0.83,0,1.5,0.67,1.5,1.5S14.33,17,13.5,17 S12,16.33,12,15.5S12.67,14,13.5,14z M6.5,14C7.33,14,8,14.67,8,15.5S7.33,17,6.5,17S5,16.33,5,15.5S5.67,14,6.5,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4.43,6H11c0-0.33,0.03-0.66,0.08-0.98C7.4,4.91,5.25,5.29,4.43,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4,11V8h7.29C11.1,7.37,11,6.7,11,6H4.43c0.83-0.71,2.98-1.09,6.65-0.98c0.1-0.7,0.3-1.37,0.59-1.99C2.97,2.67,2,5.02,2,7 v9.5c0,0.95,0.38,1.81,1,2.44V21c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-1h8v1c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-2.06 c0.62-0.63,1-1.49,1-2.44V13c-1.91,0-3.63-0.76-4.89-2H4z M16,16c0,1.1-0.9,2-2,2H6c-1.1,0-2-0.9-2-2v-3h12V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "15.5", :cx "6.5", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "15.5", :cx "13.5", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18.5,9h-1V8h1V9z M18.5,7h-1V3h1V7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 restaurant-menu
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.1 13.34l2.83-2.83L3.91 3.5c-1.56 1.56-1.56 4.09 0 5.66l4.19 4.18zm12.05-3.19c1.91-1.91 2.28-4.65.81-6.12-1.46-1.46-4.2-1.1-6.12.81-1.59 1.59-2.09 3.74-1.38 5.27L3.7 19.87l1.41 1.41L12 14.41l6.88 6.88 1.41-1.41L13.41 13l1.47-1.47c1.53.71 3.68.21 5.27-1.38z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 rate-review
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 17.17l.59-.59.58-.58H20V4H4v13.17zM18 14h-7.5l2-2H18v2zM6 11.53l5.88-5.88c.2-.2.51-.2.71 0l1.77 1.77c.2.2.2.51 0 .71L8.47 14H6v-2.47z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.17l-.59.59-.58.58V4h16v12zm-9.5-2H18v-2h-5.5zm3.86-5.87c.2-.2.2-.51 0-.71l-1.77-1.77c-.2-.2-.51-.2-.71 0L6 11.53V14h2.47l5.89-5.87z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 u-turn-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,9v12h-2V9c0-2.21-1.79-4-4-4S8,6.79,8,9v4.17l1.59-1.59L11,13l-4,4l-4-4l1.41-1.41L6,13.17V9c0-3.31,2.69-6,6-6 S18,5.69,18,9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-fire-department
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M16.2,8.65C15.56,9.07,14.8,9.3,14.02,9.3c-2.06,0-3.77-1.55-3.99-3.55C8.13,7.35,6,9.84,6,13 c0,1.79,0.79,3.4,2.04,4.5c-0.04-0.34-0.23-1.88,1.13-3.22l0,0L12,11.5l2.83,2.78l0,0c1.35,1.33,1.17,2.86,1.13,3.21l0,0.01 C17.21,16.4,18,14.79,18,13C18,11.35,17.34,9.78,16.2,8.65z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,14.31l-1.42,1.4C10.2,16.07,10,16.55,10,17.06c0,1.07,0.9,1.94,2,1.94s2-0.87,2-1.94 c0-0.51-0.2-0.99-0.57-1.36L12,14.31z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,6l-0.44,0.55c-0.42,0.52-0.98,0.75-1.54,0.75C13,7.3,12,6.52,12,5.3V2c0,0-8,4-8,11c0,4.42,3.58,8,8,8s8-3.58,8-8 C20,10.04,18.39,7.38,16,6z M12,19c-1.1,0-2-0.87-2-1.94c0-0.51,0.2-0.99,0.58-1.36l1.42-1.4l1.43,1.4 C13.8,16.07,14,16.55,14,17.06C14,18.13,13.1,19,12,19z M15.96,17.5L15.96,17.5c0.04-0.36,0.22-1.89-1.13-3.22l0,0L12,11.5 l-2.83,2.78l0,0c-1.36,1.34-1.17,2.88-1.13,3.22C6.79,16.4,6,14.79,6,13c0-3.16,2.13-5.65,4.03-7.25 c0.23,1.99,1.93,3.55,3.99,3.55c0.78,0,1.54-0.23,2.18-0.66C17.34,9.78,18,11.35,18,13C18,14.79,17.21,16.4,15.96,17.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-location-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:fill-opacity ".3",
    :d
    "M14,4.8V7h3v3h1.41c0.06,0.39,0.09,0.79,0.09,1.2c0,2.57-2.1,5.79-6.16,9.51L12,21.01l-0.34-0.31 C7.6,16.99,5.5,13.77,5.5,11.2c0-3.84,2.82-6.7,6.5-6.7C12.7,4.5,13.37,4.6,14,4.8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20,1v3h3v2h-3v3h-2V6h-3V4h3V1H20z M12,13c-1.1,0-2-0.9-2-2s0.9-2,2-2s2,0.9,2,2S13.1,13,12,13z M14,3.25v2.08 C13.38,5.11,12.7,5,12,5c-3.35,0-6,2.57-6,6.2c0,2.34,1.95,5.44,6,9.14c4.05-3.7,6-6.79,6-9.14c0-0.41-0.03-0.81-0.1-1.2h2.02 c0.05,0.39,0.08,0.79,0.08,1.2c0,3.32-2.67,7.25-8,11.8c-5.33-4.55-8-8.48-8-11.8C4,6.22,7.8,3,12,3C12.68,3,13.35,3.08,14,3.25z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-pharmacy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5.11 19h13.78l-1.79-5.37-.21-.63.21-.63L18.89 7H5.11l1.79 5.37.21.63-.21.63L5.11 19zM8 12h3V9h2v3h3v2h-3v3h-2v-3H8v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 21h18v-2l-2-6 2-6V5h-2.64l1.14-3.14L17.15 1l-1.46 4H3v2l2 6-2 6v2zm3.9-8.63L5.11 7h13.78l-1.79 5.37-.21.63.21.63L18.89 19H5.11l1.79-5.37.21-.63-.21-.63zM11 17h2v-3h3v-2h-3V9h-2v3H8v2h3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 run-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,4c-4.42,0-8,3.58-8,8s3.58,8,8,8s8-3.58,8-8S16.42,4,12,4z M13.5,6c0.55,0,1,0.45,1,1 c0,0.55-0.45,1-1,1s-1-0.45-1-1C12.5,6.45,12.95,6,13.5,6z M16,12c-0.7,0-2.01-0.54-2.91-1.76l-0.41,2.35L14,14.03V18h-1v-3.58 l-1.11-1.21l-0.52,2.64L7.6,15.08l0.2-0.98l2.78,0.57l0.96-4.89L10,10.35V12H9V9.65l3.28-1.21c0.49-0.18,1.03,0.06,1.26,0.53 C14.37,10.67,15.59,11,16,11V12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M12,20c-4.42,0-8-3.58-8-8 s3.58-8,8-8s8,3.58,8,8S16.42,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.54,8.97c-0.23-0.47-0.76-0.71-1.26-0.53L9,9.65V12h1v-1.65l1.54-0.57l-0.96,4.89L7.8,14.1l-0.2,0.98l3.76,0.77 l0.52-2.64L13,14.42V18h1v-3.97l-1.32-1.44l0.41-2.35C13.99,11.46,15.3,12,16,12v-1C15.59,11,14.37,10.67,13.54,8.97z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "7", :cx "13.5", :stroke nil, :fill nil})))))


(helix.core/defnc
 fork-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14.59,15.59L16,17l4-4l-4-4l-1.41,1.41L16.17,12c-1.51-0.33-3.73,0.08-5.17,1.36l0-6.53l1.59,1.59L14,7l-4-4L6,7 l1.41,1.41L9,6.83V21l2,0v-4c0.73-2.58,3.07-3.47,5.17-3L14.59,15.59z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 delivery-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d "M4,13v1h4v-3H6C4.9,11,4,11.9,4,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,7c0-1.1-0.9-2-2-2h-3v2h3v2.65L13.52,14H10V9H6c-2.21,0-4,1.79-4,4v3h2c0,1.66,1.34,3,3,3s3-1.34,3-3h4.48L19,10.35V7 z M7,17c-0.55,0-1-0.45-1-1h2C8,16.55,7.55,17,7,17z M8,14H4v-1c0-1.1,0.9-2,2-2h2V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6", :x "5", :width "5", :height "2", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M19,13c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,13,19,13z M19,17c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S19.55,17,19,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 near-me-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M16.1,10.44l1.5-4.05l-4.05,1.5L16.1,10.44z M14.57,14.57L9.43,9.43l-2.71,1.01l4.89,1.95l1.95,4.89 L14.57,14.57z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,6.34L21,3l-3.34,9l-1.56-1.56l1.5-4.05l-4.05,1.5L12,6.34z M21.19,21.19l-5.07-5.07L14.31,21H12.9l-2.83-7.07L3,11.1 V9.69l4.88-1.81L2.81,2.81l1.41-1.41l18.38,18.38L21.19,21.19z M14.57,14.57L9.43,9.43l-2.71,1.01l4.89,1.95l1.95,4.89L14.57,14.57z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-cafe
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M8 15h6c1.1 0 2-.9 2-2V5H6v8c0 1.1.9 2 2 2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M2 19h18v2H2zm2-6c0 2.21 1.79 4 4 4h6c2.21 0 4-1.79 4-4v-3h2c1.11 0 2-.89 2-2V5c0-1.11-.89-2-2-2H4v10zm14-8h2v3h-2V5zM6 5h10v8c0 1.1-.9 2-2 2H8c-1.1 0-2-.9-2-2V5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 medical-information
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M15,9c0,1.1-0.9,2-2,2h-2c-1.1,0-2-0.9-2-2H4v11h16V9H15z M11,16H9v2H7v-2H5v-2h2v-2h2v2h2V16z M17,17.5h-4 V16h4V17.5z M19,14.5h-6V13h6V14.5z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M20,7h-5V4c0-1.1-0.9-2-2-2h-2C9.9,2,9,2.9,9,4v3H4C2.9,7,2,7.9,2,9v11c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V9 C22,7.9,21.1,7,20,7z M11,4h2v5h-2V4z M20,20H4V9h5c0,1.1,0.9,2,2,2h2c1.1,0,2-0.9,2-2h5V20z M11,16H9v2H7v-2H5v-2h2v-2h2v2h2V16z M13,14.5V13h6v1.5H13z M13,17.5V16h4v1.5H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fort
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M19,8.17L20.17,7h-4.34L17,8.17V12H7V8.17L8.17,7H3.83L5,8.17v7.66l-2,2V19h5v-1c0-2.21,1.79-4,4-4 s4,1.79,4,4v1h5v-1.17l-2-2V8.17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M23,7V3h-2v2h-2V3h-2v2h-2V3h-2v4l2,2v1H9V9l2-2V3H9v2H7V3H5v2H3V3H1v4l2,2v6l-2,2v4h9v-3c0-1.1,0.9-2,2-2s2,0.9,2,2v3h9 v-4l-2-2V9L23,7z M21,19h-5v-1c0-2.21-1.79-4-4-4s-4,1.79-4,4v1H3v-1.17l2-2V8.17L3.83,7h4.34L7,8.17V12h10V8.17L15.83,7h4.34 L19,8.17v7.66l2,2V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-car
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5 17h14v-5H5v5zm11.5-4c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zm-9 0c.83 0 1.5.67 1.5 1.5S8.33 16 7.5 16 6 15.33 6 14.5 6.67 13 7.5 13z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18.92 6.01C18.72 5.42 18.16 5 17.5 5h-11c-.66 0-1.21.42-1.42 1.01L3 12v8c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1h12v1c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-8l-2.08-5.99zM6.85 7h10.29l1.08 3.11H5.77L6.85 7zM19 17H5v-5h14v5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "7.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "16.5", :stroke nil, :fill nil})))


(helix.core/defnc
 map
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 18.31l3-1.16V5.45L5 6.46zm11 .24l3-1.01V5.69l-3 1.17z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20.5 3l-.16.03L15 5.1 9 3 3.36 4.9c-.21.07-.36.25-.36.48V20.5c0 .28.22.5.5.5l.16-.03L9 18.9l6 2.1 5.64-1.9c.21-.07.36-.25.36-.48V3.5c0-.28-.22-.5-.5-.5zM8 17.15l-3 1.16V6.46l3-1.01v11.7zm6 1.38l-4-1.4V5.47l4 1.4v11.66zm5-.99l-3 1.01V6.86l3-1.16v11.84z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 celebration
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "12.35,16.18 7.82,11.65 5.3,18.7",
      :opacity ".3",
      :enable-background "new",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2,22l14-5L7,8L2,22z M12.35,16.18L5.3,18.7l2.52-7.05L12.35,16.18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.53,12.53l5.59-5.59c0.49-0.49,1.28-0.49,1.77,0l0.59,0.59l1.06-1.06l-0.59-0.59c-1.07-1.07-2.82-1.07-3.89,0 l-5.59,5.59L14.53,12.53z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.47,7.47l1.06,1.06l0.59-0.59c1.07-1.07,1.07-2.82,0-3.89l-0.59-0.59L9.47,4.53l0.59,0.59c0.48,0.48,0.48,1.28,0,1.76 L9.47,7.47z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.06,11.88l-1.59,1.59l1.06,1.06l1.59-1.59c0.49-0.49,1.28-0.49,1.77,0l1.61,1.61l1.06-1.06l-1.61-1.61 C19.87,10.81,18.13,10.81,17.06,11.88z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.06,5.88l-3.59,3.59l1.06,1.06l3.59-3.59c1.07-1.07,1.07-2.82,0-3.89l-1.59-1.59l-1.06,1.06l1.59,1.59 C15.54,4.6,15.54,5.4,15.06,5.88z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-subway
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-3.51 0-4.96.48-5.57 1h11.23c-.54-.54-1.95-1-5.66-1zM6 15.5c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5V12H6v3.5zm9.5-2.5c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zm-7 0c.83 0 1.5.67 1.5 1.5S9.33 16 8.5 16 7 15.33 7 14.5 7.67 13 8.5 13z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2c-4 0-8 .5-8 4v9.5C4 17.43 5.57 19 7.5 19L6 20.5v.5h12v-.5L16.5 19c1.93 0 3.5-1.57 3.5-3.5V6c0-3.5-3.58-4-8-4zm0 2c3.71 0 5.12.46 5.66 1H6.43c.61-.52 2.06-1 5.57-1zM6 7h5v3H6V7zm12 8.5c0 .83-.67 1.5-1.5 1.5h-9c-.83 0-1.5-.67-1.5-1.5V12h12v3.5zm0-5.5h-5V7h5v3z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "8.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "15.5", :stroke nil, :fill nil})))


(helix.core/defnc
 sailing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M9,11.5H6.83L9,8.38V11.5z M15.38,5.24c1.42,1.52,2.88,3.72,3.41,6.26h-3.68c0.21-1.1,0.39-2.46,0.39-4 C15.5,6.71,15.45,5.95,15.38,5.24z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M11,13.5V2L3,13.5H11z M9,11.5H6.83L9,8.38V11.5z M21,13.5C21,6.5,14.5,1,12.5,1c0,0,1,3,1,6.5s-1,6-1,6H21z M15.38,5.24 c1.42,1.52,2.88,3.72,3.41,6.26h-3.68c0.21-1.1,0.39-2.46,0.39-4C15.5,6.71,15.45,5.95,15.38,5.24z M22,15H2 c0.31,1.53,1.16,2.84,2.33,3.73C4.98,18.46,5.55,18.01,6,17.5C6.73,18.34,7.8,19,9,19s2.27-0.66,3-1.5c0.73,0.84,1.8,1.5,3,1.5 s2.26-0.66,3-1.5c0.45,0.51,1.02,0.96,1.67,1.23C20.84,17.84,21.69,16.53,22,15z M22,23v-2h-1c-1.04,0-2.08-0.35-3-1 c-1.83,1.3-4.17,1.3-6,0c-1.83,1.3-4.17,1.3-6,0c-0.91,0.65-1.96,1-3,1H2l0,2h1c1.03,0,2.05-0.25,3-0.75c1.89,1,4.11,1,6,0 c1.89,1,4.11,1,6,0h0c0.95,0.5,1.97,0.75,3,0.75H22z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ev-station
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M8 13.5H6V19h6v-8l-4 7zm-2 0L10 6v5h2V5H6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 3H6c-1.1 0-2 .9-2 2v16h10v-7.5h1.5v5c0 1.38 1.12 2.5 2.5 2.5s2.5-1.12 2.5-2.5V9c0-.69-.28-1.32-.73-1.77l.01-.01-3.72-3.72L15 4.56l2.11 2.11c-.94.36-1.61 1.26-1.61 2.33 0 1.38 1.12 2.5 2.5 2.5.36 0 .69-.08 1-.21v7.21c0 .55-.45 1-1 1s-1-.45-1-1V14c0-1.1-.9-2-2-2h-1V5c0-1.1-.9-2-2-2zm0 8v8H6V5h6v6zm6-1c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-8-4l-4 7.5h2V18l4-7h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-offer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M11 4H4v7l9 9.01L20 13l-9-9zM6.5 8C5.67 8 5 7.33 5 6.5S5.67 5 6.5 5 8 5.67 8 6.5 7.33 8 6.5 8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12.41 2.58C12.05 2.22 11.55 2 11 2H4c-1.1 0-2 .9-2 2v7c0 .55.22 1.05.59 1.42l9 9c.36.36.86.58 1.41.58s1.05-.22 1.41-.59l7-7c.37-.36.59-.86.59-1.41s-.23-1.06-.59-1.42l-9-9zM13 20.01 4 11V4h7v-.01l9 9-7 7.02z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "6.5", :cx "6.5", :stroke nil, :fill nil})))


(helix.core/defnc
 _360
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 16.77V20l4-4-4-4v2.73c-3.15-.56-5-1.9-5-2.73 0-1.06 3.04-3 8-3s8 1.94 8 3c0 .73-1.46 1.89-4 2.53v2.05c3.53-.77 6-2.53 6-4.58 0-2.76-4.48-5-10-5S2 9.24 2 12c0 2.24 2.94 4.13 7 4.77z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 zoom-out-map
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.3 5.3l-2.89 2.87 1.42 1.42L18.7 6.7 21 9V3h-6zM9 3H3v6l2.3-2.3 2.87 2.89 1.42-1.42L6.7 5.3zm-.83 11.41L5.3 17.3 3 15v6h6l-2.3-2.3 2.89-2.87zm7.66 0l-1.42 1.42 2.89 2.87L15 21h6v-6l-2.3 2.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 alt-route
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M9.78,11.16l-1.42,1.42c-0.68-0.69-1.34-1.58-1.79-2.94l1.94-0.49C8.83,10.04,9.28,10.65,9.78,11.16z M11,6L7,2L3,6h3.02 C6.04,6.81,6.1,7.54,6.21,8.17l1.94-0.49C8.08,7.2,8.03,6.63,8.02,6H11z M21,6l-4-4l-4,4h2.99c-0.1,3.68-1.28,4.75-2.54,5.88 c-0.5,0.44-1.01,0.92-1.45,1.55c-0.34-0.49-0.73-0.88-1.13-1.24L9.46,13.6C10.39,14.45,11,15.14,11,17c0,0,0,0,0,0h0v5h2v-5 c0,0,0,0,0,0c0-2.02,0.71-2.66,1.79-3.63c1.38-1.24,3.08-2.78,3.2-7.37H21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 synagogue
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M4,6C3.45,6,3,6.45,3,7v1h2V7C5,6.45,4.55,6,4,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "3",
      :width "2",
      :opacity ".3",
      :height "9",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M7,9.92V19h2v-3c0-1.65,1.35-3,3-3c1.65,0,3,1.35,3,3v3h2V9.92l-5-4.29L7,9.92z M13.5,10 c0,0.83-0.67,1.5-1.5,1.5s-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5S13.5,9.17,13.5,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M20,6c-0.55,0-1,0.45-1,1v1h2V7C21,6.45,20.55,6,20,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "19",
      :width "2",
      :opacity ".3",
      :height "9",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,4c-1.66,0-3,1.34-3,3v0.29L12,3L7,7.29V7c0-1.66-1.34-3-3-3S1,5.34,1,7v14h10v-5c0-0.55,0.45-1,1-1s1,0.45,1,1v5h10V7 C23,5.34,21.66,4,20,4z M5,19H3v-9h2V19z M5,8H3V7c0-0.55,0.45-1,1-1s1,0.45,1,1V8z M17,19h-2v-3c0-1.65-1.35-3-3-3 c-1.65,0-3,1.35-3,3v3H7V9.92l5-4.29l5,4.29V19z M21,19h-2v-9h2V19z M21,8h-2V7c0-0.55,0.45-1,1-1s1,0.45,1,1V8z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "10", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 local-hotel
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1", :opacity ".3", :cy "11", :cx "7", :stroke nil, :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M19 9h-6v6h8v-4c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 11c0 1.66 1.34 3 3 3s3-1.34 3-3-1.34-3-3-3-3 1.34-3 3zm4 0c0 .55-.45 1-1 1s-1-.45-1-1 .45-1 1-1 1 .45 1 1zm11-4h-8v8H3V5H1v15h2v-3h18v3h2v-9c0-2.21-1.79-4-4-4zm2 8h-8V9h6c1.1 0 2 .9 2 2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 home-repair-service
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M20,8h-3V6c0-1.1-0.9-2-2-2H9C7.9,4,7,4.9,7,6v2H4c-1.1,0-2,0.9-2,2v10h20V10C22,8.9,21.1,8,20,8z M9,6h6v2H9V6z M20,18 H4v-3h2v1h2v-1h8v1h2v-1h2V18z M20,13h-2v-1h-2v1H8v-1H6v1H4v-3h3h10h3V13z",
       :stroke nil,
       :fill nil})))
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/polygon
      {:points
       "18,16 16,16 16,15 8,15 8,16 6,16 6,15 4,15 4,18 20,18 20,15 18,15",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/polygon
      {:points
       "4,10 4,13 6,13 6,12 8,12 8,13 16,13 16,12 18,12 18,13 20,13 20,10 17,10 7,10",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 money
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M10 10h1v4h-1zm6 0h1v4h-1zM4 18h16V6H4v12zm10-9c0-.55.45-1 1-1h3c.55 0 1 .45 1 1v6c0 .55-.45 1-1 1h-3c-.55 0-1-.45-1-1V9zM8 9c0-.55.45-1 1-1h3c.55 0 1 .45 1 1v6c0 .55-.45 1-1 1H9c-.55 0-1-.45-1-1V9zM5 8h2v8H5V8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15 16h3c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1h-3c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1zm1-6h1v4h-1v-4zm-7 6h3c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1H9c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1zm1-6h1v4h-1v-4zM5 8h2v8H5zM2 4v16h20V4H2zm18 14H4V6h16v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 edit-attributes
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M17.63 9H6.37C5.09 9 4 10.37 4 12s1.09 3 2.37 3h11.26c1.28 0 2.37-1.37 2.37-3s-1.09-3-2.37-3zM7.24 14.46l-2.57-2.57.7-.7 1.87 1.87 3.52-3.52.7.7-4.22 4.22z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17.63 7H6.37C3.96 7 2 9.24 2 12s1.96 5 4.37 5h11.26c2.41 0 4.37-2.24 4.37-5s-1.96-5-4.37-5zm0 8H6.37C5.09 15 4 13.63 4 12s1.09-3 2.37-3h11.26C18.91 9 20 10.37 20 12s-1.09 3-2.37 3zM7.24 13.06l-1.87-1.87-.7.7 2.57 2.57 4.22-4.22-.7-.7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 temple-hindu
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "13.51,5 10.49,5 9.89,7 14.11,7",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "14.71,9 9.29,9 8.69,11 15.31,11",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "15.91,13 8.09,13 7.49,15 4,15 4,20 9,20 9,15 15,15 15,20 20,20 20,15 16.51,15",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20 11v2h-2L15 3V1h-2v2h-2.03V1h-2v2.12L6 13H4v-2H2v11h9v-5h2v5h9V11h-2zm-9.51-6h3.02l.6 2H9.89l.6-2zm-1.2 4h5.42l.6 2H8.69l.6-2zM20 20h-5v-5H9v5H4v-5h3.49l.6-2h7.82l.6 2H20v5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-movies
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M10 5h4v14h-4z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M20 21V3h-2v2h-2V3H8v2H6V3H4v18h2v-2h2v2h8v-2h2v2h2zM8 17H6v-2h2v2zm0-4H6v-2h2v2zm0-4H6V7h2v2zm6 10h-4V5h4v14zm2-12h2v2h-2V7zm0 4h2v2h-2v-2zm0 6v-2h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 terrain
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 16h3.04l-1.52-2.03z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9.78 11.63l1.25 1.67L14 9.33 19 16h-8.46l-4.01-5.37L1 18h22L14 6l-4.22 5.63zM5 16l1.52-2.03L8.04 16H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 icecream
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M9.32,13.42l2.73,5.21l2.67-5.23C13.88,13.79,12.95,14,12,14 C11.06,14,10.15,13.79,9.32,13.42z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M17.31,8.02L16.54,7.9l-0.06-0.78C16.29,4.8,14.34,3,12,3S7.71,4.8,7.51,7.12 L7.45,7.9L6.68,8.03C5.72,8.18,5,9.02,5,10c0,1.11,0.9,2,2,2c0.52,0,1.01-0.21,1.39-0.56l0.56-0.54l0.66,0.41 C10.32,11.76,11.14,12,12,12s1.68-0.24,2.39-0.68l0.66-0.42l0.56,0.54C15.99,11.8,16.48,12,17,12c1.1,0,2-0.9,2-2 C19,9.01,18.28,8.18,17.31,8.02z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.38,6.24C17.79,3.24,15.14,1,12,1S6.21,3.24,5.62,6.24C4.08,6.81,3,8.29,3,10c0,2.21,1.79,4,4,4 c0.12,0,0.23-0.02,0.34-0.02L12.07,23l4.61-9.03C16.79,13.98,16.89,14,17,14c2.21,0,4-1.79,4-4C21,8.29,19.92,6.81,18.38,6.24z M12.05,18.63l-2.73-5.21C10.15,13.79,11.06,14,12,14c0.95,0,1.88-0.21,2.72-0.6L12.05,18.63z M17,12c-0.52,0-1.01-0.2-1.39-0.56 l-0.56-0.54l-0.66,0.42C13.68,11.76,12.86,12,12,12s-1.68-0.24-2.39-0.69L8.95,10.9l-0.56,0.54C8.01,11.79,7.52,12,7,12 c-1.1,0-2-0.89-2-2c0-0.98,0.72-1.82,1.68-1.97L7.45,7.9l0.06-0.78C7.71,4.8,9.66,3,12,3s4.29,1.8,4.48,4.12l0.06,0.78l0.77,0.12 C18.28,8.18,19,9.01,19,10C19,11.1,18.1,12,17,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 satellite
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5 19h14V5H5v14zM6 6h2.57c0 1.42-1.15 2.58-2.57 2.58V6zm0 4.29c2.37 0 4.28-1.93 4.28-4.29H12c0 3.31-2.68 6-6 6v-1.71zm3 2.86l2.14 2.58 3-3.86L18 17H6l3-3.85z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zM8.57 6H6v2.58c1.42 0 2.57-1.16 2.57-2.58zM12 6h-1.72c0 2.36-1.91 4.29-4.28 4.29V12c3.32 0 6-2.69 6-6zm2.14 5.86l-3 3.87L9 13.15 6 17h12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-parking
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 3H6v18h4v-6h3c3.31 0 6-2.69 6-6s-2.69-6-6-6zm.2 8H10V7h3.2c1.1 0 2 .9 2 2s-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 train
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-3.51 0-4.96.48-5.57 1h11.13c-.6-.52-2.05-1-5.56-1zM6 15.5c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5V12H6v3.5zm9.5-2.5c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zm-7 0c.83 0 1.5.67 1.5 1.5S9.33 16 8.5 16 7 15.33 7 14.5 7.67 13 8.5 13z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "8.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "15.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 2c-4 0-8 .5-8 4v9.5C4 17.43 5.57 19 7.5 19L6 20.5v.5h2l2-2h4l2 2h2v-.5L16.5 19c1.93 0 3.5-1.57 3.5-3.5V6c0-3.5-4-4-8-4zm0 2c3.51 0 4.96.48 5.57 1H6.43c.61-.52 2.06-1 5.57-1zM6 7h5v3H6V7zm12 8.5c0 .83-.67 1.5-1.5 1.5h-9c-.83 0-1.5-.67-1.5-1.5V12h12v3.5zm0-5.5h-5V7h5v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 layers-clear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 13.47l.67-.53-5.02-5.02L6.26 9zm0-8.94l-1.17.91 5.02 5.03L17.74 9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 4.53L17.74 9l-1.89 1.47 1.43 1.42L21 9l-9-7-2.59 2.02 1.42 1.42zm9 9.54l-1.63-1.27-.67.52 1.43 1.43zM3.41.86L2 2.27l4.22 4.22L3 9l9 7 2.1-1.63 1.42 1.42-3.53 2.75-7.37-5.73L3 14.07l9 7 4.95-3.85L20.73 21l1.41-1.41L3.41.86zM12 13.47L6.26 9l1.39-1.08 5.02 5.02-.67.53z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mode-of-travel
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15.31,18.9c-0.96,1-2.06,2.03-3.31,3.1c-5.33-4.55-8-8.48-8-11.8C4,5.22,7.8,2,12,2c4,0,7.64,2.92,7.97,7.5l3.53,0L19,14 l-4.5-4.5l3.47,0C17.65,6.24,15.13,4,12,4c-3.35,0-6,2.57-6,6.2c0,2.34,1.95,5.44,6,9.14c0.64-0.59,1.23-1.16,1.77-1.71 c-0.17-0.34-0.27-0.72-0.27-1.12c0-1.38,1.12-2.5,2.5-2.5s2.5,1.12,2.5,2.5S17.38,19,16,19C15.76,19,15.53,18.97,15.31,18.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 beenhere
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 3H5v12.93l7 4.66 7-4.67V3zm-9 13l-4-4 1.41-1.41 2.58 2.58 6.59-6.59L18 8l-8 8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 1H5c-1.1 0-1.99.9-1.99 2L3 15.93c0 .69.35 1.3.88 1.66L12 23l8.11-5.41c.53-.36.88-.97.88-1.66L21 3c0-1.1-.9-2-2-2zm-7 19.6l-7-4.66V3h14v12.93l-7 4.67zm-2.01-7.42l-2.58-2.59L6 12l4 4 8-8-1.42-1.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 museum
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M6,20h12V9H6V20z M8,11h2l2,3l2-3h2v7h-2v-4l-2,3l-2-3v4H8V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,11V9L12,2L2,9v2h2v9H2v2h20v-2h-2v-9H22z M18,20H6V9h12V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "10,14 12,17 14,14 14,18 16,18 16,11 14,11 12,14 10,11 8,11 8,18 10,18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 egg-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d
       "M17.59,10.42c-0.69-0.68-1.21-1.51-1.76-2.39C14.48,5.86,13.31,4,9.97,4C8.35,4,7.01,4.52,5.99,5.55 C4.68,6.88,3.97,8.99,4,11.5C4.05,16.01,8.33,17,9.97,17c1.69,0,2.68,1.05,3.34,1.74C14.03,19.5,14.5,20,15.99,20 c1.89,0,4.01-2.13,4.01-4.98C20,12.82,19.49,12.31,17.59,10.42z M12,15.5c-1.93,0-3.5-1.57-3.5-3.5s1.57-3.5,3.5-3.5 s3.5,1.57,3.5,3.5S13.93,15.5,12,15.5z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,9C17,7,15.99,2,9.97,2C4.95,2,1.94,6,2,11.52C2.06,17.04,6.96,19,9.97,19c2.01,0,2.01,3,6.02,3C19,22,22,19,22,15.02 C22,12,21.01,11,19,9z M15.99,20c-1.49,0-1.96-0.5-2.68-1.26C12.66,18.05,11.66,17,9.97,17C8.33,17,4.05,16.01,4,11.5 C3.97,8.99,4.68,6.88,5.99,5.55C7.01,4.52,8.35,4,9.97,4c3.34,0,4.51,1.86,5.86,4.02c0.55,0.88,1.07,1.71,1.76,2.39 c1.9,1.89,2.41,2.4,2.41,4.61C20,17.87,17.88,20,15.99,20z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/circle
      {:r "3.5", :cy "12", :cx "12", :stroke nil, :fill nil}))))))


(helix.core/defnc
 directions-bus-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    {:enable-background "new"}
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M6,15c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2v-3H6V15z M15.5,13 c0.83,0,1.5,0.67,1.5,1.5S16.33,16,15.5,16S14,15.33,14,14.5S14.67,13,15.5,13z M8.5,13c0.83,0,1.5,0.67,1.5,1.5S9.33,16,8.5,16 S7,15.33,7,14.5S7.67,13,8.5,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M12,4C8.48,4,7.03,4.48,6.43,5h11.24C17.13,4.46,15.71,4,12,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C8,2,4,2.5,4,6v9.5c0,0.95,0.38,1.81,1,2.44V20c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-1h8v1c0,0.55,0.45,1,1,1h1 c0.55,0,1-0.45,1-1v-2.06c0.62-0.63,1-1.49,1-2.44V6C20,2.5,16.42,2,12,2z M12,4c3.71,0,5.13,0.46,5.67,1H6.43 C7.03,4.48,8.48,4,12,4z M18,15c0,1.1-0.9,2-2,2H8c-1.1,0-2-0.9-2-2v-3h12V15z M18,10H6V7h12V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "8.5", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "15.5", :stroke nil, :fill nil})))))


(helix.core/defnc
 safety-check
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M12,4.14L6,6.39v4.7c0,4,2.55,7.7,6,8.83c3.45-1.13,6-4.82,6-8.83v-4.7L12,4.14z M12,17c-2.76,0-5-2.24-5-5 s2.24-5,5-5s5,2.24,5,5S14.76,17,12,17z M13.65,14.35l-2.15-2.15V9h1v2.79l1.85,1.85L13.65,14.35z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M12,2L4,5v6.09c0,5.05,3.41,9.76,8,10.91c4.59-1.15,8-5.86,8-10.91V5L12,2z M18,11.09c0,4-2.55,7.7-6,8.83 c-3.45-1.13-6-4.82-6-8.83v-4.7l6-2.25l6,2.25V11.09z M12,7c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S14.76,7,12,7z M13.65,14.35 l-2.15-2.15V9h1v2.79l1.85,1.85L13.65,14.35z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-airport
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,16v-2l-8.5-5V3.5C13.5,2.67,12.83,2,12,2s-1.5,0.67-1.5,1.5V9L2,14v2l8.5-2.5V19L8,20.5L8,22l4-1l4,1l0-1.5L13.5,19 v-5.5L22,16z",
     :stroke nil,
     :fill nil})
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))))


(helix.core/defnc
 directions-subway-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M13,5h4.67C17.13,4.46,15.71,4,12,4C8.48,4,7.03,4.48,6.43,5H11H13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M6,15.5C6,16.33,6.67,17,7.5,17h9c0.83,0,1.5-0.67,1.5-1.5V12H6V15.5z M15.5,13c0.83,0,1.5,0.67,1.5,1.5S16.33,16,15.5,16S14,15.33,14,14.5S14.67,13,15.5,13z M8.5,13c0.83,0,1.5,0.67,1.5,1.5 S9.33,16,8.5,16S7,15.33,7,14.5S7.67,13,8.5,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C8,2,4,2.5,4,6v9.5C4,17.43,5.57,19,7.5,19L6,20v1h12v-1l-1.5-1c1.93,0,3.5-1.57,3.5-3.5V6C20,2.5,16.42,2,12,2z M12,4c3.71,0,5.13,0.46,5.67,1H13h-2H6.43C7.03,4.48,8.48,4,12,4z M6,7h5v3H6V7z M18,15.5c0,0.83-0.67,1.5-1.5,1.5h-9 C6.67,17,6,16.33,6,15.5V12h12V15.5z M18,10h-5V7h5V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "8.5", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "15.5", :stroke nil, :fill nil})))))


(helix.core/defnc
 person-pin-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:fill-opacity ".3",
    :d
    "M18.5 10.2c0 2.57-2.1 5.79-6.16 9.51l-.34.3-.34-.31C7.6 15.99 5.5 12.77 5.5 10.2c0-3.84 2.82-6.7 6.5-6.7s6.5 2.85 6.5 6.7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 11c1.33 0 4 .67 4 2v.16c-.97 1.12-2.4 1.84-4 1.84s-3.03-.72-4-1.84V13c0-1.33 2.67-2 4-2zm0-1c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm6 .2C18 6.57 15.35 4 12 4s-6 2.57-6 6.2c0 2.34 1.95 5.44 6 9.14 4.05-3.7 6-6.8 6-9.14zM12 2c4.2 0 8 3.22 8 8.2 0 3.32-2.67 7.25-8 11.8-5.33-4.55-8-8.48-8-11.8C4 5.22 7.8 2 12 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 trip-origin
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 16c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 plumbing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.28,4.93l-2.12-2.12c-0.78-0.78-2.05-0.78-2.83,0L11.5,5.64l2.12,2.12l2.12-2.12l3.54,3.54 C20.45,8,20.45,6.1,19.28,4.93z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5.49,13.77c0.59,0.59,1.54,0.59,2.12,0l2.47-2.47L7.96,9.17l-2.47,2.47C4.9,12.23,4.9,13.18,5.49,13.77L5.49,13.77z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.04,7.76l-0.71,0.71l-0.71,0.71l-3.18-3.18C9.85,5.4,8.9,5.4,8.32,5.99c-0.59,0.59-0.59,1.54,0,2.12l3.18,3.18 L10.79,12l-6.36,6.36c-0.78,0.78-0.78,2.05,0,2.83c0.78,0.78,2.05,0.78,2.83,0L16.45,12c0.39,0.39,1.02,0.39,1.41,0 c0.39-0.39,0.39-1.02,0-1.41L15.04,7.76z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-car
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,13h14V8H5V13z M16.5,9c0.83,0,1.5,0.67,1.5,1.5c0,0.83-0.67,1.5-1.5,1.5S15,11.33,15,10.5 C15,9.67,15.67,9,16.5,9z M7.5,9C8.33,9,9,9.67,9,10.5C9,11.33,8.33,12,7.5,12S6,11.33,6,10.5C6,9.67,6.67,9,7.5,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.92,2.01C18.72,1.42,18.16,1,17.5,1h-11C5.84,1,5.29,1.42,5.08,2.01L3,8v8c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-1 h12v1c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1V8L18.92,2.01z M6.85,3h10.29l1.08,3.11H5.77L6.85,3z M19,13H5V8h14V13z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "10.5", :cx "7.5", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "10.5", :cx "16.5", :stroke nil, :fill nil}))
   (helix.dom/polygon
    {:points "7,20 11,20 11,18 17,21 13,21 13,23",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 nightlife
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M1,5h14l-6,9v4h2v2H5v-2h2v-4L1,5z M10.1,9l1.4-2H4.49l1.4,2H10.1z M17,5h5v3h-3v9l0,0c0,1.66-1.34,3-3,3s-3-1.34-3-3 s1.34-3,3-3c0.35,0,0.69,0.06,1,0.17V5z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 breakfast-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M18,5H6C4.9,5,4,5.9,4,7c0,0.71,0.38,1.35,1.01,1.73L6,9.31V19h12V9.3l1-0.58c0.63-0.36,1-1.01,1-1.72 C20,5.9,19.1,5,18,5z M15.71,13.7l-3,3C12.51,16.9,12.26,17,12,17s-0.51-0.1-0.71-0.29l-3-3c-0.39-0.39-0.39-1.02,0-1.41l3-3 C11.49,9.1,11.74,9,12,9s0.51,0.1,0.71,0.29l3,3C16.1,12.68,16.1,13.31,15.71,13.7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,3H6C3.79,3,2,4.79,2,7c0,1.48,0.81,2.75,2,3.45V19c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-8.55c1.19-0.69,2-1.97,2-3.45 C22,4.79,20.21,3,18,3z M19,8.72L18,9.3V19H6V9.31L5.01,8.73C4.38,8.35,4,7.71,4,7c0-1.1,0.9-2,2-2h12c1.1,0,2,0.9,2,2 C20,7.71,19.62,8.36,19,8.72z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12.71,9.29C12.51,9.1,12.26,9,12,9s-0.51,0.1-0.71,0.29l-3,3c-0.39,0.39-0.39,1.02,0,1.41l3,3C11.49,16.9,11.74,17,12,17 s0.51-0.1,0.71-0.29l3-3c0.39-0.39,0.39-1.02,0-1.41L12.71,9.29z M12,14.58L10.41,13L12,11.41L13.59,13L12,14.58z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-play
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4.01 8.54C5.2 9.23 6 10.52 6 12s-.81 2.77-2 3.46V18h16v-2.54c-1.19-.69-2-1.99-2-3.46s.81-2.77 2-3.46V6H4l.01 2.54zm6.72 1.68L12 7l1.26 3.23 3.47.2-2.69 2.2.89 3.37L12 14.12 9.07 16l.88-3.37-2.69-2.2 3.47-.21z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-1.99.9-1.99 2v4c1.1 0 1.99.9 1.99 2s-.89 2-2 2v4c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-4c-1.1 0-2-.9-2-2s.9-2 2-2V6c0-1.1-.9-2-2-2zm0 4.54c-1.19.69-2 1.99-2 3.46s.81 2.77 2 3.46V18H4v-2.54c1.19-.69 2-1.99 2-3.46 0-1.48-.8-2.77-1.99-3.46L4 6h16v2.54zM9.07 16L12 14.12 14.93 16l-.89-3.36 2.69-2.2-3.47-.21L12 7l-1.27 3.22-3.47.21 2.69 2.2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 festival
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5.24,14.42C5.2,16.18,5.06,18.14,4.66,20h2.67c0.27-1.94,0.43-4.07,0.52-5.93C7.54,13.9,7.25,13.7,7,13.44 C6.53,13.93,5.92,14.27,5.24,14.42z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M11,11H8c0,0.83,0.67,1.5,1.5,1.5S11,11.83,11,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M6,11H3c0,0.83,0.67,1.5,1.5,1.5S6,11.83,6,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,4.71C10.67,5.85,8.51,7.55,5.89,9h12.23C15.49,7.55,13.33,5.85,12,4.71z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M19.5,12.5c0.83,0,1.5-0.67,1.5-1.5h-3C18,11.83,18.67,12.5,19.5,12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M14.5,12.5c0.83,0,1.5-0.67,1.5-1.5h-3C13,11.83,13.67,12.5,14.5,12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17,13.44c-0.25,0.25-0.54,0.45-0.85,0.62c0.1,1.87,0.26,4,0.52,5.93h2.67c-0.39-1.86-0.54-3.82-0.57-5.58 C18.08,14.27,17.47,13.93,17,13.44z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2c0,0-5,5-11,7v2c0,1.49,0.93,2.75,2.24,3.26C3.2,16.76,2.92,19.69,2,22h20c-0.92-2.31-1.2-5.24-1.24-7.74 C22.07,13.75,23,12.49,23,11V9C17,7,12,2,12,2z M12,4.71c1.33,1.14,3.49,2.84,6.11,4.29H5.89C8.51,7.55,10.67,5.85,12,4.71z M3,11 h3c0,0.83-0.67,1.5-1.5,1.5S3,11.83,3,11z M7.33,20H4.66c0.39-1.86,0.54-3.82,0.57-5.58c0.68-0.15,1.29-0.49,1.76-0.98 c0.25,0.25,0.54,0.45,0.85,0.62C7.76,15.93,7.6,18.06,7.33,20z M8,11h3c0,0.83-0.67,1.5-1.5,1.5S8,11.83,8,11z M9.35,20 c0.24-1.83,0.39-3.78,0.48-5.53c0.84-0.08,1.61-0.45,2.17-1.02c0.56,0.57,1.32,0.94,2.17,1.02c0.1,1.75,0.24,3.7,0.48,5.53H9.35z M14.5,12.5c-0.83,0-1.5-0.67-1.5-1.5h3C16,11.83,15.33,12.5,14.5,12.5z M16.67,20c-0.27-1.94-0.43-4.07-0.52-5.93 c0.31-0.17,0.61-0.37,0.85-0.62c0.47,0.48,1.08,0.83,1.76,0.98c0.03,1.76,0.18,3.72,0.57,5.58H16.67z M19.5,12.5 c-0.83,0-1.5-0.67-1.5-1.5h3C21,11.83,20.33,12.5,19.5,12.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 castle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17,7H7v6H3v6h5v-1c0-2.21,1.79-4,4-4s4,1.79,4,4v1h5v-6h-4V7z M11,12H9V9h2V12z M15,12h-2V9h2V12z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M21,9v2h-2V3h-2v2h-2V3h-2v2h-2V3H9v2H7V3H5v8H3V9H1v12h9v-3c0-1.1,0.9-2,2-2s2,0.9,2,2v3h9V9H21z M21,19h-5v-1 c0-2.21-1.79-4-4-4s-4,1.79-4,4v1H3v-6h4V7h10v6h4V19z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/rect
      {:y "9",
       :x "9",
       :width "2",
       :height "3",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/rect
      {:y "9",
       :x "13",
       :width "2",
       :height "3",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 pin-drop
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:fill-opacity ".3",
    :d
    "M12 3C9.19 3 6 5.11 6 9.13c0 2.68 2 5.49 6 8.44 4-2.95 6-5.77 6-8.44C18 5.11 14.81 3 12 3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 4c1.93 0 5 1.4 5 5.15 0 2.16-1.72 4.67-5 7.32-3.28-2.65-5-5.17-5-7.32C7 5.4 10.07 4 12 4m0-2C8.73 2 5 4.46 5 9.15c0 3.12 2.33 6.41 7 9.85 4.67-3.44 7-6.73 7-9.85C19 4.46 15.27 2 12 2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 7c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zM5 20h14v2H5v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-mall
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5 8v12h14V8H5zm7 6c-2.76 0-5-2.24-5-5h2c0 1.66 1.34 3 3 3s3-1.34 3-3h2c0 2.76-2.24 5-5 5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17 6c0-2.76-2.24-5-5-5S7 3.24 7 6H5c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2h-2zm-5-3c1.66 0 3 1.34 3 3H9c0-1.66 1.34-3 3-3zm7 17H5V8h14v12zm-7-8c-1.66 0-3-1.34-3-3H7c0 2.76 2.24 5 5 5s5-2.24 5-5h-2c0 1.66-1.34 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 snowmobile
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M17,14h-6.7l-7.45-2.23l0.31-0.62L11.6,12l3.93-2.94c0,0,3.77,3.44,4.27,4.14C19.8,13.2,18.7,14,17,14z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M22,17c0,0.55-0.45,1-1,1h-0.17l-2.2-2.2C20.58,15.37,22,14.4,22,13c0-1-8-8-8-8h-3v2h2.25l0.8,0.72L11,10L2,9l-2,4 l4.54,1.36l-3.49,1.88C-0.77,17.22-0.07,20,2,20h6c2.21,0,4-1.79,4-4h4l2,2h-3v2h6c1.66,0,3-1.34,3-3H22z M8,18H2l5.25-2.83L10,16 C10,17.1,9.11,18,8,18z M17,14h-6.7l-7.45-2.23l0.31-0.62L11.6,12l3.93-2.94c0,0,3.77,3.44,4.27,4.14C19.8,13.2,18.7,14,17,14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-dining
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.11 21.28L12 14.41l6.88 6.88 1.41-1.41L13.41 13l1.47-1.47c1.53.71 3.68.21 5.27-1.38 1.91-1.91 2.28-4.65.81-6.12-1.46-1.46-4.2-1.1-6.12.81-1.59 1.59-2.09 3.74-1.38 5.27L3.7 19.87l1.41 1.41zM3.91 9.16l4.19 4.18 2.83-2.83L3.91 3.5c-1.56 1.56-1.56 4.09 0 5.66z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 warehouse
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,8.35V19h-2v-8H6v8H4V8.35l8-3.2L20,8.35z M22,21V7L12,3L2,7v14h6v-8h8v8H22z M11,19H9v2h2V19z M13,16h-2v2h2V16z M15,19h-2v2h2V19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 menu-book
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,5c-1.11-0.35-2.33-0.5-3.5-0.5c-1.95,0-4.05,0.4-5.5,1.5c-1.45-1.1-3.55-1.5-5.5-1.5S2.45,4.9,1,6v14.65 c0,0.25,0.25,0.5,0.5,0.5c0.1,0,0.15-0.05,0.25-0.05C3.1,20.45,5.05,20,6.5,20c1.95,0,4.05,0.4,5.5,1.5c1.35-0.85,3.8-1.5,5.5-1.5 c1.65,0,3.35,0.3,4.75,1.05c0.1,0.05,0.15,0.05,0.25,0.05c0.25,0,0.5-0.25,0.5-0.5V6C22.4,5.55,21.75,5.25,21,5z M3,18.5V7 c1.1-0.35,2.3-0.5,3.5-0.5c1.34,0,3.13,0.41,4.5,0.99v11.5C9.63,18.41,7.84,18,6.5,18C5.3,18,4.1,18.15,3,18.5z M21,18.5 c-1.1-0.35-2.3-0.5-3.5-0.5c-1.34,0-3.13,0.41-4.5,0.99V7.49c1.37-0.59,3.16-0.99,4.5-0.99c1.2,0,2.4,0.15,3.5,0.5V18.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M11,7.49C9.63,6.91,7.84,6.5,6.5,6.5C5.3,6.5,4.1,6.65,3,7v11.5C4.1,18.15,5.3,18,6.5,18 c1.34,0,3.13,0.41,4.5,0.99V7.49z",
      :stroke nil,
      :fill nil}))
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.5,10.5c0.88,0,1.73,0.09,2.5,0.26V9.24C19.21,9.09,18.36,9,17.5,9c-1.28,0-2.46,0.16-3.5,0.47v1.57 C14.99,10.69,16.18,10.5,17.5,10.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.5,13.16c0.88,0,1.73,0.09,2.5,0.26V11.9c-0.79-0.15-1.64-0.24-2.5-0.24c-1.28,0-2.46,0.16-3.5,0.47v1.57 C14.99,13.36,16.18,13.16,17.5,13.16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.5,15.83c0.88,0,1.73,0.09,2.5,0.26v-1.52c-0.79-0.15-1.64-0.24-2.5-0.24c-1.28,0-2.46,0.16-3.5,0.47v1.57 C14.99,16.02,16.18,15.83,17.5,15.83z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 edit-road
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "15.55,17.42 15.55,18.45 16.58,18.45 20.03,15 19,13.97",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "18,4 16,4 16,11.9 18,9.9", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "4",
      :width "2",
      :height "16",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "10",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "10",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "16",
      :x "10",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.56,12.59l-1.15-1.15c-0.59-0.59-1.54-0.59-2.12,0L14,16.73V20h3.27l5.29-5.29C23.15,14.12,23.15,13.17,22.56,12.59z M16.58,18.45h-1.03v-1.03L19,13.97L20.03,15L16.58,18.45z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-rickshaw
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:opacity ".3",
       :enable-background "new",
       :d
       "M3,13h0.17C3.58,11.84,4.7,11,6,11c0.35,0,0.69,0.06,1,0.17V10H3V13z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:opacity ".3",
       :enable-background "new",
       :d "M19,11h-3v2h1.17c0.3-0.85,0.98-1.53,1.83-1.83V11z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M21,11.18V9.72c0-0.47-0.16-0.92-0.46-1.28L16.6,3.72C16.22,3.26,15.66,3,15.06,3H3C1.9,3,1,3.9,1,5v8c0,1.1,0.9,2,2,2 h0.18C3.6,16.16,4.7,17,6,17s2.4-0.84,2.82-2h8.37c0.41,1.16,1.51,2,2.82,2c1.66,0,3-1.34,3-3C23,12.7,22.16,11.6,21,11.18z M6,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S6.55,15,6,15z M7,11.17C6.69,11.06,6.35,11,6,11c-1.3,0-2.42,0.84-2.83,2H3v-3 h4V11.17z M7,8H3V5h4V8z M14,13H9v-3h3V8H9V5h5V13z M16,6.12L18.4,9H16V6.12z M17.17,13H16v-2h3v0.17 C18.15,11.47,17.47,12.15,17.17,13z M20,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S20.55,15,20,15z",
       :stroke nil,
       :fill nil}))
    (helix.dom/polygon
     {:points "7,20 11,20 11,18 17,21 13,21 13,23",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 place
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:fill-opacity ".3",
    :d
    "M18.5 10.2c0 2.57-2.1 5.79-6.16 9.51l-.34.3-.34-.31C7.6 15.99 5.5 12.77 5.5 10.2c0-3.84 2.82-6.7 6.5-6.7s6.5 2.85 6.5 6.7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2c4.2 0 8 3.22 8 8.2 0 3.32-2.67 7.25-8 11.8-5.33-4.55-8-8.48-8-11.8C4 5.22 7.8 2 12 2zm6 8.2C18 6.57 15.35 4 12 4s-6 2.57-6 6.2c0 2.34 1.95 5.44 6 9.14 4.05-3.7 6-6.8 6-9.14zM12 12c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 near-me
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M11.39 12.61l.32.83 1.32 3.42 4.24-10.13-10.13 4.24 3.42 1.33z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 11.51l6.84 2.65L12.48 21h.98L21 3 3 10.53v.98zm14.27-4.78l-4.24 10.13-1.32-3.42-.32-.83-.82-.32-3.43-1.33 10.13-4.23z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ramp-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13,21h-2V6.83L9.41,8.41L8,7l4-4l4,4l-1.41,1.41L13,6.83V9c0,4.27,4.03,7.13,6,8.27l-1.46,1.46 c-1.91-1.16-3.44-2.53-4.54-4.02L13,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 multiple-stop
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M17,4l4,4l-4,4V9h-4V7h4V4z M10,7C9.45,7,9,7.45,9,8s0.45,1,1,1s1-0.45,1-1S10.55,7,10,7z M6,7C5.45,7,5,7.45,5,8 s0.45,1,1,1s1-0.45,1-1S6.55,7,6,7z M7,17h4v-2H7v-3l-4,4l4,4V17z M14,17c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1s-1,0.45-1,1 C13,16.55,13.45,17,14,17z M18,17c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1s-1,0.45-1,1C17,16.55,17.45,17,18,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 directions-transit-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M13,5h4.67C17.13,4.46,15.71,4,12,4C8.48,4,7.03,4.48,6.43,5H11H13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M6,15.5C6,16.33,6.67,17,7.5,17h9c0.83,0,1.5-0.67,1.5-1.5V12H6V15.5z M15.5,13c0.83,0,1.5,0.67,1.5,1.5S16.33,16,15.5,16S14,15.33,14,14.5S14.67,13,15.5,13z M8.5,13c0.83,0,1.5,0.67,1.5,1.5 S9.33,16,8.5,16S7,15.33,7,14.5S7.67,13,8.5,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C8,2,4,2.5,4,6v9.5C4,17.43,5.57,19,7.5,19L6,20v1h12v-1l-1.5-1c1.93,0,3.5-1.57,3.5-3.5V6C20,2.5,16.42,2,12,2z M12,4c3.71,0,5.13,0.46,5.67,1H13h-2H6.43C7.03,4.48,8.48,4,12,4z M6,7h5v3H6V7z M18,15.5c0,0.83-0.67,1.5-1.5,1.5h-9 C6.67,17,6,16.33,6,15.5V12h12V15.5z M18,10h-5V7h5V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "8.5", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "15.5", :stroke nil, :fill nil})))))


(helix.core/defnc
 electrical-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M20,15h-2v-2h2c0.55,0,1,0.45,1,1v0C21,14.55,20.55,15,20,15z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d "M20,19h-2v-2h2c0.55,0,1,0.45,1,1v0C21,18.55,20.55,19,20,19z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M14,12L14,12L14,12c-1.1,0-2,0.9-2,2v0h-2v4h2v0c0,1.1,0.9,2,2,2h0h3l0,0v-8H14z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M4,5L4,5c0,0.55,0.45,1,1,1h3.5C9.33,6,10,6.67,10,7.5v0C10,8.33,9.33,9,8.5,9H7c-2.21,0-4,1.79-4,4v0c0,2.21,1.79,4,4,4h2 v-2H7c-1.1,0-2-0.9-2-2v0c0-1.1,0.9-2,2-2h1.5c1.93,0,3.5-1.57,3.5-3.5v0C12,5.57,10.43,4,8.5,4H5C4.45,4,4,4.45,4,5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-taxi
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5.12 12l-.12.34V17h14v-4.66l-.12-.34H5.12zm2.38 4c-.83 0-1.5-.67-1.5-1.5S6.67 13 7.5 13s1.5.67 1.5 1.5S8.33 16 7.5 16zm9 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17.5 5H15V3H9v2H6.5c-.66 0-1.21.42-1.42 1.01L3 12v8c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1h12v1c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-8l-2.08-5.99C18.72 5.42 18.16 5 17.5 5zM6.85 7h10.29l1.04 3H5.81l1.04-3zM19 17H5v-4.66l.12-.34h13.77l.11.34V17z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "7.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "16.5", :stroke nil, :fill nil})))


(helix.core/defnc
 sos
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13.5,7h-3c-1.1,0-2,0.9-2,2v6c0,1.1,0.9,2,2,2h3c1.1,0,2-0.9,2-2V9C15.5,7.9,14.6,7,13.5,7z M13.5,15h-3V9h3V15z M1,15h4 v-2H3c-1.1,0-2-0.9-2-2V9c0-1.1,0.9-2,2-2h4v2H3v2h2c1.1,0,2,0.9,2,2v2c0,1.1-0.9,2-2,2H1V15z M17,15h4v-2h-2c-1.1,0-2-0.9-2-2V9 c0-1.1,0.9-2,2-2h4v2h-4v2h2c1.1,0,2,0.9,2,2v2c0,1.1-0.9,2-2,2h-4V15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 volunteer-activism
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "13",
      :x "3",
      :width "2",
      :opacity ".3",
      :height "7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M16,10.29c1.96-1.82,4-3.88,4-4.99C20,4.56,19.44,4,18.7,4c-0.44,0-0.89,0.21-1.18,0.55L16,6.34l-1.52-1.79 C14.19,4.21,13.74,4,13.3,4C12.56,4,12,4.56,12,5.3C12,6.41,14.04,8.47,16,10.29z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M19,18h-5.35c-0.54,0-1.07-0.09-1.58-0.26l-2.38-0.79l0.63-1.9l2.38,0.79c0.31,0.1,0.63,0.15,0.95,0.15H15 c0-0.37-0.23-0.7-0.57-0.83L8.61,13H7v5.48l6.97,1.94l5.93-1.85C19.74,18.23,19.39,18,19,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,13c3.09-2.81,6-5.44,6-7.7C22,3.45,20.55,2,18.7,2c-1.04,0-2.05,0.49-2.7,1.25C15.35,2.49,14.34,2,13.3,2 C11.45,2,10,3.45,10,5.3C10,7.56,12.91,10.19,16,13z M13.3,4c0.44,0,0.89,0.21,1.18,0.55L16,6.34l1.52-1.79 C17.81,4.21,18.26,4,18.7,4C19.44,4,20,4.56,20,5.3c0,1.12-2.04,3.17-4,4.99c-1.96-1.82-4-3.88-4-4.99C12,4.56,12.56,4,13.3,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,16h-2c0-1.2-0.75-2.28-1.87-2.7L8.97,11H1v11h6v-1.44l7,1.94l8-2.5v-1C22,17.34,20.66,16,19,16z M5,20H3v-7h2V20z M13.97,20.41L7,18.48V13h1.61l5.82,2.17C14.77,15.3,15,15.63,15,16h-1.35c-0.32,0-0.64-0.05-0.95-0.15l-2.38-0.79l-0.63,1.9 l2.38,0.79c0.51,0.17,1.04,0.26,1.58,0.26H19c0.39,0,0.74,0.23,0.9,0.56L13.97,20.41z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-police
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,3.19L5,6.3V11c0,4.52,2.98,8.69,7,9.93c4.02-1.23,7-5.41,7-9.93V6.3L12,3.19z M14.5,12.59l0.9,3.88 L12,14.42l-3.4,2.05l0.9-3.87l-3-2.59l3.96-0.34L12,6.02l1.54,3.64L17.5,10L14.5,12.59z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M14.5,12.59l0.9,3.88L12,14.42l-3.4,2.05l0.9-3.87l-3-2.59l3.96-0.34L12,6.02l1.54,3.64L17.5,10L14.5,12.59z M12,3.19 l7,3.11V11c0,4.52-2.98,8.69-7,9.93C7.98,19.69,5,15.52,5,11V6.3L12,3.19 M12,1L3,5v6c0,5.55,3.84,10.74,9,12c5.16-1.26,9-6.45,9-12 V5L12,1L12,1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-transit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-3.51 0-4.96.48-5.57 1h11.23c-.54-.54-1.95-1-5.66-1zM7.5 17h9c.83 0 1.5-.67 1.5-1.5V12H6v3.5c0 .83.67 1.5 1.5 1.5zm8-4c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zm-7 0c.83 0 1.5.67 1.5 1.5S9.33 16 8.5 16 7 15.33 7 14.5 7.67 13 8.5 13z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 6v9.5C4 17.43 5.57 19 7.5 19L6 20.5v.5h12v-.5L16.5 19c1.93 0 3.5-1.57 3.5-3.5V6c0-3.5-3.58-4-8-4-4 0-8 .5-8 4zm14 4h-5V7h5v3zm-6-6c3.71 0 5.12.46 5.66 1H6.43c.61-.52 2.06-1 5.57-1zM6 7h5v3H6V7zm0 5h12v3.5c0 .83-.67 1.5-1.5 1.5h-9c-.83 0-1.5-.67-1.5-1.5V12z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "8.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "15.5", :stroke nil, :fill nil})))


(helix.core/defnc
 mosque
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M9.91,9h4.18C15.14,9,16,8.14,16,7.09c0-0.64-0.32-1.23-0.85-1.59L12,3.4L8.85,5.5C8.32,5.86,8,6.45,8,7.09 C8,8.14,8.86,9,9.91,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17,11H7v4H3v4h6v-2c0-1.65,1.35-3,3-3c1.65,0,3,1.35,3,3v2h6v-4h-4V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,4c0,0-2,1.9-2,3c0,0.74,0.4,1.38,1,1.72V13h-2v-2c0-0.95-0.66-1.74-1.55-1.94C17.79,8.48,18,7.81,18,7.09 c0-1.31-0.65-2.53-1.74-3.25L12,1L7.74,3.84C6.65,4.56,6,5.78,6,7.09c0,0.72,0.21,1.39,0.55,1.96C5.66,9.26,5,10.05,5,11v2H3V8.72 C3.6,8.38,4,7.74,4,7c0-1.1-2-3-2-3S0,5.9,0,7c0,0.74,0.4,1.38,1,1.72V21h10v-4c0-0.55,0.45-1,1-1s1,0.45,1,1v4h10V8.72 c0.6-0.35,1-0.98,1-1.72C24,5.9,22,4,22,4z M8.85,5.5L12,3.4l3.15,2.1C15.68,5.86,16,6.45,16,7.09C16,8.14,15.14,9,14.09,9H9.91 C8.86,9,8,8.14,8,7.09C8,6.45,8.32,5.86,8.85,5.5z M21,19h-6v-2c0-1.65-1.35-3-3-3c-1.65,0-3,1.35-3,3v2H3v-4h4v-4h10v4h4V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-bar
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M9.23 9L12 12.11 14.77 9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 5V3H3v2l8 9v5H6v2h12v-2h-5v-5l8-9zM5.66 5h12.69l-1.78 2H7.43L5.66 5zM12 12.11L9.23 9h5.54L12 12.11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 streetview
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.56 14.33c-.34.27-.56.7-.56 1.17V21h7c1.1 0 2-.9 2-2v-5.98c-.94-.33-1.95-.52-3-.52-2.03 0-3.93.7-5.44 1.83z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "5", :cy "6", :cx "18", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M11.5 6c0-1.08.27-2.1.74-3H5c-1.1 0-2 .9-2 2v14c0 .55.23 1.05.59 1.41l9.82-9.82C12.23 9.42 11.5 7.8 11.5 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-convenience-store
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14 14h2v4h4V9h-3V6H7v3H4v9h4v-4h6zm-1-7h1v2h1V7h1v5h-1v-2h-2V7zM8 9h2V8H8V7h3v3H9v1h2v1H8V9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M10 16h4v4h8V7h-3V4H5v3H2v13h8v-4zm-2 0v2H4V9h3V6h10v3h3v9h-4v-4H8v2zm3-5H9v-1h2V7H8v1h2v1H8v3h3zm4 1h1V7h-1v2h-1V7h-1v3h2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 kebab-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M15.5,5C15.22,5,15,4.78,15,4.5S15.22,4,15.5,4h3C18.78,4,19,4.22,19,4.5S18.78,5,18.5,5H15.5z M18.5,16 c0.28,0,0.5,0.22,0.5,0.5S18.78,17,18.5,17h-3c-0.28,0-0.5-0.22-0.5-0.5s0.22-0.5,0.5-0.5H18.5z M19,10v1h-4v-1H19z M5.5,5 C5.22,5,5,4.78,5,4.5S5.22,4,5.5,4h3C8.78,4,9,4.22,9,4.5S8.78,5,8.5,5H5.5z M8.5,16C8.78,16,9,16.22,9,16.5S8.78,17,8.5,17h-3 C5.22,17,5,16.78,5,16.5S5.22,16,5.5,16H8.5z M9,10v1H5v-1H9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17.75,7h0.75C19.88,7,21,5.88,21,4.5C21,3.12,19.88,2,18.5,2h-0.75V1h-1.5v1H15.5C14.12,2,13,3.12,13,4.5 C13,5.88,14.12,7,15.5,7h0.75v1H13v5h3.25v1H15.5c-1.38,0-2.5,1.12-2.5,2.5c0,1.38,1.12,2.5,2.5,2.5h0.75v4h1.5v-4h0.75 c1.38,0,2.5-1.12,2.5-2.5c0-1.38-1.12-2.5-2.5-2.5h-0.75v-1H21V8h-3.25V7z M15.5,5C15.22,5,15,4.78,15,4.5S15.22,4,15.5,4h3 C18.78,4,19,4.22,19,4.5S18.78,5,18.5,5H15.5z M18.5,16c0.28,0,0.5,0.22,0.5,0.5S18.78,17,18.5,17h-3c-0.28,0-0.5-0.22-0.5-0.5 s0.22-0.5,0.5-0.5H18.5z M19,10v1h-4v-1H19z M7.75,7H8.5C9.88,7,11,5.88,11,4.5C11,3.12,9.88,2,8.5,2H7.75V1h-1.5v1H5.5 C4.12,2,3,3.12,3,4.5C3,5.88,4.12,7,5.5,7h0.75v1H3v5h3.25v1H5.5C4.12,14,3,15.12,3,16.5C3,17.88,4.12,19,5.5,19h0.75v4h1.5v-4H8.5 c1.38,0,2.5-1.12,2.5-2.5c0-1.38-1.12-2.5-2.5-2.5H7.75v-1H11V8H7.75V7z M5.5,5C5.22,5,5,4.78,5,4.5S5.22,4,5.5,4h3 C8.78,4,9,4.22,9,4.5S8.78,5,8.5,5H5.5z M8.5,16C8.78,16,9,16.22,9,16.5S8.78,17,8.5,17h-3C5.22,17,5,16.78,5,16.5S5.22,16,5.5,16 H8.5z M9,10v1H5v-1H9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pest-control-rodent
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17.65,14.75C17.87,14.38,18,13.96,18,13.5c0-1.38-1.12-2.5-2.5-2.5c-1.3,0-2.5,1.08-2.5,2.5 c0,0.69,0.28,1.32,0.73,1.77l-1.41,1.41C11.5,15.87,11,14.74,11,13.5c0-0.92,0.28-1.76,0.75-2.47c-0.22,0.01-0.44,0.02-0.67,0.07 c-1.48,0.32-2.68,1.53-2.99,3.01c-0.26,1.24,0.02,2.45,0.8,3.41C9.66,18.46,10.79,19,12,19h6.53c0.81,0,1.47-0.66,1.47-1.47 c0-0.41-0.17-0.81-0.48-1.09L17.65,14.75z M17,18c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C18,17.55,17.55,18,17,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "17", :cx "17", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M20.86,14.97l-0.93-0.84c0.48-3.45-2.87-6.04-6.05-4.82C13.3,9.11,12.66,9,12,9c-4.26,0-5.65,3.58-5.89,4.85 C4.89,13.47,4,12.35,4,11c0-1.66,1.34-3,3-3h2.5C10.88,8,12,6.88,12,5.5C12,4.12,10.88,3,9.5,3H8C7.45,3,7,3.45,7,4 c0,0.55,0.45,1,1,1h1.5C9.78,5,10,5.22,10,5.5C10,5.78,9.78,6,9.5,6H7c-2.76,0-5,2.24-5,5c0,2.44,1.76,4.47,4.07,4.91 C6.51,18.79,8.99,21,12,21h6.53C21.64,21,23.23,17.11,20.86,14.97z M18.53,19H12c-1.21,0-2.34-0.54-3.11-1.48 c-0.78-0.95-1.06-2.16-0.8-3.41c0.31-1.48,1.51-2.69,2.99-3.01c0.22-0.05,0.45-0.06,0.67-0.07C11.28,11.74,11,12.58,11,13.5 c0,1.24,0.5,2.37,1.32,3.18l1.41-1.41C13.28,14.82,13,14.19,13,13.5c0-1.42,1.2-2.5,2.5-2.5c1.38,0,2.5,1.12,2.5,2.5 c0,0.46-0.13,0.88-0.35,1.25l1.87,1.7c0.31,0.28,0.48,0.67,0.48,1.09C20,18.34,19.34,19,18.53,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 ramp-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11,21h2V6.83l1.59,1.59L16,7l-4-4L8,7l1.41,1.41L11,6.83V9c0,4.27-4.03,7.13-6,8.27l1.46,1.46 C8.37,17.56,9.9,16.19,11,14.7L11,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 dry-cleaning
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "15",
      :x "9",
      :width "6",
      :opacity ".3",
      :height "5",
      :enable-background "new",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.56,11.36L13,8.44V7c0-0.55-0.45-1-1-1s-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1h2c0-1.84-1.66-3.3-3.56-2.95 C10.26,2.27,9.29,3.22,9.06,4.4C8.76,5.96,9.66,7.34,11,7.82v0.63l-6.56,2.92C3.56,11.75,3,12.62,3,13.57v0.01 C3,14.92,4.08,16,5.42,16H7v6h10v-6h1.58c1.34,0,2.42-1.08,2.42-2.42v-0.01C21,12.62,20.44,11.75,19.56,11.36z M15,20H9v-5h6V20z M18.58,14H17v-1H7v1H5.42c-0.46,0-0.58-0.65-0.17-0.81l6.75-3l6.75,3C19.17,13.38,19.03,14,18.58,14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-bus
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M17.37 17l.29-.27c.13-.11.34-.36.34-.73v-4H6v4c0 .37.21.62.34.73l.29.27h10.74zM8.5 16c-.83 0-1.5-.67-1.5-1.5S7.67 13 8.5 13s1.5.67 1.5 1.5S9.33 16 8.5 16zm5.5-1.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5zM12 4c-3.69 0-5.11.46-5.66.99h11.31C17.11 4.46 15.69 4 12 4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17 21h1c.55 0 1-.45 1-1v-1.78c.61-.55 1-1.34 1-2.22V6c0-3.5-3.58-4-8-4s-8 .5-8 4v10c0 .88.39 1.67 1 2.22V20c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1h8v1c0 .55.45 1 1 1zM12 4c3.69 0 5.11.46 5.66.99H6.34C6.89 4.46 8.31 4 12 4zM6 6.99h12V10H6V6.99zM8 17H6.63l-.29-.27C6.21 16.62 6 16.37 6 16v-4h12v4c0 .37-.21.62-.34.73l-.29.27H8z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "8.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14.5", :cx "15.5", :stroke nil, :fill nil})))


(helix.core/defnc
 theater-comedy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M14.5,10.81C14.55,9.8,15.64,9,16.99,9c1.38,0,2.5,0.84,2.5,1.88H14.5v1.22c0.69,0.55,1.55,0.9,2.5,0.9 c2.21,0,4-1.79,4-4V4h-8v3.5h1.5V10.81z M19,5.5c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S18.45,5.5,19,5.5z M14,6.5 c0-0.55,0.45-1,1-1s1,0.45,1,1s-0.45,1-1,1S14,7.05,14,6.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,2v5.5h2V4h8v5c0,2.21-1.79,4-4,4c-0.95,0-1.81-0.35-2.5-0.9v2.35C15.26,14.8,16.11,15,17,15c3.31,0,6-2.69,6-6V2H11z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "6.5", :cx "19", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "6.5", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M16.99,9c-1.35,0-2.44,0.8-2.49,1.81v0.07h4.99C19.49,9.84,18.37,9,16.99,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1,16c0,3.31,2.69,6,6,6s6-2.69,6-6V9H1V16z M3,11h8v5c0,2.21-1.79,4-4,4s-4-1.79-4-4V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M7,20c2.21,0,4-1.79,4-4v-5H3v5C3,18.21,4.79,20,7,20z M7,17.88c-1.38,0-2.5-0.84-2.5-1.88h5 C9.5,17.04,8.38,17.88,7,17.88z M9,12.5c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S8.45,12.5,9,12.5z M5,12.5c0.55,0,1,0.45,1,1 s-0.45,1-1,1s-1-0.45-1-1S4.45,12.5,5,12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13.5", :cx "5", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13.5", :cx "9", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M7,17.88c1.38,0,2.5-0.84,2.5-1.88h-5C4.5,17.04,5.62,17.88,7,17.88z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 factory
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M12,12l0-2.05l-5,2V10l-3,1.32V20h16v-8H12z M9,18H7v-4h2V18z M13,18h-2v-4h2V18z M17,18h-2v-4h2V18z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M22,22H2V10l7-3v2l5-2l0,3h3l1-8h3l1,8V22z M12,9.95l-5,2V10l-3,1.32V20h16v-8h-8L12,9.95z M11,18h2v-4h-2V18z M7,18h2v-4 H7V18z M17,14h-2v4h2V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 electric-moped
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M4,11v1h4V9H6C4.9,9,4,9.9,4,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,5c0-1.1-0.9-2-2-2h-3v2h3v2.65L13.52,12H10V7H6c-2.21,0-4,1.79-4,4v3h2c0,1.66,1.34,3,3,3s3-1.34,3-3h4.48L19,8.35V5z M7,15c-0.55,0-1-0.45-1-1h2C8,14.55,7.55,15,7,15z M8,12H4v-1c0-1.1,0.9-2,2-2h2V12z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4", :x "5", :width "5", :height "2", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M19,11c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,11,19,11z M19,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S19.55,15,19,15z",
      :stroke nil,
      :fill nil}))
   (helix.dom/polygon
    {:points "7,20 11,20 11,18 17,21 13,21 13,23",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 subway
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M10.67 18.5L9.17 20h5.66l-1.5-1.5zm6.4-13.84C15.59 4.08 13.68 4 12 4s-3.59.08-5.07.66C5.01 5.41 4 6.86 4 8.86V20h3.5v-.38l1.15-1.16C7.16 18.29 6 17.04 6 15.5V9c0-2.63 3-3 6-3s6 .37 6 3v6.5c0 1.54-1.16 2.79-2.65 2.96l1.15 1.16V20H20V8.86c0-2-1.01-3.45-2.93-4.2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17.8 2.8C16 2.09 13.86 2 12 2s-4 .09-5.8.8C3.53 3.84 2 6.05 2 8.86V22h20V8.86c0-2.81-1.53-5.02-4.2-6.06zM9.17 20l1.5-1.5h2.66l1.5 1.5H9.17zm-2.16-6V9h10v5h-10zm9.49 2c0 .55-.45 1-1 1s-1-.45-1-1 .45-1 1-1 1 .45 1 1zm-8-1c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM20 20h-3.5v-.38l-1.15-1.16c1.49-.17 2.65-1.42 2.65-2.96V9c0-2.63-3-3-6-3s-6 .37-6 3v6.5c0 1.54 1.16 2.79 2.65 2.96L7.5 19.62V20H4V8.86c0-2 1.01-3.45 2.93-4.2C8.41 4.08 10.32 4 12 4s3.59.08 5.07.66c1.92.75 2.93 2.2 2.93 4.2V20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-meals
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M16,14V6c0-1.76,2.24-4,5-4v16.17l-2-2V14H16z M20.49,23.31L10.02,12.85C9.69,12.94,9.36,13,9,13v9H7v-9c-2.21,0-4-1.79-4-4 V5.83L0.69,3.51L2.1,2.1l19.8,19.8L20.49,23.31z M6.17,9L5,7.83V9H6.17z M9,2H7v2.17l2,2V2z M13,9V2h-2v6.17l1.85,1.85 C12.94,9.69,13,9.36,13,9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airlines
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14.05,6L5.8,18h11.54l2.25-12H14.05z M14.5,14c-1.38,0-2.5-1.12-2.5-2.5c0-1.38,1.12-2.5,2.5-2.5 s2.5,1.12,2.5,2.5C17,12.88,15.88,14,14.5,14z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17.34,18H5.8l8.25-12h5.54L17.34,18z M13,4L2,20h17l3-16H13z M14.5,9c-1.38,0-2.5,1.12-2.5,2.5s1.12,2.5,2.5,2.5 s2.5-1.12,2.5-2.5S15.88,9,14.5,9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-stops
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18.21,9.21C15.93,10.78,13.45,13.3,13,17h2v2H9v-2h2c-0.5-4.5-4.37-8-9-8V7c4.39,0,8.22,2.55,10,6.3 c1.13-2.43,2.99-4.25,4.78-5.52L14,5h7v7L18.21,9.21z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 turn-sharp-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,6.83l1.59,1.59L21,7l-4-4l-4,4l1.41,1.41L16,6.83V13H8c-1.1,0-2,0.9-2,2v6h2v-6h8c1.1,0,2-0.9,2-2V6.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-post-office
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12 11l8-5H4zM4 8v10h16V8l-8 5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H4V8l8 5 8-5v10zm-8-7L4 6h16l-8 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-railway
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M6 15.5c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5V12H6v3.5zm6-3c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zM12 3C6 3 6 4.2 6 5h12c0-.8 0-2-6-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 15.5V5c0-3.5-3.58-4-8-4s-8 .5-8 4v10.5C4 17.43 5.57 19 7.5 19L6 20.5v.5h12v-.5L16.5 19c1.93 0 3.5-1.57 3.5-3.5zm-2 0c0 .83-.67 1.5-1.5 1.5h-9c-.83 0-1.5-.67-1.5-1.5V12h12v3.5zm0-5.5H6V7h12v3zM6 5c0-.8 0-2 6-2s6 1.2 6 2H6zm6 11.5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 temple-buddhist
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "12,4.33 10,7 14,7",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "8",
      :width "8",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M6,20h3v-2c0-1.65,1.35-3,3-3c1.65,0,3,1.35,3,3v2h3v-7H6V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,9.02c0,1.09-0.89,1.98-1.98,1.98H18V8.86c1.72-0.44,3-1.99,3-3.84V5l-2,0.02C19,6.11,18.11,7,17.02,7H16.5L12,1L7.5,7 H6.98C5.89,7,5,6.11,5,5.02H3c0,1.86,1.28,3.4,3,3.84V11H4.98C3.89,11,3,10.11,3,9.02H1c0,1.86,1.28,3.4,3,3.84V22h7v-4 c0-0.55,0.45-1,1-1s1,0.45,1,1v4h7v-9.14c1.72-0.44,3-1.99,3-3.84V9L21,9.02z M12,4.33L14,7h-4L12,4.33z M8,9h8v2H8V9z M18,20h-3 v-2c0-1.65-1.35-3-3-3c-1.65,0-3,1.35-3,3v2H6v-7h12V20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 person-pin
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M9.83 18l.59.59L12 20.17l1.59-1.59.58-.58H19V4H5v14h4.83zM12 5c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3zM6 15.58C6 13.08 9.97 12 12 12s6 1.08 6 3.58V17H6v-1.42z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9 20l3 3 3-3h4c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h4zM5 4h14v14h-4.83l-.59.59L12 20.17l-1.59-1.59-.58-.58H5V4zm7 7c1.65 0 3-1.35 3-3s-1.35-3-3-3-3 1.35-3 3 1.35 3 3 3zm0-4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm6 8.58c0-2.5-3.97-3.58-6-3.58s-6 1.08-6 3.58V17h12v-1.42zM8.48 15c.74-.51 2.23-1 3.52-1s2.78.49 3.52 1H8.48z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 badge
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,13.5h4V12h-4V13.5z M14,16.5h4V15h-4V16.5z M20,7h-5V4c0-1.1-0.9-2-2-2h-2C9.9,2,9,2.9,9,4v3H4C2.9,7,2,7.9,2,9v11 c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V9C22,7.9,21.1,7,20,7z M11,4h2v5h-2V4z M20,20H4V9h5c0,1.1,0.9,2,2,2h2c1.1,0,2-0.9,2-2h5V20 z M9,15c0.83,0,1.5-0.67,1.5-1.5c0-0.83-0.67-1.5-1.5-1.5s-1.5,0.67-1.5,1.5C7.5,14.33,8.17,15,9,15z M11.08,16.18 C10.44,15.9,9.74,15.75,9,15.75s-1.44,0.15-2.08,0.43C6.36,16.42,6,16.96,6,17.57V18h6v-0.43C12,16.96,11.64,16.42,11.08,16.18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M13,11h-2c-1.1,0-2-0.9-2-2H4v11h16V9h-5C15,10.1,14.1,11,13,11z M9,12c0.83,0,1.5,0.67,1.5,1.5 c0,0.83-0.67,1.5-1.5,1.5s-1.5-0.67-1.5-1.5C7.5,12.67,8.17,12,9,12z M12,18H6v-0.43c0-0.6,0.36-1.15,0.92-1.39 C7.56,15.9,8.26,15.75,9,15.75s1.44,0.15,2.08,0.43c0.55,0.24,0.92,0.78,0.92,1.39V18z M18,16.5h-4V15h4V16.5z M18,13.5h-4V12h4 V13.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 car-repair
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17,9.01V9H7v0.01V12h10V9.01z M9,11.5c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S9.55,11.5,9,11.5z M15,11.5c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S15.55,11.5,15,11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "10.5", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "10.5", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M5.78,16h0.44C6.65,16,7,15.64,7,15.19V14h10v1.19c0,0.45,0.34,0.81,0.78,0.81h0.44c0.43,0,0.78-0.36,0.78-0.81v-6.5 c0,0-1.34-4.03-1.56-4.69c-0.05-0.16-0.12-0.29-0.19-0.4c-0.02-0.02-0.03-0.04-0.05-0.07C16.82,3.01,16.28,3,16.28,3H7.72 c0,0-0.54,0.01-0.92,0.54C6.78,3.56,6.77,3.58,6.75,3.6C6.68,3.71,6.61,3.84,6.56,4C6.34,4.66,5,8.69,5,8.69v6.5 C5,15.64,5.35,16,5.78,16z M8.33,5h7.34l0.23,0.69L16.33,7H7.67L8.33,5z M7,9.01V9h10v0.01V12H7V9.01z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "4,17.01 4,19 11,19 11,22 13,22 13,19 20,19 20,17.01",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-hospital
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 19h14V5H5v14zm2-8.5h3.5V7h3v3.5H17v3h-3.5V17h-3v-3.5H7v-3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 5c0-1.1-.9-2-2-2H5c-1.1 0-1.99.9-1.99 2L3 19c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5zm-2 14H5V5h14v14zm-8.5-2h3v-3.5H17v-3h-3.5V7h-3v3.5H7v3h3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wind-power
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1",
      :opacity ".3",
      :cy "13",
      :cx "13",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M3.28,13C3.13,13,3,13.13,3,13.28c0,0.12,0.08,0.24,0.2,0.27l4.51,1.29l2.33-1.4 c-0.02-0.15-0.03-0.29-0.03-0.44H3.28z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17.76,3.54c-0.15-0.09-0.29-0.01-0.34,0.04L14,6.78v3.36l0.11,0.03l3.74-6.24 C17.94,3.79,17.89,3.62,17.76,3.54z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M18.19,15.48l-2.78-0.69c-0.07,0.1-0.15,0.19-0.24,0.28l4.85,4.85c0.16,0.16,0.35,0.05,0.4,0 c0.09-0.09,0.11-0.23,0.05-0.33L18.19,15.48z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "3", :x "4", :width "6", :height "2", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "7", :x "1", :width "5", :height "2", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "19",
      :x "3",
      :width "5",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.21,18.61l-2.28-4.1c-0.27-0.48-0.73-0.83-1.26-0.97l-2.69-0.67c-0.02-0.47-0.14-0.92-0.37-1.33l3.96-6.59 c0.65-1.08,0.3-2.48-0.78-3.13c-0.36-0.22-0.77-0.32-1.17-0.32c-0.56,0-1.12,0.21-1.56,0.62l-3.43,3.21C12.23,5.7,12,6.23,12,6.78 v3.4c-0.47,0.17-0.89,0.45-1.23,0.82H3.28C2.02,11,1,12.02,1,13.28c0,1.02,0.67,1.91,1.65,2.19l4.51,1.29 c0.18,0.05,0.37,0.08,0.55,0.08c0.36,0,0.72-0.1,1.03-0.29l2.24-1.34c0.29,0.26,0.63,0.47,1.02,0.61V21c-1.1,0-2,0.9-2,2h6 c0-1.1-0.9-2-2-2v-4.28l4.61,4.61c0.45,0.45,1.03,0.67,1.61,0.67c0.58,0,1.17-0.22,1.61-0.67h0 C22.55,20.61,22.71,19.5,22.21,18.61z M7.72,14.84L3.2,13.55C3.08,13.52,3,13.4,3,13.28C3,13.13,3.13,13,3.28,13h6.73 c0,0.15,0.01,0.3,0.03,0.44L7.72,14.84z M13,14c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C14,13.55,13.55,14,13,14z M14,10.14V6.78l3.43-3.21c0.05-0.05,0.19-0.12,0.34-0.04c0.13,0.08,0.18,0.25,0.1,0.38l-3.74,6.24L14,10.14z M20.42,19.92 c-0.05,0.05-0.24,0.16-0.4,0l-4.85-4.85c0.08-0.09,0.16-0.18,0.24-0.28l2.78,0.69l2.28,4.1C20.53,19.69,20.51,19.83,20.42,19.92z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 mode-fan-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4.5,10C4.42,10,4,10.03,4,10.6c0,2,0.82,3.4,2,3.4c0.51,0,0.89-0.12,2.69-0.86 c-0.07-0.2-0.12-0.41-0.15-0.62c-1.48-0.33-2.49-0.89-3.39-2.16C4.93,10.05,4.77,10,4.5,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M10,19.5c0,0.08,0.03,0.5,0.6,0.5c2,0,3.4-0.82,3.4-2c0-0.38-0.07-0.69-0.42-1.59l-0.97-0.97 c-0.03,0.01-0.06,0.02-0.09,0.02c-0.33,1.48-0.89,2.49-2.16,3.39C10.05,19.07,10,19.23,10,19.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M13.65,5.15C13.95,4.93,14,4.77,14,4.5C14,4.42,13.97,4,13.4,4c-2,0-3.4,0.82-3.4,2 c0,0.38,0.07,0.69,0.42,1.59l1.05,1.05l0.02-0.1C11.82,7.06,12.37,6.04,13.65,5.15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M18.85,13.65c0.21,0.3,0.38,0.35,0.65,0.35c0.08,0,0.5-0.03,0.5-0.6c0-2-0.82-3.4-2-3.4 c-0.51,0-0.89,0.12-2.69,0.86c0.07,0.2,0.12,0.41,0.15,0.62C16.94,11.82,17.96,12.37,18.85,13.65z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/path
       {:d
        "M10,6c0-1.18,1.4-2,3.4-2C13.97,4,14,4.42,14,4.5c0,0.27-0.05,0.43-0.35,0.65c-1.27,0.9-1.83,1.91-2.16,3.39l-0.02,0.1 l7.25,7.25C18.96,15.95,19.22,16,19.5,16c1.22,0,2.5-0.95,2.5-2.6C22,9.91,20.11,8,18,8c-1.06,0-1.64,0.29-3.91,1.19 c-0.19-0.14-0.4-0.27-0.62-0.37c0.25-1.03,0.61-1.53,1.33-2.04C15.61,6.21,16,5.44,16,4.5C16,3.28,15.05,2,13.4,2 c-3.08,0-4.92,1.47-5.32,3.26l2.33,2.33C10.07,6.69,10,6.38,10,6z M18,10c1.18,0,2,1.4,2,3.4c0,0.57-0.42,0.6-0.5,0.6 c-0.27,0-0.43-0.05-0.65-0.35c-0.9-1.27-1.91-1.83-3.39-2.16c-0.03-0.22-0.08-0.42-0.15-0.62C17.11,10.12,17.49,10,18,10z",
        :stroke nil,
        :fill nil})))
    (helix.dom/path
     {:d
      "M1.39,4.22l3.89,3.89C5.04,8.05,4.78,8,4.5,8C3.28,8,2,8.95,2,10.6C2,14.09,3.89,16,6,16c1.06,0,1.64-0.29,3.91-1.19 c0.19,0.14,0.4,0.27,0.62,0.37c-0.25,1.03-0.61,1.53-1.33,2.04C8.39,17.79,8,18.56,8,19.5c0,1.22,0.95,2.5,2.6,2.5 c3.08,0,4.92-1.47,5.32-3.26l3.86,3.86l1.41-1.41L2.81,2.81L1.39,4.22z M12.52,15.46c0.03,0,0.06-0.02,0.09-0.02l0.97,0.97 C13.93,17.31,14,17.62,14,18c0,1.18-1.4,2-3.4,2c-0.57,0-0.6-0.42-0.6-0.5c0-0.27,0.05-0.43,0.35-0.65 C11.63,17.96,12.18,16.94,12.52,15.46z M8.54,12.52c0.03,0.22,0.08,0.42,0.15,0.62C6.89,13.88,6.51,14,6,14c-1.18,0-2-1.4-2-3.4 C4,10.03,4.42,10,4.5,10c0.27,0,0.43,0.05,0.65,0.35C6.04,11.63,7.06,12.18,8.54,12.52z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sensor-door
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M18,4v16H6V4H18 M15.5,10.5c-0.83,0-1.5,0.67-1.5,1.5s0.67,1.5,1.5,1.5c0.83,0,1.5-0.67,1.5-1.5 S16.33,10.5,15.5,10.5z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M18,4v16H6V4H18 M18,2H6C4.9,2,4,2.9,4,4v18h16V4C20,2.9,19.1,2,18,2L18,2z M15.5,10.5c-0.83,0-1.5,0.67-1.5,1.5 s0.67,1.5,1.5,1.5c0.83,0,1.5-0.67,1.5-1.5S16.33,10.5,15.5,10.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 gas-meter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M16,6H8C6.9,6,6,6.9,6,8v10c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V8C18,6.9,17.1,6,16,6z M12,18 c-1.38,0-2.5-1.1-2.5-2.46c0-1.09,0.43-1.39,2.5-3.79c2.05,2.38,2.5,2.7,2.5,3.79C14.5,16.9,13.38,18,12,18z M16,10H8V8h8V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,4h-1V2h-2v2h-2V2H9v2H8C5.79,4,4,5.79,4,8v10c0,2.21,1.79,4,4,4h8c2.21,0,4-1.79,4-4V8C20,5.79,18.21,4,16,4z M18,18 c0,1.1-0.9,2-2,2H8c-1.1,0-2-0.9-2-2V8c0-1.1,0.9-2,2-2h8c1.1,0,2,0.9,2,2V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.5,15.54C9.5,16.9,10.62,18,12,18s2.5-1.1,2.5-2.46c0-1.09-0.45-1.41-2.5-3.79C9.93,14.15,9.5,14.46,9.5,15.54z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8",
      :x "8",
      :width "8",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 blinds
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "9",
      :x "6",
      :width "8",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "6",
      :width "8",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "16",
      :width "2",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "16",
      :width "2",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,19V3H4v16H2v2h20v-2H20z M6,5h8v2H6V5z M6,9h8v2H6V9z M18,19H6v-6h8v1.82c-0.45,0.32-0.75,0.84-0.75,1.43 c0,0.97,0.78,1.75,1.75,1.75s1.75-0.78,1.75-1.75c0-0.59-0.3-1.12-0.75-1.43V13h2V19z M18,11h-2V9h2V11z M18,7h-2V5h2V7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 roller-shades-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/rect
      {:y "5",
       :x "6",
       :width "12",
       :height "10",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M20,19V3H4v16H2v2h8.25c0,0.97,0.78,1.75,1.75,1.75s1.75-0.78,1.75-1.75H22v-2H20z M11,19H6v-2h5V19z M18,19h-5v-2h5V19z M18,15H6V5h12V15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 propane-tank
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M6,18c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2v-3H6V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M16,8H8c-1.1,0-2,0.9-2,2v3h12v-3C18,8.9,17.1,8,16,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,6.14V4c0-1.1-0.9-2-2-2H9C7.9,2,7,2.9,7,4v2.14c-1.72,0.45-3,2-3,3.86v8c0,2.21,1.79,4,4,4h8c2.21,0,4-1.79,4-4v-8 C20,8.14,18.72,6.59,17,6.14z M9,4h6v2h-2c0-0.55-0.45-1-1-1s-1,0.45-1,1H9V4z M18,18c0,1.1-0.9,2-2,2H8c-1.1,0-2-0.9-2-2v-3h12 V18z M18,13H6v-3c0-1.1,0.9-2,2-2h8c1.1,0,2,0.9,2,2V13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-meter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,4c-3.86,0-7,3.14-7,7s3.14,7,7,7s7-3.14,7-7S15.86,4,12,4z M14.25,14l-3,3l-1.5-1.5L11,14.25L9.75,13 l3-3l1.5,1.5L13,12.75L14.25,14z M16,9H8V7h8V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2c-4.97,0-9,4.03-9,9c0,3.92,2.51,7.24,6,8.48V22h2v-2.06c0.33,0.04,0.66,0.06,1,0.06s0.67-0.02,1-0.06V22h2v-2.52 c3.49-1.24,6-4.56,6-8.48C21,6.03,16.97,2,12,2z M12,18c-3.86,0-7-3.14-7-7s3.14-7,7-7s7,3.14,7,7S15.86,18,12,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7", :x "8", :width "8", :height "2", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points
      "12.75,10 9.75,13 11,14.25 9.75,15.5 11.25,17 14.25,14 13,12.75 14.25,11.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 nest-cam-wired-stand
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M12,17c-1.65,0-3,1.35-3,3v1h6v-1C15,18.35,13.65,17,12,17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M16,3l-4.08,0.41C9.69,3.64,8,5.5,8,7.75s1.69,4.11,3.92,4.34l4.11,0.42L16,3L16,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,1c-0.15,0,0.11-0.02-4.28,0.42C8.47,1.75,6,4.48,6,7.75s2.47,6,5.72,6.33l1.9,0.19l-0.56,0.85 C12.71,15.04,12.36,15,12,15c-2.76,0-5,2.24-5,5v2c0,0.55,0.45,1,1,1h8c0.55,0,1-0.45,1-1v-2c0-1.67-0.83-3.15-2.09-4.06 l0.97-1.45c0.04,0,0.09,0.01,0.13,0.01c1.09,0,2-0.89,2-2V3C18,1.89,17.09,1,16,1z M15,20v1H9v-1c0-1.65,1.35-3,3-3 C13.65,17,15,18.35,15,20z M11.92,12.09C9.69,11.86,8,10,8,7.75s1.69-4.11,3.92-4.34L16,3h0l0.03,9.5L11.92,12.09z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 blinds-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "5",
      :x "6",
      :width "8",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "6",
      :width "8",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "16",
      :width "2",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "13",
      :x "6",
      :width "8",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "6",
      :width "8",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "13",
      :x "16",
      :width "2",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "16",
      :width "2",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "16",
      :width "2",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,19V3H4v16H2v2h11.25c0,0.97,0.78,1.75,1.75,1.75s1.75-0.78,1.75-1.75H22v-2H20z M14,19H6v-2h8V19z M14,15H6v-2h8V15z M14,11H6V9h8V11z M14,7H6V5h8V7z M18,19h-2v-2h2V19z M18,15h-2v-2h2V15z M18,11h-2V9h2V11z M18,7h-2V5h2V7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 solar-power
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "4.44,20 11,20 11,18 4.84,18",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "18.36,14 13,14 13,16 18.76,16",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "13,18 13,20 19.56,20 19.16,18",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "5.24,16 11,16 11,14 5.64,14",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,12H4L2,22h20L20,12z M13,14h5.36l0.4,2H13V14z M11,20H4.44l0.4-2H11V20z M11,16H5.24l0.4-2H11V16z M13,20v-2h6.16 l0.4,2H13z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8",
      :x "11",
      :width "2",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.06",
      :x "16.53",
      :width "2",
      :transform
      "matrix(0.7071 -0.7071 0.7071 0.7071 -0.2089 14.6085)",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.56",
      :x "4.97",
      :width "3",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 -3.448 6.7885)",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "2", :x "3", :width "3", :height "2", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "2",
      :x "18",
      :width "3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,7c2.76,0,5-2.24,5-5h-2c0,1.65-1.35,3-3,3S9,3.65,9,2H7C7,4.76,9.24,7,12,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M15,2c0,1.66-1.34,3-3,3S9,3.66,9,2H15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-bolt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.69,2.21L4.33,11.49c-0.64,0.58-0.28,1.65,0.58,1.73L13,14l-4.85,6.76c-0.22,0.31-0.19,0.74,0.08,1.01h0 c0.3,0.3,0.77,0.31,1.08,0.02l10.36-9.28c0.64-0.58,0.28-1.65-0.58-1.73L11,10l4.85-6.76c0.22-0.31,0.19-0.74-0.08-1.01l0,0 C15.47,1.93,15,1.92,14.69,2.21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 oil-barrel
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M7,11c0.55,0,1,0.45,1,1s-0.45,1-1,1v6h10v-6c-0.55,0-1-0.45-1-1s0.45-1,1-1V5H7V11z M12,8.5 c2.47,2.86,3,3.24,3,4.55c0,1.63-1.34,2.95-3,2.95s-3-1.32-3-2.95C9,11.75,9.52,11.38,12,8.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,16c1.66,0,3-1.32,3-2.95c0-1.31-0.53-1.69-3-4.55c-2.48,2.88-3,3.25-3,4.55C9,14.68,10.34,16,12,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,13c0.55,0,1-0.45,1-1s-0.45-1-1-1h-1V5h1c0.55,0,1-0.45,1-1s-0.45-1-1-1H4C3.45,3,3,3.45,3,4s0.45,1,1,1h1v6H4 c-0.55,0-1,0.45-1,1s0.45,1,1,1h1v6H4c-0.55,0-1,0.45-1,1s0.45,1,1,1h16c0.55,0,1-0.45,1-1s-0.45-1-1-1h-1v-6H20z M17,11 c-0.55,0-1,0.45-1,1s0.45,1,1,1v6H7v-6c0.55,0,1-0.45,1-1s-0.45-1-1-1V5h10V11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 curtains
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M6,13.14V19h3.94C9.64,16.07,8.05,13.73,6,13.14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M9.94,5H6v5.86C8.05,10.27,9.64,7.93,9.94,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M14.06,19H18v-5.86C15.95,13.73,14.36,16.07,14.06,19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M18,10.86V5h-3.94C14.36,7.93,15.95,10.27,18,10.86z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,19V3H4v16H2v2h20v-2H20z M6,5h3.94C9.64,7.93,8.05,10.27,6,10.86V5z M6,19v-5.86c2.05,0.58,3.64,2.93,3.94,5.86H6z M11.95,19c-0.26-3.06-1.72-5.65-3.76-7c2.04-1.35,3.5-3.94,3.76-7h0.09c0.26,3.06,1.72,5.65,3.76,7c-2.04,1.35-3.5,3.94-3.76,7 H11.95z M18,19h-3.94c0.3-2.93,1.89-5.27,3.94-5.86V19z M18,10.86c-2.05-0.58-3.64-2.93-3.94-5.86H18V10.86z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 curtains-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "5",
      :x "6",
      :width "3",
      :opacity ".3",
      :height "14",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "15",
      :width "3",
      :opacity ".3",
      :height "14",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,19V3H4v16H2v2h20v-2H20z M9,19H6V5h3V19z M13,19h-2V5h2V19z M18,19h-3V5h3V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 auto-mode
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.03,3.56c-1.67-1.39-3.74-2.3-6.03-2.51v2.01c1.73,0.19,3.31,0.88,4.61,1.92L19.03,3.56z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,3.06V1.05C8.71,1.25,6.64,2.17,4.97,3.56l1.42,1.42C7.69,3.94,9.27,3.25,11,3.06z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4.98,6.39L3.56,4.97C2.17,6.64,1.26,8.71,1.05,11h2.01C3.25,9.27,3.94,7.69,4.98,6.39z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.94,11h2.01c-0.21-2.29-1.12-4.36-2.51-6.03l-1.42,1.42C20.06,7.69,20.75,9.27,20.94,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "7,12 10.44,13.56 12,17 13.56,13.56 17,12 13.56,10.44 12,7 10.44,10.44",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,21c-3.11,0-5.85-1.59-7.46-4H7v-2H1v6h2v-2.7c1.99,2.84,5.27,4.7,9,4.7c4.87,0,9-3.17,10.44-7.56l-1.96-0.45 C19.25,18.48,15.92,21,12,21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sensor-window
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d "M18,4v7h-4v-1h-4v1H6V4H18z M6,20v-7h12v7H6z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M18,2H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V4C20,2.9,19.1,2,18,2z M18,4v7h-4v-1h-4v1H6V4H18z M6,20 v-7h12v7H6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 heat-pump
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M12,6c3.31,0,6,2.69,6,6s-2.69,6-6,6s-6-2.69-6-6S8.69,6,12,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,18c3.31,0,6-2.69,6-6s-2.69-6-6-6s-6,2.69-6,6S8.69,18,12,18z M11.25,15.92c-0.55-0.1-1.05-0.32-1.5-0.62l1.5-1.5 V15.92z M12.75,15.92v-2.11l1.5,1.5C13.8,15.61,13.3,15.82,12.75,15.92z M15.31,14.25l-1.5-1.5h2.11 C15.82,13.3,15.61,13.8,15.31,14.25z M15.92,11.25h-2.11l1.5-1.5C15.61,10.2,15.82,10.7,15.92,11.25z M12.75,8.08 c0.55,0.1,1.05,0.32,1.5,0.62l-1.5,1.5V8.08z M12,11c0.55,0,1,0.45,1,1c0,0.55-0.45,1-1,1s-1-0.45-1-1C11,11.45,11.45,11,12,11z M11.25,8.08v2.11l-1.5-1.5C10.2,8.39,10.7,8.18,11.25,8.08z M8.69,9.75l1.5,1.5H8.08C8.18,10.7,8.39,10.2,8.69,9.75z M10.19,12.75l-1.5,1.5c-0.3-0.44-0.51-0.95-0.62-1.5H10.19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 propane
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17,8H7c-2.21,0-4,1.79-4,4s1.79,4,4,4h10c2.21,0,4-1.79,4-4S19.21,8,17,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,6h-1V5c0-1.1-0.9-2-2-2h-4C8.9,3,8,3.9,8,5v1H7c-3.31,0-6,2.69-6,6s2.69,6,6,6v3h2v-3h6v3h2v-3c3.31,0,6-2.69,6-6 S20.31,6,17,6z M10,5h4v1h-4V5z M17,16H7c-2.21,0-4-1.79-4-4s1.79-4,4-4h10c2.21,0,4,1.79,4,4S19.21,16,17,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sensor-occupied
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M8.14,15h7.7c-1.16-0.65-2.5-1-3.85-1C10.65,14,9.32,14.35,8.14,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1",
      :opacity ".3",
      :cy "8",
      :cx "12",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,11c1.66,0,3-1.34,3-3s-1.34-3-3-3S9,6.34,9,8S10.34,11,12,11z M12,7c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1 S11.45,7,12,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,12c-1.84,0-3.56,0.5-5.03,1.37C6.36,13.72,6,14.39,6,15.09V17h12v-1.91c0-0.7-0.36-1.36-0.97-1.72 C15.56,12.5,13.84,12,12,12z M8.14,15c1.18-0.65,2.51-1,3.86-1c1.35,0,2.68,0.35,3.85,1H8.14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.23,8.15l1.85-0.77c-1.22-2.91-3.55-5.25-6.46-6.46l-0.77,1.85C18.27,3.79,20.21,5.73,21.23,8.15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8.15,2.77L7.38,0.92C4.47,2.14,2.14,4.47,0.92,7.38l1.85,0.77C3.79,5.73,5.73,3.79,8.15,2.77z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.77,15.85l-1.85,0.77c1.22,2.91,3.55,5.25,6.46,6.46l0.77-1.85C5.73,20.21,3.79,18.27,2.77,15.85z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.85,21.23l0.77,1.85c2.91-1.22,5.25-3.55,6.46-6.46l-1.85-0.77C20.21,18.27,18.27,20.21,15.85,21.23z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 vertical-shades-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "5",
      :x "9.5",
      :width "1.5",
      :opacity ".2",
      :height "14",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "6",
      :width "1.5",
      :opacity ".2",
      :height "14",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "13",
      :width "1.5",
      :opacity ".2",
      :height "14",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "16.5",
      :width "1.5",
      :opacity ".2",
      :height "14",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,19V3H4v16H2v2h20v-2H20z M7.5,19H6V5h1.5V19z M11,19H9.5V5H11V19z M14.5,19H13V5h1.5V19z M18,19h-1.5V5H18V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 energy-savings-leaf
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d
       "M7.1,7.01C5.74,8.32,5,10.1,5,12c0,3.86,3.14,7,7,7c1.87,0,3.63-0.73,4.95-2.05C18.27,15.63,19,13.87,19,12V5h-7 C10.16,5,8.42,5.71,7.1,7.01z M13.88,7.12c0.14,0.14,0.16,0.36,0.04,0.52l-2.44,3.33l4.05,0.4c0.44,0.04,0.63,0.59,0.3,0.89 l-5.16,4.63c-0.16,0.15-0.41,0.14-0.56-0.01c-0.14-0.14-0.16-0.36-0.04-0.52l2.44-3.33l-4.05-0.4c-0.44-0.04-0.63-0.59-0.3-0.89 l5.16-4.63C13.48,6.96,13.73,6.97,13.88,7.12z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M12,3C12,3,12,3,12,3c-4.8,0-9,3.86-9,9c0,2.12,0.74,4.07,1.97,5.61L3,19.59L4.41,21l1.97-1.97C7.93,20.26,9.88,21,12,21 c2.3,0,4.61-0.88,6.36-2.64C20.12,16.61,21,14.3,21,12V3H12z M19,12c0,1.87-0.73,3.63-2.05,4.95C15.63,18.27,13.87,19,12,19 c-3.86,0-7-3.14-7-7c0-1.9,0.74-3.68,2.1-4.99C8.42,5.71,10.16,5,12,5h7V12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8.46,12.63l4.05,0.4l-2.44,3.33c-0.11,0.16-0.1,0.38,0.04,0.52c0.15,0.15,0.4,0.16,0.56,0.01l5.16-4.63 c0.33-0.3,0.15-0.85-0.3-0.89l-4.05-0.4l2.44-3.33c0.11-0.16,0.1-0.38-0.04-0.52c-0.15-0.15-0.4-0.16-0.56-0.01l-5.16,4.63 C7.84,12.04,8.02,12.59,8.46,12.63z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 vertical-shades
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "5",
      :x "6",
      :width "2",
      :opacity ".3",
      :height "14",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "16",
      :width "2",
      :opacity ".3",
      :height "14",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,19V3H4v16H2v2h20v-2H20z M8,19H6V5h2V19z M14,19h-4V5h4V19z M18,19h-2V5h2V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 broadcast-on-personal
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,10v9h5.59C9.21,18.07,9,17.06,9,16c0-3.39,2.11-6.27,5.08-7.44L10,5.5L4,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4,19v-9l6-4.5l4.08,3.06c0.81-0.32,1.69-0.51,2.61-0.54L10,3L2,9v12h8.76c-0.48-0.6-0.88-1.27-1.17-2H4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,14.75c-0.69,0-1.25,0.56-1.25,1.25c0,0.4,0.2,0.75,0.5,0.97V22h1.5v-5.03c0.3-0.23,0.5-0.57,0.5-0.97 C18.25,15.31,17.69,14.75,17,14.75z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,12c-2.21,0-4,1.79-4,4c0,1.1,0.45,2.1,1.17,2.83l1.06-1.06c-0.45-0.45-0.73-1.08-0.73-1.77c0-1.38,1.12-2.5,2.5-2.5 s2.5,1.12,2.5,2.5c0,0.69-0.28,1.31-0.73,1.76l1.06,1.06C20.55,18.1,21,17.1,21,16C21,13.79,19.21,12,17,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,9.5c-3.59,0-6.5,2.91-6.5,6.5c0,1.79,0.73,3.42,1.9,4.6l1.06-1.06C12.56,18.63,12,17.38,12,16c0-2.76,2.24-5,5-5 s5,2.24,5,5c0,1.37-0.56,2.62-1.46,3.52l1.07,1.06c1.17-1.18,1.89-2.8,1.89-4.58C23.5,12.41,20.59,9.5,17,9.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shield-moon
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M6,6.39v4.7c0,4,2.55,7.7,6,8.83c3.45-1.13,6-4.82,6-8.83v-4.7l-6-2.25L6,6.39z M12.21,7.61 c-0.46,1.23-0.39,2.64,0.32,3.86c0.71,1.22,1.89,1.99,3.18,2.2c0.34,0.06,0.49,0.47,0.26,0.74c-1.84,2.17-5.21,2.1-6.96-0.07 c-2.19-2.72-0.65-6.72,2.69-7.33C12.04,6.95,12.33,7.28,12.21,7.61z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2L4,5v6.09c0,5.05,3.41,9.76,8,10.91c4.59-1.15,8-5.86,8-10.91V5L12,2z M18,11.09c0,4-2.55,7.7-6,8.83 c-3.45-1.13-6-4.82-6-8.83v-4.7l6-2.25l6,2.25V11.09z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.01,14.33c1.75,2.17,5.12,2.24,6.96,0.07c0.23-0.27,0.08-0.68-0.26-0.74c-1.29-0.21-2.48-0.98-3.18-2.2 c-0.71-1.22-0.78-2.63-0.32-3.86c0.12-0.33-0.16-0.66-0.51-0.6C8.36,7.62,6.81,11.61,9.01,14.33z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 roller-shades
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "5",
      :x "6",
      :width "12",
      :opacity ".3",
      :height "6",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,19V3H4v16H2v2h20v-2H20z M18,19H6v-6h5v1.82c-0.45,0.32-0.75,0.84-0.75,1.43c0,0.97,0.78,1.75,1.75,1.75 s1.75-0.78,1.75-1.75c0-0.59-0.3-1.12-0.75-1.43V13h5V19z M18,11H6V5h12V11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 broadcast-on-home
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "11",
      :x "4",
      :width "3",
      :opacity ".3",
      :height "7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,8.59c0.73,0.29,1.4,0.69,2,1.17V6c0-1.1-0.9-2-2-2H4v2h16V8.59z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,9H3c-0.5,0-1,0.5-1,1v9c0,0.5,0.5,1,1,1h5c0.5,0,1-0.5,1-1v-9C9,9.5,8.5,9,8,9z M7,18H4v-7h3V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,14.75c-0.69,0-1.25,0.56-1.25,1.25c0,0.4,0.2,0.75,0.5,0.97V22h1.5v-5.03c0.3-0.23,0.5-0.57,0.5-0.97 C18.25,15.31,17.69,14.75,17,14.75z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,12c-2.21,0-4,1.79-4,4c0,1.1,0.45,2.1,1.17,2.83l1.06-1.06c-0.45-0.45-0.73-1.08-0.73-1.77c0-1.38,1.12-2.5,2.5-2.5 s2.5,1.12,2.5,2.5c0,0.69-0.28,1.31-0.73,1.76l1.06,1.06C20.55,18.1,21,17.1,21,16C21,13.79,19.21,12,17,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,9.5c-3.59,0-6.5,2.91-6.5,6.5c0,1.79,0.73,3.42,1.9,4.6l1.06-1.06C12.56,18.63,12,17.38,12,16c0-2.76,2.24-5,5-5 s5,2.24,5,5c0,1.37-0.56,2.62-1.46,3.52l1.07,1.06c1.17-1.18,1.89-2.8,1.89-4.58C23.5,12.41,20.59,9.5,17,9.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 device-unknown
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 19h10V5H7v14zm6-1h-2v-2h2v2zM12 6.72c1.96 0 3.5 1.51 3.5 3.47 0 2.26-2.62 2.49-2.62 4.45h-1.76c0-2.88 2.63-2.7 2.63-4.45 0-.93-.82-1.75-1.75-1.75s-1.75.82-1.75 1.75H8.5c0-1.95 1.54-3.47 3.5-3.47z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M11 16h2v2h-2zm6-15H7c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 18H7V5h10v14zM12 8.44c.93 0 1.75.82 1.75 1.75 0 1.75-2.63 1.57-2.63 4.45h1.76c0-1.96 2.62-2.19 2.62-4.45 0-1.96-1.54-3.47-3.5-3.47s-3.5 1.52-3.5 3.47h1.75c0-.93.82-1.75 1.75-1.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-capslock
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8.41L16.59 13 18 11.59l-6-6-6 6L7.41 13 12 8.41zM6 18h12v-2H6v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 home-mini
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M12,7c-7.91,0-8,4.8-8,5h16C19.99,11.51,19.64,7,12,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M9.14,17h5.72c2.1,0,3.92-1.24,4.71-3H4.42C5.22,15.76,7.04,17,9.14,17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,5C4.19,5,2,9.48,2,12c0,3.86,3.13,7,6.99,7h6.02c2.69,0,6.99-2.08,6.99-7C22,12,22,5,12,5z M14.86,17H9.14 c-2.1,0-3.92-1.24-4.71-3h15.15C18.78,15.76,16.96,17,14.86,17z M4,12c0-0.2,0.09-5,8-5c7.64,0,7.99,4.51,8,5H4z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 tablet
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M5 6h14v12H5z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M21 4H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h18c1.1 0 1.99-.9 1.99-2L23 6c0-1.1-.9-2-2-2zm-2 14H5V6h14v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 headset
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M17 18h1c.55 0 1-.45 1-1v-3h-2v4zM5 17c0 .55.45 1 1 1h1v-4H5v3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 1c-4.97 0-9 4.03-9 9v7c0 1.66 1.34 3 3 3h3v-8H5v-2c0-3.87 3.13-7 7-7s7 3.13 7 7v2h-4v8h3c1.66 0 3-1.34 3-3v-7c0-4.97-4.03-9-9-9zM7 14v4H6c-.55 0-1-.45-1-1v-3h2zm12 3c0 .55-.45 1-1 1h-1v-4h2v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-double-arrow-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "17.59,18 19,16.59 14.42,12 19,7.41 17.59,6 11.59,12",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,18 12.41,16.59 7.83,12 12.41,7.41 11,6 5,12",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-double-arrow-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "6.41,6 5,7.41 9.58,12 5,16.59 6.41,18 12.41,12",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "13,6 11.59,7.41 16.17,12 11.59,16.59 13,18 19,12",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-hide
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 15h16V5H4v10zm13-9h2v2h-2V6zm0 3h2v2h-2V9zm-3-3h2v2h-2V6zm0 3h2v2h-2V9zm-3-3h2v2h-2V6zm0 3h2v2h-2V9zM8 6h2v2H8V6zm0 3h2v2H8V9zm0 3h8v2H8v-2zM5 6h2v2H5V6zm0 3h2v2H5V9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 3H4c-1.1 0-1.99.9-1.99 2L2 15c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 12H4V5h16v10zm-9-9h2v2h-2zm0 3h2v2h-2zM8 6h2v2H8zm0 3h2v2H8zM5 9h2v2H5zm0-3h2v2H5zm3 6h8v2H8zm6-3h2v2h-2zm0-3h2v2h-2zm3 3h2v2h-2zm0-3h2v2h-2zm-5 17 4-4H8l4 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 monitor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,3H4C2.9,3,2,3.9,2,5v11c0,1.1,0.9,2,2,2h3l-1,1v2h12v-2l-1-1h3c1.1,0,2-0.9,2-2V5C22,3.9,21.1,3,20,3z M20,16H4V5h16 V16z",
      :stroke nil,
      :fill nil}))
   (helix.dom/rect
    {:y "5",
     :x "4",
     :width "16",
     :opacity ".3",
     :height "11",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 desktop-mac
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M3 4h18v10H3z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M21 2H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h7l-2 3v1h8v-1l-2-3h7c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 12H3V4h18v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 memory
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M7 17h10V7H7v10zm2-8h6v6H9V9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 11V9h-2V7c0-1.1-.9-2-2-2h-2V3h-2v2h-2V3H9v2H7c-1.1 0-2 .9-2 2v2H3v2h2v2H3v2h2v2c0 1.1.9 2 2 2h2v2h2v-2h2v2h2v-2h2c1.1 0 2-.9 2-2v-2h2v-2h-2v-2h2zm-4 6H7V7h10v10zm-2-8H9v6h6V9zm-2 4h-2v-2h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M15.41 16.59L10.83 12l4.58-4.59L14 6l-6 6 6 6 1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 headset-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "14",
     :x "5",
     :width "2",
     :opacity ".3",
     :height "4",
     :stroke nil,
     :fill nil})
   (helix.dom/polygon
    {:points "16.83,14 19,16.17 19,14",
     :opacity ".3",
     :stroke nil,
     :fill nil})
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,4c3.87,0,7,3.13,7,7v1h-4v0.17L16.83,14H19v2.17l2,2V11c0-4.97-4.03-9-9-9C9.98,2,8.12,2.67,6.62,3.8l1.43,1.43 C9.17,4.45,10.53,4,12,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.1,2.1L0.69,3.51l3.33,3.33C3.37,8.09,3,9.5,3,11v7c0,1.1,0.9,2,2,2h4v-8H5v-1c0-0.94,0.19-1.83,0.52-2.65L15,17.83V20 h2.17l1,1H12v2h7c0.34,0,0.65-0.09,0.93-0.24l0.55,0.55l1.41-1.41L2.1,2.1z M7,14v4H5v-4H7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sim-card
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M6 8.83V20h12V4h-7.17L6 8.83zM9 19H7v-2h2v2zm0-4H7v-4h2v4zm6-4h2v4h-2v-4zm0 6h2v2h-2v-2zm-4-6h2v2h-2v-2zm0 4h2v4h-2v-4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18 2h-8L4 8v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 2v16H6V8.83L10.83 4H18zM7 17h2v2H7zm8 0h2v2h-2zm-8-6h2v4H7zm4 4h2v4h-2zm0-4h2v2h-2zm4 0h2v4h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 toys
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   {:display "none"}
   (helix.dom/rect
    {:y "0",
     :width "24",
     :height "24",
     :fill "none",
     :display "inline",
     :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M18,12H6c-1.1,0-2,0.9-2,2c0,0.51,0.2,0.97,0.51,1.32C5.05,14.53,5.97,14,7,14c1.3,0,2.4,0.84,2.82,2h4.37 c0.41-1.16,1.51-2,2.82-2c1.03,0,1.95,0.53,2.49,1.32C19.8,14.97,20,14.51,20,14C20,12.9,19.1,12,18,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.75,10.08L17.4,6.05C17,4.82,15.85,4,14.56,4H9.44C8.15,4,7,4.82,6.6,6.05L5.81,8.4L4.41,7l0.29-0.29 c0.39-0.39,0.39-1.02,0-1.41c-0.39-0.39-1.02-0.39-1.41,0l-2,2c-0.39,0.39-0.39,1.02,0,1.41c0.39,0.39,1.02,0.39,1.41,0L3,8.41 l1.79,1.79C3.18,10.72,2,12.22,2,14c0,1.49,0.83,2.78,2.05,3.47C4.27,18.9,5.51,20,7,20c1.3,0,2.4-0.84,2.82-2h4.37 c0.41,1.16,1.51,2,2.82,2c1.49,0,2.73-1.1,2.95-2.53C21.17,16.78,22,15.49,22,14C22,12.05,20.6,10.43,18.75,10.08z M13,6h1.56 c0.43,0,0.81,0.27,0.95,0.68L16.61,10H13V6z M8.49,6.68C8.63,6.27,9.01,6,9.44,6H11v4H7.41L7.39,9.98L8.49,6.68z M7,18 c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S7.55,18,7,18z M17,18c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S17.55,18,17,18z M19.49,15.32C18.95,14.53,18.03,14,17,14c-1.3,0-2.4,0.84-2.82,2H9.82C9.4,14.84,8.3,14,7,14c-1.03,0-1.95,0.53-2.49,1.32 C4.2,14.97,4,14.51,4,14c0-1.1,0.9-2,2-2h12c1.1,0,2,0.9,2,2C20,14.51,19.8,14.97,19.49,15.32z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 security
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12 3.19L5 6.3V12h7v8.93c3.72-1.15 6.47-4.82 7-8.94h-7v-8.8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 19.93V12H5V6.3l7-3.11v8.8h7c-.53 4.12-3.28 7.79-7 8.94z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 speaker
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 4v16h10V4H7zm5 1c1.1 0 2 .9 2 2s-.9 2-2 2c-1.11 0-2-.9-2-2s.89-2 2-2zm0 14c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17 2H7c-1.1 0-2 .9-2 2v16c0 1.1.9 1.99 2 1.99L17 22c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM7 20V4h10v16H7zm5-11c1.1 0 2-.9 2-2s-.9-2-2-2c-1.11 0-2 .9-2 2s.89 2 2 2zm0 2c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 smartphone
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M7 5h10v14H7z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M17 1.01L7 1c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM17 19H7V5h10v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-voice
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 13.3c.66 0 1.19-.54 1.19-1.2l.01-6.2c0-.66-.54-1.2-1.2-1.2s-1.2.54-1.2 1.2v6.2c0 .66.54 1.2 1.2 1.2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 15c1.66 0 2.99-1.34 2.99-3L15 6c0-1.66-1.34-3-3-3S9 4.34 9 6v6c0 1.66 1.34 3 3 3zm-1.2-9.1c0-.66.54-1.2 1.2-1.2s1.2.54 1.2 1.2l-.01 6.2c0 .66-.53 1.2-1.19 1.2s-1.2-.54-1.2-1.2V5.9zm6.5 6.1c0 3-2.54 5.1-5.3 5.1S6.7 15 6.7 12H5c0 3.41 2.72 6.23 6 6.72V22h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-command-key
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.5,3C15.57,3,14,4.57,14,6.5V8h-4V6.5C10,4.57,8.43,3,6.5,3S3,4.57,3,6.5S4.57,10,6.5,10H8v4H6.5 C4.57,14,3,15.57,3,17.5S4.57,21,6.5,21s3.5-1.57,3.5-3.5V16h4v1.5c0,1.93,1.57,3.5,3.5,3.5s3.5-1.57,3.5-3.5S19.43,14,17.5,14H16 v-4h1.5c1.93,0,3.5-1.57,3.5-3.5S19.43,3,17.5,3L17.5,3z M16,8V6.5C16,5.67,16.67,5,17.5,5S19,5.67,19,6.5S18.33,8,17.5,8H16L16,8 z M6.5,8C5.67,8,5,7.33,5,6.5S5.67,5,6.5,5S8,5.67,8,6.5V8H6.5L6.5,8z M10,14v-4h4v4H10L10,14z M17.5,19c-0.83,0-1.5-0.67-1.5-1.5 V16h1.5c0.83,0,1.5,0.67,1.5,1.5S18.33,19,17.5,19L17.5,19z M6.5,19C5.67,19,5,18.33,5,17.5S5.67,16,6.5,16H8v1.5 C8,18.33,7.33,19,6.5,19L6.5,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cast
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v3h2V5h18v14h-7v2h7c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM1 18v3h3c0-1.66-1.34-3-3-3zm0-4v2c2.76 0 5 2.24 5 5h2c0-3.87-3.13-7-7-7zm0-4v2c4.97 0 9 4.03 9 9h2c0-6.08-4.93-11-11-11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phonelink-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M22 17v-7h-4v4.61L20.39 17z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M23 8h-6c-.55 0-1 .45-1 1v3.61l2 2V10h4v7h-1.61l2.93 2.93c.39-.13.68-.49.68-.93V9c0-.55-.45-1-1-1zm-1-2V4H7.39l2 2zM.65 2.92l1.82 1.82C2.18 5.08 2 5.52 2 6v11H0v3h17.73l2.35 2.35 1.41-1.41L2.06 1.51.65 2.92zM4 6.27L14.73 17H4V6.27z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-android
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M7 4h10v14H7z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M16 1H8C6.34 1 5 2.34 5 4v16c0 1.66 1.34 3 3 3h8c1.66 0 3-1.34 3-3V4c0-1.66-1.34-3-3-3zm-2 20h-4v-1h4v1zm3-3H7V4h10v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 developer-board-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4,19V6.83l2,2V12h3.17l1,1H6v4h5v-3.17l1,1V17h2.17l2,2H4z M16,13.17V11h-2.17l-1-1H16V7h-4v2.17l-1-1V7 H9.83l-2-2H18v10.17L16,13.17z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M7.83,5H18v10.17L19.83,17H22v-2h-2v-2h2v-2h-2V9h2V7h-2V5c0-1.1-0.9-2-2-2H5.83L7.83,5z M12,9.17V7h4v3h-3.17L12,9.17z M9.83,7H11v1.17L9.83,7z M13.83,11H16v2.17L13.83,11z M18,21c0.06,0,0.11,0,0.16-0.01l2.32,2.32l1.41-1.41L2.1,2.1L0.69,3.51 l1.32,1.32C2,4.89,2,4.94,2,5v14c0,1.1,0.9,2,2,2H18z M4,19V6.83l2,2V12h3.17l1,1H6v4h5v-3.17l1,1V17h2.17l2,2H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tablet-android
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M4.75 3h14.5v16H4.75z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M18 0H6C4.34 0 3 1.34 3 3v18c0 1.66 1.34 3 3 3h12c1.66 0 3-1.34 3-3V3c0-1.66-1.34-3-3-3zm-4 22h-4v-1h4v1zm5.25-3H4.75V3h14.5v16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 gamepad
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M6.67 11H4v2h2.67l1-1zM13 6.67V4h-2v2.67l1 1zm-2 10.66V20h2v-2.67l-1-1zM16.33 12l1 1H20v-2h-2.67z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9 16.5V22h6v-5.5l-3-3-3 3zm4 3.5h-2v-2.67l1-1 1 1V20zm2-12.5V2H9v5.5l3 3 3-3zM11 4h2v2.67l-1 1-1-1V4zM7.5 9H2v6h5.5l3-3-3-3zm-.83 4H4v-2h2.67l1 1-1 1zm9.83-4l-3 3 3 3H22V9h-5.5zm3.5 4h-2.67l-1-1 1-1H20v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 power-input
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M2 9v2h19V9H2zm0 6h5v-2H2v2zm7 0h5v-2H9v2zm7 0h5v-2h-5v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M3,19h18V6H3V19z M17,8h2v2h-2V8z M17,12h2v2h-2V12z M13,8h2v2h-2V8z M13,12h2 v2h-2V12z M9,8h2v2H9V8z M9,12h2v2H9V12z M8,16h8v1H8V16z M5,8h2v2H5V8z M5,12h2v2H5V12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,4H3C1.9,4,1,4.9,1,6v13c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V6C23,4.9,22.1,4,21,4z M21,19H3V6h18V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8", :x "9", :width "2", :height "2", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "8", :x "5", :width "2", :height "2", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "16",
      :x "8",
      :width "8",
      :height "1",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8",
      :x "13",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "9",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "5",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "13",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8",
      :x "17",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "17",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 laptop-windows
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M4 5h16v10H4z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M20 18v-1c1.1 0 1.99-.9 1.99-2L22 5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2v1H0v2h24v-2h-4zM4 5h16v10H4V5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 speaker-group
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M10 16.99l8 .01V3h-8v13.99zM14 4c1.1 0 2 .89 2 2s-.9 2-2 2-2-.89-2-2 .9-2 2-2zm0 5c1.93 0 3.5 1.57 3.5 3.5S15.93 16 14 16s-3.5-1.57-3.5-3.5S12.07 9 14 9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18.2 1H9.8C8.81 1 8 1.81 8 2.8v14.4c0 .99.81 1.79 1.8 1.79l8.4.01c.99 0 1.8-.81 1.8-1.8V2.8c0-.99-.81-1.8-1.8-1.8zM18 17l-8-.01V3h8v14zm-4-9c1.1 0 2-.89 2-2s-.9-2-2-2-2 .89-2 2 .9 2 2 2zm0 8c1.93 0 3.5-1.57 3.5-3.5S15.93 9 14 9s-3.5 1.57-3.5 3.5S12.07 16 14 16zm0-5c.83 0 1.5.67 1.5 1.5S14.83 14 14 14s-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zM6 5H4v16c0 1.1.89 2 2 2h10v-2H6V5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 start
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M14.59,7.41L18.17,11H6v2h12.17l-3.59,3.59L16,18l6-6l-6-6L14.59,7.41z M2,6v12h2V6H2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 home-max
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M19,7H5C3.9,7,3,7.9,3,9v5c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V9C21,7.9,20.1,7,19,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,5H5C2.79,5,1,6.79,1,9v5c0,2.21,1.79,4,4,4h2v1h10v-1h2c2.21,0,4-1.79,4-4V9C23,6.79,21.21,5,19,5z M21,14 c0,1.1-0.9,2-2,2H5c-1.1,0-2-0.9-2-2V9c0-1.1,0.9-2,2-2h14c1.1,0,2,0.9,2,2V14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 headphones
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "15",
      :x "5",
      :width "2",
      :opacity ".3",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "17",
      :width "2",
      :opacity ".3",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,3c-4.97,0-9,4.03-9,9v7c0,1.1,0.9,2,2,2h4v-8H5v-1c0-3.87,3.13-7,7-7s7,3.13,7,7v1h-4v8h4c1.1,0,2-0.9,2-2v-7 C21,7.03,16.97,3,12,3z M7,15v4H5v-4H7z M19,19h-2v-4h2V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-return
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 7v4H5.83l3.58-3.59L8 6l-6 6 6 6 1.41-1.41L5.83 13H21V7h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phonelink
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M18 10h4v7h-4z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-option-key
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "5",
      :x "15",
      :width "6",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "9,5 3,5 3,7 7.85,7 14.77,19 21,19 21,17 15.93,17",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 videogame-asset
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M3 16h18V8H3v8zm15.5-7c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zm-4 3c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zM4 11h2V9h2v2h2v2H8v2H6v-2H4v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 6H3c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 10H3V8h18v8zM6 15h2v-2h2v-2H8V9H6v2H4v2h2z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "13.5", :cx "14.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "10.5", :cx "18.5", :stroke nil, :fill nil})))


(helix.core/defnc
 tv
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M3 5h18v12H3z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v2h8v-2h5c1.1 0 1.99-.9 1.99-2L23 5c0-1.1-.9-2-2-2zm0 14H3V5h18v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 watch-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M13.89,5.27L13.51,4h-3.02l-0.38,1.27C11.93,4.76,13.34,5.11,13.89,5.27z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M10.11,18.73L10.49,20h3.02l0.38-1.27C12.07,19.24,10.66,18.89,10.11,18.73z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,7c2.76,0,5,2.24,5,5c0,0.64-0.13,1.25-0.35,1.82l1.5,1.5C18.69,14.33,19,13.2,19,12c0-2.22-1.03-4.19-2.64-5.47L15,2 H9L8.04,5.21l2.14,2.14C10.75,7.13,11.36,7,12,7z M10.49,4h3.02l0.38,1.27c-0.55-0.16-1.97-0.51-3.78,0L10.49,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.81,2.81L1.39,4.22l4.46,4.46C5.31,9.67,5,10.8,5,12c0,2.22,1.03,4.19,2.64,5.47L9,22h6l0.96-3.21l3.82,3.82l1.41-1.41 L2.81,2.81z M13.51,20h-3.02l-0.38-1.27c0.55,0.15,1.97,0.51,3.78,0L13.51,20z M12,17c-2.76,0-5-2.24-5-5 c0-0.64,0.13-1.25,0.35-1.82l6.47,6.47C13.25,16.87,12.64,17,12,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 smart-screen
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d "M3,17h1V7H3V17z M20,7v10h1V7H20z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M14,11.25h-1.5v1.5H14V11.25z M16.5,11.25H15v1.5h1.5V11.25z M11.5,11.25H10v1.5h1.5V11.25z M9,11.25H7.5v1.5H9V11.25z M21,5H3C1.9,5,1,5.9,1,7v10c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V7C23,5.9,22.1,5,21,5z M4,17H3V7h1V17z M18,17H6V7h12V17z M21,17 h-1V7h1V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 mouse
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M13 3.16V9h5c-.04-2.94-2.19-5.37-5-5.84zm-2 0C8.19 3.63 6.04 6.06 6 9h5V3.16zM11 11H6v4c0 3.31 2.69 6 6 6s6-2.69 6-6v-4h-7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 9c-.04-4.39-3.6-7.93-8-7.93S4.04 4.61 4 9v6c0 4.42 3.58 8 8 8s8-3.58 8-8V9zm-7-5.84c2.81.47 4.96 2.9 5 5.84h-5V3.16zm-2 0V9H6c.04-2.94 2.19-5.37 5-5.84zM18 15c0 3.31-2.69 6-6 6s-6-2.69-6-6v-4h12v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-double-arrow-up
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "6,17.59 7.41,19 12,14.42 16.59,19 18,17.59 12,11.59",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "6,11 7.41,12.41 12,7.83 16.59,12.41 18,11 12,5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 browser-not-supported
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,6v10.5l1.95,1.95C20.98,18.3,21,18.15,21,18V6c0-1.1-0.9-2-2-2H6.5l2,2H19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3.22,3.32L1.95,4.59L3,5.64L3,18c0,1.1,0.9,2,2,2h12.36l2.06,2.06l1.27-1.27L3.22,3.32z M15,18H5V7.64L15.36,18H15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 browser-updated
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,13v3c0,1.1-0.9,2-2,2h-3l1,1v2H6v-2l1-1H4c-1.1,0-2-0.9-2-2V5c0-1.1,0.9-2,2-2l8,0v2L4,5v11h16v-3H22z M15,15l-5-5h4V3 h2v7h4L15,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-down
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tablet-mac
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M4 3h15v16H4z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M18.5 0h-14C3.12 0 2 1.12 2 2.5v19C2 22.88 3.12 24 4.5 24h14c1.38 0 2.5-1.12 2.5-2.5v-19C21 1.12 19.88 0 18.5 0zm-7 23c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm7.5-4H4V3h15v16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 developer-board
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 19h14V5H4v14zm8-12h4v3h-4V7zm0 4h4v6h-4v-6zM6 7h5v5H6V7zm0 6h5v4H6v-4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M6 13h5v4H6zm0-6h5v5H6zm6 0h4v3h-4zm0 4h4v6h-4zm10-2V7h-2V5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-2h2v-2h-2v-2h2v-2h-2V9h2zm-4 10H4V5h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-up
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6 1.41 1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 laptop-mac
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M4 5h16v11H4z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M20 18c1.1 0 1.99-.9 1.99-2L22 5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v11c0 1.1.9 2 2 2H0c0 1.1.9 2 2 2h20c1.1 0 2-.9 2-2h-4zM4 5h16v11H4V5zm8 14c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 point-of-sale
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M9.5,16h-1C8.22,16,8,15.78,8,15.5C8,15.22,8.22,15,8.5,15h1c0.28,0,0.5,0.22,0.5,0.5 C10,15.78,9.78,16,9.5,16z M10,13.5c0-0.28-0.22-0.5-0.5-0.5h-1C8.22,13,8,13.22,8,13.5C8,13.78,8.22,14,8.5,14h1 C9.78,14,10,13.78,10,13.5z M10,11.5c0-0.28-0.22-0.5-0.5-0.5h-1C8.22,11,8,11.22,8,11.5C8,11.78,8.22,12,8.5,12h1 C9.78,12,10,11.78,10,11.5z M13,15.5c0-0.28-0.22-0.5-0.5-0.5h-1c-0.28,0-0.5,0.22-0.5,0.5c0,0.28,0.22,0.5,0.5,0.5h1 C12.78,16,13,15.78,13,15.5z M13,13.5c0-0.28-0.22-0.5-0.5-0.5h-1c-0.28,0-0.5,0.22-0.5,0.5c0,0.28,0.22,0.5,0.5,0.5h1 C12.78,14,13,13.78,13,13.5z M13,11.5c0-0.28-0.22-0.5-0.5-0.5h-1c-0.28,0-0.5,0.22-0.5,0.5c0,0.28,0.22,0.5,0.5,0.5h1 C12.78,12,13,11.78,13,11.5z M16,15.5c0-0.28-0.22-0.5-0.5-0.5h-1c-0.28,0-0.5,0.22-0.5,0.5c0,0.28,0.22,0.5,0.5,0.5h1 C15.78,16,16,15.78,16,15.5z M16,13.5c0-0.28-0.22-0.5-0.5-0.5h-1c-0.28,0-0.5,0.22-0.5,0.5c0,0.28,0.22,0.5,0.5,0.5h1 C15.78,14,16,13.78,16,13.5z M16,11.5c0-0.28-0.22-0.5-0.5-0.5h-1c-0.28,0-0.5,0.22-0.5,0.5c0,0.28,0.22,0.5,0.5,0.5h1 C15.78,12,16,11.78,16,11.5z M17,4H7v2h10V4z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M17,2H7C5.9,2,5,2.9,5,4v2c0,1.1,0.9,2,2,2h10c1.1,0,2-0.9,2-2V4C19,2.9,18.1,2,17,2z M17,6H7V4h10V6z M20,22H4 c-1.1,0-2-0.9-2-2v-1h20v1C22,21.1,21.1,22,20,22z M18.53,10.19C18.21,9.47,17.49,9,16.7,9H7.3c-0.79,0-1.51,0.47-1.83,1.19L2,18 h20L18.53,10.19z M9.5,16h-1C8.22,16,8,15.78,8,15.5C8,15.22,8.22,15,8.5,15h1c0.28,0,0.5,0.22,0.5,0.5C10,15.78,9.78,16,9.5,16z M9.5,14h-1C8.22,14,8,13.78,8,13.5C8,13.22,8.22,13,8.5,13h1c0.28,0,0.5,0.22,0.5,0.5C10,13.78,9.78,14,9.5,14z M9.5,12h-1 C8.22,12,8,11.78,8,11.5C8,11.22,8.22,11,8.5,11h1c0.28,0,0.5,0.22,0.5,0.5C10,11.78,9.78,12,9.5,12z M12.5,16h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C13,15.78,12.78,16,12.5,16z M12.5,14h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C13,13.78,12.78,14,12.5,14z M12.5,12h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C13,11.78,12.78,12,12.5,12z M15.5,16h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C16,15.78,15.78,16,15.5,16z M15.5,14h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C16,13.78,15.78,14,15.5,14z M15.5,12h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C16,11.78,15.78,12,15.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 headset-mic
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 17c0 .55.45 1 1 1h1v-4H5v3zm12-3h2v4h-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 1c-4.97 0-9 4.03-9 9v7c0 1.66 1.34 3 3 3h3v-8H5v-2c0-3.87 3.13-7 7-7s7 3.13 7 7v2h-4v8h4v1h-7v2h6c1.66 0 3-1.34 3-3V10c0-4.97-4.03-9-9-9zM7 14v4H6c-.55 0-1-.45-1-1v-3h2zm12 4h-2v-4h2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 headphones-battery
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/rect
      {:y "9",
       :x "18",
       :width "2",
       :opacity ".3",
       :height "7",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M21,7h-1V6h-2v1h-1c-0.55,0-1,0.45-1,1v9c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1V8C22,7.45,21.55,7,21,7z M20,16h-2V9h2 V16z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M8,6c-3.31,0-6,2.69-6,6v4c0,1.1,0.9,2,2,2h2v-5H3.5v-1c0-2.48,2.02-4.5,4.5-4.5s4.5,2.02,4.5,4.5v1H10v5h2 c1.1,0,2-0.9,2-2v-4C14,8.69,11.31,6,8,6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-control-key
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points "5,12 6.41,13.41 12,7.83 17.59,13.41 19,12 12,5",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cast-connected
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M17 9H5.95c2.83 1.17 5.15 3.3 6.56 6H17V9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M1 18v3h3c0-1.66-1.34-3-3-3zm0-4v2c2.76 0 5 2.24 5 5h2c0-3.87-3.13-7-7-7zm0-4v2c4.97 0 9 4.03 9 9h2c0-6.08-4.93-11-11-11zm20-7H3c-1.1 0-2 .9-2 2v3h2V5h18v14h-7v2h7c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM5 7v1.63c.32.1.63.24.95.37H17v6h-4.49c.15.29.29.58.42.88.16.36.31.74.44 1.12H19V7H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 watch
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14.72 4.48L14.31 2H9.7l-.41 2.47C10.13 4.17 11.05 4 12 4c.96 0 1.87.17 2.72.48zM9.29 19.53L9.7 22h4.61l.41-2.48c-.85.31-1.76.48-2.72.48-.95 0-1.87-.17-2.71-.47z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16.96 5.73L16 0H8l-.95 5.73C5.19 7.19 4 9.45 4 12s1.19 4.81 3.05 6.27L8 24h8l.96-5.73C18.81 16.81 20 14.54 20 12s-1.19-4.81-3.04-6.27zM9.7 2h4.61l.41 2.48C13.87 4.17 12.96 4 12 4c-.95 0-1.87.17-2.71.47L9.7 2zm4.61 20H9.7l-.41-2.47c.84.3 1.76.47 2.71.47.96 0 1.87-.17 2.72-.48L14.31 22zM12 18c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 earbuds
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M7,6c0-0.55-0.45-1-1-1S5,5.45,5,6v1h1C6.55,7,7,6.55,7,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17,18c0,0.55,0.45,1,1,1s1-0.45,1-1v-1h-1C17.45,17,17,17.45,17,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,3c-2.76,0-5,2.24-5,5v8c0,1.66-1.34,3-3,3s-3-1.34-3-3V9h0.83C7.44,9,8.89,7.82,9,6.21c0.12-1.69-1.16-3.1-2.8-3.21 C4.44,2.89,3,4.42,3,6.19V16c0,2.76,2.24,5,5,5s5-2.24,5-5V8c0-1.66,1.34-3,3-3s3,1.34,3,3v7h-0.83c-1.61,0-3.06,1.18-3.17,2.79 c-0.12,1.69,1.16,3.1,2.8,3.21c1.76,0.12,3.2-1.42,3.2-3.18V8C21,5.24,18.76,3,16,3z M5,6c0-0.55,0.45-1,1-1s1,0.45,1,1 S6.55,7,6,7H5V6z M19,18c0,0.55-0.45,1-1,1s-1-0.45-1-1s0.45-1,1-1h1V18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-double-arrow-down
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "18,6.41 16.59,5 12,9.58 7.41,5 6,6.41 12,12.41",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "18,13 16.59,11.59 12,16.17 7.41,11.59 6,13 12,19",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 laptop-chromebook
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M4 5h16v10H4z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M22 18V3H2v15H0v2h24v-2h-2zm-8 0h-4v-1h4v1zm6-3H4V5h16v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cast-for-education
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v3h2V5h18v14h-7v2h7c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM1 18v3h3c0-1.66-1.34-3-3-3zm0-4v2c2.76 0 5 2.24 5 5h2c0-3.87-3.13-7-7-7zm0-4v2c4.97 0 9 4.03 9 9h2c0-6.08-4.93-11-11-11zm10 1.09v2L14.5 15l3.5-1.91v-2L14.5 13 11 11.09zM14.5 6L9 9l5.5 3L20 9l-5.5-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 videogame-asset-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M10.83,8l8,8H20V8H10.83z M17.5,12c-0.83,0-1.5-0.67-1.5-1.5S16.67,9,17.5,9S19,9.67,19,10.5 S18.33,12,17.5,12z M13.17,16l-3-3H9v2H7v-2H5v-2h2V9.83L5.17,8H4v8H13.17z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17.5,9c0.83,0,1.5,0.67,1.5,1.5S18.33,12,17.5,12S16,11.33,16,10.5S16.67,9,17.5,9z M10.83,8H20v8h-1.17l1.87,1.87 C21.45,17.58,22,16.85,22,16V8c0-1.1-0.9-2-2-2H8.83L10.83,8z M19.78,22.61L15.17,18H4c-1.1,0-2-0.9-2-2V8 c0-0.85,0.55-1.58,1.3-1.87L1.39,4.22l1.41-1.41l18.38,18.38L19.78,22.61z M13.17,16l-3-3H9v2H7v-2H5v-2h2V9.83L5.17,8H4v8H13.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 desktop-windows
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M3 4h18v12H3z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M21 2H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h7v2H8v2h8v-2h-2v-2h7c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H3V4h18v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-iphone
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M7 4h9v14H7z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M15.5 1h-8C6.12 1 5 2.12 5 3.5v17C5 21.88 6.12 23 7.5 23h8c1.38 0 2.5-1.12 2.5-2.5v-17C18 2.12 16.88 1 15.5 1zm-4 21c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5-4H7V4h9v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-tab
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.59 7.41L15.17 11H1v2h14.17l-3.59 3.59L13 18l6-6-6-6-1.41 1.41zM20 6v12h2V6h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 laptop
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d "M4,6h16v10H4V6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,18c1.1,0,2-0.9,2-2V6c0-1.1-0.9-2-2-2H4C2.9,4,2,4.9,2,6v10c0,1.1,0.9,2,2,2H0v2h24v-2H20z M4,6h16v10H4V6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 device-hub
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 16l-4-4V8.82C14.16 8.4 15 7.3 15 6c0-1.66-1.34-3-3-3S9 4.34 9 6c0 1.3.84 2.4 2 2.82V12l-4 4H3v5h5v-3.05l4-4.2 4 4.2V21h5v-5h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 earbuds-battery
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "9",
      :x "18",
      :width "2",
      :opacity ".3",
      :height "7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.62,6C8.76,6,7.25,7.51,7.25,9.38v5.25c0,1.04-0.84,1.88-1.88,1.88S3.5,15.66,3.5,14.62v-4.7C3.66,9.97,3.83,10,4,10 c1.1,0,2-0.9,2-2S5.1,6,4,6S2,6.9,2,8c0,0.04,0,6.62,0,6.62C2,16.49,3.51,18,5.38,18s3.38-1.51,3.38-3.38V9.38 c0-1.04,0.84-1.88,1.88-1.88s1.88,0.84,1.88,1.88v4.7C12.34,14.03,12.17,14,12,14c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2 c0-0.04,0-6.62,0-6.62C14,7.51,12.49,6,10.62,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,7h-1V6h-2v1h-1c-0.55,0-1,0.45-1,1v9c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1V8C22,7.45,21.55,7,21,7z M20,16h-2V9h2 V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-backspace
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 11H6.83l3.58-3.59L9 6l-6 6 6 6 1.41-1.41L6.83 13H21v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 computer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M4 6h16v10H4z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 adf-scanner
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "6",
      :x "8",
      :width "8",
      :opacity ".3",
      :height "6",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M19,14H5c-0.55,0-1,0.45-1,1v3h16v-3C20,14.45,19.55,14,19,14z M18,17c-0.55,0-1-0.45-1-1 c0-0.55,0.45-1,1-1s1,0.45,1,1C19,16.55,18.55,17,18,17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,12h-1V4H6v8H5c-1.66,0-3,1.34-3,3v5h20v-5C22,13.34,20.66,12,19,12z M8,6h8v6H8V6z M20,18H4v-3c0-0.55,0.45-1,1-1h14 c0.55,0,1,0.45,1,1V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "16", :cx "18", :stroke nil, :fill nil})))))


(helix.core/defnc
 scanner
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 14v4h14v-4H5zm3 3H6v-2h2v2zm10 0h-8v-2h8v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.8 10.7L4.2 5l-.7 1.9L17.6 12H5c-1.1 0-2 .9-2 2v4c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-5.5c0-.8-.5-1.6-1.2-1.8zM19 18H5v-4h14v4zM6 15h2v2H6zm4 0h8v2h-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 smart-toy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M18,7H6v12h12V7z M7.5,11.5C7.5,10.67,8.17,10,9,10s1.5,0.67,1.5,1.5S9.83,13,9,13S7.5,12.33,7.5,11.5z M16,17H8v-2h8V17z M15,13c-0.83,0-1.5-0.67-1.5-1.5S14.17,10,15,10s1.5,0.67,1.5,1.5S15.83,13,15,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "8",
      :width "8",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,9V7c0-1.1-0.9-2-2-2h-3c0-1.66-1.34-3-3-3S9,3.34,9,5H6C4.9,5,4,5.9,4,7v2c-1.66,0-3,1.34-3,3c0,1.66,1.34,3,3,3v4 c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-4c1.66,0,3-1.34,3-3C23,10.34,21.66,9,20,9z M18,19H6V7h12V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "11.5", :cx "15", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "11.5", :cx "9", :stroke nil, :fill nil})))))


(helix.core/defnc
 devices-other
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M17 10h4v8h-4z", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5",
    :opacity ".3",
    :cy "16",
    :cx "11",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 6h18V4H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h4v-2H3V6zm19 2h-6c-.5 0-1 .5-1 1v10c0 .5.5 1 1 1h6c.5 0 1-.5 1-1V9c0-.5-.5-1-1-1zm-1 10h-4v-8h4v8zm-8-6H9v1.78c-.61.55-1 1.33-1 2.22s.39 1.67 1 2.22V20h4v-1.78c.61-.55 1-1.34 1-2.22s-.39-1.67-1-2.22V12zm-2 5.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 connected-tv
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,3H4C2.9,3,2,3.9,2,5v12c0,1.1,0.9,2,2,2h4v2h8v-2h4c1.1,0,1.99-0.9,1.99-2L22,5C22,3.9,21.1,3,20,3z M20,17H4V5h16V17 z M5,14v2h2C7,14.89,6.11,14,5,14z M5,11v1.43c1.97,0,3.57,1.6,3.57,3.57H10C10,13.24,7.76,11,5,11z M5,8v1.45 c3.61,0,6.55,2.93,6.55,6.55H13C13,11.58,9.41,8,5,8z",
      :stroke nil,
      :fill nil}))
   (helix.dom/rect
    {:y "5",
     :x "4",
     :width "16",
     :opacity ".3",
     :height "12",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 smart-display
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M4,18.01h16V5.99H4V18.01z M9.5,7.5l7,4.5l-7,4.5V7.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "9.5,7.5 9.5,16.5 16.5,12", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M20,4H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V6C22,4.9,21.1,4,20,4z M20,18.01H4V5.99h16V18.01z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 17h16V7H4v10zm13-9h2v2h-2V8zm0 3h2v2h-2v-2zm-3-3h2v2h-2V8zm0 3h2v2h-2v-2zm-3-3h2v2h-2V8zm0 3h2v2h-2v-2zM8 8h2v2H8V8zm0 3h2v2H8v-2zm0 3h8v2H8v-2zM5 8h2v2H5V8zm0 3h2v2H5v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 5H4c-1.1 0-1.99.9-1.99 2L2 17c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 12H4V7h16v10zm-9-9h2v2h-2zm0 3h2v2h-2zM8 8h2v2H8zm0 3h2v2H8zm-3 0h2v2H5zm0-3h2v2H5zm3 6h8v2H8zm6-3h2v2h-2zm0-3h2v2h-2zm3 3h2v2h-2zm0-3h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dock
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M8 5h8v10H8z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M8 21h8v2H8zm8-19.99L8 1c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM16 15H8V5h8v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M8.59 16.59L13.17 12 8.59 7.41 10 6l6 6-6 6-1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 router
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M15 15H5v4h14v-4h-4zm-7 3H6v-2h2v2zm3.5 0h-2v-2h2v2zm3.5 0h-2v-2h2v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16 4.2c1.5 0 3 .6 4.2 1.7l.8-.8C19.6 3.7 17.8 3 16 3s-3.6.7-5 2.1l.8.8C13 4.8 14.5 4.2 16 4.2zm-3.3 2.5l.8.8c.7-.7 1.6-1 2.5-1s1.8.3 2.5 1l.8-.8c-.9-.9-2.1-1.4-3.3-1.4s-2.4.5-3.3 1.4zM19 13h-2V9h-2v4H5c-1.1 0-2 .9-2 2v4c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-4c0-1.1-.9-2-2-2zm0 6H5v-4h14v4zM6 16h2v2H6zm3.5 0h2v2h-2zm3.5 0h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _3k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M13,9h1.5v2.25L16.25,9H18l-2.25,3L18,15h-1.75l-1.75-2.25V15H13V9z M6.5,13.5h3v-1h-2v-1 h2v-1h-3V9H10c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H6.5V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,14v-4c0-0.55-0.45-1-1-1H6.5v1.5h3v1h-2v1h2v1h-3V15H10C10.55,15,11,14.55,11,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.5,12.75 16.25,15 18,15 15.75,12 18,9 16.25,9 14.5,11.25 14.5,9 13,9 13,15 14.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 music-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M3 19h18V5H3v14zm8-7c.35 0 .69.07 1 .18V6h5v2h-3v7.03c-.02 1.64-1.35 2.97-3 2.97-1.66 0-3-1.34-3-3s1.34-3 3-3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h18v14zm-10-1c1.65 0 2.98-1.33 3-2.97V8h3V6h-5v6.18c-.31-.11-.65-.18-1-.18-1.66 0-3 1.34-3 3s1.34 3 3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 new-releases
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "m18.49 9.89.26-2.79-2.74-.62-1.43-2.41L12 5.18 9.42 4.07 7.99 6.48l-2.74.62.26 2.78L3.66 12l1.85 2.11-.26 2.8 2.74.62 1.43 2.41L12 18.82l2.58 1.11 1.43-2.41 2.74-.62-.26-2.79L20.34 12l-1.85-2.11zM13 17h-2v-2h2v2zm0-4h-2V7h2v6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "m20.9 5.54-3.61-.82-1.89-3.18L12 3 8.6 1.54 6.71 4.72l-3.61.81.34 3.68L1 12l2.44 2.78-.34 3.69 3.61.82 1.89 3.18L12 21l3.4 1.46 1.89-3.18 3.61-.82-.34-3.68L23 12l-2.44-2.78.34-3.68zM18.75 16.9l-2.74.62-1.43 2.41L12 18.82l-2.58 1.11-1.43-2.41-2.74-.62.26-2.8L3.66 12l1.85-2.12-.26-2.78 2.74-.61 1.43-2.41L12 5.18l2.58-1.11 1.43 2.41 2.74.62-.26 2.79L20.34 12l-1.85 2.11.26 2.79zM11 15h2v2h-2zm0-8h2v6h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pause
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M6 5h4v14H6zm8 0h4v14h-4z", :stroke nil, :fill nil})))


(helix.core/defnc
 lyrics
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,4v14l2-2h9v-4.03c-0.62-0.83-1-1.85-1-2.97c0-1.12,0.38-2.14,1-2.97V4H4z M10,14H6v-2h4V14z M13,11H6V9 h7V11z M13,8H6V6h7V8z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "6",
      :width "4",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6", :x "6", :width "7", :height "2", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M15,11.97V16H6l-2,2V4h11v2.03c0.52-0.69,1.2-1.25,2-1.6V4c0-1.1-0.9-2-2-2H4C2.9,2,2.01,2.9,2.01,4L2,22l4-4h9 c1.1,0,2-0.9,2-2v-2.42C16.2,13.22,15.52,12.66,15,11.97z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9", :x "6", :width "7", :height "2", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M20,6.18C19.69,6.07,19.35,6,19,6c-1.66,0-3,1.34-3,3c0,1.66,1.34,3,3,3s3-1.34,3-3V3h2V1h-4V6.18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 playlist-add
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,10H3v2h11V10z M14,6H3v2h11V6z M18,14v-4h-2v4h-4v2h4v4h2v-4h4v-2H18z M3,16h7v-2H3V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 control-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.3 13.77L5.54 12l1.76-1.77-1.76-1.77L2 12l3.54 3.54zm8.24 4.69l-1.77-1.76L12 18.46l-1.77-1.76-1.77 1.76L12 22zm2.92-2.92L22 12l-3.54-3.54-1.76 1.77L18.46 12l-1.76 1.77zM12 5.54l1.77 1.76 1.77-1.76L12 2 8.46 5.54l1.77 1.76z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "3", :cy "12", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 hearing
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.64 2.64L6.22 1.22C4.23 3.21 3 5.96 3 9s1.23 5.79 3.22 7.78l1.41-1.41C6.01 13.74 5 11.49 5 9s1.01-4.74 2.64-6.36z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2.5", :cy "9", :cx "14", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M17 20c-.29 0-.56-.06-.76-.15-.71-.37-1.21-.88-1.71-2.38-.51-1.56-1.47-2.29-2.39-3-.79-.61-1.61-1.24-2.32-2.53C9.29 10.98 9 9.93 9 9c0-2.8 2.2-5 5-5s5 2.2 5 5h2c0-3.93-3.07-7-7-7S7 5.07 7 9c0 1.26.38 2.65 1.07 3.9.91 1.65 1.98 2.48 2.85 3.15.81.62 1.39 1.07 1.71 2.05.6 1.82 1.37 2.84 2.73 3.55.51.23 1.07.35 1.64.35 2.21 0 4-1.79 4-4h-2c0 1.1-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 note
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M15 6H4v12.01h16V11h-5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 4c-1.1 0-2 .9-2 2v12.01c0 1.1.9 1.99 2 1.99h16c1.1 0 2-.9 2-2v-8l-6-6H4zm16 14.01H4V6h11v5h5v7.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-library
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M8 16h12V4H8v12zm4-10.5l6 4.5-6 4.5v-9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 6H2v14c0 1.1.9 2 2 2h14v-2H4V6zm16-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H8V4h12v12zM12 5.5v9l6-4.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _5g
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16.5,13H19v2h-5V9h7c0-1.1-0.9-2-2-2h-5c-1.1,0-2,0.9-2,2v6c0,1.1,0.9,2,2,2h5c1.1,0,2-0.9,2-2v-4h-4.5V13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,13h5v2H3v2h5c1.1,0,2-0.9,2-2v-2c0-1.1-0.9-2-2-2H5V9h5V7H3V13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 surround-sound
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,18h16V6H4V18z M16.94,7.06C18.32,8.41,19,10.21,19,12s-0.68,3.59-2.05,4.95l-1.23-1.23 c1.02-1.03,1.53-2.37,1.53-3.72c0-1.35-0.52-2.69-1.54-3.71L16.94,7.06z M12,8.5c1.93,0,3.5,1.57,3.5,3.5c0,1.93-1.57,3.5-3.5,3.5 c-1.93,0-3.5-1.57-3.5-3.5C8.5,10.07,10.07,8.5,12,8.5z M7.05,7.05l1.23,1.23C7.27,9.31,6.75,10.65,6.75,12 c0,1.35,0.52,2.69,1.54,3.71l-1.23,1.23C5.68,15.59,5,13.79,5,12S5.68,8.41,7.05,7.05z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,4H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V6C22,4.9,21.1,4,20,4z M20,18H4V6h16V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8.29,15.71C7.27,14.69,6.75,13.35,6.75,12c0-1.35,0.52-2.69,1.53-3.72L7.05,7.05C5.68,8.41,5,10.21,5,12 s0.68,3.59,2.06,4.94L8.29,15.71z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,15.5c1.93,0,3.5-1.57,3.5-3.5c0-1.93-1.57-3.5-3.5-3.5c-1.93,0-3.5,1.57-3.5,3.5C8.5,13.93,10.07,15.5,12,15.5z M12,10.5c0.83,0,1.5,0.67,1.5,1.5s-0.67,1.5-1.5,1.5s-1.5-0.67-1.5-1.5S11.17,10.5,12,10.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.72,15.72l1.23,1.23C18.32,15.59,19,13.79,19,12s-0.68-3.59-2.06-4.94l-1.23,1.23c1.02,1.02,1.54,2.36,1.54,3.71 C17.25,13.35,16.73,14.69,15.72,15.72z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 closed-caption-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    {:enable-background "new"}
    (helix.dom/g
     nil
     (helix.dom/path
      {:opacity ".3",
       :enable-background "new",
       :d
       "M19,6H5v12h14V6z M11,11H9.5v-0.5h-2v3h2V13H11v1c0,0.55-0.45,1-1,1H7 c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h3c0.55,0,1,0.45,1,1V11z M18,11h-1.5v-0.5h-2v3h2V13H18v1c0,0.55-0.45,1-1,1h-3 c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h3c0.55,0,1,0.45,1,1V11z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M5,20h14c1.1,0,2-0.9,2-2V6c0-1.1-0.9-2-2-2H5C3.89,4,3,4.9,3,6v12C3,19.1,3.89,20,5,20z M5,6h14v12H5V6z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M10,9H7c-0.55,0-1,0.45-1,1v4c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1v-1H9.5v0.5h-2v-3h2V11H11v-1C11,9.45,10.55,9,10,9z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M17,9h-3c-0.55,0-1,0.45-1,1v4c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1v-1h-1.5v0.5h-2v-3h2V11H18v-1 C18,9.45,17.55,9,17,9z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 repeat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M7 22v-3h12v-6h-2v4H7v-3l-4 4zM21 6l-4-4v3H5v6h2V7h10v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _9k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M13,9h1.5v2.25L16.25,9H18l-2.25,3L18,15h-1.75l-1.75-2.25V15H13V9z M6.5,13.5h3v-1h-2 c-0.55,0-1-0.45-1-1V10c0-0.55,0.45-1,1-1H10c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H6.5V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "8",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,14v-4c0-0.55-0.45-1-1-1H7.5c-0.55,0-1,0.45-1,1v1.5c0,0.55,0.45,1,1,1h2v1h-3V15H10C10.55,15,11,14.55,11,14z M9.5,11.5H8V10h1.5V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.5,12.75 16.25,15 18,15 15.75,12 18,9 16.25,9 14.5,11.25 14.5,9 13,9 13,15 14.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sd
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,18h16V6H4V18z M13,9h4c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1h-4V9z M6,13h1.5v0.5h2v-1H7 c-0.55,0-1-0.45-1-1V10c0-0.55,0.45-1,1-1h3c0.55,0,1,0.45,1,1v1H9.5v-0.5h-2v1H10c0.55,0,1,0.45,1,1V14c0,0.55-0.45,1-1,1H7 c-0.55,0-1-0.45-1-1V13z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10.5",
      :x "14.5",
      :width "2",
      :opacity ".3",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7,15h3c0.55,0,1-0.45,1-1v-1.5c0-0.55-0.45-1-1-1H7.5v-1h2V11H11v-1c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v1.5 c0,0.55,0.45,1,1,1h2.5v1h-2V13H6v1C6,14.55,6.45,15,7,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,14v-4c0-0.55-0.45-1-1-1h-4v6h4C17.55,15,18,14.55,18,14z M16.5,13.5h-2v-3h2V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,4H4C2.89,4,2,4.9,2,6v12c0,1.1,0.89,2,2,2h16c1.1,0,2-0.9,2-2V6C22,4.9,21.1,4,20,4z M20,18H4V6h16V18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 pause-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 8h2v8h-2zM9 8h2v8H9zm3 14c5.52 0 10-4.48 10-10S17.52 2 12 2 2 6.48 2 12s4.48 10 10 10zm0-18c4.41 0 8 3.59 8 8s-3.59 8-8 8-8-3.59-8-8 3.59-8 8-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 audio-file
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M13,4H6v16h12V9h-5V4z M16,11v2h-3v3.75c0,1.24-1.01,2.25-2.25,2.25S8.5,17.99,8.5,16.75 c0-1.24,1.01-2.25,2.25-2.25c0.46,0,0.89,0.14,1.25,0.38V11H16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14,2H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V8L14,2z M18,20H6V4h7v5h5V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,14.88c-0.36-0.24-0.79-0.38-1.25-0.38c-1.24,0-2.25,1.01-2.25,2.25c0,1.24,1.01,2.25,2.25,2.25S13,17.99,13,16.75V13 h3v-2h-4V14.88z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _2k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14v-6.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V5H5V19z M11,9h1.5v2.25L14.25,9H16l-2.25,3L16,15 h-1.75l-1.75-2.25V15H11V9z M6,12.5c0-0.55,0.45-1,1-1h1.5v-1H6V9h3c0.55,0,1,0.45,1,1v1.5c0,0.55-0.45,1-1,1H7.5v1H10V15H6V12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,11.5h-1.5V10h-1v1.5H15v1h1.5 V14h1v-1.5H19V19H5V5h14V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,13.5H7.5v-1H9c0.55,0,1-0.45,1-1V10c0-0.55-0.45-1-1-1H6v1.5h2.5v1H7c-0.55,0-1,0.45-1,1V15h4V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "12.5,12.75 14.25,15 16,15 13.75,12 16,9 14.25,9 12.5,11.25 12.5,9 11,9 11,15 12.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 videocam
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M5 8h10v8H5z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M17 7c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l4 4v-11l-4 4V7zm-2 9H5V8h10v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 movie
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M20 10H5.76L4 6.47V18h16z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M2.01 6L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4h-4l2 4h-3l-2-4h-2l2 4h-3l-2-4H8l2 4H7L5 4H4c-1.1 0-1.99.9-1.99 2zM4 6.47L5.76 10H20v8H4V6.47z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 library-music
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M8 16h12V4H8v12zm4.5-6c.57 0 1.08.19 1.5.51V5h4v2h-3v5.5c0 1.38-1.12 2.5-2.5 2.5S10 13.88 10 12.5s1.12-2.5 2.5-2.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H8V4h12v12zm-7.5-1c1.38 0 2.5-1.12 2.5-2.5V7h3V5h-4v5.51c-.42-.32-.93-.51-1.5-.51-1.38 0-2.5 1.12-2.5 2.5s1.12 2.5 2.5 2.5zM2 6v14c0 1.1.9 2 2 2h14v-2H4V6H2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _10k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "10.5",
      :x "10",
      :width "1.5",
      :opacity ".3",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "19,15 19,9 16.75,12",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,9h2.5v6H6v-4.5H5V19h14v-4h-1.75l-1.75-2.25V15H14V9h1.5v2.25L17.25,9H19V5H5V9z M8.5,10 c0-0.55,0.45-1,1-1H12c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H9.5c-0.55,0-1-0.45-1-1V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,9v6v4H5v-8.5h1V15h1.5V9H5V5 h14V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "15.5,11.25 15.5,9 14,9 14,15 15.5,15 15.5,12.75 17.25,15 19,15 16.75,12 19,9 17.25,9",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.5,15H12c0.55,0,1-0.45,1-1v-4c0-0.55-0.45-1-1-1H9.5c-0.55,0-1,0.45-1,1v4C8.5,14.55,8.95,15,9.5,15z M10,10.5h1.5v3 H10V10.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 fiber-manual-record
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12 18c3.31 0 6-2.69 6-6s-2.69-6-6-6-6 2.69-6 6 2.69 6 6 6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 20c4.42 0 8-3.58 8-8s-3.58-8-8-8-8 3.58-8 8 3.58 8 8 8zm0-14c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6 2.69-6 6-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 shuffle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 4h-5.5l2.04 2.04L4 18.59 5.41 20 17.96 7.46 20 9.5zM5.41 4L4 5.41l5.17 5.17 1.42-1.41zM20 20v-5.5l-2.04 2.04-3.13-3.13-1.41 1.41 3.13 3.13L14.5 20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pause-circle-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,4c-4.41,0-8,3.59-8,8c0,4.41,3.59,8,8,8s8-3.59,8-8C20,7.59,16.41,4,12,4z M11,16H9V8h2V16z M15,16h-2 V8h2V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8",
      :x "13",
      :width "2",
      :height "8",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8", :x "9", :width "2", :height "8", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M12,20c-4.41,0-8-3.59-8-8 c0-4.41,3.59-8,8-8s8,3.59,8,8C20,16.41,16.41,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 radio
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M20 13H4v7h16v-7zM8 18.98c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M2 20c0 1.1.89 2 2 2h16c1.11 0 2-.9 2-2V8c0-1.11-.89-2-2-2H8.3l8.26-3.34L15.88 1 3.24 6.15C2.51 6.43 2 7.17 2 8v12zM4 8h16v3h-2V9h-2v2H4V8zm0 5h16v7H4v-7z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2.5", :cy "16.48", :cx "8", :stroke nil, :fill nil})))


(helix.core/defnc
 replay-circle-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M18,12.5c0,3.31-2.69,6-6,6s-6-2.69-6-6h2 c0,2.21,1.79,4,4,4s4-1.79,4-4s-1.79-4-4-4v3l-4-4l4-4v3C15.31,6.5,18,9.19,18,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _6k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "12.5",
      :x "7.5",
      :width "1",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14v-6.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V5H5V19z M11,9h1.5v2.25L14.25,9H16l-2.25,3L16,15 h-1.75l-1.75-2.25V15H11V9z M6,10c0-0.55,0.45-1,1-1h3v1.5H7.5v1H9c0.55,0,1,0.45,1,1V14c0,0.55-0.45,1-1,1H7c-0.55,0-1-0.45-1-1 V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,11.5h-1.5V10h-1v1.5H15v1h1.5 V14h1v-1.5H19V19H5V5h14V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "12.5,12.75 14.25,15 16,15 13.75,12 16,9 14.25,9 12.5,11.25 12.5,9 11,9 11,15 12.5,15",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7,15h2c0.55,0,1-0.45,1-1v-1.5c0-0.55-0.45-1-1-1H7.5v-1H10V9H7c-0.55,0-1,0.45-1,1v4C6,14.55,6.45,15,7,15z M7.5,12.5h1 V14h-1V12.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 high-quality
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 6H5v12h14V6zm-8 9H9.5v-2h-2v2H6V9h1.5v2.5h2V9H11v6zm7-1c0 .55-.45 1-1 1h-.75v1.5h-1.5V15H14c-.55 0-1-.45-1-1v-4c0-.55.45-1 1-1h3c.55 0 1 .45 1 1v4zm-3.5-3.5h2v3h-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 6v12c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2H5c-1.11 0-2 .9-2 2zm2 0h14v12H5V6zm4.5 5.5h-2V9H6v6h1.5v-2h2v2H11V9H9.5zM17 9h-3c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h.75v1.5h1.5V15H17c.55 0 1-.45 1-1v-4c0-.55-.45-1-1-1zm-.5 4.5h-2v-3h2v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove-from-queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 17h18V5H3v12zm5-7h8v2H8v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.11 0-2 .89-2 2v12c0 1.1.89 2 2 2h5v2h8v-2h5c1.1 0 2-.9 2-2V5c0-1.11-.9-2-2-2zm0 14H3V5h18v12zM8 10h8v2H8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _4k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M5,19h14v-6.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V5H5V19z M11.5,9H13v2.25 L14.75,9h1.75l-2.25,3l2.25,3h-1.75L13,12.75V15h-1.5V9z M5.5,9H7v3h1.5V9H10v3h1v1.5h-1V15H8.5v-1.5h-3V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,11.5h-1.5V10h-1v1.5H15v1h1.5 V14h1v-1.5H19V19H5V5h14V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8.5,15 10,15 10,13.5 11,13.5 11,12 10,12 10,9 8.5,9 8.5,12 7,12 7,9 5.5,9 5.5,13.5 8.5,13.5",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "13,12.75 14.75,15 16.5,15 14.25,12 16.5,9 14.75,9 13,11.25 13,9 11.5,9 11.5,15 13,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 hd
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14.5 10.5h2v3h-2zM19 5H5v14h14V5zm-8 10H9.5v-2h-2v2H6V9h1.5v2.5h2V9H11v6zm7-1c0 .55-.45 1-1 1h-4V9h4c.55 0 1 .45 1 1v4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 21h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2zM5 5h14v14H5V5zm4.5 6.5h-2V9H6v6h1.5v-2h2v2H11V9H9.5zM17 9h-4v6h4c.55 0 1-.45 1-1v-4c0-.55-.45-1-1-1zm-.5 4.5h-2v-3h2v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5V1L7 6l5 5V7c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6H4c0 4.42 3.58 8 8 8s8-3.58 8-8-3.58-8-8-8zm-1.31 8.9l.25-2.17h2.39v.71h-1.7l-.11.92c.03-.02.07-.03.11-.05s.09-.04.15-.05.12-.03.18-.04.13-.02.2-.02c.21 0 .39.03.55.1s.3.16.41.28.2.27.25.45.09.38.09.6c0 .19-.03.37-.09.54s-.15.32-.27.45-.27.24-.45.31-.39.12-.64.12c-.18 0-.36-.03-.53-.08s-.32-.14-.46-.24-.24-.24-.32-.39-.13-.33-.13-.53h.84c.02.18.08.32.19.41s.25.15.42.15c.11 0 .2-.02.27-.06s.14-.1.18-.17.08-.15.11-.25.03-.2.03-.31-.01-.21-.04-.31-.07-.17-.13-.24-.13-.12-.21-.15-.19-.05-.3-.05c-.08 0-.15.01-.2.02s-.11.03-.15.05-.08.05-.12.07-.07.06-.1.09l-.67-.16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 equalizer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M16 9h4v11h-4zm-6-5h4v16h-4zm-6 8h4v8H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-add-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,4c-4.41,0-8,3.59-8,8s3.59,8,8,8s8-3.59,8-8S16.41,4,12,4z M7,7h7v2H7V7z M10,15H7v-2h3V15z M7,12v-2h7v2 H7z M17,15v2h-2v-2h-2v-2h2v-2h2v2h2v2H17z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-4.41,0-8-3.59-8-8s3.59-8,8-8s8,3.59,8,8 S16.41,20,12,20z M14,10H7v2h7V10z M14,7H7v2h7V7z M7,15h3v-2H7V15z M19,13v2h-2v2h-2v-2h-2v-2h2v-2h2v2H19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 volume-down
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M7 13h2.83L12 15.17V8.83L9.83 11H7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16 7.97v8.05c1.48-.73 2.5-2.25 2.5-4.02 0-1.77-1.02-3.29-2.5-4.03zM5 9v6h4l5 5V4L9 9H5zm7-.17v6.34L9.83 13H7v-2h2.83L12 8.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 slow-motion-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4.26 18.32l1.43-1.43c-.86-1.1-1.44-2.43-1.62-3.89H2.05c.2 2.01 1 3.84 2.21 5.32zM7.1 5.69c1.11-.86 2.44-1.44 3.9-1.62V2.05c-2.01.2-3.84 1-5.32 2.21L7.1 5.69zM2.05 11h2.02c.18-1.46.76-2.79 1.62-3.9L4.26 5.68C3.05 7.16 2.25 8.99 2.05 11zm11-8.95v2.02C16.97 4.59 20 7.95 20 12s-3.03 7.41-6.95 7.93v2.02C18.08 21.42 22 17.16 22 12c0-5.16-3.92-9.42-8.95-9.95zM16 12l-2.95-2.21L10 7.5v9l3.05-2.29zM5.68 19.74C7.16 20.95 9 21.75 11 21.95v-2.02c-1.46-.18-2.79-.76-3.9-1.62l-1.42 1.43z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-pin
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 14.62h1.31v-1.75h1.75c.74 0 1.31-.57 1.31-1.31v-.88c0-.74-.57-1.31-1.31-1.31H5v5.25zm1.31-3.93h1.75v.88H6.31v-.88zm5.03-1.31h1.31v5.25h-1.31zm3.28 5.24h1.1v-3.06l2.23 3.06H19V9.38h-1.09v3.06l-2.19-3.06h-1.1z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3", :d "M4 6h16v12H4z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6c0-1.11-.89-2-2-2zm0 14H4V6h16v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "10,12.83 10,15.36 11.55,14.37",
      :opacity ".3",
      :enable-background "new",
      :stroke nil,
      :fill nil}))
   (helix.dom/path
    {:d
     "M2.81,2.81L1.39,4.22L8,10.83V19l4.99-3.18l6.78,6.78l1.41-1.41L2.81,2.81z M10,15.36v-2.53l1.55,1.55L10,15.36z M19,12 L8,5v0.17l8.45,8.45L19,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 playlist-remove
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,10H3v2h11V10z M14,6H3v2h11V6z M3,16h7v-2H3V16z M14.41,22L17,19.41L19.59,22L21,20.59L18.41,18L21,15.41L19.59,14 L17,16.59L14.41,14L13,15.41L15.59,18L13,20.59L14.41,22z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 play-circle-filled
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 20c4.41 0 8-3.59 8-8s-3.59-8-8-8-8 3.59-8 8 3.59 8 8 8zM10 7.5l6 4.5-6 4.5v-9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 22c5.52 0 10-4.48 10-10S17.52 2 12 2 2 6.48 2 12s4.48 10 10 10zm0-18c4.41 0 8 3.59 8 8s-3.59 8-8 8-8-3.59-8-8 3.59-8 8-8zm-2 3.5v9l6-4.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 library-add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M8 16h12V4H8v12zm2-7h3V6h2v3h3v2h-3v3h-2v-3h-3V9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 22h14v-2H4V6H2v14c0 1.1.9 2 2 2zM8 2c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2H8zm12 14H8V4h12v12zm-7-2h2v-3h3V9h-3V6h-2v3h-3v2h3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _3k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14v-6.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V5H5V19z M11,9h1.5v2.25L14.25,9H16l-2.25,3L16,15 h-1.75l-1.75-2.25V15H11V9z M5.5,13.5h3v-1h-2v-1h2v-1h-3V9H9c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H5.5V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,11.5h-1.5V10h-1v1.5H15v1h1.5 V14h1v-1.5H19V19H5V5h14V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,14v-4c0-0.55-0.45-1-1-1H5.5v1.5h3v1h-2v1h2v1h-3V15H9C9.55,15,10,14.55,10,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "12.5,12.75 14.25,15 16,15 13.75,12 16,9 14.25,9 12.5,11.25 12.5,9 11,9 11,15 12.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 missed-video-call
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M15 13.5V8H5v8h10v-2.5zM11 15l-3.89-3.89v2.55H6V9.22h4.44v1.11H7.89l3.11 3.1 2.99-3.01.78.79L11 15z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 17c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l4 4v-11l-4 4V7c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v10zm2-9h10v8H5V8zm6 5.43l-3.11-3.1h2.55V9.22H6v4.44h1.11v-2.55L11 15l3.77-3.79-.78-.79z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 explicit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 19h14V5H5v14zM9 7h6v2h-4v2h4v2h-4v2h4v2H9V7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 19V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2zm-2 0H5V5h14v14zm-4-4h-4v-2h4v-2h-4V9h4V7H9v10h6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 featured-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 19h18V5H3v14zM4 6h9v7H4V6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h18v14zM4 6h9v7H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 speed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.38 8.57l-1.23 1.85a8 8 0 0 1-.22 7.58H5.07A8 8 0 0 1 15.58 6.85l1.85-1.23A10 10 0 0 0 3.35 19a2 2 0 0 0 1.72 1h13.85a2 2 0 0 0 1.74-1 10 10 0 0 0-.27-10.44z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M10.59 15.41a2 2 0 0 0 2.83 0l5.66-8.49-8.49 5.66a2 2 0 0 0 0 2.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sort-by-alpha
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.94 4.66L12.58 2.3l-2.36 2.36zm-4.55 13.07h1.84L7.74 6.27H6.1L1.6 17.73h1.84l.92-2.45h5.11l.92 2.45zm-5.42-4.09l1.94-5.18 1.94 5.18H4.97zm7.61 8.06l2.33-2.33h-4.66zm9.08-14.16V6.28h-8.3v1.6h5.88l-5.92 8.56v1.29h8.53v-1.59h-6.12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "9",
      :x "4",
      :width "10.5",
      :opacity ".3",
      :height "3.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14.5",
      :x "4",
      :width "10.5",
      :opacity ".3",
      :height "3.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "16.5",
      :width "3.5",
      :opacity ".3",
      :height "9",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,4H4C2.9,4,2.01,4.9,2.01,6L2,18c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V6C22,4.9,21.1,4,20,4z M14.5,18L4,18v-3.5h10.5 V18z M14.5,12.5H4V9h10.5V12.5z M20,18l-3.5,0V9H20V18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 mic-none
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 12c.55 0 1-.45 1-1V5c0-.55-.45-1-1-1s-1 .45-1 1v6c0 .55.45 1 1 1z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 14c1.66 0 3-1.34 3-3V5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm-1-9c0-.55.45-1 1-1s1 .45 1 1v6c0 .55-.45 1-1 1s-1-.45-1-1V5zm6 6c0 2.76-2.24 5-5 5s-5-2.24-5-5H5c0 3.53 2.61 6.43 6 6.92V21h2v-3.08c3.39-.49 6-3.39 6-6.92h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay-10
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.99 5V1l-5 5 5 5V7c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6h-2c0 4.42 3.58 8 8 8s8-3.58 8-8-3.58-8-8-8zm-1.1 11h-.85v-3.26l-1.01.31v-.69l1.77-.63h.09V16zm4.28-1.76c0 .32-.03.6-.1.82s-.17.42-.29.57-.28.26-.45.33-.37.1-.59.1-.41-.03-.59-.1-.33-.18-.46-.33-.23-.34-.3-.57-.11-.5-.11-.82v-.74c0-.32.03-.6.1-.82s.17-.42.29-.57.28-.26.45-.33.37-.1.59-.1.41.03.59.1.33.18.46.33.23.34.3.57.11.5.11.82v.74zm-.85-.86c0-.19-.01-.35-.04-.48s-.07-.23-.12-.31-.11-.14-.19-.17-.16-.05-.25-.05-.18.02-.25.05-.14.09-.19.17-.09.18-.12.31-.04.29-.04.48v.97c0 .19.01.35.04.48s.07.24.12.32.11.14.19.17.16.05.25.05.18-.02.25-.05.14-.09.19-.17.09-.19.11-.32.04-.29.04-.48v-.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-arrow
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M10 8.64v6.72L15.27 12z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d "M8 19l11-7L8 5v14zm2-10.36L15.27 12 10 15.36V8.64z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 forward-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.95 13c0 3.31-2.69 6-6 6s-6-2.69-6-6 2.69-6 6-6v4l5-5-5-5v4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8h-2zm-5.52 2.15c-.05.07-.11.13-.18.17s-.17.06-.27.06c-.17 0-.31-.05-.42-.15s-.17-.24-.19-.41h-.84c.01.2.05.37.13.53s.19.28.32.39.29.19.46.24.35.08.53.08c.24 0 .46-.04.64-.12s.33-.18.45-.31.21-.28.27-.45.09-.35.09-.54c0-.22-.03-.43-.09-.6s-.14-.33-.25-.45-.25-.22-.41-.28-.34-.1-.55-.1c-.07 0-.14.01-.2.02s-.13.02-.18.04-.1.03-.15.05-.08.04-.11.05l.11-.92h1.7v-.71H10.9l-.25 2.17.67.17c.03-.03.06-.06.1-.09s.07-.05.12-.07.1-.04.15-.05.13-.02.2-.02c.12 0 .22.02.3.05s.16.09.21.15.1.14.13.24.04.19.04.31-.01.22-.03.31-.06.17-.11.24z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 queue-play-next
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 15v-3h3v-2h-3V7h-2v3H8v2h3v3zm5 0l3 3-3 3 1.5 1.5L24 18l-4.5-4.5zM8 19v2h8v-2h2v-2H3V5h18v8h2V5c0-1.11-.9-2-2-2H3c-1.11 0-2 .89-2 2v12c0 1.1.89 2 2 2h5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 volume-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M7.83 11H5v2h2.83L10 15.17v-3.76l-1.29-1.29z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4.34 2.93L2.93 4.34 7.29 8.7 7 9H3v6h4l5 5v-6.59l4.18 4.18c-.65.49-1.38.88-2.18 1.11v2.06c1.34-.3 2.57-.92 3.61-1.75l2.05 2.05 1.41-1.41L4.34 2.93zM10 15.17L7.83 13H5v-2h2.83l.88-.88L10 11.41v3.76zM19 12c0 .82-.15 1.61-.41 2.34l1.53 1.53c.56-1.17.88-2.48.88-3.87 0-4.28-2.99-7.86-7-8.77v2.06c2.89.86 5 3.54 5 6.71zm-7-8l-1.88 1.88L12 7.76zm4.5 8c0-1.77-1.02-3.29-2.5-4.03v1.79l2.48 2.48c.01-.08.02-.16.02-.24z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 interpreter-mode
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M15.52,15.01C15.35,15,15.18,15,15,15c-2.37,0-4.29,0.73-5.48,1.34C9.2,16.5,9,16.84,9,17.22V18l7.17,0 C15.74,17.26,15.4,16.24,15.52,15.01z M13,8c0,1.1,0.9,2,2,2s2-0.9,2-2c0-1.1-0.9-2-2-2S13,6.9,13,8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20.5,16.5c-0.83,0-1.5-0.67-1.5-1.5v-2.5c0-0.83,0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5V15C22,15.83,21.33,16.5,20.5,16.5z M20,20h1c0,0,0-1.54,0-1.54c1.69-0.24,3-1.7,3-3.46h-1c0,1.38-1.12,2.5-2.5,2.5S18,16.38,18,15h-1c0,1.76,1.31,3.22,3,3.46 C20,18.46,20,20,20,20z M9,12c-2.21,0-4-1.79-4-4c0-2.21,1.79-4,4-4c0.47,0,0.92,0.08,1.34,0.23C9.5,5.26,9,6.57,9,8 c0,1.43,0.5,2.74,1.34,3.77C9.92,11.92,9.47,12,9,12z M7.11,13.13C5.79,14.05,5,15.57,5,17.22V20H1v-2.78 c0-1.12,0.61-2.15,1.61-2.66C3.85,13.92,5.37,13.37,7.11,13.13z M11,8c0-2.21,1.79-4,4-4s4,1.79,4,4c0,2.21-1.79,4-4,4 S11,10.21,11,8z M13,8c0,1.1,0.9,2,2,2s2-0.9,2-2c0-1.1-0.9-2-2-2S13,6.9,13,8z M15,15c-2.37,0-4.29,0.73-5.48,1.34 C9.2,16.5,9,16.84,9,17.22V18l7.17,0c0.5,0.86,1.25,1.56,2.15,2L7,20v-2.78c0-1.12,0.61-2.15,1.61-2.66C10.29,13.7,12.47,13,15,13 c0.39,0,0.77,0.02,1.14,0.05c-0.33,0.59-0.55,1.26-0.62,1.96C15.35,15,15.18,15,15,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _1k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14v-6.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V5H5V19z M10.5,9H12v2.25L13.75,9h1.75l-2.25,3l2.25,3 h-1.75L12,12.75V15h-1.5V9z M6,9h3v6H7.5v-4.5H6V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,11.5h-1.5V10h-1v1.5H15v1h1.5 V14h1v-1.5H19V19H5V5h14V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "7.5,15 9,15 9,9 6,9 6,10.5 7.5,10.5",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "12,12.75 13.75,15 15.5,15 13.25,12 15.5,9 13.75,9 12,11.25 12,9 10.5,9 10.5,15 12,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 closed-caption
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 6H5v12h14V6zm-8 5H9.5v-.5h-2v3h2V13H11v1c0 .55-.45 1-1 1H7c-.55 0-1-.45-1-1v-4c0-.55.45-1 1-1h3c.55 0 1 .45 1 1v1zm7 0h-1.5v-.5h-2v3h2V13H18v1c0 .55-.45 1-1 1h-3c-.55 0-1-.45-1-1v-4c0-.55.45-1 1-1h3c.55 0 1 .45 1 1v1z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 20h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2zM5 6h14v12H5V6zm5 3H7c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h3c.55 0 1-.45 1-1v-1H9.5v.5h-2v-3h2v.5H11v-1c0-.55-.45-1-1-1zm7 0h-3c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h3c.55 0 1-.45 1-1v-1h-1.5v.5h-2v-3h2v.5H18v-1c0-.55-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _4k
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 5H5v14h14V5zm-7 8.51h-1V15H9.5v-1.5h-3V9H8v3h1.5V9H11v3h1v1.51zM18.2 15h-1.7l-2-3v3H13V9h1.5v3l2-3h1.7l-2 3 2 3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 21h14c1.1 0 2-.9 2-2V5c0-1.1-.89-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.89 2 2 2zM5 5h14v14H5V5zm6 4H9.5v3H8V9H6.5v4.5h3V15H11v-1.49h1V12h-1zm5.5 0l-2 3 2 3h1.7l-2-3 2-3zM13 9v6h1.5V9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-file
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M13,9V4H6v16h12V9H13z M16,17.06L14,16v1c0,0.55-0.45,1-1,1H9c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h4 c0.55,0,1,0.45,1,1v1l2-1.06V17.06z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M14,2H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V8L14,2z M6,20V4h7v5h5v11H6z M14,14l2-1.06v4.12L14,16v1 c0,0.55-0.45,1-1,1H9c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h4c0.55,0,1,0.45,1,1V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 videocam-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12.39 8L15 10.61V8zM5 8v8h9.73l-8-8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3.41 1.86L2 3.27 4.73 6H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.21 0 .39-.08.55-.18L19.73 21l1.41-1.41L3.41 1.86zM5 16V8h1.73l8 8H5zm10-8v2.61l6 6V6.5l-4 4V7c0-.55-.45-1-1-1h-5.61l2 2H15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-add-check
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "10",
      :x "3",
      :width "11",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6",
      :x "3",
      :width "11",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "3",
      :width "7",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20.59,11.93 16.34,16.17 14.22,14.05 12.81,15.46 16.34,19 22,13.34",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 library-books
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M8 16h12V4H8v12zm2-10h8v2h-8V6zm0 3h8v2h-8V9zm0 3h4v2h-4v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 22h14v-2H4V6H2v14c0 1.1.9 2 2 2zM6 4v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2H8c-1.1 0-2 .9-2 2zm14 12H8V4h12v12zM10 9h8v2h-8zm0 3h4v2h-4zm0-6h8v2h-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mic
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,12c0.55,0,1-0.45,1-1V5c0-0.55-0.45-1-1-1s-1,0.45-1,1v6C11,11.55,11.45,12,12,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,14c1.66,0,3-1.34,3-3V5c0-1.66-1.34-3-3-3S9,3.34,9,5v6C9,12.66,10.34,14,12,14z M11,5c0-0.55,0.45-1,1-1s1,0.45,1,1 v6c0,0.55-0.45,1-1,1s-1-0.45-1-1V5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,11c0,2.76-2.24,5-5,5s-5-2.24-5-5H5c0,3.53,2.61,6.43,6,6.92V21h2v-3.08c3.39-0.49,6-3.39,6-6.92H17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _5k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M5,19h14v-6.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V5H5V19z M11,9h1.5v2.25 L14.25,9H16l-2.25,3L16,15h-1.75l-1.75-2.25V15H11V9z M6,13.5h2.5v-1H6V9h4v1.5H7.5v1H9c0.55,0,1,0.45,1,1V14c0,0.55-0.45,1-1,1H6 V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,11.5h-1.5V10h-1v1.5H15v1h1.5 V14h1v-1.5H19V19H5V5h14V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,14v-1.5c0-0.55-0.45-1-1-1H7.5v-1H10V9H6v3.5h2.5v1H6V15h3C9.55,15,10,14.55,10,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "12.5,12.75 14.25,15 16,15 13.75,12 16,9 14.25,9 12.5,11.25 12.5,9 11,9 11,15 12.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 forward-10
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,13c0,3.31-2.69,6-6,6s-6-2.69-6-6s2.69-6,6-6v4l5-5l-5-5v4c-4.42,0-8,3.58-8,8c0,4.42,3.58,8,8,8s8-3.58,8-8H18z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "10.9,16 10.9,11.73 10.81,11.73 9.04,12.36 9.04,13.05 10.05,12.74 10.05,16",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.32,11.78c-0.18-0.07-0.37-0.1-0.59-0.1s-0.41,0.03-0.59,0.1s-0.33,0.18-0.45,0.33s-0.23,0.34-0.29,0.57 s-0.1,0.5-0.1,0.82v0.74c0,0.32,0.04,0.6,0.11,0.82s0.17,0.42,0.3,0.57s0.28,0.26,0.46,0.33s0.37,0.1,0.59,0.1s0.41-0.03,0.59-0.1 s0.33-0.18,0.45-0.33s0.22-0.34,0.29-0.57s0.1-0.5,0.1-0.82V13.5c0-0.32-0.04-0.6-0.11-0.82s-0.17-0.42-0.3-0.57 S14.49,11.85,14.32,11.78z M14.33,14.35c0,0.19-0.01,0.35-0.04,0.48s-0.06,0.24-0.11,0.32s-0.11,0.14-0.19,0.17 s-0.16,0.05-0.25,0.05s-0.18-0.02-0.25-0.05s-0.14-0.09-0.19-0.17s-0.09-0.19-0.12-0.32s-0.04-0.29-0.04-0.48v-0.97 c0-0.19,0.01-0.35,0.04-0.48s0.06-0.23,0.12-0.31s0.11-0.14,0.19-0.17s0.16-0.05,0.25-0.05s0.18,0.02,0.25,0.05 s0.14,0.09,0.19,0.17s0.09,0.18,0.12,0.31s0.04,0.29,0.04,0.48V14.35z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 stop-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,4c-4.42,0-8,3.58-8,8s3.58,8,8,8s8-3.58,8-8S16.42,4,12,4z M16,16H8V8h8V16z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M12,20c-4.42,0-8-3.58-8-8s3.58-8,8-8 s8,3.58,8,8S16.42,20,12,20z M16,16H8V8h8V16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 stop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M8 8h8v8H8z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M6 18h12V6H6v12zM8 8h8v8H8V8z", :stroke nil, :fill nil})))


(helix.core/defnc
 repeat-one
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 15V9h-1l-2 1v1h1.5v4zm6-2h-2v4H7v-3l-4 4 4 4v-3h12zM17 2v3H5v6h2V7h10v3l4-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 call-to-action
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 19h18V5H3v14zm2-4h14v3H5v-3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h18v14zM5 15h14v3H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-play
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "10",
      :x "3",
      :width "11",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6",
      :x "3",
      :width "11",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "3",
      :width "7",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "16,13 16,21 22,17", :stroke nil, :fill nil})))))


(helix.core/defnc
 _7k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M13,9h1.5v2.25L16.25,9H18l-2.25,3L18,15h-1.75l-1.75-2.25V15H13V9z M6.5,9H10 c0.67,0,1.15,0.65,0.96,1.29L9.5,15H7.75l1.38-4.5H6.5V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.75,15H9.5l1.46-4.71C11.15,9.65,10.67,9,10,9H6.5v1.5h2.63L7.75,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.5,12.75 16.25,15 18,15 15.75,12 18,9 16.25,9 14.5,11.25 14.5,9 13,9 13,15 14.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _7k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14v-6.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V5H5V19z M11,9h1.5v2.25L14.25,9H16l-2.25,3L16,15 h-1.75l-1.75-2.25V15H11V9z M5.5,9H9c0.67,0,1.15,0.65,0.96,1.29L8.5,15H6.75l1.38-4.5H5.5V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,11.5h-1.5V10h-1v1.5H15v1h1.5 V14h1v-1.5H19V19H5V5h14V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M6.75,15H8.5l1.46-4.71C10.15,9.65,9.67,9,9,9H5.5v1.5h2.63L6.75,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "12.5,12.75 14.25,15 16,15 13.75,12 16,9 14.25,9 12.5,11.25 12.5,9 11,9 11,15 12.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 subscriptions
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M4 20h16v-8H4v8zm6-7.27L16 16l-6 3.26v-6.53z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 6h16v2H4zm2-4h12v2H6zm14 8H4c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-8c0-1.1-.9-2-2-2zm0 10H4v-8h16v8zm-10-7.27v6.53L16 16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fast-rewind
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M9 14.14V9.86L5.97 12zm9 0V9.86L14.97 12z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M11 6l-8.5 6 8.5 6V6zm-2 8.14L5.97 12 9 9.86v4.28zM20 6l-8.5 6 8.5 6V6zm-2 8.14L14.97 12 18 9.86v4.28z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M12,4c-4.41,0-8,3.59-8,8c0,4.41,3.59,8,8,8s8-3.59,8-8C20,7.59,16.41,4,12,4z M9.5,16.5v-9l7,4.5L9.5,16.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-4.41,0-8-3.59-8-8c0-4.41,3.59-8,8-8 s8,3.59,8,8C20,16.41,16.41,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "9.5,16.5 16.5,12 9.5,7.5", :stroke nil, :fill nil})))))


(helix.core/defnc
 mic-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 3.7c-.66 0-1.2.54-1.2 1.2v1.51l2.39 2.39.01-3.9c0-.66-.54-1.2-1.2-1.2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 11h-1.7c0 .58-.1 1.13-.27 1.64l1.27 1.27c.44-.88.7-1.87.7-2.91zM4.41 2.86L3 4.27l6 6V11c0 1.66 1.34 3 3 3 .23 0 .44-.03.65-.08l1.66 1.66c-.71.33-1.5.52-2.31.52-2.76 0-5.3-2.1-5.3-5.1H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c.91-.13 1.77-.45 2.55-.9l4.2 4.2 1.41-1.41L4.41 2.86zM10.8 4.9c0-.66.54-1.2 1.2-1.2s1.2.54 1.2 1.2l-.01 3.91L15 10.6V5c0-1.66-1.34-3-3-3-1.54 0-2.79 1.16-2.96 2.65l1.76 1.76V4.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _6k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "12.5",
      :x "8",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :enable-background "new",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M5,19h14V5H5V19z M13,9h1.5v2.25L16.25,9H18l-2.25,3L18,15h-1.75l-1.75-2.25 V15H13V9z M6.5,10c0-0.55,0.45-1,1-1H11v1.5H8v1h2c0.55,0,1,0.45,1,1V14c0,0.55-0.45,1-1,1H7.5c-0.55,0-1-0.45-1-1V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.5,12.75 16.25,15 18,15 15.75,12 18,9 16.25,9 14.5,11.25 14.5,9 13,9 13,15 14.5,15",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,15H10c0.55,0,1-0.45,1-1v-1.5c0-0.55-0.45-1-1-1H8v-1h3V9H7.5c-0.55,0-1,0.45-1,1v4C6.5,14.55,6.95,15,7.5,15z M8,12.5h1.5V14H8V12.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 forward-30
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 13c0 3.31-2.69 6-6 6s-6-2.69-6-6 2.69-6 6-6v4l5-5-5-5v4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8h-2zm-7.46 2.22c-.06.05-.12.09-.2.12s-.17.04-.27.04c-.09 0-.17-.01-.25-.04s-.14-.06-.2-.11-.1-.1-.13-.17-.05-.14-.05-.22h-.85c0 .21.04.39.12.55s.19.28.33.38.29.18.46.23.35.07.53.07c.21 0 .41-.03.6-.08s.34-.14.48-.24.24-.24.32-.39.12-.33.12-.53c0-.23-.06-.44-.18-.61s-.3-.3-.54-.39c.1-.05.2-.1.28-.17s.15-.14.2-.22.1-.16.13-.25.04-.18.04-.27c0-.2-.04-.37-.11-.53s-.17-.28-.3-.38-.28-.18-.46-.23-.37-.08-.59-.08c-.19 0-.38.03-.54.08s-.32.13-.44.23-.23.22-.3.37-.11.3-.11.48h.85c0-.07.02-.14.05-.2s.07-.11.12-.15.11-.07.18-.1.14-.03.22-.03c.1 0 .18.01.25.04s.13.06.18.11.08.11.11.17.04.14.04.22c0 .18-.05.32-.16.43s-.26.16-.48.16h-.43v.66h.45c.11 0 .2.01.29.04s.16.06.22.11.11.12.14.2.05.18.05.29c0 .09-.01.17-.04.24s-.08.11-.13.17zm3.9-3.44c-.18-.07-.37-.1-.59-.1s-.41.03-.59.1-.33.18-.45.33-.23.34-.29.57-.1.5-.1.82v.74c0 .32.04.6.11.82s.17.42.3.57.28.26.46.33.37.1.59.1.41-.03.59-.1.33-.18.45-.33.22-.34.29-.57.1-.5.1-.82v-.74c0-.32-.04-.6-.11-.82s-.17-.42-.3-.57-.28-.26-.46-.33zm.01 2.57c0 .19-.01.35-.04.48s-.06.24-.11.32-.11.14-.19.17-.16.05-.25.05-.18-.02-.25-.05-.14-.09-.19-.17-.09-.19-.12-.32-.04-.29-.04-.48v-.97c0-.19.01-.35.04-.48s.06-.23.12-.31.11-.14.19-.17.16-.05.25-.05.18.02.25.05.14.09.19.17.09.18.12.31.04.29.04.48v.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-new
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.12 14.47V9.53H8.09v2.88L6.03 9.53H5v4.94h1.03v-2.88l2.1 2.88zm4.12-3.9V9.53h-3.3v4.94h3.3v-1.03h-2.06v-.91h2.06v-1.04h-2.06v-.92zm.82-1.04v4.12c0 .45.37.82.82.82h3.29c.45 0 .82-.37.82-.82V9.53h-1.03v3.71h-.92v-2.89h-1.03v2.9h-.93V9.53h-1.02z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3", :d "M4 6h16v12H4z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6c0-1.11-.89-2-2-2zm0 14H4V6h16v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 repeat-one-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,1H3C1.9,1,1,1.9,1,3v18c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V3C23,1.9,22.1,1,21,1z M19,19H7v3l-4-4l4-4v3h10v-4h2V19z M10,10.5V9h3v6h-1.5v-4.5H10z M17,10V7H7v4H5V5h12V2l4,4L17,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 add-to-queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 17h18V5H3v12zm5-7h3V7h2v3h3v2h-3v3h-2v-3H8v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M11 15h2v-3h3v-2h-3V7h-2v3H8v2h3zM21 3H3c-1.11 0-2 .89-2 2v12c0 1.1.89 2 2 2h5v2h8v-2h5c1.1 0 2-.9 2-2V5c0-1.11-.9-2-2-2zm0 14H3V5h18v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _5k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M5,19h14V5H5V19z M13,9h1.5v2.25L16.25,9H18l-2.25,3L18,15h-1.75l-1.75-2.25 V15H13V9z M6.5,13.5h3v-1h-3V9H11v1.5H8v1h2c0.55,0,1,0.45,1,1V14c0,0.55-0.45,1-1,1H6.5V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,14v-1.5c0-0.55-0.45-1-1-1H8v-1h3V9H6.5v3.5h3v1h-3V15H10C10.55,15,11,14.55,11,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.5,12.75 16.25,15 18,15 15.75,12 18,9 16.25,9 14.5,11.25 14.5,9 13,9 13,15 14.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _9k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "10",
      :x "7.5",
      :width "1",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14v-6.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V5H5V19z M11,9h1.5v2.25L14.25,9H16l-2.25,3L16,15 h-1.75l-1.75-2.25V15H11V9z M6,13.5h2.5v-1H7c-0.55,0-1-0.45-1-1V10c0-0.55,0.45-1,1-1h2c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H6 V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,14v-4c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v1.5c0,0.55,0.45,1,1,1h1.5v1H6V15h3C9.55,15,10,14.55,10,14z M8.5,11.5 h-1V10h1V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,11.5h-1.5V10h-1v1.5H15v1h1.5 V14h1v-1.5H19V19H5V5h14V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "12.5,12.75 14.25,15 16,15 13.75,12 16,9 14.25,9 12.5,11.25 12.5,9 11,9 11,15 12.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 airplay
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "6,22 18,22 12,16", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M21,3H3C1.9,3,1,3.9,1,5v12c0,1.1,0.9,2,2,2h4v-2H3V5h18v12h-4v2h4c1.1,0,2-0.9,2-2V5C23,3.9,22.1,3,21,3z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 replay-30
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5V1L7 6l5 5V7c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6H4c0 4.42 3.58 8 8 8s8-3.58 8-8-3.58-8-8-8zm-2.44 8.49h.45c.21 0 .37-.05.48-.16s.16-.25.16-.43c0-.08-.01-.15-.04-.22s-.06-.12-.11-.17-.11-.09-.18-.11-.16-.04-.25-.04c-.08 0-.15.01-.22.03s-.13.05-.18.1-.09.09-.12.15-.05.13-.05.2h-.85c0-.18.04-.34.11-.48s.17-.27.3-.37.27-.18.44-.23.35-.08.54-.08c.21 0 .41.03.59.08s.33.13.46.23.23.23.3.38.11.33.11.53c0 .09-.01.18-.04.27s-.07.17-.13.25-.12.15-.2.22-.17.12-.28.17c.24.09.42.21.54.39s.18.38.18.61c0 .2-.04.38-.12.53s-.18.29-.32.39-.29.19-.48.24-.38.08-.6.08c-.18 0-.36-.02-.53-.07s-.33-.12-.46-.23-.25-.23-.33-.38-.12-.34-.12-.55h.85c0 .08.02.15.05.22s.07.12.13.17.12.09.2.11.16.04.25.04c.1 0 .19-.01.27-.04s.15-.07.2-.12.1-.11.13-.18.04-.15.04-.24c0-.11-.02-.21-.05-.29s-.08-.15-.14-.2-.13-.09-.22-.11-.18-.04-.29-.04h-.47v-.65zm5.74.75c0 .32-.03.6-.1.82s-.17.42-.29.57-.28.26-.45.33-.37.1-.59.1-.41-.03-.59-.1-.33-.18-.46-.33-.23-.34-.3-.57-.11-.5-.11-.82v-.74c0-.32.03-.6.1-.82s.17-.42.29-.57.28-.26.45-.33.37-.1.59-.1.41.03.59.1.33.18.46.33.23.34.3.57.11.5.11.82v.74zm-.85-.86c0-.19-.01-.35-.04-.48s-.07-.23-.12-.31-.11-.14-.19-.17-.16-.05-.25-.05-.18.02-.25.05-.14.09-.19.17-.09.18-.12.31-.04.29-.04.48v.97c0 .19.01.35.04.48s.07.24.12.32.11.14.19.17.16.05.25.05.18-.02.25-.05.14-.09.19-.17.09-.19.11-.32c.03-.13.04-.29.04-.48v-.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hearing-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M6.03,3.2C7.15,2.44,8.51,2,10,2c3.93,0,7,3.07,7,7c0,1.26-0.38,2.65-1.07,3.9c-0.02,0.04-0.05,0.08-0.08,0.13l-1.48-1.48 C14.77,10.69,15,9.8,15,9c0-2.8-2.2-5-5-5C9.08,4,8.24,4.26,7.5,4.67L6.03,3.2z M17.21,14.38l1.43,1.43C20.11,13.93,21,11.57,21,9 c0-3.04-1.23-5.79-3.22-7.78l-1.42,1.42C17.99,4.26,19,6.51,19,9C19,11.02,18.33,12.88,17.21,14.38z M10,6.5 c-0.21,0-0.4,0.03-0.59,0.08l3.01,3.01C12.47,9.4,12.5,9.21,12.5,9C12.5,7.62,11.38,6.5,10,6.5z M21.19,21.19L2.81,2.81L1.39,4.22 l2.13,2.13C3.19,7.16,3,8.05,3,9h2c0-0.36,0.05-0.71,0.12-1.05l6.61,6.61c-0.88,0.68-1.78,1.41-2.27,2.9c-0.5,1.5-1,2.01-1.71,2.38 C7.56,19.94,7.29,20,7,20c-1.1,0-2-0.9-2-2H3c0,2.21,1.79,4,4,4c0.57,0,1.13-0.12,1.64-0.35c1.36-0.71,2.13-1.73,2.73-3.55 c0.32-0.98,0.9-1.43,1.71-2.05c0.03-0.02,0.05-0.04,0.08-0.06l6.62,6.62L21.19,21.19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 featured-play-list
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 19h18V5H3v14zM5 7h9v2H5V7zm0 3h9v2H5v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h18v14zM5 10h9v2H5zm0-3h9v2H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 queue-music
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/circle
    {:r "1",
     :opacity ".3",
     :enable-background "new",
     :cy "17",
     :cx "16",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M3,10h12v2H3V10z M3,14h8v2H3V14z M3,6h12v2H3V6z M17,14.18C16.69,14.07,16.35,14,16,14c-1.66,0-3,1.34-3,3s1.34,3,3,3 s3-1.34,3-3V8h3V6h-5V14.18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 pause-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:opacity ".3",
       :enable-background "new",
       :d
       "M12,4c-4.41,0-8,3.59-8,8s3.59,8,8,8s8-3.59,8-8S16.41,4,12,4z M11,16H9V8h2 V16z M15,16h-2V8h2V16z",
       :stroke nil,
       :fill nil})
     (helix.dom/rect
      {:y "8",
       :x "13",
       :width "2",
       :height "8",
       :stroke nil,
       :fill nil})
     (helix.dom/rect
      {:y "8",
       :x "9",
       :width "2",
       :height "8",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-4.41,0-8-3.59-8-8s3.59-8,8-8s8,3.59,8,8 S16.41,20,12,20z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 volume-up
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 13h2.83L10 15.17V8.83L7.83 11H5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 9v6h4l5 5V4L7 9H3zm7-.17v6.34L7.83 13H5v-2h2.83L10 8.83zm4-.86v8.05c1.48-.73 2.5-2.25 2.5-4.02 0-1.77-1.02-3.29-2.5-4.03zm0-4.74v2.06c2.89.86 5 3.54 5 6.71s-2.11 5.85-5 6.71v2.06c4.01-.91 7-4.49 7-8.77 0-4.28-2.99-7.86-7-8.77z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 av-timer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 21c4.97 0 9-4.03 9-9s-4.03-9-9-9h-1v4h2V5.08c3.39.49 6 3.39 6 6.92 0 3.87-3.13 7-7 7s-7-3.13-7-7c0-1.68.59-3.22 1.58-4.42L12 13l1.41-1.41-6.8-6.8v.02C4.42 6.45 3 9.05 3 12c0 4.97 4.02 9 9 9z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "17", :cx "12", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "12", :cx "17", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "12", :cx "7", :stroke nil, :fill nil})))


(helix.core/defnc
 web-asset
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M5 8h14v10H5z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm0 14H5V8h14v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-label
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M3 5h18v11H3z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 13H3V5h18v11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 volume-mute
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M9 13h2.83L14 15.17V8.83L11.83 11H9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d "M7 9v6h4l5 5V4l-5 5H7zm7-.17v6.34L11.83 13H9v-2h2.83L14 8.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M8 16h12V4H8v12zm1-7h4V5h2v4h4v2h-4v4h-2v-4H9V9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M2 20c0 1.1.9 2 2 2h14v-2H4V6H2v14zM20 2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H8V4h12v12zm-7-1h2v-4h4V9h-4V5h-2v4H9v2h4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-settings
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,6h18v5h2V6c0-1.1-0.9-2-2-2H3C1.9,4,1,4.9,1,6v12c0,1.1,0.9,2,2,2h9v-2H3V6z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "15,12 9,8 9,16", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M22.71,18.43c0.03-0.29,0.04-0.58,0.01-0.86l1.07-0.85c0.1-0.08,0.12-0.21,0.06-0.32l-1.03-1.79 c-0.06-0.11-0.19-0.15-0.31-0.11L21.23,15c-0.23-0.17-0.48-0.31-0.75-0.42l-0.2-1.36C20.26,13.09,20.16,13,20.03,13h-2.07 c-0.12,0-0.23,0.09-0.25,0.21l-0.2,1.36c-0.26,0.11-0.51,0.26-0.74,0.42l-1.28-0.5c-0.12-0.05-0.25,0-0.31,0.11l-1.03,1.79 c-0.06,0.11-0.04,0.24,0.06,0.32l1.07,0.86c-0.03,0.29-0.04,0.58-0.01,0.86l-1.07,0.85c-0.1,0.08-0.12,0.21-0.06,0.32l1.03,1.79 c0.06,0.11,0.19,0.15,0.31,0.11l1.27-0.5c0.23,0.17,0.48,0.31,0.75,0.42l0.2,1.36c0.02,0.12,0.12,0.21,0.25,0.21h2.07 c0.12,0,0.23-0.09,0.25-0.21l0.2-1.36c0.26-0.11,0.51-0.26,0.74-0.42l1.28,0.5c0.12,0.05,0.25,0,0.31-0.11l1.03-1.79 c0.06-0.11,0.04-0.24-0.06-0.32L22.71,18.43z M19,19.5c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5 S19.83,19.5,19,19.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 snooze
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 11h3.63L9 15.2V17h6v-2h-3.63L15 10.8V9H9zm8.337-9.19l4.607 3.845-1.28 1.535-4.61-3.843zm-10.674 0l1.282 1.536L3.337 7.19l-1.28-1.536zM12 4c-4.97 0-9 4.03-9 9s4.03 9 9 9 9-4.03 9-9-4.03-9-9-9zm0 16c-3.86 0-7-3.14-7-7s3.14-7 7-7 7 3.14 7 7-3.14 7-7 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 not-interested
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 22c5.52 0 10-4.48 10-10S17.52 2 12 2 2 6.48 2 12s4.48 10 10 10zm0-18c4.42 0 8 3.58 8 8 0 1.85-.63 3.55-1.69 4.9L7.1 5.69C8.45 4.63 10.15 4 12 4zM5.69 7.1L16.9 18.31C15.55 19.37 13.85 20 12 20c-4.42 0-8-3.58-8-8 0-1.85.63-3.55 1.69-4.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-add-check-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,4c-4.41,0-8,3.59-8,8s3.59,8,8,8c4.41,0,8-3.59,8-8S16.41,4,12,4z M7,7h7v2H7V7z M7,10h7v2H7V10z M10,15 H7v-2h3V15z M14.05,18.36l-2.83-2.83l1.41-1.41l1.41,1.41L17.59,12L19,13.41L14.05,18.36z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,4c4.41,0,8,3.59,8,8s-3.59,8-8,8s-8-3.59-8-8S7.59,4,12,4z M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10 c5.52,0,10-4.48,10-10C22,6.48,17.52,2,12,2z M14,10H7v2h7V10z M14,7H7v2h7V7z M7,15h3v-2H7V15z M19,13.41L17.59,12l-3.54,3.54 l-1.41-1.41l-1.41,1.41l2.83,2.83L19,13.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-smart-record
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M9 18c3.31 0 6-2.69 6-6s-2.69-6-6-6-6 2.69-6 6 2.69 6 6 6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9 20c4.42 0 8-3.58 8-8s-3.58-8-8-8-8 3.58-8 8 3.58 8 8 8zM9 6c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6 2.69-6 6-6zm8-1.74v2.09c2.33.82 4 3.04 4 5.65s-1.67 4.83-4 5.65v2.09c3.45-.89 6-4.01 6-7.74 0-3.73-2.55-6.85-6-7.74z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 branding-watermark
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 19h18V5H3v14zm8-7h9v6h-9v-6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h18v14zm-10-7h9v6h-9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 subtitles
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 18h16V6H4v12zm14-2h-2v-2h2v2zm-8-6h8v2h-8v-2zm-4 0h2v2H6v-2zm0 4h8v2H6v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H4V6h16v12zM6 10h2v2H6zm0 4h8v2H6zm10 0h2v2h-2zm-6-4h8v2h-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-call
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 16h10V8H5v8zm2-5h2V9h2v2h2v2h-2v2H9v-2H7v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17 7c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l4 4v-11l-4 4V7zm-2 9H5V8h10v8zm-6-1h2v-2h2v-2h-2V9H9v2H7v2h2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/path
    {:d
     "M7,6l5,5V7c3.31,0,6,2.69,6,6s-2.69,6-6,6s-6-2.69-6-6H4c0,4.42,3.58,8,8,8s8-3.58,8-8c0-4.42-3.58-8-8-8V1L7,6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _8k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "12.5",
      :x "7.5",
      :width "1",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "7.5",
      :width "1",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14v-6.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V5H5V19z M11,9h1.5v2.25L14.25,9H16l-2.25,3L16,15 h-1.75l-1.75-2.25V15H11V9z M6,10c0-0.55,0.45-1,1-1h2c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H7c-0.55,0-1-0.45-1-1V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7,15h2c0.55,0,1-0.45,1-1v-4c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v4C6,14.55,6.45,15,7,15z M7.5,10h1v1.5h-1V10z M7.5,12.5h1V14h-1V12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,11.5h-1.5V10h-1v1.5H15v1h1.5 V14h1v-1.5H19V19H5V5h14V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "12.5,12.75 14.25,15 16,15 13.75,12 16,9 14.25,9 12.5,11.25 12.5,9 11,9 11,15 12.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 recent-actors
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M13 7H3v10h10V7zM8 8c1.07 0 1.95.87 1.95 1.95 0 1.07-.87 1.95-1.95 1.95s-1.95-.87-1.95-1.95S6.93 8 8 8zm3.89 8H4.11v-.65c0-1.3 2.59-1.95 3.89-1.95s3.89.65 3.89 1.95V16z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 5h2v14h-2zm-4 0h2v14h-2zm-3 14c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1H2c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h12zM3 7h10v10H3V7z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.95", :cy "9.94", :cx "8", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M8 13.4c-1.3 0-3.89.65-3.89 1.95V16h7.78v-.65c0-1.3-2.59-1.95-3.89-1.95z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-dvr
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 11.56v-.89c0-.76-.58-1.33-1.33-1.33h-3.11v5.33h1.33v-1.78h1.02l.76 1.78H20l-.8-1.87c.44-.22.8-.71.8-1.24zm-1.33 0h-1.78v-.89h1.78v.89zM7.11 9.33H4v5.33h3.11c.76 0 1.33-.58 1.33-1.33v-2.67c0-.75-.57-1.33-1.33-1.33zm0 4H5.33v-2.67h1.78v2.67zm7-4h-1.34l-.89 3.05L11 9.33H9.66l1.56 5.34h1.33z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3", :d "M3 5h18v14H3z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.11 0-2 .89-2 2v14c0 1.1.89 2 2 2h18c1.11 0 2-.9 2-2V5c0-1.11-.89-2-2-2zm0 16H3V5h18v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fast-forward
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "15,9.86 15,14.14 18.03,12",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "6,9.86 6,14.14 9.03,12",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M4,18l8.5-6L4,6V18z M6,9.86L9.03,12L6,14.14V9.86z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M21.5,12L13,6v12L21.5,12z M15,9.86L18.03,12L15,14.14V9.86z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 repeat-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,1H3C1.9,1,1,1.9,1,3v18c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V3C23,1.9,22.1,1,21,1z M19,19H7v3l-4-4l4-4v3h10v-4h2V19z M17,10V7H7v4H5V5h12V2l4,4L17,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 album
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8zm0 12.5c-2.49 0-4.5-2.01-4.5-4.5S9.51 7.5 12 7.5s4.5 2.01 4.5 4.5-2.01 4.5-4.5 4.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-12.5c-2.49 0-4.5 2.01-4.5 4.5s2.01 4.5 4.5 4.5 4.5-2.01 4.5-4.5-2.01-4.5-4.5-4.5zm0 5.5c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _1k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M12,9h1.5v2.25L15.25,9H17l-2.25,3L17,15h-1.75l-1.75-2.25V15H12V9z M7,9h3v6H8.5v-4.5H7 V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,15 10,15 10,9 7,9 7,10.5 8.5,10.5",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "13.5,12.75 15.25,15 17,15 14.75,12 17,9 15.25,9 13.5,11.25 13.5,9 12,9 12,15 13.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 games
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M11 17.33V20h2v-2.67l-1-1zm2-10.66V4h-2v2.67l1 1zM16.33 12l1 1H20v-2h-2.67zM4 11v2h2.67l1-1-1-1z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M2 9v6h5.5l3-3-3-3H2zm4.67 4H4v-2h2.67l1 1-1 1zM22 9h-5.5l-3 3 3 3H22V9zm-2 4h-2.67l-1-1 1-1H20v2zm-5 3.5l-3-3-3 3V22h6v-5.5zM13 20h-2v-2.67l1-1 1 1V20zM9 7.5l3 3 3-3V2H9v5.5zM11 4h2v2.67l-1 1-1-1V4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web-asset-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M20,17.17V8h-9.17L20,17.17z M5.17,8H4v10h11.17L5.17,8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M6.83,4H20c1.11,0,2,0.9,2,2v12c0,0.34-0.09,0.66-0.23,0.94L20,17.17V8h-9.17L6.83,4z M20.49,23.31L17.17,20H4 c-1.11,0-2-0.9-2-2V6c0-0.34,0.08-0.66,0.23-0.94L0.69,3.51L2.1,2.1l19.8,19.8L20.49,23.31z M15.17,18l-10-10H4v10H15.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 skip-previous
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M16 14.14V9.86L12.97 12z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M6 6h2v12H6zm12 12V6l-8.5 6 8.5 6zm-2-3.86L12.97 12 16 9.86v4.28z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 shuffle-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,1H3C1.9,1,1,1.9,1,3v18c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V3C23,1.9,22.1,1,21,1z M5.41,4l5.18,5.17l-1.42,1.41 L4,5.41L5.41,4z M20,20h-5.5l2.05-2.05l-3.13-3.13l1.41-1.41l3.13,3.13L20,14.5V20z M20,9.5l-2.04-2.04L5.41,20L4,18.59L16.54,6.04 L14.5,4H20V9.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 loop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 18c-3.31 0-6-2.69-6-6 0-1.01.25-1.97.7-2.8L5.24 7.74C4.46 8.97 4 10.43 4 12c0 4.42 3.58 8 8 8v3l4-4-4-4v3zm0-14V1L8 5l4 4V6c3.31 0 6 2.69 6 6 0 1.01-.25 1.97-.7 2.8l1.46 1.46C19.54 15.03 20 13.57 20 12c0-4.42-3.58-8-8-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 closed-caption-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :enable-background "new",
    :d
    "M8.83,6H19v10.17l-1.4-1.4C17.84,14.59,18,14.32,18,14v-1h-1.5v0.5h-0.17 l-1.83-1.83V10.5h2V11H18v-1c0-0.55-0.45-1-1-1h-3c-0.55,0-1,0.45-1,1v0.17L8.83,6z M7.5,13.5h2V13h0.67l-2.5-2.5H7.5V13.5z M11,14 c0,0.55-0.45,1-1,1H7c-0.55,0-1-0.45-1-1v-4c0-0.32,0.16-0.59,0.4-0.78L5,7.83V18h10.17L11,13.83V14z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M6.83,4H19c1.1,0,2,0.9,2,2v12c0,0.05-0.01,0.1-0.02,0.16L19,16.17V6H8.83L6.83,4z M19.78,22.61L17.17,20H5 c-1.11,0-2-0.9-2-2V6c0-0.05,0.02-0.1,0.02-0.15L1.39,4.22l1.41-1.41L18,18l1.82,1.82l1.37,1.37L19.78,22.61z M7.5,13.5h2V13h0.67 l-2.5-2.5H7.5V13.5z M15.17,18L11,13.83V14c0,0.55-0.45,1-1,1H7c-0.55,0-1-0.45-1-1v-4c0-0.32,0.16-0.59,0.4-0.78L5,7.83V18H15.17z M18,14v-1h-1.5v0.5h-0.17l1.28,1.28C17.84,14.59,18,14.32,18,14z M14.5,11.67V10.5h2V11H18v-1c0-0.55-0.45-1-1-1h-3 c-0.55,0-1,0.45-1,1v0.17L14.5,11.67z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _2k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M13,9h1.5v2.25L16.25,9H18l-2.25,3L18,15h-1.75l-1.75-2.25V15H13V9z M6.5,12.5 c0-0.55,0.45-1,1-1h2v-1h-3V9H10c0.55,0,1,0.45,1,1v1.5c0,0.55-0.45,1-1,1H8v1h3V15H6.5V12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,13.5H8v-1h2c0.55,0,1-0.45,1-1V10c0-0.55-0.45-1-1-1H6.5v1.5h3v1h-2c-0.55,0-1,0.45-1,1V15H11V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.5,12.75 16.25,15 18,15 15.75,12 18,9 16.25,9 14.5,11.25 14.5,9 13,9 13,15 14.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 library-add-check
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M8,16h12V4H8V16z M10.4,9.09l2.07,2.08L17.6,6L19,7.41L12.47,14L9,10.5L10.4,9.09z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H8C6.9,2,6,2.9,6,4v12c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M20,16H8V4h12V16z M12.47,14 L9,10.5l1.4-1.41l2.07,2.08L17.6,6L19,7.41L12.47,14z M4,20h14v2H4c-1.1,0-2-0.9-2-2V6h2V20z",
      :stroke nil,
      :fill nil}))
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))))


(helix.core/defnc
 art-track
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 7h8v2h-8zm0 4h8v2h-8zm0 4h8v2h-8zM4 17h6c1.1 0 2-.9 2-2V9c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v6c0 1.1.9 2 2 2zm1.25-4.25l1.25 1.51L8.25 12l2.25 3h-7l1.75-2.25z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 skip-next
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M8 9.86v4.28L11.03 12z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M14.5 12L6 6v12l8.5-6zM8 9.86L11.03 12 8 14.14V9.86zM16 6h2v12h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 16.5l6-4.5-6-4.5zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _8k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "10",
      :x "8",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12.5",
      :x "8",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M13,9h1.5v2.25L16.25,9H18l-2.25,3L18,15h-1.75l-1.75-2.25V15H13V9z M6.5,10 c0-0.55,0.45-1,1-1H10c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H7.5c-0.55,0-1-0.45-1-1V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,15H10c0.55,0,1-0.45,1-1v-4c0-0.55-0.45-1-1-1H7.5c-0.55,0-1,0.45-1,1v4C6.5,14.55,6.95,15,7.5,15z M8,10h1.5v1.5H8 V10z M8,12.5h1.5V14H8V12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.5,12.75 16.25,15 18,15 15.75,12 18,9 16.25,9 14.5,11.25 14.5,9 13,9 13,15 14.5,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 folder-shared
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M11.17 8l-.59-.59L9.17 6H4v12h16V8h-8.83zM19 16v1h-8v-1c0-1.33 2.67-2 4-2s4 .67 4 2zm-4-7c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 6h-8l-2-2H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 12H4V6h5.17l2 2H20v10zm-5-5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm-4 3v1h8v-1c0-1.33-2.67-2-4-2s-4 .67-4 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 snippet-folder
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d "M9.17,6H4v12l16,0V8h-8.83L9.17,6z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M20,6h-8l-2-2H4C2.9,4,2.01,4.9,2.01,6L2,18c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8C22,6.9,21.1,6,20,6z M20,18L4,18V6h5.17 l2,2H20V18z M17.5,12.12v3.38l-3,0v-5h1.38L17.5,12.12z M16.5,9H13v8l6,0v-5.5L16.5,9L16.5,9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 file-upload
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "9.83,8 11,8 11,14 13,14 13,8 14.17,8 12,5.83",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "18",
      :x "5",
      :width "14",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5,10h4v6h6v-6h4l-7-7L5,10z M13,8v6h-2V8H9.83L12,5.83L14.17,8H13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 create-new-folder
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M11.17 8l-.59-.59L9.17 6H4v12h16V8h-8.83zM14 10h2v2h2v2h-2v2h-2v-2h-2v-2h2v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 6h-8l-2-2H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm0 12H4V6h5.17l1.41 1.41.59.59H20v10zm-8-4h2v2h2v-2h2v-2h-2v-2h-2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-open
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M4 8h16v10H4z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M20 6h-8l-2-2H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 12H4V8h16v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 drive-file-move-rtl
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M11.17,8l-2-2H4v12h16V8H11.17z M16,14h-4v3l-4-4l4-4v3h4V14z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20,6h-8l-2-2H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8C22,6.9,21.1,6,20,6z M20,18H4V6h5.17l2,2H20V18z M12,17l-4-4l4-4v3h4v2h-4V17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 drive-file-move
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,6h-8l-2-2H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8C22,6.9,21.1,6,20,6z M20,18H4V6h5.17l1.41,1.41 L11.17,8H20V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8,14 12,14 12,17 16,13 12,9 12,12 8,12",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M10.59,7.41L9.17,6H4v12h16V8h-8.83L10.59,7.41z M12,9l4,4l-4,4v-3H8v-2h4V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cloud-done
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19.21 12.04l-1.53-.11-.3-1.5C16.88 7.86 14.62 6 12 6 9.94 6 8.08 7.14 7.12 8.96l-.5.95-1.07.11C3.53 10.24 2 11.95 2 14c0 2.21 1.79 4 4 4h13c1.65 0 3-1.35 3-3 0-1.55-1.22-2.86-2.79-2.96zM10 17l-3.5-3.5 1.41-1.41L10 14.18l4.6-4.6 1.41 1.41L10 17z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4 0-2.05 1.53-3.76 3.56-3.97l1.07-.11.5-.95C8.08 7.14 9.94 6 12 6c2.62 0 4.88 1.86 5.39 4.43l.3 1.5 1.53.11c1.56.1 2.78 1.41 2.78 2.96 0 1.65-1.35 3-3 3zm-9-3.82l-2.09-2.09L6.5 13.5 10 17l6.01-6.01-1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cloud-queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 12h-1.5v-.5C17.5 8.46 15.04 6 12 6c-2.52 0-4.63 1.69-5.29 4H6c-2.21 0-4 1.79-4 4s1.79 4 4 4h13c1.66 0 3-1.34 3-3s-1.34-3-3-3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4s1.79-4 4-4h.71C7.37 7.69 9.48 6 12 6c3.04 0 5.5 2.46 5.5 5.5v.5H19c1.66 0 3 1.34 3 3s-1.34 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-copy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "11.17,4 7,4 7,15 21,15 21,6 13.17,6",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,4h-7l-2-2H7C5.9,2,5.01,2.9,5.01,4L5,15c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V6C23,4.9,22.1,4,21,4z M21,15H7V4h4.17 l2,2H21V15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M3,6H1v13c0,1.1,0.9,2,2,2h17v-2H3V6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 drive-file-rename-outline
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "12.06,10.02 5,17.08 5,18 5.92,18 12.98,10.94",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "15,16 11,20 21,20 21,16", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M12.06,7.19L3,16.25V20h3.75l9.06-9.06L12.06,7.19z M5.92,18H5v-0.92l7.06-7.06l0.92,0.92L5.92,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.71,8.04c0.39-0.39,0.39-1.02,0-1.41l-2.34-2.34C16.17,4.09,15.92,4,15.66,4c-0.25,0-0.51,0.1-0.7,0.29l-1.83,1.83 l3.75,3.75L18.71,8.04z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 download-done
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 18h14v2H5v-2zm4.6-2.7L5 10.7l2-1.9 2.6 2.6L17 4l2 2-9.4 9.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-delete
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M14.5,11.5h2v4h-2V11.5z M20,8v10H4V6h5.17l2,2H20z M19,10h-2.5V9h-2v1H12v1.5h1v4c0,0.83,0.67,1.5,1.5,1.5 h2c0.83,0,1.5-0.67,1.5-1.5v-4h1V10z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M16.5,10V9h-2v1H12v1.5h1v4c0,0.83,0.67,1.5,1.5,1.5h2c0.83,0,1.5-0.67,1.5-1.5v-4h1V10H16.5z M16.5,15.5h-2v-4h2V15.5z M20,6h-8l-2-2H4C2.89,4,2.01,4.89,2.01,6L2,18c0,1.11,0.89,2,2,2h16c1.11,0,2-0.89,2-2V8C22,6.89,21.11,6,20,6z M20,18H4V6h5.17 l2,2H20V18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 text-snippet
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M14.17,5L19,9.83V19H5V5L14.17,5L14.17,5 M7,15h10v2H7V15z M7,11h10v2H7V11z M7,7h7v2H7V7z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M14.17,5L19,9.83V19H5V5L14.17,5L14.17,5 M14.17,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V9.83 c0-0.53-0.21-1.04-0.59-1.41l-4.83-4.83C15.21,3.21,14.7,3,14.17,3L14.17,3z M7,15h10v2H7V15z M7,11h10v2H7V11z M7,7h7v2H7V7z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cloud-download
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19.21 12.04l-1.53-.11-.3-1.5C16.88 7.86 14.62 6 12 6 9.94 6 8.08 7.14 7.12 8.96l-.5.95-1.07.11C3.53 10.24 2 11.95 2 14c0 2.21 1.79 4 4 4h13c1.65 0 3-1.35 3-3 0-1.55-1.22-2.86-2.79-2.96zM12 17l-4-4h2.55v-3h2.91v3H16l-4 4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4 0-2.05 1.53-3.76 3.56-3.97l1.07-.11.5-.95C8.08 7.14 9.94 6 12 6c2.62 0 4.88 1.86 5.39 4.43l.3 1.5 1.53.11c1.56.1 2.78 1.41 2.78 2.96 0 1.65-1.35 3-3 3zm-5.55-8h-2.9v3H8l4 4 4-4h-2.55z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-download-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/polygon
   {:points "13,5 11,5 11,8.17 13,10.17",
    :opacity ".3",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M11,8.17l-2-2V3h6v6h4l-3.59,3.59L13,10.17V5h-2V8.17z M21.19,21.19L2.81,2.81L1.39,4.22L6.17,9H5l7,7l0.59-0.59L15.17,18H5 v2h12.17l2.61,2.61L21.19,21.19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-open
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points "15,14 18,14 18,9 13,9 13,4 6,4 6,20 15,20",
     :opacity ".3",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M15,22H6c-1.1,0-2-0.9-2-2V4c0-1.1,0.9-2,2-2h8l6,6v6h-2V9h-5V4H6v16h9V22z M19,21.66l0-2.24l2.95,2.95l1.41-1.41L20.41,18 h2.24v-2H17v5.66H19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 attachment
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.5 16H7c-2.21 0-4-1.79-4-4s1.79-4 4-4h12.5c1.38 0 2.5 1.12 2.5 2.5S20.88 13 19.5 13H9c-.55 0-1-.45-1-1s.45-1 1-1h9.5V9.5H9c-1.38 0-2.5 1.12-2.5 2.5s1.12 2.5 2.5 2.5h10.5c2.21 0 4-1.79 4-4s-1.79-4-4-4H7c-3.04 0-5.5 2.46-5.5 5.5s2.46 5.5 5.5 5.5h11.5V16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cloud-upload
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19.21 12.04l-1.53-.11-.3-1.5C16.88 7.86 14.62 6 12 6 9.94 6 8.08 7.14 7.12 8.96l-.5.95-1.07.11C3.53 10.24 2 11.95 2 14c0 2.21 1.79 4 4 4h13c1.65 0 3-1.35 3-3 0-1.55-1.22-2.86-2.79-2.96zm-5.76.96v3h-2.91v-3H8l4-4 4 4h-2.55z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4 0-2.05 1.53-3.76 3.56-3.97l1.07-.11.5-.95C8.08 7.14 9.94 6 12 6c2.62 0 4.88 1.86 5.39 4.43l.3 1.5 1.53.11c1.56.1 2.78 1.41 2.78 2.96 0 1.65-1.35 3-3 3zM8 13h2.55v3h2.9v-3H16l-4-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M11.17 8l-.58-.59L9.17 6H4v12h16V8h-8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 6h-8l-2-2H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 12H4V6h5.17l1.41 1.41.59.59H20v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-download-done
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "20.13,5.41 18.72,4 9.53,13.19 5.28,8.95 3.87,10.36 9.53,16.02",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "18",
      :x "5",
      :width "14",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cloud-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8zm4.08 12H8.5C6.57 16 5 14.43 5 12.5c0-1.8 1.36-3.29 3.12-3.48.73-1.4 2.19-2.36 3.88-2.36 2.12 0 3.89 1.51 4.29 3.52 1.52.1 2.71 1.35 2.71 2.89 0 1.62-1.31 2.93-2.92 2.93z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm4.29-9.81c-.4-2.01-2.16-3.52-4.29-3.52-1.69 0-3.15.96-3.88 2.36C6.36 9.21 5 10.7 5 12.5 5 14.43 6.57 16 8.5 16h7.58c1.61 0 2.92-1.31 2.92-2.92 0-1.54-1.2-2.79-2.71-2.89zM16 14H8.5c-.83 0-1.5-.67-1.5-1.5S7.67 11 8.5 11h.9l.49-1.05c.41-.79 1.22-1.28 2.11-1.28 1.13 0 2.11.8 2.33 1.91l.28 1.42H16c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 format-overline
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3v2H5V3H19z M12,7c-3.87,0-7,3.13-7,7c0,3.87,3.13,7,7,7s7-3.13,7-7C19,10.13,15.87,7,12,7z M12,18.5 c-2.49,0-4.5-2.01-4.5-4.5S9.51,9.5,12,9.5s4.5,2.01,4.5,4.5S14.49,18.5,12,18.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 download-for-offline
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,4c-4.41,0-8,3.59-8,8c0,4.41,3.59,8,8,8s8-3.59,8-8C20,7.59,16.41,4,12,4z M11,10V6h2v4h3l-4,4l-4-4H11 z M17,17H7v-2h10V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "16,10 13,10 13,6 11,6 11,10 8,10 12,14",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "7",
      :width "10",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C6.49,2,2,6.49,2,12s4.49,10,10,10s10-4.49,10-10S17.51,2,12,2z M12,20c-4.41,0-8-3.59-8-8c0-4.41,3.59-8,8-8 s8,3.59,8,8C20,16.41,16.41,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cloud-sync
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    {:opacity ".3"}
    (helix.dom/path
     {:d
      "M21.51,18L21.51,18L15,18c-0.55,0-1-0.45-1-1s0.45-1,1-1h1.25v-0.25c0-0.97,0.78-1.75,1.75-1.75s1.75,0.78,1.75,1.75V17 c0,0,1.75,0,1.76,0c0.28,0,0.5,0.22,0.5,0.5C22,17.77,21.78,18,21.51,18z",
      :stroke nil,
      :fill nil}))
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.5,14.98c-0.02,0-0.03,0-0.05,0.01C21.2,13.3,19.76,12,18,12c-1.4,0-2.6,0.83-3.16,2.02C13.26,14.1,12,15.4,12,17 c0,1.66,1.34,3,3,3l6.5-0.02c1.38,0,2.5-1.12,2.5-2.5S22.88,14.98,21.5,14.98z M21.51,18L21.51,18L15,18c-0.55,0-1-0.45-1-1 s0.45-1,1-1h1.25v-0.25c0-0.97,0.78-1.75,1.75-1.75s1.75,0.78,1.75,1.75V17c0,0,1.75,0,1.76,0c0.28,0,0.5,0.22,0.5,0.5 C22,17.77,21.78,18,21.51,18z M10,4.26v2.09C7.67,7.18,6,9.39,6,12c0,1.77,0.78,3.34,2,4.44V14h2v6H4v-2h2.73 C5.06,16.54,4,14.4,4,12C4,8.27,6.55,5.15,10,4.26z M20,6h-2.73c1.43,1.26,2.41,3.01,2.66,5l-2.02,0 C17.68,9.64,16.98,8.45,16,7.56V10h-2V4h6V6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 newspaper
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,3l-1.67,1.67L18.67,3L17,4.67L15.33,3l-1.66,1.67L12,3l-1.67,1.67L8.67,3L7,4.67L5.33,3L3.67,4.67L2,3v16 c0,1.1,0.9,2,2,2l16,0c1.1,0,2-0.9,2-2V3z M11,19H4v-6h7V19z M20,19h-7v-2h7V19z M20,15h-7v-2h7V15z M20,11H4V8h16V11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 topic
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M20,18L4,18V6h5.17l2,2H20V18z M18,12H6v-2h12V12z M14,16H6v-2h8V16z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M20,6h-8l-2-2H4C2.9,4,2.01,4.9,2.01,6L2,18c0,1.1,0.9,2,2,2h16.77c0.68,0,1.23-0.56,1.23-1.23V8C22,6.9,21.1,6,20,6z M20,18L4,18V6h5.17l2,2H20V18z M18,12H6v-2h12V12z M14,16H6v-2h8V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 workspaces
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2",
      :opacity ".3",
      :cy "17",
      :cx "6",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2",
      :opacity ".3",
      :cy "7",
      :cx "12",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2",
      :opacity ".3",
      :cy "17",
      :cx "18",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,13c-2.2,0-4,1.8-4,4s1.8,4,4,4s4-1.8,4-4S20.2,13,18,13z M18,19c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2s2,0.9,2,2 C20,18.1,19.1,19,18,19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M6,13c-2.2,0-4,1.8-4,4s1.8,4,4,4s4-1.8,4-4S8.2,13,6,13z M6,19c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2s2,0.9,2,2 C8,18.1,7.1,19,6,19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,7c0-2.2-1.8-4-4-4S8,4.8,8,7s1.8,4,4,4S16,9.2,16,7z M12,9c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2s2,0.9,2,2 C14,8.1,13.1,9,12,9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 rule-folder
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M11.17,8l-2-2H4v12l16,0V8H11.17z M7.83,16L5,13.17l1.41-1.41l1.41,1.41l3.54-3.54l1.41,1.41L7.83,16z M19,14.59L17.59,16L16,14.41L14.41,16L13,14.59L14.59,13L13,11.41L14.41,10L16,11.59L17.59,10L19,11.41L17.41,13L19,14.59z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M7.83,16L5,13.17l1.41-1.41l1.41,1.41l3.54-3.54l1.41,1.41L7.83,16z M17.41,13L19,14.59L17.59,16L16,14.41L14.41,16 L13,14.59L14.59,13L13,11.41L14.41,10L16,11.59L17.59,10L19,11.41L17.41,13z M20,6h-8l-2-2H4C2.9,4,2.01,4.9,2.01,6L2,18 c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8C22,6.9,21.1,6,20,6z M20,18L4,18V6h5.17l2,2H20V18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 folder-zip
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M16,16h2v-2h-2v-2h2v-2h-2V8h4v10h-4V16z M16,16h-2v2H4V6h5.17l2,2H14v2h2v2h-2v2h2V16z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M20,6h-8l-2-2H4C2.9,4,2.01,4.9,2.01,6L2,18c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8C22,6.9,21.1,6,20,6z M16,16h2v-2h-2v-2 h2v-2h-2V8h4v10h-4V16z M16,16h-2v2H4V6h5.17l2,2H14v2h2v2h-2v2h2V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 difference
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M14.17,3H8v14h11V7.83L14.17,3z M16.5,15h-6v-2h6V15z M16.5,9h-2v2h-2V9h-2V7h2V5h2v2h2V9z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M18,23H4c-1.1,0-2-0.9-2-2V7h2v14h14V23z M14.5,7V5h-2v2h-2v2h2v2h2V9h2V7H14.5z M16.5,13h-6v2h6V13z M15,1H8 C6.9,1,6.01,1.9,6.01,3L6,17c0,1.1,0.89,2,1.99,2H19c1.1,0,2-0.9,2-2V7L15,1z M19,17H8V3h6.17L19,7.83V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 attach-email
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,6l8,5l8-5v3h2V4c0-1.1-0.9-2-2-2H3C1.9,2,1.01,2.9,1.01,4L1,16c0,1.1,0.9,2,2,2h10v-2H3V6z M19,4l-8,5L3,4H19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,14v4c0,1.1-0.9,2-2,2s-2-0.9-2-2v-4.5c0-0.28,0.22-0.5,0.5-0.5s0.5,0.22,0.5,0.5V18h2v-4.5c0-1.38-1.12-2.5-2.5-2.5 S15,12.12,15,13.5V18c0,2.21,1.79,4,4,4s4-1.79,4-4v-4H21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 download
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M13 9V5h-2v6H9.83L12 13.17 14.17 11H13z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15 9V3H9v6H5l7 7 7-7h-4zm-3 4.17L9.83 11H11V5h2v6h1.17L12 13.17zM5 18h14v2H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 downloading
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.32,4.26C16.84,3.05,15.01,2.25,13,2.05v2.02c1.46,0.18,2.79,0.76,3.9,1.62L18.32,4.26z M19.93,11h2.02 c-0.2-2.01-1-3.84-2.21-5.32L18.31,7.1C19.17,8.21,19.75,9.54,19.93,11z M18.31,16.9l1.43,1.43c1.21-1.48,2.01-3.32,2.21-5.32 h-2.02C19.75,14.46,19.17,15.79,18.31,16.9z M13,19.93v2.02c2.01-0.2,3.84-1,5.32-2.21l-1.43-1.43 C15.79,19.17,14.46,19.75,13,19.93z M13,12V7h-2v5H7l5,5l5-5H13z M11,19.93v2.02c-5.05-0.5-9-4.76-9-9.95s3.95-9.45,9-9.95v2.02 C7.05,4.56,4,7.92,4,12S7.05,19.44,11,19.93z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cloud
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19.21 12.04l-1.53-.11-.3-1.5C16.88 7.86 14.62 6 12 6 9.94 6 8.08 7.14 7.12 8.96l-.5.95-1.07.11C3.53 10.24 2 11.95 2 14c0 2.21 1.79 4 4 4h13c1.65 0 3-1.35 3-3 0-1.55-1.22-2.86-2.79-2.96z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4 0-2.05 1.53-3.76 3.56-3.97l1.07-.11.5-.95C8.08 7.14 9.94 6 12 6c2.62 0 4.88 1.86 5.39 4.43l.3 1.5 1.53.11c1.56.1 2.78 1.41 2.78 2.96 0 1.65-1.35 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-download
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "14.17,11 13,11 13,5 11,5 11,11 9.83,11 12,13.17",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "18",
      :x "5",
      :width "14",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,9h-4V3H9v6H5l7,7L19,9z M11,11V5h2v6h1.17L12,13.17L9.83,11H11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 drive-folder-upload
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M9.17,6H4v12l16,0V8h-8.83L9.17,6z M16,13h-3v4h-2v-4H8l4.01-4L16,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,6h-8l-2-2H4C2.9,4,2.01,4.9,2.01,6L2,18c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8C22,6.9,21.1,6,20,6z M20,18L4,18V6 h5.17l2,2H20V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,13 11,17 13,17 13,13 16,13 12.01,9 8,13",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 upload-file
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M13,4H6v16h12V9h-5V4z M16,15h-3v4h-2v-4H8l4.01-4L16,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14,2H6C4.9,2,4.01,2.9,4.01,4L4,20c0,1.1,0.89,2,1.99,2H18c1.1,0,2-0.9,2-2V8L14,2z M18,20H6V4h7v5h5V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8,15 11,15 11,19 13,19 13,15 16,15 12.01,11",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 grid-view
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "5",
      :x "5",
      :width "4",
      :opacity ".3",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "5",
      :width "4",
      :opacity ".3",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "15",
      :width "4",
      :opacity ".3",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "15",
      :width "4",
      :opacity ".3",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M3,21h8v-8H3V21z M5,15h4v4H5V15z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M3,11h8V3H3V11z M5,5h4v4H5V5z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M13,21h8v-8h-8V21z M15,15h4v4h-4V15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M13,3v8h8V3H13z M19,9h-4V5h4V9z", :stroke nil, :fill nil})))))


(helix.core/defnc
 cloud-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M22 15c0-1.66-1.34-3-3-3h-1.5v-.5C17.5 8.46 15.04 6 12 6c-.77 0-1.49.17-2.16.46L20.79 17.4c.73-.55 1.21-1.41 1.21-2.4zM2 14c0 2.21 1.79 4 4 4h9.73l-8-8H6c-2.21 0-4 1.79-4 4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4c-1.33 0-2.57.36-3.65.97l1.49 1.49C10.51 6.17 11.23 6 12 6c3.04 0 5.5 2.46 5.5 5.5v.5H19c1.66 0 3 1.34 3 3 0 .99-.48 1.85-1.21 2.4l1.41 1.41c1.09-.92 1.8-2.27 1.8-3.81 0-2.64-2.05-4.78-4.65-4.96zM3 5.27l2.77 2.77h-.42C2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h11.73l2 2 1.41-1.41L4.41 3.86 3 5.27zM7.73 10l8 8H6c-2.21 0-4-1.79-4-4s1.79-4 4-4h1.73z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 request-quote
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M6,20V4h7v4h5v12H6z M11,19h2v-1h1c0.55,0,1-0.45,1-1v-3c0-0.55-0.45-1-1-1h-3v-1h4v-2h-2V9h-2v1h-1 c-0.55,0-1,0.45-1,1v3c0,0.55,0.45,1,1,1h3v1H9v2h2V19z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M14,2H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V8L14,2z M6,20V4h7v4h5v12H6z M11,19h2v-1h1 c0.55,0,1-0.45,1-1v-3c0-0.55-0.45-1-1-1h-3v-1h4v-2h-2V9h-2v1h-1c-0.55,0-1,0.45-1,1v3c0,0.55,0.45,1,1,1h3v1H9v2h2V19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 folder-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "15.17,18 4,6.83 4,18",
      :opacity ".3",
      :enable-background "new",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11.17,8 20,17.17 20,8",
      :opacity ".3",
      :enable-background "new",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M0.69,3.51l1.56,1.56C2.1,5.35,2.01,5.66,2.01,6L2,18c0,1.1,0.9,2,2,2h13.17l3.31,3.31l1.41-1.41L2.1,2.1L0.69,3.51z M15.17,18H4V6.83L15.17,18z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M20,6h-8l-2-2H7.17l4,4H20v9.17l1.76,1.76C21.91,18.65,22,18.34,22,18V8C22,6.9,21.1,6,20,6z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 upload
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M9.83 8H11v6h2V8h1.17L12 5.83z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 3l-7 7h4v6h6v-6h4l-7-7zm1 5v6h-2V8H9.83L12 5.83 14.17 8H13zM5 18h14v2H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 approval
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "16",
      :x "6",
      :width "12",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M12,4c-1.66,0-3,1.34-3,3l3,4l3-4C15,5.34,13.66,4,12,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C9.24,2,7,4.24,7,7l5,7l5-7C17,4.24,14.76,2,12,2z M12,11L9,7c0-1.66,1.34-3,3-3s3,1.34,3,3L12,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,14h-6H6c-1.1,0-2,0.9-2,2v6h16v-6C20,14.9,19.1,14,18,14z M18,18H6v-2h12V18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 phone-callback
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M6.54 5h-1.5c.09 1.32.35 2.59.75 3.8l1.2-1.2c-.24-.84-.39-1.71-.45-2.6zm8.66 13.21c1.2.41 2.48.67 3.8.75v-1.49c-.88-.07-1.75-.22-2.6-.45l-1.2 1.19z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 15.51c-1.24 0-2.45-.2-3.57-.57-.1-.04-.21-.05-.31-.05-.26 0-.51.1-.71.29l-2.2 2.2c-2.83-1.45-5.15-3.76-6.59-6.59l2.2-2.2c.28-.28.36-.67.25-1.02C8.7 6.45 8.5 5.25 8.5 4c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1 0 9.39 7.61 17 17 17 .55 0 1-.45 1-1v-3.49c0-.55-.45-1-1-1zM5.03 5h1.5c.07.89.22 1.76.46 2.59l-1.2 1.2c-.41-1.2-.67-2.47-.76-3.79zM19 18.97c-1.32-.09-2.59-.35-3.8-.75l1.19-1.19c.85.24 1.72.39 2.6.45v1.49zM18 9h-2.59l5.02-5.02-1.41-1.41L14 7.59V5h-2v6h6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vibration
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M8 5h8v14H8z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M19 7h2v10h-2zm3 2h2v6h-2zM0 9h2v6H0zm16.5-6h-9C6.67 3 6 3.67 6 4.5v15c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5v-15c0-.83-.67-1.5-1.5-1.5zM16 19H8V5h8v14zM3 7h2v10H3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-paused
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M6.54 5h-1.5c.09 1.32.34 2.58.75 3.79l1.2-1.21c-.24-.83-.39-1.7-.45-2.58zm8.66 13.21c1.21.41 2.48.67 3.8.76v-1.5c-.88-.07-1.75-.22-2.6-.45l-1.2 1.19z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 15.5c-1.25 0-2.45-.2-3.57-.57-.1-.03-.21-.05-.31-.05-.26 0-.51.1-.71.29l-2.2 2.2c-2.83-1.44-5.15-3.75-6.59-6.59l2.2-2.21c.28-.26.36-.65.25-1C8.7 6.45 8.5 5.25 8.5 4c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1 0 9.39 7.61 17 17 17 .55 0 1-.45 1-1v-3.5c0-.55-.45-1-1-1zM5.03 5h1.5c.07.88.22 1.75.45 2.58l-1.2 1.21c-.4-1.21-.66-2.47-.75-3.79zM19 18.97c-1.32-.09-2.6-.35-3.8-.76l1.2-1.2c.85.24 1.72.39 2.6.45v1.51zM15 3h2v7h-2zm4 0h2v7h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 power
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M8 13.65l3.5 3.52V19h1v-1.83l3.5-3.51V9H8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16 7V3h-2v4h-4V3H8v4h-.01C6.89 7 6 7.89 6 8.98v5.52L9.5 18v3h5v-3l3.5-3.5V9c0-1.1-.9-2-2-2zm0 6.66l-3.5 3.51V19h-1v-1.83L8 13.65V9h8v4.66z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wifi
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M1 9l2 2c4.97-4.97 13.03-4.97 18 0l2-2C16.93 2.93 7.08 2.93 1 9zm8 8l3 3 3-3c-1.65-1.66-4.34-1.66-6 0zm-4-4l2 2c2.76-2.76 7.24-2.76 10 0l2-2C15.14 9.14 8.87 9.14 5 13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-recline-extra
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.35 5.64c-.9-.64-1.12-1.88-.49-2.79.63-.9 1.88-1.12 2.79-.49.9.64 1.12 1.88.49 2.79-.64.9-1.88 1.12-2.79.49zM16 19H8.93c-1.48 0-2.74-1.08-2.96-2.54L4 7H2l1.99 9.76C4.37 19.2 6.47 21 8.94 21H16v-2zm.23-4h-4.88l-1.03-4.1c1.58.89 3.28 1.54 5.15 1.22V9.99c-1.63.31-3.44-.27-4.69-1.25L9.14 7.47c-.23-.18-.49-.3-.76-.38-.32-.09-.66-.12-.99-.06h-.02c-1.23.22-2.05 1.39-1.84 2.61l1.35 5.92C7.16 16.98 8.39 18 9.83 18h6.85l3.82 3 1.5-1.5-5.77-4.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sms-failed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M4 17.17L5.17 16H20V4H4v13.17zM11 6h2v4h-2V6zm0 6h2v2h-2v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.17L4 17.17V4h16v12zm-9-4h2v2h-2zm0-6h2v4h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-legroom-normal
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 12V3H3v9c0 2.76 2.24 5 5 5h6v-2H8c-1.66 0-3-1.34-3-3zm15.5 6H19v-7c0-1.1-.9-2-2-2h-5V3H6v8c0 1.65 1.35 3 3 3h7v7h4.5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-disturb-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8zm5 9H7v-2h10v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-5-9h10v2H7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 enhanced-encryption
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M6 20h12V10H6v10zm2-6h3v-3h2v3h3v2h-3v3h-2v-3H8v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM8.9 6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2H8.9V6zM18 20H6V10h12v10zm-7-1h2v-3h3v-2h-3v-3h-2v3H8v2h3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tap-and-play
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 16v2c2.76 0 5 2.24 5 5h2c0-3.87-3.13-7-7-7zm0 4v3h3c0-1.66-1.34-3-3-3zm0-8v2c4.97 0 9 4.03 9 9h2c0-6.08-4.92-11-11-11zM17 1.01L7 1c-1.1 0-2 .9-2 2v7.37c.69.16 1.36.37 2 .64V5h10v13h-3.03c.52 1.25.84 2.59.95 4H17c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-locked
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,5V4c0-1.1-0.9-2-2-2s-2,0.9-2,2v1h-1v5h6V5H20z M19,5h-2V4c0-0.55,0.45-1,1-1s1,0.45,1,1V5z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:opacity ".3",
       :enable-background "new",
       :d
       "M15,17.83c1.29,0.54,2.63,0.89,4,1.07v-2.23l-2.35-0.47L15,17.83z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:opacity ".3",
       :enable-background "new",
       :d "M7.33,5H5.1c0.18,1.37,0.53,2.7,1.07,4L7.8,7.35L7.33,5z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M20.2,14.87l-3.67-0.73c-0.5-0.1-0.83,0.2-0.9,0.27l-2.52,2.5c-2.5-1.43-4.57-3.5-6-6l2.5-2.52 c0.23-0.24,0.33-0.57,0.27-0.9L9.13,3.8C9.04,3.34,8.63,3,8.15,3H4C3.44,3,2.97,3.47,3,4.03C3.17,6.92,4.05,9.63,5.43,12 c1.58,2.73,3.85,4.99,6.57,6.57c2.37,1.37,5.08,2.26,7.97,2.43c0.55,0.03,1.03-0.43,1.03-1v-4.15 C21,15.37,20.66,14.96,20.2,14.87z M5.1,5h2.23L7.8,7.35L6.17,9C5.63,7.7,5.27,6.37,5.1,5z M19,18.9c-1.37-0.18-2.7-0.53-4-1.07 l1.65-1.63L19,16.67V18.9z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 do-not-disturb-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:opacity ".3",
       :enable-background "new",
       :d
       "M12,4c-4.41,0-8,3.59-8,8s3.59,8,8,8s8-3.59,8-8S16.41,4,12,4z M17,13H7v-2 h10V13z",
       :stroke nil,
       :fill nil})
     (helix.dom/rect
      {:y "11",
       :x "7",
       :width "10",
       :height "2",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-4.41,0-8-3.59-8-8s3.59-8,8-8s8,3.59,8,8 S16.41,20,12,20z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 do-disturb
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8 0-1.85.63-3.55 1.69-4.9L16.9 18.31C15.55 19.37 13.85 20 12 20zm6.31-3.1L7.1 5.69C8.45 4.63 10.15 4 12 4c4.42 0 8 3.58 8 8 0 1.85-.63 3.55-1.69 4.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 power-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12.12 9L16 12.88V9zm-.62 8.17V19h1v-1.83l1.07-1.06L8 10.54v3.11z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M10 3H8v1.88l2 2zm6 6v3.88l1.8 1.8.2-.2V9c0-1.1-.9-2-2-2V3h-2v4h-3.88l2 2H16zM4.12 3.84L2.71 5.25 6 8.54v5.96L9.5 18v3h5v-3l.48-.48 4.47 4.47 1.41-1.41L4.12 3.84zm8.38 13.33V19h-1v-1.83L8 13.65v-3.11l5.57 5.57-1.07 1.06z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 voice-chat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 17.17L5.17 16H20V4H4v13.17zM7 7h7v2.4L17 7v6l-3-2.4V13H7V7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.17L4 17.17V4h16v12zm-6-5.4l3 2.4V7l-3 2.4V7H7v6h7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-legroom-reduced
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.97 19.2c.18.96-.55 1.8-1.47 1.8H14v-3l1-4H9c-1.65 0-3-1.35-3-3V3h6v6h5c1.1 0 2 .9 2 2l-2 7h1.44c.73 0 1.39.49 1.53 1.2zM5 12V3H3v9c0 2.76 2.24 5 5 5h4v-2H8c-1.66 0-3-1.34-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sms
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 17.17L5.17 16H20V4H4v13.17zM15 9h2v2h-2V9zm-4 0h2v2h-2V9zM7 9h2v2H7V9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.17L4 17.17V4h16v12zM7 9h2v2H7zm8 0h2v2h-2zm-4 0h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sd-card
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M6 8.83V20h12V4h-7.17L6 8.83zM15 7h2v4h-2V7zm-3 0h2v4h-2V7zm-1 4H9V7h2v4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18 2h-8L4 8v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 18H6V8.83L10.83 4H18v16zM9 7h2v4H9zm3 0h2v4h-2zm3 0h2v4h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync-problem
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 12c0 2.21.91 4.2 2.36 5.64L3 20h6v-6l-2.24 2.24C5.68 15.15 5 13.66 5 12c0-2.61 1.67-4.83 4-5.65V4.26C5.55 5.15 3 8.27 3 12zm8 5h2v-2h-2v2zM21 4h-6v6l2.24-2.24C18.32 8.85 19 10.34 19 12c0 2.61-1.67 4.83-4 5.65v2.09c3.45-.89 6-4.01 6-7.74 0-2.21-.91-4.2-2.36-5.64L21 4zm-10 9h2V7h-2v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-special
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M11.17 8l-2-2H4v12h16V8h-8.83zM15 9l1.19 2.79 3.03.26-2.3 1.99.69 2.96L15 15.47 12.39 17l.69-2.96-2.3-1.99 3.03-.26L15 9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 6h-8l-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 12H4V6h5.17l2 2H20v10zm-6.92-3.96L12.39 17 15 15.47 17.61 17l-.69-2.96 2.3-1.99-3.03-.26L15 9l-1.19 2.79-3.03.26z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 network-locked
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 16v-.5c0-1.38-1.12-2.5-2.5-2.5S17 14.12 17 15.5v.5c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h5c.55 0 1-.45 1-1v-4c0-.55-.45-1-1-1zm-1 0h-3v-.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5v.5zM18 5.83v5.43c.47-.16.97-.26 1.5-.26.17 0 .33.03.5.05V1L1 20h13v-2H5.83L18 5.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 system-update
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M7 19h10V5H7v14zm4-6V8h2v5h3l-4 4-4-4h3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16 13h-3V8h-2v5H8l4 4zm1-11.99L7 1c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM17 19H7V5h10v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-disturb
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-4.42,0-8-3.58-8-8 c0-1.85,0.63-3.55,1.69-4.9L16.9,18.31C15.55,19.37,13.85,20,12,20z M18.31,16.9L7.1,5.69C8.45,4.63,10.15,4,12,4 c4.42,0,8,3.58,8,8C20,13.85,19.37,15.55,18.31,16.9z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 tv-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 19h13.46l-12-12H3zm7.12-12L21 17.88V7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 7v10.88l1.85 1.85c.09-.23.15-.47.15-.73V7c0-1.11-.89-2-2-2h-7.58l3.29-3.3L16 1l-4 4-4-4-.7.7L10.58 5H8.12l2 2H21zm-.54 16l1.26-1.27-1.26 1.26zM2.41 2.13l-.14.14L1 3.54l1.53 1.53C1.65 5.28 1 6.06 1 7v12c0 1.1.9 2 2 2h15.46l1.99 1.99 1.26-1.26.15-.15L2.41 2.13zM3 19V7h1.46l12 12H3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-individual-suite
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1", :opacity ".3", :cy "11", :cx "7", :stroke nil, :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M19 9h-6v6h8v-4c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M7 14c1.66 0 3-1.34 3-3S8.66 8 7 8s-3 1.34-3 3 1.34 3 3 3zm0-4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm12-3h-8v8H3V7H1v10h22v-6c0-2.21-1.79-4-4-4zm2 8h-8V9h6c1.1 0 2 .9 2 2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 time-to-leave
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5.12 11l-.12.34V16h14v-4.66l-.12-.34H5.12zm2.38 4c-.83 0-1.5-.67-1.5-1.5S6.67 12 7.5 12s1.5.67 1.5 1.5S8.33 15 7.5 15zm9 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18.92 5.01C18.72 4.42 18.16 4 17.5 4h-11c-.66 0-1.21.42-1.42 1.01L3 11v8c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1h12v1c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-8l-2.08-5.99zM6.85 6h10.29l1.04 3H5.81l1.04-3zM19 16H5v-4.66l.12-.34h13.77l.11.34V16z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "13.5", :cx "7.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "13.5", :cx "16.5", :stroke nil, :fill nil})))


(helix.core/defnc
 live-tv
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 20h18V8H3v12zm6-10l7 4-7 4v-8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9 10v8l7-4zm12-4h-7.58l3.29-3.29L16 2l-4 4h-.03l-4-4-.69.71L10.56 6H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 14H3V8h18v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wc
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M.01 0h24v24h-24V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.5 22v-7.5H4V9c0-1.1.9-2 2-2h3c1.1 0 2 .9 2 2v5.5H9.5V22h-4zM18 22v-6h3l-2.54-7.63C18.18 7.55 17.42 7 16.56 7h-.12c-.86 0-1.63.55-1.9 1.37L12 16h3v6h3zM7.5 6c1.11 0 2-.89 2-2s-.89-2-2-2-2 .89-2 2 .89 2 2 2zm9 0c1.11 0 2-.89 2-2s-.89-2-2-2-2 .89-2 2 .89 2 2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vpn-lock
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 8h-2v2c0 .55-.45 1-1 1H7v2h6c.55 0 1 .45 1 1v3h1c.9 0 1.64.58 1.9 1.39C18.2 16.97 19 15.08 19 13c0-.34-.04-.67-.08-1H17c-1.65 0-3-1.35-3-3V6c0 1.1-.9 2-2 2zm-4 9v-1l-4.79-4.79C3.08 11.79 3 12.38 3 13c0 4.08 3.05 7.44 7 7.93V19c-1.1 0-2-.9-2-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18.92 12c.04.33.08.66.08 1 0 2.08-.8 3.97-2.1 5.39-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H7v-2h2c.55 0 1-.45 1-1V8h2c1.1 0 2-.9 2-2V3.46c-.95-.3-1.95-.46-3-.46C5.48 3 1 7.48 1 13s4.48 10 10 10 10-4.48 10-10c0-.34-.02-.67-.05-1h-2.03zM10 20.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L8 16v1c0 1.1.9 2 2 2v1.93zM22 4v-.5C22 2.12 20.88 1 19.5 1S17 2.12 17 3.5V4c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h5c.55 0 1-.45 1-1V5c0-.55-.45-1-1-1zm-1 0h-3v-.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5V4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 account-tree
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,11V3h-7v3H9V3H2v8h7V8h2v10h4v3h7v-8h-7v3h-2V8h2v3H22z M7,9H4V5h3V9z M17,15h3v4h-3V15z M17,5h3v4h-3V5z",
     :stroke nil,
     :fill nil})
   (helix.dom/polyline
    {:points "7,5 7,9 4,9 4,5 7,5",
     :opacity ".3",
     :stroke nil,
     :fill nil})
   (helix.dom/polyline
    {:points "20,5 20,9 17,9 17,5 20,5",
     :opacity ".3",
     :stroke nil,
     :fill nil})
   (helix.dom/polyline
    {:points "20,15 20,19 17,19 17,15 20,15",
     :opacity ".3",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 phone-in-talk
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M6.54 5h-1.5c.09 1.32.34 2.58.75 3.79l1.2-1.21c-.24-.83-.39-1.7-.45-2.58zm8.66 13.21c1.21.41 2.48.67 3.8.76v-1.5c-.88-.07-1.75-.22-2.6-.45l-1.2 1.19z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15 12h2c0-2.76-2.24-5-5-5v2c1.66 0 3 1.34 3 3zm4 0h2c0-4.97-4.03-9-9-9v2c3.87 0 7 3.13 7 7zm1 3.5c-1.25 0-2.45-.2-3.57-.57-.1-.03-.21-.05-.31-.05-.26 0-.51.1-.71.29l-2.2 2.2c-2.83-1.44-5.15-3.75-6.59-6.59l2.2-2.21c.28-.26.36-.65.25-1C8.7 6.45 8.5 5.25 8.5 4c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1 0 9.39 7.61 17 17 17 .55 0 1-.45 1-1v-3.5c0-.55-.45-1-1-1zM5.03 5h1.5c.07.88.22 1.75.45 2.58l-1.2 1.21c-.4-1.21-.66-2.47-.75-3.79zM19 18.97c-1.32-.09-2.6-.35-3.8-.76l1.2-1.2c.85.24 1.72.39 2.6.45v1.51z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-chat
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M4,17.17L5.17,16H20V4H4V17.17z M7,7c0-0.55,0.45-1,1-1h6c0.55,0,1,0.45,1,1 v1.99L17,7v6l-2-1.99V13c0,0.55-0.45,1-1,1H8c-0.55,0-1-0.45-1-1V7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2.01,2.9,2.01,4L2,22l4-4h14c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M20,16H5.17L4,17.17V4h16V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,14h6c0.55,0,1-0.45,1-1v-1.99L17,13V7l-2,1.99V7c0-0.55-0.45-1-1-1H8C7.45,6,7,6.45,7,7v6C7,13.55,7.45,14,8,14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 airline-seat-flat-angled
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14 16.64l-4-1.45V17h4zM6 8.5c.15 0 .3-.03.44-.1.49-.24.7-.84.46-1.34-.19-.41-.59-.56-.9-.56-.15 0-.3.03-.44.1-.32.16-.45.42-.5.56-.05.15-.12.44.04.77.2.42.59.57.9.57zm13.16 2.52l-6.69-2.41-.7 1.91 8.59 3.11.01-.02c.19-.51.17-1.05-.06-1.53-.23-.5-.63-.87-1.15-1.06z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M1.5 12.14L8 14.48V19h8v-1.63L20.52 19l.69-1.89-19.02-6.86-.69 1.89zm8.5 3.05l4 1.44V17h-4v-1.81zm9.84-6.05l-8.56-3.09-2.08 5.66 12.36 4.47.69-1.89c.77-2.09-.31-4.39-2.41-5.15zm.53 4.46l-.01.02-8.59-3.11.7-1.91 6.69 2.41c.52.19.93.56 1.15 1.05.23.49.25 1.04.06 1.54zM6 10.5c.44 0 .88-.1 1.3-.3 1.49-.72 2.12-2.51 1.41-4C8.19 5.13 7.12 4.5 6 4.5c-.44 0-.88.1-1.3.3-1.49.71-2.12 2.5-1.4 4 .51 1.07 1.58 1.7 2.7 1.7zm-.94-3.34c.05-.14.18-.4.51-.56.14-.06.28-.1.43-.1.31 0 .7.15.9.56.24.5.02 1.1-.47 1.34-.14.06-.28.1-.43.1-.3 0-.7-.15-.89-.56-.17-.34-.1-.63-.05-.78z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "m21.71 11.29-9-9a.996.996 0 00-1.41 0L8.21 5.38l1.41 1.41L12 4.42 19.58 12l-2.38 2.38 1.41 1.41 3.09-3.09c.4-.37.4-1 .01-1.41z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "13,7.5 13,10.17 15.17,12.34 16.5,11",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "m1.39 4.22 3.99 3.99-3.09 3.09a.996.996 0 000 1.41l9 9c.39.39 1.02.39 1.41 0l3.09-3.09 3.99 3.99 1.41-1.41L2.81 2.81 1.39 4.22zm6.64 6.63c-.01.05-.04.1-.04.15v4h2v-2.18l4.38 4.38L12 19.58 4.42 12 6.8 9.62l1.23 1.23z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 no-encryption-gmailerrorred
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none",
    :d "M0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0z",
    :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M6 20h10.78l-10-10H6zm6.44-10L18 15.56V10z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8.9 6c0-1.71 1.39-3.1 3.1-3.1s3.1 1.39 3.1 3.1v2h-4.66l2 2H18v5.56l2 2V10c0-1.1-.9-2-2-2h-1V6c0-2.76-2.24-5-5-5-2.32 0-4.26 1.59-4.82 3.74L8.9 6.46V6zM4.41 4.81L3 6.22l2.04 2.04C4.42 8.6 4 9.25 4 10v10c0 1.1.9 2 2 2h12.78l1 1 1.41-1.41L4.41 4.81zM6 20V10h.78l10 10H6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wifi-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 11l2-2c-3.73-3.73-8.87-5.15-13.7-4.31l2.58 2.58c3.3-.02 6.61 1.22 9.12 3.73zm-2 2c-1.08-1.08-2.36-1.85-3.72-2.33l3.02 3.02.7-.69zM9 17l3 3 3-3c-1.65-1.66-4.34-1.66-6 0zM3.41 1.64L2 3.05 5.05 6.1C3.59 6.83 2.22 7.79 1 9l2 2c1.23-1.23 2.65-2.16 4.17-2.78l2.24 2.24C7.79 10.89 6.27 11.74 5 13l2 2c1.35-1.35 3.11-2.04 4.89-2.06l7.08 7.08 1.41-1.41L3.41 1.64z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 more
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7.06 5L2.4 12l4.67 7H22V5H7.06c.01 0 .01 0 0 0zM19 10.5c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zm-5 0c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zm-5 0c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M22 3H7c-.69 0-1.23.35-1.59.88L0 12l5.41 8.11c.36.53.97.89 1.66.89H22c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H7.07L2.4 12l4.66-7H22v14z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "12", :cx "9", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "12", :cx "14", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "12", :cx "19", :stroke nil, :fill nil})))


(helix.core/defnc
 mms
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 17.17L5.17 16H20V4H4v13.17zM8.5 9.5l2.5 3.01L14.5 8l4.5 6H5l3.5-4.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.17L4 17.17V4h16v12zm-5.5-8L11 12.51 8.5 9.5 5 14h14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-disturb-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-1.41 0-2.73.37-3.88 1.01l6 5.99H17v2h-.88L19 15.88c.63-1.15 1-2.47 1-3.88 0-4.41-3.59-8-8-8zm0 16c1.56 0 3-.45 4.23-1.23L10.46 13H7v-2h1.46L5.23 7.77C4.45 9 4 10.44 4 12c0 4.41 3.59 8 8 8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 4c4.41 0 8 3.59 8 8 0 1.41-.37 2.73-1.01 3.88l1.46 1.46C21.43 15.79 22 13.96 22 12c0-5.52-4.48-10-10-10-1.96 0-3.79.57-5.33 1.55l1.46 1.46C9.27 4.37 10.59 4 12 4zm5 7h-2.88l2 2H17zM2.41 2.13L1 3.54l2.78 2.78C2.66 7.93 2 9.89 2 12c0 5.52 4.48 10 10 10 2.11 0 4.07-.66 5.68-1.78L20.46 23l1.41-1.41L2.41 2.13zM12 20c-4.41 0-8-3.59-8-8 0-1.56.45-3 1.23-4.23L8.46 11H7v2h3.46l5.77 5.77C15 19.55 13.56 20 12 20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-missed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M18.6 17.22c.66.37 1.28.79 1.88 1.27l1.07-1.07c-.91-.75-1.9-1.39-2.95-1.9v1.7zM3.53 18.5c.58-.47 1.21-.89 1.87-1.27v-1.71c-1.05.51-2.03 1.15-2.95 1.9l1.08 1.08z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M23.71 16.67C20.66 13.78 16.54 12 12 12S3.34 13.78.29 16.67c-.18.18-.29.43-.29.71 0 .28.11.53.29.71l2.48 2.48c.18.18.43.29.71.29.27 0 .52-.11.7-.28.79-.74 1.69-1.36 2.66-1.85.33-.16.56-.5.56-.9v-3.1c1.45-.48 3-.73 4.6-.73s3.15.25 4.6.72v3.1c0 .39.23.74.56.9.98.49 1.87 1.12 2.67 1.85.18.18.43.28.7.28.28 0 .53-.11.71-.29l2.48-2.48c.18-.18.29-.43.29-.71 0-.28-.12-.52-.3-.7zm-18.31.56c-.66.37-1.29.8-1.87 1.27l-1.07-1.07c.91-.75 1.9-1.39 2.95-1.9v1.7zm15.08 1.26c-.6-.48-1.22-.9-1.88-1.27v-1.7c1.05.51 2.03 1.15 2.95 1.9l-1.07 1.07zM7 6.43l4.94 4.94 7.07-7.07-1.41-1.42-5.66 5.66L8.4 5H11V3H5v6h2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 network-check
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.9 5c-.17 0-.32.09-.41.23l-.07.15-5.18 11.65c-.16.29-.26.61-.26.96 0 1.11.9 2.01 2.01 2.01.96 0 1.77-.68 1.96-1.59l.01-.03L16.4 5.5c0-.28-.22-.5-.5-.5zM1 9l2 2c2.88-2.88 6.79-4.08 10.53-3.62l1.19-2.68C9.89 3.84 4.74 5.27 1 9zm20 2l2-2c-1.64-1.64-3.55-2.82-5.59-3.57l-.53 2.82c1.5.62 2.9 1.53 4.12 2.75zm-4 4l2-2c-.8-.8-1.7-1.42-2.66-1.89l-.55 2.92c.42.27.83.59 1.21.97zM5 13l2 2c1.13-1.13 2.56-1.79 4.03-2l1.28-2.88c-2.63-.08-5.3.87-7.31 2.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 adb
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 16c0 3.87 3.13 7 7 7s7-3.13 7-7v-4H5v4zM16.12 4.37l2.1-2.1-.82-.83-2.3 2.31C14.16 3.28 13.12 3 12 3s-2.16.28-3.09.75L6.6 1.44l-.82.83 2.1 2.1C6.14 5.64 5 7.68 5 10v1h14v-1c0-2.32-1.14-4.36-2.88-5.63zM9 9c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm6 0c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ondemand-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 17h18V5H3v12zM9 7l7 4-7 4V7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9 7v8l7-4zm12-4H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v2h8v-2h5c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 14H3V5h18v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-forwarded
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M15.2 18.21c1.21.41 2.48.67 3.8.76v-1.5c-.88-.07-1.75-.22-2.6-.45l-1.2 1.19zM6.54 5h-1.5c.09 1.32.34 2.58.75 3.79l1.2-1.21c-.24-.83-.39-1.7-.45-2.58z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 15.5c-1.25 0-2.45-.2-3.57-.57-.1-.03-.21-.05-.31-.05-.26 0-.51.1-.71.29l-2.2 2.2c-2.83-1.44-5.15-3.75-6.59-6.59l2.2-2.21c.28-.26.36-.65.25-1C8.7 6.45 8.5 5.25 8.5 4c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1 0 9.39 7.61 17 17 17 .55 0 1-.45 1-1v-3.5c0-.55-.45-1-1-1zM5.03 5h1.5c.07.88.22 1.75.45 2.58l-1.2 1.21c-.4-1.21-.66-2.47-.75-3.79zM19 18.97c-1.32-.09-2.6-.35-3.8-.76l1.2-1.2c.85.24 1.72.39 2.6.45v1.51zM18 11l5-5-5-5v3h-4v4h4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-encryption
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none",
    :d "M0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0z",
    :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M6 20h10.78l-10-10H6zm6.44-10L18 15.56V10z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8.9 6c0-1.71 1.39-3.1 3.1-3.1s3.1 1.39 3.1 3.1v2h-4.66l2 2H18v5.56l2 2V10c0-1.1-.9-2-2-2h-1V6c0-2.76-2.24-5-5-5-2.32 0-4.26 1.59-4.82 3.74L8.9 6.46V6zM4.41 4.81L3 6.22l2.04 2.04C4.42 8.6 4 9.25 4 10v10c0 1.1.9 2 2 2h12.78l1 1 1.41-1.41L4.41 4.81zM6 20V10h.78l10 10H6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 event-note
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M5 5h14v2H5z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M19 3h-1V1h-2v2H8V1H6v2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V9h14v10zm0-12H5V5h14v2zM7 11h10v2H7zm0 4h7v2H7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sim-card-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/path
       {:opacity ".3",
        :enable-background "new",
        :d
        "M6,8.83V20h12V4h-7.17L6,8.83z M11,8h2v5h-2V8z M11,15h2v2h-2V15z",
        :stroke nil,
        :fill nil})
      (helix.dom/path
       {:d
        "M18,2h-8L4,8v12c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V4C20,2.9,19.1,2,18,2z M18,20H6V8.83L10.83,4H18V20z",
        :stroke nil,
        :fill nil})
      (helix.dom/rect
       {:y "15",
        :x "11",
        :width "2",
        :height "2",
        :stroke nil,
        :fill nil})
      (helix.dom/rect
       {:y "8",
        :x "11",
        :width "2",
        :height "5",
        :stroke nil,
        :fill nil})))))))


(helix.core/defnc
 do-disturb-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10 10-4.5 10-10S17.5 2 12 2zM4 12c0-4.4 3.6-8 8-8 1.8 0 3.5.6 4.9 1.7L5.7 16.9C4.6 15.5 4 13.8 4 12zm8 8c-1.8 0-3.5-.6-4.9-1.7L18.3 7.1C19.4 8.5 20 10.2 20 12c0 4.4-3.6 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 running-with-errors
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,10v8h-2v-8H22z M20,20v2h2v-2H20z M18,17.29C16.53,18.95,14.39,20,12,20c-4.41,0-8-3.59-8-8c0-4.41,3.59-8,8-8v9 l7.55-7.55C17.72,3.34,15.02,2,12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10c2.25,0,4.33-0.74,6-2V17.29z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-disturb-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,2C6.5,2,2,6.5,2,12s4.5,10,10,10s10-4.5,10-10S17.5,2,12,2z M4,12c0-4.4,3.6-8,8-8c1.8,0,3.5,0.6,4.9,1.7L5.7,16.9 C4.6,15.5,4,13.8,4,12z M12,20c-1.8,0-3.5-0.6-4.9-1.7L18.3,7.1C19.4,8.5,20,10.2,20,12C20,16.4,16.4,20,12,20z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 airline-seat-recline-normal
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.59 5.41c-.78-.78-.78-2.05 0-2.83s2.05-.78 2.83 0 .78 2.05 0 2.83c-.79.79-2.05.79-2.83 0zM6 16V7H4v9c0 2.76 2.24 5 5 5h6v-2H9c-1.66 0-3-1.34-3-3zm14 4.07L14.93 15H11.5v-3.68c1.4 1.15 3.6 2.16 5.5 2.16v-2.16c-1.66.02-3.61-.87-4.67-2.04l-1.4-1.55c-.19-.21-.43-.38-.69-.5-.29-.14-.62-.23-.96-.23h-.03C8.01 7 7 8.01 7 9.25V15c0 1.66 1.34 3 3 3h5.07l3.5 3.5L20 20.07z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-disturb-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:enable-background "new",
     :d
     "M7,13v-2h1.17L5.12,7.94C4.41,9.14,4,10.52,4,12c0,4.41,3.59,8,8,8 c1.48,0,2.86-0.41,4.06-1.12L10.17,13H7z M12,4c-1.48,0-2.86,0.41-4.06,1.12L13.83,11H17v2h-1.17l3.06,3.06 C19.59,14.86,20,13.48,20,12C20,7.59,16.41,4,12,4z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M12,4c4.41,0,8,3.59,8,8c0,1.48-0.41,2.86-1.12,4.06l1.46,1.46C21.39,15.93,22,14.04,22,12c0-5.52-4.48-10-10-10 C9.96,2,8.07,2.61,6.49,3.66l1.46,1.46C9.14,4.41,10.52,4,12,4z M17,13v-2h-3.17l2,2H17z M1.39,4.22l2.27,2.27 C2.61,8.07,2,9.96,2,12c0,5.52,4.48,10,10,10c2.04,0,3.93-0.61,5.51-1.66l2.27,2.27l1.41-1.41L2.81,2.81L1.39,4.22z M5.12,7.94 L8.17,11H7v2h3.17l5.88,5.88C14.86,19.59,13.48,20,12,20c-4.41,0-8-3.59-8-8C4,10.52,4.41,9.14,5.12,7.94z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 airline-seat-flat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5 11c.27 0 .52-.11.71-.3.39-.4.39-1.02-.01-1.41C5.51 9.11 5.26 9 5 9c-.27 0-.52.11-.71.3-.39.4-.39 1.02.01 1.41.19.18.44.29.7.29zm13-2h-7v2h9c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 13c.78 0 1.55-.3 2.14-.9 1.16-1.19 1.14-3.08-.04-4.24C6.51 7.29 5.75 7 5 7c-.78 0-1.55.3-2.14.9-1.16 1.19-1.14 3.08.04 4.24.59.57 1.35.86 2.1.86zm-.71-3.7c.19-.19.44-.3.71-.3.26 0 .51.1.7.28.4.39.4 1.01.02 1.41-.2.2-.45.31-.72.31-.26 0-.51-.1-.7-.28-.4-.4-.4-1.02-.01-1.42zM18 7H9v6h13v-2c0-2.21-1.79-4-4-4zm-7 4V9h7c1.1 0 2 .9 2 2h-9zm-9 5h6v2h8v-2h6v-2H2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sd-card-alert
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M6 8.83V20h12V4h-7.17L6 8.83zM11 8h2v5h-2V8zm0 7h2v2h-2v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18 2h-8L4 8v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 18H6V8.83L10.83 4H18v16zm-7-5h2v2h-2zm0-7h2v5h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 disc-full
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M10 6c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zm0 8c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 14h2v2h-2zM10 4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6zM20 7h2v5h-2zm-10 3c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 imagesearch-roller
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "4",
      :x "8",
      :width "10",
      :opacity ".3",
      :height "2",
      :enable-background "new",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "12",
      :width "2",
      :opacity ".3",
      :height "4",
      :enable-background "new",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,7V3c0-0.55-0.45-1-1-1H7C6.45,2,6,2.45,6,3v1H4C2.9,4,2,4.9,2,6v4c0,1.1,0.9,2,2,2h8v3h-1c-0.55,0-1,0.45-1,1v6 c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-6c0-0.55-0.45-1-1-1h-1v-3c0-1.1-0.9-2-2-2H4V6h2v1c0,0.55,0.45,1,1,1h12 C19.55,8,20,7.55,20,7z M8,4h10v2H8V4z M14,21h-2v-4h2V21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 personal-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M3 5h18v12H3z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.11 0-2 .89-2 2v12c0 1.1.89 2 2 2h5v2h8v-2h5c1.1 0 1.99-.9 1.99-2L23 5c0-1.11-.9-2-2-2zm0 14H3V5h18v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-bluetooth-speaker
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M15.2 18.21c1.21.41 2.48.67 3.8.76v-1.5c-.88-.07-1.75-.22-2.6-.45l-1.2 1.19zM6.54 5h-1.5c.09 1.32.34 2.58.75 3.79l1.2-1.21c-.24-.83-.39-1.7-.45-2.58z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 15.5c-1.25 0-2.45-.2-3.57-.57-.1-.03-.21-.05-.31-.05-.26 0-.51.1-.71.29l-2.2 2.2c-2.83-1.44-5.15-3.75-6.59-6.59l2.2-2.21c.28-.26.36-.65.25-1C8.7 6.45 8.5 5.25 8.5 4c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1 0 9.39 7.61 17 17 17 .55 0 1-.45 1-1v-3.5c0-.55-.45-1-1-1zM5.03 5h1.5c.07.88.22 1.75.45 2.58l-1.2 1.21c-.4-1.21-.66-2.47-.75-3.79zM19 18.97c-1.32-.09-2.6-.35-3.8-.76l1.2-1.2c.85.24 1.72.39 2.6.45v1.51zM14.71 9.5L17 7.21V11h.5l2.85-2.85L18.21 6l2.15-2.15L17.5 1H17v3.79L14.71 2.5l-.71.71L16.79 6 14 8.79l.71.71zM18 2.91l.94.94-.94.94V2.91zm0 4.3l.94.94-.94.94V7.21z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-legroom-extra
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 12V3H2v9c0 2.76 2.24 5 5 5h6v-2H7c-1.66 0-3-1.34-3-3zm18.83 5.24c-.38-.72-1.29-.97-2.03-.63l-1.09.5-3.41-6.98C15.96 9.45 15.27 9 14.51 9H11V3H5v8c0 1.66 1.34 3 3 3h7l3.41 7 3.72-1.7c.77-.36 1.1-1.3.7-2.06z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M.01 0h24v24h-24V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.01 4V1l-4 4 4 4V6c3.31 0 6 2.69 6 6 0 1.01-.25 1.97-.7 2.8l1.46 1.46c.78-1.23 1.24-2.69 1.24-4.26 0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-1.01.25-1.97.7-2.8L5.25 7.74C4.47 8.97 4.01 10.43 4.01 12c0 4.42 3.58 8 8 8v3l4-4-4-4v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 event-busy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M5 5h14v2H5z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M19 3h-1V1h-2v2H8V1H6v2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V9h14v10zm0-12H5V5h14v2zM9.29 17.47l2.44-2.44 2.44 2.44 1.06-1.06-2.44-2.44 2.44-2.44-1.06-1.06-2.44 2.44-2.44-2.44-1.06 1.06 2.44 2.44-2.44 2.44z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 event-available
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M5 5h14v2H5z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M19 3h-1V1h-2v2H8V1H6v2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V9h14v10zm0-12H5V5h14v2zm-2.51 4.53l-1.06-1.06-4.87 4.87-2.11-2.11-1.06 1.06 3.17 3.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 support-agent
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,12.22C21,6.73,16.74,3,12,3c-4.69,0-9,3.65-9,9.28C2.4,12.62,2,13.26,2,14v2c0,1.1,0.9,2,2,2h1v-6.1 c0-3.87,3.13-7,7-7s7,3.13,7,7V19h-8v2h8c1.1,0,2-0.9,2-2v-1.22c0.59-0.31,1-0.92,1-1.64v-2.3C22,13.14,21.59,12.53,21,12.22z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M18,11.03C17.52,8.18,15.04,6,12.05,6c-3.03,0-6.29,2.51-6.03,6.45c2.47-1.01,4.33-3.21,4.86-5.89 C12.19,9.19,14.88,11,18,11.03z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 bluetooth-audio
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.24 12.01l2.32 2.32c.28-.72.44-1.51.44-2.33s-.16-1.59-.43-2.31l-2.33 2.32zm5.29-5.3l-1.26 1.26c.63 1.21.98 2.57.98 4.02s-.36 2.82-.98 4.02l1.2 1.2c.97-1.54 1.54-3.36 1.54-5.31-.01-1.89-.55-3.67-1.48-5.19zm-3.82 1L10 2H9v7.59L4.41 5 3 6.41 8.59 12 3 17.59 4.41 19 9 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM11 5.83l1.88 1.88L11 9.59V5.83zm1.88 10.46L11 18.17v-3.76l1.88 1.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 confirmation-number
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4.01 8.54C5.2 9.23 6 10.52 6 12s-.81 2.77-2 3.46V18h16v-2.54c-1.19-.69-2-1.99-2-3.46s.81-2.77 2-3.46V6H4l.01 2.54zM11 7h2v2h-2V7zm0 4h2v2h-2v-2zm0 4h2v2h-2v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M22 10V6c0-1.11-.9-2-2-2H4c-1.1 0-1.99.89-1.99 2v4c1.1 0 1.99.9 1.99 2s-.89 2-2 2v4c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-4c-1.1 0-2-.9-2-2s.9-2 2-2zm-2-1.46c-1.19.69-2 1.99-2 3.46s.81 2.77 2 3.46V18H4v-2.54c1.19-.69 2-1.99 2-3.46 0-1.48-.8-2.77-1.99-3.46L4 6h16v2.54zM11 15h2v2h-2zm0-4h2v2h-2zm0-4h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync-disabled
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 6.35V4.26c-.66.17-1.29.43-1.88.75l1.5 1.5c.13-.05.25-.11.38-.16zM20 12c0-2.21-.91-4.2-2.36-5.64L20 4h-6v6l2.24-2.24C17.32 8.85 18 10.34 18 12c0 .85-.19 1.65-.51 2.38l1.5 1.5C19.63 14.74 20 13.41 20 12zM4.27 4L2.86 5.41l2.36 2.36C4.45 8.99 4 10.44 4 12c0 2.21.91 4.2 2.36 5.64L4 20h6v-6l-2.24 2.24C6.68 15.15 6 13.66 6 12c0-1 .25-1.94.68-2.77l8.08 8.08c-.25.13-.5.24-.76.34v2.09c.8-.21 1.55-.54 2.23-.96l2.58 2.58 1.41-1.41L4.27 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync-lock
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10,4.26v2.09C7.67,7.18,6,9.39,6,12c0,1.77,0.78,3.34,2,4.44V14h2v6H4v-2h2.73C5.06,16.54,4,14.4,4,12 C4,8.27,6.55,5.15,10,4.26z M20,4h-6v6h2V7.56c1.22,1.1,2,2.67,2,4.44h2c0-2.4-1.06-4.54-2.73-6H20V4z M20,17v-1c0-1.1-0.9-2-2-2 s-2,0.9-2,2v1c-0.55,0-1,0.45-1,1v3c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-3C21,17.45,20.55,17,20,17z M19,17h-2v-1 c0-0.55,0.45-1,1-1s1,0.45,1,1V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 drive-eta
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5.12 11l-.12.34V16h14v-4.66l-.12-.34H5.12zm2.38 4c-.83 0-1.5-.67-1.5-1.5S6.67 12 7.5 12s1.5.67 1.5 1.5S8.33 15 7.5 15zm9 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18.92 5.01C18.72 4.42 18.16 4 17.5 4h-11c-.66 0-1.21.42-1.42 1.01L3 11v8c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1h12v1c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-8l-2.08-5.99zM6.85 6h10.29l1.04 3H5.81l1.04-3zM19 16H5v-4.66l.12-.34h13.77l.11.34V16z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "13.5", :cx "7.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "13.5", :cx "16.5", :stroke nil, :fill nil})))


(helix.core/defnc
 priority-high
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "2", :cy "19", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path {:d "M10 3h4v12h-4z", :stroke nil, :fill nil})))


(helix.core/defnc
 error-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm-1-5h2v2h-2zm0-8h2v6h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-alert
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 6c-2.76 0-5 2.24-5 5v7h10v-7c0-2.76-2.24-5-5-5zm4 7h-3v3h-2v-3H8v-2h3V8h2v3h3v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 23c1.1 0 1.99-.89 1.99-1.99h-3.98c0 1.1.89 1.99 1.99 1.99zm7-6v-6c0-3.35-2.36-6.15-5.5-6.83V3c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v1.17C7.36 4.85 5 7.65 5 11v6l-2 2v1h18v-1l-2-2zm-2 1H7v-7c0-2.76 2.24-5 5-5s5 2.24 5 5v7zm-4-7V8h-2v3H8v2h3v3h2v-3h3v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 notification-important
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 6c-2.76 0-5 2.24-5 5v7h10v-7c0-2.76-2.24-5-5-5zm1 10h-2v-2h2v2zm0-4h-2V8h2v4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 23c1.1 0 1.99-.89 1.99-1.99h-3.98c0 1.1.89 1.99 1.99 1.99zm7-6v-6c0-3.35-2.36-6.15-5.5-6.83V3c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v1.17C7.36 4.85 5 7.65 5 11v6l-2 2v1h18v-1l-2-2zm-2 1H7v-7c0-2.76 2.24-5 5-5s5 2.24 5 5v7zM11 8h2v4h-2zm0 6h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 warning-amber
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M1 21h22L12 2 1 21zm3.47-2L12 5.99 19.53 19H4.47zM11 16h2v2h-2zm0-6h2v4h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 warning
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4.47 19h15.06L12 5.99 4.47 19zM13 18h-2v-2h2v2zm0-4h-2v-4h2v4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M1 21h22L12 2 1 21zm3.47-2L12 5.99 19.53 19H4.47zM11 16h2v2h-2zm0-6h2v4h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-delete
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,7H4v10h5.08C9.03,16.67,9,16.34,9,16c0-2.38,1.19-4.47,3-5.74V7z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "15,2 11.5,2 10.5,1 5.5,1 4.5,2 1,2 1,4 15,4",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,9c-0.7,0-1.37,0.1-2,0.29V5H2v12c0,1.1,0.9,2,2,2h5.68c1.12,2.36,3.53,4,6.32,4c3.87,0,7-3.13,7-7 C23,12.13,19.87,9,16,9z M9,16c0,0.34,0.03,0.67,0.08,1H4V7h8v3.26C10.19,11.53,9,13.62,9,16z M16,21c-2.76,0-5-2.24-5-5 s2.24-5,5-5s5,2.24,5,5S18.76,21,16,21z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "16.5,12 15,12 15,17 18.6,19.1 19.4,17.9 16.5,16.2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 error
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8-3.58-8-8-8zm1 13h-2v-2h2v2zm0-4h-2V7h2v6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm-1-5h2v2h-2zm0-8h2v6h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 child-care
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 10c-.1 0-.19.02-.29.03-.2-.67-.49-1.29-.86-1.86C16.6 6.26 14.45 5 12 5S7.4 6.26 6.15 8.17c-.37.57-.66 1.19-.86 1.86-.1-.01-.19-.03-.29-.03-1.1 0-2 .9-2 2s.9 2 2 2c.1 0 .19-.02.29-.03.2.67.49 1.29.86 1.86C7.4 17.74 9.55 19 12 19s4.6-1.26 5.85-3.17c.37-.57.66-1.19.86-1.86.1.01.19.03.29.03 1.1 0 2-.9 2-2s-.9-2-2-2zm-4.5-.75c.69 0 1.25.56 1.25 1.25s-.56 1.25-1.25 1.25-1.25-.56-1.25-1.25.56-1.25 1.25-1.25zm-5 0c.69 0 1.25.56 1.25 1.25s-.56 1.25-1.25 1.25-1.25-.56-1.25-1.25.56-1.25 1.25-1.25zM12 17c-2.01 0-3.74-1.23-4.5-3h9c-.76 1.77-2.49 3-4.5 3z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.25", :cy "10.5", :cx "14.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.25", :cy "10.5", :cx "9.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 17c2.01 0 3.74-1.23 4.5-3h-9c.76 1.77 2.49 3 4.5 3zm10.94-5.66c-.25-1.51-1.36-2.74-2.81-3.17-.53-1.12-1.28-2.1-2.19-2.91C16.36 3.85 14.28 3 12 3s-4.36.85-5.94 2.26c-.92.81-1.67 1.8-2.19 2.91-1.45.43-2.56 1.65-2.81 3.17-.04.21-.06.43-.06.66 0 .23.02.45.06.66.25 1.51 1.36 2.74 2.81 3.17.52 1.11 1.27 2.09 2.17 2.89C7.62 20.14 9.71 21 12 21s4.38-.86 5.97-2.28c.9-.8 1.65-1.79 2.17-2.89 1.44-.43 2.55-1.65 2.8-3.17.04-.21.06-.43.06-.66 0-.23-.02-.45-.06-.66zM19 14c-.1 0-.19-.02-.29-.03-.2.67-.49 1.29-.86 1.86C16.6 17.74 14.45 19 12 19s-4.6-1.26-5.85-3.17c-.37-.57-.66-1.19-.86-1.86-.1.01-.19.03-.29.03-1.1 0-2-.9-2-2s.9-2 2-2c.1 0 .19.02.29.03.2-.67.49-1.29.86-1.86C7.4 6.26 9.55 5 12 5s4.6 1.26 5.85 3.17c.37.57.66 1.19.86 1.86.1-.01.19-.03.29-.03 1.1 0 2 .9 2 2s-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 microwave
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4,18h10V6H4V18z M7.75,8c0.8,0,1.39,0.39,1.81,0.67C9.87,8.88,10.07,9,10.25,9c0.37,0,0.8-0.41,0.95-0.61 l1.42,1.42c-0.36,0.4-1.22,1.19-2.37,1.19c-0.79,0-1.37-0.38-1.79-0.66C8.13,10.12,7.94,10,7.75,10c-0.37,0-0.8,0.41-0.95,0.61 L5.37,9.19C5.73,8.79,6.59,8,7.75,8z M7.75,13c0.8,0,1.39,0.39,1.81,0.67C9.87,13.88,10.07,14,10.25,14c0.37,0,0.8-0.41,0.95-0.61 l1.42,1.42c-0.36,0.4-1.22,1.19-2.37,1.19c-0.79,0-1.37-0.38-1.79-0.66C8.13,15.12,7.94,15,7.75,15c-0.37,0-0.8,0.41-0.95,0.61 l-1.42-1.42C5.73,13.79,6.59,13,7.75,13z M16,6v12h4V6H16z M18,17c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1c0.55,0,1,0.45,1,1 C19,16.55,18.55,17,18,17z M18,13c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1c0.55,0,1,0.45,1,1C19,12.55,18.55,13,18,13z M19,9h-2V7h2V9 z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20,4H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V6C22,4.9,21.1,4,20,4z M4,6h10v12H4V6z M20,18h-4V6h4V18z M19,9h-2V7h2V9z M18,13L18,13c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v0C19,12.55,18.55,13,18,13z M18,17 L18,17c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v0C19,16.55,18.55,17,18,17z M10.25,16 c-0.79,0-1.37-0.38-1.79-0.66C8.13,15.12,7.94,15,7.75,15c-0.37,0-0.8,0.41-0.95,0.61l-1.42-1.42C5.73,13.79,6.59,13,7.75,13 c0.8,0,1.39,0.39,1.81,0.67C9.87,13.88,10.07,14,10.25,14c0.37,0,0.8-0.41,0.95-0.61l1.42,1.42C12.26,15.21,11.41,16,10.25,16z M10.25,11c-0.79,0-1.37-0.38-1.79-0.66C8.13,10.12,7.94,10,7.75,10c-0.37,0-0.8,0.41-0.95,0.61L5.37,9.19C5.73,8.79,6.59,8,7.75,8 c0.8,0,1.39,0.39,1.81,0.67C9.87,8.88,10.07,9,10.25,9c0.37,0,0.8-0.41,0.95-0.61l1.42,1.42C12.26,10.21,11.41,11,10.25,11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 meeting-room
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M7 19h6V5H7v14zm3-8h2v2h-2v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 19V4h-4V3H5v16H3v2h12V6h2v15h4v-2h-2zm-6 0H7V5h6v14zm-3-8h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cottage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/polygon
   {:points
    "18,19 13,19 13,15 11,15 11,19 6,19 6,10.1 12,5.52 18,10.1",
    :opacity ".3",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,3L6,7.58V6H4v3.11L1,11.4l1.21,1.59L4,11.62V21h16v-9.38l1.79,1.36L23,11.4L12,3z M18,19h-5v-4h-2v4H6v-8.9l6-4.58 l6,4.58V19z M10,1c0,1.66-1.34,3-3,3C6.45,4,6,4.45,6,5H4c0-1.66,1.34-3,3-3c0.55,0,1-0.45,1-1H10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 beach-access
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7.6 7.6c-.47 2.34.03 4.78 1.39 6.83l5.45-5.45c-1.53-1.02-3.28-1.56-5.08-1.56-.6 0-1.19.06-1.76.18zM13.12 5c-.93 0-1.82.16-2.67.46 1.91.19 3.79.89 5.44 2.07l1.39-1.39C16.03 5.4 14.61 5 13.12 5zM5 13.12c0 1.49.4 2.91 1.14 4.15l1.39-1.39c-1.18-1.65-1.88-3.52-2.07-5.44-.3.86-.46 1.76-.46 2.68z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M13.126 14.56l1.428-1.428 6.442 6.442-1.43 1.428zM13.12 3c-2.58 0-5.16.98-7.14 2.95l-.01.01c-3.95 3.95-3.95 10.36 0 14.31l14.3-14.31C18.3 3.99 15.71 3 13.12 3zM6.14 17.27C5.4 16.03 5 14.61 5 13.12c0-.93.16-1.82.46-2.67.19 1.91.89 3.79 2.07 5.44l-1.39 1.38zm2.84-2.84C7.63 12.38 7.12 9.93 7.6 7.6c.58-.12 1.16-.18 1.75-.18 1.8 0 3.55.55 5.08 1.56l-5.45 5.45zm1.47-8.97c.85-.3 1.74-.46 2.67-.46 1.49 0 2.91.4 4.15 1.14l-1.39 1.39c-1.65-1.18-3.52-1.88-5.43-2.07z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dry
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M10,21H4c-0.55,0-1-0.45-1-1v-6c0-0.39,0.23-0.64,0.36-0.75L7,9.87V12l3,0V21z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M20.75,16c0.69,0,1.25-0.56,1.25-1.25s-0.56-1.25-1.25-1.25H12v-1h6.75c0.69,0,1.25-0.56,1.25-1.25 c0-0.67-0.53-1.2-1.18-1.24L8.87,10l1.48-2.6c0.09-0.17,0.14-0.34,0.14-0.54c0-0.26-0.09-0.5-0.26-0.7L9.12,5l-7.18,6.8 C1.34,12.36,1,13.15,1,13.97V20c0,1.66,1.34,3,3,3h13.75c0.69,0,1.25-0.56,1.25-1.25s-0.56-1.25-1.25-1.25H12v-1h7.75 c0.69,0,1.25-0.56,1.25-1.25S20.44,17,19.75,17H12v-1H20.75z M10,21H4c-0.55,0-1-0.45-1-1v-6c0-0.39,0.23-0.64,0.36-0.75L7,9.87V12 l3,0V21z M15.65,4.86l-0.07-0.07c-0.57-0.62-0.82-1.41-0.67-2.2L15,2h-1.89l-0.06,0.43c-0.2,1.36,0.27,2.71,1.3,3.72l0.07,0.06 c0.57,0.62,0.82,1.41,0.67,2.2L14.98,9h1.91l0.06-0.43C17.16,7.21,16.68,5.86,15.65,4.86z M19.65,4.86l-0.07-0.07 c-0.57-0.62-0.82-1.41-0.67-2.2L19,2h-1.89l-0.06,0.43c-0.2,1.36,0.27,2.71,1.3,3.72l0.07,0.06c0.57,0.62,0.82,1.41,0.67,2.2 L18.98,9h1.91l0.06-0.43C21.16,7.21,20.68,5.86,19.65,4.86z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 water-damage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,5.69l-5,4.5V18h10v-7.81L12,5.69z M12,16c-1.1,0-2-0.9-2-2c0-1.1,2-4,2-4s2,2.9,2,4 C14,15.1,13.1,16,12,16z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,3L2,12h3v8h14v-8h3L12,3z M7,18v-7.81l5-4.5l5,4.5V18H7z M14,14c0,1.1-0.9,2-2,2s-2-0.9-2-2c0-1.1,2-4,2-4 S14,12.9,14,14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fire-extinguisher
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M7,19h10v1c0,1.1-0.9,2-2,2H9c-1.1,0-2-0.9-2-2V19z M7,18h10v-5H7V18z M17,3v6l-3.15-0.66c-0.01,0-0.01,0.01-0.02,0.02 c1.55,0.62,2.72,1.98,3.07,3.64H7.1c0.34-1.66,1.52-3.02,3.07-3.64c-0.33-0.26-0.6-0.58-0.8-0.95L5,6.5v-1l4.37-0.91 C9.87,3.65,10.86,3,12,3c0.7,0,1.34,0.25,1.85,0.66L17,3z M13,6c-0.03-0.59-0.45-1-1-1s-1,0.45-1,1s0.45,1,1,1S13,6.55,13,6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 vape-free
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/circle
    {:r ".5",
     :opacity ".3",
     :cy "17.5",
     :cx "10.5",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M2,16.5h1c1.33,0,2.71-0.18,4-0.5v3c-1.29-0.32-2.67-0.5-4-0.5H2V16.5z M16.17,19H8v-3h5.17L1.39,4.22l1.41-1.41 l18.38,18.38l-1.41,1.41L16.17,19z M18.83,16H22v3h-0.17L18.83,16z M11,17.5c0-0.28-0.22-0.5-0.5-0.5S10,17.22,10,17.5 c0,0.28,0.22,0.5,0.5,0.5S11,17.78,11,17.5z M22,12.76V15h-1.5v-2.23c0-2.24-1.76-4.07-4-4.07V7.2c1.02,0,1.85-0.83,1.85-1.85 S17.52,3.5,16.5,3.5V2c1.85,0,3.35,1.5,3.35,3.35c0,0.93-0.38,1.77-1,2.38C20.72,8.62,22,10.54,22,12.76z M11.15,8.32 c0-0.01,0-0.01,0-0.02c0-1.85,1.5-3.35,3.35-3.35v1.5c-1.02,0-1.85,0.73-1.85,1.75s0.83,2,1.85,2h1.53c1.87,0,3.47,1.35,3.47,3.16 V15H18v-1.3c0-1.31-0.92-2.05-1.97-2.05H14.5c-0.01,0-0.01,0-0.02,0L11.15,8.32z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 rv-hookup
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M20 17v-6c0-1.1-.9-2-2-2H7V7l-3 3 3 3v-2h4v3H4v3c0 1.1.9 2 2 2h2c0 1.66 1.34 3 3 3s3-1.34 3-3h8v-2h-2zm-9 3c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm7-6h-4v-3h4v3zM17 2v2H9v2h8v2l3-3-3-3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 17v-6c0-1.1-.9-2-2-2H7V7l-3 3 3 3v-2h4v3H4v3c0 1.1.9 2 2 2h2c0 1.66 1.34 3 3 3s3-1.34 3-3h8v-2h-2zm-9 3c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm7-6h-4v-3h4v3zM17 2v2H9v2h8v2l3-3-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 balcony
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7,16H5v4h2V16z M11,16H9v4h2V16z M6,10v4h5V4.08C8.16,4.56,6,7.03,6,10z M10,12H8v-2h2V12z M13,4.08V14h5v-4 C18,7.03,15.84,4.56,13,4.08z M16,12h-2v-2h2V12z M15,16h-2v4h2V16z M19,16h-2v4h2V16z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M10,10v2H8v-2H10z M16,12v-2h-2v2H16z M21,14v8H3v-8h1v-4c0-4.42,3.58-8,8-8s8,3.58,8,8v4H21z M7,16H5v4h2V16z M11,16H9v4h2 V16z M11,4.08C8.16,4.56,6,7.03,6,10v4h5V4.08z M13,14h5v-4c0-2.97-2.16-5.44-5-5.92V14z M15,16h-2v4h2V16z M19,16h-2v4h2V16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tty
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M4.13,5C4.3,6.37,4.66,7.71,5.18,8.99l1.65-1.65L6.36,5H4.13z M15.66,16.17l-1.65,1.65 c1.28,0.52,2.63,0.87,3.99,1.05v-2.23L15.66,16.17z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M19.2,14.84l-3.67-0.73c-0.33-0.07-0.67,0.04-0.9,0.27L12.1,16.9c-2.5-1.43-4.57-3.5-6-6l2.52-2.52 C8.86,8.14,8.96,7.8,8.9,7.48L8.16,3.8C8.07,3.34,7.66,3,7.18,3H3.03C2.47,3,2,3.47,2.03,4.03C2.2,6.92,3.05,9.63,4.43,12 c1.58,2.73,3.85,4.99,6.57,6.57c2.37,1.37,5.08,2.23,7.97,2.4c0.56,0.03,1.03-0.44,1.03-1v-4.15C20,15.34,19.66,14.93,19.2,14.84z M4.13,5h2.23l0.47,2.34L5.18,8.99C4.66,7.71,4.3,6.37,4.13,5z M18,18.87c-1.37-0.17-2.71-0.53-3.99-1.05l1.65-1.65L18,16.64V18.87 z M14,4h2v2h-2V4z M13,7h2v2h-2V7z M11,4h2v2h-2V4z M18,9h-2V7h2V9z M19,6h-2V4h2V6z M21,9h-2V7h2V9z M22,6h-2V4h2V6z M14,10h2v2 h-2V10z M11,10h2v2h-2V10z M19,12h-2v-2h2V12z M22,12h-2v-2h2V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 room-service
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 9.58c-2.95 0-5.47 1.83-6.5 4.41h13c-1.03-2.58-3.55-4.41-6.5-4.41z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M2 17h20v2H2zm11.84-9.21c.1-.24.16-.51.16-.79 0-1.1-.9-2-2-2s-2 .9-2 2c0 .28.06.55.16.79C6.25 8.6 3.27 11.93 3 16h18c-.27-4.07-3.25-7.4-7.16-8.21zM12 9.58c2.95 0 5.47 1.83 6.5 4.41h-13c1.03-2.58 3.55-4.41 6.5-4.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-touch
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M18,15.17V13h-2.17L18,15.17z M9,11.83l8.14,8.14C17.09,19.98,17.05,20,17,20h-6 c-0.39,0-0.64-0.23-0.75-0.36L6.87,16H9L9,11.83z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M2.81,2.81L1.39,4.22L7,9.83l0,4.3l-2.6-1.48c-0.17-0.09-0.34-0.14-0.54-0.14c-0.26,0-0.5,0.09-0.7,0.26L2,13.88l6.8,7.18 c0.57,0.6,1.35,0.94,2.18,0.94H17c0.62,0,1.18-0.19,1.66-0.52l1.12,1.12l1.41-1.41L2.81,2.81z M17,20h-6 c-0.39,0-0.64-0.23-0.75-0.36L6.87,16H9l0-4.17l8.14,8.14C17.09,19.98,17.05,20,17,20z M13.83,11H14V3.25C14,2.56,14.56,2,15.25,2 s1.25,0.56,1.25,1.25V11h1V5.25C17.5,4.56,18.06,4,18.75,4S20,4.56,20,5.25v11.92l-2-2V13h-2.17L13.83,11z M13,10.17V2.25 C13,1.56,12.44,1,11.75,1S10.5,1.56,10.5,2.25v5.42L13,10.17z M9.5,6.67V4.25C9.5,3.56,8.94,3,8.25,3c-0.67,0-1.2,0.53-1.24,1.18v0 L9.5,6.67z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 storefront
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M6.44,9.86L7.02,5H5.05L4.04,9.36c-0.1,0.42-0.01,0.84,0.25,1.17C4.43,10.71,4.73,11,5.23,11 C5.84,11,6.36,10.51,6.44,9.86z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M9.71,11C10.45,11,11,10.41,11,9.69V5H9.04L8.49,9.52c-0.05,0.39,0.07,0.78,0.33,1.07 C9.05,10.85,9.37,11,9.71,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M14.22,11c0.41,0,0.72-0.15,0.96-0.41c0.25-0.29,0.37-0.68,0.33-1.07L14.96,5H13v4.69 C13,10.41,13.55,11,14.22,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M18.91,4.99L16.98,5l0.58,4.86c0.08,0.65,0.6,1.14,1.21,1.14c0.49,0,0.8-0.29,0.93-0.47 c0.26-0.33,0.35-0.76,0.25-1.17L18.91,4.99z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.9,8.89l-1.05-4.37c-0.22-0.9-1-1.52-1.91-1.52H5.05C4.15,3,3.36,3.63,3.15,4.52L2.1,8.89 c-0.24,1.02-0.02,2.06,0.62,2.88C2.8,11.88,2.91,11.96,3,12.06V19c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2v-6.94 c0.09-0.09,0.2-0.18,0.28-0.28C21.92,10.96,22.15,9.91,21.9,8.89z M13,5h1.96l0.54,4.52c0.05,0.39-0.07,0.78-0.33,1.07 C14.95,10.85,14.63,11,14.22,11C13.55,11,13,10.41,13,9.69V5z M8.49,9.52L9.04,5H11v4.69C11,10.41,10.45,11,9.71,11 c-0.34,0-0.65-0.15-0.89-0.41C8.57,10.3,8.45,9.91,8.49,9.52z M4.29,10.53c-0.26-0.33-0.35-0.76-0.25-1.17L5.05,5h1.97L6.44,9.86 C6.36,10.51,5.84,11,5.23,11C4.73,11,4.43,10.71,4.29,10.53z M19,19H5v-6.03C5.08,12.98,5.15,13,5.23,13 c0.87,0,1.66-0.36,2.24-0.95c0.6,0.6,1.4,0.95,2.31,0.95c0.87,0,1.65-0.36,2.23-0.93c0.59,0.57,1.39,0.93,2.29,0.93 c0.84,0,1.64-0.35,2.24-0.95c0.58,0.59,1.37,0.95,2.24,0.95c0.08,0,0.15-0.02,0.23-0.03V19z M19.71,10.53 C19.57,10.71,19.27,11,18.77,11c-0.61,0-1.14-0.49-1.21-1.14L16.98,5l1.93-0.01l1.05,4.37C20.06,9.78,19.97,10.21,19.71,10.53z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 escalator
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M19,5L19,5l0,14H5V5H19 M17,6h-3.3l-5,9H7c-0.83,0-1.5,0.67-1.5,1.5S6.17,18,7,18h3.3l5-9H17 c0.83,0,1.5-0.67,1.5-1.5S17.83,6,17,6z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M19,5L19,5l0,14H5V5H19 M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2l0-14C21,3.9,20.1,3,19,3L19,3z M17,6h-3.3l-5,9H7c-0.83,0-1.5,0.67-1.5,1.5S6.17,18,7,18h3.3l5-9H17c0.83,0,1.5-0.67,1.5-1.5S17.83,6,17,6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 smoking-rooms
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M2 16h15v3H2v-3zm18.5 0H22v3h-1.5v-3zM18 16h1.5v3H18v-3zm.85-8.27c.62-.61 1-1.45 1-2.38C19.85 3.5 18.35 2 16.5 2v1.5c1.02 0 1.85.83 1.85 1.85S17.52 7.2 16.5 7.2v1.5c2.24 0 4 1.83 4 4.07V15H22v-2.24c0-2.22-1.28-4.14-3.15-5.03zm-2.82 2.47H14.5c-1.02 0-1.85-.98-1.85-2s.83-1.75 1.85-1.75v-1.5c-1.85 0-3.35 1.5-3.35 3.35s1.5 3.35 3.35 3.35h1.53c1.05 0 1.97.74 1.97 2.05V15h1.5v-1.64c0-1.81-1.6-3.16-3.47-3.16z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M2 16h15v3H2v-3zm18.5 0H22v3h-1.5v-3zM18 16h1.5v3H18v-3zm.85-8.27c.62-.61 1-1.45 1-2.38C19.85 3.5 18.35 2 16.5 2v1.5c1.02 0 1.85.83 1.85 1.85S17.52 7.2 16.5 7.2v1.5c2.24 0 4 1.83 4 4.07V15H22v-2.24c0-2.22-1.28-4.14-3.15-5.03zm-2.82 2.47H14.5c-1.02 0-1.85-.98-1.85-2s.83-1.75 1.85-1.75v-1.5c-1.85 0-3.35 1.5-3.35 3.35s1.5 3.35 3.35 3.35h1.53c1.05 0 1.97.74 1.97 2.05V15h1.5v-1.64c0-1.81-1.6-3.16-3.47-3.16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 countertops
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M6,6h2v2H6V6z M6,18v-6h5v6H6z M18,18h-5v-6h5V18z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M22,10h-4V7c0-1.66-1.34-3-3-3c-1.66,0-3,1.34-3,3h2c0-0.55,0.45-1,1-1c0.55,0,1,0.45,1,1v3H8c1.1,0,2-0.9,2-2V4H4v4 c0,1.1,0.9,2,2,2H2v2h2v8h16v-8h2V10z M6,6h2v2H6V6z M6,18v-6h5v6H6z M18,18h-5v-6h5V18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 desk
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "8",
      :x "16",
      :width "4",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "16",
      :width "4",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2,6v12h2V8h10v10h2v-2h4v2h2V6H2z M20,14h-4v-2h4V14z M20,10h-4V8h4V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 stroller
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M10,5c0.29,0,0.58,0.02,0.86,0.05L9.49,6.66l-1.4-1.4C8.71,5.09,9.35,5,10,5 M15,8.66V15H9.6L15,8.66",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M10,5c0.29,0,0.58,0.02,0.86,0.05L9.49,6.66l-1.4-1.4C8.71,5.09,9.35,5,10,5 M15,8.66V15H9.6L15,8.66 M18.65,3 c-1.66,0-2.54,1.27-3.18,2.03l-8.8,10.32C6.12,16,6.58,17,7.43,17H15c1.1,0,2-0.9,2-2V6.27C17.58,5.59,17.97,5,18.65,5 C19.42,5,20,5.66,20,6.48V7h2V6.48C22,4.56,20.52,3,18.65,3L18.65,3z M10,3C8.03,3,6.21,3.64,4.72,4.72l4.89,4.89l4.7-5.51 C13.03,3.4,11.56,3,10,3L10,3z M16,18c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S17.1,18,16,18L16,18z M6,18c-1.1,0-2,0.9-2,2 s0.9,2,2,2s2-0.9,2-2S7.1,18,6,18L6,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sports-bar
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M15,19H8l0-6.63c1.26-0.34,2.11-1.27,2.77-1.99C11.6,9.47,12.08,9,13,9l2,0V19z M7,10.5c-1.1,0-2-0.9-2-2 c0-0.85,0.55-1.6,1.37-1.88l0.8-0.27l0.36-0.76C8,4.62,8.94,4.02,10,4.02c0.79,0,1.39,0.35,1.74,0.65l0.78,0.65 c0,0,0.64-0.32,1.47-0.32c1.1,0,2,0.9,2,2c0,0-3,0-3,0C9.67,7,9.15,10.5,7,10.5C7,10.5,7,10.5,7,10.5L7,10.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15,19H8l0-6.63c1.26-0.34,2.11-1.27,2.77-1.99C11.6,9.47,12.08,9,13,9l2,0V19z M10,2.02c-1.89,0-3.51,1.11-4.27,2.71 C4.15,5.26,3,6.74,3,8.5c0,1.86,1.28,3.41,3,3.86L6,21h11v-2h2c1.1,0,2-0.9,2-2v-6c0-1.1-0.9-2-2-2h-1.56C17.79,8.41,18,7.73,18,7 c0-2.21-1.79-4-4-4c-0.34,0-0.66,0.05-0.98,0.13C12.2,2.45,11.16,2.02,10,2.02L10,2.02z M7,10.5c-1.1,0-2-0.9-2-2 c0-0.85,0.55-1.6,1.37-1.88l0.8-0.27l0.36-0.76C8,4.62,8.94,4.02,10,4.02c0.79,0,1.39,0.35,1.74,0.65l0.78,0.65 c0,0,0.64-0.32,1.47-0.32c1.1,0,2,0.9,2,2c0,0-3,0-3,0C9.67,7,9.15,10.5,7,10.5C7,10.5,7,10.5,7,10.5L7,10.5z M17,17v-6h2v6H17 L17,17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 all-inclusive
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.6 6.62c-1.44 0-2.8.56-3.77 1.53L7.8 14.39c-.64.64-1.49.99-2.4.99-1.87 0-3.39-1.51-3.39-3.38S3.53 8.62 5.4 8.62c.91 0 1.76.35 2.44 1.03l1.13 1 1.51-1.34L9.22 8.2C8.2 7.18 6.84 6.62 5.4 6.62 2.42 6.62 0 9.04 0 12s2.42 5.38 5.4 5.38c1.44 0 2.8-.56 3.77-1.53l7.03-6.24c.64-.64 1.49-.99 2.4-.99 1.87 0 3.39 1.51 3.39 3.38s-1.52 3.38-3.39 3.38c-.9 0-1.76-.35-2.44-1.03l-1.14-1.01-1.51 1.34 1.27 1.12c1.02 1.01 2.37 1.57 3.82 1.57 2.98 0 5.4-2.41 5.4-5.38s-2.42-5.37-5.4-5.37z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 business-center
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M15 17H9v-1H5v3h14v-3h-4zM4 14h5v-3h6v3h5V9H4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 7h-4V5l-2-2h-4L8 5v2H4c-1.1 0-2 .9-2 2v5c0 .75.4 1.38 1 1.73V19c0 1.11.89 2 2 2h14c1.11 0 2-.89 2-2v-3.28c.59-.35 1-.99 1-1.72V9c0-1.1-.9-2-2-2zM10 5h4v2h-4V5zm9 14H5v-3h4v1h6v-1h4v3zm-8-4v-2h2v2h-2zm9-1h-5v-3H9v3H4V9h16v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 house-siding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7.21,10h9.58L17,10.19V12H7v-1.81L7.21,10z M14.57,8H9.43L12,5.69L14.57,8z M7,16v-2h10v2H7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19,12h3L12,3L2,12h3v8h2v-2h10v2h2V12z M7.21,10h9.58L17,10.19V12H7v-1.81L7.21,10z M14.57,8H9.43L12,5.69L14.57,8z M7,16 v-2h10v2H7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 carpenter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5.71,5.62L7,4.33l8.49,8.49l-2.81,2.81L5.71,5.62z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.73,14.23L7,1.5L3.11,5.39l8.13,11.67c-0.78,0.78-0.78,2.05,0,2.83l1.41,1.41c0.78,0.78,2.05,0.78,2.83,0l4.24-4.24 C20.51,16.28,20.51,15.01,19.73,14.23z M5.71,5.62L7,4.33l8.49,8.49l-2.81,2.81L5.71,5.62z M14.07,19.88l-1.41-1.41l4.24-4.24 l1.41,1.41L14.07,19.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 free-breakfast
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M6 13c0 1.1.9 2 2 2h6c1.1 0 2-.9 2-2V5H6v8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 19h16v2H4zM20 3H4v10c0 2.21 1.79 4 4 4h6c2.21 0 4-1.79 4-4v-3h2c1.11 0 2-.9 2-2V5c0-1.11-.89-2-2-2zm-4 10c0 1.1-.9 2-2 2H8c-1.1 0-2-.9-2-2V5h10v8zm4-5h-2V5h2v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 gite
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M4,12h10v5H4V12z M20,17h-4v-6.17l2-2v0l2,2V17z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18,6H9V4H7v2H6l-4,4v9h20v-9L18,6z M4,12h10v5H4V12z M20,17h-4v-6.17l2-2v0l2,2V17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 escalator-warning
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M6.5,2c1.1,0,2,0.9,2,2s-0.9,2-2,2s-2-0.9-2-2S5.4,2,6.5,2z M15.5,9.5c0,0.83,0.67,1.5,1.5,1.5s1.5-0.67,1.5-1.5 S17.83,8,17,8S15.5,8.67,15.5,9.5z M18.5,12h-2.84c-0.58,0.01-1.14,0.32-1.45,0.86l-0.92,1.32L9.72,8C9.35,7.37,8.69,7.01,8.01,7H5 C3.9,7,3,7.9,3,9v6h1.5v7h5V11.61L12.03,16h2.2L15,14.9V22h4v-5h1v-3.5C20,12.68,19.33,12,18.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 grass
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,20H2v-2h5.75l0,0C7.02,15.19,4.81,12.99,2,12.26C2.64,12.1,3.31,12,4,12C8.42,12,12,15.58,12,20z M22,12.26 C21.36,12.1,20.69,12,20,12c-2.93,0-5.48,1.58-6.88,3.93c0.29,0.66,0.53,1.35,0.67,2.07c0.13,0.65,0.2,1.32,0.2,2h2h6v-2h-5.75 C16.98,15.19,19.19,12.99,22,12.26z M15.64,11.02c0.78-2.09,2.23-3.84,4.09-5C15.44,6.16,12,9.67,12,14c0,0.01,0,0.02,0,0.02 C12.95,12.75,14.2,11.72,15.64,11.02z M11.42,8.85C10.58,6.66,8.88,4.89,6.7,4C8.14,5.86,9,8.18,9,10.71c0,0.21-0.03,0.41-0.04,0.61 c0.43,0.24,0.83,0.52,1.22,0.82C10.39,10.96,10.83,9.85,11.42,8.85z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 golf-course
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1.5",
    :opacity ".3",
    :cy "19.5",
    :cx "19.5",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M17 5.92L9 2v18H7v-1.73c-1.79.35-3 .99-3 1.73 0 1.1 2.69 2 6 2s6-.9 6-2c0-.99-2.16-1.81-5-1.97V8.98l6-3.06z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "19.5", :cx "19.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M17 5.92L9 2v18H7v-1.73c-1.79.35-3 .99-3 1.73 0 1.1 2.69 2 6 2s6-.9 6-2c0-.99-2.16-1.81-5-1.97V8.98l6-3.06z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 casino
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5 19h14V5H5v14zM16.5 6c.83 0 1.5.67 1.5 1.5S17.33 9 16.5 9 15 8.33 15 7.5 15.67 6 16.5 6zm0 9c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zM12 10.5c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zM7.5 6C8.33 6 9 6.67 9 7.5S8.33 9 7.5 9 6 8.33 6 7.5 6.67 6 7.5 6zm0 9c.83 0 1.5.67 1.5 1.5S8.33 18 7.5 18 6 17.33 6 16.5 6.67 15 7.5 15z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "16.5", :cx "7.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "7.5", :cx "7.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "12", :cx "12", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "16.5", :cx "16.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "7.5", :cx "16.5", :stroke nil, :fill nil})))


(helix.core/defnc
 tapas
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M16,10V8h4v2c0,1.1-0.9,2-2,2S16,11.1,16,10z M4,6C3.72,6,3.5,5.78,3.5,5.5S3.72,5,4,5h6 c0.28,0,0.5,0.22,0.5,0.5S10.28,6,10,6H4z M10,12H4c-0.28,0-0.5-0.22-0.5-0.5S3.72,11,4,11h6c0.28,0,0.5,0.22,0.5,0.5 S10.28,12,10,12z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M22,10V1h-8v9c0,1.86,1.28,3.41,3,3.86V21h-2v2h6v-2h-2v-7.14C20.72,13.41,22,11.86,22,10z M20,3v3h-4V3H20z M16,10V8h4v2 c0,1.1-0.9,2-2,2S16,11.1,16,10z M10,9H8V8h2c1.38,0,2.5-1.12,2.5-2.5C12.5,4.12,11.38,3,10,3H8V1H6v2H4C2.62,3,1.5,4.12,1.5,5.5 C1.5,6.88,2.62,8,4,8h2v1H4c-1.38,0-2.5,1.12-2.5,2.5C1.5,12.88,2.62,14,4,14h2v9h2v-9h2c1.38,0,2.5-1.12,2.5-2.5 C12.5,10.12,11.38,9,10,9z M4,6C3.72,6,3.5,5.78,3.5,5.5S3.72,5,4,5h6c0.28,0,0.5,0.22,0.5,0.5S10.28,6,10,6H4z M10,12H4 c-0.28,0-0.5-0.22-0.5-0.5S3.72,11,4,11h6c0.28,0,0.5,0.22,0.5,0.5S10.28,12,10,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 charging-station
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d "M17,3v1H7V3H17 M17,20H7v1h10V20",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M14.5,11l-3,6v-4h-2l3-6v4H14.5z M17,3H7v1h10V3 M17,20H7v1h10V20 M17,1c1.1,0,2,0.9,2,2v18c0,1.1-0.9,2-2,2H7 c-1.1,0-2-0.9-2-2V3c0-1.1,0.9-2,2-2H17L17,1z M7,18h10V6H7V18L7,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 smoke-free
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.5 13H22v3h-1.5zM18 13h1.5v3H18zm.85-8.27c.62-.61 1-1.45 1-2.38h-1.5c0 1.02-.83 1.85-1.85 1.85v1.5c2.24 0 4 1.83 4 4.07V12H22V9.76c0-2.22-1.28-4.14-3.15-5.03zM14.5 8.65h1.53c1.05 0 1.97.74 1.97 2.05V12h1.5v-1.64c0-1.81-1.6-3.16-3.47-3.16H14.5c-1.02 0-1.85-.98-1.85-2s.83-1.75 1.85-1.75v-1.5c-1.85 0-3.35 1.5-3.35 3.35s1.5 3.35 3.35 3.35zM17 13h-2.34L17 15.34zM3.41 4.59L2 6l7 7H2v3h10l7 7 1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 foundation
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M7,15v-4.81l4-3.6V15H7z M13,15V6.59l4,3.6V15H13z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19,12h3L12,3L2,12h3v3H3v2h2v3h2v-3h4v3h2v-3h4v3h2v-3h2v-2h-2V12z M7,15v-4.81l4-3.6V15H7z M13,15V6.59l4,3.6V15H13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-stroller
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M8.1,5.27C8.71,5.1,9.35,5,10,5c0.29,0,0.58,0.02,0.86,0.05L9.49,6.67L8.1,5.27z M15,12.17V8.66l-1.61,1.89 L15,12.17z M12.17,15l-1.39-1.39L9.6,15H12.17z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M8,20c0,1.1-0.9,2-2,2s-2-0.9-2-2s0.9-2,2-2S8,18.9,8,20z M15,8.66v3.51l2,2v-7.9C17.58,5.59,17.97,5,18.65,5 C19.42,5,20,5.66,20,6.48V7h2V6.48C22,4.56,20.52,3,18.65,3c-1.66,0-2.54,1.27-3.18,2.03l-3.5,4.11l1.42,1.42L15,8.66z M19.78,22.61l-1.91-1.91C17.58,21.46,16.86,22,16,22c-1.1,0-2-0.9-2-2c0-0.86,0.54-1.58,1.3-1.87L14.17,17H7.43 c-0.85,0-1.31-1-0.76-1.65l2.69-3.16L1.39,4.22l1.41-1.41l7.86,7.86l1.42,1.42l0,0l9.11,9.11L19.78,22.61z M12.17,15l-1.39-1.39 L9.6,15H12.17z M10,5c0.29,0,0.58,0.02,0.86,0.05L9.49,6.67l1.42,1.42L14.3,4.1C13.03,3.4,11.56,3,10,3C8.77,3,7.6,3.25,6.53,3.7 L8.1,5.27C8.71,5.1,9.35,5,10,5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 corporate-fare
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M10,19H4v-2h6V19z M10,15H4v-2h6V15z M10,11H4V9h6V11z M10,7H4V5h6V7z M20,19h-8V9h8V19z M18,11h-4v2h4V11z M18,15h-4v2h4V15z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,7V3H2v18h20V7H12z M10,19H4v-2h6V19z M10,15H4v-2h6V15z M10,11H4V9h6V11z M10,7H4V5h6V7z M20,19h-8V9h8V19z M18,11h-4v2 h4V11z M18,15h-4v2h4V15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-drinks
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/polygon
    {:points "14.77,9 11.83,9 13.38,10.56",
     :opacity ".3",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M21.19,21.19L2.81,2.81L1.39,4.22l8.23,8.23L11,14v5H6v2h12v-0.17l1.78,1.78L21.19,21.19z M13,19v-3.17L16.17,19H13z M7.83,5l-2-2H21v2l-6.2,6.97l-1.42-1.42L14.77,9h-2.94l-2-2h6.74l1.78-2H7.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 family-restroom
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M16,4c0-1.11,0.89-2,2-2s2,0.89,2,2s-0.89,2-2,2S16,5.11,16,4z M20,22v-6h2.5l-2.54-7.63C19.68,7.55,18.92,7,18.06,7h-0.12 c-0.86,0-1.63,0.55-1.9,1.37l-0.86,2.58C16.26,11.55,17,12.68,17,14v8H20z M12.5,11.5c0.83,0,1.5-0.67,1.5-1.5s-0.67-1.5-1.5-1.5 S11,9.17,11,10S11.67,11.5,12.5,11.5z M5.5,6c1.11,0,2-0.89,2-2s-0.89-2-2-2s-2,0.89-2,2S4.39,6,5.5,6z M7.5,22v-7H9V9 c0-1.1-0.9-2-2-2H4C2.9,7,2,7.9,2,9v6h1.5v7H7.5z M14,22v-4h1v-4c0-0.82-0.68-1.5-1.5-1.5h-2c-0.82,0-1.5,0.68-1.5,1.5v4h1v4H14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 checkroom
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21.6,18.2L13,11.75v-0.91c1.65-0.49,2.8-2.17,2.43-4.05c-0.26-1.31-1.3-2.4-2.61-2.7C10.54,3.57,8.5,5.3,8.5,7.5h2 C10.5,6.67,11.17,6,12,6s1.5,0.67,1.5,1.5c0,0.84-0.69,1.52-1.53,1.5C11.43,8.99,11,9.45,11,9.99v1.76L2.4,18.2 C1.63,18.78,2.04,20,3,20h9h9C21.96,20,22.37,18.78,21.6,18.2z M6,18l6-4.5l6,4.5H6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 soap
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M14.25,6C14.66,6,15,6.34,15,6.75S14.66,7.5,14.25,7.5S13.5,7.16,13.5,6.75S13.84,6,14.25,6 M20,5.5 c0.28,0,0.5,0.22,0.5,0.5S20.28,6.5,20,6.5S19.5,6.28,19.5,6S19.72,5.5,20,5.5 M10,21H4c-0.55,0-1-0.45-1-1v-6 c0-0.39,0.23-0.64,0.36-0.75L7,9.87V12l3,0V21z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M14.25,6C14.66,6,15,6.34,15,6.75S14.66,7.5,14.25,7.5S13.5,7.16,13.5,6.75S13.84,6,14.25,6 M14.25,4.5 C13.01,4.5,12,5.51,12,6.75S13.01,9,14.25,9s2.25-1.01,2.25-2.25S15.49,4.5,14.25,4.5L14.25,4.5z M20,5.5c0.28,0,0.5,0.22,0.5,0.5 S20.28,6.5,20,6.5S19.5,6.28,19.5,6S19.72,5.5,20,5.5 M20,4c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S21.1,4,20,4L20,4z M16.5,1 C15.67,1,15,1.67,15,2.5S15.67,4,16.5,4C17.33,4,18,3.33,18,2.5S17.33,1,16.5,1z M20.75,16c0.69,0,1.25-0.56,1.25-1.25 s-0.56-1.25-1.25-1.25H12v-1h6.75c0.69,0,1.25-0.56,1.25-1.25c0-0.67-0.53-1.2-1.18-1.24L8.87,10l1.48-2.6 c0.09-0.17,0.14-0.34,0.14-0.54c0-0.26-0.09-0.5-0.26-0.7L9.12,5l-7.18,6.8C1.34,12.36,1,13.15,1,13.97V20c0,1.66,1.34,3,3,3h13.75 c0.69,0,1.25-0.56,1.25-1.25s-0.56-1.25-1.25-1.25H12v-1h7.75c0.69,0,1.25-0.56,1.25-1.25S20.44,17,19.75,17H12v-1H20.75z M10,21H4 c-0.55,0-1-0.45-1-1v-6c0-0.39,0.23-0.64,0.36-0.75L7,9.87V12l3,0V21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 houseboat
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/polygon
   {:points
    "13,13 13,11 11,11 11,13 9,13 9,8.18 12,5.98 15,8.18 15,13",
    :opacity ".3",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,16c-1.95,0-2.1,1-3.34,1c-1.19,0-1.42-1-3.33-1C3.38,16,3.24,17,2,17v2c1.9,0,2.17-1,3.35-1c1.19,0,1.42,1,3.33,1 c1.95,0,2.08-1,3.32-1s1.37,1,3.32,1c1.91,0,2.14-1,3.33-1c1.18,0,1.45,1,3.35,1v-2c-1.24,0-1.38-1-3.33-1c-1.91,0-2.14,1-3.33,1 C14.1,17,13.95,16,12,16z M20.34,11.34l-1.37,1.37C18.78,12.89,18.52,13,18.26,13H17V9.65l1.32,0.97L19.5,9L12,3.5L4.5,9l1.18,1.61 L7,9.65V13H5.74c-0.27,0-0.52-0.11-0.71-0.29l-1.37-1.37l-1.41,1.41l1.37,1.37C4.18,14.68,4.95,15,5.74,15h12.51 c0.8,0,1.56-0.32,2.12-0.88l1.37-1.37L20.34,11.34z M13,13v-2h-2v2H9V8.18l3-2.2l3,2.2V13H13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 roofing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/rect
   {:y "16",
    :x "11",
    :width "2",
    :opacity ".3",
    :height "2",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M13,18h-2v-2h2V18z M15,14H9v6h6V14L15,14z M19,9.3L19,9.3V4h-3v2.6v0L12,3L2,12h3l7-6.31L19,12h3L19,9.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 night-shelter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,5.5l6,4.5v9H6v-9L12,5.5 M15,12h-3.5v3.5H8V11H7v7h1v-1.5h8V18h1v-4C17,12.9,16.1,12,15,12z M9.75,12.5 c-0.69,0-1.25,0.56-1.25,1.25C8.5,14.44,9.06,15,9.75,15S11,14.44,11,13.75C11,13.06,10.44,12.5,9.75,12.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,5.5l6,4.5v9H6v-9L12,5.5 M12,3L4,9v12h16V9L12,3L12,3z M15,12h-3.5v3.5H8V11H7v7h1v-1.5h8V18h1v-4 C17,12.9,16.1,12,15,12z M9.75,12.5c-0.69,0-1.25,0.56-1.25,1.25C8.5,14.44,9.06,15,9.75,15S11,14.44,11,13.75 C11,13.06,10.44,12.5,9.75,12.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-step
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M14.98,12.15 M14.98,12.15l3.07-3.07L13.8,4.82l-3.08,3.07L14.98,12.15z M12.42,15.26l-1.67-1.68L7.42,16.9 c-0.78,0.78-2.05,0.78-2.83-0.01L4.4,16.72l-0.47,0.24c-0.29,0.14-0.59,0.27-0.89,0.39L3.03,18h6.64L12.42,15.26z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M18.51,15.68l-1.41-1.41l4.48-4.48L23,11.2L18.51,15.68z M14.98,12.15 M14.98,12.15l3.07-3.07L13.8,4.82l-3.08,3.07 L9.3,6.47L13.8,2l0,0l7.08,7.08l-4.48,4.48L14.98,12.15z M21.18,21.2l-1.41,1.41l-5.94-5.94L10.5,20H1v-2.63 c0-0.84,0.52-1.57,1.3-1.88c0.58-0.23,1.28-0.56,1.97-1.02l1.38,1.38C5.74,15.95,5.87,16,6,16s0.26-0.05,0.36-0.15 c0.2-0.2,0.2-0.51,0-0.71l-1.28-1.28c0.27-0.24,0.53-0.51,0.77-0.8l1.27,1.27c0.09,0.1,0.23,0.15,0.35,0.15s0.25-0.05,0.35-0.15 c0.2-0.2,0.2-0.51,0-0.71l-1.4-1.4c0.19-0.34,0.34-0.72,0.45-1.12l1.71,1.72c0.09,0.1,0.23,0.15,0.35,0.15s0.25-0.05,0.35-0.15 c0.19-0.2,0.19-0.5,0.01-0.7l-7.9-7.9l1.42-1.41L21.18,21.2z M12.42,15.26l-1.67-1.68L7.42,16.9c-0.78,0.78-2.05,0.78-2.83-0.01 L4.4,16.72l-0.47,0.24c-0.29,0.14-0.59,0.27-0.89,0.39L3.03,18h6.64L12.42,15.26z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 spa
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.55 12c-1.07-.71-2.25-1.27-3.53-1.61 1.28.34 2.46.9 3.53 1.61zm10.43-1.61c-1.29.34-2.49.91-3.57 1.64 1.08-.73 2.28-1.3 3.57-1.64z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M8.94 12.25c0-.01 0-.01 0 0-.13-.09-.27-.17-.4-.26.13.1.27.17.4.26zm4.41-3.67c-.22-1.21-.66-2.35-1.3-3.38-.66 1.04-1.12 2.19-1.37 3.39.46.3.9.62 1.33.97.42-.35.87-.68 1.34-.98zm3.19 5.08l.01.02c-.09.06-.18.12-.27.17l-.07.05c-.98.71-1.84 1.61-2.53 2.66L12 19.1l-1.67-2.55c-.68-1.03-1.52-1.92-2.51-2.65l-.07-.04c-.13-.08-.26-.16-.39-.25l.01-.01c-.96-.63-2.01-1.07-3.12-1.33.75 3.36 3.16 6.17 6.45 7.35.42.15.84.27 1.28.36.45-.09.89-.21 1.33-.37 3.27-1.17 5.67-3.98 6.43-7.34-1.14.26-2.23.73-3.2 1.39zm-7.55-1.38",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 15.45c-.82-1.25-1.86-2.34-3.06-3.2-.13-.09-.27-.16-.4-.26.13.09.27.17.39.25C6.98 10.83 4.59 10 2 10c0 5.32 3.36 9.82 8.03 11.49.63.23 1.29.4 1.97.51.68-.12 1.33-.29 1.97-.51C18.64 19.82 22 15.32 22 10c-4.18 0-7.85 2.17-10 5.45zm1.32 4.15c-.44.15-.88.27-1.33.37-.44-.09-.87-.21-1.28-.36-3.29-1.18-5.7-3.99-6.45-7.35 1.1.26 2.15.71 3.12 1.33l-.02.01c.13.09.26.18.39.25l.07.04c.99.72 1.84 1.61 2.51 2.65L12 19.1l1.67-2.55c.69-1.05 1.55-1.95 2.53-2.66l.07-.05c.09-.05.18-.11.27-.17l-.01-.02c.98-.65 2.07-1.13 3.21-1.4-.75 3.37-3.15 6.18-6.42 7.35zm2.17-9.97c-.18-2.79-1.31-5.51-3.43-7.63-2.14 2.14-3.32 4.86-3.55 7.63 1.28.68 2.46 1.56 3.49 2.63 1.03-1.06 2.21-1.94 3.49-2.63zm-3.44-4.44c.63 1.03 1.07 2.18 1.3 3.38-.47.3-.91.63-1.34.98-.42-.34-.87-.67-1.33-.97.25-1.2.71-2.35 1.37-3.39z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M8.99 12.28c-.02-.01-.04-.03-.05-.04 0 0 .01 0 .01.01.01.01.02.02.04.03z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cabin
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M13.94,7h-3.89L12,5.52L13.94,7z M7.44,9h9.12L18,10.1V11H6v-0.9L7.44,9z M18,13v2H6v-2H18z M6,19v-2h12v2H6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M10,1c0,1.66-1.34,3-3,3C6.45,4,6,4.45,6,5H4c0-1.66,1.34-3,3-3c0.55,0,1-0.45,1-1H10z M12,3L6,7.58V6H4v3.11L1,11.4 l1.21,1.59L4,11.62V21h16v-9.38l1.79,1.36L23,11.4L12,3z M13.94,7h-3.89L12,5.52L13.94,7z M7.44,9h9.12L18,10.1V11H6v-0.9L7.44,9z M18,13v2H6v-2H18z M6,19v-2h12v2H6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 villa
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5,9.37l9-3.46V12H9v7H5V9.37z M19,19h-3v-3h-2v3h-3v-5h8V19z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19,10c-1.1,0-2,0.9-2,2h-1V3L3,8v13h18v-9C21,10.9,20.1,10,19,10z M5,9.37l9-3.46V12H9v7H5V9.37z M19,19h-3v-3h-2v3h-3v-5 h8V19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ac-unit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 11h-4.17l3.24-3.24-1.41-1.42L15 11h-2V9l4.66-4.66-1.42-1.41L13 6.17V2h-2v4.17L7.76 2.93 6.34 4.34 11 9v2H9L4.34 6.34 2.93 7.76 6.17 11H2v2h4.17l-3.24 3.24 1.41 1.42L9 13h2v2l-4.66 4.66 1.42 1.41L11 17.83V22h2v-4.17l3.24 3.24 1.42-1.41L13 15v-2h2l4.66 4.66 1.41-1.42L17.83 13H22v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-food
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :enable-background "new",
     :d "M8.16,11c-1.43,0.07-3.52,0.57-4.54,2h6.55L8.16,11z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M1,21h15.01v0.98c0,0.56-0.45,1.01-1.01,1.01H2.01C1.45,22.99,1,22.54,1,21.98V21z M20.49,23.31L16,18.83V19H1v-2h13.17 l-2-2H1c0-3.24,2.46-5.17,5.38-5.79l-5.7-5.7L2.1,2.1L13,13l2,2l6.9,6.9L20.49,23.31z M10.17,13l-2-2c-1.42,0.06-3.52,0.56-4.55,2 H10.17z M23,5h-5V1h-2v4h-5l0.23,2h9.56l-1,9.97l1.83,1.83L23,5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 room-preferences
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :enable-background "new",
     :d
     "M13,12.11V5H7v14h4.29C11.1,18.37,11,17.7,11,17C11,15.09,11.76,13.37,13,12.11 z M10,11h2v2h-2V11z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M12,13h-2v-2h2V13z M7,19V5h6v7.11c0.57-0.59,1.25-1.07,2-1.42V6h2v4h1h1V4h-4V3H5v16H3v2h9.26c-0.42-0.6-0.75-1.28-0.97-2 H7z M21.69,17.63l1.14,1l-1,1.73l-1.45-0.49c-0.32,0.27-0.68,0.48-1.08,0.63L19,22h-2l-0.3-1.49c-0.4-0.15-0.76-0.36-1.08-0.63 l-1.45,0.49l-1-1.73l1.14-1c-0.08-0.5-0.08-0.76,0-1.26l-1.14-1l1-1.73l1.45,0.49c0.32-0.27,0.68-0.48,1.08-0.63L17,12h2l0.3,1.49 c0.4,0.15,0.76,0.36,1.08,0.63l1.45-0.49l1,1.73l-1.14,1C21.77,16.87,21.77,17.13,21.69,17.63z M20,17c0-1.1-0.9-2-2-2s-2,0.9-2,2 s0.9,2,2,2S20,18.1,20,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 no-backpack
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M18,15.17V8c0-1.1-0.9-2-2-2H8.83l6,6h1.67v1.67L18,15.17z M17.17,20l-6-6H7.5v-2h1.67L6,8.83V20H17.17z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M6.98,4.15c0.01,0,0.01-0.01,0.02-0.01V2h3v2h4V2h3v2.14c1.72,0.45,3,2,3,3.86v9.17l-2-2V8c0-1.1-0.9-2-2-2H8.83L6.98,4.15z M14.83,12l1.67,1.67V12H14.83z M19.78,22.61l-0.85-0.85C18.65,21.91,18.34,22,18,22H6c-1.1,0-2-0.9-2-2V8 c0-0.36,0.06-0.69,0.15-1.02L1.39,4.22l1.41-1.41l18.38,18.38L19.78,22.61z M17.17,20l-6-6H7.5v-2h1.67L6,8.83V20H17.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 child-friendly
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M15 4.34V8h3.66C18.05 6.3 16.7 4.95 15 4.34zM8.04 14.36l.44.67c1.19.16 2.19.92 2.68 1.97h2.68c.56-1.18 1.77-2 3.16-2 .15 0 .31.01.46.03l.29-.37c.4-.51.7-1.07.92-1.66H7.37c.32.67.57 1.19.67 1.36z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M13 2v8h8c0-4.42-3.58-8-8-8zm2 6V4.34c1.7.6 3.05 1.95 3.66 3.66H15zm-8.56 3l-.95-2H2v2h2.22s1.89 4.07 2.12 4.42c-1.1.59-1.84 1.75-1.84 3.08C4.5 20.43 6.07 22 8 22c1.76 0 3.22-1.3 3.46-3h2.08c.24 1.7 1.7 3 3.46 3 1.93 0 3.5-1.57 3.5-3.5 0-1.04-.46-1.97-1.18-2.61C20.37 14.54 21 12.84 21 11H6.44zM8 20c-.83 0-1.5-.67-1.5-1.5S7.17 17 8 17s1.5.67 1.5 1.5S8.83 20 8 20zm9 0c-.83 0-1.5-.67-1.5-1.5S16.17 17 17 17s1.5.67 1.5 1.5S17.83 20 17 20zm.74-5.34l-.29.37c-.14-.02-.3-.03-.45-.03-1.39 0-2.6.82-3.16 2h-2.68c-.5-1.04-1.5-1.8-2.68-1.97l-.44-.67c-.1-.17-.34-.69-.67-1.36h11.29c-.21.59-.52 1.15-.92 1.66z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hot-tub
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle {:r "2", :cy "6", :cx "7", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M17.42 7.21c.57.62.82 1.41.67 2.2l-.11.59h1.91l.06-.43c.21-1.36-.27-2.71-1.3-3.71l-.07-.07c-.57-.62-.82-1.41-.67-2.2L18 3h-1.89l-.06.43c-.2 1.36.27 2.71 1.3 3.72l.07.06zM11.15 12c-.31-.22-.59-.46-.82-.72l-1.4-1.55c-.19-.21-.43-.38-.69-.5-.29-.14-.62-.23-.96-.23h-.03C6.01 9 5 10.01 5 11.25V12H2v8c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-8H11.15zM7 20H5v-6h2v6zm4 0H9v-6h2v6zm4 0h-2v-6h2v6zm4 0h-2v-6h2v6zM13.42 7.21c.57.62.82 1.41.67 2.2l-.11.59h1.91l.06-.43c.21-1.36-.27-2.71-1.3-3.71l-.07-.07c-.57-.62-.82-1.41-.67-2.2L14 3h-1.89l-.06.43c-.2 1.36.27 2.71 1.3 3.72l.07.06z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fence
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   {:opacity ".3"}
   (helix.dom/path
    {:d
     "M16,6.83l1,1V10h-2V7.83l0.41-0.41L16,6.83z M12,6.83l0.59,0.59L13,7.83V10h-2V7.83l0.41-0.41L12,6.83z M11,14v-2h2v2H11z M13,16v2h-2v-2H13z M7,7.83l1-1l0.59,0.59L9,7.83V10H7V7.83z M7,12h2v2H7V12z M7,16h2v2H7V16z M17,18h-2v-2h2V18z M17,14h-2v-2h2 V14z",
     :stroke nil,
     :fill nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,12v-2h-2V7l-3-3l-2,2l-2-2l-2,2L8,4L5,7v3H3v2h2v2H3v2h2v4h14v-4h2v-2h-2v-2H21z M16,6.83l1,1V10h-2V7.83l0.41-0.41 L16,6.83z M12,6.83l0.59,0.59L13,7.83V10h-2V7.83l0.41-0.41L12,6.83z M11,14v-2h2v2H11z M13,16v2h-2v-2H13z M7,7.83l1-1l0.59,0.59 L9,7.83V10H7V7.83z M7,12h2v2H7V12z M7,16h2v2H7V16z M17,18h-2v-2h2V18z M17,14h-2v-2h2V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 rice-bowl
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19.66,14c-0.66,1.92-2.24,3.54-4.4,4.39L14,18.88V20h-4v-1.12l-1.27-0.5c-2.16-0.85-3.74-2.47-4.4-4.39 H19.66",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.66,14c-0.66,1.92-2.24,3.54-4.4,4.39L14,18.88V20h-4v-1.12l-1.27-0.5c-2.16-0.85-3.74-2.47-4.4-4.39H19.66 M12,2 C6.48,2,2,6.48,2,12c0,3.69,2.47,6.86,6,8.25V22h8v-1.75c3.53-1.39,6-4.56,6-8.25h0C22,6.48,17.52,2,12,2L12,2z M10,12V4.26 C10.64,4.1,11.31,4,12,4s1.36,0.1,2,0.26V12H10L10,12z M16,12V5.08c2.39,1.39,4,3.96,4,6.92H16L16,12z M4,12 c0-2.95,1.61-5.53,4-6.92V12H4L4,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-photography
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :enable-background "new",
     :d
     "M10.94,8.12L8.9,6.07L9.88,5h4.24l1.83,2H20v10.17l-3.12-3.12 C16.96,13.71,17,13.36,17,13c0-2.76-2.24-5-5-5C11.64,8,11.29,8.04,10.94,8.12z M12,18c-2.76,0-5-2.24-5-5 c0-0.91,0.25-1.76,0.68-2.49L4.17,7H4v12h12.17l-1.68-1.68C13.76,17.75,12.91,18,12,18z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M8.9,6.07L7.48,4.66L9,3h6l1.83,2H20c1.1,0,2,0.9,2,2v12c0,0.05-0.01,0.1-0.02,0.16L20,17.17V7h-4.05l-1.83-2H9.88 L8.9,6.07z M20.49,23.31L18.17,21H4c-1.1,0-2-0.9-2-2V7c0-0.59,0.27-1.12,0.68-1.49l-2-2L2.1,2.1L7,7l2.01,2.01l1.43,1.43l4.1,4.1 l1.43,1.43L19,19l1.82,1.82l1.08,1.08L20.49,23.31z M9.19,12.02C9.08,12.33,9,12.65,9,13c0,1.65,1.35,3,3,3 c0.35,0,0.67-0.08,0.98-0.19L9.19,12.02z M16.17,19l-1.68-1.68C13.76,17.75,12.91,18,12,18c-2.76,0-5-2.24-5-5 c0-0.91,0.25-1.76,0.68-2.49L4.17,7H4v12H16.17z M14.81,11.98l2.08,2.08C16.96,13.71,17,13.36,17,13c0-2.76-2.24-5-5-5 c-0.36,0-0.71,0.04-1.06,0.12l2.08,2.08C13.85,10.5,14.5,11.15,14.81,11.98z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bento
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   {:opacity ".3"}
   (helix.dom/path
    {:d
     "M4,17h8V7H4V17z M8,10.5c0.83,0,1.5,0.67,1.5,1.5S8.83,13.5,8,13.5S6.5,12.83,6.5,12S7.17,10.5,8,10.5z M14,13h6v4h-6V13z M20,7v4h-6V7H20z",
     :stroke nil,
     :fill nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,5H4C2.9,5,2,5.9,2,7v10c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V7C22,5.9,21.1,5,20,5z M20,11h-6V7h6V11z M4,7h8v10H4V7z M14,17v-4h6v4H14z M9.5,12c0,0.83-0.67,1.5-1.5,1.5S6.5,12.83,6.5,12s0.67-1.5,1.5-1.5S9.5,11.17,9.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 iron
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M15,16H4v-1c0-1.1,0.9-2,2-2h9V16z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21,6c-1.66,0-3,1.34-3,3v4c0,0.55-0.45,1-1,1v-4c0-1.66-1.34-3-3-3h-4c-1.66,0-3,1.34-3,3h2c0-0.55,0.45-1,1-1h4 c0.55,0,1,0.45,1,1v1H6c-2.21,0-4,1.79-4,4v3h15v-2c1.66,0,3-1.34,3-3V9c0-0.55,0.45-1,1-1h1V6H21z M15,16H4v-1c0-1.1,0.9-2,2-2h9 V16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-cell
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d "M7,21h10v-1H7V21z M7,3v1h10V3H7z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M17,6v8.17l2,2V3c0-1.1-0.9-1.99-2-1.99L7,1C6.15,1,5.42,1.55,5.13,2.3L8.83,6H17z M7,3h10v1H7V3z M21.19,21.19L2.81,2.81 L1.39,4.22L5,7.83V21c0,1.1,0.9,2,2,2h10c0.85,0,1.58-0.55,1.87-1.3l0.91,0.91L21.19,21.19z M17,21H7v-1h10V21z M7,18V9.83 L15.17,18H7z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 umbrella
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M13.28,8.5l0.76,0.58l0.92-0.23L13,14.8V8.29L13.28,8.5z M9.03,8.86L11,14.8V8.29L10.72,8.5L9.96,9.09 L9.03,8.86z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M14.5,6.92L13,5.77V3.88V3.4c0-0.26,0.22-0.48,0.5-0.48c0.28,0,0.5,0.21,0.5,0.48V4h2V3.4C16,2.07,14.88,1,13.5,1 C12.12,1,11,2.07,11,3.4v0.48v1.89L9.5,6.92L6,6.07l5.05,15.25C11.2,21.77,11.6,22,12,22s0.8-0.23,0.95-0.69L18,6.07L14.5,6.92z M13.28,8.5l0.76,0.58l0.92-0.23L13,14.8V8.29L13.28,8.5z M9.96,9.09l0.76-0.58L11,8.29v6.51L9.03,8.86L9.96,9.09z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 house
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M7,10.19V18h2v-6h6v6h2v-7.81l-5-4.5L7,10.19z M14,10h-4c0-1.1,0.9-2,2-2S14,8.9,14,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,9.3V4h-3v2.6L12,3L2,12h3v8h6v-6h2v6h6v-8h3L19,9.3z M17,18h-2v-6H9v6H7v-7.81l5-4.5l5,4.5V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M10,10h4c0-1.1-0.9-2-2-2S10,8.9,10,10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 baby-changing-station
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M14,8v2h-3L8.31,8.82L7,12.75V22H3V12l1.58-4.63C4.96,6.25,6.22,5.69,7.3,6.18l4.15,1.83L14,8z M8,1C6.9,1,6,1.9,6,3 s0.9,2,2,2s2-0.9,2-2S9.1,1,8,1z M9,19h12v-2H9V19z M19.5,16c0.83,0,1.5-0.67,1.5-1.5c0-0.83-0.67-1.5-1.5-1.5S18,13.67,18,14.5 C18,15.33,18.67,16,19.5,16z M13,12c0-0.55-0.45-1-1-1H9v2h2v1c0,1.1,0.9,2,2,2h2c1.1,0,2-0.9,2-2v-3h-2v2h-2V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bathtub
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "15",
      :x "4",
      :width "16",
      :opacity ".3",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "7", :cx "7", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M20,13V4.83C20,3.27,18.73,2,17.17,2c-0.75,0-1.47,0.3-2,0.83l-1.25,1.25C13.76,4.03,13.59,4,13.41,4 c-0.4,0-0.77,0.12-1.08,0.32l2.76,2.76c0.2-0.31,0.32-0.68,0.32-1.08c0-0.18-0.03-0.34-0.07-0.51l1.25-1.25 C16.74,4.09,16.95,4,17.17,4C17.63,4,18,4.37,18,4.83V13h-6.85c-0.3-0.21-0.57-0.45-0.82-0.72l-1.4-1.55 c-0.19-0.21-0.43-0.38-0.69-0.5C7.93,10.08,7.59,10,7.24,10C6,10.01,5,11.01,5,12.25V13H2v6c0,1.1,0.9,2,2,2c0,0.55,0.45,1,1,1h14 c0.55,0,1-0.45,1-1c1.1,0,2-0.9,2-2v-6H20z M20,19H4v-4h16V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 wash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M10,21H4c-0.55,0-1-0.45-1-1v-6c0-0.39,0.23-0.64,0.36-0.75L7,9.87V12l3,0V21z M18.5,6.5c-0.55,0-1-0.45-1-1 c0-0.4,0.43-1.22,1-2.05c0.57,0.83,1,1.65,1,2.05C19.5,6.05,19.05,6.5,18.5,6.5z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M20.75,16c0.69,0,1.25-0.56,1.25-1.25s-0.56-1.25-1.25-1.25H12v-1h6.75c0.69,0,1.25-0.56,1.25-1.25 c0-0.67-0.53-1.2-1.18-1.24L8.87,10l1.48-2.6c0.09-0.17,0.14-0.34,0.14-0.54c0-0.26-0.09-0.5-0.26-0.7L9.12,5l-7.18,6.8 C1.34,12.36,1,13.15,1,13.97V20c0,1.66,1.34,3,3,3h13.75c0.69,0,1.25-0.56,1.25-1.25s-0.56-1.25-1.25-1.25H12v-1h7.75 c0.69,0,1.25-0.56,1.25-1.25S20.44,17,19.75,17H12v-1H20.75z M10,21H4c-0.55,0-1-0.45-1-1v-6c0-0.39,0.23-0.64,0.36-0.75L7,9.87V12 l3,0V21z M13.5,9C14.33,9,15,8.33,15,7.5C15,6.66,13.5,5,13.5,5S12,6.66,12,7.5C12,8.33,12.67,9,13.5,9z M18.5,1 c0,0-2.5,2.83-2.5,4.5C16,6.88,17.12,8,18.5,8S21,6.88,21,5.5C21,3.83,18.5,1,18.5,1z M18.5,6.5c-0.55,0-1-0.45-1-1 c0-0.4,0.43-1.22,1-2.05c0.57,0.83,1,1.65,1,2.05C19.5,6.05,19.05,6.5,18.5,6.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 airport-shuttle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M3 14h.78c.55-.61 1.34-1 2.22-1s1.67.39 2.22 1h7.56c.55-.61 1.34-1 2.22-1s1.67.39 2.22 1H21v-2H3v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17 5H3c-1.1 0-2 .89-2 2v9h2c0 1.66 1.34 3 3 3s3-1.34 3-3h6c0 1.66 1.34 3 3 3s3-1.34 3-3h2v-5l-6-6zm-2 2h1l3 3h-4V7zM9 7h4v3H9V7zM3 7h4v3H3V7zm3 10.25c-.69 0-1.25-.56-1.25-1.25s.56-1.25 1.25-1.25 1.25.56 1.25 1.25-.56 1.25-1.25 1.25zm12 0c-.69 0-1.25-.56-1.25-1.25s.56-1.25 1.25-1.25 1.25.56 1.25 1.25-.56 1.25-1.25 1.25zM21 14h-.78c-.55-.61-1.34-1-2.22-1s-1.67.39-2.22 1H8.22c-.55-.61-1.33-1-2.22-1s-1.67.39-2.22 1H3v-2h18v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-flash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M13.42,16.24l2.55,2.55L15.96,20H4v-8.6h3.02l0.59-0.65l0.15-0.16l1.5,1.5C7.68,12.43,6.5,13.82,6.5,15.5 c0,1.93,1.57,3.5,3.5,3.5C11.68,19,13.07,17.82,13.42,16.24z M16,13.17l0-1.77h-1.77L16,13.17z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M20.4,5.6H22L19,11V7h-1V2h4L20.4,5.6z M16,11.4v1.77l2,2V11c0-0.88-0.72-1.6-1.6-1.6h-2.54L12.58,8h-1.75l3.4,3.4H16z M17.97,17.97L2.1,2.1L0.69,3.51l5.66,5.66L6.14,9.4H3.6C2.72,9.4,2,10.12,2,11v9.4C2,21.28,2.72,22,3.6,22h12.8 c0.75,0,1.38-0.52,1.55-1.22l2.54,2.54l1.41-1.41L17.97,17.97z M11.5,15.5c0,0.83-0.67,1.5-1.5,1.5s-1.5-0.67-1.5-1.5 S9.17,14,10,14S11.5,14.67,11.5,15.5z M15.96,20H4v-8.6h2.14h0.88l0.59-0.65l0.15-0.16l1.5,1.5C7.68,12.43,6.5,13.82,6.5,15.5 c0,1.93,1.57,3.5,3.5,3.5c1.68,0,3.07-1.18,3.42-2.76l2.55,2.55L15.96,20z",
     :stroke nil,
     :fill nil})
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))))


(helix.core/defnc
 backpack
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M18,20H6V8c0-1.1,0.9-2,2-2h8c1.1,0,2,0.9,2,2V20z M7.5,12v2h7v2h2v-4H7.5z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M17,4.14V2h-3v2h-4V2H7v2.14C5.28,4.59,4,6.14,4,8v12c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V8C20,6.14,18.72,4.59,17,4.14z M18,20H6V8c0-1.1,0.9-2,2-2h8c1.1,0,2,0.9,2,2V20z M7.5,12v2h7v2h2v-4H7.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bungalow
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,6.78l-3,4.8V19h2v-3h2v3h2v-7.42L12,6.78z M13,14h-2v-2h2V14z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M13,14h-2v-2h2V14z M18.1,16.56L17,14.79V21H7v-6.2l-1.1,1.76L4.2,15.5L12,3l7.8,12.5L18.1,16.56z M15,11.59l-3-4.8l-3,4.8 V19h2v-3h2v3h2V11.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 food-bank
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,5.5l6,4.5v9H6v-9L12,5.5 M11.5,9.5v3H11v-3h-1v3H9.5v-3h-1v3c0,0.83,0.67,1.5,1.5,1.5v4h1v-4 c0.83,0,1.5-0.67,1.5-1.5v-3H11.5z M13,11.5v3h1V18h1V9.5C13.9,9.5,13,10.4,13,11.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,5.5l6,4.5v9H6v-9L12,5.5 M12,3L4,9v12h16V9L12,3L12,3z M11.5,9.5v3H11v-3h-1v3H9.5v-3h-1v3c0,0.83,0.67,1.5,1.5,1.5v4h1 v-4c0.83,0,1.5-0.67,1.5-1.5v-3H11.5z M13,11.5v3h1V18h1V9.5C13.9,9.5,13,10.4,13,11.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 kitchen
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M8 5h2v3H8zm0 7h2v5H8zm-2 8h12v-9.02H6V20zm2-8h2v5H8v-5zM6 9h12V4H6v5zm2-4h2v3H8V5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18 2.01 6 2a2 2 0 00-2 2v16c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.11-.9-1.99-2-1.99zM18 20H6v-9.02h12V20zm0-11H6V4h12v5zM8 5h2v3H8zm0 7h2v5H8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 elevator
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M19,5v14H5V5H19 M10,18v-4h1v-2.5c0-1.1-0.9-2-2-2H8c-1.1,0-2,0.9-2,2V14h1v4H10z M8.5,8.5 c0.69,0,1.25-0.56,1.25-1.25S9.19,6,8.5,6S7.25,6.56,7.25,7.25S7.81,8.5,8.5,8.5z M18,11l-2.5-4L13,11H18z M13,13l2.5,4l2.5-4H13z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M19,5v14H5V5H19 M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3L19,3z M10,18v-4h1 v-2.5c0-1.1-0.9-2-2-2H8c-1.1,0-2,0.9-2,2V14h1v4H10z M8.5,8.5c0.69,0,1.25-0.56,1.25-1.25S9.19,6,8.5,6S7.25,6.56,7.25,7.25 S7.81,8.5,8.5,8.5z M18,11l-2.5-4L13,11H18z M13,13l2.5,4l2.5-4H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 apartment
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,11V3H7v4H3v14h8v-4h2v4h8V11H17z M7,19H5v-2h2V19z M7,15H5v-2h2V15z M7,11H5V9h2V11z M11,15H9v-2h2V15z M11,11H9V9h2 V11z M11,7H9V5h2V7z M15,15h-2v-2h2V15z M15,11h-2V9h2V11z M15,7h-2V5h2V7z M19,19h-2v-2h2V19z M19,15h-2v-2h2V15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 pool
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M22 21c-1.11 0-1.73-.37-2.18-.64-.37-.22-.6-.36-1.15-.36-.56 0-.78.13-1.15.36-.46.27-1.07.64-2.18.64s-1.73-.37-2.18-.64c-.37-.22-.6-.36-1.15-.36-.56 0-.78.13-1.15.36-.46.27-1.08.64-2.19.64s-1.73-.37-2.18-.64c-.37-.23-.6-.36-1.15-.36s-.78.13-1.15.36c-.46.27-1.08.64-2.19.64v-2c.56 0 .78-.13 1.15-.36.46-.27 1.08-.64 2.19-.64s1.73.37 2.18.64c.37.23.59.36 1.15.36.56 0 .78-.13 1.15-.36.46-.27 1.08-.64 2.19-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36s.78-.13 1.15-.36c.45-.27 1.07-.64 2.18-.64s1.73.37 2.18.64c.37.23.59.36 1.15.36v2zm0-4.5c-1.11 0-1.73-.37-2.18-.64-.37-.22-.6-.36-1.15-.36-.56 0-.78.13-1.15.36-.45.27-1.07.64-2.18.64s-1.73-.37-2.18-.64c-.37-.22-.6-.36-1.15-.36-.56 0-.78.13-1.15.36-.45.27-1.07.64-2.18.64s-1.73-.37-2.18-.64c-.37-.22-.6-.36-1.15-.36s-.78.13-1.15.36c-.47.27-1.09.64-2.2.64v-2c.56 0 .78-.13 1.15-.36.45-.27 1.07-.64 2.18-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36.56 0 .78-.13 1.15-.36.45-.27 1.07-.64 2.18-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36s.78-.13 1.15-.36c.45-.27 1.07-.64 2.18-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36v2H22zM8.67 12c.56 0 .78-.13 1.15-.36.46-.27 1.08-.64 2.19-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36s.78-.13 1.15-.36c.12-.07.26-.15.41-.23L10.48 5C8.93 3.45 7.5 2.99 5 3v2.5c1.82-.01 2.89.39 4 1.5l1 1-3.25 3.25c.31.12.56.27.77.39.37.23.59.36 1.15.36z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2.5",
    :opacity ".3",
    :cy "5.5",
    :cx "16.5",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M22 16.5h-.02.02zM10 8l-3.25 3.25c.31.12.56.27.77.39.37.23.59.36 1.15.36s.78-.13 1.15-.36c.46-.27 1.08-.64 2.19-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36.55 0 .78-.13 1.15-.36.12-.07.26-.15.41-.23L10.48 5C8.93 3.45 7.5 2.99 5 3v2.5c1.82-.01 2.89.39 4 1.5l1 1zm-4.65 7.5c.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64s1.73-.37 2.18-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64s1.73-.37 2.18-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.06.63 2.16.64v-2c-.55 0-.78-.14-1.15-.36-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.18.64c-.37.23-.6.36-1.15.36s-.78-.14-1.15-.36c-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.18.64c-.37.23-.59.36-1.15.36-.55 0-.78-.14-1.15-.36-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.18.64c-.37.23-.59.36-1.15.36v2c1.11 0 1.73-.37 2.2-.64.37-.23.6-.36 1.15-.36zM18.67 18c-1.11 0-1.73.37-2.18.64-.37.23-.6.36-1.15.36-.55 0-.78-.14-1.15-.36-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.19.64c-.37.23-.59.36-1.15.36s-.78-.13-1.15-.36c-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.19.64c-.37.23-.59.36-1.15.36v2c1.11 0 1.73-.37 2.19-.64.37-.23.6-.36 1.15-.36.55 0 .78.13 1.15.36.45.27 1.07.64 2.18.64s1.73-.37 2.19-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64s1.72-.37 2.18-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64v-2c-.56 0-.78-.13-1.15-.36-.45-.27-1.07-.64-2.18-.64z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2.5", :cy "5.5", :cx "16.5", :stroke nil, :fill nil})))


(helix.core/defnc
 stairs
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M19,5v14H5V5H19 M18,6h-4.42v3.33H11v3.33H8.42V16H6v2h4.42v-3.33H13v-3.33h2.58V8H18V6z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M19,5v14H5V5H19 M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3L19,3z M18,6h-4.42 v3.33H11v3.33H8.42V16H6v2h4.42v-3.33H13v-3.33h2.58V8H18V6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 no-meeting-room
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12 5H8.12L12 8.88V6zM7 19h5v-4.46l-5-5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 5v3.88l2 2V6h3v7.88l2 2V4h-5V3H6.12l2 2zM2.41 2.13L1 3.54l4 4V19H3v2h11v-4.46L20.46 23l1.41-1.41L2.41 2.13zM12 19H7V9.54l5 5V19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wheelchair-pickup
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M4.5,4c0-1.11,0.89-2,2-2s2,0.89,2,2s-0.89,2-2,2S4.5,5.11,4.5,4z M10,10.95V9c0-1.1-0.9-2-2-2H5C3.9,7,3,7.9,3,9v6h2v7 h3.5v-0.11c-1.24-1.26-2-2.99-2-4.89C6.5,14.42,7.91,12.16,10,10.95z M16.5,17c0,1.65-1.35,3-3,3s-3-1.35-3-3 c0-1.11,0.61-2.06,1.5-2.58v-2.16C9.98,12.9,8.5,14.77,8.5,17c0,2.76,2.24,5,5,5s5-2.24,5-5H16.5z M19.54,14H15V8h-2v8h5.46 l2.47,3.71l1.66-1.11L19.54,14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 chalet
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/polygon
   {:points
    "13,18 11,18 11,15 9,15 9,18 7,18 7,13.33 10,10.33 13,13.33",
    :opacity ".3",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17.5,15L10,7.5L2.5,15l1.41,1.41L5,15.33V20h10v-4.67l1.09,1.09L17.5,15z M13,18h-2v-3H9v3H7v-4.67l3-3l3,3V18z M22,7.5 h-1.19l0.75,0.75l-0.71,0.71L19.39,7.5H18.5v0.89l1.45,1.45l-0.71,0.71L18.5,9.81V11h-1V9.81l-0.75,0.75l-0.71-0.71l1.45-1.45V7.5 h-0.89l-1.45,1.45l-0.71-0.71l0.75-0.75H14v-1h1.19l-0.75-0.75l0.71-0.71l1.45,1.45h0.89V5.61l-1.45-1.45l0.71-0.71l0.75,0.75V3h1 v1.19l0.75-0.75l0.71,0.71L18.5,5.61V6.5h0.89l1.45-1.45l0.71,0.71L20.81,6.5H22V7.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 holiday-village
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M8,6.83l-4,4V18h3v-3h2v3h3v-7.17L8,6.83z M9,13H7v-2h2V13z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8,4l-6,6v10h12V10L8,4z M12,18H9v-3H7v3H4v-7.17l4-4l4,4V18z M9,13H7v-2h2V13z M18,20V8.35L13.65,4h-2.83L16,9.18V20H18z M22,20V6.69L19.31,4h-2.83L20,7.52V20H22z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crib
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M18,14H6V8c0-1.1,0.9-2,2-2h2v5h8V14z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18,9h-6V4H8C5.79,4,4,5.79,4,8v6c0,1.1,0.9,2,2,2h2v2.93c-0.61-0.35-1.16-0.78-1.65-1.27l-1.42,1.42 C6.74,20.88,9.24,22,12,22c2.76,0,5.26-1.12,7.07-2.93l-1.42-1.42c-0.49,0.49-1.05,0.92-1.65,1.27V16h2c1.1,0,2-0.9,2-2v-3 C20,9.9,19.1,9,18,9z M14,19.75C13.36,19.91,12.69,20,12,20c-0.69,0-1.36-0.09-2-0.25V16h4V19.75z M18,14H6V8c0-1.1,0.9-2,2-2h2v5h8 V14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 other-houses
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,5.52L6,10.1V19h12v-8.9L12,5.52z M8,15c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1 C9,14.55,8.55,15,8,15z M12,15c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C13,14.55,12.55,15,12,15z M16,15 c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C17,14.55,16.55,15,16,15z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,3L1,11.4l1.21,1.59L4,11.62V21h16v-9.38l1.79,1.36L23,11.4L12,3z M18,19H6v-8.9l6-4.58l6,4.58V19z M9,14 c0,0.55-0.45,1-1,1s-1-0.45-1-1c0-0.55,0.45-1,1-1S9,13.45,9,14z M12,13c0.55,0,1,0.45,1,1c0,0.55-0.45,1-1,1s-1-0.45-1-1 C11,13.45,11.45,13,12,13z M15,14c0-0.55,0.45-1,1-1s1,0.45,1,1c0,0.55-0.45,1-1,1S15,14.55,15,14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vaping-rooms
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/circle
    {:r ".5",
     :opacity ".3",
     :cy "17.5",
     :cx "10.5",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M2,16.5h1c1.33,0,2.71-0.18,4-0.5v3c-1.29-0.32-2.67-0.5-4-0.5H2V16.5z M22,16v3H8v-3H22z M11,17.5 c0-0.28-0.22-0.5-0.5-0.5S10,17.22,10,17.5c0,0.28,0.22,0.5,0.5,0.5S11,17.78,11,17.5z M22,12.76V15h-1.5v-2.23 c0-2.24-1.76-4.07-4-4.07V7.2c1.02,0,1.85-0.83,1.85-1.85S17.52,3.5,16.5,3.5V2c1.85,0,3.35,1.5,3.35,3.35c0,0.93-0.38,1.77-1,2.38 C20.72,8.62,22,10.54,22,12.76z M19.5,13.36V15H18v-1.3c0-1.31-0.92-2.05-1.97-2.05H14.5c-1.85,0-3.35-1.5-3.35-3.35 s1.5-3.35,3.35-3.35v1.5c-1.02,0-1.85,0.73-1.85,1.75s0.83,2,1.85,2h1.53C17.9,10.2,19.5,11.55,19.5,13.36z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fitness-center
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.57 14.86L22 13.43 20.57 12 17 15.57 8.43 7 12 3.43 10.57 2 9.14 3.43 7.71 2 5.57 4.14 4.14 2.71 2.71 4.14l1.43 1.43L2 7.71l1.43 1.43L2 10.57 3.43 12 7 8.43 15.57 17 12 20.57 13.43 22l1.43-1.43L16.29 22l2.14-2.14 1.43 1.43 1.43-1.43-1.43-1.43L22 16.29l-1.43-1.43z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-forward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8-8-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 subdirectory-arrow-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 24H0V0h24v24z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 15l-6 6-1.42-1.42L15.17 16H4V4h2v10h9.17l-3.59-3.58L13 9l6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cancel
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8zm5 11.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm3.59-13L12 10.59 8.41 7 7 8.41 10.59 12 7 15.59 8.41 17 12 13.41 15.59 17 17 15.59 13.41 12 17 8.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 expand-less
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14l-6-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 payments
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:opacity ".3",
     :d
     "M17 6H3v8h14V6zm-7 7c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3z",
     :stroke nil,
     :fill nil})
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17 4H3c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zM3 14V6h14v8H3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M10 7c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z",
      :stroke nil,
      :fill nil}))
   (helix.dom/path
    {:d "M23 7v11c0 1.1-.9 2-2 2H4v-2h17V7h2z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 arrow-drop-down
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M7 10l5 5 5-5H7z", :stroke nil, :fill nil})))


(helix.core/defnc
 arrow-downward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 12l-1.41-1.41L13 16.17V4h-2v12.17l-5.58-5.59L4 12l8 8 8-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unfold-less
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 0v24H0V0h24z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.41 18.59L8.83 20 12 16.83 15.17 20l1.41-1.41L12 14l-4.59 4.59zm9.18-13.18L15.17 4 12 7.17 8.83 4 7.41 5.41 12 10l4.59-4.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 close
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 last-page
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.59 7.41L10.18 12l-4.59 4.59L7 18l6-6-6-6-1.41 1.41zM16 6h2v12h-2V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 north
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M5,9l1.41,1.41L11,5.83V22H13V5.83l4.59,4.59L19,9l-7-7L5,9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 maps-home-work
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17,11h2v2h-2v2h2v2h-2v2h4V5h-9v1.4l5,3.57V11z M17,7h2v2h-2V7z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "10,3 10,4.97 10.96,5.66 12,6.4 12,5 21,5 21,19 17,19 17,21 23,21 23,3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "3,12 3,19 5,19 5,14 11,14 11,19 13,19 13,12 8,8.5",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7",
      :x "17",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11",
      :x "17",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "17",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1,11v10h6v-5h2v5h6V11L8,6L1,11z M13,19h-2v-5H5v5H3v-7l5-3.5l5,3.5V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 pivot-table-chart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M21,5c0-1.1-0.9-2-2-2h-9v5h11V5z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M3,19c0,1.1,0.9,2,2,2h3V10H3V19z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M3,5v3h5V3H5C3.9,3,3,3.9,3,5z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M18,9l-4,4h3v2c0,1.1-0.9,2-2,2h-2v-3l-4,4l4,4v-3h2c2.21,0,4-1.79,4-4v-2h3L18,9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 arrow-drop-up
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M7 14l5-5 5 5H7z", :stroke nil, :fill nil})))


(helix.core/defnc
 fullscreen-exit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 16h3v3h2v-5H5v2zm3-8H5v2h5V5H8v3zm6 11h2v-3h3v-2h-5v5zm2-11V5h-2v5h5V8h-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 subdirectory-arrow-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 9l1.42 1.42L8.83 14H18V4h2v12H8.83l3.59 3.58L11 21l-6-6 6-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 refresh
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 apps-outage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M4,8h4V4H4V8z M10,20h4v-4h-4V20z M4,20h4v-4H4V20z M4,14h4v-4H4V14z M10,14h4v-4h-4V14z M16,20h4v-4h-4V20z M19,0 c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S21.76,0,19,0z M19.5,8h-1V7h1V8z M19.5,6h-1V2h1V6z M16,14h4v-2.07 C19.67,11.98,19.34,12,19,12c-1.07,0-2.09-0.24-3-0.68V14z M10,4v4h2.68C12.24,7.09,12,6.07,12,5c0-0.34,0.02-0.67,0.07-1H10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 expand-more
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 24H0V0h24v24z", :stroke nil})
  (helix.dom/path
   {:d "M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6-1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 app-settings-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "20",
      :x "7",
      :width "10",
      :height "1",
      :fill "none",
      :stroke nil})
    (helix.dom/rect
     {:y "3",
      :x "7",
      :width "10",
      :height "1",
      :fill "none",
      :stroke nil})
    (helix.dom/path
     {:d
      "M21.81,12.74l-0.82-0.63c0-0.09,0-0.13,0-0.22l0.8-0.63c0.16-0.12,0.2-0.34,0.1-0.51l-0.85-1.48 c-0.07-0.13-0.21-0.2-0.35-0.2c-0.05,0-0.1,0.01-0.15,0.03l-0.95,0.38c-0.08-0.05-0.11-0.07-0.19-0.11l-0.15-1.01 C19.22,8.15,19.05,8,18.85,8h-1.71c-0.2,0-0.37,0.15-0.4,0.34L16.6,9.35c-0.03,0.02-0.07,0.03-0.1,0.05 c-0.03,0.02-0.06,0.04-0.09,0.06l-0.95-0.38c-0.05-0.02-0.1-0.03-0.15-0.03c-0.14,0-0.27,0.07-0.35,0.2l-0.85,1.48 c-0.1,0.17-0.06,0.39,0.1,0.51l0.8,0.63c0,0.09,0,0.13,0,0.23l-0.8,0.63c-0.16,0.12-0.2,0.34-0.1,0.51l0.85,1.48 c0.07,0.13,0.21,0.2,0.35,0.2c0.05,0,0.1-0.01,0.15-0.03l0.95-0.37c0.08,0.05,0.12,0.07,0.2,0.11l0.15,1.01 c0.03,0.2,0.2,0.34,0.4,0.34h1.71c0.2,0,0.37-0.15,0.4-0.34l0.15-1.01c0.03-0.02,0.07-0.03,0.1-0.05 c0.03-0.02,0.06-0.04,0.09-0.06l0.95,0.38c0.05,0.02,0.1,0.03,0.15,0.03c0.14,0,0.27-0.07,0.35-0.2l0.85-1.48 C22.01,13.08,21.97,12.86,21.81,12.74z M18,13.5c-0.83,0-1.5-0.67-1.5-1.5c0-0.83,0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5 C19.5,12.83,18.83,13.5,18,13.5z M17,18H7V6h10v1h2V3c0-1.1-0.9-2-2-2H7C5.9,1,5,1.9,5,3v18c0,1.1,0.9,2,2,2h10c1.1,0,2-0.9,2-2 v-4h-2V18z M7,3h10v1H7V3z M17,21H7v-1h10V21z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "3",
      :x "7",
      :width "10",
      :opacity ".3",
      :height "1",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "20",
      :x "7",
      :width "10",
      :opacity ".3",
      :height "1",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 arrow-drop-down-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8zm0 11l-4-4h8l-4 4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-5l4-4H8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unfold-more
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5.83L15.17 9l1.41-1.41L12 3 7.41 7.59 8.83 9 12 5.83zm0 12.34L8.83 15l-1.41 1.41L12 21l4.59-4.59L15.17 15 12 18.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-home-work
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,5v1.4l5,3.57v1.11c0.33-0.05,0.66-0.08,1-0.08c1.08,0,2.09,0.25,3,0.68V5H12z M19,9h-2V7h2V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M12,5h9v6.68c0.75,0.36,1.43,0.84,2,1.42V3H10v1.97l2,1.43V5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7",
      :x "17",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,6l-7,5v10h6v-5h2v5h2.68C11.25,20.09,11,19.08,11,18v-4H5v5H3v-6.97l5-3.57l5,3.57v1.08c0.57-0.59,1.25-1.07,2-1.42V11 L8,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M8,8.46l-5,3.57V19h2v-5h6v4c0-1.91,0.76-3.63,2-4.89v-1.08L8,8.46z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,13c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,13,18,13z M21,18.5h-2.5V21h-1v-2.5H15v-1h2.5V15h1v2.5H21V18.5z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 offline-share
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d "M6,5H4v16c0,1.1,0.9,2,2,2h10v-2H6V5z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1h-8C8.9,1,8,1.9,8,3v14c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V3C20,1.9,19.1,1,18,1z M18,17h-8v-1h8V17z M18,14h-8V6h8 V14z M18,4h-8V3h8V4z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12.5,10.25h2V12L17,9.5L14.5,7v1.75H12c-0.55,0-1,0.45-1,1V12h1.5V10.25z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 arrow-forward-ios
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points "6.23,20.23 8,22 18,12 8,2 6.23,3.77 14.46,12",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 chevron-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12l4.58-4.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 east
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15,5l-1.41,1.41L18.17,11H2V13h16.17l-4.59,4.59L15,19l7-7L15,5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 legend-toggle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M20,15H4v-2h16V15z M20,17H4v2h16V17z M15,11l5-3.55L20,5l-5,3.55L10,5L4,8.66L4,11l5.92-3.61L15,11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 menu-open
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3,18h13v-2H3V18z M3,13h10v-2H3V13z M3,6v2h13V6H3z M21,15.59L17.42,12L21,8.41L19.59,7l-5,5l5,5L21,15.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 switch-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/polyline
   {:points "8.5,8.62 8.5,15.38 5.12,12 8.5,8.62",
    :opacity ".3",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8.5,8.62v6.76L5.12,12L8.5,8.62 M10,5l-7,7l7,7V5L10,5z M14,5v14l7-7L14,5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 switch-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24",
    :transform "matrix(-1 -1.224647e-16 1.224647e-16 -1 24 24)",
    :height "24",
    :fill "none",
    :stroke nil})
  (helix.dom/polyline
   {:points "15.5,15.38 15.5,8.62 18.88,12 15.5,15.38",
    :opacity ".3",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15.5,15.38V8.62L18.88,12L15.5,15.38 M14,19l7-7l-7-7V19L14,19z M10,19V5l-7,7L10,19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 double-arrow
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "15.5,5 11,5 16,12 11,19 15.5,19 20.5,12",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,5 4,5 9,12 4,19 8.5,19 13.5,12",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 home-work
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17,11h2v2h-2v2h2v2h-2v2h4V5h-9v1.4l5,3.57V11z M17,7h2v2h-2V7z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "10,3 10,4.97 10.96,5.66 12,6.4 12,5 21,5 21,19 17,19 17,21 23,21 23,3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "3,12 3,19 5,19 5,14 11,14 11,19 13,19 13,12 8,8.5",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7",
      :x "17",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11",
      :x "17",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "17",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1,11v10h6v-5h2v5h6V11L8,6L1,11z M13,19h-2v-5H5v5H3v-7l5-3.5l5,3.5V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 north-east
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M9,5v2h6.59L4,18.59L5.41,20L17,8.41V15h2V5H9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-back
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-back-ios
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.51 3.87L15.73 2.1 5.84 12l9.9 9.9 1.77-1.77L9.38 12l8.13-8.13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 menu
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 campaign
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/path
   {:d
    "M18,11c0,0.67,0,1.33,0,2c1.2,0,2.76,0,4,0c0-0.67,0-1.33,0-2C20.76,11,19.2,11,18,11z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16,17.61c0.96,0.71,2.21,1.65,3.2,2.39c0.4-0.53,0.8-1.07,1.2-1.6c-0.99-0.74-2.24-1.68-3.2-2.4 C16.8,16.54,16.4,17.08,16,17.61z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20.4,5.6C20,5.07,19.6,4.53,19.2,4c-0.99,0.74-2.24,1.68-3.2,2.4c0.4,0.53,0.8,1.07,1.2,1.6 C18.16,7.28,19.41,6.35,20.4,5.6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4,9c-1.1,0-2,0.9-2,2v2c0,1.1,0.9,2,2,2h1v4h2v-4h1l5,3V6L8,9H4z M9.03,10.71L11,9.53v4.94l-1.97-1.18L8.55,13H8H4v-2h4 h0.55L9.03,10.71z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15.5,12c0-1.33-0.58-2.53-1.5-3.35v6.69C14.92,14.53,15.5,13.33,15.5,12z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M9.03,10.71L11,9.53v4.94l-1.97-1.18L8.55,13H8H4v-2h4h0.55L9.03,10.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 south
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,15l-1.41-1.41L13,18.17V2H11v16.17l-4.59-4.59L5,15l7,7L19,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 south-west
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M15,19v-2H8.41L20,5.41L18.59,4L7,15.59V9H5v10H15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 more-horiz
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 waterfall-chart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,4h3v16h-3V4z M3,13h3v7H3V13z M14,4h3v3h-3V4z M10,5h3v4h-3V5z M7,10h3v4H7V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 expand-circle-down
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,4c-4.42,0-8,3.58-8,8s3.58,8,8,8s8-3.58,8-8S16.42,4,12,4z M12,15.5L7.5,11l1.42-1.41L12,12.67l3.08-3.08 L16.5,11L12,15.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15.08,9.59L12,12.67L8.92,9.59L7.5,11l4.5,4.5l4.5-4.5L15.08,9.59z M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10 s10-4.48,10-10C22,6.48,17.52,2,12,2z M12,20c-4.42,0-8-3.58-8-8s3.58-8,8-8s8,3.58,8,8S16.42,20,12,20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 assistant-direction
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,3c-4.99,0-9,4.01-9,9s4.01,9,9,9s9-4.01,9-9S16.99,3,12,3z M12.54,19.8c-0.35,0.27-0.79,0.27-1.15,0 L4.2,12.58c-0.27-0.36-0.27-0.8,0-1.16l7.19-7.22c0.35-0.27,0.79-0.27,1.15,0l7.19,7.22c0.36,0.27,0.36,0.8,0,1.16L12.54,19.8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,1C5.9,1,1,5.9,1,12s4.9,11,11,11s11-4.9,11-11S18.1,1,12,1z M12,21c-4.99,0-9-4.01-9-9s4.01-9,9-9s9,4.01,9,9 S16.99,21,12,21z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.73,11.42L12.54,4.2c-0.36-0.27-0.8-0.27-1.15,0L4.2,11.42c-0.27,0.36-0.27,0.8,0,1.16l7.19,7.22 c0.36,0.27,0.8,0.27,1.15,0l7.19-7.22C20.09,12.22,20.09,11.69,19.73,11.42z M13.5,14.5V12H10v3H8v-4c0-0.6,0.4-1,1-1h4.5V7.5 L17,11L13.5,14.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 west
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M9,19l1.41-1.41L5.83,13H22V11H5.83l4.59-4.59L9,5l-7,7L9,19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fullscreen
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 check
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 apps
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-upward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M4 12l1.41 1.41L11 7.83V20h2V7.83l5.58 5.59L20 12l-8-8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 more-vert
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 0v24H0V0h24z", :stroke nil})
  (helix.dom/path {:d "M14 7l-5 5 5 5V7z", :stroke nil, :fill nil})))


(helix.core/defnc
 south-east
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M19,9h-2v6.59L5.41,4L4,5.41L15.59,17H9v2h10V9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 north-west
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M5,15h2V8.41L18.59,20L20,18.59L8.41,7H15V5H5V15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 first-page
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 0v24H0V0h24z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.41 16.59L13.82 12l4.59-4.59L17 6l-6 6 6 6 1.41-1.41zM6 6h2v12H6V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-back-ios-new
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points "17.77,3.77 16,2 6,12 16,22 17.77,20.23 9.54,12",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 arrow-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M10 17l5-5-5-5v10z", :stroke nil, :fill nil})))


(helix.core/defnc
 chevron-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6-6-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 biotech
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "4.54",
      :x "12.75",
      :width "1",
      :transform "matrix(0.9397 -0.342 0.342 0.9397 -1.6091 4.9556)",
      :opacity ".3",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1",
      :opacity ".3",
      :cy "8",
      :cx "10.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7,19c-1.1,0-2,0.9-2,2h14c0-1.1-0.9-2-2-2h-4v-2h3c1.1,0,2-0.9,2-2h-8c-1.66,0-3-1.34-3-3c0-1.09,0.59-2.04,1.47-2.57 c0.41,0.59,1.06,1,1.83,1.06c0.7,0.06,1.36-0.19,1.85-0.62l0.59,1.61l0.94-0.34l0.34,0.94l1.88-0.68l-0.34-0.94l0.94-0.34 L13.76,2.6l-0.94,0.34L12.48,2L10.6,2.68l0.34,0.94L10,3.97l0.56,1.55C9.39,5.48,8.37,6.27,8.08,7.38C6.27,8.14,5,9.92,5,12 c0,2.76,2.24,5,5,5v2H7z M12.86,4.52l1.71,4.7l-0.94,0.34l-1.71-4.7L12.86,4.52z M10.5,7c0.55,0,1,0.45,1,1c0,0.55-0.45,1-1,1 c-0.55,0-1-0.45-1-1C9.5,7.45,9.95,7,10.5,7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 insights
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,8c-1.45,0-2.26,1.44-1.93,2.51l-3.55,3.56c-0.3-0.09-0.74-0.09-1.04,0l-2.55-2.55C12.27,10.45,11.46,9,10,9 c-1.45,0-2.27,1.44-1.93,2.52l-4.56,4.55C2.44,15.74,1,16.55,1,18c0,1.1,0.9,2,2,2c1.45,0,2.26-1.44,1.93-2.51l4.55-4.56 c0.3,0.09,0.74,0.09,1.04,0l2.55,2.55C12.73,16.55,13.54,18,15,18c1.45,0,2.27-1.44,1.93-2.52l3.56-3.55 C21.56,12.26,23,11.45,23,10C23,8.9,22.1,8,21,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "15,9 15.94,6.93 18,6 15.94,5.07 15,3 14.08,5.07 12,6 14.08,6.93",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "3.5,11 4,9 6,8.5 4,8 3.5,6 3,8 1,8.5 3,9",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shield
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M6,6.39v4.7c0,4,2.55,7.7,6,8.83c3.45-1.13,6-4.82,6-8.83v-4.7l-6-2.25L6,6.39 z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2L4,5v6.09c0,5.05,3.41,9.76,8,10.91c4.59-1.15,8-5.86,8-10.91V5L12,2z M18,11.09c0,4-2.55,7.7-6,8.83 c-3.45-1.13-6-4.82-6-8.83v-4.7l6-2.25l6,2.25V11.09z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flag
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12.36 6H7v6h7.24l.4 2H18V8h-5.24z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M14.4 6L14 4H5v17h2v-7h5.6l.4 2h7V6h-5.6zm3.6 8h-3.36l-.4-2H7V6h5.36l.4 2H18v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flag-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d
       "M12,4c-4.41,0-8,3.59-8,8s3.59,8,8,8s8-3.59,8-8S16.41,4,12,4z M13,15l-1-2H9.5v5H8V7h6l1,2h3v6H13z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-4.41,0-8-3.59-8-8s3.59-8,8-8s8,3.59,8,8 S16.41,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15,9l-1-2H8v11h1.5v-5H12l1,2h5V9H15z M16.5,13.5h-2.57l-1-2H9.5v-3h3.57l1,2h2.43V13.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 save-as
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M16.17,5H5v14h9.4l4.6-4.6V7.83L16.17,5z M12,18c-1.66,0-3-1.34-3-3s1.34-3,3-3s3,1.34,3,3S13.66,18,12,18z M15,10H6V6h9V10z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M21,12.4V7l-4-4H5C3.89,3,3,3.9,3,5v14c0,1.1,0.89,2,2,2h7.4l2-2H5V5h11.17L19,7.83v6.57L21,12.4z M15,15 c0,1.66-1.34,3-3,3s-3-1.34-3-3s1.34-3,3-3S15,13.34,15,15z M6,6h9v4H6V6z M19.99,16.25l1.77,1.77L16.77,23H15v-1.77L19.99,16.25z M23.25,16.51l-0.85,0.85l-1.77-1.77l0.85-0.85c0.2-0.2,0.51-0.2,0.71,0l1.06,1.06C23.45,16,23.45,16.32,23.25,16.51z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 font-download
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 20h16V4H4v16zm7.07-14.5h1.86l5.11 13h-2.09l-1.14-3H9.17l-1.12 3H5.96l5.11-13zM12 7.98L9.93 13.5h4.14z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9.17 15.5h5.64l1.14 3h2.09l-5.11-13h-1.86l-5.11 13h2.09l1.12-3zM12 7.98l2.07 5.52H9.93L12 7.98zM20 2H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 18H4V4h16v16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 copy-all
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/rect
   {:y "4",
    :x "9",
    :width "9",
    :opacity ".3",
    :height "12",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18,2H9C7.9,2,7,2.9,7,4v12c0,1.1,0.9,2,2,2h9c1.1,0,2-0.9,2-2V4C20,2.9,19.1,2,18,2z M18,16H9V4h9V16z M3,15v-2h2v2H3z M3,9.5h2v2H3V9.5z M10,20h2v2h-2V20z M3,18.5v-2h2v2H3z M5,22c-1.1,0-2-0.9-2-2h2V22z M8.5,22h-2v-2h2V22z M13.5,22L13.5,22l0-2h2 v0C15.5,21.1,14.6,22,13.5,22z M5,6L5,6l0,2H3v0C3,6.9,3.9,6,5,6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 font-download-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M10.35,7.52L10.92,6h2.14l2.55,6.79L20,17.17V4H6.83L10.35,7.52z M12.58,9.75l-0.54-1.52h-0.1l-0.23,0.66 L12.58,9.75z M17.17,20l-5.07-5.07H9.58L8.49,18H6.41l2.39-6.37L4,6.83V20H17.17z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4.83,2H20c1.1,0,2,0.9,2,2v15.17l-2-2V4H6.83L4.83,2z M10.92,6l-0.57,1.52l1.36,1.36l0.23-0.66h0.1l0.54,1.52l3.04,3.04 L13.07,6H10.92z M20.49,23.31L19.17,22H4c-1.1,0-2-0.9-2-2V4.83L0.69,3.51L2.1,2.1l19.8,19.8L20.49,23.31z M17.17,20l-5.07-5.07 H9.58L8.49,18H6.41l2.39-6.37L4,6.83V20H17.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M19 13H5v-2h14v2z", :stroke nil, :fill nil})))


(helix.core/defnc
 add-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4zm-1-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dynamic-feed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "7",
     :x "12",
     :width "8",
     :opacity ".3",
     :height "4",
     :stroke nil,
     :fill nil})
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M8,8H6v7c0,1.1,0.9,2,2,2h9v-2H8V8z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M20,3h-8c-1.1,0-2,0.9-2,2v6c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V5C22,3.9,21.1,3,20,3z M20,11h-8V7h8V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M4,12H2v7c0,1.1,0.9,2,2,2h9v-2H4V12z",
      :stroke nil,
      :fill nil})))
  (helix.dom/g
   {:display "none"}
   (helix.dom/rect
    {:y "7",
     :x "12",
     :width "8",
     :opacity ".3",
     :height "4",
     :display "inline",
     :stroke nil,
     :fill nil})
   (helix.dom/g {:display "inline"})
   (helix.dom/g
    {:display "inline"}
    (helix.dom/path
     {:d "M8,8H6v7c0,1.1,0.9,2,2,2h9v-2H8V8z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M20,3h-8c-1.1,0-2,0.9-2,2v6c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V5C22,3.9,21.1,3,20,3z M20,11h-8V7h8V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M4,12H2v7c0,1.1,0.9,2,2,2h9v-2H4V12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 select-all
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5h2V3c-1.1 0-2 .9-2 2zm0 8h2v-2H3v2zm4 8h2v-2H7v2zM3 9h2V7H3v2zm10-6h-2v2h2V3zm6 0v2h2c0-1.1-.9-2-2-2zM5 21v-2H3c0 1.1.9 2 2 2zm-2-4h2v-2H3v2zM9 3H7v2h2V3zm2 18h2v-2h-2v2zm8-8h2v-2h-2v2zm0 8c1.1 0 2-.9 2-2h-2v2zm0-12h2V7h-2v2zm0 8h2v-2h-2v2zm-4 4h2v-2h-2v2zm0-16h2V3h-2v2zM7 17h10V7H7v10zm2-8h6v6H9V9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-copy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M8 7h11v14H8z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 inbox
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12.01 18c-1.48 0-2.75-.81-3.45-2H5v3h14v-3h-3.55c-.69 1.19-1.97 2-3.44 2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5v-3h3.56c.69 1.19 1.97 2 3.45 2s2.75-.81 3.45-2H19v3zm0-5h-5c0 1.1-.9 2-2 2s-2-.9-2-2H5V5h14v9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 weekend
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M21 11c-.55 0-1 .45-1 1v4H4v-4c0-.55-.45-1-1-1s-1 .45-1 1v5c0 .55.45 1 1 1h18c.55 0 1-.45 1-1v-5c0-.55-.45-1-1-1zM6 14h12v-2c0-.88.39-1.67 1-2.22V7c0-.55-.45-1-1-1H6c-.55 0-1 .45-1 1v2.78c.61.55 1 1.34 1 2.22v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 9V7c0-1.65-1.35-3-3-3H6C4.35 4 3 5.35 3 7v2c-1.65 0-3 1.35-3 3v5c0 1.65 1.35 3 3 3h18c1.65 0 3-1.35 3-3v-5c0-1.65-1.35-3-3-3zM5 7c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v2.78c-.61.55-1 1.34-1 2.22v2H6v-2c0-.88-.39-1.67-1-2.22V7zm17 10c0 .55-.45 1-1 1H3c-.55 0-1-.45-1-1v-5c0-.55.45-1 1-1s1 .45 1 1v4h16v-4c0-.55.45-1 1-1s1 .45 1 1v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 inventory-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "4,7 20,7 20,3.98 4,4",
      :opacity ".3",
      :enable-background "new",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d "M5,20h14V9H5V20z M9,12h6v2H9V12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C3,2,2,2.9,2,4v3.01C2,7.73,2.43,8.35,3,8.7V20c0,1.1,1.1,2,2,2h14c0.9,0,2-0.9,2-2V8.7c0.57-0.35,1-0.97,1-1.69V4 C22,2.9,21,2,20,2z M19,20H5V9h14V20z M20,7H4V4l16-0.02V7z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "9",
      :width "6",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 push-pin
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M14,4h-4v5c0,1.1-0.35,2.14-1,3h6c-0.63-0.84-1-1.88-1-3V4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,12c-1.66,0-3-1.34-3-3V4l1,0c0,0,0,0,0,0c0.55,0,1-0.45,1-1s-0.45-1-1-1H7C6.45,2,6,2.45,6,3s0.45,1,1,1c0,0,0,0,0,0 l1,0v5c0,1.66-1.34,3-3,3v2h5.97v7l1,1l1-1v-7H19L19,12C19,12,19,12,19,12z M9,12c0.65-0.86,1-1.9,1-3V4h4v5c0,1.12,0.37,2.16,1,3 H9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 calculate
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M13.03,7.06L14.09,6l1.41,1.41L16.91,6l1.06,1.06l-1.41,1.41l1.41,1.41l-1.06,1.06 L15.5,9.54l-1.41,1.41l-1.06-1.06l1.41-1.41L13.03,7.06z M13,13.25h5v1.5h-5V13.25z M13,15.75h5v1.5h-5V15.75z M6.25,7.72h5v1.5 h-5V7.72z M6,14.5h2v-2h1.5v2h2V16h-2v2H8v-2H6V14.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7.72",
      :x "6.25",
      :width "5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15.75",
      :x "13",
      :width "5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "13.25",
      :x "13",
      :width "5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8,18 9.5,18 9.5,16 11.5,16 11.5,14.5 9.5,14.5 9.5,12.5 8,12.5 8,14.5 6,14.5 6,16 8,16",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.09,10.95 15.5,9.54 16.91,10.95 17.97,9.89 16.56,8.47 17.97,7.06 16.91,6 15.5,7.41 14.09,6 13.03,7.06 14.44,8.47 13.03,9.89",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 archive
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 19h14V8H5v11zm5.55-6v-3h2.91v3H16l-4 4-4-4h2.55z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16 13h-2.55v-3h-2.9v3H8l4 4zm4.54-7.77l-1.39-1.68C18.88 3.21 18.47 3 18 3H6c-.47 0-.88.21-1.16.55L3.46 5.23C3.17 5.57 3 6.02 3 6.5V19c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V6.5c0-.48-.17-.93-.46-1.27zM6.24 5h11.52l.81.97H5.44l.8-.97zM19 19H5V8h14v11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sort
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M3 18h6v-2H3v2zM3 6v2h18V6H3zm0 7h12v-2H3v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 how-to-vote
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M5 19h14v1H5z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M18 13h-.68l-2 2h1.91L19 17H5l1.78-2h2.05l-2-2H6l-3 3v4c0 1.1.89 2 1.99 2H19c1.1 0 2-.89 2-2v-4l-3-3zm1 7H5v-1h14v1z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12.048 12.905L8.505 9.362l4.95-4.95 3.543 3.543z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.11 7.25L14.16 2.3c-.38-.4-1.01-.4-1.4-.01L6.39 8.66c-.39.39-.39 1.02 0 1.41l4.95 4.95c.39.39 1.02.39 1.41 0l6.36-6.36c.39-.39.39-1.02 0-1.41zm-7.06 5.65L8.51 9.36l4.95-4.95L17 7.95l-4.95 4.95z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 how-to-reg
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "2", :opacity ".3", :cy "8", :cx "11", :stroke nil, :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 18h4.99L9 17l.93-.94C7.55 16.33 5.2 17.37 5 18z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M11 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0-6c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zm-1 12H5c.2-.63 2.55-1.67 4.93-1.94h.03l.46-.45L12 14.06c-.39-.04-.68-.06-1-.06-2.67 0-8 1.34-8 4v2h9l-2-2zm10.6-5.5l-5.13 5.17-2.07-2.08L12 17l3.47 3.5L22 13.91z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 bolt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11,21h-1l1-7H7.5c-0.88,0-0.33-0.75-0.31-0.78C8.48,10.94,10.42,7.54,13.01,3h1l-1,7h3.51c0.4,0,0.62,0.19,0.4,0.66 C12.97,17.55,11,21,11,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 change-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12,4c4.41,0,8,3.59,8,8s-3.59,8-8,8s-8-3.59-8-8S7.59,4,12,4 M12.06,13.34v2.14 c-0.92,0.02-1.84-0.31-2.54-1.01c-1.12-1.12-1.3-2.8-0.59-4.13l-1.1-1.1c-1.28,1.94-1.07,4.59,0.64,6.29C9.44,16.51,10.72,17,12,17 c0.02,0,0.04,0,0.06,0V19l2.83-2.83L12.06,13.34z M15.54,8.46c-0.99-0.99-2.3-1.46-3.6-1.45V5L9.11,7.83l2.83,2.83V8.51 c0.02,0,0.04,0,0.06,0c0.9,0,1.79,0.34,2.48,1.02c1.12,1.12,1.3,2.8,0.59,4.13l1.1,1.1C17.45,12.82,17.24,10.17,15.54,8.46z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,4c4.41,0,8,3.59,8,8s-3.59,8-8,8s-8-3.59-8-8S7.59,4,12,4 M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10 S17.52,2,12,2L12,2z M12.06,13.34v2.14c-0.92,0.02-1.84-0.31-2.54-1.01c-1.12-1.12-1.3-2.8-0.59-4.13l-1.1-1.1 c-1.28,1.94-1.07,4.59,0.64,6.29C9.44,16.51,10.72,17,12,17c0.02,0,0.04,0,0.06,0V19l2.83-2.83L12.06,13.34z M15.54,8.46 c-0.99-0.99-2.3-1.46-3.6-1.45V5L9.11,7.83l2.83,2.83V8.51c0.02,0,0.04,0,0.06,0c0.9,0,1.79,0.34,2.48,1.02 c1.12,1.12,1.3,2.8,0.59,4.13l1.1,1.1C17.45,12.82,17.24,10.17,15.54,8.46z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-cut
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3l-6 6 2 2 7-7V3zm-9 3c0-2.21-1.79-4-4-4S2 3.79 2 6s1.79 4 4 4c.59 0 1.14-.13 1.64-.36L10 12l-2.36 2.36C7.14 14.13 6.59 14 6 14c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4c0-.59-.13-1.14-.36-1.64L12 14l7 7h3v-1L9.64 7.64c.23-.5.36-1.05.36-1.64zM6 8c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2zm0 12c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2zm6-8.5c.28 0 .5.22.5.5s-.22.5-.5.5-.5-.22-.5-.5.22-.5.5-.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-paste-go
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M10,17c0-3.31,2.69-6,6-6h3V5h-2v3H7V5H5v14h5V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,19H5V5h2v3h10V5h2v6h2V5c0-1.1-0.9-2-2-2h-4.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H5C3.9,3,3,3.9,3,5v14 c0,1.1,0.9,2,2,2h5V19z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S11.45,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "18.01,13 16.59,14.41 18.17,15.99 12,15.99 12,17.99 18.17,17.99 16.59,19.58 18.01,20.99 22,16.99",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 redo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.4 10.6C16.55 8.99 14.15 8 11.5 8c-4.65 0-8.58 3.03-9.96 7.22L3.9 16c1.05-3.19 4.05-5.5 7.6-5.5 1.95 0 3.73.72 5.12 1.88L13 16h9V7l-3.6 3.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-list
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10 18h4v-2h-4v2zM3 6v2h18V6H3zm3 7h12v-2H6v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mail
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M20 6H4l8 4.99zM4 8v10h16V8l-8 5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 2l-8 4.99L4 6h16zm0 12H4V8l8 5 8-5v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 drafts
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12 15.36l-8-5.02V18h16l-.01-7.63z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21.99 8c0-.72-.37-1.35-.94-1.7L12 1 2.95 6.3C2.38 6.65 2 7.28 2 8v10c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2l-.01-10zM12 3.32L19.99 8v.01L12 13 4 8l8-4.68zM4 18v-7.66l8 5.02 7.99-4.99L20 18H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 link-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.39 11L16 12.61V11zM17 7h-4v1.9h4c1.71 0 3.1 1.39 3.1 3.1 0 1.27-.77 2.37-1.87 2.84l1.4 1.4C21.05 15.36 22 13.79 22 12c0-2.76-2.24-5-5-5zM2 4.27l3.11 3.11C3.29 8.12 2 9.91 2 12c0 2.76 2.24 5 5 5h4v-1.9H7c-1.71 0-3.1-1.39-3.1-3.1 0-1.59 1.21-2.9 2.76-3.07L8.73 11H8v2h2.73L13 15.27V17h1.73l4.01 4.01 1.41-1.41L3.41 2.86 2 4.27z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-paste
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M17 7H7V4H5v16h14V4h-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 2h-4.18C14.4.84 13.3 0 12 0S9.6.84 9.18 2H5c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm7 18H5V4h2v3h10V4h2v16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 stream
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "12", :cx "20", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "2", :cy "12", :cx "4", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "2", :cy "20", :cx "12", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "6.13",
      :x "13.74",
      :width "6.22",
      :transform
      "matrix(0.7081 -0.7061 0.7061 0.7081 -0.1146 13.9802)",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8.32,9.68 8.63,10 10.05,8.59 6.03,4.55 6.02,4.55 5.71,4.23 4.29,5.64 8.31,9.69",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "15.41,13.94 14,15.35 17.99,19.36 18.34,19.71 19.76,18.3 15.77,14.29",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8.59,13.95 4.56,17.96 4.24,18.29 5.65,19.7 9.68,15.68 10.01,15.36",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 remove-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8zm5 9H7v-2h10v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M7 11h10v2H7zm5-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 11h10v2H7zm5-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 amp-stories
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/rect
      {:y "6",
       :x "9",
       :width "6",
       :height "11",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d "M7,19h10V4H7V19z M9,6h6v11H9V6z", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "6",
      :x "3",
      :width "2",
      :height "11",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6",
      :x "19",
      :width "2",
      :height "11",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 deselect
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M3,13h2v-2H3V13z M7,21h2v-2H7V21z M13,3h-2v2h2V3z M19,3v2h2C21,3.9,20.1,3,19,3z M5,21v-2H3C3,20.1,3.9,21,5,21z M3,17h2 v-2H3V17z M11,21h2v-2h-2V21z M19,13h2v-2h-2V13z M19,9h2V7h-2V9z M15,5h2V3h-2V5z M7.83,5L7,4.17V3h2v2H7.83z M19.83,17L19,16.17 V15h2v2H19.83z M21.19,21.19L2.81,2.81L1.39,4.22L4.17,7H3v2h2V7.83l2,2V17h7.17l2,2H15v2h2v-1.17l2.78,2.78L21.19,21.19z M9,15 v-3.17L12.17,15H9z M15,12.17V9h-3.17l-2-2H17v7.17L15,12.17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 undo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.5 8c-2.65 0-5.05.99-6.9 2.6L2 7v9h9l-3.62-3.62c1.39-1.16 3.16-1.88 5.12-1.88 3.54 0 6.55 2.31 7.6 5.5l2.37-.78C21.08 11.03 17.15 8 12.5 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-paste-search
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M10,16.5c0-3.58,2.92-6.5,6.5-6.5c0.89,0,1.73,0.18,2.5,0.5V5h-2v3H7V5H5v14h5.5 C10.18,18.23,10,17.39,10,16.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.5,19H5V5h2v3h10V5h2v5.5c0.75,0.31,1.42,0.76,2,1.32V5c0-1.1-0.9-2-2-2h-4.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3 H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h6.82C11.27,20.42,10.81,19.75,10.5,19z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1 S11.45,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.3,18.9c0.4-0.7,0.7-1.5,0.7-2.4c0-2.5-2-4.5-4.5-4.5S12,14,12,16.5s2,4.5,4.5,4.5c0.9,0,1.7-0.3,2.4-0.7l2.7,2.7 l1.4-1.4L20.3,18.9z M16.5,19c-1.4,0-2.5-1.1-2.5-2.5c0-1.4,1.1-2.5,2.5-2.5s2.5,1.1,2.5,2.5C19,17.9,17.9,19,16.5,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 file-copy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M14 7H8v14h11v-9h-5z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm-1 4H8c-1.1 0-1.99.9-1.99 2L6 21c0 1.1.89 2 1.99 2H19c1.1 0 2-.9 2-2V11l-6-6zm4 16H8V7h6v5h5v9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 text-format
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 17v2h14v-2H5zm4.5-4.2h5l.9 2.2h2.1L12.75 4h-1.5L6.5 15h2.1l.9-2.2zM12 5.98L13.87 11h-3.74L12 5.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unarchive
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 19h14V8H5v11zm7-9l4 4h-2.55v3h-2.91v-3H8l4-4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20.54 5.23l-1.39-1.68C18.88 3.21 18.47 3 18 3H6c-.47 0-.88.21-1.16.55L3.46 5.23C3.17 5.57 3 6.02 3 6.5V19c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V6.5c0-.48-.17-.93-.46-1.27zM6.24 5h11.52l.83 1H5.42l.82-1zM19 19H5V8h14v11zm-8.45-2h2.9v-3H16l-4-4-4 4h2.55z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 clear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 markunread
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M20 6H4l8 5zM4 8v10h16V8l-8 5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 2l-8 5-8-5h16zm0 12H4V8l8 5 8-5v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 where-to-vote
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 3C8.69 3 6 5.69 6 9c0 3.54 3.82 8.86 6 11.47 1.75-2.11 6-7.63 6-11.47 0-3.31-2.69-6-6-6zm-1.53 11l-3.18-3.18L8.71 9.4l1.77 1.77 4.6-4.6 1.41 1.41L10.47 14z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 1C7.59 1 4 4.59 4 9c0 5.57 6.96 13.34 7.26 13.67l.74.82.74-.82C13.04 22.34 20 14.57 20 9c0-4.41-3.59-8-8-8zm0 19.47C9.82 17.86 6 12.54 6 9c0-3.31 2.69-6 6-6s6 2.69 6 6c0 3.83-4.25 9.36-6 11.47zm3.07-13.9l-4.6 4.6L8.71 9.4l-1.42 1.42L10.47 14l6.01-6.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 reply-all
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 8V5l-7 7 7 7v-3l-4-4 4-4zm6 1V5l-7 7 7 7v-4.1c5 0 8.5 1.6 11 5.1-1-5-4-10-11-11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 reply
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10 9V5l-7 7 7 7v-4.1c5 0 8.5 1.6 11 5.1-1-5-4-10-11-11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 save-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 12v7H5v-7H3v7c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-7h-2zm-6 .67l2.59-2.58L17 11.5l-5 5-5-5 1.41-1.41L11 12.67V3h2v9.67z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 report-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 9.1L14.9 5H9.1l-.22.22L11 7.33V7h2v2.33l5.78 5.79.22-.22zM6.05 8.04L5 9.1v5.8L9.1 19h5.8l1.05-1.05-9.9-9.91zM13 16c0 .55-.45 1-1 1s-1-.45-1-1 .45-1 1-1 1 .45 1 1z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9.1 5h5.8L19 9.1v5.8l-.22.22 1.42 1.41.8-.8V8.27L15.73 3H8.27l-.8.8 1.41 1.42z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M13 7h-2v.33l2 2zM2.41 1.58L1 2.99l3.64 3.64L3 8.27v7.46L8.27 21h7.46l1.64-1.64L21.01 23l1.41-1.41L2.41 1.58zM14.9 19H9.1L5 14.9V9.1l1.05-1.05 9.9 9.9L14.9 19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z", :stroke nil, :fill nil})))


(helix.core/defnc
 link
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".87",
    :d
    "M17 7h-4v2h4c1.65 0 3 1.35 3 3s-1.35 3-3 3h-4v2h4c2.76 0 5-2.24 5-5s-2.24-5-5-5zm-6 8H7c-1.65 0-3-1.35-3-3s1.35-3 3-3h4V7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h4v-2zm-3-4h8v2H8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8zm5 9h-4v4h-2v-4H7v-2h4V7h2v4h4v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4zm-1-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-box
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 19h14V5H5v14zm2-8h4V7h2v4h4v2h-4v4h-2v-4H7v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zm-8-2h2v-4h4v-2h-4V7h-2v4H7v2h4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 gesture
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4.59 6.89c.7-.71 1.4-1.35 1.71-1.22.5.2 0 1.03-.3 1.52-.25.42-2.86 3.89-2.86 6.31 0 1.28.48 2.34 1.34 2.98.75.56 1.74.73 2.64.46 1.07-.31 1.95-1.4 3.06-2.77 1.21-1.49 2.83-3.44 4.08-3.44 1.63 0 1.65 1.01 1.76 1.79-3.78.64-5.38 3.67-5.38 5.37 0 1.7 1.44 3.09 3.21 3.09 1.63 0 4.29-1.33 4.69-6.1H21v-2.5h-2.47c-.15-1.65-1.09-4.2-4.03-4.2-2.25 0-4.18 1.91-4.94 2.84-.58.73-2.06 2.48-2.29 2.72-.25.3-.68.84-1.11.84-.45 0-.72-.83-.36-1.92.35-1.09 1.4-2.86 1.85-3.52.78-1.14 1.3-1.92 1.3-3.28C8.95 3.69 7.31 3 6.44 3 5.12 3 3.97 4 3.72 4.25c-.36.36-.66.66-.88.93l1.75 1.71zm9.29 11.66c-.31 0-.74-.26-.74-.72 0-.6.73-2.2 2.87-2.76-.3 2.69-1.43 3.48-2.13 3.48z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web-stories
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "4",
      :x "4",
      :width "9",
      :opacity ".3",
      :height "16",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M17,4v16c1.1,0,2-0.9,2-2V6C19,4.9,18.1,4,17,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h9c1.1,0,2-0.9,2-2V4C15,2.9,14.1,2,13,2z M13,20H4V4h9V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M21,6v12c0.83,0,1.5-0.67,1.5-1.5v-9C22.5,6.67,21.83,6,21,6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 next-week
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M4 20h16V9H4v11zm6-8.5l1-1 4 4-4 4-1-1 3-3-3-3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M11 18.5l4-4-4-4-1 1 3 3-3 3zM20 7h-4V5c0-.55-.22-1.05-.59-1.41C15.05 3.22 14.55 3 14 3h-4c-1.1 0-2 .9-2 2v2H4c-1.1 0-2 .9-2 2v11c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V9c0-1.1-.9-2-2-2zM10 5h4v2h-4V5zm10 15H4V9h16v11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 inventory
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M21,11.5l1.5,1.5l-6.99,7L11,15.5l1.5-1.5l3.01,3L21,11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points
       "17,5 17,8 7,8 7,5 5,5 5,19 11.68,19 8.17,15.5 12.5,11.17 15.51,14.17 19,10.67 19,5",
       :opacity ".3",
       :enable-background "new",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M5,19V5h2v3h10V5h2v5.67l2-2l0,0V5c0-1.1-0.9-2-2-2h-4.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H5C3.9,3,3,3.9,3,5v14 c0,1.1,0.9,2,2,2h8.68l-2-2H5z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S11.45,3,12,3z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 attribution
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8-3.58-8-8-8zm0 1c.83 0 1.5.67 1.5 1.5S12.83 8 12 8s-1.5-.67-1.5-1.5S11.17 5 12 5zm2.75 9.5h-1.5V19h-2.5v-4.5h-1.5V9.88c0-.92 1.84-1.38 2.75-1.38s2.75.47 2.75 1.38v4.62z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm0-11.5c-.91 0-2.75.46-2.75 1.38v4.62h1.5V19h2.5v-4.5h1.5V9.88c0-.91-1.84-1.38-2.75-1.38z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "6.5", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 waves
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 16.99c-1.35 0-2.2.42-2.95.8-.65.33-1.18.6-2.05.6-.9 0-1.4-.25-2.05-.6-.75-.38-1.57-.8-2.95-.8s-2.2.42-2.95.8c-.65.33-1.17.6-2.05.6v1.95c1.35 0 2.2-.42 2.95-.8.65-.33 1.17-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.42 2.95-.8c.65-.33 1.18-.6 2.05-.6.9 0 1.4.25 2.05.6.75.38 1.58.8 2.95.8v-1.95c-.9 0-1.4-.25-2.05-.6-.75-.38-1.6-.8-2.95-.8zm0-4.45c-1.35 0-2.2.43-2.95.8-.65.32-1.18.6-2.05.6-.9 0-1.4-.25-2.05-.6-.75-.38-1.57-.8-2.95-.8s-2.2.43-2.95.8c-.65.32-1.17.6-2.05.6v1.95c1.35 0 2.2-.43 2.95-.8.65-.35 1.15-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.43 2.95-.8c.65-.35 1.15-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.58.8 2.95.8v-1.95c-.9 0-1.4-.25-2.05-.6-.75-.38-1.6-.8-2.95-.8zm2.95-8.08c-.75-.38-1.58-.8-2.95-.8s-2.2.42-2.95.8c-.65.32-1.18.6-2.05.6-.9 0-1.4-.25-2.05-.6-.75-.37-1.57-.8-2.95-.8s-2.2.42-2.95.8c-.65.33-1.17.6-2.05.6v1.93c1.35 0 2.2-.43 2.95-.8.65-.33 1.17-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.43 2.95-.8c.65-.32 1.18-.6 2.05-.6.9 0 1.4.25 2.05.6.75.38 1.58.8 2.95.8V5.04c-.9 0-1.4-.25-2.05-.58zM17 8.09c-1.35 0-2.2.43-2.95.8-.65.35-1.15.6-2.05.6s-1.4-.25-2.05-.6c-.75-.38-1.57-.8-2.95-.8s-2.2.43-2.95.8c-.65.35-1.15.6-2.05.6v1.95c1.35 0 2.2-.43 2.95-.8.65-.32 1.18-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.43 2.95-.8c.65-.32 1.18-.6 2.05-.6.9 0 1.4.25 2.05.6.75.38 1.58.8 2.95.8V9.49c-.9 0-1.4-.25-2.05-.6-.75-.38-1.6-.8-2.95-.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ballot
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 14h3v3H7zm0-7h3v3H7zM5 19h14V5H5v14zm8-11.5h5v2h-5v-2zm0 7h5v2h-5v-2zM6 6h5v5H6V6zm0 7h5v5H6v-5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M13 7.5h5v2h-5zm0 7h5v2h-5zM19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zM11 6H6v5h5V6zm-1 4H7V7h3v3zm1 3H6v5h5v-5zm-1 4H7v-3h3v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 backspace
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7.06 5L2.4 12l4.67 7H22V5H7.06c.01 0 .01 0 0 0zM9 8.41L10.41 7 14 10.59 17.59 7 19 8.41 15.41 12 19 15.59 17.59 17 14 13.41 10.41 17 9 15.59 12.59 12 9 8.41z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M22 3H7c-.69 0-1.23.35-1.59.88L0 12l5.41 8.11c.36.53.9.89 1.59.89h15c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H7.07L2.4 12l4.66-7H22v14zm-11.59-2L14 13.41 17.59 17 19 15.59 15.41 12 19 8.41 17.59 7 14 10.59 10.41 7 9 8.41 12.59 12 9 15.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-list-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10.83,8H21V6H8.83L10.83,8z M15.83,13H18v-2h-4.17L15.83,13z M14,16.83V18h-4v-2h3.17l-3-3H6v-2h2.17l-3-3H3V6h0.17 L1.39,4.22l1.41-1.41l18.38,18.38l-1.41,1.41L14,16.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 content-paste-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M10.83,8H17V5h2v11.17L10.83,8z M5,19V7.83L16.17,19H5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21.19,21.19L2.81,2.81L1.39,4.22L3,5.83V19c0,1.1,0.9,2,2,2h13.17l1.61,1.61L21.19,21.19z M5,19V7.83L16.17,19H5z M17,8V5 h2v11.17l2,2V5c0-1.1-0.9-2-2-2h-4.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H5.83l5,5H17z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1 s-1-0.45-1-1S11.45,3,12,3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 report
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M9.1 5L5 9.1v5.8L9.1 19h5.8l4.1-4.1V9.1L14.9 5H9.1zM12 17c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm1-3h-2V7h2v7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15.73 3H8.27L3 8.27v7.46L8.27 21h7.46L21 15.73V8.27L15.73 3zM19 14.9L14.9 19H9.1L5 14.9V9.1L9.1 5h5.8L19 9.1v5.8z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path {:d "M11 7h2v7h-2z", :stroke nil, :fill nil})))


(helix.core/defnc
 delete-sweep
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M5 10h6v8H5z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M15 16h4v2h-4zm0-8h7v2h-7zm0 4h6v2h-6zM3 18c0 1.1.9 2 2 2h6c1.1 0 2-.9 2-2V8H3v10zm2-8h6v8H5v-8zm5-6H6L5 5H2v2h12V5h-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 square-foot
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "7,17 12.76,17 7,11.24",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M17.66,17.66l-1.06,1.06l-0.71-0.71l1.06-1.06l-1.94-1.94l-1.06,1.06l-0.71-0.71l1.06-1.06l-1.94-1.94l-1.06,1.06 l-0.71-0.71l1.06-1.06L9.7,9.7l-1.06,1.06l-0.71-0.71l1.06-1.06L7.05,7.05L5.99,8.11L5.28,7.4l1.06-1.06L4,4v14c0,1.1,0.9,2,2,2 h14L17.66,17.66z M7,17v-5.76L12.76,17H7z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 upcoming
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,17c-2.04,0-3.81-1.24-4.58-3H4v5h16v-5h-3.42C15.81,15.76,14.04,17,12,17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.16,7.26l-1.41-1.41L16.19,9.4l1.41,1.41C17.6,10.81,21.05,7.29,21.16,7.26z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "3",
      :x "11",
      :width "2",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,12h-5c0,1.66-1.34,3-3,3s-3-1.34-3-3H4c-1.1,0-2,0.9-2,2v5c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2v-5 C22,12.9,21.1,12,20,12z M20,19H4v-5h3.42c0.77,1.76,2.54,3,4.58,3s3.81-1.24,4.58-3H20V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M6.4,10.81L7.81,9.4L4.26,5.84L2.84,7.26C2.95,7.29,6.4,10.81,6.4,10.81z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-link
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,11h8v2H8V11z M20.1,12H22c0-2.76-2.24-5-5-5h-4v1.9h4C18.71,8.9,20.1,10.29,20.1,12z M3.9,12c0-1.71,1.39-3.1,3.1-3.1h4 V7H7c-2.76,0-5,2.24-5,5s2.24,5,5,5h4v-1.9H7C5.29,15.1,3.9,13.71,3.9,12z M19,12h-2v3h-3v2h3v3h2v-3h3v-2h-3V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 outlined-flag
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M14 6l-1-2H5v17h2v-7h5l1 2h7V6h-6zm4 8h-4l-1-2H7V6h5l1 2h5v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 report-gmailerrorred
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.73 3H8.27L3 8.27v7.46L8.27 21h7.46L21 15.73V8.27L15.73 3zM19 14.9L14.9 19H9.1L5 14.9V9.1L9.1 5h5.8L19 9.1v5.8z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path {:d "M11 7h2v7h-2z", :stroke nil, :fill nil})))


(helix.core/defnc
 save
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5 5v14h14V7.83L16.17 5H5zm7 13c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm3-8H6V6h9v4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V7l-4-4zm2 16H5V5h11.17L19 7.83V19zm-7-7c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zM6 6h9v4H6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 send
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M4 8.25l7.51 1-7.5-3.22zm.01 9.72l7.5-3.22-7.51 1z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M2.01 3L2 10l15 2-15 2 .01 7L23 12 2.01 3zM4 8.25V6.03l7.51 3.22-7.51-1zm.01 9.72v-2.22l7.51-1-7.51 3.22z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 create
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 18.08V19h.92l9.06-9.06-.92-.92z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM5.92 19H5v-.92l9.06-9.06.92.92L5.92 19zM20.71 5.63l-2.34-2.34c-.2-.2-.45-.29-.71-.29s-.51.1-.7.29l-1.83 1.83 3.75 3.75 1.83-1.83c.39-.39.39-1.02 0-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 stacked-bar-chart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "9",
      :x "4",
      :width "4",
      :height "11",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4", :x "4", :width "4", :height "4", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "7",
      :x "10",
      :width "4",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "16",
      :width "4",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "16",
      :width "4",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "10",
      :width "4",
      :height "8",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 tag
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,10V8h-4V4h-2v4h-4V4H8v4H4v2h4v4H4v2h4v4h2v-4h4v4h2v-4h4v-2h-4v-4H20z M14,14h-4v-4h4V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 low-priority
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 5h8v2h-8V5zm0 5.5h8v2h-8v-2zm0 5.5h8v2h-8v-2zM2 11.5C2 15.08 4.92 18 8.5 18H9v2l3-3-3-3v2h-.5C6.02 16 4 13.98 4 11.5S6.02 7 8.5 7H12V5H8.5C4.92 5 2 7.92 2 11.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 forward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M14 14v1.17L17.17 12 14 8.83V10H6v4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 12l-8-8v4H4v8h8v4l8-8zM6 14v-4h8V8.83L17.17 12 14 15.17V14H6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 policy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,6.3V11c0,4.52,2.98,8.69,7,9.93c1.74-0.53,3.28-1.62,4.47-3.04l-1.72-1.72 c-1.94,1.29-4.58,1.07-6.29-0.64c-1.95-1.95-1.95-5.12,0-7.07c1.95-1.95,5.12-1.95,7.07,0c1.71,1.71,1.92,4.35,0.64,6.29 l1.45,1.45C18.49,14.65,19,12.85,19,11V6.3l-7-3.11L5,6.3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,1L3,5v6c0,5.55,3.84,10.74,9,12c0.65-0.16,1.27-0.38,1.87-0.65c1.8-0.82,3.36-2.13,4.57-3.74 C20.04,16.46,21,13.77,21,11V5L12,1z M19,11c0,1.85-0.51,3.65-1.38,5.21l-1.45-1.45c1.29-1.94,1.07-4.58-0.64-6.29 c-1.95-1.95-5.12-1.95-7.07,0c-1.95,1.95-1.95,5.12,0,7.07c1.71,1.71,4.35,1.92,6.29,0.64l1.72,1.72 c-1.19,1.42-2.73,2.51-4.47,3.04C7.98,19.69,5,15.52,5,11V6.3l7-3.11l7,3.11V11z M15,12c0,1.66-1.34,3-3,3s-3-1.34-3-3s1.34-3,3-3 S15,10.34,15,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 move-to-inbox
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12.01 18c-1.48 0-2.75-.81-3.45-2H5v3h14v-3h-3.55c-.69 1.19-1.97 2-3.44 2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16 9h-2.55V6h-2.9v3H8l4 4zm3-6H4.99C3.88 3 3 3.9 3 5v14c0 1.1.88 2 1.99 2H19c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5v-3h3.56c.69 1.19 1.97 2 3.45 2s2.75-.81 3.45-2H19v3zm0-5h-4.99c0 1.1-.9 2-2 2s-2-.9-2-2H5l-.01-9H19v9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 block
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM4 12c0-4.42 3.58-8 8-8 1.85 0 3.55.63 4.9 1.69L5.69 16.9C4.63 15.55 4 13.85 4 12zm8 8c-1.85 0-3.55-.63-4.9-1.69L18.31 7.1C19.37 8.45 20 10.15 20 12c0 4.42-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 assistant-photo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M14.24 12l.4 2H18V8h-5.24l-.4-2H7v6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M7 14h5.6l.4 2h7V6h-5.6L14 4H5v17h2v-7zm0-8h5.36l.4 2H18v6h-3.36l-.4-2H7V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-4
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M18 9.52V6h-3.52L12 3.52 9.52 6H6v3.52L3.52 12 6 14.48V18h3.52L12 20.48 14.48 18H18v-3.52L20.48 12 18 9.52zM12.29 17c-.74 0-1.45-.17-2.08-.46 1.72-.79 2.92-2.52 2.92-4.54s-1.2-3.75-2.92-4.54c.63-.29 1.34-.46 2.08-.46 2.76 0 5 2.24 5 5s-2.24 5-5 5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69L23.31 12 20 8.69zm-2 5.79V18h-3.52L12 20.48 9.52 18H6v-3.52L3.52 12 6 9.52V6h3.52L12 3.52 14.48 6H18v3.52L20.48 12 18 14.48zM12.29 7c-.74 0-1.45.17-2.08.46 1.72.79 2.92 2.53 2.92 4.54s-1.2 3.75-2.92 4.54c.63.29 1.34.46 2.08.46 2.76 0 5-2.24 5-5s-2.24-5-5-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-fix-high
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14.29",
      :x "3.64",
      :width "10.14",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 -8.2634 10.636)",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20,7 20.94,4.94 23,4 20.94,3.06 20,1 19.06,3.06 17,4 19.06,4.94",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8.5,7 9.44,4.94 11.5,4 9.44,3.06 8.5,1 7.56,3.06 5.5,4 7.56,4.94",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20,12.5 19.06,14.56 17,15.5 19.06,16.44 20,18.5 20.94,16.44 23,15.5 20.94,14.56",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.71,9.12l-2.83-2.83C14.68,6.1,14.43,6,14.17,6c-0.26,0-0.51,0.1-0.71,0.29L2.29,17.46c-0.39,0.39-0.39,1.02,0,1.41 l2.83,2.83C5.32,21.9,5.57,22,5.83,22s0.51-0.1,0.71-0.29l11.17-11.17C18.1,10.15,18.1,9.51,17.71,9.12z M5.83,19.59l-1.41-1.41 L11.59,11L13,12.41L5.83,19.59z M14.41,11L13,9.59l1.17-1.17l1.41,1.41L14.41,11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 broken-image
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M13.99 15.41l-4-4-4 4-.99-.99V19h14v-6.57l-1.01-1.01zM5 11.59l.99 1 4-4 4 4 4-4.01L19 9.59V5H5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5v-4.58l.99.99 4-4 4 4 4-3.99L19 12.43V19zm0-9.41l-1.01-1.01-4 4.01-4-4-4 4-.99-1V5h14v4.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12.7 4.91c1.46 2 2.3 4.46 2.3 7.09s-.84 5.09-2.3 7.09C15.25 17.76 17 15.08 17 12s-1.75-5.76-4.3-7.09z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9 2c-1.05 0-2.05.16-3 .46 4.06 1.27 7 5.06 7 9.54 0 4.48-2.94 8.27-7 9.54.95.3 1.95.46 3 .46 5.52 0 10-4.48 10-10S14.52 2 9 2zm3.7 17.09c1.46-2 2.3-4.46 2.3-7.09s-.84-5.09-2.3-7.09C15.25 6.24 17 8.92 17 12s-1.75 5.76-4.3 7.09z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 assistant
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M9.83 18l.59.59L12 20.17l1.59-1.59.58-.58H19V4H5v14h4.83zm.29-8.88L12 5l1.88 4.12L18 11l-4.12 1.88L12 17l-1.88-4.12L6 11l4.12-1.88z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 20h4l3 3 3-3h4c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2zM5 4h14v14h-4.83l-.59.59L12 20.17l-1.59-1.59-.58-.58H5V4zm7 13l1.88-4.12L18 11l-4.12-1.88L12 5l-1.88 4.12L6 11l4.12 1.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 grid-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M20 14v-4h-4v2.89L17.11 14zm-10-1.45V14h1.45zM14 10h-.89l.89.89zm5.11 6l.89.89V16zM8 4h-.89l.89.89zm6 4V4h-4v2.89L11.11 8zm2-4h4v4h-4zm-6 12v4h4v-3.45l-.55-.55zm-6-6v4h4v-3.45L7.45 10zm12 10h1.45L16 18.55zM4 16h4v4H4zm0-9.45V8h1.45z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8 4v.89l2 2V4h4v4h-2.89l2 2H14v.89l2 2V10h4v4h-2.89l2 2H20v.89l2 2V4c0-1.1-.9-2-2-2H5.11l2 2H8zm8 0h4v4h-4V4zM1.41 1.14L0 2.55l2 2V20c0 1.1.9 2 2 2h15.45l2.01 2.01 1.41-1.41L1.41 1.14zM10 12.55L11.45 14H10v-1.45zm-6-6L5.45 8H4V6.55zM8 20H4v-4h4v4zm0-6H4v-4h3.45l.55.55V14zm6 6h-4v-4h3.45l.55.55V20zm2 0v-1.45L17.45 20H16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 monochrome-photos
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 18v-1.8c-1.8 0-3.2-1.4-3.2-3.2s1.4-3.2 3.2-3.2V8c-2.8 0-5 2.2-5 5s2.2 5 5 5zm5-5c0 2.8-2.2 5-5 5v1h8V7h-8v1c2.8 0 5 2.2 5 5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 21h16c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2h-3.2L15 3H9L7.2 5H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2zm8-13V7h8v12h-8v-1c-2.8 0-5-2.2-5-5s2.2-5 5-5zm3.2 5c0 1.8-1.4 3.2-3.2 3.2V18c2.8 0 5-2.2 5-5s-2.2-5-5-5v1.8c1.8 0 3.2 1.4 3.2 3.2zm-6.4 0c0 1.8 1.4 3.2 3.2 3.2V9.8c-1.8 0-3.2 1.4-3.2 3.2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flip-camera-ios
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M14.12,5H9.88L8.05,7H4v12h16V7h-4.05L14.12,5z M12,18c-2.76,0-5-2.24-5-5H5l2.49-2.49L7.5,10.5L10,13H9.97 H8c0,2.21,1.79,4,4,4c0.58,0,1.13-0.13,1.62-0.35l0.74,0.74C13.65,17.76,12.86,18,12,18z M19,13l-2.49,2.49L16.5,15.5L14,13h0.03 H16c0-2.21-1.79-4-4-4c-0.58,0-1.13,0.13-1.62,0.35L9.64,8.62C10.35,8.24,11.14,8,12,8c2.76,0,5,2.24,5,5H19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,5h-3.17L15,3H9L7.17,5H4C2.9,5,2,5.9,2,7v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V7C22,5.9,21.1,5,20,5z M20,19H4V7 h4.05l1.83-2h4.24l1.83,2H20V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,17c-2.21,0-4-1.79-4-4h1.97H10l-2.5-2.5l-0.01,0.01L5,13h2c0,2.76,2.24,5,5,5c0.86,0,1.65-0.24,2.36-0.62l-0.74-0.74 C13.13,16.87,12.58,17,12,17z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,8c-0.86,0-1.65,0.24-2.36,0.62l0.74,0.73C10.87,9.13,11.42,9,12,9c2.21,0,4,1.79,4,4h-1.97H14l2.5,2.5l0.01-0.01 L19,13h-2C17,10.24,14.76,8,12,8z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 gradient
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 11h2v2h-2zm6 10c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14zM9 18H7v-2h2v2zm4 0h-2v-2h2v2zm4 0h-2v-2h2v2zM5 13h2v-2H5V5h14v6h-2v2h2v2h-2v-2h-2v2h-2v-2h-2v2H9v-2H7v2H5v-2zm2-4h2v2H7zm8 0h2v2h-2zm-4 0h2v2h-2zm-2 2h2v2H9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 switch-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14.12 4H9.88L8.05 6H4v12h16V6h-4.05l-1.83-2zM15 15.5V13H9v2.5L5.5 12 9 8.5V11h6V8.5l3.5 3.5-3.5 3.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 4h-3.17L15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H4V6h4.05l1.83-2h4.24l1.83 2H20v12zm-5-7H9V8.5L5.5 12 9 15.5V13h6v2.5l3.5-3.5L15 8.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove-red-eye
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 6.5c-3.79 0-7.17 2.13-8.82 5.5 1.65 3.37 5.02 5.5 8.82 5.5s7.17-2.13 8.82-5.5C19.17 8.63 15.79 6.5 12 6.5zm0 10c-2.48 0-4.5-2.02-4.5-4.5S9.52 7.5 12 7.5s4.5 2.02 4.5 4.5-2.02 4.5-4.5 4.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zm0 13c-3.79 0-7.17-2.13-8.82-5.5C4.83 8.63 8.21 6.5 12 6.5s7.17 2.13 8.82 5.5c-1.65 3.37-5.03 5.5-8.82 5.5zm0-10c-2.48 0-4.5 2.02-4.5 4.5s2.02 4.5 4.5 4.5 4.5-2.02 4.5-4.5-2.02-4.5-4.5-4.5zm0 7c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vrpano
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M4,6.38v11.25c2.01-0.59,4.61-1.13,8-1.13c3.38,0,5.99,0.54,8,1.13V6.37 c-2.01,0.59-4.62,1.13-8,1.13C9.32,7.5,6.58,7.11,4,6.38z M18.51,15.4C16.52,15.15,14.3,15,12,15c-2.34,0-4.52,0.15-6.52,0.41 l3.69-4.42l2,2.4L14,10L18.51,15.4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.01,4C20.45,4,17.4,5.5,12,5.5c-5.31,0-8.49-1.49-9.01-1.49C2.46,4.01,2,4.45,2,5.02V19c0,0.57,0.46,1,0.99,1 c0.57,0,3.55-1.5,9.01-1.5c5.42,0,8.44,1.5,9.01,1.5c0.53,0,0.99-0.43,0.99-1V5C22,4.43,21.54,4,21.01,4z M20,17.63 c-2.01-0.59-4.62-1.13-8-1.13c-3.39,0-5.99,0.54-8,1.13V6.38C6.58,7.11,9.32,7.5,12,7.5c3.38,0,5.99-0.54,8-1.13V17.63z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.17,10.99l-3.69,4.42C7.48,15.15,9.66,15,12,15c2.3,0,4.52,0.15,6.51,0.4L14,10l-2.83,3.39L9.17,10.99z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 incomplete-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,12c0,5.52-4.48,10-10,10S2,17.52,2,12c0-2.76,1.12-5.26,2.93-7.07L12,12V2C17.52,2,22,6.48,22,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-fix-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "15.15",
      :x "3.99",
      :width "7.73",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 -9.117 10.2825)",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20,7 20.94,4.94 23,4 20.94,3.06 20,1 19.06,3.06 17,4 19.06,4.94",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.17,8.42l1.41,1.41l-1.46,1.46l1.41,1.41l2.17-2.17c0.39-0.39,0.39-1.02,0-1.41l-2.83-2.83C14.68,6.1,14.43,6,14.17,6 c-0.26,0-0.51,0.1-0.71,0.29l-2.17,2.17l1.41,1.41L14.17,8.42z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.81,2.81L1.39,4.22l7.07,7.07l-6.17,6.17c-0.39,0.39-0.39,1.02,0,1.41l2.83,2.83C5.32,21.9,5.57,22,5.83,22 s0.51-0.1,0.71-0.29l6.17-6.17l7.07,7.07l1.41-1.41L2.81,2.81z M5.83,19.59l-1.41-1.41l5.46-5.46l1.41,1.41L5.83,19.59z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _23mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M13,10h3 V9h-2V8h2V7h-3V5.5h3.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H13V10z M6.5,9c0-0.55,0.45-1,1-1h2V7h-3V5.5H10c0.55,0,1,0.45,1,1 V8c0,0.55-0.45,1-1,1H8v1h3v1.5H6.5V9z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,12.5v6H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1H13.5z M16.5,15.5H15V14h1.5V15.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,10H8V9h2c0.55,0,1-0.45,1-1V6.5c0-0.55-0.45-1-1-1H6.5V7h3v1h-2c-0.55,0-1,0.45-1,1v2.5H11V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.5,10.5v-4c0-0.55-0.45-1-1-1H13V7h3v1h-2v1h2v1h-3v1.5h3.5C17.05,11.5,17.5,11.05,17.5,10.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 video-camera-front
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,10.48V6c0-1.1-0.9-2-2-2H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-4.48l4,3.98v-11L18,10.48z M16,18 H4V6h12V18z M10,12c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S8.9,12,10,12z M14,15.43c0-0.81-0.48-1.53-1.22-1.85 C11.93,13.21,10.99,13,10,13c-0.99,0-1.93,0.21-2.78,0.58C6.48,13.9,6,14.62,6,15.43V16h8V15.43z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,18h12V9.69V6H4V18z M10,8c1.1,0,2,0.9,2,2s-0.9,2-2,2s-2-0.9-2-2S8.9,8,10,8z M6,15.43 c0-0.81,0.48-1.53,1.22-1.85C8.07,13.21,9.01,13,10,13c0.99,0,1.93,0.21,2.78,0.58C13.52,13.9,14,14.62,14,15.43V16H6V15.43z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 view-comfy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M10,18h10v-5H10V18z M4,6v5h16V6H4z M4,18h4v-5H4V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2,4v16h20V4H2z M8,18H4v-5h4V18z M20,18H10v-5h10V18z M20,11H4V6h16V11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 brightness-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M18 12c0-4.41-3.59-8-8-8-.34 0-.68.02-1.01.07C10.9 6.23 12 9.05 12 12c0 2.95-1.1 5.77-3.01 7.93.33.05.67.07 1.01.07 4.41 0 8-3.59 8-8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 20.65C6.47 21.5 8.18 22 10 22c5.52 0 10-4.48 10-10S15.52 2 10 2c-1.82 0-3.53.5-5 1.35C7.99 5.08 10 8.3 10 12s-2.01 6.92-5 8.65zM12 12c0-2.95-1.1-5.77-3.01-7.93C9.32 4.02 9.66 4 10 4c4.41 0 8 3.59 8 8s-3.59 8-8 8c-.34 0-.68-.02-1.01-.07C10.9 17.77 12 14.95 12 12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-cloudy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19.23 12.04l-1.52-.11-.3-1.5C16.89 7.86 14.62 6 12.01 6 9.95 6 8.08 7.14 7.13 8.96l-.5.95-1.07.11c-2.02.22-3.55 1.93-3.55 3.98 0 2.21 1.79 4 4 4h13c1.65 0 3-1.35 3-3 0-1.55-1.23-2.86-2.78-2.96z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.36 10.04C18.67 6.59 15.65 4 12.01 4 9.11 4 6.6 5.64 5.35 8.04 2.35 8.36.01 10.91.01 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19.01 18h-13c-2.21 0-4-1.79-4-4 0-2.05 1.53-3.76 3.56-3.97l1.07-.11.5-.95C8.08 7.14 9.95 6 12.01 6c2.61 0 4.89 1.86 5.4 4.43l.3 1.5 1.52.11c1.56.11 2.78 1.41 2.78 2.96 0 1.65-1.35 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M18 9.52V6h-3.52L12 3.52 9.52 6H6v3.52L3.52 12 6 14.48V18h3.52L12 20.48 14.48 18H18v-3.52L20.48 12 18 9.52zm-6 7.98c-3.03 0-5.5-2.47-5.5-5.5S8.97 6.5 12 6.5s5.5 2.47 5.5 5.5-2.47 5.5-5.5 5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69L23.31 12 20 8.69zm-2 5.79V18h-3.52L12 20.48 9.52 18H6v-3.52L3.52 12 6 9.52V6h3.52L12 3.52 14.48 6H18v3.52L20.48 12 18 14.48zM12 6.5c-3.03 0-5.5 2.47-5.5 5.5s2.47 5.5 5.5 5.5 5.5-2.47 5.5-5.5-2.47-5.5-5.5-5.5zm0 9c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 leak-remove
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 3h-2c0 1.35-.31 2.63-.84 3.77l1.49 1.49C13.51 6.7 14 4.91 14 3zm7 9v-2c-1.91 0-3.7.49-5.27 1.35l1.49 1.49c1.15-.53 2.43-.84 3.78-.84zm0 4v-2c-.79 0-1.54.13-2.24.37l1.68 1.68c.19-.01.37-.05.56-.05zM10 3H8c0 .19-.04.37-.06.56l1.68 1.68c.25-.7.38-1.46.38-2.24zm-5.59-.14L3 4.27l2.84 2.84C5.03 7.67 4.06 8 3 8v2c1.61 0 3.09-.55 4.27-1.46L8.7 9.97C7.14 11.24 5.16 12 3 12v2c2.72 0 5.2-.99 7.11-2.62l2.51 2.51C10.99 15.81 10 18.29 10 21h2c0-2.16.76-4.14 2.03-5.7l1.43 1.43C14.55 17.91 14 19.39 14 21h2c0-1.06.33-2.03.89-2.84L19.73 21l1.41-1.41L4.41 2.86z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 burst-mode
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M11 17h10V7H11v10zm3-3.53l1.43 1.72 2-2.58L20 15.99h-8l2-2.52z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M1 5h2v14H1zm4 0h2v14H5zm17 0H10c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h12c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1zm-1 12H11V7h10v10zm-3.57-4.38l-2 2.57L14 13.47l-2 2.52h8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 picture-as-pdf
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M4 6H2v14c0 1.1.9 2 2 2h14v-2H4V6z", :stroke nil, :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M10 9h1v1h-1zm4 0h1v3h-1zm-6 7h12V4H8v12zm9-8h2v1h-1v1h1v1h-1v2h-1V8zm-4 0h2c.55 0 1 .45 1 1v3c0 .55-.45 1-1 1h-2V8zM9 8h2c.55 0 1 .45 1 1v1c0 .55-.45 1-1 1h-1v2H9V8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H8V4h12v12zm-4-4V9c0-.55-.45-1-1-1h-2v5h2c.55 0 1-.45 1-1zm-2-3h1v3h-1V9zm4 2h1v-1h-1V9h1V8h-2v5h1zm-8 0h1c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1H9v5h1v-2zm0-2h1v1h-1V9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 19V5L5 19h14zm-4.5-4.5v-2H16v2h2V16h-2v2h-1.5v-2h-2v-1.5h2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM6 7h5v1.5H6V7zm13 12H5L19 5v14zm-4.5-3v2H16v-2h2v-1.5h-2v-2h-1.5v2h-2V16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 audiotrack
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "2", :opacity ".3", :cy "17", :cx "10", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M10 21c2.21 0 4-1.79 4-4V7h4V3h-6v10.55c-.59-.34-1.27-.55-2-.55-2.21 0-4 1.79-4 4s1.79 4 4 4zm0-6c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-tilt-shift
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 2.05v2.02c1.46.18 2.79.76 3.9 1.62l1.42-1.43C16.84 3.05 15.01 2.25 13 2.05zm0 17.88v2.02c2.01-.2 3.84-1 5.32-2.21l-1.43-1.43c-1.1.86-2.43 1.44-3.89 1.62zm-8.74-1.61l1.43-1.43c-.86-1.1-1.44-2.43-1.62-3.89H2.05c.2 2.01 1 3.84 2.21 5.32zM2.05 11h2.02c.18-1.46.76-2.79 1.62-3.9L4.26 5.68C3.05 7.16 2.25 8.99 2.05 11zm16.26-3.9c.86 1.11 1.44 2.44 1.62 3.9h2.02c-.2-2.01-1-3.84-2.21-5.32L18.31 7.1zM7.1 5.69c1.11-.86 2.44-1.44 3.9-1.62V2.05c-2.01.2-3.84 1-5.32 2.21L7.1 5.69zM5.68 19.74C7.16 20.95 9 21.75 11 21.95v-2.02c-1.46-.18-2.79-.76-3.9-1.62l-1.42 1.43zm16.27-6.73h-2.02c-.18 1.45-.76 2.78-1.62 3.89l1.43 1.43c1.21-1.48 2.01-3.32 2.21-5.32zM9 12c0 1.66 1.34 3 3 3s3-1.34 3-3-1.34-3-3-3-3 1.34-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 adjust
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 9c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zm0-7C6.49 2 2 6.49 2 12s4.49 10 10 10 10-4.49 10-10S17.51 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 camera-rear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 16h10V2H7v14zm4.99-13c1.1 0 2 .9 2 2C14 6.1 13.1 7 12 7c-1.11 0-2-.9-2-2s.89-2 1.99-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 20v2h5v2l3-3-3-3v2zm9 0h5v2h-5zm5-18c0-1.1-.9-2-2-2H7C5.9 0 5 .9 5 2v14c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V2zm-2 14H7V2h10v14zm-5-9c1.1 0 2-.9 1.99-2 0-1.1-.9-2-2-2S10 3.9 10 5s.89 2 2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-awesome
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "9.99,11.01 9,8.83 8.01,11.01 5.83,12 8.01,12.99 9,15.17 9.99,12.99 12.17,12",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "19,9 20.25,6.25 23,5 20.25,3.75 19,1 17.75,3.75 15,5 17.75,6.25",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "19,15 17.75,17.75 15,19 17.75,20.25 19,23 20.25,20.25 23,19 20.25,17.75",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.5,9.5L9,4L6.5,9.5L1,12l5.5,2.5L9,20l2.5-5.5L17,12L11.5,9.5z M9.99,12.99L9,15.17l-0.99-2.18L5.83,12l2.18-0.99 L9,8.83l0.99,2.18L12.17,12L9.99,12.99z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 tag-faces
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8-3.58-8-8-8zm3.5 4c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5.67-1.5 1.5-1.5zm-7 0c.83 0 1.5.67 1.5 1.5S9.33 11 8.5 11 7 10.33 7 9.5 7.67 8 8.5 8zm3.5 9.5c-2.33 0-4.31-1.46-5.11-3.5h10.22c-.8 2.04-2.78 3.5-5.11 3.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "9.5", :cx "8.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 17.5c2.33 0 4.31-1.46 5.11-3.5H6.89c.8 2.04 2.78 3.5 5.11 3.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "9.5", :cx "15.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 raw-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "17.15,14.32 17.74,11.96 18.5,15 19.98,15 21.48,9 19.98,9 19.24,12 18.5,9 16.98,9 16.24,12 15.5,9 14,9 14.72,11.9",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1.39,4.22L6.17,9H3v6h1.5v-2h1.1l0.9,2H8l-0.9-2.1C7.6,12.6,8,12.1,8,11.5v-0.67l1.43,1.43L8.75,15h1.5l0.38-1.5h0.04 l9.11,9.11l1.41-1.41L2.81,2.81L1.39,4.22z M6.5,11.5h-2v-1h2V11.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 music-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "2", :opacity ".3", :cy "17", :cx "10", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M14 7h4V3h-6v4.61l2 2zm-2 3.44L4.41 2.86 3 4.27l9 9v.28c-.94-.54-2.1-.75-3.33-.32-1.34.48-2.37 1.67-2.61 3.07-.46 2.74 1.86 5.08 4.59 4.65 1.96-.31 3.35-2.11 3.35-4.1v-1.58L19.73 21l1.41-1.41L12 10.44zM10 19c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-library
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M8 16h12V4H8v12zm3.5-4.33l1.69 2.26 2.48-3.09L19 15H9l2.5-3.33z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M22 16V4c0-1.1-.9-2-2-2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2zm-2 0H8V4h12v12zm-4.33-5.17l-2.48 3.09-1.69-2.25L9 15h10zM4 22h14v-2H4V6H2v14c0 1.1.9 2 2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-sunny
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12 7.5c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5.34 6.25l1.42-1.41-1.8-1.79-1.41 1.41zM1 10.5h3v2H1zM11 .55h2V3.5h-2zm7.66 5.705l-1.41-1.407 1.79-1.79 1.406 1.41zM17.24 18.16l1.79 1.8 1.41-1.41-1.8-1.79zM20 10.5h3v2h-3zm-8-5c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zm0 10c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4zm-1 4h2v2.95h-2zm-7.45-.96l1.41 1.41 1.79-1.8-1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _16mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M12,6.5 c0-0.55,0.45-1,1-1h3.5V7h-3v1h2c0.55,0,1,0.45,1,1v1.5c0,0.55-0.45,1-1,1H13c-0.55,0-1-0.45-1-1V6.5z M7,5.5h3v6H8.5V7H7V5.5z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "13.5",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13,11.5h2.5c0.55,0,1-0.45,1-1V9c0-0.55-0.45-1-1-1h-2V7h3V5.5H13c-0.55,0-1,0.45-1,1v4C12,11.05,12.45,11.5,13,11.5z M13.5,9H15v1.5h-1.5V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,11.5 10,11.5 10,5.5 7,5.5 7,7 8.5,7",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flash-auto
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 2v12h3v9l7-12H9l4-9zm14 0l-3.2 9h1.9l.7-2h3.2l.7 2h1.9L19 2h-2zm-.15 5.65L18 4l1.15 3.65h-2.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _3mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M10,10h3 V9h-2V8h2V7h-3V5.5h3.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H10V10z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14 h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.5,10.5v-4c0-0.55-0.45-1-1-1H10V7h3v1h-2v1h2v1h-3v1.5h3.5C14.05,11.5,14.5,11.05,14.5,10.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-16-9
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,7H5C3.9,7,3,7.9,3,9v6c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V9C21,7.9,20.1,7,19,7z M19,15H5V9h14V15z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 _9mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.5",
      :x "11.5",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M10,10h3 V9h-2c-0.55,0-1-0.45-1-1V6.5c0-0.55,0.45-1,1-1h2.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H10V10z M6,13.5c0-0.55,0.45-1,1-1h4.5 c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.5,10.5v-4c0-0.55-0.45-1-1-1H11c-0.55,0-1,0.45-1,1V8c0,0.55,0.45,1,1,1h2v1h-3v1.5h3.5 C14.05,11.5,14.5,11.05,14.5,10.5z M13,8h-1.5V6.5H13V8z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 bedtime-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d
       "M7.95 5.13 9.03 6.2c.05-.55.12-1.12.24-1.71-.46.17-.9.39-1.32.64z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d
       "M5.13 7.96C4.42 9.15 4 10.52 4 12c0 4.41 3.59 8 8 8 1.45 0 2.84-.4 4.05-1.12L5.13 7.96z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M9.27 4.49c-.13.59-.2 1.15-.24 1.71l2.05 2.05c-.27-2.05.1-4.22 1.26-6.23-.12 0-.23-.01-.35-.01-2.05 0-3.93.61-5.5 1.65l1.46 1.46c.42-.24.86-.46 1.32-.63zM2.81 2.81 1.39 4.22l2.27 2.27C2.61 8.07 2 9.97 2 12c0 5.52 4.48 10 10 10 2.04 0 3.92-.63 5.5-1.67l2.28 2.28 1.41-1.41L2.81 2.81zM12 20c-4.41 0-8-3.59-8-8 0-1.48.42-2.85 1.13-4.04l10.92 10.92C14.84 19.6 13.45 20 12 20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 currency-franc
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "18,5 18,3 7,3 7,16 5,16 5,18 7,18 7,21 9,21 9,18 13,18 13,16 9,16 9,13 17,13 17,11 9,11 9,5",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 crop-rotate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.95 24c.23 0 .44-.02.66-.03L8.8 20.15l-1.33 1.34C4.2 19.93 1.86 16.76 1.5 13H0c.51 6.16 5.66 11 11.95 11zm.1-24c-.23 0-.44.02-.66.04l3.81 3.81 1.33-1.33C19.8 4.07 22.14 7.24 22.5 11H24c-.51-6.16-5.66-11-11.95-11zM16 6h-6v2h6v6h2V8c0-1.11-.9-2-2-2zm2 12h2v-2H8V4H6v2H4v2h2v8c0 1.1.89 2 2 2h8v2h2v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-paused
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M22,12c0,5.52-4.48,10-10,10S2,17.52,2,12c0-1.19,0.22-2.32,0.6-3.38L4.48,9.3C4.17,10.14,4,11.05,4,12c0,4.41,3.59,8,8,8 s8-3.59,8-8s-3.59-8-8-8c-0.95,0-1.85,0.17-2.69,0.48L8.63,2.59C9.69,2.22,10.82,2,12,2C17.52,2,22,6.48,22,12z M5.5,4 C4.67,4,4,4.67,4,5.5S4.67,7,5.5,7S7,6.33,7,5.5S6.33,4,5.5,4z M11,16V8H9v8H11z M15,16V8h-2v8H15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 blur-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "14", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M13.8 11.48l.2.02c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5l.02.2c.09.67.61 1.19 1.28 1.28zM14 3.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm-4 0c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "10", :cx "18", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "18", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M21 10.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "10", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "14", :cx "18", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "18", :cx "6", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M14 20.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm7-7c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm-18 0c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "18", :cx "10", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M3 9.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm7 11c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "14", :cx "6", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M2.5 5.27L6 8.77l.28.28L6 9c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1c0-.1-.03-.19-.06-.28l2.81 2.81c-.71.11-1.25.73-1.25 1.47 0 .83.67 1.5 1.5 1.5.74 0 1.36-.54 1.47-1.25l2.81 2.81c-.09-.03-.18-.06-.28-.06-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1c0-.1-.03-.19-.06-.28l3.78 3.78h.01l1.41-1.41L3.91 3.86 2.5 5.27z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _18mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "6.5",
      :x "13.5",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "13.5",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M12,6.5 c0-0.55,0.45-1,1-1h2.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H13c-0.55,0-1-0.45-1-1V6.5z M7,5.5h3v6H8.5V7H7V5.5z M6,13.5 c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,11.5 10,11.5 10,5.5 7,5.5 7,7 8.5,7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13,11.5h2.5c0.55,0,1-0.45,1-1v-4c0-0.55-0.45-1-1-1H13c-0.55,0-1,0.45-1,1v4C12,11.05,12.45,11.5,13,11.5z M13.5,6.5H15 V8h-1.5V6.5z M13.5,9H15v1.5h-1.5V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera-front
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M7 14h10v2H7z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M5 20v2h5v2l3-3-3-3v2zm9 0h5v2h-5zM11.99 8C13.1 8 14 7.1 14 6s-.9-2-2.01-2S10 4.9 10 6s.89 2 1.99 2zM17 0H7C5.9 0 5 .9 5 2v14c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V2c0-1.1-.9-2-2-2zm0 16H7v-2h10v2zm0-3.5c0-1.67-3.33-2.5-5-2.5s-5 .83-5 2.5V2h10v10.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-none
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M7 3h14v14H7z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M3 23h16v-2H3V5H1v16c0 1.1.9 2 2 2zM21 1H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-weak
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 6c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zm0 10c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2", :opacity ".3", :cy "12", :cx "5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M5 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-vintage
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M18.69 7.61c-.7 0-1.39.19-2 .54-.16.09-.32.21-.54.37l-1.13.9c.31.36.56.78.72 1.24l1.38-.52c.22-.08.41-.17.58-.27.84-.49 1.47-1.27 1.78-2.18-.26-.06-.52-.08-.79-.08zm-1.56 6.26l-1.38-.52c-.16.45-.4.85-.7 1.21l1.15.96c.15.12.31.24.49.34.61.35 1.3.54 1.99.54.27 0 .53-.03.8-.08-.31-.91-.94-1.69-1.78-2.18-.16-.1-.35-.19-.57-.27zM11 6c0 .19.02.41.05.63l.23 1.44c.24-.04.48-.07.72-.07s.48.03.71.07l.23-1.44c.04-.22.06-.44.06-.63 0-.98-.37-1.91-1-2.63-.63.72-1 1.65-1 2.63zm1.71 9.93c-.23.04-.47.07-.71.07-.25 0-.49-.03-.72-.07l-.22 1.42c-.04.24-.06.45-.06.65 0 .98.37 1.91 1 2.63.63-.72 1-1.66 1-2.63 0-.19-.02-.41-.05-.63l-.24-1.44zm-5.84-5.81l1.38.52c.16-.44.4-.85.7-1.2L7.8 8.49c-.17-.15-.34-.27-.49-.35-.62-.36-1.3-.54-2-.54-.27 0-.54.03-.81.08.3.91.93 1.68 1.79 2.18.17.09.36.18.58.26zm0 3.74c-.22.08-.41.17-.58.27-.84.49-1.47 1.27-1.78 2.18.26.05.52.08.79.08.7 0 1.39-.19 2-.54.16-.09.32-.21.54-.37l1.13-.89c-.31-.36-.56-.78-.72-1.24l-1.38.51z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18.7 12.4c-.28-.16-.57-.29-.86-.4.29-.11.58-.24.86-.4 1.92-1.11 2.99-3.12 3-5.19-.91-.52-1.95-.8-3.01-.8-1.02 0-2.05.26-2.99.8-.28.16-.54.35-.78.54.05-.31.08-.63.08-.95 0-2.22-1.21-4.15-3-5.19C10.21 1.85 9 3.78 9 6c0 .32.03.64.08.95-.24-.2-.5-.39-.78-.55-.94-.54-1.97-.8-2.99-.8-1.05 0-2.1.28-3.01.8 0 2.07 1.07 4.08 3 5.19.28.16.57.29.86.4-.29.11-.58.24-.86.4-1.92 1.11-2.99 3.12-3 5.19.91.52 1.95.8 3.01.8 1.02 0 2.05-.26 2.99-.8.28-.16.54-.35.78-.54-.05.32-.08.64-.08.96 0 2.22 1.21 4.15 3 5.19 1.79-1.04 3-2.97 3-5.19 0-.32-.03-.64-.08-.95.24.2.5.38.78.54.94.54 1.97.8 2.99.8 1.05 0 2.1-.28 3.01-.8-.01-2.07-1.08-4.08-3-5.19zM4.51 7.68c.26-.06.53-.08.8-.08.69 0 1.38.18 1.99.54.15.09.32.2.49.35l1.15.96c-.3.36-.53.76-.7 1.2l-1.38-.52c-.21-.09-.4-.18-.56-.27-.87-.5-1.49-1.27-1.79-2.18zm3.33 7.79c-.21.17-.38.29-.54.37-.61.35-1.3.54-2 .54-.27 0-.53-.03-.79-.08.31-.91.94-1.69 1.78-2.18.17-.1.36-.18.58-.27l1.38-.52c.16.46.41.88.72 1.24l-1.13.9zM12 3.37c.63.72 1 1.66 1 2.63 0 .19-.02.41-.05.63l-.23 1.44C12.48 8.03 12.24 8 12 8s-.48.03-.71.07l-.23-1.44C11.02 6.41 11 6.19 11 6c0-.98.37-1.91 1-2.63zm0 17.26c-.63-.72-1-1.66-1-2.63 0-.2.02-.41.06-.65l.22-1.42c.23.04.47.07.72.07.24 0 .48-.03.71-.07l.23 1.44c.04.22.06.44.06.63 0 .98-.37 1.91-1 2.63zM12 14c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm4.16-5.48c.21-.17.38-.29.54-.37.61-.35 1.3-.54 2-.54.27 0 .53.03.79.08-.31.91-.94 1.69-1.78 2.18-.17.1-.36.18-.58.27l-1.38.52c-.17-.46-.41-.87-.72-1.24l1.13-.9zm2.53 7.87c-.69 0-1.38-.18-1.99-.54-.18-.1-.34-.22-.49-.34l-1.15-.96c.3-.36.54-.76.7-1.21l1.38.52c.22.08.41.17.57.26.85.49 1.47 1.27 1.78 2.18-.27.07-.54.09-.8.09z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 looks-6
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M11 13h2v2h-2zm8-8H5v14h14V5zm-4 4h-4v2h2c1.1 0 2 .89 2 2v2c0 1.11-.9 2-2 2h-2c-1.1 0-2-.89-2-2V9c0-1.11.9-2 2-2h4v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9 9v6c0 1.11.9 2 2 2h2c1.1 0 2-.89 2-2v-2c0-1.11-.9-2-2-2h-2V9h4V7h-4c-1.1 0-2 .89-2 2zm4 4v2h-2v-2h2zm-8 8h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2zM5 5h14v14H5V5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 iso
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M19 19V5L5 19h14zm-2-3.5V17h-5v-1.5h5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 15.5h5V17h-5zM19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM5.5 7.5h2v-2H9v2h2V9H9v2H7.5V9h-2V7.5zM19 19H5L19 5v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 leak-add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 21h3v-3c-1.66 0-3 1.34-3 3zM3 14c6.08 0 11-4.93 11-11h-2c0 4.97-4.03 9-9 9v2zm11 7h2c0-2.76 2.24-5 5-5v-2c-3.87 0-7 3.13-7 7zM3 10c3.87 0 7-3.13 7-7H8c0 2.76-2.24 5-5 5v2zm7 11h2c0-4.97 4.03-9 9-9v-2c-6.07 0-11 4.93-11 11zM3 3v3c1.66 0 3-1.34 3-3H3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _12mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M12,9 c0-0.55,0.45-1,1-1h2V7h-3V5.5h3.5c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1h-2v1h3v1.5H12V9z M7,5.5h3v6H8.5V7H7V5.5z M6,13.5 c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,11.5 10,11.5 10,5.5 7,5.5 7,7 8.5,7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.5,10h-3V9h2c0.55,0,1-0.45,1-1V6.5c0-0.55-0.45-1-1-1H12V7h3v1h-2c-0.55,0-1,0.45-1,1v2.5h4.5V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shutter-speed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 6c-3.87 0-7 3.13-7 7s3.13 7 7 7 7-3.13 7-7-3.13-7-7-7zm0 1c.46 0 .9.06 1.33.15l-2.72 4.7-2.32-3.56C9.31 7.49 10.6 7 12 7zm-6 6c0-1.54.59-2.95 1.55-4.01L10.81 14H6.09c-.05-.33-.09-.66-.09-1zm.35 2h5.33l-2.03 3.5.11.06c-1.59-.64-2.84-1.94-3.41-3.56zM12 19c-.48 0-.94-.06-1.39-.17l2.85-4.92 2.11 3.9c-1 .74-2.23 1.19-3.57 1.19zm6-6c0 1.6-.63 3.06-1.66 4.13L13.57 12h4.34c.05.33.09.66.09 1zm-5.74-2l2.05-3.54c1.56.65 2.77 1.94 3.34 3.54h-5.39z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M7.55 8.99C6.59 10.05 6 11.46 6 13c0 .34.04.67.09 1h4.72L7.55 8.99zm6.76-1.53L12.26 11h5.39c-.57-1.6-1.78-2.89-3.34-3.54zm-.98-.31C12.9 7.06 12.46 7 12 7c-1.4 0-2.69.49-3.71 1.29l2.32 3.56 2.72-4.7zM11.68 15H6.35c.57 1.62 1.82 2.92 3.41 3.56l-.11-.06 2.03-3.5zm7.35-7.61l1.42-1.42c-.43-.51-.9-.99-1.41-1.41l-1.42 1.42C16.07 4.74 14.12 4 12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9 9-4.03 9-9c0-2.12-.74-4.07-1.97-5.61zM12 20c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7zM9 1h6v2H9zm7.34 16.13C17.37 16.06 18 14.6 18 13c0-.34-.04-.67-.09-1h-4.34l2.77 5.13zm-5.73 1.7c.45.11.91.17 1.39.17 1.34 0 2.57-.45 3.57-1.19l-2.11-3.9-2.85 4.92z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _7mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M10,5.5 h3.5c0.67,0,1.15,0.65,0.96,1.29L13,11.5h-1.75L12.62,7H10V5.5z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3 H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.25,11.5H13l1.46-4.71c0.19-0.64-0.29-1.29-0.96-1.29H10V7h2.62L11.25,11.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-center-focus
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 5h4V3H5c-1.1 0-2 .9-2 2v4h2V5zm7 4c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zm7-6h-4v2h4v4h2V5c0-1.1-.9-2-2-2zm0 16h-4v2h4c1.1 0 2-.9 2-2v-4h-2v4zM5 15H3v4c0 1.1.9 2 2 2h4v-2H5v-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-neg-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M19 18V5h-.3L14 6.7v1.7l3-1.02V18zM4 11h8v2H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-plus-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 18V5h-.3L15 6.7v1.7l3-1.02V18zm-10-1v-4h4v-2h-4V7H8v4H4v2h4v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-filter
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 10v9H4.98V5h9V3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-9h-2zm-2.94-2.06L17 10l.94-2.06L20 7l-2.06-.94L17 4l-.94 2.06L14 7zM12 8l-1.25 2.75L8 12l2.75 1.25L12 16l1.25-2.75L16 12l-2.75-1.25z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hevc
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "5.5,11 4.5,11 4.5,9 3,9 3,15 4.5,15 4.5,12.5 5.5,12.5 5.5,15 7,15 7,9 5.5,9",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,11v-1c0-0.55-0.45-1-1-1h-2c-0.55,0-1,0.45-1,1v4c0,0.55,0.45,1,1,1h2c0.55,0,1-0.45,1-1v-1h-1.5v0.5h-1v-3h1V11H21z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "14.25,13.5 13.5,9 12,9 13,15 15.5,15 16.5,9 15,9",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8,9 8,15 11.5,15 11.5,13.5 9.5,13.5 9.5,12.5 11.5,12.5 11.5,11 9.5,11 9.5,10.5 11.5,10.5 11.5,9",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 timer-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.46 10.8c.12-.1.27-.18.45-.24s.4-.09.64-.09c.25 0 .47.04.66.11.19.07.35.17.48.29s.22.26.29.42c.06.16.1.32.1.49h1.95c0-.39-.08-.75-.24-1.09-.16-.34-.39-.63-.69-.88-.3-.25-.66-.44-1.09-.59-.43-.15-.92-.22-1.46-.22-.51 0-.98.07-1.39.21-.41.14-.77.33-1.06.57-.29.24-.51.52-.67.84-.16.32-.23.65-.23 1.01s.08.68.23.96c.15.28.37.52.64.73.27.21.6.38.98.53.38.14.81.26 1.27.36.39.08.71.17.95.26s.43.19.57.29c.13.1.22.22.27.34s.07.25.07.39c0 .32-.13.57-.4.77-.27.2-.66.29-1.17.29-.22 0-.43-.02-.64-.08-.21-.05-.4-.13-.56-.24-.17-.11-.3-.26-.41-.44s-.17-.41-.18-.67h-1.89c0 .36.08.71.24 1.05.16.34.39.65.7.93.31.27.69.49 1.15.66.46.17.98.25 1.58.25.53 0 1.01-.06 1.44-.19.43-.13.8-.31 1.11-.54.31-.23.54-.51.71-.83.17-.32.25-.67.25-1.06-.02-.4-.09-.74-.24-1.02-.14-.28-.35-.53-.63-.74-.28-.21-.61-.39-1.01-.53s-.85-.27-1.35-.38c-.35-.07-.64-.15-.87-.23s-.41-.16-.55-.25c-.14-.09-.23-.19-.28-.3-.05-.11-.08-.24-.08-.39s.03-.28.09-.41c.06-.13.15-.25.27-.34zm-8.34 5.71c-.29 0-.56-.04-.8-.13-.24-.08-.44-.2-.61-.36-.17-.16-.3-.34-.39-.56-.09-.22-.14-.46-.14-.72H4.19c0 .55.11 1.03.32 1.45.21.42.5.77.86 1.05s.77.49 1.24.63.96.21 1.48.21c.57 0 1.09-.08 1.58-.23.49-.15.91-.38 1.26-.68.36-.3.64-.66.84-1.1.2-.43.3-.93.3-1.48 0-.29-.04-.58-.11-.86-.08-.25-.19-.51-.35-.76-.16-.24-.36-.46-.62-.65-.25-.19-.56-.35-.93-.48.3-.14.57-.3.8-.5.23-.2.42-.41.57-.64.15-.23.27-.46.34-.71.08-.24.11-.49.11-.73 0-.55-.09-1.04-.28-1.46-.18-.42-.44-.77-.78-1.06-.33-.28-.73-.5-1.2-.64-.45-.13-.97-.2-1.53-.2-.55 0-1.06.08-1.52.24-.47.17-.87.4-1.2.69-.33.29-.6.63-.78 1.03-.2.39-.29.83-.29 1.29h1.98c0-.26.05-.49.14-.69.09-.2.22-.38.38-.52.17-.14.36-.25.58-.33.22-.08.46-.12.73-.12.61 0 1.06.16 1.36.47.3.31.44.75.44 1.32 0 .27-.04.52-.12.74-.08.22-.21.41-.38.57-.17.16-.38.28-.63.37-.25.09-.55.13-.89.13H6.72v1.57H7.9c.34 0 .64.04.91.11.27.08.5.19.69.35.19.16.34.36.44.61.1.24.16.54.16.87 0 .62-.18 1.09-.53 1.42-.35.33-.84.49-1.45.49z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 image-not-supported
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M7.83,5H19v11.17L7.83,5z M16.17,19l-2-2H6l3-4l2,2.72l0.84-1.05L5,7.83V19H16.17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5.83,3H19c1.1,0,2,0.9,2,2v13.17l-2-2V5H7.83L5.83,3z M20.49,23.31L18.17,21H5c-1.1,0-2-0.9-2-2V5.83L0.69,3.51L2.1,2.1 l1.49,1.49L5,5l8.11,8.11l2.69,2.69L19,19l1.41,1.41l1.49,1.49L20.49,23.31z M16.17,19l-2-2H6l3-4l2,2.72l0.84-1.05L5,7.83V19 H16.17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 photo-camera-back
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M15.95,7l-1.83-2H9.88L8.05,7H4v12h16V7H15.95z M6,17l3-4l2.25,3l3-4L18,17H6z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M20,5h-3.17L15,3H9L7.17,5H4C2.9,5,2,5.9,2,7v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V7C22,5.9,21.1,5,20,5z M20,19H4V7 h4.05l1.83-2h4.24l1.83,2H20V19z M11.25,16L9,13l-3,4h12l-3.75-5L11.25,16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 filter-frames
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M8 10h8v6H8z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M20 4h-4l-4-4-4 4H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 16H4V6h4.52l3.52-3.5L15.52 6H20v14zM6 18h12V8H6v10zm2-8h8v6H8v-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dehaze
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M2 16v2h20v-2H2zm0-5v2h20v-2H2zm0-5v2h20V6H2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-5-4
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,4H5C3.9,4,3,4.9,3,6v12c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V6C21,4.9,20.1,4,19,4z M19,18H5V6h14V18z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 movie-creation
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M4 6.47V18h16v-8H5.76z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18 4l2 4h-3l-2-4h-2l2 4h-3l-2-4H8l2 4H7L5 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4h-4zm2 14H4V6.47L5.76 10H20v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 control-point
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8zm5 9h-4v4h-2v-4H7v-2h4V7h2v4h4v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.49 2 2 6.49 2 12s4.49 10 10 10 10-4.49 10-10S17.51 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm1-13h-2v4H7v2h4v4h2v-4h4v-2h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-drama
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 12h-1.5v-.5C17.5 8.47 15.03 6 12 6c-1.8 0-3.39.88-4.4 2.22 2.54.7 4.4 3.02 4.4 5.78h-2c0-2.21-1.79-4-4-4s-4 1.79-4 4 1.79 4 4 4h13c1.65 0 3-1.35 3-3s-1.35-3-3-3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.61 5.64 5.36 8.04 2.35 8.36 0 10.9 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4h2c0-2.76-1.86-5.08-4.4-5.78C8.61 6.88 10.2 6 12 6c3.03 0 5.5 2.47 5.5 5.5v.5H19c1.65 0 3 1.35 3 3s-1.35 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-rupee
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13.66,7C13.1,5.82,11.9,5,10.5,5L6,5V3h12v2l-3.26,0c0.48,0.58,0.84,1.26,1.05,2L18,7v2l-2.02,0c-0.25,2.8-2.61,5-5.48,5 H9.77l6.73,7h-2.77L7,14v-2h3.5c1.76,0,3.22-1.3,3.46-3L6,9V7L13.66,7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _24mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17c0.55,0,1,0.45,1,1V16z M13,5.5h1.5v3H16v-3 h1.5v3h1V10h-1v1.5H16V10h-3V5.5z M6.5,9c0-0.55,0.45-1,1-1h2V7h-3V5.5H10c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1H8v1h3v1.5H6.5V9 z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,12.5h-3.5v6H15V17h2c0.55,0,1-0.45,1-1v-2.5C18,12.95,17.55,12.5,17,12.5z M16.5,15.5H15V14h1.5V15.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,10H8V9h2c0.55,0,1-0.45,1-1V6.5c0-0.55-0.45-1-1-1H6.5V7h3v1h-2c-0.55,0-1,0.45-1,1v2.5H11V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "16,11.5 17.5,11.5 17.5,10 18.5,10 18.5,8.5 17.5,8.5 17.5,5.5 16,5.5 16,8.5 14.5,8.5 14.5,5.5 13,5.5 13,10 16,10",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 hide-image
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "16.17,19 14.17,17 6,17 9,13 11.25,16 12.07,14.9 5,7.83 5,19",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "7.83,5 19,16.17 19,5",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M19,5v11.17l2,2V5c0-1.1-0.9-2-2-2H5.83l2,2H19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.81,2.81L1.39,4.22L3,5.83V19c0,1.1,0.9,2,2,2h13.17l1.61,1.61l1.41-1.41L2.81,2.81z M5,19V7.83l7.07,7.07L11.25,16 L9,13l-3,4h8.17l2,2H5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 raw-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6.5,9H3v6h1.5v-2h1.1l0.9,2H8l-0.9-2.1C7.6,12.6,8,12.1,8,11.5v-1C8,9.7,7.3,9,6.5,9z M6.5,11.5h-2v-1h2V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.25,9l-1.5,6h1.5l0.38-1.5h1.75l0.37,1.5h1.5l-1.5-6H10.25z M11,12l0.25-1h0.5L12,12H11z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "19.98,9 19.24,12 18.5,9 16.98,9 16.24,12 15.5,9 14,9 15.5,15 16.98,15 17.74,11.96 18.5,15 19.98,15 21.48,9",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 panorama-photosphere
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M3,9.91l0,4.18c0,0,0,0,0,0C5.19,15.3,8.47,16,12,16c3.53,0,6.81-0.69,9-1.91l0-4.18c0,0,0,0,0,0 C18.81,8.7,15.53,8,12,8C8.47,8,5.2,8.69,3,9.91z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.95,8.15c-0.29-0.16-0.61-0.31-0.93-0.46C19.4,4.33,15.98,2,12,2C8.02,2,4.6,4.33,2.99,7.68 c-0.33,0.15-0.64,0.3-0.93,0.46C1.41,8.5,1,9.17,1,9.91v4.18c0,0.74,0.41,1.41,1.05,1.77c0.29,0.16,0.61,0.31,0.93,0.46 C4.6,19.67,8.02,22,12,22c3.98,0,7.4-2.33,9.01-5.68c0.33-0.15,0.64-0.3,0.93-0.46C22.59,15.5,23,14.83,23,14.09V9.91 C23,9.17,22.59,8.5,21.95,8.15z M12,4c2.37,0,4.49,1.04,5.95,2.68C16.17,6.25,14.15,6,12,6C9.85,6,7.83,6.25,6.05,6.68 C7.51,5.04,9.63,4,12,4z M12,20c-2.37,0-4.49-1.04-5.95-2.68C7.83,17.75,9.85,18,12,18s4.17-0.25,5.95-0.68 C16.49,18.96,14.37,20,12,20z M21,9.91l0,4.18C18.81,15.31,15.53,16,12,16c-3.53,0-6.81-0.7-9-1.91c0,0,0,0,0,0l0-4.18 C5.2,8.69,8.47,8,12,8C15.53,8,18.81,8.7,21,9.91C21,9.91,21,9.91,21,9.91z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M10.9 19.91c.36.05.72.09 1.1.09 2.18 0 4.16-.88 5.61-2.3L14.89 13l-3.99 6.91zm-1.04-.21l2.71-4.7H4.59c.93 2.28 2.87 4.03 5.27 4.7zM8.54 12L5.7 7.09C4.64 8.45 4 10.15 4 12c0 .69.1 1.36.26 2h5.43l-1.15-2zm9.76 4.91C19.36 15.55 20 13.85 20 12c0-.69-.1-1.36-.26-2h-5.43l3.99 6.91zM13.73 9h5.68c-.93-2.28-2.88-4.04-5.28-4.7L11.42 9h2.31zm-3.46 0l2.83-4.92C12.74 4.03 12.37 4 12 4c-2.18 0-4.16.88-5.6 2.3L9.12 11l1.15-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 22c5.52 0 10-4.48 10-10 0-4.75-3.31-8.72-7.75-9.74l-.08-.04-.01.02C13.46 2.09 12.74 2 12 2 6.48 2 2 6.48 2 12s4.48 10 10 10zm0-2c-.38 0-.74-.04-1.1-.09L14.89 13l2.72 4.7C16.16 19.12 14.18 20 12 20zm8-8c0 1.85-.64 3.55-1.7 4.91l-4-6.91h5.43c.17.64.27 1.31.27 2zm-.59-3h-7.99l2.71-4.7c2.4.66 4.35 2.42 5.28 4.7zM12 4c.37 0 .74.03 1.1.08L10.27 9l-1.15 2L6.4 6.3C7.84 4.88 9.82 4 12 4zm-8 8c0-1.85.64-3.55 1.7-4.91L8.54 12l1.15 2H4.26C4.1 13.36 4 12.69 4 12zm6.27 3h2.3l-2.71 4.7c-2.4-.67-4.35-2.42-5.28-4.7h5.69z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 deblur
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1", :cy "14", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "18", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "10", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "10", :cx "3", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "6", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "14", :cx "3", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "21", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "3", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "6", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "10", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "18", :cx "10", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M12,3v2c3.86,0,7,3.14,7,7s-3.14,7-7,7v2c4.96,0,9-4.04,9-9S16.96,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M12,5v14c3.86,0,7-3.14,7-7S15.86,5,12,5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 wb-auto
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M8 6c-3.31 0-6 2.69-6 6s2.69 6 6 6c2.35 0 4.38-1.36 5.36-3.32l.01-.01c.4-.81.63-1.71.63-2.67 0-3.31-2.69-6-6-6zm2.3 10l-.7-2H6.4l-.7 2H3.8L7 7h2l3.2 9h-1.9zm-3.45-3.35h2.3L8 9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M7 7l-3.2 9h1.9l.7-2h3.2l.7 2h1.9L9 7H7zm-.15 5.65L8 9l1.15 3.65h-2.3zm13.95.64L19.3 7h-1.6l-1.49 6.29L15 7h-.76l-.01.01C12.76 5.18 10.53 4 8 4c-4.42 0-8 3.58-8 8s3.58 8 8 8c2.96 0 5.55-1.61 6.93-4 .03-.06.05-.12.08-.18.05-.08.09-.17.14-.25l.1.43H17l1.5-6.1L20 16h1.75l2.05-9H22l-1.2 6.29zm-7.43 1.38C12.38 16.64 10.35 18 8 18c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6c0 .96-.23 1.86-.63 2.67z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 17h14V3H7v14zm4-4h4v-2h-4V5h6v2h-4v2h2c1.1 0 2 .89 2 2v2c0 1.11-.9 2-2 2h-4v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 23v-2H3V5H1v16c0 1.1.9 2 2 2h16zm-2-10v-2c0-1.11-.9-2-2-2h-2V7h4V5h-6v6h4v2h-4v2h4c1.1 0 2-.89 2-2zm4-12H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 17h14V3H7v14zm4-6c0-1.11.9-2 2-2h2V7h-4V5h4c1.1 0 2 .89 2 2v2c0 1.11-.9 2-2 2h-2v2h4v2h-6v-4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17 13h-4v-2h2c1.1 0 2-.89 2-2V7c0-1.11-.9-2-2-2h-4v2h4v2h-2c-1.1 0-2 .89-2 2v4h6v-2zm4-12H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zM1 21c0 1.1.9 2 2 2h16v-2H3V5H1v16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 face-retouching-natural
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M10.66,4.12c2.55,4.23,7.03,3.87,7.18,3.86l-0.57-1.25L12.4,4.5l0.85-0.39C12.84,4.04,12.43,4,12,4 C11.54,4,11.09,4.05,10.66,4.12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M8.08,5.03C6.37,6,5.05,7.58,4.42,9.47C6.13,8.5,7.45,6.92,8.08,5.03z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.89,10.75C19.96,11.16,20,11.57,20,12c0,4.41-3.59,8-8,8s-8-3.59-8-8c0-0.05,0.01-0.1,0-0.14 c2.6-0.98,4.69-2.99,5.74-5.55c3.38,4.14,7.97,3.73,8.99,3.61l-0.89-1.93c-0.13,0.01-4.62,0.38-7.18-3.86 c1.01-0.16,1.71-0.15,2.59-0.01l2.12-0.97l0.64-0.29C14.78,2.3,13.43,2,12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10 c0-1.43-0.3-2.78-0.84-4.01L19.89,10.75z M8.08,5.03C7.45,6.92,6.13,8.5,4.42,9.47C5.05,7.58,6.37,6,8.08,5.03z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "15", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points
      "20.6,3.4 19.5,1 18.4,3.4 16,4.5 18.4,5.6 19.5,8 20.6,5.6 23,4.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-b-and-w
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M19 5h-7v6l7 8zm-7 14v-8l-7 8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 19V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2zm-9 0H5l7-8V5h7v14l-7-8v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-horizontal-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M4,6.38v11.25c2.01-0.59,4.61-1.13,8-1.13c3.38,0,5.99,0.54,8,1.13V6.37 c-2.01,0.59-4.62,1.13-8,1.13C9.32,7.5,6.58,7.11,4,6.38z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.01,4C20.45,4,17.4,5.5,12,5.5c-5.31,0-8.49-1.49-9.01-1.49C2.46,4.01,2,4.45,2,5.02V19c0,0.57,0.46,1,0.99,1 c0.57,0,3.55-1.5,9.01-1.5c5.42,0,8.44,1.5,9.01,1.5c0.53,0,0.99-0.43,0.99-1V5C22,4.43,21.54,4,21.01,4z M20,17.63 c-2.01-0.59-4.62-1.13-8-1.13c-3.39,0-5.99,0.54-8,1.13V6.38C6.58,7.11,9.32,7.5,12,7.5c3.38,0,5.99-0.54,8-1.13V17.63z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 hdr-enhanced-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,4C9.79,4,8,5.79,8,8s1.79,4,4,4s4-1.79,4-4S14.21,4,12,4z M15,9h-2v2h-2V9H9V7h2V5h2v2h2V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C8.69,2,6,4.69,6,8s2.69,6,6,6s6-2.69,6-6S15.31,2,12,2z M12,12c-2.21,0-4-1.79-4-4s1.79-4,4-4s4,1.79,4,4 S14.21,12,12,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "13,5 11,5 11,7 9,7 9,9 11,9 11,11 13,11 13,9 15,9 15,7 13,7",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "3.5,18 1.5,18 1.5,16 0,16 0,22 1.5,22 1.5,19.5 3.5,19.5 3.5,22 5,22 5,16 3.5,16",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "22,18.5 22,16.5 20.5,16.5 20.5,18.5 18.5,18.5 18.5,20 20.5,20 20.5,22 22,22 22,20 24,20 24,18.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.5,16H13v6h1.5v-2h1.1l0.9,2H18l-0.9-2.1c0.5-0.3,0.9-0.8,0.9-1.4v-1C18,16.7,17.3,16,16.5,16z M16.5,18.5h-2v-1h2 V18.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,16H6.5v6H10c0.8,0,1.5-0.7,1.5-1.5v-3C11.5,16.7,10.8,16,10,16z M10,20.5H8v-3h2V20.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _60fps-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,6v6h-3V6H18z M18,4h-3c-1.1,0-2,0.9-2,2v6c0,1.1,0.9,2,2,2h3c1.1,0,2-0.9,2-2V6C20,4.9,19.1,4,18,4z M11,6V4H6 C4.9,4,4,4.9,4,6v6c0,1.1,0.9,2,2,2h3c1.1,0,2-0.9,2-2v-2c0-1.1-0.9-2-2-2H6V6H11z M9,10v2H6v-2H9z M5,22H3v-5h2V22z M9,22H7v-5h2 V22z M13,22h-2v-5h2V22z M21,22h-6v-5h6V22z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 thermostat-auto
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M9.8,13.6L9,13V6c0-0.55-0.45-1-1-1S7,5.45,7,6v7l-0.8,0.6C5.45,14.16,5,15.06,5,16h6 C11,15.06,10.55,14.17,9.8,13.6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,12V6c0-1.66-1.34-3-3-3S5,4.34,5,6v6c-1.21,0.91-2,2.37-2,4c0,1.12,0.38,2.14,1,2.97V19h0.02c0.91,1.21,2.35,2,3.98,2 s3.06-0.79,3.98-2H12v-0.03c0.62-0.83,1-1.85,1-2.97C13,14.37,12.21,12.91,11,12z M5,16c0-0.94,0.45-1.84,1.2-2.4L7,13V6 c0-0.55,0.45-1,1-1s1,0.45,1,1v7l0.8,0.6c0.75,0.57,1.2,1.46,1.2,2.4H5z M18.62,4h-1.61l-3.38,9h1.56L16,10.7h3.63l0.8,2.3H22 L18.62,4z M16.47,9.39l1.31-3.72h0.08l1.31,3.72H16.47z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 control-point-duplicate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M15 5c-3.86 0-7 3.14-7 7s3.14 7 7 7 7-3.14 7-7-3.14-7-7-7zm4 8h-3v3h-2v-3h-3v-2h3V8h2v3h3v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16 8h-2v3h-3v2h3v3h2v-3h3v-2h-3zm-1-5c-4.96 0-9 4.04-9 9s4.04 9 9 9 9-4.04 9-9-4.04-9-9-9zm0 16c-3.86 0-7-3.14-7-7s3.14-7 7-7 7 3.14 7 7-3.14 7-7 7zM2 12c0-2.79 1.64-5.2 4.01-6.32V3.52C2.52 4.76 0 8.09 0 12s2.52 7.24 6.01 8.48v-2.16C3.64 17.2 2 14.79 2 12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 17h14V3H7v14zm4-4h4v-2h-2V9h2V7h-4V5h4c1.1 0 2 .89 2 2v1.5c0 .83-.67 1.5-1.5 1.5.83 0 1.5.67 1.5 1.5V13c0 1.11-.9 2-2 2h-4v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 1H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zm-4-4v-1.5c0-.83-.67-1.5-1.5-1.5.83 0 1.5-.67 1.5-1.5V7c0-1.11-.9-2-2-2h-4v2h4v2h-2v2h2v2h-4v2h4c1.1 0 2-.89 2-2zm2 10v-2H3V5H1v16c0 1.1.9 2 2 2h16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timer
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,6c-3.87,0-7,3.13-7,7s3.13,7,7,7s7-3.13,7-7S15.87,6,12,6z M13,14h-2V8h2V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "1", :x "9", :width "6", :height "2", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M19.03,7.39l1.42-1.42c-0.43-0.51-0.9-0.99-1.41-1.41l-1.42,1.42C16.07,4.74,14.12,4,12,4c-4.97,0-9,4.03-9,9 c0,4.97,4.02,9,9,9s9-4.03,9-9C21,10.88,20.26,8.93,19.03,7.39z M12,20c-3.87,0-7-3.13-7-7s3.13-7,7-7s7,3.13,7,7S15.87,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8",
      :x "11",
      :width "2",
      :height "6",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 wb-incandescent
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14 8.59l-1-.58V4.05h-2v3.96l-1 .58c-1.24.72-2 2.04-2 3.46 0 2.21 1.79 4 4 4s4-1.79 4-4c0-1.42-.77-2.74-2-3.46z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3.55 19.09l1.41 1.41 1.79-1.8-1.41-1.41zM11 20h2v3h-2zM1 11h3v2H1zm14-4.14V2.05H9v4.81C7.21 7.9 6 9.83 6 12.05c0 3.31 2.69 6 6 6s6-2.69 6-6c0-2.22-1.21-4.15-3-5.19zm-3 9.19c-2.21 0-4-1.79-4-4 0-1.42.77-2.74 2-3.46l1-.58V4.05h2v3.96l1 .58c1.24.72 2 2.04 2 3.46 0 2.21-1.79 4-4 4zM20 11h3v2h-3zm-2.76 7.71l1.79 1.8 1.41-1.41-1.8-1.79z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 straighten
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M19 12h-2V8h-2v4h-2V8h-2v4H9V8H7v4H5V8H3v8h18V8h-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 6H3c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 10H3V8h2v4h2V8h2v4h2V8h2v4h2V8h2v4h2V8h2v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _20mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M13,6.5 c0-0.55,0.45-1,1-1h2.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H14c-0.55,0-1-0.45-1-1V6.5z M6.5,9c0-0.55,0.45-1,1-1h2V7h-3V5.5 H10c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1H8v1h3v1.5H6.5V9z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5 v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7",
      :x "14.5",
      :width "1.5",
      :opacity ".3",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,12.5v6H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1H13.5z M16.5,15.5H15V14h1.5V15.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14,11.5h2.5c0.55,0,1-0.45,1-1v-4c0-0.55-0.45-1-1-1H14c-0.55,0-1,0.45-1,1v4C13,11.05,13.45,11.5,14,11.5z M14.5,7H16v3 h-1.5V7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,10H8V9h2c0.55,0,1-0.45,1-1V6.5c0-0.55-0.45-1-1-1H6.5V7h3v1h-2c-0.55,0-1,0.45-1,1v2.5H11V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-4
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M21 3H7v14h14V3zm-4 12h-2v-4h-4V5h2v4h2V5h2v10z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 23h16v-2H3V5H1v16c0 1.1.9 2 2 2zm4-4h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2zM7 3h14v14H7V3zm8 6h-2V5h-2v6h4v4h2V5h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-fish-eye
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 17c0 1.1.9 2 2 2h10v4h2v-4h4v-2H7V1H5v4H1v2h4v10zm14-2V7c0-1.1-.9-2-2-2H9v2h8v8h2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timelapse
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 3.99c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8-3.58-8-8-8zm4.25 12.24c-2.35 2.34-6.15 2.34-8.49 0L12 11.99v-6c1.54 0 3.07.59 4.24 1.76 2.35 2.34 2.35 6.14.01 8.48z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16.24 7.75c-1.17-1.17-2.7-1.76-4.24-1.76v6l-4.24 4.24c2.34 2.34 6.14 2.34 8.49 0 2.34-2.34 2.34-6.14-.01-8.48zM12 1.99c-5.52 0-10 4.48-10 10s4.48 10 10 10 10-4.48 10-10-4.48-10-10-10zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _30fps-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M4,4v2h5v2H5v2h4v2H4v2h5c1.1,0,2-0.9,2-2v-1.5C11,9.67,10.83,9,10,9c0.83,0,1-0.67,1-1.5V6c0-1.1-0.9-2-2-2H4z M18,4 c1.1,0,2,0.9,2,2v6c0,1.1-0.9,2-2,2h-3c-1.1,0-2-0.9-2-2V6c0-1.1,0.9-2,2-2H18z M18,6h-3v6h3V6z M5,22H3v-5h2V22z M9,22H7v-5h2V22 z M13,22h-2v-5h2V22z M21,22h-6v-5h6V22z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _15mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M12,10h3 V9h-3V5.5h4.5V7h-3v1h2c0.55,0,1,0.45,1,1v1.5c0,0.55-0.45,1-1,1H12V10z M7,5.5h3v6H8.5V7H7V5.5z M6,13.5c0-0.55,0.45-1,1-1h4.5 c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,11.5 10,11.5 10,5.5 7,5.5 7,7 8.5,7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.5,10.5V9c0-0.55-0.45-1-1-1h-2V7h3V5.5H12V9h3v1h-3v1.5h3.5C16.05,11.5,16.5,11.05,16.5,10.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 color-lens
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8c.28 0 .5-.22.5-.5 0-.16-.08-.28-.14-.35-.41-.46-.63-1.05-.63-1.65 0-1.38 1.12-2.5 2.5-2.5H16c2.21 0 4-1.79 4-4 0-3.86-3.59-7-8-7zm-5.5 9c-.83 0-1.5-.67-1.5-1.5S5.67 10 6.5 10s1.5.67 1.5 1.5S7.33 13 6.5 13zm3-4C8.67 9 8 8.33 8 7.5S8.67 6 9.5 6s1.5.67 1.5 1.5S10.33 9 9.5 9zm5 0c-.83 0-1.5-.67-1.5-1.5S13.67 6 14.5 6s1.5.67 1.5 1.5S15.33 9 14.5 9zm4.5 2.5c0 .83-.67 1.5-1.5 1.5s-1.5-.67-1.5-1.5.67-1.5 1.5-1.5 1.5.67 1.5 1.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.49 2 2 6.49 2 12s4.49 10 10 10c1.38 0 2.5-1.12 2.5-2.5 0-.61-.23-1.21-.64-1.67-.08-.09-.13-.21-.13-.33 0-.28.22-.5.5-.5H16c3.31 0 6-2.69 6-6 0-4.96-4.49-9-10-9zm4 13h-1.77c-1.38 0-2.5 1.12-2.5 2.5 0 .61.22 1.19.63 1.65.06.07.14.19.14.35 0 .28-.22.5-.5.5-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.14 8 7c0 2.21-1.79 4-4 4z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "11.5", :cx "6.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "7.5", :cx "9.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "7.5", :cx "14.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "11.5", :cx "17.5", :stroke nil, :fill nil})))


(helix.core/defnc
 portrait
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5 19h14V5H5v14zm7-13c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3zM6 16.58C6 14.08 9.97 13 12 13s6 1.08 6 3.58V18H6v-1.42z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 12c1.65 0 3-1.35 3-3s-1.35-3-3-3-3 1.35-3 3 1.35 3 3 3zm0-4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm6 8.58c0-2.5-3.97-3.58-6-3.58s-6 1.08-6 3.58V18h12v-1.42zM8.48 16c.74-.51 2.23-1 3.52-1s2.78.49 3.52 1H8.48zM19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flash-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 10h-3.61l2.28 2.28zm0-8H7v1.61l6.13 6.13zm-13.59.86L2 4.27l5 5V13h3v9l3.58-6.15L17.73 20l1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-stories
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M3,6.71v9.91C4.14,16.21,5.31,16,6.5,16c1.19,0,2.36,0.21,3.5,0.62V6.72C8.89,6.25,7.7,6,6.5,6 C5.28,6,4.11,6.24,3,6.71z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "19,0.5 14,5.5 14,15 19,10.5", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M22.47,5.2C22,4.96,21.51,4.76,21,4.59v12.03C19.86,16.21,18.69,16,17.5,16c-1.9,0-3.78,0.54-5.5,1.58V5.48 C10.38,4.55,8.51,4,6.5,4C4.71,4,3.02,4.44,1.53,5.2C1.2,5.36,1,5.71,1,6.08v12.08c0,0.58,0.47,0.99,1,0.99 c0.16,0,0.32-0.04,0.48-0.12C3.69,18.4,5.05,18,6.5,18c2.07,0,3.98,0.82,5.5,2c1.52-1.18,3.43-2,5.5-2c1.45,0,2.81,0.4,4.02,1.04 c0.16,0.08,0.32,0.12,0.48,0.12c0.52,0,1-0.41,1-0.99V6.08C23,5.71,22.8,5.36,22.47,5.2z M10,16.62C8.86,16.21,7.69,16,6.5,16 c-1.19,0-2.36,0.21-3.5,0.62V6.71C4.11,6.24,5.28,6,6.5,6C7.7,6,8.89,6.25,10,6.72V16.62z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cases
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "7",
      :x "7",
      :width "14",
      :opacity ".3",
      :height "9",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M3,9H1v11c0,1.11,0.89,2,2,2h17v-2H3V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,5V3c0-1.1-0.9-2-2-2h-4c-1.1,0-2,0.9-2,2v2H5v11c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5H18z M12,3h4v2h-4V3z M21,16H7 V7h14V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 grid-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M10 10h4v4h-4zm0 6h4v4h-4zM4 4h4v4H4zm0 6h4v4H4zm0 6h4v4H4zM16 4h4v4h-4zm0 6h4v4h-4zm0 6h4v4h-4zM10 4h4v4h-4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM8 20H4v-4h4v4zm0-6H4v-4h4v4zm0-6H4V4h4v4zm6 12h-4v-4h4v4zm0-6h-4v-4h4v4zm0-6h-4V4h4v4zm6 12h-4v-4h4v4zm0-6h-4v-4h4v4zm0-6h-4V4h4v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 animation
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,12c-0.63,0.84-1,1.88-1,3c0,2.76,2.24,5,5,5c1.12,0,2.16-0.37,3-1C8.13,19,5,15.87,5,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M15,4c-1.13,0-2.16,0.37-3,1c3.87,0.01,7,3.14,7,7c0.63-0.84,1-1.88,1-3C20,6.24,17.76,4,15,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,7c-0.6,0-1.17,0.11-1.7,0.3C10.11,7.83,10,8.4,10,9c0,2.76,2.24,5,5,5c0.6,0,1.17-0.11,1.7-0.3 c0.19-0.53,0.3-1.1,0.3-1.7C17,9.24,14.76,7,12,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M8,9c-0.63,0.84-1,1.88-1,3c0,2.76,2.24,5,5,5c1.12,0,2.16-0.37,3-1C11.13,15.99,8,12.86,8,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15,2c-2.71,0-5.05,1.54-6.22,3.78c-1.28,0.67-2.34,1.72-3,3C3.54,9.95,2,12.29,2,15c0,3.87,3.13,7,7,7 c2.71,0,5.05-1.54,6.22-3.78c1.28-0.67,2.34-1.72,3-3C20.46,14.05,22,11.71,22,9C22,5.13,18.87,2,15,2z M9,20c-2.76,0-5-2.24-5-5 c0-1.12,0.37-2.16,1-3c0,3.87,3.13,7,7,7C11.16,19.63,10.12,20,9,20z M12,17c-2.76,0-5-2.24-5-5c0-1.12,0.37-2.16,1-3 c0,3.86,3.13,6.99,7,7C14.16,16.63,13.12,17,12,17z M16.7,13.7C16.17,13.89,15.6,14,15,14c-2.76,0-5-2.24-5-5 c0-0.6,0.11-1.17,0.3-1.7C10.83,7.11,11.4,7,12,7c2.76,0,5,2.24,5,5C17,12.6,16.89,13.17,16.7,13.7z M19,12c0-3.86-3.13-6.99-7-7 c0.84-0.63,1.87-1,3-1c2.76,0,5,2.24,5,5C20,10.12,19.63,11.16,19,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flip
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 7h2v2h-2zm0 14c1.1 0 2-.9 2-2h-2v2zm0-6h2v2h-2zm0-4h2v2h-2zM9 5V3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h4v-2H5V5h4zm10-2v2h2c0-1.1-.9-2-2-2zm-8-2h2v22h-2zm4 2h2v2h-2zm0 16h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 details
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M13,8.92L18.6,19H13V8.92z M11,8.92V19H5.4L11,8.92z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12,3L2,21h20L12,3z M13,8.92L18.6,19H13V8.92z M11,8.92V19H5.4L11,8.92z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-camera-back
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,18h12V6H4V18z M7.38,12.83L9,15l2.62-3.5L15,16H5L7.38,12.83z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11.62,11.5 9,15 7.38,12.83 5,16 15,16",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,10.48V6c0-1.1-0.9-2-2-2H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-4.48l4,3.98v-11L18,10.48z M16,18 H4V6h12V18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-a-photo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M6 7v3H5v10h16V8h-4.05l-1.83-2H9v1H6zm7 2c2.76 0 5 2.24 5 5s-2.24 5-5 5-5-2.24-5-5 2.24-5 5-5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 6h-3.17L16 4H9v2h6.12l1.83 2H21v12H5V10H3v10c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zM8 14c0 2.76 2.24 5 5 5s5-2.24 5-5-2.24-5-5-5-5 2.24-5 5zm5-3c1.65 0 3 1.35 3 3s-1.35 3-3 3-3-1.35-3-3 1.35-3 3-3zM5 9V6h3V4H5V1H3v3H0v2h3v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 style
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M15.22 4.75L7.87 7.79l4.96 11.96 7.35-3.05-4.96-11.95zM11 10c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3.87 11.18l-2.43 5.86c-.41 1.02.08 2.19 1.09 2.61l1.34.56v-9.03zm18.16 4.77L17.07 3.98c-.31-.75-1.04-1.21-1.81-1.23-.26 0-.53.04-.79.15L7.1 5.95c-.75.31-1.21 1.03-1.23 1.8-.01.27.04.54.15.8l4.96 11.97c.31.76 1.05 1.22 1.83 1.23.26 0 .52-.05.77-.15l7.36-3.05c1.02-.42 1.51-1.59 1.09-2.6zm-9.2 3.8L7.87 7.79l7.35-3.04h.01l4.95 11.95-7.35 3.05z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "9", :cx "11", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M9.33 21.75l-3.45-8.34v6.34c0 1.1.9 2 2 2h1.45z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-vertical-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.5,12c0-3.89,0.84-6.95,1.43-8.69C20.15,2.67,19.67,2,18.98,2L5,2C4.32,2,3.84,2.66,4.05,3.31C4.74,5.36,5.5,8.1,5.5,12 c0,3.87-0.76,6.66-1.45,8.69C3.84,21.34,4.32,22,5,22h14c0.68,0,1.17-0.66,0.95-1.31C19.27,18.66,18.5,15.86,18.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 currency-ruble
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13.5,3H7v9H5v2h2v2H5v2h2v3h2v-3h4v-2H9v-2h4.5c3.04,0,5.5-2.46,5.5-5.5C19,5.46,16.54,3,13.5,3z M13.5,12H9V5h4.5 C15.43,5,17,6.57,17,8.5S15.43,12,13.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 crop-din
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-square
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 4H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H6V6h12v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 nature
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12.17 4.17c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.25-5-5-5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.17 9.17c0-3.87-3.13-7-7-7s-7 3.13-7 7c0 3.47 2.52 6.34 5.83 6.89V20H5v2h14v-2h-6v-3.88h-.03c3.49-.4 6.2-3.36 6.2-6.95zm-7 5c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.25 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-fix-normal
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14.29",
      :x "3.64",
      :width "10.14",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 -8.2634 10.636)",
      :opacity ".3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20,7 20.94,4.94 23,4 20.94,3.06 20,1 19.06,3.06 17,4 19.06,4.94",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.71,9.12l-2.83-2.83C14.68,6.1,14.43,6,14.17,6c-0.26,0-0.51,0.1-0.71,0.29L2.29,17.46c-0.39,0.39-0.39,1.02,0,1.41 l2.83,2.83C5.32,21.9,5.57,22,5.83,22s0.51-0.1,0.71-0.29l11.17-11.17C18.1,10.15,18.1,9.51,17.71,9.12z M5.83,19.59l-1.41-1.41 L11.59,11L13,12.41L5.83,19.59z M14.41,11L13,9.59l1.17-1.17l1.41,1.41L14.41,11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _11mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M13,5.5h3 v6h-1.5V7H13V5.5z M8,5.5h3v6H9.5V7H8V5.5z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "9.5,11.5 11,11.5 11,5.5 8,5.5 8,7 9.5,7",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "14.5,11.5 16,11.5 16,5.5 13,5.5 13,7 14.5,7",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 filter-hdr
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 16h3.04l-1.52-2.03z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9.78 11.63l1.25 1.67L14 9.33 19 16h-8.46l-4.01-5.37L1 18h22L14 6l-4.22 5.63zM5 16l1.52-2.03L8.04 16H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 image
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 19h14V5H5v14zm4-5.86l2.14 2.58 3-3.87L18 17H6l3-3.86z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zm-4.86-7.14l-3 3.86L9 13.14 6 17h12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _4mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M9.5,5.5 H11v3h1.5v-3H14v3h1V10h-1v1.5h-1.5V10h-3V5.5z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6 V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "12.5,11.5 14,11.5 14,10 15,10 15,8.5 14,8.5 14,5.5 12.5,5.5 12.5,8.5 11,8.5 11,5.5 9.5,5.5 9.5,10 12.5,10",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-landscape
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 5H5c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 12H5V7h14v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 camera-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14.12 4H9.88L8.05 6H4v12h16V6h-4.05l-1.83-2zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 4h-3.17L15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H4V6h4.05l1.83-2h4.24l1.83 2H20v12zM12 7c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5zm0 8c-1.65 0-3-1.35-3-3s1.35-3 3-3 3 1.35 3 3-1.35 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dirty-lens
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M14.12,5H9.88L8.05,7H4v12h7.27c0.14-0.98,0.42-2.05-0.16-2.43c-0.89-0.59-1.27,2.06-2.8,1.35 c-1.39-1.12,1.05-1.29,0.5-3.27c-0.22-0.79-2.28,0.36-2.4-1.24c-0.08-1,1.49-0.74,1.51-1.49c0.03-0.75-1.03-1.05-0.25-1.91 c0.22-0.24,0.71-0.26,0.91-0.19c0.79,0.27,1.55,1.82,2.51,1.19c1.03-0.66-1.88-2.35,0-2.86c1.64-0.44,1.31,2.08,2.65,2.44 c1.94,0.52,2.65-4.55,4.41-2.33c1.85,2.33-3.43,2.27-2.85,4.01c0.34,1.01,2.15-1.2,2.76,0.53c0.64,1.83-3.09,0.82-3.04,1.66 c0.06,0.83,2.41,0.55,1.64,2.12c-1.14,1.86-3-1.03-3.81,0.09c-0.39,0.57-0.09,1.49,0.13,2.33H20V7h-4.05L14.12,5z M19,17.15 c0,0.48-0.38,0.86-0.86,0.86c-0.47,0-0.86-0.38-0.86-0.86s0.38-0.86,0.86-0.86C18.61,16.29,19,16.67,19,17.15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,5h-3.17L15,3H9L7.17,5H4C2.9,5,2,5.9,2,7v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V7C22,5.9,21.1,5,20,5z M20,19h-7.02 c-0.22-0.84-0.52-1.76-0.13-2.33c0.81-1.12,2.67,1.77,3.81-0.09c0.77-1.57-1.58-1.29-1.64-2.12c-0.05-0.84,3.68,0.17,3.04-1.66 c-0.61-1.73-2.42,0.48-2.76-0.53c-0.58-1.74,4.7-1.68,2.85-4.01c-1.76-2.22-2.47,2.85-4.41,2.33c-1.34-0.36-1.01-2.88-2.65-2.44 c-1.88,0.51,1.03,2.2,0,2.86c-0.96,0.63-1.72-0.92-2.51-1.19c-0.2-0.07-0.69-0.05-0.91,0.19c-0.78,0.86,0.28,1.16,0.25,1.91 c-0.02,0.75-1.59,0.49-1.51,1.49c0.12,1.6,2.18,0.45,2.4,1.24c0.55,1.98-1.89,2.15-0.5,3.27c1.53,0.71,1.91-1.94,2.8-1.35 c0.58,0.38,0.3,1.45,0.16,2.43H4V7h4.05l1.83-2h4.24l1.83,2H20V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.28,17.15c0,0.48,0.39,0.86,0.86,0.86c0.48,0,0.86-0.38,0.86-0.86s-0.39-0.86-0.86-0.86 C17.66,16.29,17.28,16.67,17.28,17.15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 blur-linear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M17 16.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "12", :cx "9", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "8", :cx "13", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "13", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M17 12.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "12", :cx "13", :stroke nil, :fill nil})
  (helix.dom/path {:d "M3 3h18v2H3z", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "8", :cx "5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "12", :cx "5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "16", :cx "5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M17 8.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "9", :stroke nil, :fill nil})
  (helix.dom/circle {:r "1", :cy "8", :cx "9", :stroke nil, :fill nil})
  (helix.dom/path {:d "M3 19h18v2H3z", :stroke nil, :fill nil})))


(helix.core/defnc
 photo-camera-front
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M15.95,7l-1.83-2H9.88L8.05,7H4v12h16V7H15.95z M12,9c1.1,0,2,0.9,2,2c0,1.1-0.9,2-2,2s-2-0.9-2-2 C10,9.9,10.9,9,12,9z M16,17H8v-0.57c0-0.81,0.48-1.53,1.22-1.85C10.07,14.21,11.01,14,12,14s1.93,0.21,2.78,0.58 C15.52,14.9,16,15.62,16,16.43V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,5h-3.17L15,3H9L7.17,5H4C2.9,5,2,5.9,2,7v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V7C22,5.9,21.1,5,20,5z M20,19H4V7 h4.05l1.83-2h4.24l1.83,2H20V19z M12,13c1.1,0,2-0.9,2-2c0-1.1-0.9-2-2-2s-2,0.9-2,2C10,12.1,10.9,13,12,13z M14.78,14.58 C13.93,14.21,12.99,14,12,14s-1.93,0.21-2.78,0.58C8.48,14.9,8,15.62,8,16.43V17h8v-0.57C16,15.62,15.52,14.9,14.78,14.58z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 switch-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M4 17h12V7H4v10zm4-8v2h4V9l3 3-3 3v-2H8v2l-3-3 3-3z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8 13h4v2l3-3-3-3v2H8V9l-3 3 3 3zm10-3.5V6c0-.55-.45-1-1-1H3c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h14c.55 0 1-.45 1-1v-3.5l4 4v-13l-4 4zM16 17H4V7h12v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 blur-circular
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M14 7.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "10", :cx "14", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "14", :cx "14", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M10 16.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "10", :cx "10", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M7 13.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zM7 9.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "14", :cx "10", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M10 7.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm4 9c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm3-7c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm0 4c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 edit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 18.08V19h.92l9.06-9.06-.92-.92z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.2-.2-.45-.29-.71-.29s-.51.1-.7.29l-1.83 1.83 3.75 3.75 1.83-1.83zM3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM5.92 19H5v-.92l9.06-9.06.92.92L5.92 19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-7
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M18 9.52V6h-3.52L12 3.52 9.52 6H6v3.52L3.52 12 6 14.48V18h3.52L12 20.48 14.48 18H18v-3.52L20.48 12 18 9.52zm-6 7.98c-3.03 0-5.5-2.47-5.5-5.5S8.97 6.5 12 6.5s5.5 2.47 5.5 5.5-2.47 5.5-5.5 5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69L23.31 12 20 8.69zm-2 5.79V18h-3.52L12 20.48 9.52 18H6v-3.52L3.52 12 6 9.52V6h3.52L12 3.52 14.48 6H18v3.52L20.48 12 18 14.48zM12 6.5c-3.03 0-5.5 2.47-5.5 5.5s2.47 5.5 5.5 5.5 5.5-2.47 5.5-5.5-2.47-5.5-5.5-5.5zm0 9c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2", :cy "12", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 grain
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zM6 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm8 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-4 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0-12c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm4 12c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-8 4c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 receipt-long
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path
   {:opacity ".3",
    :d "M19,19c0,0.55-0.45,1-1,1s-1-0.45-1-1v-3H8V5h11V19z",
    :stroke nil,
    :fill nil})
  (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.5,3.5L18,2l-1.5,1.5L15,2l-1.5,1.5L12,2l-1.5,1.5L9,2L7.5,3.5L6,2v14H3v3c0,1.66,1.34,3,3,3h12c1.66,0,3-1.34,3-3V2 L19.5,3.5z M19,19c0,0.55-0.45,1-1,1s-1-0.45-1-1v-3H8V5h11V19z",
     :stroke nil,
     :fill nil})
   (helix.dom/rect
    {:y "7", :x "9", :width "6", :height "2", :stroke nil, :fill nil})
   (helix.dom/rect
    {:y "7", :x "16", :width "2", :height "2", :stroke nil, :fill nil})
   (helix.dom/rect
    {:y "10", :x "9", :width "6", :height "2", :stroke nil, :fill nil})
   (helix.dom/rect
    {:y "10",
     :x "16",
     :width "2",
     :height "2",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 image-aspect-ratio
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 18h16V6H4v12zm10-8h2v2h-2v-2zm0 4h2v2h-2v-2zm-4-4h2v2h-2v-2zm-4 0h2v2H6v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M14 10h2v2h-2zm0 4h2v2h-2zm-8-4h2v2H6zm4 0h2v2h-2zm10-6H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H4V6h16v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 lens
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12 4c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-awesome-motion
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "12",
      :x "12",
      :width "8",
      :opacity ".3",
      :height "8",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M14,2H4C2.9,2,2,2.9,2,4v10h2V4h10V2z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,10h-8c-1.1,0-2,0.9-2,2v8c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2v-8C22,10.9,21.1,10,20,10z M20,20h-8v-8h8V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M18,6H8C6.9,6,6,6.9,6,8v10h2V8h10V6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 movie-filter
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M16.63 11.37L18 12l-1.37.63L16 14l-.63-1.37L14 12l1.37-.63L16 10H5.77L4.01 6.47V18h16v-8H16l.63 1.37zm-5.69 3.57L10 17l-.94-2.06L7 14l2.06-.94L10 11l.94 2.06L13 14l-2.06.94z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M10 11l-.94 2.06L7 14l2.06.94L10 17l.94-2.06L13 14l-2.06-.94zm8.01-7l2 4h-3l-2-4h-2l2 4h-3l-2-4h-2l2 4h-3l-2-4h-1c-1.1 0-1.99.9-1.99 2l-.01 12c0 1.1.9 2 2 2h16c1.1 0 1.99-.9 1.99-2V4h-3.99zm2 14h-16V6.47L5.77 10H16l-.63 1.37L14 12l1.37.63L16 14l.63-1.37L18 12l-1.37-.63L16 10h4.01v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timer-10
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2.99 18h2V6h-.25L-.01 7.72V9.4l3-1zm9.59-11.83c-.47-.18-1.01-.27-1.59-.27s-1.11.09-1.59.27c-.48.18-.89.47-1.23.88-.34.41-.6.93-.79 1.59-.18.65-.28 1.45-.28 2.39v1.92c0 .94.09 1.74.28 2.39.19.66.45 1.19.8 1.6.34.41.75.71 1.23.89.48.18 1.01.28 1.59.28.59 0 1.12-.09 1.59-.28.48-.18.88-.48 1.22-.89.34-.41.6-.94.78-1.6.18-.65.28-1.45.28-2.39v-1.92c0-.94-.09-1.74-.28-2.39-.18-.66-.44-1.19-.78-1.59s-.75-.7-1.23-.88zm.32 7.05h-.01c0 .6-.04 1.11-.12 1.53-.08.42-.2.76-.36 1.02-.16.26-.36.45-.59.57s-.51.18-.82.18c-.3 0-.58-.06-.82-.18s-.44-.31-.6-.57c-.16-.26-.29-.6-.38-1.02-.09-.42-.13-.93-.13-1.53v-2.5c0-.6.04-1.11.13-1.52.09-.41.21-.74.38-1 .16-.25.36-.43.6-.55.24-.11.51-.17.81-.17.31 0 .58.06.81.17.24.11.44.29.6.55.16.25.29.58.37.99.08.41.13.92.13 1.52v2.51zm10.24.41c-.28-.21-.61-.39-1.01-.53s-.85-.27-1.35-.38c-.35-.07-.64-.15-.87-.23-.23-.08-.41-.16-.55-.25-.14-.09-.23-.19-.28-.3-.05-.11-.08-.24-.08-.39 0-.14.03-.28.09-.41.06-.13.15-.25.27-.34.12-.1.27-.18.45-.24s.4-.09.64-.09c.25 0 .47.04.66.11.19.07.35.17.48.29.13.12.22.26.29.42.06.16.1.32.1.49h1.95c0-.39-.08-.75-.24-1.09-.16-.34-.39-.63-.69-.88s-.66-.44-1.09-.59c-.43-.15-.92-.22-1.46-.22-.51 0-.98.07-1.39.21-.41.14-.77.33-1.06.57s-.51.52-.67.84c-.16.32-.23.65-.23 1.01s.08.69.23.96c.15.28.36.52.64.73.27.21.6.38.98.53.38.14.81.26 1.27.36.39.08.71.17.95.26s.43.19.57.29c.13.1.22.22.27.34s.07.25.07.39c0 .32-.13.57-.4.77-.27.2-.66.29-1.17.29-.22 0-.43-.02-.64-.08-.21-.05-.4-.13-.56-.24-.17-.11-.3-.26-.41-.44-.11-.18-.17-.41-.18-.67h-1.89c0 .36.08.71.24 1.05.16.34.39.65.7.93.31.27.69.49 1.15.66.46.17.98.25 1.58.25.53 0 1.01-.06 1.44-.19s.8-.31 1.11-.54c.31-.23.54-.51.71-.83.17-.32.25-.67.25-1.06-.02-.4-.09-.74-.24-1.02-.14-.28-.35-.53-.63-.74z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 rotate-90-degrees-cw
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M4.64,19.37c3.03,3.03,7.67,3.44,11.15,1.25l-1.46-1.46c-2.66,1.43-6.04,1.03-8.28-1.21c-2.73-2.73-2.73-7.17,0-9.9 C7.42,6.69,9.21,6.03,11,6.03V9l4-4l-4-4v3.01c-2.3,0-4.61,0.87-6.36,2.63C1.12,10.15,1.12,15.85,4.64,19.37z M11,13l6,6l6-6 l-6-6L11,13z M17,16.17L13.83,13L17,9.83L20.17,13L17,16.17z",
       :stroke nil,
       :fill nil})
     (helix.dom/rect
      {:y "10.75",
       :stroke nil,
       :transform
       "matrix(0.7071 -0.7071 0.7071 0.7071 -4.2138 15.8229)",
       :fill nil,
       :width "4.49",
       :opacity ".3",
       :x "14.75",
       :enable-background "new",
       :height "4.49"}))))))


(helix.core/defnc
 panorama-horizontal
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M4 6.54v10.91c2.6-.77 5.28-1.16 8-1.16s5.4.39 8 1.16V6.54c-2.6.78-5.28 1.17-8 1.16-2.72 0-5.4-.39-8-1.16z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21.43 4c-.1 0-.2.02-.31.06C18.18 5.16 15.09 5.7 12 5.7s-6.18-.55-9.12-1.64C2.77 4.02 2.66 4 2.57 4c-.34 0-.57.23-.57.63v14.75c0 .39.23.62.57.62.1 0 .2-.02.31-.06 2.94-1.1 6.03-1.64 9.12-1.64s6.18.55 9.12 1.64c.11.04.21.06.31.06.33 0 .57-.23.57-.63V4.63c0-.4-.24-.63-.57-.63zM20 17.45c-2.6-.77-5.28-1.16-8-1.16s-5.4.39-8 1.16V6.54c2.6.77 5.28 1.16 8 1.16 2.72.01 5.4-.38 8-1.16v10.91z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-twilight
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "7.31",
      :x "17.22",
      :width "3",
      :transform "matrix(0.7069 -0.7074 0.7074 0.7069 -0.3887 15.676)",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "18",
      :x "2",
      :width "20",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "11",
      :width "2",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.78",
      :x "4.31",
      :width "2",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 -4.2992 6.1783)",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M5,16h14c0-3.87-3.13-7-7-7S5,12.13,5,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 photo-album
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M16,4v7l-2.5-1.5L11,11V4H6v16h12V4H16z M7,18l2.38-3.17L11,17l2.62-3.5L17,18H7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M18,2H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V4C20,2.9,19.1,2,18,2z M18,20H6V4h5v7l2.5-1.5L16,11V4h2V20 z M13.62,13.5L17,18H7l2.38-3.17L11,17L13.62,13.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-photosphere-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.95,8.15c-0.29-0.16-0.61-0.31-0.93-0.46C19.4,4.33,15.98,2,12,2C8.02,2,4.6,4.33,2.99,7.68 c-0.33,0.15-0.64,0.3-0.93,0.46C1.41,8.5,1,9.17,1,9.91v4.18c0,0.74,0.41,1.41,1.05,1.77c0.29,0.16,0.61,0.31,0.93,0.46 C4.6,19.67,8.02,22,12,22c3.98,0,7.4-2.33,9.01-5.68c0.33-0.15,0.64-0.3,0.93-0.46C22.59,15.5,23,14.83,23,14.09V9.91 C23,9.17,22.59,8.5,21.95,8.15z M12,4c2.37,0,4.49,1.04,5.95,2.68C16.17,6.25,14.15,6,12,6C9.85,6,7.83,6.25,6.05,6.68 C7.51,5.04,9.63,4,12,4z M12,20c-2.37,0-4.49-1.04-5.95-2.68C7.83,17.75,9.85,18,12,18s4.17-0.25,5.95-0.68 C16.49,18.96,14.37,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 loupe
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 20c4.41 0 8-3.59 8-8s-3.59-8-8-8-8 3.59-8 8 3.59 8 8 8zm-5-9h4V7h2v4h4v2h-4v4h-2v-4H7v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M11 17h2v-4h4v-2h-4V7h-2v4H7v2h4zm1 5h8c1.1 0 2-.9 2-2v-8c0-5.51-4.49-10-10-10S2 6.49 2 12s4.49 10 10 10zm0-18c4.41 0 8 3.59 8 8s-3.59 8-8 8-8-3.59-8-8 3.59-8 8-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 looks
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 6C5.93 6 1 10.93 1 17h2c0-4.96 4.04-9 9-9s9 4.04 9 9h2c0-6.07-4.93-11-11-11zm0 6c2.76 0 5 2.24 5 5h2c0-3.86-3.14-7-7-7s-7 3.14-7 7h2c0-2.76 2.24-5 5-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-size-select-small
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 19h2v2h-2zm-4 0h2v2h-2zM1 19c0 1.1.9 2 2 2h8v-6H1v4zM9 3h2v2H9zM5 3h2v2H5zm12 0h2v2h-2zM1 11h2v2H1zm0-4h2v2H1zm2-4C2 3 1 4 1 5h2V3zm10 0h2v2h-2zm8 18c1 0 2-1 2-2h-2v2zm0-10h2v2h-2zm0-8v2h2c0-1-1-2-2-2zm0 12h2v2h-2zm0-8h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-6
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M18 9.52V6h-3.52L12 3.52 9.52 6H6v3.52L3.52 12 6 14.48V18h3.52L12 20.48 14.48 18H18v-3.52L20.48 12 18 9.52zm-6 7.98v-11c3.03 0 5.5 2.47 5.5 5.5s-2.47 5.5-5.5 5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69L23.31 12 20 8.69zm-2 5.79V18h-3.52L12 20.48 9.52 18H6v-3.52L3.52 12 6 9.52V6h3.52L12 3.52 14.48 6H18v3.52L20.48 12 18 14.48zM12 6.5v11c3.03 0 5.5-2.47 5.5-5.5S15.03 6.5 12 6.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _21mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M13,5.5h3v6h-1.5V7H13V5.5z M13.5,12.5H17c0.55,0,1,0.45,1,1V16c0,0.55-0.45,1-1,1h-2v1.5 h-1.5V12.5z M7.5,9c0-0.55,0.45-1,1-1h2V7h-3V5.5H11c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1H9v1h3v1.5H7.5V9z M6,13.5 c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "14.5,11.5 16,11.5 16,5.5 13,5.5 13,7 14.5,7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,10H9V9h2c0.55,0,1-0.45,1-1V6.5c0-0.55-0.45-1-1-1H7.5V7h3v1h-2c-0.55,0-1,0.45-1,1v2.5H12V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15,17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5v6H15V17z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 navigate-next
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10.02 18l6-6-6-6-1.41 1.41L13.19 12l-4.58 4.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12 20c4.41 0 8-3.59 8-8s-3.59-8-8-8-8 3.59-8 8 3.59 8 8 8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 22c5.52 0 10-4.48 10-10S17.52 2 12 2 2 6.48 2 12s4.48 10 10 10zm0-18c4.41 0 8 3.59 8 8s-3.59 8-8 8-8-3.59-8-8 3.59-8 8-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tune
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5h10v2H3zm4 6H3v2h4v2h2V9H7zm6 4h-2v6h2v-2h8v-2h-8zM3 17h6v2H3zm8-6h10v2H11zm6-8h-2v6h2V7h4V5h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M20 6h-4.05l-1.83-2H9.88L8.05 6H4v12h16V6zm-8 11c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 20h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2H9L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2zM4 6h4.05l1.83-2h4.24l1.83 2H20v12H4V6zm8 1c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5zm0 8c-1.65 0-3-1.35-3-3s1.35-3 3-3 3 1.35 3 3-1.35 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,4c-4.41,0-8,3.59-8,8c0,2.52,1.17,4.77,3,6.24V13h3.5c0.8,0,1.5,0.7,1.5,1.5v1c0,0.6-0.4,1.1-0.9,1.4 L12,19h-1.5l-0.9-2H8.5v2H8.13c1.15,0.64,2.47,1,3.87,1c4.41,0,8-3.59,8-8C20,7.59,16.41,4,12,4z M12,12h-1.5V9.5h-2V12H7V6h1.5v2 h2V6H12V12z M17.5,16H16v1.5h-1.5V16H13v-1.5h1.5V13H16v1.49h1.5V16z M17.5,10.5c0,0.8-0.7,1.5-1.5,1.5h-3V6h3 c0.8,0,1.5,0.7,1.5,1.5V10.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7.5",
      :x "14.5",
      :width "1.5",
      :opacity ".3",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14.5",
      :x "8.5",
      :width "2",
      :opacity ".3",
      :height "1",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-1.4,0-2.72-0.36-3.87-1H8.5v-2h1.1l0.9,2H12 l-0.9-2.1c0.5-0.3,0.9-0.8,0.9-1.4v-1c0-0.8-0.7-1.5-1.5-1.5H7v5.24C5.17,16.77,4,14.52,4,12c0-4.41,3.59-8,8-8s8,3.59,8,8 C20,16.41,16.41,20,12,20z M8.5,15.5v-1h2v1H8.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "10.5,8 8.5,8 8.5,6 7,6 7,12 8.5,12 8.5,9.5 10.5,9.5 10.5,12 12,12 12,6 10.5,6",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,6h-3v6h3c0.8,0,1.5-0.7,1.5-1.5v-3C17.5,6.7,16.8,6,16,6z M16,10.5h-1.5v-3H16V10.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "16,13 14.5,13 14.5,14.5 13,14.5 13,16 14.5,16 14.5,17.5 16,17.5 16,16 17.5,16 17.5,14.49 16,14.49",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 center-focus-weak
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M12 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 19c0 1.1.9 2 2 2h4v-2H5v-4H3v4zM3 5v4h2V5h4V3H5c-1.1 0-2 .9-2 2zm9 3c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm9-9c0-1.1-.9-2-2-2h-4v2h4v4h2V5zm-2 14h-4v2h4c1.1 0 2-.9 2-2v-4h-2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 logo-dev
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.68,14.98H6V9h1.71 c1.28,0,1.71,1.03,1.71,1.71l0,2.56C9.42,13.95,9,14.98,7.68,14.98z M12.38,11.46v1.07h-1.18v1.39h1.93v1.07h-2.25 c-0.4,0.01-0.74-0.31-0.75-0.71V9.75c-0.01-0.4,0.31-0.74,0.71-0.75h2.28l0,1.07h-1.92v1.39H12.38z M16.88,14.23 c-0.48,1.11-1.33,0.89-1.71,0L13.77,9h1.18l1.07,4.11L17.09,9h1.18L16.88,14.23z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.77,10.12H7.14v3.77h0.63c0.14,0,0.28-0.05,0.42-0.16c0.14-0.1,0.21-0.26,0.21-0.47v-2.52c0-0.21-0.07-0.37-0.21-0.47 C8.05,10.17,7.91,10.12,7.77,10.12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _14mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M12,5.5 h1.5v3H15v-3h1.5v3h1V10h-1v1.5H15V10h-3V5.5z M7,5.5h3v6H8.5V7H7V5.5z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14 h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,12.5v6H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1H13.5z M16.5,15.5H15V14h1.5V15.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,11.5 10,11.5 10,5.5 7,5.5 7,7 8.5,7",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "15,11.5 16.5,11.5 16.5,10 17.5,10 17.5,8.5 16.5,8.5 16.5,5.5 15,5.5 15,8.5 13.5,8.5 13.5,5.5 12,5.5 12,10 15,10",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 looks-4
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M.04 0h24v24h-24V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5.04 19h14V5h-14v14zm4-12h2v4h2V7h2v10h-2v-4h-4V7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.04 3h-14c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16h-14V5h14v14zm-6-2h2V7h-2v4h-2V7h-2v6h4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-bitcoin
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17.06,11.57C17.65,10.88,18,9.98,18,9c0-1.86-1.27-3.43-3-3.87L15,3h-2v2h-2V3H9v2H6v2h2v10H6v2h3v2h2v-2h2v2h2v-2 c2.21,0,4-1.79,4-4C19,13.55,18.22,12.27,17.06,11.57z M10,7h4c1.1,0,2,0.9,2,2s-0.9,2-2,2h-4V7z M15,17h-5v-4h5c1.1,0,2,0.9,2,2 S16.1,17,15,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 looks-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M5 19h14V5H5v14zm4-4h4v-2h-2v-2h2V9H9V7h4c1.1 0 2 .89 2 2v1.5c0 .83-.67 1.5-1.5 1.5.83 0 1.5.67 1.5 1.5V15c0 1.11-.9 2-2 2H9v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zm-4-4v-1.5c0-.83-.67-1.5-1.5-1.5.83 0 1.5-.67 1.5-1.5V9c0-1.11-.9-2-2-2H9v2h4v2h-2v2h2v2H9v2h4c1.1 0 2-.89 2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "10.5",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,5l0,14l14,0l0-14H5z M12.5,15H11v-4.5h-1v3H8.5v-3h-1V15H6v-5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1 V15z M18,12.5c0,0.55-0.45,1-1,1h-2V15h-1.5V9H17c0.55,0,1,0.45,1,1V12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,9h-3.5v6H15v-1.5h2c0.55,0,1-0.45,1-1V10C18,9.45,17.55,9,17,9z M16.5,12H15v-1.5h1.5V12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.5,9H7c-0.55,0-1,0.45-1,1v5h1.5v-4.5h1v3H10v-3h1V15h1.5v-5C12.5,9.45,12.05,9,11.5,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5V19c0,1.1,0.9,2,2,2H19c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M5,19L5,5h14l0,14L5,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-portrait
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 3H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H7V5h10v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 bedtime
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d
       "M9.27 4.49C6.2 5.6 4 8.55 4 12c0 4.41 3.59 8 8 8 1.81 0 3.54-.62 4.93-1.71-3.91-1.39-9.29-6.26-7.66-13.8z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M12.34 2.02c-.12 0-.23-.01-.35-.01C6.4 2.01 2 6.54 2 12c0 5.52 4.48 10 10 10 3.71 0 6.93-2.02 8.66-5.02-7.51-.25-12.09-8.43-8.32-14.96zM12 20c-4.41 0-8-3.59-8-8 0-3.45 2.2-6.4 5.27-7.51-1.63 7.54 3.75 12.41 7.66 13.8C15.54 19.38 13.81 20 12 20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 rotate-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.93 11c-.17-1.39-.72-2.73-1.62-3.89l-1.42 1.42c.54.75.88 1.6 1.02 2.47h2.02zM11 1v3.07C7.06 4.56 4 7.92 4 12s3.05 7.44 7 7.93v-2.02c-2.84-.48-5-2.94-5-5.91s2.16-5.43 5-5.91V10l4.55-4.45L11 1zm4.46 15.87c-.75.54-1.59.89-2.46 1.03v2.02c1.39-.17 2.74-.71 3.9-1.61l-1.44-1.44zm2.85.02c.9-1.16 1.45-2.5 1.62-3.89h-2.02c-.14.87-.48 1.72-1.02 2.48l1.42 1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-strong
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M17 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17 6c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zm0 10c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4zM5 16c2.21 0 4-1.79 4-4S7.21 8 5 8s-4 1.79-4 4 1.79 4 4 4zm0-6c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-stable
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "7.57",
      :x "9.45",
      :width "5.1",
      :transform
      "matrix(0.2589 -0.9659 0.9659 0.2589 -2.6958 20.4865)",
      :opacity ".3",
      :height "8.86",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,4H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V6C22,4.9,21.1,4,20,4z M4,18V6h2.95l-2.33,8.73L16.82,18 H4z M15.62,15.61l-8.55-2.29l1.31-4.92l8.56,2.29L15.62,15.61z M20,18h-2.95l2.34-8.73L7.18,6H20V18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 nature-people
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "5",
    :opacity ".3",
    :cy "9.17",
    :cx "15.17",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "9.5", :cx "4.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M15.17 2.17c-3.87 0-7 3.13-7 7 0 3.47 2.52 6.34 5.83 6.89V20H6v-3h1v-4c0-.55-.45-1-1-1H3c-.55 0-1 .45-1 1v4h1v5h16v-2h-3v-3.88c3.47-.41 6.17-3.36 6.17-6.95 0-3.87-3.13-7-7-7zm0 12c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-neg-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.98 10.1c-.14.25-.32.53-.56.83-.23.3-.52.65-.88 1.03l-4.17 4.55V18H21v-1.71h-5.95l2.86-3.07c.38-.39.72-.79 1.04-1.18s.59-.78.82-1.17c.23-.39.41-.78.54-1.17.13-.39.19-.79.19-1.18 0-.53-.09-1.02-.27-1.46s-.44-.81-.78-1.11c-.34-.31-.77-.54-1.26-.71-.51-.16-1.08-.24-1.72-.24-.69 0-1.31.11-1.85.32-.54.21-1 .51-1.36.88-.37.37-.65.8-.84 1.3-.18.47-.27.97-.28 1.5h2.14c.01-.31.05-.6.13-.87.09-.29.23-.54.4-.75.18-.21.41-.37.68-.49.27-.12.6-.18.96-.18.31 0 .58.05.81.15s.43.25.59.43c.16.18.28.4.37.65.08.25.13.52.13.81 0 .22-.03.43-.08.65-.06.22-.15.45-.29.7zM2 11h8v2H2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 compare
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M19 5h-5v7l5 6zm-9 13v-6l-5 6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 3h-5v2h5v13l-5-6v9h5c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7-2h-2v2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h5v2h2V1zm-2 17H5l5-6v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-plus-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8 17v-4h4v-2H8V7H6v4H2v2h4v4zm11.95-4.96c.32-.39.59-.78.82-1.17.23-.39.41-.78.54-1.17.13-.39.19-.79.19-1.18 0-.53-.09-1.02-.27-1.46s-.44-.81-.78-1.11c-.34-.31-.77-.54-1.26-.71-.51-.16-1.08-.24-1.72-.24-.69 0-1.31.11-1.85.32-.54.21-1 .51-1.36.88-.37.37-.65.8-.84 1.3-.18.47-.27.97-.28 1.5h2.14c.01-.31.05-.6.13-.87.09-.29.23-.54.4-.75.18-.21.41-.37.68-.49.27-.12.6-.18.96-.18.31 0 .58.05.81.15s.43.25.59.43c.16.18.28.4.37.65.08.25.13.52.13.81 0 .22-.03.43-.08.65-.06.22-.15.45-.29.7-.14.25-.32.53-.56.83-.23.3-.52.65-.88 1.03l-4.17 4.55V18H22v-1.71h-5.95l2.86-3.07c.38-.39.72-.79 1.04-1.18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M3 18h18V6H3v12zm5.5-5.5l2.5 3.01L14.5 11l4.5 6H5l3.5-4.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 4H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H3V6h18v12zm-6.5-7L11 15.51 8.5 12.5 5 17h14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-yuan
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "13.28,12 18,12 18,14 13,14 13,21 11,21 11,14 6,14 6,12 10.72,12 5,3 7.37,3 12,10.29 16.63,3 19,3",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 collections-bookmark
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M20 4h-1v9l-3-2.25L13 13V4H8v12h12z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 22h14v-2H4V6H2v14c0 1.1.9 2 2 2zm18-6V4c0-1.1-.9-2-2-2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2zM15 4h2v5l-1-.75L15 9V4zM8 4h5v9l3-2.25L19 13V4h1v12H8V4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 9H9.5v6H13c.8 0 1.5-.7 1.5-1.5v-3c0-.8-.7-1.5-1.5-1.5zm0 4.5h-2v-3h2v3zm8-2v-1c0-.8-.7-1.5-1.5-1.5H16v6h1.5v-2h1.1l.9 2H21l-.9-2.1c.5-.3.9-.8.9-1.4zm-1.5 0h-2v-1h2v1zm-13-.5h-2V9H3v6h1.5v-2.5h2V15H8V9H6.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-9-plus
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 17h14v-6h-2v2h-2v-2h-2V9h2V7h2v2h2V3H7v14zm2-5h3v-1h-1c-1.1 0-2-.89-2-2V8c0-1.11.9-2 2-2h1c1.1 0 2 .89 2 2v4c0 1.11-.9 2-2 2H9v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d "M19 21H3V5H1v16c0 1.1.9 2 2 2h16v-2z", :stroke nil, :fill nil})
  (helix.dom/path
   {:opacity ".3", :d "M11 8h1v1h-1z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 6h-1c-1.1 0-2 .89-2 2v1c0 1.11.9 2 2 2h1v1H9v2h3c1.1 0 2-.89 2-2V8c0-1.11-.9-2-2-2zm0 3h-1V8h1v1zm9-8H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 8h-2V7h-2v2h-2v2h2v2h2v-2h2v6H7V3h14v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 autofps-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "12.03,6.3 11.97,6.3 10.95,9.19 13.05,9.19",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "3",
      :width "2",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,15c3.31,0,6-2.69,6-6s-2.69-6-6-6S6,5.69,6,9S8.69,15,12,15z M11.37,5h1.25l2.63,7h-1.21l-0.63-1.79h-2.83L9.96,12 H8.74L11.37,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "7",
      :width "2",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "11",
      :width "2",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "15",
      :width "6",
      :height "5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 currency-pound
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,21c1.93,0,3.62-1.17,4-3l-1.75-0.88C16,18.21,15.33,19,14,19l-4.9,0c0.83-1,1.5-2.34,1.5-4c0-0.35-0.03-0.69-0.08-1 L14,14v-2l-4.18,0C9,10.42,8,9.6,8,8c0-1.93,1.57-3.5,3.5-3.5c1.5,0,2.79,0.95,3.28,2.28L16.63,6c-0.8-2.05-2.79-3.5-5.13-3.5 C8.46,2.5,6,4.96,6,8c0,1.78,0.79,2.9,1.49,4L6,12v2l2.47,0c0.08,0.31,0.13,0.64,0.13,1c0,2.7-2.6,4-2.6,4v2H14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _5mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M10,10h3 V9h-3V5.5h4.5V7h-3v1h2c0.55,0,1,0.45,1,1v1.5c0,0.55-0.45,1-1,1H10V10z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14 h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.5,10.5V9c0-0.55-0.45-1-1-1h-2V7h3V5.5H10V9h3v1h-3v1.5h3.5C14.05,11.5,14.5,11.05,14.5,10.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 mic-external-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "6.81,16 7.19,16 7.79,10 6.21,10",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.22,7C9.7,6.47,10,5.77,10,5c0-1.66-1.34-3-3-3S4,3.34,4,5c0,0.77,0.3,1.47,0.78,2H9.22z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,2c-2.21,0-4,1.79-4,4v12c0,1.1-0.9,2-2,2s-2-0.9-2-2h1l1-10H4l1,10h1c0,2.21,1.79,4,4,4s4-1.79,4-4V6c0-1.1,0.9-2,2-2 s2,0.9,2,2v16h2V6C20,3.79,18.21,2,16,2z M7.19,16H6.81l-0.6-6h1.58L7.19,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 texture
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.88 3L3 11.88v2.83L14.71 3zM3 5v2l4-4H5c-1.1 0-2 .9-2 2zm16.51-1.92L3.08 19.51c.09.34.27.65.51.9.25.24.56.42.9.51L20.93 4.49c-.19-.69-.73-1.23-1.42-1.41zM21 9.29L9.29 21h2.83L21 12.12zm-.59 11.12c.37-.36.59-.86.59-1.41v-2l-4 4h2c.55 0 1.05-.22 1.41-.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-photo-alternate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10.21 16.83l-1.96-2.36L5.5 18h11l-3.54-4.71z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M16.5 18h-11l2.75-3.53 1.96 2.36 2.75-3.54L16.5 18zM17 7h-3V6H4v14h14V10h-1V7z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20 4V1h-2v3h-3v2h3v2.99h2V6h3V4zm-2 16H4V6h10V4H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V10h-2v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _10mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/rect
      {:y "7",
       :x "13.5",
       :width "1.5",
       :height "3",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/rect
      {:y "14",
       :x "15",
       :width "1.5",
       :height "1.5",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     {:opacity ".3"}
     (helix.dom/path
      {:d
       "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M12,6.5 c0-0.55,0.45-1,1-1h2.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H13c-0.55,0-1-0.45-1-1V6.5z M7,5.5h3v6H8.5V7H7V5.5z M6,13.5 c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M13,11.5h2.5c0.55,0,1-0.45,1-1v-4c0-0.55-0.45-1-1-1H13c-0.55,0-1,0.45-1,1v4C12,11.05,12.45,11.5,13,11.5z M13.5,7H15 v3h-1.5V7z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "8.5,11.5 10,11.5 10,5.5 7,5.5 7,7 8.5,7",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 looks-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 5H5v14h14V5zm-4 4h-4v2h2c1.1 0 2 .89 2 2v2c0 1.11-.9 2-2 2H9v-2h4v-2H9V7h6v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 21h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2zM5 5h14v14H5V5zm4 8h4v2H9v2h4c1.1 0 2-.89 2-2v-2c0-1.11-.9-2-2-2h-2V9h4V7H9v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "8",
      :opacity ".3",
      :cy "12",
      :cx "12",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C6.47,2,2,6.47,2,12c0,5.53,4.47,10,10,10s10-4.47,10-10C22,6.47,17.53,2,12,2z M12,20c-4.42,0-8-3.58-8-8 c0-4.42,3.58-8,8-8s8,3.58,8,8C20,16.42,16.42,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flash-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M17 10h-4l3-8H7v11h3v9z", :stroke nil, :fill nil})))


(helix.core/defnc
 photo-size-select-large
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 19h2v2h-2zM1 19c0 1.1.9 2 2 2h12V11H1v8zm4.5-3.21l1.79 2.15 2.5-3.22L13 19H3l2.5-3.21zM17 3h2v2h-2zm4 8h2v2h-2zm0 4h2v2h-2zM3 3C2 3 1 4 1 5h2V3zm18 4h2v2h-2zm-8-4h2v2h-2zm8 18c1 0 2-1 2-2h-2v2zM1 7h2v2H1zm8-4h2v2H9zM5 3h2v2H5zm16 0v2h2c0-1-1-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-8
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 17h14V3H7v14zm4-5.5c0-.83.67-1.5 1.5-1.5-.83 0-1.5-.67-1.5-1.5V7c0-1.11.9-2 2-2h2c1.1 0 2 .89 2 2v1.5c0 .83-.67 1.5-1.5 1.5.83 0 1.5.67 1.5 1.5V13c0 1.11-.9 2-2 2h-2c-1.1 0-2-.89-2-2v-1.5zM13 7h2v2h-2zm0 4h2v2h-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 1H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zM3 23h16v-2H3V5H1v16c0 1.1.9 2 2 2zm10-8h2c1.1 0 2-.89 2-2v-1.5c0-.83-.67-1.5-1.5-1.5.83 0 1.5-.67 1.5-1.5V7c0-1.11-.9-2-2-2h-2c-1.1 0-2 .89-2 2v1.5c0 .83.67 1.5 1.5 1.5-.83 0-1.5.67-1.5 1.5V13c0 1.11.9 2 2 2zm0-8h2v2h-2V7zm0 4h2v2h-2v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-3-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,6H5C3.9,6,3,6.9,3,8v8c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V8C21,6.9,20.1,6,19,6z M19,16H5V8h14V16z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 contrast
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,22c5.52,0,10-4.48,10-10S17.52,2,12,2S2,6.48,2,12S6.48,22,12,22z M13,4.07c3.94,0.49,7,3.85,7,7.93 s-3.05,7.44-7,7.93V4.07z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 brush
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M8 17c0-.55-.45-1-1-1s-1 .45-1 1c0 .74-.19 1.4-.5 1.95.17.03.33.05.5.05 1.1 0 2-.9 2-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M11.75 15l8.96-8.96c.39-.39.39-1.02 0-1.41l-1.34-1.34c-.2-.2-.45-.29-.7-.29s-.51.1-.71.29L9 12.25 11.75 15zM6 21c2.21 0 4-1.79 4-4 0-1.66-1.34-3-3-3s-3 1.34-3 3c0 1.31-1.16 2-2 2 .92 1.22 2.49 2 4 2zm0-4c0-.55.45-1 1-1s1 .45 1 1c0 1.1-.9 2-2 2-.17 0-.33-.02-.5-.05.31-.55.5-1.21.5-1.95z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M7 17h14V3H7v14zm5-12h4v10h-2V7h-2V5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M14 15h2V5h-4v2h2zm7-14H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zM1 5v16c0 1.1.9 2 2 2h16v-2H3V5H1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 healing
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M13.03 16.72l3.63 3.62 3.62-3.63-3.62-3.62zM7.29 3.71L3.66 7.34l3.63 3.62 3.62-3.63z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M17.73 12.02l3.98-3.98c.39-.39.39-1.02 0-1.41l-4.34-4.34c-.39-.39-1.02-.39-1.41 0l-3.98 3.98L8 2.29C7.8 2.1 7.55 2 7.29 2c-.25 0-.51.1-.7.29L2.25 6.63c-.39.39-.39 1.02 0 1.41l3.98 3.98L2.25 16c-.39.39-.39 1.02 0 1.41l4.34 4.34c.39.39 1.02.39 1.41 0l3.98-3.98 3.98 3.98c.2.2.45.29.71.29s.51-.1.71-.29l4.34-4.34c.39-.39.39-1.02 0-1.41l-3.99-3.98zM12 9c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm-4.71 1.96L3.66 7.34l3.63-3.63 3.62 3.62-3.62 3.63zM10 13c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm2 2c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm2-4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm2.66 9.34l-3.63-3.62 3.63-3.63 3.62 3.62-3.62 3.63z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 euro
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/path
    {:d
     "M15,18.5c-2.51,0-4.68-1.42-5.76-3.5H15l1-2H8.58c-0.05-0.33-0.08-0.66-0.08-1s0.03-0.67,0.08-1H15l1-2H9.24 C10.32,6.92,12.5,5.5,15,5.5c1.61,0,3.09,0.59,4.23,1.57L21,5.3C19.41,3.87,17.3,3,15,3c-3.92,0-7.24,2.51-8.48,6H3l-1,2h4.06 C6.02,11.33,6,11.66,6,12s0.02,0.67,0.06,1H3l-1,2h4.52c1.24,3.49,4.56,6,8.48,6c2.31,0,4.41-0.87,6-2.3l-1.78-1.77 C18.09,17.91,16.62,18.5,15,18.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 filter-6
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 17h14V3H7v14zm4-10c0-1.11.9-2 2-2h4v2h-4v2h2c1.1 0 2 .89 2 2v2c0 1.11-.9 2-2 2h-2c-1.1 0-2-.89-2-2V7zm2 4h2v2h-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 1H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zm-8-2h2c1.1 0 2-.89 2-2v-2c0-1.11-.9-2-2-2h-2V7h4V5h-4c-1.1 0-2 .89-2 2v6c0 1.11.9 2 2 2zm0-4h2v2h-2v-2zM3 23h16v-2H3V5H1v16c0 1.1.9 2 2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 landscape
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 16h3.04l-1.52-2.03z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M9.78 11.63l1.25 1.67L14 9.33 19 16h-8.46l-4.01-5.37L1 18h22L14 6l-4.22 5.63zM5 16l1.52-2.03L8.04 16H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 navigate-before
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M14.2 6l-6 6 6 6 1.41-1.41L11.03 12l4.58-4.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vignette
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M3 19h18V5H3v14zm9-13c4.42 0 8 2.69 8 6s-3.58 6-8 6-8-2.69-8-6 3.58-6 8-6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h18v14zm-9-1c4.42 0 8-2.69 8-6s-3.58-6-8-6-8 2.69-8 6 3.58 6 8 6zm0-10c3.25 0 6 1.83 6 4s-2.75 4-6 4-6-1.83-6-4 2.75-4 6-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mic-external-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "6.21,10 6.81,16 7.19,16 7.73,10.56 7.17,10",
      :opacity ".3",
      :enable-background "new",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,5c0-1.66-1.34-3-3-3C6.38,2,5.81,2.19,5.33,2.5l4.15,4.15C9.8,6.18,10,5.61,10,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14,6c0-1.1,0.9-2,2-2s2,0.9,2,2v9.17l2,2V6c0-2.21-1.79-4-4-4s-4,1.79-4,4v3.17l2,2V6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.1,2.1L0.69,3.51L5.17,8H4l1,10h1c0,2.21,1.79,4,4,4s4-1.79,4-4v-1.17l6.49,6.49l1.41-1.41L2.1,2.1z M7.19,16H6.81 l-0.6-6h0.96l0.56,0.56L7.19,16z M12,18c0,1.1-0.9,2-2,2s-2-0.9-2-2h1l0.56-5.61L12,14.83V18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 image-search
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M17.7 11.53c-.7.31-1.45.47-2.21.47C12.46 12 10 9.53 10 6.5c0-.17.01-.34.03-.5H4v14h14v-8.17l-.3-.3zM5.5 18l2.75-3.53 1.96 2.36 2.75-3.54L16.5 18h-11z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M10.21 16.83l-1.96-2.36L5.5 18h11l-3.54-4.71zM20 6.5C20 4.01 17.99 2 15.5 2S11 4.01 11 6.5s2.01 4.5 4.49 4.5c.88 0 1.7-.26 2.39-.7L21 13.42 22.42 12 19.3 8.89c.44-.7.7-1.51.7-2.39zM15.5 9C14.12 9 13 7.88 13 6.5S14.12 4 15.5 4 18 5.12 18 6.5 16.88 9 15.5 9zM18 20H4V6h6.03c.06-.72.27-1.39.58-2H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-6.17l-2-2V20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M7 17h14V3H7v14zm4.25-5.53l1.96 2.36 2.75-3.54L19.5 15h-11l2.75-3.53z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M1 21c0 1.1.9 2 2 2h16v-2H3V5H1v16zM21 1H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zm-5.04-6.71l-2.75 3.54-1.96-2.36L8.5 15h11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-7
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M7 17h14V3H7v14zm4-10V5h6v2l-4 8h-2l4-8h-4z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M3 23h16v-2H3V5H1v16c0 1.1.9 2 2 2zm10-8l4-8V5h-6v2h4l-4 8zm8-14H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-shade
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,12v2.5l5.5,5.5H22L14,12z M14,20h3l-3-3V20z M8,4l-6,6h2v10h8V10h2L8,4z M9,14H7v-4h2V14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _22mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M13,9 c0-0.55,0.45-1,1-1h2V7h-3V5.5h3.5c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1h-2v1h3v1.5H13V9z M6.5,9c0-0.55,0.45-1,1-1h2V7h-3V5.5 H10c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1H8v1h3v1.5H6.5V9z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5 v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,12.5v6H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1H13.5z M16.5,15.5H15V14h1.5V15.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,10H8V9h2c0.55,0,1-0.45,1-1V6.5c0-0.55-0.45-1-1-1H6.5V7h3v1h-2c-0.55,0-1,0.45-1,1v2.5H11V10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.5,10h-3V9h2c0.55,0,1-0.45,1-1V6.5c0-0.55-0.45-1-1-1H13V7h3v1h-2c-0.55,0-1,0.45-1,1v2.5h4.5V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-9
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M13 7h2v2h-2zM7 17h14V3H7v14zm4-4h4v-2h-2c-1.1 0-2-.89-2-2V7c0-1.11.9-2 2-2h2c1.1 0 2 .89 2 2v6c0 1.11-.9 2-2 2h-4v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 1H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14zM3 23h16v-2H3V5H1v16c0 1.1.9 2 2 2zm14-10V7c0-1.11-.9-2-2-2h-2c-1.1 0-2 .89-2 2v2c0 1.11.9 2 2 2h2v2h-4v2h4c1.1 0 2-.89 2-2zm-4-4V7h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tonality
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M4 12c0 4.08 3.06 7.44 7 7.93V4.07C7.05 4.56 4 7.92 4 12z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.94-.49-7-3.85-7-7.93s3.05-7.44 7-7.93v15.86zm2-15.86c1.03.13 2 .45 2.87.93H13v-.93zM13 7h5.24c.25.31.48.65.68 1H13V7zm0 3h6.74c.08.33.15.66.19 1H13v-1zm0 9.93V19h2.87c-.87.48-1.84.8-2.87.93zM18.24 17H13v-1h5.92c-.2.35-.43.69-.68 1zm1.5-3H13v-1h6.93c-.04.34-.11.67-.19 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 looks-one
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M19 5H5v14h14V5zm-5 12h-2V9h-2V7h4v10z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 21h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2zM5 5h14v14H5V5zm5 4h2v8h2V7h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 center-focus-strong
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "3", :opacity ".3", :cy "12", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M7 12c0 2.76 2.24 5 5 5s5-2.24 5-5-2.24-5-5-5-5 2.24-5 5zm8 0c0 1.65-1.35 3-3 3s-3-1.35-3-3 1.35-3 3-3 3 1.35 3 3zM3 19c0 1.1.9 2 2 2h4v-2H5v-4H3v4zM3 5v4h2V5h4V3H5c-1.1 0-2 .9-2 2zm18 0c0-1.1-.9-2-2-2h-4v2h4v4h2V5zm-2 14h-4v2h4c1.1 0 2-.9 2-2v-4h-2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-size-select-actual
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M3.08 5L3 5.08V19h17.92c.03-.02.06-.06.08-.08V5.08L20.92 5H3.08zM5 17l3.5-4.5 2.5 3.01L14.5 11l4.5 6H5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21 3H3C2 3 1 4 1 5v14c0 1.1.9 2 2 2h18c1 0 2-1 2-2V5c0-1-1-2-2-2zm0 15.92c-.02.03-.06.06-.08.08H3V5.08L3.08 5h17.83c.03.02.06.06.08.08v13.84zm-10-3.41L8.5 12.5 5 17h14l-4.5-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-7-5
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,5H5C3.9,5,3,5.9,3,7v10c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V7C21,5.9,20.1,5,19,5z M19,17H5V7h14V17z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 collections
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M8 16h12V4H8v12zm3.5-4.33l1.69 2.26 2.48-3.09L19 15H9l2.5-3.33z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8 2c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2H8zm12 14H8V4h12v12zm-4.33-5.17l-2.48 3.09-1.69-2.25L9 15h10zM4 22h14v-2H4V6H2v14c0 1.1.9 2 2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flip-camera-android
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1",
      :opacity ".3",
      :cy "12",
      :cx "12",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9,12c0,1.66,1.34,3,3,3s3-1.34,3-3s-1.34-3-3-3S9,10.34,9,12z M13,12c0,0.55-0.45,1-1,1s-1-0.45-1-1s0.45-1,1-1 S13,11.45,13,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,8H5.09C6.47,5.61,9.05,4,12,4c3.72,0,6.85,2.56,7.74,6h2.06c-0.93-4.56-4.96-8-9.8-8C8.73,2,5.82,3.58,4,6.01V4H2v6h6 V8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,14v2h2.91c-1.38,2.39-3.96,4-6.91,4c-3.72,0-6.85-2.56-7.74-6H2.2c0.93,4.56,4.96,8,9.8,8c3.27,0,6.18-1.58,8-4.01V20 h2v-6H16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-free
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 19c0 1.1.9 2 2 2h4v-2H5v-4H3v4zM21 5c0-1.1-.9-2-2-2h-4v2h4v4h2V5zM5 5h4V3H5c-1.1 0-2 .9-2 2v4h2V5zm16 14v-4h-2v4h-4v2h4c1.1 0 2-.9 2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-pause
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M2.88,7.88l1.54,1.54C4.15,10.23,4,11.1,4,12c0,4.41,3.59,8,8,8s8-3.59,8-8s-3.59-8-8-8c-0.9,0-1.77,0.15-2.58,0.42 L7.89,2.89C9.15,2.32,10.54,2,12,2c5.52,0,10,4.48,10,10s-4.48,10-10,10S2,17.52,2,12C2,10.53,2.32,9.14,2.88,7.88z M7,5.5 C7,6.33,6.33,7,5.5,7S4,6.33,4,5.5S4.67,4,5.5,4S7,4.67,7,5.5z M11,15H9V9h2V15z M15,15h-2V9h2V15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-zero
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.01 6.22c-.36-.43-.8-.74-1.31-.93S12.63 5 12 5c-.62 0-1.19.1-1.69.29-.51.19-.95.5-1.31.93s-.64.99-.84 1.69c-.2.7-.3 1.55-.3 2.55v2.04c0 1 .1 1.85.3 2.55.2.69.49 1.26.85 1.7s.8.75 1.31.95c.51.2 1.07.3 1.69.3.63 0 1.19-.1 1.7-.3.51-.2.94-.51 1.3-.95.35-.43.63-1 .83-1.7.2-.7.3-1.55.3-2.55h.01v-2.04c0-1.01-.1-1.85-.3-2.55-.2-.7-.48-1.26-.84-1.69zm-.97 6.58c0 .63-.04 1.17-.13 1.62-.09.45-.22.81-.39 1.09s-.38.48-.63.61-.54.19-.87.19c-.33 0-.62-.06-.87-.19s-.47-.33-.64-.61c-.17-.28-.31-.64-.4-1.09-.09-.44-.14-.98-.14-1.62v-2.67c0-.64.04-1.18.13-1.62.09-.44.23-.79.4-1.06s.39-.46.64-.58.54-.18.86-.18.61.06.86.19c.25.12.47.31.64.58.18.27.31.62.4 1.06.08.44.13.98.13 1.62h.01v2.66z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.5 15v-2h1.1l.9 2H21l-.9-2.1c.5-.3.9-.8.9-1.4v-1c0-.8-.7-1.5-1.5-1.5H16v4.86L17.14 15h.36zm0-4.5h2v1h-2v-1zm-4.5 0v.36l1.5 1.5V10.5c0-.8-.7-1.5-1.5-1.5h-1.86l1.5 1.5H13zM2.51 2.49L1.45 3.55 6.9 9h-.4v2h-2V9H3v6h1.5v-2.5h2V15H8v-4.9l1.5 1.5V15h3.4l7.6 7.6 1.06-1.06z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-wide-angle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 6c-2.45 0-4.71.2-7.29.64C4.24 8.42 4 10.22 4 12c0 1.78.24 3.58.71 5.36 2.58.44 4.84.64 7.29.64s4.71-.2 7.29-.64c.47-1.78.71-3.58.71-5.36 0-1.78-.24-3.58-.71-5.36C16.71 6.2 14.45 6 12 6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M21.13 5.78l-.25-.89-.93-.16C17.22 4.24 14.73 4 12 4s-5.22.24-7.95.72l-.93.16-.25.9C2.29 7.85 2 9.93 2 12s.29 4.15.87 6.22l.25.89.93.16c2.73.49 5.22.73 7.95.73s5.22-.24 7.95-.72l.93-.16.25-.89c.58-2.08.87-4.16.87-6.23s-.29-4.15-.87-6.22zm-1.84 11.58c-2.58.44-4.84.64-7.29.64s-4.71-.2-7.29-.64C4.24 15.58 4 13.78 4 12c0-1.78.24-3.58.71-5.36C7.29 6.2 9.55 6 12 6s4.71.2 7.29.64c.47 1.78.71 3.58.71 5.36 0 1.78-.24 3.58-.71 5.36z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 transform
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8 4h2L7 1 4 4h2v2H2v2h4v8c0 1.1.9 2 2 2h8v2h-2l3 3 3-3h-2v-2h4v-2H8V4zm10 10V8c0-1.1-.9-2-2-2h-6v2h6v6h2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-lira
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9,8.76V3h2v4.51L15,5v2.36l-4,2.51l0.01,2.35L15,9.72v2.36l-4,2.51V19c2.76,0,5-2.24,5-5h2c0,3.87-3.13,7-7,7H9v-5.16 l-3,1.88l0-2.36l3-1.88v-2.36L6,13l0-2.36L9,8.76z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 camera-roll
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M12 5H9V3H7v2H4v15h8v-2h8V7h-8V5zm-1 12H9v-2h2v2zm0-7H9V8h2v2zm6-2h2v2h-2V8zm0 7h2v2h-2v-2zm-4-7h2v2h-2V8zm0 7h2v2h-2v-2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M14 5c0-1.1-.9-2-2-2h-1V2c0-.55-.45-1-1-1H6c-.55 0-1 .45-1 1v1H4c-1.1 0-2 .9-2 2v15c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2h8V5h-8zm6 13h-8v2H4V5h3V3h2v2h3v2h8v11zM9 15h2v2H9zm0-7h2v2H9zm4 7h2v2h-2zm0-7h2v2h-2zm4 7h2v2h-2zm0-7h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 slideshow
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M5 19h14V5H5v14zm5-11l5 4-5 4V8z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zM10 8v8l5-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 music-note
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "2",
    :opacity ".3",
    :cy "17",
    :cx "10.01",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 3l.01 10.55c-.59-.34-1.27-.55-2-.55C7.79 13 6 14.79 6 17s1.79 4 4.01 4S14 19.21 14 17V7h4V3h-6zm-1.99 16c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _8mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.5",
      :x "11.5",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "11.5",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M10,6.5 c0-0.55,0.45-1,1-1h2.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H11c-0.55,0-1-0.45-1-1V6.5z M6,13.5c0-0.55,0.45-1,1-1h4.5 c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,11.5h2.5c0.55,0,1-0.45,1-1v-4c0-0.55-0.45-1-1-1H11c-0.55,0-1,0.45-1,1v4C10,11.05,10.45,11.5,11,11.5z M11.5,6.5H13 V8h-1.5V6.5z M11.5,9H13v1.5h-1.5V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 panorama-vertical
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M6.54 4c.77 2.6 1.16 5.28 1.16 8 0 2.72-.39 5.4-1.16 8h10.91c-.77-2.6-1.16-5.28-1.16-8 0-2.72.39-5.4 1.16-8H6.54z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.94 21.12c-1.1-2.94-1.64-6.03-1.64-9.12 0-3.09.55-6.18 1.64-9.12.04-.11.06-.22.06-.31 0-.34-.23-.57-.63-.57H4.63c-.4 0-.63.23-.63.57 0 .1.02.2.06.31C5.16 5.82 5.71 8.91 5.71 12c0 3.09-.55 6.18-1.64 9.12-.05.11-.07.22-.07.31 0 .33.23.57.63.57h14.75c.39 0 .63-.24.63-.57-.01-.1-.03-.2-.07-.31zM17.45 20H6.54c.77-2.6 1.16-5.28 1.16-8 0-2.72-.39-5.4-1.16-8h10.91c-.77 2.6-1.16 5.28-1.16 8 0 2.72.39 5.4 1.16 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _2mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M10,9 c0-0.55,0.45-1,1-1h2V7h-3V5.5h3.5c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1h-2v1h3v1.5H10V9z M6,13.5c0-0.55,0.45-1,1-1h4.5 c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.5,10h-3V9h2c0.55,0,1-0.45,1-1V6.5c0-0.55-0.45-1-1-1H10V7h3v1h-2c-0.55,0-1,0.45-1,1v2.5h4.5V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 photo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M19 5H5v14h14V5zM6 17l3-3.86 2.14 2.58 3-3.87L18 17H6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 21h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2zM5 5h14v14H5V5zm6.14 10.72L9 13.14 6 17h12l-3.86-5.14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-iridescent
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3", :d "M7 11h10v2H7z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M5 15h14V9H5v6zm2-4h10v2H7v-2zm4-10h2v3h-2zm6.25 4.39l1.41 1.41 1.8-1.79-1.42-1.41zM11 20h2v3h-2zm6.24-1.29l1.79 1.8 1.42-1.42-1.8-1.79zM5.34 6.805l-1.788-1.79L4.96 3.61l1.788 1.788zM3.55 19.08l1.41 1.42 1.79-1.8-1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-awesome-mosaic
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "5",
      :x "5",
      :width "4",
      :opacity ".3",
      :height "14",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "15",
      :width "4",
      :opacity ".3",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "15",
      :width "4",
      :opacity ".3",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,5v14c0,1.1,0.89,2,2,2h6V3H5C3.89,3,3,3.9,3,5z M9,19H5V5h4V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M19,3h-6v8h8V5C21,3.9,20.1,3,19,3z M19,9h-4V5h4V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M13,21h6c1.1,0,2-0.9,2-2v-6h-8V21z M15,15h4v4h-4V15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 colorize
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M15.896 9.023l-.92-.92L17.67 5.41l.92.92z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20.71 5.63l-2.34-2.34c-.2-.2-.45-.29-.71-.29s-.51.1-.7.29l-3.12 3.12-1.93-1.91-1.41 1.41 1.42 1.42L3 16.25V21h4.75l8.92-8.92 1.42 1.42 1.41-1.41-1.92-1.92 3.12-3.12c.4-.4.4-1.03.01-1.42zM6.92 19L5 17.08l8.06-8.06 1.92 1.92L6.92 19zm8.98-9.97l-.93-.93 2.69-2.69.92.92-2.68 2.7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _17mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M12,5.5 h3.5c0.67,0,1.15,0.65,0.96,1.29L15,11.5h-1.75L14.62,7H12V5.5z M7,5.5h3v6H8.5V7H7V5.5z M6,13.5c0-0.55,0.45-1,1-1h4.5 c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,11.5 10,11.5 10,5.5 7,5.5 7,7 8.5,7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.25,11.5H15l1.46-4.71c0.19-0.64-0.29-1.29-0.96-1.29H12V7h2.62L13.25,11.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 panorama-wide-angle-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,4C8.03,4,5.15,4.63,3,5c-0.55,1.97-1,3.92-1,7c0,3.03,0.45,5.05,1,7c2.15,0.37,4.98,1,9,1c3.97,0,6.85-0.63,9-1 c0.57-2.02,1-3.99,1-7c0-3.03-0.45-5.05-1-7C18.85,4.63,16.02,4,12,4z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 rotate-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 17.91v2.02c3.95-.49 7-3.85 7-7.93s-3.05-7.44-7-7.93V1L8.45 5.55 13 10V6.09c2.84.48 5 2.94 5 5.91s-2.16 5.43-5 5.91zm-7.31-1.02l1.41-1.42c-.52-.75-.87-1.59-1.01-2.47H4.07c.17 1.39.72 2.73 1.62 3.89zm1.42-8.36L5.7 7.11C4.8 8.27 4.24 9.61 4.07 11h2.02c.14-.87.49-1.72 1.02-2.47zM11 17.9c-.87-.15-1.71-.49-2.46-1.03L7.1 18.32c1.16.9 2.51 1.44 3.9 1.61V17.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flare
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.644 7.05L7.05 5.645l2.123 2.122-1.408 1.407zM11 1h2v6h-2zm5.242 13.834l2.12 2.12-1.406 1.408-2.12-2.12zM14.834 7.76l2.12-2.123 1.41 1.407-2.123 2.122zm-5.668 8.482l-2.122 2.12-1.407-1.406 2.122-2.122zM12 9c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zm-1 8h2v6h-2zM1 11h6v2H1zm16 0h6v2h-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _6mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "11.5",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M10,6.5 c0-0.55,0.45-1,1-1h3.5V7h-3v1h2c0.55,0,1,0.45,1,1v1.5c0,0.55-0.45,1-1,1H11c-0.55,0-1-0.45-1-1V6.5z M6,13.5c0-0.55,0.45-1,1-1 h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,11.5h2.5c0.55,0,1-0.45,1-1V9c0-0.55-0.45-1-1-1h-2V7h3V5.5H11c-0.55,0-1,0.45-1,1v4C10,11.05,10.45,11.5,11,11.5z M11.5,9H13v1.5h-1.5V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _13mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M12,10h3 V9h-2V8h2V7h-3V5.5h3.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H12V10z M7,5.5h3v6H8.5V7H7V5.5z M6,13.5c0-0.55,0.45-1,1-1h4.5 c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,11.5 10,11.5 10,5.5 7,5.5 7,7 8.5,7",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,11.5 10,11.5 10,5.5 7,5.5 7,7 8.5,7",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.5,10.5v-4c0-0.55-0.45-1-1-1H12V7h3v1h-2v1h2v1h-3v1.5h3.5C16.05,11.5,16.5,11.05,16.5,10.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M16.5,10.5v-4c0-0.55-0.45-1-1-1H12V7h3v1h-2v1h2v1h-3v1.5h3.5C16.05,11.5,16.5,11.05,16.5,10.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 motion-photos-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M2.81,2.81L1.39,4.22l2.27,2.27C2.61,8.07,2,9.96,2,12c0,5.52,4.48,10,10,10c2.04,0,3.93-0.61,5.51-1.66l2.27,2.27 l1.41-1.42L2.81,2.81z M12,20c-4.41,0-8-3.59-8-8c0-1.48,0.41-2.86,1.12-4.06l10.93,10.94C14.86,19.59,13.48,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,4c4.41,0,8,3.59,8,8c0,1.48-0.41,2.86-1.12,4.05l1.45,1.45C21.39,15.93,22,14.04,22,12c0-5.52-4.48-10-10-10 C9.96,2,8.07,2.61,6.49,3.66l1.45,1.45C9.14,4.41,10.52,4,12,4z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-original
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zm-5.04-6.71l-2.75 3.54-1.96-2.36L6.5 17h11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timer-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,20c1.47,0,2.83-0.45,3.95-1.22L6.22,9.05C5.45,10.17,5,11.53,5,13C5,16.87,8.13,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,6c-0.94,0-1.83,0.19-2.65,0.52L11,8.17V8h2v2.17l5.48,5.48C18.81,14.83,19,13.94,19,13 C19,9.13,15.87,6,12,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "1", :x "9", :width "6", :height "2", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M12,6c3.87,0,7,3.13,7,7c0,0.94-0.19,1.83-0.52,2.65l1.5,1.5C20.63,15.91,21,14.5,21,13c0-2.12-0.74-4.07-1.97-5.61 l1.42-1.42c-0.43-0.51-0.9-0.99-1.41-1.41l-1.42,1.42C16.07,4.74,14.12,4,12,4c-1.5,0-2.91,0.37-4.15,1.02l1.5,1.5 C10.17,6.19,11.06,6,12,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,8 11,8.17 13,10.17 13,8", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M2.81,2.81L1.39,4.22l3.4,3.4C3.67,9.12,3,10.98,3,13c0,4.97,4.02,9,9,9c2.02,0,3.88-0.67,5.38-1.79l2.4,2.4l1.41-1.41 L2.81,2.81z M12,20c-3.87,0-7-3.13-7-7c0-1.47,0.45-2.83,1.22-3.95l9.73,9.73C14.83,19.55,13.47,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 face-retouching-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M12,4c-0.46,0-0.91,0.05-1.34,0.12C12.06,6.44,14.6,8,17.5,8c0.46,0,0.91-0.05,1.34-0.12 C17.44,5.56,14.9,4,12,4z M4.42,9.47C5.09,9.09,5.7,8.61,6.23,8.06L5.51,7.34C5.05,7.99,4.68,8.7,4.42,9.47z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9,14.25c0.69,0,1.25-0.56,1.25-1.25S9.69,11.75,9,11.75S7.75,12.31,7.75,13S8.31,14.25,9,14.25z M17.5,10 c0.75,0,1.47-0.09,2.17-0.24C19.88,10.47,20,11.22,20,12c0,1.22-0.28,2.37-0.77,3.4l1.49,1.49C21.53,15.44,22,13.78,22,12 c0-5.52-4.48-10-10-10c-1.78,0-3.44,0.47-4.89,1.28l5.33,5.33C13.93,9.49,15.65,10,17.5,10z M10.66,4.12C11.09,4.05,11.54,4,12,4 c2.9,0,5.44,1.56,6.84,3.88C18.41,7.95,17.96,8,17.5,8C14.6,8,12.06,6.44,10.66,4.12z M1.89,3.72l2.19,2.19C2.78,7.6,2,9.71,2,12 c0,5.52,4.48,10,10,10c2.29,0,4.4-0.78,6.09-2.08l2.19,2.19l1.41-1.41L3.31,2.31L1.89,3.72z M16.66,18.49 C15.35,19.44,13.74,20,12,20c-4.41,0-8-3.59-8-8c0-0.05,0.01-0.1,0-0.14c1.39-0.52,2.63-1.35,3.64-2.39L16.66,18.49z M5.51,7.34 l0.72,0.72C5.7,8.61,5.09,9.09,4.42,9.47C4.68,8.7,5.05,7.99,5.51,7.34z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 palette
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/path
       {:opacity ".3",
        :enable-background "new",
        :d
        "M12,4c-4.41,0-8,3.59-8,8s3.59,8,8,8c0.28,0,0.5-0.22,0.5-0.5 c0-0.16-0.08-0.28-0.14-0.35c-0.41-0.46-0.63-1.05-0.63-1.65c0-1.38,1.12-2.5,2.5-2.5H16c2.21,0,4-1.79,4-4 C20,7.14,16.41,4,12,4z M6.5,13C5.67,13,5,12.33,5,11.5S5.67,10,6.5,10S8,10.67,8,11.5S7.33,13,6.5,13z M9.5,9 C8.67,9,8,8.33,8,7.5S8.67,6,9.5,6S11,6.67,11,7.5S10.33,9,9.5,9z M14.5,9C13.67,9,13,8.33,13,7.5S13.67,6,14.5,6 S16,6.67,16,7.5S15.33,9,14.5,9z M19,11.5c0,0.83-0.67,1.5-1.5,1.5S16,12.33,16,11.5s0.67-1.5,1.5-1.5S19,10.67,19,11.5z",
        :stroke nil,
        :fill nil})
      (helix.dom/path
       {:d
        "M12,2C6.49,2,2,6.49,2,12s4.49,10,10,10c1.38,0,2.5-1.12,2.5-2.5c0-0.61-0.23-1.21-0.64-1.67 c-0.08-0.09-0.13-0.21-0.13-0.33c0-0.28,0.22-0.5,0.5-0.5H16c3.31,0,6-2.69,6-6C22,6.04,17.51,2,12,2z M16,15h-1.77 c-1.38,0-2.5,1.12-2.5,2.5c0,0.61,0.22,1.19,0.63,1.65c0.06,0.07,0.14,0.19,0.14,0.35c0,0.28-0.22,0.5-0.5,0.5 c-4.41,0-8-3.59-8-8s3.59-8,8-8s8,3.14,8,7C20,13.21,18.21,15,16,15z",
        :stroke nil,
        :fill nil})
      (helix.dom/circle
       {:r "1.5", :cy "11.5", :cx "6.5", :stroke nil, :fill nil})
      (helix.dom/circle
       {:r "1.5", :cy "7.5", :cx "9.5", :stroke nil, :fill nil})
      (helix.dom/circle
       {:r "1.5", :cy "7.5", :cx "14.5", :stroke nil, :fill nil})
      (helix.dom/circle
       {:r "1.5", :cy "11.5", :cx "17.5", :stroke nil, :fill nil})))))))


(helix.core/defnc
 looks-two
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M19 5H5v14h14V5zm-4 6c0 1.11-.9 2-2 2h-2v2h4v2H9v-4c0-1.11.9-2 2-2h2V9H9V7h4c1.1 0 2 .89 2 2v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M5 21h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2zM5 5h14v14H5V5zm8 2H9v2h4v2h-2c-1.1 0-2 .89-2 2v4h6v-2h-4v-2h2c1.1 0 2-.89 2-2V9c0-1.11-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-to-photos
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M20 4H8v12h12V4zm-1 7h-4v4h-2v-4H9V9h4V5h2v4h4v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M4 22h14v-2H4V6H2v14c0 1.1.9 2 2 2zm4-4h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2zM8 4h12v12H8V4zm7 1h-2v4H9v2h4v4h2v-4h4V9h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _19mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M5,19h14V5H5V19z M18,13.5V16c0,0.55-0.45,1-1,1h-2v1.5h-1.5v-6H17C17.55,12.5,18,12.95,18,13.5z M12,10h3 V9h-2c-0.55,0-1-0.45-1-1V6.5c0-0.55,0.45-1,1-1h2.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H12V10z M7,5.5h3v6H8.5V7H7V5.5z M6,13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v5H11V14h-1v3H8.5v-3h-1v4.5H6V13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.5",
      :x "13.5",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :opacity ".3",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.5,14h1v3H10v-3h1v4.5h1.5v-5c0-0.55-0.45-1-1-1H7c-0.55,0-1,0.45-1,1v5h1.5V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.5,18.5H15V17h2c0.55,0,1-0.45,1-1v-2.5c0-0.55-0.45-1-1-1h-3.5V18.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,19H5V5h14V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.5,10.5v-4c0-0.55-0.45-1-1-1H13c-0.55,0-1,0.45-1,1V8c0,0.55,0.45,1,1,1h2v1h-3v1.5h3.5 C16.05,11.5,16.5,11.05,16.5,10.5z M15,8h-1.5V6.5H15V8z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,11.5 10,11.5 10,5.5 7,5.5 7,7 8.5,7",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 rotate-90-degrees-ccw
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:opacity ".3",
    :d "M7.35 9.24L3.69 12.9l3.65 3.66L11 12.9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M7.34 6.41L.86 12.9l6.49 6.48 6.49-6.48-6.5-6.49zm0 10.15L3.69 12.9l3.66-3.66L11 12.9l-3.66 3.66zm12.02-9.92C17.61 4.88 15.3 4 13 4V.76L8.76 5 13 9.24V6c1.79 0 3.58.68 4.95 2.05 2.73 2.73 2.73 7.17 0 9.9C16.58 19.32 14.79 20 13 20c-.97 0-1.94-.21-2.84-.61l-1.49 1.49C10.02 21.62 11.51 22 13 22c2.3 0 4.61-.88 6.36-2.64 3.52-3.51 3.52-9.21 0-12.72z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-auto
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M2.88,7.88l1.54,1.54C4.15,10.23,4,11.1,4,12c0,4.41,3.59,8,8,8s8-3.59,8-8s-3.59-8-8-8c-0.9,0-1.77,0.15-2.58,0.42 L7.89,2.89C9.15,2.32,10.54,2,12,2c5.52,0,10,4.48,10,10s-4.48,10-10,10S2,17.52,2,12C2,10.53,2.32,9.14,2.88,7.88z M7,5.5 C7,6.33,6.33,7,5.5,7S4,6.33,4,5.5S4.67,4,5.5,4S7,4.67,7,5.5z M12.03,8.99h-0.07l-1.16,3.31h2.39L12.03,8.99z M11.29,7.5h1.43 l3.01,8h-1.39l-0.72-2.04h-3.23L9.66,15.5H8.28L11.29,7.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 linked-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 20H4V8h4.05l1.83-2H15V4H9L7.17 6H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V9h-2v11zM16 2v1.33c2.58 0 4.66 2.09 4.67 4.66H22C21.99 4.68 19.31 2 16 2zm0 2.67V6c1.11 0 1.99.89 2 1.99h1.33c-.01-1.84-1.49-3.32-3.33-3.32z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:opacity ".3",
    :d
    "M14.98 10.01c-.13-.09-.26-.18-.39-.26.14.08.27.17.39.26zM17 9c0-.37-.11-.71-.28-1.01-.18-.3-.43-.55-.73-.72C15.7 7.1 15.36 7 15 7V6H9.88L8.05 8H4v12h16V9h-3zm-5 10c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M12 9c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5zm0 8c-1.65 0-3-1.35-3-3s1.35-3 3-3 3 1.35 3 3-1.35 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M2.88,7.88l1.54,1.54C4.15,10.23,4,11.1,4,12c0,4.41,3.59,8,8,8s8-3.59,8-8s-3.59-8-8-8c-0.9,0-1.77,0.15-2.58,0.42 L7.89,2.89C9.15,2.32,10.54,2,12,2c5.52,0,10,4.48,10,10s-4.48,10-10,10S2,17.52,2,12C2,10.53,2.32,9.14,2.88,7.88z M7,5.5 C7,6.33,6.33,7,5.5,7S4,6.33,4,5.5S4.67,4,5.5,4S7,4.67,7,5.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 blur-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/circle
   {:r "1.5", :cy "10", :cx "14", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "18", :cx "14", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14", :cx "14", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "14", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M3 9.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM14.5 3c0-.28-.22-.5-.5-.5s-.5.22-.5.5.22.5.5.5.5-.22.5-.5zM21 14.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "18", :cx "18", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M13.5 21c0 .28.22.5.5.5s.5-.22.5-.5-.22-.5-.5-.5-.5.22-.5.5zM21 10.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "14", :cx "18", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "18", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "18", :cx "6", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "14", :cx "6", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M3.5 14c0-.28-.22-.5-.5-.5s-.5.22-.5.5.22.5.5.5.5-.22.5-.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "10", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "10", :cx "6", :stroke nil, :fill nil})
  (helix.dom/circle {:r "1", :cy "6", :cx "6", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M9.5 21c0 .28.22.5.5.5s.5-.22.5-.5-.22-.5-.5-.5-.5.22-.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "18", :cx "10", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M10.5 3c0-.28-.22-.5-.5-.5s-.5.22-.5.5.22.5.5.5.5-.22.5-.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "14", :cx "10", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "10", :cx "10", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "10", :cx "18", :stroke nil, :fill nil})))


(helix.core/defnc
 currency-yen
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "13.92,11 18,11 18,13 13,13 13,15 18,15 18,17 13,17 13,21 11,21 11,17 6,17 6,15 11,15 11,13 6,13 6,11 10.08,11 5,3 7.37,3 12,10.29 16.63,3 19,3",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 view-compact
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,13.25h2.5v-2.5H4V13.25z M4,18h2.5v-2.5H4V18z M8.5,8.5H11V6H8.5V8.5z M17.5,18H20v-2.5h-2.5V18z M17.5,13.25H20v-2.5h-2.5V13.25z M17.5,6v2.5H20V6H17.5z M13,8.5h2.5V6H13V8.5z M8.5,13.25H11v-2.5H8.5V13.25z M8.5,18H11v-2.5 H8.5V18z M4,8.5h2.5V6H4V8.5z M13,13.25h2.5v-2.5H13V13.25z M13,18h2.5v-2.5H13V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2,4v16h20V4H2z M6.5,18H4v-2.5h2.5V18z M6.5,13.25H4v-2.5h2.5V13.25z M6.5,8.5H4V6h2.5V8.5z M11,18H8.5v-2.5H11V18z M11,13.25H8.5v-2.5H11V13.25z M11,8.5H8.5V6H11V8.5z M15.5,18H13v-2.5h2.5V18z M15.5,13.25H13v-2.5h2.5V13.25z M15.5,8.5H13V6 h2.5V8.5z M20,18h-2.5v-2.5H20V18z M20,13.25h-2.5v-2.5H20V13.25z M20,8.5h-2.5V6H20V8.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 bed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M19 8c0-.55-.45-1-1-1h-4c-.55 0-1 .45-1 1v2h6V8zm-8 0c0-.55-.45-1-1-1H6c-.55 0-1 .45-1 1v2h6V8zm8 4H5c-.55 0-1 .45-1 1v2h16v-2c0-.55-.45-1-1-1z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21 10.78V8c0-1.65-1.35-3-3-3h-4c-.77 0-1.47.3-2 .78-.53-.48-1.23-.78-2-.78H6C4.35 5 3 6.35 3 8v2.78c-.61.55-1 1.34-1 2.22v6h2v-2h16v2h2v-6c0-.88-.39-1.67-1-2.22zM13 8c0-.55.45-1 1-1h4c.55 0 1 .45 1 1v2h-6V8zM5 8c0-.55.45-1 1-1h4c.55 0 1 .45 1 1v2H5V8zm15 7H4v-2c0-.55.45-1 1-1h14c.55 0 1 .45 1 1v2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 door-back
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M7,19h10V5H7V19z M9,11h2v2H9V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,19V5c0-1.1-0.9-2-2-2H7C5.9,3,5,3.9,5,5v14H3v2h18v-2H19z M17,19H7V5h10V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11",
      :x "9",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 door-front
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M7,19h10V5H7V19z M13,11h2v2h-2V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11",
      :x "13",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,19V5c0-1.1-0.9-2-2-2H7C5.9,3,5,3.9,5,5v14H3v2h18v-2H19z M17,19H7V5h10V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 bedroom-child
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M4,20h16V4H4V20z M6,12.87c0-1,0.62-1.85,1.5-2.2V9c0-1.1,0.9-2,2-2h5c1.1,0,2,0.9,2,2v1.67 c0.88,0.35,1.5,1.2,1.5,2.2V17h-1.5v-1.5h-9V17H6V12.87z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M20,20H4V4h16V20z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M7.5,15.5h9V17H18v-4.13c0-1-0.62-1.85-1.5-2.2V9c0-1.1-0.9-2-2-2h-5c-1.1,0-2,0.9-2,2v1.67c-0.88,0.35-1.5,1.2-1.5,2.2V17 h1.5V15.5z M9,8.5h6v2H9V8.5z M8.37,12h7.27c0.48,0,0.87,0.39,0.87,0.87V14h-9v-1.13H7.5C7.5,12.39,7.89,12,8.37,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bathroom
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,20h16V4H4V20z M9,18c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S9.55,18,9,18z M9,15c-0.55,0-1-0.45-1-1 s0.45-1,1-1s1,0.45,1,1S9.55,15,9,15z M12,18c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S12.55,18,12,18z M12,15 c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S12.55,15,12,15z M15,18c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S15.55,18,15,18z M15,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S15.55,15,15,15z M7,11c0-2.76,2.24-5,5-5s5,2.24,5,5v1H7V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "14", :cx "15", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "14", :cx "12", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "17", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M20,20H4V4h16V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,11c0-2.76-2.24-5-5-5s-5,2.24-5,5v1h10V11z M8.54,10.5c0.24-1.69,1.7-3,3.46-3s3.22,1.31,3.47,3H8.54z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "17", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "14", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "17", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 bedroom-baby
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,20h16V4H4V20z M6.45,10.5l-0.95-1L7,7.76L6,7h3.65l1.73,3H17v1h-1v2.5l0.84,1.46 c0.39-0.28,0.76-0.58,1.1-0.92L19,15.1c-1.87,1.87-4.36,2.9-7,2.9s-5.13-1.03-7-2.9l1.06-1.06c0.34,0.34,0.71,0.65,1.1,0.92 L8,13.5V9.51L6.45,10.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M15.53,15.71l-0.03-0.06l-0.81-1.41c-1.74,0.65-3.66,0.65-5.4,0l-0.81,1.41l-0.03,0.06 c1.1,0.52,2.28,0.79,3.53,0.79S14.43,16.22,15.53,15.71z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.16,14.96c-0.39-0.27-0.76-0.58-1.1-0.92L5,15.1c1.87,1.87,4.36,2.9,7,2.9s5.13-1.03,7-2.9l-1.06-1.06 c-0.34,0.34-0.71,0.64-1.1,0.92L16,13.5V11h1v-1h-5.62L9.65,7H6l1,0.76L5.5,9.5l0.95,1L8,9.51v3.99L7.16,14.96z M8.48,15.65 l0.81-1.41c1.74,0.65,3.66,0.65,5.4,0l0.81,1.41l0.03,0.06c-1.1,0.51-2.3,0.79-3.55,0.79s-2.43-0.27-3.53-0.79L8.48,15.65z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M20,20H4V4h16V20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 manage-search
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "12",
      :x "2",
      :width "5",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.17,13.75C18.69,12.96,19,12.02,19,11c0-2.76-2.24-5-5-5s-5,2.24-5,5s2.24,5,5,5c1.02,0,1.96-0.31,2.76-0.83L20.59,19 L22,17.59L18.17,13.75z M14,14c-1.65,0-3-1.35-3-3c0-1.65,1.35-3,3-3s3,1.35,3,3C17,12.65,15.65,14,14,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7", :x "2", :width "5", :height "2", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "2",
      :width "10",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 living
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,20h16V4H4V20z M5,12.5c0-0.92,0.51-1.72,1.25-2.15V9c0-1.66,1.34-3,3-3h5.5c1.66,0,3,1.34,3,3v1.35 C18.49,10.78,19,11.58,19,12.5V16c0,1.1-0.9,2-2,2H7c-1.1,0-2-0.9-2-2V12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M20,20H4V4h16V20z M7,18h10 c1.1,0,2-0.9,2-2v-3.5c0-0.92-0.51-1.72-1.25-2.15V9c0-1.66-1.34-3-3-3h-5.5c-1.66,0-3,1.34-3,3v1.35C5.51,10.78,5,11.58,5,12.5 V16C5,17.1,5.9,18,7,18z M7.75,9c0-0.83,0.67-1.5,1.5-1.5h5.5c0.83,0,1.5,0.67,1.5,1.5v1.03C14.99,10.15,14,11.2,14,12.5V13h-4 v-0.5c0-1.3-0.99-2.35-2.25-2.47V9z M6.5,12.5c0-0.55,0.45-1,1-1s1,0.45,1,1v2h7v-2c0-0.55,0.45-1,1-1s1,0.45,1,1V16 c0,0.28-0.22,0.5-0.5,0.5H7c-0.28,0-0.5-0.22-0.5-0.5V12.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 doorbell
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M6,10v9h12v-9l-6-4.5L6,10z M12,17.5c-0.55,0-1-0.45-1-1h2C13,17.05,12.55,17.5,12,17.5z M12.75,9.25V9.5 C14.19,9.84,15,11.12,15,12.66V15h1v1H8v-1h1v-2.34c0-1.54,0.82-2.82,2.25-3.16V9.25c0-0.41,0.34-0.75,0.75-0.75 S12.75,8.84,12.75,9.25z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M12,3L4,9v12h16V9L12,3z M18,19H6v-9l6-4.5l6,4.5V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.25,9.25V9.5C9.82,9.84,9,11.12,9,12.66V15H8v1h8v-1h-1v-2.34c0-1.54-0.81-2.82-2.25-3.16V9.25 c0-0.41-0.34-0.75-0.75-0.75S11.25,8.84,11.25,9.25z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M12,17.5c0.55,0,1-0.45,1-1h-2C11,17.05,11.45,17.5,12,17.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 coffee-maker
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:opacity ".3",
       :d "M13,19c1.65,0,3-1.35,3-3v-3h-6v3C10,17.65,11.35,19,13,19z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M9,7h8c0.55,0,1-0.45,1-1V4h2V2H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h14v-2h-4.03C17.2,19.09,18,17.64,18,16v-5H8v5 c0,1.64,0.81,3.09,2.03,4H6V4h2v2C8,6.55,8.45,7,9,7z M10,16v-3h6v3c0,1.65-1.35,3-3,3S10,17.65,10,16z",
       :stroke nil,
       :fill nil}))
    (helix.dom/circle
     {:r "1", :cy "9", :cx "13", :stroke nil, :fill nil})))))


(helix.core/defnc
 chair
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M7,13h10v-2c0-0.88,0.39-1.67,1-2.22V6c0-0.55-0.45-1-1-1H7C6.45,5,6,5.45,6,6 v2.78C6.61,9.33,7,10.12,7,11V13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :enable-background "new",
      :d
      "M20,10c-0.55,0-1,0.45-1,1v4H5v-4c0-0.55-0.45-1-1-1s-1,0.45-1,1v5 c0,0.55,0.45,1,1,1h16c0.55,0,1-0.45,1-1v-5C21,10.45,20.55,10,20,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,8V6c0-1.65-1.35-3-3-3H7C5.35,3,4,4.35,4,6v2c-1.65,0-3,1.35-3,3v5c0,1.65,1.35,3,3,3v1c0,0.55,0.45,1,1,1 c0.55,0,1-0.45,1-1v-1h12v1c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1v-1c1.65,0,3-1.35,3-3v-5C23,9.35,21.65,8,20,8z M6,6 c0-0.55,0.45-1,1-1h10c0.55,0,1,0.45,1,1v2.78c-0.61,0.55-1,1.34-1,2.22v2H7v-2c0-0.88-0.39-1.67-1-2.22V6z M21,16 c0,0.55-0.45,1-1,1H4c-0.55,0-1-0.45-1-1v-5c0-0.55,0.45-1,1-1s1,0.45,1,1v4h14v-4c0-0.55,0.45-1,1-1s1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shower
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M12,7c-2.76,0-5,2.24-5,5h10C17,9.24,14.76,7,12,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "20", :cx "8", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "17", :cx "16", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M13,5.08V3h-2v2.08C7.61,5.57,5,8.47,5,12v2h14v-2C19,8.47,16.39,5.57,13,5.08z M7,12c0-2.76,2.24-5,5-5s5,2.24,5,5H7z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "20", :cx "16", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "17", :cx "12", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "17", :cx "8", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "20", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 podcasts
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,12c0,0.74-0.4,1.38-1,1.72V22h-2v-8.28c-0.6-0.35-1-0.98-1-1.72c0-1.1,0.9-2,2-2S14,10.9,14,12z M12,6 c-3.31,0-6,2.69-6,6c0,1.74,0.75,3.31,1.94,4.4l1.42-1.42C8.53,14.25,8,13.19,8,12c0-2.21,1.79-4,4-4s4,1.79,4,4 c0,1.19-0.53,2.25-1.36,2.98l1.42,1.42C17.25,15.31,18,13.74,18,12C18,8.69,15.31,6,12,6z M12,2C6.48,2,2,6.48,2,12 c0,2.85,1.2,5.41,3.11,7.24l1.42-1.42C4.98,16.36,4,14.29,4,12c0-4.41,3.59-8,8-8s8,3.59,8,8c0,2.29-0.98,4.36-2.53,5.82l1.42,1.42 C20.8,17.41,22,14.85,22,12C22,6.48,17.52,2,12,2z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 feed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:opacity ".3",
     :d
     "M15,5H5v14h14V9h-4V5z M7,7h5v2H7V7z M17,17H7v-2h10V17z M17,11v2H7v-2H17z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M7,13h10v-2H7V13z M7,17h10v-2H7V17z M16,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V8L16,3z M19,19H5V5 h10v4h4V19z M12,7H7v2h5V7z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 window
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "13",
      :x "13",
      :width "6",
      :opacity ".3",
      :height "6",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "13",
      :x "5",
      :width "6",
      :opacity ".3",
      :height "6",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "5",
      :width "6",
      :opacity ".3",
      :height "6",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "13",
      :width "6",
      :opacity ".3",
      :height "6",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-8 16H5v-6h6v6zm0-8H5V5h6v6zm8 8h-6v-6h6v6zm0-8h-6V5h6v6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 coffee
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M6,11c0,2.76,2.24,5,5,5s5-2.24,5-5v-1H6V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "19",
      :x "4",
      :width "16",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.5,3H6C4.9,3,4,3.9,4,5v5.71c0,3.83,2.95,7.18,6.78,7.29c3.96,0.12,7.22-3.06,7.22-7v-1h0.5c1.93,0,3.5-1.57,3.5-3.5 S20.43,3,18.5,3z M16,11c0,2.76-2.24,5-5,5s-5-2.24-5-5v-1h10V11z M16,8H6V5h10V8z M18.5,8H18V5h0.5C19.33,5,20,5.67,20,6.5 S19.33,8,18.5,8z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 table-bar
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/ellipse
     {:ry "1.5", :rx "7.72", :opacity ".3", :cy "7.5", :cx "12"})
    (helix.dom/path
     {:d
      "M22,7.5C22,5.57,17.52,4,12,4S2,5.57,2,7.5c0,1.81,3.95,3.31,9,3.48V15H9.35c-0.82,0-1.55,0.5-1.86,1.26L6,20h2l1.2-3h5.6 l1.2,3h2l-1.5-3.74C16.2,15.5,15.46,15,14.65,15H13v-4.02C18.05,10.81,22,9.31,22,7.5z M12,9C7.95,9,5.26,8.14,4.28,7.5 C5.26,6.86,7.95,6,12,6s6.74,0.86,7.72,1.5C18.74,8.14,16.05,9,12,9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera-indoor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M6,10v9h12v-9l-6-4.5L6,10z M14,12v1l2-1.06v4.12L14,15v1c0,0.55-0.45,1-1,1H9c-0.55,0-1-0.45-1-1v-4 c0-0.55,0.45-1,1-1h4C13.55,11,14,11.45,14,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,12v4c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-1l2,1.06v-4.12L14,13v-1c0-0.55-0.45-1-1-1H9C8.45,11,8,11.45,8,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M12,3L4,9v12h16V9L12,3z M18,19H6v-9l6-4.5l6,4.5V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 door-sliding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M13,19h5V5h-5V19z M14,11h2v2h-2V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d "M6,19h5V5H6V19z M8,11h2v2H8V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,19V5c0-1.1-0.9-2-2-2H6C4.9,3,4,3.9,4,5v14H3v2h18v-2H20z M11,19H6V5h5V19z M18,19h-5V5h5V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11",
      :x "8",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11",
      :x "14",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 light
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d "M10,17c0,1.1,0.9,2,2,2s2-0.9,2-2h-2H10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13,6.06V3h-2v3.06c-4.5,0.5-8,4.31-8,8.93C3,16.1,3.9,17,5.01,17H8c0,2.21,1.79,4,4,4s4-1.79,4-4h2.99 C20.1,17,21,16.1,21,14.99C21,10.37,17.5,6.56,13,6.06z M12,19c-1.1,0-2-0.9-2-2h2h2C14,18.1,13.1,19,12,19z M12,15H5 c0-3.86,3.14-7,7-7s7,3.14,7,7H12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flatware
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,7.08c0,1.77-0.84,3.25-2,3.82V21h-2V10.9c-1.16-0.57-2-2.05-2-3.82C10.01,4.83,11.35,3,13,3C14.66,3,16,4.83,16,7.08z M17,3v18h2v-8h2V7C21,5.24,19.76,3,17,3z M8.28,3c-0.4,0-0.72,0.32-0.72,0.72V7H6.72V3.72C6.72,3.32,6.4,3,6,3 S5.28,3.32,5.28,3.72V7H4.44V3.72C4.44,3.32,4.12,3,3.72,3S3,3.32,3,3.72V9c0,1.1,0.9,2,2,2v10h2V11c1.1,0,2-0.9,2-2V3.72 C9,3.32,8.68,3,8.28,3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,20h16V4H4V20z M14.75,6c1.38,0,2.5,1.53,2.5,3.41c0,1.48-0.7,2.71-1.67,3.18l-0.08,0.03V19H14v-6.38 l-0.08-0.04c-0.97-0.47-1.67-1.7-1.67-3.18C12.25,7.52,13.38,6,14.75,6z M6.5,6.5C6.5,6.22,6.72,6,7,6s0.5,0.22,0.5,0.5V9h0.75 V6.5c0-0.28,0.22-0.5,0.5-0.5s0.5,0.22,0.5,0.5V9H10V6.5C10,6.22,10.23,6,10.5,6C10.78,6,11,6.22,11,6.5v3.8 c0,0.93-0.64,1.71-1.5,1.93V19H8v-6.77c-0.86-0.22-1.5-1-1.5-1.93V6.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M20,20H4V4h16V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,12.23V19h1.5v-6.77c0.86-0.22,1.5-1,1.5-1.93V6.5C11,6.22,10.78,6,10.5,6C10.23,6,10,6.22,10,6.5V9H9.25V6.5 c0-0.28-0.22-0.5-0.5-0.5s-0.5,0.22-0.5,0.5V9H7.5V6.5C7.5,6.22,7.28,6,7,6S6.5,6.22,6.5,6.5v3.8C6.5,11.23,7.14,12.01,8,12.23z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.92,12.58L14,12.62V19h1.5v-6.38l0.08-0.03c0.97-0.47,1.67-1.7,1.67-3.18c0-1.88-1.12-3.41-2.5-3.41 c-1.37,0-2.5,1.52-2.5,3.4C12.25,10.88,12.95,12.11,13.92,12.58z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 table-restaurant
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "5.18,6 4.33,9 19.67,9 18.82,6",
      :opacity ".3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.96,9.73l-1.43-5C20.41,4.3,20.02,4,19.57,4H4.43C3.98,4,3.59,4.3,3.47,4.73l-1.43,5C1.86,10.36,2.34,11,3,11h2.2L4,20 h2l0.67-5h10.67L18,20h2l-1.2-9H21C21.66,11,22.14,10.36,21.96,9.73z M6.93,13l0.27-2h9.6l0.27,2H6.93z M4.33,9l0.86-3h13.63 l0.86,3H4.33z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 garage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:opacity ".3",
      :d
      "M17,11.51V11.5H7v0.01v2.99h10V11.51z M9,14c-0.55,0-1-0.45-1-1s0.45-1,1-1c0.55,0,1,0.45,1,1S9.55,14,9,14 z M15,14c-0.55,0-1-0.45-1-1s0.45-1,1-1c0.55,0,1,0.45,1,1S15.55,14,15,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:opacity ".3",
      :d
      "M4,20h16V4H4V20z M5,11.19C5.82,8.72,6.34,7.16,6.56,6.5c0.05-0.16,0.12-0.29,0.19-0.4 C6.77,6.08,6.78,6.06,6.8,6.04C7.18,5.51,7.72,5.5,7.72,5.5h8.56c0,0,0.54,0.01,0.92,0.53c0.02,0.03,0.03,0.05,0.05,0.07 c0.07,0.11,0.14,0.24,0.19,0.4c0.22,0.66,0.74,2.23,1.56,4.69v6.5c0,0.45-0.35,0.81-0.78,0.81h-0.44c-0.44,0-0.78-0.36-0.78-0.81 V16.5H7v1.19c0,0.45-0.35,0.81-0.78,0.81H5.78C5.35,18.5,5,18.14,5,17.69V11.19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M20,20H4V4h16V20z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M5.78