(ns
 toddler.material.sharp
 (:refer-clojure
  :exclude
  [merge
   map
   loop
   cast
   repeat
   shuffle
   sync
   remove
   sort
   send
   compare
   filter
   update
   print
   list
   commute
   class
   comment
   key])
 (:require [helix.core] [helix.dom]))


(helix.core/defnc
 agriculture
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.5,12c0.93,0,1.78,0.28,2.5,0.76V8c0-1.1-0.9-2-2-2h-6.29l-1.06-1.06l1.41-1.41l-0.71-0.71L9.82,6.35l0.71,0.71 l1.41-1.41L13,6.71V9c0,1.1-0.9,2-2,2h-0.54c0.95,1.06,1.54,2.46,1.54,4c0,0.34-0.04,0.67-0.09,1h3.14 C15.3,13.75,17.19,12,19.5,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.5,13c-1.93,0-3.5,1.57-3.5,3.5s1.57,3.5,3.5,3.5s3.5-1.57,3.5-3.5S21.43,13,19.5,13z M19.5,18 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S20.33,18,19.5,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4,9h5c0-1.1-0.9-2-2-2H4C3.45,7,3,7.45,3,8C3,8.55,3.45,9,4,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.83,13.82l-0.18-0.47L10.58,13c-0.46-1.06-1.28-1.91-2.31-2.43l-0.4,0.89l-0.46-0.21l0.4-0.9C7.26,10.13,6.64,10,6,10 c-0.53,0-1.04,0.11-1.52,0.26l0.34,0.91l-0.47,0.18L4,10.42c-1.06,0.46-1.91,1.28-2.43,2.31l0.89,0.4l-0.21,0.46l-0.9-0.4 C1.13,13.74,1,14.36,1,15c0,0.53,0.11,1.04,0.26,1.52l0.91-0.34l0.18,0.47L1.42,17c0.46,1.06,1.28,1.91,2.31,2.43l0.4-0.89 l0.46,0.21l-0.4,0.9C4.74,19.87,5.36,20,6,20c0.53,0,1.04-0.11,1.52-0.26l-0.34-0.91l0.47-0.18L8,19.58 c1.06-0.46,1.91-1.28,2.43-2.31l-0.89-0.4l0.21-0.46l0.9,0.4C10.87,16.26,11,15.64,11,15c0-0.53-0.11-1.04-0.26-1.52L9.83,13.82z M7.15,17.77c-1.53,0.63-3.29-0.09-3.92-1.62c-0.63-1.53,0.09-3.29,1.62-3.92c1.53-0.63,3.29,0.09,3.92,1.62 C9.41,15.38,8.68,17.14,7.15,17.77z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 diamond
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "12.16,3 11.84,3 9.21,8.25 14.79,8.25",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "16.46,8.25 21.62,8.25 19,3 13.84,3",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "21.38,9.75 12.75,9.75 12.75,20.1",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "11.25,20.1 11.25,9.75 2.62,9.75",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "7.54,8.25 10.16,3 5,3 2.38,8.25",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 local-library
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 11.55C9.64 9.35 6.48 8 3 8v11c3.48 0 6.64 1.35 9 3.55 2.36-2.19 5.52-3.55 9-3.55V8c-3.48 0-6.64 1.35-9 3.55zM12 8c1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3 1.34 3 3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 connecting-airports
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15.4,17l1.3,4.4h-1.1L13,17h-3c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h3l2.6-4.4h1.1L15.4,15h2.85L19,14h1l-0.6,2l0.6,2h-1 l-0.75-1H15.4z M5.75,7L5,6H4l0.6,2L4,10h1l0.75-1H8.6l-1.3,4.4h1.1L11,9h3c0.55,0,1-0.45,1-1s-0.45-1-1-1h-3L8.4,2.6H7.3L8.6,7 H5.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 traffic
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 10h-3V8.86c1.72-.45 3-2 3-3.86h-3V3H7v2H4c0 1.86 1.28 3.41 3 3.86V10H4c0 1.86 1.28 3.41 3 3.86V15H4c0 1.86 1.28 3.41 3 3.86V21h10v-2.14c1.72-.45 3-2 3-3.86h-3v-1.14c1.72-.45 3-2 3-3.86zm-8 9c-1.11 0-2-.9-2-2s.89-2 2-2c1.1 0 2 .9 2 2s-.89 2-2 2zm0-5c-1.11 0-2-.9-2-2s.89-2 2-2c1.1 0 2 .9 2 2s-.89 2-2 2zm0-5c-1.11 0-2-.9-2-2 0-1.11.89-2 2-2 1.1 0 2 .89 2 2 0 1.1-.89 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crisis-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14.5,2.5c0,1.06-0.75,3.64-1.19,5.04C13.13,8.11,12.6,8.5,12,8.5h0c-0.6,0-1.13-0.39-1.31-0.96 C10.25,6.14,9.5,3.56,9.5,2.5C9.5,1.12,10.62,0,12,0S14.5,1.12,14.5,2.5z M12,10c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2 S13.1,10,12,10z M16.08,5.11c0.18-0.75,0.33-1.47,0.39-2.06C19.75,4.69,22,8.08,22,12c0,5.52-4.48,10-10,10S2,17.52,2,12 c0-3.92,2.25-7.31,5.53-8.95C7.6,3.64,7.74,4.37,7.92,5.11C5.58,6.51,4,9.07,4,12c0,4.42,3.58,8,8,8s8-3.58,8-8 C20,9.07,18.42,6.51,16.08,5.11z M18,12c0,3.31-2.69,6-6,6s-6-2.69-6-6c0-2,0.98-3.77,2.48-4.86c0.23,0.81,0.65,2.07,0.65,2.07 C8.43,9.93,8,10.92,8,12c0,2.21,1.79,4,4,4s4-1.79,4-4c0-1.08-0.43-2.07-1.13-2.79c0,0,0.41-1.22,0.65-2.07C17.02,8.23,18,10,18,12 z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bakery-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "16.36,7.58 15.5,16.99 17,16.99 20.16,9.1",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "3.84,9.1 7,16.99 8.5,16.99 7.64,7.58",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "10,16.99 14,16.99 15,6 9,6", :stroke nil, :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "20.32,12.75 18.51,17.25 20.46,18.21 22.52,16.99",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "1.48,16.99 3.54,18.21 5.49,17.25 3.68,12.75",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 signpost
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2c-0.55,0-1,0.45-1,1v1H5.5C4.67,4,4,4.67,4,5.5v3C4,9.33,4.67,10,5.5,10H11v2H6.62c-0.4,0-0.78,0.16-1.06,0.44 l-1.5,1.5c-0.59,0.59-0.59,1.54,0,2.12l1.5,1.5C5.84,17.84,6.22,18,6.62,18H11v3c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1v-3h5.5 c0.83,0,1.5-0.67,1.5-1.5v-3c0-0.83-0.67-1.5-1.5-1.5H13v-2h4.38c0.4,0,0.78-0.16,1.06-0.44l1.5-1.5c0.59-0.59,0.59-1.54,0-2.12 l-1.5-1.5C18.16,4.16,17.78,4,17.38,4H13V3C13,2.45,12.55,2,12,2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 departure-board
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.34 1.13c-2.94-.55-5.63.75-7.12 2.92.01-.01.01-.02.02-.03C9.84 4 9.42 4 9 4c-4.42 0-8 .5-8 4v10c0 .88.39 1.67 1 2.22V23h3v-2h8v2h3v-2.78c.61-.55 1-1.34 1-2.22v-3.08c3.72-.54 6.5-3.98 5.92-7.97-.42-2.9-2.7-5.29-5.58-5.82zM4.5 19c-.83 0-1.5-.67-1.5-1.5S3.67 16 4.5 16s1.5.67 1.5 1.5S5.33 19 4.5 19zM3 13V8h6c0 1.96.81 3.73 2.11 5H3zm10.5 6c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm2.5-6c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm.5-9H15v5l3.62 2.16.75-1.23-2.87-1.68V4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 moped
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,10.35V5h-5v2h3v2.65L13.52,14H10V9H6c-2.21,0-4,1.79-4,4v3h2c0,1.66,1.34,3,3,3s3-1.34,3-3h4.48L19,10.35z M7,17 c-0.55,0-1-0.45-1-1h2C8,16.55,7.55,17,7,17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6", :x "5", :width "5", :height "2", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M19,13c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,13,19,13z M19,17c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S19.55,17,19,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 u-turn-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6,9v12h2V9c0-2.21,1.79-4,4-4s4,1.79,4,4v4.17l-1.59-1.59L13,13l4,4l4-4l-1.41-1.41L18,13.17V9c0-3.31-2.69-6-6-6 S6,5.69,6,9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 forest
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "16,12 9,2 2,12 3.86,12 0,18 7,18 7,22 11,22 11,18 18,18 14.14,12",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20.14,12 22,12 15,2 12.61,5.41 17.92,13 16,13 15.97,13 19.19,18 24,18",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "19",
      :x "13",
      :width "4",
      :height "3",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-walk
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.5 5.5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zM9.8 8.9L7 23h2.1l1.8-8 2.1 2v6h2v-7.5l-2.1-2 .6-3C14.8 12 16.8 13 19 13v-2c-1.9 0-3.5-1-4.3-2.4l-1-1.6c-.56-.89-1.68-1.25-2.65-.84L6 8.3V13h2V9.6l1.8-.7",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 miscellaneous-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.02,13.97l1.7-2.94c0,0-0.09-0.08-0.23-0.18l-1.47-1.16l-0.01,0.02c0.03-0.24,0.05-0.47,0.05-0.71S14.04,8.53,14,8.31 l0.01,0.01l1.71-1.34l-1.7-2.95l-2.01,0.81v0.01c-0.37-0.28-0.77-0.52-1.2-0.7h0.01L10.52,2H7.11L6.8,4.15h0.01 c-0.43,0.18-0.83,0.42-1.2,0.7V4.84L3.6,4.03L1.9,6.98l1.7,1.34l0.01-0.01C3.58,8.53,3.56,8.76,3.56,9s0.02,0.47,0.05,0.71 L3.6,9.69l-1.47,1.16C2,10.95,1.9,11.03,1.9,11.03l1.7,2.94l2.02-0.8L5.6,13.14c0.37,0.29,0.77,0.53,1.21,0.71H6.8L7.11,16h3.4 c0,0,0.02-0.13,0.04-0.3l0.27-1.85h-0.01c0.44-0.18,0.84-0.42,1.21-0.71L12,13.17L14.02,13.97z M8.81,11c-1.1,0-2-0.9-2-2 s0.9-2,2-2s2,0.9,2,2S9.91,11,8.81,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.98,17.94l-0.01,0.01C20.99,17.8,21,17.65,21,17.5c0-0.15-0.01-0.3-0.04-0.44l0.01,0.01l1.1-0.86l-1.09-1.9l-1.29,0.52 v0.01c-0.24-0.18-0.49-0.33-0.77-0.45h0.01L18.73,13h-2.19l-0.2,1.38h0.01c-0.28,0.12-0.53,0.27-0.77,0.45v-0.01l-1.29-0.52 l-1.09,1.9l1.09,0.86l0.01-0.01c-0.02,0.14-0.03,0.29-0.03,0.44c0,0.15,0.01,0.3,0.03,0.46l-0.01-0.01l-0.94,0.75 c-0.08,0.06-0.15,0.12-0.15,0.12l1.09,1.89l1.3-0.51l-0.01-0.02c0.24,0.19,0.5,0.34,0.78,0.46h-0.01l0.2,1.38h2.19 c0,0,0.01-0.08,0.03-0.19l0.17-1.19h-0.01c0.28-0.12,0.54-0.27,0.78-0.46l-0.01,0.02l1.3,0.51l1.09-1.89c0,0-0.06-0.05-0.15-0.12 L20.98,17.94z M17.63,18.79c-0.71,0-1.29-0.58-1.29-1.29s0.58-1.29,1.29-1.29s1.29,0.58,1.29,1.29S18.34,18.79,17.63,18.79z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 wrong-location
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,10V3.26C13.35,3.09,12.68,3,12,3c-4.2,0-8,3.22-8,8.2c0,3.32,2.67,7.25,8,11.8c5.33-4.55,8-8.48,8-11.8 c0-0.41-0.04-0.81-0.09-1.2H14z M12,13c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2s2,0.9,2,2C14,12.1,13.1,13,12,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "22.54,2.88 21.12,1.46 19,3.59 16.88,1.46 15.46,2.88 17.59,5 15.46,7.12 16.88,8.54 19,6.41 21.12,8.54 22.54,7.12 20.41,5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-road
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "20,18 20,15 18,15 18,18 15,18 15,20 18,20 18,23 20,23 20,20 23,20 23,18",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "18",
      :width "2",
      :height "9",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "4",
      :width "2",
      :height "16",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "16",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 not-listed-location
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.01 16a.99.99 0 001-1 .99.99 0 00-1-1c-.28 0-.51.1-.71.29-.2.19-.3.43-.3.7s.1.51.29.71c.2.2.44.3.72.3zm-.88-3.66V13h1.85v-.42c0-.33.06-.6.18-.81.12-.21.33-.47.65-.77.4-.38.68-.75.89-1.09.19-.35.3-.76.3-1.25s-.13-.94-.39-1.35a2.57 2.57 0 00-1.05-.96C13.11 6.12 12.58 6 12 6c-.78 0-1.51.32-2.03.79C9.46 7.27 9 7.99 9 9h1.68c0-.52.19-.77.4-.98.21-.2.58-.3.96-.3.35 0 .64.1.85.3.21.2.32.45.32.74 0 .24-.06.46-.19.64-.13.19-.33.41-.61.66-.48.42-.81.79-1 1.12-.19.33-.28.71-.28 1.16zM12 2c4.2 0 8 3.22 8 8.2 0 3.32-2.67 7.25-8 11.8-5.33-4.55-8-8.48-8-11.8C4 5.22 7.8 2 12 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 attractions
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10.44,18.75c0.37-0.46,0.94-0.75,1.57-0.75s1.19,0.29,1.56,0.75c0.39-0.09,0.76-0.21,1.12-0.36l-1.42-3.18 c-0.39,0.15-0.82,0.23-1.26,0.23c-0.46,0-0.9-0.09-1.3-0.25l-1.43,3.19C9.65,18.54,10.03,18.67,10.44,18.75z M5.16,10 C5,10.59,4.91,11.21,4.91,11.85c0,0.75,0.12,1.47,0.33,2.15c0.63,0.05,1.22,0.4,1.56,0.99c0.33,0.57,0.35,1.23,0.11,1.79 c0.27,0.27,0.56,0.53,0.87,0.76l1.52-3.39l0,0c-0.47-0.58-0.75-1.32-0.75-2.13c0-1.89,1.55-3.41,3.46-3.41s3.46,1.53,3.46,3.41 c0,0.82-0.29,1.57-0.78,2.16l1.5,3.35c0.32-0.24,0.62-0.5,0.9-0.79c-0.22-0.55-0.2-1.2,0.12-1.75c0.33-0.57,0.9-0.92,1.52-0.99 c0.22-0.68,0.34-1.41,0.34-2.16c0-0.64-0.09-1.27-0.25-1.86c-0.64-0.04-1.26-0.39-1.6-1c-0.36-0.62-0.35-1.36-0.03-1.95 c-0.91-0.98-2.1-1.71-3.44-2.05C13.4,5.6,12.74,6,12.01,6s-1.39-0.41-1.74-1.01C8.93,5.33,7.74,6.04,6.83,7.02 C7.16,7.62,7.18,8.37,6.81,9C6.45,9.62,5.82,9.97,5.16,10z M3.86,9.58C3.08,8.98,2.84,7.88,3.35,7s1.58-1.23,2.49-0.85 c1.11-1.17,2.56-2.03,4.18-2.42C10.15,2.75,10.99,2,12.01,2s1.85,0.75,1.98,1.73c1.63,0.39,3.07,1.24,4.18,2.42 c0.91-0.38,1.99-0.03,2.49,0.85c0.51,0.88,0.27,1.98-0.51,2.58c0.23,0.77,0.35,1.58,0.35,2.42s-0.12,1.65-0.35,2.42 c0.78,0.6,1.02,1.7,0.51,2.58s-1.58,1.23-2.49,0.85c-0.4,0.43-0.85,0.81-1.34,1.15l1.34,3h-1.86l-0.97-2.17 c-0.43,0.18-0.88,0.33-1.34,0.44C13.86,21.25,13.02,22,12.01,22s-1.85-0.75-1.98-1.73C9.55,20.15,9.09,20,8.65,19.81L7.66,22H5.79 l1.36-3.03c-0.47-0.33-0.91-0.71-1.3-1.12c-0.92,0.38-1.99,0.03-2.5-0.85s-0.27-1.98,0.51-2.58C3.62,13.65,3.51,12.84,3.51,12 S3.62,10.35,3.86,9.58z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 brunch-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,8h2V4h-2V8z M16,22H2v-2h14V22z M18,15.89l-0.4-0.42c-1.02-1.08-1.6-2.52-1.6-4V2h6v9.51c0,1.46-0.54,2.87-1.53,3.94 L20,15.97V20h2v2h-4V15.89z M7,16v-2h4v2h5v2H2v-2H7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 handyman
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M16.37,12.87h-0.99l-2.54,2.54v0.99l6.01,6.01l3.54-3.54L16.37,12.87z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M17.34,10.19l1.41-1.41l2.12,2.12c1.17-1.17,1.17-3.07,0-4.24l-3.54-3.54l-1.41,1.41V1.71L15.22,1l-3.54,3.54l0.71,0.71 h2.83l-1.41,1.41l1.06,1.06l-2.89,2.89L7.85,6.48V5.06L4.83,2.04L2,4.87l3.03,3.03h1.41l4.13,4.13l-0.85,0.85H7.6l-6.01,6.01 l3.54,3.54l6.01-6.01v-2.12l5.15-5.15L17.34,10.19z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 two-wheeler
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0",
     :x "0",
     :width "24",
     :height "24",
     :fill-rule "evenodd",
     :fill "none",
     :stroke nil})
   (helix.dom/path
    {:d
     "M4.17,11L4.17,11C4.12,11,4.06,11,4,11H4.17 M13.41,5H9v2h3.59l2,2H11l-4,2L5,9H0v2h4c-2.21,0-4,1.79-4,4 c0,2.21,1.79,4,4,4c2.21,0,4-1.79,4-4l2,2h3l3.49-6.1l1.01,1.01C16.59,12.64,16,13.75,16,15c0,2.21,1.79,4,4,4c2.21,0,4-1.79,4-4 c0-2.21-1.79-4-4-4c-0.18,0-0.36,0.03-0.53,0.05L17.41,9H20V6l-3.72,1.86L13.41,5L13.41,5z M20,17c-1.1,0-2-0.9-2-2 c0-1.1,0.9-2,2-2c1.1,0,2,0.9,2,2C22,16.1,21.1,17,20,17L20,17z M4,17c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2c1.1,0,2,0.9,2,2 C6,16.1,5.1,17,4,17L4,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 add-location
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13,6h-2v3H8v2h3v3h2v-3h3V9h-3V6z M12,2c4.2,0,8,3.22,8,8.2c0,3.32-2.67,7.25-8,11.8 c-5.33-4.55-8-8.48-8-11.8C4,5.22,7.8,2,12,2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-scooter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M7.82,16H15v-1c0-2.21,1.79-4,4-4h0.74L17.49,1H12v2h3.89l1.4,6.25c0,0-0.01,0-0.01,0c-2.16,0.65-3.81,2.48-4.19,4.75 H7.82c-0.48-1.34-1.86-2.24-3.42-1.94c-1.18,0.23-2.13,1.2-2.35,2.38C1.7,16.34,3.16,18,5,18C6.3,18,7.4,17.16,7.82,16z M5,16 c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S5.55,16,5,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,12c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,12,19,12z M19,16c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S19.55,16,19,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,20 7,20 13,23 13,21 17,21 11,18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 turn-sharp-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "6,6.83 4.41,8.41 3,7 7,3 11,7 9.59,8.41 8,6.83 8,13 18,13 18,21 16,21 16,15 6,15",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-printshop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 8v9h4v4h12v-4h4V8H2zm14 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 restaurant
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 6v8h3v8h2V2c-2.76 0-5 2.24-5 4zm-5 3H9V2H7v7H5V2H3v7c0 2.21 1.79 4 4 4v9h2v-9c2.21 0 4-1.79 4-4V2h-2v7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cleaning-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M15,11V1H9v10H3v12h18V11H15z M19,21h-2v-4h-2v4h-2v-4h-2v4H9v-4H7v4H5v-8h14V21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 tire-repair
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,7c0,0.55,0.45,1,1,1c0.28,0,0.53-0.11,0.71-0.29c0.4-0.4,1.04-2.46,1.04-2.46s-2.06,0.64-2.46,1.04 C18.11,6.47,18,6.72,18,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,2c-2.76,0-5,2.24-5,5c0,2.05,1.23,3.81,3,4.58V13h1v6h-2v-6h-4V5c0-1.1-0.9-2-2-2H4C2.9,3,2,3.9,2,5v14 c0,1.1,0.9,2,2,2h6c1.1,0,2-0.9,2-2v-4h2v6h6v-8h1v-1.42c1.77-0.77,3-2.53,3-4.58C24,4.24,21.76,2,19,2z M6,19.5l-2-2v-2.83l2,2 V19.5z M6,14.5l-2-2V9.67l2,2V14.5z M6,9.5l-2-2V4.67l2,2V9.5z M10,17.5l-2,2v-2.83l2-2V17.5z M10,12.5l-2,2v-2.83l2-2V12.5z M10,7.5l-2,2V6.67l2-2V7.5z M19,10c-1.66,0-3-1.34-3-3s1.34-3,3-3s3,1.34,3,3S20.66,10,19,10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 fastfood
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 5V1h-2v4h-5l.23 2.31C14.9 8.16 18 10.77 18 15l.02 8h3.18L23 5h-5zM1 21h15v2H1zM8.5 8.99C4.75 8.99 1 11 1 15h15c0-4-3.75-6.01-7.5-6.01zM1 17h15v2H1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-laundry-service
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.17 16.83c1.56 1.56 4.1 1.56 5.66 0s1.56-4.1 0-5.66l-5.66 5.66zM20 2.01L4 2v20h16V2.01zM10 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM7 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm5 16c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 medical-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16,6V2H8v4H2v16h20V6H16z M10,4h4v2h-4V4z M16,15h-3v3h-2v-3H8v-2h3v-3h2v3h3V15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22.41 12 12 1.59 1.59 11.99 12 22.41 22.41 12zM14 14.5V12h-4v3H8v-5h6V7.5l3.5 3.5-3.5 3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-car-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.57,5H5.43L3,12v9h3v-2h12v2h3v-9L18.57,5z M7.5,16C6.67,16,6,15.33,6,14.5S6.67,13,7.5,13S9,13.67,9,14.5 S8.33,16,7.5,16z M16.5,16c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S17.33,16,16.5,16z M5.81,10l1.04-3h10.29 l1.04,3H5.81z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 edit-location
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.11 1.77L19.78.1l2.12 2.12-1.67 1.67-2.12-2.12zm-1 1l2.12 2.12L13.12 11H11V8.89l6.11-6.12zm-1.98-.13L9.5 8.27v4.24h4.24l5.62-5.62c.41.99.64 2.1.64 3.32 0 3.32-2.67 7.25-8 11.8-5.33-4.55-8-8.48-8-11.8 0-4.98 3.8-8.2 8-8.2 1.09 0 2.16.22 3.13.63z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 roundabout-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,13c2.21,0,4-1.79,4-4s-1.79-4-4-4c-2.21,0-4,1.79-4,4l0,1l-6.17,0l1.59,1.59L6,13L2,9l4-4l1.41,1.41L5.83,8l4.25,0 c0.48-2.84,2.94-5,5.92-5c3.31,0,6,2.69,6,6c0,2.97-2.16,5.44-5,5.92L17,21h-2l0-8L16,13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-shipping
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 8h-3V4H1v13h2c0 1.66 1.34 3 3 3s3-1.34 3-3h6c0 1.66 1.34 3 3 3s3-1.34 3-3h2v-5l-3-4zM6 18c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm13.5-8.5l1.96 2.5H17V9.5h2.5zM18 18c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-railway-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:enable-background "new",
     :d
     "M12,2C8,2,4,2.5,4,6v9.5C4,17.43,5.57,19,7.5,19L6,20v1h12v-1l-1.5-1c1.93,0,3.5-1.57,3.5-3.5 V6C20,2.5,16.42,2,12,2z M12,16c-0.83,0-1.5-0.67-1.5-1.5S11.17,13,12,13s1.5,0.67,1.5,1.5S12.83,16,12,16z M18,10H6V7h12V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 egg
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,3C8.5,3,5,9.33,5,14c0,3.87,3.13,7,7,7s7-3.13,7-7C19,9.33,15.5,3,12,3z M13,18c-3,0-5-1.99-5-5c0-0.55,0-1,0-1h2 c0,0,0,1,0,1c0,2.92,2.42,3,3,3c0.55,0,1,0,1,0l0,2C14,18,13.55,18,13,18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 turn-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "17.17,11 15.59,12.59 17,14 21,10 17,6 15.59,7.41 17.17,9 7,9 7,20 9,20 9,11",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 remove-road
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "4",
      :x "18",
      :width "2",
      :height "9",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "4",
      :width "2",
      :height "16",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "16",
      :x "11",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "22.5,16.41 21.09,15 19,17.09 16.91,15 15.5,16.41 17.59,18.5 15.5,20.59 16.91,22 19,19.91 21.09,22 22.5,20.59 20.41,18.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-business
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M15,17h2v-3h1v-2l-1-5H2l-1,5v2h1v6h9v-6h4V17z M9,18H4v-4h5V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "2",
      :width "15",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20,18 20,15 18,15 18,18 15,18 15,20 18,20 18,23 20,23 20,20 23,20 23,18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-bike
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,7h-0.82L16,1h-4v2h2.6l1.46,4h-4.81l-0.36-1H12V4H7v2h1.75l1.82,5H9.9C9.46,8.77,7.59,7.12,5.25,7.01 C2.45,6.87,0,9.2,0,12c0,2.8,2.2,5,5,5c2.46,0,4.45-1.69,4.9-4h4.2c0.44,2.23,2.31,3.88,4.65,3.99c2.8,0.13,5.25-2.19,5.25-5 C24,9.2,21.8,7,19,7z M7.82,13c-0.4,1.17-1.49,2-2.82,2c-1.68,0-3-1.32-3-3s1.32-3,3-3c1.33,0,2.42,0.83,2.82,2H5v2H7.82z M14.1,11h-1.4l-0.73-2H15C14.56,9.58,14.24,10.25,14.1,11z M19,15c-1.68,0-3-1.32-3-3c0-0.93,0.41-1.73,1.05-2.28l0.96,2.64 l1.88-0.68l-0.97-2.67C18.94,9.01,18.97,9,19,9c1.68,0,3,1.32,3,3S20.68,15,19,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,20 7,20 13,23 13,21 17,21 11,18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 hardware
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/path
       {:d "M18,3l-3,3V3H9C6.24,3,4,5.24,4,8h5v3h6V8l3,3h2V3H18z",
        :stroke nil,
        :fill nil}))
     (helix.dom/g
      nil
      (helix.dom/path
       {:d "M9,13v8h6v-8H9z", :stroke nil, :fill nil})))))))


(helix.core/defnc
 car-crash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18.5,7h-1V3h1V7z M18.5,8v1h-1V8H18.5z M17.91,13 c0.06,0.16,0.09,0.33,0.09,0.5c0,0.83-0.67,1.5-1.5,1.5S15,14.33,15,13.5c0-0.39,0.15-0.74,0.39-1.01 c-1.63-0.66-2.96-1.91-3.71-3.49H5.81l1.04-3H11c0-0.69,0.1-1.37,0.29-2H5.41L3,11v9h3v-2h12v2h3v-7.68 C19.95,12.83,18.84,13.01,17.91,13z M7.5,15C6.67,15,6,14.33,6,13.5S6.67,12,7.5,12S9,12.67,9,13.5S8.33,15,7.5,15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 transfer-within-a-station
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.49 15.5v-1.75L14 16.25l2.49 2.5V17H22v-1.5h-5.51zm3.02 4.25H14v1.5h5.51V23L22 20.5 19.51 18v1.75zM9.5 5.5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zM5.75 8.9L3 23h2.1l1.75-8L9 17v6h2v-7.55L8.95 13.4l.6-3C10.85 12 12.8 13 15 13v-2c-1.85 0-3.45-1-4.35-2.45l-.95-1.6C9.35 6.35 8.7 6 8 6c-.25 0-.5.05-.75.15L2 8.3V13h2V9.65l1.75-.75",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-grocery-store
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 18c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zM1 4h2l3.6 7.59L3.62 17H19v-2H7l1.1-2h8.64l4.97-9H5.21l-.94-2H1v2zm16 14c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-transfer
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M5.78,2.95C7.24,2.16,9.48,2,12,2c4.42,0,8,0.5,8,4v10c0,0.35-0.08,0.67-0.19,0.98L13.83,11H18V6H8.83L5.78,2.95z M19.78,22.61L18.17,21H16v-2H8v2H5v-2.78C4.39,17.67,4,16.88,4,16V6.83L1.39,4.22l1.41-1.41l18.38,18.38L19.78,22.61z M9,15.5 C9,14.67,8.33,14,7.5,14S6,14.67,6,15.5C6,16.33,6.67,17,7.5,17S9,16.33,9,15.5z M8.17,11L6,8.83V11H8.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-activity
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 12c0-1.1.9-2 2-2V4H2.01v6c1.1 0 1.99.9 1.99 2s-.89 2-2 2v6h20v-6c-1.1 0-2-.9-2-2zm-4.42 4.8L12 14.5l-3.58 2.3 1.08-4.12-3.29-2.69 4.24-.25L12 5.8l1.54 3.95 4.24.25-3.29 2.69 1.09 4.11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flight-class
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18,4h-6v9h6V4z M9.5,16H18v2H8L5,8V4h2v4L9.5,16z M8,19h10v2H8V19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-phone
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 15.46l-5.27-.61-2.52 2.52c-2.83-1.44-5.15-3.75-6.59-6.59l2.53-2.53L8.54 3H3.03C2.45 13.18 10.82 21.55 21 20.97v-5.51z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 design-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.79,17.06l-5.55-5.55l1.57-1.57l-3.75-3.75l-1.57,1.57L6.94,2.21L2.21,6.94l5.55,5.55L3,17.25V21h3.75l4.76-4.76 l5.55,5.55l0,0v0L21.79,17.06z M9.18,11.07L5.04,6.94l1.9-1.9l1.27,1.27L7.02,7.5l1.41,1.41l1.19-1.19l1.45,1.45L9.18,11.07z M12.93,14.82l1.9-1.9l1.45,1.45l-1.19,1.19l1.41,1.41l1.19-1.19l1.27,1.27l-1.9,1.9L12.93,14.82z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "3.08",
      :x "16.48",
      :width "3.59",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 1.302 14.5981)",
      :height "5.3",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 layers
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.99 18.54l-7.37-5.73L3 14.07l9 7 9-7-1.63-1.27-7.38 5.74zM12 16l7.36-5.73L21 9l-9-7-9 7 1.63 1.27L12 16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wine-bar
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6,3l0,6c0,2.97,2.16,5.43,5,5.91V19H8v2h8v-2h-3v-4.09c2.84-0.48,5-2.94,5-5.91l0-6H6z M16,8H8l0-3h8C16,5,16,8,16,8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-crash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.57,8H5.43L3,15v9h3v-2h12v2h3v-9L18.57,8z M6.85,10h10.29l1.04,3H5.81L6.85,10z M6,17.5C6,16.67,6.67,16,7.5,16 S9,16.67,9,17.5S8.33,19,7.5,19S6,18.33,6,17.5z M15,17.5c0-0.83,0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S17.33,19,16.5,19 S15,18.33,15,17.5z M12,6.36L9.17,3.54l1.41-1.41L12,3.54L15.54,0l1.41,1.41L12,6.36z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 route
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,15.18V3h-8v16H7V8.82C8.16,8.4,9,7.3,9,6c0-1.66-1.34-3-3-3S3,4.34,3,6c0,1.3,0.84,2.4,2,2.82V21h8V5h4v10.18 c-1.16,0.41-2,1.51-2,2.82c0,1.66,1.34,3,3,3s3-1.34,3-3C21,16.7,20.16,15.6,19,15.18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-boat-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,21c-1.39,0-2.78-0.47-4-1.32c-2.44,1.71-5.56,1.71-8,0C6.78,20.53,5.39,21,4,21H2v2h2c1.38,0,2.74-0.35,4-0.99 c2.52,1.29,5.48,1.29,8,0c1.26,0.65,2.62,0.99,4,0.99h2v-2H20z M3.95,19H4c1.6,0,3.02-0.88,4-2c0.98,1.12,2.4,2,4,2s3.02-0.88,4-2 c0.98,1.12,2.4,2,4,2h0.05l2.18-7.65L20,10.62V4h-5V1H9v3H4v6.62l-2.23,0.73L3.95,19z M6,6h12v3.97L12,8L6,9.97V6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 category
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M12 2l-5.5 9h11z", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "4.5", :cy "17.5", :cx "17.5", :stroke nil, :fill nil})
  (helix.dom/path {:d "M3 13.5h8v8H3z", :stroke nil, :fill nil})))


(helix.core/defnc
 store-mall-directory
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 4H4v2h16V4zm1 10v-2l-1-5H4l-1 5v2h1v6h10v-6h4v6h2v-6h1zm-9 4H6v-4h6v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fork-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9.41,15.59L8,17l-4-4l4-4l1.41,1.41L7.83,12c1.51-0.33,3.73,0.08,5.17,1.36l0-6.53l-1.59,1.59L10,7l4-4l4,4l-1.41,1.41 L15,6.83V21l-2,0v-4c-0.73-2.58-3.07-3.47-5.17-3L9.41,15.59z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 turn-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "6.83,11 8.41,12.59 7,14 3,10 7,6 8.41,7.41 6.83,9 17,9 17,20 15,20 15,11",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 car-rental
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10.83,3C10.41,1.83,9.3,1,8,1C6.34,1,5,2.34,5,4c0,1.65,1.34,3,3,3c1.3,0,2.41-0.84,2.83-2H16v2h2V5h1V3H10.83z M8,5 C7.45,5,7,4.55,7,4s0.45-1,1-1s1,0.45,1,1S8.55,5,8,5z M17.11,9H6.89L5,14.69V22h2v-2h10v2h2v-7.31L17.11,9z M9,17.5 c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S9.55,17.5,9,17.5z M15,17.5c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S15.55,17.5,15,17.5z M7.67,13l0.66-2h7.34l0.66,2H7.67z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 hotel
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 13c1.66 0 3-1.34 3-3S8.66 7 7 7s-3 1.34-3 3 1.34 3 3 3zm16-6H11v7H3V5H1v15h2v-3h18v3h2V7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 emergency-share
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,9c-3.15,0-6,2.41-6,6.15c0,2.49,2,5.44,6,8.85c4-3.41,6-6.36,6-8.85C18,11.41,15.15,9,12,9z M12,16.5 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S12.83,16.5,12,16.5z M12,4c1.93,0,3.68,0.78,4.95,2.05l-1.41,1.41 C14.63,6.56,13.38,6,12,6S9.37,6.56,8.46,7.46L7.05,6.05C8.32,4.78,10.07,4,12,4z M19.78,3.23l-1.41,1.41 C16.74,3.01,14.49,2,12.01,2S7.27,3.01,5.64,4.63L4.22,3.22C6.22,1.23,8.97,0,12.01,0S17.79,1.23,19.78,3.23z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 dinner-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "2,19 4,21 20,21 22,19", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M3,18l16.97,0c0,0,0,0,0,0c0.29-3.26-2.28-6-5.48-6c-2.35,0-4.35,1.48-5.14,3.55C8.94,15.32,8.48,15.17,8,15.08V9h4V6.75 h9v-1.5h-9V3H3v1.5h1v0.75H3v1.5h1V7.5H3V9h1v7.39C3.56,16.85,3.22,17.39,3,18z M8,7.5V6.75h2V7.5H8z M10,5.25H8V4.5h2V5.25z M5.5,4.5h1v0.75h-1V4.5z M5.5,6.75h1V7.5h-1V6.75z M6.5,9v6.06c-0.35,0.06-0.68,0.17-1,0.3V9H6.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 lunch-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "16",
      :x "2",
      :width "20",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.66,11.5c-1.95,0-2.09,1-3.33,1c-1.19,0-1.42-1-3.33-1c-1.95,0-2.09,1-3.33,1c-1.19,0-1.42-1-3.33-1 c-1.95,0-2.09,1-3.33,1v2c1.9,0,2.17-1,3.35-1c1.19,0,1.42,1,3.33,1c1.95,0,2.09-1,3.33-1c1.19,0,1.42,1,3.33,1 c1.95,0,2.09-1,3.33-1c1.19,0,1.4,0.98,3.32,1l-0.01-1.98C20.38,12.19,20.37,11.5,18.66,11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M22,9c0.02-4-4.28-6-10-6C6.29,3,2,5,2,9v1h20L22,9L22,9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 turn-slight-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "11.66,6 11.66,4 6,4 6,9.66 8,9.66 8,7.41 13,12.41 13,20 15,20 15,11.59 9.41,6",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 merge
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6.41,21L5,19.59l4.83-4.83c0.75-0.75,1.17-1.77,1.17-2.83v-5.1L9.41,8.41L8,7l4-4l4,4l-1.41,1.41L13,6.83v5.1 c0,1.06,0.42,2.08,1.17,2.83L19,19.59L17.59,21L12,15.41L6.41,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 roundabout-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,13c-2.21,0-4-1.79-4-4c0-2.21,1.79-4,4-4c2.21,0,4,1.79,4,4l0,1l6.17,0l-1.59,1.59L18,13l4-4l-4-4l-1.41,1.41L18.17,8 l-4.25,0C13.44,5.16,10.97,3,8,3C4.69,3,2,5.69,2,9c0,2.97,2.16,5.44,5,5.92L7,21h2l0-8L8,13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 ramen-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,3.51V2L4,3.99V12H2c0,3.69,2.47,6.86,6,8.25V22h8v-1.75c3.53-1.39,6-4.56,6-8.25H10.5V8H22V6.5H10.5V4.78L22,3.51z M6.5,5.22V6.5h-1V5.34L6.5,5.22z M5.5,8h1v4h-1V8z M9,12H8V8h1V12z M9,6.5H8V5.06l1-0.11V6.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 edit-location-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13.95,13H9V8.05l5.61-5.61C13.78,2.16,12.9,2,12,2c-4.2,0-8,3.22-8,8.2c0,3.32,2.67,7.25,8,11.8c5.33-4.55,8-8.48,8-11.8 c0-1.01-0.16-1.94-0.45-2.8L13.95,13z M11,11h2.12l6.16-6.16l-2.12-2.12L11,8.88V11z M19.29,0.59l-1.42,1.42l2.12,2.12l1.42-1.42 L19.29,0.59z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 taxi-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,13c-1.91,0-3.63-0.76-4.89-2H4.81l1.04-3h5.44C11.1,7.37,11,6.7,11,6s0.1-1.37,0.29-2H8v2H4.43L2,13v9h3v-2h12v2h3 v-9l-0.09-0.27C19.3,12.9,18.66,13,18,13z M6.5,17C5.67,17,5,16.33,5,15.5S5.67,14,6.5,14S8,14.67,8,15.5S7.33,17,6.5,17z M15.5,17c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S16.33,17,15.5,17z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18.5,9h-1V8h1V9z M18.5,7h-1V3h1V7z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 soup-kitchen
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.4,7C6.06,7.55,6,7.97,6,8.38C6,9.15,7,11,7,12c0,0.95-0.4,1.5-0.4,1.5H5.1c0,0,0.4-0.55,0.4-1.5c0-1-1-2.85-1-3.62 C4.5,7.97,4.56,7.55,4.9,7H6.4z M11.4,7C11.06,7.55,11,7.97,11,8.38C11,9.15,12,11,12,12c0,0.95-0.4,1.5-0.4,1.5h1.5 c0,0,0.4-0.55,0.4-1.5c0-1-1-2.85-1-3.62c0-0.41,0.06-0.83,0.4-1.38H11.4z M8.15,7c-0.34,0.55-0.4,0.97-0.4,1.38 c0,0.77,1,2.63,1,3.62c0,0.95-0.4,1.5-0.4,1.5h1.5c0,0,0.4-0.55,0.4-1.5c0-1-1-2.85-1-3.62c0-0.41,0.06-0.83,0.4-1.38H8.15z M21.47,6.5c0,0,0.13-1.06,0.13-1.5c0-1.65-1.35-3-3-3c-1.54,0-2.81,1.16-2.98,2.65L14.53,15l-11.6,0c-0.02,3.87,3.09,7,6.82,7 c3.48,0,6.34-2.73,6.71-6.23l1.15-10.87C17.66,4.39,18.08,4,18.6,4c0.55,0,1,0.45,1,1c0,0.3-0.1,1.25-0.1,1.25L21.47,6.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-pizza
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C8.43 2 5.23 3.54 3.01 6L12 22l8.99-16C18.78 3.55 15.57 2 12 2zM7 7c0-1.1.9-2 2-2s2 .9 2 2-.9 2-2 2-2-.9-2-2zm5 8c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 bike-scooter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10,14h0.74L8.47,4H3v2h3.87l1.42,6.25c0,0-0.01,0-0.01,0C6.12,12.9,4.47,14.73,4.09,17H0v2h6v-1C6,15.79,7.79,14,10,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.18,8l-1.83-5H11v2h3.96l1.1,3H10.4l0.46,2H15c-0.43,0.58-0.75,1.25-0.9,2h-2.79l0.46,2h2.33 c0.44,2.23,2.31,3.88,4.65,3.99c2.8,0.13,5.25-2.19,5.25-5c0-2.8-2.2-5-5-5H18.18z M19,16c-1.68,0-3-1.32-3-3 c0-0.93,0.41-1.73,1.05-2.28l0.96,2.64l1.88-0.68l-0.97-2.67c0.03,0,0.06-0.01,0.09-0.01c1.68,0,3,1.32,3,3S20.68,16,19,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,15c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S11.66,15,10,15z M10,19c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S10.55,19,10,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 atm
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8 9v1.5h2.25V15h1.5v-4.5H14V9H8zM7 9H2v6h1.5v-1.5h2V15H7V9zm-1.5 3h-2v-1.5h2V12zM22 9h-6.5v6H17v-4.5h1V14h1.5v-3.51h1V15H22V9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 set-meal
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21.05,17.56L3.08,18.5L3,17l17.98-0.94L21.05,17.56z M21,19.48H3v1.5h18V19.48z M22,3v11H2V3H22z M20,6 c-1.68,0-3.04,0.98-3.21,2.23C16.15,7.5,14.06,5.5,10.25,5.5c-4.67,0-6.75,3-6.75,3s2.08,3,6.75,3c3.81,0,5.9-2,6.54-2.73 C16.96,10.02,18.32,11,20,11V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 takeout-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "22,7.46 20.59,6.05 19,7.63 19.03,7.07 14.98,3 9.02,3 4.97,7.07 5,7.57 3.41,6.01 2,7.44 4.66,10 19.35,10",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "5.93,20 18.07,20 18.7,11.55 5.3,11.55",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 screen-rotation-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M4,7.59l6.41-6.41L20.24,11h-2.83L10.4,4L5.41,9H8v2H2V5h2V7.59z M20,19h2v-6h-6v2h2.59l-4.99,5l-7.01-7H3.76l9.83,9.83 L20,16.41V19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 minor-crash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.57,8H5.43L3,15v9h3v-2h12v2h3v-9L18.57,8z M6.85,10h10.29l1.04,3H5.81L6.85,10z M6,17.5C6,16.67,6.67,16,7.5,16 S9,16.67,9,17.5S8.33,19,7.5,19S6,18.33,6,17.5z M15,17.5c0-0.83,0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S17.33,19,16.5,19 S15,18.33,15,17.5z M9.41,5L8,6.41l-3-3L6.41,2L9.41,5z M16,6.41L14.59,5l3-3L19,3.41L16,6.41z M13,5h-2V0h2V5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 maps-ugc
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0",
    :width "24",
    :height "24",
    :fill-rule "evenodd",
    :fill "none",
    :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,4c4.41,0,8,3.59,8,8s-3.59,8-8,8c-1.18,0-2.34-0.26-3.43-0.78c-0.27-0.13-0.56-0.19-0.86-0.19 c-0.19,0-0.38,0.03-0.56,0.08l-3.2,0.94l0.94-3.2c0.14-0.47,0.1-0.98-0.11-1.42C4.26,14.34,4,13.18,4,12C4,7.59,7.59,4,12,4 M12,2 C6.48,2,2,6.48,2,12c0,1.54,0.36,2.98,0.97,4.29L1,23l6.71-1.97C9.02,21.64,10.46,22,12,22c5.52,0,10-4.48,10-10 C22,6.48,17.52,2,12,2L12,2z",
     :stroke nil,
     :fill nil}))
  (helix.dom/polygon
   {:points
    "13,8 11,8 11,11 8,11 8,13 11,13 11,16 13,16 13,13 16,13 16,11 13,11",
    :fill-rule "evenodd",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 park
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points
       "17,12 19,12 12,2 5.05,12 7,12 3.1,18 10.02,18 10.02,22 13.98,22 13.98,18 21,18",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 pest-control
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,15v-2h-3.07c-0.05-0.39-0.12-0.77-0.22-1.14l2.58-1.49l-1-1.73L16.92,10c-0.28-0.48-0.62-0.91-0.99-1.29 C15.97,8.48,16,8.25,16,8c0-0.8-0.24-1.55-0.65-2.18L17,4.17l-1.41-1.41l-1.72,1.72c-1.68-0.89-3.1-0.33-3.73,0L8.41,2.76L7,4.17 l1.65,1.65C8.24,6.45,8,7.2,8,8c0,0.25,0.03,0.48,0.07,0.72C7.7,9.1,7.36,9.53,7.08,10L4.71,8.63l-1,1.73l2.58,1.49 c-0.1,0.37-0.17,0.75-0.22,1.14H3v2h3.07c0.05,0.39,0.12,0.77,0.22,1.14l-2.58,1.49l1,1.73L7.08,18c1.08,1.81,2.88,3,4.92,3 s3.84-1.19,4.92-3l2.37,1.37l1-1.73l-2.58-1.49c0.1-0.37,0.17-0.75,0.22-1.14H21z M13,17h-2v-6h2V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-boat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 21c-1.39 0-2.78-.47-4-1.32-2.44 1.71-5.56 1.71-8 0C6.78 20.53 5.39 21 4 21H2v2h2c1.38 0 2.74-.35 4-.99 2.52 1.29 5.48 1.29 8 0 1.26.65 2.62.99 4 .99h2v-2h-2zM3.95 19H4c1.6 0 3.02-.88 4-2 .98 1.12 2.4 2 4 2s3.02-.88 4-2c.98 1.12 2.4 2 4 2h.05l2.18-7.65-2.23-.73V4h-5V1H9v3H4v6.62l-2.23.73L3.95 19zM6 6h12v3.97L12 8 6 9.97V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flight
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 16v-2l-8-5V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5V9l-8 5v2l8-2.5V19l-2 1.5V22l3.5-1 3.5 1v-1.5L13 19v-5.5l8 2.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pedal-bike
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.18,10L16,4h-4v2h2.6l1.46,4h-4.81l-0.36-1H12V7H7v2h1.75l1.82,5H9.9c-0.44-2.23-2.31-3.88-4.65-3.99 C2.45,9.87,0,12.2,0,15c0,2.8,2.2,5,5,5c2.46,0,4.45-1.69,4.9-4h4.2c0.44,2.23,2.31,3.88,4.65,3.99c2.8,0.13,5.25-2.19,5.25-5 c0-2.8-2.2-5-5-5H18.18z M7.82,16c-0.4,1.17-1.49,2-2.82,2c-1.68,0-3-1.32-3-3s1.32-3,3-3c1.33,0,2.42,0.83,2.82,2H5v2H7.82z M14.1,14h-1.4l-0.73-2H15C14.56,12.58,14.24,13.25,14.1,14z M19,18c-1.68,0-3-1.32-3-3c0-0.93,0.41-1.73,1.05-2.28l0.96,2.64 l1.88-0.68l-0.97-2.67c0.03,0,0.06-0.01,0.09-0.01c1.68,0,3,1.32,3,3S20.68,18,19,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 directions-bike
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.5 5.5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zM5 12c-2.8 0-5 2.2-5 5s2.2 5 5 5 5-2.2 5-5-2.2-5-5-5zm0 8.5c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5 3.5 1.6 3.5 3.5-1.6 3.5-3.5 3.5zm5.8-10l2.4-2.4.8.8c1.3 1.3 3 2.1 5.1 2.1V9c-1.5 0-2.7-.6-3.6-1.5l-1.9-1.9c-.5-.4-1-.6-1.6-.6s-1.1.2-1.4.6L6.31 9.9 11 14v5h2v-6.2l-2.2-2.3zM19 12c-2.8 0-5 2.2-5 5s2.2 5 5 5 5-2.2 5-5-2.2-5-5-5zm0 8.5c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5 3.5 1.6 3.5 3.5-1.6 3.5-3.5 3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 moving
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19.71,9.71L22,12V6h-6l2.29,2.29l-4.17,4.17c-0.39,0.39-1.02,0.39-1.41,0l-1.17-1.17c-1.17-1.17-3.07-1.17-4.24,0L2,16.59 L3.41,18l5.29-5.29c0.39-0.39,1.02-0.39,1.41,0l1.17,1.17c1.17,1.17,3.07,1.17,4.24,0L19.71,9.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fire-truck
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M23,11l-2-6h-2V3h-3v2h-4v6H1v7h3c0,1.66,1.34,3,3,3s3-1.34,3-3h4c0,1.66,1.34,3,3,3s3-1.34,3-3h3V11z M7,19 c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S7.55,19,7,19z M17,19c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S17.55,19,17,19z M14,11V7h5.56l1.33,4H14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,8.5h-1v-2h1V5H1v1.5h1v2H1V10h10V8.5z M5.25,8.5H3.5v-2h1.75V8.5z M8.5,8.5H6.75v-2H8.5V8.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-run
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.49 5.48c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm-3.6 13.9l1-4.4 2.1 2v6h2v-7.5l-2.1-2 .6-3c1.3 1.5 3.3 2.5 5.5 2.5v-2c-1.9 0-3.5-1-4.3-2.4l-1-1.6c-.4-.6-1-1-1.7-1-.3 0-.5.1-.8.1l-5.2 2.2v4.7h2v-3.4l1.8-.7-1.6 8.1-4.9-1-.4 2 7 1.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-car-wash
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.58 7H5.43L3 14v9h3v-2h12v2h3v-9l-2.42-7zM6.5 18c-.83 0-1.5-.67-1.5-1.5S5.67 15 6.5 15s1.5.67 1.5 1.5S7.33 18 6.5 18zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 13l1.5-4.5h11L19 13H5zm12-8c.83 0 1.5-.67 1.5-1.5 0-1-1.5-2.7-1.5-2.7s-1.5 1.7-1.5 2.7c0 .83.67 1.5 1.5 1.5zm-5 0c.83 0 1.5-.67 1.5-1.5 0-1-1.5-2.7-1.5-2.7s-1.5 1.7-1.5 2.7c0 .83.67 1.5 1.5 1.5zM7 5c.83 0 1.5-.67 1.5-1.5C8.5 2.5 7 .8 7 .8S5.5 2.5 5.5 3.5C5.5 4.33 6.17 5 7 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 church
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,12.22V9l-5-2.5V5h2V3h-2V1h-2v2H9v2h2v1.5L6,9v3.22L2,14v8h8v-5h4v5h8v-8L18,12.22z M12,13.5 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S12.83,13.5,12,13.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 my-location
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm8.94 3c-.46-4.17-3.77-7.48-7.94-7.94V1h-2v2.06C6.83 3.52 3.52 6.83 3.06 11H1v2h2.06c.46 4.17 3.77 7.48 7.94 7.94V23h2v-2.06c4.17-.46 7.48-3.77 7.94-7.94H23v-2h-2.06zM12 19c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 straight
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "11,6.83 9.41,8.41 8,7 12,3 16,7 14.59,8.41 13,6.83 13,21 11,21",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 turn-slight-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "12.34,6 12.34,4 18,4 18,9.66 16,9.66 16,7.41 11,12.41 11,20 9,20 9,11.59 14.59,6",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 railway-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M4,11V8h7.29c-0.77-2.6,0.21-4.61,0.37-4.97C2.97,2.67,2,5.02,2,7v9.5C2,18.43,3.57,20,5.5,20L4,21v1h12v-1l-1.5-1 c1.93,0,3.5-1.57,3.5-3.5V13c-1.91,0-3.63-0.76-4.89-2H4z M10,17c-0.83,0-1.5-0.67-1.5-1.5c0-0.83,0.67-1.5,1.5-1.5 s1.5,0.67,1.5,1.5C11.5,16.33,10.83,17,10,17z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18.5,9h-1V8h1V9z M18.5,7h-1V3h1V7z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 zoom-in-map
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9,9l0-6L7,3l0,2.59L3.91,2.5L2.5,3.91L5.59,7L3,7l0,2L9,9z M21,9V7l-2.59,0l3.09-3.09L20.09,2.5L17,5.59V3l-2,0l0,6L21,9z M3,15l0,2h2.59L2.5,20.09l1.41,1.41L7,18.41L7,21h2l0-6L3,15z M15,15l0,6h2v-2.59l3.09,3.09l1.41-1.41L18.41,17H21v-2L15,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-gas-station
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "m19.77 7.23.01-.01-3.72-3.72L15 4.56l2.11 2.11c-1.05.4-1.76 1.47-1.58 2.71.16 1.1 1.1 1.99 2.2 2.11.47.05.88-.03 1.27-.2v8.21h-2V12h-3V3H4v18h10v-7.5h1.5v7.49h5V9c0-.69-.28-1.32-.73-1.77zM12 10H6V5h6v5zm6 0c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 transit-enterexit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M16 18H6V8h3v4.77L15.98 6 18 8.03 11.15 15H16v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 navigation
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M12 2L4.5 20.29l.71.71L12 18l6.79 3 .71-.71L12 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-see
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "3.2", :cy "12", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M22 4h-5.17L15 2H9L7.17 4H2v16h20V4zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hail
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,6c-1.1,0-2-0.9-2-2s0.9-2,2-2s2,0.9,2,2S13.1,6,12,6z M17,2h2c0,2.7-0.93,4.41-2.3,5.5c-0.5,0.4-1.1,0.7-1.7,0.9V22h-2 v-6h-2v6H9V10.1c-0.3,0.1-0.5,0.2-0.6,0.3C7.87,10.81,7,11.43,7,14H5c0-2.06,0.35-3.78,2.11-5.29C8.21,7.81,10,7,12,7 s2.68-0.46,3.48-1.06C15.96,5.55,17,4.76,17,2z M4,16h3v6H4V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 emergency
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/polygon
   {:points
    "20.79,9.23 18.79,5.77 14,8.54 14,3 10,3 10,8.54 5.21,5.77 3.21,9.23 8,12 3.21,14.77 5.21,18.23 10,15.46 10,21 14,21 14,15.46 18.79,18.23 20.79,14.77 16,12",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hvac
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M8.56,14h6.89c0.26-0.45,0.44-0.96,0.51-1.5h-7.9C8.12,13.04,8.29,13.55,8.56,14z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,16c1.01,0,1.91-0.39,2.62-1H9.38C10.09,15.61,10.99,16,12,16z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,8c-1.01,0-1.91,0.39-2.62,1h5.24C13.91,8.39,13.01,8,12,8z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M8.56,10c-0.26,0.45-0.44,0.96-0.51,1.5h7.9c-0.07-0.54-0.24-1.05-0.51-1.5H8.56z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M3,3v18h18V3H3z M12,18c-3.31,0-6-2.69-6-6s2.69-6,6-6s6,2.69,6,6S15.31,18,12,18z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 stadium
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M7,5L3,7V3L7,5z M18,3v4l4-2L18,3z M11,2v4l4-2L11,2z M5,10.04C6.38,10.53,8.77,11,12,11s5.62-0.47,7-0.96 C19,9.86,16.22,9,12,9S5,9.86,5,10.04z M15,17H9l0,4.88C4.94,21.49,2,20.34,2,19v-9c0-1.66,4.48-3,10-3s10,1.34,10,3v9 c0,1.34-2.94,2.48-7,2.87L15,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 tram
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 5l.75-1.5H17V2H7v1.5h4.75L11 5c-3.13.09-6 .73-6 3.5V17c0 1.5 1.11 2.73 2.55 2.95L6 21.5v.5h2l2-2h4l2 2h2v-.5l-1.55-1.55C17.89 19.73 19 18.5 19 17V8.5c0-2.77-2.87-3.41-6-3.5zm-1 13.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm5-4.5H7V9h10v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-florist
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 22c4.97 0 9-4.03 9-9-4.97 0-9 4.03-9 9zM5.6 10.25c0 1.38 1.12 2.5 2.5 2.5.53 0 1.01-.16 1.42-.44l-.02.19c0 1.38 1.12 2.5 2.5 2.5s2.5-1.12 2.5-2.5l-.02-.19c.4.28.89.44 1.42.44 1.38 0 2.5-1.12 2.5-2.5 0-1-.59-1.85-1.43-2.25.84-.4 1.43-1.25 1.43-2.25 0-1.38-1.12-2.5-2.5-2.5-.53 0-1.01.16-1.42.44l.02-.19C14.5 2.12 13.38 1 12 1S9.5 2.12 9.5 3.5l.02.19c-.4-.28-.89-.44-1.42-.44-1.38 0-2.5 1.12-2.5 2.5 0 1 .59 1.85 1.43 2.25-.84.4-1.43 1.25-1.43 2.25zM12 5.5c1.38 0 2.5 1.12 2.5 2.5s-1.12 2.5-2.5 2.5S9.5 9.38 9.5 8s1.12-2.5 2.5-2.5zM3 13c0 4.97 4.03 9 9 9 0-4.97-4.03-9-9-9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 compass-calibration
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "4", :cy "17", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 3C8.1 3 4.56 4.59 2 7.15l5 5c1.28-1.28 3.05-2.08 5-2.08s3.72.79 5 2.07l5-5C19.44 4.59 15.9 3 12 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-atm
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 17h2v-1h2v-5h-4v-1h4V8h-2V7h-2v1H9v5h4v1H9v2h2v1zM22 4H2.01L2 20h20V4zm-2 14H4V6h16v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-drink
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 2l2.21 20H18.8L21 2H3zm9 17c-1.66 0-3-1.34-3-3 0-2 3-5.4 3-5.4s3 3.4 3 5.4c0 1.66-1.34 3-3 3zm6.33-11H5.67l-.44-4h13.53l-.43 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fire-hydrant-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,11h-3V8h2V6h-2.35C16.83,3.67,14.61,2,12,2S7.17,3.67,6.35,6H4v2h2v3H3v6h3v3H4v2h16v-2h-2v-3h3V11z M12,17.5 c-1.93,0-3.5-1.57-3.5-3.5s1.57-3.5,3.5-3.5s3.5,1.57,3.5,3.5S13.93,17.5,12,17.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 liquor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/path
       {:d
        "M3,14c0,1.3,0.84,2.4,2,2.82V20H3v2h6v-2H7v-3.18C8.16,16.4,9,15.3,9,14V6H3V14z M5,8h2v3H5V8z",
        :stroke nil,
        :fill nil}))
     (helix.dom/g
      nil
      (helix.dom/path
       {:d
        "M22,9l-3-1.01V2h-5v6l-3,1.01V22h11V9z M16,4h1v1h-1V4z M13,10.44l3-0.98V7h1v2.46l3,0.98V12h-7V10.44z M20,20h-7v-2h7 V20z",
        :stroke nil,
        :fill nil})))))))


(helix.core/defnc
 emergency-recording
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,10.48V4H2v16h16v-6.48l4,3.98v-11L18,10.48z M12,12l3,1.73l-1,1.73l-3-1.73V17H9v-3.27l-3,1.73l-1-1.73L8,12l-3-1.73 l1-1.73l3,1.73V7h2v3.27l3-1.73l1,1.73L12,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bus-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M4,11V8h7.29c-0.77-2.6,0.21-4.61,0.37-4.97C2.97,2.67,2,5.02,2,7v9.5c0,0.95,0.38,1.81,1,2.44V22h3v-2h8v2h3v-3.06 c0.62-0.63,1-1.49,1-2.44V13c-1.91,0-3.63-0.76-4.89-2H4z M6.5,17C5.67,17,5,16.33,5,15.5S5.67,14,6.5,14S8,14.67,8,15.5 S7.33,17,6.5,17z M15,15.5c0,0.83-0.67,1.5-1.5,1.5S12,16.33,12,15.5s0.67-1.5,1.5-1.5S15,14.67,15,15.5z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18.5,9h-1V8h1V9z M18.5,7h-1V3h1V7z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 restaurant-menu
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.1 13.34l2.83-2.83L3.91 3.5c-1.56 1.56-1.56 4.09 0 5.66l4.19 4.18zm6.78-1.81c1.53.71 3.68.21 5.27-1.38 1.91-1.91 2.28-4.65.81-6.12-1.46-1.46-4.2-1.1-6.12.81-1.59 1.59-2.09 3.74-1.38 5.27L3.7 19.87l1.41 1.41L12 14.41l6.88 6.88 1.41-1.41L13.41 13l1.47-1.47z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 rate-review
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 2H2v20l4-4h16V2zM6 14v-2.47l6.88-6.88c.2-.2.51-.2.71 0l1.77 1.77c.2.2.2.51 0 .71L8.47 14H6zm12 0h-7.5l2-2H18v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 u-turn-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,9v12h-2V9c0-2.21-1.79-4-4-4S8,6.79,8,9v4.17l1.59-1.59L11,13l-4,4l-4-4l1.41-1.41L6,13.17V9c0-3.31,2.69-6,6-6 S18,5.69,18,9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-fire-department
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,12.9l-2.13,2.09C9.31,15.55,9,16.28,9,17.06C9,18.68,10.35,20,12,20s3-1.32,3-2.94c0-0.78-0.31-1.52-0.87-2.07 L12,12.9z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M16,6l-0.44,0.55C14.38,8.02,12,7.19,12,5.3V2c0,0-8,4-8,11c0,2.92,1.56,5.47,3.89,6.86C7.33,19.07,7,18.1,7,17.06 c0-1.32,0.52-2.56,1.47-3.5L12,10.1l3.53,3.47c0.95,0.93,1.47,2.17,1.47,3.5c0,1.02-0.31,1.96-0.85,2.75 c1.89-1.15,3.29-3.06,3.71-5.3C20.52,10.97,18.79,7.62,16,6z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 add-location-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 1v3h3v2h-3v3h-2V6h-3V4h3V1h2zm-8 12c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm2-9.75V7h3v3h2.92c.05.39.08.79.08 1.2 0 3.32-2.67 7.25-8 11.8-5.33-4.55-8-8.48-8-11.8C4 6.22 7.8 3 12 3c.68 0 1.35.08 2 .25z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-pharmacy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 5h-2.64l1.14-3.14L17.15 1l-1.46 4H3v2l2 6-2 6v2h18v-2l-2-6 2-6V5zm-5 9h-3v3h-2v-3H8v-2h3V9h2v3h3v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 run-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M13.5,6c0.55,0,1,0.45,1,1 c0,0.55-0.45,1-1,1s-1-0.45-1-1C12.5,6.45,12.95,6,13.5,6z M16,12c-0.7,0-2.01-0.54-2.91-1.76l-0.41,2.35L14,14.03V18h-1v-3.58 l-1.11-1.21l-0.52,2.64L7.6,15.08l0.2-0.98l2.78,0.57l0.96-4.89L10,10.35V12H9V9.65l3.28-1.21c0.49-0.18,1.03,0.06,1.26,0.53 C14.37,10.67,15.59,11,16,11V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fork-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14.59,15.59L16,17l4-4l-4-4l-1.41,1.41L16.17,12c-1.51-0.33-3.73,0.08-5.17,1.36l0-6.53l1.59,1.59L14,7l-4-4L6,7 l1.41,1.41L9,6.83V21l2,0v-4c0.73-2.58,3.07-3.47,5.17-3L14.59,15.59z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 delivery-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,10.35V5h-5v2h3v2.65L13.52,14H10V9H2v7h2c0,1.66,1.34,3,3,3s3-1.34,3-3h4.48L19,10.35z M7,17c-0.55,0-1-0.45-1-1h2 C8,16.55,7.55,17,7,17z",
       :stroke nil,
       :fill nil})
     (helix.dom/rect
      {:y "6",
       :x "5",
       :width "5",
       :height "2",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M19,13c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,13,19,13z M19,17c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 C20,16.55,19.55,17,19,17z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 near-me-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,6.34L21,3l-3.34,9L12,6.34z M22.61,19.78L4.22,1.39L2.81,2.81l5.07,5.07L3,9.69v1.41l7.07,2.83L12.9,21h1.41l1.81-4.88 l5.07,5.07L22.61,19.78z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-cafe
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 3H4v14h14v-7h2c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 5h-2V5h2v3zM2 21h18v-2H2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 medical-information
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,7h-7V2H9v5H2v15h20V7z M11,4h2v5h-2V4z M11,16H9v2H7v-2H5v-2h2v-2h2v2h2V16z M13,14.5V13h6v1.5H13z M13,17.5V16h4v1.5 H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fort
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "21,3 21,5 19,5 19,3 17,3 17,5 15,5 15,3 13,3 13,7 15,9 15,10 9,10 9,9 11,7 11,3 9,3 9,5 7,5 7,3 5,3 5,5 3,5 3,3 1,3 1,7 3,9 3,15 1,17 1,21 10,21 10,16 14,16 14,21 23,21 23,17 21,15 21,9 23,7 23,3",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-car
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.58 5H5.43L3 12v9h3v-2h12v2h3v-9l-2.42-7zM6.5 16c-.83 0-1.5-.67-1.5-1.5S5.67 13 6.5 13s1.5.67 1.5 1.5S7.33 16 6.5 16zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 11l1.5-4.5h11L19 11H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 map
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 5.1L9 3 3 5.02v16.2l6-2.33 6 2.1 6-2.02V2.77L15 5.1zm0 13.79l-6-2.11V5.11l6 2.11v11.67z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 celebration
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "2,22 16,17 7,8", :stroke nil, :fill nil})
     (helix.dom/path
      {:d
       "M14.53,12.53L21,6.05l1.48,1.48l1.06-1.06L21,3.93l-7.53,7.53L14.53,12.53z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M10.94,6L9.47,7.47l1.06,1.06l2.54-2.54l-2.54-2.53L9.47,4.53L10.94,6z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M18.97,9.97l-3.5,3.5l1.06,1.06L19,12.06l2.5,2.49l1.06-1.06L18.97,9.97z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M15.97,4.97l-4.5,4.5l1.06,1.06L18.07,5l-3.53-3.53l-1.06,1.06L15.97,4.97z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 directions-subway
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2c-4.42 0-8 .5-8 4v9.5C4 17.43 5.57 19 7.5 19L6 20.5v.5h12v-.5L16.5 19c1.93 0 3.5-1.57 3.5-3.5V6c0-3.5-3.58-4-8-4zM7.5 17c-.83 0-1.5-.67-1.5-1.5S6.67 14 7.5 14s1.5.67 1.5 1.5S8.33 17 7.5 17zm3.5-6H6V6h5v5zm5.5 6c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm1.5-6h-5V6h5v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sailing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M11,13.5V2L3,13.5H11z M21,13.5C21,6.5,14.5,1,12.5,1c0,0,1,3,1,6.5s-1,6-1,6H21z M22,15H2c0.31,1.53,1.16,2.84,2.33,3.73 C4.98,18.46,5.55,18.01,6,17.5C6.73,18.34,7.8,19,9,19s2.27-0.66,3-1.5c0.73,0.84,1.8,1.5,3,1.5s2.26-0.66,3-1.5 c0.45,0.51,1.02,0.96,1.67,1.23C20.84,17.84,21.69,16.53,22,15z M22,23v-2h-1c-1.04,0-2.08-0.35-3-1c-1.83,1.3-4.17,1.3-6,0 c-1.83,1.3-4.17,1.3-6,0c-0.91,0.65-1.96,1-3,1H2l0,2h1c1.03,0,2.05-0.25,3-0.75c1.89,1,4.11,1,6,0c1.89,1,4.11,1,6,0h0 c0.95,0.5,1.97,0.75,3,0.75H22z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ev-station
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.77 7.23l.01-.01-3.72-3.72L15 4.56l2.11 2.11c-1.05.4-1.76 1.47-1.58 2.71.16 1.1 1.1 1.99 2.2 2.11.47.05.88-.03 1.27-.2v8.21h-2V12h-3V3H4v18h10v-7.5h1.5V21h5V9c0-.69-.28-1.32-.73-1.77zM18 10c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zM8 18v-4.5H6L10 6v5h2l-4 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-offer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22.83 12.99 11.83 2H2v9.83l10.99 10.99 9.84-9.83zM5.5 7C4.67 7 4 6.33 4 5.5S4.67 4 5.5 4 7 4.67 7 5.5 6.33 7 5.5 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _360
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 7C6.48 7 2 9.24 2 12c0 2.24 2.94 4.13 7 4.77V20l4-4-4-4v2.73c-3.15-.56-5-1.9-5-2.73 0-1.06 3.04-3 8-3s8 1.94 8 3c0 .73-1.46 1.89-4 2.53v2.05c3.53-.77 6-2.53 6-4.58 0-2.76-4.48-5-10-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 zoom-out-map
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 3l2.3 2.3-2.89 2.87 1.42 1.42L18.7 6.7 21 9V3h-6zM3 9l2.3-2.3 2.87 2.89 1.42-1.42L6.7 5.3 9 3H3v6zm6 12l-2.3-2.3 2.89-2.87-1.42-1.42L5.3 17.3 3 15v6h6zm12-6l-2.3 2.3-2.87-2.89-1.42 1.42 2.89 2.87L15 21h6v-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 alt-route
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M9.78,11.16l-1.42,1.42c-0.68-0.69-1.34-1.58-1.79-2.94l1.94-0.49C8.83,10.04,9.28,10.65,9.78,11.16z M11,6L7,2L3,6h3.02 C6.04,6.81,6.1,7.54,6.21,8.17l1.94-0.49C8.08,7.2,8.03,6.63,8.02,6H11z M21,6l-4-4l-4,4h2.99c-0.1,3.68-1.28,4.75-2.54,5.88 c-0.5,0.44-1.01,0.92-1.45,1.55c-0.34-0.49-0.73-0.88-1.13-1.24L9.46,13.6C10.39,14.45,11,15.14,11,17c0,0,0,0,0,0h0v5h2v-5 c0,0,0,0,0,0c0-2.02,0.71-2.66,1.79-3.63c1.38-1.24,3.08-2.78,3.2-7.37H21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 synagogue
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6,8v13h4v-7h4v7h4V8l-6-5L6,8z M13.5,10c0,0.83-0.67,1.5-1.5,1.5s-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5S13.5,9.17,13.5,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M3,5C1.9,5,1,5.9,1,7v1h4V7C5,5.9,4.1,5,3,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "1",
      :width "4",
      :height "12",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M21,5c-1.1,0-2,0.9-2,2v1h4V7C23,5.9,22.1,5,21,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "19",
      :width "4",
      :height "12",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-hotel
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 13c1.66 0 3-1.34 3-3S8.66 7 7 7s-3 1.34-3 3 1.34 3 3 3zm16-6H11v7H3V5H1v15h2v-3h18v3h2V7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 home-repair-service
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points
       "18,16 16,16 16,15 8,15 8,16 6,16 6,15 2,15 2,20 22,20 22,15 18,15",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d "M17,8V4H7v4H2v6h4v-2h2v2h8v-2h2v2h4V8H17z M9,6h6v2H9V6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 money
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 16h5V8h-5v8zm2-6h1v4h-1v-4zm-8 6h5V8H8v8zm2-6h1v4h-1v-4zM5 8h2v8H5zM2 4v16h20V4H2zm18 14H4V6h16v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 edit-attributes
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.63 7H6.37C3.96 7 2 9.24 2 12s1.96 5 4.37 5h11.26c2.41 0 4.37-2.24 4.37-5s-1.96-5-4.37-5zM7.24 14.46l-2.57-2.57.7-.7 1.87 1.87 3.52-3.52.7.7-4.22 4.22z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 temple-hindu
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "6.6,11 17.4,11 16.5,8 7.5,8", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points
      "20,11 20,13 4,13 4,11 2,11 2,22 10,22 10,17 14,17 14,22 22,22 22,11",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "15.9,6 15,3 15,1 13,1 13,3 10.97,3 10.97,1 8.97,1 8.97,3.12 8.1,6",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-movies
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 3v2h-2V3H8v2H6V3H4v18h2v-2h2v2h8v-2h2v2h2V3h-2zM8 17H6v-2h2v2zm0-4H6v-2h2v2zm0-4H6V7h2v2zm10 8h-2v-2h2v2zm0-4h-2v-2h2v2zm0-4h-2V7h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 terrain
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 6l-3.75 5 2.85 3.8-1.6 1.2C9.81 13.75 7 10 7 10l-6 8h22L14 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 icecream
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.38,6.24C17.79,3.24,15.14,1,12,1S6.21,3.24,5.62,6.24C4.08,6.81,3,8.29,3,10c0,2.21,1.79,4,4,4 c0.12,0,0.23-0.02,0.34-0.02L12.07,23l4.61-9.03C16.79,13.98,16.89,14,17,14c2.21,0,4-1.79,4-4C21,8.29,19.92,6.81,18.38,6.24z M12.05,18.63l-2.73-5.21C10.15,13.79,11.06,14,12,14c0.95,0,1.88-0.21,2.72-0.6L12.05,18.63z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 satellite
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3v18h18V3zM5 4.99h3C8 6.65 6.66 8 5 8V4.99zM5 12v-2c2.76 0 5-2.25 5-5.01h2C12 8.86 8.87 12 5 12zm0 6l3.5-4.5 2.5 3.01L14.5 12l4.5 6H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-parking
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 3H6v18h4v-6h3c3.31 0 6-2.69 6-6s-2.69-6-6-6zm.2 8H10V7h3.2c1.1 0 2 .9 2 2s-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 train
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2c-4 0-8 .5-8 4v9.5C4 17.43 5.57 19 7.5 19L6 20.5v.5h2l2-2h4l2 2h2v-.5L16.5 19c1.93 0 3.5-1.57 3.5-3.5V6c0-3.5-4-4-8-4zM7.5 17c-.83 0-1.5-.67-1.5-1.5S6.67 14 7.5 14s1.5.67 1.5 1.5S8.33 17 7.5 17zm3.5-7H6V6h5v4zm5.5 7c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm1.5-7h-5V6h5v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 layers-clear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 9l-9-7-2.59 2.02 7.87 7.87zm0 5.07l-1.63-1.27-.67.52 1.43 1.43zM3.41.86L2 2.27l4.22 4.22L3 9l9 7 2.1-1.63 1.42 1.42-3.53 2.75-7.37-5.73L3 14.07l9 7 4.95-3.85L20.73 21l1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mode-of-travel
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15.31,18.9c-0.96,1-2.06,2.03-3.31,3.1c-5.33-4.55-8-8.48-8-11.8C4,5.22,7.8,2,12,2c4,0,7.64,2.92,7.97,7.5l3.53,0L19,14 l-4.5-4.5l3.47,0C17.65,6.24,15.13,4,12,4c-3.35,0-6,2.57-6,6.2c0,2.34,1.95,5.44,6,9.14c0.64-0.59,1.23-1.16,1.77-1.71 c-0.17-0.34-0.27-0.72-0.27-1.12c0-1.38,1.12-2.5,2.5-2.5s2.5,1.12,2.5,2.5S17.38,19,16,19C15.76,19,15.53,18.97,15.31,18.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 beenhere
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3.01 1L3 17l9 6 8.99-6L21 1H3.01zM10 16l-5-5 1.41-1.42L10 13.17l7.59-7.59L19 7l-9 9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 museum
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,11V9L12,2L2,9v2h2v9H2v2h20v-2h-2v-9H22z M16,18h-2v-4l-2,3l-2-3v4H8v-7h2l2,3l2-3h2V18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 egg-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,9C17,7,15.99,2,9.97,2C4.95,2,1.94,6,2,11.52C2.06,17.04,6.96,19,9.97,19c2.01,0,2.01,3,6.02,3C19,22,22,19,22,15.02 C22,12,21.01,11,19,9z M12,15.5c-1.93,0-3.5-1.57-3.5-3.5s1.57-3.5,3.5-3.5s3.5,1.57,3.5,3.5S13.93,15.5,12,15.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-bus-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:enable-background "new",
     :d
     "M12,2C8,2,4,2.5,4,6v9.5c0,0.95,0.38,1.81,1,2.44V21h3v-2h8v2h3v-3.06 c0.62-0.63,1-1.49,1-2.44V6C20,2.5,16.42,2,12,2z M8.5,16C7.67,16,7,15.33,7,14.5S7.67,13,8.5,13s1.5,0.67,1.5,1.5S9.33,16,8.5,16z M15.5,16c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S16.33,16,15.5,16z M18,10H6V7h12V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 safety-check
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2L4,5v6.09c0,5.05,3.41,9.76,8,10.91c4.59-1.15,8-5.86,8-10.91V5L12,2z M12,17c-2.76,0-5-2.24-5-5s2.24-5,5-5 s5,2.24,5,5S14.76,17,12,17z M13.65,14.35l-2.15-2.15V9h1v2.79l1.85,1.85L13.65,14.35z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-airport
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,16v-2l-8.5-5V3.5C13.5,2.67,12.83,2,12,2s-1.5,0.67-1.5,1.5V9L2,14v2l8.5-2.5V19L8,20.5L8,22l4-1l4,1l0-1.5L13.5,19 v-5.5L22,16z",
     :stroke nil,
     :fill nil})
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))))


(helix.core/defnc
 directions-subway-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C8,2,4,2.5,4,6v9.5C4,17.43,5.57,19,7.5,19L6,20v1h12v-1l-1.5-1c1.93,0,3.5-1.57,3.5-3.5V6C20,2.5,16.42,2,12,2z M8.5,16C7.67,16,7,15.33,7,14.5S7.67,13,8.5,13s1.5,0.67,1.5,1.5S9.33,16,8.5,16z M11,10H6V7h5V10z M15.5,16 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S16.33,16,15.5,16z M18,10h-5V7h5V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 person-pin-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 11c-1.33 0-4 .67-4 2v.16c.97 1.12 2.4 1.84 4 1.84s3.03-.72 4-1.84V13c0-1.33-2.67-2-4-2zm0-1c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0-8c4.2 0 8 3.22 8 8.2 0 3.32-2.67 7.25-8 11.8-5.33-4.55-8-8.48-8-11.8C4 5.22 7.8 2 12 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 trip-origin
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 12C2 6.48 6.48 2 12 2s10 4.48 10 10-4.48 10-10 10S2 17.52 2 12zm10 6c3.31 0 6-2.69 6-6s-2.69-6-6-6-6 2.69-6 6 2.69 6 6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 plumbing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16.16,5.64l3.54,3.54c1.17-1.17,1.17-3.07,0-4.24l-3.54-3.54l-4.24,4.24l2.12,2.12L16.16,5.64z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10.5",
      :x "5.17",
      :width "5",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 -6.2383 8.9393)",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.45,7.76l-1.41,1.41L9.79,4.93L7.67,7.05l4.24,4.24l-8.49,8.49l2.83,2.83L16.86,12l0.71,0.71l1.41-1.41L15.45,7.76z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-car
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.58,1H5.43L3,8v9h3v-2h12v2h3V8L18.58,1z M6.5,12C5.67,12,5,11.33,5,10.5S5.67,9,6.5,9S8,9.67,8,10.5S7.33,12,6.5,12z M17.5,12c-0.83,0-1.5-0.67-1.5-1.5S16.67,9,17.5,9S19,9.67,19,10.5S18.33,12,17.5,12z M5,7l1.5-4.5h11L19,7H5z",
     :stroke nil,
     :fill nil})
   (helix.dom/polygon
    {:points "7,20 11,20 11,18 17,21 13,21 13,23",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 nightlife
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M1,5h14l-6,9v4h2v2H5v-2h2v-4L1,5z M10.1,9l1.4-2H4.49l1.4,2H10.1z M17,5h5v3h-3v9l0,0c0,1.66-1.34,3-3,3s-3-1.34-3-3 s1.34-3,3-3c0.35,0,0.69,0.06,1,0.17V5z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 breakfast-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17.85,3L6.14,3C4.15,3,2.36,4.39,2.05,6.36C1.78,8.11,2.64,9.65,4,10.45V21h16V10.45c1.36-0.79,2.23-2.36,1.95-4.11 C21.63,4.38,19.83,3,17.85,3z M16.41,13L12,17.42L7.59,13L12,8.59L16.41,13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-play
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 12c0-1.1.9-2 2-2V4H2.01v6c1.1 0 1.99.9 1.99 2s-.89 2-2 2v6h20v-6c-1.1 0-2-.9-2-2zm-4.42 4.8L12 14.5l-3.58 2.3 1.08-4.12-3.29-2.69 4.24-.25L12 5.8l1.54 3.95 4.24.25-3.29 2.69 1.09 4.11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 festival
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M23,11V9c-6-2-11-7-11-7S7,7,1,9v2c0,1.49,0.93,2.75,2.24,3.26C3.2,16.76,2.92,19.69,2,22h5h10h5 c-0.92-2.31-1.2-5.24-1.24-7.74C22.07,13.75,23,12.49,23,11z M12,4.71c1.33,1.14,3.49,2.84,6.11,4.29H5.89 C8.51,7.55,10.67,5.85,12,4.71z M13,11h3c0,0.83-0.67,1.5-1.5,1.5S13,11.83,13,11z M9.5,12.5C8.67,12.5,8,11.83,8,11h3 C11,11.83,10.33,12.5,9.5,12.5z M6,11c0,0.83-0.67,1.5-1.5,1.5S3,11.83,3,11H6z M4.66,20c0.39-1.86,0.54-3.82,0.57-5.58 c0.68-0.15,1.29-0.49,1.76-0.98c0.25,0.25,0.54,0.45,0.85,0.62c-0.1,1.87-0.26,4-0.52,5.93H4.66z M9.35,20 c0.24-1.83,0.39-3.78,0.48-5.53c0.84-0.08,1.61-0.45,2.17-1.02c0.56,0.57,1.32,0.94,2.17,1.02c0.1,1.75,0.24,3.7,0.48,5.53H9.35z M16.67,20c-0.27-1.94-0.43-4.07-0.52-5.93c0.31-0.17,0.61-0.37,0.85-0.62c0.47,0.48,1.08,0.83,1.76,0.98 c0.03,1.76,0.18,3.72,0.57,5.58H16.67z M19.5,12.5c-0.83,0-1.5-0.67-1.5-1.5h3C21,11.83,20.33,12.5,19.5,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 castle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,9v2h-2V3h-2v2h-2V3h-2v2h-2V3H9v2H7V3H5v8H3V9H1v12h9v-5h4v5h9V9H21z M11,12H9V9h2V12z M15,12h-2V9h2V12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 pin-drop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:fill-rule "evenodd",
    :d
    "M5 20h14v2H5v-2zm7-13c-1.1 0-2 .9-2 2s.9 2 2 2a2 2 0 100-4zm0-5c3.27 0 7 2.46 7 7.15 0 3.12-2.33 6.41-7 9.85-4.67-3.44-7-6.73-7-9.85C5 4.46 8.73 2 12 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-mall
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 6h-4c0-2.76-2.24-5-5-5S7 3.24 7 6H3v16h18V6zm-9-3c1.66 0 3 1.34 3 3H9c0-1.66 1.34-3 3-3zm0 10c-2.76 0-5-2.24-5-5h2c0 1.66 1.34 3 3 3s3-1.34 3-3h2c0 2.76-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 snowmobile
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,17c0,0.55-0.45,1-1,1h-0.17l-2.2-2.2C21.6,15.18,23,13,23,13l-9-8h-3v2h2.25l1.45,1.3L11,11l-9.5-1L0,13l4.54,1.36 l-3.49,1.88C-0.77,17.22-0.07,20,2,20h6c2.21,0,4-1.79,4-4h4l2,2h-3v2h6c1.66,0,3-1.34,3-3H22z M8,18H2l5.25-2.83L10,16 C10,17.1,9.11,18,8,18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-dining
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.1 13.34l2.83-2.83L3.91 3.5c-1.56 1.56-1.56 4.09 0 5.66l4.19 4.18zm6.78-1.81c1.53.71 3.68.21 5.27-1.38 1.91-1.91 2.28-4.65.81-6.12-1.46-1.46-4.2-1.1-6.12.81-1.59 1.59-2.09 3.74-1.38 5.27L3.7 19.87l1.41 1.41L12 14.41l6.88 6.88 1.41-1.41L13.41 13l1.47-1.47z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 warehouse
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,21V7L12,3L2,7v14h5v-9h10v9H22z M11,19H9v2h2V19z M13,16h-2v2h2V16z M15,19h-2v2h2V19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 menu-book
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/path
    {:d
     "M21,5c-1.11-0.35-2.33-0.5-3.5-0.5c-1.95,0-4.05,0.4-5.5,1.5c-1.45-1.1-3.55-1.5-5.5-1.5S2.45,4.9,1,6v15.5 C2.45,20.4,4.55,20,6.5,20s4.05,0.4,5.5,1.5c1.45-1.1,3.55-1.5,5.5-1.5c1.17,0,2.39,0.15,3.5,0.5c0.75,0.25,1.4,0.55,2,1V6 C22.4,5.55,21.75,5.25,21,5z M21,18.5c-1.1-0.35-2.3-0.5-3.5-0.5c-1.7,0-4.15,0.65-5.5,1.5V8c1.35-0.85,3.8-1.5,5.5-1.5 c1.2,0,2.4,0.15,3.5,0.5V18.5z",
     :stroke nil,
     :fill nil})
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.5,10.5c0.88,0,1.73,0.09,2.5,0.26V9.24C19.21,9.09,18.36,9,17.5,9c-1.7,0-3.24,0.29-4.5,0.83v1.66 C14.13,10.85,15.7,10.5,17.5,10.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13,12.49v1.66c1.13-0.64,2.7-0.99,4.5-0.99c0.88,0,1.73,0.09,2.5,0.26V11.9c-0.79-0.15-1.64-0.24-2.5-0.24 C15.8,11.66,14.26,11.96,13,12.49z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.5,14.33c-1.7,0-3.24,0.29-4.5,0.83v1.66c1.13-0.64,2.7-0.99,4.5-0.99c0.88,0,1.73,0.09,2.5,0.26v-1.52 C19.21,14.41,18.36,14.33,17.5,14.33z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 edit-road
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "18,4 16,4 16,11.9 18,9.9", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "4",
      :width "2",
      :height "16",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "10",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "10",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "16",
      :x "10",
      :width "2",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.56,12.59l-1.15-1.15c-0.59-0.59-1.54-0.59-2.12,0L14,16.73V20h3.27l5.29-5.29C23.15,14.12,23.15,13.17,22.56,12.59z M16.58,18.45h-1.03v-1.03L19,13.97L20.03,15L16.58,18.45z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-rickshaw
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,11.18V9l-5-6H1v12h2.18C3.6,16.16,4.7,17,6,17s2.4-0.84,2.82-2h8.37c0.48,1.34,1.86,2.25,3.42,1.94 c1.16-0.23,2.11-1.17,2.33-2.33C23.25,13.05,22.34,11.66,21,11.18z M18.4,9H16V6.12L18.4,9z M3,5h4v4H3V5z M6,15 c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S6.55,15,6,15z M9,13v-2h3V9H9V5h5v8H9z M20,15c-0.55,0-1-0.45-1-1s0.45-1,1-1 s1,0.45,1,1S20.55,15,20,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "7,20 11,20 11,18 17,21 13,21 13,23",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 place
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 12c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm0-10c-4.2 0-8 3.22-8 8.2 0 3.32 2.67 7.25 8 11.8 5.33-4.55 8-8.48 8-11.8C20 5.22 16.2 2 12 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 near-me
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3L3 10.53v.98l6.84 2.65L12.48 21h.98L21 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ramp-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13,21h-2V6.83L9.41,8.41L8,7l4-4l4,4l-1.41,1.41L13,6.83V9c0,4.27,4.03,7.13,6,8.27l-1.46,1.46 c-1.91-1.16-3.44-2.53-4.54-4.02L13,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 multiple-stop
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M17,4l4,4l-4,4V9h-4V7h4V4z M7,17h4v-2H7v-3l-4,4l4,4V17z M19,15h-2v2h2V15z M15,15h-2v2h2V15z M11,7H9v2h2V7z M7,7H5v2h2 V7z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 directions-transit-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C8,2,4,2.5,4,6v9.5C4,17.43,5.57,19,7.5,19L6,20v1h12v-1l-1.5-1c1.93,0,3.5-1.57,3.5-3.5V6C20,2.5,16.42,2,12,2z M8.5,16C7.67,16,7,15.33,7,14.5S7.67,13,8.5,13s1.5,0.67,1.5,1.5S9.33,16,8.5,16z M11,10H6V7h5V10z M15.5,16 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S16.33,16,15.5,16z M18,10h-5V7h5V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 electrical-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "13",
      :x "18",
      :width "3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "12,12 12,14 10,14 10,18 12,18 12,20 17,20 17,12",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "5,11 12,11 12,4 4,4 4,6 10,6 10,9 3,9 3,17 9,17 9,15 5,15",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "18",
      :width "3",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-taxi
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.58 5H15V3H9v2H5.43L3 12v9h3v-2h12v2h3v-9l-2.42-7zM6.5 16c-.83 0-1.5-.67-1.5-1.5S5.67 13 6.5 13s1.5.67 1.5 1.5S7.33 16 6.5 16zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 11l1.5-4.5h11L19 11H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sos
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M15.5,7h-7v10h7V7z M13.5,15h-3V9h3V15z M1,15h4v-2H1V7h6v2H3v2h4v6H1V15z M17,15h4v-2h-4V7h6v2h-4v2h4v6h-6V15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 volunteer-activism
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "11",
      :x "1",
      :width "4",
      :height "11",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,3.25C16.65,2.49,17.66,2,18.7,2C20.55,2,22,3.45,22,5.3c0,2.27-2.91,4.9-6,7.7c-3.09-2.81-6-5.44-6-7.7 C10,3.45,11.45,2,13.3,2C14.34,2,15.35,2.49,16,3.25z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "22,17 13,17 10.91,16.27 11.24,15.32 13,16 17,16 17,14 8.97,11 7,11 7,20.02 14,22 22,19",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-police
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M14.5,12.59l0.9,3.88L12,14.42l-3.4,2.05l0.9-3.87l-3-2.59l3.96-0.34L12,6.02l1.54,3.64L17.5,10L14.5,12.59z M3,5v6 c0,5.55,3.84,10.74,9,12c5.16-1.26,9-6.45,9-12V5l-9-4L3,5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-transit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2c-4.42 0-8 .5-8 4v9.5C4 17.43 5.57 19 7.5 19L6 20.5v.5h12v-.5L16.5 19c1.93 0 3.5-1.57 3.5-3.5V6c0-3.5-3.58-4-8-4zM7.5 17c-.83 0-1.5-.67-1.5-1.5S6.67 14 7.5 14s1.5.67 1.5 1.5S8.33 17 7.5 17zm3.5-6H6V6h5v5zm5.5 6c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm1.5-6h-5V6h5v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mosque
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M6.12,8C6,8,18,8,17.88,8", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M17.88,8C17.95,7.71,18,7.41,18,7.09c0-1.31-0.65-2.53-1.74-3.25L12,1L7.74,3.84C6.65,4.56,6,5.78,6,7.09 C6,7.41,6.05,7.71,6.12,8",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M24,7c0-1.1-2-3-2-3s-2,1.9-2,3c0,0.74,0.4,1.38,1,1.72V13h-2V9H5v4H3V8.72C3.6,8.38,4,7.74,4,7c0-1.1-2-3-2-3S0,5.9,0,7 c0,0.74,0.4,1.38,1,1.72V21h9v-6h4v6h9V8.72C23.6,8.38,24,7.74,24,7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-bar
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 5V3H3v2l8 9v5H6v2h12v-2h-5v-5l8-9zM7.43 7L5.66 5h12.69l-1.78 2H7.43z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 streetview
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.56 14.33c-.34.27-.56.7-.56 1.17V21h7c1.1 0 2-.9 2-2v-5.98c-.94-.33-1.95-.52-3-.52-2.03 0-3.93.7-5.44 1.83z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "5", :cy "6", :cx "18", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M11.5 6c0-1.08.27-2.1.74-3H5c-1.1 0-2 .9-2 2v14c0 .55.23 1.05.59 1.41l9.82-9.82C12.23 9.42 11.5 7.8 11.5 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-convenience-store
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 7V4H5v3H2v13h8v-4h4v4h8V7h-3zm-8 3H9v1h2v1H8V9h2V8H8V7h3v3zm5 2h-1v-2h-2V7h1v2h1V7h1v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 kebab-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M7.75,8H11v5H7.75v1H8.5c1.38,0,2.5,1.12,2.5,2.5S9.88,19,8.5,19H7.75v4h-1.5v-4H5.5C4.12,19,3,17.88,3,16.5S4.12,14,5.5,14 h0.75v-1H3V8h3.25V7H5.5C4.12,7,3,5.88,3,4.5S4.12,2,5.5,2h0.75V1h1.5v1H8.5C9.88,2,11,3.12,11,4.5S9.88,7,8.5,7H7.75V8z M17.75,7 h0.75C19.88,7,21,5.88,21,4.5S19.88,2,18.5,2h-0.75V1h-1.5v1H15.5C14.12,2,13,3.12,13,4.5S14.12,7,15.5,7h0.75v1H13v5h3.25v1H15.5 c-1.38,0-2.5,1.12-2.5,2.5s1.12,2.5,2.5,2.5h0.75v4h1.5v-4h0.75c1.38,0,2.5-1.12,2.5-2.5S19.88,14,18.5,14h-0.75v-1H21V8h-3.25V7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pest-control-rodent
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21.31,17.38l-2.39-2.13C19.44,12.89,17.56,11,15.5,11c-1.16,0-3.5,0.9-3.5,3.5c0,0.97,0.39,1.84,1.03,2.47l-0.71,0.71 C11.5,16.87,11,15.74,11,14.5c0-1.7,0.96-3.17,2.35-3.93c-0.7-0.36-1.48-0.57-2.28-0.57c-2.38,0-4.37,1.65-4.91,3.87 C4.91,13.5,4,12.36,4,11c0-1.66,1.34-3,3-3c0.94,0,1.56,0,2.5,0C10.88,8,12,6.88,12,5.5C12,4.12,10.88,3,9.5,3H7v2h2.5 C9.78,5,10,5.22,10,5.5C10,5.78,9.78,6,9.5,6C9.47,6,9,6,7,6c-2.76,0-5,2.24-5,5c0,2.42,1.72,4.44,4,4.9v0.03 C6,18.73,8.27,21,11.07,21h8.86C21.8,21,22.74,18.66,21.31,17.38z M18,19c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1 C19,18.55,18.55,19,18,19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 ramp-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11,21h2V6.83l1.59,1.59L16,7l-4-4L8,7l1.41,1.41L11,6.83V9c0,4.27-4.03,7.13-6,8.27l1.46,1.46 C8.37,17.56,9.9,16.19,11,14.7L11,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 dry-cleaning
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,12l-8-3.56V6h-1c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1h2c0-1.84-1.66-3.3-3.56-2.95 C10.26,2.27,9.29,3.22,9.06,4.4C8.76,5.96,9.66,7.34,11,7.82v0.63l-8,3.56L3,16h4v6h10v-6h4V12z M19,14h-2v-1H7v1H5v-0.7l7-3.11 l7,3.11V14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-bus
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 16c0 .88.39 1.67 1 2.22V21h3v-2h8v2h3v-2.78c.61-.55 1-1.34 1-2.22V6c0-3.5-3.58-4-8-4s-8 .5-8 4v10zm3.5 1c-.83 0-1.5-.67-1.5-1.5S6.67 14 7.5 14s1.5.67 1.5 1.5S8.33 17 7.5 17zm9 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm1.5-6H6V6h12v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 theater-comedy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M11,2v5.5h3.5v3.31C14.55,9.8,15.64,9,16.99,9c1.38,0,2.5,0.84,2.5,1.88H14.5v3.56C15.26,14.8,16.11,15,17,15 c3.31,0,6-2.69,6-6V2H11z M15,7.5c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S15.55,7.5,15,7.5z M19,7.5c-0.55,0-1-0.45-1-1 s0.45-1,1-1s1,0.45,1,1S19.55,7.5,19,7.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1,16c0,3.31,2.69,6,6,6s6-2.69,6-6V9H1V16z M7,17.88c-1.38,0-2.5-0.84-2.5-1.88h5C9.5,17.04,8.38,17.88,7,17.88z M9,12.5 c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S8.45,12.5,9,12.5z M5,12.5c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1 S4.45,12.5,5,12.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 factory
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,10v12H2V10l7-3v2l5-2l0,0l0,3H22z M17.2,8.5L18,2h3l0.8,6.5H17.2z M11,18h2v-4h-2V18z M7,18h2v-4H7V18z M17,14h-2v4h2 V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 electric-moped
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,8.35V3h-5v2h3v2.65L13.52,12H10V7H6c-2.21,0-4,1.79-4,4v3h2c0,1.66,1.34,3,3,3s3-1.34,3-3h4.48L19,8.35z M7,15 c-0.55,0-1-0.45-1-1h2C8,14.55,7.55,15,7,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4", :x "5", :width "5", :height "2", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M19,11c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,11,19,11z M19,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S19.55,15,19,15z",
      :stroke nil,
      :fill nil}))
   (helix.dom/polygon
    {:points "7,20 11,20 11,18 17,21 13,21 13,23",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 subway
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "8.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "15.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M7.01 9h10v5h-10zM17.8 2.8C16 2.09 13.86 2 12 2s-4 .09-5.8.8C3.53 3.84 2 6.05 2 8.86V22h20V8.86c0-2.81-1.53-5.02-4.2-6.06zm.2 12.7c0 1.54-1.16 2.79-2.65 2.96l1.15 1.16V20h-1.67l-1.5-1.5h-2.66L9.17 20H7.5v-.38l1.15-1.16C7.16 18.29 6 17.04 6 15.5V9c0-2.63 3-3 6-3s6 .37 6 3v6.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-meals
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M16,14V6c0-1.76,2.24-4,5-4v16.17l-2-2V14H16z M20.49,23.31L10.02,12.85C9.69,12.94,9.36,13,9,13v9H7v-9c-2.21,0-4-1.79-4-4 V5.83L0.69,3.51L2.1,2.1l19.8,19.8L20.49,23.31z M6.17,9L5,7.83V9H6.17z M9,2H7v2.17l2,2V2z M13,9V2h-2v6.17l1.85,1.85 C12.94,9.69,13,9.36,13,9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airlines
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M13,4L2,20h17l3-16H13z M14.5,14c-1.38,0-2.5-1.12-2.5-2.5c0-1.38,1.12-2.5,2.5-2.5s2.5,1.12,2.5,2.5 C17,12.88,15.88,14,14.5,14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-stops
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18.21,9.21C15.93,10.78,13.45,13.3,13,17h2v2H9v-2h2c-0.5-4.5-4.37-8-9-8V7c4.39,0,8.22,2.55,10,6.3 c1.13-2.43,2.99-4.25,4.78-5.52L14,5h7v7L18.21,9.21z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 turn-sharp-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "18,6.83 19.59,8.41 21,7 17,3 13,7 14.41,8.41 16,6.83 16,13 6,13 6,21 8,21 8,15 18,15",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-post-office
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 4H2.01v16H22V4zm-2 4l-8 5-8-5V6l8 5 8-5v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-railway
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 15.5C4 17.43 5.57 19 7.5 19L6 20.5v.5h12v-.5L16.5 19c1.93 0 3.5-1.57 3.5-3.5V5c0-3.5-3.58-4-8-4s-8 .5-8 4v10.5zm8 1.5c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm6-7H6V5h12v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 temple-buddhist
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M21,9.02c0,1.09-0.89,1.98-1.98,1.98H4.98C3.89,11,3,10.11,3,9.02H1c0,1.86,1.28,3.4,3,3.84V22h6v-5h4v5h6v-9.14 c0.55-0.14,3-1.04,3-3.86L21,9.02z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M6,8.86V10h12V8.86c0.55-0.14,3-1.04,3-3.86l-2,0.02C19,6.11,18.11,7,17.02,7H6.98C5.89,7,5,6.11,5,5.02H3 C3,6.87,4.28,8.42,6,8.86z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "12,1 8.25,6 15.75,6", :stroke nil, :fill nil}))))))


(helix.core/defnc
 person-pin
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 2H3v18h6l3 3 3-3h6V2zm-9 3.3c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7S9.3 9.49 9.3 8s1.21-2.7 2.7-2.7zM18 16H6v-.9c0-2 4-3.1 6-3.1s6 1.1 6 3.1v.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 badge
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,7h-7V2H9v5H2v15h20V7z M9,12c0.83,0,1.5,0.67,1.5,1.5c0,0.83-0.67,1.5-1.5,1.5s-1.5-0.67-1.5-1.5 C7.5,12.67,8.17,12,9,12z M12,18H6v-0.43c0-0.6,0.36-1.15,0.92-1.39C7.56,15.9,8.26,15.75,9,15.75s1.44,0.15,2.08,0.43 c0.55,0.24,0.92,0.78,0.92,1.39V18z M13,9h-2V4h2V9z M18,16.5h-4V15h4V16.5z M18,13.5h-4V12h4V13.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 car-repair
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M4,17.01V19h7v3h2v-3h7v-1.99H4z M7,14h10v2h2V8.69L17.11,3H6.89L5,8.69V16h2V14z M9,11.5c-0.55,0-1-0.45-1-1s0.45-1,1-1 s1,0.45,1,1S9.55,11.5,9,11.5z M15,11.5c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S15.55,11.5,15,11.5z M8.33,5h7.34l0.66,2H7.67 L8.33,5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-hospital
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3H3.01L3 21h18V3zm-3 11h-4v4h-4v-4H6v-4h4V6h4v4h4v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wind-power
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/rect
      {:y "3",
       :x "4",
       :width "6",
       :height "2",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/rect
      {:y "7",
       :x "1",
       :width "5",
       :height "2",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/rect
      {:y "19",
       :x "3",
       :width "5",
       :height "2",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M15.32,12.09l5.42-9.04L17.32,1L12,5.97v4.74c0.31-0.13,0.64-0.21,1-0.21C14.06,10.5,14.96,11.16,15.32,12.09z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M10.5,13c0-0.82,0.4-1.54,1.01-2H1v4l7,2l3.44-2.06C10.87,14.48,10.5,13.79,10.5,13z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M20.17,23L23,20.17l-3.54-6.36l-3.98-1c0,0.06,0.02,0.12,0.02,0.19c0,1.38-1.12,2.5-2.5,2.5c-0.36,0-0.69-0.08-1-0.21V21 c-1.1,0-2,0.9-2,2h6c0-1.1-0.9-2-2-2v-4.17L20.17,23z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/circle
      {:r "1.5", :cy "13", :cx "13", :stroke nil, :fill nil}))))))


(helix.core/defnc
 mode-fan-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M16.34,8.36l-2.29,0.82c-0.18-0.13-0.38-0.25-0.58-0.34c0.17-0.83,0.63-1.58,1.36-2.06C16.85,5.44,16.18,2,13.39,2 c-3.08,0-4.9,1.47-5.3,3.26L18.73,15.9c1.5,0.39,3.27-0.51,3.27-2.51C22,9,18.99,7.16,16.34,8.36z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M2.81,2.81L1.39,4.22L5.27,8.1C3.77,7.7,2,8.61,2,10.61c0,4.4,3.01,6.24,5.66,5.03l2.29-0.82 c0.18,0.13,0.38,0.25,0.58,0.34c-0.17,0.83-0.63,1.58-1.36,2.06C7.15,18.56,7.82,22,10.61,22c3.08,0,4.9-1.47,5.3-3.26l3.87,3.87 l1.41-1.41L2.81,2.81z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 sensor-door
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M20,2H4v20h16V2z M15.5,13.5c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5S17,11.17,17,12S16.33,13.5,15.5,13.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 gas-meter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,4h-5V2h-2v2h-2V2H9v2H4v18h16V4z M12,18c-1.38,0-2.5-1.1-2.5-2.46c0-1.09,0.43-1.39,2.5-3.79 c2.05,2.38,2.5,2.7,2.5,3.79C14.5,16.9,13.38,18,12,18z M16,10H8V8h8V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 blinds
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V3H4v16H2v2h20v-2H20z M16,9h2v2h-2V9z M14,11H6V9h8V11z M18,7h-2V5h2V7z M14,5v2H6V5H14z M6,19v-6h8v1.82 c-0.45,0.32-0.75,0.84-0.75,1.43c0,0.97,0.78,1.75,1.75,1.75s1.75-0.78,1.75-1.75c0-0.59-0.3-1.12-0.75-1.43V13h2v6H6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 roller-shades-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,19V3H4v16H2v2h8.25c0,0.97,0.78,1.75,1.75,1.75s1.75-0.78,1.75-1.75H22v-2H20z M6,19v-2h5v2H6z M13,19v-2h5v2H13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 propane-tank
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M4,15v3c0,2.21,1.79,4,4,4h8c2.21,0,4-1.79,4-4v-3H4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,13v-3c0-1.86-1.28-3.41-3-3.86V2H7v4.14c-1.72,0.45-3,2-3,3.86v3H20z M9,4h6v2h-2V5h-2v1H9V4z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-meter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2c-4.96,0-9,4.04-9,9c0,3.91,2.51,7.24,6,8.47V22h2v-2.06c0.33,0.04,0.66,0.06,1,0.06s0.67-0.02,1-0.06V22h2v-2.53 c3.49-1.24,6-4.57,6-8.47C21,6.04,16.96,2,12,2z M14.25,14l-3,3l-1.5-1.5L11,14.25L9.75,13l3-3l1.5,1.5L13,12.75L14.25,14z M16,9H8 V7h8V9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 nest-cam-wired-stand
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,0.85L11.98,1.4C8.95,1.7,6.37,4,6.04,7.03c-0.39,3.57,2.2,6.69,5.68,7.04l1.9,0.19l-0.56,0.85 c-0.88-0.19-1.83-0.18-2.85,0.25C8.21,16.21,7,18.25,7,20.41L7,23h10v-3c0-1.67-0.83-3.15-2.09-4.06l0.97-1.45L18,14.72V0.85z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 blinds-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V3H4v16H2v2h11.25c0,0.97,0.78,1.75,1.75,1.75s1.75-0.78,1.75-1.75H22v-2H20z M18,11h-2V9h2V11z M14,11H6V9h8V11z M14,13v2H6v-2H14z M16,13h2v2h-2V13z M18,7h-2V5h2V7z M14,5v2H6V5H14z M6,19v-2h8v2H6z M16,19v-2h2v2H16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 solar-power
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "3.33,16 11,16 11,13 4,13", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points "13,16 20.67,16 20,13 13,13", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points "21.11,18 13,18 13,22 22,22", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points "2,22 11,22 11,18 2.89,18", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "8",
      :x "11",
      :width "2",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.06",
      :x "16.53",
      :width "2",
      :transform
      "matrix(0.7071 -0.7071 0.7071 0.7071 -0.2089 14.6085)",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.56",
      :x "4.97",
      :width "3",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 -3.448 6.7885)",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "2", :x "3", :width "3", :height "2", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "2",
      :x "18",
      :width "3",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M12,7c2.76,0,5-2.24,5-5H7C7,4.76,9.24,7,12,7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-bolt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "15,2 2.5,13 13,14 8,21 9,22 21.5,11 11,10 16,3",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 oil-barrel
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,13v-2h-2V5h2V3H3v2h2v6H3v2h2v6H3v2h18v-2h-2v-6H21z M12,16c-1.66,0-3-1.32-3-2.95c0-1.3,0.52-1.67,3-4.55 c2.47,2.86,3,3.24,3,4.55C15,14.68,13.66,16,12,16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 curtains
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V3H4v16H2v2h20v-2H20z M8.19,12c2.04-1.35,3.5-3.94,3.76-7h0.09c0.26,3.06,1.72,5.65,3.76,7 c-2.04,1.35-3.5,3.94-3.76,7h-0.09C11.69,15.94,10.23,13.35,8.19,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 curtains-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M20,19V3H4v16H2v2h20v-2H20z M11,5h2v14h-2V5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 auto-mode
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.03,3.56c-1.67-1.39-3.74-2.3-6.03-2.51v2.01c1.73,0.19,3.31,0.88,4.61,1.92L19.03,3.56z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,3.06V1.05C8.71,1.25,6.64,2.17,4.97,3.56l1.42,1.42C7.69,3.94,9.27,3.25,11,3.06z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4.98,6.39L3.56,4.97C2.17,6.64,1.26,8.71,1.05,11h2.01C3.25,9.27,3.94,7.69,4.98,6.39z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.94,11h2.01c-0.21-2.29-1.12-4.36-2.51-6.03l-1.42,1.42C20.06,7.69,20.75,9.27,20.94,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "7,12 10.44,13.56 12,17 13.56,13.56 17,12 13.56,10.44 12,7 10.44,10.44",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,21c-3.11,0-5.85-1.59-7.46-4H7v-2H1v6h2v-2.7c1.99,2.84,5.27,4.7,9,4.7c4.87,0,9-3.17,10.44-7.56l-1.96-0.45 C19.25,18.48,15.92,21,12,21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sensor-window
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M18,4v16H6V4H18 M4,2v20h16V2H4z M7,19h10v-6H7V19z M10,10h4v1h3V5H7v6h3V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 heat-pump
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M12.75,7.08c0.82,0.12,1.57,0.44,2.2,0.91l-2.2,2.2V7.08z M11.25,7.08v3.11l-2.2-2.2 C9.68,7.52,10.43,7.2,11.25,7.08z M7.99,9.05l2.2,2.2H7.08C7.2,10.43,7.52,9.68,7.99,9.05z M7.08,12.75h3.11l-2.2,2.2 C7.52,14.32,7.2,13.57,7.08,12.75z M11.25,16.92c-0.82-0.12-1.57-0.44-2.2-0.91l2.2-2.2V16.92z M12,13c-0.55,0-1-0.45-1-1 c0-0.55,0.45-1,1-1s1,0.45,1,1C13,12.55,12.55,13,12,13z M12.75,16.92v-3.11l2.2,2.2C14.32,16.48,13.57,16.8,12.75,16.92z M16.01,14.95l-2.2-2.2h3.11C16.8,13.57,16.48,14.32,16.01,14.95z M13.81,11.25l2.2-2.2c0.47,0.64,0.79,1.39,0.91,2.2H13.81z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 propane
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16.75,6L16,6V3H8v3L7.25,6C3.97,6,1.1,8.53,1,11.82C0.9,15.21,3.62,18,7,18v3h2v-3h6v3h2v-3c3.38,0,6.1-2.79,6-6.18 C22.9,8.53,20.03,6,16.75,6z M10,5h4v1h-4V5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sensor-occupied
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,11c1.66,0,3-1.34,3-3s-1.34-3-3-3S9,6.34,9,8S10.34,11,12,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,12c-1.84,0-3.56,0.5-5.03,1.37C6.36,13.72,6,14.39,6,15.09V17h12v-1.91c0-0.7-0.36-1.36-0.97-1.72 C15.56,12.5,13.84,12,12,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.23,8.15l1.85-0.77c-1.22-2.91-3.55-5.25-6.46-6.46l-0.77,1.85C18.27,3.79,20.21,5.73,21.23,8.15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8.15,2.77L7.38,0.92C4.47,2.14,2.14,4.47,0.92,7.38l1.85,0.77C3.79,5.73,5.73,3.79,8.15,2.77z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.77,15.85l-1.85,0.77c1.22,2.91,3.55,5.25,6.46,6.46l0.77-1.85C5.73,20.21,3.79,18.27,2.77,15.85z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.85,21.23l0.77,1.85c2.91-1.22,5.25-3.55,6.46-6.46l-1.85-0.77C20.21,18.27,18.27,20.21,15.85,21.23z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 vertical-shades-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V3H4v16H2v2h20v-2H20z M13,5h1.5v14H13V5z M11,19H9.5V5H11V19z M6,5h1.5v14H6V5z M16.5,19V5H18v14H16.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 energy-savings-leaf
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,3c-4.8,0-9,3.86-9,9c0,2.12,0.74,4.07,1.97,5.61L3,19.59L4.41,21l1.97-1.97C7.93,20.26,9.88,21,12,21 c2.3,0,4.61-0.88,6.36-2.64C20.12,16.61,21,14.3,21,12V3H12z M10.5,17L10,16.5l2.5-3.5l-5-0.5l6-5.5L14,7.5L11.5,11l5,0.5L10.5,17 z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 vertical-shades
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M20,19V3H4v16H2v2h20v-2H20z M10,19V5h4v14H10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 broadcast-on-personal
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17,8c0.7,0,1.38,0.1,2.02,0.27L12,3L4,9v12h6.76C9.66,19.63,9,17.89,9,16C9,11.58,12.58,8,17,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,14.75c-0.69,0-1.25,0.56-1.25,1.25c0,0.4,0.2,0.75,0.5,0.97V22h1.5v-5.03c0.3-0.23,0.5-0.57,0.5-0.97 C18.25,15.31,17.69,14.75,17,14.75z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,12c-2.21,0-4,1.79-4,4c0,1.1,0.45,2.1,1.17,2.83l1.06-1.06c-0.45-0.45-0.73-1.08-0.73-1.77c0-1.38,1.12-2.5,2.5-2.5 s2.5,1.12,2.5,2.5c0,0.69-0.28,1.31-0.73,1.76l1.06,1.06C20.55,18.1,21,17.1,21,16C21,13.79,19.21,12,17,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,9.5c-3.59,0-6.5,2.91-6.5,6.5c0,1.79,0.73,3.42,1.9,4.6l1.06-1.06C12.56,18.63,12,17.38,12,16c0-2.76,2.24-5,5-5 s5,2.24,5,5c0,1.37-0.56,2.62-1.46,3.52l1.07,1.06c1.17-1.18,1.89-2.8,1.89-4.58C23.5,12.41,20.59,9.5,17,9.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shield-moon
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2L4,5v6.09c0,5.05,3.41,9.76,8,10.91c4.59-1.15,8-5.86,8-10.91V5L12,2z M15.97,14.41c-1.84,2.17-5.21,2.1-6.96-0.07 c-2.19-2.72-0.65-6.72,2.69-7.33c0.34-0.06,0.63,0.27,0.51,0.6c-0.46,1.23-0.39,2.64,0.32,3.86c0.71,1.22,1.89,1.99,3.18,2.2 C16.05,13.72,16.2,14.14,15.97,14.41z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 roller-shades
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V3H4v16H2v2h20v-2H20z M6,19v-6h5v1.8c-0.4,0.3-0.8,0.8-0.8,1.4c0,1,0.8,1.8,1.8,1.8s1.8-0.8,1.8-1.8 c0-0.6-0.3-1.1-0.8-1.4V13h5v6H6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 broadcast-on-home
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M22,9.76V4H4v2h16v2.59C20.73,8.88,21.4,9.28,22,9.76z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M9,9H2v11h7V9z M7,18H4v-7h3V18z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M17.75,16.97c0.3-0.23,0.5-0.57,0.5-0.97c0-0.69-0.56-1.25-1.25-1.25s-1.25,0.56-1.25,1.25c0,0.4,0.2,0.75,0.5,0.97V22 h1.5V16.97z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,13.5c1.38,0,2.5,1.12,2.5,2.5c0,0.69-0.28,1.31-0.73,1.76l1.06,1.06C20.55,18.1,21,17.1,21,16c0-2.21-1.79-4-4-4 c-2.21,0-4,1.79-4,4c0,1.1,0.45,2.1,1.17,2.83l1.06-1.06c-0.45-0.45-0.73-1.08-0.73-1.77C14.5,14.62,15.62,13.5,17,13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,9.5c-3.59,0-6.5,2.91-6.5,6.5c0,1.79,0.73,3.42,1.9,4.6l1.06-1.06C12.56,18.63,12,17.38,12,16c0-2.76,2.24-5,5-5 s5,2.24,5,5c0,1.37-0.56,2.62-1.46,3.52l1.07,1.06c1.17-1.18,1.89-2.8,1.89-4.58C23.5,12.41,20.59,9.5,17,9.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 device-unknown
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 1H5v22h14V1zm-2 18H7V5h10v14zM12 6.72c-1.96 0-3.5 1.52-3.5 3.47h1.75c0-.93.82-1.75 1.75-1.75s1.75.82 1.75 1.75c0 1.75-2.63 1.57-2.63 4.45h1.76c0-1.96 2.62-2.19 2.62-4.45 0-1.96-1.54-3.47-3.5-3.47zM11 16h2v2h-2v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-capslock
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8.41L16.59 13 18 11.59l-6-6-6 6L7.41 13 12 8.41zM6 18h12v-2H6v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 home-mini
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,5C4.19,5,2,9.48,2,12c0,3.86,3.13,7,6.99,7h6.02c2.69,0,6.99-2.08,6.99-7C22,12,22,5,12,5z M12,7c7.64,0,7.99,4.51,8,5 H4C4,11.8,4.09,7,12,7z M14.86,17H9.14c-2.1,0-3.92-1.24-4.71-3h15.15C18.78,15.76,16.96,17,14.86,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 tablet
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 4H1v16h21.99L23 4zm-4 14H5V6h14v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 headset
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.4 1.02C6.62 1.33 3 5.52 3 10.31V20h6v-8H5v-1.71C5 6.45 7.96 3.11 11.79 3 15.76 2.89 19 6.06 19 10v2h-4v8h6V10c0-5.17-4.36-9.32-9.6-8.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-double-arrow-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "17.59,18 19,16.59 14.42,12 19,7.41 17.59,6 11.59,12",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,18 12.41,16.59 7.83,12 12.41,7.41 11,6 5,12",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-double-arrow-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "6.41,6 5,7.41 9.58,12 5,16.59 6.41,18 12.41,12",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "13,6 11.59,7.41 16.17,12 11.59,16.59 13,18 19,12",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-hide
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 3H2.01L2 17h20V3zM11 6h2v2h-2V6zm0 3h2v2h-2V9zM8 6h2v2H8V6zm0 3h2v2H8V9zm-1 2H5V9h2v2zm0-3H5V6h2v2zm9 7H8v-2h8v2zm0-4h-2V9h2v2zm0-3h-2V6h2v2zm3 3h-2V9h2v2zm0-3h-2V6h2v2zm-7 15 4-4H8l4 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 monitor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M22,3H2v15h5l-1,1v2h12v-2l-1-1h5V3z M20,16H4V5h16V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 desktop-mac
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 2H1v16h9l-2 3v1h8v-1l-2-3h9V2zm-2 12H3V4h18v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 memory
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 9H9v6h6V9zm-2 4h-2v-2h2v2zm8-2V9h-2V5h-4V3h-2v2h-2V3H9v2H5v4H3v2h2v2H3v2h2v4h4v2h2v-2h2v2h2v-2h4v-4h2v-2h-2v-2h2zm-4 6H7V7h10v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M15.41 16.59L10.83 12l4.58-4.59L14 6l-6 6 6 6 1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 headset-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,4c3.87,0,7,3.13,7,7v1h-4v0.17l6,6V11c0-4.97-4.03-9-9-9C9.98,2,8.12,2.67,6.62,3.8l1.43,1.43C9.17,4.45,10.53,4,12,4 z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.1,2.1L0.69,3.51l3.33,3.33C3.37,8.09,3,9.5,3,11v9h6v-8H5v-1c0-0.94,0.19-1.83,0.52-2.65L15,17.83V20h2.17l1,1H12v2 h8.17l0.31,0.31l1.41-1.41L2.1,2.1z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sim-card
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.99 2H10L4 8v14h16l-.01-20zM9 19H7v-2h2v2zm8 0h-2v-2h2v2zm-8-4H7v-4h2v4zm4 4h-2v-4h2v4zm0-6h-2v-2h2v2zm4 2h-2v-4h2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 toys
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   {:display "none"}
   (helix.dom/rect
    {:y "0",
     :width "24",
     :height "24",
     :fill "none",
     :display "inline",
     :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.72,10l-2-6H7.28L5.81,8.4L4.41,7l1-1L4,4.59L0.59,8L2,9.41l1-1L4.59,10H2v8h2.18C4.59,19.16,5.7,20,7,20 c1.3,0,2.4-0.84,2.82-2h4.37c0.41,1.16,1.51,2,2.82,2c1.3,0,2.41-0.84,2.82-2H22v-8H18.72z M7,18c-0.55,0-1-0.45-1-1s0.45-1,1-1 s1,0.45,1,1S7.55,18,7,18z M11,10H7.41L7.39,9.98L8.72,6c0,0,0,0,0,0H11V10z M13,10V6h2.28l1.33,4H13z M17,18c-0.55,0-1-0.45-1-1 s0.45-1,1-1s1,0.45,1,1S17.55,18,17,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 security
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 speaker
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 2H5v19.99h14V2zm-7 2c1.1 0 2 .9 2 2s-.9 2-2 2c-1.11 0-2-.9-2-2s.89-2 2-2zm0 16c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 smartphone
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M5 1v22h14V1H5zm12 18H7V5h10v14z", :stroke nil, :fill nil})))


(helix.core/defnc
 keyboard-voice
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 15c1.66 0 2.99-1.34 2.99-3L15 6c0-1.66-1.34-3-3-3S9 4.34 9 6v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 15 6.7 12H5c0 3.42 2.72 6.23 6 6.72V22h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-command-key
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.5,3C15.57,3,14,4.57,14,6.5V8h-4V6.5C10,4.57,8.43,3,6.5,3S3,4.57,3,6.5S4.57,10,6.5,10H8v4H6.5 C4.57,14,3,15.57,3,17.5S4.57,21,6.5,21s3.5-1.57,3.5-3.5V16h4v1.5c0,1.93,1.57,3.5,3.5,3.5s3.5-1.57,3.5-3.5S19.43,14,17.5,14H16 v-4h1.5c1.93,0,3.5-1.57,3.5-3.5S19.43,3,17.5,3L17.5,3z M16,8V6.5C16,5.67,16.67,5,17.5,5S19,5.67,19,6.5S18.33,8,17.5,8H16L16,8 z M6.5,8C5.67,8,5,7.33,5,6.5S5.67,5,6.5,5S8,5.67,8,6.5V8H6.5L6.5,8z M10,14v-4h4v4H10L10,14z M17.5,19c-0.83,0-1.5-0.67-1.5-1.5 V16h1.5c0.83,0,1.5,0.67,1.5,1.5S18.33,19,17.5,19L17.5,19z M6.5,19C5.67,19,5,18.33,5,17.5S5.67,16,6.5,16H8v1.5 C8,18.33,7.33,19,6.5,19L6.5,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cast
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 3H1v5h2V5h18v14h-7v2h9V3zM1 18v3h3c0-1.66-1.34-3-3-3zm0-4v2c2.76 0 5 2.24 5 5h2c0-3.87-3.13-7-7-7zm0-4v2c4.97 0 9 4.03 9 9h2c0-6.08-4.93-11-11-11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phonelink-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4.56 4l-2.5-2.49L4.56 4zM24 8h-8v4.61l2 2V10h4v7h-1.61l3 3H24zm-2-2V4H7.39l2 2zM2.06 1.51L.65 2.92 2 4.27V17H0v3h17.73l2.35 2.35 1.41-1.41L2.06 1.51zM4 17V6.27L14.73 17H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-android
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M19 1H5v22h14V1zm-5 20h-4v-1h4v1zm3-3H7V4h10v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 developer-board-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M7.83,5H18v10.17L19.83,17H22v-2h-2v-2h2v-2h-2V9h2V7h-2V3H5.83L7.83,5z M12,9.17V7h4v3h-3.17L12,9.17z M9.83,7H11v1.17 L9.83,7z M13.83,11H16v2.17L13.83,11z M18.17,21l2.31,2.31l1.41-1.41L2.1,2.1L0.69,3.51L2,4.83V21H18.17z M4,19V6.83l2,2V12h3.17 l1,1H6v4h5v-3.17l1,1V17h2.17l2,2H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tablet-android
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 0H3v24h18V0zm-7 22h-4v-1h4v1zm5.25-3H4.75V3h14.5v16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 gamepad
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 7.5V2H9v5.5l3 3 3-3zM7.5 9H2v6h5.5l3-3-3-3zM9 16.5V22h6v-5.5l-3-3-3 3zM16.5 9l-3 3 3 3H22V9h-5.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 power-input
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M2 9v2h19V9H2zm0 6h5v-2H2v2zm7 0h5v-2H9v2zm7 0h5v-2h-5v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M23,4H1v17h22V4z M7,12v2H5v-2H7z M5,10V8h2v2H5z M11,12v2H9v-2H11z M9,10V8h2v2H9z M16,16v1H8v-1H16z M15,12v2h-2v-2H15z M13,10V8h2v2H13z M17,14v-2h2v2H17z M19,10h-2V8h2V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 laptop-windows
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M20 18v-1h1.99L22 3H2v14h2v1H0v2h24v-2h-4zM4 5h16v10H4V5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 speaker-group
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 1H8v17.99h12V1zm-6 2c1.1 0 2 .89 2 2s-.9 2-2 2-2-.89-2-2 .9-2 2-2zm0 13.5c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2.5", :cy "12.5", :cx "14", :stroke nil, :fill nil})
  (helix.dom/path {:d "M6 5H4v18h12v-2H6z", :stroke nil, :fill nil})))


(helix.core/defnc
 start
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M14.59,7.41L18.17,11H6v2h12.17l-3.59,3.59L16,18l6-6l-6-6L14.59,7.41z M2,6v12h2V6H2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 home-max
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,5H5C2.79,5,1,6.79,1,9v5c0,2.21,1.79,4,4,4h2v1h10v-1h2c2.21,0,4-1.79,4-4V9C23,6.79,21.21,5,19,5z M21,14 c0,1.1-0.9,2-2,2H5c-1.1,0-2-0.9-2-2V9c0-1.1,0.9-2,2-2h14c1.1,0,2,0.9,2,2V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 headphones
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,3c-4.97,0-9,4.03-9,9v9h6v-8H5v-1c0-3.87,3.13-7,7-7s7,3.13,7,7v1h-4v8h6v-9C21,7.03,16.97,3,12,3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 keyboard-return
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 7v4H5.83l3.58-3.59L8 6l-6 6 6 6 1.41-1.41L5.83 13H21V7h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phonelink
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M4 6h18V4H2v13H0v3h14v-3H4V6zm20 2h-8v12h8V8zm-2 9h-4v-7h4v7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-option-key
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "5",
      :x "15",
      :width "6",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "9,5 3,5 3,7 7.85,7 14.77,19 21,19 21,17 15.93,17",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 videogame-asset
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 6H1v12h22V6zm-12 7H8v3H6v-3H3v-2h3V8h2v3h3v2zm4.5 2c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4-3c-.83 0-1.5-.67-1.5-1.5S18.67 9 19.5 9s1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tv
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 3H1v16h7v2h8v-2h6.99L23 3zm-2 14H3V5h18v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 watch-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,7c2.76,0,5,2.24,5,5c0,0.64-0.13,1.25-0.35,1.82l1.5,1.5C18.69,14.33,19,13.2,19,12c0-2.22-1.03-4.19-2.64-5.47L15,2 H9L8.04,5.21l2.14,2.14C10.75,7.13,11.36,7,12,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.81,2.81L1.39,4.22l4.46,4.46C5.31,9.67,5,10.8,5,12c0,2.22,1.03,4.19,2.64,5.47L9,22h6l0.96-3.21l3.82,3.82l1.41-1.41 L2.81,2.81z M12,17c-2.76,0-5-2.24-5-5c0-0.64,0.13-1.25,0.35-1.82l6.47,6.47C13.25,16.87,12.64,17,12,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 smart-screen
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M1,5v14h22V5H1z M18,17H6V7h12V17z", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "11.25",
      :x "12.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11.25",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11.25",
      :x "10",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11.25",
      :x "7.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 mouse
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 1.07V9h7c0-4.08-3.05-7.44-7-7.93zM4 15c0 4.42 3.58 8 8 8s8-3.58 8-8v-4H4v4zm7-13.93C7.05 1.56 4 4.92 4 9h7V1.07z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-double-arrow-up
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "6,17.59 7.41,19 12,14.42 16.59,19 18,17.59 12,11.59",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "6,11 7.41,12.41 12,7.83 16.59,12.41 18,11 12,5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 browser-not-supported
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "19,6 19,16.5 21,18.5 21,4 6.5,4 8.5,6",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3.22,3.32L1.95,4.59L3,5.64L3,20h14.36l2.06,2.06l1.27-1.27L3.22,3.32z M15,18H5V7.64L15.36,18H15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 browser-updated
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,13v5h-5l1,1v2H6v-2l1-1H2V3l10,0v2L4,5v11h16v-3H22z M15,15l-5-5h4V3h2v7h4L15,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-down
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tablet-mac
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 0H2v24h19V0zm-9.5 23c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm7.5-4H4V3h15v16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 developer-board
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 9V7h-2V3H2v18h18v-4h2v-2h-2v-2h2v-2h-2V9h2zm-4 10H4V5h14v14zM6 13h5v4H6v-4zm6-6h4v3h-4V7zM6 7h5v5H6V7zm6 4h4v6h-4v-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-up
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6 1.41 1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 laptop-mac
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 18l1.99-2L22 3H2v13l2 2H0v2h24v-2h-4zM4 5h16v11H4V5zm8 14c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 point-of-sale
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M19,2H5c0,0,0,0,0,0v6c0,0,0,0,0,0h14c0,0,0,0,0,0L19,2C19,2,19,2,19,2z M17,6H7V4h10V6z M22,22H2c0,0,0,0,0,0v-3h20L22,22 C22,22,22,22,22,22z M18,9H6c0,0,0,0,0,0l-4,9h20L18,9z M10,16H8v-1h2V16z M10,14H8v-1h2V14z M10,12H8v-1h2V12z M13,16h-2v-1h2V16z M13,14h-2v-1h2V14z M13,12h-2v-1h2V12z M16,16h-2v-1h2V16z M16,14h-2v-1h2V14z M16,12h-2v-1h2V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 headset-mic
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.4 1.02C6.62 1.33 3 5.51 3 10.31V20h6v-8H5v-1.71C5 6.45 7.96 3.11 11.79 3 15.76 2.89 19 6.06 19 10v2h-4v8h4v1h-7v2h9V10c0-5.17-4.36-9.32-9.6-8.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 headphones-battery
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "20,7 20,6 18,6 18,7 16,7 16,18 22,18 22,7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,6c-3.31,0-6,2.69-6,6v6h4v-5H3.5v-1c0-2.48,2.02-4.5,4.5-4.5s4.5,2.02,4.5,4.5v1H10v5h4v-6C14,8.69,11.31,6,8,6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-control-key
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points "5,12 6.41,13.41 12,7.83 17.59,13.41 19,12 12,5",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cast-connected
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M1 18v3h3c0-1.66-1.34-3-3-3zm0-4v2c2.76 0 5 2.24 5 5h2c0-3.87-3.13-7-7-7zm18-7H5v1.63c3.96 1.28 7.09 4.41 8.37 8.37H19V7zM1 10v2c4.97 0 9 4.03 9 9h2c0-6.08-4.93-11-11-11zm22-7H1v5h2V5h18v14h-7v2h9V3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 watch
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 12c0-2.54-1.19-4.81-3.04-6.27L16 0H8l-.95 5.73C5.19 7.19 4 9.45 4 12s1.19 4.81 3.05 6.27L8 24h8l.96-5.73C18.81 16.81 20 14.54 20 12zM6 12c0-3.31 2.69-6 6-6s6 2.69 6 6-2.69 6-6 6-6-2.69-6-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 earbuds
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6.2,3.01C4.44,2.89,3,4.42,3,6.19L3,16c0,2.76,2.24,5,5,5h0c2.76,0,5-2.24,5-5V8c0-1.66,1.34-3,3-3h0c1.66,0,3,1.34,3,3 v7l-0.83,0c-1.61,0-3.06,1.18-3.17,2.79c-0.12,1.69,1.16,3.1,2.8,3.21c1.76,0.12,3.2-1.42,3.2-3.18L21,8c0-2.76-2.24-5-5-5h0 c-2.76,0-5,2.24-5,5v8c0,1.66-1.34,3-3,3l0,0c-1.66,0-3-1.34-3-3V9l0.83,0C7.44,9,8.89,7.82,9,6.21C9.11,4.53,7.83,3.11,6.2,3.01z",
      :stroke nil,
      :fill nil}))
   (helix.dom/rect
    {:y "3", :x "6", :width "3", :height "6", :stroke nil, :fill nil})
   (helix.dom/rect
    {:y "15",
     :x "15",
     :width "3",
     :height "6",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 keyboard-double-arrow-down
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "18,6.41 16.59,5 12,9.58 7.41,5 6,6.41 12,12.41",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "18,13 16.59,11.59 12,16.17 7.41,11.59 6,13 12,19",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 laptop-chromebook
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 18V3H2v15H0v2h24v-2h-2zm-8 0h-4v-1h4v1zm6-3H4V5h16v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cast-for-education
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 3H1v5h2V5h18v14h-7v2h9V3zM1 18v3h3c0-1.66-1.34-3-3-3zm0-4v2c2.76 0 5 2.24 5 5h2c0-3.87-3.13-7-7-7zm0-4v2c4.97 0 9 4.03 9 9h2c0-6.08-4.93-11-11-11zm10 1.09v2L14.5 15l3.5-1.91v-2L14.5 13 11 11.09zM14.5 6L9 9l5.5 3L20 9l-5.5-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 videogame-asset-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20.83,18H22V6H8.83L20.83,18z M17.5,9c0.83,0,1.5,0.67,1.5,1.5S18.33,12,17.5,12S16,11.33,16,10.5S16.67,9,17.5,9z M21.19,21.19L2.81,2.81L1.39,4.22L3.17,6H2v12h13.17l4.61,4.61L21.19,21.19z M9,13v2H7v-2H5v-2h2V9.83L10.17,13H9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 desktop-windows
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 2H1v16h9v2H8v2h8v-2h-2v-2h9V2zm-2 14H3V4h18v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-iphone
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 1H5v22h13V1zm-6.5 21c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5-4H7V4h9v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-tab
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.59 7.41L15.17 11H1v2h14.17l-3.59 3.59L13 18l6-6-6-6-1.41 1.41zM20 6v12h2V6h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 laptop
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M20,18l2-2V4H2v12l2,2H0v2h24v-2H20z M4,6h16v10H4V6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 device-hub
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 16l-4-4V8.82C14.16 8.4 15 7.3 15 6c0-1.66-1.34-3-3-3S9 4.34 9 6c0 1.3.84 2.4 2 2.82V12l-4 4H3v5h5v-3.05l4-4.2 4 4.2V21h5v-5h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 earbuds-battery
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "20,7 20,6 18,6 18,7 16,7 16,18 22,18 22,7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5.38,16.5L5.38,16.5c-1.04,0-1.88-0.84-1.88-1.87V10H6V6H4C2.9,6,2,6.9,2,8v6.63C2,16.49,3.51,18,5.37,18h0 c1.86,0,3.37-1.51,3.37-3.37V9.37c0-1.04,0.84-1.87,1.87-1.87h0c1.04,0,1.87,0.84,1.87,1.87V14H10v4h2c1.1,0,2-0.9,2-2V9.37 C14,7.51,12.49,6,10.63,6h0C8.76,6,7.25,7.51,7.25,9.37v5.25C7.25,15.66,6.41,16.5,5.38,16.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-backspace
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 11H6.83l3.58-3.59L9 6l-6 6 6 6 1.41-1.41L6.83 13H21v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 computer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M20 18l2-2V4H2v12l2 2H0v2h24v-2h-4zM4 6h16v10H4V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 adf-scanner
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,12h-4V4H6v8H2v8h20V12z M16,12H8V6h8V12z M18,17c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1 C19,16.55,18.55,17,18,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 scanner
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4.2 5l-.7 1.9L17.6 12H3v8h18v-8.86L4.2 5zM7 17H5v-2h2v2zm12 0H9v-2h10v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 smart-toy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,9V5h-5V2H9v3H4v4H1v6h3v6h16v-6h3V9H20z M7.5,11.5C7.5,10.67,8.17,10,9,10s1.5,0.67,1.5,1.5S9.83,13,9,13 S7.5,12.33,7.5,11.5z M16,17H8v-2h8V17z M15,13c-0.83,0-1.5-0.67-1.5-1.5S14.17,10,15,10s1.5,0.67,1.5,1.5S15.83,13,15,13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 devices-other
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 6h18V4H1v16h6v-2H3V6zm10 6H9v1.78c-.61.55-1 1.33-1 2.22 0 .89.39 1.67 1 2.22V20h4v-1.78c.61-.55 1-1.34 1-2.22s-.39-1.67-1-2.22V12zm-2 5.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM23 8h-8v12h8V8zm-2 10h-4v-8h4v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 connected-tv
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M8.57,16H10c0-2.76-2.24-5-5-5v1.43C6.97,12.43,8.57,14.03,8.57,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.55,16H13c0-4.42-3.59-8-8-8v1.45C8.61,9.45,11.55,12.38,11.55,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M5,14v2h2C7,14.89,6.11,14,5,14z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M22,3H2v16h6v2h8v-2h6V3z M20,17H4V5h16V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 smart-display
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M22,4H2v16h20V4z M9.5,16.5v-9l7,4.5L9.5,16.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 keyboard
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 5H2.01L2 19h20V5zM11 8h2v2h-2V8zm0 3h2v2h-2v-2zM8 8h2v2H8V8zm0 3h2v2H8v-2zm-1 2H5v-2h2v2zm0-3H5V8h2v2zm9 7H8v-2h8v2zm0-4h-2v-2h2v2zm0-3h-2V8h2v2zm3 3h-2v-2h2v2zm0-3h-2V8h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dock
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M8 23h8v-2H8v2zM18 1.01L6 1v18h12V1.01zM16 15H8V5h8v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M8.59 16.59L13.17 12 8.59 7.41 10 6l6 6-6 6-1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 router
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.2 5.9l.8-.8C19.6 3.7 17.8 3 16 3s-3.6.7-5 2.1l.8.8C13 4.8 14.5 4.2 16 4.2s3 .6 4.2 1.7zm-.9.8c-.9-.9-2.1-1.4-3.3-1.4s-2.4.5-3.3 1.4l.8.8c.7-.7 1.6-1 2.5-1s1.8.3 2.5 1l.8-.8zM21 13h-4V9h-2v4H3v8h18v-8zM8 18H6v-2h2v2zm3.5 0h-2v-2h2v2zm3.5 0h-2v-2h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _3k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M11,9v6H6.5v-1.5h3v-1h-2v-1h2v-1h-3V9H11z M18,15h-1.75l-1.75-2.25V15H13V9h1.5v2.25L16.25,9H18l-2.25,3 L18,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 music-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 3H1v18h22V3zm-2 16H3V5h18v14zM8 15c0-1.66 1.34-3 3-3 .35 0 .69.07 1 .18V6h5v2h-3v7.03c-.02 1.64-1.35 2.97-3 2.97-1.66 0-3-1.34-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 new-releases
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "m23 12-2.44-2.78.34-3.68-3.61-.82-1.89-3.18L12 3 8.6 1.54 6.71 4.72l-3.61.81.34 3.68L1 12l2.44 2.78-.34 3.69 3.61.82 1.89 3.18L12 21l3.4 1.46 1.89-3.18 3.61-.82-.34-3.68L23 12zm-10 5h-2v-2h2v2zm0-4h-2V7h2v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pause
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M6 19h4V5H6v14zm8-14v14h4V5h-4z", :stroke nil, :fill nil})))


(helix.core/defnc
 lyrics
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,9c0-2.04,1.24-3.79,3-4.57V4c0-1.1-0.9-2-2-2H4C2.9,2,2.01,2.9,2.01,4L2,22l4-4h9c1.1,0,2-0.9,2-2v-2.42 C15.24,12.8,14,11.05,14,9z M10,14H6v-2h4V14z M13,11H6V9h7V11z M13,8H6V6h7V8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,6.18C19.69,6.07,19.35,6,19,6c-1.66,0-3,1.34-3,3c0,1.66,1.34,3,3,3s3-1.34,3-3V3h2V1h-4V6.18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 playlist-add
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,10H3v2h11V10z M14,6H3v2h11V6z M18,14v-4h-2v4h-4v2h4v4h2v-4h4v-2H18z M3,16h7v-2H3V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 control-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.54 8.46L2 12l3.54 3.54 1.76-1.77L5.54 12l1.76-1.77zm12.92 0l-1.76 1.77L18.46 12l-1.76 1.77 1.76 1.77L22 12zm-6.46 10l-1.77-1.76-1.77 1.76L12 22l3.54-3.54-1.77-1.76zM8.46 5.54l1.77 1.76L12 5.54l1.77 1.76 1.77-1.76L12 2z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "3", :cy "12", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 hearing
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 20c-.29 0-.56-.06-.76-.15-.71-.37-1.21-.88-1.71-2.38-.51-1.56-1.47-2.29-2.39-3-.79-.61-1.61-1.24-2.32-2.53C9.29 10.98 9 9.93 9 9c0-2.8 2.2-5 5-5s5 2.2 5 5h2c0-3.93-3.07-7-7-7S7 5.07 7 9c0 1.26.38 2.65 1.07 3.9.91 1.65 1.98 2.48 2.85 3.15.81.62 1.39 1.07 1.71 2.05.6 1.82 1.37 2.84 2.73 3.55.51.23 1.07.35 1.64.35 2.21 0 4-1.79 4-4h-2c0 1.1-.9 2-2 2zM7.64 2.64L6.22 1.22C4.23 3.21 3 5.96 3 9s1.23 5.79 3.22 7.78l1.41-1.41C6.01 13.74 5 11.49 5 9s1.01-4.74 2.64-6.36zM11.5 9c0 1.38 1.12 2.5 2.5 2.5s2.5-1.12 2.5-2.5-1.12-2.5-2.5-2.5-2.5 1.12-2.5 2.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 note
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 10l-6-6H2v16h20V10zm-7-4.5l5.5 5.5H15V5.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-library
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M4 6H2v16h16v-2H4V6zm18-4H6v16h16V2zM12 14.5v-9l6 4.5-6 4.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _5g
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "17,13 19,13 19,15 14,15 14,9 21,9 21,7 12,7 12,17 21,17 21,11 17,11",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "3,13 8,13 8,15 3,15 3,17 10,17 10,11 5,11 5,9 10,9 10,7 3,7",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 surround-sound
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,4H2v16h20V4z M7.76,16.24l-1.41,1.41C4.78,16.1,4,14.05,4,12s0.78-4.1,2.34-5.66l1.41,1.41C6.59,8.93,6,10.46,6,12 S6.59,15.07,7.76,16.24z M12,16c-2.21,0-4-1.79-4-4s1.79-4,4-4s4,1.79,4,4S14.21,16,12,16z M17.66,17.66l-1.41-1.41 C17.41,15.07,18,13.54,18,12s-0.59-3.07-1.76-4.24l1.41-1.41C19.22,7.9,20,9.95,20,12S19.22,16.1,17.66,17.66z M12,10 c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S13.1,10,12,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 closed-caption-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    {:enable-background "new"}
    (helix.dom/path
     {:d
      "M21,4H3v16h18V4z M11,11H9.5v-0.5h-2v3h2V13H11v2H6V9h5V11z M18,11h-1.5v-0.5h-2v3h2V13H18v2h-5V9h5V11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 repeat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 7h10v3l4-4-4-4v3H5v6h2V7zm10 10H7v-3l-4 4 4 4v-3h12v-6h-2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _9k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,10h1.5v1.5H8V10z M21,3H3v18h18V3z M11,9v6H6.5v-1.5h3v-1h-3V9H11z M18,15h-1.75l-1.75-2.25V15H13V9h1.5v2.25L16.25,9 H18l-2.25,3L18,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sd
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2,4v16h20V4H2z M13,9h4c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1h-4V9z M9.5,13.5v-1H6V9h5v2H9.5v-0.5h-2v1H11V15H6v-2h1.5 v0.5H9.5z M14.5,13.5h2v-3h-2V13.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 pause-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 16h2V8H9v8zm3-14C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm1-4h2V8h-2v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 audio-file
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,2H4v20h16V8L14,2z M16,13h-3v3.75c0,1.24-1.01,2.25-2.25,2.25S8.5,17.99,8.5,16.75c0-1.24,1.01-2.25,2.25-2.25 c0.46,0,0.89,0.14,1.25,0.38V11h4V13z M13,9V3.5L18.5,9H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _2k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M10,12.5H7.5v1H10V15H6v-3.5h2.5v-1H6V9h4V12.5z M14.25,15l-1.75-2.25V15H11V9h1.5v2.25L14.25,9H16 l-2.25,3L16,15H14.25z M19,12.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 videocam
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M17 10.5V6H3v12h14v-4.5l4 4v-11l-4 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 movie
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 4l2 4h-3l-2-4h-2l2 4h-3l-2-4H8l2 4H7L5 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 library-music
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 2H6v16h16V2zm-4 5h-3v5.5c0 1.38-1.12 2.5-2.5 2.5S10 13.88 10 12.5s1.12-2.5 2.5-2.5c.57 0 1.08.19 1.5.51V5h4v2zM4 6H2v16h16v-2H4V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _10k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10,10.5h1.5v3H10V10.5z M21,3H3v18h18V3z M7.5,15H6v-4.5H4.5V9h3V15z M13,9v6H8.5V9H13z M19,15h-1.75l-1.75-2.25V15H14V9 h1.5v2.25L17.25,9H19l-2.25,3L19,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fiber-manual-record
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "8", :cy "12", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 shuffle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10.59 9.17L5.41 4 4 5.41l5.17 5.17 1.42-1.41zM14.5 4l2.04 2.04L4 18.59 5.41 20 17.96 7.46 20 9.5V4h-5.5zm.33 9.41l-1.41 1.41 3.13 3.13L14.5 20H20v-5.5l-2.04 2.04-3.13-3.13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pause-circle-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M11,16H9V8h2V16z M15,16h-2V8h2V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 radio
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 6.67V22h20V6H8.3l8.26-3.34L15.88 1 2 6.67zM7 20c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm13-8h-2v-2h-2v2H4V8h16v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay-circle-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M18,12.5c0,3.31-2.69,6-6,6s-6-2.69-6-6h2 c0,2.21,1.79,4,4,4s4-1.79,4-4s-1.79-4-4-4v3l-4-4l4-4v3C15.31,6.5,18,9.19,18,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _6k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M7.5,12.5h1V14h-1V12.5z M21,3H3v18h18V3z M10,10.5H7.5v1H10V15H6V9h4V10.5z M16,15h-1.75l-1.75-2.25V15H11V9h1.5v2.25 L14.25,9H16l-2.25,3L16,15z M19,12.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 high-quality
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 4H3v16h18V4zM11 15H9.5v-2h-2v2H6V9h1.5v2.5h2V9H11v6zm7 0h-1.75v1.5h-1.5V15H13V9h5v6zm-3.5-1.5h2v-3h-2v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove-from-queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 3H1v16h7v2h8v-2h7V3zm-2 14H3V5h18v12zm-5-7v2H8v-2h8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _4k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M11,13.5h-1V15H8.5v-1.5h-3V9H7v3h1.5V9H10v3h1V13.5z M14.75,15L13,12.75V15h-1.5V9H13v2.25L14.75,9h1.75 l-2.25,3l2.25,3H14.75z M19,12.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 hd
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3v18h18V3zM11 15H9.5v-2h-2v2H6V9h1.5v2.5h2V9H11v6zm2-6h4c.55 0 1 .45 1 1v4c0 .55-.45 1-1 1h-4V9zm1.5 4.5h2v-3h-2v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5V1L7 6l5 5V7c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6H4c0 4.42 3.58 8 8 8s8-3.58 8-8-3.58-8-8-8zm-1.31 8.9l.25-2.17h2.39v.71h-1.7l-.11.92c.03-.02.07-.03.11-.05s.09-.04.15-.05.12-.03.18-.04.13-.02.2-.02c.21 0 .39.03.55.1s.3.16.41.28.2.27.25.45.09.38.09.6c0 .19-.03.37-.09.54s-.15.32-.27.45-.27.24-.45.31-.39.12-.64.12c-.18 0-.36-.03-.53-.08s-.32-.14-.46-.24-.24-.24-.32-.39-.13-.33-.13-.53h.84c.02.18.08.32.19.41s.25.15.42.15c.11 0 .2-.02.27-.06s.14-.1.18-.17.08-.15.11-.25.03-.2.03-.31-.01-.21-.04-.31-.07-.17-.13-.24-.13-.12-.21-.15-.19-.05-.3-.05c-.08 0-.15.01-.2.02s-.11.03-.15.05-.08.05-.12.07-.07.06-.1.09l-.67-.16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 equalizer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10 20h4V4h-4v16zm-6 0h4v-8H4v8zM16 9v11h4V9h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-add-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M7,7h7v2H7V7z M10,15H7v-2h3V15z M7,12v-2h7v2H7z M19,15h-2v2h-2v-2h-2v-2h2v-2h2v2h2V15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 volume-down
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.5 12c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM5 9v6h4l5 5V4L9 9H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 slow-motion-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.05 9.79L10 7.5v9l3.05-2.29L16 12l-2.95-2.21zm0 0L10 7.5v9l3.05-2.29L16 12l-2.95-2.21zm0 0L10 7.5v9l3.05-2.29L16 12l-2.95-2.21zM11 4.07V2.05c-2.01.2-3.84 1-5.32 2.21L7.1 5.69c1.11-.86 2.44-1.44 3.9-1.62zM5.69 7.1L4.26 5.68C3.05 7.16 2.25 8.99 2.05 11h2.02c.18-1.46.76-2.79 1.62-3.9zM4.07 13H2.05c.2 2.01 1 3.84 2.21 5.32l1.43-1.43c-.86-1.1-1.44-2.43-1.62-3.89zm1.61 6.74C7.16 20.95 9 21.75 11 21.95v-2.02c-1.46-.18-2.79-.76-3.9-1.62l-1.42 1.43zM22 12c0 5.16-3.92 9.42-8.95 9.95v-2.02C16.97 19.41 20 16.05 20 12s-3.03-7.41-6.95-7.93V2.05C18.08 2.58 22 6.84 22 12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-pin
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.5 10.5h2v1h-2v-1zM22 4H2v16h20V4zM9 13H5.5v2H4V9h5v4zm3.5 2H11V9h1.5v6zm7.5 0h-1.2l-2.55-3.5V15H15V9h1.25l2.5 3.5V9H20v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "16.45,13.62 19,12 8,5 8,5.17", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points
      "2.81,2.81 1.39,4.22 8,10.83 8,19 12.99,15.82 19.78,22.61 21.19,21.19",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 playlist-remove
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,10H3v2h11V10z M14,6H3v2h11V6z M3,16h7v-2H3V16z M14.41,22L17,19.41L19.59,22L21,20.59L18.41,18L21,15.41L19.59,14 L17,16.59L14.41,14L13,15.41L15.59,18L13,20.59L14.41,22z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 play-circle-filled
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 14.5v-9l6 4.5-6 4.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 library-add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 6H2v16h16v-2H4V6zm18-4H6v16h16V2zm-3 9h-4v4h-2v-4H9V9h4V5h2v4h4v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _3k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M10,9v6H5.5v-1.5h3v-1h-2v-1h2v-1h-3V9H10z M16,15h-1.75l-1.75-2.25V15H11V9h1.5v2.25L14.25,9H16l-2.25,3 L16,15z M19,12.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 missed-video-call
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 10.5V6H3v12h14v-4.5l4 4v-11l-4 4zM10 15l-3.89-3.89v2.55H5V9.22h4.44v1.11H6.89l3.11 3.1 4.22-4.22.78.79-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 explicit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3H3v18h18V3zm-6 6h-4v2h4v2h-4v2h4v2H9V7h6v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 featured-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 3H1v18h22V3zm-11 9H3V5h9v7z", :stroke nil, :fill nil})))


(helix.core/defnc
 speed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.39 8.56l-1.24 1.86a8 8 0 0 1-.22 7.58H5.07A8 8 0 0 1 15.58 6.85l1.86-1.24A10 10 0 0 0 4 20h16a10 10 0 0 0 .38-11.44z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M10.59 15.41a2 2 0 0 0 2.83 0l5.66-8.49-8.49 5.66a2 2 0 0 0 0 2.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sort-by-alpha
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.94 4.66h-4.72l2.36-2.36 2.36 2.36zm-4.69 14.71h4.66l-2.33 2.33-2.33-2.33zM6.1 6.27L1.6 17.73h1.84l.92-2.45h5.11l.92 2.45h1.84L7.74 6.27H6.1zm-1.13 7.37l1.94-5.18 1.94 5.18H4.97zm10.76 2.5h6.12v1.59h-8.53v-1.29l5.92-8.56h-5.88v-1.6h8.3v1.26l-5.93 8.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,4H2v16h20V4z M4,9h10.5v3.5H4V9z M4,14.5h10.5V18L4,18V14.5z M20,18l-3.5,0V9H20V18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 mic-none
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 14c1.66 0 3-1.34 3-3V5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm-1-9c0-.55.45-1 1-1s1 .45 1 1v6c0 .55-.45 1-1 1s-1-.45-1-1V5zm6 6c0 2.76-2.24 5-5 5s-5-2.24-5-5H5c0 3.53 2.61 6.43 6 6.92V21h2v-3.08c3.39-.49 6-3.39 6-6.92h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay-10
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.99 5V1l-5 5 5 5V7c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6h-2c0 4.42 3.58 8 8 8s8-3.58 8-8-3.58-8-8-8zm-1.1 11h-.85v-3.26l-1.01.31v-.69l1.77-.63h.09V16zm4.28-1.76c0 .32-.03.6-.1.82s-.17.42-.29.57-.28.26-.45.33-.37.1-.59.1-.41-.03-.59-.1-.33-.18-.46-.33-.23-.34-.3-.57-.11-.5-.11-.82v-.74c0-.32.03-.6.1-.82s.17-.42.29-.57.28-.26.45-.33.37-.1.59-.1.41.03.59.1.33.18.46.33.23.34.3.57.11.5.11.82v.74zm-.85-.86c0-.19-.01-.35-.04-.48s-.07-.23-.12-.31-.11-.14-.19-.17-.16-.05-.25-.05-.18.02-.25.05-.14.09-.19.17-.09.18-.12.31-.04.29-.04.48v.97c0 .19.01.35.04.48s.07.24.12.32.11.14.19.17.16.05.25.05.18-.02.25-.05.14-.09.19-.17.09-.19.11-.32.04-.29.04-.48v-.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-arrow
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M8 5v14l11-7L8 5z", :stroke nil, :fill nil})))


(helix.core/defnc
 forward-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.95 13c0 3.31-2.69 6-6 6s-6-2.69-6-6 2.69-6 6-6v4l5-5-5-5v4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8h-2zm-5.52 2.15c-.05.07-.11.13-.18.17s-.17.06-.27.06c-.17 0-.31-.05-.42-.15s-.17-.24-.19-.41h-.84c.01.2.05.37.13.53s.19.28.32.39.29.19.46.24.35.08.53.08c.24 0 .46-.04.64-.12s.33-.18.45-.31.21-.28.27-.45.09-.35.09-.54c0-.22-.03-.43-.09-.6s-.14-.33-.25-.45-.25-.22-.41-.28-.34-.1-.55-.1c-.07 0-.14.01-.2.02s-.13.02-.18.04-.1.03-.15.05-.08.04-.11.05l.11-.92h1.7v-.71H10.9l-.25 2.17.67.17c.03-.03.06-.06.1-.09s.07-.05.12-.07.1-.04.15-.05.13-.02.2-.02c.12 0 .22.02.3.05s.16.09.21.15.1.14.13.24.04.19.04.31-.01.22-.03.31-.06.17-.11.24z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 queue-play-next
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 3H1v16h7v2h8v-2h2v-2H3V5h18v8h2V3zm-10 7V7h-2v3H8v2h3v3h2v-3h3v-2h-3zm11 8l-4.5 4.5L18 21l3-3-3-3 1.5-1.5L24 18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 volume-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4.34 2.93L2.93 4.34 7.29 8.7 7 9H3v6h4l5 5v-6.59l4.18 4.18c-.65.49-1.38.88-2.18 1.11v2.06c1.34-.3 2.57-.92 3.61-1.75l2.05 2.05 1.41-1.41L4.34 2.93zM19 12c0 .82-.15 1.61-.41 2.34l1.53 1.53c.56-1.17.88-2.48.88-3.87 0-4.28-2.99-7.86-7-8.77v2.06c2.89.86 5 3.54 5 6.71zm-7-8l-1.88 1.88L12 7.76zm4.5 8c0-1.77-1.02-3.29-2.5-4.03v1.79l2.48 2.48c.01-.08.02-.16.02-.24z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 interpreter-mode
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20.5,16.5c-0.83,0-1.5-0.67-1.5-1.5v-2.5c0-0.83,0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5V15C22,15.83,21.33,16.5,20.5,16.5z M20,20h1c0,0,0-1.54,0-1.54c1.69-0.24,3-1.7,3-3.46h-1c0,1.38-1.12,2.5-2.5,2.5S18,16.38,18,15h-1c0,1.76,1.31,3.22,3,3.46 C20,18.46,20,20,20,20z M9,12c-2.21,0-4-1.79-4-4c0-2.21,1.79-4,4-4c0.47,0,0.92,0.08,1.34,0.23C9.5,5.26,9,6.57,9,8 c0,1.43,0.5,2.74,1.34,3.77C9.92,11.92,9.47,12,9,12z M7.11,13.13C5.79,14.05,5,15.57,5,17.22V20H1v-2.78 c0-1.12,0.61-2.15,1.61-2.66C3.85,13.92,5.37,13.37,7.11,13.13z M11,8c0-2.21,1.79-4,4-4s4,1.79,4,4c0,2.21-1.79,4-4,4 S11,10.21,11,8z M18.32,20c-1.67-0.81-2.82-2.52-2.82-4.5c0-0.89,0.23-1.73,0.64-2.45C15.77,13.02,15.39,13,15,13 c-2.53,0-4.71,0.7-6.39,1.56C7.61,15.07,7,16.1,7,17.22V20L18.32,20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _1k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M9,15H7.5v-4.5H6V9h3V15z M13.75,15L12,12.75V15h-1.5V9H12v2.25L13.75,9h1.75l-2.25,3l2.25,3H13.75z M19,12.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 closed-caption
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 4H3v16h18V4zm-10 7H9.5v-.5h-2v3h2V13H11v2H6V9h5v2zm7 0h-1.5v-.5h-2v3h2V13H18v2h-5V9h5v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _4k
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3v18h18V3zm-9 10.51h-1V15H9.5v-1.5h-3V9H8v3h1.5V9H11v3h1v1.51zM18.2 15h-1.7l-2-3v3H13V9h1.5v3l2-3h1.7l-2 3 2 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-file
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,2H4v20h16V8L14,2z M13,9V3.5L18.5,9H13z M14,14l2-1.06v4.12L14,16v2H8v-6h6V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 videocam-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 16.61V6.5l-4 4V6h-6.61zM3.41 1.86L2 3.27 4.73 6H3v12h13.73l3 3 1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-add-check
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "10",
      :x "3",
      :width "11",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6",
      :x "3",
      :width "11",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "3",
      :width "7",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20.59,11.93 16.34,16.17 14.22,14.05 12.81,15.46 16.34,19 22,13.34",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 library-books
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 6H2v16h16v-2H4V6zm18-4H6v16h16V2zm-3 9H9V9h10v2zm-4 4H9v-2h6v2zm4-8H9V5h10v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mic
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,14c1.66,0,3-1.34,3-3V5c0-1.66-1.34-3-3-3S9,3.34,9,5v6C9,12.66,10.34,14,12,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,11c0,2.76-2.24,5-5,5s-5-2.24-5-5H5c0,3.53,2.61,6.43,6,6.92V21h2v-3.08c3.39-0.49,6-3.39,6-6.92H17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _5k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M10,10.5H7.5v1H10V15H6v-1.5h2.5v-1H6V9h4V10.5z M16,15h-1.75l-1.75-2.25V15H11V9h1.5v2.25L14.25,9H16 l-2.25,3L16,15z M19,12.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 forward-10
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,13c0,3.31-2.69,6-6,6s-6-2.69-6-6s2.69-6,6-6v4l5-5l-5-5v4c-4.42,0-8,3.58-8,8c0,4.42,3.58,8,8,8s8-3.58,8-8H18z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "10.9,16 10.9,11.73 10.81,11.73 9.04,12.36 9.04,13.05 10.05,12.74 10.05,16",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.32,11.78c-0.18-0.07-0.37-0.1-0.59-0.1s-0.41,0.03-0.59,0.1s-0.33,0.18-0.45,0.33s-0.23,0.34-0.29,0.57 s-0.1,0.5-0.1,0.82v0.74c0,0.32,0.04,0.6,0.11,0.82s0.17,0.42,0.3,0.57s0.28,0.26,0.46,0.33s0.37,0.1,0.59,0.1s0.41-0.03,0.59-0.1 s0.33-0.18,0.45-0.33s0.22-0.34,0.29-0.57s0.1-0.5,0.1-0.82V13.5c0-0.32-0.04-0.6-0.11-0.82s-0.17-0.42-0.3-0.57 S14.49,11.85,14.32,11.78z M14.33,14.35c0,0.19-0.01,0.35-0.04,0.48s-0.06,0.24-0.11,0.32s-0.11,0.14-0.19,0.17 s-0.16,0.05-0.25,0.05s-0.18-0.02-0.25-0.05s-0.14-0.09-0.19-0.17s-0.09-0.19-0.12-0.32s-0.04-0.29-0.04-0.48v-0.97 c0-0.19,0.01-0.35,0.04-0.48s0.06-0.23,0.12-0.31s0.11-0.14,0.19-0.17s0.16-0.05,0.25-0.05s0.18,0.02,0.25,0.05 s0.14,0.09,0.19,0.17s0.09,0.18,0.12,0.31s0.04,0.29,0.04,0.48V14.35z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 stop-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M16,16H8V8h8V16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 stop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M6 6h12v12H6V6z", :stroke nil, :fill nil})))


(helix.core/defnc
 repeat-one
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 7h10v3l4-4-4-4v3H5v6h2V7zm10 10H7v-3l-4 4 4 4v-3h12v-6h-2v4zm-4-2V9h-1l-2 1v1h1.5v4H13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 call-to-action
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 3H1v18h22V3zm-2 16H3v-3h18v3z", :stroke nil, :fill nil})))


(helix.core/defnc
 playlist-play
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "10",
      :x "3",
      :width "11",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6",
      :x "3",
      :width "11",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "3",
      :width "7",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "16,13 16,21 22,17", :stroke nil, :fill nil})))))


(helix.core/defnc
 _7k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M9.5,15H7.75l1.38-4.5H6.5V9h4.86L9.5,15z M18,15h-1.75l-1.75-2.25V15H13V9h1.5v2.25L16.25,9H18l-2.25,3 L18,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _7k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M8.5,15H6.75l1.38-4.5H5.5V9h4.86L8.5,15z M16,15h-1.75l-1.75-2.25V15H11V9h1.5v2.25L14.25,9H16l-2.25,3 L16,15z M19,12.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 subscriptions
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 8H4V6h16v2zm-2-6H6v2h12V2zm4 8v12H2V10h20zm-6 6l-6-3.27v6.53L16 16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fast-rewind
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M11 18V6l-8.5 6 8.5 6zm.5-6l8.5 6V6l-8.5 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M9.5,16.5v-9l7,4.5L9.5,16.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 mic-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 10.6V5c0-1.66-1.34-3-3-3-1.54 0-2.79 1.16-2.96 2.65L15 10.6zm4 .4h-1.7c0 .58-.1 1.13-.27 1.64l1.27 1.27c.44-.88.7-1.87.7-2.91zM4.41 2.86L3 4.27l6 6V11c0 1.66 1.34 3 3 3 .23 0 .44-.03.65-.08l1.66 1.66c-.71.33-1.5.52-2.31.52-2.76 0-5.3-2.1-5.3-5.1H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c.91-.13 1.77-.45 2.55-.9l4.2 4.2 1.41-1.41L4.41 2.86z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _6k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,12.5h1.5V14H8V12.5z M21,3H3v18h18V3z M11,10.5H8v1h3V15H6.5V9H11V10.5z M18,15h-1.75l-1.75-2.25V15H13V9h1.5v2.25 L16.25,9H18l-2.25,3L18,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 forward-30
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 13c0 3.31-2.69 6-6 6s-6-2.69-6-6 2.69-6 6-6v4l5-5-5-5v4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8h-2zm-7.46 2.22c-.06.05-.12.09-.2.12s-.17.04-.27.04c-.09 0-.17-.01-.25-.04s-.14-.06-.2-.11-.1-.1-.13-.17-.05-.14-.05-.22h-.85c0 .21.04.39.12.55s.19.28.33.38.29.18.46.23.35.07.53.07c.21 0 .41-.03.6-.08s.34-.14.48-.24.24-.24.32-.39.12-.33.12-.53c0-.23-.06-.44-.18-.61s-.3-.3-.54-.39c.1-.05.2-.1.28-.17s.15-.14.2-.22.1-.16.13-.25.04-.18.04-.27c0-.2-.04-.37-.11-.53s-.17-.28-.3-.38-.28-.18-.46-.23-.37-.08-.59-.08c-.19 0-.38.03-.54.08s-.32.13-.44.23-.23.22-.3.37-.11.3-.11.48h.85c0-.07.02-.14.05-.2s.07-.11.12-.15.11-.07.18-.1.14-.03.22-.03c.1 0 .18.01.25.04s.13.06.18.11.08.11.11.17.04.14.04.22c0 .18-.05.32-.16.43s-.26.16-.48.16h-.43v.66h.45c.11 0 .2.01.29.04s.16.06.22.11.11.12.14.2.05.18.05.29c0 .09-.01.17-.04.24s-.08.11-.13.17zm3.9-3.44c-.18-.07-.37-.1-.59-.1s-.41.03-.59.1-.33.18-.45.33-.23.34-.29.57-.1.5-.1.82v.74c0 .32.04.6.11.82s.17.42.3.57.28.26.46.33.37.1.59.1.41-.03.59-.1.33-.18.45-.33.22-.34.29-.57.1-.5.1-.82v-.74c0-.32-.04-.6-.11-.82s-.17-.42-.3-.57-.28-.26-.46-.33zm.01 2.57c0 .19-.01.35-.04.48s-.06.24-.11.32-.11.14-.19.17-.16.05-.25.05-.18-.02-.25-.05-.14-.09-.19-.17-.09-.19-.12-.32-.04-.29-.04-.48v-.97c0-.19.01-.35.04-.48s.06-.23.12-.31.11-.14.19-.17.16-.05.25-.05.18.02.25.05.14.09.19.17.09.18.12.31.04.29.04.48v.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-new
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 4H2v16h20V4zM8.5 15H7.3l-2.55-3.5V15H3.5V9h1.25l2.5 3.5V9H8.5v6zm5-4.74H11v1.12h2.5v1.26H11v1.11h2.5V15h-4V9h4v1.26zm7 4.74h-6V9h1.25v4.51h1.13V9.99h1.25v3.51h1.12V9h1.25v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 repeat-one-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,1H3C1.9,1,1,1.9,1,3v18c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V3C23,1.9,22.1,1,21,1z M19,19H7v3l-4-4l4-4v3h10v-4h2V19z M10,10.5V9h3v6h-1.5v-4.5H10z M17,10V7H7v4H5V5h12V2l4,4L17,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 add-to-queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 3H1v16h7v2h8v-2h7V3zm-2 14H3V5h18v12zm-5-7v2h-3v3h-2v-3H8v-2h3V7h2v3h3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _5k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M11,10.5H8v1h3V15H6.5v-1.5h3v-1h-3V9H11V10.5z M18,15h-1.75l-1.75-2.25V15H13V9h1.5v2.25L16.25,9H18 l-2.25,3L18,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _9k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M7.5,10h1v1.5h-1V10z M21,3H3v18h18V3z M10,9v6H6v-1.5h2.5v-1H6V9H10z M16,15h-1.75l-1.75-2.25V15H11V9h1.5v2.25L14.25,9 H16l-2.25,3L16,15z M19,12.5h-1.5V14h-1v-1.5H15v-1h1.5V10h1v1.5H19V12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 airplay
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M6,22h12l-6-6L6,22z M23,3H1v16h6v-2H3V5h18v12h-4v2h6V3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 replay-30
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5V1L7 6l5 5V7c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6H4c0 4.42 3.58 8 8 8s8-3.58 8-8-3.58-8-8-8zm-2.44 8.49h.45c.21 0 .37-.05.48-.16s.16-.25.16-.43c0-.08-.01-.15-.04-.22s-.06-.12-.11-.17-.11-.09-.18-.11-.16-.04-.25-.04c-.08 0-.15.01-.22.03s-.13.05-.18.1-.09.09-.12.15-.05.13-.05.2h-.85c0-.18.04-.34.11-.48s.17-.27.3-.37.27-.18.44-.23.35-.08.54-.08c.21 0 .41.03.59.08s.33.13.46.23.23.23.3.38.11.33.11.53c0 .09-.01.18-.04.27s-.07.17-.13.25-.12.15-.2.22-.17.12-.28.17c.24.09.42.21.54.39s.18.38.18.61c0 .2-.04.38-.12.53s-.18.29-.32.39-.29.19-.48.24-.38.08-.6.08c-.18 0-.36-.02-.53-.07s-.33-.12-.46-.23-.25-.23-.33-.38-.12-.34-.12-.55h.85c0 .08.02.15.05.22s.07.12.13.17.12.09.2.11.16.04.25.04c.1 0 .19-.01.27-.04s.15-.07.2-.12.1-.11.13-.18.04-.15.04-.24c0-.11-.02-.21-.05-.29s-.08-.15-.14-.2-.13-.09-.22-.11-.18-.04-.29-.04h-.47v-.65zm5.74.75c0 .32-.03.6-.1.82s-.17.42-.29.57-.28.26-.45.33-.37.1-.59.1-.41-.03-.59-.1-.33-.18-.46-.33-.23-.34-.3-.57-.11-.5-.11-.82v-.74c0-.32.03-.6.1-.82s.17-.42.29-.57.28-.26.45-.33.37-.1.59-.1.41.03.59.1.33.18.46.33.23.34.3.57.11.5.11.82v.74zm-.85-.86c0-.19-.01-.35-.04-.48s-.07-.23-.12-.31-.11-.14-.19-.17-.16-.05-.25-.05-.18.02-.25.05-.14.09-.19.17-.09.18-.12.31-.04.29-.04.48v.97c0 .19.01.35.04.48s.07.24.12.32.11.14.19.17.16.05.25.05.18-.02.25-.05.14-.09.19-.17.09-.19.11-.32c.03-.13.04-.29.04-.48v-.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hearing-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M6.03,3.2C7.15,2.44,8.51,2,10,2c3.93,0,7,3.07,7,7c0,1.26-0.38,2.65-1.07,3.9c-0.02,0.04-0.05,0.08-0.08,0.13l-1.48-1.48 C14.77,10.69,15,9.8,15,9c0-2.8-2.2-5-5-5C9.08,4,8.24,4.26,7.5,4.67L6.03,3.2z M17.21,14.38l1.43,1.43C20.11,13.93,21,11.57,21,9 c0-3.04-1.23-5.79-3.22-7.78l-1.42,1.42C17.99,4.26,19,6.51,19,9C19,11.02,18.33,12.88,17.21,14.38z M10,6.5 c-0.21,0-0.4,0.03-0.59,0.08l3.01,3.01C12.47,9.4,12.5,9.21,12.5,9C12.5,7.62,11.38,6.5,10,6.5z M21.19,21.19L2.81,2.81L1.39,4.22 l2.13,2.13C3.19,7.16,3,8.05,3,9h2c0-0.36,0.05-0.71,0.12-1.05l6.61,6.61c-0.88,0.68-1.78,1.41-2.27,2.9c-0.5,1.5-1,2.01-1.71,2.38 C7.56,19.94,7.29,20,7,20c-1.1,0-2-0.9-2-2H3c0,2.21,1.79,4,4,4c0.57,0,1.13-0.12,1.64-0.35c1.36-0.71,2.13-1.73,2.73-3.55 c0.32-0.98,0.9-1.43,1.71-2.05c0.03-0.02,0.05-0.04,0.08-0.06l6.62,6.62L21.19,21.19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 featured-play-list
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 3H1v18h22V3zm-11 8H3V9h9v2zm0-4H3V5h9v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 queue-music
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M15,6H3v2h12V6z M15,10H3v2h12V10z M3,16h8v-2H3V16z M17,6v8.18C16.69,14.07,16.35,14,16,14c-1.66,0-3,1.34-3,3s1.34,3,3,3 s3-1.34,3-3V8h3V6H17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 pause-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M11,16H9V8h2V16z M15,16h-2V8h2V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 volume-up
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM14 3.23v2.06c2.89.86 5 3.54 5 6.71s-2.11 5.85-5 6.71v2.06c4.01-.91 7-4.49 7-8.77s-2.99-7.86-7-8.77z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 av-timer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 17c0 .55.45 1 1 1s1-.45 1-1-.45-1-1-1-1 .45-1 1zm0-14v4h2V5.08c3.39.49 6 3.39 6 6.92 0 3.87-3.13 7-7 7s-7-3.13-7-7c0-1.68.59-3.22 1.58-4.42L12 13l1.41-1.41-6.8-6.8v.02C4.42 6.45 3 9.05 3 12c0 4.97 4.02 9 9 9 4.97 0 9-4.03 9-9s-4.03-9-9-9h-1zm7 9c0-.55-.45-1-1-1s-1 .45-1 1 .45 1 1 1 1-.45 1-1zM6 12c0 .55.45 1 1 1s1-.45 1-1-.45-1-1-1-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web-asset
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M3 4v16h18V4H3zm16 14H5V8h14v10z", :stroke nil, :fill nil})))


(helix.core/defnc
 video-label
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 3H1v18h22V3zm-2 13H3V5h18v11z", :stroke nil, :fill nil})))


(helix.core/defnc
 volume-mute
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M7 9v6h4l5 5V4l-5 5H7z", :stroke nil, :fill nil})))


(helix.core/defnc
 queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 6H2v16h16v-2H4V6zm18-4H6v16h16V2zm-3 9h-4v4h-2v-4H9V9h4V5h2v4h4v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-settings
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "3,6 21,6 21,11 23,11 23,4 1,4 1,20 12,20 12,18 3,18",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "15,12 9,8 9,16", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M22.72,17.57l1.23-0.98l-1.25-2.17L21.23,15c-0.23-0.17-0.48-0.31-0.75-0.42L20.25,13h-2.5l-0.24,1.58 c-0.26,0.11-0.51,0.26-0.74,0.42l-1.48-0.58l-1.25,2.17l1.24,0.99c-0.03,0.29-0.04,0.58-0.01,0.86l-1.23,0.98l1.25,2.17L16.77,21 c0.23,0.17,0.48,0.31,0.75,0.42L17.75,23h2.5l0.24-1.58c0.26-0.11,0.51-0.26,0.74-0.42l1.48,0.58l1.25-2.17l-1.24-0.99 C22.75,18.14,22.75,17.85,22.72,17.57z M19,19.5c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S19.83,19.5,19,19.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 snooze
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 11h3.63L9 15.2V17h6v-2h-3.63L15 10.8V9H9v2zm7.056-7.654l1.282-1.535 4.607 3.85-1.28 1.54zM3.336 7.19l-1.28-1.536L6.662 1.81l1.28 1.536zM12 6c3.86 0 7 3.14 7 7s-3.14 7-7 7-7-3.14-7-7 3.14-7 7-7m0-2c-4.97 0-9 4.03-9 9s4.03 9 9 9 9-4.03 9-9-4.03-9-9-9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 not-interested
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8 0-1.85.63-3.55 1.69-4.9L16.9 18.31C15.55 19.37 13.85 20 12 20zm6.31-3.1L7.1 5.69C8.45 4.63 10.15 4 12 4c4.42 0 8 3.58 8 8 0 1.85-.63 3.55-1.69 4.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-add-check-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10c5.52,0,10-4.48,10-10C22,6.48,17.52,2,12,2z M7,7h7v2H7V7z M7,10h7v2H7V10z M10,15H7v-2h3V15z M14.05,18.36l-2.83-2.83l1.41-1.41l1.41,1.41L17.59,12L19,13.41L14.05,18.36z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-smart-record
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "8", :cy "12", :cx "9", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M17 4.26v2.09c2.33.82 4 3.04 4 5.65s-1.67 4.83-4 5.65v2.09c3.45-.89 6-4.01 6-7.74s-2.55-6.85-6-7.74z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 branding-watermark
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 3H1v18h22V3zm-2 16h-9v-6h9v6z", :stroke nil, :fill nil})))


(helix.core/defnc
 subtitles
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 4H2v16h20V4zM4 12h4v2H4v-2zm10 6H4v-2h10v2zm6 0h-4v-2h4v2zm0-4H10v-2h10v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-call
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 10.5V6H3v12h14v-4.5l4 4v-11l-4 4zM14 13h-3v3H9v-3H6v-2h3V8h2v3h3v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,5V1L7,6l5,5V7c3.31,0,6,2.69,6,6s-2.69,6-6,6s-6-2.69-6-6H4c0,4.42,3.58,8,8,8s8-3.58,8-8S16.42,5,12,5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _8k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M7.5,12.5h1V14h-1V12.5z M7.5,10h1v1.5h-1V10z M21,3H3v18h18V3z M10,14c0,0.55-0.45,1-1,1H7c-0.55,0-1-0.45-1-1v-4 c0-0.55,0.45-1,1-1h2c0.55,0,1,0.45,1,1V14z M16,15h-1.75l-1.75-2.25V15H11V9h1.5v2.25L14.25,9H16l-2.25,3L16,15z M19,12.5h-1.5V14 h-1v-1.5H15v-1h1.5V10h1v1.5H19V12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 recent-actors
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 5v14h2V5h-2zm-4 14h2V5h-2v14zM15 5H1v14h14V5zM8 7.75c1.24 0 2.25 1.01 2.25 2.25S9.24 12.25 8 12.25 5.75 11.24 5.75 10 6.76 7.75 8 7.75zM12.5 17h-9v-.75c0-1.5 3-2.25 4.5-2.25s4.5.75 4.5 2.25V17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-dvr
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.5 10.5h2v1h-2v-1zm-13 0h2v3h-2v-3zM23 3H1v18h22V3zM8 13.5c0 .85-.65 1.5-1.5 1.5H3V9h3.5c.85 0 1.5.65 1.5 1.5v3zm4.62 1.5h-1.5L9.37 9h1.5l1 3.43 1-3.43h1.5l-1.75 6zM21 12.9h-.9L21 15h-1.5l-.85-2H17.5v2H16V9h5v3.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fast-forward
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M4,18l8.5-6L4,6V18z M13,6v12l8.5-6L13,6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 repeat-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,1H3C1.9,1,1,1.9,1,3v18c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V3C23,1.9,22.1,1,21,1z M19,19H7v3l-4-4l4-4v3h10v-4h2V19z M17,10V7H7v4H5V5h12V2l4,4L17,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 album
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 14.5c-2.49 0-4.5-2.01-4.5-4.5S9.51 7.5 12 7.5s4.5 2.01 4.5 4.5-2.01 4.5-4.5 4.5zm0-5.5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _1k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M10,15H8.5v-4.5H7V9h3V15z M17,15h-1.75l-1.75-2.25V15H12V9h1.5v2.25L15.25,9H17l-2.25,3L17,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 games
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 7.5V2H9v5.5l3 3 3-3zM7.5 9H2v6h5.5l3-3-3-3zM9 16.5V22h6v-5.5l-3-3-3 3zM16.5 9l-3 3 3 3H22V9h-5.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web-asset-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.83,4H22v15.17l-2-2V8h-9.17L6.83,4z M20.49,23.31L17.17,20H2V4.83L0.69,3.51L2.1,2.1l19.8,19.8L20.49,23.31z M15.17,18 l-10-10H4v10H15.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 skip-previous
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M6 6h2v12H6V6zm3.5 6l8.5 6V6l-8.5 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 shuffle-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M1,1v22h22V1H1z M5.41,4l5.18,5.17l-1.42,1.41L4,5.41L5.41,4z M20,20h-5.5l2.05-2.05l-3.13-3.13l1.41-1.41l3.13,3.13 L20,14.5V20z M20,9.5l-2.04-2.04L5.41,20L4,18.59L16.54,6.04L14.5,4H20V9.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 loop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 4V1L8 5l4 4V6c3.31 0 6 2.69 6 6 0 1.01-.25 1.97-.7 2.8l1.46 1.46C19.54 15.03 20 13.57 20 12c0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-1.01.25-1.97.7-2.8L5.24 7.74C4.46 8.97 4 10.43 4 12c0 4.42 3.58 8 8 8v3l4-4-4-4v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 closed-caption-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.83,4H21v14.17L17.83,15H18v-2h-1.5v0.5h-0.17l-1.83-1.83V10.5h2V11H18V9h-5v1.17L6.83,4z M19.78,22.61L17.17,20H3V5.83 L1.39,4.22l1.41-1.41l18.38,18.38L19.78,22.61z M11,13.83L10.17,13H9.5v0.5h-2v-3h0.17L6.17,9H6v6h5V13.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _2k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M8,12.5v1h3V15H6.5v-3.5h3v-1h-3V9H11v3.5H8z M18,15h-1.75l-1.75-2.25V15H13V9h1.5v2.25L16.25,9H18 l-2.25,3L18,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 library-add-check
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,2H6v16h16V2z M12.47,14L9,10.5l1.4-1.41l2.07,2.08L17.6,6L19,7.41L12.47,14z M4,6H2v16h16v-2H4V6z",
     :stroke nil,
     :fill nil})
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))))


(helix.core/defnc
 art-track
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 13h-8v-2h8v2zm0-6h-8v2h8V7zm-8 10h8v-2h-8v2zM12 7v10H2V7h10zm-1.5 8l-2.25-3-1.75 2.26-1.25-1.51L3.5 15h7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 skip-next
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M6 18l8.5-6L6 6v12zM16 6v12h2V6h-2z", :stroke nil, :fill nil})))


(helix.core/defnc
 play-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 16.5l6-4.5-6-4.5v9zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _8k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,12.5h1.5V14H8V12.5z M8,10h1.5v1.5H8V10z M21,3H3v18h18V3z M11,10v4c0,0.55-0.45,1-1,1H7.5c-0.55,0-1-0.45-1-1v-4 c0-0.55,0.45-1,1-1H10C10.55,9,11,9.45,11,10z M18,15h-1.75l-1.75-2.25V15H13V9h1.5v2.25L16.25,9H18l-2.25,3L18,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 folder-shared
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 6H12l-2-2H2v16h20V6zm-7 3c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zm4 8h-8v-1c0-1.33 2.67-2 4-2s4 .67 4 2v1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 snippet-folder
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M12,6l-2-2H2v16h20V6H12z M19,17l-6,0V9h3.5l2.5,2.5V17z M15.88,10.5l1.62,1.62v3.38l-3,0v-5H15.88z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 file-upload
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M5,10h4v6h6v-6h4l-7-7L5,10z M5,18v2h14v-2H5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 create-new-folder
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 6H12l-2-2H2v16h20V6zm-3 8h-3v3h-2v-3h-3v-2h3V9h2v3h3v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-open
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 6H12l-2-2H2v16h20V6zm-2 12H4V8h16v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 drive-file-move-rtl
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M22,6H12l-2-2H2v16h20V6z M12,17l-4-4l4-4v3h4v2h-4V17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 drive-file-move
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M22,6H12l-2-2H2v16h20V6z M12,17v-3H8v-2h4V9l4,4L12,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cloud-done
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM10 17l-3.5-3.5 1.41-1.41L10 14.18 15.18 9l1.41 1.41L10 17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cloud-queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4s1.79-4 4-4h.71C7.37 7.69 9.48 6 12 6c3.04 0 5.5 2.46 5.5 5.5v.5H19c1.66 0 3 1.34 3 3s-1.34 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-copy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "3,6 1,6 1,21 20,21 20,19 3,19", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M23,4h-9l-2-2H5.01L5,17h18V4z", :stroke nil, :fill nil})))))


(helix.core/defnc
 drive-file-rename-outline
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "15,16 11,20 21,20 21,16", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points "12.06,7.19 3,16.25 3,20 6.75,20 15.81,10.94",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4.08",
      :x "14.48",
      :width "3.59",
      :transform
      "matrix(0.7071 -0.7071 0.7071 0.7071 8.257289e-03 13.4765)",
      :height "5.3",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 download-done
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 18h14v2H5v-2zm4.6-2.7L5 10.7l2-1.9 2.6 2.6L17 4l2 2-9.4 9.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-delete
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,6v14H2V4h8l2,2H22z M16.5,10V9h-2v1H12v1.5h1V17h5v-5.5h1V10H16.5z M16.5,15.5h-2v-4h2V15.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 text-snippet
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21,9l-6-6H3v18h18V9z M7,7h7v2H7V7z M17,17H7v-2h10V17z M17,13H7v-2h10V13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cloud-download
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM17 13l-5 5-5-5h3V9h4v4h3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-download-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M9,6.17V3h6v6h4l-3.59,3.59L9,6.17z M21.19,21.19L2.81,2.81L1.39,4.22L6.17,9H5l7,7l0.59-0.59L15.17,18H5v2h12.17l2.61,2.61 L21.19,21.19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-open
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,2H4v20h11v-8h5V8L14,2z M13,9V3.5L18.5,9H13z M17,21.66V16h5.66v2h-2.24l2.95,2.95l-1.41,1.41L19,19.41l0,2.24H17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 attachment
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.5 16H7c-2.21 0-4-1.79-4-4s1.79-4 4-4h12.5c1.38 0 2.5 1.12 2.5 2.5S20.88 13 19.5 13H9c-.55 0-1-.45-1-1s.45-1 1-1h9.5V9.5H9c-1.38 0-2.5 1.12-2.5 2.5s1.12 2.5 2.5 2.5h10.5c2.21 0 4-1.79 4-4s-1.79-4-4-4H7c-3.04 0-5.5 2.46-5.5 5.5s2.46 5.5 5.5 5.5h11.5V16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cloud-upload
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM14 13v4h-4v-4H7l5-5 5 5h-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10 4H2v16h20V6H12l-2-2z", :stroke nil, :fill nil})))


(helix.core/defnc
 file-download-done
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "20.13,5.41 18.72,4 9.53,13.19 5.28,8.95 3.87,10.36 9.53,16.02",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "18",
      :x "5",
      :width "14",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cloud-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm4.5 14H8c-1.66 0-3-1.34-3-3s1.34-3 3-3h.14c.44-1.73 1.99-3 3.86-3 2.21 0 4 1.79 4 4h.5c1.38 0 2.5 1.12 2.5 2.5S17.88 16 16.5 16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 format-overline
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3v2H5V3H19z M12,7c-3.87,0-7,3.13-7,7c0,3.87,3.13,7,7,7s7-3.13,7-7C19,10.13,15.87,7,12,7z M12,18.5 c-2.49,0-4.5-2.01-4.5-4.5S9.51,9.5,12,9.5s4.5,2.01,4.5,4.5S14.49,18.5,12,18.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 download-for-offline
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.49,2,2,6.49,2,12s4.49,10,10,10s10-4.49,10-10S17.51,2,12,2z M11,10V6h2v4h3l-4,4l-4-4H11z M17,17H7v-2h10V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cloud-sync
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.5,14.98c-0.02,0-0.03,0-0.05,0.01C21.2,13.3,19.76,12,18,12c-1.4,0-2.6,0.83-3.16,2.02C13.26,14.1,12,15.4,12,17 c0,1.66,1.34,3,3,3l6.5-0.02c1.38,0,2.5-1.12,2.5-2.5S22.88,14.98,21.5,14.98z M10,4.26v2.09C7.67,7.18,6,9.39,6,12 c0,1.77,0.78,3.34,2,4.44V14h2v6H4v-2h2.73C5.06,16.54,4,14.4,4,12C4,8.27,6.55,5.15,10,4.26z M20,6h-2.73 c1.43,1.26,2.41,3.01,2.66,5l-2.02,0C17.68,9.64,16.98,8.45,16,7.56V10h-2V4h6V6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 newspaper
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,3l-1.67,1.67L18.67,3L17,4.67L15.33,3l-1.66,1.67L12,3l-1.67,1.67L8.67,3L7,4.67L5.33,3L3.67,4.67L2,3v18c0,0,0,0,0,0 l20,0V3z M11,19H4v-6h7V19z M20,19h-7v-2h7V19z M20,15h-7v-2h7V15z M20,11H4V8h16V11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 topic
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M12,6l-2-2H2v16h20V6H12z M14,16H6v-2h8V16z M18,12H6v-2h12V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 workspaces
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6,13c-2.2,0-4,1.8-4,4s1.8,4,4,4s4-1.8,4-4S8.2,13,6,13z M12,3C9.8,3,8,4.8,8,7s1.8,4,4,4s4-1.8,4-4S14.2,3,12,3z M18,13 c-2.2,0-4,1.8-4,4s1.8,4,4,4s4-1.8,4-4S20.2,13,18,13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 rule-folder
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M22,6H12l-2-2H2v16h20V6z M7.83,16L5,13.17l1.41-1.41l1.41,1.41l3.54-3.54l1.41,1.41L7.83,16z M17.41,13L19,14.59L17.59,16 L16,14.41L14.41,16L13,14.59L14.59,13L13,11.41L14.41,10L16,11.59L17.59,10L19,11.41L17.41,13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 folder-zip
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,6l-2-2H2v16h20V6H12z M18,12h-2v2h2v2h-2v2h-2v-2h2v-2h-2v-2h2v-2h-2V8h2v2h2V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 difference
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,23H2V7h2v14h14V23z M15,1H6.01L6,19h15V7L15,1z M16.5,15h-6v-2h6V15z M16.5,9h-2v2h-2V9h-2V7h2V5h2v2h2V9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 attach-email
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,10V2H1v16h13v-5c0-1.66,1.34-3,3-3H21z M11,11L3,6V4l8,5l8-5v2L11,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,14v4c0,1.1-0.9,2-2,2s-2-0.9-2-2v-4.5c0-0.28,0.22-0.5,0.5-0.5s0.5,0.22,0.5,0.5V18h2v-4.5c0-1.38-1.12-2.5-2.5-2.5 S15,12.12,15,13.5V18c0,2.21,1.79,4,4,4s4-1.79,4-4v-4H21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 download
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 downloading
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.32,4.26C16.84,3.05,15.01,2.25,13,2.05v2.02c1.46,0.18,2.79,0.76,3.9,1.62L18.32,4.26z M19.93,11h2.02 c-0.2-2.01-1-3.84-2.21-5.32L18.31,7.1C19.17,8.21,19.75,9.54,19.93,11z M18.31,16.9l1.43,1.43c1.21-1.48,2.01-3.32,2.21-5.32 h-2.02C19.75,14.46,19.17,15.79,18.31,16.9z M13,19.93v2.02c2.01-0.2,3.84-1,5.32-2.21l-1.43-1.43 C15.79,19.17,14.46,19.75,13,19.93z M13,12V7h-2v5H7l5,5l5-5H13z M11,19.93v2.02c-5.05-0.5-9-4.76-9-9.95s3.95-9.45,9-9.95v2.02 C7.05,4.56,4,7.92,4,12S7.05,19.44,11,19.93z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cloud
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-download
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M19,9h-4V3H9v6H5l7,7L19,9z M5,18v2h14v-2H5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 drive-folder-upload
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M22,6H12l-2-2H2v16h20V6z M13,13v4h-2v-4H8l4.01-4L16,13H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 upload-file
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,2H4v20h16V8L14,2z M13,15v4h-2v-4H8l4.01-4L16,15H13z M13,9V3.5L18.5,9H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 grid-view
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "3", :x "3", :width "8", :height "8", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "13",
      :x "3",
      :width "8",
      :height "8",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "3",
      :x "13",
      :width "8",
      :height "8",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "13",
      :x "13",
      :width "8",
      :height "8",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cloud-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M24 15c0-2.64-2.05-4.78-4.65-4.96C18.67 6.59 15.64 4 12 4c-1.33 0-2.57.36-3.65.97l1.49 1.49C10.51 6.17 11.23 6 12 6c3.04 0 5.5 2.46 5.5 5.5v.5H19c1.66 0 3 1.34 3 3 0 .99-.48 1.85-1.21 2.4l1.41 1.41c1.09-.92 1.8-2.27 1.8-3.81zM4.41 3.86L3 5.27l2.77 2.77h-.42C2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h11.73l2 2 1.41-1.41L4.41 3.86zM6 18c-2.21 0-4-1.79-4-4s1.79-4 4-4h1.73l8 8H6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 request-quote
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M14,2H4v20h16V8L14,2z M15,12h-4v1h4v5h-2v1h-2v-1H9v-2h4v-1H9v-5h2V9h2v1h2V12z M13,8V3.5L17.5,8H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 folder-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "12,6 10,4 6.83,4 22,19.17 22,6",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "2.1,2.1 0.69,3.51 2,4.83 2,20 17.17,20 20.49,23.31 21.9,21.9",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 upload
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M9 16h6v-6h4l-7-7-7 7h4v6zm-4 2h14v2H5v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 approval
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M4,14v8h16v-8H4z M18,18H6v-2h12V18z M12,2C9.24,2,7,4.24,7,7l5,7l5-7C17,4.24,14.76,2,12,2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 phone-callback
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.73 14.85l-2.52 2.52c-2.83-1.44-5.15-3.75-6.59-6.59l2.53-2.53L8.54 3H3.03C2.45 13.18 10.82 21.55 21 20.97v-5.51l-5.27-.61zM18 9h-2.59l5.02-5.02-1.41-1.41L14 7.59V5h-2v6h6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vibration
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M0 15h2V9H0v6zm3 2h2V7H3v10zm19-8v6h2V9h-2zm-3 8h2V7h-2v10zM18 3H6v18h12V3zm-2 16H8V5h8v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-paused
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 3h2v7h-2zm4 0h2v7h-2zm-5.79 14.37c-2.83-1.44-5.15-3.75-6.59-6.59l2.53-2.53L8.54 3H3.03C2.45 13.18 10.82 21.55 21 20.97v-5.51l-5.27-.61-2.52 2.52z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 power
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M16 7V3h-2v4h-4V3H8v4H6v7.5L9.5 18v3h5v-3l3.5-3.51V7h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wifi
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M1 9l2 2c4.97-4.97 13.03-4.97 18 0l2-2C16.93 2.93 7.08 2.93 1 9zm8 8l3 3 3-3c-1.65-1.66-4.34-1.66-6 0zm-4-4l2 2c2.76-2.76 7.24-2.76 10 0l2-2C15.14 9.14 8.87 9.14 5 13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-recline-extra
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.35 5.64c-.9-.64-1.12-1.88-.49-2.79.63-.9 1.88-1.12 2.79-.49.9.64 1.12 1.88.49 2.79-.64.9-1.88 1.12-2.79.49zM16 19H6.5L4 7H2l2.85 14H16v-2zm.23-4h-4.88l-1.03-4.1c1.58.89 3.28 1.54 5.15 1.22V9.99c-1.63.31-3.44-.27-4.69-1.25L9.14 7.47c-.23-.18-.49-.3-.76-.38-.32-.09-.66-.12-.99-.06h-.02c-1.23.22-2.05 1.39-1.84 2.61L7.44 18h9.24l3.82 3 1.5-1.5-5.77-4.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sms-failed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 2H2v20l4-4h16V2zm-9 12h-2v-2h2v2zm0-4h-2V6h2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-legroom-normal
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 15V3H3v14h11v-2H5zm17 3h-3v-7c0-1.1-.9-2-2-2h-5V3H6v11h10v7h6v-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-disturb-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11H7v-2h10v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 enhanced-encryption
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 8h-3V6.22c0-2.61-1.91-4.94-4.51-5.19C9.51.74 7 3.08 7 6v2H4v14h16V8zM8.9 6c0-1.71 1.39-3.1 3.1-3.1s3.1 1.39 3.1 3.1v2H8.9V6zM16 16h-3v3h-2v-3H8v-2h3v-3h2v3h3v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tap-and-play
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 16v2c2.76 0 5 2.24 5 5h2c0-3.87-3.13-7-7-7zm0 4v3h3c0-1.66-1.34-3-3-3zm0-8v2c4.97 0 9 4.03 9 9h2c0-6.08-4.92-11-11-11zM5 1v9.37c.69.16 1.36.37 2 .64V5h10v13h-3.03c.52 1.25.84 2.59.95 4H19V1H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-locked
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,5V4c0-1.1-0.9-2-2-2s-2,0.9-2,2v1h-1v5h6V5H20z M19,5h-2V4c0-0.55,0.45-1,1-1s1,0.45,1,1V5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,15l-5-1l-2.9,2.9c-2.5-1.43-4.57-3.5-6-6L10,8L9,3L3,3c0,3.28,0.89,6.35,2.43,9c1.58,2.73,3.85,4.99,6.57,6.57 c2.65,1.53,5.72,2.43,9,2.43L21,15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 do-not-disturb-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M17,13H7v-2h10V13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 do-disturb
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8 0-1.85.63-3.55 1.69-4.9L16.9 18.31C15.55 19.37 13.85 20 12 20zm6.31-3.1L7.1 5.69C8.45 4.63 10.15 4 12 4c4.42 0 8 3.58 8 8 0 1.85-.63 3.55-1.69 4.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 power-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 14.49V9c0-1.1-.9-2-2-2V3h-2v4h-3.88l7.69 7.69.19-.2zM10 3H8v1.88l2 2zm-5.88.84L2.71 5.25l3.34 3.34c-.03.13-.05.27-.05.4v5.51L9.5 18v3h5v-3l.48-.48 4.47 4.47 1.41-1.41L4.12 3.84z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 voice-chat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 2H2.01L2 22l4-4h16V2zm-4 12l-4-3.2V14H6V6h8v3.2L18 6v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-legroom-reduced
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.97 21H14v-3l1-4H6V3h6v6h5c1.1 0 2 .9 2 2l-2 7h2.97v3zM5 15V3H3v14h9v-2H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sms
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 2H2v20l4-4h16V2zM9 11H7V9h2v2zm4 0h-2V9h2v2zm4 0h-2V9h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sd-card
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 2H10L4 8v14h16V2zm-8 6h-2V4h2v4zm3 0h-2V4h2v4zm3 0h-2V4h2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync-problem
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 12c0 2.21.91 4.2 2.36 5.64L3 20h6v-6l-2.24 2.24C5.68 15.15 5 13.66 5 12c0-2.61 1.67-4.83 4-5.65V4.26C5.55 5.15 3 8.27 3 12zm8 5h2v-2h-2v2zM21 4h-6v6l2.24-2.24C18.32 8.85 19 10.34 19 12c0 2.61-1.67 4.83-4 5.65v2.09c3.45-.89 6-4.01 6-7.74 0-2.21-.91-4.2-2.36-5.64L21 4zm-10 9h2V7h-2v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-special
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 6H12l-2-2H2v16h20V6zm-4.06 11L15 15.28 12.06 17l.78-3.33-2.59-2.24 3.41-.29L15 8l1.34 3.14 3.41.29-2.59 2.24.78 3.33z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 network-locked
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 16v-.36c0-1.31-.94-2.5-2.24-2.63-1.5-.15-2.76 1.02-2.76 2.49v.5h-1v6h7v-6h-1zm-1 0h-3v-.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5v.5zm-1.5-5c.15 0 .3.01.46.02.01 0 .03.01.04.01V1L1 20h13v-6h1.26c.22-.63.58-1.2 1.06-1.68.85-.85 1.98-1.32 3.18-1.32z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 system-update
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M5 1v22h14V1H5zm12 18H7V5h10v14zm-1-6h-3V8h-2v5H8l4 4 4-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-disturb
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-4.42,0-8-3.58-8-8 c0-1.85,0.63-3.55,1.69-4.9L16.9,18.31C15.55,19.37,13.85,20,12,20z M18.31,16.9L7.1,5.69C8.45,4.63,10.15,4,12,4 c4.42,0,8,3.58,8,8C20,13.85,19.37,15.55,18.31,16.9z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 tv-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 7v10.88l2 2V5h-9.58l3.29-3.3L16 1l-4 4-4-4-.7.7L10.58 5H8.12l2 2zM2.41 2.13l-.14.14L1 3.54l1.53 1.53H1V21h17.46l1.99 1.99 1.26-1.26.15-.15L2.41 2.13zM3 19V7h1.46l12 12H3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-individual-suite
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 13c1.65 0 3-1.35 3-3S8.65 7 7 7s-3 1.35-3 3 1.35 3 3 3zm16-6H11v7H3V7H1v10h22V7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 time-to-leave
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.57 4H5.43L3 11v9h3v-2h12v2h3v-9l-2.43-7zM6.5 15c-.83 0-1.5-.67-1.5-1.5S5.67 12 6.5 12s1.5.67 1.5 1.5S7.33 15 6.5 15zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 10l1.5-4.5h11L19 10H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 live-tv
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 6h-9.59l3.29-3.29L16 2l-4 4-4-4-.71.71L10.59 6H1v16h22V6zm-2 14H3V8h18v12zM9 10v8l7-4-7-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wc
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M.01 0h24v24h-24V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.5 22v-7.5H4V7h7v7.5H9.5V22h-4zM18 22v-6h3l-3-9h-3l-3 9h3v6h3zM7.5 6c1.11 0 2-.89 2-2s-.89-2-2-2-2 .89-2 2 .89 2 2 2zm9 0c1.11 0 2-.89 2-2s-.89-2-2-2-2 .89-2 2 .89 2 2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vpn-lock
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 13c0 2.08-.8 3.97-2.1 5.39V17H14v-4H7v-2h3V8h4V3.46c-.95-.3-1.95-.46-3-.46C5.48 3 1 7.48 1 13s4.48 10 10 10 10-4.48 10-10c0-.34-.02-.67-.05-1h-2.03c.04.33.08.66.08 1zm-9 7.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L8 16v3h2v1.93zM22 4v-.36c0-1.31-.94-2.5-2.24-2.63C18.26.86 17 2.03 17 3.5V4h-1v6h7V4h-1zm-1 0h-3v-.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5V4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 account-tree
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/polygon
   {:points
    "22,11 22,3 15,3 15,6 9,6 9,3 2,3 2,11 9,11 9,8 11,8 11,18 15,18 15,21 22,21 22,13 15,13 15,16 13,16 13,8 15,8 15,11",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-in-talk
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 12h2c0-4.97-4.03-9-9-9v2c3.87 0 7 3.13 7 7zm-4 0h2c0-2.76-2.24-5-5-5v2c1.66 0 3 1.34 3 3zm-1.79 5.37c-2.83-1.44-5.15-3.75-6.59-6.59l2.53-2.53L8.54 3H3.03C2.45 13.18 10.82 21.55 21 20.97v-5.51l-5.27-.61-2.52 2.52z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-chat
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M2,2v20l4-4h16V2H2z M17,13l-2-1.99V14H7V6h8v2.99L17,7V13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 airline-seat-flat-angled
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21.56 16.18L9.2 11.71l2.08-5.66 12.35 4.47-2.07 5.66zM1.5 12.14L8 14.48V19h8v-1.63L20.52 19l.69-1.89-19.02-6.86-.69 1.89zm5.8-1.94c1.49-.72 2.12-2.51 1.41-4C7.99 4.71 6.2 4.08 4.7 4.8c-1.49.71-2.12 2.5-1.4 4 .71 1.49 2.5 2.12 4 1.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "13,7.5 16.5,11 15.17,12.34 18.62,15.79 22.41,12 12.01,1.58 8.21,5.38 13,10.17",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "m1.39 4.22 3.99 3.99L1.59 12l10.42 10.4 3.79-3.79 3.99 3.99 1.41-1.41L2.81 2.81 1.39 4.22zm8.6 8.6V15h-2v-4.18l2 2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 no-encryption-gmailerrorred
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none",
    :d "M0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0z",
    :stroke nil})
  (helix.dom/path
   {:d
    "M8.9 6c0-1.71 1.39-3.1 3.1-3.1s3.1 1.39 3.1 3.1v2h-4.66L20 17.56V8h-3V6.22c0-2.61-1.91-4.94-4.51-5.19-2.53-.25-4.72 1.41-5.32 3.7L8.9 6.46V6zM4.41 4.81L3 6.22 4.78 8H4v14h14.78l1 1 1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wifi-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 11l2-2c-3.73-3.73-8.87-5.15-13.7-4.31l2.58 2.58c3.3-.02 6.61 1.22 9.12 3.73zM9 17l3 3 3-3c-1.65-1.66-4.34-1.66-6 0zm10-4c-1.08-1.08-2.36-1.85-3.72-2.33l3.02 3.02.7-.69zM3.41 1.64L2 3.05 5.05 6.1C3.59 6.83 2.22 7.79 1 9l2 2c1.23-1.23 2.65-2.16 4.17-2.78l2.24 2.24C7.79 10.89 6.27 11.74 5 13l2 2c1.35-1.35 3.11-2.04 4.89-2.06l7.08 7.08 1.41-1.41L3.41 1.64z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 more
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M24 3H6l-6 9 6 9h18V3zM9 13.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm5 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm5 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mms
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 2H2v20l4-4h16V2zM5 14l3.5-4.5 2.5 3.01L14.5 8l4.5 6H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-disturb-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 11v2h-.88l4.33 4.33C21.43 15.79 22 13.96 22 12c0-5.52-4.48-10-10-10-1.96 0-3.79.57-5.33 1.55L14.12 11H17zM2.41 2.13L1 3.54l2.78 2.78C2.66 7.93 2 9.89 2 12c0 5.52 4.48 10 10 10 2.11 0 4.07-.66 5.68-1.78L20.46 23l1.41-1.41L2.41 2.13zM7 13v-2h1.46l2 2H7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-missed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23.32 16.67c-2.95-2.79-6.93-4.51-11.31-4.51-4.39 0-8.37 1.72-11.31 4.51l-.69.69L3.65 21l3.93-2.72-.01-3.49c1.4-.45 2.9-.7 4.44-.7 1.55 0 3.04.24 4.44.7l-.01 3.49L20.37 21l3.64-3.64c0-.01-.52-.52-.69-.69zM7 6.43l4.94 4.94 7.07-7.07-1.41-1.42-5.66 5.66L8.4 5H11V3H5v6h2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 network-check
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.9 5c-.17 0-.32.09-.41.23l-.07.15-5.18 11.65c-.16.29-.26.61-.26.96 0 1.11.9 2.01 2.01 2.01.96 0 1.77-.68 1.96-1.59l.01-.03L16.4 5.5c0-.28-.22-.5-.5-.5zM1 9l2 2c2.88-2.88 6.79-4.08 10.53-3.62l1.19-2.68C9.89 3.84 4.74 5.27 1 9zm20 2l2-2c-1.64-1.64-3.55-2.82-5.59-3.57l-.53 2.82c1.5.62 2.9 1.53 4.12 2.75zm-4 4l2-2c-.8-.8-1.7-1.42-2.66-1.89l-.55 2.92c.42.27.83.59 1.21.97zM5 13l2 2c1.13-1.13 2.56-1.79 4.03-2l1.28-2.88c-2.63-.08-5.3.87-7.31 2.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 adb
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 16c0 3.87 3.13 7 7 7s7-3.13 7-7v-4H5v4zM16.12 4.37l2.1-2.1-.82-.83-2.3 2.31C14.16 3.28 13.12 3 12 3s-2.16.28-3.09.75L6.6 1.44l-.82.83 2.1 2.1C6.14 5.64 5 7.68 5 10v1h14v-1c0-2.32-1.14-4.36-2.88-5.63zM9 9c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm6 0c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ondemand-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 3H1v16h7v2h8v-2h6.99L23 3zm-2 14H3V5h18v12zm-5-6l-7 4V7l7 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-forwarded
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 11l5-5-5-5v3h-4v4h4zm-4.79 6.37c-2.83-1.44-5.15-3.75-6.59-6.59l2.53-2.53L8.54 3H3.03C2.45 13.18 10.82 21.55 21 20.97v-5.51l-5.27-.61-2.52 2.52z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-encryption
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none",
    :d "M0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0z",
    :stroke nil})
  (helix.dom/path
   {:d
    "M8.9 6c0-1.71 1.39-3.1 3.1-3.1s3.1 1.39 3.1 3.1v2h-4.66L20 17.56V8h-3V6.22c0-2.61-1.91-4.94-4.51-5.19-2.53-.25-4.72 1.41-5.32 3.7L8.9 6.46V6zM4.41 4.81L3 6.22 4.78 8H4v14h14.78l1 1 1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 event-note
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 10H7v2h10v-2zm4-7h-3V1h-2v2H8V1H6v2H3v18h18V3zm-2 16H5V8h14v11zm-5-5H7v2h7v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sim-card-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d "M20,2H10L4,8v14h16V2z M13,17h-2v-2h2V17z M13,13h-2V8h2V13z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 do-disturb-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10 10-4.5 10-10S17.5 2 12 2zM4 12c0-4.4 3.6-8 8-8 1.8 0 3.5.6 4.9 1.7L5.7 16.9C4.6 15.5 4 13.8 4 12zm8 8c-1.8 0-3.5-.6-4.9-1.7L18.3 7.1C19.4 8.5 20 10.2 20 12c0 4.4-3.6 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 running-with-errors
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,10v8h-2v-8H22z M20,20v2h2v-2H20z M18,17.29C16.53,18.95,14.39,20,12,20c-4.41,0-8-3.59-8-8c0-4.41,3.59-8,8-8v9 l7.55-7.55C17.72,3.34,15.02,2,12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10c2.25,0,4.33-0.74,6-2V17.29z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-disturb-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,2C6.5,2,2,6.5,2,12s4.5,10,10,10s10-4.5,10-10S17.5,2,12,2z M4,12c0-4.4,3.6-8,8-8c1.8,0,3.5,0.6,4.9,1.7L5.7,16.9 C4.6,15.5,4,13.8,4,12z M12,20c-1.8,0-3.5-0.6-4.9-1.7L18.3,7.1C19.4,8.5,20,10.2,20,12C20,16.4,16.4,20,12,20z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 airline-seat-recline-normal
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.59 5.41c-.78-.78-.78-2.05 0-2.83s2.05-.78 2.83 0 .78 2.05 0 2.83c-.79.79-2.05.79-2.83 0zM6 19V7H4v14h11v-2H6zm14 1.07L14.93 15H11.5v-3.68c1.4 1.15 3.6 2.16 5.5 2.16v-2.16c-1.66.02-3.61-.87-4.67-2.04l-1.4-1.55c-.19-.21-.43-.38-.69-.5-.29-.14-.62-.23-.96-.23h-.03C8.01 7 7 8.01 7 9.25V18h8.07l3.5 3.5L20 20.07z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-disturb-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,11v2h-1.17l4.51,4.51C21.39,15.93,22,14.04,22,12c0-5.52-4.48-10-10-10C9.96,2,8.07,2.61,6.49,3.66L13.83,11H17z M1.39,4.22l2.27,2.27C2.61,8.07,2,9.96,2,12c0,5.52,4.48,10,10,10c2.04,0,3.93-0.61,5.51-1.66l2.27,2.27l1.41-1.41L2.81,2.81 L1.39,4.22z M7,11h1.17l2,2H7V11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 airline-seat-flat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 7v6H9V7h13zM2 14v2h6v2h8v-2h6v-2H2zm5.14-1.9c1.16-1.19 1.14-3.08-.04-4.24-1.19-1.16-3.08-1.14-4.24.04-1.16 1.19-1.14 3.08.04 4.24 1.19 1.16 3.08 1.14 4.24-.04z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sd-card-alert
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M20 2H10L4 8v14h16V2zm-7 15h-2v-2h2v2zm0-4h-2V8h2v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 disc-full
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 16h2v-2h-2v2zm0-9v5h2V7h-2zM10 4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8-3.58-8-8-8zm0 10c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 imagesearch-roller
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M20,2v6H6V6H4v4h10v5h2v8h-6v-8h2v-3H2V4h4V2H20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 personal-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 3H1v16h7v2h8v-2h6.99L23 3zm-2 14H3V5h18v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-bluetooth-speaker
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.71 9.5L17 7.21V11h.5l2.85-2.85L18.21 6l2.15-2.15L17.5 1H17v3.79L14.71 2.5l-.71.71L16.79 6 14 8.79l.71.71zM18 2.91l.94.94-.94.94V2.91zm0 4.3l.94.94-.94.94V7.21zm3 8.25l-5.27-.61-2.52 2.52c-2.83-1.44-5.15-3.75-6.59-6.59l2.53-2.53L8.54 3H3.03C2.45 13.18 10.82 21.55 21 20.97v-5.51z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-legroom-extra
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 3H2v14h11v-2H4zm18.24 12.96l-2.53 1.15-3.41-6.98C15.96 9.45 15.27 9 14.51 9H11V3H5v11h10l3.41 7 5.07-2.32-1.24-2.72z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M.01 0h24v24h-24V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 4V1L8 5l4 4V6c3.31 0 6 2.69 6 6 0 1.01-.25 1.97-.7 2.8l1.46 1.46C19.54 15.03 20 13.57 20 12c0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-1.01.25-1.97.7-2.8L5.24 7.74C4.46 8.97 4 10.43 4 12c0 4.42 3.58 8 8 8v3l4-4-4-4v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 event-busy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.31 17l2.44-2.44L14.19 17l1.06-1.06-2.44-2.44 2.44-2.44L14.19 10l-2.44 2.44L9.31 10l-1.06 1.06 2.44 2.44-2.44 2.44L9.31 17zM21 3h-3V1h-2v2H8V1H6v2H3.01L3 21h18V3zm-2 16H5V8h14v11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 event-available
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.53 11.06L15.47 10l-4.88 4.88-2.12-2.12-1.06 1.06L10.59 17l5.94-5.94zM21 3h-3V1h-2v2H8V1H6v2H3v18h18V3zm-2 16H5V8h14v11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 support-agent
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M18,11.03C17.52,8.18,15.04,6,12.05,6c-3.03,0-6.29,2.51-6.03,6.45c2.47-1.01,4.33-3.21,4.86-5.89 C12.19,9.19,14.88,11,18,11.03z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.99,12C20.88,6.63,16.68,3,12,3c-4.61,0-8.85,3.53-8.99,9H2v6h3v-5.81c0-3.83,2.95-7.18,6.78-7.29 c3.96-0.12,7.22,3.06,7.22,7V19h-8v2h10v-3h1v-6H20.99z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 bluetooth-audio
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.24 12.01l2.32 2.32c.28-.72.44-1.51.44-2.33s-.16-1.59-.43-2.31l-2.33 2.32zm5.29-5.3l-1.26 1.26c.63 1.21.98 2.57.98 4.02s-.36 2.82-.98 4.02l1.2 1.2c.97-1.54 1.54-3.36 1.54-5.31-.01-1.89-.55-3.67-1.48-5.19zm-3.82 1L10 2H9v7.59L4.41 5 3 6.41 8.59 12 3 17.59 4.41 19 9 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM11 5.83l1.88 1.88L11 9.59V5.83zm1.88 10.46L11 18.17v-3.76l1.88 1.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 confirmation-number
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 10V4H2.01v6c1.1 0 1.99.9 1.99 2s-.89 2-2 2v6h20v-6c-1.1 0-2-.9-2-2s.9-2 2-2zm-9 7.5h-2v-2h2v2zm0-4.5h-2v-2h2v2zm0-4.5h-2v-2h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync-disabled
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 6.35V4.26c-.66.17-1.29.43-1.88.75l1.5 1.5c.13-.05.25-.11.38-.16zM20 12c0-2.21-.91-4.2-2.36-5.64L20 4h-6v6l2.24-2.24C17.32 8.85 18 10.34 18 12c0 .85-.19 1.65-.51 2.38l1.5 1.5C19.63 14.74 20 13.41 20 12zM4.27 4L2.86 5.41l2.36 2.36C4.45 8.99 4 10.44 4 12c0 2.21.91 4.2 2.36 5.64L4 20h6v-6l-2.24 2.24C6.68 15.15 6 13.66 6 12c0-1 .25-1.94.68-2.77l8.08 8.08c-.25.13-.5.24-.76.34v2.09c.8-.21 1.55-.54 2.23-.96l2.58 2.58 1.41-1.41L4.27 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync-lock
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10,4.26v2.09C7.67,7.18,6,9.39,6,12c0,1.77,0.78,3.34,2,4.44V14h2v6H4v-2h2.73C5.06,16.54,4,14.4,4,12 C4,8.27,6.55,5.15,10,4.26z M20,4h-6v6h2V7.56c1.22,1.1,2,2.67,2,4.44h2c0-2.4-1.06-4.54-2.73-6H20V4z M20,17v-1c0-1.1-0.9-2-2-2 s-2,0.9-2,2v1c-0.55,0-1,0.45-1,1v3c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-3C21,17.45,20.55,17,20,17z M19,17h-2v-1 c0-0.55,0.45-1,1-1s1,0.45,1,1V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 drive-eta
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.92 5.01L18.57 4H5.43L3 11v9h3v-2h12v2h3v-9l-2.08-5.99zM6.5 15c-.83 0-1.5-.67-1.5-1.5S5.67 12 6.5 12s1.5.67 1.5 1.5S7.33 15 6.5 15zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 10l1.5-4.5h11L19 10H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 priority-high
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "2", :cy "19", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path {:d "M10 3h4v12h-4z", :stroke nil, :fill nil})))


(helix.core/defnc
 error-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M11 15h2v2h-2v-2zm0-8h2v6h-2V7zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-alert
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 23c1.1 0 1.99-.89 1.99-1.99h-3.98c0 1.1.89 1.99 1.99 1.99zm7-6v-6c0-3.35-2.36-6.15-5.5-6.83V1.5h-3v2.67C7.36 4.85 5 7.65 5 11v6l-2 2v1h18v-1l-2-2zm-3-3.99h-3v3h-2v-3H8V11h3V8h2v3h3v2.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 notification-important
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 23c1.1 0 1.99-.89 1.99-1.99h-3.98c0 1.1.89 1.99 1.99 1.99zm7-6v-6c0-3.35-2.36-6.15-5.5-6.83V1.5h-3v2.67C7.36 4.85 5 7.65 5 11v6l-2 2v1h18v-1l-2-2zm-6-1h-2v-2h2v2zm0-4h-2V8h2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 warning-amber
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 5.99L19.53 19H4.47L12 5.99M12 2L1 21h22L12 2zm1 14h-2v2h2v-2zm0-6h-2v4h2v-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 warning
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d "M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-delete
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "15,2 11.5,2 10.5,1 5.5,1 4.5,2 1,2 1,4 15,4",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,9c-0.7,0-1.37,0.1-2,0.29V5H2v14h7.68c1.12,2.36,3.53,4,6.32,4c3.87,0,7-3.13,7-7C23,12.13,19.87,9,16,9z M16,21 c-2.76,0-5-2.24-5-5s2.24-5,5-5s5,2.24,5,5S18.76,21,16,21z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "16.5,12 15,12 15,17 18.6,19.1 19.4,17.9 16.5,16.2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 error
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 child-care
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1.25", :cy "10.5", :cx "14.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.25", :cy "10.5", :cx "9.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 17c2.01 0 3.74-1.23 4.5-3h-9c.76 1.77 2.49 3 4.5 3zm10.94-5.66c-.25-1.51-1.36-2.74-2.81-3.17-.53-1.12-1.28-2.1-2.19-2.91C16.36 3.85 14.28 3 12 3s-4.36.85-5.94 2.26c-.92.81-1.67 1.8-2.19 2.91-1.45.43-2.56 1.65-2.81 3.17-.04.21-.06.43-.06.66 0 .23.02.45.06.66.25 1.51 1.36 2.74 2.81 3.17.52 1.11 1.27 2.09 2.17 2.89C7.62 20.14 9.71 21 12 21s4.38-.86 5.97-2.28c.9-.8 1.65-1.79 2.17-2.89 1.44-.43 2.55-1.65 2.8-3.17.04-.21.06-.43.06-.66 0-.23-.02-.45-.06-.66zM19 14c-.1 0-.19-.02-.29-.03-.2.67-.49 1.29-.86 1.86C16.6 17.74 14.45 19 12 19s-4.6-1.26-5.85-3.17c-.37-.57-.66-1.19-.86-1.86-.1.01-.19.03-.29.03-1.1 0-2-.9-2-2s.9-2 2-2c.1 0 .19.02.29.03.2-.67.49-1.29.86-1.86C7.4 6.26 9.55 5 12 5s4.6 1.26 5.85 3.17c.37.57.66 1.19.86 1.86.1-.01.19-.03.29-.03 1.1 0 2 .9 2 2s-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 microwave
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.8,10.61L5.37,9.19C5.73,8.79,6.59,8,7.75,8c0.8,0,1.39,0.39,1.81,0.67C9.87,8.88,10.07,9,10.25,9 c0.37,0,0.8-0.41,0.95-0.61l1.42,1.42c-0.36,0.4-1.22,1.19-2.37,1.19c-0.79,0-1.37-0.38-1.79-0.66C8.13,10.12,7.94,10,7.75,10 C7.38,10,6.95,10.41,6.8,10.61z M7.75,15c0.19,0,0.38,0.12,0.71,0.34c0.42,0.28,1,0.66,1.79,0.66c1.16,0,2.01-0.79,2.37-1.19 l-1.42-1.42c-0.15,0.2-0.59,0.61-0.95,0.61c-0.18,0-0.38-0.12-0.69-0.33C9.14,13.39,8.55,13,7.75,13c-1.16,0-2.02,0.79-2.38,1.19 l1.42,1.42C6.95,15.41,7.38,15,7.75,15z M22,4v16H2V4H22z M14,6H4v12h10V6z M19,16c0-0.55-0.45-1-1-1c-0.55,0-1,0.45-1,1 c0,0.55,0.45,1,1,1C18.55,17,19,16.55,19,16z M19,12c0-0.55-0.45-1-1-1c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1 C18.55,13,19,12.55,19,12z M19,7h-2v2h2V7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 meeting-room
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M14 6v15H3v-2h2V3h9v1h5v15h2v2h-4V6h-3zm-4 5v2h2v-2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cottage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,3L6,7.58V6H4v3.11L1,11.4l1.21,1.59L4,11.62V21h7v-6h2v6h7v-9.38l1.79,1.36L23,11.4L12,3z M10,1c0,1.66-1.34,3-3,3 C6.45,4,6,4.45,6,5H4c0-1.66,1.34-3,3-3c0.55,0,1-0.45,1-1H10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 beach-access
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.95 5.98c-3.94 3.95-3.93 10.35.02 14.3l2.86-2.86C5.7 14.29 4.65 9.91 5.95 5.98zm11.47 2.85l2.86-2.86c-3.95-3.95-10.35-3.96-14.3-.02 3.93-1.3 8.31-.25 11.44 2.88zM5.97 5.96l-.01.01c-.38 3.01 1.17 6.88 4.3 10.02l5.73-5.73c-3.13-3.13-7.01-4.68-10.02-4.3zm7.156 8.6l1.428-1.428 6.442 6.442-1.43 1.428z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dry
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M1,12.68V23h18v-2.5h-7v-1h9V17h-9v-1h10v-2.5H12v-1h8V10H8.86l1.88-3.3L9.12,5L1,12.68z M15.65,4.86l-0.07-0.07 c-0.57-0.62-0.82-1.41-0.67-2.2L15,2h-1.89l-0.06,0.43c-0.2,1.36,0.27,2.71,1.3,3.72l0.07,0.06c0.57,0.62,0.82,1.41,0.67,2.2 L14.98,9h1.91l0.06-0.43C17.16,7.21,16.68,5.86,15.65,4.86z M19.65,4.86l-0.07-0.07c-0.57-0.62-0.82-1.41-0.67-2.2L19,2h-1.89 l-0.06,0.43c-0.2,1.36,0.27,2.71,1.3,3.72l0.07,0.06c0.57,0.62,0.82,1.41,0.67,2.2L18.98,9h1.91l0.06-0.43 C21.16,7.21,20.68,5.86,19.65,4.86z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 water-damage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,3L2,12h3v8h14v-8h3L12,3z M12,16c-1.1,0-2-0.9-2-2c0-1.1,2-4,2-4s2,2.9,2,4C14,15.1,13.1,16,12,16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fire-extinguisher
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M7,19h10v3H7V19z M7,18h10v-5H7V18z M17,3v6l-3.15-0.66c-0.01,0-0.01,0.01-0.02,0.02c1.55,0.62,2.72,1.98,3.07,3.64H7.1 c0.34-1.66,1.52-3.02,3.07-3.64c-0.33-0.26-0.6-0.58-0.8-0.95L5,6.5v-1l4.37-0.91C9.87,3.65,10.86,3,12,3 c0.7,0,1.34,0.25,1.85,0.66L17,3z M13,6c-0.03-0.59-0.45-1-1-1s-1,0.45-1,1s0.45,1,1,1S13,6.55,13,6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 vape-free
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2,16.5h1c1.33,0,2.71-0.18,4-0.5v3c-1.29-0.32-2.67-0.5-4-0.5H2V16.5z M16.17,19H8v-3h5.17L1.39,4.22l1.41-1.41 l18.38,18.38l-1.41,1.41L16.17,19z M18.83,16H22v3h-0.17L18.83,16z M11,17.5c0-0.28-0.22-0.5-0.5-0.5S10,17.22,10,17.5 c0,0.28,0.22,0.5,0.5,0.5S11,17.78,11,17.5z M22,12.76V15h-1.5v-2.23c0-2.24-1.76-4.07-4-4.07V7.2c1.02,0,1.85-0.83,1.85-1.85 S17.52,3.5,16.5,3.5V2c1.85,0,3.35,1.5,3.35,3.35c0,0.93-0.38,1.77-1,2.38C20.72,8.62,22,10.54,22,12.76z M11.15,8.32 c0-0.01,0-0.01,0-0.02c0-1.85,1.5-3.35,3.35-3.35v1.5c-1.02,0-1.85,0.73-1.85,1.75s0.83,2,1.85,2h1.53c1.87,0,3.47,1.35,3.47,3.16 V15H18v-1.3c0-1.31-0.92-2.05-1.97-2.05H14.5c-0.01,0-0.01,0-0.02,0L11.15,8.32z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 rv-hookup
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 17V9H7V7l-3 3 3 3v-2h4v3H4v5h4c0 1.66 1.34 3 3 3s3-1.34 3-3h8v-2h-2zm-9 3c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm7-6h-4v-3h4v3zM17 2v2H9v2h8v2l3-3-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 balcony
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M10,10v2H8v-2H10z M16,12v-2h-2v2H16z M21,14v8H3v-8h1v-4c0-4.42,3.58-8,8-8s8,3.58,8,8v4H21z M7,16H5v4h2V16z M11,16H9v4h2 V16z M11,4.08C8.16,4.56,6,7.03,6,10v4h5V4.08z M13,14h5v-4c0-2.97-2.16-5.44-5-5.92V14z M15,16h-2v4h2V16z M19,16h-2v4h2V16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tty
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M20,15v6c-3.28,0-6.35-0.89-9-2.43C8.27,16.99,6.01,14.73,4.43,12C2.89,9.35,2,6.28,2,3h6l1,5l-2.9,2.9 c1.43,2.5,3.5,4.57,6,6L15,14L20,15z M14,6h2V4h-2V6z M13,9h2V7h-2V9z M11,6h2V4h-2V6z M18,7h-2v2h2V7z M19,4h-2v2h2V4z M21,7h-2v2 h2V7z M22,4h-2v2h2V4z M14,12h2v-2h-2V12z M11,12h2v-2h-2V12z M19,10h-2v2h2V10z M22,10h-2v2h2V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 room-service
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 17h20v2H2v-2zm11.84-9.21c.1-.24.16-.51.16-.79 0-1.1-.9-2-2-2s-2 .9-2 2c0 .28.06.55.16.79C6.25 8.6 3.27 11.93 3 16h18c-.27-4.07-3.25-7.4-7.16-8.21z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-touch
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M13,10.17l-2.5-2.5V1H13V10.17z M20,4h-2.5v7h-1V2H14v9.17l6,6V4z M9.5,3H7.01v1.18L9.5,6.67V3z M21.19,21.19L2.81,2.81 L1.39,4.22L7,9.83v4.3l-3.32-1.9L2,13.88L9.68,22h9.54l0.56,0.61L21.19,21.19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 storefront
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.9,8.89L20.49,3h-3.75h-2.01H13h-2H9.28H7.26H3.51L2.1,8.89c-0.24,1.02-0.02,2.06,0.62,2.88 C2.8,11.88,2.91,11.96,3,12.06V21h18v-8.94c0.09-0.09,0.2-0.18,0.28-0.28C21.92,10.96,22.15,9.91,21.9,8.89z M7.02,5L6.44,9.86 C6.36,10.51,5.84,11,5.23,11c-0.49,0-0.8-0.29-0.93-0.47c-0.26-0.33-0.35-0.76-0.25-1.17L5.09,5H7.02z M18.91,5l1.05,4.36 c0.1,0.42,0.01,0.84-0.25,1.17C19.57,10.71,19.27,11,18.77,11c-0.61,0-1.14-0.49-1.21-1.14L16.98,5H18.91z M15.51,9.52 c0.05,0.39-0.07,0.78-0.33,1.07C14.95,10.85,14.63,11,14.22,11C13.55,11,13,10.41,13,9.69V5h1.96L15.51,9.52z M11,9.69 C11,10.41,10.45,11,9.71,11c-0.34,0-0.65-0.15-0.89-0.41C8.57,10.3,8.45,9.91,8.49,9.52L9.04,5H11V9.69z M5,19v-6.03 C5.08,12.98,5.15,13,5.23,13c0.87,0,1.66-0.36,2.24-0.95c0.6,0.6,1.4,0.95,2.31,0.95c0.87,0,1.65-0.36,2.23-0.93 c0.59,0.57,1.39,0.93,2.29,0.93c0.84,0,1.64-0.35,2.24-0.95c0.58,0.59,1.37,0.95,2.24,0.95c0.08,0,0.15-0.02,0.23-0.03V19H5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 escalator
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M21,3H3v18h18L21,3z M18.5,9h-3.2l-5,9H5.5v-3h3.2l5-9h4.8V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 smoking-rooms
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 16h15v3H2v-3zm18.5 0H22v3h-1.5v-3zM18 16h1.5v3H18v-3zm.85-8.27c.62-.61 1-1.45 1-2.38C19.85 3.5 18.35 2 16.5 2v1.5c1.02 0 1.85.83 1.85 1.85S17.52 7.2 16.5 7.2v1.5c2.24 0 4 1.83 4 4.07V15H22v-2.24c0-2.22-1.28-4.14-3.15-5.03zm-2.82 2.47H14.5c-1.02 0-1.85-.98-1.85-2s.83-1.75 1.85-1.75v-1.5c-1.85 0-3.35 1.5-3.35 3.35s1.5 3.35 3.35 3.35h1.53c1.05 0 1.97.74 1.97 2.05V15h1.5v-1.64c0-1.81-1.6-3.16-3.47-3.16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 countertops
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18,10V7c0-1.66-1.34-3-3-3c-1.66,0-3,1.34-3,3h2c0-0.55,0.45-1,1-1c0.55,0,1,0.45,1,1v3H8c1.1,0,2-0.9,2-2V4H4v4 c0,1.1,0.9,2,2,2H2v2h2v8h16v-8h2v-2H18z M13,18h-2v-6h2V18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 desk
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2,6v12h2V8h10v10h2v-2h4v2h2V6H2z M20,8v2h-4V8H20z M16,14v-2h4v2H16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 stroller
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M18,20c0,1.1-0.9,2-2,2s-2-0.9-2-2s0.9-2,2-2S18,18.9,18,20z M6,18c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S7.1,18,6,18z M22,7V6.48C22,4.56,20.52,3,18.65,3c-1.66,0-2.54,1.27-3.18,2.03L5.27,17H17V6.27C17.58,5.59,17.97,5,18.65,5 C19.42,5,20,5.66,20,6.48V7H22z M14.3,4.1C13.03,3.4,11.56,3,10,3C8.03,3,6.21,3.64,4.72,4.72l4.89,4.89L14.3,4.1z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sports-bar
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21,9h-3.56C17.79,8.41,18,7.73,18,7c0-2.21-1.79-4-4-4c-0.34,0-0.66,0.05-0.98,0.13C12.2,2.45,11.16,2.02,10,2.02 c-1.89,0-3.51,1.11-4.27,2.71C4.15,5.26,3,6.74,3,8.5c0,1.86,1.28,3.41,3,3.86L6,21h11v-2h4V9z M7,10.5c-1.1,0-2-0.9-2-2 c0-0.85,0.55-1.6,1.37-1.88l0.8-0.27l0.36-0.76C8,4.62,8.94,4.02,10,4.02c0.79,0,1.39,0.35,1.74,0.65l0.78,0.65 c0,0,0.64-0.32,1.47-0.32c1.1,0,2,0.9,2,2c0,0-3,0-3,0C9.67,7,9.15,10.5,7,10.5z M19,17h-2v-6h2V17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 all-inclusive
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.6 6.62c-1.44 0-2.8.56-3.77 1.53L7.8 14.39c-.64.64-1.49.99-2.4.99-1.87 0-3.39-1.51-3.39-3.38S3.53 8.62 5.4 8.62c.91 0 1.76.35 2.44 1.03l1.13 1 1.51-1.34L9.22 8.2C8.2 7.18 6.84 6.62 5.4 6.62 2.42 6.62 0 9.04 0 12s2.42 5.38 5.4 5.38c1.44 0 2.8-.56 3.77-1.53L13.51 12l2.69-2.39c.64-.64 1.49-.99 2.4-.99 1.87 0 3.39 1.51 3.39 3.38s-1.52 3.38-3.39 3.38c-.9 0-1.76-.35-2.44-1.03l-1.14-1.01-1.51 1.34 1.27 1.12c1.02 1.01 2.37 1.57 3.82 1.57 2.98 0 5.4-2.41 5.4-5.38s-2.42-5.37-5.4-5.37z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 business-center
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 16v-1H3.01v6H21v-6h-7v1h-4zm12-9h-6V5l-2-2h-4L8 5v2H2v7h8v-2h4v2h8V7zm-8 0h-4V5h4v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 house-siding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,12h3L12,3L2,12h3v8h2v-2h10v2h2V12z M7.21,10h9.58L17,10.19V12H7v-1.81L7.21,10z M14.57,8H9.43L12,5.69L14.57,8z M7,16 v-2h10v2H7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 carpenter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M7,1.5L3.11,5.39l8.13,11.67l-1.41,1.41l4.24,4.24l7.07-7.07L7,1.5z M12.66,18.47l4.24-4.24l1.41,1.41l-4.24,4.24 L12.66,18.47z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 free-breakfast
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 3H4v14h14v-7h2c1.11 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 5h-2V5h2v3zM4 19h16v2H4v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 gite
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18,6H9V4H7v2H6l-4,4v9h20v-9L18,6z M4,12h10v5H4V12z M20,17h-4v-6.17l2-2v0l2,2V17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 escalator-warning
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M6.5,2c1.1,0,2,0.9,2,2s-0.9,2-2,2s-2-0.9-2-2S5.4,2,6.5,2z M15.5,9.5c0,0.83,0.67,1.5,1.5,1.5s1.5-0.67,1.5-1.5 S17.83,8,17,8S15.5,8.67,15.5,9.5z M14.21,12.86l-0.92,1.32L9.72,8C9.37,7.38,8.71,7,7.99,7H3v8h1.5v7h5V11.61L12.03,16h2.2 L15,14.9V22h4v-5h1v-5h-4.15C15.19,12,14.58,12.32,14.21,12.86z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 grass
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,20H2v-2h5.75l0,0C7.02,15.19,4.81,12.99,2,12.26C2.64,12.1,3.31,12,4,12C8.42,12,12,15.58,12,20z M22,12.26 C21.36,12.1,20.69,12,20,12c-2.93,0-5.48,1.58-6.88,3.93c0.29,0.66,0.53,1.35,0.67,2.07c0.13,0.65,0.2,1.32,0.2,2h2h6v-2h-5.75 C16.98,15.19,19.19,12.99,22,12.26z M15.64,11.02c0.78-2.09,2.23-3.84,4.09-5C15.44,6.16,12,9.67,12,14c0,0.01,0,0.02,0,0.02 C12.95,12.75,14.2,11.72,15.64,11.02z M11.42,8.85C10.58,6.66,8.88,4.89,6.7,4C8.14,5.86,9,8.18,9,10.71c0,0.21-0.03,0.41-0.04,0.61 c0.43,0.24,0.83,0.52,1.22,0.82C10.39,10.96,10.83,9.85,11.42,8.85z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 golf-course
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1.5", :cy "19.5", :cx "19.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M17 5.92L9 2v18H7v-1.73c-1.79.35-3 .99-3 1.73 0 1.1 2.69 2 6 2s6-.9 6-2c0-.99-2.16-1.81-5-1.97V8.98l6-3.06z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 casino
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3v18h18V3zM7.5 18c-.83 0-1.5-.67-1.5-1.5S6.67 15 7.5 15s1.5.67 1.5 1.5S8.33 18 7.5 18zm0-9C6.67 9 6 8.33 6 7.5S6.67 6 7.5 6 9 6.67 9 7.5 8.33 9 7.5 9zm4.5 4.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5 4.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm0-9c-.83 0-1.5-.67-1.5-1.5S15.67 6 16.5 6s1.5.67 1.5 1.5S17.33 9 16.5 9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tapas
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,10V1h-8v9c0,1.86,1.28,3.41,3,3.86V21h-2v2h6v-2h-2v-7.14C20.72,13.41,22,11.86,22,10z M20,3v3h-4V3H20z M10,9H8V8h2 c1.38,0,2.5-1.12,2.5-2.5C12.5,4.12,11.38,3,10,3H8V1H6v2H4C2.62,3,1.5,4.12,1.5,5.5C1.5,6.88,2.62,8,4,8h2v1H4 c-1.38,0-2.5,1.12-2.5,2.5C1.5,12.88,2.62,14,4,14h2v9h2v-9h2c1.38,0,2.5-1.12,2.5-2.5C12.5,10.12,11.38,9,10,9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 charging-station
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M14.5,11l-3,6v-4h-2l3-6v4H14.5z M5,1h14v22H5V1z M7,6v12h10V6H7z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 smoke-free
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.5 13H22v3h-1.5zm-6-4.35h1.53c1.05 0 1.97.74 1.97 2.05V12h1.5v-1.64c0-1.81-1.6-3.16-3.47-3.16H14.5c-1.02 0-1.85-.98-1.85-2s.83-1.75 1.85-1.75v-1.5c-1.85 0-3.35 1.5-3.35 3.35s1.5 3.35 3.35 3.35zM17 13h-2.34L17 15.34zm1.85-8.27c.62-.61 1-1.45 1-2.38h-1.5c0 1.02-.83 1.85-1.85 1.85v1.5c2.24 0 4 1.83 4 4.07V12H22V9.76c0-2.22-1.28-4.14-3.15-5.03zM18 13h1.5v3H18zM3.41 4.59L2 6l7 7H2v3h10l7 7 1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 foundation
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,12h3L12,3L2,12h3v3H3v2h2v3h2v-3h4v3h2v-3h4v3h2v-3h2v-2h-2V12z M7,15v-4.81l4-3.6V15H7z M13,15V6.59l4,3.6V15H13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-stroller
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M10.91,8.08L6.53,3.7C7.6,3.25,8.77,3,10,3c1.56,0,3.03,0.4,4.3,1.1L10.91,8.08z M21.19,21.19l-4.78-4.78l-5.75-5.75 L2.81,2.81L1.39,4.22l7.97,7.97L5.27,17h8.9l1.13,1.13c-0.88,0.33-1.47,1.25-1.26,2.28c0.15,0.76,0.78,1.39,1.54,1.54 c1.03,0.21,1.95-0.38,2.28-1.26l1.91,1.91L21.19,21.19z M6,18c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S7.1,18,6,18z M17,6.27 C17.58,5.59,17.97,5,18.65,5C19.42,5,20,5.66,20,6.48V7h2V6.48C22,4.56,20.52,3,18.65,3c-1.66,0-2.54,1.27-3.18,2.03l-3.5,4.11 L17,14.17V6.27z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 corporate-fare
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,7V3H2v18h20V7H12z M10,19H4v-2h6V19z M10,15H4v-2h6V15z M10,11H4V9h6V11z M10,7H4V5h6V7z M20,19h-8V9h8V19z M18,11h-4v2 h4V11z M18,15h-4v2h4V15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-drinks
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21.19,21.19L2.81,2.81L1.39,4.22l8.23,8.23L11,14v5H6v2h12v-0.17l1.78,1.78L21.19,21.19z M13,19v-3.17L16.17,19H13z M7.83,5l-2-2H21v2l-6.2,6.97L9.83,7h6.74l1.78-2H7.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 family-restroom
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M16,4c0-1.11,0.89-2,2-2s2,0.89,2,2s-0.89,2-2,2S16,5.11,16,4z M20,22v-6h2.5l-3-9l-3,0l-1.17,3.5H17V22H20z M12.5,11.5 c0.83,0,1.5-0.67,1.5-1.5s-0.67-1.5-1.5-1.5S11,9.17,11,10S11.67,11.5,12.5,11.5z M5.5,6c1.11,0,2-0.89,2-2s-0.89-2-2-2 s-2,0.89-2,2S4.39,6,5.5,6z M7.5,22v-7H9V7H2v8h1.5v7H7.5z M14,22v-4h1v-5.5h-5V18h1v4H14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 checkroom
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21.6,18.2L13,11.75v-0.91c1.65-0.49,2.8-2.17,2.43-4.05c-0.26-1.31-1.3-2.4-2.61-2.7C10.54,3.57,8.5,5.3,8.5,7.5h2 C10.5,6.67,11.17,6,12,6s1.5,0.67,1.5,1.5c0,0.84-0.69,1.52-1.53,1.5L11,9l0,2.75L2.4,18.2C1.63,18.78,2.04,20,3,20h9h9 C21.96,20,22.37,18.78,21.6,18.2z M6,18l6-4.5l6,4.5H6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 soap
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M14.25,6C14.66,6,15,6.34,15,6.75S14.66,7.5,14.25,7.5S13.5,7.16,13.5,6.75S13.84,6,14.25,6 M14.25,4.5 C13.01,4.5,12,5.51,12,6.75S13.01,9,14.25,9s2.25-1.01,2.25-2.25S15.49,4.5,14.25,4.5L14.25,4.5z M20,5.5c0.28,0,0.5,0.22,0.5,0.5 S20.28,6.5,20,6.5S19.5,6.28,19.5,6S19.72,5.5,20,5.5 M20,4c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S21.1,4,20,4L20,4z M18,2.5 C18,3.33,17.33,4,16.5,4C15.67,4,15,3.33,15,2.5S15.67,1,16.5,1C17.33,1,18,1.67,18,2.5z M1,12.68V23h18v-2.5h-7v-1h9V17h-9v-1h10 v-2.5H12v-1h8V10H8.86l1.88-3.3L9.12,5L1,12.68z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 houseboat
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,16c-1.95,0-2.1,1-3.34,1c-1.19,0-1.42-1-3.33-1C3.38,16,3.24,17,2,17v2c1.9,0,2.17-1,3.35-1c1.19,0,1.42,1,3.33,1 c1.95,0,2.08-1,3.32-1s1.37,1,3.32,1c1.91,0,2.14-1,3.33-1c1.18,0,1.45,1,3.35,1v-2c-1.24,0-1.38-1-3.33-1c-1.91,0-2.14,1-3.33,1 C14.1,17,13.95,16,12,16z M20.34,11.34L18.67,13H17V9.65l1.32,0.97L19.5,9L12,3.5L4.5,9l1.18,1.61L7,9.65V13H5.33l-1.66-1.66 l-1.41,1.41L4.5,15h15l2.25-2.25L20.34,11.34z M13,13h-2v-2h2V13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 roofing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M13,18h-2v-2h2V18z M15,14H9v6h6V14L15,14z M19,9.3L19,9.3V4h-3v2.6v0L12,3L2,12h3l7-6.31L19,12h3L19,9.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 night-shelter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,3L4,9v12h16V9L12,3z M9.75,12.5c0.69,0,1.25,0.56,1.25,1.25S10.44,15,9.75,15S8.5,14.44,8.5,13.75S9.06,12.5,9.75,12.5z M17,18h-1v-1.5H8V18H7v-7h1v4.5h3.5V12H17V18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-step
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M1.39,4.22l8.24,8.24l-0.69,0.72L6.87,11.1c-0.11,0.4-0.26,0.78-0.45,1.12l1.75,1.75l-0.69,0.72l-1.63-1.63 c-0.24,0.29-0.5,0.56-0.77,0.8l1.63,1.63l-0.7,0.72l-1.74-1.74C2.83,15.43,1.34,15.82,1,15.92L1,20h9.5l3.33-3.33l5.94,5.94 l1.41-1.41L2.81,2.81L1.39,4.22z M18.51,15.68l-1.41-1.41l4.48-4.48L23,11.2L18.51,15.68z M20.88,9.08l-4.48,4.48L9.3,6.47L13.8,2 L20.88,9.08z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 spa
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.55 12c-1.07-.71-2.25-1.27-3.53-1.61 1.28.34 2.46.9 3.53 1.61zm10.43-1.61c-1.29.34-2.49.91-3.57 1.64 1.08-.73 2.28-1.3 3.57-1.64zm-3.49-.76c-.18-2.79-1.31-5.51-3.43-7.63-2.14 2.14-3.32 4.86-3.55 7.63 1.28.68 2.46 1.56 3.49 2.63 1.03-1.06 2.21-1.94 3.49-2.63zm-6.5 2.65c-.14-.1-.3-.19-.45-.29.15.11.31.19.45.29zm6.42-.25c-.13.09-.27.16-.4.26.13-.1.27-.17.4-.26zM12 15.45C9.85 12.17 6.18 10 2 10c0 5.32 3.36 9.82 8.03 11.49.63.23 1.29.4 1.97.51.68-.12 1.33-.29 1.97-.51C18.64 19.82 22 15.32 22 10c-4.18 0-7.85 2.17-10 5.45z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cabin
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M10,1c0,1.66-1.34,3-3,3C6.45,4,6,4.45,6,5H4c0-1.66,1.34-3,3-3c0.55,0,1-0.45,1-1H10z M12,3L6,7.58V6H4v3.11L1,11.4 l1.21,1.59L4,11.62V21h16v-9.38l1.79,1.36L23,11.4L12,3z M13.94,7h-3.89L12,5.52L13.94,7z M7.44,9h9.12L18,10.1V11H6v-0.9L7.44,9z M18,13v2H6v-2H18z M6,19v-2h12v2H6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 villa
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M7,21H3V8l13-5v7H7V21z M19,10c-1.1,0-2,0.9-2,2H9v9h5v-5h2v5h5v-9C21,10.9,20.1,10,19,10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ac-unit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 11h-4.17l3.24-3.24-1.41-1.42L15 11h-2V9l4.66-4.66-1.42-1.41L13 6.17V2h-2v4.17L7.76 2.93 6.34 4.34 11 9v2H9L4.34 6.34 2.93 7.76 6.17 11H2v2h4.17l-3.24 3.24 1.41 1.42L9 13h2v2l-4.66 4.66 1.42 1.41L11 17.83V22h2v-4.17l3.24 3.24 1.42-1.41L13 15v-2h2l4.66 4.66 1.41-1.42L17.83 13H22v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-food
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M11.35,8.52L11,5h5V1h2v4h5l-1.38,13.79L18,15.17L11.35,8.52z M21.9,21.9L2.1,2.1L0.69,3.51l5.7,5.7 C3.46,9.83,1,11.76,1,15h11.17l2,2H1v2h15v-0.17l4.49,4.49L21.9,21.9z M1,23h15v-2H1V23z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 room-preferences
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M14,11.26V6h3v4h2V4h-5V3H5v16H3v2h9.26C11.47,19.87,11,18.49,11,17C11,14.62,12.19,12.53,14,11.26z M10,11h2v2h-2V11z M21.69,16.37l1.14-1l-1-1.73l-1.45,0.49c-0.32-0.27-0.68-0.48-1.08-0.63L19,12h-2l-0.3,1.49c-0.4,0.15-0.76,0.36-1.08,0.63 l-1.45-0.49l-1,1.73l1.14,1c-0.08,0.5-0.08,0.76,0,1.26l-1.14,1l1,1.73l1.45-0.49c0.32,0.27,0.68,0.48,1.08,0.63L17,22h2l0.3-1.49 c0.4-0.15,0.76-0.36,1.08-0.63l1.45,0.49l1-1.73l-1.14-1C21.77,17.13,21.77,16.87,21.69,16.37z M18,19c-1.1,0-2-0.9-2-2s0.9-2,2-2 s2,0.9,2,2S19.1,19,18,19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 no-backpack
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.19,21.19L2.81,2.81L1.39,4.22l2.76,2.76C4.06,7.31,4,7.64,4,8v14h15.17l0.61,0.61L21.19,21.19z M6,14v-2h3.17l2,2H6z M6.98,4.15c0.01,0,0.01-0.01,0.02-0.01V2h3v2h4V2h3v2.14c1.72,0.45,3,2,3,3.86v9.17l-2-2V12h-3.17L6.98,4.15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 child-friendly
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 2v8h8c0-4.42-3.58-8-8-8zm6.32 13.89C20.37 14.54 21 12.84 21 11H6.44l-.95-2H2v2h2.22s1.89 4.07 2.12 4.42c-1.1.59-1.84 1.75-1.84 3.08C4.5 20.43 6.07 22 8 22c1.76 0 3.22-1.3 3.46-3h2.08c.24 1.7 1.7 3 3.46 3 1.93 0 3.5-1.57 3.5-3.5 0-1.04-.46-1.97-1.18-2.61zM8 20c-.83 0-1.5-.67-1.5-1.5S7.17 17 8 17s1.5.67 1.5 1.5S8.83 20 8 20zm9 0c-.83 0-1.5-.67-1.5-1.5S16.17 17 17 17s1.5.67 1.5 1.5S17.83 20 17 20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hot-tub
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle {:r "2", :cy "6", :cx "7", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M11.15 12c-.31-.22-.59-.46-.82-.72l-1.4-1.55c-.19-.21-.43-.38-.69-.5-.29-.14-.62-.23-.96-.23h-.03C6.01 9 5 10.01 5 11.25V12H2v10h20V12H11.15zM7 20H5v-6h2v6zm4 0H9v-6h2v6zm4 0h-2v-6h2v6zm4 0h-2v-6h2v6zm-.35-14.14l-.07-.07c-.57-.62-.82-1.41-.67-2.2L18 3h-1.89l-.06.43c-.2 1.36.27 2.71 1.3 3.72l.07.06c.57.62.82 1.41.67 2.2l-.11.59h1.91l.06-.43c.21-1.36-.27-2.71-1.3-3.71zm-4 0l-.07-.07c-.57-.62-.82-1.41-.67-2.2L14 3h-1.89l-.06.43c-.2 1.36.27 2.71 1.3 3.72l.07.06c.57.62.82 1.41.67 2.2l-.11.59h1.91l.06-.43c.21-1.36-.27-2.71-1.3-3.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fence
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,12v-2h-2V7l-3-3l-2,2l-2-2l-2,2L8,4L5,7v3H3v2h2v2H3v2h2v4h14v-4h2v-2h-2v-2H21z M16,6.83l1,1V10h-2V7.83l0.41-0.41 L16,6.83z M12,6.83l0.59,0.59L13,7.83V10h-2V7.83l0.41-0.41L12,6.83z M11,14v-2h2v2H11z M13,16v2h-2v-2H13z M7,7.83l1-1l0.59,0.59 L9,7.83V10H7V7.83z M7,12h2v2H7V12z M7,16h2v2H7V16z M17,18h-2v-2h2V18z M17,14h-2v-2h2V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 rice-bowl
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,12L22,12c0-5.52-4.48-10-10-10S2,6.48,2,12c0,3.69,2.47,6.86,6,8.25V22h8v-1.75C19.53,18.86,22,15.69,22,12z M20,12h-4 V5.08C18.39,6.47,20,9.05,20,12z M14,4.26V12h-4V4.26C10.64,4.1,11.31,4,12,4S13.36,4.1,14,4.26z M4,12c0-2.95,1.61-5.53,4-6.92V12 H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-photography
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M10.94,8.12L7.48,4.66L9,3h6l1.83,2H22v14.17l-5.12-5.12C16.96,13.71,17,13.36,17,13c0-2.76-2.24-5-5-5 C11.64,8,11.29,8.04,10.94,8.12z M20.49,23.31L18.17,21H2V5h0.17L0.69,3.51L2.1,2.1L21,21l0.9,0.9L20.49,23.31z M14.49,17.32 l-1.5-1.5C12.67,15.92,12.35,16,12,16c-1.66,0-3-1.34-3-3c0-0.35,0.08-0.67,0.19-0.98l-1.5-1.5C7.25,11.24,7,12.09,7,13 c0,2.76,2.24,5,5,5C12.91,18,13.76,17.75,14.49,17.32z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bento
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,11V5h6v6H16z M16,19h6v-6h-6V19z M14,5v14H2V5H14z M9.5,12c0-0.83-0.67-1.5-1.5-1.5S6.5,11.17,6.5,12s0.67,1.5,1.5,1.5 S9.5,12.83,9.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 iron
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18,6v8h-1V7H7v3h2V9h6v2H6c-2.21,0-4,1.79-4,4v3h15v-2h3V8h2V6H18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-cell
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21.19,21.19L2.81,2.81L1.39,4.22L5,7.83V23h14v-1.17l0.78,0.78L21.19,21.19z M7,18V9.83L15.17,18H7z M8.83,6L5,2.17V1h14 v15.17l-2-2V6H8.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 umbrella
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M14.5,6.92L13,5.77V3.88V3.4c0-0.26,0.22-0.48,0.5-0.48c0.28,0,0.5,0.21,0.5,0.48V4h2V3.4C16,2.07,14.88,1,13.5,1 C12.12,1,11,2.07,11,3.4v0.48v1.89L9.5,6.92L6,6.07l5.05,15.25C11.2,21.77,11.6,22,12,22s0.8-0.23,0.95-0.69L18,6.07L14.5,6.92z M13.28,8.5l0.76,0.58l0.92-0.23L13,14.8V8.29L13.28,8.5z M9.96,9.09l0.76-0.58L11,8.29v6.51L9.03,8.86L9.96,9.09z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 house
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,9.3V4h-3v2.6L12,3L2,12h3v8h5v-6h4v6h5v-8h3L19,9.3z M10,10c0-1.1,0.9-2,2-2s2,0.9,2,2H10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 baby-changing-station
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M14,8v2h-3L8.31,8.82L7,12.75V22H3V12l1.58-4.63C4.86,6.53,5.63,6.01,6.46,6C6.74,6,7.02,6.05,7.3,6.18l4.15,1.83L14,8z M8,1C6.9,1,6,1.9,6,3s0.9,2,2,2s2-0.9,2-2S9.1,1,8,1z M9,19h12v-2H9V19z M19.5,16c0.83,0,1.5-0.67,1.5-1.5 c0-0.83-0.67-1.5-1.5-1.5S18,13.67,18,14.5C18,15.33,18.67,16,19.5,16z M13,13v-2H9v2h2v3h6v-5h-2v2H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bathtub
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/circle
      {:r "2", :cy "7", :cx "7", :stroke nil, :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M20,13V4.83C20,3.27,18.73,2,17.17,2c-0.75,0-1.47,0.3-2,0.83l-1.25,1.25C13.76,4.03,13.59,4,13.41,4 c-0.4,0-0.77,0.12-1.08,0.32l2.76,2.76c0.2-0.31,0.32-0.68,0.32-1.08c0-0.18-0.03-0.34-0.07-0.51l1.25-1.25 C16.74,4.09,16.95,4,17.17,4C17.63,4,18,4.37,18,4.83V13h-6.85c-0.3-0.21-0.57-0.45-0.82-0.72l-1.4-1.55 c-0.19-0.21-0.43-0.38-0.69-0.5C7.93,10.08,7.59,10,7.24,10C6,10.01,5,11.01,5,12.25V13H2v8h2v1h16v-1h2v-8H20z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 wash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M9.12,5L1,12.68V23h18v-2.5h-7v-1h9V17h-9v-1h10v-2.5H12v-1h8V10H8.86l1.88-3.3L9.12,5L9.12,5z M13.5,9 C14.33,9,15,8.33,15,7.5C15,6.66,13.5,5,13.5,5S12,6.66,12,7.5C12,8.33,12.67,9,13.5,9z M18.5,1c0,0-2.5,2.83-2.5,4.5 C16,6.88,17.12,8,18.5,8S21,6.88,21,5.5C21,3.83,18.5,1,18.5,1z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 airport-shuttle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 5H1v11h2c0 1.66 1.34 3 3 3s3-1.34 3-3h6c0 1.66 1.34 3 3 3s3-1.34 3-3h2v-5l-6-6zM3 11V7h4v4H3zm3 6.25c-.69 0-1.25-.56-1.25-1.25s.56-1.25 1.25-1.25 1.25.56 1.25 1.25-.56 1.25-1.25 1.25zM13 11H9V7h4v4zm5 6.25c-.69 0-1.25-.56-1.25-1.25s.56-1.25 1.25-1.25 1.25.56 1.25 1.25-.56 1.25-1.25 1.25zM15 11V7h1l4 4h-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-flash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2.45,2.45L1.04,3.87l5.3,5.3L6.14,9.4H2V22h16v-1.17l2.13,2.13l1.41-1.41L2.45,2.45z M10,20c-2.21,0-4-1.79-4-4 c0-1.95,1.4-3.57,3.25-3.92l1.57,1.57c-0.26-0.09-0.53-0.15-0.82-0.15c-1.38,0-2.5,1.12-2.5,2.5c0,1.38,1.12,2.5,2.5,2.5 c1.38,0,2.5-1.12,2.5-2.5c0-0.29-0.06-0.56-0.15-0.82l1.57,1.57C13.57,18.6,11.95,20,10,20z M18,15.17L10.83,8h1.75l1.28,1.4H18 V15.17z M20.4,5.6H22L19,11V7h-1V2h4L20.4,5.6z",
     :stroke nil,
     :fill nil})
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))))


(helix.core/defnc
 backpack
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M20,8v14H4V8c0-1.86,1.28-3.41,3-3.86V2h3v2h4V2h3v2.14C18.72,4.59,20,6.14,20,8z M6,12v2h10v2h2v-4H6z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 bungalow
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,3L4.2,15.5l1.7,1.06L7,14.8V21h4v-5h2v5h4v-6.21l1.1,1.77l1.7-1.06L12,3z M13,14h-2v-2h2V14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 food-bank
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,3L4,9v12h16V9L12,3z M12.5,12.5c0,0.83-0.67,1.5-1.5,1.5v4h-1v-4c-0.83,0-1.5-0.67-1.5-1.5v-3h1v3H10v-3h1v3h0.5v-3h1 V12.5z M15,18h-1v-3.5h-1v-3c0-1.1,0.9-2,2-2V18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 kitchen
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 2.01 4 2v20h16V2.01zM18 20H6v-9.02h12V20zm0-11H6V4h12v5zM8 5h2v3H8V5zm0 7h2v5H8v-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 elevator
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M8.5,6c0.69,0,1.25,0.56,1.25,1.25c0,0.69-0.56,1.25-1.25,1.25S7.25,7.94,7.25,7.25 C7.25,6.56,7.81,6,8.5,6z M11,14h-1v4H7v-4H6V9.5h5V14z M15.5,17L13,13h5L15.5,17z M13,11l2.5-4l2.5,4H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 apartment
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,11V3H7v4H3v14h8v-4h2v4h8V11H17z M7,19H5v-2h2V19z M7,15H5v-2h2V15z M7,11H5V9h2V11z M11,15H9v-2h2V15z M11,11H9V9h2 V11z M11,7H9V5h2V7z M15,15h-2v-2h2V15z M15,11h-2V9h2V11z M15,7h-2V5h2V7z M19,19h-2v-2h2V19z M19,15h-2v-2h2V15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 pool
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 8l-3.25 3.25c.31.12.56.27.77.39.37.23.59.36 1.15.36s.78-.13 1.15-.36c.46-.27 1.08-.64 2.19-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36.55 0 .78-.13 1.15-.36.12-.07.26-.15.41-.23L10.48 5 5 3v2.5L9 7l1 1zm12 8.5h-.02.02zm-16.65-1c.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64s1.73-.37 2.18-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64s1.73-.37 2.18-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.06.63 2.16.64v-2c-.55 0-.78-.14-1.15-.36-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.18.64c-.37.23-.6.36-1.15.36s-.78-.14-1.15-.36c-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.18.64c-.37.23-.59.36-1.15.36-.55 0-.78-.14-1.15-.36-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.18.64c-.37.23-.59.36-1.15.36v2c1.11 0 1.73-.37 2.2-.64.37-.23.6-.36 1.15-.36zM18.67 18c-1.11 0-1.73.37-2.18.64-.37.23-.6.36-1.15.36-.55 0-.78-.14-1.15-.36-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.19.64c-.37.23-.59.36-1.15.36s-.78-.13-1.15-.36c-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.19.64c-.37.23-.59.36-1.15.36v2c1.11 0 1.73-.37 2.19-.64.37-.23.6-.36 1.15-.36.55 0 .78.13 1.15.36.45.27 1.07.64 2.18.64s1.73-.37 2.19-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64s1.72-.37 2.18-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64v-2c-.56 0-.78-.13-1.15-.36-.45-.27-1.07-.64-2.18-.64z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2.5", :cy "5.5", :cx "16.5", :stroke nil, :fill nil})))


(helix.core/defnc
 stairs
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M3,3v18h18V3H3z M18,8h-2.42v3.33H13v3.33h-2.58V18H6v-2h2.42v-3.33H11V9.33h2.58V6H18V8z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 no-meeting-room
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 6h3v7.88l2 2V4h-5V3H6.12L14 10.88zm-2 5.71V13h-2v-2h1.29L2.41 2.13 1 3.54l4 4V19H3v2h11v-4.46L20.46 23l1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wheelchair-pickup
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M4.5,4c0-1.11,0.89-2,2-2s2,0.89,2,2s-0.89,2-2,2S4.5,5.11,4.5,4z M10,10.95V7H3v8h2v7h3.5v-0.11c-1.24-1.26-2-2.99-2-4.89 C6.5,14.42,7.91,12.16,10,10.95z M16.5,17c0,1.65-1.35,3-3,3s-3-1.35-3-3c0-1.11,0.61-2.06,1.5-2.58v-2.16 C9.98,12.9,8.5,14.77,8.5,17c0,2.76,2.24,5,5,5s5-2.24,5-5H16.5z M19.54,14H15V8h-2v8h5.46l2.47,3.71l1.66-1.11L19.54,14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 chalet
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M10,7.5l7.5,7.5l-1.41,1.41L15,15.33V20h-4v-5H9v5H5v-4.67l-1.09,1.09L2.5,15L10,7.5z M22,6.5h-1.19l0.75-0.75l-0.71-0.71 L19.39,6.5H18.5V5.61l1.45-1.45l-0.71-0.71L18.5,4.19V3h-1v1.19l-0.75-0.75l-0.71,0.71l1.45,1.45V6.5h-0.89l-1.45-1.45l-0.71,0.71 l0.75,0.75H14v1h1.19l-0.75,0.75l0.71,0.71l1.45-1.45h0.89v0.89l-1.45,1.45l0.71,0.71l0.75-0.75V11h1V9.81l0.75,0.75l0.71-0.71 L18.5,8.39V7.5h0.89l1.45,1.45l0.71-0.71L20.81,7.5H22V6.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 holiday-village
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18,20V8.35L13.65,4h-2.83L16,9.18V20H18z M22,20V6.69L19.31,4h-2.83L20,7.52V20H22z M8,4l-6,6v10h5v-5h2v5h5V10L8,4z M9,13 H7v-2h2V13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crib
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20,9h-8V4H8C5.79,4,4,5.79,4,8v8h4v2.93c-0.61-0.35-1.16-0.78-1.65-1.27l-1.42,1.42C6.74,20.88,9.24,22,12,22 c2.76,0,5.26-1.12,7.07-2.93l-1.42-1.42c-0.49,0.49-1.05,0.92-1.65,1.27V16h4V9z M14,19.75C13.36,19.91,12.69,20,12,20 c-0.69,0-1.36-0.09-2-0.25V16h4V19.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 other-houses
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,3L1,11.4l1.21,1.59L4,11.62V21h16v-9.38l1.79,1.36L23,11.4L12,3z M8,15c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1 s1,0.45,1,1C9,14.55,8.55,15,8,15z M12,15c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C13,14.55,12.55,15,12,15z M16,15 c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C17,14.55,16.55,15,16,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vaping-rooms
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2,16.5h1c1.33,0,2.71-0.18,4-0.5v3c-1.29-0.32-2.67-0.5-4-0.5H2V16.5z M22,16v3H8v-3H22z M11,17.5 c0-0.28-0.22-0.5-0.5-0.5S10,17.22,10,17.5c0,0.28,0.22,0.5,0.5,0.5S11,17.78,11,17.5z M22,12.76V15h-1.5v-2.23 c0-2.24-1.76-4.07-4-4.07V7.2c1.02,0,1.85-0.83,1.85-1.85S17.52,3.5,16.5,3.5V2c1.85,0,3.35,1.5,3.35,3.35c0,0.93-0.38,1.77-1,2.38 C20.72,8.62,22,10.54,22,12.76z M19.5,13.36V15H18v-1.3c0-1.31-0.92-2.05-1.97-2.05H14.5c-1.85,0-3.35-1.5-3.35-3.35 s1.5-3.35,3.35-3.35v1.5c-1.02,0-1.85,0.73-1.85,1.75s0.83,2,1.85,2h1.53C17.9,10.2,19.5,11.55,19.5,13.36z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fitness-center
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.57 14.86L22 13.43 20.57 12 17 15.57 8.43 7 12 3.43 10.57 2 9.14 3.43 7.71 2 5.57 4.14 4.14 2.71 2.71 4.14l1.43 1.43L2 7.71l1.43 1.43L2 10.57 3.43 12 7 8.43 15.57 17 12 20.57 13.43 22l1.43-1.43L16.29 22l2.14-2.14 1.43 1.43 1.43-1.43-1.43-1.43L22 16.29l-1.43-1.43z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-forward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8-8-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 subdirectory-arrow-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 24H0V0h24v24z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 15l-6 6-1.42-1.42L15.17 16H4V4h2v10h9.17l-3.59-3.58L13 9l6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cancel
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 expand-less
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14l-6-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 payments
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M23 7v13H4v-2h17V7h2zm-4 9H1V4h18v12zm-6-6c0-1.66-1.34-3-3-3s-3 1.34-3 3 1.34 3 3 3 3-1.34 3-3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 arrow-drop-down
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M7 10l5 5 5-5H7z", :stroke nil, :fill nil})))


(helix.core/defnc
 arrow-downward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 12l-1.41-1.41L13 16.17V4h-2v12.17l-5.58-5.59L4 12l8 8 8-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unfold-less
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 0v24H0V0h24z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.41 18.59L8.83 20 12 16.83 15.17 20l1.41-1.41L12 14l-4.59 4.59zm9.18-13.18L15.17 4 12 7.17 8.83 4 7.41 5.41 12 10l4.59-4.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 close
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 last-page
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.59 7.41L10.18 12l-4.59 4.59L7 18l6-6-6-6-1.41 1.41zM16 6h2v12h-2V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 north
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M5,9l1.41,1.41L11,5.83V22H13V5.83l4.59,4.59L19,9l-7-7L5,9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 maps-home-work
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "1,11 1,21 6,21 6,15 10,15 10,21 15,21 15,11 8,6",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M10,3v1.97l7,5V11h2v2h-2v2h2v2h-2v4h6V3H10z M19,9h-2V7h2V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 pivot-table-chart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "3",
      :x "10",
      :width "11",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "3",
      :width "5",
      :height "11",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "3", :x "3", :width "5", :height "5", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points
      "18,9 14,13 17,13 17,17 13,17 13,14 9,18 13,22 13,19 19,19 19,13 22,13",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 arrow-drop-up
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M7 14l5-5 5 5H7z", :stroke nil, :fill nil})))


(helix.core/defnc
 fullscreen-exit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 16h3v3h2v-5H5v2zm3-8H5v2h5V5H8v3zm6 11h2v-3h3v-2h-5v5zm2-11V5h-2v5h5V8h-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 subdirectory-arrow-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 9l1.42 1.42L8.83 14H18V4h2v12H8.83l3.59 3.58L11 21l-6-6 6-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 refresh
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 apps-outage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M4,8h4V4H4V8z M10,20h4v-4h-4V20z M4,20h4v-4H4V20z M4,14h4v-4H4V14z M10,14h4v-4h-4V14z M16,20h4v-4h-4V20z M19,0 c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S21.76,0,19,0z M19.5,8h-1V7h1V8z M19.5,6h-1V2h1V6z M16,14h4v-2.07 C19.67,11.98,19.34,12,19,12c-1.07,0-2.09-0.24-3-0.68V14z M10,4v4h2.68C12.24,7.09,12,6.07,12,5c0-0.34,0.02-0.67,0.07-1H10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 expand-more
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 24H0V0h24v24z", :stroke nil})
  (helix.dom/path
   {:d "M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6-1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 app-settings-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21.81,12.74l-0.82-0.63c0-0.09,0-0.13,0-0.22l0.8-0.63c0.16-0.12,0.2-0.34,0.1-0.51l-0.85-1.48 c-0.07-0.13-0.21-0.2-0.35-0.2c-0.05,0-0.1,0.01-0.15,0.03l-0.95,0.38c-0.08-0.05-0.11-0.07-0.19-0.11l-0.15-1.01 C19.22,8.15,19.05,8,18.85,8h-1.71c-0.2,0-0.37,0.15-0.4,0.34L16.6,9.35c-0.03,0.02-0.07,0.03-0.1,0.05 c-0.03,0.02-0.06,0.04-0.09,0.06l-0.95-0.38c-0.05-0.02-0.1-0.03-0.15-0.03c-0.14,0-0.27,0.07-0.35,0.2l-0.85,1.48 c-0.1,0.17-0.06,0.39,0.1,0.51l0.8,0.63c0,0.09,0,0.13,0,0.23l-0.8,0.63c-0.16,0.12-0.2,0.34-0.1,0.51l0.85,1.48 c0.07,0.13,0.21,0.2,0.35,0.2c0.05,0,0.1-0.01,0.15-0.03l0.95-0.37c0.08,0.05,0.12,0.07,0.2,0.11l0.15,1.01 c0.03,0.2,0.2,0.34,0.4,0.34h1.71c0.2,0,0.37-0.15,0.4-0.34l0.15-1.01c0.03-0.02,0.07-0.03,0.1-0.05c0.03-0.02,0.06-0.04,0.09-0.06 l0.95,0.38c0.05,0.02,0.1,0.03,0.15,0.03c0.14,0,0.27-0.07,0.35-0.2l0.85-1.48C22.01,13.08,21.97,12.86,21.81,12.74z M18,13.5 c-0.83,0-1.5-0.67-1.5-1.5c0-0.83,0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5C19.5,12.83,18.83,13.5,18,13.5z M5,23V1h14v6h-2V6H7v12h10v-1 h2v6H5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 arrow-drop-down-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 13l-4-4h8l-4 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unfold-more
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5.83L15.17 9l1.41-1.41L12 3 7.41 7.59 8.83 9 12 5.83zm0 12.34L8.83 15l-1.41 1.41L12 21l4.59-4.59L15.17 15 12 18.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-home-work
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M15,11.68V11L8,6l-7,5v10h5v-6h4v6h1.68C11.25,20.09,11,19.08,11,18C11,15.21,12.64,12.81,15,11.68z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M23,13.11V3H10v1.97l7,5v1.11c0.33-0.05,0.66-0.08,1-0.08C19.96,11,21.73,11.81,23,13.11z M17,7h2v2h-2V7z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M23,18c0-2.76-2.24-5-5-5s-5,2.24-5,5s2.24,5,5,5S23,20.76,23,18z M17.5,21v-2.5H15v-1h2.5V15h1v2.5H21v1h-2.5V21H17.5z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 offline-share
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "6,5 4,5 4,23 16,23 16,21 6,21",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d "M20,1H8v18h12V1z M18,15h-8V5h8V15z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points
       "12.5,10.25 14.5,10.25 14.5,12 17,9.5 14.5,7 14.5,8.75 11,8.75 11,12 12.5,12",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 arrow-forward-ios
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points "6.23,20.23 8,22 18,12 8,2 6.23,3.77 14.46,12",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 chevron-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12l4.58-4.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 east
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15,5l-1.41,1.41L18.17,11H2V13h16.17l-4.59,4.59L15,19l7-7L15,5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 legend-toggle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M20,15H4v-2h16V15z M20,17H4v2h16V17z M15,11l5-3.55L20,5l-5,3.55L10,5L4,8.66L4,11l5.92-3.61L15,11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 menu-open
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3,18h13v-2H3V18z M3,13h10v-2H3V13z M3,6v2h13V6H3z M21,15.59L17.42,12L21,8.41L19.59,7l-5,5l5,5L21,15.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 switch-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M8.5,8.62v6.76L5.12,12L8.5,8.62 M10,5l-7,7l7,7V5L10,5z M14,5v14l7-7L14,5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 switch-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24",
    :transform "matrix(-1 -1.224647e-16 1.224647e-16 -1 24 24)",
    :height "24",
    :fill "none",
    :stroke nil})
  (helix.dom/path
   {:d
    "M15.5,15.38V8.62L18.88,12L15.5,15.38 M14,19l7-7l-7-7V19L14,19z M10,19V5l-7,7L10,19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 double-arrow
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "15.5,5 11,5 16,12 11,19 15.5,19 20.5,12",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8.5,5 4,5 9,12 4,19 8.5,19 13.5,12",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 home-work
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "1,11 1,21 6,21 6,15 10,15 10,21 15,21 15,11 8,6",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M10,3v1.97l7,5V11h2v2h-2v2h2v2h-2v4h6V3H10z M19,9h-2V7h2V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 north-east
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M9,5v2h6.59L4,18.59L5.41,20L17,8.41V15h2V5H9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-back
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-back-ios
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.51 3.87L15.73 2.1 5.84 12l9.9 9.9 1.77-1.77L9.38 12l8.13-8.13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 menu
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 campaign
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/path
   {:d
    "M18,11c0,0.67,0,1.33,0,2c1.2,0,2.76,0,4,0c0-0.67,0-1.33,0-2C20.76,11,19.2,11,18,11z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16,17.61c0.96,0.71,2.21,1.65,3.2,2.39c0.4-0.53,0.8-1.07,1.2-1.6c-0.99-0.74-2.24-1.68-3.2-2.4 C16.8,16.54,16.4,17.08,16,17.61z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M20.4,5.6C20,5.07,19.6,4.53,19.2,4c-0.99,0.74-2.24,1.68-3.2,2.4c0.4,0.53,0.8,1.07,1.2,1.6 C18.16,7.28,19.41,6.35,20.4,5.6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d "M8,9H2v6h3v4h2v-4h1l5,3V6L8,9z", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M15.5,12c0-1.33-0.58-2.53-1.5-3.35v6.69C14.92,14.53,15.5,13.33,15.5,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 south
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,15l-1.41-1.41L13,18.17V2H11v16.17l-4.59-4.59L5,15l7,7L19,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 south-west
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M15,19v-2H8.41L20,5.41L18.59,4L7,15.59V9H5v10H15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 more-horiz
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 waterfall-chart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,4h3v16h-3V4z M3,13h3v7H3V13z M14,4h3v3h-3V4z M10,5h3v4h-3V5z M7,10h3v4H7V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 expand-circle-down
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M12,15.5L7.5,11l1.42-1.41L12,12.67 l3.08-3.08L16.5,11L12,15.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 assistant-direction
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13.5,10H8v5h2v-3h3.5v2.5L17,11l-3.5-3.5V10z M12,1C5.9,1,1,5.9,1,12s4.9,11,11,11s11-4.9,11-11S18.1,1,12,1z M20.31,12 l-8.34,8.37L3.62,12l8.34-8.37L20.31,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 west
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M9,19l1.41-1.41L5.83,13H22V11H5.83l4.59-4.59L9,5l-7,7L9,19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fullscreen
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 check
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 apps
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-upward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M4 12l1.41 1.41L11 7.83V20h2V7.83l5.58 5.59L20 12l-8-8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 more-vert
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 0v24H0V0h24z", :stroke nil})
  (helix.dom/path {:d "M14 7l-5 5 5 5V7z", :stroke nil, :fill nil})))


(helix.core/defnc
 south-east
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M19,9h-2v6.59L5.41,4L4,5.41L15.59,17H9v2h10V9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 north-west
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M5,15h2V8.41L18.59,20L20,18.59L8.41,7H15V5H5V15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 first-page
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 0v24H0V0h24z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.41 16.59L13.82 12l4.59-4.59L17 6l-6 6 6 6 1.41-1.41zM6 6h2v12H6V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-back-ios-new
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points "17.77,3.77 16,2 6,12 16,22 17.77,20.23 9.54,12",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 arrow-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M10 17l5-5-5-5v10z", :stroke nil, :fill nil})))


(helix.core/defnc
 chevron-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6-6-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 biotech
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13,19v-2h5v-2h-8c-1.66,0-3-1.34-3-3c0-1.09,0.59-2.04,1.46-2.56C8.17,9.03,8,8.54,8,8c0-0.21,0.04-0.42,0.09-0.62 C6.28,8.13,5,9.92,5,12c0,2.76,2.24,5,5,5v2H5v2h14v-2H13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.56,5.51C11.91,5.54,13,6.64,13,8c0,0.75-0.33,1.41-0.85,1.87l0.59,1.62l0.94-0.34l0.34,0.94l1.88-0.68l-0.34-0.94 l0.94-0.34L13.76,2.6l-0.94,0.34L12.48,2L10.6,2.68l0.34,0.94L10,3.97L10.56,5.51z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "8", :cx "10.5", :stroke nil, :fill nil})))))


(helix.core/defnc
 insights
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,8c-1.45,0-2.26,1.44-1.93,2.51l-3.55,3.56c-0.3-0.09-0.74-0.09-1.04,0l-2.55-2.55C12.27,10.45,11.46,9,10,9 c-1.45,0-2.27,1.44-1.93,2.52l-4.56,4.55C2.44,15.74,1,16.55,1,18c0,1.1,0.9,2,2,2c1.45,0,2.26-1.44,1.93-2.51l4.55-4.56 c0.3,0.09,0.74,0.09,1.04,0l2.55,2.55C12.73,16.55,13.54,18,15,18c1.45,0,2.27-1.44,1.93-2.52l3.56-3.55 C21.56,12.26,23,11.45,23,10C23,8.9,22.1,8,21,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "15,9 15.94,6.93 18,6 15.94,5.07 15,3 14.08,5.07 12,6 14.08,6.93",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "3.5,11 4,9 6,8.5 4,8 3.5,6 3,8 1,8.5 3,9",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shield
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2L4,5v6.09c0,5.05,3.41,9.76,8,10.91c4.59-1.15,8-5.86,8-10.91V5L12,2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flag
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M14.4 6L14 4H5v17h2v-7h5.6l.4 2h7V6h-5.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flag-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M18,15h-5l-1-2H9.5v5H8V7h6l1,2h3V15 z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 save-as
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,12.4V7l-4-4H3v18h9.4L21,12.4z M15,15c0,1.66-1.34,3-3,3s-3-1.34-3-3s1.34-3,3-3S15,13.34,15,15z M6,6h9v4H6V6z M19.99,16.25l1.77,1.77L16.77,23H15v-1.77L19.99,16.25z M23.61,16.16l-1.2,1.2l-1.77-1.77l1.2-1.2L23.61,16.16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 font-download
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.93 13.5h4.14L12 7.98 9.93 13.5zM22 2H2v20h20V2zm-6.05 16.5l-1.14-3H9.17l-1.12 3H5.96l5.11-13h1.86l5.11 13h-2.09z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 copy-all
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20,2H7v16h13V2z M18,16H9V4h9V16z M3,15v-2h2v2H3z M3,9.5h2v2H3V9.5z M10,20h2v2h-2V20z M3,18.5v-2h2v2H3z M5,22H3v-2h2V22 z M8.5,22h-2v-2h2V22z M15.5,22h-2v-2h2V22z M3,6h2v2H3V6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 font-download-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12.58,9.75l-0.87-0.87l0.23-0.66h0.1L12.58,9.75z M20.49,23.31L19.17,22H2V4.83L0.69,3.51L2.1,2.1l19.8,19.8L20.49,23.31z M12.1,14.93l-3.3-3.3L6.41,18h2.08l1.09-3.07H12.1z M10.35,7.52L10.92,6h2.14l2.55,6.79L22,19.17V2H4.83L10.35,7.52z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path {:d "M19 13H5v-2h14v2z", :stroke nil, :fill nil})))


(helix.core/defnc
 add-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4V7zm-1-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dynamic-feed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "8,8 6,8 6,17 17,17 17,15 8,15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M22,3H10v10h12V3z M20,11h-8V7h8V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "4,12 2,12 2,21 13,21 13,19 4,19",
      :stroke nil,
      :fill nil})))
  (helix.dom/g
   {:display "none"}
   (helix.dom/g {:display "inline"})
   (helix.dom/g
    {:display "inline"}
    (helix.dom/polygon
     {:points "8,8 6,8 6,17 17,17 17,15 8,15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M22,3H10v10h12V3z M20,11h-8V7h8V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "4,12 2,12 2,21 13,21 13,19 4,19",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 select-all
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 13h2v-2H3v2zm4 8h2v-2H7v2zM3 9h2V7H3v2zm10-6h-2v2h2V3zM3 17h2v-2H3v2zM9 3H7v2h2V3zM5 3H3v2h2V3zm6 18h2v-2h-2v2zm8-8h2v-2h-2v2zm0-4h2V7h-2v2zm0 8h2v-2h-2v2zm-4 4h2v-2h-2v2zm0-16h2V3h-2v2zm4 0h2V3h-2v2zm0 16h2v-2h-2v2zM3 21h2v-2H3v2zm4-4h10V7H7v10zm2-8h6v6H9V9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-copy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M16 1H2v16h2V3h12V1zm5 4H6v18h15V5zm-2 16H8V7h11v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 inbox
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3.01v18H21V3zm-2 12h-4c0 1.66-1.35 3-3 3s-3-1.34-3-3H5V5h14v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 weekend
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 9.03V14h12V9.03h2V5H4v4.03zM19 15H5v-4.97H1V19h22v-8.97h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 inventory-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2,2v6.7h1V22h18V8.7h1V2H2z M15,14H9v-2h6V14z M20,7H4V4h16V7z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 push-pin
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:fill-rule "evenodd",
     :d
     "M16,9V4l2,0V2H6v2l2,0v5c0,1.66-1.34,3-3,3h0v2h5.97v7l1,1l1-1v-7H19v-2h0 C17.34,12,16,10.66,16,9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 calculate
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M13.03,7.06L14.09,6l1.41,1.41L16.91,6l1.06,1.06l-1.41,1.41l1.41,1.41l-1.06,1.06L15.5,9.54l-1.41,1.41 l-1.06-1.06l1.41-1.41L13.03,7.06z M6.25,7.72h5v1.5h-5V7.72z M11.5,16h-2v2H8v-2H6v-1.5h2v-2h1.5v2h2V16z M18,17.25h-5v-1.5h5 V17.25z M18,14.75h-5v-1.5h5V14.75z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 archive
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.71 3H5.29L3 5.79V21h18V5.79L18.71 3zM12 17.5L6.5 12H10v-2h4v2h3.5L12 17.5zM5.12 5l.81-1h12l.94 1H5.12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sort
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M3 18h6v-2H3v2zM3 6v2h18V6H3zm0 7h12v-2H3v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 how-to-vote
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 13h-.68l-2 2h1.91L19 17H5l1.78-2h2.05l-2-2H6l-3 3v6h18v-6zm1.81-5.04L13.45 1.6 5.68 9.36l6.36 6.36 7.77-7.76zm-6.35-3.55L17 7.95l-4.95 4.95-3.54-3.54 4.95-4.95z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 how-to-reg
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 17l3-2.94c-.39-.04-.68-.06-1-.06-2.67 0-8 1.34-8 4v2h9l-3-3zm2-5c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15.47 20.5L12 17l1.4-1.41 2.07 2.08 5.13-5.17 1.4 1.41-6.53 6.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 bolt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M11,21h-1l1-7H6.74c0,0,3.68-6.46,6.26-11h1l-1,7h4.28L11,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 change-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M12.06,19v-2.01c-0.02,0-0.04,0-0.06,0 c-1.28,0-2.56-0.49-3.54-1.46c-1.71-1.71-1.92-4.35-0.64-6.29l1.1,1.1c-0.71,1.33-0.53,3.01,0.59,4.13c0.7,0.7,1.62,1.03,2.54,1.01 v-2.14l2.83,2.83L12.06,19z M16.17,14.76l-1.1-1.1c0.71-1.33,0.53-3.01-0.59-4.13C13.79,8.84,12.9,8.5,12,8.5c-0.02,0-0.04,0-0.06,0 v2.15L9.11,7.83L11.94,5v2.02c1.3-0.02,2.61,0.45,3.6,1.45C17.24,10.17,17.45,12.82,16.17,14.76z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-cut
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.64 7.64c.23-.5.36-1.05.36-1.64 0-2.21-1.79-4-4-4S2 3.79 2 6s1.79 4 4 4c.59 0 1.14-.13 1.64-.36L10 12l-2.36 2.36C7.14 14.13 6.59 14 6 14c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4c0-.59-.13-1.14-.36-1.64L12 14l7 7h3v-1L9.64 7.64zM6 8c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2zm0 12c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2zm6-7.5c-.28 0-.5-.22-.5-.5s.22-.5.5-.5.5.22.5.5-.22.5-.5.5zM19 3l-6 6 2 2 7-7V3h-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-paste-go
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M5,5h2v3h10V5h2v6h2V3h-6.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H3v18h7v-2H5V5z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1 s-1-0.45-1-1S11.45,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "18.01,13 16.59,14.41 18.17,15.99 12,15.99 12,17.99 18.17,17.99 16.59,19.58 18.01,20.99 22,16.99",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 redo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.4 10.6C16.55 8.99 14.15 8 11.5 8c-4.65 0-8.58 3.03-9.96 7.22L3.9 16c1.05-3.19 4.05-5.5 7.6-5.5 1.95 0 3.73.72 5.12 1.88L13 16h9V7l-3.6 3.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-list
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10 18h4v-2h-4v2zM3 6v2h18V6H3zm3 7h12v-2H6v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mail
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 4H2v16h20V4zm-2 4l-8 5-8-5V6l8 5 8-5v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 drafts
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21.99 6.86L12 1 2 6.86V20h20l-.01-13.14zM12 13L3.74 7.84 12 3l8.26 4.84L12 13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 link-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.39 11L16 12.61V11zM17 7h-4v1.9h4c1.71 0 3.1 1.39 3.1 3.1 0 1.27-.77 2.37-1.87 2.84l1.4 1.4C21.05 15.36 22 13.79 22 12c0-2.76-2.24-5-5-5zM2 4.27l3.11 3.11C3.29 8.12 2 9.91 2 12c0 2.76 2.24 5 5 5h4v-1.9H7c-1.71 0-3.1-1.39-3.1-3.1 0-1.59 1.21-2.9 2.76-3.07L8.73 11H8v2h2.73L13 15.27V17h1.73l4.01 4.01 1.41-1.41L3.41 2.86 2 4.27z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-paste
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 2h-6.18C14.4.84 13.3 0 12 0S9.6.84 9.18 2H3v20h18V2zm-9 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm7 18H5V4h2v3h10V4h2v16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 stream
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "12", :cx "20", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "2", :cy "12", :cx "4", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "2", :cy "20", :cx "12", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "6.13",
      :x "13.74",
      :width "6.22",
      :transform
      "matrix(0.7081 -0.7061 0.7061 0.7081 -0.1146 13.9802)",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8.32,9.68 8.63,10 10.05,8.59 6.03,4.55 6.02,4.55 5.71,4.23 4.29,5.64 8.31,9.69",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "15.41,13.94 14,15.35 17.99,19.36 18.34,19.71 19.76,18.3 15.77,14.29",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8.59,13.95 4.56,17.96 4.24,18.29 5.65,19.7 9.68,15.68 10.01,15.36",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 remove-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11H7v-2h10v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 11v2h10v-2H7zm5-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 amp-stories
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "4",
      :x "7",
      :width "10",
      :height "15",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6",
      :x "3",
      :width "2",
      :height "11",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6",
      :x "19",
      :width "2",
      :height "11",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 deselect
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M3,13h2v-2H3V13z M7,21h2v-2H7V21z M13,3h-2v2h2V3z M19,3v2h2V3H19z M5,21v-2H3v2H5z M3,17h2v-2H3V17z M11,21h2v-2h-2V21z M19,13h2v-2h-2V13z M19,9h2V7h-2V9z M15,5h2V3h-2V5z M7.83,5L7,4.17V3h2v2H7.83z M19.83,17L19,16.17V15h2v2H19.83z M21.19,21.19 L2.81,2.81L1.39,4.22L4.17,7H3v2h2V7.83l2,2V17h7.17l2,2H15v2h2v-1.17l2.78,2.78L21.19,21.19z M9,15v-3.17L12.17,15H9z M15,12.17V9 h-3.17l-2-2H17v7.17L15,12.17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 undo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.5 8c-2.65 0-5.05.99-6.9 2.6L2 7v9h9l-3.62-3.62c1.39-1.16 3.16-1.88 5.12-1.88 3.54 0 6.55 2.31 7.6 5.5l2.37-.78C21.08 11.03 17.15 8 12.5 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-paste-search
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M5,5h2v3h10V5h2v5h2V3h-6.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H3v18h7v-2H5V5z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1 s-1-0.45-1-1S11.45,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.3,18.9c0.4-0.7,0.7-1.5,0.7-2.4c0-2.5-2-4.5-4.5-4.5S12,14,12,16.5s2,4.5,4.5,4.5c0.9,0,1.7-0.3,2.4-0.7l2.7,2.7 l1.4-1.4L20.3,18.9z M16.5,19c-1.4,0-2.5-1.1-2.5-2.5c0-1.4,1.1-2.5,2.5-2.5s2.5,1.1,2.5,2.5C19,17.9,17.9,19,16.5,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 file-copy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M16 1H2v16h2V3h12V1zm-1 4l6 6v12H6V5h9zm-1 7h5.5L14 6.5V12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 text-format
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 17v2h14v-2H5zm4.5-4.2h5l.9 2.2h2.1L12.75 4h-1.5L6.5 15h2.1l.9-2.2zM12 5.98L13.87 11h-3.74L12 5.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unarchive
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.71 3H5.29L3 5.79V21h18V5.79L18.71 3zM14 15v2h-4v-2H6.5L12 9.5l5.5 5.5H14zM5.12 5l.81-1h12l.94 1H5.12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 clear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 markunread
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 4H2v16h20V4zm-2 4l-8 5-8-5V6l8 5 8-5v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 where-to-vote
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C8.14 2 5 5.14 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.86-3.14-7-7-7zm-1.53 12l-3.48-3.48L8.4 9.1l2.07 2.07 5.13-5.14 1.41 1.42L10.47 14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 reply-all
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 8V5l-7 7 7 7v-3l-4-4 4-4zm6 1V5l-7 7 7 7v-4.1c5 0 8.5 1.6 11 5.1-1-5-4-10-11-11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 reply
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10 9V5l-7 7 7 7v-4.1c5 0 8.5 1.6 11 5.1-1-5-4-10-11-11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 save-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 12v7H5v-7H3v9h18v-9h-2zm-6 .67l2.59-2.58L17 11.5l-5 5-5-5 1.41-1.41L11 12.67V3h2v9.67z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 report-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 7h2v2.33l7.2 7.2.8-.8V8.27L15.73 3H8.27l-.8.8L11 7.33zM2.41 1.58L1 2.99l3.64 3.64L3 8.27v7.46L8.27 21h7.46l1.64-1.64L21.01 23l1.41-1.41L2.41 1.58zM11 12.99l.01.01H11v-.01zm1 4.31c-.72 0-1.3-.58-1.3-1.3 0-.72.58-1.3 1.3-1.3s1.3.58 1.3 1.3c0 .72-.58 1.3-1.3 1.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z", :stroke nil, :fill nil})))


(helix.core/defnc
 link
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 7h-4v2h4c1.65 0 3 1.35 3 3s-1.35 3-3 3h-4v2h4c2.76 0 5-2.24 5-5s-2.24-5-5-5zm-6 8H7c-1.65 0-3-1.35-3-3s1.35-3 3-3h4V7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h4v-2zm-3-4h8v2H8zm9-4h-4v2h4c1.65 0 3 1.35 3 3s-1.35 3-3 3h-4v2h4c2.76 0 5-2.24 5-5s-2.24-5-5-5zm-6 8H7c-1.65 0-3-1.35-3-3s1.35-3 3-3h4V7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h4v-2zm-3-4h8v2H8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-box
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3H3v18h18V3zm-4 10h-4v4h-2v-4H7v-2h4V7h2v4h4v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 gesture
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4.59 6.89c.7-.71 1.4-1.35 1.71-1.22.5.2 0 1.03-.3 1.52-.25.42-2.86 3.89-2.86 6.31 0 1.28.48 2.34 1.34 2.98.75.56 1.74.73 2.64.46 1.07-.31 1.95-1.4 3.06-2.77 1.21-1.49 2.83-3.44 4.08-3.44 1.63 0 1.65 1.01 1.76 1.79-3.78.64-5.38 3.67-5.38 5.37 0 1.7 1.44 3.09 3.21 3.09 1.63 0 4.29-1.33 4.69-6.1H21v-2.5h-2.47c-.15-1.65-1.09-4.2-4.03-4.2-2.25 0-4.18 1.91-4.94 2.84-.58.73-2.06 2.48-2.29 2.72-.25.3-.68.84-1.11.84-.45 0-.72-.83-.36-1.92.35-1.09 1.4-2.86 1.85-3.52.78-1.14 1.3-1.92 1.3-3.28C8.95 3.69 7.31 3 6.44 3 5.12 3 3.97 4 3.72 4.25c-.36.36-.66.66-.88.93l1.75 1.71zm9.29 11.66c-.31 0-.74-.26-.74-.72 0-.6.73-2.2 2.87-2.76-.3 2.69-1.43 3.48-2.13 3.48z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web-stories
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,4c1.1,0,2,0,2,0v16c0,0-0.9,0-2,0V4z M2,2v20h13V2H2z M21,18c0.83,0,1.5,0,1.5,0V6c0,0-0.67,0-1.5,0V18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 next-week
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 7h-6V5c0-.55-.22-1.05-.59-1.41C15.05 3.22 14.55 3 14 3h-4c-1.1 0-2 .9-2 2v2H2v15h20V7zM10 5h4v2h-4V5zm1 13.5l-1-1 3-3-3-3 1-1 4 4-4 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 inventory
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M5,5h2v3h10V5h2v5h2V3h-6.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H3v18h8v-2H5V5z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1 s-1-0.45-1-1S11.45,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "21,11.5 15.51,17 12.5,14 11,15.5 15.51,20 22.5,13",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 attribution
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm-2.75-5.5h1.5V19h2.5v-4.5h1.5v-6h-5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "6.5", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 waves
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 16.99c-1.35 0-2.2.42-2.95.8-.65.33-1.18.6-2.05.6-.9 0-1.4-.25-2.05-.6-.75-.38-1.57-.8-2.95-.8s-2.2.42-2.95.8c-.65.33-1.17.6-2.05.6v1.95c1.35 0 2.2-.42 2.95-.8.65-.33 1.17-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.42 2.95-.8c.65-.33 1.18-.6 2.05-.6.9 0 1.4.25 2.05.6.75.38 1.58.8 2.95.8v-1.95c-.9 0-1.4-.25-2.05-.6-.75-.38-1.6-.8-2.95-.8zm0-4.45c-1.35 0-2.2.43-2.95.8-.65.32-1.18.6-2.05.6-.9 0-1.4-.25-2.05-.6-.75-.38-1.57-.8-2.95-.8s-2.2.43-2.95.8c-.65.32-1.17.6-2.05.6v1.95c1.35 0 2.2-.43 2.95-.8.65-.35 1.15-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.43 2.95-.8c.65-.35 1.15-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.58.8 2.95.8v-1.95c-.9 0-1.4-.25-2.05-.6-.75-.38-1.6-.8-2.95-.8zm2.95-8.08c-.75-.38-1.58-.8-2.95-.8s-2.2.42-2.95.8c-.65.32-1.18.6-2.05.6-.9 0-1.4-.25-2.05-.6-.75-.37-1.57-.8-2.95-.8s-2.2.42-2.95.8c-.65.33-1.17.6-2.05.6v1.93c1.35 0 2.2-.43 2.95-.8.65-.33 1.17-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.43 2.95-.8c.65-.32 1.18-.6 2.05-.6.9 0 1.4.25 2.05.6.75.38 1.58.8 2.95.8V5.04c-.9 0-1.4-.25-2.05-.58zM17 8.09c-1.35 0-2.2.43-2.95.8-.65.35-1.15.6-2.05.6s-1.4-.25-2.05-.6c-.75-.38-1.57-.8-2.95-.8s-2.2.43-2.95.8c-.65.35-1.15.6-2.05.6v1.95c1.35 0 2.2-.43 2.95-.8.65-.32 1.18-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.43 2.95-.8c.65-.32 1.18-.6 2.05-.6.9 0 1.4.25 2.05.6.75.38 1.58.8 2.95.8V9.49c-.9 0-1.4-.25-2.05-.6-.75-.38-1.6-.8-2.95-.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ballot
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 9.5h5v-2h-5v2zm0 7h5v-2h-5v2zm8 4.5H3V3h18v18zM6 11h5V6H6v5zm1-4h3v3H7V7zM6 18h5v-5H6v5zm1-4h3v3H7v-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 backspace
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M24 3H6l-6 9 6 9h18V3zm-5 12.59L17.59 17 14 13.41 10.41 17 9 15.59 12.59 12 9 8.41 10.41 7 14 10.59 17.59 7 19 8.41 15.41 12 19 15.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-list-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10.83,8H21V6H8.83L10.83,8z M15.83,13H18v-2h-4.17L15.83,13z M14,16.83V18h-4v-2h3.17l-3-3H6v-2h2.17l-3-3H3V6h0.17 L1.39,4.22l1.41-1.41l18.38,18.38l-1.41,1.41L14,16.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 content-paste-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21.19,21.19L2.81,2.81L1.39,4.22L3,5.83V21h15.17l1.61,1.61L21.19,21.19z M5,19V7.83L16.17,19H5z M17,8V5h2v11.17l2,2V3 h-6.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H5.83l5,5H17z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S11.45,3,12,3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 report
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.73 3H8.27L3 8.27v7.46L8.27 21h7.46L21 15.73V8.27L15.73 3zM12 17.3c-.72 0-1.3-.58-1.3-1.3s.58-1.3 1.3-1.3 1.3.58 1.3 1.3-.58 1.3-1.3 1.3zm1-4.3h-2V7h2v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 delete-sweep
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 16h4v2h-4v-2zm0-8h7v2h-7V8zm0 4h6v2h-6v-2zM3 20h10V8H3v12zM14 5h-3l-1-1H6L5 5H2v2h12V5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 square-foot
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.66,17.66l-1.06,1.06l-0.71-0.71l1.06-1.06l-1.94-1.94l-1.06,1.06l-0.71-0.71l1.06-1.06l-1.94-1.94l-1.06,1.06 l-0.71-0.71l1.06-1.06L9.7,9.7l-1.06,1.06l-0.71-0.71l1.06-1.06L7.05,7.05L5.99,8.11L5.28,7.4l1.06-1.06L4,4v16h16L17.66,17.66z M7,17v-5.76L12.76,17H7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 upcoming
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.16,7.26l-1.41-1.41L16.19,9.4l1.41,1.41C17.6,10.81,21.05,7.29,21.16,7.26z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "3",
      :x "11",
      :width "2",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M6.4,10.81L7.81,9.4L4.26,5.84L2.84,7.26C2.95,7.29,6.4,10.81,6.4,10.81z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M22,12h-7c0,1.66-1.34,3-3,3s-3-1.34-3-3H2v9h20V12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-link
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,11h8v2H8V11z M20.1,12H22c0-2.76-2.24-5-5-5h-4v1.9h4C18.71,8.9,20.1,10.29,20.1,12z M3.9,12c0-1.71,1.39-3.1,3.1-3.1h4 V7H7c-2.76,0-5,2.24-5,5s2.24,5,5,5h4v-1.9H7C5.29,15.1,3.9,13.71,3.9,12z M19,12h-2v3h-3v2h3v3h2v-3h3v-2h-3V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 outlined-flag
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M14 6l-1-2H5v17h2v-7h5l1 2h7V6h-6zm4 8h-4l-1-2H7V6h5l1 2h5v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 report-gmailerrorred
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.73 3H8.27L3 8.27v7.46L8.27 21h7.46L21 15.73V8.27L15.73 3zM19 14.9L14.9 19H9.1L5 14.9V9.1L9.1 5h5.8L19 9.1v5.8z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path {:d "M11 7h2v7h-2z", :stroke nil, :fill nil})))


(helix.core/defnc
 save
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 3H3v18h18V7l-4-4zm-5 16c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm3-10H5V5h10v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 send
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M2.01 21L23 12 2.01 3 2 10l15 2-15 2 .01 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 create
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM21.41 6.34l-3.75-3.75-2.53 2.54 3.75 3.75 2.53-2.54z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 stacked-bar-chart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "9",
      :x "4",
      :width "4",
      :height "11",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4", :x "4", :width "4", :height "4", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "7",
      :x "10",
      :width "4",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "16",
      :width "4",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "16",
      :width "4",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "10",
      :width "4",
      :height "8",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 tag
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,10V8h-4V4h-2v4h-4V4H8v4H4v2h4v4H4v2h4v4h2v-4h4v4h2v-4h4v-2h-4v-4H20z M14,14h-4v-4h4V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 low-priority
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 5h8v2h-8V5zm0 5.5h8v2h-8v-2zm0 5.5h8v2h-8v-2zM2 11.5C2 15.08 4.92 18 8.5 18H9v2l3-3-3-3v2h-.5C6.02 16 4 13.98 4 11.5S6.02 7 8.5 7H12V5H8.5C4.92 5 2 7.92 2 11.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 forward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M12 8V4l8 8-8 8v-4H4V8h8z", :stroke nil, :fill nil})))


(helix.core/defnc
 policy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,5l-9-4L3,5v6c0,5.55,3.84,10.74,9,12c2.3-0.56,4.33-1.9,5.88-3.71l-3.12-3.12c-1.94,1.29-4.58,1.07-6.29-0.64 c-1.95-1.95-1.95-5.12,0-7.07c1.95-1.95,5.12-1.95,7.07,0c1.71,1.71,1.92,4.35,0.64,6.29l2.9,2.9C20.29,15.69,21,13.38,21,11V5z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "3", :cy "12", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 move-to-inbox
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3v18h18V3zm-2 12h-4c0 1.66-1.35 3-3 3s-3-1.34-3-3H4.99V5H19v10zm-3-5h-2V7h-4v3H8l4 4 4-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 block
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM4 12c0-4.42 3.58-8 8-8 1.85 0 3.55.63 4.9 1.69L5.69 16.9C4.63 15.55 4 13.85 4 12zm8 8c-1.85 0-3.55-.63-4.9-1.69L18.31 7.1C19.37 8.45 20 10.15 20 12c0 4.42-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 assistant-photo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M14.4 6L14 4H5v17h2v-7h5.6l.4 2h7V6h-5.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-4
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69L23.31 12 20 8.69zM12 18c-.89 0-1.74-.2-2.5-.55C11.56 16.5 13 14.42 13 12s-1.44-4.5-3.5-5.45C10.26 6.2 11.11 6 12 6c3.31 0 6 2.69 6 6s-2.69 6-6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-fix-high
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "20,7 20.94,4.94 23,4 20.94,3.06 20,1 19.06,3.06 17,4 19.06,4.94",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8.5,7 9.44,4.94 11.5,4 9.44,3.06 8.5,1 7.56,3.06 5.5,4 7.56,4.94",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20,12.5 19.06,14.56 17,15.5 19.06,16.44 20,18.5 20.94,16.44 23,15.5 20.94,14.56",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.41,9.83l-4.24-4.24L1.59,18.17l4.24,4.24L18.41,9.83z M14.21,11.21l-1.41-1.41l1.38-1.38l1.41,1.41L14.21,11.21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 broken-image
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3v8.59l-3-3.01-4 4.01-4-4-4 4-3-3.01V3h18zm-3 8.42l3 3.01V21H3v-8.58l3 2.99 4-4 4 4 4-3.99z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 2c-1.05 0-2.05.16-3 .46 4.06 1.27 7 5.06 7 9.54s-2.94 8.27-7 9.54c.95.3 1.95.46 3 .46 5.52 0 10-4.48 10-10S14.52 2 9 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 assistant
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 2H3v18h6l3 3 3-3h6V2zm-7.12 10.88L12 17l-1.88-4.12L6 11l4.12-1.88L12 5l1.88 4.12L18 11l-4.12 1.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 grid-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8 4v.89l2 2V4h4v4h-2.89l2 2H14v.89l2 2V10h4v4h-2.89l2 2H20v.89l2 2V2H5.11l2 2H8zm8 0h4v4h-4V4zM1.41 1.14L0 2.55l2 2V22h17.45l2.01 2.01 1.41-1.41L1.41 1.14zM10 12.55L11.45 14H10v-1.45zm-6-6L5.45 8H4V6.55zM8 20H4v-4h4v4zm0-6H4v-4h3.45l.55.55V14zm6 6h-4v-4h3.45l.55.55V20zm2 0v-1.45L17.45 20H16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 monochrome-photos
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 5h-5.2L15 3H9L7.2 5H2v16h20V5zm-2 14h-8v-1c-2.8 0-5-2.2-5-5s2.2-5 5-5V7h8v12zm-3-6c0-2.8-2.2-5-5-5v1.8c1.8 0 3.2 1.4 3.2 3.2s-1.4 3.2-3.2 3.2V18c2.8 0 5-2.2 5-5zm-8.2 0c0 1.8 1.4 3.2 3.2 3.2V9.8c-1.8 0-3.2 1.4-3.2 3.2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flip-camera-ios
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16.83,5L15,3H9L7.17,5H2v16h20V5H16.83z M12,18c-2.76,0-5-2.24-5-5H5l2.5-2.5L10,13H8c0,2.21,1.79,4,4,4 c0.58,0,1.13-0.13,1.62-0.35l0.74,0.74C13.65,17.76,12.86,18,12,18z M16.5,15.5L14,13h2c0-2.21-1.79-4-4-4 c-0.58,0-1.13,0.13-1.62,0.35L9.64,8.62C10.35,8.24,11.14,8,12,8c2.76,0,5,2.24,5,5h2L16.5,15.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 gradient
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 9h2v2h-2V9zm-2 2h2v2H9v-2zm4 0h2v2h-2v-2zm2-2h2v2h-2V9zM7 9h2v2H7V9zm14-6H3v18h18V3zM9 18H7v-2h2v2zm4 0h-2v-2h2v2zm4 0h-2v-2h2v2zm2-7h-2v2h2v2h-2v-2h-2v2h-2v-2h-2v2H9v-2H7v2H5v-2h2v-2H5V5h14v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 switch-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 4h-5.17L15 2H9L7.17 4H2v16h20V4zm-7 11.5V13H9v2.5L5.5 12 9 8.5V11h6V8.5l3.5 3.5-3.5 3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove-red-eye
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vrpano
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,5.5c-5.25,0-9.01-1.54-10-1.92V20.4c2.16-0.76,5.21-1.9,10-1.9c4.78,0,7.91,1.17,10,1.9V3.6 C19.91,4.33,16.77,5.5,12,5.5z M12,15c-2.34,0-4.52,0.15-6.52,0.41l3.69-4.42l2,2.4L14,10l4.51,5.4C16.52,15.15,14.3,15,12,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 incomplete-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,12c0,5.52-4.48,10-10,10S2,17.52,2,12c0-2.76,1.12-5.26,2.93-7.07L12,12V2C17.52,2,22,6.48,22,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-fix-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "20,7 20.94,4.94 23,4 20.94,3.06 20,1 19.06,3.06 17,4 19.06,4.94",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.17,8.42 15.58,9.83 14.12,11.29 15.54,12.71 18.41,9.83 14.17,5.59 11.29,8.46 12.71,9.88",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "1.39,4.22 8.46,11.29 1.59,18.17 5.83,22.41 12.71,15.54 19.78,22.61 21.19,21.19 2.81,2.81",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _23mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M6.5,8h3V7h-3V5.5H11V9H8v1h3v1.5H6.5V8z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M13,10h3V9 h-2V8h2V7h-3V5.5h4.5v6H13V10z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 video-camera-front
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,10.48V4H2v16h16v-6.48l4,3.98v-11L18,10.48z M10,8c1.1,0,2,0.9,2,2s-0.9,2-2,2s-2-0.9-2-2S8.9,8,10,8z M14,16H6v-0.57 c0-0.81,0.48-1.53,1.22-1.85C8.07,13.21,9.01,13,10,13c0.99,0,1.93,0.21,2.78,0.58C13.52,13.9,14,14.62,14,15.43V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 view-comfy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M2,4v7h20V4H2z M10,20h12v-7H10V20z M2,20h6v-7H2V20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 brightness-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 2c-1.82 0-3.53.5-5 1.35C7.99 5.08 10 8.3 10 12s-2.01 6.92-5 8.65C6.47 21.5 8.18 22 10 22c5.52 0 10-4.48 10-10S15.52 2 10 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-cloudy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.37 10.04C18.68 6.59 15.65 4 12.01 4c-2.89 0-5.4 1.64-6.65 4.04C2.35 8.36.01 10.91.01 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.64-4.96z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 15.31L23.31 12 20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69zM12 18c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 leak-remove
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 3h-2c0 1.35-.31 2.63-.84 3.77l1.49 1.49C13.51 6.7 14 4.91 14 3zm7 9v-2c-1.91 0-3.7.49-5.27 1.35l1.49 1.49c1.15-.53 2.43-.84 3.78-.84zm0 4v-2c-.79 0-1.54.13-2.24.37l1.68 1.68c.19-.01.37-.05.56-.05zM10 3H8c0 .19-.04.37-.06.56l1.68 1.68c.25-.7.38-1.46.38-2.24zm-5.59-.14L3 4.27l2.84 2.84C5.03 7.67 4.06 8 3 8v2c1.61 0 3.09-.55 4.27-1.46L8.7 9.97C7.14 11.24 5.16 12 3 12v2c2.72 0 5.2-.99 7.11-2.62l2.51 2.51C10.99 15.81 10 18.29 10 21h2c0-2.16.76-4.14 2.03-5.7l1.43 1.43C14.55 17.91 14 19.39 14 21h2c0-1.06.33-2.03.89-2.84L19.73 21l1.41-1.41L4.41 2.86z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 burst-mode
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M1 5h2v14H1V5zm4 0h2v14H5V5zm18 0H9v14h14V5zM11 17l2.5-3.15L15.29 16l2.5-3.22L21 17H11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 picture-as-pdf
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 2H6v16h16V2zm-10.5 9H9v2H7.5V7h4v4zm5 .5c0 .83-.67 1.5-1.5 1.5h-2.5V7H15c.83 0 1.5.67 1.5 1.5v3zm4-3H19v1h1.5V11H19v2h-1.5V7h3v1.5zM9 9.5h1v-1H9v1zM4 6H2v16h16v-2H4V6zm10 5.5h1v-3h-1v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3v18h18V3zM6 7h5v1.5H6V7zm13 12H5L19 5v14zm-4.5-3v2H16v-2h2v-1.5h-2v-2h-1.5v2h-2V16h2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 audiotrack
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 3v10.55c-.59-.34-1.27-.55-2-.55-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4V7h4V3h-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-tilt-shift
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 4.07V2.05c-2.01.2-3.84 1-5.32 2.21L7.1 5.69c1.11-.86 2.44-1.44 3.9-1.62zm7.32.19C16.84 3.05 15.01 2.25 13 2.05v2.02c1.46.18 2.79.76 3.9 1.62l1.42-1.43zM19.93 11h2.02c-.2-2.01-1-3.84-2.21-5.32L18.31 7.1c.86 1.11 1.44 2.44 1.62 3.9zM5.69 7.1L4.26 5.68C3.05 7.16 2.25 8.99 2.05 11h2.02c.18-1.46.76-2.79 1.62-3.9zM4.07 13H2.05c.2 2.01 1 3.84 2.21 5.32l1.43-1.43c-.86-1.1-1.44-2.43-1.62-3.89zM15 12c0-1.66-1.34-3-3-3s-3 1.34-3 3 1.34 3 3 3 3-1.34 3-3zm3.31 4.9l1.43 1.43c1.21-1.48 2.01-3.32 2.21-5.32h-2.02c-.18 1.45-.76 2.78-1.62 3.89zM13 19.93v2.02c2.01-.2 3.84-1 5.32-2.21l-1.43-1.43c-1.1.86-2.43 1.44-3.89 1.62zm-7.32-.19C7.16 20.95 9 21.75 11 21.95v-2.02c-1.46-.18-2.79-.76-3.9-1.62l-1.42 1.43z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 adjust
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.49 2 2 6.49 2 12s4.49 10 10 10 10-4.49 10-10S17.51 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm3-8c0 1.66-1.34 3-3 3s-3-1.34-3-3 1.34-3 3-3 3 1.34 3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 camera-rear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 20H5v2h5v2l3-3-3-3v2zm4 0v2h5v-2h-5zm5-20H5v18h14V0zm-7 6c-1.11 0-2-.9-2-2s.89-2 1.99-2 2 .9 2 2C14 5.1 13.1 6 12 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-awesome
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,9l1.25-2.75L23,5l-2.75-1.25L19,1l-1.25,2.75L15,5l2.75,1.25L19,9z M11.5,9.5L9,4L6.5,9.5L1,12l5.5,2.5L9,20l2.5-5.5 L17,12L11.5,9.5z M19,15l-1.25,2.75L15,19l2.75,1.25L19,23l1.25-2.75L23,19l-2.75-1.25L19,15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 tag-faces
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.01 2C6.49 2 2.02 6.48 2.02 12s4.47 10 9.99 10c5.53 0 10.01-4.48 10.01-10S17.54 2 12.01 2zm.01 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm3.5-9c.83 0 1.5-.67 1.5-1.5S16.35 8 15.52 8s-1.5.67-1.5 1.5.67 1.5 1.5 1.5zm-7 0c.83 0 1.5-.67 1.5-1.5S9.35 8 8.52 8s-1.5.67-1.5 1.5.67 1.5 1.5 1.5zm3.5 6.5c2.33 0 4.31-1.46 5.11-3.5H6.91c.8 2.04 2.78 3.5 5.11 3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 raw-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "17.15,14.32 17.74,11.96 18.5,15 19.98,15 21.48,9 19.98,9 19.24,12 18.5,9 16.98,9 16.24,12 15.5,9 14,9 14.72,11.9",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1.39,4.22L6.17,9H3v6h1.5v-2h1.1l0.9,2H8l-0.9-2.1C7.6,12.6,8,12.1,8,11.5v-0.67l1.43,1.43L8.75,15h1.5l0.38-1.5h0.04 l9.11,9.11l1.41-1.41L2.81,2.81L1.39,4.22z M6.5,11.5h-2v-1h2V11.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 music-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 9.61V7h4V3h-6v4.61zM4.41 2.86L3 4.27l9 9v.28c-.94-.54-2.1-.75-3.33-.32-1.34.48-2.37 1.67-2.61 3.07-.46 2.74 1.86 5.08 4.59 4.65 1.96-.31 3.35-2.11 3.35-4.1v-1.58L19.73 21l1.41-1.41L12 10.44 4.41 2.86z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-library
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 18V2H6v16h16zm-11-6l2.03 2.71L16 11l4 5H8l3-4zM2 6v16h16v-2H4V6H2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-sunny
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6.76 4.84l-1.8-1.79-1.41 1.41 1.79 1.79 1.42-1.41zM4 10.5H1v2h3v-2zm9-9.95h-2V3.5h2V.55zm7.45 3.91l-1.41-1.41-1.79 1.79 1.41 1.41 1.79-1.79zm-3.21 13.7l1.79 1.8 1.41-1.41-1.8-1.79-1.4 1.4zM20 10.5v2h3v-2h-3zm-8-5c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zm-1 16.95h2V19.5h-2v2.95zm-7.45-3.91l1.41 1.41 1.79-1.8-1.41-1.41-1.79 1.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _16mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M12,5.5h4.5V7h-3v1h3v3.5H12V5.5z M7,5.5h3v6H8.5V7H7V5.5z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5 V18.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "13.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flash-auto
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 2v12h3v9l7-12H9l4-9H3zm16 0h-2l-3.2 9h1.9l.7-2h3.2l.7 2h1.9L19 2zm-2.15 5.65L18 4l1.15 3.65h-2.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _3mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M10,10h3V9h-2V8h2V7h-3V5.5h4.5v6H10V10z M18,17h-3 v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-16-9
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d "M21,7H3v10h18V7z M19,15H5V9h14V15z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 _9mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M10,10h3V9h-3V5.5h4.5v6H10V10z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M18,17h-3v1.5h-1.5 v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.5",
      :x "11.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 bedtime-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M21.19 21.19 2.81 2.81 1.39 4.22l2.27 2.27C2.61 8.08 2 9.97 2 12c0 5.52 4.48 10 10 10 2.04 0 3.93-.62 5.51-1.66l2.27 2.27 1.41-1.42z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12.34 2.02c-2.18-.07-4.19.55-5.85 1.64l4.59 4.59c-.27-2.05.1-4.22 1.26-6.23z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 currency-franc
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "18,5 18,3 7,3 7,16 5,16 5,18 7,18 7,21 9,21 9,18 13,18 13,16 9,16 9,13 17,13 17,11 9,11 9,5",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 crop-rotate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.47 21.49C4.2 19.93 1.86 16.76 1.5 13H0c.51 6.16 5.66 11 11.95 11 .23 0 .44-.02.66-.03L8.8 20.15l-1.33 1.34zM12.05 0c-.23 0-.44.02-.66.04l3.81 3.81 1.33-1.33C19.8 4.07 22.14 7.24 22.5 11H24c-.51-6.16-5.66-11-11.95-11zM16 14h2V6h-8v2h6v6zm-8 2V4H6v2H4v2h2v10h10v2h2v-2h2v-2H8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-paused
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M22,12c0,5.52-4.48,10-10,10S2,17.52,2,12c0-1.19,0.22-2.32,0.6-3.38L4.48,9.3C4.17,10.14,4,11.05,4,12c0,4.41,3.59,8,8,8 s8-3.59,8-8s-3.59-8-8-8c-0.95,0-1.85,0.17-2.69,0.48L8.63,2.59C9.69,2.22,10.82,2,12,2C17.52,2,22,6.48,22,12z M5.5,4 C4.67,4,4,4.67,4,5.5S4.67,7,5.5,7S7,6.33,7,5.5S6.33,4,5.5,4z M11,16V8H9v8H11z M15,16V8h-2v8H15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 blur-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "14", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M13.8 11.48l.2.02c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5l.02.2c.09.67.61 1.19 1.28 1.28zM14 3.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm-4 0c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "10", :cx "18", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "18", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M21 10.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "10", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "14", :cx "18", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "18", :cx "6", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M14 20.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm7-7c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm-18 0c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "18", :cx "10", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M3 9.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm7 11c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "14", :cx "6", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M2.5 5.27L6 8.77l.28.28L6 9c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1c0-.1-.03-.19-.06-.28l2.81 2.81c-.71.11-1.25.73-1.25 1.47 0 .83.67 1.5 1.5 1.5.74 0 1.36-.54 1.47-1.25l2.81 2.81c-.09-.03-.18-.06-.28-.06-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1c0-.1-.03-.19-.06-.28l3.78 3.78h.01l1.41-1.41L3.91 3.86 2.5 5.27z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _18mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "9",
      :x "13.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.5",
      :x "13.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M12,5.5h4.5v6H12V5.5z M7,5.5h3v6H8.5V7H7V5.5z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera-front
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 20H5v2h5v2l3-3-3-3v2zm4 0v2h5v-2h-5zM12 8c1.1 0 2-.9 2-2s-.9-2-2-2-1.99.9-1.99 2S10.9 8 12 8zm7-8H5v18h14V0zM7 2h10v10.5c0-1.67-3.33-2.5-5-2.5s-5 .83-5 2.5V2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-none
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M3 5H1v18h18v-2H3V5zm20-4H5v18h18V1zm-2 16H7V3h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-weak
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm12-2c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zm0 10c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-vintage
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.7 12.4c-.28-.16-.57-.29-.86-.4.29-.11.58-.24.86-.4 1.92-1.11 2.99-3.12 3-5.19-1.79-1.03-4.07-1.11-6 0-.28.16-.54.35-.78.54.05-.31.08-.63.08-.95 0-2.22-1.21-4.15-3-5.19C10.21 1.85 9 3.78 9 6c0 .32.03.64.08.95-.24-.2-.5-.39-.78-.55-1.92-1.11-4.2-1.03-6 0 0 2.07 1.07 4.08 3 5.19.28.16.57.29.86.4-.29.11-.58.24-.86.4-1.92 1.11-2.99 3.12-3 5.19 1.79 1.03 4.07 1.11 6 0 .28-.16.54-.35.78-.54-.05.32-.08.64-.08.96 0 2.22 1.21 4.15 3 5.19 1.79-1.04 3-2.97 3-5.19 0-.32-.03-.64-.08-.95.24.2.5.38.78.54 1.92 1.11 4.2 1.03 6 0-.01-2.07-1.08-4.08-3-5.19zM12 16c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 looks-6
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M11 15h2v-2h-2v2zM21 3H3v18h18V3zm-6 6h-4v2h4v6H9V7h6v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 iso
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3v18h18V3zM5.5 7.5h2v-2H9v2h2V9H9v2H7.5V9h-2V7.5zM19 19H5L19 5v14zm-2-2v-1.5h-5V17h5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 leak-add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 3H3v3c1.66 0 3-1.34 3-3zm8 0h-2c0 4.97-4.03 9-9 9v2c6.08 0 11-4.93 11-11zm-4 0H8c0 2.76-2.24 5-5 5v2c3.87 0 7-3.13 7-7zm0 18h2c0-4.97 4.03-9 9-9v-2c-6.07 0-11 4.93-11 11zm8 0h3v-3c-1.66 0-3 1.34-3 3zm-4 0h2c0-2.76 2.24-5 5-5v-2c-3.87 0-7 3.13-7 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _12mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M12,8h3V7h-3V5.5h4.5V9h-3v1h3v1.5H12V8z M7,5.5h3v6H8.5V7H7V5.5z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6 v-6h6.5V18.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shutter-speed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 1H9v2h6V1zm4.03 6.39l1.42-1.42c-.43-.51-.9-.99-1.41-1.41l-1.42 1.42C16.07 4.74 14.12 4 12 4c-4.97 0-9 4.03-9 9s4.02 9 9 9 9-4.03 9-9c0-2.12-.74-4.07-1.97-5.61zM12 20c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7zm-.32-5H6.35c.57 1.62 1.82 2.92 3.41 3.56l-.11-.06 2.03-3.5zm5.97-4c-.57-1.6-1.78-2.89-3.34-3.54L12.26 11h5.39zm-7.04 7.83c.45.11.91.17 1.39.17 1.34 0 2.57-.45 3.57-1.19l-2.11-3.9-2.85 4.92zM7.55 8.99C6.59 10.05 6 11.46 6 13c0 .34.04.67.09 1h4.72L7.55 8.99zm8.79 8.14C17.37 16.06 18 14.6 18 13c0-.34-.04-.67-.09-1h-4.34l2.77 5.13zm-3.01-9.98C12.9 7.06 12.46 7 12 7c-1.4 0-2.69.49-3.71 1.29l2.32 3.56 2.72-4.7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _7mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M11.25,11.5L12.62,7H10V5.5h4.87l-1.87,6H11.25z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-center-focus
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 15H3v6h6v-2H5v-4zM5 5h4V3H3v6h2V5zm16-2h-6v2h4v4h2V3zm-2 16h-4v2h6v-6h-2v4zM12 9c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-neg-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M4 11v2h8v-2H4zm15 7h-2V7.38L14 8.4V6.7L18.7 5h.3v13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-plus-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 7H8v4H4v2h4v4h2v-4h4v-2h-4V7zm10 11h-2V7.38L15 8.4V6.7L19.7 5h.3v13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-filter
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 10v9H4.98V5h9V3H3v18h18V10h-2zm-2 0l.94-2.06L20 7l-2.06-.94L17 4l-.94 2.06L14 7l2.06.94L17 10zm-3.75.75L12 8l-1.25 2.75L8 12l2.75 1.25L12 16l1.25-2.75L16 12l-2.75-1.25z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hevc
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "5.5,11 4.5,11 4.5,9 3,9 3,15 4.5,15 4.5,12.5 5.5,12.5 5.5,15 7,15 7,9 5.5,9",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "21,11 21,9 17,9 17,15 21,15 21,13 19.5,13 19.5,13.5 18.5,13.5 18.5,10.5 19.5,10.5 19.5,11",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "14.25,13.5 13.5,9 12,9 13,15 15.5,15 16.5,9 15,9",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8,9 8,15 11.5,15 11.5,13.5 9.5,13.5 9.5,12.5 11.5,12.5 11.5,11 9.5,11 9.5,10.5 11.5,10.5 11.5,9",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 timer-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.61 12.97c-.16-.24-.36-.46-.62-.65-.25-.19-.56-.35-.93-.48.3-.14.57-.3.8-.5.23-.2.42-.41.57-.64.15-.23.27-.46.34-.71.08-.24.11-.49.11-.73 0-.55-.09-1.04-.28-1.46-.18-.42-.44-.77-.78-1.06-.33-.28-.73-.5-1.2-.64-.45-.13-.97-.2-1.53-.2-.55 0-1.06.08-1.52.24-.47.17-.87.4-1.2.69-.33.29-.6.63-.78 1.03-.2.39-.29.83-.29 1.29h1.98c0-.26.05-.49.14-.69.09-.2.22-.38.38-.52.17-.14.36-.25.58-.33s.46-.12.73-.12c.61 0 1.06.16 1.36.47.3.31.44.75.44 1.32 0 .27-.04.52-.12.74-.08.22-.21.41-.38.57s-.38.28-.63.37-.55.13-.89.13H6.72v1.57H7.9c.34 0 .64.04.91.11.27.08.5.19.69.35.19.16.34.36.44.61.1.24.16.54.16.87 0 .62-.18 1.09-.53 1.42-.35.33-.84.49-1.45.49-.29 0-.56-.04-.8-.13-.24-.08-.44-.2-.61-.36s-.3-.34-.39-.56c-.09-.22-.14-.46-.14-.72H4.19c0 .55.11 1.03.32 1.45.21.42.5.77.86 1.05s.77.49 1.24.63.96.21 1.48.21c.57 0 1.09-.08 1.58-.23s.91-.38 1.26-.68c.36-.3.64-.66.84-1.1.2-.43.3-.93.3-1.48 0-.29-.04-.58-.11-.86-.08-.25-.19-.51-.35-.76zm9.26 1.4c-.14-.28-.35-.53-.63-.74-.28-.21-.61-.39-1.01-.53s-.85-.27-1.35-.38c-.35-.07-.64-.15-.87-.23-.23-.08-.41-.16-.55-.25s-.23-.19-.28-.3c-.05-.11-.08-.24-.08-.39s.03-.28.09-.41.15-.25.27-.34c.12-.1.27-.18.45-.24s.4-.09.64-.09c.25 0 .47.04.66.11s.35.17.48.29.22.26.29.42c.06.16.1.32.1.49h1.95c0-.39-.08-.75-.24-1.09s-.39-.63-.69-.88c-.3-.25-.66-.44-1.09-.59-.43-.15-.92-.22-1.46-.22-.51 0-.98.07-1.39.21s-.77.33-1.06.57c-.29.24-.51.52-.67.84s-.23.65-.23 1.01.08.68.23.96.37.52.64.73c.27.21.6.38.98.53.38.14.81.26 1.27.36.39.08.71.17.95.26s.43.19.57.29c.13.1.22.22.27.34.05.12.07.25.07.39 0 .32-.13.57-.4.77s-.66.29-1.17.29c-.22 0-.43-.02-.64-.08-.21-.05-.4-.13-.56-.24-.17-.11-.3-.26-.41-.44-.11-.18-.17-.41-.18-.67h-1.89c0 .36.08.71.24 1.05s.39.65.7.93c.31.27.69.49 1.15.66.46.17.98.25 1.58.25.53 0 1.01-.06 1.44-.19.43-.13.8-.31 1.11-.54.31-.23.54-.51.71-.83.17-.32.25-.67.25-1.06-.02-.4-.09-.74-.24-1.02z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 image-not-supported
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21.9,21.9l-8.49-8.49l0,0L3,3l0,0L2.1,2.1L0.69,3.51L3,5.83V21h15.17l2.31,2.31L21.9,21.9z M5,18l3.5-4.5l2.5,3.01 L12.17,15l3,3H5z M21,18.17L5.83,3H21V18.17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 photo-camera-back
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16.83,5L15,3H9L7.17,5H2v16h20V5H16.83z M6,17l3-4l2.25,3l3-4L18,17H6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 filter-frames
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 4h-6l-4-4-4 4H2v18h20V4zm-2 16H4V6h4.52l3.52-3.5L15.52 6H20v14zM18 8H6v10h12",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dehaze
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M2 16v2h20v-2H2zm0-5v2h20v-2H2zm0-5v2h20V6H2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-5-4
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d "M21,4H3v16h18V4z M19,18H5V6h14V18z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 movie-creation
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 4l2 4h-3l-2-4h-2l2 4h-3l-2-4H8l2 4H7L5 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 control-point
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4V7zm-1-5C6.49 2 2 6.49 2 12s4.49 10 10 10 10-4.49 10-10S17.51 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-drama
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.61 5.64 5.36 8.04 2.35 8.36 0 10.9 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4h2c0-2.76-1.86-5.08-4.4-5.78C8.61 6.88 10.2 6 12 6c3.03 0 5.5 2.47 5.5 5.5v.5H19c1.65 0 3 1.35 3 3s-1.35 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-rupee
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13.66,7C13.1,5.82,11.9,5,10.5,5L6,5V3h12v2l-3.26,0c0.48,0.58,0.84,1.26,1.05,2L18,7v2l-2.02,0c-0.25,2.8-2.61,5-5.48,5 H9.77l6.73,7h-2.77L7,14v-2h3.5c1.76,0,3.22-1.3,3.46-3L6,9V7L13.66,7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _24mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M6.5,8h3V7h-3V5.5H11V9H8v1h3v1.5H6.5V8z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M18,17h-3 v1.5h-1.5v-6H18V17z M18.5,10h-1v1.5H16V10h-3V5.5h1.5v3H16v-3h1.5v3h1V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 hide-image
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "21,3 5.83,3 21,18.17", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M2.81,2.81L1.39,4.22L3,5.83V21h15.17l1.61,1.61l1.41-1.41L2.81,2.81z M6,17l3-4l2.25,3l0.82-1.1l2.1,2.1H6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 raw-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6.5,9H3v6h1.5v-2h1.1l0.9,2H8l-0.9-2.1C7.6,12.6,8,12.1,8,11.5v-1C8,9.7,7.3,9,6.5,9z M6.5,11.5h-2v-1h2V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.25,9l-1.5,6h1.5l0.38-1.5h1.75l0.37,1.5h1.5l-1.5-6H10.25z M11,12l0.25-1h0.5L12,12H11z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "19.98,9 19.24,12 18.5,9 16.98,9 16.24,12 15.5,9 14,9 15.5,15 16.98,15 17.74,11.96 18.5,15 19.98,15 21.48,9",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 panorama-photosphere
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M23,8.84c-0.54-0.43-1.23-0.81-1.99-1.15C19.4,4.33,15.98,2,12,2C8.02,2,4.6,4.33,2.99,7.68C2.23,8.03,1.54,8.4,1,8.84 v6.33c0.54,0.43,1.23,0.81,1.99,1.15C4.6,19.67,8.02,22,12,22c3.98,0,7.4-2.33,9.01-5.68c0.76-0.34,1.45-0.72,1.99-1.15V8.84z M12,4c2.37,0,4.49,1.04,5.95,2.68C16.17,6.25,14.15,6,12,6C9.85,6,7.83,6.25,6.05,6.68C7.51,5.04,9.63,4,12,4z M12,20 c-2.37,0-4.49-1.04-5.95-2.68C7.83,17.75,9.85,18,12,18s4.17-0.25,5.95-0.68C16.49,18.96,14.37,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.4 10.5l4.77-8.26C13.47 2.09 12.75 2 12 2c-2.4 0-4.6.85-6.32 2.25l3.66 6.35.06-.1zM21.54 9c-.92-2.92-3.15-5.26-6-6.34L11.88 9h9.66zm.26 1h-7.49l.29.5 4.76 8.25C21 16.97 22 14.61 22 12c0-.69-.07-1.35-.2-2zM8.54 12l-3.9-6.75C3.01 7.03 2 9.39 2 12c0 .69.07 1.35.2 2h7.49l-1.15-2zm-6.08 3c.92 2.92 3.15 5.26 6 6.34L12.12 15H2.46zm11.27 0l-3.9 6.76c.7.15 1.42.24 2.17.24 2.4 0 4.6-.85 6.32-2.25l-3.66-6.35-.93 1.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 deblur
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M12,3v18c4.97,0,9-4.03,9-9C21,7.03,16.97,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "14", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "18", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "10", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "10", :cx "3", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "6", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "14", :cx "3", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "21", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "3", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "6", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "10", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "18", :cx "10", :stroke nil, :fill nil})))))


(helix.core/defnc
 wb-auto
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6.85 12.65h2.3L8 9l-1.15 3.65zM22 7l-1.2 6.29L19.3 7h-1.6l-1.49 6.29L15 7h-.76C12.77 5.17 10.53 4 8 4c-4.42 0-8 3.58-8 8s3.58 8 8 8c3.13 0 5.84-1.81 7.15-4.43l.1.43H17l1.5-6.1L20 16h1.75l2.05-9H22zm-11.7 9l-.7-2H6.4l-.7 2H3.8L7 7h2l3.2 9h-1.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 1H5v18h18V1zm-2 16H7V3h14v14zM3 5H1v18h18v-2H3V5zm14 10V9h-4V7h4V5h-6v6h4v2h-4v2h6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5H1v18h18v-2H3V5zm20-4H5v18h18V1zm-2 16H7V3h14v14zm-4-4h-4v-2h4V5h-6v2h4v2h-4v6h6v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 face-retouching-natural
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M19.85,10.59C20.79,15.4,17.01,20,12,20c-4.41,0-8-3.59-8-8c0-0.39,3.87-1.12,5.74-5.69c3.42,4.19,8.07,3.73,9.09,3.59 l-1.48-3.25L12.63,4.5l3.5-1.59C9.51-0.14,2,4.77,2,12c0,5.52,4.48,10,10,10c7.21,0,12.12-7.45,9.1-14.13L19.85,10.59z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M20.6,5.6L19.5,8l-1.1-2.4L16,4.5l2.4-1.1L19.5,1l1.1,2.4L23,4.5L20.6,5.6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-b-and-w
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3H3v18h18V3zm-2 16l-7-8v8H5l7-8V5h7v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-horizontal-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,5.5c-5.25,0-9.01-1.54-10-1.92L2,20.4c2.16-0.76,5.21-1.9,10-1.9c4.78,0,7.91,1.17,10,1.9L22,3.6 C19.91,4.33,16.77,5.5,12,5.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 hdr-enhanced-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C8.69,2,6,4.69,6,8s2.69,6,6,6s6-2.69,6-6S15.31,2,12,2z M15,9h-2v2h-2V9H9V7h2V5h2v2h2V9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,16H6.5v6H10c0.8,0,1.5-0.7,1.5-1.5v-3C11.5,16.7,10.8,16,10,16z M10,20.5H8v-3h2V20.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,16h-5v6h1.5v-2h1.1l0.9,2H18l-0.86-2H18V16z M16.5,18.5h-2v-1h2V18.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "3.5,18 1.5,18 1.5,16 0,16 0,22 1.5,22 1.5,19.5 3.5,19.5 3.5,22 5,22 5,16 3.5,16",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "22,18.5 22,16.5 20.5,16.5 20.5,18.5 18.5,18.5 18.5,20 20.5,20 20.5,22 22,22 22,20 24,20 24,18.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _60fps-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,6v6h-3V6H18z M20,4h-7v10h7V4z M11,6V4H4v10h7V8H6V6H11z M9,10v2H6v-2H9z M5,22H3v-5h2V22z M9,22H7v-5h2V22z M13,22 h-2v-5h2V22z M21,22h-6v-5h6V22z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 thermostat-auto
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11,12V6c0-1.66-1.34-3-3-3S5,4.34,5,6v6c-1.21,0.91-2,2.37-2,4c0,1.12,0.38,2.14,1,2.97V19h0.02c0.91,1.21,2.35,2,3.98,2 s3.06-0.79,3.98-2H12v-0.03c0.62-0.83,1-1.85,1-2.97C13,14.37,12.21,12.91,11,12z M5,16c0-0.94,0.45-1.84,1.2-2.4L7,13V6 c0-0.55,0.45-1,1-1s1,0.45,1,1v7l0.8,0.6c0.75,0.57,1.2,1.46,1.2,2.4H5z M18.62,4h-1.61l-3.38,9h1.56L16,10.7h3.63l0.8,2.3H22 L18.62,4z M16.47,9.39l1.31-3.72h0.08l1.31,3.72H16.47z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 control-point-duplicate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 8h-2v3h-3v2h3v3h2v-3h3v-2h-3V8zM2 12c0-2.79 1.64-5.2 4.01-6.32V3.52C2.52 4.76 0 8.09 0 12s2.52 7.24 6.01 8.48v-2.16C3.64 17.2 2 14.79 2 12zm13-9c-4.96 0-9 4.04-9 9s4.04 9 9 9 9-4.04 9-9-4.04-9-9-9zm0 16c-3.86 0-7-3.14-7-7s3.14-7 7-7 7 3.14 7 7-3.14 7-7 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 1H5v18h18V1zm-2 16H7V3h14v14zM3 5H1v18h18v-2H3V5zm14 10V5h-6v2h4v2h-2v2h2v2h-4v2h6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timer
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M15,1H9v2h6V1z M11,14h2V8h-2V14z M19.03,7.39l1.42-1.42c-0.43-0.51-0.9-0.99-1.41-1.41l-1.42,1.42 C16.07,4.74,14.12,4,12,4c-4.97,0-9,4.03-9,9s4.02,9,9,9s9-4.03,9-9C21,10.88,20.26,8.93,19.03,7.39z M12,20c-3.87,0-7-3.13-7-7 s3.13-7,7-7s7,3.13,7,7S15.87,20,12,20z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 wb-incandescent
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3.55 19.09l1.41 1.41 1.79-1.8-1.41-1.41-1.79 1.8zM11 23h2v-2.95h-2V23zM4 11.05H1v2h3v-2zm11-4.19V2.05H9v4.81C7.21 7.9 6 9.83 6 12.05c0 3.31 2.69 6 6 6s6-2.69 6-6c0-2.22-1.21-4.15-3-5.19zm5 4.19v2h3v-2h-3zm-2.76 7.66l1.79 1.8 1.41-1.41-1.8-1.79-1.4 1.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 straighten
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 6H1v12h22V6zm-2 10H3V8h2v4h2V8h2v4h2V8h2v4h2V8h2v4h2V8h2v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _20mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "7",
      :x "14.5",
      :width "1.5",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M6.5,8h3V7h-3V5.5H11V9H8v1h3v1.5H6.5V8z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M13,5.5 h4.5v6H13V5.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-4
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5H1v18h18v-2H3V5zm12 10h2V5h-2v4h-2V5h-2v6h4v4zm8-14H5v18h18V1zm-2 16H7V3h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-fish-eye
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M17 15h2V5H9v2h8v8zM7 17V1H5v4H1v2h4v12h12v4h2v-4h4v-2H7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timelapse
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.24 7.76C15.07 6.59 13.54 6 12 6v6l-4.24 4.24c2.34 2.34 6.14 2.34 8.49 0 2.34-2.34 2.34-6.14-.01-8.48zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _30fps-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M4,4v2h5v2H5v2h4v2H4v2h7V4H4z M13,4h7v10h-7V4z M18,6h-3v6h3V6z M5,22H3v-5h2V22z M9,22H7v-5h2V22z M13,22h-2v-5h2V22z M21,22h-6v-5h6V22z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _15mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M12,10h3V9h-3V5.5h4.5V7h-3v1h3v3.5H12V10z M7,5.5h3v6H8.5V7H7V5.5z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5 H6v-6h6.5V18.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 color-lens
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 3c-4.97 0-9 4.03-9 9s4.03 9 9 9c.83 0 1.5-.67 1.5-1.5 0-.39-.15-.74-.39-1.01-.23-.26-.38-.61-.38-.99 0-.83.67-1.5 1.5-1.5H16c2.76 0 5-2.24 5-5 0-4.42-4.03-8-9-8zm-5.5 9c-.83 0-1.5-.67-1.5-1.5S5.67 9 6.5 9 8 9.67 8 10.5 7.33 12 6.5 12zm3-4C8.67 8 8 7.33 8 6.5S8.67 5 9.5 5s1.5.67 1.5 1.5S10.33 8 9.5 8zm5 0c-.83 0-1.5-.67-1.5-1.5S13.67 5 14.5 5s1.5.67 1.5 1.5S15.33 8 14.5 8zm3 4c-.83 0-1.5-.67-1.5-1.5S16.67 9 17.5 9s1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 portrait
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 12.25c1.24 0 2.25-1.01 2.25-2.25S13.24 7.75 12 7.75 9.75 8.76 9.75 10s1.01 2.25 2.25 2.25zm4.5 4c0-1.5-3-2.25-4.5-2.25s-4.5.75-4.5 2.25V17h9v-.75zM21 3H3v18h18V3zm-2 16H5V5h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flash-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 10h-3.61l2.28 2.28zm0-8H7v1.61l6.13 6.13zm-13.59.86L2 4.27l5 5V13h3v9l3.58-6.15L17.73 20l1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-stories
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,4.6v2.12v7.24v2.66C19.86,16.21,18.69,16,17.5,16c-1.9,0-3.78,0.54-5.5,1.58v-3.62V7.79V5.48C10.38,4.55,8.51,4,6.5,4 S2.62,4.55,1,5.48V20c1.52-1.18,3.43-2,5.5-2s3.98,0.82,5.5,2c1.52-1.18,3.43-2,5.5-2s3.98,0.82,5.5,2V5.48 C22.37,5.12,21.7,4.84,21,4.6z",
     :stroke nil,
     :fill nil})
   (helix.dom/polygon
    {:points "19,0.5 14,5.5 14,15 19,10.5", :stroke nil, :fill nil}))))


(helix.core/defnc
 cases
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,5V1h-8v4H5v13h18V5H18z M16,5h-4V3h4V5z M3,9H1v13h18v-2H3V9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 grid-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 2H2v20h20V2zM8 20H4v-4h4v4zm0-6H4v-4h4v4zm0-6H4V4h4v4zm6 12h-4v-4h4v4zm0-6h-4v-4h4v4zm0-6h-4V4h4v4zm6 12h-4v-4h4v4zm0-6h-4v-4h4v4zm0-6h-4V4h4v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 animation
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M15,2c-2.71,0-5.05,1.54-6.22,3.78c-1.28,0.67-2.34,1.72-3,3C3.54,9.95,2,12.29,2,15c0,3.87,3.13,7,7,7 c2.71,0,5.05-1.54,6.22-3.78c1.28-0.67,2.34-1.72,3-3C20.46,14.05,22,11.71,22,9C22,5.13,18.87,2,15,2z M9,20c-2.76,0-5-2.24-5-5 c0-1.12,0.37-2.16,1-3c0,3.87,3.13,7,7,7C11.16,19.63,10.12,20,9,20z M12,17c-2.76,0-5-2.24-5-5c0-1.12,0.37-2.16,1-3 c0,3.86,3.13,6.99,7,7C14.16,16.63,13.12,17,12,17z M16.7,13.7C16.17,13.89,15.6,14,15,14c-2.76,0-5-2.24-5-5 c0-0.6,0.11-1.17,0.3-1.7C10.83,7.11,11.4,7,12,7c2.76,0,5,2.24,5,5C17,12.6,16.89,13.17,16.7,13.7z M19,12c0-3.86-3.13-6.99-7-7 c0.84-0.63,1.87-1,3-1c2.76,0,5,2.24,5,5C20,10.12,19.63,11.16,19,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flip
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 21h2v-2h-2v2zm4-12h2V7h-2v2zM3 3v18h6v-2H5V5h4V3H3zm16 0v2h2V3h-2zm-8 20h2V1h-2v22zm8-6h2v-2h-2v2zM15 5h2V3h-2v2zm4 8h2v-2h-2v2zm0 8h2v-2h-2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 details
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,3L2,21h20L12,3z M13,8.92L18.6,19H13V8.92z M11,8.92V19H5.4L11,8.92z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-camera-back
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,10.48V4H2v16h16v-6.48l4,3.98v-11L18,10.48z M5,16l2.38-3.17L9,15l2.62-3.5L15,16H5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 add-a-photo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 4V1h2v3h3v2H5v3H3V6H0V4h3zm3 6V7h3V4h7l1.83 2H23v16H3V10h3zm7 9c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-3-5c0 1.66 1.34 3 3 3s3-1.34 3-3-1.34-3-3-3-3 1.34-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 style
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3.87 20.21v-9.03l-3.19 7.7 3.19 1.33zm18.92-2.43L16.31 2.14 5.26 6.71l6.48 15.64 11.05-4.57zM7.88 8.75c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-2 13h3.45l-3.45-8.34v8.34z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-vertical-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.49,11.99c0-5.25,1.54-9.01,1.92-10l-16.82,0c0.76,2.16,1.9,5.21,1.9,10c0,4.78-1.17,7.91-1.9,10l16.81,0 C19.66,19.91,18.49,16.76,18.49,11.99z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 currency-ruble
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13.5,3H7v9H5v2h2v2H5v2h2v3h2v-3h4v-2H9v-2h4.5c3.04,0,5.5-2.46,5.5-5.5C19,5.46,16.54,3,13.5,3z M13.5,12H9V5h4.5 C15.43,5,17,6.57,17,8.5S15.43,12,13.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 crop-din
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3H3v18h18V3zm-2 16H5V5h14v14z", :stroke nil, :fill nil})))


(helix.core/defnc
 crop-square
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M20 4H4v16h16V4zm-2 14H6V6h12v12z", :stroke nil, :fill nil})))


(helix.core/defnc
 nature
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 16.12c3.47-.41 6.17-3.36 6.17-6.95 0-3.87-3.13-7-7-7s-7 3.13-7 7c0 3.47 2.52 6.34 5.83 6.89V20H5v2h14v-2h-6v-3.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-fix-normal
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "20,7 20.94,4.94 23,4 20.94,3.06 20,1 19.06,3.06 17,4 19.06,4.94",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.41,9.83l-4.24-4.24L1.59,18.17l4.24,4.24L18.41,9.83z M14.21,11.21l-1.41-1.41l1.38-1.38l1.41,1.41L14.21,11.21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _11mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M8,5.5h3v6H9.5V7H8V5.5z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M13,5.5h3v6h-1.5V7H13V5.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-hdr
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 6l-3.75 5 2.85 3.8-1.6 1.2C9.81 13.75 7 10 7 10l-6 8h22L14 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 image
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 21V3H3v18h18zM8.5 13.5l2.5 3.01L14.5 12l4.5 6H5l3.5-4.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _4mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M9.5,10V5.5H11v3h1.5v-3H14v3h1V10h-1v1.5h-1.5V10 H9.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-landscape
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 5H3v14h18V5zm-2 12H5V7h14v10z", :stroke nil, :fill nil})))


(helix.core/defnc
 camera-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "3", :cy "12", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M16.83 4L15 2H9L7.17 4H2v16h20V4h-5.17zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dirty-lens
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,5h-5.17L15,3H9L7.17,5H2v16h20V5z M16.66,16.58c-1.14,1.86-3-1.03-3.81,0.09c-0.39,0.57-0.09,1.49,0.13,2.33 c0,0.47-0.38,0.85-0.85,0.85c-0.47,0-0.86-0.38-0.86-0.85c0.14-0.98,0.42-2.05-0.16-2.43c-0.89-0.59-1.27,2.06-2.8,1.35 c-1.39-1.12,1.05-1.29,0.5-3.27c-0.22-0.79-2.28,0.36-2.4-1.24c-0.08-1,1.49-0.74,1.51-1.49c0.03-0.75-1.03-1.05-0.25-1.91 c0.22-0.24,0.71-0.26,0.91-0.19c0.79,0.27,1.55,1.82,2.51,1.19c1.03-0.66-1.88-2.35,0-2.86c1.64-0.44,1.31,2.08,2.65,2.44 c1.94,0.52,2.65-4.55,4.41-2.33c1.85,2.33-3.43,2.27-2.85,4.01c0.34,1.01,2.15-1.2,2.76,0.53c0.64,1.83-3.09,0.82-3.04,1.66 C15.08,15.29,17.43,15.01,16.66,16.58z M18.14,18.01c-0.47,0-0.86-0.38-0.86-0.86s0.38-0.86,0.86-0.86c0.47,0,0.86,0.38,0.86,0.86 S18.62,18.01,18.14,18.01z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 blur-linear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 17.5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5.67 1.5 1.5 1.5zM9 13c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0-4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zM3 21h18v-2H3v2zM5 9.5c.83 0 1.5-.67 1.5-1.5S5.83 6.5 5 6.5 3.5 7.17 3.5 8 4.17 9.5 5 9.5zm0 4c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5.67 1.5 1.5 1.5zM9 17c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm8-.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM3 3v2h18V3H3zm14 5.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm0 4c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM13 9c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0 4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0 4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-camera-front
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16.83,5L15,3H9L7.17,5H2v16h20V5H16.83z M12,9c1.1,0,2,0.9,2,2c0,1.1-0.9,2-2,2s-2-0.9-2-2C10,9.9,10.9,9,12,9z M16,17H8 v-0.57c0-0.81,0.48-1.53,1.22-1.85C10.07,14.21,11.01,14,12,14s1.93,0.21,2.78,0.58C15.52,14.9,16,15.62,16,16.43V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 switch-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 9.5V5H2v14h16v-4.5l4 4v-13l-4 4zm-5 6V13H7v2.5L3.5 12 7 8.5V11h6V8.5l3.5 3.5-3.5 3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 blur-circular
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 9c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zM7 9.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm3 7c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm-3-3c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm3-6c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM14 9c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-1.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm3 6c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm0-4c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm2-3.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm0-3.5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 edit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM21.41 6.34l-3.75-3.75-2.53 2.54 3.75 3.75 2.53-2.54z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-7
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69L23.31 12 20 8.69zM12 18c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6zm0-10c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 grain
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 12c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zM6 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12-8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm-4 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm4-4c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-4-4c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-4-4c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 receipt-long
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.5,3.5L18,2l-1.5,1.5L15,2l-1.5,1.5L12,2l-1.5,1.5L9,2L7.5,3.5L6,2v14H3v3c0,1.66,1.34,3,3,3h12c1.66,0,3-1.34,3-3V2 L19.5,3.5z M15,20H6c-0.55,0-1-0.45-1-1v-1h10V20z M19,19c0,0.55-0.45,1-1,1s-1-0.45-1-1v-3H8V5h11V19z",
     :stroke nil,
     :fill nil})
   (helix.dom/rect
    {:y "7", :x "9", :width "6", :height "2", :stroke nil, :fill nil})
   (helix.dom/rect
    {:y "10", :x "9", :width "6", :height "2", :stroke nil, :fill nil})
   (helix.dom/rect
    {:y "7", :x "16", :width "2", :height "2", :stroke nil, :fill nil})
   (helix.dom/rect
    {:y "10",
     :x "16",
     :width "2",
     :height "2",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 image-aspect-ratio
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 10h-2v2h2v-2zm0 4h-2v2h2v-2zm-8-4H6v2h2v-2zm4 0h-2v2h2v-2zm10-6H2v16h20V4zm-2 14H4V6h16v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 lens
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-awesome-motion
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,2H2v12h2V4h10V2z M18,6H6v12h2V8h10V6z M22,10H10v12h12V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 movie-filter
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 4l2 3h-3l-2-3h-2l2 3h-3l-2-3H8l2 3H7L5 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4h-4zm-6.75 11.25L10 18l-1.25-2.75L6 14l2.75-1.25L10 10l1.25 2.75L14 14l-2.75 1.25zm5.69-3.31L16 14l-.94-2.06L13 11l2.06-.94L16 8l.94 2.06L19 11l-2.06.94z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timer-10
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M-.01 7.72V9.4l3-1V18h2V6h-.25L-.01 7.72zm23.78 6.65c-.14-.28-.35-.53-.63-.74-.28-.21-.61-.39-1.01-.53s-.85-.27-1.35-.38c-.35-.07-.64-.15-.87-.23-.23-.08-.41-.16-.55-.25s-.23-.19-.28-.3c-.05-.11-.08-.24-.08-.39 0-.14.03-.28.09-.41s.15-.25.27-.34c.12-.1.27-.18.45-.24s.4-.09.64-.09c.25 0 .47.04.66.11s.35.17.48.29.22.26.29.42c.06.16.1.32.1.49h1.95c0-.39-.08-.75-.24-1.09s-.39-.63-.69-.88c-.3-.25-.66-.44-1.09-.59-.43-.15-.92-.22-1.46-.22-.51 0-.98.07-1.39.21s-.77.33-1.06.57c-.29.24-.51.52-.67.84-.16.32-.23.65-.23 1.01s.08.69.23.96c.15.28.36.52.64.73.27.21.6.38.98.53.38.14.81.26 1.27.36.39.08.71.17.95.26s.43.19.57.29c.13.1.22.22.27.34.05.12.07.25.07.39 0 .32-.13.57-.4.77s-.66.29-1.17.29c-.22 0-.43-.02-.64-.08-.21-.05-.4-.13-.56-.24-.17-.11-.3-.26-.41-.44-.11-.18-.17-.41-.18-.67h-1.89c0 .36.08.71.24 1.05s.39.65.7.93c.31.27.69.49 1.15.66s.98.25 1.58.25c.53 0 1.01-.06 1.44-.19.43-.13.8-.31 1.11-.54.31-.23.54-.51.71-.83.17-.32.25-.67.25-1.06-.02-.4-.09-.74-.24-1.02zm-9.96-7.32c-.34-.4-.75-.7-1.23-.88-.47-.18-1.01-.27-1.59-.27s-1.11.09-1.59.27c-.48.18-.89.47-1.23.88-.34.41-.6.93-.79 1.59-.18.65-.28 1.45-.28 2.39v1.92c0 .94.09 1.74.28 2.39.19.66.45 1.19.8 1.6.34.41.75.71 1.23.89s1.01.28 1.59.28c.59 0 1.12-.09 1.59-.28.48-.18.88-.48 1.22-.89s.6-.94.78-1.6c.18-.65.28-1.45.28-2.39v-1.92c0-.94-.09-1.74-.28-2.39-.18-.66-.44-1.19-.78-1.59zm-.92 6.17c0 .6-.04 1.11-.12 1.53s-.2.76-.36 1.02c-.16.26-.36.45-.59.57-.23.12-.51.18-.82.18-.3 0-.58-.06-.82-.18s-.44-.31-.6-.57c-.16-.26-.29-.6-.38-1.02s-.13-.93-.13-1.53v-2.5c0-.6.04-1.11.13-1.52s.21-.74.38-1c.16-.25.36-.43.6-.55.24-.11.51-.17.81-.17.31 0 .58.06.81.17.24.11.44.29.6.55.16.25.29.58.37.99s.13.92.13 1.52v2.51h-.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 rotate-90-degrees-cw
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M4.64,19.37c3.03,3.03,7.67,3.44,11.15,1.25l-1.46-1.46c-2.66,1.43-6.04,1.03-8.28-1.21c-2.73-2.73-2.73-7.17,0-9.9 C7.42,6.69,9.21,6.03,11,6.03V9l4-4l-4-4v3.01c-2.3,0-4.61,0.87-6.36,2.63C1.12,10.15,1.12,15.85,4.64,19.37z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d "M17,7l-6,6l6,6l6-6L17,7z", :stroke nil, :fill nil}))))))


(helix.core/defnc
 panorama-horizontal
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 6.55c2.6.77 5.28 1.16 8 1.16 2.72 0 5.41-.39 8-1.16v10.91c-2.6-.77-5.28-1.16-8-1.16-2.72 0-5.41.39-8 1.16V6.55M2 3.77v16.47s.77-.26.88-.3C5.82 18.85 8.91 18.3 12 18.3c3.09 0 6.18.55 9.12 1.64.11.04.88.3.88.3V3.77s-.77.26-.88.3C18.18 5.15 15.09 5.71 12 5.71s-6.18-.56-9.12-1.64c-.11-.05-.88-.3-.88-.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-twilight
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "7.31",
      :x "17.22",
      :width "3",
      :transform "matrix(0.7069 -0.7074 0.7074 0.7069 -0.3887 15.676)",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "18",
      :x "2",
      :width "20",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "4",
      :x "11",
      :width "2",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.78",
      :x "4.31",
      :width "2",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 -4.2992 6.1783)",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M5,16h14c0-3.87-3.13-7-7-7S5,12.13,5,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 photo-album
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20,2H4v20h16V2z M11,4h5v7l-2.5-1.5L11,11V4z M7,18l2.38-3.17L11,17l2.62-3.5L17,18H7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-photosphere-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M23,8.84c-0.54-0.43-1.23-0.81-1.99-1.15C19.4,4.33,15.98,2,12,2C8.02,2,4.6,4.33,2.99,7.68C2.23,8.03,1.54,8.4,1,8.84 v6.33c0.54,0.43,1.23,0.81,1.99,1.15C4.6,19.67,8.02,22,12,22c3.98,0,7.4-2.33,9.01-5.68c0.76-0.34,1.45-0.72,1.99-1.15V8.84z M12,4c2.37,0,4.49,1.04,5.95,2.68C16.17,6.25,14.15,6,12,6C9.85,6,7.83,6.25,6.05,6.68C7.51,5.04,9.63,4,12,4z M12,20 c-2.37,0-4.49-1.04-5.95-2.68C7.83,17.75,9.85,18,12,18s4.17-0.25,5.95-0.68C16.49,18.96,14.37,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 loupe
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4V7zm-.27-4.97c-6.08-.44-11.14 4.62-10.7 10.7.38 5.28 5 9.27 10.29 9.27H22v-9.68c0-5.3-3.98-9.91-9.27-10.29zM12 20c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 looks
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 10c-3.86 0-7 3.14-7 7h2c0-2.76 2.24-5 5-5s5 2.24 5 5h2c0-3.86-3.14-7-7-7zm0-4C5.93 6 1 10.93 1 17h2c0-4.96 4.04-9 9-9s9 4.04 9 9h2c0-6.07-4.93-11-11-11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-size-select-small
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 15h-2v2h2v-2zm0 4h-2v2h2v-2zm0-8h-2v2h2v-2zm-8-8h-2v2h2V3zm8 4h-2v2h2V7zM1 21h10v-6H1v6zM3 7H1v2h2V7zm12 12h-2v2h2v-2zm4-16h-2v2h2V3zm4 0h-2v2h2V3zm-4 16h-2v2h2v-2zM3 11H1v2h2v-2zm8-8H9v2h2V3zM7 3H5v2h2V3zM3 3H1v2h2V3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-6
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 15.31L23.31 12 20 8.69V4h-4.69L12 .69 8.69 4H4v4.69L.69 12 4 15.31V20h4.69L12 23.31 15.31 20H20v-4.69zM12 18V6c3.31 0 6 2.69 6 6s-2.69 6-6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _21mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M7.5,8h3V7h-3V5.5H12V9H9v1h3v1.5H7.5V8z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M13,5.5h3 v6h-1.5V7H13V5.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 navigate-next
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10.02 6L8.61 7.41 13.19 12l-4.58 4.59L10.02 18l6-6-6-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "10", :cy "12", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 tune
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 17v2h6v-2H3zM3 5v2h10V5H3zm10 16v-2h8v-2h-8v-2h-2v6h2zM7 9v2H3v2h4v2h2V9H7zm14 4v-2H11v2h10zm-6-4h2V7h4V5h-4V3h-2v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "3", :cy "12", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M9 2L7.17 4H2v16h20V4h-5.17L15 2H9zm3 15c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14.5",
      :x "8.5",
      :width "2",
      :height "1",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7.5",
      :x "14.5",
      :width "1.5",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,17l-0.86-0.01L12,19h-1.5l-0.9-2H8.5v2H7v-6h5 c0,0,0,0.7,0,1.5V17z M12,12h-1.5V9.5h-2V12H7V6h1.5v2h2V6H12V12z M17.5,16H16v1.5h-1.5V16H13v-1.5h1.5V13H16v1.49h1.5V16z M17.5,10.5c0,0.8-0.7,1.5-1.5,1.5h-3V6h3c0.8,0,1.5,0.7,1.5,1.5V10.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 center-focus-weak
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 15H3v6h6v-2H5v-4zM5 5h4V3H3v6h2V5zm16-2h-6v2h4v4h2V3zm-2 16h-4v2h6v-6h-2v4zM12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 logo-dev
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.68,14.98H6V9h1.71 c1.28,0,1.71,1.03,1.71,1.71l0,2.56C9.42,13.95,9,14.98,7.68,14.98z M12.38,11.46v1.07h-1.18v1.39h1.93v1.07h-2.25 c-0.4,0.01-0.74-0.31-0.75-0.71V9.75c-0.01-0.4,0.31-0.74,0.71-0.75h2.28l0,1.07h-1.92v1.39H12.38z M16.88,14.23 c-0.48,1.11-1.33,0.89-1.71,0L13.77,9h1.18l1.07,4.11L17.09,9h1.18L16.88,14.23z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.77,10.12H7.14v3.77h0.63c0.14,0,0.28-0.05,0.42-0.16c0.14-0.1,0.21-0.26,0.21-0.47v-2.52c0-0.21-0.07-0.37-0.21-0.47 C8.05,10.17,7.91,10.12,7.77,10.12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _14mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M12,5.5h1.5v3H15v-3h1.5v3h1V10h-1v1.5H15V10h-3V5.5z M7,5.5h3v6H8.5V7H7V5.5z M12.5,18.5H11V14h-1v3H8.5 v-3h-1v4.5H6v-6h6.5V18.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 looks-4
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M.04 0h24v24h-24V0z", :stroke nil})
  (helix.dom/path
   {:d "M21.04 3h-18v18h18V3zm-6 14h-2v-4h-4V7h2v4h2V7h2v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-bitcoin
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17.06,11.57C17.65,10.88,18,9.98,18,9c0-1.86-1.27-3.43-3-3.87L15,3h-2v2h-2V3H9v2H6v2h2v10H6v2h3v2h2v-2h2v2h2v-2 c2.21,0,4-1.79,4-4C19,13.55,18.22,12.27,17.06,11.57z M10,7h4c1.1,0,2,0.9,2,2s-0.9,2-2,2h-4V7z M15,17h-5v-4h5c1.1,0,2,0.9,2,2 S16.1,17,15,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 looks-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3H3.01v18H21V3zm-5.99 14H9v-2h4v-2h-2v-2h2V9H9V7h6.01v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,3H3v18h18V3z M6,9h6.5v6H11v-4.5h-1v3H8.5v-3h-1V15H6V9z M15,15h-1.5V9H18v4.5h-3V15z M15,12h1.5v-1.5H15V12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-portrait
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M19 3H5v18h14V3zm-2 16H7V5h10v14z", :stroke nil, :fill nil})))


(helix.core/defnc
 bedtime
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12.34 2.02C6.59 1.82 2 6.42 2 12c0 5.52 4.48 10 10 10 3.71 0 6.93-2.02 8.66-5.02-7.51-.25-12.09-8.43-8.32-14.96z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 rotate-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.55 5.55L11 1v3.07C7.06 4.56 4 7.92 4 12s3.05 7.44 7 7.93v-2.02c-2.84-.48-5-2.94-5-5.91s2.16-5.43 5-5.91V10l4.55-4.45zM19.93 11c-.17-1.39-.72-2.73-1.62-3.89l-1.42 1.42c.54.75.88 1.6 1.02 2.47h2.02zM13 17.9v2.02c1.39-.17 2.74-.71 3.9-1.61l-1.44-1.44c-.75.54-1.59.89-2.46 1.03zm3.89-2.42l1.42 1.41c.9-1.16 1.45-2.5 1.62-3.89h-2.02c-.14.87-.48 1.72-1.02 2.48z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-strong
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 6c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zM5 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-stable
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M2,4v16h20V4H2z M4,18V6h2.95l-2.33,8.73L16.82,18H4z M20,18h-2.95l2.34-8.73L7.18,6H20V18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 nature-people
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22.17 9.17c0-3.91-3.19-7.06-7.11-7-3.83.06-6.99 3.37-6.88 7.19.09 3.38 2.58 6.16 5.83 6.7V20H6v-3h1v-5H2v5h1v5h16v-2h-3v-3.88c3.47-.41 6.17-3.36 6.17-6.95zM4.5 11c.83 0 1.5-.67 1.5-1.5S5.33 8 4.5 8 3 8.67 3 9.5 3.67 11 4.5 11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-neg-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.05 16.29l2.86-3.07c.38-.39.72-.79 1.04-1.18.32-.39.59-.78.82-1.17s.41-.78.54-1.17.19-.79.19-1.18c0-.53-.09-1.02-.27-1.46s-.44-.81-.78-1.11c-.34-.31-.77-.54-1.26-.71-.51-.16-1.08-.24-1.72-.24-.69 0-1.31.11-1.85.32-.54.21-1 .51-1.36.88-.37.37-.65.8-.84 1.3-.18.47-.27.97-.28 1.5h2.14c.01-.31.05-.6.13-.87.09-.29.23-.54.4-.75.18-.21.41-.37.68-.49s.6-.18.96-.18c.31 0 .58.05.81.15s.43.25.59.43.28.4.37.65c.08.25.13.52.13.81 0 .22-.03.43-.08.65-.06.22-.15.45-.29.7-.14.25-.32.53-.56.83-.23.3-.52.65-.88 1.03l-4.17 4.55V18H21v-1.71h-5.95zM2 11v2h8v-2H2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 compare
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 3H3v18h7v2h2V1h-2v2zm0 15H5l5-6v6zM21 3h-7v2h5v13l-5-6v9h7V3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-plus-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.05 16.29l2.86-3.07c.38-.39.72-.79 1.04-1.18.32-.39.59-.78.82-1.17s.41-.78.54-1.17c.13-.39.19-.79.19-1.18 0-.53-.09-1.02-.27-1.46s-.44-.81-.78-1.11c-.34-.31-.77-.54-1.26-.71-.51-.16-1.08-.24-1.72-.24-.69 0-1.31.11-1.85.32-.54.21-1 .51-1.36.88-.37.37-.65.8-.84 1.3-.18.47-.27.97-.28 1.5h2.14c.01-.31.05-.6.13-.87.09-.29.23-.54.4-.75.18-.21.41-.37.68-.49s.6-.18.96-.18c.31 0 .58.05.81.15s.43.25.59.43.28.4.37.65c.08.25.13.52.13.81 0 .22-.03.43-.08.65-.06.22-.15.45-.29.7-.14.25-.32.53-.56.83-.23.3-.52.65-.88 1.03l-4.17 4.55V18H22v-1.71h-5.95zM8 7H6v4H2v2h4v4h2v-4h4v-2H8V7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 20V4H1v16h22zM8.5 12.5l2.5 3.01L14.5 11l4.5 6H5l3.5-4.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-yuan
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "13.28,12 18,12 18,14 13,14 13,21 11,21 11,14 6,14 6,12 10.72,12 5,3 7.37,3 12,10.29 16.63,3 19,3",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 collections-bookmark
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 6H2v16h16v-2H4V6zm18-4H6v16h16V2zm-2 10l-2.5-1.5L15 12V4h5v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 12.9V9h-5v6h1.5v-2h1.1l.9 2H21l-.9-2.1h.9zm-1.5-1.4h-2v-1h2v1zm-13-.5h-2V9H3v6h1.5v-2.5h2V15H8V9H6.5v2zM13 9H9.5v6H13c.8 0 1.5-.7 1.5-1.5v-3c0-.8-.7-1.5-1.5-1.5zm0 4.5h-2v-3h2v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-9-plus
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5H1v18h18v-2H3V5zm11 9V6H9v5h3v1H9v2h5zm-3-5V8h1v1h-1zm12-8H5v18h18V1zm-2 8h-2V7h-2v2h-2v2h2v2h2v-2h2v6H7V3h14v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 autofps-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "12.03,6.3 11.97,6.3 10.95,9.19 13.05,9.19",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "3",
      :width "2",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,15c3.31,0,6-2.69,6-6s-2.69-6-6-6S6,5.69,6,9S8.69,15,12,15z M11.37,5h1.25l2.63,7h-1.21l-0.63-1.79h-2.83L9.96,12 H8.74L11.37,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "7",
      :width "2",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "11",
      :width "2",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "17",
      :x "15",
      :width "6",
      :height "5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 currency-pound
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,21c1.93,0,3.62-1.17,4-3l-1.75-0.88C16,18.21,15.33,19,14,19l-4.9,0c0.83-1,1.5-2.34,1.5-4c0-0.35-0.03-0.69-0.08-1 L14,14v-2l-4.18,0C9,10.42,8,9.6,8,8c0-1.93,1.57-3.5,3.5-3.5c1.5,0,2.79,0.95,3.28,2.28L16.63,6c-0.8-2.05-2.79-3.5-5.13-3.5 C8.46,2.5,6,4.96,6,8c0,1.78,0.79,2.9,1.49,4L6,12v2l2.47,0c0.08,0.31,0.13,0.64,0.13,1c0,2.7-2.6,4-2.6,4v2H14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _5mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M10,10h3V9h-3V5.5h4.5V7h-3v1h3v3.5H10V10z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M18,17 h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 mic-external-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M9.22,7H4.78C4.3,6.47,4,5.77,4,5c0-1.66,1.34-3,3-3s3,1.34,3,3C10,5.77,9.7,6.47,9.22,7z M20,2v20h-2V4h-4v18H6 c0,0,0-1.79,0-4H5L4,8h6L9,18H8v2h4V2H20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 texture
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.66 3L3.07 19.59V21h1.41L21.07 4.42V3zm-7.71 0l-8.88 8.88v2.83L14.78 3zM3.07 3v4l4-4zm18 18v-4l-4 4zm-8.88 0l8.88-8.88V9.29L9.36 21z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-photo-alternate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 7v2.99s-1.99.01-2 0V7h-3s.01-1.99 0-2h3V2h2v3h3v2h-3zm-3 4V8h-3V5H3v16h16V11h-3zM5 19l3-4 2 3 3-4 4 5H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _10mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13.5,7H15v3h-1.5V7z M21,3H3v18h18V3z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M15,18.5h-1.5v-6H18V17h-3 V18.5z M10,5.5v6H8.5V7H7V5.5H10z M16.5,5.5v6H12v-6H16.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 looks-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3H3v18h18V3zm-6 6h-4v2h4v6H9v-2h4v-2H9V7h6v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.47,2,2,6.47,2,12s4.47,10,10,10s10-4.47,10-10S17.53,2,12,2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flash-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M7 2v11h3v9l7-12h-4l3-8z", :stroke nil, :fill nil})))


(helix.core/defnc
 photo-size-select-large
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 15h2v2h-2v-2zm0 4h2v2h-2v-2zm0-8h2v2h-2v-2zm-8-8h2v2h-2V3zm8 4h2v2h-2V7zM1 7h2v2H1V7zm16-4h2v2h-2V3zm0 16h2v2h-2v-2zM3 3H1v2h2V3zm20 0h-2v2h2V3zM9 3h2v2H9V3zM5 3h2v2H5V3zm-4 8v10h14V11H1zm2 8l2.5-3.21 1.79 2.15 2.5-3.22L13 19H3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-8
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5H1v18h18v-2H3V5zm20-4H5v18h18V1zm-2 16H7V3h14v14zm-8-2h2c1.1 0 2-.89 2-2v-1.5c0-.83-.67-1.5-1.5-1.5.83 0 1.5-.67 1.5-1.5V7c0-1.11-.9-2-2-2h-2c-1.1 0-2 .89-2 2v1.5c0 .83.67 1.5 1.5 1.5-.83 0-1.5.67-1.5 1.5V13c0 1.11.9 2 2 2zm0-8h2v2h-2V7zm0 4h2v2h-2v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-3-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d "M21,6H3v12h18V6z M19,16H5V8h14V16z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 contrast
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,22c5.52,0,10-4.48,10-10S17.52,2,12,2S2,6.48,2,12S6.48,22,12,22z M13,4.07c3.94,0.49,7,3.85,7,7.93s-3.05,7.44-7,7.93 V4.07z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 brush
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 14c-1.66 0-3 1.34-3 3 0 1.31-1.16 2-2 2 .92 1.22 2.49 2 4 2 2.21 0 4-1.79 4-4 0-1.66-1.34-3-3-3zm14.41-8.66l-2.75-2.75L9 12.25 11.75 15l9.66-9.66z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5H1v18h18v-2H3V5zm11 10h2V5h-4v2h2v8zm9-14H5v18h18V1zm-2 16H7V3h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 healing
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.74 12.01l4.68-4.68-5.75-5.75-4.68 4.68L7.3 1.58 1.55 7.34l4.68 4.69-4.68 4.68 5.75 5.75 4.68-4.68 4.69 4.69 5.76-5.76-4.69-4.7zM12 9c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm-4.71 1.96L3.66 7.34l3.63-3.63 3.62 3.62-3.62 3.63zM10 13c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm2 2c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm2-4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm2.66 9.34l-3.63-3.62 3.63-3.63 3.62 3.62-3.62 3.63z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 euro
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/path
    {:d
     "M15,18.5c-2.51,0-4.68-1.42-5.76-3.5H15l1-2H8.58c-0.05-0.33-0.08-0.66-0.08-1s0.03-0.67,0.08-1H15l1-2H9.24 C10.32,6.92,12.5,5.5,15,5.5c1.61,0,3.09,0.59,4.23,1.57L21,5.3C19.41,3.87,17.3,3,15,3c-3.92,0-7.24,2.51-8.48,6H3l-1,2h4.06 C6.02,11.33,6,11.66,6,12s0.02,0.67,0.06,1H3l-1,2h4.52c1.24,3.49,4.56,6,8.48,6c2.31,0,4.41-0.87,6-2.3l-1.78-1.77 C18.09,17.91,16.62,18.5,15,18.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 filter-6
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5H1v18h18v-2H3V5zm20-4H5v18h18V1zm-2 16H7V3h14v14zm-10-2h6V9h-4V7h4V5h-6v10zm2-4h2v2h-2v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 landscape
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 6l-3.75 5 2.85 3.8-1.6 1.2C9.81 13.75 7 10 7 10l-6 8h22L14 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 navigate-before
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M15.61 7.41L14.2 6l-6 6 6 6 1.41-1.41L11.03 12l4.58-4.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vignette
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 3H1v18h22V3zM12 18c-4.42 0-8-2.69-8-6s3.58-6 8-6 8 2.69 8 6-3.58 6-8 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mic-external-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10,5c0-1.66-1.34-3-3-3C6.38,2,5.81,2.19,5.33,2.5l4.15,4.15C9.8,6.18,10,5.61,10,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "14,4 18,4 18,15.17 20,17.17 20,2 12,2 12,9.17 14,11.17",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.1,2.1L0.69,3.51L5.17,8H4l1,10h1c0,2.21,0,4,0,4h8v-5.17l6.49,6.49l1.41-1.41L2.1,2.1z M12,20H8v-2h1l0.56-5.61 L12,14.83V20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 image-search
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 13v7H4V6h5.02c.05-.71.22-1.38.48-2H2v18h18v-7l-2-2zm-1.5 5h-11l2.75-3.53 1.96 2.36 2.75-3.54L16.5 18zm2.8-9.11c.44-.7.7-1.51.7-2.39C20 4.01 17.99 2 15.5 2S11 4.01 11 6.5s2.01 4.5 4.49 4.5c.88 0 1.7-.26 2.39-.7L21 13.42 22.42 12 19.3 8.89zM15.5 9C14.12 9 13 7.88 13 6.5S14.12 4 15.5 4 18 5.12 18 6.5 16.88 9 15.5 9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.96 10.29l-2.75 3.54-1.96-2.36L8.5 15h11l-3.54-4.71zM3 5H1v18h18v-2H3V5zm20-4H5v18h18V1zm-2 16H7V3h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-7
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5H1v18h18v-2H3V5zm20-4H5v18h18V1zm-2 16H7V3h14v14zm-8-2l4-8V5h-6v2h4l-4 8h2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-shade
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,12v2.5l5.5,5.5H22L14,12z M14,20h3l-3-3V20z M8,4l-6,6h2v10h8V10h2L8,4z M9,14H7v-4h2V14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _22mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M6.5,8h3V7h-3V5.5H11V9H8v1h3v1.5H6.5V8z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M13,8h3V7 h-3V5.5h4.5V9h-3v1h3v1.5H13V8z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-9
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5H1v18h18v-2H3V5zm20-4H5v18h18V1zm-2 16H7V3h14v14zM17 5h-6v6h4v2h-4v2h6V5zm-2 4h-2V7h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tonality
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.94-.49-7-3.85-7-7.93s3.05-7.44 7-7.93v15.86zm2-15.86c1.03.13 2 .45 2.87.93H13v-.93zM13 7h5.24c.25.31.48.65.68 1H13V7zm0 3h6.74c.08.33.15.66.19 1H13v-1zm0 9.93V19h2.87c-.87.48-1.84.8-2.87.93zM18.24 17H13v-1h5.92c-.2.35-.43.69-.68 1zm1.5-3H13v-1h6.93c-.04.34-.11.67-.19 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 looks-one
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3H3v18h18V3zm-7 14h-2V9h-2V7h4v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 center-focus-strong
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm-7 7H3v6h6v-2H5v-4zM5 5h4V3H3v6h2V5zm16-2h-6v2h4v4h2V3zm-2 16h-4v2h6v-6h-2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-size-select-actual
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M23 3H1v18h22V3zM5 17l3.5-4.5 2.5 3.01L14.5 11l4.5 6H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-7-5
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d "M21,5H3v14h18V5z M19,17H5V7h14V17z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 collections
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 18V2H6v16h16zm-11-6l2.03 2.71L16 11l4 5H8l3-4zM2 6v16h16v-2H4V6H2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flip-camera-android
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M9,12c0,1.66,1.34,3,3,3s3-1.34,3-3s-1.34-3-3-3S9,10.34,9,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,10V8H5.09C6.47,5.61,9.05,4,12,4c3.72,0,6.85,2.56,7.74,6h2.06c-0.93-4.56-4.96-8-9.8-8C8.73,2,5.82,3.58,4,6.01V4H2v6 H8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,14v2h2.91c-1.38,2.39-3.96,4-6.91,4c-3.72,0-6.85-2.56-7.74-6H2.2c0.93,4.56,4.96,8,9.8,8c3.27,0,6.18-1.58,8-4.01V20 h2v-6H16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-free
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 3v6h2V5h4V3H3zm2 12H3v6h6v-2H5v-4zm14 4h-4v2h6v-6h-2v4zm2-16h-6v2h4v4h2V3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-pause
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M2.88,7.88l1.54,1.54C4.15,10.23,4,11.1,4,12c0,4.41,3.59,8,8,8s8-3.59,8-8s-3.59-8-8-8c-0.9,0-1.77,0.15-2.58,0.42 L7.89,2.89C9.15,2.32,10.54,2,12,2c5.52,0,10,4.48,10,10s-4.48,10-10,10S2,17.52,2,12C2,10.53,2.32,9.14,2.88,7.88z M7,5.5 C7,6.33,6.33,7,5.5,7S4,6.33,4,5.5S4.67,4,5.5,4S7,4.67,7,5.5z M12,6c-3.31,0-6,2.69-6,6s2.69,6,6,6s6-2.69,6-6S15.31,6,12,6z M11,15H9V9h2V15z M15,15h-2V9h2V15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-zero
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.14 12.5c0 1-.1 1.85-.3 2.55s-.48 1.27-.83 1.7c-.36.44-.79.75-1.3.95s-1.07.3-1.7.3c-.62 0-1.18-.1-1.69-.3-.51-.2-.95-.51-1.31-.95s-.65-1.01-.85-1.7c-.2-.7-.3-1.55-.3-2.55v-2.04c0-1 .1-1.85.3-2.55.2-.7.48-1.26.84-1.69.36-.43.8-.74 1.31-.93C10.81 5.1 11.38 5 12 5c.63 0 1.19.1 1.7.29.51.19.95.5 1.31.93.36.43.64.99.84 1.69.2.7.3 1.54.3 2.55v2.04h-.01zm-2.11-2.36c0-.64-.05-1.18-.13-1.62-.09-.44-.22-.79-.4-1.06-.17-.27-.39-.46-.64-.58-.25-.13-.54-.19-.86-.19s-.61.06-.86.18-.47.31-.64.58-.31.62-.4 1.06-.13.98-.13 1.62v2.67c0 .64.05 1.18.14 1.62.09.45.23.81.4 1.09s.39.48.64.61.54.19.87.19.62-.06.87-.19.46-.33.63-.61.3-.64.39-1.09.13-.99.13-1.62v-2.66h-.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.5 15v-2h1.1l.9 2H21l-.9-2.1h.9V9h-5v4.86L17.14 15h.36zm0-4.5h2v1h-2v-1zm-4.5 0v.36l1.5 1.5V10.5c0-.8-.7-1.5-1.5-1.5h-1.86l1.5 1.5H13zM2.51 2.49L1.45 3.55 6.9 9h-.4v2h-2V9H3v6h1.5v-2.5h2V15H8v-4.9l1.5 1.5V15h3.4l7.6 7.6 1.06-1.06z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-wide-angle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 6c2.45 0 4.71.2 7.29.64.47 1.78.71 3.58.71 5.36s-.24 3.58-.71 5.36c-2.58.44-4.84.64-7.29.64s-4.71-.2-7.29-.64C4.24 15.58 4 13.78 4 12s.24-3.58.71-5.36C7.29 6.2 9.55 6 12 6m0-2c-2.73 0-5.22.24-7.95.72l-.93.16-.25.9C2.29 7.85 2 9.93 2 12s.29 4.15.87 6.22l.25.89.93.16c2.73.49 5.22.73 7.95.73s5.22-.24 7.95-.72l.93-.16.25-.89c.58-2.08.87-4.16.87-6.23s-.29-4.15-.87-6.22l-.25-.89-.93-.16C17.22 4.24 14.73 4 12 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 transform
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 18v-2H8V4h2L7 1 4 4h2v2H2v2h4v10h10v2h-2l3 3 3-3h-2v-2h4zM10 8h6v6h2V6h-8v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-lira
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9,8.76V3h2v4.51L15,5v2.36l-4,2.51l0.01,2.35L15,9.72v2.36l-4,2.51V19c2.76,0,5-2.24,5-5h2c0,3.87-3.13,7-7,7H9v-5.16 l-3,1.88l0-2.36l3-1.88v-2.36L6,13l0-2.36L9,8.76z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 camera-roll
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 5V3h-3V1H5v2H2v19h12v-2h8V5h-8zm-2 13h-2v-2h2v2zm0-9h-2V7h2v2zm4 9h-2v-2h2v2zm0-9h-2V7h2v2zm4 9h-2v-2h2v2zm0-9h-2V7h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 slideshow
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10 8v8l5-4-5-4zm11-5H3v18h18V3zm-2 16H5V5h14v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 music-note
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 3v10.55c-.59-.34-1.27-.55-2-.55-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4V7h4V3h-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _8mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.5",
      :x "11.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M10,5.5h4.5v6H10V5.5z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "11.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 panorama-vertical
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.46 4c-.77 2.6-1.16 5.28-1.16 8 0 2.72.39 5.41 1.16 8H6.55c.77-2.6 1.16-5.28 1.16-8 0-2.72-.39-5.41-1.16-8h10.91m2.78-2H3.77s.26.77.3.88C5.16 5.82 5.71 8.91 5.71 12s-.55 6.18-1.64 9.12c-.04.11-.3.88-.3.88h16.47s-.26-.77-.3-.88c-1.09-2.94-1.64-6.03-1.64-9.12s.55-6.18 1.64-9.12c.04-.11.3-.88.3-.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _2mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M10,8h3V7h-3V5.5h4.5V9h-3v1h3v1.5H10V8z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M18,17h-3 v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 photo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 21V3H3v18h18zM8.5 13.5l2.5 3.01L14.5 12l4.5 6H5l3.5-4.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-iridescent
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 15h14V9.05H5V15zm6-14v3h2V1h-2zm8.04 2.6l-1.79 1.79 1.41 1.41 1.8-1.79-1.42-1.41zM13 23v-2.95h-2V23h2zm7.45-3.91l-1.8-1.79-1.41 1.41 1.79 1.8 1.42-1.42zM3.55 5.01L5.34 6.8l1.41-1.41L4.96 3.6 3.55 5.01zM4.96 20.5l1.79-1.8-1.41-1.41-1.79 1.79 1.41 1.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-awesome-mosaic
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M3,21h8V3L3,3V21z M21,3h-8v8h8V3z M13,21h8v-8h-8V21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 colorize
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21.42 6.34l-3.75-3.75-3.82 3.82-1.94-1.91-1.41 1.41 1.42 1.42L3 16.25V21h4.75l8.92-8.92 1.42 1.42 1.41-1.41-1.92-1.92 3.84-3.83zM6.92 19L5 17.08l8.06-8.06 1.92 1.92L6.92 19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _17mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M7,5.5h3v6H8.5V7H7V5.5z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M12,7V5.5h4.87l-1.87,6 h-1.75L14.62,7H12z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 panorama-wide-angle-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,4C8.03,4,5.15,4.63,3,5c-0.55,1.97-1,3.92-1,7c0,3.03,0.45,5.05,1,7c2.15,0.37,4.98,1,9,1c3.97,0,6.85-0.63,9-1 c0.57-2.02,1-3.99,1-7c0-3.03-0.45-5.05-1-7C18.85,4.63,16.02,4,12,4z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 rotate-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.11 8.53L5.7 7.11C4.8 8.27 4.24 9.61 4.07 11h2.02c.14-.87.49-1.72 1.02-2.47zM6.09 13H4.07c.17 1.39.72 2.73 1.62 3.89l1.41-1.42c-.52-.75-.87-1.59-1.01-2.47zm1.01 5.32c1.16.9 2.51 1.44 3.9 1.61V17.9c-.87-.15-1.71-.49-2.46-1.03L7.1 18.32zM13 4.07V1L8.45 5.55 13 10V6.09c2.84.48 5 2.94 5 5.91s-2.16 5.43-5 5.91v2.02c3.95-.49 7-3.85 7-7.93s-3.05-7.44-7-7.93z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flare
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 11H1v2h6v-2zm2.17-3.24L7.05 5.64 5.64 7.05l2.12 2.12 1.41-1.41zM13 1h-2v6h2V1zm5.36 6.05l-1.41-1.41-2.12 2.12 1.41 1.41 2.12-2.12zM17 11v2h6v-2h-6zm-5-2c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zm2.83 7.24l2.12 2.12 1.41-1.41-2.12-2.12-1.41 1.41zm-9.19.71l1.41 1.41 2.12-2.12-1.41-1.41-2.12 2.12zM11 23h2v-6h-2v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _6mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M10,5.5h4.5V7h-3v1h3v3.5H10V5.5z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5V18.5z M18,17h-3v1.5 h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "11.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _13mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M12,10h3V9h-2V8h2V7h-3V5.5h4.5v6H12V10z M7,5.5h3v6H8.5V7H7V5.5z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6 v-6h6.5V18.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 motion-photos-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,6c-0.92,0-1.8,0.22-2.58,0.59l7.99,7.99C17.78,13.8,18,12.92,18,12C18,8.69,15.31,6,12,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.81,2.81L1.39,4.22l2.27,2.27C2.61,8.07,2,9.96,2,12c0,5.52,4.48,10,10,10c2.04,0,3.93-0.61,5.51-1.66l2.27,2.27 l1.41-1.42L2.81,2.81z M12,20c-4.41,0-8-3.59-8-8c0-1.48,0.41-2.86,1.12-4.06l1.47,1.47C6.22,10.2,6,11.08,6,12c0,3.31,2.69,6,6,6 c0.92,0,1.8-0.22,2.58-0.59l1.47,1.47C14.86,19.59,13.48,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,4c4.41,0,8,3.59,8,8c0,1.48-0.41,2.86-1.12,4.05l1.45,1.45C21.39,15.93,22,14.04,22,12c0-5.52-4.48-10-10-10 C9.96,2,8.07,2.61,6.49,3.66l1.45,1.45C9.14,4.41,10.52,4,12,4z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-original
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3v18h18V3zm-2 16H5V5h14v14zm-5.04-6.71l-2.75 3.54-1.96-2.36L6.5 17h11l-3.54-4.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timer-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "1", :x "9", :width "6", :height "2", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M13,8v2.17l6.98,6.98C20.63,15.91,21,14.5,21,13c0-2.12-0.74-4.07-1.97-5.61l1.42-1.42c-0.43-0.51-0.9-0.99-1.41-1.41 l-1.42,1.42C16.07,4.74,14.12,4,12,4c-1.5,0-2.91,0.37-4.15,1.02L10.83,8H13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.81,2.81L1.39,4.22l3.4,3.4C3.67,9.12,3,10.98,3,13c0,4.97,4.02,9,9,9c2.02,0,3.88-0.67,5.38-1.79l2.4,2.4l1.41-1.41 L2.81,2.81z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 face-retouching-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M17.5,10c0.75,0,1.47-0.09,2.17-0.24C19.88,10.47,20,11.22,20,12c0,1.22-0.28,2.37-0.77,3.4l1.49,1.49 C21.53,15.44,22,13.78,22,12c0-5.52-4.48-10-10-10c-1.78,0-3.44,0.47-4.89,1.28l5.33,5.33C13.93,9.49,15.65,10,17.5,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1.89,3.72l2.19,2.19C2.78,7.6,2,9.71,2,12c0,5.52,4.48,10,10,10c2.29,0,4.4-0.78,6.09-2.08l2.19,2.19l1.41-1.41 L3.31,2.31L1.89,3.72z M16.66,18.49C15.35,19.44,13.74,20,12,20c-4.41,0-8-3.59-8-8c0-0.05,0.01-0.1,0-0.14 c1.39-0.52,2.63-1.35,3.64-2.39L16.66,18.49z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 palette
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.49,2,2,6.49,2,12s4.49,10,10,10c1.38,0,2.5-1.12,2.5-2.5c0-0.61-0.23-1.2-0.64-1.67c-0.08-0.1-0.13-0.21-0.13-0.33 c0-0.28,0.22-0.5,0.5-0.5H16c3.31,0,6-2.69,6-6C22,6.04,17.51,2,12,2z M17.5,13c-0.83,0-1.5-0.67-1.5-1.5c0-0.83,0.67-1.5,1.5-1.5 s1.5,0.67,1.5,1.5C19,12.33,18.33,13,17.5,13z M14.5,9C13.67,9,13,8.33,13,7.5C13,6.67,13.67,6,14.5,6S16,6.67,16,7.5 C16,8.33,15.33,9,14.5,9z M5,11.5C5,10.67,5.67,10,6.5,10S8,10.67,8,11.5C8,12.33,7.33,13,6.5,13S5,12.33,5,11.5z M11,7.5 C11,8.33,10.33,9,9.5,9S8,8.33,8,7.5C8,6.67,8.67,6,9.5,6S11,6.67,11,7.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 looks-two
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3H3v18h18V3zm-6 10h-4v2h4v2H9v-6h4V9H9V7h6v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-to-photos
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 6H2v16h16v-2H4V6zm18-4H6v16h16V2zm-3 9h-4v4h-2v-4H9V9h4V5h2v4h4v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _19mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "6.5",
      :x "13.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M12,10h3V9h-3V5.5h4.5v6H12V10z M7,5.5h3v6H8.5V7H7V5.5z M12.5,18.5H11V14h-1v3H8.5v-3h-1v4.5H6v-6h6.5 V18.5z M18,17h-3v1.5h-1.5v-6H18V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 rotate-90-degrees-ccw
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.34 6.41L.86 12.9l6.49 6.48 6.49-6.48-6.5-6.49zM3.69 12.9l3.66-3.66L11 12.9l-3.66 3.66-3.65-3.66zm15.67-6.26C17.61 4.88 15.3 4 13 4V.76L8.76 5 13 9.24V6c1.79 0 3.58.68 4.95 2.05 2.73 2.73 2.73 7.17 0 9.9C16.58 19.32 14.79 20 13 20c-.97 0-1.94-.21-2.84-.61l-1.49 1.49C10.02 21.62 11.51 22 13 22c2.3 0 4.61-.88 6.36-2.64 3.52-3.51 3.52-9.21 0-12.72z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-auto
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M2.88,7.88l1.54,1.54C4.15,10.23,4,11.1,4,12c0,4.41,3.59,8,8,8s8-3.59,8-8s-3.59-8-8-8c-0.9,0-1.77,0.15-2.58,0.42 L7.89,2.89C9.15,2.32,10.54,2,12,2c5.52,0,10,4.48,10,10s-4.48,10-10,10S2,17.52,2,12C2,10.53,2.32,9.14,2.88,7.88z M7,5.5 C7,6.33,6.33,7,5.5,7S4,6.33,4,5.5S4.67,4,5.5,4S7,4.67,7,5.5z M12.03,8.99h-0.07l-1.16,3.31h2.39L12.03,8.99z M12,18 c3.31,0,6-2.69,6-6s-2.69-6-6-6s-6,2.69-6,6S8.69,18,12,18z M11.29,7.5h1.43l3.01,8h-1.39l-0.72-2.04h-3.23L9.66,15.5H8.28 L11.29,7.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 linked-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "3", :cy "14", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M18 8h1.33c0-1.84-1.49-3.33-3.33-3.33V6c1.11 0 2 .89 2 2zm2.67 0H22c0-3.31-2.69-6-6-6v1.33c2.58 0 4.67 2.09 4.67 4.67zM15 7V4H9L7.17 6H2v16h20V9h-5c0-1.1-.9-2-2-2zm-3 12c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M2.88,7.88l1.54,1.54C4.15,10.23,4,11.1,4,12c0,4.41,3.59,8,8,8s8-3.59,8-8s-3.59-8-8-8c-0.9,0-1.77,0.15-2.58,0.42 L7.89,2.89C9.15,2.32,10.54,2,12,2c5.52,0,10,4.48,10,10s-4.48,10-10,10S2,17.52,2,12C2,10.53,2.32,9.14,2.88,7.88z M6,12 c0-3.31,2.69-6,6-6s6,2.69,6,6s-2.69,6-6,6S6,15.31,6,12z M7,5.5C7,6.33,6.33,7,5.5,7S4,6.33,4,5.5S4.67,4,5.5,4S7,4.67,7,5.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 blur-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 13c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-8c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm-3 .5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM6 5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm15 5.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM14 7c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0-3.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm-11 10c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm7 7c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm0-17c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM10 7c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0 5.5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm8 .5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-8c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm3 8.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM14 17c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 3.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm-4-12c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm0 8.5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm4-4.5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm0-4c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-yen
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "13.92,11 18,11 18,13 13,13 13,15 18,15 18,17 13,17 13,21 11,21 11,17 6,17 6,15 11,15 11,13 6,13 6,11 10.08,11 5,3 7.37,3 12,10.29 16.63,3 19,3",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 view-compact
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M4,18h2.5v-2.5H4V18z M4,13.25h2.5v-2.5H4V13.25z M4,8.5h2.5V6H4V8.5z M17.5,6v2.5H20V6H17.5z M13,8.5h2.5V6H13V8.5z M17.5,18H20v-2.5h-2.5V18z M17.5,13.25H20v-2.5h-2.5V13.25z M8.5,18H11v-2.5H8.5V18z M13,18h2.5v-2.5H13V18z M8.5,8.5H11V6H8.5 V8.5z M13,13.25h2.5v-2.5H13V13.25z M8.5,13.25H11v-2.5H8.5V13.25z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21 10V5H3v5H2v9h2v-2h16v2h2v-9h-1zm-8-3h6v3h-6V7zm-8 3V7h6v3H5zm-1 5v-3h16v3H4z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 door-back
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M19,19V3H5v16H3v2h18v-2H19z M11,13H9v-2h2V13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 door-front
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M19,19V3H5v16H3v2h18v-2H19z M15,13h-2v-2h2V13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bedroom-child
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "8.5",
      :x "9",
      :width "6",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "7.51",
      :width "9",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,2H2v20h20V2z M18,17h-1.5v-1.5h-9V17H6l0-6.32l1.5-0.01V7h9v3.67l1.5,0V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 bathroom
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,2H2v20h20V2z M9,18c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S9.55,18,9,18z M9,15c-0.55,0-1-0.45-1-1s0.45-1,1-1 s1,0.45,1,1S9.55,15,9,15z M12,18c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S12.55,18,12,18z M12,15c-0.55,0-1-0.45-1-1s0.45-1,1-1 s1,0.45,1,1S12.55,15,12,15z M15,18c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S15.55,18,15,18z M15,15c-0.55,0-1-0.45-1-1 s0.45-1,1-1s1,0.45,1,1S15.55,15,15,15z M17,12H7v-1c0-2.76,2.24-5,5-5s5,2.24,5,5V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bedroom-baby
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22,2H2v20h20V2z M12,18c-2.64,0-5.13-1.03-7-2.9l1.06-1.06c0.34,0.34,0.71,0.65,1.1,0.92L8,13.5V9.51L6.45,10.5l-0.95-1 L7,7.76L6,7h3.65l1.73,3H17v1h-1v2.5l0.84,1.46c0.39-0.28,0.76-0.58,1.1-0.92L19,15.1C17.13,16.97,14.64,18,12,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.69,14.24c-1.74,0.65-3.66,0.65-5.4,0l-0.81,1.41l-0.03,0.06c1.1,0.52,2.28,0.79,3.53,0.79s2.45-0.28,3.55-0.79 l-0.03-0.06L14.69,14.24z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 manage-search
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M7,9H2V7h5V9z M7,12H2v2h5V12z M20.59,19l-3.83-3.83C15.96,15.69,15.02,16,14,16c-2.76,0-5-2.24-5-5s2.24-5,5-5s5,2.24,5,5 c0,1.02-0.31,1.96-0.83,2.75L22,17.59L20.59,19z M17,11c0-1.65-1.35-3-3-3s-3,1.35-3,3s1.35,3,3,3S17,12.65,17,11z M2,19h10v-2H2 V19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 living
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "15.5,12 15.5,14.5 8.5,14.5 8.5,12 7.52,12 6.5,12 6.5,16.5 17.5,16.5 17.5,12",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "10,10 10,13 14,13 14,10 16.25,9.99 16.25,7.5 7.75,7.5 7.75,9.99",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M22,2H2v20h20V2z M19,9.99V18H5v-8l1.25-0.01V6h11.5v3.99H19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 doorbell
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,3L4,9v12h16V9L12,3z M12,17.5c-0.55,0-1-0.45-1-1h2C13,17.05,12.55,17.5,12,17.5z M16,16H8v-1h1v-2.34 c0-1.54,0.82-2.82,2.25-3.16v-1h1.5v1C14.19,9.84,15,11.12,15,12.66V15h1V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 coffee-maker
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,7V4h2V2H4v20h16v-2h-4.03C17.2,19.09,18,17.64,18,16v-5H8v5c0,1.64,0.81,3.09,2.03,4H6V4h2v3H18z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "9", :cx "13", :stroke nil, :fill nil})))))


(helix.core/defnc
 chair
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "7,13 17,13 17,7 20,7 20,3 4,3 4,7 7,7",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M23,9h-4v6H5V9H1v10h3v1c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1v-1h12v1c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1v-1h3V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shower
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/circle
    {:r "1", :cy "17", :cx "8", :stroke nil, :fill nil})
   (helix.dom/circle
    {:r "1", :cy "17", :cx "12", :stroke nil, :fill nil})
   (helix.dom/circle
    {:r "1", :cy "17", :cx "16", :stroke nil, :fill nil})
   (helix.dom/path
    {:d
     "M13,5.08V3h-2v2.08C7.61,5.57,5,8.47,5,12v2h14v-2C19,8.47,16.39,5.57,13,5.08z",
     :stroke nil,
     :fill nil})
   (helix.dom/circle
    {:r "1", :cy "20", :cx "8", :stroke nil, :fill nil})
   (helix.dom/circle
    {:r "1", :cy "20", :cx "12", :stroke nil, :fill nil})
   (helix.dom/circle
    {:r "1", :cy "20", :cx "16", :stroke nil, :fill nil}))))


(helix.core/defnc
 podcasts
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,12c0,0.74-0.4,1.38-1,1.72V22h-2v-8.28c-0.6-0.35-1-0.98-1-1.72c0-1.1,0.9-2,2-2S14,10.9,14,12z M12,6 c-3.31,0-6,2.69-6,6c0,1.74,0.75,3.31,1.94,4.4l1.42-1.42C8.53,14.25,8,13.19,8,12c0-2.21,1.79-4,4-4s4,1.79,4,4 c0,1.19-0.53,2.25-1.36,2.98l1.42,1.42C17.25,15.31,18,13.74,18,12C18,8.69,15.31,6,12,6z M12,2C6.48,2,2,6.48,2,12 c0,2.85,1.2,5.41,3.11,7.24l1.42-1.42C4.98,16.36,4,14.29,4,12c0-4.41,3.59-8,8-8s8,3.59,8,8c0,2.29-0.98,4.36-2.53,5.82l1.42,1.42 C20.8,17.41,22,14.85,22,12C22,6.48,17.52,2,12,2z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 feed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,3H3v18h18V8L16,3z M7,7h5v2H7V7z M17,17H7v-2h10V17z M17,13H7v-2h10V13z M15,9V5l4,4H15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 window
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "3", :x "3", :width "8", :height "8", :stroke nil, :fill nil})
    (helix.dom/rect
     {:y "3",
      :x "13",
      :width "8",
      :height "8",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "13",
      :x "3",
      :width "8",
      :height "8",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "13",
      :x "13",
      :width "8",
      :height "8",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 coffee
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.5,3H4v8c0,3.87,3.13,7,7,7h0c3.87,0,7-3.13,7-7v-1l0.4,0c1.67,0,3.19-1.13,3.52-2.77C22.39,4.98,20.67,3,18.5,3z M16,5 v3H6V5H16z M18.5,8H18V5h0.5C19.33,5,20,5.67,20,6.5S19.33,8,18.5,8z M4,19h16v2H4V19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 table-bar
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22,7.5C22,5.57,17.52,4,12,4S2,5.57,2,7.5c0,1.81,3.95,3.31,9,3.48V15H8l-2,5h2l1.2-3h5.6l1.2,3h2l-2-5h-3v-4.02 C18.05,10.81,22,9.31,22,7.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera-indoor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,3L4,9v12h16V9L12,3z M16,16.06L14,15v2H8v-6h6v2l2-1.06V16.06z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 door-sliding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V3h-7.25v16h-1.5V3H4v16H3v2h18v-2H20z M10,13H8v-2h2V13z M16,13h-2v-2h2V13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 light
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13,6.06V3h-2v3.06C5.87,6.63,2.03,11.51,3.22,17L8,17c0,2.21,1.79,4,4,4s4-1.79,4-4l4.78,0 C21.97,11.51,18.13,6.63,13,6.06z M12,15H5c0-3.86,3.14-7,7-7s7,3.14,7,7H12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 flatware
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,7.08c0,1.77-0.84,3.25-2,3.82V21h-2V10.9c-1.16-0.57-2-2.05-2-3.82C10.01,4.83,11.35,3,13,3C14.66,3,16,4.83,16,7.08z M17,3v18h2v-8h2V7C21,5.24,19.76,3,17,3z M8.28,3H7.56v4H6.72V3L6,3L5.28,3v4H4.44V3L3.72,3H3v8c0,0,0.9,0,2,0v10h2V11 c1.1,0,2,0,2,0V3L8.28,3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,2H2v20h20V2z M11,10.3c0,0.93-0.64,1.71-1.5,1.93V19H8v-6.77c-0.86-0.22-1.5-1-1.5-1.93V6H7h0.5v3h0.75V6h0.5h0.5v3H10 V6h0.5H11V10.3z M15.58,12.59l-0.08,0.03V19H14v-6.38l-0.08-0.04c-0.97-0.47-1.67-1.7-1.67-3.18c0-1.88,1.13-3.4,2.5-3.4 c1.38,0,2.5,1.53,2.5,3.41C17.25,10.89,16.55,12.12,15.58,12.59z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 table-restaurant
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22.33,11l-2-7H3.67l-2,7H5.2L4,20h2l0.67-5h10.67L18,20h2l-1.2-9H22.33z M6.93,13l0.27-2h9.6l0.27,2H6.93z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 garage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1", :cy "13", :cx "15", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points "8.33,7.5 7.67,9.5 16.33,9.5 15.67,7.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,2H2v20h20V2z M19,18.5h-2v-2H7v2H5v-7.31L6.89,5.5h10.21L19,11.19V18.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 blender
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,3h-4V2h-4v1H3v8h4.23l0.64,4.13L6,17v5h12v-5l-1.87-1.87L18,3z M5,9V5h1.31l0.62,4H5z M12,19c-0.55,0-1-0.45-1-1 s0.45-1,1-1s1,0.45,1,1S12.55,19,12,19z M14.29,14H9.72L8.33,5h7.34L14.29,14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera-outdoor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,14v-2h-6v6h6v-2l2,1.06v-4.12L18,14z M12,3L4,9v12h16v-2H6v-9l6-4.5l6,4.5v1h2V9L12,3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 yard
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22,2H2v20h20V2z M8,8.22c0-0.86,0.7-1.56,1.56-1.56c0.33,0,0.64,0.1,0.89,0.28l-0.01-0.12c0-0.86,0.7-1.56,1.56-1.56 s1.56,0.7,1.56,1.56l-0.01,0.12c0.26-0.18,0.56-0.28,0.89-0.28c0.86,0,1.56,0.7,1.56,1.56c0,0.62-0.37,1.16-0.89,1.4 C15.63,9.87,16,10.41,16,11.03c0,0.86-0.7,1.56-1.56,1.56c-0.33,0-0.64-0.11-0.89-0.28l0.01,0.12c0,0.86-0.7,1.56-1.56,1.56 s-1.56-0.7-1.56-1.56l0.01-0.12c-0.26,0.18-0.56,0.28-0.89,0.28C8.7,12.59,8,11.89,8,11.03c0-0.62,0.37-1.16,0.89-1.4 C8.37,9.38,8,8.84,8,8.22z M12,19c-3.31,0-6-2.69-6-6C9.31,13,12,15.69,12,19c0-3.31,2.69-6,6-6C18,16.31,15.31,19,12,19z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.56", :cy "9.62", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 chair-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,10h3V3H5v7h3v2H5v9h2v-3h10v3h2v-9h-3V10z M7,8V5h10v3H7z M17,16H7v-2h10V16z M14,12h-4v-2h4V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bedroom-parent
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "12",
      :x "6.5",
      :width "11",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8.5",
      :x "7.25",
      :width "4",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8.5",
      :x "12.75",
      :width "4",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,2H2v20h20V2z M19,17h-1.5v-1.5h-11V17H5v-5l0.65-0.55V7H11c0.37,0,0.72,0.12,1,0.32C12.28,7.12,12.63,7,13,7h5.35 v4.45L19,12V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 indeterminate-check-box
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d "M21 3H3v18h18V3zm-4 10H7v-2h10v2z", :stroke nil, :fill nil})))


(helix.core/defnc
 star-border
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 9.24l-7.19-.62L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27 18.18 21l-1.63-7.03L22 9.24zM12 15.4l-3.76 2.27 1-4.28-3.32-2.88 4.38-.38L12 6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 radio-button-unchecked
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 check-box-outline-blank
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M19 5v14H5V5h14m2-2H3v18h18V3z", :stroke nil, :fill nil})))


(helix.core/defnc
 star-border-purple500
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 9.24l-7.19-.62L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27 18.18 21l-1.63-7.03L22 9.24zM12 15.4l-3.76 2.27 1-4.28-3.32-2.88 4.38-.38L12 6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 star-half
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 9.24l-7.19-.62L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27 18.18 21l-1.63-7.03L22 9.24zM12 15.4V6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 radio-button-checked
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "5", :cy "12", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 toggle-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h10c2.76 0 5-2.24 5-5s-2.24-5-5-5zm0 8c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 toggle-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h10c2.76 0 5-2.24 5-5s-2.24-5-5-5zM7 15c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 star
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
   (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12 17.27 18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 star-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 9.24l-7.19-.62L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27 18.18 21l-1.63-7.03L22 9.24zM12 15.4l-3.76 2.27 1-4.28-3.32-2.88 4.38-.38L12 6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 check-box
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3v18h18V3zM10 17l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 star-purple500
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sign-language
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12.49,13l-1.39-2.7L12.49,9L19,15.2V24H4.5v-2H10v-1H3v-2h7v-1H2v-2h8v-1H3.5v-2H12.49z M11.78,7.12 c-0.84,0.4-1.17,0.62-1.63,1.19L6.76,4.74l1.45-1.38L11.78,7.12z M9.64,9.21C9.41,9.76,9.35,10.45,9.44,11H8.58L5.62,7.89 l1.45-1.38L9.64,9.21z M21.98,12.34L22,3.35l-1.9-0.1l-1,2.86L13.3,0l-1.45,1.38l4.09,4.3l-0.73,0.69L9.74,0.64L8.3,2l3.36,3.53 l1.06,1.11l2.65,2.33l5.08,4.83L21.98,12.34z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sports-cricket
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M15.05,12.81L6.56,4.32c-0.39-0.39-1.02-0.39-1.41,0L2.32,7.15c-0.39,0.39-0.39,1.02,0,1.41l8.49,8.49 c0.39,0.39,1.02,0.39,1.41,0l2.83-2.83C15.44,13.83,15.44,13.2,15.05,12.81z",
       :stroke nil,
       :fill nil})
     (helix.dom/rect
      {:y "16.17",
       :x "16.17",
       :width "2",
       :transform
       "matrix(0.7071 -0.7071 0.7071 0.7071 -8.5264 17.7562)",
       :height "6",
       :stroke nil,
       :fill nil}))
    (helix.dom/circle
     {:r "3.5", :cy "5.5", :cx "18.5", :stroke nil, :fill nil})))))


(helix.core/defnc
 thumb-down-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M1 11.6V16h8.31l-1.12 5.38L9.83 23 17 15.82V3H4.69zM19 3h4v12h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sports-tennis
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.52,2.49c-2.34-2.34-6.62-1.87-9.55,1.06c-1.6,1.6-2.52,3.87-2.54,5.46c-0.02,1.58,0.26,3.89-1.35,5.5l-4.24,4.24 l1.42,1.42l4.24-4.24c1.61-1.61,3.92-1.33,5.5-1.35s3.86-0.94,5.46-2.54C21.38,9.11,21.86,4.83,19.52,2.49z M10.32,11.68 c-1.53-1.53-1.05-4.61,1.06-6.72s5.18-2.59,6.72-1.06c1.53,1.53,1.05,4.61-1.06,6.72S11.86,13.21,10.32,11.68z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M18,17c0.53,0,1.04,0.21,1.41,0.59c0.78,0.78,0.78,2.05,0,2.83C19.04,20.79,18.53,21,18,21s-1.04-0.21-1.41-0.59 c-0.78-0.78-0.78-2.05,0-2.83C16.96,17.21,17.47,17,18,17 M18,15c-1.02,0-2.05,0.39-2.83,1.17c-1.56,1.56-1.56,4.09,0,5.66 C15.95,22.61,16.98,23,18,23s2.05-0.39,2.83-1.17c1.56-1.56,1.56-4.09,0-5.66C20.05,15.39,19.02,15,18,15L18,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 man
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "16,7 8,7 8,15 10,15 10,22 14,22 14,15 16,15",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 recycling
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M5.77 7.15 7.2 4.78l1.03-1.71c.39-.65 1.33-.65 1.72 0l1.48 2.46-1.23 2.06-1 1.62-3.43-2.06zm15.95 5.82-1.6-2.66-3.46 2L18.87 16H20c.76 0 1.45-.43 1.79-1.11.14-.28.21-.58.21-.89 0-.36-.1-.71-.28-1.03zM16 21h1.5c.76 0 1.45-.43 1.79-1.11L20.74 17H16v-2l-4 4 4 4v-2zm-6-4H5.7l-.84 1.41c-.3.5-.32 1.12-.06 1.65.28.57.87.94 1.52.94H10v-4zm-3.88-2.65 1.73 1.04L6.48 9.9 1 11.27l1.7 1.02-.41.69c-.35.59-.38 1.31-.07 1.92l1.63 3.26 2.27-3.81zm10.9-9.21-1.3-2.17C15.35 2.37 14.7 2 14 2h-3.53l3.12 5.2-1.72 1.03 5.49 1.37 1.37-5.49-1.71 1.03z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sports-rugby
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20.49,3.51c-0.56-0.56-2.15-0.97-4.16-0.97c-3.08,0-7.15,0.96-9.98,3.79C1.66,11.03,2.1,19.07,3.51,20.49 c0.56,0.56,2.15,0.97,4.16,0.97c3.08,0,7.15-0.96,9.98-3.79C22.34,12.97,21.9,4.93,20.49,3.51z M7.76,7.76 c2.64-2.64,6.35-3.12,8.03-3.19c-2.05,0.94-4.46,2.45-6.61,4.61c-2.16,2.16-3.67,4.58-4.61,6.63C4.66,13.33,5.44,10.07,7.76,7.76z M16.24,16.24c-2.64,2.64-6.35,3.12-8.03,3.19c2.05-0.94,4.46-2.45,6.61-4.61c2.16-2.16,3.67-4.58,4.62-6.63 C19.34,10.67,18.56,13.93,16.24,16.24z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 water-drop
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2c-5.33,4.55-8,8.48-8,11.8c0,4.98,3.8,8.2,8,8.2s8-3.22,8-8.2C20,10.48,17.33,6.55,12,2z M13,18.91 C12.68,18.97,12.35,19,12,19c-2.69,0-4.88-1.94-5-5h1.5c0.08,2.07,1.5,3.5,3.5,3.5c0.35,0,0.69-0.04,1-0.13V18.91z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 luggage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,6h-4V2H9v4H5v15h2c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1h6c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1h2V6z M9.5,18H8V9h1.5 V18z M12.75,18h-1.5V9h1.5V18z M13.5,6h-3V3.5h3V6z M16,18h-1.5V9H16V18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sick
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21,9c-1.1,0-2-0.9-2-2c0-1.1,2-4,2-4s2,2.9,2,4C23,8.1,22.1,9,21,9z M17.5,7c0-0.73,0.41-1.71,0.92-2.66 C16.68,2.88,14.44,2,11.99,2C6.47,2,2,6.48,2,12c0,5.52,4.47,10,9.99,10C17.52,22,22,17.52,22,12c0-0.55-0.06-1.09-0.14-1.62 C21.58,10.45,21.3,10.5,21,10.5C19.07,10.5,17.5,8.93,17.5,7z M15.62,7.38l1.06,1.06L15.62,9.5l1.06,1.06l-1.06,1.06L13.5,9.5 L15.62,7.38z M7.32,8.44l1.06-1.06L10.5,9.5l-2.12,2.12l-1.06-1.06L8.38,9.5L7.32,8.44z M15.44,17c-0.69-1.19-1.97-2-3.44-2 s-2.75,0.81-3.44,2H6.88c0.3-0.76,0.76-1.43,1.34-1.99L5.24,13.3c-0.45,0.26-1.01,0.28-1.49,0c-0.72-0.41-0.96-1.33-0.55-2.05 c0.41-0.72,1.33-0.96,2.05-0.55c0.48,0.28,0.74,0.78,0.74,1.29l3.58,2.07c0.73-0.36,1.55-0.56,2.43-0.56c2.33,0,4.32,1.45,5.12,3.5 H15.44z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 history-edu
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M9,4v1.38c-0.83-0.33-1.72-0.5-2.61-0.5c-1.79,0-3.58,0.68-4.95,2.05l3.33,3.33h1.11v1.11c0.86,0.86,1.98,1.31,3.11,1.36 V15H6v3c0,1.1,0.9,2,2,2h10c1.66,0,3-1.34,3-3V4H9z M7.89,10.41V8.26H5.61L4.57,7.22C5.14,7,5.76,6.88,6.39,6.88 c1.34,0,2.59,0.52,3.54,1.46l1.41,1.41l-0.2,0.2c-0.51,0.51-1.19,0.8-1.92,0.8C8.75,10.75,8.29,10.63,7.89,10.41z M19,17 c0,0.55-0.45,1-1,1s-1-0.45-1-1v-2h-6v-2.59c0.57-0.23,1.1-0.57,1.56-1.03l0.2-0.2L15.59,14H17v-1.41l-6-5.97V6h8V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sports-handball
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.27,6C13.72,6.95,14.05,8.18,15,8.73c0.95,0.55,2.18,0.22,2.73-0.73c0.55-0.95,0.22-2.18-0.73-2.73 C16.05,4.72,14.82,5.05,14.27,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.84,10.41c0,0-1.63-0.94-2.6-1.5c-2.38-1.38-3.2-4.44-1.82-6.82l-1.73-1C8.1,3.83,8.6,7.21,10.66,9.4l-5.15,8.92 l1.73,1l1.5-2.6l1.73,1l-3,5.2l1.73,1l6.29-10.89c1.14,1.55,1.33,3.69,0.31,5.46l1.73,1C19.13,16.74,18.81,12.91,15.84,10.41z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12.75,3.8c0.72,0.41,1.63,0.17,2.05-0.55c0.41-0.72,0.17-1.63-0.55-2.05c-0.72-0.41-1.63-0.17-2.05,0.55 C11.79,2.47,12.03,3.39,12.75,3.8z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 surfing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21,23c-1.03,0-2.06-0.25-3-0.75h0c-1.89,1-4.11,1-6,0c-1.89,1-4.11,1-6,0C5.05,22.75,4.03,23,3,23H2l0-2h1 c1.04,0,2.08-0.35,3-1c1.83,1.3,4.17,1.3,6,0c1.83,1.3,4.17,1.3,6,0c0.91,0.65,1.96,1,3,1h1v2H21z M17,1.5c-1.1,0-2,0.9-2,2 s0.9,2,2,2s2-0.9,2-2S18.1,1.5,17,1.5z M14.43,8.48L12.18,10L16,13v3.84c0.53,0.38,1.03,0.78,1.49,1.17C16.81,18.59,15.94,19,15,19 c-1.2,0-2.27-0.66-3-1.5c-0.73,0.84-1.8,1.5-3,1.5c-0.33,0-0.65-0.05-0.96-0.14C5.19,16.9,3,14.72,3,13.28C3,12.25,4.01,12,4.85,12 c0.98,0,2.28,0.31,3.7,0.83L7.83,8.59l3.12-2.1l-2-0.37L6.13,8.05L5,6.4L8.5,4l5.55,1.03c0.45,0.09,0.93,0.37,1.22,0.89l0.88,1.55 C17.01,8.98,18.64,10,20.5,10v2C17.91,12,15.64,10.58,14.43,8.48z M10.3,11.1l0.44,2.65c0.92,0.42,2.48,1.27,3.26,1.75V14L10.3,11.1 z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fireplace
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2,2v20h20V2H2z M13.2,13.74c-0.08-0.46-0.07-0.85,0.08-1.28c0.54,1.21,2.15,1.64,1.98,3.18 c-0.19,1.69-2.11,2.37-3.39,1.32c0.76-0.24,1.4-1.04,1.53-1.63C13.52,14.78,13.29,14.29,13.2,13.74z M20,20h-2v-2h-2.02 c0.63-0.84,1.02-1.87,1.02-3c0-1.89-1.09-2.85-1.85-3.37C12.2,9.61,13,7,13,7c-6.73,3.57-6.02,7.47-6,8c0.03,0.96,0.49,2.07,1.23,3 H6v2H4V4h16V20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 south-america
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M4,12c0-1.95,0.7-3.74,1.87-5.13L9,10 v1c0,1.1,0.9,2,2,2v5.59c0,0.27,0.11,0.52,0.29,0.71L12,20C7.58,20,4,16.42,4,12z M13,19.94V18l3.75-5.62 c0.16-0.25,0.25-0.54,0.25-0.83V10.5c0-0.55-0.45-1-1-1h-1.5l-1.4-1.75C12.72,7.28,12.15,7,11.54,7H8V5.07C9.18,4.39,10.54,4,12,4 c4.41,0,8,3.59,8,8C20,16.07,16.94,19.44,13,19.94z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 blind
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "3.5", :cx "11.5", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M12.13,7.12c-0.17-0.35-0.44-0.65-0.8-0.85C10.72,5.91,9.99,5.93,9.4,6.24l0-0.01L4,9.3V14h2v-3.54l1.5-0.85 C7.18,10.71,7,11.85,7,13v5.33L4.4,21.8L6,23l3-4l0.22-3.54L11,18v5h2v-6.5l-1.97-2.81c-0.04-0.52-0.14-1.76,0.45-3.4 c0.75,1.14,1.88,1.98,3.2,2.41L20.63,23l0.87-0.5L16.02,13H17v-2c-0.49,0-2.88,0.17-4.08-2.21",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sports-hockey
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M2,17v3l2,0v-4H3C2.45,16,2,16.45,2,17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9,16H5v4l4.69-0.01c0.38,0,0.72-0.21,0.89-0.55l0.87-1.9l-1.59-3.48L9,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M21.71,16.29C21.53,16.11,21.28,16,21,16h-1v4l2,0v-3C22,16.72,21.89,16.47,21.71,16.29z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M13.6,12.84L17.65,4H14.3l-1.76,3.97l-0.49,1.1L12,9.21L9.7,4H6.35l4.05,8.84l1.52,3.32L12,16.34l1.42,3.1 c0.17,0.34,0.51,0.55,0.89,0.55L19,20v-4h-4L13.6,12.84z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 piano
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21,3H3v18h18V3z M13,14.5h1.25V19h-4.5v-4.5H11V5h2V14.5z M5,5h2v9.5h1.25V19H5V5z M19,19h-3.25v-4.5H17V5h2V19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 woman-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points
       "13.41,7 10.59,7 7,16 10.5,16 10.5,22 13.5,22 13.5,16 17,16",
       :stroke nil,
       :fill nil})
     (helix.dom/circle
      {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil}))))))


(helix.core/defnc
 group-remove
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M24,9v2h-6V9H24z M8,4C5.79,4,4,5.79,4,8s1.79,4,4,4s4-1.79,4-4S10.21,4,8,4z M8,13c-2.67,0-8,1.34-8,4v3h16v-3 C16,14.34,10.67,13,8,13z M12.51,4.05C13.43,5.11,14,6.49,14,8s-0.57,2.89-1.49,3.95C14.47,11.7,16,10.04,16,8S14.47,4.3,12.51,4.05 z M16.53,13.83C17.42,14.66,18,15.7,18,17v3h2v-3C20,15.55,18.41,14.49,16.53,13.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 person-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5.9c1.16 0 2.1.94 2.1 2.1s-.94 2.1-2.1 2.1S9.9 9.16 9.9 8s.94-2.1 2.1-2.1m0 9c2.97 0 6.1 1.46 6.1 2.1v1.1H5.9V17c0-.64 3.13-2.1 6.1-2.1M12 4C9.79 4 8 5.79 8 8s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 9c-2.67 0-8 1.34-8 4v3h16v-3c0-2.66-5.33-4-8-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 public-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M11,8.17L6.49,3.66C8.07,2.61,9.96,2,12,2c5.52,0,10,4.48,10,10c0,2.04-0.61,3.93-1.66,5.51l-1.46-1.46 C19.59,14.87,20,13.48,20,12c0-3.35-2.07-6.22-5-7.41V5c0,1.1-0.9,2-2,2h-2V8.17z M21.19,21.19l-1.41,1.41l-2.27-2.27 C15.93,21.39,14.04,22,12,22C6.48,22,2,17.52,2,12c0-2.04,0.61-3.93,1.66-5.51L1.39,4.22l1.41-1.41L21.19,21.19z M11,18 c-1.1,0-2-0.9-2-2v-1l-4.79-4.79C4.08,10.79,4,11.38,4,12c0,4.08,3.05,7.44,7,7.93V18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 plus-one
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 8H8v4H4v2h4v4h2v-4h4v-2h-4V8zm4.5-1.92V7.9l2.5-.5V18h2V5l-4.5 1.08z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tsunami
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.67,17.63c-3.8,2.8-6.12,0.4-6.67,0c-0.66,0.49-2.92,2.76-6.67,0C3.43,19.03,2.65,19,2,19v2c1.16,0,2.3-0.32,3.33-0.93 c2.06,1.22,4.61,1.22,6.67,0c2.06,1.22,4.61,1.22,6.67,0C19.7,20.68,20.84,21,22,21v-2C21.34,19,20.5,18.98,18.67,17.63z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.33,12H22v-2h-2.67C17.5,10,16,8.5,16,6.67c0-1.02,0.38-1.74,1.09-3.34C15.72,3.12,15.09,3,14,3 C7.36,3,2.15,8.03,2.01,14.5c0,0-0.01,2-0.01,2c1.16,0,2.3-0.32,3.33-0.93c2.06,1.22,4.61,1.22,6.67,0c2.06,1.22,4.61,1.22,6.67,0 c1.03,0.61,2.17,0.93,3.33,0.93v-2c-0.66,0-1.5-0.02-3.33-1.37c-3.8,2.8-6.12,0.4-6.67,0c-0.9,0.67-0.54,0.41-0.91,0.63 C10.39,12.82,10,11.7,10,10.5c0-2.58,1.77-4.74,4.21-5.33C14.08,5.68,14,6.19,14,6.67C14,9.61,16.39,12,19.33,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 person-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8.65,5.82C9.36,4.72,10.6,4,12,4c2.21,0,4,1.79,4,4c0,1.4-0.72,2.64-1.82,3.35L8.65,5.82z M20,17.17 c-0.02-1.1-0.63-2.11-1.61-2.62c-0.54-0.28-1.13-0.54-1.77-0.76L20,17.17z M21.19,21.19L2.81,2.81L1.39,4.22l8.89,8.89 c-1.81,0.23-3.39,0.79-4.67,1.45C4.61,15.07,4,16.1,4,17.22V20h13.17l2.61,2.61L21.19,21.19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sports-volleyball
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6,4.01C3.58,5.84,2,8.73,2,12c0,1.46,0.32,2.85,0.89,4.11L6,14.31V4.01z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M11,11.42V2.05C9.94,2.16,8.93,2.43,8,2.84v10.32L11,11.42z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,13.15l-8.11,4.68c0.61,0.84,1.34,1.59,2.18,2.2L15,14.89L12,13.15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13,7.96v3.46l8.11,4.68c0.42-0.93,0.7-1.93,0.82-2.98L13,7.96z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8.07,21.2C9.28,21.71,10.6,22,12,22c3.34,0,6.29-1.65,8.11-4.16L17,16.04L8.07,21.2z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M21.92,10.81c-0.55-4.63-4.26-8.3-8.92-8.76v3.6L21.92,10.81z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 domain-add
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,7V3H2v18h14v-2h-4v-2h2v-2h-2v-2h2v-2h-2V9h8v6h2V7H12z M6,19H4v-2h2V19z M6,15H4v-2h2V15z M6,11H4V9h2V11z M6,7H4V5h2 V7z M10,19H8v-2h2V19z M10,15H8v-2h2V15z M10,11H8V9h2V11z M10,7H8V5h2V7z M24,19v2h-2v2h-2v-2h-2v-2h2v-2h2v2H24z M18,11h-2v2h2 V11z M18,15h-2v2h2V15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 reduce-capacity
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M16,4c0-1.1,0.9-2,2-2s2,0.9,2,2s-0.9,2-2,2S16,5.1,16,4z M20.78,7.58C19.93,7.21,18.99,7,18,7c-0.67,0-1.31,0.1-1.92,0.28 C16.66,7.83,17,8.6,17,9.43V10h5V9.43C22,8.62,21.52,7.9,20.78,7.58z M6,6c1.1,0,2-0.9,2-2S7.1,2,6,2S4,2.9,4,4S4.9,6,6,6z M7.92,7.28C7.31,7.1,6.67,7,6,7C5.01,7,4.07,7.21,3.22,7.58C2.48,7.9,2,8.62,2,9.43V10h5V9.43C7,8.6,7.34,7.83,7.92,7.28z M10,4 c0-1.1,0.9-2,2-2s2,0.9,2,2s-0.9,2-2,2S10,5.1,10,4z M16,10H8V9.43C8,8.62,8.48,7.9,9.22,7.58C10.07,7.21,11.01,7,12,7 c0.99,0,1.93,0.21,2.78,0.58C15.52,7.9,16,8.62,16,9.43V10z M15,16c0-1.1,0.9-2,2-2s2,0.9,2,2s-0.9,2-2,2S15,17.1,15,16z M21,22h-8 v-0.57c0-0.81,0.48-1.53,1.22-1.85C15.07,19.21,16.01,19,17,19c0.99,0,1.93,0.21,2.78,0.58C20.52,19.9,21,20.62,21,21.43V22z M5,16 c0-1.1,0.9-2,2-2s2,0.9,2,2s-0.9,2-2,2S5,17.1,5,16z M11,22H3v-0.57c0-0.81,0.48-1.53,1.22-1.85C5.07,19.21,6.01,19,7,19 c0.99,0,1.93,0.21,2.78,0.58C10.52,19.9,11,20.62,11,21.43V22z M12.75,13v-2h-1.5v2H9l3,3l3-3H12.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 man-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "16,7 8,7 8,15 10.5,15 10.5,22 13.5,22 13.5,15 16,15",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 scale
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,11V8c4.56-0.58,8-3.1,8-6H2c0,2.9,3.44,5.42,8,6l0,3c-3.68,0.73-8,3.61-8,11h6v-2H4.13c0.93-6.83,6.65-7.2,7.87-7.2 s6.94,0.37,7.87,7.2H16v2h6C22,14.61,17.68,11.73,14,11z M12,22c-1.1,0-2-0.9-2-2c0-0.55,0.22-1.05,0.59-1.41 C11.39,17.79,16,16,16,16s-1.79,4.61-2.59,5.41C13.05,21.78,12.55,22,12,22z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 diversity-1
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "14", :cx "4", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M1.22,17.58C0.48,17.9,0,18.62,0,19.43V21l4.5,0v-1.61c0-0.83,0.23-1.61,0.63-2.29C4.76,17.04,4.39,17,4,17 C3.01,17,2.07,17.21,1.22,17.58z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "14", :cx "20", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M22.78,17.58C21.93,17.21,20.99,17,20,17c-0.39,0-0.76,0.04-1.13,0.1c0.4,0.68,0.63,1.46,0.63,2.29V21l4.5,0v-1.57 C24,18.62,23.52,17.9,22.78,17.58z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.24,16.65c-1.17-0.52-2.61-0.9-4.24-0.9c-1.63,0-3.07,0.39-4.24,0.9C6.68,17.13,6,18.21,6,19.39V21h12v-1.61 C18,18.21,17.32,17.13,16.24,16.65z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9,12c0,1.66,1.34,3,3,3s3-1.34,3-3c0-1.66-1.34-3-3-3S9,10.34,9,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.48,10.86C2.17,10.1,2,9.36,2,8.6C2,6.02,4.02,4,6.6,4c2.68,0,3.82,1.74,5.4,3.59C13.57,5.76,14.7,4,17.4,4 C19.98,4,22,6.02,22,8.6c0,0.76-0.17,1.5-0.48,2.26c0.65,0.31,1.18,0.82,1.53,1.44C23.65,11.1,24,9.88,24,8.6 C24,4.9,21.1,2,17.4,2c-2.09,0-4.09,0.97-5.4,2.51C10.69,2.97,8.69,2,6.6,2C2.9,2,0,4.9,0,8.6c0,1.28,0.35,2.5,0.96,3.7 C1.31,11.68,1.84,11.17,2.48,10.86z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _6-ft-apart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6,6c1.1,0,2-0.9,2-2S7.1,2,6,2S4,2.9,4,4S4.9,6,6,6z M10,9.43c0-0.81-0.48-1.53-1.22-1.85C7.93,7.21,6.99,7,6,7 C5.01,7,4.07,7.21,3.22,7.58C2.48,7.9,2,8.62,2,9.43V10h8V9.43z M18,6c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S16.9,6,18,6z M22,9.43 c0-0.81-0.48-1.53-1.22-1.85C19.93,7.21,18.99,7,18,7c-0.99,0-1.93,0.21-2.78,0.58C14.48,7.9,14,8.62,14,9.43V10h8V9.43z M19,17 v-2.01L5,15v2l-3-3l3-3v2.01L19,13v-2l3,3L19,17z M10,19v-1H7v4h3v-2.5H8V19H10z M9,20.5V21H8v-0.5H9z M17.5,19h-1v3h-1v-3h-1v-1h3 V19z M12.5,19v0.5h1v1h-1V22h-1v-4H14v1H12.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 man-4
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "7.96,7 10,22 14,22 16.04,7", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 group-add
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "22,9 22,7 20,7 20,9 18,9 18,11 20,11 20,13 22,13 22,11 24,11 24,9",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,12c2.21,0,4-1.79,4-4s-1.79-4-4-4S4,5.79,4,8S5.79,12,8,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M8,13c-2.67,0-8,1.34-8,4v3h16v-3C16,14.34,10.67,13,8,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12.51,4.05C13.43,5.11,14,6.49,14,8s-0.57,2.89-1.49,3.95C14.47,11.7,16,10.04,16,8S14.47,4.3,12.51,4.05z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.53,13.83C17.42,14.66,18,15.7,18,17v3h2v-3C20,15.55,18.41,14.49,16.53,13.83z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 man-3
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "16,7 8,7 8,15 10,15 10,22 14,22 14,15 16,15",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "2.41",
      :x "10.41",
      :width "3.18",
      :transform "matrix(0.7071 0.7071 -0.7071 0.7071 6.3431 -7.3137)",
      :height "3.18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 party-mode
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 4h-5.17L15 2H9L7.17 4H2v16h20V4zM12 7c1.63 0 3.06.79 3.98 2H12c-1.66 0-3 1.34-3 3 0 .35.07.69.18 1H7.1c-.06-.32-.1-.66-.1-1 0-2.76 2.24-5 5-5zm0 10c-1.63 0-3.06-.79-3.98-2H12c1.66 0 3-1.34 3-3 0-.35-.07-.69-.18-1h2.08c.07.32.1.66.1 1 0 2.76-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 boy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,7.5c0.97,0,1.75-0.78,1.75-1.75S12.97,4,12,4s-1.75,0.78-1.75,1.75S11.03,7.5,12,7.5z M14,20v-5h1v-4.5 c0-1.1-0.9-2-2-2h-2c-1.1,0-2,0.9-2,2V15h1v5H14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 catching-pokemon
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M14.5,12c0,1.38-1.12,2.5-2.5,2.5c-1.38,0-2.5-1.12-2.5-2.5s1.12-2.5,2.5-2.5C13.38,9.5,14.5,10.62,14.5,12z M22,12 c0,5.52-4.48,10-10,10C6.48,22,2,17.52,2,12S6.48,2,12,2C17.52,2,22,6.48,22,12z M20,12h-4c0-2.21-1.79-4-4-4c-2.21,0-4,1.79-4,4H4 c0,4.41,3.59,8,8,8C16.41,20,20,16.41,20,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 emoji-events
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,5h-2V3H7v2H5C3.9,5,3,5.9,3,7v1c0,2.55,1.92,4.63,4.39,4.94c0.63,1.5,1.98,2.63,3.61,2.96V19H7v2h10v-2h-4v-3.1 c1.63-0.33,2.98-1.46,3.61-2.96C19.08,12.63,21,10.55,21,8V7C21,5.9,20.1,5,19,5z M5,8V7h2v3.82C5.84,10.4,5,9.3,5,8z M19,8 c0,1.3-0.84,2.4-2,2.82V7h2V8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 real-estate-agent
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M1,22h4V11H1V22z M14,1.5l-7,5V9h2l10,4v2h2V6.5L14,1.5z M13.5,10h-1V9h1V10z M13.5,8h-1V7h1V8z M15.5,10h-1V9h1V10z M15.5,8h-1V7h1V8z M22,19l-8,3l-7-1.98V11h1.97L17,14l0,2h-4l-1.76-0.68l-0.33,0.94L13,17h9V19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 waving-hand
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M23,17c0,3.31-2.69,6-6,6v-1.5c2.48,0,4.5-2.02,4.5-4.5H23z M1,7c0-3.31,2.69-6,6-6v1.5C4.52,2.5,2.5,4.52,2.5,7H1z M8.9,3.43L3.42,8.91c-3.22,3.22-3.22,8.44,0,11.67s8.44,3.22,11.67,0l7.95-7.95l-1.77-1.77l-5.3,5.3l-0.71-0.71l7.42-7.42 l-1.77-1.77l-6.72,6.72l-0.71-0.71l7.78-7.78L19.5,2.73l-7.78,7.78L11.02,9.8l6.36-6.36l-1.77-1.77l-8.51,8.51 c1.22,1.57,1.11,3.84-0.33,5.28l-0.71-0.71c1.17-1.17,1.17-3.08,0-4.24l-0.35-0.35l4.95-4.95L8.9,3.43z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-adult-content
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M4,12c0-1.85,0.63-3.54,1.69-4.9L7.59,9h2.83 L7.1,5.69C8.46,4.63,10.15,4,12,4c4.41,0,8,3.59,8,8c0,1.85-0.63,3.54-1.69,4.9l-1.9-1.9h-2.83l3.31,3.31 C15.54,19.37,13.85,20,12,20C7.59,20,4,16.41,4,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.25,14 12.75,12 14.25,10 12.75,10 12,11 11.25,10 9.75,10 11.25,12 9.75,14 11.25,14 12,13 12.75,14",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8,10 7.25,11 6.5,10 5,10 6.5,12 5,14 6.5,14 7.25,13 8,14 9.5,14 8,12 9.5,10",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "16,14 16.75,13 17.5,14 19,14 17.5,12 19,10 17.5,10 16.75,11 16,10 14.5,10 16,12 14.5,14",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 assist-walker
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "4.5", :cx "12.5", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M19.77,17.72L19,10h-3c-1.5-0.02-2.86-0.54-3.76-1.44l-2-1.98C10.08,6.42,9.62,6,8.83,6C8.32,6,7.81,6.2,7.42,6.59 l-4.2,4.17l2.08,4.07l-3.15,4.05l1.57,1.24l3.68-4.73l-0.17-1.36L8,14.75V20h2v-6.12l-2.12-2.12l2.36-2.36 c0.94,0.94,1.72,1.82,3.59,2.32L13,20h1.5l0.41-3.5h3.18l0.14,1.22c-0.44,0.26-0.73,0.74-0.73,1.28c0,0.83,0.67,1.5,1.5,1.5 s1.5-0.67,1.5-1.5C20.5,18.46,20.21,17.98,19.77,17.72z M15.09,15l0.41-3.5h2l0.41,3.5H15.09z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 recommend
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M18,12.05L15.46,18H7l0-7.56L12,5l1,1l0,0.53 L12.41,10H18V12.05z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 emoji-symbols
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "2", :x "3", :width "8", :height "2", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points "6,11 8,11 8,7 11,7 11,5 3,5 3,7 6,7",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "16",
      :x "11.5",
      :width "11",
      :transform
      "matrix(0.7071 -0.7071 0.7071 0.7071 -7.0416 16.9999)",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "14.5", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "19.5", :cx "19.5", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M15.5,11c1.38,0,2.5-1.12,2.5-2.5V4h3V2h-4v4.51C16.58,6.19,16.07,6,15.5,6C14.12,6,13,7.12,13,8.5 C13,9.88,14.12,11,15.5,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.74,15.96l-1.41,1.41l-0.71-0.71l0.35-0.35c0.98-0.98,0.98-2.56,0-3.54c-0.49-0.49-1.13-0.73-1.77-0.73 c-0.64,0-1.28,0.24-1.77,0.73c-0.98,0.98-0.98,2.56,0,3.54l0.35,0.35l-1.06,1.06c-0.98,0.98-0.98,2.56,0,3.54 C4.22,21.76,4.86,22,5.5,22s1.28-0.24,1.77-0.73l1.06-1.06l1.41,1.41l1.41-1.41l-1.41-1.41l1.41-1.41L9.74,15.96z M5.85,14.2 c0.12-0.12,0.26-0.15,0.35-0.15s0.23,0.03,0.35,0.15c0.19,0.2,0.19,0.51,0,0.71l-0.35,0.35L5.85,14.9 C5.66,14.71,5.66,14.39,5.85,14.2z M5.85,19.85C5.73,19.97,5.59,20,5.5,20s-0.23-0.03-0.35-0.15c-0.19-0.19-0.19-0.51,0-0.71 l1.06-1.06l0.71,0.71L5.85,19.85z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 notifications-paused
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 22c1.1 0 2-.9 2-2h-4c0 1.1.89 2 2 2zm6-6v-5c0-3.07-1.64-5.64-4.5-6.32V2.5h-3v2.18C7.63 5.36 6 7.93 6 11v5l-2 2v1h16v-1l-2-2zm-3.5-6.2l-2.8 3.4h2.8V15h-5v-1.8l2.8-3.4H9.5V8h5v1.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 group
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5s-3 1.34-3 3 1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 face-3
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M22.91,11.96c-0.54-5.93-5.75-10.41-11.8-9.92C5.73,2.46,1.55,6.94,1.06,12.32L0,24h24c0,0,0,0,0,0L22.91,11.96z M4.54,9.13C5.41,9.68,6.43,10,7.5,10C9.36,10,11,9.07,12,7.65C13,9.07,14.64,10,16.5,10c1.07,0,2.09-0.32,2.96-0.87 C19.8,10.02,20,10.99,20,12c0,4.41-3.59,8-8,8s-8-3.59-8-8C4,10.99,4.2,10.02,4.54,9.13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 groups-3
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16.24,13.65c-1.17-0.52-2.61-0.9-4.24-0.9c-1.63,0-3.07,0.39-4.24,0.9C6.68,14.13,6,15.21,6,16.39V18h12v-1.61 C18,15.21,17.32,14.13,16.24,13.65z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1.22,14.58C0.48,14.9,0,15.62,0,16.43V18l4.5,0v-1.61c0-0.83,0.23-1.61,0.63-2.29C4.76,14.04,4.39,14,4,14 C3.01,14,2.07,14.21,1.22,14.58z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.78,14.58C21.93,14.21,20.99,14,20,14c-0.39,0-0.76,0.04-1.13,0.1c0.4,0.68,0.63,1.46,0.63,2.29V18l4.5,0v-1.57 C24,15.62,23.52,14.9,22.78,14.58z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,12c1.66,0,3-1.34,3-3c0-1.66-1.34-3-3-3S9,7.34,9,9C9,10.66,10.34,12,12,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9.23",
      :x "2.23",
      :width "3.54",
      :transform "matrix(0.7071 -0.7071 0.7071 0.7071 -6.6066 6.0503)",
      :height "3.54",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "20,9 17.5,13 22.5,13", :stroke nil, :fill nil})))))


(helix.core/defnc
 face-4
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2c-0.96,0-1.88,0.14-2.75,0.39C8.37,0.96,6.8,0,5,0C2.24,0,0,2.24,0,5c0,1.8,0.96,3.37,2.39,4.25 C2.14,10.12,2,11.04,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-4.41,0-8-3.59-8-8c0-0.05,0.01-0.1,0.01-0.15 c2.6-0.98,4.68-2.99,5.74-5.55C11.58,8.56,14.37,10,17.5,10c0.75,0,1.47-0.09,2.17-0.24C19.88,10.47,20,11.22,20,12 C20,16.41,16.41,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "15", :stroke nil, :fill nil})))))


(helix.core/defnc
 person
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 skateboarding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M13,3c0-1.1,0.9-2,2-2s2,0.9,2,2c0,1.1-0.9,2-2,2S13,4.1,13,3z M7.25,22.5c-0.41,0-0.75,0.34-0.75,0.75S6.84,24,7.25,24 S8,23.66,8,23.25S7.66,22.5,7.25,22.5z M15.75,22.5c-0.41,0-0.75,0.34-0.75,0.75S15.34,24,15.75,24s0.75-0.34,0.75-0.75 S16.16,22.5,15.75,22.5z M19.24,19c-0.24,0-0.45,0.11-0.59,0.3c-0.55,0.73-1.42,1.2-2.4,1.2H16v-6l-4.32-2.67l1.8-2.89 C14.63,10.78,16.68,12,19,12v-2c-1.85,0-3.44-1.12-4.13-2.72l-0.52-1.21C14.16,5.64,13.61,5,12.7,5H7L4.5,9l1.7,1.06L8.1,7h2.35 l-2.89,4.63l1.62,5.03l-3.12,3.76c-0.7-0.16-1.3-0.57-1.71-1.12C4.21,19.11,3.99,19,3.75,19C3.31,19,3,19.36,3,19.75 c0,0.15,0.05,0.31,0.15,0.45c0.82,1.1,2.13,1.8,3.6,1.8h9.5c1.47,0,2.78-0.7,3.6-1.8c0.1-0.14,0.15-0.3,0.15-0.45 C20,19.36,19.68,19,19.24,19z M14,20.5H8.6l2.9-3.5l-1-3.3l3.5,2.2V20.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sports-golf
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,16c3.87,0,7-3.13,7-7c0-3.87-3.13-7-7-7S5,5.13,5,9C5,12.87,8.13,16,12,16z M12,4c2.76,0,5,2.24,5,5s-2.24,5-5,5 s-5-2.24-5-5S9.24,4,12,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "8", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "8", :cx "14", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "6", :cx "12", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M7,19h2c1.1,0,2,0.9,2,2v1h2v-1c0-1.1,0.9-2,2-2h2v-2H7V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 person-remove-alt-1
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,8c0-2.21-1.79-4-4-4S6,5.79,6,8s1.79,4,4,4S14,10.21,14,8z M17,10v2h6v-2H17z M2,18v2h16v-2c0-2.66-5.33-4-8-4 S2,15.34,2,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 flood
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.67,19c-1.95,0-2.09,1-3.33,1c-1.19,0-1.42-1-3.33-1c-1.95,0-2.1,1-3.34,1c-1.24,0-1.38-1-3.33-1c-1.95,0-2.1,1-3.34,1 v2c1.95,0,2.11-1,3.34-1c1.24,0,1.38,1,3.33,1c1.95,0,2.1-1,3.34-1c1.22,0,1.4,1,3.33,1c1.93,0,2.1-1,3.33-1c1.22,0,1.4,1,3.33,1 v-2C20.76,20,20.62,19,18.67,19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8.68,17.5c1.95,0,2.09-1,3.33-1c1.19,0,1.42,1,3.33,1c1.95,0,2.09-1,3.33-1c1.19,0,1.4,0.98,3.31,1v-2 c-0.63,0-1-0.28-1.48-0.55l-2.02-7.53l2.09,0.85l0.74-1.86L9.78,2L2,11.61l1.57,1.23l1.39-1.78l0.93,3.48 c-0.18-0.02-0.35-0.05-0.56-0.05c-1.95,0-2.09,1-3.33,1v2c1.9,0,2.17-1,3.35-1C6.54,16.5,6.77,17.5,8.68,17.5z M14.04,10.18 l1.42,5.31c-1.34,0.09-1.47-0.99-3.47-0.99c-0.36,0-0.65,0.04-0.91,0.1l-0.91-3.39L14.04,10.18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 safety-divider
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M11,5h2v14h-2V5z M5,12c1.1,0,2-0.9,2-2c0-1.1-0.9-2-2-2s-2,0.9-2,2C3,11.1,3.9,12,5,12z M7.78,13.58 C6.93,13.21,5.99,13,5,13s-1.93,0.21-2.78,0.58C1.48,13.9,1,14.62,1,15.43L1,16h8l0-0.57C9,14.62,8.52,13.9,7.78,13.58z M19,12 c1.1,0,2-0.9,2-2c0-1.1-0.9-2-2-2s-2,0.9-2,2C17,11.1,17.9,12,19,12z M21.78,13.58C20.93,13.21,19.99,13,19,13s-1.93,0.21-2.78,0.58 C15.48,13.9,15,14.62,15,15.43L15,16h8l0-0.57C23,14.62,22.52,13.9,21.78,13.58z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 emoji-people
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M15.89,8.11C15.5,7.72,14.83,7,13.53,7c-0.21,0-1.42,0-2.54,0C8.24,6.99,6,4.75,6,2H4c0,3.16,2.11,5.84,5,6.71V22h2v-6h2 v6h2V10.05L18.95,14l1.41-1.41L15.89,8.11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-reaction
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18,9V7h-2V2.84C14.77,2.3,13.42,2,11.99,2C6.47,2,2,6.48,2,12s4.47,10,9.99,10C17.52,22,22,17.52,22,12 c0-1.05-0.17-2.05-0.47-3H18z M15.5,8C16.33,8,17,8.67,17,9.5S16.33,11,15.5,11S14,10.33,14,9.5S14.67,8,15.5,8z M8.5,8 C9.33,8,10,8.67,10,9.5S9.33,11,8.5,11S7,10.33,7,9.5S7.67,8,8.5,8z M12,17.5c-2.33,0-4.31-1.46-5.11-3.5h10.22 C16.31,16.04,14.33,17.5,12,17.5z M22,3h2v2h-2v2h-2V5h-2V3h2V1h2V3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 handshake
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10.59,5.95l-7.05,7.04L0.7,10.3l8.55-8.55l7.95,7.95l-1.42,1.42L10.59,5.95z M23.24,10.24l-8.49-8.49l-2.06,2.06l5.9,5.88 l-2.83,2.83l-5.17-5.17l-6.27,6.27l1.42,1.41l5.32-5.32l0.71,0.71l-5.32,5.32l1.42,1.41l5.32-5.32l0.71,0.71l-5.32,5.32l1.41,1.41 l5.32-5.32l0.71,0.71L10.68,20l1.41,1.41L23.24,10.24z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 groups-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10.27,12h3.46c0.93,0,1.63-0.83,1.48-1.75l-0.3-1.79C14.67,7.04,13.44,6,12,6S9.33,7.04,9.09,8.47l-0.3,1.79 C8.64,11.17,9.34,12,10.27,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1.66,11.11c-0.13,0.26-0.18,0.57-0.1,0.88c0.16,0.69,0.76,1.03,1.53,1c0,0,1.49,0,1.95,0c0.83,0,1.51-0.58,1.51-1.29 c0-0.14-0.03-0.27-0.07-0.4c-0.01-0.03-0.01-0.05,0.01-0.08c0.09-0.16,0.14-0.34,0.14-0.53c0-0.31-0.14-0.6-0.36-0.82 c-0.03-0.03-0.03-0.06-0.02-0.1c0.07-0.2,0.07-0.43,0.01-0.65C6.1,8.69,5.71,8.4,5.27,8.38c-0.03,0-0.05-0.01-0.07-0.03 C5.03,8.14,4.72,8,4.37,8C4.07,8,3.8,8.1,3.62,8.26C3.59,8.29,3.56,8.29,3.53,8.28c-0.14-0.06-0.3-0.09-0.46-0.09 c-0.65,0-1.18,0.49-1.24,1.12c0,0.02-0.01,0.04-0.03,0.06c-0.29,0.26-0.46,0.65-0.41,1.05c0.03,0.22,0.12,0.43,0.25,0.6 C1.67,11.04,1.67,11.08,1.66,11.11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.24,13.65c-1.17-0.52-2.61-0.9-4.24-0.9c-1.63,0-3.07,0.39-4.24,0.9C6.68,14.13,6,15.21,6,16.39V18h12v-1.61 C18,15.21,17.32,14.13,16.24,13.65z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1.22,14.58C0.48,14.9,0,15.62,0,16.43V18l4.5,0v-1.61c0-0.83,0.23-1.61,0.63-2.29C4.76,14.04,4.39,14,4,14 C3.01,14,2.07,14.21,1.22,14.58z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.78,14.58C21.93,14.21,20.99,14,20,14c-0.39,0-0.76,0.04-1.13,0.1c0.4,0.68,0.63,1.46,0.63,2.29V18l4.5,0v-1.57 C24,15.62,23.52,14.9,22.78,14.58z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,11v-0.5c0-1.1-0.9-2-2-2h-2c-0.42,0-0.65,0.48-0.39,0.81l0.7,0.63C18.12,10.25,18,10.61,18,11c0,1.1,0.9,2,2,2 S22,12.1,22,11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sports-martial-arts
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "19.8,2 11.6,8.7 10.39,7.66 13.99,5.58 9.41,1 8,2.41 10.74,5.15 5,8.46 3.81,12.75 6.27,17 8,16 5.97,12.48 6.32,11.18 9.5,13 10,22 12,22 12.5,12 21,3.4",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "5", :cx "5", :stroke nil, :fill nil})))))


(helix.core/defnc
 face-5
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-4.41,0-8-3.59-8-8 c0-1.12,0.23-2.18,0.65-3.15C4.74,8.94,4.86,9,5,9c0.28,0,0.5-0.22,0.5-0.5c0-0.25-0.19-0.45-0.43-0.49 c0.15-0.26,0.32-0.51,0.49-0.75C5.53,7.34,5.5,7.41,5.5,7.5C5.5,7.78,5.72,8,6,8s0.5-0.22,0.5-0.5C6.5,7.22,6.28,7,6,7 C5.87,7,5.75,7.05,5.66,7.13c0.52-0.68,1.15-1.28,1.86-1.76C7.51,5.41,7.5,5.45,7.5,5.5C7.5,5.78,7.72,6,8,6s0.5-0.22,0.5-0.5 c0-0.24-0.17-0.43-0.4-0.48c0.16-0.09,0.32-0.17,0.49-0.25C8.68,4.91,8.83,5,9,5c0.28,0,0.5-0.22,0.5-0.5 c0-0.03-0.01-0.06-0.02-0.09c0.39-0.13,0.79-0.23,1.21-0.3C10.58,4.21,10.5,4.34,10.5,4.5C10.5,4.78,10.72,5,11,5 s0.5-0.22,0.5-0.5c0-0.21-0.13-0.38-0.3-0.46C11.46,4.01,11.73,4,12,4s0.54,0.01,0.8,0.04c-0.18,0.08-0.3,0.25-0.3,0.46 C12.5,4.78,12.72,5,13,5s0.5-0.22,0.5-0.5c0-0.16-0.08-0.29-0.19-0.38c0.41,0.07,0.82,0.17,1.21,0.3 C14.51,4.44,14.5,4.47,14.5,4.5C14.5,4.78,14.72,5,15,5c0.17,0,0.32-0.09,0.41-0.23c0.17,0.08,0.33,0.16,0.49,0.25 c-0.23,0.05-0.4,0.24-0.4,0.48C15.5,5.78,15.72,6,16,6s0.5-0.22,0.5-0.5c0-0.05-0.01-0.09-0.03-0.13 c0.71,0.48,1.34,1.08,1.86,1.76C18.25,7.05,18.13,7,18,7c-0.28,0-0.5,0.22-0.5,0.5C17.5,7.78,17.72,8,18,8s0.5-0.22,0.5-0.5 c0-0.09-0.03-0.16-0.07-0.23c0.18,0.24,0.34,0.49,0.49,0.75C18.69,8.05,18.5,8.25,18.5,8.5C18.5,8.78,18.72,9,19,9 c0.14,0,0.26-0.06,0.35-0.15C19.77,9.82,20,10.88,20,12C20,16.41,16.41,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "5.5", :cx "12", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "5.5", :cx "14", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "5.5", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "6.5", :cx "17", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "6.5", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "6.5", :cx "7", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "6.5", :cx "11", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "6.5", :cx "13", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "6.5", :cx "15", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "7.5", :cx "12", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "7.5", :cx "14", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "7.5", :cx "16", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "7.5", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "7.5", :cx "8", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "8.5", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "8.5", :cx "7", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "8.5", :cx "11", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "8.5", :cx "13", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "8.5", :cx "15", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "8.5", :cx "17", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "15", :stroke nil, :fill nil})))))


(helix.core/defnc
 group-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15,8c0-1.42-0.5-2.73-1.33-3.76C14.09,4.1,14.53,4,15,4c2.21,0,4,1.79,4,4s-1.79,4-4,4c-0.06,0-0.12,0-0.18,0l-0.77-0.77 C14.65,10.29,15,9.18,15,8z M22.83,20H23v-3c0-2.18-3.58-3.47-6.34-3.87c1.1,0.75,1.95,1.71,2.23,2.94L22.83,20z M7.24,4.41 C7.77,4.15,8.37,4,9,4c2.21,0,4,1.79,4,4c0,0.63-0.15,1.23-0.41,1.76L7.24,4.41z M9.17,12C9.11,12,9.06,12,9,12c-2.21,0-4-1.79-4-4 c0-0.06,0-0.11,0-0.17L0.69,3.51L2.1,2.1l19.8,19.8l-1.41,1.41L17,19.83V20H1v-3c0-2.66,5.33-4,8-4c0.37,0,0.8,0.03,1.25,0.08 L9.17,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 face-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.97,13.52c0-0.01,0-0.02,0-0.04C23.21,12.38,24,10.78,24,9c0-3.31-2.69-6-6-6c-0.26,0-0.52,0.02-0.78,0.06 C16.19,1.23,14.24,0,12,0S7.81,1.23,6.78,3.06C6.52,3.02,6.26,3,6,3C2.69,3,0,5.69,0,9c0,1.78,0.79,3.38,2.02,4.48 c0,0.01,0,0.02,0,0.04C0.79,14.62,0,16.22,0,18c0,3.31,2.69,6,6,6c1.39,0,2.67-0.48,3.69-1.28C10.43,22.9,11.2,23,12,23 s1.57-0.1,2.31-0.28C15.33,23.52,16.61,24,18,24c3.31,0,6-2.69,6-6C24,16.22,23.21,14.62,21.97,13.52z M12,21c-4.41,0-8-3.59-8-8 c0-3.72,2.56-6.85,6-7.74c0,0.02,0,0.03,0,0.05c0,3.34,2.72,6.06,6.06,6.06c1.26,0,2.45-0.39,3.45-1.09 C19.82,11.14,20,12.05,20,13C20,17.41,16.41,21,12,21z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "14", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "14", :cx "15", :stroke nil, :fill nil})))))


(helix.core/defnc
 psychology
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13,8.57c-0.79,0-1.43,0.64-1.43,1.43s0.64,1.43,1.43,1.43s1.43-0.64,1.43-1.43S13.79,8.57,13,8.57z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13,3C9.25,3,6.2,5.94,6.02,9.64L4.1,12.2C3.85,12.53,4.09,13,4.5,13H6v3c0,1.1,0.9,2,2,2h1v3h7v-4.68 c2.36-1.12,4-3.53,4-6.32C20,6.13,16.87,3,13,3z M16,10c0,0.13-0.01,0.26-0.02,0.39l0.83,0.66c0.08,0.06,0.1,0.16,0.05,0.25 l-0.8,1.39c-0.05,0.09-0.16,0.12-0.24,0.09l-0.99-0.4c-0.21,0.16-0.43,0.29-0.67,0.39L14,13.83c-0.01,0.1-0.1,0.17-0.2,0.17h-1.6 c-0.1,0-0.18-0.07-0.2-0.17l-0.15-1.06c-0.25-0.1-0.47-0.23-0.68-0.39l-0.99,0.4c-0.09,0.03-0.2,0-0.25-0.09l-0.8-1.39 c-0.05-0.08-0.03-0.19,0.05-0.25l0.84-0.66C10.01,10.26,10,10.13,10,10c0-0.13,0.02-0.27,0.04-0.39L9.19,8.95 c-0.08-0.06-0.1-0.16-0.05-0.26l0.8-1.38c0.05-0.09,0.15-0.12,0.24-0.09l1,0.4c0.2-0.15,0.43-0.29,0.67-0.39l0.15-1.06 C12.02,6.07,12.1,6,12.2,6h1.6c0.1,0,0.18,0.07,0.2,0.17l0.15,1.06c0.24,0.1,0.46,0.23,0.67,0.39l1-0.4c0.09-0.03,0.2,0,0.24,0.09 l0.8,1.38c0.05,0.09,0.03,0.2-0.05,0.26l-0.85,0.66C15.99,9.73,16,9.86,16,10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 elderly
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M13.5,5.5c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S12.4,5.5,13.5,5.5z M20,12.5V23h-1V12.5c0-0.28-0.22-0.5-0.5-0.5 S18,12.22,18,12.5v1h-1v-0.69c-1.46-0.38-2.7-1.29-3.51-2.52C13.18,11.16,13,12.07,13,13c0,0.23,0.02,0.46,0.03,0.69L15,16.5V23h-2 v-5l-1.78-2.54L11,19l-3,4l-1.6-1.2L9,18.33V13c0-1.15,0.18-2.29,0.5-3.39L8,10.46V14H6V9.3l5.4-3.07l0,0.01 c0.59-0.31,1.32-0.33,1.94,0.03c0.36,0.21,0.63,0.51,0.8,0.85l0,0l0.79,1.67C15.58,10.1,16.94,11,18.5,11C19.33,11,20,11.67,20,12.5 z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 science
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.8,18.4L14,10.67V6.5l1.35-1.69C15.61,4.48,15.38,4,14.96,4H9.04C8.62,4,8.39,4.48,8.65,4.81L10,6.5v4.17L4.2,18.4 C3.71,19.06,4.18,20,5,20h14C19.82,20,20.29,19.06,19.8,18.4z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sanitizer
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15.5,6.5C15.5,5.66,17,4,17,4s1.5,1.66,1.5,2.5C18.5,7.33,17.83,8,17,8S15.5,7.33,15.5,6.5z M19.5,15 c1.38,0,2.5-1.12,2.5-2.5c0-1.67-2.5-4.5-2.5-4.5S17,10.83,17,12.5C17,13.88,18.12,15,19.5,15z M13,14h-2v-2H9v2H7v2h2v2h2v-2h2V14z M16,12v10H4V12c0-2.97,2.16-5.43,5-5.91V4H7V2h6c1.13,0,2.15,0.39,2.99,1.01l-1.43,1.43C14.1,4.17,13.57,4,13,4h-2v2.09 C13.84,6.57,16,9.03,16,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 single-bed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,10V5H6v5H4v7h1.33L6,19h1l0.67-2h8.67L17,19h1l0.67-2H20v-7H18z M11,10H8V7h3V10z M16,10h-3V7h3V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fitbit
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19.89,13.89c1.04,0,1.89-0.85,1.89-1.89s-0.85-1.89-1.89-1.89C18.85,10.11,18,10.96,18,12S18.85,13.89,19.89,13.89z M15.65,13.68c0.93,0,1.68-0.75,1.68-1.68s-0.75-1.68-1.68-1.68c-0.93,0-1.68,0.75-1.68,1.68S14.72,13.68,15.65,13.68z M15.65,9.42 c0.93,0,1.68-0.75,1.68-1.68c0-0.93-0.75-1.68-1.68-1.68c-0.93,0-1.68,0.75-1.68,1.68C13.97,8.67,14.72,9.42,15.65,9.42z M15.65,17.93c0.93,0,1.68-0.75,1.68-1.68c0-0.93-0.75-1.68-1.68-1.68c-0.93,0-1.68,0.75-1.68,1.68 C13.97,17.17,14.72,17.93,15.65,17.93z M11.41,13.47c0.81,0,1.47-0.66,1.47-1.47s-0.66-1.47-1.47-1.47c-0.81,0-1.47,0.66-1.47,1.47 S10.59,13.47,11.41,13.47z M11.41,9.21c0.81,0,1.47-0.66,1.47-1.47s-0.66-1.47-1.47-1.47c-0.81,0-1.47,0.66-1.47,1.47 S10.59,9.21,11.41,9.21z M11.41,17.73c0.81,0,1.47-0.66,1.47-1.47c0-0.81-0.66-1.47-1.47-1.47c-0.81,0-1.47,0.66-1.47,1.47 C9.93,17.07,10.59,17.73,11.41,17.73z M11.41,22c0.81,0,1.47-0.66,1.47-1.47c0-0.81-0.66-1.47-1.47-1.47 c-0.81,0-1.47,0.66-1.47,1.47C9.93,21.34,10.59,22,11.41,22z M11.41,4.94c0.81,0,1.47-0.66,1.47-1.47S12.22,2,11.41,2 c-0.81,0-1.47,0.66-1.47,1.47S10.59,4.94,11.41,4.94z M7.16,13.26c0.7,0,1.26-0.57,1.26-1.26s-0.57-1.26-1.26-1.26 c-0.7,0-1.26,0.57-1.26,1.26S6.46,13.26,7.16,13.26z M7.16,17.51c0.7,0,1.26-0.57,1.26-1.26c0-0.7-0.57-1.26-1.26-1.26 c-0.7,0-1.26,0.57-1.26,1.26C5.9,16.94,6.46,17.51,7.16,17.51z M7.16,9.02c0.7,0,1.26-0.57,1.26-1.26c0-0.7-0.57-1.26-1.26-1.26 c-0.7,0-1.26,0.57-1.26,1.26C5.9,8.45,6.46,9.02,7.16,9.02z M3.29,13.05c0.58,0,1.05-0.47,1.05-1.05s-0.47-1.05-1.05-1.05 c-0.58,0-1.05,0.47-1.05,1.05S2.71,13.05,3.29,13.05z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 back-hand
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M2.21,10.47L5,9.36L7.25,15H8V2h2.5v10h1V0H14v12h1V1.5h2.5V12h1V4.5H21V16c0,4.42-3.58,8-8,8c-3.26,0-6.19-1.99-7.4-5.02 L2.21,10.47z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 whatshot
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.5.67s.74 2.65.74 4.8c0 2.06-1.35 3.73-3.41 3.73-2.07 0-3.63-1.67-3.63-3.73l.03-.36C5.21 7.51 4 10.62 4 14c0 4.42 3.58 8 8 8s8-3.58 8-8C20 8.61 17.41 3.8 13.5.67zM11.71 19c-1.78 0-3.22-1.4-3.22-3.14 0-1.62 1.05-2.76 2.81-3.12 1.77-.36 3.6-1.21 4.62-2.58.39 1.29.59 2.65.59 4.04 0 2.65-2.15 4.8-4.8 4.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 self-improvement
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "6", :cx "12", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M21,16v-2c-2.24,0-4.16-0.96-5.6-2.68l-1.34-1.6C13.68,9.26,13.12,9,12.53,9h-1.05c-0.59,0-1.15,0.26-1.53,0.72l-1.34,1.6 C7.16,13.04,5.24,14,3,14v2c2.77,0,5.19-1.17,7-3.25V15l-3.88,1.55C5.45,16.82,5,17.48,5,18.21C5,19.2,5.8,20,6.79,20H9v-0.5 c0-1.38,1.12-2.5,2.5-2.5h3c0.28,0,0.5,0.22,0.5,0.5S14.78,18,14.5,18h-3c-0.83,0-1.5,0.67-1.5,1.5V20h7.21 C18.2,20,19,19.2,19,18.21c0-0.73-0.45-1.39-1.12-1.66L14,15v-2.25C15.81,14.83,18.23,16,21,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 piano-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21.19,21.19L2.81,2.81L1.39,4.22L3,5.83V21h15.17l1.61,1.61L21.19,21.19z M8.25,19H5V7.83l2,2v4.67h1.25V19z M9.75,19v-4.5 H11v-0.67l3.25,3.25V19H9.75z M5.83,3H21v15.17l-2-2V5h-2v9.17l-4-4V5h-2v3.17L5.83,3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sentiment-very-dissatisfied
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 13.5c-2.33 0-4.31 1.46-5.11 3.5h10.22c-.8-2.04-2.78-3.5-5.11-3.5zM7.82 12l1.06-1.06L9.94 12 11 10.94 9.94 9.88 11 8.82 9.94 7.76 8.88 8.82 7.82 7.76 6.76 8.82l1.06 1.06-1.06 1.06zm4.17-10C6.47 2 2 6.47 2 12s4.47 10 9.99 10S22 17.53 22 12 17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm4.18-12.24l-1.06 1.06-1.06-1.06L13 8.82l1.06 1.06L13 10.94 14.06 12l1.06-1.06L16.18 12l1.06-1.06-1.06-1.06 1.06-1.06z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 roller-skating
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,16l-0.01-6l-5.71-1.43C13.4,8.35,12.7,7.76,12.32,7H9V6h3.02L12,5H9V4h3V1H4v15H20z M5,23c-1.66,0-3-1.34-3-3 s1.34-3,3-3s3,1.34,3,3S6.66,23,5,23z M19,23c-1.66,0-3-1.34-3-3s1.34-3,3-3s3,1.34,3,3S20.66,23,19,23z M12,23 c-1.66,0-3-1.34-3-3s1.34-3,3-3s3,1.34,3,3S13.66,23,12,23z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 scuba-diving
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M1,13c0-1.1,0.9-2,2-2s2,0.9,2,2s-0.9,2-2,2S1,14.1,1,13z M8.89,10.11l4.53-1.21L12.64,6L8.11,7.21 c-0.8,0.21-1.28,1.04-1.06,1.84l0,0C7.27,9.85,8.09,10.33,8.89,10.11z M20.5,5.9L23,3l-1-1l-3,3l-2,4l-9.48,2.87 c-0.82,0.2-1.39,0.89-1.5,1.68L5.24,18L2.4,21.8L4,23l3-4l1.14-3.14L14,14l5-3.5L20.5,5.9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 groups
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,12.75c1.63,0,3.07,0.39,4.24,0.9c1.08,0.48,1.76,1.56,1.76,2.73L18,18H6l0-1.61c0-1.18,0.68-2.26,1.76-2.73 C8.93,13.14,10.37,12.75,12,12.75z M4,13c1.1,0,2-0.9,2-2c0-1.1-0.9-2-2-2s-2,0.9-2,2C2,12.1,2.9,13,4,13z M5.13,14.1 C4.76,14.04,4.39,14,4,14c-0.99,0-1.93,0.21-2.78,0.58C0.48,14.9,0,15.62,0,16.43V18l4.5,0v-1.61C4.5,15.56,4.73,14.78,5.13,14.1z M20,13c1.1,0,2-0.9,2-2c0-1.1-0.9-2-2-2s-2,0.9-2,2C18,12.1,18.9,13,20,13z M24,16.43c0-0.81-0.48-1.53-1.22-1.85 C21.93,14.21,20.99,14,20,14c-0.39,0-0.76,0.04-1.13,0.1c0.4,0.68,0.63,1.46,0.63,2.29V18l4.5,0V16.43z M12,6c1.66,0,3,1.34,3,3 c0,1.66-1.34,3-3,3s-3-1.34-3-3C9,7.34,10.34,6,12,6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _18-up-rating
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "12.5",
      :x "13",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "13",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,3H3v18h18V3z M10,15H8.5v-4.5H7V9h3V15z M16,14c0,0.55-0.45,1-1,1h-2.5c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1H15 c0.55,0,1,0.45,1,1V14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sports-mma
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "17",
      :x "7",
      :width "10",
      :height "4",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,7c-0.55,0-1,0.45-1,1V5c0-1.1-0.9-2-2-2H7C5.9,3,5,3.9,5,5v5.8c0,0.13,0.01,0.26,0.04,0.39l0.8,4 c0.09,0.47,0.5,0.8,0.98,0.8h10.36c0.45,0,0.89-0.36,0.98-0.8l0.8-4C18.99,11.06,19,10.93,19,10.8V8C19,7.45,18.55,7,18,7z M15,10 H7V7h8V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 severe-cold
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "12,10.41 16,6.41 14.59,5 12,7.59 12,4 10,4 10,7.59 7.41,5 6,6.41 10,10.41 10,12 8.41,12 4.41,8 3,9.41 5.59,12 2,12 2,14 5.59,14 3,16.59 4.41,18 8.41,14 10,14 10,15.59 6,19.59 7.41,21 10,18.41 10,22 12,22 12,18.41 14.59,21 16,19.59 12,15.59 12,14 13.59,14 17.59,18 19,16.59 16.41,14 20,14 20,12 12,12",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "2",
      :x "19",
      :width "2",
      :height "5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8",
      :x "19",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 person-add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm-9-2V7H4v3H1v2h3v3h2v-3h3v-2H6zm9 4c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sports
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M11.23,6C9.57,6,8.01,6.66,6.87,7.73C6.54,6.73,5.61,6,4.5,6C3.12,6,2,7.12,2,8.5C2,9.88,3.12,11,4.5,11 c0.21,0,0.41-0.03,0.61-0.08c-0.05,0.25-0.09,0.51-0.1,0.78c-0.18,3.68,2.95,6.68,6.68,6.27c2.55-0.28,4.68-2.26,5.19-4.77 c0.15-0.71,0.15-1.4,0.06-2.06c-0.09-0.6,0.38-1.13,0.99-1.13H22V6H11.23z M4.5,9C4.22,9,4,8.78,4,8.5C4,8.22,4.22,8,4.5,8 S5,8.22,5,8.5C5,8.78,4.78,9,4.5,9z M11,15c-1.66,0-3-1.34-3-3s1.34-3,3-3s3,1.34,3,3S12.66,15,11,15z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/circle
      {:r "2", :cy "12", :cx "11", :stroke nil, :fill nil}))))))


(helix.core/defnc
 sentiment-very-satisfied
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.88 9.94L9.94 11 11 9.94 8.88 7.82 6.76 9.94 7.82 11zM12 17.5c2.33 0 4.31-1.46 5.11-3.5H6.89c.8 2.04 2.78 3.5 5.11 3.5zm1-7.56L14.06 11l1.06-1.06L16.18 11l1.06-1.06-2.12-2.12zM11.99 2C6.47 2 2 6.47 2 12s4.47 10 9.99 10S22 17.53 22 12 17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mood-bad
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm3.5-9c.83 0 1.5-.67 1.5-1.5S16.33 8 15.5 8 14 8.67 14 9.5s.67 1.5 1.5 1.5zm-7 0c.83 0 1.5-.67 1.5-1.5S9.33 8 8.5 8 7 8.67 7 9.5 7.67 11 8.5 11zm3.5 2.5c-2.33 0-4.31 1.46-5.11 3.5h10.22c-.8-2.04-2.78-3.5-5.11-3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 downhill-skiing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18.5,4.5c0,1.1-0.9,2-2,2s-2-0.9-2-2s0.9-2,2-2S18.5,3.4,18.5,4.5z M15.78,20.9l0.76,0.27c0.62,0.21,1.27,0.33,1.96,0.33 c0.84,0,1.65-0.18,2.38-0.5L22,22.13C20.95,22.68,19.76,23,18.5,23c-0.86,0-1.68-0.14-2.45-0.41L2,17.47l0.5-1.41l6.9,2.51 l1.72-4.44L7.55,10.4C6.66,9.46,6.88,7.93,8,7.28l3.48-2.01c1.1-0.64,2.52-0.1,2.91,1.11l0.33,1.08c0.44,1.42,1.48,2.57,2.83,3.14 L18.07,9l1.43,0.46l-1.12,3.45c-2.45-0.4-4.48-2.07-5.38-4.32l-2.53,1.45l3.03,3.46l-2.22,5.76l3.09,1.12l2.1-6.44h0l0,0 c0.46,0.18,0.94,0.31,1.44,0.41L15.78,20.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 location-city
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 11V5l-3-3-3 3v2H3v14h18V11h-6zm-8 8H5v-2h2v2zm0-4H5v-2h2v2zm0-4H5V9h2v2zm6 8h-2v-2h2v2zm0-4h-2v-2h2v2zm0-4h-2V9h2v2zm0-4h-2V5h2v2zm6 12h-2v-2h2v2zm0-4h-2v-2h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ios-share
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "20,8 15,8 15,10 18,10 18,21 6,21 6,10 9,10 9,8 4,8 4,23 20,23",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,16 13,16 13,5 16,5 12,1 8,5 11,5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 kayaking
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21,23c-1.03,0-2.06-0.25-3-0.75h0c-1.89,1-4.11,1-6,0c-1.89,1-4.11,1-6,0C5.05,22.75,4.03,23,3,23H2l0-2h1 c1.04,0,2.08-0.35,3-1c1.83,1.3,4.17,1.3,6,0c1.83,1.3,4.17,1.3,6,0c0.91,0.65,1.96,1,3,1h1v2H21z M12,5.5c-1.1,0-2,0.9-2,2 s0.9,2,2,2s2-0.9,2-2S13.1,5.5,12,5.5z M24,17.5c0,0-1.52,0.71-3.93,1.37c-0.82-0.23-1.53-0.75-2.07-1.37c-0.73,0.84-1.8,1.5-3,1.5 s-2.27-0.66-3-1.5c-0.73,0.84-1.8,1.5-3,1.5s-2.27-0.66-3-1.5c-0.54,0.61-1.25,1.13-2.07,1.37C1.52,18.21,0,17.5,0,17.5 s2.93-1.36,7.13-2.08l1.35-4.17c0.31-0.95,1.32-1.47,2.27-1.16c0.09,0.03,0.19,0.07,0.27,0.11l0,0l2.47,1.3l2.84-1.5l1.65-3.71 l-0.51-1.32L18.8,2L22,3.43L20.67,6.4l-1.31,0.5l-3.72,8.34C20.49,15.87,24,17.5,24,17.5z M15.02,12.96l-1.52,0.8l-1.75-0.92 l-0.71,2.17C11.36,15.01,11.68,15,12,15c0.71,0,1.4,0.03,2.07,0.08L15.02,12.96z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 switch-account
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M4,6H2v16h16v-2H4V6z M6,2v16h16V2H6z M14,5c1.66,0,3,1.34,3,3c0,1.66-1.34,3-3,3s-3-1.34-3-3C11,6.34,12.34,5,14,5z M7.76,16c1.47-1.83,3.71-3,6.24-3s4.77,1.17,6.24,3H7.76z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 coronavirus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20.5,10.5v0.75h-1.54c-0.15-1.37-0.69-2.63-1.52-3.65l1.09-1.09l0.01,0.01l0.53,0.53l1.06-1.06l-2.12-2.12l-1.06,1.06 l0.52,0.52l-1.09,1.09c-1.02-0.82-2.27-1.36-3.64-1.51V3.5h0.01h0.75V2h-3v1.5h0.74v1.54C9.87,5.19,8.62,5.74,7.6,6.56L6.51,5.47 l0.01-0.01l0.53-0.53L5.99,3.87L3.87,5.99l1.06,1.06l0.52-0.52l1.09,1.09c-0.82,1.02-1.36,2.26-1.5,3.63H3.5V10.5H2v3h1.5v-0.75 h1.54c0.15,1.37,0.69,2.61,1.5,3.63l-1.09,1.09l-0.52-0.52l-1.06,1.06l2.12,2.12l1.06-1.06l-0.53-0.53v0l-0.01-0.01l1.09-1.09 c1.02,0.82,2.26,1.36,3.63,1.51v1.54H10.5V22h3v-1.5h-0.75h-0.01v-1.54c1.37-0.14,2.62-0.69,3.64-1.51l1.09,1.09l-0.52,0.52 l1.06,1.06l2.12-2.12l-1.06-1.06l-0.53,0.53c0,0,0,0,0,0l-0.01,0.01l-1.09-1.09c0.82-1.02,1.37-2.27,1.52-3.65h1.54v0.75H22v-3H20.5 z M13.75,8c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S13.2,8,13.75,8z M10.25,8c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1 S9.7,8,10.25,8z M8.5,13c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C9.5,12.55,9.05,13,8.5,13z M10.25,16c-0.55,0-1-0.45-1-1 c0-0.55,0.45-1,1-1s1,0.45,1,1C11.25,15.55,10.8,16,10.25,16z M12,13c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1 C13,12.55,12.55,13,12,13z M13.75,16c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C14.75,15.55,14.3,16,13.75,16z M15.5,13 c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C16.5,12.55,16.05,13,15.5,13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 landslide
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "15.47,13.79 12.89,12.76 6,15.05 2,13.51 2,15.61 6,16.95",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "10.57,11.42 8,8 2,8 2,11.61 6,12.95",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "6,19.05 2,17.72 2,22 22,22 17.03,15.38",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "17,6 17,1 12,0 9,2 9,6 12,8", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points "18.5,7 16,9 16,12 18.5,14 23,12 23,8",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 elderly-woman
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.5,11c-1.56,0-2.92-0.9-3.58-2.21l-0.79-1.67l0,0C14.12,7.1,13.63,6,12.34,6l0,0C8.72,6,6,16.69,6,19h2.5l-2.1,2.8 L8,23l3-4h2v4h2v-4.03L13,13l0.49-2.71c0.81,1.23,2.05,2.14,3.51,2.52v0.69h1v-1c0-0.28,0.22-0.5,0.5-0.5s0.5,0.22,0.5,0.5V23h1 V12.5C20,11.67,19.33,11,18.5,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.6,2.91c-0.06,0.19-0.1,0.38-0.1,0.59c0,1.1,0.9,2,2,2s2-0.9,2-2c0-1.1-0.9-2-2-2c-0.21,0-0.4,0.04-0.59,0.1 C12.76,1.25,12.41,1,12,1c-0.55,0-1,0.45-1,1C11,2.41,11.25,2.76,11.6,2.91z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 tornado
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "20.11,8 23,3 1,3 3.89,8", :stroke nil, :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "7.95,15 12,22 16.05,15", :stroke nil, :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "18.95,10 5.05,10 6.79,13 17.21,13",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 nordic-walking
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,23h-1.5v-9H19V23z M7.53,14H6l-2,9h1.53L7.53,14z M13.5,5.5c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S12.4,5.5,13.5,5.5z M9.8,8.9L7,23h2.1l1.8-8l2.1,2v6h2v-7.5l-2.1-2l0.6-3C14.8,12,16.8,13,19,13v-2c-1.9,0-3.5-1-4.3-2.4l-1-1.6 c-0.56-0.89-1.68-1.25-2.65-0.84L6,8.3V13h2V9.6L9.8,8.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sentiment-dissatisfied
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1.5", :cy "9.5", :cx "15.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "9.5", :cx "8.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 14c-2.33 0-4.32 1.45-5.12 3.5h1.67c.69-1.19 1.97-2 3.45-2s2.75.81 3.45 2h1.67c-.8-2.05-2.79-3.5-5.12-3.5zm-.01-12C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 person-remove
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,8c0-2.21-1.79-4-4-4S6,5.79,6,8s1.79,4,4,4S14,10.21,14,8z M17,10v2h6v-2H17z M2,18v2h16v-2c0-2.66-5.33-4-8-4 S2,15.34,2,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 outdoor-grill
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17,22c1.66,0,3-1.34,3-3s-1.34-3-3-3c-1.3,0-2.4,0.84-2.82,2H9.14l1.99-3.06C11.42,14.98,11.71,15,12,15 c0.29,0,0.58-0.02,0.87-0.06l1.02,1.57c0.42-0.53,0.96-0.95,1.6-1.21l-0.6-0.93C17.31,13.27,19,10.84,19,8H5 c0,2.84,1.69,5.27,4.12,6.37l-4.5,6.92l1.68,1.09L7.84,20h6.34C14.6,21.16,15.7,22,17,22z M17,18c0.55,0,1,0.45,1,1 c0,0.55-0.45,1-1,1s-1-0.45-1-1C16,18.45,16.45,18,17,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.41,7h1c0.15-1.15,0.23-1.64-0.89-2.96C9.1,3.54,8.84,3.27,9.06,2H8.07C7.86,3.11,8.1,4.05,8.96,4.96 C9.18,5.2,9.75,5.63,9.41,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.89,7h1c0.15-1.15,0.23-1.64-0.89-2.96c-0.42-0.5-0.68-0.78-0.46-2.04h-0.99c-0.21,1.11,0.03,2.05,0.89,2.96 C11.67,5.2,12.24,5.63,11.89,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.41,7h1c0.15-1.15,0.23-1.64-0.89-2.96C14.1,3.54,13.84,3.27,14.06,2h-0.99c-0.21,1.11,0.03,2.05,0.89,2.96 C14.18,5.2,14.75,5.63,14.41,7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 notifications-none
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm6-6v-5c0-3.07-1.63-5.64-4.5-6.32V2.5h-3v2.18C7.64 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2zm-2 1H8v-6c0-2.48 1.51-4.5 4-4.5s4 2.02 4 4.5v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 architecture
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6.36,18.78L6.61,21l1.62-1.54l2.77-7.6c-0.68-0.17-1.28-0.51-1.77-0.98L6.36,18.78z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.77,10.88c-0.49,0.47-1.1,0.81-1.77,0.98l2.77,7.6L17.39,21l0.26-2.22L14.77,10.88z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15,8c0-1.3-0.84-2.4-2-2.82V3h-2v2.18C9.84,5.6,9,6.7,9,8c0,1.66,1.34,3,3,3S15,9.66,15,8z M12,9c-0.55,0-1-0.45-1-1 c0-0.55,0.45-1,1-1s1,0.45,1,1C13,8.55,12.55,9,12,9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 military-tech
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,11V2H7v9l4.66,2.8l-0.99,2.34l-3.41,0.29l2.59,2.24L9.07,22L12,20.23L14.93,22l-0.78-3.33l2.59-2.24l-3.41-0.29 l-0.99-2.34L17,11z M13,12.23l-1,0.6l-1-0.6V3h2V12.23z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 emoji-nature
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.94,4.88C21.76,4.35,21.25,4,20.68,4c-0.03,0-0.06,0-0.09,0H19.6l-0.31-0.97C19.15,2.43,18.61,2,18,2h0 c-0.61,0-1.15,0.43-1.29,1.04L16.4,4h-0.98c-0.03,0-0.06,0-0.09,0c-0.57,0-1.08,0.35-1.26,0.88c-0.19,0.56,0.04,1.17,0.56,1.48 l0.87,0.52L15.1,8.12c-0.23,0.58-0.04,1.25,0.45,1.62C15.78,9.91,16.06,10,16.33,10c0.31,0,0.61-0.11,0.86-0.32L18,8.98l0.81,0.7 C19.06,9.89,19.36,10,19.67,10c0.27,0,0.55-0.09,0.78-0.26c0.5-0.37,0.68-1.04,0.45-1.62l-0.39-1.24l0.87-0.52 C21.89,6.05,22.12,5.44,21.94,4.88z M18,7c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C19,6.55,18.55,7,18,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.49,10.51c-0.43-0.43-0.94-0.73-1.49-0.93V8h-1v1.38c-0.11-0.01-0.23-0.03-0.34-0.03c-1.02,0-2.05,0.39-2.83,1.17 c-0.16,0.16-0.3,0.34-0.43,0.53L6,10.52c-1.56-0.55-3.28,0.27-3.83,1.82c0,0,0,0,0,0c-0.27,0.75-0.23,1.57,0.12,2.29 c0.23,0.48,0.58,0.87,1,1.16c-0.38,1.35-0.06,2.85,1,3.91c1.06,1.06,2.57,1.38,3.91,1c0.29,0.42,0.68,0.77,1.16,1 C9.78,21.9,10.21,22,10.65,22c0.34,0,0.68-0.06,1.01-0.17c0,0,0,0,0,0c1.56-0.55,2.38-2.27,1.82-3.85l-0.52-1.37 c0.18-0.13,0.36-0.27,0.53-0.43c0.87-0.87,1.24-2.04,1.14-3.17H16v-1h-1.59C14.22,11.46,13.92,10.95,13.49,10.51z M4.67,14.29 c-0.25-0.09-0.45-0.27-0.57-0.51s-0.13-0.51-0.04-0.76c0.19-0.52,0.76-0.79,1.26-0.61l3.16,1.19C7.33,14.2,5.85,14.71,4.67,14.29z M10.99,19.94c-0.25,0.09-0.52,0.08-0.76-0.04c-0.24-0.11-0.42-0.32-0.51-0.57c-0.42-1.18,0.09-2.65,0.7-3.8l1.18,3.13 C11.78,19.18,11.51,19.76,10.99,19.94z M12.2,14.6l-0.61-1.61c0-0.01-0.01-0.02-0.02-0.03c-0.02-0.04-0.04-0.08-0.06-0.12 c-0.02-0.04-0.04-0.07-0.07-0.11c-0.03-0.03-0.06-0.06-0.09-0.09c-0.03-0.03-0.06-0.06-0.09-0.09c-0.03-0.03-0.07-0.05-0.11-0.07 c-0.04-0.02-0.07-0.05-0.12-0.06c-0.01,0-0.02-0.01-0.03-0.02L9.4,11.8c0.36-0.29,0.79-0.46,1.26-0.46c0.53,0,1.04,0.21,1.41,0.59 C12.8,12.66,12.84,13.81,12.2,14.6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 public
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pix
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M15.45,16.52l-3.01-3.01c-0.11-0.11-0.24-0.13-0.31-0.13s-0.2,0.02-0.31,0.13L8.8,16.53c-0.34,0.34-0.87,0.89-2.64,0.89 l3.71,3.7c1.17,1.17,3.07,1.17,4.24,0l3.72-3.71C16.92,17.41,16.16,17.23,15.45,16.52z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8.8,7.47l3.02,3.02c0.08,0.08,0.2,0.13,0.31,0.13s0.23-0.05,0.31-0.13l2.99-2.99c0.71-0.74,1.52-0.91,2.43-0.91 l-3.72-3.71c-1.17-1.17-3.07-1.17-4.24,0l-3.71,3.7C7.95,6.58,8.49,7.16,8.8,7.47z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.11,9.85l-2.25-2.26H17.6c-0.54,0-1.08,0.22-1.45,0.61l-3,3c-0.28,0.28-0.65,0.42-1.02,0.42 c-0.36,0-0.74-0.15-1.02-0.42L8.09,8.17c-0.38-0.38-0.9-0.6-1.45-0.6H5.17l-2.29,2.3c-1.17,1.17-1.17,3.07,0,4.24l2.29,2.3h1.48 c0.54,0,1.06-0.22,1.45-0.6l3.02-3.02c0.28-0.28,0.65-0.42,1.02-0.42c0.37,0,0.74,0.14,1.02,0.42l3.01,3.01 c0.38,0.38,0.9,0.6,1.45,0.6h1.26l2.25-2.26C22.3,12.96,22.3,11.04,21.11,9.85z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 facebook
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,12c0-5.52-4.48-10-10-10S2,6.48,2,12c0,4.84,3.44,8.87,8,9.8V15H8v-3h2V9.5C10,7.57,11.57,6,13.5,6H16v3h-2 c-0.55,0-1,0.45-1,1v2h3v3h-3v6.95C18.05,21.45,22,17.19,22,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 scoreboard
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17.5,13.5H16v-3h1.5V13.5z M22,4h-5V2h-2v2H9V2H7v2H2v16h20V4z M9.5,12.5h-3v1h3V15H5v-3.5h3v-1H5V9h4.5V12.5z M12.75,18 h-1.5v-1.5h1.5V18z M12.75,14.5h-1.5V13h1.5V14.5z M12.75,11h-1.5V9.5h1.5V11z M12.75,7.5h-1.5V6h1.5V7.5z M19,9v6h-4.5V9H19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 connect-without-contact
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M11,14H9c0-4.97,4.03-9,9-9v2C14.13,7,11,10.13,11,14z M18,11V9c-2.76,0-5,2.24-5,5h2C15,12.34,16.34,11,18,11z M7,4 c0-1.11-0.89-2-2-2S3,2.89,3,4s0.89,2,2,2S7,5.11,7,4z M11.45,4.5h-2C9.21,5.92,7.99,7,6.5,7H2v4h6V8.74 C9.86,8.15,11.25,6.51,11.45,4.5z M19,17c1.11,0,2-0.89,2-2s-0.89-2-2-2s-2,0.89-2,2S17.89,17,19,17z M17.5,18 c-1.49,0-2.71-1.08-2.95-2.5h-2c0.2,2.01,1.59,3.65,3.45,4.24V22h6v-4H17.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 people-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:fill-rule "evenodd",
       :d
       "M16.67,13.13C18.04,14.06,19,15.32,19,17v3h4v-3 C23,14.82,19.43,13.53,16.67,13.13z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/circle
      {:r "4",
       :fill-rule "evenodd",
       :cy "8",
       :cx "9",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:fill-rule "evenodd",
       :d
       "M15,12c2.21,0,4-1.79,4-4c0-2.21-1.79-4-4-4c-0.47,0-0.91,0.1-1.33,0.24 C14.5,5.27,15,6.58,15,8s-0.5,2.73-1.33,3.76C14.09,11.9,14.53,12,15,12z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:fill-rule "evenodd",
       :d "M9,13c-2.67,0-8,1.34-8,4v3h16v-3C17,14.34,11.67,13,9,13z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 king-bed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "7",
      :x "6",
      :width "5",
      :height "3",
      :fill "none",
      :stroke nil})
    (helix.dom/rect
     {:y "7",
      :x "13",
      :width "5",
      :height "3",
      :fill "none",
      :stroke nil})
    (helix.dom/path
     {:d
      "M20,10V5H4v5H2v7h1.33L4,19h1l0.67-2h12.67L19,19h1l0.67-2H22v-7H20z M11,10H6V7h5V10z M18,10h-5V7h5V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 diversity-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10.1,15.9l1.42-1.42C8.79,12.05,7,10.41,7,8.85C7,7.8,7.8,7,8.85,7c1.11,0,1.54,0.65,2.68,2h0.93 c1.12-1.31,1.53-2,2.68-2c0.87,0,1.55,0.54,1.77,1.32c0.35-0.04,0.68-0.06,1-0.06c0.36,0,0.7,0.03,1.03,0.08 C18.7,6.43,17.13,5,15.15,5c-0.12,0-0.23,0.03-0.35,0.04C14.92,4.71,15,4.37,15,4c0-1.66-1.34-3-3-3S9,2.34,9,4 c0,0.37,0.08,0.71,0.2,1.04C9.08,5.03,8.97,5,8.85,5C6.69,5,5,6.69,5,8.85C5,11.27,7.04,13.16,10.1,15.9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.5,16.24c-0.32-0.18-0.66-0.29-1-0.35c0.07-0.1,0.15-0.18,0.21-0.28c1.08-1.87,0.46-4.18-1.41-5.26 c-2.09-1.21-4.76-0.39-8.65,0.9l0.52,1.94c3.47-1.14,5.79-1.88,7.14-1.1c0.91,0.53,1.2,1.61,0.68,2.53 c-0.56,0.96-1.33,1-3.07,1.32l-0.47,0.81c0.58,1.62,0.97,2.33,0.39,3.32c-0.53,0.91-1.61,1.2-2.53,0.68 c-0.06-0.03-0.11-0.09-0.17-0.13c-0.3,0.67-0.64,1.24-1.03,1.73c0.07,0.04,0.13,0.09,0.2,0.14c1.87,1.08,4.18,0.46,5.26-1.41 c0.06-0.1,0.09-0.21,0.14-0.32c0.22,0.27,0.48,0.51,0.8,0.69c1.43,0.83,3.27,0.34,4.1-1.1S23.93,17.06,22.5,16.24z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12.32,14.01c-0.74,3.58-1.27,5.95-2.62,6.73c-0.91,0.53-2,0.24-2.53-0.68c-0.56-0.96-0.2-1.66,0.39-3.32L7.1,15.93 c-1.7-0.31-2.5-0.33-3.07-1.32c-0.53-0.91-0.24-2,0.68-2.53c0.09-0.05,0.19-0.08,0.29-0.11c-0.35-0.56-0.64-1.17-0.82-1.85 c-0.16,0.07-0.32,0.14-0.48,0.23c-1.87,1.08-2.49,3.39-1.41,5.26c0.06,0.1,0.14,0.18,0.21,0.28c-0.34,0.06-0.68,0.17-1,0.35 c-1.43,0.83-1.93,2.66-1.1,4.1s2.66,1.93,4.1,1.1c0.32-0.18,0.58-0.42,0.8-0.69c0.05,0.11,0.08,0.22,0.14,0.32 c1.08,1.87,3.39,2.49,5.26,1.41c2.09-1.21,2.71-3.93,3.55-7.94L12.32,14.01z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sentiment-satisfied
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1.5", :cy "9.5", :cx "15.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "9.5", :cx "8.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm0-4c-1.48 0-2.75-.81-3.45-2H6.88c.8 2.05 2.79 3.5 5.12 3.5s4.32-1.45 5.12-3.5h-1.67c-.7 1.19-1.97 2-3.45 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sports-gymnastics
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M4,6c0-1.1,0.9-2,2-2s2,0.9,2,2S7.1,8,6,8S4,7.1,4,6z M1,9h6l7-5l1.31,1.52L11.14,8.5H14L21.8,4L23,5.4L14.5,12L14,22h-2 l-0.5-10L8,11H1V9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 precision-manufacturing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,10V9.82l2.01,2.01l5.23-2.44l-0.63-1.36l-4.28,2L14,7.7V6.3l2.33-2.33l4.28,2l0.63-1.36l-5.23-2.44L14,4.18V4h-2v2 H8.82C8.4,4.84,7.3,4,6,4C4.34,4,3,5.34,3,7c0,1.1,0.6,2.05,1.48,2.58L7.08,18H4v3h13v-3h-3.62L8.41,8.76 C8.58,8.53,8.72,8.28,8.82,8H12v2H14z M6,8C5.45,8,5,7.55,5,7c0-0.55,0.45-1,1-1s1,0.45,1,1C7,7.55,6.55,8,6,8z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sports-kabaddi
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "2.38", :cx "16.5", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M24,11.88v-4.7l-5.05-2.14c-0.97-0.41-2.09-0.06-2.65,0.84l0,0l-1,1.6c-0.67,1.18-1.91,2.06-3.41,2.32l0.06,0.06 c0.69,0.69,1.52,1.07,2.46,1.17c0.8-0.42,1.52-0.98,2.09-1.64l0.6,3l-1.16,1.1L15,14.38v0.76v6.74h2v-6l2.1-2l1.8,8H23l-2.18-11 l-0.62-3.1l1.8,0.7v3.4H24z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.29,8.09c0.22,0.15,0.47,0.24,0.72,0.29c0.13,0.02,0.25,0.04,0.38,0.04s0.26-0.01,0.38-0.04 c0.13-0.02,0.25-0.06,0.37-0.11c0.24-0.1,0.47-0.24,0.66-0.44c0.49-0.49,0.67-1.17,0.55-1.8C13.28,5.66,13.1,5.29,12.8,5 c-0.19-0.19-0.42-0.34-0.66-0.44c-0.12-0.05-0.24-0.09-0.37-0.11s-0.25-0.04-0.38-0.04c-0.12,0-0.23,0.01-0.35,0.03 c-0.14,0.02-0.28,0.06-0.41,0.11C10.4,4.66,10.17,4.81,9.98,5C9.68,5.29,9.5,5.66,9.43,6.03c-0.12,0.63,0.06,1.31,0.55,1.8 C10.07,7.93,10.18,8.01,10.29,8.09z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.24,10.56l-2-2c-0.1-0.1-0.2-0.18-0.31-0.26C8.71,8.16,8.46,8.06,8.21,8.02C8.08,7.99,7.96,7.98,7.83,7.98 c-0.51,0-1.02,0.2-1.41,0.59l-3.34,3.34c-0.41,0.41-0.62,0.98-0.58,1.54C2.5,13.63,2.54,13.82,2.61,14l1.07,2.95l-3.63,3.63 L1.46,22l4.24-4.24v-2.22L7,16.75v5.13h2v-6l-2.12-2.12l2.36-2.36l0.71,0.71l0,0c1.29,1.26,2.97,2.04,5.03,2.04l-0.14-2.07 C13.34,12.06,12.14,11.46,11.24,10.56z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 front-hand
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18.5,8v7H18c-1.65,0-3,1.35-3,3h-1c0-2.04,1.53-3.72,3.5-3.97V2H15v9h-1V0h-2.5v11h-1V1.5H8V12H7V4.5H4.5v11.25 c0,4.56,3.69,8.25,8.25,8.25S21,20.31,21,15.75V8H18.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 person-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.39,14.56C16.71,13.7,14.53,13,12,13c-2.53,0-4.71,0.7-6.39,1.56C4.61,15.07,4,16.1,4,17.22V20h16v-2.78 C20,16.1,19.39,15.07,18.39,14.56z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.78,12h4.44c1.21,0,2.14-1.06,1.98-2.26l-0.32-2.45C15.57,5.39,13.92,4,12,4S8.43,5.39,8.12,7.29L7.8,9.74 C7.64,10.94,8.57,12,9.78,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 snowboarding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M14,3c0-1.1,0.9-2,2-2s2,0.9,2,2c0,1.1-0.9,2-2,2S14,4.1,14,3z M21.4,20.09c-0.23-0.05-0.46,0.02-0.64,0.17 c-0.69,0.6-1.64,0.88-2.6,0.67L17,20.69l-1-6.19l-3.32-2.67l1.8-2.89C15.63,10.78,17.68,12,20,12v-2c-1.85,0-3.44-1.12-4.13-2.72 l-0.52-1.21C15.16,5.64,14.61,5,13.7,5H8L5.5,9l1.7,1.06L9.1,7h2.35L8.5,11.7l1,4.3L6,18.35l-0.47-0.1c-0.96-0.2-1.71-0.85-2.1-1.67 c-0.1-0.21-0.28-0.37-0.51-0.42c-0.43-0.09-0.82,0.2-0.9,0.58C1.98,16.88,2,17.05,2.07,17.2c0.58,1.24,1.71,2.2,3.15,2.51 l12.63,2.69c1.44,0.31,2.86-0.11,3.9-1.01c0.13-0.11,0.21-0.26,0.24-0.41C22.06,20.6,21.83,20.18,21.4,20.09z M8.73,18.93l3.02-2.03 l-0.44-3.32l2.84,2.02l0.75,4.64L8.73,18.93z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 people
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5s-3 1.34-3 3 1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 girl
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,7.5c0.97,0,1.75-0.78,1.75-1.75S12.97,4,12,4s-1.75,0.78-1.75,1.75S11.03,7.5,12,7.5z M14,16v4h-4v-4H8l2.38-6.38 C10.63,8.95,11.28,8.5,12,8.5s1.37,0.45,1.62,1.12L16,16H14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 person-3
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18.39,14.56C16.71,13.7,14.53,13,12,13c-2.53,0-4.71,0.7-6.39,1.56C4.61,15.07,4,16.1,4,17.22V20h16v-2.78 C20,16.1,19.39,15.07,18.39,14.56z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M10,12c0.17,0,3.83,0,4,0c1.66,0,3-1.34,3-3c0-0.73-0.27-1.4-0.71-1.92C16.42,6.75,16.5,6.38,16.5,6 c0-1.25-0.77-2.32-1.86-2.77C14,2.48,13.06,2,12,2s-2,0.48-2.64,1.23C8.27,3.68,7.5,4.75,7.5,6c0,0.38,0.08,0.75,0.21,1.08 C7.27,7.6,7,8.27,7,9C7,10.66,8.34,12,10,12z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 add-moderator
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17,10c1.08,0,2.09,0.25,3,0.68V5l-8-3L4,5v6.09c0,5.05,3.41,9.76,8,10.91c0.03-0.01,0.05-0.02,0.08-0.02 C10.8,20.71,10,18.95,10,17C10,13.13,13.13,10,17,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,12c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S19.76,12,17,12z M20,17.5h-2.5V20h-1v-2.5H14v-1h2.5V14h1v2.5H20V17.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sports-esports
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,5H4L2,19h4l3-3h6l3,3h4L20,5z M11,11H9v2H8v-2H6v-1h2V8h1v2h2V11z M15,10c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1 s1,0.45,1,1C16,9.55,15.55,10,15,10z M17,13c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C18,12.55,17.55,13,17,13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 person-4
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18.39,14.56C16.71,13.7,14.53,13,12,13c-2.53,0-4.71,0.7-6.39,1.56C4.61,15.07,4,16.1,4,17.22V20h16v-2.78 C20,16.1,19.39,15.07,18.39,14.56z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,12c2.21,0,4-1.79,4-4c0-1.37,0-3.5,0-3.5C16,3.67,15.33,3,14.5,3c-0.52,0-0.98,0.27-1.25,0.67 C12.98,3.27,12.52,3,12,3s-0.98,0.27-1.25,0.67C10.48,3.27,10.02,3,9.5,3C8.67,3,8,3.67,8,4.5c0,0,0,2.12,0,3.5 C8,10.21,9.79,12,12,12z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 wallet
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,4H2v16h20V4z M15.75,14.09L4,11.22V10h16v0.53L15.75,14.09z M4,6h16v2H4V6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 diversity-3
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6.32,13.01c0.96,0.02,1.85,0.5,2.45,1.34C9.5,15.38,10.71,16,12,16c1.29,0,2.5-0.62,3.23-1.66 c0.6-0.84,1.49-1.32,2.45-1.34C16.96,11.78,14.08,11,12,11C9.93,11,7.04,11.78,6.32,13.01z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4,13L4,13c1.66,0,3-1.34,3-3c0-1.66-1.34-3-3-3s-3,1.34-3,3C1,11.66,2.34,13,4,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,13L20,13c1.66,0,3-1.34,3-3c0-1.66-1.34-3-3-3s-3,1.34-3,3C17,11.66,18.34,13,20,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,10c1.66,0,3-1.34,3-3c0-1.66-1.34-3-3-3S9,5.34,9,7C9,8.66,10.34,10,12,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,14h-3.27c-0.77,0-1.35,0.45-1.68,0.92C16.01,14.98,14.69,17,12,17c-1.43,0-3.03-0.64-4.05-2.08 C7.56,14.37,6.95,14,6.27,14H3c-1.1,0-2,0.9-2,2v4h7v-2.26c1.15,0.8,2.54,1.26,4,1.26s2.85-0.46,4-1.26V20h7v-4 C23,14.9,22.1,14,21,14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 construction
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "12.87",
      :x "16.34",
      :width "3",
      :transform
      "matrix(0.7071 -0.7071 0.7071 0.7071 -6.8717 17.6255)",
      :height "8.48",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.5,10c1.93,0,3.5-1.57,3.5-3.5c0-0.58-0.16-1.12-0.41-1.6l-2.7,2.7L16.4,6.11l2.7-2.7C18.62,3.16,18.08,3,17.5,3 C15.57,3,14,4.57,14,6.5c0,0.41,0.08,0.8,0.21,1.16l-1.85,1.85l-1.78-1.78l0.71-0.71L9.88,5.61L12,3.49 c-1.17-1.17-3.07-1.17-4.24,0L4.22,7.03l1.41,1.41H2.81L2.1,9.15l3.54,3.54l0.71-0.71V9.15l1.41,1.41l0.71-0.71l1.78,1.78 l-7.41,7.41l2.12,2.12L16.34,9.79C16.7,9.92,17.09,10,17.5,10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 thumb-up-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.17 1L7 8.18V21h12.31L23 12.4V8h-8.31l1.12-5.38zM1 9h4v12H1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hive
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "13.79,8 15.59,5 13.79,2 10.21,2 8.41,5 10.21,8",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "10.21,9 8.41,12 10.21,15 13.79,15 15.59,12 13.79,9",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "16.45,11.51 20.04,11.51 21.83,8.51 20.04,5.51 16.45,5.51 14.65,8.51",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20.04,12.51 16.45,12.51 14.65,15.51 16.45,18.51 20.04,18.51 21.83,15.51",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "7.55,11.51 9.35,8.51 7.55,5.51 3.96,5.51 2.17,8.51 3.96,11.51",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "7.55,12.51 3.96,12.51 2.17,15.51 3.96,18.51 7.55,18.51 9.35,15.51",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "10.21,16 8.41,19 10.21,22 13.79,22 15.59,19 13.79,16",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 emoji-emotions
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/path
    {:d
     "M11.99,2C6.47,2,2,6.48,2,12c0,5.52,4.47,10,9.99,10C17.52,22,22,17.52,22,12C22,6.48,17.52,2,11.99,2z M8.5,8 C9.33,8,10,8.67,10,9.5S9.33,11,8.5,11S7,10.33,7,9.5S7.67,8,8.5,8z M12,18c-2.28,0-4.22-1.66-5-4h10C16.22,16.34,14.28,18,12,18z M15.5,11c-0.83,0-1.5-0.67-1.5-1.5S14.67,8,15.5,8S17,8.67,17,9.5S16.33,11,15.5,11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 clean-hands
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14.99,7l1.37-0.63L16.99,5l0.63,1.37L18.99,7l-1.37,0.63L16.99,9l-0.63-1.37L14.99,7z M20,14c1.1,0,2-0.9,2-2 c0-1.1-2-4-2-4s-2,2.9-2,4C18,13.1,18.9,14,20,14z M1,22h4V11H1V22z M9.24,9.5L15,11.65V11c0-2.42-1.72-4.44-4-4.9V4h2 c0.57,0,1.1,0.17,1.55,0.45l1.43-1.43C15.15,2.39,14.13,2,13,2c-1.48,0-5.5,0-5.5,0v2H9v2.11C7.22,6.48,5.8,7.79,5.25,9.5H9.24z M22,17h-9l-2.09-0.73l0.33-0.94L13,16h4l0-2l-8.03-3H7v9.02L14,22l8-3V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 workspace-premium
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M9.68,13.69L12,11.93l2.31,1.76l-0.88-2.85L15.75,9h-2.84L12,6.19L11.09,9H8.25l2.31,1.84L9.68,13.69z M20,10 c0-4.42-3.58-8-8-8s-8,3.58-8,8c0,2.03,0.76,3.87,2,5.28V23l6-2l6,2v-7.72C19.24,13.87,20,12.03,20,10z M12,4c3.31,0,6,2.69,6,6 s-2.69,6-6,6s-6-2.69-6-6S8.69,4,12,4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sports-baseball
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M3.81,6.28C2.67,7.9,2,9.87,2,12s0.67,4.1,1.81,5.72C6.23,16.95,8,14.68,8,12S6.23,7.05,3.81,6.28z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M20.19,6.28C17.77,7.05,16,9.32,16,12s1.77,4.95,4.19,5.72C21.33,16.1,22,14.13,22,12S21.33,7.9,20.19,6.28z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M14,12c0-3.28,1.97-6.09,4.79-7.33C17.01,3.02,14.63,2,12,2S6.99,3.02,5.21,4.67C8.03,5.91,10,8.72,10,12 s-1.97,6.09-4.79,7.33C6.99,20.98,9.37,22,12,22s5.01-1.02,6.79-2.67C15.97,18.09,14,15.28,14,12z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 paragliding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,17c-1.1,0-2-0.9-2-2s0.9-2,2-2s2,0.9,2,2S13.1,17,12,17z M8.52,17.94C8.04,17.55,7,16.76,7,14H5 c0,2.7,0.93,4.41,2.3,5.5c0.5,0.4,1.1,0.7,1.7,0.9L9,24h6v-3.6c0.6-0.2,1.2-0.5,1.7-0.9c1.37-1.09,2.3-2.8,2.3-5.5h-2 c0,2.76-1.04,3.55-1.52,3.94C14.68,18.54,14,19,12,19S9.32,18.54,8.52,17.94z M12,0C5.92,0,1,1.9,1,4.25v3.49 C1,8.55,1.88,9,2.56,8.57C2.7,8.48,2.84,8.39,3,8.31L5,13h2l1.5-6.28C9.6,6.58,10.78,6.5,12,6.5s2.4,0.08,3.5,0.22L17,13h2l2-4.69 c0.16,0.09,0.3,0.17,0.44,0.26C22.12,9,23,8.55,23,7.74V4.25C23,1.9,18.08,0,12,0z M5.88,11.24L4.37,7.69 c0.75-0.28,1.6-0.52,2.53-0.71L5.88,11.24z M18.12,11.24L17.1,6.98c0.93,0.19,1.78,0.43,2.53,0.71L18.12,11.24z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cookie
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.95,10.99c-1.79-0.03-3.7-1.95-2.68-4.22c-2.98,1-5.77-1.59-5.19-4.56C6.95,0.71,2,6.58,2,12c0,5.52,4.48,10,10,10 C17.89,22,22.54,16.92,21.95,10.99z M8.5,15C7.67,15,7,14.33,7,13.5S7.67,12,8.5,12s1.5,0.67,1.5,1.5S9.33,15,8.5,15z M10.5,10 C9.67,10,9,9.33,9,8.5S9.67,7,10.5,7S12,7.67,12,8.5S11.33,10,10.5,10z M15,16c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1 C16,15.55,15.55,16,15,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sledding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M14,4.5c0,1.1-0.9,2-2,2s-2-0.9-2-2s0.9-2,2-2S14,3.4,14,4.5z M17.22,17.9l1.93,0.63l-0.46,1.43l-3.32-1.08L14.9,20.3 l3.32,1.08l0,0c1.31,0.43,2.72-0.29,3.15-1.61c0.43-1.31-0.29-2.72-1.61-3.15l0.46-1.43c2.1,0.68,3.25,2.94,2.57,5.04 c-0.68,2.1-2.94,3.25-5.04,2.57h0L1,17.36l0.46-1.43l3.93,1.28l0.46-1.43L1.93,14.5l0.46-1.43L4,13.6V9.5l5.47-2.35 c0.39-0.17,0.84-0.21,1.28-0.07c0.95,0.31,1.46,1.32,1.16,2.27l-1.05,3.24L14.5,12L17.22,17.9z M6,14.25l0.48,0.16l0.75-2.31 L7.92,10L6,10.82V14.25z M13.94,18.41l-6.66-2.16l-0.46,1.43l6.66,2.16L13.94,18.41z M14.63,17.05l-1.18-2.56l-3.97,0.89 L14.63,17.05z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 male
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M9.5,11c1.93,0,3.5,1.57,3.5,3.5S11.43,18,9.5,18S6,16.43,6,14.5S7.57,11,9.5,11z M9.5,9C6.46,9,4,11.46,4,14.5 S6.46,20,9.5,20s5.5-2.46,5.5-5.5c0-1.16-0.36-2.23-0.97-3.12L18,7.42V10h2V4h-6v2h2.58l-3.97,3.97C11.73,9.36,10.66,9,9.5,9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 follow-the-signs
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M9.5,5.5c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S8.4,5.5,9.5,5.5z M5.75,8.9L3,23h2.1l1.75-8L9,17v6h2v-7.55L8.95,13.4 l0.6-3C10.85,12,12.8,13,15,13v-2c-1.85,0-3.45-1-4.35-2.45L9.7,6.95C9.35,6.35,8.7,6,8,6C7.75,6,7.5,6.05,7.25,6.15L2,8.3V13h2 V9.65L5.75,8.9 M13,2v7h3.75v14h1.5V9H22V2H13z M18.01,8V6.25H14.5v-1.5h3.51V3l2.49,2.5L18.01,8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sentiment-neutral
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11.99,2C6.47,2,2,6.48,2,12s4.47,10,9.99,10C17.52,22,22,17.52,22,12S17.52,2,11.99,2z M7,9.5C7,8.67,7.67,8,8.5,8 S10,8.67,10,9.5S9.33,11,8.5,11S7,10.33,7,9.5z M15,15.5H9V14h6V15.5z M15.5,11c-0.83,0-1.5-0.67-1.5-1.5S14.67,8,15.5,8 S17,8.67,17,9.5S16.33,11,15.5,11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 no-luggage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12.75,9v0.92l1.75,1.75V9H16v4.17l3,3V6h-4V2H9v4H8.83l3,3H12.75z M10.5,3.5h3V6h-3V3.5z M21.19,21.19L2.81,2.81L1.39,4.22 L5,7.83V21h2v1h2v-1h6v1h2v-1h1.17l1.61,1.61L21.19,21.19z M8,18v-7.17l1.5,1.5V18H8z M11.25,18v-3.92l1.5,1.5V18H11.25z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 heart-broken
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16.5,3c-0.96,0-1.9,0.25-2.73,0.69L12,9h3l-3,10l1-9h-3l1.54-5.39C10.47,3.61,9.01,3,7.5,3C4.42,3,2,5.42,2,8.5 c0,4.13,4.16,7.18,10,12.5c5.47-4.94,10-8.26,10-12.5C22,5.42,19.58,3,16.5,3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sports-soccer
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M13,5.3l1.35-0.95 c1.82,0.56,3.37,1.76,4.38,3.34l-0.39,1.34l-1.35,0.46L13,6.7V5.3z M9.65,4.35L11,5.3v1.4L7.01,9.49L5.66,9.03L5.27,7.69 C6.28,6.12,7.83,4.92,9.65,4.35z M7.08,17.11l-1.14,0.1C4.73,15.81,4,13.99,4,12c0-0.12,0.01-0.23,0.02-0.35l1-0.73L6.4,11.4 l1.46,4.34L7.08,17.11z M14.5,19.59C13.71,19.85,12.87,20,12,20s-1.71-0.15-2.5-0.41l-0.69-1.49L9.45,17h5.11l0.64,1.11 L14.5,19.59z M14.27,15H9.73l-1.35-4.02L12,8.44l3.63,2.54L14.27,15z M18.06,17.21l-1.14-0.1l-0.79-1.37l1.46-4.34l1.39-0.47 l1,0.73C19.99,11.77,20,11.88,20,12C20,13.99,19.27,15.81,18.06,17.21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sports-football
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3.02,15.62c-0.08,2.42,0.32,4.34,0.67,4.69s2.28,0.76,4.69,0.67L3.02,15.62z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.08,3.28C10.75,3.7,8.29,4.62,6.46,6.46s-2.76,4.29-3.18,6.62l7.63,7.63c2.34-0.41,4.79-1.34,6.62-3.18 s2.76-4.29,3.18-6.62L13.08,3.28z M9.9,15.5l-1.4-1.4l5.6-5.6l1.4,1.4L9.9,15.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.98,8.38c0.08-2.42-0.32-4.34-0.67-4.69s-2.28-0.76-4.69-0.67L20.98,8.38z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 personal-injury
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,6c0-2.21,1.79-4,4-4s4,1.79,4,4c0,2.21-1.79,4-4,4S8,8.21,8,6z M17,22h1c1.1,0,2-0.9,2-2l0-4.78 c0-1.12-0.61-2.15-1.61-2.66c-0.43-0.22-0.9-0.43-1.39-0.62L17,22z M12.34,17L15,11.33C14.07,11.12,13.07,11,12,11 c-2.53,0-4.71,0.7-6.39,1.56C4.61,13.07,4,14.1,4,15.22L4,22h2.34C6.12,21.55,6,21.04,6,20.5C6,18.57,7.57,17,9.5,17H12.34z M10,22 l1.41-3H9.5C8.67,19,8,19.67,8,20.5S8.67,22,9.5,22H10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 notifications-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 22c1.1 0 2-.9 2-2h-4c0 1.1.89 2 2 2zm6-11c0-3.07-1.64-5.64-4.5-6.32V2.5h-3v2.18c-.24.06-.47.15-.69.23L18 13.1V11zM5.41 3.35L4 4.76l2.81 2.81C6.29 8.57 6 9.73 6 11v5l-2 2v1h14.24l1.74 1.74 1.41-1.41L5.41 3.35z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 person-add-alt-1
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13,8c0-2.21-1.79-4-4-4S5,5.79,5,8s1.79,4,4,4S13,10.21,13,8z M15,10v2h3v3h2v-3h3v-2h-3V7h-2v3H15z M1,18v2h16v-2 c0-2.66-5.33-4-8-4S1,15.34,1,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 mood
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm3.5-9c.83 0 1.5-.67 1.5-1.5S16.33 8 15.5 8 14 8.67 14 9.5s.67 1.5 1.5 1.5zm-7 0c.83 0 1.5-.67 1.5-1.5S9.33 8 8.5 8 7 8.67 7 9.5 7.67 11 8.5 11zm3.5 6.5c2.33 0 4.31-1.46 5.11-3.5H6.89c.8 2.04 2.78 3.5 5.11 3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 compost
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12.87,11.81c-0.23-0.38-0.37-0.83-0.37-1.31C12.5,9.12,13.62,8,15,8l1,0c1.51,0,2-1,2-1s0.55,6-3,6 c-0.49,0-0.94-0.14-1.32-0.38c-0.24,0.64-0.59,1.76-0.76,2.96c1.26,0.22,2.28,0.89,2.77,1.77c1.69-1.17,2.81-3.13,2.81-5.35h3 c0,5.24-4.26,9.5-9.5,9.5S2.5,17.24,2.5,12S6.76,2.5,12,2.5V0l4,4l-4,4V5.5c-3.58,0-6.5,2.92-6.5,6.5c0,2.21,1.11,4.17,2.81,5.35 c0.51-0.92,1.63-1.62,2.98-1.8c-0.09-0.69-0.26-1.42-0.49-2.03C10.45,13.82,10,14,9.5,14c-1.1,0-2-0.9-2-2v-0.99 c0-0.56-0.19-1.09-0.5-1.51c0,0,4.45-0.23,4.5,2.5c0,0.29-0.06,0.56-0.17,0.8C10.91,12.48,10.47,12.2,10,12 c0.58,0.43,1.37,1.37,2,2.6c0.67-1.62,1.68-3.27,3-4.6C14.24,10.52,13.53,11.12,12.87,11.81z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 face-6
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10c5.52,0,10-4.48,10-10S17.52,2,12,2z M12,20c-4.41,0-8-3.59-8-8h2.62l2-4h6.76l2,4 H20C20,16.41,16.41,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "15", :stroke nil, :fill nil})))))


(helix.core/defnc
 female
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17.5,9.5C17.5,6.46,15.04,4,12,4S6.5,6.46,6.5,9.5c0,2.7,1.94,4.93,4.5,5.4V17H9v2h2v2h2v-2h2v-2h-2v-2.1 C15.56,14.43,17.5,12.2,17.5,9.5z M8.5,9.5C8.5,7.57,10.07,6,12,6s3.5,1.57,3.5,3.5S13.93,13,12,13S8.5,11.43,8.5,9.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 vaccines
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,5.5H8V4h1.5V2h-5v2H6v1.5H2v2c0,0,0.45,0,1,0V17h3v4l2,1.5V17h3V7.5c0.55,0,1,0,1,0V5.5z M9,9H6.5v1.5H9V12H6.5v1.5H9 L9,15H5V7.5h4V9z M19.5,10.5V10h1V8h-7l-0.01,2h1.01v0.5c0,0.5-1.5,1.16-1.5,3V22h8v-8.5C21,11.66,19.5,11,19.5,10.5z M16.5,10.5V10 h1v0.5c0,1.6,1.5,2,1.5,3V14h-4c0-0.21,0-0.39,0-0.5C15,12.5,16.5,12.1,16.5,10.5z M15,20c0,0,0-0.63,0-1.5h4V20H15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pages
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 3v8h5L7 7l4 1V3H3zm5 10H3v8h8v-5l-4 1 1-4zm9 4l-4-1v5h8v-8h-5l1 4zm4-14h-8v5l4-1-1 4h5V3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 school
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 13.18v4L12 21l7-3.82v-4L12 17l-7-3.82zM12 3 1 9l11 6 9-4.91V17h2V9L12 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 domain
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cyclone
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,8c-2.21,0-4,1.79-4,4c0,2.21,1.79,4,4,4c2.21,0,4-1.79,4-4C16,9.79,14.21,8,12,8z M12,14c-1.1,0-2-0.9-2-2 c0-1.1,0.9-2,2-2s2,0.9,2,2C14,13.1,13.1,14,12,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,7.47V5.35C20.05,4.77,16.56,4,12,4C9.85,4,7.89,4.86,6.46,6.24C6.59,5.39,6.86,3.84,7.47,2H5.35 C4.77,3.95,4,7.44,4,12c0,2.15,0.86,4.11,2.24,5.54c-0.85-0.14-2.4-0.4-4.24-1.01v2.12C3.95,19.23,7.44,20,12,20 c2.15,0,4.11-0.86,5.54-2.24c-0.14,0.85-0.4,2.4-1.01,4.24h2.12C19.23,20.05,20,16.56,20,12c0-2.15-0.86-4.11-2.24-5.54 C18.61,6.59,20.16,6.86,22,7.47z M12,18c-3.31,0-6-2.69-6-6s2.69-6,6-6s6,2.69,6,6S15.31,18,12,18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 interests
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M7.02,13c-2.21,0-4,1.79-4,4s1.79,4,4,4s4-1.79,4-4S9.23,13,7.02,13z M13,13v8h8v-8H13z M7,2l-5,9h10L7,2z M19.25,2.5 c-1.06,0-1.81,0.56-2.25,1.17c-0.44-0.61-1.19-1.17-2.25-1.17C13.19,2.5,12,3.78,12,5.25c0,2,2.42,3.42,5,5.75 c2.58-2.33,5-3.75,5-5.75C22,3.78,20.81,2.5,19.25,2.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 health-and-safety
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M10.5,13H8v-3h2.5V7.5h3V10H16v3h-2.5v2.5h-3V13z M12,2L4,5v6.09c0,5.05,3.41,9.76,8,10.91c4.59-1.15,8-5.86,8-10.91V5L12,2 z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 emoji-objects
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,3c-0.42,0-0.85,0.04-1.28,0.11c-2.81,0.5-5.08,2.75-5.6,5.55c-0.48,2.61,0.48,5.01,2.22,6.56 C7.77,15.6,8,16.13,8,16.69C8,18.21,8,21,8,21h2.28c0.35,0.6,0.98,1,1.72,1s1.38-0.4,1.72-1H16v-4.31c0-0.55,0.22-1.09,0.64-1.46 C18.09,13.95,19,12.08,19,10C19,6.13,15.87,3,12,3z M14,19h-4v-1h4V19z M14,17h-4v-1h4V17z M12.5,11.41V14h-1v-2.59L9.67,9.59 l0.71-0.71L12,10.5l1.62-1.62l0.71,0.71L12.5,11.41z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 emoji-food-beverage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "19",
      :x "2",
      :width "18",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,3H9v2.4L11,7v5H6V7l2-1.6V3H4v14h14v-7h2c1.1,0,2-0.9,2-2V5C22,3.9,21.1,3,20,3z M20,8h-2V5h2V8z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 volcano
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "18,8 11,8 9,13 6,13 2,22 22,22",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/rect
      {:y "1",
       :x "13",
       :width "2",
       :height "4",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/rect
      {:y "3.76",
       :x "16.24",
       :width "4",
       :transform
       "matrix(0.7071 -0.7071 0.7071 0.7071 1.9792 14.2929)",
       :height "2",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/rect
      {:y "2.76",
       :x "8.76",
       :width "2",
       :transform
       "matrix(0.7071 -0.7071 0.7071 0.7071 -0.5061 8.2929)",
       :height "4",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 ice-skating
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,17c0,1.66-1.34,3-3,3h-2v-2h3l-0.01-6l-5.71-1.43C12.4,10.35,11.7,9.76,11.32,9H8V8h3.02L11,7H8V6h3V3H3v15h3v2H2v2h16 c2.76,0,5-2.24,5-5H21z M14,20H8v-2h6V20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 remove-moderator
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,11.09V5l-8-3L6.78,3.96l12.09,12.09C19.59,14.52,20,12.83,20,11.09z M2.81,2.81L1.39,4.22L4,6.83v4.26 c0,5.05,3.41,9.76,8,10.91c1.72-0.43,3.28-1.36,4.55-2.62l3.23,3.23l1.41-1.41L2.81,2.81z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 thunderstorm
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.92,7.02C17.45,4.18,14.97,2,12,2C9.82,2,7.83,3.18,6.78,5.06C4.09,5.41,2,7.74,2,10.5C2,13.53,4.47,16,7.5,16h10 c2.48,0,4.5-2.02,4.5-4.5C22,9.16,20.21,7.23,17.92,7.02z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "14.8,17 11.9,20.32 13.9,21.32 11.55,24 14.2,24 17.1,20.68 15.1,19.68 17.45,17",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8.8,17 5.9,20.32 7.9,21.32 5.55,24 8.2,24 11.1,20.68 9.1,19.68 11.45,17",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 engineering
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M9,15c-2.67,0-8,1.34-8,4v2h16v-2C17,16.34,11.67,15,9,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.75,8H13c0-1.48-0.81-2.75-2-3.45V5.5C11,5.78,10.78,6,10.5,6S10,5.78,10,5.5V4.14C9.68,4.06,9.35,4,9,4 S8.32,4.06,8,4.14V5.5C8,5.78,7.78,6,7.5,6S7,5.78,7,5.5V4.55C5.81,5.25,5,6.52,5,8H4.25v1h9.5V8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M9,13c1.86,0,3.41-1.28,3.86-3H5.14C5.59,11.72,7.14,13,9,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.98,6.23l0.93-0.83l-0.75-1.3l-1.19,0.39c-0.14-0.11-0.3-0.2-0.47-0.27L20.25,3h-1.5L18.5,4.22 c-0.17,0.07-0.33,0.16-0.48,0.27L16.84,4.1l-0.75,1.3l0.93,0.83C17,6.4,17,6.58,17.02,6.75L16.09,7.6l0.75,1.3l1.2-0.38 c0.13,0.1,0.28,0.18,0.43,0.25L18.75,10h1.5l0.27-1.22c0.16-0.07,0.3-0.15,0.44-0.25l1.19,0.38l0.75-1.3l-0.93-0.85 C22,6.57,21.99,6.4,21.98,6.23z M19.5,7.75c-0.69,0-1.25-0.56-1.25-1.25s0.56-1.25,1.25-1.25s1.25,0.56,1.25,1.25 S20.19,7.75,19.5,7.75z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.4,10.79l-0.85,0.28c-0.1-0.08-0.21-0.14-0.33-0.19L18.04,10h-1.07l-0.18,0.87c-0.12,0.05-0.24,0.12-0.34,0.19 l-0.84-0.28l-0.54,0.93l0.66,0.59c-0.01,0.13-0.01,0.25,0,0.37l-0.66,0.61l0.54,0.93l0.86-0.27c0.1,0.07,0.2,0.13,0.31,0.18 L16.96,15h1.07l0.19-0.87c0.11-0.05,0.22-0.11,0.32-0.18l0.85,0.27l0.54-0.93l-0.66-0.61c0.01-0.13,0.01-0.25,0-0.37l0.66-0.59 L19.4,10.79z M17.5,13.39c-0.49,0-0.89-0.4-0.89-0.89c0-0.49,0.4-0.89,0.89-0.89s0.89,0.4,0.89,0.89 C18.39,12.99,17.99,13.39,17.5,13.39z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 person-add-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M15.39,14.56C13.71,13.7,11.53,13,9,13c-2.53,0-4.71,0.7-6.39,1.56C1.61,15.07,1,16.1,1,17.22V20h16v-2.78 C17,16.1,16.39,15.07,15.39,14.56z M9,12c2.21,0,4-1.79,4-4c0-2.21-1.79-4-4-4S5,5.79,5,8C5,10.21,6.79,12,9,12z M20,9V6h-2v3h-3v2 h3v3h2v-3h3V9H20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 snowshoeing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12.5,3.5c0-1.1,0.9-2,2-2s2,0.9,2,2c0,1.1-0.9,2-2,2S12.5,4.6,12.5,3.5z M6.32,19.03l-1.14-1.47L4,18.5l2.38,3.04 c0.51,0.65,1.16,1.15,1.88,1.41c0.28,0.1,0.53,0.04,0.72-0.11c0.3-0.23,0.42-0.7,0.12-1.07c-0.08-0.1-0.2-0.17-0.31-0.22 c-0.43-0.18-0.82-0.45-1.14-0.83l-0.08-0.1L11,18.2l0.89-3.22l2.11,2v4.52h-2V23h3.87c0.82,0,1.61-0.21,2.26-0.61 c0.26-0.16,0.37-0.39,0.37-0.64c0-0.38-0.3-0.75-0.77-0.75c-0.13,0-0.26,0.04-0.37,0.1c-0.4,0.23-0.87,0.37-1.36,0.4l0-6.02l-2.11-2 l0.6-3C15.79,11.98,17.8,13,20,13v-2c-1.9,0-3.51-1.02-4.31-2.42l-1-1.58c-0.4-0.6-1-1-1.7-1C12.24,6,11.58,6.34,7,8.28V13h2V9.58 l1.79-0.7L9.2,17L6.32,19.03z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 emoji-transportation
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20.57,10.66C20.43,10.26,20.05,10,19.6,10h-7.19c-0.46,0-0.83,0.26-0.98,0.66L10,14.77l0.01,5.51 c0,0.38,0.31,0.72,0.69,0.72h0.62C11.7,21,12,20.62,12,20.24V19h8v1.24c0,0.38,0.31,0.76,0.69,0.76h0.61 c0.38,0,0.69-0.34,0.69-0.72L22,18.91v-4.14L20.57,10.66z M12.41,11h7.19l1.03,3h-9.25L12.41,11z M12,17c-0.55,0-1-0.45-1-1 s0.45-1,1-1s1,0.45,1,1S12.55,17,12,17z M20,17c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S20.55,17,20,17z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "14,9 15,9 15,3 7,3 7,8 2,8 2,21 3,21 3,9 8,9 8,4 14,4",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "11",
      :x "5",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "5",
      :x "10",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "15",
      :x "5",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "19",
      :x "5",
      :width "2",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 notifications
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 22c1.1 0 2-.9 2-2h-4c0 1.1.89 2 2 2zm6-6v-5c0-3.07-1.64-5.64-4.5-6.32V2.5h-3v2.18C7.63 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 travel-explore
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19.3,16.9c0.4-0.7,0.7-1.5,0.7-2.4c0-2.5-2-4.5-4.5-4.5S11,12,11,14.5s2,4.5,4.5,4.5c0.9,0,1.7-0.3,2.4-0.7l3.2,3.2 l1.4-1.4L19.3,16.9z M15.5,17c-1.4,0-2.5-1.1-2.5-2.5s1.1-2.5,2.5-2.5s2.5,1.1,2.5,2.5S16.9,17,15.5,17z M12,20v2 C6.48,22,2,17.52,2,12C2,6.48,6.48,2,12,2c4.84,0,8.87,3.44,9.8,8h-2.07c-0.64-2.46-2.4-4.47-4.73-5.41V5c0,1.1-0.9,2-2,2h-2v2 c0,0.55-0.45,1-1,1H8v2h2v3H9l-4.79-4.79C4.08,10.79,4,11.38,4,12C4,16.41,7.59,20,12,20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cruelty-free
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M16.84,14.52c-0.26-0.19-0.62-0.63-0.79-0.84C17.24,12.01,19,8.87,19,5c0-1.95-0.74-3-2-3c-1.54,0-3.96,2.06-5,5.97 C10.96,4.06,8.54,2,7,2C5.74,2,5,3.05,5,5c0,3.87,1.76,7.01,2.95,8.68c-0.17,0.21-0.53,0.65-0.79,0.84 c-0.5,0.41-1.66,1.37-1.66,2.98c0,2.21,1.79,4,4,4c1.55,0,2.5-0.56,2.5-0.56s0.95,0.56,2.5,0.56c2.21,0,4-1.79,4-4 C18.5,15.89,17.34,14.93,16.84,14.52z M9.35,12.2C8.34,10.7,7,8.12,7,5c0-0.49,0.06-0.8,0.12-0.97c0.94,0.31,3.24,2.71,3.38,7.64 C10.03,11.79,9.66,11.97,9.35,12.2z M10.5,16.75c-0.28,0-0.5-0.34-0.5-0.75c0-0.41,0.22-0.75,0.5-0.75S11,15.59,11,16 C11,16.41,10.78,16.75,10.5,16.75z M12,19.5c-0.55,0-1-0.72-1-1c0-0.28,0.45-0.5,1-0.5s1,0.22,1,0.5C13,18.78,12.55,19.5,12,19.5z M13.5,16.75c-0.28,0-0.5-0.34-0.5-0.75c0-0.41,0.22-0.75,0.5-0.75S14,15.59,14,16C14,16.41,13.78,16.75,13.5,16.75z M13.5,11.67 c0.14-4.93,2.44-7.33,3.38-7.64C16.94,4.2,17,4.51,17,5c0,3.12-1.34,5.7-2.35,7.2C14.34,11.97,13.97,11.79,13.5,11.67z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 masks
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19.5,6c-1.31,0-2.37,1.01-2.48,2.3C15.14,7.8,14.18,6.5,12,6.5c-2.19,0-3.14,1.3-5.02,1.8C6.87,7.02,5.81,6,4.5,6 C3.12,6,2,7.12,2,8.5V9c0,6,3.6,7.81,6.52,7.98C9.53,17.62,10.72,18,12,18s2.47-0.38,3.48-1.02C18.4,16.81,22,15,22,9V8.5 C22,7.12,20.88,6,19.5,6z M3.5,9V8.5c0-0.55,0.45-1,1-1s1,0.45,1,1v3c0,1.28,0.38,2.47,1.01,3.48C4.99,14.27,3.5,12.65,3.5,9z M20.5,9c0,3.65-1.49,5.27-3.01,5.98c0.64-1.01,1.01-2.2,1.01-3.48v-3c0-0.55,0.45-1,1-1s1,0.45,1,1V9z M10.69,10.48 c-0.44,0.26-0.96,0.56-1.69,0.76V10.2c0.48-0.17,0.84-0.38,1.18-0.58C10.72,9.3,11.23,9,12,9s1.27,0.3,1.8,0.62 c0.34,0.2,0.71,0.42,1.2,0.59v1.04c-0.75-0.21-1.26-0.51-1.71-0.78C12.83,10.2,12.49,10,12,10C11.51,10,11.16,10.2,10.69,10.48z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 whatsapp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19.05,4.91C17.18,3.03,14.69,2,12.04,2c-5.46,0-9.91,4.45-9.91,9.91c0,1.75,0.46,3.45,1.32,4.95L2.05,22l5.25-1.38 c1.45,0.79,3.08,1.21,4.74,1.21h0c0,0,0,0,0,0c5.46,0,9.91-4.45,9.91-9.91C21.95,9.27,20.92,6.78,19.05,4.91z M12.04,20.15 L12.04,20.15c-1.48,0-2.93-0.4-4.2-1.15l-0.3-0.18l-3.12,0.82l0.83-3.04l-0.2-0.31c-0.82-1.31-1.26-2.83-1.26-4.38 c0-4.54,3.7-8.24,8.24-8.24c2.2,0,4.27,0.86,5.82,2.42c1.56,1.56,2.41,3.63,2.41,5.83C20.28,16.46,16.58,20.15,12.04,20.15z M16.56,13.99c-0.25-0.12-1.47-0.72-1.69-0.81c-0.23-0.08-0.39-0.12-0.56,0.12c-0.17,0.25-0.64,0.81-0.78,0.97 c-0.14,0.17-0.29,0.19-0.54,0.06c-0.25-0.12-1.05-0.39-1.99-1.23c-0.74-0.66-1.23-1.47-1.38-1.72c-0.14-0.25-0.02-0.38,0.11-0.51 c0.11-0.11,0.25-0.29,0.37-0.43c0.12-0.14,0.17-0.25,0.25-0.41c0.08-0.17,0.04-0.31-0.02-0.43c-0.06-0.12-0.56-1.34-0.76-1.84 c-0.2-0.48-0.41-0.42-0.56-0.43C8.86,7.33,8.7,7.33,8.53,7.33c-0.17,0-0.43,0.06-0.66,0.31C7.65,7.89,7.01,8.49,7.01,9.71 c0,1.22,0.89,2.4,1.01,2.56c0.12,0.17,1.75,2.67,4.23,3.74c0.59,0.26,1.05,0.41,1.41,0.52c0.59,0.19,1.13,0.16,1.56,0.1 c0.48-0.07,1.47-0.6,1.67-1.18c0.21-0.58,0.21-1.07,0.14-1.18S16.81,14.11,16.56,13.99z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 deck
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "22,9 12,2 2,9 11,9 11,22 13,22 13,9",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "4.14,12 2.18,12.37 3,16.74 3,22 5,22 5.02,18 7,18 7,22 9,22 9,16 4.9,16",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "19.1,16 15,16 15,22 17,22 17,18 18.98,18 19,22 21,22 21,16.74 21.82,12.37 19.86,12",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 psychology-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.94,9.06C19.5,5.73,16.57,3,13,3C9.47,3,6.57,5.61,6.08,9l-1.93,3.48C3.74,13.14,4.22,14,5,14h1l0,4h3v3h7l0-4.68 C18.62,15.07,20.35,12.24,19.94,9.06z M12.5,14c-0.41,0-0.74-0.33-0.74-0.74c0-0.41,0.33-0.73,0.74-0.73 c0.41,0,0.73,0.32,0.73,0.73C13.23,13.67,12.92,14,12.5,14z M14.26,9.68c-0.44,0.65-0.86,0.85-1.09,1.27 c-0.09,0.17-0.13,0.28-0.13,0.82h-1.06c0-0.29-0.04-0.75,0.18-1.16c0.28-0.51,0.83-0.81,1.14-1.26c0.33-0.47,0.15-1.36-0.8-1.36 c-0.62,0-0.92,0.47-1.05,0.86l-0.96-0.4C10.76,7.67,11.46,7,12.5,7c0.86,0,1.45,0.39,1.75,0.88C14.51,8.31,14.66,9.1,14.26,9.68z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 transgender
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,8c1.93,0,3.5,1.57,3.5,3.5S13.93,15,12,15s-3.5-1.57-3.5-3.5S10.07,8,12,8z M16.53,8.38l3.97-3.96V7h2V1h-6v2h2.58 l-3.97,3.97C14.23,6.36,13.16,6,12,6c-1.16,0-2.23,0.36-3.11,0.97L8.24,6.32l1.41-1.41L8.24,3.49L6.82,4.9L4.92,3H7.5V1h-6v6h2V4.42 l1.91,1.9L3.99,7.74l1.41,1.41l1.41-1.41l0.65,0.65C6.86,9.27,6.5,10.34,6.5,11.5c0,2.7,1.94,4.94,4.5,5.41L11,19H9v2h2v2h2v-2h2v-2 h-2l0-2.09c2.56-0.47,4.5-2.71,4.5-5.41C17.5,10.34,17.14,9.27,16.53,8.38z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sports-motorsports
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,11.39c0-0.65-0.39-1.23-0.98-1.48L5.44,7.55c-1.48,1.68-2.32,3.7-2.8,5.45h7.75C11.28,13,12,12.28,12,11.39z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.96,11.22c-0.41-4.41-4.56-7.49-8.98-7.2c-2.51,0.16-4.44,0.94-5.93,2.04l4.74,2.01c1.33,0.57,2.2,1.87,2.2,3.32 c0,1.99-1.62,3.61-3.61,3.61H2.21C2,16.31,2,17.2,2,17.2V20h12C18.67,20,22.41,15.99,21.96,11.22z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cake
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 6c1.11 0 2-.9 2-2 0-.38-.1-.73-.29-1.03L12 0l-1.71 2.97c-.19.3-.29.65-.29 1.03 0 1.1.9 2 2 2zm4.53 9.92l-1-1-1.08 1.07c-1.3 1.3-3.58 1.31-4.89 0l-1.07-1.07-1.09 1.07C6.75 16.64 5.88 17 4.96 17c-.73 0-1.4-.23-1.96-.61V22h18v-5.61c-.75.51-1.71.75-2.74.52-.66-.14-1.25-.51-1.73-.99zM18 9h-5V7h-2v2H6c-1.66 0-3 1.34-3 3v1.54c0 1.08.88 1.96 1.96 1.96.52 0 1.02-.2 1.38-.57l2.14-2.13 2.13 2.13c.74.74 2.03.74 2.77 0l2.14-2.13 2.13 2.13c.37.37.86.57 1.38.57 1.08 0 1.96-.88 1.96-1.96V12C21 10.34 19.66 9 18 9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 edit-notifications
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17.58,6.25l1.77,1.77L14.37,13H12.6v-1.77L17.58,6.25z M20.85,5.81l-1.06-1.06c-0.2-0.2-0.51-0.2-0.71,0l-0.85,0.85 l1.77,1.77l0.85-0.85C21.05,6.32,21.05,6,20.85,5.81z M18,12.2V17h2v2H4v-2h2v-7c0-2.79,1.91-5.14,4.5-5.8V2h3v2.2 c0.82,0.21,1.57,0.59,2.21,1.09L10.6,10.4V15h4.6L18,12.2z M10,20h4c0,1.1-0.9,2-2,2S10,21.1,10,20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 social-distance
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M4,5c0-1.1,0.9-2,2-2s2,0.9,2,2c0,1.1-0.9,2-2,2S4,6.1,4,5z M8.78,8.58C7.93,8.21,6.99,8,6,8S4.07,8.21,3.22,8.58 C2.48,8.9,2,9.62,2,10.43L2,11h8l0-0.57C10,9.62,9.52,8.9,8.78,8.58z M18,7c1.1,0,2-0.9,2-2c0-1.1-0.9-2-2-2s-2,0.9-2,2 C16,6.1,16.9,7,18,7z M20.78,8.58C19.93,8.21,18.99,8,18,8c-0.99,0-1.93,0.21-2.78,0.58C14.48,8.9,14,9.62,14,10.43L14,11h8l0-0.57 C22,9.62,21.52,8.9,20.78,8.58z M22,17l-4-4v3H6v-3l-4,4l4,4v-3h12v3L22,17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 emoji-flags
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/path
    {:d
     "M14,9l-1-2H7V5.72C7.6,5.38,8,4.74,8,4c0-1.1-0.9-2-2-2S4,2.9,4,4c0,0.74,0.4,1.38,1,1.72V21h2v-4h5l1,2h7V9H14z M18,17h-4 l-1-2H7V9h5l1,2h5V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 poll
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M3 3v18h18V3H3zm6 14H7v-7h2v7zm4 0h-2V7h2v10zm4 0h-2v-4h2v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 woman
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "13.41,7 10.59,7 7,16 10,16 10,22 14,22 14,16 17,16",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 co2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15,9h-5v6h5V9z M13.5,13.5h-2v-3h2V13.5z M8,13v2H3V9h5v2H6.5v-0.5h-2v3h2V13H8z M18.5,15.5v1h3V18H17v-3.5h3v-1h-3V12h4.5 v3.5H18.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sports-basketball
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M17.09,11h4.86c-0.16-1.61-0.71-3.11-1.54-4.4C18.68,7.43,17.42,9.05,17.09,11z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M6.91,11C6.58,9.05,5.32,7.43,3.59,6.6C2.76,7.89,2.21,9.39,2.05,11H6.91z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M15.07,11c0.32-2.59,1.88-4.79,4.06-6c-1.6-1.63-3.74-2.71-6.13-2.95V11H15.07z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M8.93,11H11V2.05C8.61,2.29,6.46,3.37,4.87,5C7.05,6.21,8.61,8.41,8.93,11z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M15.07,13H13v8.95c2.39-0.24,4.54-1.32,6.13-2.95C16.95,17.79,15.39,15.59,15.07,13z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M3.59,17.4c1.72-0.83,2.99-2.46,3.32-4.4H2.05C2.21,14.61,2.76,16.11,3.59,17.4z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M17.09,13c0.33,1.95,1.59,3.57,3.32,4.4c0.83-1.29,1.38-2.79,1.54-4.4H17.09z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M8.93,13c-0.32,2.59-1.88,4.79-4.06,6c1.6,1.63,3.74,2.71,6.13,2.95V13H8.93z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 people-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 12c1.93 0 3.5-1.57 3.5-3.5S10.93 5 9 5 5.5 6.57 5.5 8.5 7.07 12 9 12zm0-5c.83 0 1.5.67 1.5 1.5S9.83 10 9 10s-1.5-.67-1.5-1.5S8.17 7 9 7zm0 6.75c-2.34 0-7 1.17-7 3.5V19h14v-1.75c0-2.33-4.66-3.5-7-3.5zM4.34 17c.84-.58 2.87-1.25 4.66-1.25s3.82.67 4.66 1.25H4.34zm11.7-3.19c1.16.84 1.96 1.96 1.96 3.44V19h4v-1.75c0-2.02-3.5-3.17-5.96-3.44zM15 12c1.93 0 3.5-1.57 3.5-3.5S16.93 5 15 5c-.54 0-1.04.13-1.5.35.63.89 1 1.98 1 3.15s-.37 2.26-1 3.15c.46.22.96.35 1.5.35z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 nights-stay
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M11.1 12.08c-2.33-4.51-.5-8.48.53-10.07C6.27 2.2 1.98 6.59 1.98 12c0 .14.02.28.02.42.62-.27 1.29-.42 2-.42 1.66 0 3.18.83 4.1 2.15 1.67.48 2.9 2.02 2.9 3.85 0 1.52-.87 2.83-2.12 3.51.98.32 2.03.5 3.11.5 3.5 0 6.58-1.8 8.37-4.52-2.36.23-6.98-.97-9.26-5.41z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M7 16h-.18C6.4 14.84 5.3 14 4 14c-1.66 0-3 1.34-3 3s1.34 3 3 3h3c1.1 0 2-.9 2-2s-.9-2-2-2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 hiking
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M13.5,5.5c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S12.4,5.5,13.5,5.5z M17.5,10.78c-1.23-0.37-2.22-1.17-2.8-2.18l-1-1.6 c-0.41-0.65-1.11-1-1.84-1c-0.78,0-1.59,0.5-1.78,1.44S7,23,7,23h2.1l1.8-8l2.1,2v6h2v-7.5l-2.1-2l0.6-3c1,1.15,2.41,2.01,4,2.34V23 H19V9h-1.5L17.5,10.78z M7.43,13.13l-3.1-0.6l1.34-6.87l3.13,0.61L7.43,13.13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 notification-add
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0",
    :x "0",
    :width "24",
    :height "24",
    :fill "none",
    :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10,20h4c0,1.1-0.9,2-2,2S10,21.1,10,20z M14,9c0,2.61,1.67,4.83,4,5.66L18,17h2v2H4v-2h2v-7c0-2.79,1.91-5.14,4.5-5.8V2 l3,0v2.2c0.71,0.18,1.36,0.49,1.95,0.9C14.54,6.14,14,7.51,14,9z M24,8h-3V5h-2v3h-3v2h3v3h2v-3h3V8z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 kitesurfing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6,3c0-1.1,0.9-2,2-2s2,0.9,2,2c0,1.1-0.9,2-2,2S6,4.1,6,3z M20.06,1h-2.12L15.5,3.44l1.06,1.06L20.06,1z M22,23v-2h-1 c-1.04,0-2.08-0.35-3-1c-1.83,1.3-4.17,1.3-6,0c-1.83,1.3-4.17,1.3-6,0c-0.91,0.65-1.96,1-3,1H2l0,2h1c1.03,0,2.05-0.25,3-0.75 c1.89,1,4.11,1,6,0c1.89,1,4.11,1,6,0h0c0.95,0.5,1.97,0.75,3,0.75H22z M21,13.28c0,1.44-2.19,3.62-5.04,5.58 C15.65,18.95,15.33,19,15,19c-1.2,0-2.27-0.66-3-1.5c-0.73,0.84-1.8,1.5-3,1.5c-0.94,0-1.81-0.41-2.49-0.99 c0.46-0.39,0.96-0.78,1.49-1.17L6,13V8c0-1.1,0.9-2,2-2h3c1.38,0,2.63-0.56,3.54-1.46l1.41,1.41C14.68,7.21,12.93,8,11,8H9.6l0,3.5 h2.8l1.69,1.88c1.95-0.84,3.77-1.38,5.06-1.38C19.99,12,21,12.25,21,13.28z M12.2,14.27l-0.7-0.77L9,13.6l0.83,2.01 C10.42,15.23,11.64,14.55,12.2,14.27z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 share
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92s2.92-1.31 2.92-2.92-1.31-2.92-2.92-2.92z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 notifications-active
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.58 4.08L6.15 2.65C3.75 4.48 2.17 7.3 2.03 10.5h2c.15-2.65 1.51-4.97 3.55-6.42zm12.39 6.42h2c-.15-3.2-1.73-6.02-4.12-7.85l-1.42 1.43c2.02 1.45 3.39 3.77 3.54 6.42zM18 11c0-3.07-1.64-5.64-4.5-6.32V2.5h-3v2.18C7.63 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2v-5zm-6 11c.14 0 .27-.01.4-.04.65-.14 1.18-.58 1.44-1.18.1-.24.15-.5.15-.78h-4c.01 1.1.9 2 2.01 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 question-answer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 6h-3v9H6v3h12l4 4V6zm-5 7V2H2v15l4-4h11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 gavel
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M1 21h12v2H1v-2zM5.24 8.07l2.83-2.83 14.14 14.14-2.83 2.83L5.24 8.07zM12.32 1l5.66 5.66-2.83 2.83-5.66-5.66L12.32 1zM3.83 9.48l5.66 5.66-2.83 2.83L1 12.31l2.83-2.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-shopping-cart
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.42 4l-3.87 7H8.53L4.27 2H1v2h2l3.6 7.59L3.62 17H19v-2H7l1.1-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 token
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19.97,6.43L12,2L4.03,6.43L9.1,9.24C9.83,8.48,10.86,8,12,8s2.17,0.48,2.9,1.24L19.97,6.43z M10,12c0-1.1,0.9-2,2-2 s2,0.9,2,2s-0.9,2-2,2S10,13.1,10,12z M11,21.44L3,17V8.14l5.13,2.85C8.04,11.31,8,11.65,8,12c0,1.86,1.27,3.43,3,3.87V21.44z M13,21.44v-5.57c1.73-0.44,3-2.01,3-3.87c0-0.35-0.04-0.69-0.13-1.01L21,8.14L21,17L13,21.44z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 swipe-down
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M3.8,12.18c-0.2-0.86-0.3-1.76-0.3-2.68c0-2.84,0.99-5.45,2.63-7.5L7.2,3.07C5.82,4.85,5,7.08,5,9.5 c0,0.88,0.11,1.74,0.32,2.56l1.62-1.62L8,11.5L4.5,15L1,11.5l1.06-1.06L3.8,12.18z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M21.71,11.18l2.09,7.39l-8.23,3.65l-6.84-2.85l0.61-1.62l3.8-0.75L8.79,7.17c-0.34-0.76,0-1.64,0.76-1.98 c0.76-0.34,1.64,0,1.98,0.76l2.43,5.49l1.26-0.56L21.71,11.18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 shopping-bag
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M20 6h-4c0-2.21-1.79-4-4-4S8 3.79 8 6H4v16h16V6zm-10 5H8V8h2v3zm2-7c1.1 0 2 .9 2 2h-4c0-1.1.9-2 2-2zm4 7h-2V8h2v3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 delete-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 21h12V7H6v14zM8 9h8v10H8V9zm7.5-5l-1-1h-5l-1 1H5v2h14V4h-3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 webhook
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10,15l5.88,0c0.27-0.31,0.67-0.5,1.12-0.5c0.83,0,1.5,0.67,1.5,1.5c0,0.83-0.67,1.5-1.5,1.5c-0.44,0-0.84-0.19-1.12-0.5 l-3.98,0c-0.46,2.28-2.48,4-4.9,4c-2.76,0-5-2.24-5-5c0-2.42,1.72-4.44,4-4.9l0,2.07C4.84,13.58,4,14.7,4,16c0,1.65,1.35,3,3,3 s3-1.35,3-3V15z M12.5,4c1.65,0,3,1.35,3,3h2c0-2.76-2.24-5-5-5l0,0c-2.76,0-5,2.24-5,5c0,1.43,0.6,2.71,1.55,3.62l-2.35,3.9 C6.02,14.66,5.5,15.27,5.5,16c0,0.83,0.67,1.5,1.5,1.5s1.5-0.67,1.5-1.5c0-0.16-0.02-0.31-0.07-0.45l3.38-5.63 C10.49,9.61,9.5,8.42,9.5,7C9.5,5.35,10.85,4,12.5,4z M17,13c-0.64,0-1.23,0.2-1.72,0.54l-3.05-5.07C11.53,8.35,11,7.74,11,7 c0-0.83,0.67-1.5,1.5-1.5S14,6.17,14,7c0,0.15-0.02,0.29-0.06,0.43l2.19,3.65C16.41,11.03,16.7,11,17,11l0,0c2.76,0,5,2.24,5,5 c0,2.76-2.24,5-5,5c-1.85,0-3.47-1.01-4.33-2.5l2.67,0C15.82,18.82,16.39,19,17,19c1.65,0,3-1.35,3-3S18.65,13,17,13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 highlight-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M17,5h-2V3h2V5z M19,3v2h2V3H19z M19,9h2V7h-2V9z M19,13h2v-2h-2V13z M11,21h2v-2h-2V21z M7,5h2V3H7V5z M3,5h2V3H3V5z M3,17h2v-2H3V17z M3,21h2v-2H3V21z M11,5h2V3h-2V5z M3,9h2V7H3V9z M7,21h2v-2H7V21z M3,13h2v-2H3V13z M15,15v6l2.29-2.29L19.59,21 L21,19.59l-2.29-2.29L21,15H15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 outbox
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "11,14 13,14 13,11 16,11 12,7 8,11 11,11",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,3v18h18V3H3z M19,14h-4.18c-0.41,1.16-1.51,2-2.82,2s-2.4-0.84-2.82-2H5V5h14V14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 commit
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16.9,11L16.9,11c-0.46-2.28-2.48-4-4.9-4s-4.44,1.72-4.9,4h0H2v2h5.1h0c0.46,2.28,2.48,4,4.9,4s4.44-1.72,4.9-4h0H22v-2 H16.9z M12,15c-1.66,0-3-1.34-3-3s1.34-3,3-3s3,1.34,3,3S13.66,15,12,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 density-large
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "3",
      :x "3",
      :width "18",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "19",
      :x "3",
      :width "18",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 search-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M15.5,14h-0.79l-0.28-0.27C15.41,12.59,16,11.11,16,9.5C16,5.91,13.09,3,9.5,3C6.08,3,3.28,5.64,3.03,9h2.02 C5.3,6.75,7.18,5,9.5,5C11.99,5,14,7.01,14,9.5S11.99,14,9.5,14c-0.17,0-0.33-0.03-0.5-0.05v2.02C9.17,15.99,9.33,16,9.5,16 c1.61,0,3.09-0.59,4.23-1.57L14,14.71v0.79l5,4.99L20.49,19L15.5,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "6.47,10.82 4,13.29 1.53,10.82 0.82,11.53 3.29,14 0.82,16.47 1.53,17.18 4,14.71 6.47,17.18 7.18,16.47 4.71,14 7.18,11.53",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 remove-shopping-cart
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M1.41 1.13L0 2.54l4.39 4.39 2.21 4.66L3.62 17h10.84l1.38 1.38c-.5.36-.83.95-.83 1.62 0 1.1.89 2 1.99 2 .67 0 1.26-.33 1.62-.84L21.46 24l1.41-1.41L1.41 1.13zM7 15l1.1-2h2.36l2 2H7zm9.05-2.06h.73L21.7 4H7.12l8.93 8.94zM7 18c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dashboard-customize
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M3,3h8v8H3V3z M13,3h8v8h-8V3z M3,13h8v8H3V13z M18,13h-2v3h-3v2h3v3h2v-3h3v-2h-3V13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 https
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 8h-3V6.21c0-2.61-1.91-4.94-4.51-5.19C9.51.74 7 3.08 7 6v2H4v14h16V8zm-8 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM9 8V6c0-1.66 1.34-3 3-3s3 1.34 3 3v2H9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 swap-horiz
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6.99 11L3 15l3.99 4v-3H14v-2H6.99v-3zM21 9l-3.99-4v3H10v2h7.01v3L21 9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 swipe-vertical
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M1,3.5h2.02C1.13,5.82,0,8.78,0,12s1.13,6.18,3.02,8.5H1V22h5v-5H4.5v2.91c-1.86-2.11-3-4.88-3-7.91s1.14-5.79,3-7.91V7H6 V2H1V3.5z M21.71,11.18l2.09,7.39l-8.23,3.65l-6.84-2.85l0.61-1.62l3.8-0.75L8.79,7.17c-0.34-0.76,0-1.64,0.76-1.98 c0.76-0.34,1.64,0,1.98,0.76l2.43,5.49l1.26-0.56L21.71,11.18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 join-inner
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/ellipse {:ry "5.74", :rx "3", :cy "12", :cx "12"})
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M9.04,16.87C8.71,16.95,8.36,17,8,17c-2.76,0-5-2.24-5-5s2.24-5,5-5c0.36,0,0.71,0.05,1.04,0.13 c0.39-0.56,0.88-1.12,1.49-1.63C9.75,5.19,8.9,5,8,5c-3.86,0-7,3.14-7,7s3.14,7,7,7c0.9,0,1.75-0.19,2.53-0.5 C9.92,17.99,9.43,17.43,9.04,16.87z",
      :stroke nil,
      :fill nil}))
   (helix.dom/path
    {:d
     "M16,5c-0.9,0-1.75,0.19-2.53,0.5c0.61,0.51,1.1,1.07,1.49,1.63C15.29,7.05,15.64,7,16,7c2.76,0,5,2.24,5,5s-2.24,5-5,5 c-0.36,0-0.71-0.05-1.04-0.13c-0.39,0.56-0.88,1.12-1.49,1.63C14.25,18.81,15.1,19,16,19c3.86,0,7-3.14,7-7S19.86,5,16,5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 settings-applications
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.11 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-1.75 9c0 .24-.02.47-.05.71l.01-.02 1.47 1.16c.14.1.23.18.23.18l-1.7 2.94-2.02-.8.02-.03c-.37.29-.77.53-1.21.71h.01l-.27 1.85c-.02.17-.04.3-.04.3h-3.4l-.31-2.15H10c-.44-.18-.84-.42-1.21-.71l.02.03-2.02.8-1.7-2.94s.1-.08.23-.18l1.47-1.16.01.02c-.03-.24-.05-.47-.05-.71s.02-.47.05-.69l-.01.01-1.7-1.34 1.7-2.95 2.01.81v.01c.37-.28.77-.52 1.2-.7h-.01L10.3 5h3.41l.3 2.15H14c.43.18.83.42 1.2.7v-.01l2.01-.81 1.7 2.95-1.71 1.34-.01-.01c.04.22.06.45.06.69z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2.45", :cy "12", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 settings
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.44 12.99l-.01.02c.04-.33.08-.67.08-1.01 0-.34-.03-.66-.07-.99l.01.02 2.44-1.92-2.43-4.22-2.87 1.16.01.01c-.52-.4-1.09-.74-1.71-1h.01L14.44 2H9.57l-.44 3.07h.01c-.62.26-1.19.6-1.71 1l.01-.01-2.88-1.17-2.44 4.22 2.44 1.92.01-.02c-.04.33-.07.65-.07.99 0 .34.03.68.08 1.01l-.01-.02-2.1 1.65-.33.26 2.43 4.2 2.88-1.15-.02-.04c.53.41 1.1.75 1.73 1.01h-.03L9.58 22h4.85s.03-.18.06-.42l.38-2.65h-.01c.62-.26 1.2-.6 1.73-1.01l-.02.04 2.88 1.15 2.43-4.2s-.14-.12-.33-.26l-2.11-1.66zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 home
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8h5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 thumb-down
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.83 23L17 15.82V3H4.69L1 11.6V16h8.31l-1.12 5.38zM19 3h4v12h-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 trending-up
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 6l2.29 2.29-4.88 4.88-4-4L2 16.59 3.41 18l6-6 4 4 6.3-6.29L22 12V6h-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 abc
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,11h-1.5v-0.5h-2v3h2V13H21v2h-5V9h5V11z M8,9v6H6.5v-1.5h-2V15H3V9H8z M6.5,10.5h-2V12h2V10.5z M13.5,12 c0.55,0,1,0.45,1,1v1c0,0.55-0.45,1-1,1h-4V9h4c0.55,0,1,0.45,1,1v1C14.5,11.55,14.05,12,13.5,12z M11,10.5v0.75h2V10.5H11z M13,12.75h-2v0.75h2V12.75z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 swipe-left-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10.1,13c0.46,2.28,2.48,4,4.9,4c2.76,0,5-2.24,5-5s-2.24-5-5-5c-2.42,0-4.44,1.72-4.9,4H5.83l1.59-1.59L6,8l-4,4l4,4 l1.41-1.41L5.83,13H10.1z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 plagiarism
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1.5", :cy "14.5", :cx "11.5", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M14,2H4v20h16V8L14,2z M15.04,19.45l-1.88-1.88c-1.33,0.71-3.01,0.53-4.13-0.59c-1.37-1.37-1.37-3.58,0-4.95 c1.37-1.37,3.58-1.37,4.95,0c1.12,1.12,1.31,2.8,0.59,4.13l1.88,1.88L15.04,19.45z M13,9V3.5L18.5,9H13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 app-blocking
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,8c-2.21,0-4,1.79-4,4c0,2.21,1.79,4,4,4s4-1.79,4-4C22,9.79,20.21,8,18,8z M15.5,12c0-1.38,1.12-2.5,2.5-2.5 c0.42,0,0.8,0.11,1.15,0.29l-3.36,3.36C15.61,12.8,15.5,12.42,15.5,12z M18,14.5c-0.42,0-0.8-0.11-1.15-0.29l3.36-3.36 c0.18,0.35,0.29,0.73,0.29,1.15C20.5,13.38,19.38,14.5,18,14.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M19,23v-6h-2v1H7V6h10v1h2V0.94L5,1v22H19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sensors
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M7.76,16.24C6.67,15.16,6,13.66,6,12s0.67-3.16,1.76-4.24l1.42,1.42C8.45,9.9,8,10.9,8,12c0,1.1,0.45,2.1,1.17,2.83 L7.76,16.24z M16.24,16.24C17.33,15.16,18,13.66,18,12s-0.67-3.16-1.76-4.24l-1.42,1.42C15.55,9.9,16,10.9,16,12 c0,1.1-0.45,2.1-1.17,2.83L16.24,16.24z M12,10c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S13.1,10,12,10z M20,12 c0,2.21-0.9,4.21-2.35,5.65l1.42,1.42C20.88,17.26,22,14.76,22,12s-1.12-5.26-2.93-7.07l-1.42,1.42C19.1,7.79,20,9.79,20,12z M6.35,6.35L4.93,4.93C3.12,6.74,2,9.24,2,12s1.12,5.26,2.93,7.07l1.42-1.42C4.9,16.21,4,14.21,4,12S4.9,7.79,6.35,6.35z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fit-screen
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,4h5v5h-2V6h-3V4z M4,9V6h3V4H2v5H4z M20,15v3h-3v2h5v-5H20z M7,18H4v-3H2v5h5V18z M18,8H6v8h12V8z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 reorder
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M3 15h18v-2H3v2zm0 4h18v-2H3v2zm0-8h18V9H3v2zm0-6v2h18V5H3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 view-stream
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M3,19v-6h18v6H3z M3,5v6h18V5H3z", :stroke nil, :fill nil})))


(helix.core/defnc
 compress
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "9",
      :x "4",
      :width "16",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "16,4 13,4 13,1 11,1 11,4 8,4 12,8",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "8,19 11,19 11,22 13,22 13,19 16,19 12,15",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12",
      :x "4",
      :width "16",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 build-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:fill-rule "evenodd",
      :d
      "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10 C22,6.48,17.52,2,12,2z M15.14,17.25l-3.76-3.76c-1.22,0.43-2.64,0.17-3.62-0.81c-1.11-1.11-1.3-2.79-0.59-4.1l2.35,2.35 l1.41-1.41L8.58,7.17c1.32-0.71,2.99-0.52,4.1,0.59c0.98,0.98,1.24,2.4,0.81,3.62l3.76,3.76L15.14,17.25z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 join-full
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/ellipse {:ry "5.74", :rx "3", :cy "12", :cx "12"})
    (helix.dom/path
     {:d
      "M7.5,12c0-0.97,0.23-4.16,3.03-6.5C9.75,5.19,8.9,5,8,5c-3.86,0-7,3.14-7,7s3.14,7,7,7c0.9,0,1.75-0.19,2.53-0.5 C7.73,16.16,7.5,12.97,7.5,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,5c-0.9,0-1.75,0.19-2.53,0.5c2.8,2.34,3.03,5.53,3.03,6.5c0,0.97-0.23,4.16-3.03,6.5C14.25,18.81,15.1,19,16,19 c3.86,0,7-3.14,7-7S19.86,5,16,5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 addchart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M11,9h2v8h-2V9z M9,17v-6H7v6H9z M19,19H5V5h6V3H3v18h18v-8h-2V19z M15,13v4h2v-4H15z M19,5V2h-2v3h-3v2h3v3h2V7h3V5H19z",
     :stroke nil,
     :fill nil}))
  (helix.dom/g nil)))


(helix.core/defnc
 thumb-down-off-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "3",
      :x "19",
      :width "4",
      :height "12",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1,11.6V16h8.31l-1.12,5.38L9.83,23L17,15.82V3H4.69L1,11.6z M15,5v9.99l-4.34,4.35l0.61-2.93l0.5-2.41H9.31H3v-1.99 L6.01,5H15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 disabled-by-default
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M3,3v18h18V3H3z M17,15.59L15.59,17L12,13.41L8.41,17L7,15.59L10.59,12L7,8.41L8.41,7L12,10.59L15.59,7L17,8.41L13.41,12 L17,15.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 settings-accessibility
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20.5,4c-2.61,0.7-5.67,1-8.5,1S6.11,4.7,3.5,4L3,6c1.86,0.5,4,0.83,6,1v12h2v-6h2v6h2V7c2-0.17,4.14-0.5,6-1L20.5,4z M12,4c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S10.9,4,12,4z M7,24h2v-2H7V24z M11,24h2v-2h-2V24z M15,24h2v-2h-2V24z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 g-translate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 5h-9.12L10 2H4c-1.1 0-2 .9-2 2v13c0 1.1.9 2 2 2h7l1 3h8c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zM7.17 14.59c-2.25 0-4.09-1.83-4.09-4.09s1.83-4.09 4.09-4.09c1.04 0 1.99.37 2.74 1.07l.07.06-1.23 1.18-.06-.05c-.29-.27-.78-.59-1.52-.59-1.31 0-2.38 1.09-2.38 2.42s1.07 2.42 2.38 2.42c1.37 0 1.96-.87 2.12-1.46H7.08V9.91h3.95l.01.07c.04.21.05.4.05.61 0 2.35-1.61 4-3.92 4zm6.03-1.71c.33.6.74 1.18 1.19 1.7l-.54.53-.65-2.23zm.77-.76h-.99l-.31-1.04h3.99s-.34 1.31-1.56 2.74c-.52-.62-.89-1.23-1.13-1.7zM21 20c0 .55-.45 1-1 1h-7l2-2-.81-2.77.92-.92L17.79 18l.73-.73-2.71-2.68c.9-1.03 1.6-2.25 1.92-3.51H19v-1.04h-3.64V9h-1.04v1.04h-1.96L11.18 6H20c.55 0 1 .45 1 1v13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 view-module
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14.67,5v6.5H9.33V5H14.67z M15.67,11.5H21V5h-5.33V11.5z M14.67,19v-6.5H9.33V19H14.67z M15.67,12.5V19H21v-6.5H15.67z M8.33,12.5H3V19h5.33V12.5z M8.33,11.5V5H3v6.5H8.33z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 view-list
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M3,14h4v-4H3V14z M3,19h4v-4H3V19z M3,9h4V5H3V9z M8,14h13v-4H8V14z M8,19h13v-4H8V19z M8,5v4h13V5H8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 help-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 settings-phone
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.21 17.37c-2.83-1.44-5.15-3.75-6.59-6.59l2.53-2.53L8.54 3H3.03C2.45 13.18 10.82 21.55 21 20.97v-5.51l-5.27-.61-2.52 2.52zM11 9h2v2h-2zm4 0h2v2h-2zm4 0h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 credit-card
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 4H2.01L2 20h20V4zm-2 14H4v-6h16v6zm0-10H4V6h16v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 contactless
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M8.46,14.45L7.1,13.83 c0.28-0.61,0.41-1.24,0.4-1.86c-0.01-0.63-0.14-1.24-0.4-1.8l1.36-0.63c0.35,0.75,0.53,1.56,0.54,2.4 C9.01,12.8,8.83,13.64,8.46,14.45z M11.53,16.01l-1.3-0.74c0.52-0.92,0.78-1.98,0.78-3.15c0-1.19-0.27-2.33-0.8-3.4l1.34-0.67 c0.64,1.28,0.96,2.65,0.96,4.07C12.51,13.55,12.18,14.86,11.53,16.01z M14.67,17.33l-1.35-0.66c0.78-1.6,1.18-3.18,1.18-4.69 c0-1.51-0.4-3.07-1.18-4.64l1.34-0.67C15.56,8.45,16,10.23,16,11.98C16,13.72,15.56,15.52,14.67,17.33z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 toc
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 9h14V7H3v2zm0 4h14v-2H3v2zm0 4h14v-2H3v2zm16 0h2v-2h-2v2zm0-10v2h2V7h-2zm0 6h2v-2h-2v2zM3 9h14V7H3v2zm0 4h14v-2H3v2zm0 4h14v-2H3v2zm16 0h2v-2h-2v2zm0-10v2h2V7h-2zm0 6h2v-2h-2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 upgrade
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d "M16,18v2H8v-2H16z M11,7.99V16h2V7.99h3L12,4L8,7.99H11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 expand
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M4,20h16v2H4V20z M4,2h16v2H4V2z M13,9h3l-4-4L8,9h3v6H8l4,4l4-4h-3V9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 drag-indicator
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 18c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2zm-2-8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0-6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm6 4c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 event-repeat
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,12V4h-3V2h-2v2H8V2H6v2H3v18h9v-2H5V10h14v2H21z M15.64,20c0.43,1.45,1.77,2.5,3.36,2.5c1.93,0,3.5-1.57,3.5-3.5 s-1.57-3.5-3.5-3.5c-0.95,0-1.82,0.38-2.45,1l1.45,0V18h-4v-4h1.5l0,1.43C16.4,14.55,17.64,14,19,14c2.76,0,5,2.24,5,5s-2.24,5-5,5 c-2.42,0-4.44-1.72-4.9-4L15.64,20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 schedule
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 highlight-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.59 8L12 10.59 9.41 8 8 9.41 10.59 12 8 14.59 9.41 16 12 13.41 14.59 16 16 14.59 13.41 12 16 9.41 14.59 8zM12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 task-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,5.18L10.59,16.6l-4.24-4.24l1.41-1.41l2.83,2.83l10-10L22,5.18z M19.79,10.22C19.92,10.79,20,11.39,20,12 c0,4.42-3.58,8-8,8s-8-3.58-8-8c0-4.42,3.58-8,8-8c1.58,0,3.04,0.46,4.28,1.25l1.44-1.44C16.1,2.67,14.13,2,12,2C6.48,2,2,6.48,2,12 c0,5.52,4.48,10,10,10s10-4.48,10-10c0-1.19-0.22-2.33-0.6-3.39L19.79,10.22z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 contact-support
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.5 2C6.81 2 3 5.81 3 10.5S6.81 19 11.5 19h.5v3c4.86-2.34 8-7 8-11.5C20 5.81 16.19 2 11.5 2zm1 14.5h-2v-2h2v2zm0-3.5h-2c0-3.25 3-3 3-5 0-1.1-.9-2-2-2s-2 .9-2 2h-2c0-2.21 1.79-4 4-4s4 1.79 4 4c0 2.5-3 2.75-3 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pregnant-woman
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 4c0-1.11.89-2 2-2s2 .89 2 2-.89 2-2 2-2-.89-2-2zm7 9c-.01-1.34-.83-2.51-2-3 0-1.66-1.34-3-3-3s-3 1.34-3 3v7h2v5h3v-5h3v-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tab-unselected
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M1 9h2V7H1v2zm0 4h2v-2H1v2zm8 8h2v-2H9v2zm-8-4h2v-2H1v2zm0 4h2v-2H1v2zM23 3H13v6h10V3zm-2 14h2v-2h-2v2zM9 5h2V3H9v2zM5 21h2v-2H5v2zM5 5h2V3H5v2zM1 5h2V3H1v2zm20 8h2v-2h-2v2zm-8 8h2v-2h-2v2zm4 0h2v-2h-2v2zm4 0h2v-2h-2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 watch-later
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.5,2,2,6.5,2,12s4.5,10,10,10s10-4.5,10-10S17.5,2,12,2z M16.2,16.2L11,13V7h1.5v5.2l4.5,2.7L16.2,16.2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 room
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 star-rate
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/polygon
    {:points
     "14.43,10 12,2 9.57,10 2,10 8.18,14.41 5.83,22 12,17.31 18.18,22 15.83,14.41 22,10",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 published-with-changes
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M17.66,9.53l-7.07,7.07l-4.24-4.24l1.41-1.41l2.83,2.83l5.66-5.66L17.66,9.53z M4,12c0-2.33,1.02-4.42,2.62-5.88L9,8.5v-6H3 l2.2,2.2C3.24,6.52,2,9.11,2,12c0,5.19,3.95,9.45,9,9.95v-2.02C7.06,19.44,4,16.07,4,12z M22,12c0-5.19-3.95-9.45-9-9.95v2.02 c3.94,0.49,7,3.86,7,7.93c0,2.33-1.02,4.42-2.62,5.88L15,15.5v6h6l-2.2-2.2C20.76,17.48,22,14.89,22,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 grading
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M4,7h16v2H4V7z M4,13h16v-2H4V13z M4,17h7v-2H4V17z M4,21h7v-2H4V21z M15.41,18.17L14,16.75l-1.41,1.41L15.41,21L20,16.42 L18.58,15L15.41,18.17z M4,3v2h16V3H4z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 lightbulb-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M12,19c-0.83,0-1.5-0.67-1.5-1.5h3 C13.5,18.33,12.83,19,12,19z M15,16.5H9V15h6V16.5z M14.97,14H9.03C7.8,13.09,7,11.64,7,10c0-2.76,2.24-5,5-5s5,2.24,5,5 C17,11.64,16.2,13.09,14.97,14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 perm-data-setting
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.99 11.5c.34 0 .67.03 1 .07L20 0 0 20h11.56c-.04-.33-.07-.66-.07-1 0-4.14 3.36-7.5 7.5-7.5zm3.71 7.99c.02-.16.04-.32.04-.49s-.01-.33-.04-.49l1.06-.83c.09-.08.12-.21.06-.32l-1-1.73c-.06-.11-.19-.15-.31-.11l-1.24.5c-.26-.2-.54-.37-.85-.49l-.19-1.32c-.01-.12-.12-.21-.24-.21h-2c-.12 0-.23.09-.25.21l-.19 1.32c-.3.13-.59.29-.85.49l-1.24-.5c-.11-.04-.24 0-.31.11l-1 1.73c-.06.11-.04.24.06.32l1.06.83c-.02.16-.03.32-.03.49s.01.33.03.49l-1.06.83c-.09.08-.12.21-.06.32l1 1.73c.06.11.19.15.31.11l1.24-.5c.26.2.54.37.85.49l.19 1.32c.02.12.12.21.25.21h2c.12 0 .23-.09.25-.21l.19-1.32c.3-.13.59-.29.84-.49l1.25.5c.11.04.24 0 .31-.11l1-1.73c.06-.11.03-.24-.06-.32l-1.07-.83zm-3.71 1.01c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pageview
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.5 9C10.12 9 9 10.12 9 11.5s1.12 2.5 2.5 2.5 2.5-1.12 2.5-2.5S12.88 9 11.5 9zM22 4H2v16h20V4zm-5.21 14.21l-2.91-2.91c-.69.44-1.51.7-2.39.7C9.01 16 7 13.99 7 11.5S9.01 7 11.5 7 16 9.01 16 11.5c0 .88-.26 1.69-.7 2.39l2.91 2.9-1.42 1.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 bookmark
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M19 3H5v18l7-3 7 3V3z", :stroke nil, :fill nil})))


(helix.core/defnc
 check-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pin-end
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20,12V6H4v12h10l0,2H2V4h20v8H20z M19,14c-1.66,0-3,1.34-3,3s1.34,3,3,3c1.66,0,3-1.34,3-3S20.66,14,19,14z M14.66,8H9 v5.66l2.12-2.12l2.83,2.83l1.41-1.41l-2.83-2.83L14.66,8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-present
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,2H4v20h16V8L14,2z M16,15c0,2.21-1.79,4-4,4s-4-1.79-4-4V9.5C8,8.12,9.12,7,10.5,7S13,8.12,13,9.5V15h-2V9.5 C11,9.22,10.78,9,10.5,9S10,9.22,10,9.5V15c0,1.1,0.9,2,2,2s2-0.9,2-2v-4h2V15z M14,8V4l4,4H14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 savings
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.83,7.5l-2.27-2.27c0.07-0.42,0.18-0.81,0.32-1.15c0.23-0.56,0.56-1.06,0.97-1.5C18.15,2.21,17.35,2,16.5,2 c-1.64,0-3.09,0.79-4,2l-5,0C4.46,4,2,6.46,2,9.5S4.5,21,4.5,21l5.5,0v-2h2v2l5.5,0l1.68-5.59L22,14.47V7.5H19.83z M13,9H8V7h5V9z M16,11c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C17,10.55,16.55,11,16,11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fingerprint
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.81 4.47c-.08 0-.16-.02-.23-.06C15.66 3.42 14 3 12.01 3c-1.98 0-3.86.47-5.57 1.41-.24.13-.54.04-.68-.2-.13-.24-.04-.55.2-.68C7.82 2.52 9.86 2 12.01 2c2.13 0 3.99.47 6.03 1.52.25.13.34.43.21.67-.09.18-.26.28-.44.28zM3.5 9.72c-.1 0-.2-.03-.29-.09-.23-.16-.28-.47-.12-.7.99-1.4 2.25-2.5 3.75-3.27C9.98 4.04 14 4.03 17.15 5.65c1.5.77 2.76 1.86 3.75 3.25.16.22.11.54-.12.7-.23.16-.54.11-.7-.12-.9-1.26-2.04-2.25-3.39-2.94-2.87-1.47-6.54-1.47-9.4.01-1.36.7-2.5 1.7-3.4 2.96-.08.14-.23.21-.39.21zm6.25 12.07c-.13 0-.26-.05-.35-.15-.87-.87-1.34-1.43-2.01-2.64-.69-1.23-1.05-2.73-1.05-4.34 0-2.97 2.54-5.39 5.66-5.39s5.66 2.42 5.66 5.39c0 .28-.22.5-.5.5s-.5-.22-.5-.5c0-2.42-2.09-4.39-4.66-4.39s-4.66 1.97-4.66 4.39c0 1.44.32 2.77.93 3.85.64 1.15 1.08 1.64 1.85 2.42.19.2.19.51 0 .71-.11.1-.24.15-.37.15zm7.17-1.85c-1.19 0-2.24-.3-3.1-.89-1.49-1.01-2.38-2.65-2.38-4.39 0-.28.22-.5.5-.5s.5.22.5.5c0 1.41.72 2.74 1.94 3.56.71.48 1.54.71 2.54.71.24 0 .64-.03 1.04-.1.27-.05.53.13.58.41.05.27-.13.53-.41.58-.57.11-1.07.12-1.21.12zM14.91 22c-.04 0-.09-.01-.13-.02-1.59-.44-2.63-1.03-3.72-2.1-1.4-1.39-2.17-3.24-2.17-5.22 0-1.62 1.38-2.94 3.08-2.94s3.08 1.32 3.08 2.94c0 1.07.93 1.94 2.08 1.94s2.08-.87 2.08-1.94c0-3.77-3.25-6.83-7.25-6.83-2.84 0-5.44 1.58-6.61 4.03-.39.81-.59 1.76-.59 2.8 0 .78.07 2.01.67 3.61.1.26-.03.55-.29.64-.26.1-.55-.04-.64-.29-.49-1.31-.73-2.61-.73-3.96 0-1.2.23-2.29.68-3.24 1.33-2.79 4.28-4.6 7.51-4.6 4.55 0 8.25 3.51 8.25 7.83 0 1.62-1.38 2.94-3.08 2.94s-3.08-1.32-3.08-2.94c0-1.07-.93-1.94-2.08-1.94s-2.08.87-2.08 1.94c0 1.71.66 3.31 1.87 4.51.95.94 1.86 1.46 3.27 1.85.27.07.42.35.35.61-.05.23-.26.38-.47.38z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 calendar-view-month
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,4H2v16h20V4z M8,11H4V6h4V11z M14,11h-4V6h4V11z M20,11h-4V6h4V11z M8,18H4v-5h4V18z M14,18h-4v-5h4V18z M20,18h-4v-5 h4V18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 extension
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.36 11H19V5h-6V3.64c0-1.31-.94-2.5-2.24-2.63C9.26.86 8 2.03 8 3.5V5H2.01v5.8H3.4c1.31 0 2.5.88 2.75 2.16.33 1.72-.98 3.24-2.65 3.24H2V22h5.8v-1.4c0-1.31.88-2.5 2.16-2.75 1.72-.33 3.24.98 3.24 2.65V22H19v-6h1.5c1.47 0 2.64-1.26 2.49-2.76-.13-1.3-1.33-2.24-2.63-2.24z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 credit-card-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.83,4H22v15.17L14.83,12H20V8h-9.17L6.83,4z M20.49,23.31L17.17,20H2V4.83L0.69,3.51L2.1,2.1l19.8,19.8L20.49,23.31z M9.17,12l-4-4H4v4H9.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 visibility-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none",
    :d "M0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0z",
    :stroke nil})
  (helix.dom/path
   {:d
    "M12 6.5c2.76 0 5 2.24 5 5 0 .51-.1 1-.24 1.46l3.06 3.06c1.39-1.23 2.49-2.77 3.18-4.53C21.27 7.11 17 4 12 4c-1.27 0-2.49.2-3.64.57l2.17 2.17c.47-.14.96-.24 1.47-.24zM3.42 2.45L2.01 3.87l2.68 2.68C3.06 7.83 1.77 9.53 1 11.5 2.73 15.89 7 19 12 19c1.52 0 2.97-.3 4.31-.82l3.43 3.43 1.41-1.41L3.42 2.45zM12 16.5c-2.76 0-5-2.24-5-5 0-.77.18-1.5.49-2.14l1.57 1.57c-.03.18-.06.37-.06.57 0 1.66 1.34 3 3 3 .2 0 .38-.03.57-.07L14.14 16c-.65.32-1.37.5-2.14.5zm2.97-5.33c-.15-1.4-1.25-2.49-2.64-2.64l2.64 2.64z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 rowing
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.5 14.5L4 19l1.5 1.5L9 17h2l-2.5-2.5zM15 1c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm6 20.01L18 24l-2.99-3.01V19.5l-7.1-7.09c-.31.05-.61.07-.91.07v-2.16c1.66.03 3.61-.87 4.67-2.04l1.4-1.55c.19-.21.43-.38.69-.5.29-.14.62-.23.96-.23h.03C15.99 6 17 7.01 17 8.25V17l-.92-.83-3.58-3.58v-2.27c-.63.52-1.43 1.02-2.29 1.39L16.5 18H18l3 3.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 perm-identity
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0-6c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zm0 7c-2.67 0-8 1.34-8 4v3h16v-3c0-2.66-5.33-4-8-4zm6 5H6v-.99c.2-.72 3.3-2.01 6-2.01s5.8 1.29 6 2v1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 alarm-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10.54 14.53L8.41 12.4l-1.06 1.06 3.18 3.18 6-6-1.06-1.06zm6.797-12.72l4.607 3.845-1.28 1.535-4.61-3.843zm-10.674 0l1.282 1.536L3.337 7.19l-1.28-1.536zM12 4c-4.97 0-9 4.03-9 9s4.03 9 9 9 9-4.03 9-9-4.03-9-9-9zm0 16c-3.86 0-7-3.14-7-7s3.14-7 7-7 7 3.14 7 7-3.14 7-7 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vertical-split
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 15h8v-2H3v2zm0 4h8v-2H3v2zm0-8h8V9H3v2zm0-6v2h8V5H3zm10 0h8v14h-8V5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 troubleshoot
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22,20.59l-4.69-4.69C18.37,14.55,19,12.85,19,11c0-4.42-3.58-8-8-8c-4.08,0-7.44,3.05-7.93,7h2.02C5.57,7.17,8.03,5,11,5 c3.31,0,6,2.69,6,6s-2.69,6-6,6c-2.42,0-4.5-1.44-5.45-3.5H3.4C4.45,16.69,7.46,19,11,19c1.85,0,3.55-0.63,4.9-1.69L20.59,22 L22,20.59z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "8.43,9.69 9.65,15 11.29,15 12.55,11.22 13.5,13.5 15.5,13.5 15.5,12 14.5,12 13.25,9 11.71,9 10.59,12.37 9.35,7 7.7,7 6.45,11 1,11 1,12.5 7.55,12.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 settings-brightness
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 3H1v18h22V3zm-2 16.01H3V4.99h18v14.02zM8 16h2.5l1.5 1.5 1.5-1.5H16v-2.5l1.5-1.5-1.5-1.5V8h-2.5L12 6.5 10.5 8H8v2.5L6.5 12 8 13.5V16zm4-7c1.66 0 3 1.34 3 3s-1.34 3-3 3V9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 settings-input-svideo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8 11.5c0-.83-.67-1.5-1.5-1.5S5 10.67 5 11.5 5.67 13 6.5 13 8 12.33 8 11.5zm7-5c0-.83-.67-1.5-1.5-1.5h-3C9.67 5 9 5.67 9 6.5S9.67 8 10.5 8h3c.83 0 1.5-.67 1.5-1.5zM8.5 15c-.83 0-1.5.67-1.5 1.5S7.67 18 8.5 18s1.5-.67 1.5-1.5S9.33 15 8.5 15zM12 1C5.93 1 1 5.93 1 12s4.93 11 11 11 11-4.93 11-11S18.07 1 12 1zm0 20c-4.96 0-9-4.04-9-9s4.04-9 9-9 9 4.04 9 9-4.04 9-9 9zm5.5-11c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm-2 5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fact-check
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:fill-rule "evenodd",
      :d
      "M2,3v18h20V3H2z M10,17H5v-2h5V17z M10,13H5v-2h5V13z M10,9H5V7h5V9z M14.82,15 L12,12.16l1.41-1.41l1.41,1.42L17.99,9l1.42,1.42L14.82,15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 settings-input-antenna
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5c-3.87 0-7 3.13-7 7h2c0-2.76 2.24-5 5-5s5 2.24 5 5h2c0-3.87-3.13-7-7-7zm1 9.29c.88-.39 1.5-1.26 1.5-2.29 0-1.38-1.12-2.5-2.5-2.5S9.5 10.62 9.5 12c0 1.02.62 1.9 1.5 2.29v3.3L7.59 21 9 22.41l3-3 3 3L16.41 21 13 17.59v-3.3zM12 1C5.93 1 1 5.93 1 12h2c0-4.97 4.03-9 9-9s9 4.03 9 9h2c0-6.07-4.93-11-11-11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 not-started
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M11,16H9V8h2V16z M12,16V8l5,4L12,16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 contact-page
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M14,2H4v20h16V8L14,2z M12,10c1.1,0,2,0.9,2,2c0,1.1-0.9,2-2,2s-2-0.9-2-2C10,10.9,10.9,10,12,10z M16,18H8v-0.57 c0-0.81,0.48-1.53,1.22-1.85C10.07,15.21,11.01,15,12,15c0.99,0,1.93,0.21,2.78,0.58C15.52,15.9,16,16.62,16,17.43V18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 settings-voice
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 24h2v-2H7v2zm5-11c1.66 0 2.99-1.34 2.99-3L15 4c0-1.66-1.34-3-3-3S9 2.34 9 4v6c0 1.66 1.34 3 3 3zm-1 11h2v-2h-2v2zm4 0h2v-2h-2v2zm4-14h-1.7c0 3-2.54 5.1-5.3 5.1S6.7 13 6.7 10H5c0 3.41 2.72 6.23 6 6.72V20h2v-3.28c3.28-.49 6-3.31 6-6.72z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 update
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M11,8v5l4.25,2.52l0.77-1.28l-3.52-2.09V8H11z M21,10V3l-2.64,2.64C16.74,4.01,14.49,3,12,3c-4.97,0-9,4.03-9,9 s4.03,9,9,9s9-4.03,9-9h-2c0,3.86-3.14,7-7,7s-7-3.14-7-7s3.14-7,7-7c1.93,0,3.68,0.79,4.95,2.05L14,10H21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 app-shortcut
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "17,18 7,18 7,6 17,6 17,7 19,7 19,1 5,1 5,1 5,23 19,23 19,17 17,17",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "20.38,9.62 21,11 21.62,9.62 23,9 21.62,8.38 21,7 20.38,8.38 19,9",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "16,8 14.75,10.75 12,12 14.75,13.25 16,16 17.25,13.25 20,12 17.25,10.75",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "21,13 20.38,14.38 19,15 20.38,15.62 21,17 21.62,15.62 23,15 21.62,14.38",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 face-unlock
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10.25 13c0 .69-.56 1.25-1.25 1.25S7.75 13.69 7.75 13s.56-1.25 1.25-1.25 1.25.56 1.25 1.25zM15 11.75c-.69 0-1.25.56-1.25 1.25s.56 1.25 1.25 1.25 1.25-.56 1.25-1.25-.56-1.25-1.25-1.25zm7 .25c0 5.52-4.48 10-10 10S2 17.52 2 12 6.48 2 12 2s10 4.48 10 10zM10.66 4.12C12.06 6.44 14.6 8 17.5 8c.46 0 .91-.05 1.34-.12C17.44 5.56 14.9 4 12 4c-.46 0-.91.05-1.34.12zM4.42 9.47c1.71-.97 3.03-2.55 3.66-4.44C6.37 6 5.05 7.58 4.42 9.47zM20 12c0-.78-.12-1.53-.33-2.24-.7.15-1.42.24-2.17.24-3.13 0-5.92-1.44-7.76-3.69C8.69 8.87 6.6 10.88 4 11.86c.01.04 0 .09 0 .14 0 4.41 3.59 8 8 8s8-3.59 8-8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 label-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 12l-4.97-7H8.66l10.7 10.73zM2 4l1 1v14h14l2 2 1.41-1.41L3.44 2.62z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unfold-less-double
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "16.58,1.41 15.16,0 11.99,3.17 8.82,0 7.41,1.41 11.99,6",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "16.58,6.41 15.16,5 11.99,8.17 8.82,5 7.41,6.41 11.99,11",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "7.42,17.59 8.84,19 12.01,15.83 15.18,19 16.59,17.59 12.01,13",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "7.42,22.59 8.84,24 12.01,20.83 15.18,24 16.59,22.59 12.01,18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 delete
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M6 21h12V7H6v14zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 view-column
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14.67,5v14H9.33V5H14.67z M15.67,19H21V5h-5.33V19z M8.33,19V5H3v14H8.33z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 offline-bolt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2.02c-5.51 0-9.98 4.47-9.98 9.98s4.47 9.98 9.98 9.98 9.98-4.47 9.98-9.98S17.51 2.02 12 2.02zM11.48 20v-6.26H8L13 4v6.26h3.35L11.48 20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 view-array
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M21,5h-3v14h3V5z M17,5H7v14h10V5z M6,5H3v14h3V5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 perm-contact-calendar
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3h-3V1h-2v2H8V1H6v2H3v18h18V3zm-9 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm6 12H6v-1c0-2 4-3.1 6-3.1s6 1.1 6 3.1v1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unpublished
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21.19,21.19L2.81,2.81L1.39,4.22l2.27,2.27C2.61,8.07,2,9.96,2,12c0,5.52,4.48,10,10,10c2.04,0,3.93-0.61,5.51-1.66 l2.27,2.27L21.19,21.19z M10.59,16.6l-4.24-4.24l1.41-1.41l2.83,2.83l0.18-0.18l1.41,1.41L10.59,16.6z M13.59,10.76l-7.1-7.1 C8.07,2.61,9.96,2,12,2c5.52,0,10,4.48,10,10c0,2.04-0.61,3.93-1.66,5.51l-5.34-5.34l2.65-2.65l-1.41-1.41L13.59,10.76z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 swipe-up
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2.06,5.56L1,4.5L4.5,1L8,4.5L6.94,5.56L5.32,3.94C5.11,4.76,5,5.62,5,6.5c0,2.42,0.82,4.65,2.2,6.43L6.13,14 C4.49,11.95,3.5,9.34,3.5,6.5c0-0.92,0.1-1.82,0.3-2.68L2.06,5.56z M21.71,11.18l2.09,7.39l-8.23,3.65l-6.84-2.85l0.61-1.62 l3.8-0.75L8.79,7.17c-0.34-0.76,0-1.64,0.76-1.98c0.76-0.34,1.64,0,1.98,0.76l2.43,5.49l1.26-0.56L21.71,11.18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 visibility
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 4C7 4 2.73 7.11 1 11.5 2.73 15.89 7 19 12 19s9.27-3.11 11-7.5C21.27 7.11 17 4 12 4zm0 12.5c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 note-add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 2H4v20h16V8l-6-6zm2 14h-3v3h-2v-3H8v-2h3v-3h2v3h3v2zm-3-7V3.5L18.5 9H13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 lock-person
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16.43,11.18c1.26-0.29,2.47-0.21,3.57,0.12V8h-3V6.22c0-2.61-1.91-4.94-4.51-5.19C9.51,0.74,7,3.08,7,6v2H4v14h8.26 c-1.01-1.45-1.5-3.3-1.15-5.27C11.6,14,13.74,11.79,16.43,11.18z M8.9,6c0-1.71,1.39-3.1,3.1-3.1s3.1,1.39,3.1,3.1v2H8.9V6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,13c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,13,18,13z M18,15c0.83,0,1.5,0.67,1.5,1.5S18.83,18,18,18 s-1.5-0.67-1.5-1.5S17.17,15,18,15z M18,21c-1.03,0-1.94-0.52-2.48-1.32C16.25,19.26,17.09,19,18,19s1.75,0.26,2.48,0.68 C19.94,20.48,19.03,21,18,21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 face
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 11.75c-.69 0-1.25.56-1.25 1.25s.56 1.25 1.25 1.25 1.25-.56 1.25-1.25-.56-1.25-1.25-1.25zm6 0c-.69 0-1.25.56-1.25 1.25s.56 1.25 1.25 1.25 1.25-.56 1.25-1.25-.56-1.25-1.25-1.25zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8 0-.29.02-.58.05-.86 2.36-1.05 4.23-2.98 5.21-5.37C11.07 8.33 14.05 10 17.42 10c.78 0 1.53-.09 2.25-.26.21.71.33 1.47.33 2.26 0 4.41-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 verified
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M23,12l-2.44-2.79l0.34-3.69l-3.61-0.82L15.4,1.5L12,2.96L8.6,1.5L6.71,4.69L3.1,5.5L3.44,9.2L1,12l2.44,2.79l-0.34,3.7 l3.61,0.82L8.6,22.5l3.4-1.47l3.4,1.46l1.89-3.19l3.61-0.82l-0.34-3.69L23,12z M10.09,16.72l-3.8-3.81l1.48-1.48l2.32,2.33 l5.85-5.87l1.48,1.48L10.09,16.72z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 css
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9.5,15v-2H11v0.5h2v-1H9.5V9h5v2H13v-0.5h-2v1h3.5V15H9.5z M16,15h5v-3.5h-3.5v-1h2V11H21V9h-5v3.5h3.5v1h-2V13H16V15z M8,11V9H3v6h5v-2H6.5v0.5h-2v-3h2V11H8z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 today
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3h-3V1h-2v2H8V1H6v2H3v18h18V3zm-2 16H5V8h14v11zM7 10h5v5H7v-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 join-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/ellipse {:ry "5.74", :rx "3", :cy "12", :cx "12"}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M16.5,12c0,0.97-0.23,4.16-3.03,6.5C14.25,18.81,15.1,19,16,19c3.86,0,7-3.14,7-7s-3.14-7-7-7c-0.9,0-1.75,0.19-2.53,0.5 C16.27,7.84,16.5,11.03,16.5,12z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M8,19c0.9,0,1.75-0.19,2.53-0.5c-0.61-0.51-1.1-1.07-1.49-1.63C8.71,16.95,8.36,17,8,17c-2.76,0-5-2.24-5-5s2.24-5,5-5 c0.36,0,0.71,0.05,1.04,0.13c0.39-0.56,0.88-1.12,1.49-1.63C9.75,5.19,8.9,5,8,5c-3.86,0-7,3.14-7,7S4.14,19,8,19z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 data-thresholding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,3H3v18h18V3z M10.67,8.17l2,2l3.67-3.67l1.41,1.41L12.67,13l-2-2l-3,3l-1.41-1.41L10.67,8.17z M5,16h1.72L5,17.72V16z M5.84,19l3-3h1.83l-3,3H5.84z M9.8,19l3-3h1.62l-3,3H9.8z M13.53,19l3-3h1.62l-3,3H13.53z M19,19h-1.73L19,17.27V19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 manage-accounts
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10.67,13.02C10.45,13.01,10.23,13,10,13c-2.42,0-4.68,0.67-6.61,1.82C2.51,15.34,2,16.32,2,17.35V20h9.26 C10.47,18.87,10,17.49,10,16C10,14.93,10.25,13.93,10.67,13.02z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "4", :cy "8", :cx "10", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M20.75,16c0-0.22-0.03-0.42-0.06-0.63l1.14-1.01l-1-1.73l-1.45,0.49c-0.32-0.27-0.68-0.48-1.08-0.63L18,11h-2l-0.3,1.49 c-0.4,0.15-0.76,0.36-1.08,0.63l-1.45-0.49l-1,1.73l1.14,1.01c-0.03,0.21-0.06,0.41-0.06,0.63s0.03,0.42,0.06,0.63l-1.14,1.01 l1,1.73l1.45-0.49c0.32,0.27,0.68,0.48,1.08,0.63L16,21h2l0.3-1.49c0.4-0.15,0.76-0.36,1.08-0.63l1.45,0.49l1-1.73l-1.14-1.01 C20.72,16.42,20.75,16.22,20.75,16z M17,18c-1.1,0-2-0.9-2-2s0.9-2,2-2s2,0.9,2,2S18.1,18,17,18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 subtitles-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "6.83,4 14.83,12 20,12 20,14 16.83,14 22,19.17 22,4",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1.04,3.87L2,4.83V20h15.17l2.96,2.96l1.41-1.41L2.45,2.45L1.04,3.87z M4,12h4v2H4V12z M4,16h9.17L14,16.83V18H4V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 lock-reset
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M13,3c-4.97,0-9,4.03-9,9H1l4,4l4-4H6c0-3.86,3.14-7,7-7s7,3.14,7,7s-3.14,7-7,7c-1.9,0-3.62-0.76-4.88-1.99L6.7,18.42 C8.32,20.01,10.55,21,13,21c4.97,0,9-4.03,9-9S17.97,3,13,3z M15,11v-1c0-1.1-0.9-2-2-2s-2,0.9-2,2v1h-1v5h6v-5H15z M14,11h-2v-1 c0-0.55,0.45-1,1-1s1,0.45,1,1V11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flaky
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:fill-rule "evenodd",
     :d
     "M14.05,17.58l-0.01,0.01l-2.4-2.4l1.06-1.06l1.35,1.35L16.54,13l1.06,1.06 l-3.54,3.54L14.05,17.58z M12,2C6.5,2,2,6.5,2,12s4.5,10,10,10s10-4.5,10-10S17.5,2,12,2z M7.34,6.28l1.41,1.41l1.41-1.41 l1.06,1.06L9.81,8.75l1.41,1.41l-1.06,1.06L8.75,9.81l-1.41,1.41l-1.06-1.06l1.41-1.41L6.28,7.34L7.34,6.28z M12,20 c-2.2,0-4.2-0.9-5.7-2.3L17.7,6.3C19.1,7.8,20,9.8,20,12C20,16.4,16.4,20,12,20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 translate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.87 15.07l-2.54-2.51.03-.03c1.74-1.94 2.98-4.17 3.71-6.53H17V4h-7V2H8v2H1v1.99h11.17C11.5 7.92 10.44 9.75 9 11.35 8.07 10.32 7.3 9.19 6.69 8h-2c.73 1.63 1.73 3.17 2.98 4.56l-5.09 5.02L4 19l5-5 3.11 3.11.76-2.04zM18.5 10h-2L12 22h2l1.12-3h4.75L21 22h2l-4.5-12zm-2.62 7l1.62-4.33L19.12 17h-3.24z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 settings-ethernet
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.77 6.76L6.23 5.48.82 12l5.41 6.52 1.54-1.28L3.42 12l4.35-5.24zM7 13h2v-2H7v2zm10-2h-2v2h2v-2zm-6 2h2v-2h-2v2zm6.77-7.52l-1.54 1.28L20.58 12l-4.35 5.24 1.54 1.28L23.18 12l-5.41-6.52z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 lock-open
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 8h-3V6.21c0-2.61-1.91-4.94-4.51-5.19C9.51.74 7 3.08 7 6h2c0-1.13.6-2.24 1.64-2.7C12.85 2.31 15 3.9 15 6v2H4v14h16V8zm-2 12H6V10h12v10zm-6-3c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 input
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/g
   {:fill "none"}
   (helix.dom/path {:d "M0 0h24v24H0V0z", :stroke nil, :fill nil})
   (helix.dom/path
    {:opacity ".87", :d "M0 0h24v24H0V0z", :stroke nil, :fill nil}))
  (helix.dom/path
   {:d
    "M21 3.01H3c-1.1 0-2 .9-2 2V9h2V4.99h18v14.03H3V15H1v4.01c0 1.1.9 1.98 2 1.98h18c1.1 0 2-.88 2-1.98v-14c0-1.11-.9-2-2-2zM11 16l4-4-4-4v3H1v2h10v3zM23 3.01H1V9h2V4.99h18v14.03H3V15H1v5.99h22V3.01zM11 16l4-4-4-4v3H1v2h10v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fax
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22,9h-4V4H8v14.5V20h14V9z M10,6h6v3h-6V6z M14,17h-4v-5h4V17z M16,17c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1 C17,16.55,16.55,17,16,17z M16,14c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C17,13.55,16.55,14,16,14z M19,17 c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C20,16.55,19.55,17,19,17z M19,14c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1 s1,0.45,1,1C20,13.55,19.55,14,19,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8",
      :x "2",
      :width "5",
      :height "13",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 settings-cell
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 24h2v-2H7v2zm4 0h2v-2h-2v2zm4 0h2v-2h-2v2zM6 0v20h12V0H6zm10 16H8V4h8v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hide-source
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2.81,2.81L1.39,4.22l2.27,2.27C2.61,8.07,2,9.96,2,12c0,5.52,4.48,10,10,10c2.04,0,3.93-0.61,5.51-1.66l2.27,2.27 l1.41-1.41L2.81,2.81z M12,20c-4.41,0-8-3.59-8-8c0-1.48,0.41-2.86,1.12-4.06l10.94,10.94C14.86,19.59,13.48,20,12,20z M7.94,5.12 L6.49,3.66C8.07,2.61,9.96,2,12,2c5.52,0,10,4.48,10,10c0,2.04-0.61,3.93-1.66,5.51l-1.46-1.46C19.59,14.86,20,13.48,20,12 c0-4.41-3.59-8-8-8C10.52,4,9.14,4.41,7.94,5.12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 settings-bluetooth
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 24h2v-2h-2v2zm-4 0h2v-2H7v2zm8 0h2v-2h-2v2zm2.71-18.29L12 0h-1v7.59L6.41 3 5 4.41 10.59 10 5 15.59 6.41 17 11 12.41V20h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 3.83l1.88 1.88L13 7.59V3.83zm1.88 10.46L13 16.17v-3.76l1.88 1.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 trending-flat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 12l-4-4v3H3v2h15v3l4-4z", :stroke nil, :fill nil})))


(helix.core/defnc
 swap-vertical-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM6.5 9L10 5.5 13.5 9H11v4H9V9H6.5zm7.5 9.5L10.5 15H13v-4h2v4h2.5L14 18.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pets
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "2.5", :cy "9.5", :cx "4.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "2.5", :cy "5.5", :cx "9", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "2.5", :cy "5.5", :cx "15", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "2.5", :cy "9.5", :cx "19.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M17.34 14.86c-.87-1.02-1.6-1.89-2.48-2.91-.46-.54-1.05-1.08-1.75-1.32-.11-.04-.22-.07-.33-.09-.25-.04-.52-.04-.78-.04s-.53 0-.79.05c-.11.02-.22.05-.33.09-.7.24-1.28.78-1.75 1.32-.87 1.02-1.6 1.89-2.48 2.91-1.31 1.31-2.92 2.76-2.62 4.79.29 1.02 1.02 2.03 2.33 2.32.73.15 3.06-.44 5.54-.44h.18c2.48 0 4.81.58 5.54.44 1.31-.29 2.04-1.31 2.33-2.32.31-2.04-1.3-3.49-2.61-4.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 assignment-ind
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3h-6.18C14.4 1.84 13.3 1 12 1s-2.4.84-2.82 2H3v18h18V3zm-9 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm0 4c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm6 12H6v-1.4c0-2 4-3.1 6-3.1s6 1.1 6 3.1V19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 outbond
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0",
    :x "0",
    :width "24",
    :height "24",
    :fill "none",
    :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M13.88,11.54l-4.96,4.96l-1.41-1.41 l4.96-4.96L10.34,8l5.65,0.01L16,13.66L13.88,11.54z",
    :stroke nil,
    :fill nil})
  (helix.dom/g nil)
  (helix.dom/g nil)
  (helix.dom/g nil)))


(helix.core/defnc
 network-ping
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,14.67L3.41,6.09L2,7.5l8.5,8.5H4v2h16v-2h-6.5l5.15-5.15C18.91,10.95,19.2,11,19.5,11c1.38,0,2.5-1.12,2.5-2.5 S20.88,6,19.5,6S17,7.12,17,8.5c0,0.35,0.07,0.67,0.2,0.97L12,14.67z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 launch
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 19H5V5h7V3H3v18h18v-9h-2v7zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3h-7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-circle-down
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M12,4c4.41,0,8,3.59,8,8s-3.59,8-8,8s-8-3.59-8-8S7.59,4,12,4 M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10 c5.52,0,10-4.48,10-10C22,6.48,17.52,2,12,2L12,2z M13,12l0-4h-2l0,4H8l4,4l4-4H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 supervisor-account
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.5 12c1.38 0 2.49-1.12 2.49-2.5S17.88 7 16.5 7 14 8.12 14 9.5s1.12 2.5 2.5 2.5zM9 11c1.66 0 2.99-1.34 2.99-3S10.66 5 9 5 6 6.34 6 8s1.34 3 3 3zm7.5 3c-1.83 0-5.5.92-5.5 2.75V19h11v-2.25c0-1.83-3.67-2.75-5.5-2.75zM9 13c-2.33 0-7 1.17-7 3.5V19h7v-2.25c0-.85.33-2.34 2.37-3.47C10.5 13.1 9.66 13 9 13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 payment
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M22 4H2v16h20V4zm-2 14H4v-6h16v6zm0-10H4V6h16v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 text-rotate-vertical
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none",
    :d "M0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0z",
    :stroke nil})
  (helix.dom/path
   {:d
    "M15.75 5h-1.5L9.5 16h2.1l.9-2.2h5l.9 2.2h2.1L15.75 5zm-2.62 7L15 6.98 16.87 12h-3.74zM6 20l3-3H7V4H5v13H3l3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 picture-in-picture-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M19 11h-8v6h8v-6zm4 10V3H1v18h22zm-2-1.98H3V4.97h18v14.05z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 work-history
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16.66,11.13c2-0.37,3.88,0.11,5.34,1.13V6h-6V2H8v4H2v15h9.68c-0.63-1.33-0.87-2.88-0.52-4.51 C11.75,13.79,13.94,11.63,16.66,11.13z M10,4h4v2h-4V4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18,13c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,13,18,13z M19.65,20.35l-2.15-2.15V15h1v2.79l1.85,1.85 L19.65,20.35z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shop-two
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 9H1v13h18v-2H3V9zm15-4V3c0-1.1-.9-2-2-2h-4c-1.1 0-2 .9-2 2v2H5v13h18V5h-5zm-6-2h4v2h-4V3zm0 12V8l5.5 3-5.5 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 assignment-returned
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3h-6.18C14.4 1.84 13.3 1 12 1s-2.4.84-2.82 2H3v18h18V3zm-9 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm0 15l-5-5h3V9h4v4h3l-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 repartition
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,21h18v-6H3V21z M10.33,19v-2h3.33v2H10.33z M19,19h-3.33v-2H19V19z M5,17h3.33v2H5V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M6,10l1.42-1.42L5.83,7H17c1.1,0,2,0.9,2,2s-0.9,2-2,2H3v2h14c2.21,0,4-1.79,4-4s-1.79-4-4-4H5.83l1.59-1.59L6,2L2,6L6,10 z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 wysiwyg
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M17,12H7v-2h10V12z M13,14H7v2h6V14z M21,21H3V3h18V21z M19,7H5v12h14V7z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 pin-invoke
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,12v8H2V4h12l0,2H4v12h16v-6H22z M22,7c0-1.66-1.34-3-3-3c-1.66,0-3,1.34-3,3s1.34,3,3,3C20.66,10,22,8.66,22,7z M11.47,12.12l-2.83,2.83l1.41,1.41l2.83-2.83L15,15.66V10H9.34L11.47,12.12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 system-update-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 16l4-4h-3V3h-2v9H8l4 4zm9-13h-6v1.99h6v14.03H3V4.99h6V3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-9 13l4-4h-3V3h-2v9H8l4 4zM23 3h-8v1.99h6v14.03H3V4.99h6V3H1v18h22V3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 picture-in-picture
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d "M19 7h-8v6h8V7zm4-4H1v17.98h22V3zm-2 16.01H3V4.98h18v14.03z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 compare-arrows
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.01 14H2v2h7.01v3L13 15l-3.99-4v3zm5.98-1v-3H22V8h-7.01V5L11 9l3.99 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 perm-device-information
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 7h-2v2h2V7zm0 4h-2v6h2v-6zM5 1v22h14V1H5zm12 18H7V5h10v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 source
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M12,6l-2-2H2v16h20V6H12z M14,16H6v-2h8V16z M18,12H6v-2h12V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 space-dashboard
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d "M11,21H3V3h8V21z M13,21h8v-9h-8V21z M21,10V3h-8v7H21z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 density-small
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "2",
      :x "3",
      :width "18",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "20",
      :x "3",
      :width "18",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "3",
      :width "18",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8",
      :x "3",
      :width "18",
      :height "2",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 arrow-outward
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/polygon
    {:points
     "6,6 6,8 14.59,8 5,17.59 6.41,19 16,9.41 16,18 18,18 18,6",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 pending-actions
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M17,12c-2.76,0-5,2.24-5,5s2.24,5,5,5c2.76,0,5-2.24,5-5S19.76,12,17,12z M18.65,19.35l-2.15-2.15V14h1v2.79l1.85,1.85 L18.65,19.35z M20,3h-5.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H4v19h8.11c-0.59-0.57-1.07-1.25-1.42-2H6V5h2v3h8V5h2v5.08 c0.71,0.1,1.38,0.31,2,0.6V3z M12,5c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1c0.55,0,1,0.45,1,1C13,4.55,12.55,5,12,5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 segment
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d "M9,18h12v-2H9V18z M3,6v2h18V6H3z M9,13h12v-2H9V13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 view-comfy-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M2,4v16h20V4H2z M11,17H7v-4h4V17z M11,11H7V7h4V11z M17,17h-4v-4h4V17z M17,11h-4V7h4V11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-home
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,11c0.7,0,1.37,0.1,2,0.29V9l-8-6L4,9v12h7.68C11.25,20.09,11,19.08,11,18C11,14.13,14.13,11,18,11z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,13c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,13,18,13z M21,18.5h-2.5V21h-1v-2.5H15v-1h2.5V15h1v2.5H21V18.5z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 settings-overscan
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.01 5.5L10 8h4l-1.99-2.5zM18 10v4l2.5-1.99L18 10zM6 10l-2.5 2.01L6 14v-4zm8 6h-4l2.01 2.5L14 16zm9-13H1v18h22V3zm-2 16.01H3V4.99h18v14.02z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 open-in-full
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/polygon
   {:points
    "21,11 21,3 13,3 16.29,6.29 6.29,16.29 3,13 3,21 11,21 7.71,17.71 17.71,7.71",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 theaters
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 3v2h-2V3H8v2H6V3H4v18h