;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.so
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"01-01" {:name (partial get-name "01-01")},
   "05-01" {:name (partial get-name "05-01")},
   "06-26"
   {:name
    {:ar "استقلال الصومال البريطاني",
     :en "Independence of British Somaliland"}},
   "07-01" {:name (partial get-name "Independence Day")},
   "10 Muharram" {:name (partial get-name "10 Muharram")},
   "12 Rabi al-awwal" {:name (partial get-name "12 Rabi al-awwal")},
   "1 Shawwal" {:name (partial get-name "1 Shawwal")},
   "10 Dhu al-Hijjah" {:name (partial get-name "10 Dhu al-Hijjah")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :so
  [_ context]
  (holiday? context))
