;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.mr
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"01-01" {:name (partial get-name "01-01")},
   "05-01" {:name (partial get-name "05-01")},
   "05-25" {:name {:ar "يوم افريقيا", :en "Africa Day"}},
   "11-28" {:name (partial get-name "Independence Day")},
   "1 Muharram" {:name (partial get-name "1 Muharram")},
   "12 Rabi al-awwal" {:name (partial get-name "12 Rabi al-awwal")},
   "1 Shawwal" {:name (partial get-name "1 Shawwal")},
   "10 Dhu al-Hijjah P3D" {:name (partial get-name "10 Dhu al-Hijjah")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :mr
  [_ context]
  (holiday? context))
