;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.bl
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"easter -46"
   {"type" "observance", :name (partial get-name "easter -46")},
   "10-09" {:name (partial get-name "Abolition of Slavery")},
   "easter -48"
   {"type" "observance", :name (partial get-name "easter -48")},
   "08-24"
   {"type" "observance",
    :name {:fr "Fête de Saint Barthélemy", :en "Saint Barth"}},
   "easter -47"
   {"type" "Observance", :name (partial get-name "easter -47")},
   "easter" {"type" "observance", :name (partial get-name "easter")},
   "easter -21"
   {"type" "observance", :name {:fr "Mi-Carême", :en "Laetare Sunday"}},
   "easter -2" {"type" "bank", :name (partial get-name "easter -2")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :bl
  [_ context]
  (holiday? context))
