;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.bh
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"12-16" {:name {:ar "اليوم الوطني", :en "National Day"}},
   "01-01" {:name (partial get-name "01-01")},
   "12-17" {:name {:ar "يوم الجلوس", :en "Accession Day"}},
   "1 Muharram" {:name (partial get-name "1 Muharram")},
   "10 Muharram" {:name (partial get-name "10 Muharram")},
   "1 Shawwal" {:name (partial get-name "1 Shawwal")},
   "9 Dhu al-Hijjah" {:name (partial get-name "9 Dhu al-Hijjah")},
   "10 Dhu al-Hijjah P3D" {:name (partial get-name "10 Dhu al-Hijjah")},
   "05-01" {"_name" "05-01", :name {:ar "يوم العمال"}},
   "12 Rabi al-awwal" {:name (partial get-name "12 Rabi al-awwal")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :bh
  [_ context]
  (holiday? context))
