;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.th
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"06-03"
   {:name
    {:en "Queen Suthida's Birthday",
     :th
     "วันเฉลิมพระชนมพรรษาสมเด็จพระนางเจ้าสุทิดา พัชรสุธาพิมลลักษณ พระบรมราชินี"}},
   "2026-05-31" {:name (partial get-name "Vesak")},
   "2016-07-20" {:name (partial get-name "Buddhist Lent")},
   "2022-07-13" {:name (partial get-name "Asalha Puja")},
   "10-23" {:name {:en "King Chulalongkorn Day", :th "วันปิยมหาราช"}},
   "04-15" {:name {:en "Songkran Festival", :th "วันสงกรานต์"}},
   "2020-07-04" {:name (partial get-name "Asalha Puja")},
   "2017-02-11" {:name (partial get-name "Makha Bucha")},
   "2015-06-02" {:name (partial get-name "Vesak")},
   "2012-03-07" {:name (partial get-name "Makha Bucha")},
   "2020-05-07" {:name (partial get-name "Vesak")},
   "2015-03-04" {:name (partial get-name "Makha Bucha")},
   "2025-07-10" {:name (partial get-name "Asalha Puja")},
   "2015-07-31" {:name (partial get-name "Buddhist Lent")},
   "2026-07-30" {:name (partial get-name "Buddhist Lent")},
   "01-01" {:name (partial get-name "01-01")},
   "2025-07-11" {:name (partial get-name "Buddhist Lent")},
   "2019-02-19" {:name (partial get-name "Makha Bucha")},
   "2015-07-30" {:name (partial get-name "Asalha Puja")},
   "2020-02-08" {:name (partial get-name "Makha Bucha")},
   "2021-02-26" {:name (partial get-name "Makha Bucha")},
   "2019-07-16" {:name (partial get-name "Asalha Puja")},
   "2024-02-24" {:name (partial get-name "Makha Bucha")},
   "2023-05-04" {:name (partial get-name "Vesak")},
   "2022-07-14" {:name (partial get-name "Buddhist Lent")},
   "2012-05-06" {:name (partial get-name "Vesak")},
   "2024-07-19" {:name (partial get-name "Asalha Puja")},
   "2018-07-27" {:name (partial get-name "Asalha Puja")},
   "2019-07-17" {:name (partial get-name "Buddhist Lent")},
   "2013-02-25" {:name (partial get-name "Makha Bucha")},
   "04-13" {:name {:en "Songkran Festival", :th "วันสงกรานต์"}},
   "2011-07-16" {:name (partial get-name "Buddhist Lent")},
   "2013-07-22" {:name (partial get-name "Asalha Puja")},
   "2014-07-12" {:name (partial get-name "Buddhist Lent")},
   "2023-03-06" {:name (partial get-name "Makha Bucha")},
   "2023-07-31" {:name (partial get-name "Asalha Puja")},
   "2022-02-16" {:name (partial get-name "Makha Bucha")},
   "2017-07-08" {:name (partial get-name "Asalha Puja")},
   "2025-05-12" {:name (partial get-name "Vesak")},
   "2016-05-22" {:name (partial get-name "Vesak")},
   "05-04" {:name {:en "Coronation Day", :th "วันฉัตรมงคล"}},
   "2018-03-01" {:name (partial get-name "Makha Bucha")},
   "12-05"
   {:name
    {:en "King Bhumibol Adulyadej's Birthday",
     :th
     "วันคล้ายวันพระบรมราชสมภพ พระบาทสมเด็จพระบรมชนกาธิเบศร มหาภูมิพลอดุลยเดชมหาราช บรมนาถบพิตร"}},
   "2010-03-01" {:name (partial get-name "Makha Bucha")},
   "2025-02-13" {:name (partial get-name "Makha Bucha")},
   "2012-08-03" {:name (partial get-name "Buddhist Lent")},
   "2012-08-02" {:name (partial get-name "Asalha Puja")},
   "2018-05-29" {:name (partial get-name "Vesak")},
   "2011-07-15" {:name (partial get-name "Asalha Puja")},
   "08-12"
   {:name
    {:en "The Queen Mother's Birthday",
     :th
     "วันเฉลิมพระชนมพรรษาสมเด็จพระนางเจ้าสิริกิติ์ พระบรมราชินีนาถ พระบรมราชชนนีพันปีหลวง"}},
   "12-10" {:name {:en "Constitution Day", :th "วันรัฐธรรมนูญ"}},
   "2022-05-16" {"substitute" true, :name (partial get-name "Vesak")},
   "04-14" {:name {:en "Songkran Festival", :th "วันสงกรานต์"}},
   "2014-05-15" {:name (partial get-name "Vesak")},
   "2017-05-10" {:name (partial get-name "Vesak")},
   "2017-07-09" {:name (partial get-name "Buddhist Lent")},
   "2022-05-15" {:name (partial get-name "Vesak")},
   "2021-07-24" {:name (partial get-name "Asalha Puja")},
   "2013-07-23" {:name (partial get-name "Buddhist Lent")},
   "2011-05-17" {:name (partial get-name "Vesak")},
   "2024-07-20" {:name (partial get-name "Buddhist Lent")},
   "2018-07-28" {:name (partial get-name "Buddhist Lent")},
   "10-13"
   {:name
    {:en "King Bhumibol Adulyadej Memorial Day",
     :th
     "วันคล้ายวันสวรรคตพระบาทสมเด็จพระบรมชนกาธิเบศร มหาภูมิพลอดุลยเดชมหาราช บรมนาถบพิตร"}},
   "2026-07-29" {:name (partial get-name "Asalha Puja")},
   "2011-02-18" {:name (partial get-name "Makha Bucha")},
   "2021-05-26" {:name (partial get-name "Vesak")},
   "2010-07-26" {:name (partial get-name "Buddhist Lent")},
   "2010-05-28" {:name (partial get-name "Vesak")},
   "2016-07-19" {:name (partial get-name "Asalha Puja")},
   "2019-05-19" {:name (partial get-name "Vesak")},
   "04-06" {:name {:en "Chakri Memorial Day", :th "วันจักรี"}},
   "2014-02-14" {:name (partial get-name "Makha Bucha")},
   "12-31" {:name (partial get-name "12-31")},
   "2021-07-25" {:name (partial get-name "Buddhist Lent")},
   "07-28"
   {:name
    {:en "King's Birthday",
     :th "วันเฉลิมพระชนมพรรษาพระบาทสมเด็จพระวชิรเกล้าเจ้าอยู่หัว"}},
   "2026-03-03" {:name (partial get-name "Makha Bucha")},
   "2020-07-05" {:name (partial get-name "Buddhist Lent")},
   "2023-08-01" {:name (partial get-name "Buddhist Lent")},
   "2016-02-22" {:name (partial get-name "Makha Bucha")},
   "2013-05-25" {:name (partial get-name "Vesak")},
   "2010-07-25" {:name (partial get-name "Asalha Puja")},
   "2014-07-11" {:name (partial get-name "Asalha Puja")},
   "2024-05-22" {:name (partial get-name "Vesak")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :th
  [_ context]
  (holiday? context))
