;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.pa
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"easter -48"
   {"type" "observance", :name (partial get-name "easter -48")},
   "easter -47" {:name (partial get-name "easter -47")},
   "12-08 and if sunday then next monday"
   {"substitute" true, :name (partial get-name "Mothers Day")},
   "01-09 and if sunday then next monday"
   {"substitute" true,
    :name
    {:en "Martyrs' Day",
     :es "Día de los Mártires Caídos en la Gesta Patriótica"}},
   "01-01 and if sunday then next monday"
   {"substitute" true, :name (partial get-name "01-01")},
   "12-25 and if sunday then next monday"
   {"substitute" true, :name (partial get-name "12-25")},
   "easter -2" {:name (partial get-name "easter -2")},
   "11-28 and if sunday then next monday"
   {"substitute" true, :name (partial get-name "Independence Day")},
   "11-03 and if sunday then next monday"
   {"substitute" true,
    :name
    {:en "Separation Day (from Columbia)",
     :es "Día de la Separación (de Colombia)"}},
   "11-10 and if sunday then next monday"
   {"substitute" true, :name {:es "Primer Grito de Independencia"}},
   "05-01 and if sunday then next monday"
   {"substitute" true, :name (partial get-name "05-01")},
   "07-01 every 5 years since 2014"
   {:name {:en "Presidential Inauguration"}}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :pa
  [_ context]
  (holiday? context))
