;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.ls
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"10-04" {:name (partial get-name "Independence Day")},
   "01-01" {:name (partial get-name "01-01")},
   "easter 39" {:name (partial get-name "easter 39")},
   "05-25" {:name {:en "Africa Day/ Heroes' Day"}},
   "03-11" {:name {:en "Moshoeshoe Day"}},
   "easter -2" {:name (partial get-name "easter -2")},
   "12-26" {:name (partial get-name "12-26")},
   "easter 1" {:name (partial get-name "easter 1")},
   "07-17" {:name {:en "King Letsie III's Birthday"}},
   "05-01" {"_name" "05-01", :name {:en "Workers' Day"}},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :ls
  [_ context]
  (holiday? context))
