;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.cu
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"07-25"
   {:name
    {:es "Conmemoración del asalto a Moncada",
     :en
     "Day before the Commemoration of the Assault of the Moncada garrison"}},
   "07-26"
   {:name
    {:es "Día de la Rebeldía Nacional",
     :en "Commemoration of the Assault of the Moncada garrison"}},
   "01-01"
   {:name
    {:es "Triunfo de la Revolución", :en "Triumph of the Revolution"}},
   "01-02"
   {:name
    {:es "Día de Victoria de las Fuerzas Armadas",
     :en "Victory of Armed Forces Day"}},
   "07-27"
   {:name
    {:es "Conmemoración del asalto a Moncada",
     :en
     "Day after the Commemoration of the Assault of the Moncada garrison"}},
   "10-10" {:name (partial get-name "Independence Day")},
   "easter -2" {:name (partial get-name "easter -2")},
   "05-01" {:name (partial get-name "05-01")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :cu
  [_ context]
  (holiday? context))
