;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.ss
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"01-01" {:name (partial get-name "01-01")},
   "1st monday in July"
   {"type" "observance", :name (partial get-name "Mothers Day")},
   "05-16" {:name {:en "SPLA Day"}},
   "12-28" {:name {:en "Republic Day"}},
   "2 Shawwal" {:name (partial get-name "1 Shawwal")},
   "03-08" {:name (partial get-name "03-08")},
   "07-30" {:name {:en "Martyrs Day"}},
   "01-09" {:name {:en "Peace Agreement Day"}},
   "12 Dhu al-Hijjah" {:name (partial get-name "10 Dhu al-Hijjah")},
   "07-09" {:name (partial get-name "Independence Day")},
   "12-31" {:name (partial get-name "12-31")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :ss
  [_ context]
  (holiday? context))
