/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojurescript;

import dev.clojurephant.plugin.clojurescript.ClojureScriptBuild;
import dev.clojurephant.plugin.clojurescript.ClojureScriptExtension;
import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptCompile;
import dev.clojurephant.plugin.common.internal.ClojureCommonBasePlugin;
import dev.clojurephant.plugin.common.internal.Namespaces;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;

public class ClojureScriptBasePlugin
implements Plugin<Project> {
    public static final String SOURCE_DIRECTORY_SET_NAME = "clojurescript";
    private final ObjectFactory objects;

    @Inject
    public ClojureScriptBasePlugin(ObjectFactory objects) {
        this.objects = objects;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(ClojureCommonBasePlugin.class);
        ClojureScriptExtension extension = (ClojureScriptExtension)project.getExtensions().create(SOURCE_DIRECTORY_SET_NAME, ClojureScriptExtension.class, new Object[0]);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        this.configureSourceSetDefaults(project, sourceSets, extension);
        this.configureBuildDefaults(project, sourceSets, extension);
    }

    private void configureSourceSetDefaults(Project project, SourceSetContainer sourceSets, ClojureScriptExtension extension) {
        sourceSets.all(sourceSet -> {
            SourceDirectorySet clojureScriptSource = this.objects.sourceDirectorySet(sourceSet.getName(), sourceSet.getName());
            clojureScriptSource.srcDir((Object)String.format("src/%s/clojurescript", sourceSet.getName()));
            clojureScriptSource.getFilter().include(Namespaces.CLOJURESCRIPT_PATTERNS);
            sourceSet.getExtensions().add(SOURCE_DIRECTORY_SET_NAME, (Object)clojureScriptSource);
            sourceSet.getResources().getFilter().exclude(element -> clojureScriptSource.contains(element.getFile()));
            sourceSet.getAllJava().source(clojureScriptSource);
            sourceSet.getAllSource().source(clojureScriptSource);
            ClojureScriptBuild build = (ClojureScriptBuild)extension.getBuilds().create(sourceSet.getName());
            build.getSourceRoots().from(new Object[]{clojureScriptSource.getSourceDirectories()});
            clojureScriptSource.getDestinationDirectory().set((Provider)build.getOutputDir());
            build.getClasspath().from(new Object[]{project.provider(() -> sourceSet.getCompileClasspath())}).from(new Object[]{project.getTasks().named(sourceSet.getProcessResourcesTaskName())});
            Provider output = project.provider(() -> {
                if (build.isCompilerConfigured()) {
                    return project.files(new Object[]{build.getOutputDir()});
                }
                return build.getSourceRoots();
            });
            ((DefaultSourceSetOutput)sourceSet.getOutput()).getClassesDirs().from(new Object[]{output});
            project.getTasks().named(sourceSet.getClassesTaskName(), task -> task.dependsOn(new Object[]{build.getTaskName("compile")}));
        });
    }

    private void configureBuildDefaults(Project project, SourceSetContainer sourceSets, ClojureScriptExtension extension) {
        extension.getRootOutputDir().set(project.getLayout().getBuildDirectory().dir(SOURCE_DIRECTORY_SET_NAME));
        extension.getBuilds().configureEach(build -> {
            build.getOutputDir().convention(extension.getRootOutputDir().dir(build.getName()));
            build.getCompiler().getBaseOutputDirectory().set((Provider)build.getOutputDir());
            build.getCompiler().getModules().configureEach(module -> module.getBaseOutputDirectory().set((Provider)build.getCompiler().getBaseOutputDirectory()));
            build.getFigwheel().getTargetDir().set((Provider)build.getOutputDir());
            build.getFigwheel().getWatchDirs().from(new Object[]{build.getSourceRoots()});
            build.getFigwheel().getRebelReadline().set((Object)false);
            build.getFigwheel().getHelpfulClasspaths().set((Object)false);
            String compileTaskName = build.getTaskName("compile");
            TaskProvider compileTask = project.getTasks().register(compileTaskName, ClojureScriptCompile.class, task -> {
                task.setDescription(String.format("Compiles the ClojureScript source for the %s build.", build.getName()));
                task.getDestinationDir().set((Provider)build.getCompiler().getBaseOutputDirectory());
                task.setSource(build.getSourceTree());
                task.getClasspath().from(new Object[]{build.getSourceRoots()});
                task.getClasspath().from(new Object[]{build.getClasspath()});
                task.getOptions().set((Object)build.getCompiler());
            });
            SourceSet sourceSet = (SourceSet)sourceSets.findByName(build.getName());
            if (sourceSet != null) {
                SourceDirectorySet source = (SourceDirectorySet)sourceSet.getExtensions().getByName(SOURCE_DIRECTORY_SET_NAME);
                source.compiledBy(compileTask, ClojureScriptCompile::getDestinationDir);
            }
        });
    }
}

