/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.clojure.tasks.ClojureTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaToolchainService;

public class ClojureCommonBasePlugin
implements Plugin<Project> {
    public static final String NREPL_JACK_IN_PROPERTY = "dev.clojurephant.jack-in.nrepl";

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureJavaToolchain(project);
        this.configureNreplDependencies(project);
    }

    public void configureJavaToolchain(Project project) {
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        JavaToolchainService javaToolchain = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        Provider launcher = javaToolchain.launcherFor(java.getToolchain());
        project.getTasks().withType(ClojureTask.class, task -> task.getJavaLauncher().set(launcher));
    }

    public void configureNreplDependencies(Project project) {
        Configuration nrepl = (Configuration)project.getConfigurations().create("nrepl");
        if (project.hasProperty(NREPL_JACK_IN_PROPERTY)) {
            String[] jackInDeps;
            for (String jackInDep : jackInDeps = project.findProperty(NREPL_JACK_IN_PROPERTY).toString().split(",")) {
                project.getLogger().lifecycle("Jacking {} into the {} configuration", new Object[]{jackInDep, "nrepl"});
                project.getDependencies().add("nrepl", (Object)jackInDep);
            }
        } else {
            project.getDependencies().add("nrepl", (Object)"nrepl:nrepl:0.9.0");
        }
    }
}

